(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12229,        414]
NotebookOptionsPosition[      8356,        294]
NotebookOutlinePosition[     10840,        361]
CellTagsIndexPosition[     10747,        355]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "InverseFourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierTransform"], 
          "InverseLaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseLaplaceTransform"], 
          "LaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/LaplaceTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FourierTransform\"\>", 
       2->"\<\"InverseFourierTransform\"\>", 
       3->"\<\"InverseLaplaceTransform\"\>", 
       4->"\<\"LaplaceTransform\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Integral Transforms", "Title",
 CellTags->{"S1.5.12", "12.1"},
 CellID->13929],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "find the Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseLaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["s", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the inverse Laplace transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->731],

Cell["Laplace transforms. ", "Caption",
 CellID->4278],

Cell["This computes a Laplace transform. ", "MathCaption",
 CellID->17859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "3"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"a", " ", "t"}], "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8752],

Cell[BoxData[
 FractionBox["6", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "-", "s"}], ")"}], "4"]]], "Output",
 ImageSize->{55, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5089]
}, Open  ]],

Cell["Here is the inverse transform. ", "MathCaption",
 CellID->31958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{"%", ",", "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20238],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"a", " ", "t"}]], " ", 
  SuperscriptBox["t", "3"]}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->7054]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "find the symbolic Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["w", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the inverse Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27972],

Cell["Fourier transforms. ", "Caption",
 CellID->4208],

Cell["This computes a Fourier transform. ", "MathCaption",
 CellID->25656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "4"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"t", "^", "2"}]}], "]"}]}], ",", "t", ",", "w"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->24171],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["w", "2"], "4"]}]], " ", 
   RowBox[{"(", 
    RowBox[{"12", "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["w", "2"]}], "+", 
     SuperscriptBox["w", "4"]}], ")"}]}], 
  RowBox[{"16", " ", 
   SqrtBox["2"]}]]], "Output",
 ImageSize->{133, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->18147]
}, Open  ]],

Cell["Here is the inverse transform. ", "MathCaption",
 CellID->8503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{"%", ",", "w", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->19511],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SuperscriptBox["t", "2"]}]], " ", 
  SuperscriptBox["t", "4"]}]], "Output",
 ImageSize->{43, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->32174]
}, Open  ]],

Cell[TextData[{
 "Note that in the scientific and technical literature many different \
conventions are used for defining Fourier transforms. The setup for \
specifying different conventions is described in ",
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 "."
}], "Text",
 CellID->28819],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->293236024],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integral Transforms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Limits"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GenericAndNonGenericCases"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 40.4430454}", "context" -> "", 
    "keywords" -> {
     "FourierTransform", "integral transforms", "InverseFourierTransform", 
      "InverseLaplaceTransform", "LaplaceTransform"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Laplace transforms. This computes a Laplace transform. Here is the \
inverse transform. ", "synonyms" -> {"1.5.12"}, "title" -> 
    "Integral Transforms", "type" -> "Tutorial", "uri" -> 
    "tutorial/IntegralTransforms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.12"->{
  Cell[2294, 67, 84, 2, 70, "Title",
   CellTags->{"S1.5.12", "12.1"},
   CellID->13929]},
 "12.1"->{
  Cell[2294, 67, 84, 2, 70, "Title",
   CellTags->{"S1.5.12", "12.1"},
   CellID->13929]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.12", 10531, 344},
 {"12.1", 10633, 348}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1669, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2294, 67, 84, 2, 70, "Title",
 CellTags->{"S1.5.12", "12.1"},
 CellID->13929],
Cell[2381, 71, 1290, 37, 70, "DefinitionBox",
 CellID->731],
Cell[3674, 110, 54, 1, 70, "Caption",
 CellID->4278],
Cell[3731, 113, 74, 1, 70, "MathCaption",
 CellID->17859],
Cell[CellGroupData[{
Cell[3830, 118, 248, 8, 28, "Input",
 CellID->8752],
Cell[4081, 128, 247, 9, 54, "Output",
 CellID->5089]
}, Open  ]],
Cell[4343, 140, 70, 1, 70, "MathCaption",
 CellID->31958],
Cell[CellGroupData[{
Cell[4438, 145, 149, 4, 28, "Input",
 CellID->20238],
Cell[4590, 151, 262, 9, 36, "Output",
 CellID->7054]
}, Open  ]],
Cell[4867, 163, 1301, 37, 70, "DefinitionBox",
 CellID->27972],
Cell[6171, 202, 54, 1, 70, "Caption",
 CellID->4208],
Cell[6228, 205, 74, 1, 70, "MathCaption",
 CellID->25656],
Cell[CellGroupData[{
Cell[6327, 210, 274, 10, 70, "Input",
 CellID->24171],
Cell[6604, 222, 489, 18, 70, "Output",
 CellID->18147]
}, Open  ]],
Cell[7108, 243, 69, 1, 70, "MathCaption",
 CellID->8503],
Cell[CellGroupData[{
Cell[7202, 248, 149, 4, 70, "Input",
 CellID->19511],
Cell[7354, 254, 284, 10, 40, "Output",
 CellID->32174]
}, Open  ]],
Cell[7653, 267, 377, 10, 70, "Text",
 CellID->28819],
Cell[CellGroupData[{
Cell[8055, 281, 72, 1, 70, "RelatedTutorialsSection",
 CellID->293236024],
Cell[8130, 284, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[8329, 292, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

