(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17719,        621]
NotebookOptionsPosition[     13149,        476]
NotebookOutlinePosition[     15725,        544]
CellTagsIndexPosition[     15634,        538]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Boole" :> Documentation`HelpLookup["paclet:ref/Boole"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"], 
          "True" :> Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Boole\"\>", 2->"\<\"Integrate\"\>", 
       3->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Integrals over Regions", "Title",
 CellTags->{"S3.5.9", "9.1"},
 CellID->23954],

Cell["This does an integral over the interior of the unit circle. ", \
"MathCaption",
 CellID->29676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "1", ",", "0"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->3454],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21658]
}, Open  ]],

Cell["Here is an equivalent form. ", "MathCaption",
 CellID->1721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20784],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10688]
}, Open  ]],

Cell["\<\
Even though an integral may be straightforward over a simple rectangular \
region, it can be significantly more complicated even over a circular region. \
\
\>", "Text",
 CellID->10466],

Cell["This gives a Bessel function. ", "MathCaption",
 CellID->16116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30856],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]", " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{"1", ",", "1"}], "]"}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30180]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], " ", 
     ButtonBox["Boole",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Boole"], "[", 
     StyleBox["cond", "TI"], "]", ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "integrate ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over the region where ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26429],

Cell["Integrals over regions. ", "Caption",
 CellID->24537],

Cell["\<\
Particularly if there are parameters inside the conditions that define \
regions, the results for integrals over regions may break into several cases. \
\
\>", "Text",
 CellID->13629],

Cell[TextData[{
 "This gives a piecewise function of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->18389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "<", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->9843],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"a", "\[LessEqual]", "0"}]},
    {
     FractionBox[
      RowBox[{"2", "-", "a"}], "2"], 
     RowBox[{"0", "<", "a", "\[LessEqual]", "1"}]},
    {
     FractionBox["1", 
      RowBox[{"2", " ", "a"}]], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.84}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{95, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->7004]
}, Open  ]],

Cell["\<\
With two parameters even this breaks into quite a few cases. \
\>", "MathCaption",
 CellID->20101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "<", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->29384],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", ">", "0"}], "&&", 
        RowBox[{
         RowBox[{"a", "-", "b"}], "\[LessEqual]", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "\[LessEqual]", "0"}], "&&", 
        RowBox[{"b", ">", "0"}]}], ")"}]}]},
    {
     FractionBox[
      RowBox[{"a", "-", "b"}], "a"], 
     RowBox[{
      RowBox[{"a", "\[LessEqual]", "0"}], "&&", 
      RowBox[{
       RowBox[{"a", "-", "b"}], "<", "0"}], "&&", 
      RowBox[{"b", "\[LessEqual]", "0"}]}]},
    {
     FractionBox["b", "a"], 
     RowBox[{
      RowBox[{"a", ">", "0"}], "&&", 
      RowBox[{"b", ">", "0"}], "&&", 
      RowBox[{
       RowBox[{"a", "-", "b"}], ">", "0"}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.84}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{265, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->12920]
}, Open  ]],

Cell["This involves intersecting a circle with a square. ", "MathCaption",
 CellID->31987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->5136],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"a", "\[GreaterEqual]", "2"}]},
    {
     FractionBox[
      RowBox[{"a", " ", "\[Pi]"}], "4"], 
     RowBox[{"0", "<", "a", "\[LessEqual]", "1"}]},
    {
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}]]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"ArcCot", "[", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}]], "]"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"ArcTan", "[", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}]], "]"}]}]}], ")"}]}], 
     RowBox[{"1", "<", "a", "<", "2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.84}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{423, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->29052]
}, Open  ]],

Cell["The region can have an infinite number of components. ", "MathCaption",
 CellID->7582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ">", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->1528],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"isum\"\>"}], ":", 
  " ", "\<\"Warning: infinite subdivision of the integration domain has been \
used in computation of the definite integral \\!\\(\\(\[Integral]\\_\\(-\
\[Infinity]\\)\\%\[Infinity]\\) \\(\\(\\(\\(\[ExponentialE]\\^\\(-x\\)\\\\ \
\\(\\(Boole[\\(\\(\\(\\(Sin[x]\\)\\) > 1\\/2\\)\\)]\\)\\)\\)\\) \\(\\(\
\[DifferentialD] x\\)\\)\\)\\)\\). If the integral is divergent, the result \
may be incorrect.\"\>"}]], "Message", "MSG",
 CellID->6366],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{
    RowBox[{"K$2064", "[", "1", "]"}], "=", 
    RowBox[{"-", "\[Infinity]"}]}], "\[Infinity]"], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", "\[Pi]"}], "6"]}], "-", 
     RowBox[{"2", " ", "\[Pi]", " ", 
      RowBox[{"K$2064", "[", "1", "]"}]}]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"2", " ", "\[Pi]"}], "/", "3"}]]}], ")"}]}]}]], "Output",
 ImageSize->{236, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->1472]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->318861164],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrals over Regions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiniteIntegrals"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingIntegralsInSymbolicForm"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 38.0992354}", "context" -> "", 
    "keywords" -> {"areas", "measures", "mensuration", "regions", "volumes"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "This does an integral over the interior of the unit circle. Here is an \
equivalent form. Even though an integral may be straightforward over a simple \
rectangular region, it can be significantly more complicated even over a \
circular region. ", "synonyms" -> {"3.5.9"}, "title" -> 
    "Integrals over Regions", "type" -> "Tutorial", "uri" -> 
    "tutorial/IntegralsOverRegions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.9"->{
  Cell[1935, 59, 85, 2, 70, "Title",
   CellTags->{"S3.5.9", "9.1"},
   CellID->23954]},
 "9.1"->{
  Cell[1935, 59, 85, 2, 70, "Title",
   CellTags->{"S3.5.9", "9.1"},
   CellID->23954]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.9", 15423, 527},
 {"9.1", 15522, 531}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1310, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1935, 59, 85, 2, 70, "Title",
 CellTags->{"S3.5.9", "9.1"},
 CellID->23954],
Cell[2023, 63, 101, 2, 70, "MathCaption",
 CellID->29676],
Cell[CellGroupData[{
Cell[2149, 69, 472, 17, 28, "Input",
 CellID->3454],
Cell[2624, 88, 159, 5, 36, "Output",
 CellID->21658]
}, Open  ]],
Cell[2798, 96, 66, 1, 70, "MathCaption",
 CellID->1721],
Cell[CellGroupData[{
Cell[2889, 101, 433, 15, 28, "Input",
 CellID->20784],
Cell[3325, 118, 159, 5, 36, "Output",
 CellID->10688]
}, Open  ]],
Cell[3499, 126, 195, 5, 70, "Text",
 CellID->10466],
Cell[3697, 133, 69, 1, 70, "MathCaption",
 CellID->16116],
Cell[CellGroupData[{
Cell[3791, 138, 494, 17, 28, "Input",
 CellID->30856],
Cell[4288, 157, 250, 8, 36, "Output",
 CellID->30180]
}, Open  ]],
Cell[4553, 168, 1556, 49, 70, "DefinitionBox",
 CellID->26429],
Cell[6112, 219, 59, 1, 70, "Caption",
 CellID->24537],
Cell[6174, 222, 193, 5, 70, "Text",
 CellID->13629],
Cell[6370, 229, 160, 6, 70, "MathCaption",
 CellID->18389],
Cell[CellGroupData[{
Cell[6555, 239, 336, 11, 70, "Input",
 CellID->9843],
Cell[6894, 252, 792, 26, 82, "Output",
 CellID->7004]
}, Open  ]],
Cell[7701, 281, 108, 3, 70, "MathCaption",
 CellID->20101],
Cell[CellGroupData[{
Cell[7834, 288, 268, 9, 70, "Input",
 CellID->29384],
Cell[8105, 299, 1209, 39, 82, "Output",
 CellID->12920]
}, Open  ]],
Cell[9329, 341, 90, 1, 70, "MathCaption",
 CellID->31987],
Cell[CellGroupData[{
Cell[9444, 346, 390, 13, 70, "Input",
 CellID->5136],
Cell[9837, 361, 1209, 39, 82, "Output",
 CellID->29052]
}, Open  ]],
Cell[11061, 403, 92, 1, 70, "MathCaption",
 CellID->7582],
Cell[CellGroupData[{
Cell[11178, 408, 416, 14, 70, "Input",
 CellID->1528],
Cell[11597, 424, 516, 9, 70, "Message",
 CellID->6366],
Cell[12116, 435, 721, 24, 60, "Output",
 CellID->1472]
}, Open  ]],
Cell[CellGroupData[{
Cell[12874, 464, 72, 1, 70, "RelatedTutorialsSection",
 CellID->318861164],
Cell[12949, 467, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[13122, 474, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

