(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14231,        457]
NotebookOptionsPosition[     10276,        344]
NotebookOutlinePosition[     12621,        402]
CellTagsIndexPosition[     12578,        399]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Editing Mathematica Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InteractiveGraphicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Editing Mathematica Graphics\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"], 
          "Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Interactivity & Drawing\"\>", 
       2->"\<\"Annotating & Combining Graphics\"\>", 
       3->"\<\"Combining Graphics\"\>", 
       4->"\<\"Graphics Annotation & Appearance\"\>", 
       5->"\<\"Graphics Options & Styling\"\>", 
       6->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Graphics As Input", "Title",
 CellID->509267359],

Cell["\<\
An image is equivalent to its symbolic expression. You can operate on an \
image as you would a symbolic expression.\
\>", "Text",
 CellID->384676789],

Cell["This input produces some disks.", "MathCaption",
 CellID->653821473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{
        RowBox[{"i", "/", "2"}], ",", ".7", ",", 
        RowBox[{"j", "/", "2"}]}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", " ", "i"}], ",", 
         RowBox[{"2", "j"}]}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13056279],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0, 0.7, 0], DiskBox[{0, 0}]}, 
    {RGBColor[0, 0.7, 
      NCache[
       Rational[1, 2], 0.5]], DiskBox[{0, 2}]}, 
    {RGBColor[0, 0.7, 1], DiskBox[{0, 4}]}}, {
    {RGBColor[
      NCache[
       Rational[1, 2], 0.5], 0.7, 0], DiskBox[{2, 0}]}, 
    {RGBColor[
      NCache[
       Rational[1, 2], 0.5], 0.7, 
      NCache[
       Rational[1, 2], 0.5]], DiskBox[{2, 2}]}, 
    {RGBColor[
      NCache[
       Rational[1, 2], 0.5], 0.7, 1], DiskBox[{2, 4}]}}, {
    {RGBColor[1, 0.7, 0], DiskBox[{4, 0}]}, 
    {RGBColor[1, 0.7, 
      NCache[
       Rational[1, 2], 0.5]], DiskBox[{4, 2}]}, 
    {RGBColor[1, 0.7, 1], DiskBox[{4, 4}]}}},
  ImageMargins->0.,
  ImageSize->Automatic]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3927940]
}, Open  ]],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"//", " ", 
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"]}]], "InlineFormula"],
 " after the graphic to get the symbolic expression that corresponds to the \
graphic."
}], "MathCaption",
 CellID->1617373851],

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{
        RowBox[{"i", "/", "2"}], ",", ".7", ",", 
        RowBox[{"j", "/", "2"}]}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", " ", "i"}], ",", 
         RowBox[{"2", "j"}]}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[71]:=",
 CellID->354310031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  GraphicsBox[{{
     {RGBColor[0, 0.7, 0], DiskBox[{0, 0}]}, 
     {RGBColor[0, 0.7, 
       NCache[
        Rational[1, 2], 0.5]], DiskBox[{0, 2}]}, 
     {RGBColor[0, 0.7, 1], DiskBox[{0, 4}]}}, {
     {RGBColor[
       NCache[
        Rational[1, 2], 0.5], 0.7, 0], DiskBox[{2, 0}]}, 
     {RGBColor[
       NCache[
        Rational[1, 2], 0.5], 0.7, 
       NCache[
        Rational[1, 2], 0.5]], DiskBox[{2, 2}]}, 
     {RGBColor[
       NCache[
        Rational[1, 2], 0.5], 0.7, 1], DiskBox[{2, 4}]}}, {
     {RGBColor[1, 0.7, 0], DiskBox[{4, 0}]}, 
     {RGBColor[1, 0.7, 
       NCache[
        Rational[1, 2], 0.5]], DiskBox[{4, 2}]}, 
     {RGBColor[1, 0.7, 1], DiskBox[{4, 4}]}}}], "//", "InputForm"}]], "Input",\

 CellLabel->"In[72]:=",
 CellID->280648648],

Cell["\<\
Graphics[{{{RGBColor[0, 0.7, 0], Disk[{0, 0}]}, {RGBColor[0, 0.7, 1/2], 
    Disk[{0, 2}]}, {RGBColor[0, 0.7, 1], Disk[{0, 4}]}}, 
  {{RGBColor[1/2, 0.7, 0], Disk[{2, 0}]}, {RGBColor[1/2, 0.7, 1/2], 
    Disk[{2, 2}]}, {RGBColor[1/2, 0.7, 1], Disk[{2, 4}]}}, 
  {{RGBColor[1, 0.7, 0], Disk[{4, 0}]}, {RGBColor[1, 0.7, 1/2], Disk[{4, \
2}]}, 
   {RGBColor[1, 0.7, 1], Disk[{4, 4}]}}}]\
\>", "Output",
 ImageSize->{553, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[72]//InputForm=",
 CellID->987738124]
}, Open  ]],

Cell[TextData[{
 "Type a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " command after the output graphic and evaluate."
}], "MathCaption",
 CellID->1660176439],

Cell[BoxData[
 RowBox[{
  GraphicsBox[{{
     {RGBColor[0, 0.7, 0], DiskBox[{0, 0}]}, 
     {RGBColor[0, 0.7, 
       NCache[
        Rational[1, 2], 0.5]], DiskBox[{0, 2}]}, 
     {RGBColor[0, 0.7, 1], DiskBox[{0, 4}]}}, {
     {RGBColor[
       NCache[
        Rational[1, 2], 0.5], 0.7, 0], DiskBox[{2, 0}]}, 
     {RGBColor[
       NCache[
        Rational[1, 2], 0.5], 0.7, 
       NCache[
        Rational[1, 2], 0.5]], DiskBox[{2, 2}]}, 
     {RGBColor[
       NCache[
        Rational[1, 2], 0.5], 0.7, 1], DiskBox[{2, 4}]}}, {
     {RGBColor[1, 0.7, 0], DiskBox[{4, 0}]}, 
     {RGBColor[1, 0.7, 
       NCache[
        Rational[1, 2], 0.5]], DiskBox[{4, 2}]}, 
     {RGBColor[1, 0.7, 1], DiskBox[{4, 4}]}}}], "/.", 
  RowBox[{"Disk", "\[Rule]", "Rectangle"}]}]], "Input",
 CellID->180527503],

Cell["The disks are now replaced by squares.", "MathCaption",
 CellID->32278947],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlDsKgEAMRLO4h7AUvYtWHmIRwS1EUQ+wd1rvF6OkE0vBzxSZGfKqaaZ2
S9f2bvGNy6rJjZ1v5qwcJnklhojW/VKSzJKOW5nFz2pFc4pU7B7UOR5/UFDQ
v9KrxXijatOgTYM2DRYUFPTT9An7c8uasfZl7csWFBT00/RqE8hsYy5Nzg==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->332795712],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->881266509],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsInteractivityAndDrawing"]], "TutorialMoreAbout",
 CellID->47647152],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AnnotatingAndCombiningGraphics"]], "TutorialMoreAbout",
 CellID->39409291],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "TutorialMoreAbout",
 CellID->4750463],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsAnnotationAndAppearance"]], "TutorialMoreAbout",
 CellID->71032073],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "TutorialMoreAbout",
 CellID->113160759],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "TutorialMoreAbout",
 CellID->42656734]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->315321217],

Cell[TextData[{
 ButtonBox["Editing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"]
}], "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics As Input - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Editing Mathematica Graphics", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InteractiveGraphicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InteractiveGraphicsLayout#27684169"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InteractiveGraphics3DInteraction#181090781"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 42.8024808}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "An image is equivalent to its symbolic expression. You can operate on an \
image as you would a symbolic expression. This input produces some disks. \
Type // InputForm after the graphic to get the symbolic expression that \
corresponds to the graphic.", "synonyms" -> {}, "title" -> 
    "Graphics As Input", "type" -> "Tutorial", "uri" -> 
    "tutorial/InteractiveGraphicsDirectOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2187, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2812, 78, 54, 1, 70, "Title",
 CellID->509267359],
Cell[2869, 81, 160, 4, 70, "Text",
 CellID->384676789],
Cell[3032, 87, 74, 1, 70, "MathCaption",
 CellID->653821473],
Cell[CellGroupData[{
Cell[3131, 92, 625, 20, 28, "Input",
 CellID->13056279],
Cell[3759, 114, 871, 29, 380, "Output",
 CellID->3927940]
}, Open  ]],
Cell[4645, 146, 301, 10, 70, "MathCaption",
 CellID->1617373851],
Cell[4949, 158, 627, 20, 70, "Input",
 CellID->354310031],
Cell[CellGroupData[{
Cell[5601, 182, 795, 26, 70, "Input",
 CellID->280648648],
Cell[6399, 210, 552, 13, 130, "Output",
 CellID->987738124]
}, Open  ]],
Cell[6966, 226, 290, 11, 70, "MathCaption",
 CellID->1660176439],
Cell[7259, 239, 801, 25, 70, "Input",
 CellID->180527503],
Cell[8063, 266, 80, 1, 31, "MathCaption",
 CellID->32278947],
Cell[8146, 269, 396, 11, 201, "Output",
 Evaluatable->False,
 CellID->332795712],
Cell[CellGroupData[{
Cell[8567, 284, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->881266509],
Cell[8636, 287, 185, 4, 70, "TutorialMoreAbout",
 CellID->47647152],
Cell[8824, 293, 183, 4, 70, "TutorialMoreAbout",
 CellID->39409291],
Cell[9010, 299, 153, 3, 70, "TutorialMoreAbout",
 CellID->4750463],
Cell[9166, 304, 185, 4, 70, "TutorialMoreAbout",
 CellID->71032073],
Cell[9354, 310, 171, 3, 70, "TutorialMoreAbout",
 CellID->113160759],
Cell[9528, 315, 169, 3, 70, "TutorialMoreAbout",
 CellID->42656734]
}, Open  ]],
Cell[CellGroupData[{
Cell[9734, 323, 72, 1, 70, "RelatedTutorialsSection",
 CellID->315321217],
Cell[9809, 326, 413, 12, 70, "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]],
Cell[10249, 342, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

