(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13999,        464]
NotebookOptionsPosition[      9627,        329]
NotebookOutlinePosition[     12200,        397]
CellTagsIndexPosition[     12107,        391]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General" :> Documentation`HelpLookup["paclet:ref/General"], 
          "Off" :> Documentation`HelpLookup["paclet:ref/Off"], "On" :> 
          Documentation`HelpLookup["paclet:ref/On"], "$NewSymbol" :> 
          Documentation`HelpLookup["paclet:ref/$NewSymbol"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General\"\>", 2->"\<\"Off\"\>", 
       3->"\<\"On\"\>", 4->"\<\"$NewSymbol\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Intercepting the Creation of New Symbols", "Title",
 CellTags->{"S2.7.13", "13.1"},
 CellID->25032],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " creates a new symbol when you first enter a particular name. Sometimes it \
is useful to \[OpenCurlyDoubleQuote]intercept\[CloseCurlyDoubleQuote] the \
process of creating a new symbol. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides several ways to do this. "
}], "Text",
 CellID->18102],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["On",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/On"], "[", 
     ButtonBox["General",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/General"], "::", "newsym", "]"}], Cell[
    "print a message whenever a new symbol is created", "TableText"]},
   {
    RowBox[{
     ButtonBox["Off",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Off"], "[", 
     ButtonBox["General",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/General"], "::", "newsym", "]"}], Cell[
    "switch off the message printed when new symbols are created", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5945],

Cell["Printing a message when new symbols are created. ", "Caption",
 CellID->20476],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to print a message whenever a new symbol is created. "
}], "MathCaption",
 CellID->28224],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "newsym"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9081],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " now prints a message about each new symbol that it creates. "
}], "MathCaption",
 CellID->22195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "[", "k", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31623],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"newsym\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Symbol \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(sin\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is \
new.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"General\\\", \\\"newsym\\\"}]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1405262],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"newsym\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Symbol \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(k\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is new.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"General\\\", \\\"newsym\\\"}]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[2]:=",
 CellID->889876474],

Cell[BoxData[
 RowBox[{"sin", "[", "k", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->287520932]
}, Open  ]],

Cell["This switches off the message. ", "MathCaption",
 CellID->15369],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "newsym"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3282],

Cell[TextData[{
 "Generating a message when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " creates a new symbol is often a good way to catch typing mistakes. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself cannot tell the difference between an intentionally new name, and a \
misspelling of a name it already knows. But by reporting all new names it \
encounters, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to see whether any of them are mistakes. "
}], "Text",
 CellID->19989],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$NewSymbol",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$NewSymbol"], Cell["\<\
a function to be applied to the name and context of new symbols which are \
created\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14437],

Cell["Performing operations when new symbols are created. ", "Caption",
 CellID->21599],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " creates a new symbol, you may want it not just to print a message, but \
instead to perform some other action. Any function you specify as the value \
of the global variable ",
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " will automatically be applied to strings giving the name and context of \
each new symbol that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " creates. "
}], "Text",
 CellID->35],

Cell["\<\
This defines a function to be applied to each new symbol which is created. \
\>", "MathCaption",
 CellID->3179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$NewSymbol", "=", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Name: \>\"", ",", "#1", ",", "\"\< Context: \>\"", ",", "#2"}], 
    "]"}], "&"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19654],

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\<\"Name: \"\>", ",", "#1", ",", "\<\" Context: \"\>", ",", 
    "#2"}], "]"}], "&"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->382346976]
}, Open  ]],

Cell[TextData[{
 "The function is applied once to ",
 Cell[BoxData["v"], "InlineFormula"],
 " and once to ",
 Cell[BoxData["w"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "+", "w"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->28350],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Name: \"\>", "\[InvisibleSpace]", "\<\"v\"\>", 
   "\[InvisibleSpace]", "\<\" Context: \"\>", 
   "\[InvisibleSpace]", "\<\"Global`\"\>"}],
  SequenceForm["Name: ", "v", " Context: ", "Global`"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->132669039],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Name: \"\>", "\[InvisibleSpace]", "\<\"w\"\>", 
   "\[InvisibleSpace]", "\<\" Context: \"\>", 
   "\[InvisibleSpace]", "\<\"Global`\"\>"}],
  SequenceForm["Name: ", "w", " Context: ", "Global`"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->46302739]
}, Open  ]],

Cell[BoxData[
 RowBox[{"v", "+", "w"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->372847844]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->115398493],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Intercepting the Creation of New Symbols - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 53.3496258}", "context" -> "", 
    "keywords" -> {
     "creation of symbols", "messages", "newsym", "new symbols", "off", "on", 
      "symbols", "NewSymbol"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica creates a new symbol when you first enter a particular name. \
Sometimes it is useful to 'intercept' the process of creating a new symbol. \
Mathematica provides several ways to do this. Printing a message when new \
symbols are created. This tells Mathematica to print a message whenever a new \
symbol is created. ", "synonyms" -> {"2.7.13"}, "title" -> 
    "Intercepting the Creation of New Symbols", "type" -> "Tutorial", "uri" -> 
    "tutorial/InterceptingTheCreationOfNewSymbols"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.13"->{
  Cell[2110, 62, 105, 2, 70, "Title",
   CellTags->{"S2.7.13", "13.1"},
   CellID->25032]},
 "13.1"->{
  Cell[2110, 62, 105, 2, 70, "Title",
   CellTags->{"S2.7.13", "13.1"},
   CellID->25032]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.13", 11889, 380},
 {"13.1", 11992, 384}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1485, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2110, 62, 105, 2, 70, "Title",
 CellTags->{"S2.7.13", "13.1"},
 CellID->25032],
Cell[2218, 66, 372, 10, 70, "Text",
 CellID->18102],
Cell[2593, 78, 949, 28, 70, "DefinitionBox",
 CellID->5945],
Cell[3545, 108, 84, 1, 70, "Caption",
 CellID->20476],
Cell[3632, 111, 173, 6, 70, "MathCaption",
 CellID->28224],
Cell[3808, 119, 128, 4, 70, "Input",
 CellID->9081],
Cell[3939, 125, 164, 5, 70, "MathCaption",
 CellID->22195],
Cell[CellGroupData[{
Cell[4128, 134, 95, 3, 70, "Input",
 CellID->31623],
Cell[4226, 139, 498, 10, 70, "Message",
 CellID->1405262],
Cell[4727, 151, 496, 9, 70, "Message",
 CellID->889876474],
Cell[5226, 162, 187, 6, 36, "Output",
 CellID->287520932]
}, Open  ]],
Cell[5428, 171, 70, 1, 70, "MathCaption",
 CellID->15369],
Cell[5501, 174, 129, 4, 70, "Input",
 CellID->3282],
Cell[5633, 180, 522, 14, 70, "Text",
 CellID->19989],
Cell[6158, 196, 555, 16, 70, "DefinitionBox",
 CellID->14437],
Cell[6716, 214, 87, 1, 70, "Caption",
 CellID->21599],
Cell[6806, 217, 566, 17, 70, "Text",
 CellID->35],
Cell[7375, 236, 121, 3, 70, "MathCaption",
 CellID->3179],
Cell[CellGroupData[{
Cell[7521, 243, 235, 8, 70, "Input",
 CellID->19654],
Cell[7759, 253, 289, 9, 36, "Output",
 CellID->382346976]
}, Open  ]],
Cell[8063, 265, 187, 7, 70, "MathCaption",
 CellID->23399],
Cell[CellGroupData[{
Cell[8275, 276, 88, 3, 70, "Input",
 CellID->28350],
Cell[CellGroupData[{
Cell[8388, 283, 338, 8, 70, "Print",
 CellID->132669039],
Cell[8729, 293, 337, 8, 70, "Print",
 CellID->46302739]
}, Open  ]],
Cell[9081, 304, 180, 6, 36, "Output",
 CellID->372847844]
}, Open  ]],
Cell[CellGroupData[{
Cell[9298, 315, 72, 1, 70, "RelatedTutorialsSection",
 CellID->115398493],
Cell[9373, 318, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],
Cell[9600, 327, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

