(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18719,        663]
NotebookOptionsPosition[     13479,        501]
NotebookOutlinePosition[     16474,        576]
CellTagsIndexPosition[     16381,        570]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abort" :> Documentation`HelpLookup["paclet:ref/Abort"], 
          "AbortProtect" :> 
          Documentation`HelpLookup["paclet:ref/AbortProtect"], "CheckAbort" :> 
          Documentation`HelpLookup["paclet:ref/CheckAbort"], "Interrupt" :> 
          Documentation`HelpLookup["paclet:ref/Interrupt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abort\"\>", 
       2->"\<\"AbortProtect\"\>", 3->"\<\"CheckAbort\"\>", 
       4->"\<\"Interrupt\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Interrupts and Aborts", "Title",
 CellTags->{"S2.6.15", "15.1"},
 CellID->13759],

Cell[TextData[{
 ButtonBox["\"Interrupting Calculations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InterruptingCalculations"],
 " described how you can interrupt a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " computation by pressing appropriate keys on your keyboard. "
}], "Text",
 CellID->5850],

Cell[TextData[{
 "In some cases, you may want to simulate such interrupts from within a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program. In general, executing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interrupt"], "[", "]"}]], "InlineFormula"],
 " has the same effect as pressing interrupt keys. On a typical system, a \
menu of options is displayed, as discussed in \"",
 ButtonBox["Interrupting Calculations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InterruptingCalculations"],
 ". "
}], "Text",
 CellID->4546],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Interrupt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Interrupt"], "[", "]"}], Cell[
    "interrupt a computation", "TableText"]},
   {
    RowBox[{
     ButtonBox["Abort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abort"], "[", "]"}], Cell[
    "abort a computation", "TableText"]},
   {
    RowBox[{
     ButtonBox["CheckAbort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CheckAbort"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["failexpr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " and return the result, or ",
     Cell[BoxData[
      StyleBox["failexpr", "TI"]], "InlineFormula"],
     " if an abort occurs"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AbortProtect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbortProtect"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", masking the effect of aborts until the evaluation is complete"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29260],

Cell["Interrupts and aborts. ", "Caption",
 CellID->6427],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "[", "]"}]], "InlineFormula"],
 " has the same effect as interrupting a computation, and selecting the ",
 Cell[BoxData["abort"], "InlineFormula"],
 " option in the interrupt menu. "
}], "Text",
 CellID->22233],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "[", "]"}]], "InlineFormula"],
 " to implement an \[OpenCurlyDoubleQuote]emergency stop\
\[CloseCurlyDoubleQuote] in a program. In almost all cases, however, you \
should try to use functions like ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ", which lead to more controlled behavior. "
}], "Text",
 CellID->9421],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 " terminates the computation, so only the first ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " is executed. "
}], "MathCaption",
 CellID->3161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "a", "]"}], ";", 
  RowBox[{"Abort", "[", "]"}], ";", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27818],

Cell[BoxData["a"], "Print",
 CellID->9546],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21350]
}, Open  ]],

Cell[TextData[{
 "If you abort at any point during the evaluation of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally abandons the evaluation of the whole expression, and returns the \
value ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21263],

Cell[TextData[{
 "You can, however, \[OpenCurlyDoubleQuote]catch\[CloseCurlyDoubleQuote] \
aborts using the function ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 ". If an abort occurs during the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CheckAbort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CheckAbort"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["failexpr", "TI"]}], "]"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox["failexpr", "TI"]], "InlineFormula"],
 ", but the abort propagates no further. Functions like ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " use ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " in this way to contain the effect of aborts. "
}], "Text",
 CellID->16461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " catches the abort, prints ",
 Cell[BoxData["c"], "InlineFormula"],
 " and returns the value ",
 Cell[BoxData["aborted"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckAbort", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "a", "]"}], ";", 
    RowBox[{"Abort", "[", "]"}], ";", 
    RowBox[{"Print", "[", "b", "]"}]}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "c", "]"}], ";", "aborted"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->23458],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellID->9594],

Cell[BoxData["c"], "Print",
 CellID->27371]
}, Open  ]],

Cell[BoxData["aborted"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->17945]
}, Open  ]],

Cell[TextData[{
 "The effect of the ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 " is contained by ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 ", so ",
 Cell[BoxData["b"], "InlineFormula"],
 " is printed. "
}], "MathCaption",
 CellID->13502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckAbort", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", "a", "]"}], ";", 
     RowBox[{"Abort", "[", "]"}]}], ",", 
    RowBox[{
     RowBox[{"Print", "[", "c", "]"}], ";", "aborted"}]}], "]"}], ";", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->8246],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellID->20420],

Cell[BoxData["c"], "Print",
 CellID->25254],

Cell[BoxData["b"], "Print",
 CellID->7953]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "When you construct sophisticated programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you may sometimes want to guarantee that a particular section of code in \
a program cannot be aborted, either interactively or by calling ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 ". The function ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 " allows you to evaluate an expression, saving up any aborts until after the \
evaluation of the expression is complete. "
}], "Text",
 CellID->15760],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 " is saved up until ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 " is finished. "
}], "MathCaption",
 CellID->3586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AbortProtect", "[", 
   RowBox[{
    RowBox[{"Abort", "[", "]"}], ";", 
    RowBox[{"Print", "[", "a", "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->25419],

Cell[BoxData["a"], "Print",
 CellID->28735],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->16616]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " sees the abort, but does not propagate it further. "
}], "MathCaption",
 CellID->20113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AbortProtect", "[", 
   RowBox[{
    RowBox[{"Abort", "[", "]"}], ";", 
    RowBox[{"CheckAbort", "[", 
     RowBox[{
      RowBox[{"Print", "[", "a", "]"}], ",", "x"}], "]"}]}], "]"}], ";", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->13335],

Cell[BoxData["b"], "Print",
 CellID->28592]
}, Open  ]],

Cell[TextData[{
 "Even inside ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " will see any aborts that occur, and will return the appropriate ",
 Cell[BoxData[
  StyleBox["failexpr", "TI"]], "InlineFormula"],
 ". Unless this ",
 Cell[BoxData[
  StyleBox["failexpr", "TI"]], "InlineFormula"],
 " itself contains ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "[", "]"}]], "InlineFormula"],
 ", the aborts will be \
\[OpenCurlyDoubleQuote]absorbed\[CloseCurlyDoubleQuote] by the ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->29018],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->33577463],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interrupts and Aborts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ControllingInfiniteEvaluation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CompilingMathematicaExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 54.7871626}", "context" -> "", 
    "keywords" -> {
     "abort", "AbortProtect", "aborts", "catching", "CheckAbort", 
      "critical section", "interrupt", "interrupts", "stopping calculations", 
      "terminating computations", "uninterruptible code", "aborted"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"Interrupting Calculations\" described how you can interrupt a \
Mathematica computation by pressing appropriate keys on your keyboard. In \
some cases, you may want to simulate such interrupts from within a \
Mathematica program. In general, executing Interrupt[] has the same effect as \
pressing interrupt keys. On a typical system, a menu of options is displayed, \
as discussed in \"Interrupting Calculations\". Interrupts and aborts. ", 
    "synonyms" -> {"2.6.14"}, "title" -> "Interrupts and Aborts", "type" -> 
    "Tutorial", "uri" -> "tutorial/InterruptsAndAborts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.15"->{
  Cell[2141, 63, 86, 2, 70, "Title",
   CellTags->{"S2.6.15", "15.1"},
   CellID->13759]},
 "15.1"->{
  Cell[2141, 63, 86, 2, 70, "Title",
   CellTags->{"S2.6.15", "15.1"},
   CellID->13759]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.15", 16165, 559},
 {"15.1", 16267, 563}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1516, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2141, 63, 86, 2, 70, "Title",
 CellTags->{"S2.6.15", "15.1"},
 CellID->13759],
Cell[2230, 67, 319, 9, 70, "Text",
 CellID->5850],
Cell[2552, 78, 605, 17, 70, "Text",
 CellID->4546],
Cell[3160, 97, 1522, 47, 70, "DefinitionBox",
 CellID->29260],
Cell[4685, 146, 57, 1, 70, "Caption",
 CellID->6427],
Cell[4745, 149, 352, 11, 70, "Text",
 CellID->22233],
Cell[5100, 162, 651, 21, 70, "Text",
 CellID->9421],
Cell[5754, 185, 345, 12, 70, "MathCaption",
 CellID->3161],
Cell[CellGroupData[{
Cell[6124, 201, 190, 6, 70, "Input",
 CellID->27818],
Cell[6317, 209, 42, 1, 70, "Print",
 CellID->9546],
Cell[6362, 212, 162, 5, 36, "Output",
 CellID->21350]
}, Open  ]],
Cell[6539, 220, 430, 15, 70, "Text",
 CellID->21263],
Cell[6972, 237, 1190, 39, 70, "Text",
 CellID->16461],
Cell[8165, 278, 321, 11, 70, "MathCaption",
 CellID->21846],
Cell[CellGroupData[{
Cell[8511, 293, 321, 10, 70, "Input",
 CellID->23458],
Cell[CellGroupData[{
Cell[8857, 307, 42, 1, 70, "Print",
 CellID->9594],
Cell[8902, 310, 43, 1, 70, "Print",
 CellID->27371]
}, Open  ]],
Cell[8960, 314, 161, 5, 36, "Output",
 CellID->17945]
}, Open  ]],
Cell[9136, 322, 396, 15, 70, "MathCaption",
 CellID->13502],
Cell[CellGroupData[{
Cell[9557, 341, 337, 11, 70, "Input",
 CellID->8246],
Cell[CellGroupData[{
Cell[9919, 356, 43, 1, 70, "Print",
 CellID->20420],
Cell[9965, 359, 43, 1, 70, "Print",
 CellID->25254],
Cell[10011, 362, 42, 1, 70, "Print",
 CellID->7953]
}, Open  ]]
}, Open  ]],
Cell[10080, 367, 672, 18, 70, "Text",
 CellID->15760],
Cell[10755, 387, 340, 13, 70, "MathCaption",
 CellID->3586],
Cell[CellGroupData[{
Cell[11120, 404, 247, 8, 70, "Input",
 CellID->25419],
Cell[11370, 414, 43, 1, 70, "Print",
 CellID->28735],
Cell[11416, 417, 162, 5, 36, "Output",
 CellID->16616]
}, Open  ]],
Cell[11593, 425, 238, 8, 70, "MathCaption",
 CellID->20113],
Cell[CellGroupData[{
Cell[11856, 437, 314, 10, 70, "Input",
 CellID->13335],
Cell[12173, 449, 43, 1, 70, "Print",
 CellID->28592]
}, Open  ]],
Cell[12231, 453, 915, 31, 70, "Text",
 CellID->29018],
Cell[CellGroupData[{
Cell[13171, 488, 71, 1, 70, "RelatedTutorialsSection",
 CellID->33577463],
Cell[13245, 491, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[13452, 499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

