(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23065,        852]
NotebookOptionsPosition[     16746,        647]
NotebookOutlinePosition[     19566,        719]
CellTagsIndexPosition[     19475,        713]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval" :> Documentation`HelpLookup["paclet:ref/Interval"], 
          "IntervalIntersection" :> 
          Documentation`HelpLookup["paclet:ref/IntervalIntersection"], 
          "IntervalMemberQ" :> 
          Documentation`HelpLookup["paclet:ref/IntervalMemberQ"], 
          "IntervalUnion" :> 
          Documentation`HelpLookup["paclet:ref/IntervalUnion"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interval\"\>", 
       2->"\<\"IntervalIntersection\"\>", 3->"\<\"IntervalMemberQ\"\>", 
       4->"\<\"IntervalUnion\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Interval Arithmetic", "Title",
 CellTags->{"S3.1.7", "7.1"},
 CellID->9265],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Interval",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Interval"], "[", "{", 
     StyleBox["min", "TI"], ",", 
     StyleBox["max", "TI"], "}", "]"}], Cell[TextData[{
     "the interval from ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Interval",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Interval"], "[", "{", 
     SubscriptBox[
      StyleBox["min", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["max", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["min", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["max", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the union of intervals from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["min", "TI"], "1"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["max", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["min", "TI"], "2"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["max", "TI"], "2"]], "InlineFormula"],
     ",",
     " ",
     "\[Ellipsis] "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9370],

Cell["Representations of real intervals. ", "Caption",
 CellID->22336],

Cell[TextData[{
 "This represents all numbers between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "2"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "5"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->26525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12746],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435589007]
}, Open  ]],

Cell[TextData[{
 "The square of any number between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "2"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "5"}], TraditionalForm]], "InlineMath"],
 " is always between 0 and 25. "
}], "MathCaption",
 CellID->19512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}], "^", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29482],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "25"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->603451011]
}, Open  ]],

Cell["Taking the reciprocal gives two distinct intervals. ", "MathCaption",
 CellID->5105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25726],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "5"], ",", "\[Infinity]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{190, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1366756669]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " folds the intervals back together again. "
}], "MathCaption",
 CellID->773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25306],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["1", "5"], ",", "\[Infinity]"}], "}"}], "]"}]], "Output",
 ImageSize->{119, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1908399879]
}, Open  ]],

Cell["You can use intervals in many kinds of functions. ", "MathCaption",
 CellID->31593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x"}], "+", "2"}], "==", 
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->23990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Interval", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", "3"]}], ",", "1"}], "}"}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{176, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1441722491]
}, Open  ]],

Cell["Some functions automatically generate intervals. ", "MathCaption",
 CellID->24214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->3223],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2016426294]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["IntervalUnion",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntervalUnion"], "[", 
     SubscriptBox[
      StyleBox["interval", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["interval", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["find the union of several intervals", "TableText"]},
   {
    RowBox[{
     ButtonBox["IntervalIntersection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntervalIntersection"], "[", 
     SubscriptBox[
      StyleBox["interval", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["interval", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["find the intersection of several intervals", "TableText"]},
   {
    RowBox[{
     ButtonBox["IntervalMemberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntervalMemberQ"], "[", 
     StyleBox["interval", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether the point ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " lies within an interval"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntervalMemberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntervalMemberQ"], "[", 
     SubscriptBox[
      StyleBox["interval", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["interval", "TI"], "2"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["interval", "TI"], "2"]], "InlineFormula"],
     " lies completely within ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["interval", "TI"], "1"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2700],

Cell["Operations on intervals. ", "Caption",
 CellID->18849],

Cell["This finds the overlap of the two intervals. ", "MathCaption",
 CellID->2322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalIntersection", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "7"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "5"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->13285],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "5"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->554585447]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " to find the end points of intervals. "
}], "MathCaption",
 CellID->2702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "%", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1268],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->947135606]
}, Open  ]],

Cell["\<\
This finds out which of a list of intervals contains the point 7.\
\>", "MathCaption",
 CellID->5152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalMemberQ", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Interval", "[", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"i", "+", "1"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "20", ",", "3"}], "}"}]}], "]"}], ",", 
   "7"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->23848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
   "False", ",", "False"}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->505840776]
}, Open  ]],

Cell[TextData[{
 "You can use intervals not only with exact quantities but also with \
approximate numbers. Even with machine\[Hyphen]precision numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always tries to do rounding in such a way as to preserve the validity of \
results."
}], "Text",
 CellID->28638],

Cell[TextData[{
 "This shows explicitly the interval treated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as the machine\[Hyphen]precision number ",
 Cell[BoxData["0."], "InlineFormula"]
}], "MathCaption",
 CellID->22762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interval", "[", "0.", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->28237],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.2250738585072014`*^-308"}], ",", 
    "2.2250738585072014`*^-308"}], "}"}], "]"}]], "Output",
 ImageSize->{297, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->124510341]
}, Open  ]],

Cell[TextData[{
 "This shows the corresponding interval around ",
 Cell[BoxData["100."], "InlineFormula"],
 ", shifted back to zero. "
}], "MathCaption",
 CellID->1792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interval", "[", "100.", "]"}], "-", "100"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->12200],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1.4210854715202007`*^-14"}], ",", 
    "1.4210854715202007`*^-14"}], "}"}], "]"}]], "Output",
 ImageSize->{287, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1754183514]
}, Open  ]],

Cell["The same kind of thing works with numbers of any precision. ", \
"MathCaption",
 CellID->17519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interval", "[", 
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", "50"}], "]"}], "]"}], "-", "Pi"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->7481],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "8.55284607201334952`0.43496078328485227*^-50"}], ",", 
    "8.55284807257670261`0.4349608848689935*^-50"}], "}"}], "]"}]], "Output",
 ImageSize->{217, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->2070030341]
}, Open  ]],

Cell["\<\
With ordinary machine\[Hyphen]precision arithmetic, this computation gives an \
incorrect result. \
\>", "MathCaption",
 CellID->8991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"N", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->29145],

Cell[BoxData["1.2246063538223773`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1392495970]
}, Open  ]],

Cell["\<\
The interval generated here, however, includes the correct value of 0. \
\>", "MathCaption",
 CellID->12714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"N", "[", "Pi", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->27085],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "3.2162857446782494`*^-16"}], ",", 
    "5.665498452323004`*^-16"}], "}"}], "]"}]], "Output",
 ImageSize->{280, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1137927244]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->122719002],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interval Arithmetic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MachinePrecisionNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IndeterminateAndInfiniteResults"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 55.4903056}", "context" -> "", 
    "keywords" -> {
     "arithmetic", "domains", "error analysis", "fuzzy arithmetic", 
      "interval", "interval arithmetic", "IntervalIntersection", 
      "IntervalMemberQ", "IntervalUnion", "machine-precision arithmetic", 
      "numerical analysis", "point location", "range arithmetic", "ranges", 
      "region", "rounding", "searching", "significance arithmetic", "spans", 
      "validated numeric computation"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Representations of real intervals. This represents all numbers between \
-2 and +5. The square of any number between -2 and +5 is always between 0 and \
25. ", "synonyms" -> {"3.1.7"}, "title" -> "Interval Arithmetic", "type" -> 
    "Tutorial", "uri" -> "tutorial/IntervalArithmetic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.7"->{
  Cell[2160, 64, 81, 2, 70, "Title",
   CellTags->{"S3.1.7", "7.1"},
   CellID->9265]},
 "7.1"->{
  Cell[2160, 64, 81, 2, 70, "Title",
   CellTags->{"S3.1.7", "7.1"},
   CellID->9265]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.7", 19266, 702},
 {"7.1", 19364, 706}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1535, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2160, 64, 81, 2, 70, "Title",
 CellTags->{"S3.1.7", "7.1"},
 CellID->9265],
Cell[2244, 68, 1870, 61, 70, "DefinitionBox",
 CellID->9370],
Cell[4117, 131, 70, 1, 70, "Caption",
 CellID->22336],
Cell[4190, 134, 273, 11, 70, "MathCaption",
 CellID->26525],
Cell[CellGroupData[{
Cell[4488, 149, 167, 6, 28, "Input",
 CellID->12746],
Cell[4658, 157, 260, 9, 36, "Output",
 CellID->435589007]
}, Open  ]],
Cell[4933, 169, 297, 11, 70, "MathCaption",
 CellID->19512],
Cell[CellGroupData[{
Cell[5255, 184, 193, 7, 28, "Input",
 CellID->29482],
Cell[5451, 193, 241, 8, 36, "Output",
 CellID->603451011]
}, Open  ]],
Cell[5707, 204, 90, 1, 70, "MathCaption",
 CellID->5105],
Cell[CellGroupData[{
Cell[5822, 209, 193, 7, 28, "Input",
 CellID->25726],
Cell[6018, 218, 426, 15, 51, "Output",
 CellID->1366756669]
}, Open  ]],
Cell[6459, 236, 203, 7, 70, "MathCaption",
 CellID->773],
Cell[CellGroupData[{
Cell[6687, 247, 95, 3, 70, "Input",
 CellID->25306],
Cell[6785, 252, 274, 9, 51, "Output",
 CellID->1908399879]
}, Open  ]],
Cell[7074, 264, 89, 1, 70, "MathCaption",
 CellID->31593],
Cell[CellGroupData[{
Cell[7188, 269, 312, 12, 70, "Input",
 CellID->23990],
Cell[7503, 283, 378, 14, 51, "Output",
 CellID->1441722491]
}, Open  ]],
Cell[7896, 300, 88, 1, 70, "MathCaption",
 CellID->24214],
Cell[CellGroupData[{
Cell[8009, 305, 200, 7, 70, "Input",
 CellID->3223],
Cell[8212, 314, 261, 9, 36, "Output",
 CellID->2016426294]
}, Open  ]],
Cell[8488, 326, 2266, 66, 70, "DefinitionBox",
 CellID->2700],
Cell[10757, 394, 60, 1, 70, "Caption",
 CellID->18849],
Cell[10820, 397, 83, 1, 70, "MathCaption",
 CellID->2322],
Cell[CellGroupData[{
Cell[10928, 402, 331, 11, 70, "Input",
 CellID->13285],
Cell[11262, 415, 240, 8, 36, "Output",
 CellID->554585447]
}, Open  ]],
Cell[11517, 426, 336, 13, 70, "MathCaption",
 CellID->2702],
Cell[CellGroupData[{
Cell[11878, 443, 94, 3, 70, "Input",
 CellID->1268],
Cell[11975, 448, 158, 5, 36, "Output",
 CellID->947135606]
}, Open  ]],
Cell[12148, 456, 111, 3, 70, "MathCaption",
 CellID->5152],
Cell[CellGroupData[{
Cell[12284, 463, 388, 13, 70, "Input",
 CellID->23848],
Cell[12675, 478, 288, 9, 36, "Output",
 CellID->505840776]
}, Open  ]],
Cell[12978, 490, 320, 8, 70, "Text",
 CellID->28638],
Cell[13301, 500, 234, 7, 70, "MathCaption",
 CellID->22762],
Cell[CellGroupData[{
Cell[13560, 511, 102, 3, 70, "Input",
 CellID->28237],
Cell[13665, 516, 314, 10, 39, "Output",
 CellID->124510341]
}, Open  ]],
Cell[13994, 529, 168, 5, 70, "MathCaption",
 CellID->1792],
Cell[CellGroupData[{
Cell[14187, 538, 129, 4, 70, "Input",
 CellID->12200],
Cell[14319, 544, 313, 10, 39, "Output",
 CellID->1754183514]
}, Open  ]],
Cell[14647, 557, 101, 2, 70, "MathCaption",
 CellID->17519],
Cell[CellGroupData[{
Cell[14773, 563, 180, 6, 70, "Input",
 CellID->7481],
Cell[14956, 571, 352, 10, 39, "Output",
 CellID->2070030341]
}, Open  ]],
Cell[15323, 584, 144, 4, 70, "MathCaption",
 CellID->8991],
Cell[CellGroupData[{
Cell[15492, 592, 125, 4, 70, "Input",
 CellID->29145],
Cell[15620, 598, 183, 5, 36, "Output",
 CellID->1392495970]
}, Open  ]],
Cell[15818, 606, 118, 3, 70, "MathCaption",
 CellID->12714],
Cell[CellGroupData[{
Cell[15961, 613, 161, 5, 70, "Input",
 CellID->27085],
Cell[16125, 620, 312, 10, 39, "Output",
 CellID->1137927244]
}, Open  ]],
Cell[CellGroupData[{
Cell[16474, 635, 72, 1, 70, "RelatedTutorialsSection",
 CellID->122719002],
Cell[16549, 638, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[16719, 645, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

