(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26126,        916]
NotebookOptionsPosition[     20228,        734]
NotebookOutlinePosition[     23307,        809]
CellTagsIndexPosition[     23216,        803]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Patterns" :> 
         Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Patterns", "Title",
 CellTags->{"S2.3.1", "1.1"},
 CellID->139],

Cell[TextData[{
 "Patterns are used throughout ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to represent classes of expressions. A simple example of a pattern is the \
expression ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 ". This pattern represents the class of expressions with the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["anything", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19821],

Cell[TextData[{
 "The main power of patterns comes from the fact that many operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be done not only with single expressions, but also with patterns that \
represent whole classes of expressions. "
}], "Text",
 CellID->6340],

Cell["\<\
You can use patterns in transformation rules to specify how classes of \
expressions should be transformed. \
\>", "MathCaption",
 CellID->3640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], "+", 
   RowBox[{"f", "[", "b", "]"}]}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "->", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->7966],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["b", "2"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->29081]
}, Open  ]],

Cell["\<\
You can use patterns to find the positions of all expressions in a particular \
class. \
\>", "MathCaption",
 CellID->8148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"g", "[", "b", "]"}], ",", 
     RowBox[{"f", "[", "c", "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", "x_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->9951]
}, Open  ]],

Cell[TextData[{
 "The basic object that appears in almost all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns is ",
 Cell[BoxData["_"], "InlineFormula"],
 " (traditionally called \[OpenCurlyDoubleQuote]blank\[CloseCurlyDoubleQuote] \
by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers). The fundamental rule is simply that _ ",
 StyleBox["stands for any expression",
  FontSlant->"Italic"],
 ". On most keyboards the ",
 Cell[BoxData["_"], "InlineFormula"],
 " underscore character appears as the shifted version of the ",
 Cell[BoxData["-"], "InlineFormula"],
 " dash character. "
}], "Text",
 CellID->12907],

Cell[TextData[{
 "Thus, for example, the pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", "_", "]"}]], "InlineFormula"],
 " stands for any expression of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["anything", "TI"], "]"}]], "InlineFormula"],
 ". The pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " also stands for any expression of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["anything", "TI"], "]"}]], "InlineFormula"],
 ", but gives the name ",
 Cell[BoxData["x"], "InlineFormula"],
 " to the expression ",
 Cell[BoxData[
  StyleBox["anything", "TI"]], "InlineFormula"],
 ", allowing you to refer to it on the right\[Hyphen]hand side of a \
transformation rule. "
}], "Text",
 CellID->19551],

Cell["\<\
You can put blanks anywhere in an expression. What you get is a pattern which \
matches all expressions that can be made by \[OpenCurlyDoubleQuote]filling in \
the blanks\[CloseCurlyDoubleQuote] in any way. \
\>", "Text",
 CellID->3110],

Cell[BoxData[GridBox[{
   {
    RowBox[{"f", "[", "n_", "]"}], Cell[
    "f with any argument, named n", "TableText"]},
   {
    RowBox[{"f", "[", "n_", ",", "m_", "]"}], Cell[
    "f with two arguments, named n and m", "TableText"]},
   {
    RowBox[{"x", "^", "n_"}], Cell[
    "x to any power, with the power named n", "TableText"]},
   {
    RowBox[{"x_", "^", "n_"}], Cell[
    "any expression to any power", "TableText"]},
   {
    RowBox[{"a_", "+", "b_"}], Cell[
    "a sum of two expressions", "TableText"]},
   {
    RowBox[{"{", "a1_", ",", "a2_", "}"}], Cell[
    "a list of two expressions", "TableText"]},
   {
    RowBox[{"f", "[", "n_", ",", "n_", "]"}], Cell[TextData[{
     "f",
     " with two ",
     StyleBox["identical",
      FontSlant->"Italic"],
     " arguments"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6557],

Cell["Some examples of patterns. ", "Caption",
 CellID->27077],

Cell["\<\
You can construct patterns for expressions with any structure. \
\>", "MathCaption",
 CellID->13009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], "+", 
   RowBox[{"f", "[", "c", "]"}]}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", "+", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->403],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "c", "]"}], "+", 
  RowBox[{"p", "[", 
   RowBox[{"a", "+", "b"}], "]"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->21576]
}, Open  ]],

Cell[TextData[{
 "One of the most common uses of patterns is for \
\[OpenCurlyDoubleQuote]destructuring\[CloseCurlyDoubleQuote] function \
arguments. If you make a definition for ",
 Cell[BoxData[
  RowBox[{"f", "[", "list_", "]"}]], "InlineFormula"],
 ", then you need to use functions like ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " explicitly in order to pick out elements of the list. But if you know for \
example that the list will always have two elements, then it is usually much \
more convenient instead to give a definition instead for ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "]"}]], "InlineFormula"],
 ". Then you can refer to the elements of the list directly as ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". In addition, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not use the definition you have given unless the argument of ",
 Cell[BoxData["f"], "InlineFormula"],
 " really is of the required form of a list of two expressions. "
}], "Text",
 CellID->10540],

Cell["\<\
Here is one way to define a function which takes a list of two elements, and \
evaluates the first element raised to the power of the second element. \
\>", "MathCaption",
 CellID->26023],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "list_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Part", "[", 
    RowBox[{"list", ",", "1"}], "]"}], "^", 
   RowBox[{"Part", "[", 
    RowBox[{"list", ",", "2"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->22574],

Cell["\<\
Here is a much more elegant way to make the definition, using a pattern. \
\>", "MathCaption",
 CellID->15454],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
  RowBox[{"x", "^", "y"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->369],

Cell[TextData[{
 "A crucial point to understand is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns represent classes of expressions with a given ",
 StyleBox["structure",
  FontSlant->"Italic"],
 ". One pattern will match a particular expression if the structure of the \
pattern is the same as the structure of the expression, in the sense that by \
filling in blanks in the pattern you can get the expression. Even though two \
expressions may be ",
 StyleBox["mathematically equal",
  FontSlant->"Italic"],
 ", they cannot be represented by the same ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pattern unless they have the same structure. "
}], "Text",
 CellID->11906],

Cell[TextData[{
 "Thus, for example, the pattern ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x_"}], ")"}], "^", "2"}]], "InlineFormula"],
 " can stand for expressions like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "^", "2"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"b", "^", "3"}]}], ")"}], "^", "2"}]], "InlineFormula"],
 " that have the same ",
 StyleBox["structure",
  FontSlant->"Italic"],
 ". However, it cannot stand for the expression ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   RowBox[{"2", "a"}], "+", 
   RowBox[{"a", "^", "2"}]}]], "InlineFormula"],
 ". Although this expression is ",
 StyleBox["mathematically equal",
  FontSlant->"Italic"],
 " to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "^", "2"}]], "InlineFormula"],
 ", it does not have the same ",
 StyleBox["structure",
  FontSlant->"Italic"],
 " as the pattern ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x_"}], ")"}], "^", "2"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->32485],

Cell[TextData[{
 "The fact that patterns in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " specify the ",
 StyleBox["structure",
  FontSlant->"Italic"],
 " of expressions is crucial in making it possible to set up transformation \
rules which change the ",
 StyleBox["structure",
  FontSlant->"Italic"],
 " of expressions, while leaving them mathematically equal. "
}], "Text",
 CellID->24999],

Cell[TextData[{
 "It is worth realizing that in general it would be quite impossible for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to match patterns by mathematical, rather than structural, equivalence. In \
the case of expressions like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "^", "2"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   RowBox[{"2", "a"}], "+", 
   RowBox[{"a", "^", "2"}]}]], "InlineFormula"],
 ", you can determine equivalence just by using functions like ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ". But, as discussed in \"",
 ButtonBox["Reducing Expressions to Their Standard Form\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReducingExpressionsToTheirStandardForm"],
 " there is no general way to find out whether an arbitrary pair of \
mathematical expressions are equal. "
}], "Text",
 CellID->28048],

Cell[TextData[{
 "As another example, the pattern ",
 Cell[BoxData[
  RowBox[{"x", "^", "_"}]], "InlineFormula"],
 " will match the expression ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 ". It will not, however, match the expression ",
 Cell[BoxData["1"], "InlineFormula"],
 ", even though this could be considered as ",
 Cell[BoxData[
  RowBox[{"x", "^", "0"}]], "InlineFormula"],
 ". \"",
 ButtonBox["Optional and Default Arguments\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/OptionalAndDefaultArguments"],
 " will discuss how to construct a pattern for which this particular case \
will match. But you should understand that in all cases pattern matching in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is fundamentally structural. "
}], "Text",
 CellID->23930],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"x", "^", "n_"}]], "InlineFormula"],
 " matches only ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"x", "^", "3"}]], "InlineFormula"],
 ". ",
 Cell[BoxData["1"], "InlineFormula"],
 " and ",
 Cell[BoxData["x"], "InlineFormula"],
 " can mathematically be written as ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 ", but do not have the same structure."
}], "MathCaption",
 CellID->573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "x", ",", 
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "^", "3"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"x", "^", "n_"}], "->", 
   RowBox[{"r", "[", "n", "]"}]}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->26658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   RowBox[{"r", "[", "2", "]"}], ",", 
   RowBox[{"r", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->25816]
}, Open  ]],

Cell[TextData[{
 "Another point to realize is that the structure ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses in pattern matching is the full form of expressions printed by ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ". Thus, for example, an object such as ",
 Cell[BoxData[
  RowBox[{"1", "/", "x"}]], "InlineFormula"],
 ", whose full form is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{"x", ",", 
    RowBox[{"-", "1"}]}], "]"}]], "InlineFormula"],
 " will be matched by the pattern ",
 Cell[BoxData[
  RowBox[{"x_", "^", "n_"}]], "InlineFormula"],
 ", but not by the pattern ",
 Cell[BoxData[
  RowBox[{"x_", "/", "y_"}]], "InlineFormula"],
 ", whose full form is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"], "[", 
   RowBox[{"x_", ",", 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", 
     RowBox[{"y_", ",", 
      RowBox[{"-", "1"}]}], "]"}]}], "]"}]], "InlineFormula"],
 ". Again, \"",
 ButtonBox["Optional and Default Arguments\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/OptionalAndDefaultArguments"],
 " will discuss how you can construct patterns which can match all these \
cases. "
}], "Text",
 CellID->8884],

Cell[TextData[{
 "The expressions in the list contain explicit powers of ",
 Cell[BoxData["b"], "InlineFormula"],
 ", so the transformation rule can be applied. "
}], "MathCaption",
 CellID->20373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "/", "b"}], ",", 
    RowBox[{"1", "/", 
     RowBox[{"b", "^", "2"}]}], ",", 
    RowBox[{"2", "/", 
     RowBox[{"b", "^", "2"}]}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"b", "^", "n_"}], "->", 
   RowBox[{"d", "[", "n", "]"}]}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->20031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"d", "[", 
     RowBox[{"-", "1"}], "]"}]}], ",", 
   RowBox[{"d", "[", 
    RowBox[{"-", "2"}], "]"}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"d", "[", 
     RowBox[{"-", "2"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->22604]
}, Open  ]],

Cell["Here is the full form of the list. ", "MathCaption",
 CellID->9783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "/", "b"}], ",", 
    RowBox[{"1", "/", 
     RowBox[{"b", "^", "2"}]}], ",", 
    RowBox[{"2", "/", 
     RowBox[{"b", "^", "2"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->15791],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Power", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"b", ",", 
       RowBox[{"-", "2"}]}], "]"}], ",", 
     RowBox[{"Times", "[", 
      RowBox[{"2", ",", 
       RowBox[{"Power", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "2"}]}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{449, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//FullForm= ",
 CellID->25422]
}, Open  ]],

Cell[TextData[{
 "Although ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not use mathematical equivalences such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "1"], "=", "x"}], TraditionalForm]], "InlineMath"],
 " when matching patterns, it does use certain structural equivalences. Thus, \
for example, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes account of properties such as commutativity and associativity in \
pattern matching. "
}], "Text",
 CellID->8010],

Cell[TextData[{
 "To apply this transformation rule, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes use of the commutativity and associativity of addition. "
}], "MathCaption",
 CellID->20987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", "+", "b"}], "]"}], "+", 
   RowBox[{"f", "[", 
    RowBox[{"a", "+", "c"}], "]"}], "+", 
   RowBox[{"f", "[", 
    RowBox[{"b", "+", "d"}], "]"}]}], "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", "+", "x_"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"c", "+", "y_"}], "]"}]}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->32364],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"b", "+", "d"}], "]"}], "+", 
  RowBox[{"p", "[", 
   RowBox[{"b", ",", "a"}], "]"}]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->568]
}, Open  ]],

Cell[TextData[{
 "The discussion so far has considered only pattern objects such as ",
 Cell[BoxData["x_"], "InlineFormula"],
 " which can stand for any single expression. Later we discuss the constructs \
that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses to extend and restrict the classes of expressions represented by \
patterns. "
}], "Text",
 CellID->5994],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->440877341],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FindingExpressionsThatMatchAPattern"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 1.3498306}", "context" -> "", 
    "keywords" -> {
     "_", "algebraic expressions", "all expressions", "any expression", 
      "associativity", "blank", "blanks", "classes of expressions", 
      "commutativity", "destructuring", "dummy variables", "expressions", 
      "flat functions", "FullForm", "lists", "matching", 
      "orderless functions", "patterns", "pattern variables", "Powers", 
      "quantifiers in patterns", "rules", "structural equivalence", "sums", 
      "templates in patterns", "transformation rules", "Underbar", 
      "underscore", "variables", "wildcards"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Patterns are used throughout Mathematica to represent classes of \
expressions. A simple example of a pattern is the expression f[x_]. This \
pattern represents the class of expressions with the form f[anything]. The \
main power of patterns comes from the fact that many operations in \
Mathematica can be done not only with single expressions, but also with \
patterns that represent whole classes of expressions. You can use patterns in \
transformation rules to specify how classes of expressions should be \
transformed. ", "synonyms" -> {"2.3.1"}, "title" -> 
    "Introduction to Patterns", "type" -> "Tutorial", "uri" -> 
    "tutorial/Introduction-Patterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.1"->{
  Cell[1215, 42, 85, 2, 70, "Title",
   CellTags->{"S2.3.1", "1.1"},
   CellID->139]},
 "1.1"->{
  Cell[1215, 42, 85, 2, 70, "Title",
   CellTags->{"S2.3.1", "1.1"},
   CellID->139]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.1", 23009, 792},
 {"1.1", 23106, 796}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 85, 2, 70, "Title",
 CellTags->{"S2.3.1", "1.1"},
 CellID->139],
Cell[1303, 46, 455, 14, 70, "Text",
 CellID->19821],
Cell[1761, 62, 288, 7, 70, "Text",
 CellID->6340],
Cell[2052, 71, 154, 4, 70, "MathCaption",
 CellID->3640],
Cell[CellGroupData[{
Cell[2231, 79, 248, 9, 28, "Input",
 CellID->7966],
Cell[2482, 90, 225, 8, 36, "Output",
 CellID->29081]
}, Open  ]],
Cell[2722, 101, 133, 4, 70, "MathCaption",
 CellID->8148],
Cell[CellGroupData[{
Cell[2880, 109, 306, 10, 28, "Input",
 CellID->17547],
Cell[3189, 121, 247, 9, 36, "Output",
 CellID->9951]
}, Open  ]],
Cell[3451, 133, 644, 19, 70, "Text",
 CellID->12907],
Cell[4098, 154, 755, 23, 70, "Text",
 CellID->19551],
Cell[4856, 179, 246, 5, 70, "Text",
 CellID->3110],
Cell[5105, 186, 1176, 36, 70, "DefinitionBox",
 CellID->6557],
Cell[6284, 224, 62, 1, 70, "Caption",
 CellID->27077],
Cell[6349, 227, 110, 3, 70, "MathCaption",
 CellID->13009],
Cell[CellGroupData[{
Cell[6484, 234, 380, 14, 70, "Input",
 CellID->403],
Cell[6867, 250, 257, 9, 36, "Output",
 CellID->21576]
}, Open  ]],
Cell[7139, 262, 1165, 29, 70, "Text",
 CellID->10540],
Cell[8307, 293, 197, 4, 70, "MathCaption",
 CellID->26023],
Cell[8507, 299, 265, 9, 70, "Input",
 CellID->22574],
Cell[8775, 310, 120, 3, 70, "MathCaption",
 CellID->15454],
Cell[8898, 315, 190, 7, 70, "Input",
 CellID->369],
Cell[9091, 324, 703, 18, 70, "Text",
 CellID->11906],
Cell[9797, 344, 1149, 43, 70, "Text",
 CellID->32485],
Cell[10949, 389, 401, 13, 70, "Text",
 CellID->24999],
Cell[11353, 404, 1112, 32, 70, "Text",
 CellID->28048],
Cell[12468, 438, 809, 23, 70, "Text",
 CellID->23930],
Cell[13280, 463, 532, 20, 70, "MathCaption",
 CellID->573],
Cell[CellGroupData[{
Cell[13837, 487, 285, 10, 70, "Input",
 CellID->26658],
Cell[14125, 499, 279, 9, 36, "Output",
 CellID->25816]
}, Open  ]],
Cell[14419, 511, 1436, 46, 70, "Text",
 CellID->8884],
Cell[15858, 559, 197, 5, 70, "MathCaption",
 CellID->20373],
Cell[CellGroupData[{
Cell[16080, 568, 352, 13, 70, "Input",
 CellID->20031],
Cell[16435, 583, 410, 15, 36, "Output",
 CellID->22604]
}, Open  ]],
Cell[16860, 601, 73, 1, 70, "MathCaption",
 CellID->9783],
Cell[CellGroupData[{
Cell[16958, 606, 285, 10, 70, "Input",
 CellID->15791],
Cell[17246, 618, 745, 26, 50, "Output",
 CellID->25422]
}, Open  ]],
Cell[18006, 647, 513, 16, 70, "Text",
 CellID->8010],
Cell[18522, 665, 206, 6, 70, "MathCaption",
 CellID->20987],
Cell[CellGroupData[{
Cell[18753, 675, 501, 18, 70, "Input",
 CellID->32364],
Cell[19257, 695, 280, 10, 36, "Output",
 CellID->568]
}, Open  ]],
Cell[19552, 708, 376, 10, 70, "Text",
 CellID->5994],
Cell[CellGroupData[{
Cell[19953, 722, 72, 1, 70, "RelatedTutorialsSection",
 CellID->440877341],
Cell[20028, 725, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[20201, 732, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

