(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106246,       1917]
NotebookOptionsPosition[    102430,       1809]
NotebookOutlinePosition[    104695,       1864]
CellTagsIndexPosition[    104652,       1861]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Editing Mathematica Graphics" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InteractiveGraphicsOverview"]}, #, 2]& , Evaluator -> 
       Automatic], {
      1->"\<\"Editing Mathematica Graphics\"\>"}, "\<\"related tutorials\"\>",
       
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Introduction to Editing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Graphics"
}], "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["An Example of Editing Graphics", "Section",
 CellID->905654289],

Cell["\<\
We will use this graph to illustrate some of the ways of interacting with \
graphics.\
\>", "Text",
 CellID->46096212],

Cell["\<\
The following graph represents an impulse response of an ideal Low Pass \
Filter (LPF). We will use this graph to illustrate some of the ways of \
interacting with graphics. Details on each topic follow in the other parts of \
Interactive Graphics. \
\>", "MathCaption",
 CellID->326114994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Pi", 
      RowBox[{"(", 
       RowBox[{"t", "-", "4"}], ")"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"Pi", " ", 
      RowBox[{"(", 
       RowBox[{"t", "-", "4"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580595583],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300284932]
}, Open  ]],

Cell["\<\
Select the curve and change its color and thickness using the Graphics \
Inspector.\
\>", "MathCaption",
 CellID->67751693],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.003, 0.006}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl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      "]],
     FontColor->GrayLevel[0.]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
    RectangleBox[{0, -0.21184}, {9.9954, 0.99497}]}, 
   {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, {0, -0.21184}], 
     Offset[{3.5, 3.5}, {0, -0.21184}]], 
    RectangleBox[Offset[{0., -1.75}, {0, 0.39156}], 
     Offset[{3.5, 1.75}, {0, 0.39156}]], 
    RectangleBox[Offset[{0., -3.5}, {0, 0.99497}], 
     Offset[{3.5, 0.}, {0, 0.99497}]], 
    RectangleBox[Offset[{-1.75, 0.}, {4.9977, -0.21184}], 
     Offset[{1.75, 3.5}, {4.9977, -0.21184}]], 
    RectangleBox[Offset[{-1.75, -3.5}, {4.9977, 0.99497}], 
     Offset[{1.75, 0.}, {4.9977, 0.99497}]], 
    RectangleBox[Offset[{-3.5, 0.}, {9.9954, -0.21184}], 
     Offset[{0., 3.5}, {9.9954, -0.21184}]], 
    RectangleBox[Offset[{-3.5, -1.75}, {9.9954, 0.39156}], 
     Offset[{0., 1.75}, {9.9954, 0.39156}]], 
    RectangleBox[Offset[{-3.5, -3.5}, {9.9954, 0.99497}], 
     Offset[{0., 0.}, {9.9954, 0.99497}]]}, 
   {RGBColor[1., 0.560784, 0.262745], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl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      "]],
     FontColor->GrayLevel[0.]]}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 
    1}, {0, 1}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {4.49612223136964, 0.564041109982254}], 
     Offset[{21.5, -0.5}, {4.49612223136964, 0.564041109982254}]}]},
  AspectRatio->0.618033988749895,
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->{All, All},
  Ticks->None]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->355109490],

Cell["\<\
Using the Text tool and the TraditionalForm Text tool, add a plot label and \
axis labels. \
\>", "MathCaption",
 CellID->271661948],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.003, 0.006}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl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      "]],
     FontColor->GrayLevel[0.]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    RowBox[{"h", "(", "t", ")"}], {-0.52894, 0.96235}, {-1, 0}], 
   InsetBox[Cell["Impulse Response of Ideal LPF"], {4.9487, 0.8781}, {-1, 0}],
    InsetBox["t", {9.9128, -0.088497}, {-1, 0}], 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {0.83652469781497, 0.752061539150305}], 
     Offset[{21.5, -0.5}, {0.83652469781497, 0.752061539150305}]}]},
  AspectRatio->0.618033988749895,
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->{All, All},
  Ticks->None]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->19562315],

Cell["\<\
You can edit the title to change its font, color, size, and face.\
\>", "MathCaption",
 CellID->165273948],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.003, 0.006}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl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      "]],
     FontColor->GrayLevel[0.]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    RowBox[{"h", "(", "t", ")"}], {-0.52894, 0.96235}, {-1, 0}], 
   StyleBox[
    InsetBox[Cell[
     "Impulse Response of Ideal LPF"], {4.9487, 0.8781}, {-1, 0}],
    FontSize->12], {
    {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
     RectangleBox[{4.9038, 0.8368}, \
{9.637435782313787, 0.9286750635076054}]}, 
    {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
     RectangleBox[Offset[{0., 0.}, {4.9038, 0.8368}], 
      Offset[{3.5, 3.5}, {4.9038, 0.8368}]], 
     RectangleBox[Offset[{0., -1.75}, {4.9038, 0.88074}], 
      Offset[{3.5, 1.75}, {4.9038, 0.88074}]], 
     RectangleBox[Offset[{0., -3.5}, {4.9038, 0.92468}], 
      Offset[{3.5, 0.}, {4.9038, 0.92468}]], 
     RectangleBox[Offset[{-1.75, 0.}, {7.1677, 0.8368}], 
      Offset[{1.75, 3.5}, {7.1677, 0.8368}]], 
     RectangleBox[Offset[{-1.75, -3.5}, {7.1677, 0.92468}], 
      Offset[{1.75, 0.}, {7.1677, 0.92468}]], 
     RectangleBox[
      Offset[{-3.5, 2.0000000000000284`}, \
{9.645752080427707, 0.8250833949830243}], 
      Offset[{0., 5.500000000000028}, \
{9.645752080427707, 0.8250833949830243}]], 
     RectangleBox[
      Offset[{-3.5, 0.25}, {9.645752080427707, 0.8690233949830243}], 
      Offset[{0., 3.75}, {9.645752080427707, 0.8690233949830243}]], 
     RectangleBox[
      Offset[{-3.5, -1.4999999999999716`}, \
{9.645752080427707, 0.9129633949830243}], 
      Offset[{0., 2.0000000000000284`}, \
{9.645752080427707, 0.9129633949830243}]]}}, 
   InsetBox["t", {9.9128, -0.088497}, {-1, 0}], 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.500000000000057, -21.5}, {7.59761180846118, 0.933514385628098}],
      Offset[{21.5000000000001, -0.5}, {7.59761180846118, 
      0.933514385628098}]}]},
  AspectRatio->0.618033988749895,
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->{All, All},
  Ticks->None]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->1352909],

Cell["\<\
Draw vertical and horizontal lines to the maximum point with the Line tool.\
\>", "MathCaption",
 CellID->202466],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.003, 0.006}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl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      "]],
     FontColor->GrayLevel[0.]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    RowBox[{"h", "(", "t", ")"}], {-0.52894, 0.96235}, {-1, 0}], 
   StyleBox[
    InsetBox[Cell[
     "Impulse Response of Ideal LPF"], {4.9487, 0.8781}, {-1, 0}],
    FontSize->12], 
   {EdgeForm[None], FaceForm[None], 
    LineBox[{{4.01659087284984, 1.00083144268141}, {
     4.01659087284984, -0.00163367705398954}}], 
    LineBox[{{3.98599771850302, 0.995814607568025}, {3.03760993375174, 
     0.995814607568025}}]}, 
   {EdgeForm[RGBColor[1., 0.560784, 0.262745]], FaceForm[None], 
    RectangleBox[{4.2166, -0.0016337}, {3.8166, 1.0008}]}, 
   {EdgeForm[None], FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, {3.8166, -0.0016337}], 
     Offset[{3.5, 3.5}, {3.8166, -0.0016337}]], 
    RectangleBox[Offset[{0., -1.75}, {3.8166, 0.4996}], 
     Offset[{3.5, 1.75}, {3.8166, 0.4996}]], 
    RectangleBox[Offset[{0., -3.5}, {3.8166, 1.0008}], 
     Offset[{3.5, 0.}, {3.8166, 1.0008}]], 
    RectangleBox[Offset[{-1.75, 0.}, {4.0166, -0.0016337}], 
     Offset[{1.75, 3.5}, {4.0166, -0.0016337}]], 
    RectangleBox[Offset[{-1.75, -3.5}, {4.0166, 1.0008}], 
     Offset[{1.75, 0.}, {4.0166, 1.0008}]], 
    RectangleBox[Offset[{-3.5, 0.}, {4.2166, -0.0016337}], 
     Offset[{0., 3.5}, {4.2166, -0.0016337}]], 
    RectangleBox[Offset[{-3.5, -1.75}, {4.2166, 0.4996}], 
     Offset[{0., 1.75}, {4.2166, 0.4996}]], 
    RectangleBox[Offset[{-3.5, -3.5}, {4.2166, 1.0008}], 
     Offset[{0., 0.}, {4.2166, 1.0008}]]}, 
   {RGBColor[1., 0.560784, 0.262745], 
    LineBox[{{4.01659087284984, 1.00083144268141}, {
     4.01659087284984, -0.00163367705398954}}]}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {1, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 1}, {1, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {1, 1}, {0, 
    1}, {1, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.500000000000028, -21.5}, {
      3.94555913396445, -0.0142604021724391}], 
     Offset[{21.5, -0.499999999999972}, {
      3.94555913396445, -0.0142604021724391}]}], 
   InsetBox["t", {9.9128, -0.088497}, {-1, 0}]},
  AspectRatio->0.618033988749895,
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->{All, All},
  Ticks->None]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->14904336],

Cell["\<\
Select the lines and make them dashed using the Graphics Inspector.\
\>", "MathCaption",
 CellID->146771679],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.003, 0.006}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl
G4xtrHMnOyP5SVGWaENiKpSl8np/7/Pef+7zec695znPuc+5z/ccqqvP/hP8
fHx8tGV8fP+7//9K9CetOB8aXWNbdbh6TDkOJSxan5TfeAZv+Y9vI7faZt4m
ozCs9x/nIFM1cfPl9nEY/ceVqMfs2hTL4TbW+o9bUe/2+NptzdnYK6PSag3v
BVr0CG0yYxRge+MVPtrOL5F/7U2BE9+YeLi0Uq+j6TUaUXw3WqNQig0mCYr3
zvai57TrMyv4y3CU6mk+zw1vkRM+kj3dWIZPG3nEOzT2IZfCj/c1D5djm46v
+zqv9SPThLv7F++U4+1O3rKmhweQ4FNLK89/y7H+KK+vVnUQ9RhlX7BeLMcq
QX6Zm6cG0fD84vsYFRam8E+dzGO/Q+uj7nj+Aha+ZGogK71rCNW5KehdtGVh
IcmF0PbcIfQipy96lTMLh3ZX98UQhlHl2Ka3ycdYeOJOhKFJ8DDKcS/6+eMQ
C3u77Mj82zeMtMrVZmhmLPxe9a9AldF7VMMstSJtYGGXSfbJoKfvUcX1sP4O
MRbuLj3fqi3xATW4mk+jwXK8Nxw0v/p/QNLmhMOe2eW4SOh1UfbrD6j3aMJQ
rns5lrzmoXvC4CNSZ00fE1Mpxx2PUw0Hl31CRyQCZe0jynBS5TPTg62fUE70
TFE9sxTv/y8/nxG1Sq18oaEEd/8yPl6nPIrkJz2V/WKZ2I56O6i0YAwRje+a
CDxg4CzrWA19wgRSVjmmlzZ3D/Pj6m+DW7+hleu47MXlAejZFucfuP07khaj
212IfYTCC/inHxybQunquy6X/2airdQ1t8O2TaNj47rXC/jK0XSyqeF+2RnU
02gTTLlaiQqF3T+of59BI2bjyh+jatAcWtBNO/oTMY5NtCpU1SKPsKuxAu0/
kU7vQGRxPRs9DP7x21fvF9pxYg/5WBpGKGgNS9XrF7ohFnlzyyRGfQGH/AYf
/kIcbz20TJGDgv3jNVJ6f6GvoToTYMBB0n7sT5aSs0hh0Ka02oaDGD7fM/h3
ziLdwnOn7Fw5yNxbxbEybBYtI+w9Mu2xdN7roIxv4SxKfbcx6oI3B+V7XOlY
+2kW7R6rOTJ6hoMs3GtjB+Tn0ECEqO7qoxz06fQ345v75lDJbSPBRQsOijpF
/2MRPYe6125LSdbmIKWT9qxlNXOIO78yjivJQRVucX4V3+fQrseVjcDFyPZ4
jYaP6jzaaHiPpuSO0YrBhqo4h3lE2tLaoMqP0bNDz80fx8+jZLZb/4EENtLa
O3jqDW8ebfqR91P3XC0S1ed7bFKxgA7oyZapN1ahj3TaECPqN/qe6B1qaM5C
SZI7FeXM/6DSu2eqDxJLEN/+dQM1C3+Rk2zJQb/9GeihhcgL7YN8YHpUgp66
ORWHed/aMv11GQjXkWqnmzHWjxXb0FvCD5KRJiSRk41YLqV+ncVqAeCKlKb5
ZDfj2cyINTVnBUDMGWZLz7XitfZemoVFAuD9i5ARZNaGtxd9KszmCkCGWVe8
dEYbNhQ7uunhZwGI/L7hg/t4G7Z1e12evkwQtkrYjWxez8Xu7L0GKYqCQL4k
dmKNGxf/I9dcm6gnCH3xbf9OJ3HxLX9kFLtfEN5JaJw5WsTFae2shgtegpD0
ItKc0sjFjLXaZuGxgqDqmZO08JyL66OyuYGPBME7SN6/tI2L376lWHuzBeGS
1SfHldVc/GPz7a5TbwTB9No439D9JU6UtneZFoQeE0LUeBAXi47FvXGUEoJ+
mruv8NKDKZvwH7FVF4L2EY/fQn/asLHTp7bzJkLA+bzq5tXiNmwd0LI177AQ
kBOL6twPt+G0R4ky/ElCUPuym91ytRW3vbT9duiZENwPKN8akNCC/wgotBdO
CUGI7ixn4kgzDnJ7evHIIWEwPEqtc/BqwL0Nm7atqBWGfnPLN6urObgsalRw
vboIGKq/uCfcyMLJ2+917E0TgW1yAmmruNl4T6mw6w0/URAQMhoKHWUgVKJJ
IJPF4Itm5FBsWDd6c+OvWwtjBQyNey9sL3uPrulXlFyOFoeh6UiV+OnPaEic
6PTxhziYnfap5L4bRdpDfvwmzhLQY7i5LuTeF/QwL+zAmQYJaE05MPNT4iuS
DrnwOGmdJAynbegwtpxAN43jZsoSJUF0Xtnn9b5JtFNNgmz+TBJWrZaLj6md
REKS13f3T0lCCMrrnJLnobPUdaE56lKw1v7waKI3D63TmCEQdktBppfz9WPX
eWhy87OcYBcpkOk6an2ukIfuGyYYD0RIgRklYq6/hYf2mDn0mdySAvPqwYLQ
AR6S2b8mMLdECs6Yfu21mOChOqfv4tIvpED1rux661keij1RmxXyRQr84w0L
/vnLQ3dZO5V5/AQI4ctjfFjkocCaXI+HBALkKd/k+v3mIftnhAo7MgHU9Ix/
rZ/mIa2mYMHlmgRYHcjxlh/hIWlu/74afQK8DqWzDV7x0NgL43s+pgS4KuPG
Tmbz0LPu7DGaHQEaLnYkazziIaq/uWOqKwG2HxzZnHuRh0KkvrQt9yWAbMG/
sw+deWi9hUb+tysEmBexZ64T46HXlzwTerIIMBpQOCT3aBIlYYY3m7Nkj9Qd
6FOfRN83a+tc/UkAPog49l50AtnkFk85aEqDkMgBocnscQQJrrTaa9IwuzNg
ZVn0KNrgu9KGMiMNNZvOyRx//hF9/lrX1dGxEgR2xK2Nd+5Bgw6tT8XvrIIb
9uGWZb3VyNKWWpr/ZxUclr8cqpHligJs9lRFaMmAk9QbgYC7T3DO3jCOlYsM
WI9kieP3ZfhGWOUL+zQZqK9T2HK3DWPhJIcep2IZePZF5FmfRB0OfTw3eOy5
DJzY0egos1iPXV/oT7oLEMFpf6z3vH4z7vn4ZsaHTIS90r2MhIst2Hw+7E+g
PhFIYzvvp6Qs1c/zS7y8/UToQH+6qo+34St6V06bOhPBY+yh88rKNmyVmTT8
3mPJ3xcjUgU/Fy9bkeIYGUqEyfnPFm1L9VsXeOcl6TIRZCpHVp8J4OKLgxlW
ZdeJoIPTvFh3uHinWVbjvvtECGXA9NtyLhYozjX8mkuEK2GuiwvNXNykUMSK
YRFhwxWjc7s6uDj8cpk2vYEI2LHl08dWLt7Gq8phdxKBP6lOTWzpf1k4xKE5
DhBha2JI+kgmF9fWNabPjBHBbTz3EzOSi89pcmWu/1yyCy+fzLDhYsPUzgRN
AVmwiRBu+iLPxS4rFOJeE2TBNyUvmP9VG74adeJSFFkWLJV8450uteHP7vNn
u/Vl4ai8cLtsQys2sUvyU7OThdns7Bx2fwu+i1ROR/jKAu3W8BrSv83YRGav
ncpTWRAWzPiYeqgRz42GGLcPyMKYR+a3D/51eJv9A0Ml89WgYd5Jsuhg4fj6
FgPv0tWAz+5Jeef7CM+o3R2KlpODxRFaHWtLLMruu7wp2UIOOgzNDcReZSK3
RJ/ojAg5aHl5zzMuOx91enu9/1QsB2/lz3oFXy1BhtYehppjclD/dpvr5B8W
eqh15o6/MgkCHuR9Sr5Zjd4pn25JMSDByhvuRPPltUiacOpnhR0Jmidu6dw3
ZqO97E5JSR8SjL7vLR7WxigoRSi9IpwEWe3elrtvYpTgaaB6PJYE79YHbY78
ghHTxKdEIoUEe7z36TSROKhD/jGqyCRBLjtDv0aPg6a+93JdC0igsMfNWtWa
gyRaJQ5JVJNA1WvZK6ljHKT9wPgjq5kEnVveu0e5L+mFkBBf124ShMnkfb68
pA/89ub/Fh8mQXgGx1zLk4Pi1gzHsiZI8Ienyko4vqQffhOJrvMkGKtqOF1q
y0EvX1pkiovIg0Pz3KMKxEG83PPrWavkQSagiMFU4SCZf0orXSjy4L+uvbZC
gINyvtPd2zXlwbuIUxNUvaR/XJLl9fTloWgt/USIG0YR4B8uvl8eyP+oRRxJ
ZSOWsk3/sLs8eFQm7ZLLqEVTf7V2sC7Kw+6IBdH2Jb11onbir0uZPBDPdVjG
9lairvA8jvjIEp+KfDjELEcUW2v71/sV4GO3KytcnYF8NafGM9gKcMqh79Vb
pVQ0+ttIQ4euCK8vjDES18Zg6omxtjA7RTgtGfjL41Q6dnl+zb0uRhGqnvzd
aiSehc2PW63axVYEh0Z17qBOPoY5kZrmaUXw5ZB0MtWZeFNSvZuFhhJo3nT7
tju3BFMdqZXxu5WgjhDitL2wFCuuOS/x3EUJDsP4Jbv4MrymwNQKwpXAj6L8
THdTOX74I298LkYJYqK7phzDyjFFjxBfclMJCkWmnaG8HD8ID1T3ylSChldv
pIfGyrEap7d1bYES8IrO3dGTYeFswR1nhqqUoMlaW8xMl4VVzDNF7zQrgetd
6S/EPSz8KEEo+0C3EiT9stmc47TUL3SdMZUYVgK2vJGlhAsL58l2fG6aUIKN
t7R4+46wsJrTxuioeSUQO6y2KXofCz/NSF1jIEKGqz9ifOsMlvx/nG+YWkUG
OVaIPlmRhQvUnN0YFDKs9ThgUTZdjtd71QucWk8GPym+s08aluK1cG0e0ifD
5Q9PzHYmLPUvqsviHXeTwcNa6PSrPeVYadhw5V5nMoTuTi8+wyrDyukRt41C
yZB6oU+HsdQ/rbarouheJ4PXtBZRWqcUi7bqainWk4GcHyVQuqMYi+xg7hCY
IcOZwtn7q3oKsUtUp+cuF2WwtbnVWPrqES6q56XHPFeGjNBM00L/OJy6eLjK
jESBjqj8NM2hWBSQmKQdv5EChYMn14jvuoUOKdU9eW5JgZ5tGUePZ2QiQn0k
df0pCuya28ya/fEEjRMHBvsDKXA1jagQZ5uDmk5vu3v1Hwrk/GhjCV3IQ5cl
Z2W/3qOAcUxFsfeGQuTqYt+dnkcBdtGhcapdETIsLb1uWUmBaEwN9p4qQqkZ
ewKqmyhA9iLTT/owkTFR3i3gOQV2bhJ9HZ/JRN+ufLbV6KbAtHpFPuYy0T2+
kl0f3lLA6tr2ewsTTGQZfH5L+jAFbv/uF90hWox+jVuqHhilgF6gdsUl+WKU
5SInt4JHAf7HHa9eqxSjfT0fRetnKHDW+cGIgWox+mPFnDv7mwLNCy+bqqnF
KK/u3JeNAlTYnX829ZRMMTq01aLvy3IqWMd3V1gvMpFQgWz7QwIVgiJs6mPf
M1Ex/UON42oqOKTs8VNnM9Gx24WMlWQqvNpyLcX6BhOJSUXcb1Ohwlxoipis
MxNt3/xhuZQGFRquVVk1qjGRp4NF0AEdKgyn3DDc+bUINT6Ss+rfQYWrxrZh
Wi5FKG5r2dyEPRVO9iuoGUkUIJPnNk8XfaiQUXRLoqY4F/1xmbSVjqNCjGKq
lULbE7S+clulN6ZC6cnU0eqO28iJEKfUPkOFTrqWyeIxX3T/Q559ghoNDK81
mganJ2G0Z8fUhBENPJ7GPMsQuI2HyzuS9jrRYM65a19g5QN83uZVoFYgDXyn
e8ouuz3Gcl/7HAgJNPiisUL/7+WnuCz6veH3LBqs90wzkZTMxcu6TzBdimlw
Mlg3+bFMHramjtG72Ev3a06fzfuWhyXOMuVs2mmQQL8kta0gH598QkwmvKTB
n4c/qpPn8nFDV5hE5xsaXDkSnvVOj4HpiwMxSUM0+CauMbHqDANHaBjzW4/Q
wL/8wGmNBAYeOPgkQnKSBrV/e9LXPmZgg0tiv55P0+DubkLZigIGTi7y9ktY
oIGGnXXU51wGnurvGrfip4OAlcSRljsMvH+53knx5XS4cIuj1XKOgfN104e4
UnRIj/ay4bdlYDHXRcd4WTpoi/yMuKXEwO6Jx19ZKNHhEXVzFfNtPqaOaLS1
qtOB70XqObp2PhauV8dEHTo0mM7Dus48PHx/XamLHh2am6zV+E7m4Ux71ftz
JnTIkrUNnArIxZQmmv+6I3RwvabX5K2cjR/pknc7BNNh/pVLpZ5JFqZnkeTj
kpbi0eq43vUjE3cxVbi0JjrEaxiHBqFkHM3Wiqj5TQdTtU647GmD/28apAL/
Pw/6H+A8pXA=
      "]],
     FontColor->GrayLevel[0.]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    RowBox[{"h", "(", "t", ")"}], {-0.52894, 0.96235}, {-1, 0}], 
   StyleBox[
    InsetBox[Cell[
     "Impulse Response of Ideal LPF"], {4.9487, 0.8781}, {-1, 0}],
    FontSize->12], 
   {Dashing[{0.015, 0.005}], EdgeForm[None], FaceForm[None], 
    LineBox[{{4.01659087284984, 1.00083144268141}, {
     4.01659087284984, -0.00163367705398954}}], 
    LineBox[{{3.98599771850302, 0.995814607568025}, {3.03760993375174, 
     0.995814607568025}}]}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {2.18262348907485, 0.722770026607866}], 
     Offset[{21.5, -0.5}, {2.18262348907485, 0.722770026607866}]}], 
   InsetBox["t", {9.9128, -0.088497}, {-1, 0}]},
  AspectRatio->0.618033988749895,
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->{All, All},
  Ticks->None]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->183910142],

Cell["Label the point with the TraditionalForm Text tool.", "MathCaption",
 CellID->625772229],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.003, 0.006}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl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      "]],
     FontColor->GrayLevel[0.]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    RowBox[{"h", "(", "t", ")"}], {-0.52894, 0.96235}, {-1, 0}], 
   StyleBox[
    InsetBox[Cell[
     "Impulse Response of Ideal LPF"], {4.9487, 0.8781}, {-1, 0}],
    FontSize->12], 
   {Dashing[{0.015, 0.005}], EdgeForm[None], FaceForm[None], 
    LineBox[{{4.01659087284984, 1.00083144268141}, {
     4.01659087284984, -0.00163367705398954}}], 
    LineBox[{{3.98599771850302, 0.995814607568025}, {3.03760993375174, 
     0.995814607568025}}]}, 
   InsetBox["t", {9.9128, -0.088497}, {-1, 0}], {
    InsetBox["B", {2.8141, 0.99204}, {-1, 0}], InsetBox[
     SubscriptBox["t", "0"], {3.9181, -0.051024}, {-1, 0}]}, 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.5, -21.5}, {2.61092764993027, 0.845879778154319}], 
     Offset[{21.5, -0.5}, {2.61092764993027, 0.845879778154319}]}]},
  AspectRatio->0.618033988749895,
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->{All, All},
  Ticks->None]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->720459775],

Cell["Add the formula for the curve.", "MathCaption",
 CellID->59107556],

Cell[BoxData[
 GraphicsBox[{
   {EdgeForm[{RGBColor[1., 0.560784, 0.262745], Dashing[{0.003, 0.006}]}], 
    FaceForm[None], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, 
   {RGBColor[0, 0, 1], AbsoluteThickness[2], EdgeForm[None], 
    StyleBox[LineBox[CompressedData["
1:eJw1mHk4FF7Ux2VPllFGxjJmUYRCJVG5B5W1pFCoRNrs+xJJv8qSUAmVSipl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      "]],
     FontColor->GrayLevel[0.]]}, 
   {FaceForm[RGBColor[1., 0.560784, 0.262745]], 
    RectangleBox[Offset[{0., 0.}, Scaled[{0., 0.}]], Offset[{3.5, 3.5}, 
     Scaled[{0., 0.}]]], 
    RectangleBox[Offset[{0., -1.75}, Scaled[{0., 0.5}]], Offset[{3.5, 1.75}, 
     Scaled[{0., 0.5}]]], 
    RectangleBox[Offset[{0., -3.5}, Scaled[{0., 1.}]], Offset[{3.5, 0.}, 
     Scaled[{0., 1.}]]], 
    RectangleBox[Offset[{-1.75, 0.}, Scaled[{0.5, 0.}]], Offset[{1.75, 3.5}, 
     Scaled[{0.5, 0.}]]], 
    RectangleBox[Offset[{-1.75, -3.5}, Scaled[{0.5, 1.}]], Offset[{1.75, 0.}, 
     Scaled[{0.5, 1.}]]], 
    RectangleBox[Offset[{-3.5, 0.}, Scaled[{1., 0.}]], Offset[{0., 3.5}, 
     Scaled[{1., 0.}]]], 
    RectangleBox[Offset[{-3.5, -1.75}, Scaled[{1., 0.5}]], Offset[{0., 1.75}, 
     Scaled[{1., 0.5}]]], 
    RectangleBox[Offset[{-3.5, -3.5}, Scaled[{1., 1.}]], Offset[{0., 0.}, 
     Scaled[{1., 1.}]]]}, InsetBox[
    RowBox[{"h", "(", "t", ")"}], {-0.52894, 0.96235}, {-1, 0}], 
   StyleBox[
    InsetBox[Cell[
     "Impulse Response of Ideal LPF"], {4.9487, 0.8781}, {-1, 0}],
    FontSize->12], 
   {Dashing[{0.015, 0.005}], EdgeForm[None], FaceForm[None], 
    LineBox[{{4.01659087284984, 1.00083144268141}, {
     4.01659087284984, -0.00163367705398954}}], 
    LineBox[{{3.98599771850302, 0.995814607568025}, {3.03760993375174, 
     0.995814607568025}}]}, 
   InsetBox["t", {9.9128, -0.088497}, {-1, 0}], {
    InsetBox["B", {2.8141, 0.99204}, {-1, 0}], InsetBox[
     SubscriptBox["t", "0"], {3.9181, -0.051024}, {-1, 0}]}, InsetBox[
    RowBox[{
     RowBox[{"h", "(", "t", ")"}], "=", 
     FractionBox[
      RowBox[{"B", " ", "sin", " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", " ", 
         RowBox[{"B", "(", 
          RowBox[{"t", "-", 
           SubscriptBox["t", "0"]}], ")"}]}]}]}], 
      RowBox[{"\[Pi]", " ", 
       RowBox[{"B", "(", 
        RowBox[{"t", "-", 
         SubscriptBox["t", "0"]}], ")"}]}]]}], {5.7776, 0.64026}, {-1, 0}], 
   RasterBox[{{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {0, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 
    1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 1}, {1, 1}, {1, 1}, {0, 
    1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {1, 
    1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}, {{0, 1}, {1, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 1}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}}, {{0, 1}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
    0}, {0, 0}}}, {
    Offset[{0.500000000000057, -21.5}, {7.8423570432357, 0.341716033725989}], 
     Offset[{21.5000000000001, -0.5}, {7.8423570432357, 
      0.341716033725989}]}]},
  AspectRatio->0.618033988749895,
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{Automatic, Automatic},
  PlotRange->{All, All},
  Ticks->None]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->52242632],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->244384720],

Cell[TextData[{
 ButtonBox["Editing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"]
}], "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Editing Mathematica Graphics - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Editing Mathematica Graphics", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InteractiveGraphicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InteractiveGraphicsPalette"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 4.4749106}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "We will use this graph to illustrate some of the ways of interacting \
with graphics. The following graph represents an impulse response of an ideal \
Low Pass Filter (LPF). We will use this graph to illustrate some of the ways \
of interacting with graphics. Details on each topic follow in the other parts \
of Interactive Graphics. Select the curve and change its color and thickness \
using the Graphics Inspector.", "synonyms" -> {}, "title" -> 
    "Introduction to Editing Mathematica Graphics", "type" -> "Tutorial", 
    "uri" -> "tutorial/IntroductionToInteractiveGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 658, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1283, 44, 139, 6, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[1447, 54, 69, 1, 70, "Section",
 CellID->905654289],
Cell[1519, 57, 128, 4, 70, "Text",
 CellID->46096212],
Cell[1650, 63, 300, 6, 70, "MathCaption",
 CellID->326114994],
Cell[CellGroupData[{
Cell[1975, 73, 520, 17, 28, "Input",
 CellID->580595583],
Cell[2498, 92, 4605, 80, 244, "Output",
 Evaluatable->False,
 CellID->300284932]
}, Open  ]],
Cell[7118, 175, 133, 4, 70, "MathCaption",
 CellID->67751693],
Cell[7254, 181, 18810, 312, 70, "Input",
 CellID->355109490],
Cell[26067, 495, 142, 4, 70, "MathCaption",
 CellID->271661948],
Cell[26212, 501, 11769, 191, 70, "Input",
 CellID->19562315],
Cell[37984, 694, 116, 3, 70, "MathCaption",
 CellID->165273948],
Cell[38103, 699, 13123, 222, 70, "Input",
 CellID->1352909],
Cell[51229, 923, 123, 3, 70, "MathCaption",
 CellID->202466],
Cell[51355, 928, 13265, 223, 70, "Input",
 CellID->14904336],
Cell[64623, 1153, 118, 3, 70, "MathCaption",
 CellID->146771679],
Cell[64744, 1158, 12074, 199, 70, "Input",
 CellID->183910142],
Cell[76821, 1359, 94, 1, 70, "MathCaption",
 CellID->625772229],
Cell[76918, 1362, 12194, 201, 70, "Input",
 CellID->720459775],
Cell[89115, 1565, 72, 1, 70, "MathCaption",
 CellID->59107556],
Cell[89190, 1568, 12661, 215, 70, "Input",
 CellID->52242632],
Cell[CellGroupData[{
Cell[101876, 1787, 72, 1, 70, "RelatedTutorialsSection",
 CellID->244384720],
Cell[101951, 1790, 413, 12, 70, "RelatedTutorials",
 CellID->683270035]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[102403, 1807, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

