(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    407639,      10397]
NotebookOptionsPosition[    389126,       9850]
NotebookOutlinePosition[    391438,       9899]
CellTagsIndexPosition[    391395,       9896]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Manipulate Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedManipulateFunctionality"], 
          "Introduction to Dynamic" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToDynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Advanced Manipulate Functionality\"\>", 
       2->"\<\"Introduction to Dynamic\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Dynamic Interactivity Language\"\>", 
       2->"\<\"Dynamic Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Manipulate", "Title"],

Cell[TextData[{
 "The single command ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " lets you create an astonishing range of interactive applications with just \
a few lines of input. ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is designed to be used by anyone who is comfortable using basic commands \
such as ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ": it does not require learning any complicated new concepts, nor any \
understanding of user interface programing ideas."
}], "Text"],

Cell[TextData[{
 "The output you get from evaluating a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " command is an interactive object containing one or more controls (sliders, \
",
 "etc.",
 ") that you can use to vary the value of one or more parameters. The output \
is very much like a small applet or widget: it is not just a static result, \
it is a running program you can interact with."
}], "Text"],

Cell[TextData[{
 "This tutorial is designed for people who are familiar with the basics of \
using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language, including how to use functions, the various kinds of brackets \
and braces, and how to make simple plots. Some of the examples will use more \
advanced functions, but ",
 "it is",
 " not necessary to understand exactly how these work in order to get the \
point of the example."
}], "Text"],

Cell[TextData[{
 "Despite the length of this tutorial, it is only half the story. \"",
 ButtonBox["Advanced Manipulate Functionality\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedManipulateFunctionality"],
 " provides further information about some of the more sophisticated features \
of this rich command."
}], "Text"],

Cell[CellGroupData[{

Cell["Manipulate Is as Easy as Table", "Section"],

Cell[TextData[{
 "At its most basic, the syntax of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is identical to that of the humble function ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". Consider this ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command, which produces a list of numbers from one to twenty",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"n", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",\

 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Simply replace the word ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " with the word ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", and you get an interactive application that lets you explore values of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " with a slider."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"n", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 6.18, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20}}, Typeset`size$$ = {28.75, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$40836$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$40836$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`n$$, 
      "Specifications" :> {{$CellContext`n$$, 1, 20}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "If you are reading this documentation inside ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can click and drag the slider to see the displayed value change in \
real time (meaning that it changes while you are dragging the slider, not \
just when you release it). If you are reading a static form of the \
documentation, you will see the slider moved to an arbitrary position. (By \
default, it starts out on the left side, but in the following examples the \
slider has typically been moved away from its initial position.)"
}], "Text"],

Cell[TextData[{
 "In both ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["variable", "TI"], ",", 
    StyleBox["min", "TI"], ",", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " is used to specify an \"iterator\", giving the name of the variable and \
the range over which to vary it."
}], "Text"],

Cell[TextData[{
 "Of course the whole point of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " (and ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " for that matter) is that you can put any expression you like in the first \
argument, not just a simple variable name. Moving the slider in this very \
simple output already starts to give a flavor of the power of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 6.86, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20}}, Typeset`size$$ = {360., {105., 110.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$40862$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$40862$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`n$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}], 
      "Specifications" :> {{$CellContext`n$$, 1, 20}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {149., 154.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 305},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Again, if you are reading this in a static form you will have to trust that \
the graph changes in real time when the slider is moved.\
\>", "Text"],

Cell["\<\
Note that the slider has an extra icon next to it which, when clicked, opens \
a small panel of additional controls. Here, the panel from the previous \
example is opened.\
\>", "Text"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 6.42, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20}}, Typeset`size$$ = {360., {105., 110.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1559$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1559$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`n$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}], 
      "Specifications" :> {{$CellContext`n$$, 1, 20, Appearance -> "Open"}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {162., 167.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 331},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
The panel allows you to see the numerical value of the variable, as well as \
set it in motion using the animation controls.\
\>", "Text"],

Cell[TextData[{
 "If you want to see the value of the variable without having to open the \
subpanel, you can add the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", "\"\<Labeled\>\""}]], 
  "InlineFormula"],
 " to the variable specification (note the number displayed to the right of \
the plus sign, which is updated in real time as the slider is moved)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 6.1000000000000005`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20}}, Typeset`size$$ = {360., {105., 110.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$12388$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$12388$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`n$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}], 
      "Specifications" :> {{$CellContext`n$$, 1, 20, Appearance -> 
         "Labeled"}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {149., 154.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 305},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This is also the first hint that ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " goes far beyond the relative simplicity of ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ", both in its output and in the flexibility and range of what can be \
specified in the list of variables."
}], "Text"],

Cell[TextData[{
 "Just like ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " allows you to give more than one variable range specification",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n1$$ = 
    7.0600000000000005`, $CellContext`n2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}}, Typeset`size$$ = {360., {112., 117.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$15540$$ = 0, $CellContext`n2$15541$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n1$$ = 1, $CellContext`n2$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$15540$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$15541$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {170., 175.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "You can have as many variables as you like, including so many that a \
similar ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command would try to enumerate an unreasonably large number of entries",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a1", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n1", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], "+", 
      RowBox[{"a2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n2", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p2", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 0.936, $CellContext`a2$$ = 
    0.5, $CellContext`n1$$ = 1.6400000000000001`, $CellContext`n2$$ = 
    16.18, $CellContext`p1$$ = 1.376219852020282, $CellContext`p2$$ = 
    1.778141441931823, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`a1$$], 0, 1}, {
      Hold[$CellContext`p1$$], 0, 2 Pi}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`a2$$], 0, 1}, {
      Hold[$CellContext`p2$$], 0, 2 Pi}}, Typeset`size$$ = {
    360., {113., 117.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$53710$$ = 
    0, $CellContext`a1$53711$$ = 0, $CellContext`p1$53712$$ = 
    0, $CellContext`n2$53713$$ = 0, $CellContext`a2$53714$$ = 
    0, $CellContext`p2$53715$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 0, $CellContext`a2$$ = 
        0, $CellContext`n1$$ = 1, $CellContext`n2$$ = 1, $CellContext`p1$$ = 
        0, $CellContext`p2$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$53710$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$53711$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$53712$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$53713$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$53714$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$53715$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)] + \
$CellContext`a2$$ 
         Sin[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)], \
{$CellContext`x, 0, 2 Pi}, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`a1$$, 0, 
         1}, {$CellContext`p1$$, 0, 2 Pi}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`a2$$, 0, 1}, {$CellContext`p2$$, 0, 2 Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {225., 230.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 457},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
You can open any or all of the subpanels to see numerical values, and you are \
free to animate many different variables at the same time if you like.\
\>", "Text"],

Cell[TextData[{
 "One way to think of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is as a way to interactively explore a large parameter space. You can move \
around that space at will, exploring interesting directions as they appear",
 ". ",
 "As you will see in later sections, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " has many features designed to make such exploration easier and more \
rewarding."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Output and Step Sizes", "Section"],

Cell[TextData[{
 "The previous examples are graphical, and indeed interactive graphics are \
the most common application for ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". But ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is capable of making any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function interactive, not just graphical ones."
}], "Text"],

Cell[TextData[{
 "Often the first issue in examples involving symbolic, rather than \
graphical, output is that you want to deal with integers, rather than \
continuously variable real numbers. In ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " the default step size is 1, so you naturally get integers, while in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " the default is to allow continuous variation (which you could think of as \
a step size of zero). Compare these two examples, and note that ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " allows values in between those returned by ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"n", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]], "Output",\

 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"n", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 11.72, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20}}, Typeset`size$$ = {35., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$146662$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$146662$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`n$$, 
      "Specifications" :> {{$CellContext`n$$, 1, 20}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Functions involving algebraic manipulations, for example, often do nothing \
interesting when given non-integer parameter values. This ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " function never expands anything",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "n"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 12.42, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20}}, Typeset`size$$ = {
    66.125, {2., 11.375}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$146766$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$146766$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Expand[($CellContext`\[Alpha] + $CellContext`\[Beta])^$CellContext`n$$],
       "Specifications" :> {{$CellContext`n$$, 1, 20}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Fortunately it is trivial to add an explicit step size of 1 to the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " command, yielding exactly the same set of possible values in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " as are returned by ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"n", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 8, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$146636$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$146636$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`n$$, 
      "Specifications" :> {{$CellContext`n$$, 1, 20, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "With an explicit step size, the ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " example is much more interesting",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "n"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 10, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20, 1}}, Typeset`size$$ = {
    590.25, {2., 11.375}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$146792$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$146792$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Expand[($CellContext`\[Alpha] + $CellContext`\[Beta])^$CellContext`n$$],
       "Specifications" :> {{$CellContext`n$$, 1, 20, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{637., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{641, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "The fact that only one value is displayed at a time allows you to create \
examples that go far beyond what would be practical in a ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command. An important property of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output is that there is no fixed panel size or arbitrary limit as to how \
large the output panel can grow."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "n"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "300", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 53, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 300, 1}}, Typeset`size$$ = {
    651.6875, {231., 12.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$1774$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1774$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Expand[($CellContext`\[Alpha] + $CellContext`\[Beta])^$CellContext`n$$],
       "Specifications" :> {{$CellContext`n$$, 1, 300, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{698., {163., 168.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{702, 333},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
(In printed forms of this documentation, the slider is set fairly low to \
avoid wasting paper, but when moved all the way to the right, the output \
smoothly grows to cover many pages worth of vertical space.)\
\>", "Text"],

Cell[TextData[{
 "As with ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ", if you use rational numbers for the minimum and step, you will get \
perfect rational numbers in the variable, not approximate real numbers. Here \
is an example that uses the formatting function ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " to create a simple example of adding fractions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", "\"\<+\>\"", ",", "m", ",", "\"\<=\>\"", ",", 
      RowBox[{"n", "+", "m"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "144"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "144"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`m$$ = Rational[17, 36], $CellContext`n$$ = 
    Rational[3, 8], Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 
      Rational[1, 2], 
      Rational[1, 3], 
      Rational[1, 144]}, {
      Hold[$CellContext`m$$], 
      Rational[1, 2], 
      Rational[1, 3], 
      Rational[1, 144]}}, Typeset`size$$ = {61.375, {10.5625, 16.5}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1826$$ = 0, $CellContext`m$1827$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`m$$ = Rational[1, 2], $CellContext`n$$ = 
        Rational[1, 2]}, "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1826$$, 0], 
        Hold[$CellContext`m$$, $CellContext`m$1827$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Row[{$CellContext`n$$, "+", $CellContext`m$$, 
         "=", $CellContext`n$$ + $CellContext`m$$}], 
      "Specifications" :> {{$CellContext`n$$, 
         Rational[1, 2], 
         Rational[1, 3], 
         Rational[1, 144]}, {$CellContext`m$$, 
         Rational[1, 2], 
         Rational[1, 3], 
         Rational[1, 144]}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{252., {70., 75.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{256, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
You can even use end points and step sizes that are symbolic expressions \
rather than just plain numbers.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"n", ",", "\"\<+\>\"", ",", "m", ",", "\"\<=\>\"", ",", 
      RowBox[{"n", "+", "m"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "a", ",", 
     RowBox[{"10", "a"}], ",", 
     RowBox[{"a", "/", "12"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "a", ",", 
     RowBox[{"10", "a"}], ",", 
     RowBox[{"a", "/", "12"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`m$$ = 
    Rational[11, 4] $CellContext`a, $CellContext`n$$ = 
    Rational[13, 4] $CellContext`a, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], $CellContext`a, 10 $CellContext`a, 
      Rational[1, 12] $CellContext`a}, {
      Hold[$CellContext`m$$], $CellContext`a, 10 $CellContext`a, 
      Rational[1, 12] $CellContext`a}}, Typeset`size$$ = {
    87.25, {10.5625, 16.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$1919$$ = 
    0, $CellContext`m$1920$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`m$$ = $CellContext`a, $CellContext`n$$ = \
$CellContext`a}, "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1919$$, 0], 
        Hold[$CellContext`m$$, $CellContext`m$1920$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Row[{$CellContext`n$$, "+", $CellContext`m$$, 
         "=", $CellContext`n$$ + $CellContext`m$$}], 
      "Specifications" :> {{$CellContext`n$$, $CellContext`a, 
         10 $CellContext`a, 
         Rational[1, 12] $CellContext`a}, {$CellContext`m$$, $CellContext`a, 
         10 $CellContext`a, Rational[1, 12] $CellContext`a}}, "Options" :> {},
       "DefaultOptions" :> {}],
     ImageSizeCache->{252., {70., 75.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{256, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Types of Controls", "Section"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " supports a wide range of alternate ways of specifying variables, which \
generate different kinds of controls for those variables. This includes \
checkboxes, popup menus, and others in addition to sliders. "
}], "Text"],

Cell[TextData[{
 "The principle is that for each variable, you ask for a particular set of \
possible values, and ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " automatically chooses an appropriate type of control to make those values \
conveniently available. For a typical numerical ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "-like iterator, a slider is the most convenient interface."
}], "Text"],

Cell[TextData[{
 "You might, on the other hand, want to specify a discrete list of possible \
values (numeric or symbolic) rather than a range. This is done with an \
iterator of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["variable", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["val1", "TI"], ",", 
      StyleBox["val2", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 "."
}], "Text"],

Cell["\<\
(Note the extra level of list compared to the range specification.) If you \
ask for a small number of separate values, you will get a row of buttons.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{"None", ",", "Axis", ",", "Top", ",", "Bottom"}], "}"}]}], 
    "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`filling$$ = Axis, $CellContext`n1$$ = 
    11.36, $CellContext`n2$$ = 10.16, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`filling$$], {None, Axis, Top, Bottom}}}, 
    Typeset`size$$ = {360., {113., 117.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$16022$$ = 0, $CellContext`n2$16023$$ = 
    0, $CellContext`filling$16024$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`filling$$ = None, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$16022$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$16023$$, 0], 
        Hold[$CellContext`filling$$, $CellContext`filling$16024$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Filling -> $CellContext`filling$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`filling$$, {None, Axis, Top, Bottom}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {182., 187.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 371},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "If you ask for a larger number of discrete values, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " will switch to using a popup menu."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{
      "None", ",", "Axis", ",", "Top", ",", "Bottom", ",", "Automatic", ",", 
       "1", ",", " ", "0.5", ",", " ", "0", ",", " ", 
       RowBox[{"-", "0.5"}], ",", " ", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`filling$$ = Automatic, $CellContext`n1$$ = 
    14.040000000000001`, $CellContext`n2$$ = 9.1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`filling$$], {
      None, Axis, Top, Bottom, Automatic, 1, 0.5, 0, -0.5, -1}}}, 
    Typeset`size$$ = {360., {113., 117.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$16649$$ = 0, $CellContext`n2$16650$$ = 
    0, $CellContext`filling$16651$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`filling$$ = None, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$16649$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$16650$$, 0], 
        Hold[$CellContext`filling$$, $CellContext`filling$16651$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Filling -> $CellContext`filling$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`filling$$, {
         None, Axis, Top, Bottom, Automatic, 1, 0.5, 0, -0.5, -1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {181., 186.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 369},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "If you use the specific values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", you will get a ",
 "checkbox",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "frame"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"frame", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`frame$$ = True, $CellContext`n1$$ = 
    20., $CellContext`n2$$ = 10.82, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`frame$$], {True, False}}}, Typeset`size$$ = {
    360., {115., 120.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$17000$$ = 
    0, $CellContext`n2$17001$$ = 0, $CellContext`frame$17002$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`frame$$ = True, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$17000$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$17001$$, 0], 
        Hold[$CellContext`frame$$, $CellContext`frame$17002$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Frame -> $CellContext`frame$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`frame$$, {True, False}}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {182., 187.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 371},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "These choices are of course somewhat arbitrary, but they are designed to be \
convenient, and you can always override the automatic choice of control type \
using a ",
 Cell[BoxData[
  ButtonBox["ControlType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
 " option inserted into the variable specification. (The full list of \
possible control types is given in the documentation for ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ".)"
}], "Text"],

Cell[TextData[{
 "For example, you can ask for a row of buttons even if the automatic \
behavior would have chosen a popup menu, using the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlType"], "->", 
   ButtonBox["SetterBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetterBar"]}]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{
      "None", ",", "Axis", ",", "Top", ",", "Bottom", ",", "Automatic", ",", 
       "2", ",", " ", "1", ",", " ", "0", ",", " ", 
       RowBox[{"-", "1"}], ",", " ", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "SetterBar"}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`filling$$ = Axis, $CellContext`n1$$ = 
    1, $CellContext`n2$$ = 12.200000000000001`, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`filling$$], {
      None, Axis, Top, Bottom, Automatic, 2, 1, 0, -1, -2}}}, 
    Typeset`size$$ = {360., {113., 117.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$17352$$ = 0, $CellContext`n2$17353$$ = 
    0, $CellContext`filling$17354$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`filling$$ = None, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$17352$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$17353$$, 0], 
        Hold[$CellContext`filling$$, $CellContext`filling$17354$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Filling -> $CellContext`filling$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`filling$$, {
         None, Axis, Top, Bottom, Automatic, 2, 1, 0, -1, -2}, ControlType -> 
         SetterBar}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {182., 187.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 371},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Sliders can be used to scan through discrete symbolic values, not just \
through numerical ranges (and this allows you to animate through them as \
well). The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlType"], "->", 
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"]}]], "InlineFormula"],
 " asks for the default control used by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", which is a slider plus an optional control panel with numerical value and \
animation controls (see the previous example). ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlType"], "->", 
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"]}]], "InlineFormula"],
 " asks for a plain slider."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{
      "None", ",", "Axis", ",", "Top", ",", "Bottom", ",", "Automatic", ",", 
       "1", ",", " ", "0.5", ",", " ", "0", ",", " ", 
       RowBox[{"-", "0.5"}], ",", " ", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "Manipulator"}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`filling$$ = Bottom, $CellContext`n1$$ = 
    7.8, $CellContext`n2$$ = 8.46, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`filling$$], {
      None, Axis, Top, Bottom, Automatic, 1, 0.5, 0, -0.5, -1}}}, 
    Typeset`size$$ = {360., {113., 117.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$17590$$ = 0, $CellContext`n2$17591$$ = 
    0, $CellContext`filling$17592$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`filling$$ = None, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$17590$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$17591$$, 0], 
        Hold[$CellContext`filling$$, $CellContext`filling$17592$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Filling -> $CellContext`filling$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`filling$$, {
         None, Axis, Top, Bottom, Automatic, 1, 0.5, 0, -0.5, -1}, 
         ControlType -> Manipulator}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {184., 189.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 375},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "It is even possible to use two different controls to adjust the value of \
the same variable. Here both a popup menu and a slider are connected to the \
value of the ",
 Cell[BoxData["filling"], "InlineFormula"],
 " variable. If the slider is used to select a value that ",
 "does not",
 " appear in the popup menu, the popup will appear blank, but remains \
functional. When a value is chosen from the popup menu, the slider is moved \
to the corresponding position. Both controls can thus be used interchangeably \
to adjust the same value, and each one follows along when the other is being \
used."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{
      "None", ",", "2", ",", "1.5", ",", "1", ",", "0.5", ",", "0", ",", 
       RowBox[{"-", "0.5"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1.5"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`filling$$ = 0, $CellContext`n1$$ = 
    1, $CellContext`n2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`filling$$], {
      None, 2, 1.5, 1, 0.5, 0, -0.5, -1, -1.5, -2}}, {
      Hold[$CellContext`filling$$], -2, 2}}, Typeset`size$$ = {
    360., {113., 117.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$18413$$ = 
    0, $CellContext`n2$18414$$ = 0, $CellContext`filling$18415$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`filling$$ = -2, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$18413$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$18414$$, 0], 
        Hold[$CellContext`filling$$, $CellContext`filling$18415$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Filling -> $CellContext`filling$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`filling$$, {
         None, 2, 1.5, 1, 0.5, 
          0, -0.5, -1, -1.5, -2}}, {$CellContext`filling$$, -2, 2}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {195., 200.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 397},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This is not an exhaustive list of the possible controls types in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". See the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " ",
 ButtonBox["documentation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Manipulate"],
 " for a more detailed listing. One of the most important controls types, ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ", which allows you to place control points inside graphical output in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", is discussed later in its own section, as is ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initial Values and Labels", "Section"],

Cell["Here is a fun example for making Lissajous figures.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p2", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 0, $CellContext`a2$$ = 
    0, $CellContext`n1$$ = 1, $CellContext`n2$$ = 1, $CellContext`p1$$ = 
    0, $CellContext`p2$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 4}, {
      Hold[$CellContext`a1$$], 0, 1}, {
      Hold[$CellContext`p1$$], 0, 2 Pi}, {
      Hold[$CellContext`n2$$], 1, 4}, {
      Hold[$CellContext`a2$$], 0, 1}, {
      Hold[$CellContext`p2$$], 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$3382$$ = 
    0, $CellContext`a1$3383$$ = 0, $CellContext`p1$3384$$ = 
    0, $CellContext`n2$3385$$ = 0, $CellContext`a2$3386$$ = 
    0, $CellContext`p2$3387$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 0, $CellContext`a2$$ = 
        0, $CellContext`n1$$ = 1, $CellContext`n2$$ = 1, $CellContext`p1$$ = 
        0, $CellContext`p2$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$3382$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$3383$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$3384$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$3385$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$3386$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$3387$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{$CellContext`n1$$, 1, 4}, {$CellContext`a1$$, 0, 
         1}, {$CellContext`p1$$, 0, 2 Pi}, {$CellContext`n2$$, 1, 
         4}, {$CellContext`a2$$, 0, 1}, {$CellContext`p2$$, 0, 2 Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {288., 293.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 583},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Unfortunately you see nothing at first: until you move the ",
 Cell[BoxData["a1"], "InlineFormula"],
 " and ",
 Cell[BoxData["a2"], "InlineFormula"],
 " (amplitude) variables away from their initial values of zero, there is \
nothing to see. It would be convenient to set their initial value to \
something other than the default left-most value. This is done by using a \
variable specification of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["var", "TI"], ",", 
      StyleBox["init", "TI"]}], "}"}], ",", 
    StyleBox["min", "TI"], ",", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Text"],

Cell["\<\
Here is the same example with both amplitudes set to one initially, and the \
default frequency values set to give a pleasing initial figure.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}]}], "}"}], ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p2", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 4}, {{
       Hold[$CellContext`a1$$], 1}, 0, 1}, {
      Hold[$CellContext`p1$$], 0, 2 Pi}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4]}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1}, 0, 1}, {
      Hold[$CellContext`p2$$], 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$3459$$ = 
    0, $CellContext`a1$3460$$ = 0, $CellContext`p1$3461$$ = 
    0, $CellContext`n2$3462$$ = 0, $CellContext`a2$3463$$ = 
    0, $CellContext`p2$3464$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$3459$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$3460$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$3461$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$3462$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$3463$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$3464$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{$CellContext`n1$$, 1, 4}, {{$CellContext`a1$$, 1},
          0, 1}, {$CellContext`p1$$, 0, 2 Pi}, {{$CellContext`n2$$, 
          Rational[5, 4]}, 1, 4}, {{$CellContext`a2$$, 1}, 0, 
         1}, {$CellContext`p2$$, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {288., 293.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 583},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "It is fun to watch how one shape turns into another, and in this connection \
it is good to know about an unusual feature of sliders in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you hold down the ",
 StyleBox["Option", "KeyEvent"],
 " key (Macintosh) or ",
 StyleBox["Alt", "KeyEvent"],
 " key (Windows), the action of the slider will be slowed down by a factor of \
20 relative to the movements of the mouse. In other words, when you drag the \
mouse left and right, the thumb will move only 1/20",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " as much as it normally would. If you move outside the area of the slider, \
the value will start moving slowly in that direction as long as the mouse \
remains clicked."
}], "Text"],

Cell[TextData[{
 "By holding down the ",
 StyleBox["Shift", "KeyEvent"],
 " or ",
 StyleBox["Control", "KeyEvent"],
 " keys, or both, in addition to the ",
 StyleBox["Option", "KeyEvent"],
 "/",
 StyleBox["Alt", "KeyEvent"],
 " key, you can slow the movement down by additional factors of 20 (one for \
each additional modifier key). With all three held down, it is possible to \
move the thumb by less that one part per million of its full range, which can \
be helpful in examples like this where beautiful patterns are hidden in very \
small ranges of parameter space."
}], "Text"],

Cell[TextData[{
 "(The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PerformanceGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PerformanceGoal"], "->", "\"\<Quality\>\""}]], 
  "InlineFormula"],
 " is used in this example to ensure that ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " draws smooth curves even when a slider is being moved: the need for this \
option is explained in more detail in  \"",
 ButtonBox["Advanced Manipulate Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedManipulateFunctionality"],
 "\".)"
}], "Text"],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " uses the names of the variables to label each control. But you may want to \
provide longer, more descriptive labels, which can be done by using variable \
specifications of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["var", "TI"], ",", 
      StyleBox["init", "TI"], ",", 
      StyleBox["label", "TI"]}], "}"}], ",", 
    StyleBox["min", "TI"], ",", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Text"],

Cell["Here is the same example with labels.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency 1\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude 1\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase 1\>\""}], "}"}], ",", "0", ",", 
     
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency 2\>\""}], "}"}], ",", "1",
      ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude 2\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase 2\>\""}], "}"}], ",", "0", ",", 
     
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n1$$], 1, "Frequency 1"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude 1"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase 1"}, 0, 2 Pi}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency 2"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude 2"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase 2"}, 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$3538$$ = 
    0, $CellContext`a1$3539$$ = 0, $CellContext`p1$3540$$ = 
    0, $CellContext`n2$3541$$ = 0, $CellContext`a2$3542$$ = 
    0, $CellContext`p2$3543$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$3538$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$3539$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$3540$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$3541$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$3542$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$3543$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{{$CellContext`n1$$, 1, "Frequency 1"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude 1"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase 1"}, 0, 2 
         Pi}, {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency 2"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude 2"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase 2"}, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {288., 293.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 583},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beautifying the Control Area", "Section"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " supports a number of features that allow you to rearrange, annotate, and \
generally pretty up the control area, to make it suit the needs of a \
particular example. (Advanced users should remember, however, that ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is by no means the only way to create interactive interfaces in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and if you cannot do what you want using ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", you can easily start using functions such as ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " directly to create free-form, open-ended user interfaces not tied to the \
particular conventions of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". These features are explained in detail in ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " and ",
 ButtonBox["Advanced Dynamic Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 ".)"
}], "Text"],

Cell[TextData[{
 "When you have a small number of controls, it is usually most convenient to \
have them above the content area of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " panel. But because screens are typically wider than they are tall, if you \
have a large number of controls, you may find it better to put them on the \
left side, using the ",
 Cell[BoxData[
  ButtonBox["ControlPlacement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlPlacement"]], "InlineFormula"],
 " option",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency 1\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude 1\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase 1\>\""}], "}"}], ",", "0", ",", 
     
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency 2\>\""}], "}"}], ",", "1",
      ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude 2\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase 2\>\""}], "}"}], ",", "0", ",", 
     
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n1$$], 1, "Frequency 1"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude 1"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase 1"}, 0, 2 Pi}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency 2"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude 2"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase 2"}, 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$3633$$ = 
    0, $CellContext`a1$3634$$ = 0, $CellContext`p1$3635$$ = 
    0, $CellContext`n2$3636$$ = 0, $CellContext`a2$3637$$ = 
    0, $CellContext`p2$3638$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$3633$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$3634$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$3635$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$3636$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$3637$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$3638$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{{$CellContext`n1$$, 1, "Frequency 1"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude 1"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase 1"}, 0, 2 
         Pi}, {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency 2"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude 2"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase 2"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{684., {204., 209.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{688, 415},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["ControlPlacement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlPlacement"]], "InlineFormula"],
 " is used at the level of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " as a whole, it sets the default position of all the controls. But the \
option can also be used inside individual variable specifications, allowing \
you to distribute controls to multiple sides of the output field."
}], "Text"],

Cell[TextData[{
 "In the following example the controls naturally fall into two groups of \
three, or three groups of two. You can use the keyword ",
 Cell[BoxData[
  ButtonBox["Delimiter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Delimiter"]], "InlineFormula"],
 " inserted in the sequence of variable specifications to indicate where you \
would like dividing lines put. Here two unlabeled delimiters break the \
controls up into three groups."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency 1\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency 2\>\""}], "}"}], ",", "1",
      ",", "4"}], "}"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude 1\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude 2\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase 1\>\""}], "}"}], ",", "0", ",", 
     
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase 2\>\""}], "}"}], ",", "0", ",", 
     
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n1$$], 1, "Frequency 1"}, 1, 4}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency 2"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude 1"}, 0, 1}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude 2"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase 1"}, 0, 2 Pi}, {{
       Hold[$CellContext`p2$$], 0, "Phase 2"}, 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$3712$$ = 
    0, $CellContext`n2$3713$$ = 0, $CellContext`a1$3714$$ = 
    0, $CellContext`a2$3715$$ = 0, $CellContext`p1$3716$$ = 
    0, $CellContext`p2$3717$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$3712$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$3713$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$3714$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$3715$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$3716$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$3717$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{{$CellContext`n1$$, 1, "Frequency 1"}, 1, 
         4}, {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency 2"}, 1, 4}, 
        Delimiter, {{$CellContext`a1$$, 1, "Amplitude 1"}, 0, 
         1}, {{$CellContext`a2$$, 1, "Amplitude 2"}, 0, 1}, 
        Delimiter, {{$CellContext`p1$$, 0, "Phase 1"}, 0, 2 
         Pi}, {{$CellContext`p2$$, 0, "Phase 2"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{684., {204., 209.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{688, 415},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Alternately strings, or delimiters and strings, can be used to label the \
groups of controls.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", "\"\<Horizontal\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", "Delimiter", 
   ",", "\"\<Vertical\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold["Horizontal"], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n1$$], 1, "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase"}, 0, 2 Pi}, {
      Hold["Vertical"], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase"}, 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$3791$$ = 
    0, $CellContext`a1$3792$$ = 0, $CellContext`p1$3793$$ = 
    0, $CellContext`n2$3794$$ = 0, $CellContext`a2$3795$$ = 
    0, $CellContext`p2$3796$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$3791$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$3792$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$3793$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$3794$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$3795$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$3796$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {
       "Horizontal", {{$CellContext`n1$$, 1, "Frequency"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase"}, 0, 2 Pi}, Delimiter, 
        "Vertical", {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{676., {204., 209.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{680, 415},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Quite a variety of things can be interspersed with the controls, including \
styled text, arbitrary expressions, and even dynamic objects that update \
independently of the main output window. Here a simple example of using ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " makes the group headings more prominent."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Horizontal\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", "Delimiter", 
   ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Vertical\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["Horizontal", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n1$$], 1, "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase"}, 0, 2 Pi}, {
      Hold[
       Style["Vertical", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase"}, 0, 2 Pi}}, Typeset`size$$ = {
    360., {176., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$3854$$ = 
    0, $CellContext`a1$3855$$ = 0, $CellContext`p1$3856$$ = 
    0, $CellContext`n2$3857$$ = 0, $CellContext`a2$3858$$ = 
    0, $CellContext`p2$3859$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$3854$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$3855$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$3856$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$3857$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$3858$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$3859$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {
        Style[
        "Horizontal", 12, Bold], {{$CellContext`n1$$, 1, "Frequency"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase"}, 0, 2 Pi}, Delimiter, 
        Style["Vertical", 12, Bold], {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{676., {204., 209.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{680, 415},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Examples of more complex arrangements and dynamic labels are shown in \"",
 ButtonBox["Advanced Manipulate Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedManipulateFunctionality"],
 "\"."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2D Sliders", "Section"],

Cell[TextData[{
 "A clever feature of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is support for two-dimensional sliders, which allow you to use both \
directions of mouse movement to control two values simultaneously",
 ". ",
 "(Ordinary one-dimensional sliders in a sense waste one of the two degrees \
of freedom a mouse is capable of.)"
}], "Text"],

Cell[TextData[{
 "To get a 2D slider, use pairs of numbers for both the ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 ", as in ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["var", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"]
}], "Text"],

Cell[TextData[{
 "The value of the variable will also be an ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " pair. In this trivial example, just look at the value of the variable to \
get a feel for how the control works."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"pt", ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {-0.18999999999999995`, 
    0.33000000000000007`}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {},
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    88.875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$147989$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pt$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$147989$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`pt$$, 
      "Specifications" :> {{$CellContext`pt$$, {-1, -1}, {1, 1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{135., {77., 82.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{139, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
The following example shows more graphically how the value of a 2D slider \
corresponds to a coordinate point.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {-0.42999999999999994`, \
-0.19999999999999996`}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$1141$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pt$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$1141$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[0.1], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {{$CellContext`pt$$, {-1, -1}, {1, 1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {251., 256.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 509},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
To do something more interesting, you can recast the Lissajous figure from \
the previous section with three 2D sliders instead of six 1D sliders. You are \
controlling the same six parameters, but now you can do it two at a time.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", "1", "]"}], "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"n", "[", 
           RowBox[{"[", "1", "]"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", 
            RowBox[{"p", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", "2", "]"}], "]"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"n", "[", 
           RowBox[{"[", "2", "]"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", 
            RowBox[{"p", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"5", "/", "4"}]}], "}"}], ",", "\"\<Frequency\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "\"\<Amplitude\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\"\<Phase\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = {1, 1}, $CellContext`n$$ = {1, 
     Rational[5, 4]}, $CellContext`p$$ = {0, 0}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], {1, 
        Rational[5, 4]}, "Frequency"}, {1, 1}, {4, 4}}, {{
       Hold[$CellContext`a$$], {1, 1}, "Amplitude"}, {0, 0}, {1, 1}}, {{
       Hold[$CellContext`p$$], {0, 0}, "Phase"}, {0, 0}, {2 Pi, 2 Pi}}}, 
    Typeset`size$$ = {360., {176., 180.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$3946$$ = {0, 0}, $CellContext`a$3947$$ = {0, 
    0}, $CellContext`p$3948$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = {1, 1}, $CellContext`n$$ = {1, 
          Rational[5, 4]}, $CellContext`p$$ = {0, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$3946$$, {0, 0}], 
        Hold[$CellContext`a$$, $CellContext`a$3947$$, {0, 0}], 
        Hold[$CellContext`p$$, $CellContext`p$3948$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{
        Part[$CellContext`a$$, 1] 
         Sin[Part[$CellContext`n$$, 1] ($CellContext`x + 
            Part[$CellContext`p$$, 1])], Part[$CellContext`a$$, 2] 
         Cos[Part[$CellContext`n$$, 2] ($CellContext`x + 
            Part[$CellContext`p$$, 2])]}, {$CellContext`x, 0, 20 Pi}, 
        PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {{{$CellContext`n$$, {1, 
           Rational[5, 4]}, "Frequency"}, {1, 1}, {4, 
         4}}, {{$CellContext`a$$, {1, 1}, "Amplitude"}, {0, 0}, {1, 
         1}}, {{$CellContext`p$$, {0, 0}, "Phase"}, {0, 0}, {2 Pi, 2 Pi}}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{545., {204., 209.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{549, 415},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This creates an example that is compact and fun. Note that fine control \
using the ",
 StyleBox["Option", "KeyEvent"],
 ", ",
 StyleBox["Shift", "KeyEvent"],
 ", and ",
 StyleBox["Control", "KeyEvent"],
 " keys to slow down the motion of sliders (as explained earlier) works for \
2D sliders as well as 1D sliders."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics beyond Plotting", "Section"],

Cell[TextData[{
 "So far we have mostly used high-level plotting functions, but it is equally \
interesting to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s low level graphics language inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". The following example, repeated from the previous section, is a trivial \
example of using the low-level graphics language."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {0.14000000000000012`, 
    0.32000000000000006`}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {},
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$2061$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pt$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$2061$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[0.1], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {{$CellContext`pt$$, {-1, -1}, {1, 1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {251., 256.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 509},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This example also makes the important point that anytime you use ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", you probably want to set an explicit ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " option. (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", "1"}]], "InlineFormula"],
 " means one in all directions from the origin, and  is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]], "InlineFormula"],
 ".) If you omit the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " option ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s automatic plot range determination will cause the dot to appear not to \
move at all, because the plot range is always exactly centered around it."
}], "Text"],

Cell[TextData[{
 "Simple (or complicated) ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming can add arbitrary graphical elements to the output. For \
example, here we have lines to the center point instead of a dot, with a \
second linear slider determining the number of lines."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Line", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "t", "]"}], ",", 
             RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", "pt"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"2.", 
            RowBox[{"Pi", "/", "n"}]}], ",", 
           RowBox[{"2.", "Pi"}], ",", 
           RowBox[{"2.", 
            RowBox[{"Pi", "/", "n"}]}]}], "}"}]}], "]"}], "]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "30"}], "}"}], ",", "1", ",", "200", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 108, $CellContext`pt$$ = {0.49, 
    0.4099999999999999}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 30}, 1, 200, 1}, {
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$3913$$ = 
    0, $CellContext`pt$3914$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 30, $CellContext`pt$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$3913$$, 0], 
        Hold[$CellContext`pt$$, $CellContext`pt$3914$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Line[
          Table[{{
             Cos[$CellContext`t], 
             Sin[$CellContext`t]}, $CellContext`pt$$}, {$CellContext`t, 
            2. (Pi/$CellContext`n$$), 2. Pi, 2. (Pi/$CellContext`n$$)}]]}, 
        PlotRange -> 1], 
      "Specifications" :> {{{$CellContext`n$$, 30}, 1, 200, 
         1}, {$CellContext`pt$$, {-1, -1}, {1, 1}}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {265., 270.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 537},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Here is a fun little string-figure example also based on creating a table of \
lines.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"n", "+", "i"}], "]"}], ",", 
            RowBox[{"Cos", "[", 
             RowBox[{"n", "+", "i"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"n", "+", "dn", "+", "i"}], "]"}], ",", 
            RowBox[{"Cos", "[", 
             RowBox[{"n", "+", "dn", "+", "i"}], "]"}]}], "}"}]}], "}"}], ",",
         
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "di", ",", 
          RowBox[{"di", "/", "l"}]}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1.1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"dn", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"di", ",", "1", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"l", ",", "1", ",", "200"}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`di$$ = 
    3.990282883863646, $CellContext`dn$$ = 
    4.0212385965949355`, $CellContext`l$$ = 130.8, $CellContext`n$$ = 
    1.2566370614359172`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 0, 2 Pi}, {
      Hold[$CellContext`dn$$], 0, 2 Pi}, {
      Hold[$CellContext`di$$], 1, 2 Pi}, {
      Hold[$CellContext`l$$], 1, 200}}, Typeset`size$$ = {360., {178., 182.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$757$$ = 0, $CellContext`dn$758$$ = 
    0, $CellContext`di$759$$ = 0, $CellContext`l$760$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`di$$ = 1, $CellContext`dn$$ = 
        0, $CellContext`l$$ = 1, $CellContext`n$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$757$$, 0], 
        Hold[$CellContext`dn$$, $CellContext`dn$758$$, 0], 
        Hold[$CellContext`di$$, $CellContext`di$759$$, 0], 
        Hold[$CellContext`l$$, $CellContext`l$760$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Line[
         Table[{{
            Sin[$CellContext`n$$ + $CellContext`i], 
            Cos[$CellContext`n$$ + $CellContext`i]}, {
            Sin[$CellContext`n$$ + $CellContext`dn$$ + $CellContext`i], 
            
            Cos[$CellContext`n$$ + $CellContext`dn$$ + $CellContext`i]}}, \
{$CellContext`i, 0, $CellContext`di$$, $CellContext`di$$/$CellContext`l$$}]], 
        PlotRange -> 1.1], 
      "Specifications" :> {{$CellContext`n$$, 0, 2 Pi}, {$CellContext`dn$$, 0,
          2 Pi}, {$CellContext`di$$, 1, 2 Pi}, {$CellContext`l$$, 1, 200}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{639., {206., 211.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{643, 419},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a sophisticated programming language, it is possible to use ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to explore parameterized programs or algorithms interactively. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics language is explained in ",
 ButtonBox["The Structure of Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheStructureOfGraphics"],
 ", and many more examples like this can be found in ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Locator", "Section"],

Cell[TextData[{
 "For creating interactive graphics examples, one of the most important \
features of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is the ability to place a control point, called a ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ", inside graphics that appear in the output area. "
}], "Text"],

Cell[TextData[{
 "Consider the previous example with lines going to a center point. While \
using a 2D slider is a fine way to control the center point, you might prefer \
to be able to simply click and drag the center point itself. This can be done \
by adding ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " to the control specification for the ",
 Cell[BoxData[
  StyleBox["pt", "TI"]], "InlineFormula"],
 " variable. In this case it is not necessary to specify a ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " range, because it can be taken automatically from the graphic. (It is, \
however, necessary to specify an initial value.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Line", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "t", "]"}], ",", 
             RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", "pt"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"2.", 
            RowBox[{"Pi", "/", "n"}]}], ",", 
           RowBox[{"2.", "Pi"}], ",", 
           RowBox[{"2.", 
            RowBox[{"Pi", "/", "n"}]}]}], "}"}]}], "]"}], "]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "30"}], "}"}], ",", "1", ",", "200", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 30, $CellContext`pt$$ = {0.482, 
    0.4650000000000001}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 30}, 1, 200, 1}, {{
       Hold[$CellContext`pt$$], {0, 0}}, Automatic}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$4177$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 30, $CellContext`pt$$ = {0, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$4177$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Line[
          Table[{{
             Cos[$CellContext`t], 
             Sin[$CellContext`t]}, $CellContext`pt$$}, {$CellContext`t, 
            2. (Pi/$CellContext`n$$), 2. Pi, 2. (Pi/$CellContext`n$$)}]]}, 
        PlotRange -> 1], 
      "Specifications" :> {{{$CellContext`n$$, 30}, 1, 200, 
         1}, {{$CellContext`pt$$, {0, 0}}, Automatic, ControlType -> 
         Locator}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {222., 227.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 451},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Now you can click anywhere in the graphic and the center point of the lines \
will follow the mouse as long as you keep the mouse button down. (It is not \
necessary to click exactly on the center; it will jump to wherever you click, \
anywhere in the graphic.)\
\>", "Text"],

Cell[TextData[{
 "You can have multiple ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " controls by listing them individually, and it is perfectly fine to have a \
",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " with no controls outside the content area, so you can create purely \
graphical examples."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{"pt1", ",", "pt2", ",", "pt3"}], "}"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt1", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", "Locator"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt2", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "Locator"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt3", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt1$$ = {-0.634, -0.5349999999999999}, \
$CellContext`pt2$$ = {-0.7, 0.71}, $CellContext`pt3$$ = {0.42599999999999993`,
     0.655}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`pt1$$], {0, 0}}, Automatic}, {{
       Hold[$CellContext`pt2$$], {0, 1}}, Automatic}, {{
       Hold[$CellContext`pt3$$], {1, 0}}, Automatic}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pt1$$ = {0, 0}, $CellContext`pt2$$ = {0, 
         1}, $CellContext`pt3$$ = {1, 0}}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Polygon[{$CellContext`pt1$$, $CellContext`pt2$$, $CellContext`pt3$$}],
         PlotRange -> 1], 
      "Specifications" :> {{{$CellContext`pt1$$, {0, 0}}, Automatic, 
         ControlType -> Locator}, {{$CellContext`pt2$$, {0, 1}}, Automatic, 
         ControlType -> Locator}, {{$CellContext`pt3$$, {1, 0}}, Automatic, 
         ControlType -> Locator}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {206., 211.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 419},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "When there are multiple locators, you can still click anywhere in the \
graphic, and the nearest ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " will jump to where you click and start tracking the mouse."
}], "Text"],

Cell[TextData[{
 "Instead of using multiple separate variables, each of which corresponds to \
a single ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " point,  you can use a single variable whose value is a list of points",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Polygon", "[", "pts", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", "Locator"}], 
    "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pts$$ = {{-0.6839999999999999, -0.395}, {
    0.5820000000000001, -0.43499999999999994`}, {0.3500000000000001, 
    0.6100000000000001}}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`pts$$], {{0, 0}, {1, 0}, {0, 1}}}, Automatic}}, 
    Typeset`size$$ = {360., {178., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pts$$ = {{0, 0}, {1, 0}, {0, 1}}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Polygon[$CellContext`pts$$], PlotRange -> 1], 
      "Specifications" :> {{{$CellContext`pts$$, {{0, 0}, {1, 0}, {0, 1}}}, 
         Automatic, ControlType -> Locator}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {206., 211.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 419},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Again if you click anywhere in the graphic, not on a particular ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ", the nearest one will jump to the mouse and start tracking it."
}], "Text"],

Cell[TextData[{
 "Due to internal limitations, it is not possible to combine individual ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " variables with a variable that is a list of multiple ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " vairables: you can have only one multi-point ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " variable in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". However, in exchange, it is possible to add the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorAutoCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorAutoCreate"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to that one ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " multivariable specification, and thereby allow you to create and destroy \
",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " points interactively (changing the length of the list of points stored in \
the variable)."
}], "Text"],

Cell[TextData[{
 "In the following example, hold down the ",
 StyleBox["Command", "KeyEvent"],
 " key (Macintosh) or ",
 StyleBox["Alt", "KeyEvent"],
 " key (Windows) and click anywhere that is not an existing ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " to create a new one at that location. ",
 StyleBox["Command", "KeyEvent"],
 "/",
 StyleBox["Alt", "KeyEvent"],
 " click an existing ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " to destroy it. When you add or remove a ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ", you are changing the length of the list of points stored in the ",
 Cell[BoxData[
  StyleBox["pts", "TI"]], "InlineFormula"],
 " variable, thus changing the number of vertices in the displayed polygon."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Polygon", "[", "pts", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".5", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}]}], "}"}]}], "}"}], ",", "Locator", 
     ",", 
     RowBox[{"LocatorAutoCreate", "\[Rule]", "True"}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pts$$ = {{1, 0}, {-0.18399999999999994`, 
     0.885}, {-0.6779999999999999, -0.41500000000000004`}, {
     0.254, -0.53}, {-0.69, 0.45500000000000007`}, {0.482, 
     0.9299999999999999}}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {},
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`pts$$], {{0, 0}, {1, 0}, {0, 1}}}, Automatic}}, 
    Typeset`size$$ = {360., {178., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pts$$ = {{0, 0}, {1, 0}, {0, 1}}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Polygon[$CellContext`pts$$], PlotRange -> 1], 
      "Specifications" :> {{{$CellContext`pts$$, {{0, 0}, {1, 0}, {0, 1}}}, 
         Automatic, ControlType -> Locator, LocatorAutoCreate -> True}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {206., 211.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 419},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "You can of course combine ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " controls with normal ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " variables. For example, you can use some sliders and color choosers to \
control the appearance of the polygon."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FaceForm", "[", "face", "]"}], ",", 
       RowBox[{"EdgeForm", "[", 
        RowBox[{"{", 
         RowBox[{"edge", ",", 
          RowBox[{"Thickness", "[", "thickness", "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"Polygon", "[", "pts", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"Background", "\[Rule]", "background"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"face", ",", "Green"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"edge", ",", "Red"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"background", ",", "Cyan"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"thickness", ",", "0.02"}], "}"}], ",", "0", ",", "0.1"}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".5", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}]}], "}"}]}], "}"}], ",", "Locator", 
     ",", 
     RowBox[{"LocatorAutoCreate", "\[Rule]", "True"}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`background$$ = RGBColor[
    0., 1., 1.], $CellContext`edge$$ = RGBColor[
    1, 0, 0], $CellContext`face$$ = RGBColor[
    0, 1, 0], $CellContext`pts$$ = {{-0.356, 0.5800000000000001}, {0.726, 
    0.6699999999999999}, {-0.562, 0.06499999999999995}, {-0.69, -0.56}, {
    0.738, -0.64}, {
    0.76, -0.07499999999999996}, {-0.128, -0.10999999999999999`}}, \
$CellContext`thickness$$ = 0.018000000000000002`, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`face$$], 
      RGBColor[0, 1, 0]}, {
      Hold[$CellContext`edge$$], 
      RGBColor[1, 0, 0]}, {
      Hold[$CellContext`background$$], 
      RGBColor[0, 1, 1]}, {{
       Hold[$CellContext`thickness$$], 0.02}, 0, 1}, {{
       Hold[$CellContext`pts$$], {{0, 0}, {0.5, 0}, {0, 0.5}}}, Automatic}}, 
    Typeset`size$$ = {360., {178., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`thickness$4513$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`background$$ = 
        RGBColor[0, 1, 1], $CellContext`edge$$ = 
        RGBColor[1, 0, 0], $CellContext`face$$ = 
        RGBColor[
         0, 1, 0], $CellContext`pts$$ = {{0, 0}, {0.5, 0}, {
          0, 0.5}}, $CellContext`thickness$$ = 0.02}, 
      "ControllerVariables" :> {
        Hold[$CellContext`thickness$$, $CellContext`thickness$4513$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         FaceForm[$CellContext`face$$], 
         EdgeForm[{$CellContext`edge$$, 
           Thickness[$CellContext`thickness$$]}], 
         Polygon[$CellContext`pts$$]}, PlotRange -> 1, 
        Background -> $CellContext`background$$], 
      "Specifications" :> {{$CellContext`face$$, 
         RGBColor[0, 1, 0]}, {$CellContext`edge$$, 
         RGBColor[1, 0, 0]}, {$CellContext`background$$, 
         RGBColor[0, 1, 1]}, {{$CellContext`thickness$$, 0.02}, 0, 
         1}, {{$CellContext`pts$$, {{0, 0}, {0.5, 0}, {0, 0.5}}}, Automatic, 
         ControlType -> Locator, LocatorAutoCreate -> True}}, "Options" :> {},
       "DefaultOptions" :> {}],
     ImageSizeCache->{406., {275., 280.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 557},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
While a case can be made that the examples above are frivolous, they are \
meant to demonstrate the generality of the system: it provides a framework \
inside of which anything is possible. And the following example shows that \
even just a couple of lines of code can do something quite remarkable: create \
an interactive polynomial curve-fitting environment.\
\>", "Text"],

Cell[TextData[{
 "The locator thumbs represent data points that are being fit by least \
squares with a polynomial whose order is determined by the \"order\" slider. \
Five points are provided initially, but you can add new ones by ",
 StyleBox["Command", "KeyEvent"],
 "/",
 StyleBox["Alt", "KeyEvent"],
 " clicking any blank area of the graphic, or remove one by ",
 StyleBox["Command", "KeyEvent"],
 "/",
 StyleBox["Alt", "KeyEvent"],
 " clicking it."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Fit", "[", 
        RowBox[{"points", ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"x", "^", "i"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "order"}], "}"}]}], "]"}], ",", "x"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "2"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
       RowBox[{"Evaluated", "->", "True"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"order", ",", "3"}], "}"}], ",", "1", ",", "10", ",", "1", ",", 
     
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"points", ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", "Locator", 
     ",", 
     RowBox[{"LocatorAutoCreate", "\[Rule]", "True"}]}], "}"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`order$$ = 3, $CellContext`points$$ = {{
    1.9189255230878413`, 0.8623577344274889}, {-0.5879999999999999, 
    0.9500000000000002}, {0.3699553719964488, -0.275696063879594}, {
    0.8402864512898605, 
    1.3005827190824784`}, {-1.1739688426559844`, -0.5120578907961573}}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`order$$], 3}, 1, 10, 1}, {{
       Hold[$CellContext`points$$], {{1.9189255230878413`, 
       0.8623577344274889}, {-0.8185233213368441, 1.5448086870751698`}, {
       0.3699553719964488, -0.275696063879594}, {0.8402864512898605, 
       1.3005827190824784`}, {-1.1739688426559844`, -0.5120578907961573}}}, 
      Automatic}}, Typeset`size$$ = {500., {158., 163.}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`order$17458207$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`order$$ = 
        3, $CellContext`points$$ = {{1.9189255230878413`, 
         0.8623577344274889}, {-0.8185233213368441, 1.5448086870751698`}, {
         0.3699553719964488, -0.275696063879594}, {0.8402864512898605, 
         1.3005827190824784`}, {-1.1739688426559844`, -0.5120578907961573}}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`order$$, $CellContext`order$17458207$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Module[{$CellContext`x$}, 
        Plot[
         Fit[$CellContext`points$$, 
          
          Table[$CellContext`x$^$CellContext`i, {$CellContext`i, 
            0, $CellContext`order$$}], $CellContext`x$], {$CellContext`x$, -2,
           2}, PlotRange -> 2, ImageSize -> 500, Evaluated -> True]], 
      "Specifications" :> {{{$CellContext`order$$, 3}, 1, 10, 1, Appearance -> 
         "Labeled"}, {{$CellContext`points$$, {{1.9189255230878413`, 
          0.8623577344274889}, {-0.8185233213368441, 1.5448086870751698`}, {
          0.3699553719964488, -0.275696063879594}, {0.8402864512898605, 
          1.3005827190824784`}, {-1.1739688426559844`, -0.5120578907961573}}},
          Automatic, ControlType -> Locator, LocatorAutoCreate -> True}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{546., {202., 207.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{550, 411},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "The fact that an example of this sophistication can be constructed using \
such a small volume of code is really quite remarkable. And if you want to \
really impress someone with the compactness of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, the following example shows how to do it only two lines, with some \
loss of generality. Practice a bit and you can type this from scratch in 30 \
seconds or less."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"InterpolatingPolynomial", "[", 
      RowBox[{"points", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"points", ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", "Locator"}], 
    "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`points$$ = {{-1.8713713263956322`, 
    0.44425243750689436`}, {1.71, 0.27}, {-0.24, 1.37}, {0.9100000000000001, 
    0.3599999999999999}, {-0.81, 0.08999999999999986}}, Typeset`show$$ = True,
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`points$$], {{-1.8713713263956322`, 
       0.44425243750689436`}, {-1.713695426336396, 
       1.090719506481311}, {-1.2651467450152367`, 0.44080090702486086`}, {
       0.7437269843776875, 
       0.8349000615224975}, {-0.915623336058359, -1.1689140098744906`}}}, 
      Automatic}}, Typeset`size$$ = {360., {115., 120.}}, Typeset`update$$ = 
    0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`points$$ = {{-1.8713713263956322`, 
         0.44425243750689436`}, {-1.713695426336396, 
         1.090719506481311}, {-1.2651467450152367`, 0.44080090702486086`}, {
         0.7437269843776875, 
         0.8349000615224975}, {-0.915623336058359, -1.1689140098744906`}}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        InterpolatingPolynomial[$CellContext`points$$, $CellContext`x], \
{$CellContext`x, -2, 2}, PlotRange -> 2], 
      "Specifications" :> {{{$CellContext`points$$, {{-1.8713713263956322`, 
          0.44425243750689436`}, {-1.713695426336396, 
          1.090719506481311}, {-1.2651467450152367`, 0.44080090702486086`}, {
          0.7437269843776875, 
          0.8349000615224975}, {-0.915623336058359, -1.1689140098744906`}}}, 
         Automatic, ControlType -> Locator}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {143., 148.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 293},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3D Graphics", "Section"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " can be used to explore 3D graphics just as easily as 2D, though \
performance issues become more of a concern. Consider this simple example",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 2.27, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 5}}, Typeset`size$$ = {360., {144., 148.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$5744$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$5744$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[($CellContext`n$$ $CellContext`x) $CellContext`y], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}], 
      "Specifications" :> {{$CellContext`n$$, 1, 5}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {188., 193.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 383},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "For large values of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " the function oscillates rapidly, and in order to produce a smooth picture, \
the default adaptive sampling algorithm in ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " produces a fairly large number of polygons, with correspondingly long \
computation and rendering times."
}], "Text"],

Cell[TextData[{
 "Fortunately, ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " and other built-in plotting functions automatically adjust their internal \
algorithms and settings when used inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to deliver increased speed while a control is being dragged, sometimes at \
the expense of rendering quality. As soon as the mouse button is released, a \
high-quality version of the plot is generated asynchronously (meaning other \
operations in the front end can continue while the plot is being generated). \
Asynchronous evaluations are discussed in further detail in \"",
 ButtonBox["Synchronous Versus Asynchronous Dynamic Evaluations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality#681967067"],
 "\" in \"",
 ButtonBox["Advanced Dynamic Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 "\"."
}], "Text"],

Cell[TextData[{
 "The net result is that while you drag the slider, a fast, but somewhat \
crude, rendering of the plot is created in real time, and when you release \
the control, a smooth rendering shows up a moment later. (This happens \
because ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ", and most other plotting functions, refer to the function ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " in the default settings of the various options that control rendering \
quality and speed. See \"",
 ButtonBox["Dealing with Slow Evaluations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedManipulateFunctionality#1234"],
 "\" in \"",
 ButtonBox["Advanced Manipulate Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedManipulateFunctionality"],
 "\" for more about using ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " within ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ".)"
}], "Text"],

Cell[TextData[{
 "As in 2D, you can use the low-level graphics language just as easily as \
higher-level plotting commands. In this example you can see how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles spheres that intersect with each other and with the bounding box."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sphere", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "r1"}], "]"}], ",", 
       RowBox[{"Sphere", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"c", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"c", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", "r2"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r1", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r2", ",", "1"}], "}"}], ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c$$ = {0.8000000000000003, 
    0.14000000000000012`}, $CellContext`r1$$ = 1, $CellContext`r2$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r1$$], 1}, 0, 2}, {{
       Hold[$CellContext`r2$$], 1}, 0, 2}, {
      Hold[$CellContext`c$$], {-2, -2}, {2, 2}}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`r1$684$$ = 
    0, $CellContext`r2$685$$ = 0, $CellContext`c$686$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c$$ = {-2, -2}, $CellContext`r1$$ = 
        1, $CellContext`r2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`r1$$, $CellContext`r1$684$$, 0], 
        Hold[$CellContext`r2$$, $CellContext`r2$685$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$686$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         Sphere[{0, 0, 0}, $CellContext`r1$$], 
         Sphere[{
           Part[$CellContext`c$$, 1], 
           Part[$CellContext`c$$, 2], 0}, $CellContext`r2$$]}, PlotRange -> 
        2], "Specifications" :> {{{$CellContext`r1$$, 1}, 0, 
         2}, {{$CellContext`r2$$, 1}, 0, 2}, {$CellContext`c$$, {-2, -2}, {2, 
         2}}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {293., 298.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 593},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
This example shows how opacity (which is to say, transparency) can be used to \
see inside nested 3D structures.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"SphericalPlot3D", "[", " ", 
     RowBox[{
      RowBox[{"\[Theta]", "+", " ", "\[Phi]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", 
        RowBox[{"a", " ", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", "0", ",", 
        RowBox[{"b", " ", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "10"}], ",", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"Opacity", "[", "opacity", "]"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "0.1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "0.1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"opacity", ",", "1", ",", "0"}], "}"}]}], "]"}], "\n"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 
    1.6720000000000002`, $CellContext`b$$ = 1.858, $CellContext`opacity$$ = 
    1., Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0.1, 2}, {
      Hold[$CellContext`b$$], 0.1, 2}, {
      Hold[$CellContext`opacity$$], 1, 0}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`a$19598$$ = 
    0, $CellContext`b$19599$$ = 0, $CellContext`opacity$19600$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.1, $CellContext`b$$ = 
        0.1, $CellContext`opacity$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$19598$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$19599$$, 0], 
        Hold[$CellContext`opacity$$, $CellContext`opacity$19600$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      SphericalPlot3D[$CellContext`\[Theta] + $CellContext`\[Phi], \
{$CellContext`\[Theta], 0, $CellContext`a$$ Pi}, {$CellContext`\[Phi], 
         0, $CellContext`b$$ Pi}, SphericalRegion -> True, PlotRange -> 10, 
        Ticks -> None, PerformanceGoal -> "Quality", BaseStyle -> 
        Opacity[$CellContext`opacity$$]], 
      "Specifications" :> {{$CellContext`a$$, 0.1, 2}, {$CellContext`b$$, 0.1,
          2}, {$CellContext`opacity$$, 1, 0}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {249., 254.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 505},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
(Note that adding transparency to a 3D graphic can slow down rendering \
significantly.)\
\>", "Text"],

Cell[TextData[{
 "You can rotate a 3D graphics inside a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output by clicking and dragging it in the ordinary way. In most cases if \
you subsequently move one of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " controls, the graphic will stay rotated to the position you moved it to \
manually, unless the graphics expression in the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " contains an explicit ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " option, or wraps the graphical output in additional formatting \
constructs."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["All Types of Output Are Supported", "Section"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is designed to work with the full range of possible types of output you \
can get with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and it does not stop with graphical and algebraic output. ",
 StyleBox["Any",
  FontSlant->"Italic"],
 " kind of output supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be used inside ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". ",
 "Here are some examples which may be less than obvious."
}], "Text"],

Cell[TextData[{
 "Formatting constructs such as ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 ", ",
 "etc.",
 " can be used to produce nicely formatted outputs. (See ",
 ButtonBox["Grids, Rows, and Columns",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 " for more information about formatting constructs.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"i", "^", "m"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
     RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "1", ",", "100", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`m$$ = 34, $CellContext`n$$ = 7, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20, 1}, {
      Hold[$CellContext`m$$], 1, 100, 1}}, Typeset`size$$ = {
    249., {53.5, 58.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$214125$$ = 
    0, $CellContext`m$214126$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`m$$ = 1, $CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$214125$$, 0], 
        Hold[$CellContext`m$$, $CellContext`m$214126$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Grid[
        Table[{$CellContext`i, $CellContext`i^$CellContext`m$$}, \
{$CellContext`i, 1, $CellContext`n$$}], Alignment -> Left, Frame -> All], 
      "Specifications" :> {{$CellContext`n$$, 1, 20, 1}, {$CellContext`m$$, 1,
          100, 1}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{295., {112., 117.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{299, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "You can even wrap ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " around functions that generate user interface elements like sliders and \
tab views. (See ",
 ButtonBox["Control Objects",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlObjects"],
 " and ",
 ButtonBox["Viewers and Annotation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ViewersAndAnnotation"],
 " for more information about user interface elements.)  In this example we \
use two sliders to control the appearance of a third slider."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"style", ",", "size"}], "}"}], ",", 
      RowBox[{"Slider", "[", 
       RowBox[{"0.5", ",", 
        RowBox[{"Appearance", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"style", ",", "size"}], "}"}]}]}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"style", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Automatic\>\"", ",", "\"\<Vertical\>\"", ",", "\"\<LeftArrow\>\"", 
       ",", "\"\<RightArrow\>\"", ",", "\"\<UpArrow\>\"", ",", 
       "\"\<DownArrow\>\""}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "Slider"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"size", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Automatic\>\"", ",", "\"\<Tiny\>\"", ",", " ", "\"\<Small\>\"", 
       ",", " ", "\"\<Medium\>\"", ",", " ", "\"\<Large\>\""}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "Slider"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`size$$ = "Tiny", $CellContext`style$$ = 
    "UpArrow", Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`style$$], {
      "Automatic", "Vertical", "LeftArrow", "RightArrow", "UpArrow", 
       "DownArrow"}}, {
      Hold[$CellContext`size$$], {
      "Automatic", "Tiny", "Small", "Medium", "Large"}}}, Typeset`size$$ = {
    200., {12.5, 17.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`style$147947$$ = 
    0, $CellContext`size$147948$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`size$$ = "Automatic", $CellContext`style$$ = 
        "Automatic"}, "ControllerVariables" :> {
        Hold[$CellContext`style$$, $CellContext`style$147947$$, 0], 
        Hold[$CellContext`size$$, $CellContext`size$147948$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Column[{{$CellContext`style$$, $CellContext`size$$}, 
         Slider[
         0.5, Appearance -> {$CellContext`style$$, $CellContext`size$$}]}], 
      "Specifications" :> {{$CellContext`style$$, {
         "Automatic", "Vertical", "LeftArrow", "RightArrow", "UpArrow", 
          "DownArrow"}, ControlType -> Slider}, {$CellContext`size$$, {
         "Automatic", "Tiny", "Small", "Medium", "Large"}, ControlType -> 
         Slider}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{253., {71., 76.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{257, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "In this more complicated example the structure of a ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " is controlled by a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["pane", "TI"], "]"}]], "InlineFormula"],
 " allows the current pane of the ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " to be selected either by using the slider created by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", or by clicking the ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " in the output area. The output is fully active."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Nest", "[", 
        RowBox[{
         RowBox[{
          FractionBox["1", 
           RowBox[{"1", "-", "#"}]], "&"}], ",", "base", ",", "i"}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "pane", "]"}], ",", 
     RowBox[{"Alignment", "\[Rule]", "alignment"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"alignment", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"pane", ",", "1", ",", "n", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`alignment$$ = {0., 
    0.41999999999999993`}, $CellContext`n$$ = 9, $CellContext`pane$$ = 5, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 20, 1}, {
      Hold[$CellContext`alignment$$], {-1, -1}, {1, 1}}, {
      Hold[$CellContext`pane$$], 1, 
      Dynamic[$CellContext`n$$], 1}}, Typeset`size$$ = {195., {65.5, 70.5}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$6403$$ = 0, $CellContext`alignment$6404$$ = {0, 
    0}, $CellContext`pane$6405$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`alignment$$ = {-1, -1}, $CellContext`n$$ = 
        1, $CellContext`pane$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$6403$$, 0], 
        Hold[$CellContext`alignment$$, $CellContext`alignment$6404$$, {0, 0}],
         
        Hold[$CellContext`pane$$, $CellContext`pane$6405$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> TabView[
        Table[
         Nest[
         1/(1 - #)& , $CellContext`base, $CellContext`i], {$CellContext`i, 
          1, $CellContext`n$$}], 
        Dynamic[$CellContext`pane$$], Alignment -> $CellContext`alignment$$], 
      "Specifications" :> {{$CellContext`n$$, 1, 20, 
         1}, {$CellContext`alignment$$, {-1, -1}, {1, 
         1}}, {$CellContext`pane$$, 1, 
         Dynamic[$CellContext`n$$], 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{287., {166., 171.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{291, 339},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This example may be somewhat alarming, but is meant only to illustrate that \
",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is a fully general function, not limited to exploring any fixed domain of \
graphical or algebraic examples. There is literally nothing you can see in a \
cell in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook that you cannot interactively explore using ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " (subject only, of course, to the speed of your computer)."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Saving Definitions of Functions Used inside Manipulate", "Section"],

Cell[TextData[{
 "Suppose you define a function, then use it in the first argument of a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"f", "[", "y", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`y$$ = 16.6, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`y$$], 0, 100}}, Typeset`size$$ = {49., {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`y$3534$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`y$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`y$$, $CellContext`y$3534$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`f[$CellContext`y$$], 
      "Specifications" :> {{$CellContext`y$$, 0, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This example will work well, until you try saving it in a file and then \
reopening it in a fresh session of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Then the function ",
 Cell[BoxData["f"], "InlineFormula"],
 " will not be defined until you manually evaluate the cell containing its \
definition. (In fact, if you are reading this documentation inside ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you will see ",
 Cell[BoxData["f"], "InlineFormula"],
 " appearing in the output area of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " at first, for exactly this reason.)"
}], "Text"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " supports the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SaveDefinitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SaveDefinitions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", which causes it to automatically build into the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output a copy of all the definitions of functions referred to in the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " input (and recursively any functions they refer to). These definitions are \
then reestablished in any new ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output is opened in, before contents of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " are evaluated for the first time."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"g", "[", "y", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`y$$ = 53.400000000000006`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`y$$], 0, 100}}, Typeset`size$$ = {49., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`y$3572$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`y$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`y$$, $CellContext`y$3572$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`g[$CellContext`y$$], 
      "Specifications" :> {{$CellContext`y$$, 0, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`g[
         Pattern[$CellContext`x, 
          Blank[]]] := $CellContext`x^2, $CellContext`x = 
       "Fri 2 Feb 2007 17:02:11"}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Thus if you are reading this inside ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the second example should correctly display a number even when first \
opened."
}], "Text"],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["SaveDefinitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SaveDefinitions"]], "InlineFormula"],
 " to store function definitions or datasets, but be warned that if you refer \
to a large volume of data, it will of course be present in the file \
containing the saved ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output, potentially creating a very large file."
}], "Text"],

Cell[TextData[{
 "An alternative in such a case is to use the ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option to load a package of data from a file or other source, rather than \
building it into the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output. The ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option can be given any arbitrary block of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to be evaluated before the contents of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " are first evaluated in any fresh session of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The right hand-side of the ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option will be evaluated only once per session."
}], "Text"],

Cell[TextData[{
 "For example, you can achieve the same result as earlier using the ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option instead of ",
 Cell[BoxData[
  ButtonBox["SaveDefinitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SaveDefinitions"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"h", "[", "y", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"h", "[", "x_", "]"}], ":=", 
      RowBox[{"x", "^", "2"}]}], ")"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`y$$ = 47., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`y$$], 0, 100}}, Typeset`size$$ = {35., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`y$3621$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`y$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`y$$, $CellContext`y$3621$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`h[$CellContext`y$$], 
      "Specifications" :> {{$CellContext`y$$, 0, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>($CellContext`h[
        Pattern[$CellContext`x, 
         Blank[]]] := $CellContext`x^2; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[
  ButtonBox["SaveDefinitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SaveDefinitions"]], "InlineFormula"],
 " as a convenient automatic way of setting an ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option with all the definitions you need to run the example. (",
 Cell[BoxData[
  ButtonBox["SaveDefinitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SaveDefinitions"]], "InlineFormula"],
 " does not actually interfere with the use of the ",
 Cell[BoxData[
  ButtonBox["Initialization",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Initialization"]], "InlineFormula"],
 " option: you can use both if you like.)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gamepads and Joysticks", "Section"],

Cell[TextData[{
 "When interacting with a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output using a mouse, you are limited to moving only one control at a \
time. However, there are many USB controller devices available which overcome \
this limitation by placing a button or joystick under each finger, thus \
greatly increasing the number of controls you can move simultaneously."
}], "Text"],

Cell[TextData[{
 "In order to take advantage of a USB controller in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", all you have to do is plug it in, and use the mouse to select (highlight) \
the cell bracket containing the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output you want to control",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically detects the controller, and ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " automatically links as many parameters as possible with the available \
joysticks and buttons."
}], "Text"],

Cell[TextData[{
 "While ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will work, or attempt to work, with any USB controller device (gamepad, \
joystick, simulated airplane throttle control, even data acquisition devices \
that use the USB controller interface standard), some definitely work better \
than others for controlling ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " outputs. Generally speaking, dual-joystick gamepads, such as commonly used \
with video games, provide a good set of controls, typically four analog axes \
and large number of buttons."
}], "Text"],

Cell[TextData[{
 "For the remainder of this section we will assume you are using a Logitech \
Dual Action gamepad. (This inexpensive controller is widely available and has \
better mechanical and electrical performance than many other units, even \
significantly more expensive ones.) If you are using a single joystick or \
other brand, of gamepad there may be some differences in which controller \
parts map to which ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " parameters."
}], "Text"],

Cell["\<\
With a gamepad plugged in, select the cell bracket of the cell containing the \
following output. Initially nothing will happen, because the gamepad's \
joysticks are in their neutral, undeflected position. But if you move them, \
you will see one or more of the parameters start to change. The rate at which \
the parameter changes is proportional to the degree of deflection of the \
joystick.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a1", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n1", " ", "x"}], "]"}]}], "+", 
      RowBox[{"a2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n2", " ", "x"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a2", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 
    0.24527109414510942`, $CellContext`a2$$ = 1, $CellContext`n1$$ = 
    9.769336901687094, $CellContext`n2$$ = 9.568627450980392, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`a1$$], 0, 1}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`a2$$], 0, 1}}, Typeset`size$$ = {360., {113., 117.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$17597730$$ = 0, $CellContext`a1$17597731$$ = 
    0, $CellContext`n2$17597732$$ = 0, $CellContext`a2$17597733$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 0, $CellContext`a2$$ = 
        0, $CellContext`n1$$ = 1, $CellContext`n2$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$17597730$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$17597731$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$17597732$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$17597733$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`a1$$ 
         Sin[$CellContext`n1$$ $CellContext`x] + $CellContext`a2$$ 
         Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`a1$$, 0, 
         1}, {$CellContext`n2$$, 1, 20}, {$CellContext`a2$$, 0, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {198., 203.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 403},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " connects the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis of the left gamepad to the first parameter, the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " axis of the left joystick to the second parameter, the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis of the right joystick to the third parameter, and the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " axis of the right gamepad to the fourth parameter. You can verify this by \
moving each joystick in a given direction and watching which parameter \
changes. (If you are using something other than a Logitech Dual Action \
gamepad you may see a different mapping: each manufacturer does things a bit \
differently, and while ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has tables that attempt to normalize many commonly available controllers, \
new ones are always being introduced.)"
}], "Text"],

Cell["\<\
By default, the mapping is \"velocity-based\", which is to say that the rate \
at which the parameter changes is controlled by the position of the joystick. \
The joystick position is thus not directly connected to the value of the \
variable. \
\>", "Text"],

Cell[TextData[{
 "You might instead want the value of the variable to be determined by the \
absolute position of the joystick, and there are two ways to achieve this. On \
many gamepads, including the recommended Logitech model, the joysticks are \
also buttons: if you press down on a joystick it clicks like a button, and \
when the joystick is controlling a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", this causes the corresponding parameter(s) to become directly linked to \
the position of the joystick. You can use this direct mode to rapidly jump to \
any position, then release the joystick to stop the parameter value there."
}], "Text"],

Cell[TextData[{
 "If your gamepad ",
 "does not",
 " have buttons in the joysticks, or you just want the linkage to always be \
direct, you can use the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerMethod"], "->", "\"\<Absolute\>\""}]], 
  "InlineFormula"],
 ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a1", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n1", " ", "x"}], "]"}]}], "+", 
      RowBox[{"a2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n2", " ", "x"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerMethod", " ", "\[Rule]", " ", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 
    0.4980392156862745, $CellContext`a2$$ = 
    0.4980392156862745, $CellContext`n1$$ = 
    10.462745098039216`, $CellContext`n2$$ = 10.462745098039216`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`a1$$], 0, 1}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`a2$$], 0, 1}}, Typeset`size$$ = {360., {113., 117.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$17606479$$ = 0, $CellContext`a1$17606480$$ = 
    0, $CellContext`n2$17606481$$ = 0, $CellContext`a2$17606482$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 0, $CellContext`a2$$ = 
        0, $CellContext`n1$$ = 1, $CellContext`n2$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$17606479$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$17606480$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$17606481$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$17606482$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`a1$$ 
         Sin[$CellContext`n1$$ $CellContext`x] + $CellContext`a2$$ 
         Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`a1$$, 0, 
         1}, {$CellContext`n2$$, 1, 20}, {$CellContext`a2$$, 0, 1}}, 
      "Options" :> {ControllerMethod -> "Absolute"}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {198., 203.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 403},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Note that there are disadvantages to direct linkage, most notably that as \
soon as you highlight the cell bracket (with a gamepad connected), all of the \
parameter values immediately jump to their middle positions, which is of \
course what they must do if the joysticks are in their neutral positions. \
While you can still use the mouse to set values, they will be overridden by \
the gamepad as soon as it is touched. \
\>", "Text"],

Cell[TextData[{
 "A small variation on velocity control can be had with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerMethod"], "->", "\"\<Cyclic\>\""}]], 
  "InlineFormula"],
 ". With this setting the linkage is velocity-based, but when you reach one \
end of the parameter's range of values instead of stopping, it cycles around \
to the opposite end."
}], "Text"],

Cell["\<\
Whether direct or velocity-based linking is best depends on the example. The \
previous example is generally more satisfactory with velocity linking, while \
the following example is definitely better with direct linking.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.02", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Cos", "[", "l", "]"}]}], ",", 
            RowBox[{"Sin", "[", "l", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "l", "]"}], ",", 
            RowBox[{"Sin", "[", "l", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.5"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Cos", "[", "a", "]"}]}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"Sin", "[", "a", "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "a", "]"}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"Sin", "[", "a", "]"}]}]}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1.5"}], "}"}], ",", ".2"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"l", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
   RowBox[{"ControllerMethod", " ", "\[Rule]", " ", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = -0.006159985595274082, \
$CellContext`l$$ = -0.7884781561950853, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`l$$], Rational[-1, 2] Pi, 0}, {
      Hold[$CellContext`a$$], Rational[-1, 2] Pi, Rational[1, 2] Pi}}, 
    Typeset`size$$ = {288., {214., 218.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`l$17608555$$ = 0, $CellContext`a$17608556$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = Rational[-1, 2] Pi, $CellContext`l$$ = 
        Rational[-1, 2] Pi}, "ControllerVariables" :> {
        Hold[$CellContext`l$$, $CellContext`l$17608555$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$17608556$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Thickness[0.02], 
         Line[{{-Cos[$CellContext`l$$], 
            Sin[$CellContext`l$$]}, {0, 0}, {
            Cos[$CellContext`l$$], 
            Sin[$CellContext`l$$]}}], 
         Line[{{0, 0}, {0, 1.5}}], 
         Line[{{-Cos[$CellContext`a$$], 1 + Sin[$CellContext`a$$]}, {0, 1}, {
            Cos[$CellContext`a$$], 1 + Sin[$CellContext`a$$]}}], 
         Disk[{0, 1.5}, 0.2]}, PlotRange -> {{-1, 1}, {-1, 2}}], 
      "Specifications" :> {{$CellContext`l$$, Rational[-1, 2] Pi, 
         0}, {$CellContext`a$$, Rational[-1, 2] Pi, Rational[1, 2] Pi}}, 
      "Options" :> {ControllerMethod -> "Absolute"}, "DefaultOptions" :> {}],
     ImageSizeCache->{334., {272., 277.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{338, 551},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "If any of these examples seem not to be working, chances are it is because \
you have forgotten to highlight the cell bracket containing them. This is a \
common mistake. As a convenience, and to avoid the need to select each output \
as soon as it is generated, if you wiggle any gamepad controller immediately \
after generating an output that references controllers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically select the output cell for you. But this only happens \
immediately after the output is generated, after that ",
 "it is",
 " up to you to choose, by selecting it, which ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output you want the controller connected to."
}], "Text"],

Cell[TextData[{
 "If you want a given ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to always respond to the controller whether ",
 "it is",
 " selected or not, you can add the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerLinking",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerLinking"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", but this feature should be used with caution. If you have multiple such \
outputs on screen, they will all attempt to move simultaneously, which is \
rarely helpful. The option is best used in situations where you are creating \
a fixed-format output window, rather than when creating examples meant to be \
used in a scrolling document such as this one."
}], "Text"],

Cell[TextData[{
 "In examples like the previous one, which do not make much sense unless you \
have a gamepad available, it is often pointless to display the sliders \
associated with the parameters, or the rest of the framework of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". The function ",
 Cell[BoxData[
  ButtonBox["ControllerManipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFormula"],
 " is basically identical to ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " in all its features and syntax, except that it does not display any frame \
or sliders."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerManipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.02", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Cos", "[", "l", "]"}]}], ",", 
            RowBox[{"Sin", "[", "l", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "l", "]"}], ",", 
            RowBox[{"Sin", "[", "l", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.5"}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Cos", "[", "a", "]"}]}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"Sin", "[", "a", "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "a", "]"}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"Sin", "[", "a", "]"}]}]}], "}"}]}], "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1.5"}], "}"}], ",", ".2"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"l", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", "0"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ControllerMethod", " ", "\[Rule]", " ", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 
    0.006159985595274082, $CellContext`l$$ = -0.7884781561950853, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`l$$], Rational[-1, 2] Pi, 0}, {
      Hold[$CellContext`a$$], Rational[-1, 2] Pi, Rational[1, 2] Pi}}, 
    Typeset`size$$ = {144., {106., 110.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`l$17623410$$ = 0, $CellContext`a$17623411$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = Rational[-1, 2] Pi, $CellContext`l$$ = 
        Rational[-1, 2] Pi}, "ControllerVariables" :> {
        Hold[$CellContext`l$$, $CellContext`l$17623410$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$17623411$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Thickness[0.02], 
         Line[{{-Cos[$CellContext`l$$], 
            Sin[$CellContext`l$$]}, {0, 0}, {
            Cos[$CellContext`l$$], 
            Sin[$CellContext`l$$]}}], 
         Line[{{0, 0}, {0, 1.5}}], 
         Line[{{-Cos[$CellContext`a$$], 1 + Sin[$CellContext`a$$]}, {0, 1}, {
            Cos[$CellContext`a$$], 1 + Sin[$CellContext`a$$]}}], 
         Disk[{0, 1.5}, 0.2]}, PlotRange -> {{-1, 1}, {-1, 2}}], 
      "Specifications" :> {{$CellContext`l$$, Rational[-1, 2] Pi, 
         0}, {$CellContext`a$$, Rational[-1, 2] Pi, Rational[1, 2] Pi}}, 
      "Options" :> {
       ControllerMethod -> "Absolute", AppearanceElements -> {}, ControlType -> 
        None, Paneled -> False, SynchronousUpdating -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{164., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{168, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " will continue to be used in subsequent examples because it is helpful to \
be able to see the controls to understand how they are being affected by the \
gamepad, but many of these examples would look and work just as well with ",
 Cell[BoxData[
  ButtonBox["ControllerManipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " contains ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " variables, whose values are ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " pairs of numbers, they will automatically be linked to both directions of \
available joysticks. This example responds in both directions to the \
left-hand joystick on a gamepad."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {0.10629559992020632`, 
    0.21528295247255047`}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {},
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$17623606$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pt$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$17623606$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[0.05], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {{$CellContext`pt$$, {-1, -1}, {1, 1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {251., 256.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 509},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Push buttons on the controller are by default linked up to any Boolean (",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "/",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ") parameters specified in the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". Which button is which can be a bit hard to guess on a given controller (a \
concept which is explained elsewhere), but on the Logitech model the group of \
four buttons on the right side are labeled 1 through 4, and are used by ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " in that order. In this example clicking the \"1\" button toggles the \
setting of ",
 Cell[BoxData["b1"], "InlineFormula"],
 ", changing the color of the  point."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{"b1", ",", "Red", ",", "Green"}], "]"}], ",", 
       RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`b1$$ = 
    False, $CellContext`pt$$ = {-0.19416569088441224`, 0.07231967715124386}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}, {
      Hold[$CellContext`b1$$], {True, False}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$17624310$$ = {0, 
    0}, $CellContext`b1$17624311$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`b1$$ = True, $CellContext`pt$$ = {-1, -1}},
       "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$17624310$$, {0, 0}], 
        Hold[$CellContext`b1$$, $CellContext`b1$17624311$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         If[$CellContext`b1$$, Red, Green], 
         PointSize[0.05], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {{$CellContext`pt$$, {-1, -1}, {1, 
         1}}, {$CellContext`b1$$, {True, False}}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {260., 265.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 527},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This toggling behavior (flipping the value of the parameter once each time \
the button is pressed) is the equivalent of velocity-based linking. If you \
use the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerMethod"], "->", "\"\<Absolute\>\""}]], 
  "InlineFormula"],
 " option (see previous examples) the parameter will be linked directly, \
which is to say ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " all the time except while the button is actually being held down."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{"b1", ",", "Red", ",", "Green"}], "]"}], ",", 
       RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"ControllerMethod", "\[Rule]", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`b1$$ = False, $CellContext`pt$$ = {
    0.10588235294117654`, -0.0039215686274509665`}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}, {
      Hold[$CellContext`b1$$], {True, False}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$17624757$$ = {0, 
    0}, $CellContext`b1$17624758$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`b1$$ = True, $CellContext`pt$$ = {-1, -1}},
       "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$17624757$$, {0, 0}], 
        Hold[$CellContext`b1$$, $CellContext`b1$17624758$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         If[$CellContext`b1$$, Red, Green], 
         PointSize[0.05], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {{$CellContext`pt$$, {-1, -1}, {1, 
         1}}, {$CellContext`b1$$, {True, False}}}, 
      "Options" :> {ControllerMethod -> "Absolute"}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {260., 265.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 527},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "The exact rules by which ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " connects controller axes to parameters are somewhat complex, but basically \
they try to allocate the available analog and Boolean controls to the \
parameters in the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " so as to make maximum use of the available joysticks, buttons, knobs, and \
other widgets on the controller. (Often the quickest and easiest way to \
figure out what has been linked to what is simply to wiggle the various knobs \
and see what happens.)"
}], "Text"],

Cell[TextData[{
 "If you find that the default linking is not to your liking, it can \
overridden it by explicitly stating which controller axis should be connected \
to which parameter. The controller axes are named according to a logical \
system, but for most purposes ",
 "it is",
 " enough to remember a few basic names: ",
 Cell[BoxData["\"\<X\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Y\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<XY\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<X1\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<X2\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<B1\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<B2\>\""], "InlineFormula"],
 ", etc."
}], "Text"],

Cell[TextData[{
 Cell[BoxData["\"\<X\>\""], "InlineFormula"],
 ", or its synonym ",
 Cell[BoxData["\"\<X1\>\""], "InlineFormula"],
 ", refers to the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis of the primary, or left-hand joystick on the gamepad. To specify that \
a parameter should be linked to this axis, use the following form."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"\"\<X\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.036358219278724964`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {63., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$17608964$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$17608964$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {"X" -> {$CellContext`x$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\"\<X2\>\""], "InlineFormula"],
 " similarly refers to the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis of the secondary, or right-hand joystick."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"\"\<X2\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.132, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {35., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$17609111$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$17609111$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {"X2" -> {$CellContext`x$$, 0, 1}}, "Options" :> {},
       "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Axes can be combined into multidimensional parameters. For example, ",
 Cell[BoxData["\"\<XY\>\""], "InlineFormula"],
 " refers to both directions of the left or primary joystick, combined into a \
single ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " value. Such a combined axis must be connected to a ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " style of parameter, as in this example."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"\"\<XY\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"pt", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {-0.04999999999999993, 
    0.3500000000000001}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$17621224$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pt$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$17621224$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[0.05], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {"XY" -> {$CellContext`pt$$, {-1, -1}, {1, 1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {251., 256.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 509},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Three-axis variables are also supported as ",
 Cell[BoxData[
  ButtonBox["\"\<XYZ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XYZ"]], "InlineFormula"],
 ". When using a three-axis joystick controller, these will correspond to the \
three degrees of freedom of the joystick. When using a dual-joystick gamepad, \
each joystick only has two degrees of freedom. In this case the ",
 Cell[BoxData["\"\<XYZ\>\""], "InlineFormula"],
 " axis is linked to the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " directions of the left joystick plus the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction of the right joystick. Whether this makes sense depends on the \
example: examples written specifically to take advantage of a \
three-degrees-of-freedom joystick may not work well with any other kind of \
controller."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"\"\<XYZ\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"pt", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {
    0.4870509363594427, -0.5443350759448716, 0.6574598315012844}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1, -1}, {1, 1, 1}}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$17625756$$ = {0, 0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pt$$ = {-1, -1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$17625756$$, {0, 0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         PointSize[0.05], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {
       "XYZ" -> {$CellContext`pt$$, {-1, -1, -1}, {1, 1, 1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {233., 238.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 473},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Some controllers actually provide 6 analog degrees of freedom, which can be \
referred to as ",
 Cell[BoxData["\"\<XYZ\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<XYZ2\>\""], "InlineFormula"],
 ". For example, if you have a 3Dconnexion SpaceNavigator control, the \
following example will let you explore its three spatial and three angular \
degrees of freedom. If you do not have one, the example will be \
unsatisfactory."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
       RowBox[{"PointSize", "[", "0.04", "]"}], ",", 
       RowBox[{"Point", "[", "pt1", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"pt1", ",", 
          RowBox[{"pt1", "+", "pt2"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"\"\<XYZ\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"pt1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"\"\<XYZ2\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"pt2", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ControllerMethod", "\[Rule]", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt1$$ = {-0.04999999999999993, 
    0.14000000000000012`, -0.020000000000000018`}, $CellContext`pt2$$ = \
{-0.6699999999999999, 0.06000000000000005, -0.13}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt1$$], {-1, -1, -1}, {1, 1, 1}}, {
      Hold[$CellContext`pt2$$], {-1, -1, -1}, {1, 1, 1}}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt1$17630398$$ = {0, 0, 
    0}, $CellContext`pt2$17630399$$ = {0, 0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pt1$$ = {-1, -1, -1}, $CellContext`pt2$$ = \
{-1, -1, -1}}, "ControllerVariables" :> {
        Hold[$CellContext`pt1$$, $CellContext`pt1$17630398$$, {0, 0, 0}], 
        Hold[$CellContext`pt2$$, $CellContext`pt2$17630399$$, {0, 0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         Thickness[0.01], 
         PointSize[0.04], 
         Point[$CellContext`pt1$$], 
         Line[{$CellContext`pt1$$, $CellContext`pt1$$ + $CellContext`pt2$$}]},
         PlotRange -> 1], 
      "Specifications" :> {
       "XYZ" -> {$CellContext`pt1$$, {-1, -1, -1}, {1, 1, 1}}, 
        "XYZ2" -> {$CellContext`pt2$$, {-1, -1, -1}, {1, 1, 1}}}, 
      "Options" :> {ControllerMethod -> "Absolute"}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {243., 248.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 493},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "(Note that 3D variables in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " are available whether you are using a controller or not, but are not \
generally useful other than in connection with a joystick or gamepad.)"
}], "Text"],

Cell[TextData[{
 "A typical gamepad has two ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "-",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " controllers, named ",
 Cell[BoxData["\"\<XY\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<XY2\>\""], "InlineFormula"],
 ". But what is less obvious is that there are also several more \
pseudo-analog axes available, generated by considering groups of four buttons \
as four directions: up, down, left, and right. For example, the \"hat\", a \
directional pad on the left side of a Logitech Dual Action gamepad, can be \
referenced as ",
 Cell[BoxData["\"\<XY3\>\""], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
       RowBox[{"Point", "[", "pt", "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"\"\<XY3\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"pt", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {0.24, 0.42999999999999994`}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`pt$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`pt$17621563$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`pt$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`pt$$, $CellContext`pt$17621563$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[0.05], 
         Point[$CellContext`pt$$]}, PlotRange -> 1], 
      "Specifications" :> {"XY3" -> {$CellContext`pt$$, {-1, -1}, {1, 1}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {251., 256.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 509},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Two additional axes (",
 Cell[BoxData["\"\<XY4\>\""], "InlineFormula"],
 ") are defined by the four buttons on the right side of the gamepad, and the \
four buttons on the front face (",
 Cell[BoxData["\"\<XY5\>\""], "InlineFormula"],
 "). Needless to say this is highly specific to the Logitech brand of \
controller, but others typically have similar groups of buttons."
}], "Text"],

Cell["\<\
These pseudo-analog axes act just like real analog ones, except that in \
velocity-linked mode they always progress at the same speed, and in absolute \
mode they are always pegged at the full-left, center, or full-right \
positions.\
\>", "Text"],

Cell[TextData[{
 "When attempting to hook up specific axes it is often confusing trying to \
figure out which one is which on a given controller. The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"], "[", "]"}]], 
  "InlineFormula"],
 " can be used figure this out interactively. With your gamepad or joystick \
plugged in, evaluate this input (you have to evaluate it in your session of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with your controller plugged in to get current information)",
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerInformation", "[", "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  PanelBox[
   StyleBox[
    TagBox[GridBox[{
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"1\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "1", ": ", 
               "Logitech Dual Action"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"1\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "1", ": ", 
                   "Logitech Dual Action"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Logitech\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1133", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Logitech", " (", 1133, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Logitech Dual Action\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "49686"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Joystick\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", "0.0039215686274509665`"},
                    {"\<\"Y\"\>", "0.0039215686274509665`"},
                    {"\<\"Z\"\>", "0.0039215686274509665`"},
                    {"\<\"X1\"\>", "0.0039215686274509665`"},
                    {"\<\"Y1\"\>", "0.0039215686274509665`"},
                    {"\<\"Z1\"\>", "0.0039215686274509665`"},
                    {"\<\"X2\"\>", "0.0039215686274509665`"},
                    {"\<\"Y2\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"X3\"\>", "0.`"},
                    {"\<\"Y3\"\>", "0.`"},
                    {"\<\"X4\"\>", "0"},
                    {"\<\"Y4\"\>", "0"},
                    {"\<\"X5\"\>", "0"},
                    {"\<\"Y5\"\>", "0"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"B3\"\>", "False"},
                    {"\<\"B4\"\>", "False"},
                    {"\<\"B5\"\>", "False"},
                    {"\<\"B6\"\>", "False"},
                    {"\<\"B7\"\>", "False"},
                    {"\<\"B8\"\>", "False"},
                    {"\<\"B9\"\>", "False"},
                    {"\<\"B10\"\>", "False"},
                    {"\<\"B11\"\>", "False"},
                    {"\<\"B12\"\>", "False"},
                    {"\<\"BLB\"\>", "False"},
                    {"\<\"BRB\"\>", "False"},
                    {"\<\"JB\"\>", "False"},
                    {"\<\"JB1\"\>", "False"},
                    {"\<\"JB2\"\>", "False"},
                    {"\<\"Select Button\"\>", "False"},
                    {"\<\"Start Button\"\>", "False"},
                    {"\<\"TLB\"\>", "False"},
                    {"\<\"TRB\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", 
                    "X3", "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", 
                    "B4", "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", 
                    "BLB", "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}, 
                    ControllerState[
                    1, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", "X3", 
                    "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", "B4", 
                    "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", "BLB", 
                    "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Y Axis\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Z Rotation\"\>", "0.0039215686274509665`"},
                    {"\<\"Hatswitch X Axis\"\>", "0.`"},
                    {"\<\"Hatswitch Y Axis\"\>", "0.`"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"},
                    {"\<\"Button 3\"\>", "False"},
                    {"\<\"Button 4\"\>", "False"},
                    {"\<\"Button 5\"\>", "False"},
                    {"\<\"Button 6\"\>", "False"},
                    {"\<\"Button 7\"\>", "False"},
                    {"\<\"Button 8\"\>", "False"},
                    {"\<\"Button 9\"\>", "False"},
                    {"\<\"Button 10\"\>", "False"},
                    {"\<\"Button 11\"\>", "False"},
                    {"\<\"Button 12\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}, 
                    ControllerState[
                    1, {"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 28.3953488372093}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            GridBoxAlignment->{"Columns" -> {{Left}}}],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"2\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"2\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Apple IR\\\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "33344"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"External \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"B\"\>", "False"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"B", "B1", "B2", "Button 1", "Button 2"}, 
                    ControllerState[
                    2, {"B", "B1", "B2", "Button 1", "Button 2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"Reserved Button\"\>", "False"},
                    {"\<\"Rewind Button\"\>", "False"},
                    {"\<\"FastForward Button\"\>", "False"},
                    {"\<\"Menu Button\"\>", "False"},
                    {"\<\"Reserved Button 2\"\>", "False"},
                    {"\<\"SystemAppMenu Button\"\>", "False"},
                    {"\<\"SystemMenu Button\"\>", "False"},
                    {"\<\"SystemMenuRight Button\"\>", "False"},
                    {"\<\"SystemMenuLeft Button\"\>", "False"},
                    {"\<\"Reserved Button 3\"\>", "False"},
                    {"\<\"SystemMenuUp Button\"\>", "False"},
                    {"\<\"SystemMenuDown Button\"\>", "False"},
                    {"\<\"Unknown:65281:65535 Button\"\>", "False"},
                    {"\<\"Unknown:65281:32 Button\"\>", "False"},
                    {"\<\"Unknown:65281:33 Button\"\>", "False"},
                    {"\<\"Unknown:65281:34 Button\"\>", "False"},
                    {"\<\"Unknown:65281:35 Button\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}, 
                    ControllerState[
                    2, {"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 28.3953488372093}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            GridBoxAlignment->{"Columns" -> {{Left}}}],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"3\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "3", ": ", 
               "Sudden Motion Sensor"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"3\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "3", ": ", 
                   "Sudden Motion Sensor"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Sudden Motion Sensor\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "0"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Motion Sensor Device\"\
\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Internal \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Y\"\>", "0.0039215686274509665`"},
                    {"\<\"Z\"\>", 
                    RowBox[{"-", "0.5450980392156863`"}]},
                    {"\<\"X1\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Y1\"\>", "0.0039215686274509665`"},
                    {"\<\"Z1\"\>", 
                    RowBox[{"-", "0.5450980392156863`"}]},
                    {"\<\"X2\"\>", 
                    RowBox[{"-", "0.5450980392156863`"}]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}, 
                    ControllerState[
                    3, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Y Axis\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z Axis\"\>", 
                    RowBox[{"-", "0.5450980392156863`"}]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X Axis", "Y Axis", "Z Axis"}, 
                    ControllerState[3, {"X Axis", "Y Axis", "Z Axis"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 28.3953488372093}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            GridBoxAlignment->{"Columns" -> {{Left}}}],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]}
      },
      GridBoxAlignment->{"Columns" -> {{Left}}}],
     "Column"], "DialogStyle",
    Editable->False,
    Deletable->False,
    StripOnInput->False,
    ShowStringCharacters->False,
    TooltipBoxOptions->{ActionDelay->Automatic}],
   DefaultBaseStyle->"DialogStyle",
   FrameMargins->5],
  ControllerInformationData[{
   "Logitech Dual Action" -> {{
      "X Axis" -> 0.0039215686274509665`, "Y Axis" -> -0.0039215686274509665`,
        "Z Axis" -> 0.0039215686274509665`, "Z Rotation" -> 
       0.0039215686274509665`, "Hatswitch X Axis" -> 0., "Hatswitch Y Axis" -> 
       0.}, {"Button 1" -> False, "Button 2" -> False, "Button 3" -> False, 
       "Button 4" -> False, "Button 5" -> False, "Button 6" -> False, 
       "Button 7" -> False, "Button 8" -> False, "Button 9" -> False, 
       "Button 10" -> False, "Button 11" -> False, "Button 12" -> False}, {
      "Manufacturer Name" -> "Logitech", "Manufacturer ID" -> 1133, 
       "Product Name" -> "Logitech Dual Action", "Product ID" -> 49686, 
       "Controller Type" -> "Joystick", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> 
       "GenericDesktop", "HID Usage" -> "Joystick"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", 
       "Select Button" -> "Button 9", "Start Button" -> "Button 10", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Apple IR" -> {{}, {
      "Reserved Button" -> False, "Rewind Button" -> False, 
       "FastForward Button" -> False, "Menu Button" -> False, 
       "Reserved Button 2" -> False, "SystemAppMenu Button" -> False, 
       "SystemMenu Button" -> False, "SystemMenuRight Button" -> False, 
       "SystemMenuLeft Button" -> False, "Reserved Button 3" -> False, 
       "SystemMenuUp Button" -> False, "SystemMenuDown Button" -> False, 
       "Unknown:65281:65535 Button" -> False, "Unknown:65281:32 Button" -> 
       False, "Unknown:65281:33 Button" -> False, "Unknown:65281:34 Button" -> 
       False, "Unknown:65281:35 Button" -> False}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Apple IR", "Product ID" -> 33344, 
       "Controller Type" -> "External Controller", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> "Consumer", 
       "HID Usage" -> "ConsumerControl"}, {
      "B" -> "Rewind Button", "B1" -> "Rewind Button", "Button 1" -> 
       "Rewind Button", "B2" -> "FastForward Button", "Button 2" -> 
       "FastForward Button", "X" -> "X Axis", "Y" -> -"Y Axis", "Z" -> 
       "Z Axis", "X1" -> "X Axis", "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> 
       "Z Rotation", "Y2" -> -"Slider", "Z2" -> None, "X3" -> 
       "Hatswitch X Axis", "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Sudden Motion Sensor" -> {{
      "X Axis" -> -0.0039215686274509665`, 
       "Y Axis" -> -0.0039215686274509665`, 
       "Z Axis" -> -0.5450980392156863}, {}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Sudden Motion Sensor", "Product ID" -> 0, 
       "Controller Type" -> "Internal Controller", "Device Type" -> 
       "Mac OS X Motion Sensor Device"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> 
       False}}}]]], "Output",
 ImageSize->{277, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Depending on what type of computer you are using you may get several \
built-in controls. For example, Macintosh laptops typically contain a \
position sensor that reads out the orientation of the computer at all times. \
This information is available and can be used with ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", but is not used by default (otherwise all ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " functions run on such laptops would constantly move around as you tilted \
the computer, which some might consider a nuisance)."
}], "Text"],

Cell[TextData[{
 "Locate the controller you want to examine and click the disclosure triangle \
next to its name to open a panel of information, then open the ",
 StyleBox["Mathematica", "DialogElementName",
  FontSlant->"Italic"],
 StyleBox[" Controls", "DialogElementName"],
 " sub-section to see a list of all the available axis names."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerInformation", "[", "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  PanelBox[
   StyleBox[
    TagBox[GridBox[{
       {
        DynamicModuleBox[{System`InfoDump`open$$ = True}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{111.3125, {1., 10.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"1\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "1", ": ", 
               "Logitech Dual Action"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm],
                    ImageSizeCache->{97., {1., 9.}}],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"1\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "1", ": ", 
                   "Logitech Dual Action"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Logitech\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1133", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Logitech", " (", 1133, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Logitech Dual Action\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "49686"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Joystick\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = True}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm],
                    ImageSizeCache->{53.125, {1., 10.}}],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm],
                    ImageSizeCache->{42., {1., 9.}}],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = False}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", "0.0039215686274509665`"},
                    {"\<\"Y\"\>", "0.0039215686274509665`"},
                    {"\<\"Z\"\>", "0.0039215686274509665`"},
                    {"\<\"X1\"\>", "0.0039215686274509665`"},
                    {"\<\"Y1\"\>", "0.0039215686274509665`"},
                    {"\<\"Z1\"\>", "0.0039215686274509665`"},
                    {"\<\"X2\"\>", "0.0039215686274509665`"},
                    {"\<\"Y2\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"X3\"\>", "0.`"},
                    {"\<\"Y3\"\>", "0.`"},
                    {"\<\"X4\"\>", "0"},
                    {"\<\"Y4\"\>", "0"},
                    {"\<\"X5\"\>", "0"},
                    {"\<\"Y5\"\>", "0"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"B3\"\>", "False"},
                    {"\<\"B4\"\>", "False"},
                    {"\<\"B5\"\>", "False"},
                    {"\<\"B6\"\>", "False"},
                    {"\<\"B7\"\>", "False"},
                    {"\<\"B8\"\>", "False"},
                    {"\<\"B9\"\>", "False"},
                    {"\<\"B10\"\>", "False"},
                    {"\<\"B11\"\>", "False"},
                    {"\<\"B12\"\>", "False"},
                    {"\<\"BLB\"\>", "False"},
                    {"\<\"BRB\"\>", "False"},
                    {"\<\"JB\"\>", "False"},
                    {"\<\"JB1\"\>", "False"},
                    {"\<\"JB2\"\>", "False"},
                    {"\<\"Select Button\"\>", "False"},
                    {"\<\"Start Button\"\>", "False"},
                    {"\<\"TLB\"\>", "False"},
                    {"\<\"TRB\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", 
                    "X3", "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", 
                    "B4", "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", 
                    "BLB", "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}, 
                    ControllerState[
                    1, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", "X3", 
                    "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", "B4", 
                    "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", "BLB", 
                    "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm],
                    ImageSizeCache->{106., {258., 263.}}]}, Dynamic[
                    System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm],
                    ImageSizeCache->{42., {1., 9.}}],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Y Axis\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Z Rotation\"\>", "0.0039215686274509665`"},
                    {"\<\"Hatswitch X Axis\"\>", "0.`"},
                    {"\<\"Hatswitch Y Axis\"\>", "0.`"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"},
                    {"\<\"Button 3\"\>", "False"},
                    {"\<\"Button 4\"\>", "False"},
                    {"\<\"Button 5\"\>", "False"},
                    {"\<\"Button 6\"\>", "False"},
                    {"\<\"Button 7\"\>", "False"},
                    {"\<\"Button 8\"\>", "False"},
                    {"\<\"Button 9\"\>", "False"},
                    {"\<\"Button 10\"\>", "False"},
                    {"\<\"Button 11\"\>", "False"},
                    {"\<\"Button 12\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}, 
                    ControllerState[
                    1, {"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 28.3953488372093}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            GridBoxAlignment->{"Columns" -> {{Left}}}],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"2\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"2\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Apple IR\\\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "33344"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"External \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"B\"\>", "False"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"B", "B1", "B2", "Button 1", "Button 2"}, 
                    ControllerState[
                    2, {"B", "B1", "B2", "Button 1", "Button 2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"Reserved Button\"\>", "False"},
                    {"\<\"Rewind Button\"\>", "False"},
                    {"\<\"FastForward Button\"\>", "False"},
                    {"\<\"Menu Button\"\>", "False"},
                    {"\<\"Reserved Button 2\"\>", "False"},
                    {"\<\"SystemAppMenu Button\"\>", "False"},
                    {"\<\"SystemMenu Button\"\>", "False"},
                    {"\<\"SystemMenuRight Button\"\>", "False"},
                    {"\<\"SystemMenuLeft Button\"\>", "False"},
                    {"\<\"Reserved Button 3\"\>", "False"},
                    {"\<\"SystemMenuUp Button\"\>", "False"},
                    {"\<\"SystemMenuDown Button\"\>", "False"},
                    {"\<\"Unknown:65281:65535 Button\"\>", "False"},
                    {"\<\"Unknown:65281:32 Button\"\>", "False"},
                    {"\<\"Unknown:65281:33 Button\"\>", "False"},
                    {"\<\"Unknown:65281:34 Button\"\>", "False"},
                    {"\<\"Unknown:65281:35 Button\"\>", "False"}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}, 
                    ControllerState[
                    2, {"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 28.3953488372093}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            GridBoxAlignment->{"Columns" -> {{Left}}}],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"3\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "3", ": ", 
               "Sudden Motion Sensor"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"3\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "3", ": ", 
                   "Sudden Motion Sensor"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Sudden Motion Sensor\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "0"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Motion Sensor Device\"\
\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Internal \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", 
                    RowBox[{"-", "0.04313725490196074`"}]},
                    {"\<\"Y\"\>", "0.0039215686274509665`"},
                    {"\<\"Z\"\>", 
                    RowBox[{"-", "0.5686274509803921`"}]},
                    {"\<\"X1\"\>", 
                    RowBox[{"-", "0.04313725490196074`"}]},
                    {"\<\"Y1\"\>", "0.0039215686274509665`"},
                    {"\<\"Z1\"\>", 
                    RowBox[{"-", "0.5686274509803921`"}]},
                    {"\<\"X2\"\>", 
                    RowBox[{"-", "0.5686274509803921`"}]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}, 
                    ControllerState[
                    3, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", 
                    RowBox[{"-", "0.04313725490196074`"}]},
                    {"\<\"Y Axis\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z Axis\"\>", 
                    RowBox[{"-", "0.5686274509803921`"}]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X Axis", "Y Axis", "Z Axis"}, 
                    ControllerState[3, {"X Axis", "Y Axis", "Z Axis"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    GridBoxAlignment->{"Columns" -> {{Left}}}],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}}],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 28.3953488372093}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            GridBoxAlignment->{"Columns" -> {{Left}}}],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]}
      },
      GridBoxAlignment->{"Columns" -> {{Left}}}],
     "Column"], "DialogStyle",
    Editable->False,
    Deletable->False,
    StripOnInput->False,
    ShowStringCharacters->False,
    TooltipBoxOptions->{ActionDelay->Automatic}],
   DefaultBaseStyle->"DialogStyle",
   FrameMargins->5],
  ControllerInformationData[{
   "Logitech Dual Action" -> {{
      "X Axis" -> 0.0039215686274509665`, "Y Axis" -> -0.0039215686274509665`,
        "Z Axis" -> 0.0039215686274509665`, "Z Rotation" -> 
       0.0039215686274509665`, "Hatswitch X Axis" -> 0., "Hatswitch Y Axis" -> 
       0.}, {"Button 1" -> False, "Button 2" -> False, "Button 3" -> False, 
       "Button 4" -> False, "Button 5" -> False, "Button 6" -> False, 
       "Button 7" -> False, "Button 8" -> False, "Button 9" -> False, 
       "Button 10" -> False, "Button 11" -> False, "Button 12" -> False}, {
      "Manufacturer Name" -> "Logitech", "Manufacturer ID" -> 1133, 
       "Product Name" -> "Logitech Dual Action", "Product ID" -> 49686, 
       "Controller Type" -> "Joystick", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> 
       "GenericDesktop", "HID Usage" -> "Joystick"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", 
       "Select Button" -> "Button 9", "Start Button" -> "Button 10", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Apple IR" -> {{}, {
      "Reserved Button" -> False, "Rewind Button" -> False, 
       "FastForward Button" -> False, "Menu Button" -> False, 
       "Reserved Button 2" -> False, "SystemAppMenu Button" -> False, 
       "SystemMenu Button" -> False, "SystemMenuRight Button" -> False, 
       "SystemMenuLeft Button" -> False, "Reserved Button 3" -> False, 
       "SystemMenuUp Button" -> False, "SystemMenuDown Button" -> False, 
       "Unknown:65281:65535 Button" -> False, "Unknown:65281:32 Button" -> 
       False, "Unknown:65281:33 Button" -> False, "Unknown:65281:34 Button" -> 
       False, "Unknown:65281:35 Button" -> False}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Apple IR", "Product ID" -> 33344, 
       "Controller Type" -> "External Controller", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> "Consumer", 
       "HID Usage" -> "ConsumerControl"}, {
      "B" -> "Rewind Button", "B1" -> "Rewind Button", "Button 1" -> 
       "Rewind Button", "B2" -> "FastForward Button", "Button 2" -> 
       "FastForward Button", "X" -> "X Axis", "Y" -> -"Y Axis", "Z" -> 
       "Z Axis", "X1" -> "X Axis", "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> 
       "Z Rotation", "Y2" -> -"Slider", "Z2" -> None, "X3" -> 
       "Hatswitch X Axis", "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Sudden Motion Sensor" -> {{
      "X Axis" -> -0.04313725490196074, "Y Axis" -> -0.0039215686274509665`, 
       "Z Axis" -> -0.5686274509803921}, {}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Sudden Motion Sensor", "Product ID" -> 0, 
       "Controller Type" -> "Internal Controller", "Device Type" -> 
       "Mac OS X Motion Sensor Device"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> 
       False}}}]]], "Output",
 ImageSize->{393, 725},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "If ",
 StyleBox["Show Dynamic Values", "DialogElementName"],
 " is checked, the values displayed in the panel will update in real time as \
you wiggle the controller or push its buttons, allowing you to easily \
determine which button corresponds to which named axis. (Do not forget the \
quotes around the axis names when using them in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ".)"
}], "Text"],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["ControllerMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerMethod"]], "InlineFormula"],
 " can only be used at the level of the whole ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to change the linking from velocity-based to absolute. If you want to make \
some axes absolute and some velocity-based, add ",
 Cell[BoxData["\"\<Absolute\>\""], "InlineFormula"],
 " to the name of any axes you want to have linked absolutely, as in this \
example, which has a velocity-based ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction and an absolute ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " direction."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"\"\<X\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
   RowBox[{"\"\<YAbsolute\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 
    0.2507602052816929, $CellContext`y$$ = -0.0039215686274509665`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], -1, 1}, {
      Hold[$CellContext`y$$], -1, 1}}, Typeset`size$$ = {360., {178., 182.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$406$$ = 0, $CellContext`y$407$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = -1, $CellContext`y$$ = -1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$406$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$407$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[0.05], 
         Point[{$CellContext`x$$, $CellContext`y$$}]}, PlotRange -> 1], 
      "Specifications" :> {
       "X" -> {$CellContext`x$$, -1, 1}, 
        "YAbsolute" -> {$CellContext`y$$, -1, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{406., {236., 241.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 479},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "The opposite of ",
 Cell[BoxData["\"\<Absolute\>\""], "InlineFormula"],
 " in this notation is ",
 Cell[BoxData["\"\<Relative\>\""], "InlineFormula"],
 ", as in ",
 Cell[BoxData["\"\<XRelative\>\""], "InlineFormula"],
 ", etc."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Autorun", "Section"],

Cell[TextData[{
 "In many ways ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is a big improvement over simple linear animations. Rather than running \
through a fixed sequence, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " lets you move back and forth at will. But what if you do not want to have \
to move a slider by hand? One option is to use the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "SquarePlusIcon"],
   ImageSizeCache->{7., {0., 7.}}]], "Output"],
 " icon next to each slider to open a panel with animation controls. A ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " with one variable being animated is virtually equivalent to ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 "."
}], "Text"],

Cell[TextData[{
 "But if you have multiple variables and want to see the effect of changing \
all of them, ",
 "it is",
 " inconvenient to use the individual animation controls. The ",
 StyleBox["Autorun", "DialogElementName"],
 " feature of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " solves this problem by providing a single animation control that runs all \
the variables through their ranges of values."
}], "Text"],

Cell[TextData[{
 "Click the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CirclePlusIcon"],
   ImageSizeCache->{10., {3., 7.}}]], "Output"],
 " menu in the top right corner of a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output and select ",
 StyleBox["Autorun", "DialogElementName"],
 " from the bottom of the menu. You will see an ",
 StyleBox["Autorun", "DialogElementName"],
 " panel appear at the top of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", containing animation controls and a close button. By default the \
animation runs each individual variable through its range of values, leaving \
the others at their default values. As with any animation control, you can \
change the speed and direction, or click the slider to move through the \
animation manually. The ",
 StyleBox["Autorun", "DialogElementName"],
 " animation slider acts as a sort of master control driving all the other \
controls in a defined order."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{"None", ",", "Axis", ",", "Top", ",", "Bottom"}], "}"}]}], 
    "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`filling$$ = None, $CellContext`n1$$ = 
    1, $CellContext`n2$$ = 14.137400054931646`, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Autorun", 
    Typeset`animator$$ = AnimatorBox[
     Dynamic[
     Typeset`animvar$$, (
      Typeset`animvar$$ = #; {$CellContext`filling$$, $CellContext`n1$$, \
$CellContext`n2$$} = Through[
         Manipulate`Dump`flis1$2136[Typeset`animvar$$]])& ], {0, 12}, 
     ImageSize -> Small, DefaultDuration -> 12, AnimationRate -> Automatic, 
     AppearanceElements -> {
      "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
       "DirectionButton"}], Typeset`animvar$$ = 8.614737033843994, 
    Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`filling$$], {None, Axis, Top, Bottom}}}, 
    Typeset`size$$ = {360., {113., 117.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$6655$$ = 0, $CellContext`n2$6656$$ = 
    0, $CellContext`filling$6657$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`filling$$ = None, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$6655$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$6656$$, 0], 
        Hold[$CellContext`filling$$, $CellContext`filling$6657$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Filling -> $CellContext`filling$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`filling$$, {None, Axis, Top, Bottom}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {213., 218.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 433},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "The default behavior of ",
 StyleBox["Autorun", "DialogElementName"],
 " simulates something you could do yourself with the mouse, moving one \
control at a time. If you add the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AutorunSequencing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutorunSequencing"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " input, the ",
 StyleBox["Autorun", "DialogElementName"],
 " command in the resulting output will instead move all the controls \
simultaneously, as you can see in this example. This feature works better for \
some examples than for others."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n1", " ", "x"}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"n2", " ", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "filling"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"filling", ",", 
     RowBox[{"{", 
      RowBox[{"None", ",", "Axis", ",", "Top", ",", "Bottom"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", "All"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`filling$$ = Top, $CellContext`n1$$ = 
    12.46881141110407, $CellContext`n2$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Autorun", 
    Typeset`animator$$ = AnimatorBox[
     Dynamic[
     Typeset`animvar$$, (
      Typeset`animvar$$ = #; {$CellContext`n1$$, $CellContext`n2$$, \
$CellContext`filling$$} = Through[
         Manipulate`Dump`flis1$2396[Typeset`animvar$$]])& ], {0, 
      DirectedInfinity[1]}, ImageSize -> Small, DefaultDuration -> 5, 
     AnimationRate -> Automatic, 
     AppearanceElements -> {
      "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
       "DirectionButton"}], Typeset`animvar$$ = 5742.5055022239685`, 
    Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n1$$], 1, 20}, {
      Hold[$CellContext`n2$$], 1, 20}, {
      Hold[$CellContext`filling$$], {None, Axis, Top, Bottom}}}, 
    Typeset`size$$ = {360., {113., 117.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n1$17594144$$ = 0, $CellContext`n2$17594145$$ = 
    0, $CellContext`filling$17594146$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`filling$$ = None, $CellContext`n1$$ = 
        1, $CellContext`n2$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$17594144$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$17594145$$, 0], 
        Hold[$CellContext`filling$$, $CellContext`filling$17594146$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[Sin[$CellContext`n1$$ $CellContext`x] + 
        Sin[$CellContext`n2$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
        Filling -> $CellContext`filling$$, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`n1$$, 1, 20}, {$CellContext`n2$$, 1, 
         20}, {$CellContext`filling$$, {None, Axis, Top, Bottom}}}, 
      "Options" :> {AutorunSequencing -> All}, "DefaultOptions" :> {}],
     ImageSizeCache->{406., {210., 215.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{410, 427},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["AutorunSequencing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFormula"],
 " to exclude certain controls from the ",
 StyleBox["Autorun", "DialogElementName"],
 " animation, or change the order in which the controls are animated. In the \
following example, the third control is animated first, then the first \
control, then the fourth, and the second control is left at its default \
value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "4"}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`w$$ = 0, $CellContext`x$$ = 
    0, $CellContext`y$$ = 0.8120336532592776, $CellContext`z$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$, 
    Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`w$$], 0, 1}, {
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}}, Typeset`size$$ = {124.5625, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`w$17595664$$ = 0, $CellContext`x$17595665$$ = 
    0, $CellContext`y$17595666$$ = 0, $CellContext`z$17595667$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`w$$ = 0, $CellContext`x$$ = 
        0, $CellContext`y$$ = 0, $CellContext`z$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`w$$, $CellContext`w$17595664$$, 0], 
        Hold[$CellContext`x$$, $CellContext`x$17595665$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$17595666$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$17595667$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`w$$, $CellContext`x$$, $CellContext`y$$, \
$CellContext`z$$}, 
      "Specifications" :> {{$CellContext`w$$, 0, 1}, {$CellContext`x$$, 0, 
         1}, {$CellContext`y$$, 0, 1}, {$CellContext`z$$, 0, 1}}, 
      "Options" :> {AutorunSequencing -> {3, 1, 4}}, "DefaultOptions" :> {}],
     ImageSizeCache->{252., {89., 94.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{256, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AutorunSequencing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFormula"],
 " allows you to specify the duration reserved for the animation of a \
particular control. This setting reserves two seconds for the first control, \
two seconds for the third control, and ten seconds for the fourth control. \
The second control is skipped as before."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`w$$ = 0.299, $CellContext`x$$ = 
    0, $CellContext`y$$ = 0, $CellContext`z$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`w$$], 0, 1}, {
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}}, Typeset`size$$ = {103.5625, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`w$16034$$ = 0, $CellContext`x$16035$$ = 
    0, $CellContext`y$16036$$ = 0, $CellContext`z$16037$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`w$$ = 0, $CellContext`x$$ = 
        0, $CellContext`y$$ = 0, $CellContext`z$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`w$$, $CellContext`w$16034$$, 0], 
        Hold[$CellContext`x$$, $CellContext`x$16035$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$16036$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$16037$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`w$$, $CellContext`x$$, $CellContext`y$$, \
$CellContext`z$$}, 
      "Specifications" :> {{$CellContext`w$$, 0, 1}, {$CellContext`x$$, 0, 
         1}, {$CellContext`y$$, 0, 1}, {$CellContext`z$$, 0, 1}}, 
      "Options" :> {AutorunSequencing -> {{1, 2}, {3, 2}, {4, 10}}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{252., {89., 94.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{256, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "One reason to care about the details of ",
 Cell[BoxData[
  ButtonBox["AutorunSequencing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFormula"],
 " is that it is possible to use the ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " command to automatically generate an animation video (in, for example, \
QuickTime or Flash format). By default ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " will generate an animation by running the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " through one ",
 StyleBox["Autorun", "DialogElementName"],
 " cycle."
}], "Text"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["AutorunSequencing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFormula"],
 " does not give you enough control over the animation sequence, you can use \
the ",
 StyleBox["Bookmarks", "DialogElementName"],
 " feature described in the next section to define a list of \"way points\", \
combinations of parameter values, and then create an animation that smoothly \
interpolates through those defined points. This allows complete control over \
the exact path of the animation."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bookmarking Combinations of Parameter Values", "Section"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " functions, particularly when they have many controls, can be used to find \
a needle in a haystack: a particular combination of multiple parameter values \
that yields a particularly interesting result. When you have found a set of \
values like that, you might want to save it for future reference. ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " provides several features for doing this through the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CirclePlusIcon"],
   ImageSizeCache->{10., {3., 7.}}]], "Output"],
 " menu in the top-right corner of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output."
}], "Text"],

Cell[TextData[{
 "To get a single value out into a form you can use as a static input, use \
the ",
 StyleBox["Paste Snapshot", "DialogElementName"],
 " command from the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CirclePlusIcon"],
   ImageSizeCache->{10., {3., 7.}}]], "Output"],
 " menu. The result will be inserted as a new cell below the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.37, $CellContext`y$$ = 
    0.506, $CellContext`z$$ = 0.29, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}}, Typeset`size$$ = {127.375, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$16404$$ = 0, $CellContext`y$16405$$ = 
    0, $CellContext`z$16406$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        0, $CellContext`z$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$16404$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$16405$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$16406$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}, {$CellContext`z$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Here is the result of using ",
 StyleBox["Paste Snapshot", "DialogElementName"],
 " with this example."
}], "Text"],

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "=", "0.37"}], ",", " ", 
     RowBox[{"y", " ", "=", " ", "0.506"}], ",", " ", 
     RowBox[{"z", " ", "=", " ", "0.29"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}]}], "]"}]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False],

Cell[TextData[{
 "The three current values have been copied into the variable definition \
block of a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ", and the first argument has been copied into the body. (",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is used because in cases where the body contains explicit uses of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " this will result in more correct functioning. Depending on what you want \
to do with the result you are of course free to replace ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " without needing to make any other changes to the expression. Or you can \
copy/paste the block of assignments into other code you are building, etc. \
The differences between Module and DynamicModule are discussed in further \
detail in \"",
 ButtonBox["Advanced Dynamic Functionality",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"],
 "\".)"
}], "Text"],

Cell[TextData[{
 "If, instead of immediately extracting that location, you just want to \
remember it so that ",
 "it is",
 " easy to visit in the future, select ",
 StyleBox["Add To Bookmarks", "DialogElementName"],
 " from the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CirclePlusIcon"],
   ImageSizeCache->{10., {3., 7.}}]], "Output"],
 " menu. That will bring up a panel that will let you name the bookmark and \
add it to list of bookmarks which are known to this ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " by clicking the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CompactAddButton"],
   ImageSizeCache->{26., {4., 9.}}]], "Output"],
 " button, or cancel the addition by clicking the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CompactCloseButton"],
   ImageSizeCache->{32., {4., 9.}}]], "Output"],
 " button."
}], "Text"],

Cell[TextData[{
 "After adding a bookmark, the name you have specified for it will appear in \
the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CirclePlusIcon"],
   ImageSizeCache->{10., {3., 7.}}]], "Output"],
 " menu. Selecting its name from that menu will cause all the parameters to \
snap back to the values they had when that bookmark was added. Also note that \
every ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " remembers the initial settings of all its controls, and you can snap back \
to those values by choosing ",
 StyleBox["Initial Settings", "DialogElementName"],
 " in this menu."
}], "Text"],

Cell[TextData[{
 "Once you start placing bookmarks, there are a two other items in the ",
 Cell[BoxData[
  DynamicBox[FrontEndResource["FEBitmaps", "CirclePlusIcon"],
   ImageSizeCache->{10., {3., 7.}}]], "Output"],
 " menu which become relevant: ",
 StyleBox["Paste Bookmarks", "DialogElementName"],
 " and ",
 StyleBox["Animate Bookmarks", "DialogElementName"],
 "."
}], "Text"],

Cell[TextData[{
 "Bookmarks are lists of locations in a given parameter space, and you can \
extract the raw data in that list by choosing the ",
 StyleBox["Paste Bookmarks", "DialogElementName"],
 " item. Every element of the resulting list is of the form ",
 Cell[BoxData[
  RowBox[{"bookmarkName", ":>", "parameterValues"}]], "InlineFormula"],
 ". This list is syntactically appropriate for reinserting into ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " input as the setting for the ",
 Cell[BoxData["Bookmarks"], "InlineFormula"],
 " option. (This allows you to, for example, modify the bookmarks by manual \
editing, or run a program on them, before restoring them as active bookmarks \
in a new ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output.)"
}], "Text"],

Cell[TextData[{
 "The ",
 StyleBox["Animate Bookmarks", "DialogElementName"],
 " menu command works much like the ",
 StyleBox["Autorun", "DialogElementName"],
 " command described in the previous section, except that instead of \
animating each parameter through its range of values, it creates an animation \
that interpolates through the points specified by the bookmarks."
}], "Text"],

Cell[TextData[{
 "The interpolation which occurs when animating bookmarks is done internally \
via the ",
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 " command. ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " even accepts the ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " option to adjust how the animation proceeds from one point to the next. \
The default value of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " performs quadratic interpolation if there are enough bookmarks, and linear \
otherwise."
}], "Text"],

Cell[TextData[{
 "When a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output containing explicit bookmarks is exported to a video animation \
format using ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ", the resulting video will be one cycle through the sequence generated by \
",
 StyleBox["Animate Bookmarks", "DialogElementName"],
 ". (If no bookmarks are present, the result is one cycle of ",
 StyleBox["Autorun", "DialogElementName"],
 ".)"
}], "Text"],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DynamicInteractivityLanguage"]], "TutorialMoreAbout",
 CellID->346793833],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Advanced Manipulate Functionality",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AdvancedManipulateFunctionality"]], "RelatedTutorials",
 CellID->32204359],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "RelatedTutorials",
 CellID->546467600]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Manipulate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 7.6624922}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "The single command Manipulate lets you create an astonishing range of \
interactive applications with just a few lines of input. Manipulate is \
designed to be used by anyone who is comfortable using basic commands such as \
Table and Plot: it does not require learning any complicated new concepts, \
nor any understanding of user interface programing ideas. The output you get \
from evaluating a Manipulate command is an interactive object containing one \
or more controls (sliders, etc.) that you can use to vary the value of one or \
more parameters. The output is very much like a small applet or widget: it is \
not just a static result, it is a running program you can interact with. This \
tutorial is designed for people who are familiar with the basics of using the \
Mathematica language, including how to use functions, the various kinds of \
brackets and braces, and how to make simple plots. Some of the examples will \
use more advanced functions, but it is not necessary to understand exactly \
how these work in order to get the point of the example.", "synonyms" -> {}, 
    "title" -> "Introduction to Manipulate", "type" -> "Tutorial", "uri" -> 
    "tutorial/IntroductionToManipulate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1626, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2251, 66, 43, 0, 70, "Title"],
Cell[2297, 68, 849, 25, 70, "Text"],
Cell[3149, 95, 489, 12, 70, "Text"],
Cell[3641, 109, 458, 11, 70, "Text"],
Cell[4102, 122, 338, 7, 70, "Text"],
Cell[CellGroupData[{
Cell[4465, 133, 49, 0, 70, "Section"],
Cell[4517, 135, 556, 18, 70, "Text"],
Cell[CellGroupData[{
Cell[5098, 157, 141, 4, 28, "Input"],
Cell[5242, 163, 365, 9, 36, "Output"]
}, Open  ]],
Cell[5622, 175, 466, 15, 70, "Text"],
Cell[CellGroupData[{
Cell[6113, 194, 146, 4, 70, "Input"],
Cell[6262, 200, 1493, 32, 70, "Output"]
}, Open  ]],
Cell[7770, 235, 568, 10, 70, "Text"],
Cell[8341, 247, 582, 20, 70, "Text"],
Cell[8926, 269, 656, 19, 70, "Text"],
Cell[CellGroupData[{
Cell[9607, 292, 350, 11, 70, "Input"],
Cell[9960, 305, 1560, 33, 70, "Output"]
}, Open  ]],
Cell[11535, 341, 158, 3, 70, "Text"],
Cell[11696, 346, 195, 4, 70, "Text"],
Cell[11894, 352, 1580, 33, 70, "Output"],
Cell[13477, 387, 148, 3, 70, "Text"],
Cell[13628, 392, 455, 11, 70, "Text"],
Cell[CellGroupData[{
Cell[14108, 407, 418, 13, 70, "Input"],
Cell[14529, 422, 1632, 34, 70, "Output"]
}, Open  ]],
Cell[16176, 459, 460, 13, 70, "Text"],
Cell[16639, 474, 357, 13, 70, "Text"],
Cell[CellGroupData[{
Cell[17021, 491, 564, 17, 70, "Input"],
Cell[17588, 510, 1905, 40, 70, "Output"]
}, Open  ]],
Cell[19508, 553, 305, 9, 70, "Text"],
Cell[CellGroupData[{
Cell[19838, 566, 1072, 33, 70, "Input"],
Cell[20913, 601, 2880, 56, 70, "Output"]
}, Open  ]],
Cell[23808, 660, 174, 3, 70, "Text"],
Cell[23985, 665, 587, 16, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24609, 686, 49, 0, 70, "Section"],
Cell[24661, 688, 527, 16, 70, "Text"],
Cell[25191, 706, 957, 25, 70, "Text"],
Cell[CellGroupData[{
Cell[26173, 735, 141, 4, 70, "Input"],
Cell[26317, 741, 365, 9, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26719, 755, 146, 4, 70, "Input"],
Cell[26868, 761, 1494, 32, 70, "Output"]
}, Open  ]],
Cell[28377, 796, 324, 9, 70, "Text"],
Cell[CellGroupData[{
Cell[28726, 809, 272, 8, 70, "Input"],
Cell[29001, 819, 1563, 33, 70, "Output"]
}, Open  ]],
Cell[30579, 855, 555, 17, 70, "Text"],
Cell[CellGroupData[{
Cell[31159, 876, 156, 4, 70, "Input"],
Cell[31318, 882, 1495, 32, 70, "Output"]
}, Open  ]],
Cell[32828, 917, 222, 8, 70, "Text"],
Cell[CellGroupData[{
Cell[33075, 929, 282, 8, 70, "Input"],
Cell[33360, 939, 1566, 33, 70, "Output"]
}, Open  ]],
Cell[34941, 975, 552, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[35518, 993, 283, 8, 70, "Input"],
Cell[35804, 1003, 1567, 33, 70, "Output"]
}, Open  ]],
Cell[37386, 1039, 234, 4, 70, "Text"],
Cell[37623, 1045, 517, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[38165, 1063, 549, 16, 70, "Input"],
Cell[38717, 1081, 2112, 48, 70, "Output"]
}, Open  ]],
Cell[40844, 1132, 130, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[40999, 1139, 487, 14, 70, "Input"],
Cell[41489, 1155, 2166, 45, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43704, 1206, 36, 0, 70, "Section"],
Cell[43743, 1208, 362, 8, 70, "Text"],
Cell[44108, 1218, 556, 14, 70, "Text"],
Cell[44667, 1234, 466, 14, 70, "Text"],
Cell[45136, 1250, 174, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[45335, 1257, 774, 23, 70, "Input"],
Cell[46112, 1282, 2236, 45, 70, "Output"]
}, Open  ]],
Cell[48363, 1330, 245, 7, 70, "Text"],
Cell[CellGroupData[{
Cell[48633, 1341, 922, 26, 70, "Input"],
Cell[49558, 1369, 2334, 47, 70, "Output"]
}, Open  ]],
Cell[51907, 1419, 337, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[52269, 1437, 737, 22, 70, "Input"],
Cell[53009, 1461, 2195, 44, 70, "Output"]
}, Open  ]],
Cell[55219, 1508, 583, 15, 70, "Text"],
Cell[55805, 1525, 403, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[56233, 1541, 981, 28, 70, "Input"],
Cell[57217, 1571, 2348, 47, 70, "Output"]
}, Open  ]],
Cell[59580, 1621, 997, 28, 70, "Text"],
Cell[CellGroupData[{
Cell[60602, 1653, 987, 28, 70, "Input"],
Cell[61592, 1683, 2354, 48, 70, "Output"]
}, Open  ]],
Cell[63961, 1734, 632, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[64618, 1750, 1022, 30, 70, "Input"],
Cell[65643, 1782, 2365, 48, 70, "Output"]
}, Open  ]],
Cell[68023, 1833, 1023, 31, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69083, 1869, 44, 0, 70, "Section"],
Cell[69130, 1871, 67, 0, 70, "Text"],
Cell[CellGroupData[{
Cell[69222, 1875, 1238, 36, 70, "Input"],
Cell[70463, 1913, 2875, 57, 70, "Output"]
}, Open  ]],
Cell[73353, 1973, 688, 19, 70, "Text"],
Cell[74044, 1994, 165, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[74234, 2001, 1425, 43, 70, "Input"],
Cell[75662, 2046, 2986, 60, 70, "Output"]
}, Open  ]],
Cell[78663, 2109, 801, 18, 70, "Text"],
Cell[79467, 2129, 584, 14, 70, "Text"],
Cell[80054, 2145, 662, 19, 70, "Text"],
Cell[80719, 2166, 640, 20, 70, "Text"],
Cell[81362, 2188, 53, 0, 70, "Text"],
Cell[CellGroupData[{
Cell[81440, 2192, 1734, 55, 70, "Input"],
Cell[83177, 2249, 3213, 63, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86439, 2318, 47, 0, 70, "Section"],
Cell[86489, 2320, 1629, 45, 70, "Text"],
Cell[88121, 2367, 604, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[88750, 2387, 1797, 56, 70, "Input"],
Cell[90550, 2445, 3237, 63, 70, "Output"]
}, Open  ]],
Cell[93802, 2511, 549, 14, 70, "Text"],
Cell[94354, 2527, 466, 10, 70, "Text"],
Cell[CellGroupData[{
Cell[94845, 2541, 1902, 56, 70, "Input"],
Cell[96750, 2599, 3257, 63, 70, "Output"]
}, Open  ]],
Cell[100022, 2665, 118, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[100165, 2672, 1893, 55, 70, "Input"],
Cell[102061, 2729, 3383, 66, 70, "Output"]
}, Open  ]],
Cell[105459, 2798, 414, 9, 70, "Text"],
Cell[CellGroupData[{
Cell[105898, 2811, 2037, 59, 70, "Input"],
Cell[107938, 2872, 3477, 69, 70, "Output"]
}, Open  ]],
Cell[111430, 2944, 246, 6, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111713, 2955, 29, 0, 70, "Section"],
Cell[111745, 2957, 363, 9, 70, "Text"],
Cell[112111, 2968, 750, 28, 70, "Text"],
Cell[112864, 2998, 318, 9, 70, "Text"],
Cell[CellGroupData[{
Cell[113207, 3011, 299, 10, 70, "Input"],
Cell[113509, 3023, 1584, 32, 70, "Output"]
}, Open  ]],
Cell[115108, 3058, 134, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[115267, 3065, 533, 17, 70, "Input"],
Cell[115803, 3084, 1682, 35, 70, "Output"]
}, Open  ]],
Cell[117500, 3122, 254, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[117779, 3130, 2264, 71, 70, "Input"],
Cell[120046, 3203, 2677, 53, 70, "Output"]
}, Open  ]],
Cell[122738, 3259, 346, 10, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123121, 3274, 43, 0, 70, "Section"],
Cell[123167, 3276, 473, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[123665, 3292, 533, 17, 70, "Input"],
Cell[124201, 3311, 1683, 35, 70, "Output"]
}, Open  ]],
Cell[125899, 3349, 1462, 46, 70, "Text"],
Cell[127364, 3397, 308, 7, 70, "Text"],
Cell[CellGroupData[{
Cell[127697, 3408, 1119, 36, 70, "Input"],
Cell[128819, 3446, 2072, 44, 70, "Output"]
}, Open  ]],
Cell[130906, 3493, 109, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[131040, 3500, 1314, 38, 70, "Input"],
Cell[132357, 3540, 2654, 54, 70, "Output"]
}, Open  ]],
Cell[135026, 3597, 768, 22, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135831, 3624, 26, 0, 70, "Section"],
Cell[135860, 3626, 466, 13, 70, "Text"],
Cell[136329, 3641, 810, 20, 70, "Text"],
Cell[CellGroupData[{
Cell[137164, 3665, 1076, 35, 70, "Input"],
Cell[138243, 3702, 2000, 42, 70, "Output"]
}, Open  ]],
Cell[140258, 3747, 285, 5, 70, "Text"],
Cell[140546, 3754, 470, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[141041, 3772, 854, 30, 70, "Input"],
Cell[141898, 3804, 2057, 40, 70, "Output"]
}, Open  ]],
Cell[143970, 3847, 309, 8, 70, "Text"],
Cell[144282, 3857, 325, 10, 70, "Text"],
Cell[CellGroupData[{
Cell[144632, 3871, 618, 20, 70, "Input"],
Cell[145253, 3893, 1743, 36, 70, "Output"]
}, Open  ]],
Cell[147011, 3932, 280, 7, 70, "Text"],
Cell[147294, 3941, 1436, 43, 70, "Text"],
Cell[148733, 3986, 966, 28, 70, "Text"],
Cell[CellGroupData[{
Cell[149724, 4018, 685, 22, 70, "Input"],
Cell[150412, 4042, 1822, 37, 70, "Output"]
}, Open  ]],
Cell[152249, 4082, 441, 13, 70, "Text"],
Cell[CellGroupData[{
Cell[152715, 4099, 1440, 41, 70, "Input"],
Cell[154158, 4142, 3029, 64, 70, "Output"]
}, Open  ]],
Cell[157202, 4209, 385, 6, 70, "Text"],
Cell[157590, 4217, 466, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[158081, 4233, 1387, 42, 70, "Input"],
Cell[159471, 4277, 3100, 58, 70, "Output"]
}, Open  ]],
Cell[162586, 4338, 454, 9, 70, "Text"],
Cell[CellGroupData[{
Cell[163065, 4351, 729, 23, 70, "Input"],
Cell[163797, 4376, 2550, 50, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[166396, 4432, 30, 0, 70, "Section"],
Cell[166429, 4434, 300, 8, 70, "Text"],
Cell[CellGroupData[{
Cell[166754, 4446, 410, 12, 70, "Input"],
Cell[167167, 4460, 1627, 35, 70, "Output"]
}, Open  ]],
Cell[168809, 4498, 459, 12, 70, "Text"],
Cell[169271, 4512, 1095, 25, 70, "Text"],
Cell[170369, 4539, 1258, 34, 70, "Text"],
Cell[171630, 4575, 297, 6, 70, "Text"],
Cell[CellGroupData[{
Cell[171952, 4585, 1126, 36, 70, "Input"],
Cell[173081, 4623, 2207, 44, 70, "Output"]
}, Open  ]],
Cell[175303, 4670, 136, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[175464, 4677, 914, 23, 70, "Input"],
Cell[176381, 4702, 2303, 45, 70, "Output"]
}, Open  ]],
Cell[178699, 4750, 112, 3, 70, "Text"],
Cell[178814, 4755, 910, 25, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179761, 4785, 52, 0, 70, "Section"],
Cell[179816, 4787, 694, 22, 70, "Text"],
Cell[180513, 4811, 660, 23, 70, "Text"],
Cell[CellGroupData[{
Cell[181198, 4838, 601, 17, 70, "Input"],
Cell[181802, 4857, 1857, 38, 70, "Output"]
}, Open  ]],
Cell[183674, 4898, 626, 17, 70, "Text"],
Cell[CellGroupData[{
Cell[184325, 4919, 1059, 29, 70, "Input"],
Cell[185387, 4950, 2260, 45, 70, "Output"]
}, Open  ]],
Cell[187662, 4998, 1058, 34, 70, "Text"],
Cell[CellGroupData[{
Cell[188745, 5036, 926, 28, 70, "Input"],
Cell[189674, 5066, 2389, 50, 70, "Output"]
}, Open  ]],
Cell[192078, 5119, 697, 18, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192812, 5142, 73, 0, 70, "Section"],
Cell[192888, 5144, 230, 7, 70, "Text"],
Cell[193121, 5153, 102, 3, 70, "Input"],
Cell[CellGroupData[{
Cell[193248, 5160, 176, 5, 70, "Input"],
Cell[193427, 5167, 1536, 33, 70, "Output"]
}, Open  ]],
Cell[194978, 5203, 711, 19, 70, "Text"],
Cell[195692, 5224, 1303, 39, 70, "Text"],
Cell[196998, 5265, 102, 3, 70, "Input"],
Cell[CellGroupData[{
Cell[197125, 5272, 233, 6, 70, "Input"],
Cell[197361, 5280, 1746, 37, 70, "Output"]
}, Open  ]],
Cell[199122, 5320, 201, 6, 70, "Text"],
Cell[199326, 5328, 526, 14, 70, "Text"],
Cell[199855, 5344, 1173, 34, 70, "Text"],
Cell[201031, 5380, 391, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[201447, 5396, 348, 10, 70, "Input"],
Cell[201798, 5408, 1674, 36, 70, "Output"]
}, Open  ]],
Cell[203487, 5447, 792, 22, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204316, 5474, 41, 0, 70, "Section"],
Cell[204360, 5476, 480, 10, 70, "Text"],
Cell[204843, 5488, 801, 23, 70, "Text"],
Cell[205647, 5513, 665, 15, 70, "Text"],
Cell[206315, 5530, 573, 12, 70, "Text"],
Cell[206891, 5544, 419, 7, 70, "Text"],
Cell[CellGroupData[{
Cell[207335, 5555, 764, 23, 70, "Input"],
Cell[208102, 5580, 2443, 49, 70, "Output"]
}, Open  ]],
Cell[210560, 5632, 1097, 27, 70, "Text"],
Cell[211660, 5661, 268, 5, 70, "Text"],
Cell[211931, 5668, 733, 13, 70, "Text"],
Cell[212667, 5683, 359, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[213051, 5699, 847, 25, 70, "Input"],
Cell[213901, 5726, 2497, 50, 70, "Output"]
}, Open  ]],
Cell[216413, 5779, 447, 7, 70, "Text"],
Cell[216863, 5788, 454, 11, 70, "Text"],
Cell[217320, 5801, 245, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[217590, 5809, 2406, 72, 70, "Input"],
Cell[219999, 5883, 2386, 48, 70, "Output"]
}, Open  ]],
Cell[222400, 5934, 818, 17, 70, "Text"],
Cell[223221, 5953, 879, 22, 70, "Text"],
Cell[224103, 5977, 779, 20, 70, "Text"],
Cell[CellGroupData[{
Cell[224907, 6001, 2493, 74, 70, "Input"],
Cell[227403, 6077, 2506, 51, 70, "Output"]
}, Open  ]],
Cell[229924, 6131, 532, 13, 70, "Text"],
Cell[230459, 6146, 641, 20, 70, "Text"],
Cell[CellGroupData[{
Cell[231125, 6170, 534, 17, 70, "Input"],
Cell[231662, 6189, 1692, 35, 70, "Output"]
}, Open  ]],
Cell[233369, 6227, 1016, 27, 70, "Text"],
Cell[CellGroupData[{
Cell[234410, 6258, 744, 23, 70, "Input"],
Cell[235157, 6283, 2007, 42, 70, "Output"]
}, Open  ]],
Cell[237179, 6328, 651, 17, 70, "Text"],
Cell[CellGroupData[{
Cell[237855, 6349, 817, 25, 70, "Input"],
Cell[238675, 6376, 2040, 42, 70, "Output"]
}, Open  ]],
Cell[240730, 6421, 733, 17, 70, "Text"],
Cell[241466, 6440, 719, 21, 70, "Text"],
Cell[242188, 6463, 368, 9, 70, "Text"],
Cell[CellGroupData[{
Cell[242581, 6476, 185, 5, 70, "Input"],
Cell[242769, 6483, 1548, 33, 70, "Output"]
}, Open  ]],
Cell[244332, 6519, 212, 6, 70, "Text"],
Cell[CellGroupData[{
Cell[244569, 6529, 186, 5, 70, "Input"],
Cell[244758, 6536, 1533, 33, 70, "Output"]
}, Open  ]],
Cell[246306, 6572, 584, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[246915, 6592, 581, 18, 70, "Input"],
Cell[247499, 6612, 1698, 35, 70, "Output"]
}, Open  ]],
Cell[249212, 6650, 962, 23, 70, "Text"],
Cell[CellGroupData[{
Cell[250199, 6677, 628, 19, 70, "Input"],
Cell[250830, 6698, 1757, 37, 70, "Output"]
}, Open  ]],
Cell[252602, 6738, 465, 10, 70, "Text"],
Cell[CellGroupData[{
Cell[253092, 6752, 1215, 36, 70, "Input"],
Cell[254310, 6790, 2275, 46, 70, "Output"]
}, Open  ]],
Cell[256600, 6839, 328, 8, 70, "Text"],
Cell[256931, 6849, 679, 18, 70, "Text"],
Cell[CellGroupData[{
Cell[257635, 6871, 582, 18, 70, "Input"],
Cell[258220, 6891, 1685, 35, 70, "Output"]
}, Open  ]],
Cell[259920, 6929, 402, 8, 70, "Text"],
Cell[260325, 6939, 257, 5, 70, "Text"],
Cell[260585, 6946, 625, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[261235, 6966, 69, 1, 70, "Input"],
Cell[261307, 6969, 45637, 946, 70, "Output"]
}, Open  ]],
Cell[306959, 7918, 732, 16, 70, "Text"],
Cell[307694, 7936, 351, 7, 70, "Text"],
Cell[CellGroupData[{
Cell[308070, 7947, 69, 1, 70, "Input"],
Cell[308142, 7950, 45858, 948, 70, "Output"]
}, Open  ]],
Cell[354015, 8901, 498, 12, 70, "Text"],
Cell[354516, 8915, 810, 22, 70, "Text"],
Cell[CellGroupData[{
Cell[355351, 8941, 667, 20, 70, "Input"],
Cell[356021, 8963, 1899, 41, 70, "Output"]
}, Open  ]],
Cell[357935, 9007, 257, 8, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[358229, 9020, 26, 0, 70, "Section"],
Cell[358258, 9022, 1040, 28, 70, "Text"],
Cell[359301, 9052, 505, 13, 70, "Text"],
Cell[359809, 9067, 1130, 27, 70, "Text"],
Cell[CellGroupData[{
Cell[360964, 9098, 774, 23, 70, "Input"],
Cell[361741, 9123, 2690, 54, 70, "Output"]
}, Open  ]],
Cell[364446, 9180, 835, 23, 70, "Text"],
Cell[CellGroupData[{
Cell[365306, 9207, 832, 24, 70, "Input"],
Cell[366141, 9233, 2760, 55, 70, "Output"]
}, Open  ]],
Cell[368916, 9291, 506, 12, 70, "Text"],
Cell[CellGroupData[{
Cell[369447, 9307, 548, 15, 70, "Input"],
Cell[369998, 9324, 2279, 46, 70, "Output"]
}, Open  ]],
Cell[372292, 9373, 434, 9, 70, "Text"],
Cell[CellGroupData[{
Cell[372751, 9386, 714, 21, 70, "Input"],
Cell[373468, 9409, 2269, 47, 70, "Output"]
}, Open  ]],
Cell[375752, 9459, 840, 25, 70, "Text"],
Cell[376595, 9486, 574, 13, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[377206, 9504, 63, 0, 70, "Section"],
Cell[377272, 9506, 941, 23, 70, "Text"],
Cell[378216, 9531, 509, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[378750, 9549, 342, 10, 70, "Input"],
Cell[379095, 9561, 1997, 42, 70, "Output"]
}, Open  ]],
Cell[381107, 9606, 133, 4, 70, "Text"],
Cell[381243, 9612, 390, 11, 70, "Input"],
Cell[381636, 9625, 1640, 46, 70, "Text"],
Cell[383279, 9673, 970, 25, 70, "Text"],
Cell[384252, 9700, 709, 17, 70, "Text"],
Cell[384964, 9719, 380, 10, 70, "Text"],
Cell[385347, 9731, 934, 22, 70, "Text"],
Cell[386284, 9755, 388, 8, 70, "Text"],
Cell[386675, 9765, 860, 25, 70, "Text"],
Cell[387538, 9792, 615, 18, 70, "Text"],
Cell[CellGroupData[{
Cell[388178, 9814, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->23220180],
Cell[388246, 9817, 181, 4, 70, "TutorialMoreAbout",
 CellID->346793833],
Cell[388430, 9823, 161, 3, 70, "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],
Cell[CellGroupData[{
Cell[388628, 9831, 72, 1, 70, "RelatedTutorialsSection",
 CellID->415694126],
Cell[388703, 9834, 188, 4, 70, "RelatedTutorials",
 CellID->32204359],
Cell[388894, 9840, 166, 3, 70, "RelatedTutorials",
 CellID->546467600]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[389099, 9848, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

