(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     67481,       1659]
NotebookOptionsPosition[     61415,       1473]
NotebookOutlinePosition[     64440,       1549]
CellTagsIndexPosition[     64344,       1543]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
          "Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
          "Axes" :> Documentation`HelpLookup["paclet:ref/Axes"], "AxesEdge" :> 
          Documentation`HelpLookup["paclet:ref/AxesEdge"], "AxesLabel" :> 
          Documentation`HelpLookup["paclet:ref/AxesLabel"], "AxesStyle" :> 
          Documentation`HelpLookup["paclet:ref/AxesStyle"], "Boxed" :> 
          Documentation`HelpLookup["paclet:ref/Boxed"], "BoxStyle" :> 
          Documentation`HelpLookup["paclet:ref/BoxStyle"], "FaceGrids" :> 
          Documentation`HelpLookup["paclet:ref/FaceGrids"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "PlotLabel" :> 
          Documentation`HelpLookup["paclet:ref/PlotLabel"], "Ticks" :> 
          Documentation`HelpLookup["paclet:ref/Ticks"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"Automatic\"\>", 
       3->"\<\"Axes\"\>", 4->"\<\"AxesEdge\"\>", 5->"\<\"AxesLabel\"\>", 
       6->"\<\"AxesStyle\"\>", 7->"\<\"Boxed\"\>", 8->"\<\"BoxStyle\"\>", 
       9->"\<\"FaceGrids\"\>", 10->"\<\"False\"\>", 11->"\<\"None\"\>", 
       12->"\<\"PlotLabel\"\>", 13->"\<\"Ticks\"\>", 
       14->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Labeling Three\[Hyphen]Dimensional Graphics\
\>", "Title",
 CellTags->{"S2.10.13", "13.1"},
 CellID->21590],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides various options for labeling three\[Hyphen]dimensional graphics. \
Some of these options are directly analogous to those for \
two\[Hyphen]dimensional graphics, discussed in \"",
 ButtonBox["Labeling Two-Dimensional Graphics\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LabelingTwoDimensionalGraphics"],
 ". Others are different. "
}], "Text",
 CellID->12891],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Boxed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Boxed"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[
    "draw a cuboidal bounding box around the graphics (default)", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Axes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Axes"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[TextData[{
     "draw ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " axes on the edges of the box"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Axes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Axes"], "->", "{", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], ",", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], ",", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "}"}], Cell[TextData[{
     "draw the ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " axis only"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FaceGrids",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceGrids"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[
    "draw grid lines on the faces of the box", "TableText"]},
   {
    RowBox[{
     ButtonBox["PlotLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlotLabel"], "->", 
     StyleBox["text", "TI"]}], Cell[
    "give an overall label for the plot", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30369],

Cell["\<\
Some options for labeling three\[Hyphen]dimensional graphics. \
\>", "Caption",
 CellID->1538],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " is to include a box, but no other forms of labeling. "
}], "MathCaption",
 CellID->32212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->10991],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->819550548]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " adds ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axes. "
}], "MathCaption",
 CellID->23409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->11620],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->312375221]
}, Open  ]],

Cell["This adds grid lines to each face of the box. ", "MathCaption",
 CellID->22662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"FaceGrids", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->25128],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
      Rational[1, 2]}, {
     0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
       Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
       Rational[1, 2], 
      Rational[-1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
       Rational[1, 2], Rational[
      1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
      Rational[1, 2], Rational[-1, 2], 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
      Rational[1, 2], Rational[1, 2], 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2], 0, 
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
      Rational[1, 2]}, {
     Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
     0, 0, -1.4012585384440737`}, {0.17841104488654497`, -1.3090169943749475`,
      0.46708617948135783`}, {0.17841104488654497`, 1.3090169943749475`, 
     0.46708617948135783`}, {
     0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, {
     0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
     1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
     1.0444364486709836`, 0.8090169943749475, 
     0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
     0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
     0.46708617948135783`}, {
     1.2228474935575286`, -0.5, -0.46708617948135783`}, {1.2228474935575286`, 
     0.5, -0.46708617948135783`}, {-0.9341723589627157, 
      0, -1.0444364486709836`}, {-0.46708617948135783`, -0.8090169943749475, 
     1.0444364486709836`}, {-0.46708617948135783`, 0.8090169943749475, 
     1.0444364486709836`}, {
     0.9341723589627157, 0, 
      1.0444364486709836`}, {-1.0444364486709836`, -0.8090169943749475, \
-0.46708617948135783`}, {-1.0444364486709836`, 
     0.8090169943749475, -0.46708617948135783`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
     1.3090169943749475`, -0.46708617948135783`}}], 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]],
  Axes->True,
  FaceGrids->All]], "Output",
 ImageSize->{184, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->513393206,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BoxStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BoxStyle"], "->", 
     StyleBox["style", "TI"]}], Cell[
    "specify the style for the box", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesStyle"], "->", 
     StyleBox["style", "TI"]}], Cell[
    "specify the style for axes", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesStyle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesStyle"], "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["xstyle", "TI"], ",", 
       StyleBox["ystyle", "TI"], ",", 
       StyleBox["zstyle", "TI"]}], "}"}]}], Cell[
    "specify separate styles for each axis", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32759],

Cell["Style options. ", "Caption",
 CellID->10842],

Cell["\<\
This makes the box dashed, and draws axes which are thicker than normal. \
\>", "MathCaption",
 CellID->18440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], ",", 
   RowBox[{"BoxStyle", "->", 
    RowBox[{"Dashing", "[", 
     RowBox[{"{", 
      RowBox[{"0.02", ",", "0.02"}], "}"}], "]"}]}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Thickness", "[", "0.01", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->1787503252],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->417535150]
}, Open  ]],

Cell[TextData[{
 "By setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", you tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to draw axes on the edges of the three\[Hyphen]dimensional box. However, \
for each axis, there are in principle four possible edges on which it can be \
drawn. The option ",
 Cell[BoxData[
  ButtonBox["AxesEdge",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesEdge"]], "InlineFormula"],
 " allows you to specify on which edge to draw each of the axes. "
}], "Text",
 CellID->22642],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AxesEdge",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesEdge"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "use an internal algorithm to choose where to draw all axes", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesEdge",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesEdge"], "->", "{", 
     StyleBox["xspec", "TI"], ",", 
     StyleBox["yspec", "TI"], ",", 
     StyleBox["zspec", "TI"], "}"}], Cell[TextData[{
     "give separate specifications for each of the ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " axes"
    }], "TableText"]},
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "do not draw this axis", "TableText"]},
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "decide automatically where to draw this axis", "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["dir", "TI"], 
      StyleBox["i", "TI"]], ",", 
     SubscriptBox[
      StyleBox["dir", "TI"], 
      StyleBox["j", "TI"]], "}"}], Cell["\<\
specify on which of the four possible edges to draw this axis\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31620],

Cell["\<\
Specifying where to draw three\[Hyphen]dimensional axes. \
\>", "Caption",
 CellID->21486],

Cell[TextData[{
 "This draws the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " on the edge with larger ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " coordinates, draws no ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis, and chooses automatically where to draw the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis. "
}], "MathCaption",
 CellID->6146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesEdge", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "None", ",", "Automatic"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->27964],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->660386269]
}, Open  ]],

Cell[TextData[{
 "When you draw the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis on a three\[Hyphen]dimensional box, there are four possible edges on \
which the axis can be drawn. These edges are distinguished by having larger \
or smaller ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " coordinates. When you use the specification ",
 Cell[BoxData["{"], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "y"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "z"], TraditionalForm]], "InlineMath"],
 Cell[BoxData["}"], "InlineFormula"],
 " for where to draw the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis, you can set the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "i"], TraditionalForm]], "InlineMath"],
 " to be ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " to represent larger or smaller values for the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " coordinates. "
}], "Text",
 CellID->1271],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AxesLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesLabel"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "give no axis labels", "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesLabel"], "->", 
     StyleBox["zlabel", "TI"]}], Cell[TextData[{
     "put a label on the ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " axis"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AxesLabel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AxesLabel"], "->", "{", 
     StyleBox["xlabel", "TI"], ",", 
     StyleBox["ylabel", "TI"], ",", 
     StyleBox["zlabel", "TI"], "}"}], Cell[
    "put labels on all three axes", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30943],

Cell["\<\
Axis labels in three\[Hyphen]dimensional graphics. \
\>", "Caption",
 CellID->9466],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["AxesLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesLabel"]], "InlineFormula"],
 " to label edges of the box, without necessarily drawing scales on them. "
}], "MathCaption",
 CellID->21474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Image\>\""}], "]"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
   
   RowBox[{"Ticks", "->", "None"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->3445],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->167976081]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Ticks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ticks"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "draw no tick marks", "TableText"]},
   {
    RowBox[{
     ButtonBox["Ticks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ticks"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "place tick marks automatically", "TableText"]},
   {
    RowBox[{
     ButtonBox["Ticks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ticks"], "->", "{", 
     StyleBox["xticks", "TI"], ",", 
     StyleBox["yticks", "TI"], ",", 
     StyleBox["zticks", "TI"], "}"}], Cell[
    "tick mark specifications for each axis", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17349],

Cell[TextData[{
 "Settings for the ",
 StyleBox["Ticks", "MR"],
 " option. "
}], "Caption",
 CellID->15827],

Cell[TextData[{
 "You can give the same kind of tick mark specifications in three dimensions \
as were described for two\[Hyphen]dimensional graphics in \"",
 ButtonBox["Labeling Two-Dimensional Graphics\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LabelingTwoDimensionalGraphics"],
 ". "
}], "Text",
 CellID->30954],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FaceGrids",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceGrids"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "draw no grid lines on faces", "TableText"]},
   {
    RowBox[{
     ButtonBox["FaceGrids",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceGrids"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[
    "draw grid lines on all faces", "TableText"]},
   {
    RowBox[{
     ButtonBox["FaceGrids",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceGrids"], "->", "{", 
     SubscriptBox[
      StyleBox["face", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["face", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "draw grid lines on the faces specified by the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["face", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FaceGrids",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceGrids"], "->", "{", "{", 
     SubscriptBox[
      StyleBox["face", "TI"], "1"], ",", "{", 
     SubscriptBox[
      StyleBox["xgrid", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["ygrid", "TI"], "1"], "}", "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["xgrid", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["ygrid", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to determine where and how to draw grid lines on each face"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31504],

Cell["Drawing grid lines in three dimensions. ", "Caption",
 CellID->3281],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to draw grid lines on the faces of the box that surrounds a \
three\[Hyphen]dimensional object. If you set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FaceGrids",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGrids"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", grid lines are drawn in gray on every face. By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FaceGrids",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGrids"], "->", "{"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["face", "TI"], "1"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["face", "TI"], "2"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{
   RowBox[{",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to draw grid lines only on specific faces. Each face is specified by a \
list ",
 Cell[BoxData["{"], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "x"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "y"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "z"], TraditionalForm]], "InlineMath"],
 Cell[BoxData["}"], "InlineFormula"],
 ", where two of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["dir", "TI"], "i"], TraditionalForm]], "InlineMath"],
 " must be ",
 Cell[BoxData["0"], "InlineFormula"],
 ", and the third one is ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ". For each face, you can also explicitly tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " where and how to draw the grid lines, using the same kind of \
specifications as you give for the ",
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 " option in two\[Hyphen]dimensional graphics. "
}], "Text",
 CellID->14246],

Cell["\<\
This draws grid lines only on the top and bottom faces of the box. \
\>", "MathCaption",
 CellID->23757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Image\>\""}], "]"}], ",", 
   RowBox[{"FaceGrids", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->27285],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->138885866]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->282513444],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "RelatedTutorials",
 CellID->12933],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Labeling Three-Dimensional Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LightingAndSurfaceProperties"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EfficientRepresentationOfManyPrimitives"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 17.1783608}", "context" -> "", 
    "keywords" -> {
     "axes", "AxesEdge", "AxesLabel", "AxesStyle", "boxed", "BoxStyle", 
      "cages", "FaceGrids", "fiducial marks", "graphics", "labeling", 
      "markings", "PlotLabel", "plots", "scales", "style options", 
      "tick marks", "ticks"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides various options for labeling three-dimensional \
graphics. Some of these options are directly analogous to those for \
two-dimensional graphics, discussed in \"Labeling Two-Dimensional Graphics\". \
Others are different. Some options for labeling three-dimensional graphics. \
The default for Graphics3D is to include a box, but no other forms of \
labeling. ", "synonyms" -> {}, "title" -> 
    "Labeling Three-Dimensional Graphics", "type" -> "Tutorial", "uri" -> 
    "tutorial/LabelingThreeDimensionalGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.13"->{
  Cell[3220, 78, 117, 4, 70, "Title",
   CellTags->{"S2.10.13", "13.1"},
   CellID->21590]},
 "13.1"->{
  Cell[3220, 78, 117, 4, 70, "Title",
   CellTags->{"S2.10.13", "13.1"},
   CellID->21590]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.13", 64124, 1532},
 {"13.1", 64228, 1536}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2595, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3220, 78, 117, 4, 70, "Title",
 CellTags->{"S2.10.13", "13.1"},
 CellID->21590],
Cell[3340, 84, 447, 11, 70, "Text",
 CellID->12891],
Cell[3790, 97, 2204, 74, 70, "DefinitionBox",
 CellID->30369],
Cell[5997, 173, 104, 3, 70, "Caption",
 CellID->1538],
Cell[6104, 178, 252, 8, 70, "MathCaption",
 CellID->32212],
Cell[CellGroupData[{
Cell[6381, 190, 202, 6, 28, "Input",
 CellID->10991],
Cell[6586, 198, 3857, 67, 229, "Output",
 Evaluatable->False,
 CellID->819550548]
}, Open  ]],
Cell[10458, 268, 508, 21, 70, "MathCaption",
 CellID->23409],
Cell[CellGroupData[{
Cell[10991, 293, 151, 5, 28, "Input",
 CellID->11620],
Cell[11145, 300, 4016, 70, 237, "Output",
 Evaluatable->False,
 CellID->312375221]
}, Open  ]],
Cell[15176, 373, 85, 1, 70, "MathCaption",
 CellID->22662],
Cell[CellGroupData[{
Cell[15286, 378, 155, 5, 70, "Input",
 CellID->25128],
Cell[15444, 385, 13278, 230, 237, 5287, 95, "CachedBoxData", "BoxData", \
"Output",
 CellID->513393206]
}, Open  ]],
Cell[28737, 618, 1116, 34, 70, "DefinitionBox",
 CellID->32759],
Cell[29856, 654, 50, 1, 70, "Caption",
 CellID->10842],
Cell[29909, 657, 120, 3, 70, "MathCaption",
 CellID->18440],
Cell[CellGroupData[{
Cell[30054, 664, 481, 13, 47, "Input",
 CellID->1787503252],
Cell[30538, 679, 3804, 66, 237, "Output",
 Evaluatable->False,
 CellID->417535150]
}, Open  ]],
Cell[34357, 748, 713, 22, 70, "Text",
 CellID->22642],
Cell[35073, 772, 1834, 59, 70, "DefinitionBox",
 CellID->31620],
Cell[36910, 833, 100, 3, 70, "Caption",
 CellID->21486],
Cell[37013, 838, 524, 18, 70, "MathCaption",
 CellID->6146],
Cell[CellGroupData[{
Cell[37562, 860, 326, 11, 28, "Input",
 CellID->27964],
Cell[37891, 873, 3695, 65, 236, "Output",
 Evaluatable->False,
 CellID->660386269]
}, Open  ]],
Cell[41601, 941, 1393, 46, 70, "Text",
 CellID->1271],
Cell[42997, 989, 1207, 38, 70, "DefinitionBox",
 CellID->30943],
Cell[44207, 1029, 93, 3, 70, "Caption",
 CellID->9466],
Cell[44303, 1034, 264, 8, 70, "MathCaption",
 CellID->21474],
Cell[CellGroupData[{
Cell[44592, 1046, 422, 12, 47, "Input",
 CellID->3445],
Cell[45017, 1060, 3861, 67, 223, "Output",
 Evaluatable->False,
 CellID->167976081]
}, Open  ]],
Cell[48893, 1130, 1171, 36, 70, "DefinitionBox",
 CellID->17349],
Cell[50067, 1168, 107, 5, 70, "Caption",
 CellID->15827],
Cell[50177, 1175, 327, 8, 70, "Text",
 CellID->30954],
Cell[50507, 1185, 2139, 67, 70, "DefinitionBox",
 CellID->31504],
Cell[52649, 1254, 74, 1, 70, "Caption",
 CellID->3281],
Cell[52726, 1257, 2357, 77, 70, "Text",
 CellID->14246],
Cell[55086, 1336, 114, 3, 70, "MathCaption",
 CellID->23757],
Cell[CellGroupData[{
Cell[55225, 1343, 456, 14, 28, "Input",
 CellID->27285],
Cell[55684, 1359, 5216, 90, 229, "Output",
 Evaluatable->False,
 CellID->138885866]
}, Open  ]],
Cell[CellGroupData[{
Cell[60937, 1454, 72, 1, 70, "RelatedTutorialsSection",
 CellID->282513444],
Cell[61012, 1457, 145, 3, 70, "RelatedTutorials",
 CellID->12933],
Cell[61160, 1462, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[61388, 1471, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

