(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33988,       1230]
NotebookOptionsPosition[     17114,        672]
NotebookOutlinePosition[     27017,        987]
CellTagsIndexPosition[     26619,        968]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Unix and Linux"
}], "Title",
 CellID->235582594],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Locally"
}], "Section",
 CellTags->{"locally", "i:1"},
 CellID->74973949],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a network license, both the client machine and the license server \
must be on the network and ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be running. "
}], "Text",
 CellTags->"b:3.1",
 CellID->753753085],

Cell[CellGroupData[{

Cell[TextData[{
 "To launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Subsection",
 CellTags->{"i:13", "b:3.1"},
 CellID->341419464],

Cell[TextData[{
 "Make sure that you are running ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ". Then, from a shell, type ",
 StyleBox["mathematica", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "Text",
 CellTags->"b:3.1",
 CellID->256159382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To launch only the ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "kernel:"
}], "Subsection",
 CellTags->{"i:8", "b:3.1"},
 CellID->15832764],

Cell[TextData[{
 "From a shell, type ",
 StyleBox["math", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "Text",
 CellTags->"b:3.1",
 CellID->131598079]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a File Server"
}], "Section",
 CellTags->{"fs1", "i:2"},
 CellID->185806732],

Cell[TextData[{
 "Rather than installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on every client machine, you can install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on a file server and export the installation directory to the clients. To \
display the front end, the clients must have access to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts. For information about configuring the X server on the client \
machines to find the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts, see \"",
 ButtonBox["Fonts on Unix and Linux\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FontsOnUnixAndLinux"],
 ". Once the fonts are properly configured, the client machines can run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as though it were a local installation."
}], "Text",
 CellTags->"b:6.0.1",
 CellID->153061519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Command-Line Options"
}], "Section",
 CellTags->{"clo", "b:6.2", "net: 1"},
 CellID->24354717],

Cell[CellGroupData[{

Cell["math", "Subsection",
 CellTags->{"i:14", "b:6.2", "net: 2"},
 CellID->322524989],

Cell[TextData[{
 "The ",
 StyleBox["math", "InlineCode"],
 " command starts the kernel from within a shell. The kernel is the part of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that handles calculations. This is also used by the front end. "
}], "Text",
 CellTags->"b:6.2",
 CellID->349677795],

Cell[CellGroupData[{

Cell["Command\[Hyphen]Line Options", "Subsubsection",
 CellTags->"b:6.2",
 CellID->239008601],

Cell[TextData[{
 StyleBox["-initfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->439474550],

Cell["\<\
Specifies the name of a file containing commands to be run on startup.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->337349050],

Cell[TextData[StyleBox["-lmverbose", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->108592801],

Cell[TextData[{
 "Prints diagnostic information to ",
 StyleBox["stderr", "InlineCode"],
 " on connecting to the license manager. This is useful for debugging",
 " ",
 "problems related to the license server."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->266572272],

Cell[TextData[StyleBox["-mathlink", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->620965862],

Cell[TextData[{
 "Specifies that the kernel should be run in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode. See ",
 ButtonBox["www.wolfram.com/solutions/mathlink",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/mathlink"], None}],
 " for additional information about ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->10541758],

Cell[TextData[StyleBox["-noinit", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->25124354],

Cell["\<\
Specifies that no initialization file should be read at startup.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->757559550],

Cell[TextData[{
 StyleBox["-password ", "InlineCode"],
 StyleBox["str", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->38477054],

Cell[TextData[{
 "Specifies a password to use instead of the password or passwords stored in \
the ",
 StyleBox["mathpass", "InlineCode"],
 " file. The password should have the form \"",
 StyleBox["!servername", "TI"],
 "\" or \"",
 StyleBox["machinename mathid licensenumber password", "TI"],
 "\"."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->145786886],

Cell[TextData[{
 StyleBox["-pwfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->36100677],

Cell["Specifies the name of a file that has a valid password.", \
"ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->103621716],

Cell[TextData[StyleBox["-run", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->790226394],

Cell["Takes a command to be run on startup as an argument.", \
"ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->93560847]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["mathematica ", "Subsection",
 CellTags->{"i:15", "b:6.2", "net: 3"},
 CellID->168021220],

Cell[TextData[{
 "The ",
 StyleBox["mathematica", "InlineCode"],
 " command runs the X front end. In order for the front end to run, the ",
 StyleBox["DISPLAY", "InlineCode"],
 " environment variable must be set and the front end must be able to \
locate",
 " ",
 "the fonts included with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellTags->"b:6.2",
 CellID->568787544],

Cell[CellGroupData[{

Cell["Command-Line Options", "Subsubsection",
 CellTags->"b:6.2",
 CellID->329396048],

Cell[TextData[StyleBox["-appHelper", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->297881347],

Cell[TextData[{
 "Combines the options ",
 StyleBox["-querySingleLaunch", "InlineCode"],
 " and ",
 StyleBox["-forceSaveAs", "InlineCode"],
 ". This option is typically used when configuring ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a helper application for web browsers."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->292401936],

Cell[TextData[StyleBox["-backgroundTaskDelay", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->497334527],

Cell["\<\
Specifies the time the front end delays background tasks like PostScript \
rendering when waiting for input. The delay is measured in milliseconds and \
the default setting is 100.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->201683677],

Cell[TextData[StyleBox["-cleanStart", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->295897063],

Cell[TextData[{
 "Tells the front end to ignore caches stored in the directory ",
 "$UserBaseDirectory/FrontEnd/6.0_Caches",
 ", and rebuilds the front end preferences file, ",
 "$UserBaseDirectory/FrontEnd/init.m",
 ". This option can also be abbreviated as ",
 StyleBox["-clean", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->585144311],

Cell[TextData[StyleBox["-copyright", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->493459623],

Cell["\<\
Tells the front end to display copyright information from the command line.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->286660715],

Cell[TextData[StyleBox["-dontUpdatePrefs", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->3665023],

Cell["\<\
Prevents changes to the user\[CloseCurlyQuote]s preference settings.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->494970455],

Cell[TextData[{
 StyleBox["-font ", "InlineCode"],
 StyleBox["f", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->553264788],

Cell[TextData[{
 "Specifies the font the front end uses in menus, buttons, and so on. The X \
program ",
 StyleBox["xfontsel", "InlineCode"],
 " can be used to obtain a font name. The font name may be expressed either",
 " ",
 "as an X Logical Font Description or as a valid font alias."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->180679787],

Cell[TextData[StyleBox["-forceSaveAs", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->326894396],

Cell[TextData[{
 "Forces the front end to bring up the Save dialog box when closing a file \
passed to it on the command line. This option is typically used when",
 " ",
 "configuring ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a helper application for web browsers."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->18538000],

Cell[TextData[StyleBox["-help", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->628047958],

Cell["\<\
Prints a listing of all available command\[Hyphen]line options.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->164171258],

Cell[TextData[StyleBox["-lmverbose", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->746542686],

Cell[TextData[{
 "Prints diagnostic information to ",
 StyleBox["stderr", "InlineCode"],
 " on connecting to the license manager. This is useful for diagnosing",
 " ",
 "problems related to the license server."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->219458163],

Cell[TextData[StyleBox["-mathlink", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->3228885],

Cell[TextData[{
 "Causes the front end to run in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode. In ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode, the front end runs as a child process that is capable of accepting \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " packets. This option may be useful when the front end is used as a",
 " ",
 "typesetting or graphics rendering service."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->263940544],

Cell[TextData[StyleBox["-noSplashScreen", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->327148784],

Cell["Prevents the splash screen from being displayed on startup.", \
"ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->19557077],

Cell[TextData[StyleBox["-nostderrWindow", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->17220780],

Cell[TextData[{
 "Tells the front end not to display ",
 StyleBox["stderr", "InlineCode"],
 " messages in a pop-up window."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->182875440],

Cell[TextData[{
 StyleBox["-preferencesDirectory ", "InlineCode"],
 StyleBox["dir", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->54197272],

Cell["\<\
Specifies the location where preference settings are stored. The default \
location is ~/.Mathematica.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->1023304978],

Cell[TextData[{
 StyleBox["-printCommand ", "InlineCode"],
 StyleBox["command", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->226593496],

Cell[TextData[{
 "Specifies a command for sending a file to the printer, such as ",
 StyleBox["lpr", "InlineCode"],
 " or ",
 StyleBox["lp", "InlineCode"],
 ". This command appears in the Print dialog box."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->560747072],

Cell[TextData[{
 StyleBox["-pwfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->37583712],

Cell["Specifies the name of a file containing a valid password.", \
"ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->278863530],

Cell[TextData[StyleBox["-querySingleLaunch", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->1007648],

Cell[TextData[{
 "Brings up a dialog box to ask the user if a file specified on the command \
line should be opened in the currently running front end. The dialog box",
 " ",
 "appears only if the current front end was also launched with the ",
 StyleBox["-querySingleLaunch", "InlineCode"],
 " option."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->13447287],

Cell[TextData[StyleBox["-singleLaunch", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->448539259],

Cell[TextData[{
 "Allows only one copy of the front end per display. Multiple launches are",
 " ",
 "prevented only if the currently running front end was launched with the ",
 StyleBox["-singleLaunch", "InlineCode"],
 " or ",
 StyleBox["-querySingleLaunch", "InlineCode"],
 " option."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->284516393],

Cell[TextData[{
 StyleBox["-style ", "InlineCode"],
 StyleBox["s", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->15406604],

Cell[TextData[{
 "Specifies which widget style the front end should use. Valid values are ",
 StyleBox["motif", "InlineCode"],
 ", ",
 StyleBox["motifplus", "InlineCode"],
 ", ",
 StyleBox["windows", "InlineCode"],
 ", ",
 StyleBox["cde", "InlineCode"],
 ", ",
 StyleBox["platinum", "InlineCode"],
 ", ",
 StyleBox["sgi", "InlineCode"],
 ", and ",
 StyleBox["compact", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->373166559],

Cell[TextData[{
 StyleBox["-topDirectory ", "InlineCode"],
 StyleBox["dir", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->366833550],

Cell[TextData[{
 "Specifies the directory in which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed. The default location is ",
 "/usr/local/Wolfram/Mathematica/6.0",
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->490028575],

Cell[TextData[StyleBox["-version", "InlineCode"]], "IndentedText",
 CellTags->"b:6.2",
 CellID->304172841],

Cell["\<\
Prints the current version of the front end from the command line.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->667461695],

Cell[TextData[{
 StyleBox["-wwwBrowser ", "InlineCode"],
 StyleBox["command", "TI"]
}], "IndentedText",
 CellTags->"b:6.2",
 CellID->34495944],

Cell[TextData[{
 "Specifies the command to execute when opening URL links from the front",
 " ",
 "end. The command can include a ",
 StyleBox["%s", "InlineCode"],
 " format argument that is replaced with the URL."
}], "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->799518095]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->274196276],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Launching Mathematica on Unix and Linux - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 18.4283928}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "To run Mathematica using a network license, both the client machine and \
the license server must be on the network and MathLM must be running. Make \
sure that you are running MathLM. Then, from a shell, type mathematica and \
press Enter. From a shell, type math and press Enter.", "synonyms" -> {}, 
    "title" -> "Launching Mathematica on Unix and Linux", "type" -> 
    "Tutorial", "uri" -> "tutorial/LaunchingMathematicaOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "locally"->{
  Cell[1724, 58, 156, 7, 70, "Section",
   CellTags->{"locally", "i:1"},
   CellID->74973949]},
 "i:1"->{
  Cell[1724, 58, 156, 7, 70, "Section",
   CellTags->{"locally", "i:1"},
   CellID->74973949]},
 "b:3.1"->{
  Cell[1883, 67, 376, 13, 70, "Text",
   CellTags->"b:3.1",
   CellID->753753085],
  Cell[2284, 84, 152, 7, 70, "Subsection",
   CellTags->{"i:13", "b:3.1"},
   CellID->341419464],
  Cell[2439, 93, 347, 13, 70, "Text",
   CellTags->"b:3.1",
   CellID->256159382],
  Cell[2823, 111, 166, 7, 70, "Subsection",
   CellTags->{"i:8", "b:3.1"},
   CellID->15832764],
  Cell[2992, 120, 177, 8, 70, "Text",
   CellTags->"b:3.1",
   CellID->131598079]},
 "i:13"->{
  Cell[2284, 84, 152, 7, 70, "Subsection",
   CellTags->{"i:13", "b:3.1"},
   CellID->341419464]},
 "i:8"->{
  Cell[2823, 111, 166, 7, 70, "Subsection",
   CellTags->{"i:8", "b:3.1"},
   CellID->15832764]},
 "fs1"->{
  Cell[3218, 134, 164, 7, 70, "Section",
   CellTags->{"fs1", "i:2"},
   CellID->185806732]},
 "i:2"->{
  Cell[3218, 134, 164, 7, 70, "Section",
   CellTags->{"fs1", "i:2"},
   CellID->185806732]},
 "b:6.0.1"->{
  Cell[3385, 143, 880, 25, 70, "Text",
   CellTags->"b:6.0.1",
   CellID->153061519]},
 "clo"->{
  Cell[4302, 173, 162, 6, 70, "Section",
   CellTags->{"clo", "b:6.2", "net: 1"},
   CellID->24354717]},
 "b:6.2"->{
  Cell[4302, 173, 162, 6, 70, "Section",
   CellTags->{"clo", "b:6.2", "net: 1"},
   CellID->24354717],
  Cell[4489, 183, 86, 2, 70, "Subsection",
   CellTags->{"i:14", "b:6.2", "net: 2"},
   CellID->322524989],
  Cell[4578, 187, 307, 10, 70, "Text",
   CellTags->"b:6.2",
   CellID->349677795],
  Cell[4910, 201, 93, 2, 70, "Subsubsection",
   CellTags->"b:6.2",
   CellID->239008601],
  Cell[5006, 205, 138, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->439474550],
  Cell[5147, 212, 151, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->337349050],
  Cell[5301, 218, 108, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->108592801],
  Cell[5412, 222, 278, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->266572272],
  Cell[5693, 232, 107, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->620965862],
  Cell[5803, 236, 436, 15, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->10541758],
  Cell[6242, 253, 104, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->25124354],
  Cell[6349, 257, 145, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->757559550],
  Cell[6497, 263, 136, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->38477054],
  Cell[6636, 270, 369, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->145786886],
  Cell[7008, 283, 135, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->36100677],
  Cell[7146, 290, 130, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->103621716],
  Cell[7279, 295, 102, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->790226394],
  Cell[7384, 299, 126, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->93560847],
  Cell[7559, 308, 94, 2, 70, "Subsection",
   CellTags->{"i:15", "b:6.2", "net: 3"},
   CellID->168021220],
  Cell[7656, 312, 398, 14, 70, "Text",
   CellTags->"b:6.2",
   CellID->568787544],
  Cell[8079, 330, 85, 2, 70, "Subsubsection",
   CellTags->"b:6.2",
   CellID->329396048],
  Cell[8167, 334, 108, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->297881347],
  Cell[8278, 338, 357, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->292401936],
  Cell[8638, 351, 118, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->497334527],
  Cell[8759, 355, 261, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->201683677],
  Cell[9023, 363, 109, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->295897063],
  Cell[9135, 367, 370, 10, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->585144311],
  Cell[9508, 379, 108, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->493459623],
  Cell[9619, 383, 156, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->286660715],
  Cell[9778, 389, 112, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->3665023],
  Cell[9893, 393, 149, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->494970455],
  Cell[10045, 399, 131, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->553264788],
  Cell[10179, 406, 356, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->180679787],
  Cell[10538, 417, 110, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->326894396],
  Cell[10651, 421, 349, 10, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->18538000],
  Cell[11003, 433, 103, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->628047958],
  Cell[11109, 437, 144, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->164171258],
  Cell[11256, 443, 108, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->746542686],
  Cell[11367, 447, 279, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->219458163],
  Cell[11649, 457, 105, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->3228885],
  Cell[11757, 461, 478, 16, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->263940544],
  Cell[12238, 479, 113, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->327148784],
  Cell[12354, 483, 133, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->19557077],
  Cell[12490, 488, 112, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->17220780],
  Cell[12605, 492, 192, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->182875440],
  Cell[12800, 500, 148, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->54197272],
  Cell[12951, 507, 184, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->1023304978],
  Cell[13138, 514, 145, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->226593496],
  Cell[13286, 521, 275, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->560747072],
  Cell[13564, 531, 135, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->37583712],
  Cell[13702, 538, 132, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->278863530],
  Cell[13837, 543, 114, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->1007648],
  Cell[13954, 547, 371, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->13447287],
  Cell[14328, 558, 111, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->448539259],
  Cell[14442, 562, 354, 10, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->284516393],
  Cell[14799, 574, 131, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->15406604],
  Cell[14933, 581, 457, 18, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->373166559],
  Cell[15393, 601, 141, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->366833550],
  Cell[15537, 608, 259, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->490028575],
  Cell[15799, 619, 106, 2, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->304172841],
  Cell[15908, 623, 147, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->667461695],
  Cell[16058, 629, 142, 5, 70, "IndentedText",
   CellTags->"b:6.2",
   CellID->34495944],
  Cell[16203, 636, 283, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:6.2",
   CellID->799518095]},
 "net: 1"->{
  Cell[4302, 173, 162, 6, 70, "Section",
   CellTags->{"clo", "b:6.2", "net: 1"},
   CellID->24354717]},
 "i:14"->{
  Cell[4489, 183, 86, 2, 70, "Subsection",
   CellTags->{"i:14", "b:6.2", "net: 2"},
   CellID->322524989]},
 "net: 2"->{
  Cell[4489, 183, 86, 2, 70, "Subsection",
   CellTags->{"i:14", "b:6.2", "net: 2"},
   CellID->322524989]},
 "i:15"->{
  Cell[7559, 308, 94, 2, 70, "Subsection",
   CellTags->{"i:15", "b:6.2", "net: 3"},
   CellID->168021220]},
 "net: 3"->{
  Cell[7559, 308, 94, 2, 70, "Subsection",
   CellTags->{"i:15", "b:6.2", "net: 3"},
   CellID->168021220]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"locally", 18640, 707},
 {"i:1", 18746, 711},
 {"b:3.1", 18854, 715},
 {"i:13", 19310, 731},
 {"i:8", 19419, 735},
 {"fs1", 19527, 739},
 {"i:2", 19631, 743},
 {"b:6.0.1", 19739, 747},
 {"clo", 19836, 751},
 {"b:6.2", 19953, 755},
 {"net: 1", 26007, 945},
 {"i:14", 26123, 949},
 {"net: 2", 26245, 953},
 {"i:15", 26365, 957},
 {"net: 3", 26487, 961}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 134, 6, 70, "Title",
 CellID->235582594],
Cell[CellGroupData[{
Cell[1724, 58, 156, 7, 70, "Section",
 CellTags->{"locally", "i:1"},
 CellID->74973949],
Cell[1883, 67, 376, 13, 70, "Text",
 CellTags->"b:3.1",
 CellID->753753085],
Cell[CellGroupData[{
Cell[2284, 84, 152, 7, 70, "Subsection",
 CellTags->{"i:13", "b:3.1"},
 CellID->341419464],
Cell[2439, 93, 347, 13, 70, "Text",
 CellTags->"b:3.1",
 CellID->256159382]
}, Open  ]],
Cell[CellGroupData[{
Cell[2823, 111, 166, 7, 70, "Subsection",
 CellTags->{"i:8", "b:3.1"},
 CellID->15832764],
Cell[2992, 120, 177, 8, 70, "Text",
 CellTags->"b:3.1",
 CellID->131598079]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3218, 134, 164, 7, 70, "Section",
 CellTags->{"fs1", "i:2"},
 CellID->185806732],
Cell[3385, 143, 880, 25, 70, "Text",
 CellTags->"b:6.0.1",
 CellID->153061519]
}, Open  ]],
Cell[CellGroupData[{
Cell[4302, 173, 162, 6, 70, "Section",
 CellTags->{"clo", "b:6.2", "net: 1"},
 CellID->24354717],
Cell[CellGroupData[{
Cell[4489, 183, 86, 2, 70, "Subsection",
 CellTags->{"i:14", "b:6.2", "net: 2"},
 CellID->322524989],
Cell[4578, 187, 307, 10, 70, "Text",
 CellTags->"b:6.2",
 CellID->349677795],
Cell[CellGroupData[{
Cell[4910, 201, 93, 2, 70, "Subsubsection",
 CellTags->"b:6.2",
 CellID->239008601],
Cell[5006, 205, 138, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->439474550],
Cell[5147, 212, 151, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->337349050],
Cell[5301, 218, 108, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->108592801],
Cell[5412, 222, 278, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->266572272],
Cell[5693, 232, 107, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->620965862],
Cell[5803, 236, 436, 15, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->10541758],
Cell[6242, 253, 104, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->25124354],
Cell[6349, 257, 145, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->757559550],
Cell[6497, 263, 136, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->38477054],
Cell[6636, 270, 369, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->145786886],
Cell[7008, 283, 135, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->36100677],
Cell[7146, 290, 130, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->103621716],
Cell[7279, 295, 102, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->790226394],
Cell[7384, 299, 126, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->93560847]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7559, 308, 94, 2, 70, "Subsection",
 CellTags->{"i:15", "b:6.2", "net: 3"},
 CellID->168021220],
Cell[7656, 312, 398, 14, 70, "Text",
 CellTags->"b:6.2",
 CellID->568787544],
Cell[CellGroupData[{
Cell[8079, 330, 85, 2, 70, "Subsubsection",
 CellTags->"b:6.2",
 CellID->329396048],
Cell[8167, 334, 108, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->297881347],
Cell[8278, 338, 357, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->292401936],
Cell[8638, 351, 118, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->497334527],
Cell[8759, 355, 261, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->201683677],
Cell[9023, 363, 109, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->295897063],
Cell[9135, 367, 370, 10, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->585144311],
Cell[9508, 379, 108, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->493459623],
Cell[9619, 383, 156, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->286660715],
Cell[9778, 389, 112, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->3665023],
Cell[9893, 393, 149, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->494970455],
Cell[10045, 399, 131, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->553264788],
Cell[10179, 406, 356, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->180679787],
Cell[10538, 417, 110, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->326894396],
Cell[10651, 421, 349, 10, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->18538000],
Cell[11003, 433, 103, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->628047958],
Cell[11109, 437, 144, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->164171258],
Cell[11256, 443, 108, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->746542686],
Cell[11367, 447, 279, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->219458163],
Cell[11649, 457, 105, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->3228885],
Cell[11757, 461, 478, 16, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->263940544],
Cell[12238, 479, 113, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->327148784],
Cell[12354, 483, 133, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->19557077],
Cell[12490, 488, 112, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->17220780],
Cell[12605, 492, 192, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->182875440],
Cell[12800, 500, 148, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->54197272],
Cell[12951, 507, 184, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->1023304978],
Cell[13138, 514, 145, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->226593496],
Cell[13286, 521, 275, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->560747072],
Cell[13564, 531, 135, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->37583712],
Cell[13702, 538, 132, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->278863530],
Cell[13837, 543, 114, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->1007648],
Cell[13954, 547, 371, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->13447287],
Cell[14328, 558, 111, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->448539259],
Cell[14442, 562, 354, 10, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->284516393],
Cell[14799, 574, 131, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->15406604],
Cell[14933, 581, 457, 18, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->373166559],
Cell[15393, 601, 141, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->366833550],
Cell[15537, 608, 259, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->490028575],
Cell[15799, 619, 106, 2, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->304172841],
Cell[15908, 623, 147, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->667461695],
Cell[16058, 629, 142, 5, 70, "IndentedText",
 CellTags->"b:6.2",
 CellID->34495944],
Cell[16203, 636, 283, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:6.2",
 CellID->799518095]
}, Open  ]],
Cell[CellGroupData[{
Cell[16523, 649, 72, 1, 70, "RelatedTutorialsSection",
 CellID->274196276],
Cell[16598, 652, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[16815, 659, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[17087, 670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

