(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    143708,       3852]
NotebookOptionsPosition[    131802,       3541]
NotebookOutlinePosition[    138700,       3669]
CellTagsIndexPosition[    138604,       3663]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Mathematical and Other Notation" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/MathematicalAndOtherNotationOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Mathematical and Other Notation\"\>"}, "\<\"related tutorials\"\
\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Letters and Letter\[Hyphen]like Forms", "Title",
 CellTags->{"S3.10.3", "3.1"},
 CellID->19606],

Cell[CellGroupData[{

Cell["Greek Letters", "Section",
 CellID->11221],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "aliases", "TableHeader"]},
       {"\[Alpha]", Cell[BoxData[
         ButtonBox["\\[Alpha]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Alpha"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["a\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["alpha\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Beta]", Cell[BoxData[
         ButtonBox["\\[Beta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Beta"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["b\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["beta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Gamma]", Cell[BoxData[
         ButtonBox["\\[Gamma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Gamma"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["g\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["gamma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Delta]", Cell[BoxData[
         ButtonBox["\\[Delta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Delta"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["d\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["delta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Epsilon]", Cell[BoxData[
         ButtonBox["\\[Epsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Epsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["e\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["epsilon\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CurlyEpsilon]", Cell[BoxData[
         ButtonBox["\\[CurlyEpsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyEpsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ce\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["cepsilon\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Zeta]", Cell[BoxData[
         ButtonBox["\\[Zeta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Zeta"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["z\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["zeta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Eta]", Cell[BoxData[
         ButtonBox["\\[Eta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Eta"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["h\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["et\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["eta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Theta]", Cell[BoxData[
         ButtonBox["\\[Theta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Theta"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["q\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["th\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["theta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CurlyTheta]", Cell[BoxData[
         ButtonBox["\\[CurlyTheta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyTheta"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cq\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["cth\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["ctheta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Iota]", Cell[BoxData[
         ButtonBox["\\[Iota]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Iota"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["i\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["iota\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Kappa]", Cell[BoxData[
         ButtonBox["\\[Kappa]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Kappa"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["k\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["kappa\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CurlyKappa]", Cell[BoxData[
         ButtonBox["\\[CurlyKappa]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyKappa"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ck\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["ckappa\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Lambda]", Cell[BoxData[
         ButtonBox["\\[Lambda]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Lambda"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["l\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["lambda\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Mu]", Cell[BoxData[
         ButtonBox["\\[Mu]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Mu"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["m\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["mu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Nu]", Cell[BoxData[
         ButtonBox["\\[Nu]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Nu"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["n\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["nu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Xi]", Cell[BoxData[
         ButtonBox["\\[Xi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Xi"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["x\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["xi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Omicron]", Cell[BoxData[
         ButtonBox["\\[Omicron]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Omicron"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["om\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["omicron\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Pi]", Cell[BoxData[
         ButtonBox["\\[Pi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Pi"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["p\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["pi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CurlyPi]", Cell[BoxData[
         ButtonBox["\\[CurlyPi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyPi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cp\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["cpi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Rho]", Cell[BoxData[
         ButtonBox["\\[Rho]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Rho"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["r\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["rho\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CurlyRho]", Cell[BoxData[
         ButtonBox["\\[CurlyRho]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyRho"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cr\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["crho\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Sigma]", Cell[BoxData[
         ButtonBox["\\[Sigma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sigma"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["s\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["sigma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[FinalSigma]", Cell[BoxData[
         ButtonBox["\\[FinalSigma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FinalSigma"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["fs\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Tau]", Cell[BoxData[
         ButtonBox["\\[Tau]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Tau"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["t\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["tau\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Upsilon]", Cell[BoxData[
         ButtonBox["\\[Upsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Upsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["upsilon\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[Phi]", Cell[BoxData[
         ButtonBox["\\[Phi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Phi"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["f\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["ph\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["phi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CurlyPhi]", Cell[BoxData[
         ButtonBox["\\[CurlyPhi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyPhi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["j\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["cph\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["cphi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Chi]", Cell[BoxData[
         ButtonBox["\\[Chi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Chi"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["ch\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["chi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Psi]", Cell[BoxData[
         ButtonBox["\\[Psi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Psi"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["y\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["ps\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["psi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Omega]", Cell[BoxData[
         ButtonBox["\\[Omega]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Omega"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["w\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["omega\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Digamma]", Cell[BoxData[
         ButtonBox["\\[Digamma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Digamma"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["di\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["digamma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Koppa]", Cell[BoxData[
         ButtonBox["\\[Koppa]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Koppa"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ko\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["koppa\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Stigma]", Cell[BoxData[
         ButtonBox["\\[Stigma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Stigma"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sti\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["stigma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Sampi]", Cell[BoxData[
         ButtonBox["\\[Sampi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sampi"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sa\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["sampi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "aliases", "TableHeader"]},
       {"\[CapitalAlpha]", Cell[BoxData[
         ButtonBox["\\[CapitalAlpha]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalAlpha"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["A\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Alpha\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalBeta]", Cell[BoxData[
         ButtonBox["\\[CapitalBeta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalBeta"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["B\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Beta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalGamma]", Cell[BoxData[
         ButtonBox["\\[CapitalGamma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalGamma"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["G\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Gamma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalDelta]", Cell[BoxData[
         ButtonBox["\\[CapitalDelta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalDelta"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["D\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Delta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEpsilon]", Cell[BoxData[
         ButtonBox["\\[CapitalEpsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEpsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["E\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Epsilon\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[CapitalZeta]", Cell[BoxData[
         ButtonBox["\\[CapitalZeta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalZeta"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Z\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Zeta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEta]", Cell[BoxData[
         ButtonBox["\\[CapitalEta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEta"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["H\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Et\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Eta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalTheta]", Cell[BoxData[
         ButtonBox["\\[CapitalTheta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalTheta"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Q\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Th\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Theta\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[CapitalIota]", Cell[BoxData[
         ButtonBox["\\[CapitalIota]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalIota"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["I\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Iota\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalKappa]", Cell[BoxData[
         ButtonBox["\\[CapitalKappa]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalKappa"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["K\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Kappa\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[CapitalLambda]", Cell[BoxData[
         ButtonBox["\\[CapitalLambda]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalLambda"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["L\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Lambda\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalMu]", Cell[BoxData[
         ButtonBox["\\[CapitalMu]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalMu"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["M\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Mu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalNu]", Cell[BoxData[
         ButtonBox["\\[CapitalNu]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalNu"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["N\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Nu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalXi]", Cell[BoxData[
         ButtonBox["\\[CapitalXi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalXi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["X\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Xi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalOmicron]", Cell[BoxData[
         ButtonBox["\\[CapitalOmicron]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOmicron"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Om\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Omicron\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalPi]", Cell[BoxData[
         ButtonBox["\\[CapitalPi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalPi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["P\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Pi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[CapitalRho]", Cell[BoxData[
         ButtonBox["\\[CapitalRho]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalRho"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["R\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Rho\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[CapitalSigma]", Cell[BoxData[
         ButtonBox["\\[CapitalSigma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalSigma"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["S\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Sigma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[CapitalTau]", Cell[BoxData[
         ButtonBox["\\[CapitalTau]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalTau"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["T\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Tau\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalUpsilon]", Cell[BoxData[
         ButtonBox["\\[CapitalUpsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalUpsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["U\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Upsilon\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CurlyCapitalUpsilon]", Cell[BoxData[
         ButtonBox["\\[CurlyCapitalUpsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyCapitalUpsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cU\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["cUpsilon\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalPhi]", Cell[BoxData[
         ButtonBox["\\[CapitalPhi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalPhi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["F\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Ph\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Phi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"", "\[Null]", "\[Null]"},
       {"\[CapitalChi]", Cell[BoxData[
         ButtonBox["\\[CapitalChi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalChi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["C\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Ch\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Chi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalPsi]", Cell[BoxData[
         ButtonBox["\\[CapitalPsi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalPsi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Y\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Ps\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Psi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalOmega]", Cell[BoxData[
         ButtonBox["\\[CapitalOmega]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOmega"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["W\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Omega\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalDigamma]", Cell[BoxData[
         ButtonBox["\\[CapitalDigamma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalDigamma"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Di\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Digamma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalKoppa]", Cell[BoxData[
         ButtonBox["\\[CapitalKoppa]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalKoppa"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Ko\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Koppa\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalStigma]", Cell[BoxData[
         ButtonBox["\\[CapitalStigma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalStigma"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Sti\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Stigma\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalSampi]", Cell[BoxData[
         ButtonBox["\\[CapitalSampi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalSampi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Sa\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["Sampi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->17975],

Cell[TextData[{
 "The complete collection of Greek letters in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->31520],

Cell[TextData[{
 "You can use Greek letters as the names of symbols. The only Greek letter \
with a built\[Hyphen]in meaning in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is ",
 Cell[BoxData["\[Pi]"], "InlineMath"],
 ", which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes to stand for the symbol ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2792],

Cell[TextData[{
 "Note that even though ",
 Cell[BoxData["\[Pi]"], "InlineMath"],
 " on its own is assigned a built\[Hyphen]in meaning, combinations such as ",
 Cell[BoxData[
  RowBox[{"\[Pi]", "2"}]], "InlineMath"],
 " or ",
 Cell[BoxData[
  RowBox[{"x", "\[Pi]"}]], "InlineMath"],
 " have no built\[Hyphen]in meanings. "
}], "Text",
 CellID->24565],

Cell[TextData[{
 "The Greek letters ",
 Cell[BoxData["\[CapitalSigma]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[CapitalPi]"], "InlineMath"],
 " look very much like the operators for sum and product. But as discussed \
above, these operators are different characters, entered as ",
 ButtonBox["\[Backslash][Sum]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Sum"],
 " and ",
 ButtonBox["\[Backslash][Product]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Product"],
 " respectively. "
}], "Text",
 CellID->25547],

Cell[TextData[{
 "Similarly, ",
 Cell[BoxData["\[Epsilon]"], "InlineMath"],
 " is different from the ",
 Cell[BoxData["\[Element]"], "InlineMath"],
 " operator ",
 ButtonBox["\[Backslash][Element]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Element"],
 ", and ",
 Cell[BoxData["\[Mu]"], "InlineMath"],
 " is different from ",
 Cell[BoxData["\[Micro]"], "InlineMath"],
 " or ",
 ButtonBox["\[Backslash][Micro]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Micro"],
 ". "
}], "Text",
 CellID->24258],

Cell[TextData[{
 "Some capital Greek letters such as ",
 ButtonBox["\[Backslash][CapitalAlpha]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalAlpha"],
 " look essentially the same as capital English letters. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " however treats them as different characters, and in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " it uses ",
 ButtonBox["\[Backslash][CapitalBeta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalBeta"],
 ", for example, to denote the built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27684],

Cell[TextData[{
 "Following common convention, lower\[Hyphen]case Greek letters are rendered \
slightly slanted in the standard fonts provided with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", while capital Greek letters are unslanted. On Greek systems, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will render all Greek letters unslanted so that standard Greek fonts can \
be used."
}], "Text",
 CellID->21531],

Cell[TextData[{
 "Almost all Greek letters that do not look similar to English letters are \
widely used in science and mathematics. The ",
 StyleBox["capital xi",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData["\[CapitalXi]"], "InlineMath"],
 " is rare, though it is used to denote the cascade hyperon particles, the \
grand canonical partition function and regular language complexity. The ",
 StyleBox["capital upsilon",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData["\[CapitalUpsilon]"], "InlineMath"],
 " is also rare, though it is used to denote ",
 Cell[BoxData[
  RowBox[{"b", 
   OverscriptBox["b", "_"]}]], "InlineMath"],
 " particles, as well as the vernal equinox."
}], "Text",
 CellID->2829],

Cell[TextData[{
 StyleBox["Curly Greek letters",
  FontWeight->"Bold"],
 " are often assumed to have different meanings from their ordinary \
counterparts. Indeed, in pure mathematics a single formula can sometimes \
contain both curly and ordinary forms of a particular letter. The curly pi ",
 Cell[BoxData["\[CurlyPi]"], "InlineMath"],
 " is rare, except in astronomy. "
}], "Text",
 CellID->31782],

Cell[TextData[{
 "The ",
 StyleBox["final sigma",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData["\[FinalSigma]"], "InlineMath"],
 " is used for sigmas that appear at the ends of words in written Greek; it \
is not commonly used in technical notation. "
}], "Text",
 CellID->32705],

Cell[TextData[{
 "The ",
 StyleBox["digamma",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData["\[Digamma]"], "InlineMath"],
 ", ",
 StyleBox["koppa",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData["\[Koppa]"], "InlineMath"],
 ", ",
 StyleBox["stigma",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData["\[Stigma]"], "InlineMath"],
 " and ",
 StyleBox["sampi",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData["\[Sampi]"], "InlineMath"],
 " are archaic Greek letters. These letters provide a convenient extension to \
the usual set of Greek letters. They are sometimes needed in making \
correspondences with English letters. The digamma corresponds to an English \
w, and koppa to an English q. Digamma is occasionally used to denote the \
digamma function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26162]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variants of English Letters", "Section",
 CellID->15689],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[ScriptL]", Cell[BoxData[
         ButtonBox["\\[ScriptL]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ScriptL"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["scl\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ScriptCapitalE]", Cell[BoxData[
         ButtonBox["\\[ScriptCapitalE]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ScriptCapitalE"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["scE\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ScriptCapitalH]", Cell[BoxData[
         ButtonBox["\\[ScriptCapitalH]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ScriptCapitalH"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["scH\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ScriptCapitalL]", Cell[BoxData[
         ButtonBox["\\[ScriptCapitalL]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ScriptCapitalL"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["scL\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GothicCapitalC]", Cell[BoxData[
         ButtonBox["\\[GothicCapitalC]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GothicCapitalC"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["goC\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GothicCapitalH]", Cell[BoxData[
         ButtonBox["\\[GothicCapitalH]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GothicCapitalH"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["goH\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GothicCapitalI]", Cell[BoxData[
         ButtonBox["\\[GothicCapitalI]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GothicCapitalI"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["goI\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GothicCapitalR]", Cell[BoxData[
         ButtonBox["\\[GothicCapitalR]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GothicCapitalR"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["goR\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[DoubleStruckCapitalC]", Cell[BoxData[
         ButtonBox["\\[DoubleStruckCapitalC]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleStruckCapitalC"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dsC\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleStruckCapitalR]", Cell[BoxData[
         ButtonBox["\\[DoubleStruckCapitalR]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleStruckCapitalR"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dsR\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleStruckCapitalQ]", Cell[BoxData[
         ButtonBox["\\[DoubleStruckCapitalQ]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleStruckCapitalQ"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dsQ\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleStruckCapitalZ]", Cell[BoxData[
         ButtonBox["\\[DoubleStruckCapitalZ]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleStruckCapitalZ"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dsZ\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleStruckCapitalN]", Cell[BoxData[
         ButtonBox["\\[DoubleStruckCapitalN]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleStruckCapitalN"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dsN\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DotlessI]", Cell[BoxData[
         ButtonBox["\\[DotlessI]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DotlessI"]], 
         "InlineCharacterName"], ""},
       {"\[DotlessJ]", Cell[BoxData[
         ButtonBox["\\[DotlessJ]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DotlessJ"]], 
         "InlineCharacterName"], ""},
       {"\[WeierstrassP]", Cell[BoxData[
         ButtonBox["\\[WeierstrassP]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/WeierstrassP"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["wp\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->15923],

Cell["Some commonly used variants of English letters. ", "Caption",
 CellID->30870],

Cell[TextData[{
 "By using menu items in the notebook front end, you can make changes in the \
font and style of ordinary text. However, such changes are usually discarded \
whenever you send input to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "Text",
 CellID->25342],

Cell[TextData[{
 "Script, gothic and double\[Hyphen]struck characters are, however, treated \
as fundamentally different from their ordinary forms. This means that even \
though a ",
 Cell[BoxData[
  ButtonBox["C",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/C"]], "InlineFormula"],
 " that is italic or a different size will be considered equivalent to an \
ordinary ",
 Cell[BoxData[
  ButtonBox["C",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/C"]], "InlineFormula"],
 " when fed to the kernel, a double\[Hyphen]struck ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"],
 " will not. "
}], "Text",
 CellID->9282],

Cell["\<\
Different styles and sizes of C are treated as the same by the kernel. But \
gothic and double\[Hyphen]struck characters are treated as different. \
\>", "MathCaption",
 CellID->14196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C", "+", 
  StyleBox["C",
   FontSlant->"Italic"], "+", 
  StyleBox["C",
   FontSize->16], "+", "\[GothicCapitalC]", "+", 
  "\[DoubleStruckCapitalC]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->12180],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "C"}], "+", "\[GothicCapitalC]", "+", 
  "\[DoubleStruckCapitalC]"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->742283631]
}, Open  ]],

Cell[TextData[{
 "In standard mathematical notation, capital script and gothic letters are \
sometimes used interchangeably. The double\[Hyphen]struck letters, sometimes \
called blackboard or openface letters, are conventionally used to denote \
specific sets. Thus, for example, ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"],
 " conventionally denotes the set of complex numbers, and ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"],
 " the set of integers. "
}], "Text",
 CellID->19072],

Cell["\<\
Dotless i and j are not usually taken to be different in meaning from \
ordinary i and j; they are simply used when overscripts are being placed on \
the ordinary characters. \
\>", "Text",
 CellID->18715],

Cell[TextData[{
 ButtonBox["\[Backslash][WeierstrassP]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/WeierstrassP"],
 " is a notation specifically used for the Weierstrass P function ",
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16051],

Cell[BoxData[GridBox[{
   {Cell["full names", "TableHeader"], Cell["aliases", "TableHeader"], ""},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["\\[ScriptA]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/ScriptA"]], "InlineCharacterName"],
     " \[Dash] ",
     Cell[BoxData[
      ButtonBox["\\[ScriptZ]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/ScriptZ"]], "InlineCharacterName"]
    }], "TableText"], Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["sca\[AliasIndicator]", "InlineCode"],
     " \[Dash] \[AliasIndicator]",
     StyleBox["scz\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[
    "lower\[Hyphen]case script letters", "TableText"]},
   {
    StyleBox[Cell[TextData[{
      Cell[BoxData[
       ButtonBox["\\[ScriptCapitalA]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/ScriptCapitalA"]], 
       "InlineCharacterName"],
      " \[Dash] ",
      Cell[BoxData[
       ButtonBox["\\[ScriptCapitalZ]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/ScriptCapitalZ"]], 
       "InlineCharacterName"]
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["scA\[AliasIndicator]", "InlineCode"],
     " \[Dash] \[AliasIndicator]",
     StyleBox["scZ\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[
    "upper\[Hyphen]case script letters", "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["\\[GothicA]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/GothicA"]], "InlineCharacterName"],
     " \[Dash] ",
     Cell[BoxData[
      ButtonBox["\\[GothicZ]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/GothicZ"]], "InlineCharacterName"]
    }], "TableText"], Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["goa\[AliasIndicator]", "InlineCode"],
     " \[Dash] \[AliasIndicator]",
     StyleBox["goz\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[
    "lower\[Hyphen]case gothic letters", "TableText"]},
   {
    StyleBox[Cell[TextData[{
      Cell[BoxData[
       ButtonBox["\\[GothicCapitalA]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/GothicCapitalA"]], 
       "InlineCharacterName"],
      " \[Dash] ",
      Cell[BoxData[
       ButtonBox["\\[GothicCapitalZ]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/GothicCapitalZ"]], 
       "InlineCharacterName"]
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["goA\[AliasIndicator]", "InlineCode"],
     " \[Dash] \[AliasIndicator]",
     StyleBox["goZ\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[
    "upper\[Hyphen]case gothic letters", "TableText"]},
   {
    StyleBox[Cell[TextData[{
      Cell[BoxData[
       ButtonBox["\\[DoubleStruckA]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/DoubleStruckA"]], 
       "InlineCharacterName"],
      " \[Dash] ",
      Cell[BoxData[
       ButtonBox["\\[DoubleStruckZ]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/DoubleStruckZ"]], 
       "InlineCharacterName"]
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["dsa\[AliasIndicator]", "InlineCode"],
     " \[Dash] \[AliasIndicator]",
     StyleBox["dsz\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell["\<\
lower\[Hyphen]case double\[Hyphen]struck letters\
\>", "TableText"]},
   {
    StyleBox[Cell[TextData[{
      Cell[BoxData[
       ButtonBox["\\[DoubleStruckCapitalA]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/DoubleStruckCapitalA"]], 
       "InlineCharacterName"],
      "\[NonBreakingSpace]\[Dash] ",
      Cell[BoxData[
       ButtonBox["\\[DoubleStruckCapitalZ]",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/DoubleStruckCapitalZ"]], 
       "InlineCharacterName"]
     }], "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["dsA\[AliasIndicator]", "InlineCode"],
     " \[Dash] \[AliasIndicator]",
     StyleBox["dsZ\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell["\<\
upper\[Hyphen]case double\[Hyphen]struck letters\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, True, False, False, True, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.3]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24736],

Cell["Complete alphabets of variant English letters. ", "Caption",
 CellID->11755]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hebrew Letters", "Section",
 CellID->15174],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Aleph]", Cell[BoxData[
         ButtonBox["\\[Aleph]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Aleph"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["al\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Bet]", Cell[BoxData[
         ButtonBox["\\[Bet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Bet"]], "InlineCharacterName"], 
        ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[Gimel]", Cell[BoxData[
         ButtonBox["\\[Gimel]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Gimel"]], "InlineCharacterName"], 
        ""},
       {"\[Dalet]", Cell[BoxData[
         ButtonBox["\\[Dalet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Dalet"]], "InlineCharacterName"], 
        ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->18477],

Cell["Hebrew characters. ", "Caption",
 CellID->1154],

Cell[TextData[{
 "Hebrew characters are used in mathematics in the theory of transfinite \
sets; ",
 Cell[BoxData[
  SubscriptBox["\[Aleph]", "0"]], "InlineMath"],
 " is for example used to denote the total number of integers. "
}], "Text",
 CellID->24729]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Units and Letter\[Hyphen]Like Mathematical Symbols\
\>", "Section",
 CellID->10882],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Micro]", Cell[BoxData[
         ButtonBox["\\[Micro]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Micro"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["mi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Mho]", Cell[BoxData[
         ButtonBox["\\[Mho]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Mho"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["mho\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Angstrom]", Cell[BoxData[
         ButtonBox["\\[Angstrom]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Angstrom"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Ang\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[HBar]", Cell[BoxData[
         ButtonBox["\\[HBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HBar"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["hb\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Cent]", Cell[BoxData[
         ButtonBox["\\[Cent]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Cent"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cent\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Sterling]", Cell[BoxData[
         ButtonBox["\\[Sterling]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sterling"]], 
         "InlineCharacterName"], ""},
       {"\[Euro]", Cell[BoxData[
         ButtonBox["\\[Euro]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Euro"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["euro\[AliasIndicator]", "InlineCode"]
        }]]},
       {"\[Yen]", Cell[BoxData[
         ButtonBox["\\[Yen]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Yen"]], "InlineCharacterName"], 
        ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Degree]", Cell[BoxData[
         ButtonBox["\\[Degree]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Degree"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["deg\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EmptySet]", Cell[BoxData[
         ButtonBox["\\[EmptySet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptySet"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["es\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Infinity]", Cell[BoxData[
         ButtonBox["\\[Infinity]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Infinity"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["inf\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ExponentialE]", Cell[BoxData[
         ButtonBox["\\[ExponentialE]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ExponentialE"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ee\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ImaginaryI]", Cell[BoxData[
         ButtonBox["\\[ImaginaryI]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ImaginaryI"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ii\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ImaginaryJ]", Cell[BoxData[
         ButtonBox["\\[ImaginaryJ]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ImaginaryJ"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["jj\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubledPi]", Cell[BoxData[
         ButtonBox["\\[DoubledPi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubledPi"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["pp\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubledGamma]", Cell[BoxData[
         ButtonBox["\\[DoubledGamma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubledGamma"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["gg\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->15851],

Cell["\<\
Units and letter\[Hyphen]like mathematical symbols. \
\>", "Caption",
 CellID->19769],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats ",
 Cell[BoxData[
  FormBox["\[Degree]", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  ButtonBox["\\[Degree]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Degree"]], "InlineCharacterName"],
 " as the symbol ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 ", so that, for example, ",
 Cell[BoxData[
  RowBox[{"30", "\[Degree]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"30", 
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11237],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  FormBox["\[Micro]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Angstrom]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[EmptySet]", TraditionalForm]], "InlineMath"],
 " are all distinct from the ordinary letters ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
 " (",
 Cell[BoxData[
  ButtonBox[
   ButtonBox["\\[Mu]",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/character/Mu"],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Degree"]], "InlineCharacterName"],
 "), ",
 Cell[BoxData[
  FormBox["\[CapitalARing]", TraditionalForm]], "InlineMath"],
 " (",
 Cell[BoxData[
  ButtonBox["\\[CapitalARing]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CapitalARing"]], "InlineCharacterName"],
 ") and ",
 Cell[BoxData[
  FormBox["\[CapitalOSlash]", TraditionalForm]], "InlineMath"],
 " (",
 Cell[BoxData[
  ButtonBox["\\[CapitalOSlash]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CapitalOSlash"]], 
  "InlineCharacterName"],
 "). "
}], "Text",
 CellID->28301],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interprets ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 ", and both ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[ImaginaryJ]", TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ". The characters ",
 Cell[BoxData[
  FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[ImaginaryJ]", TraditionalForm]], "InlineMath"],
 " are provided as alternatives to the usual upper\[Hyphen]case letters ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15676],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[DoubledPi]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[DoubledGamma]", TraditionalForm]], "InlineMath"],
 " are not by default assigned meanings in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". You can therefore use ",
 Cell[BoxData[
  FormBox["\[DoubledPi]", TraditionalForm]], "InlineMath"],
 " to represent a pi that will not automatically be treated as ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ". In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DoubledGamma]", TraditionalForm]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13604],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[PartialD]", Cell[BoxData[
         ButtonBox["\\[PartialD]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/PartialD"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["pd\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DifferentialD]", Cell[BoxData[
         ButtonBox["\\[DifferentialD]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DifferentialD"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dd\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalDifferentialD]", Cell[BoxData[
         ButtonBox["\\[CapitalDifferentialD]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalDifferentialD"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["DD\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Del]", Cell[BoxData[
         ButtonBox["\\[Del]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Del"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["del\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Sum]", Cell[BoxData[
         ButtonBox["\\[Sum]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sum\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Product]", Cell[BoxData[
         ButtonBox["\\[Product]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Product"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["prod\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Transpose]", Cell[BoxData[
         ButtonBox["\\[Transpose]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Transpose"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["tr\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[HermitianConjugate]", Cell[BoxData[
         ButtonBox["\\[HermitianConjugate]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HermitianConjugate"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["hc\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->27073],

Cell["Operators that look like letters. ", "Caption",
 CellID->24161],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Del]", TraditionalForm]], "InlineMath"],
 " is an operator while ",
 Cell[BoxData[
  FormBox["\[HBar]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Degree]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Yen]", TraditionalForm]], "InlineMath"],
 " are ordinary symbols. "
}], "MathCaption",
 CellID->21197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Del]", " ", "f"}], ",", 
    RowBox[{"\[HBar]", "^", "2"}], ",", 
    RowBox[{"45", "\[Degree]"}], ",", 
    RowBox[{"5000", "\[Yen]"}]}], "}"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8595],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"Del", "[", "f", "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"\\[HBar]", ",", "2"}], "]"}], ",", 
     RowBox[{"Times", "[", 
      RowBox[{"45", ",", "Degree"}], "]"}], ",", 
     RowBox[{"Times", "[", 
      RowBox[{"5000", ",", "\\[Yen]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm= ",
 CellID->2125]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shapes, Icons and Geometrical Constructs", "Section",
 CellID->5485],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[FilledVerySmallSquare]", Cell[BoxData[
         ButtonBox["\\[FilledVerySmallSquare]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledVerySmallSquare"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["fvssq\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EmptySmallSquare]", Cell[BoxData[
         ButtonBox["\\[EmptySmallSquare]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptySmallSquare"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["essq\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[FilledSmallSquare]", Cell[BoxData[
         ButtonBox["\\[FilledSmallSquare]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledSmallSquare"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["fssq\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EmptySquare]", Cell[BoxData[
         ButtonBox["\\[EmptySquare]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptySquare"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["esq\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GraySquare]", Cell[BoxData[
         ButtonBox["\\[GraySquare]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GraySquare"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["gsq\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[FilledSquare]", Cell[BoxData[
         ButtonBox["\\[FilledSquare]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledSquare"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["fsq\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DottedSquare]", Cell[BoxData[
         ButtonBox["\\[DottedSquare]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DottedSquare"]], 
         "InlineCharacterName"], ""},
       {"\[EmptyRectangle]", Cell[BoxData[
         ButtonBox["\\[EmptyRectangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptyRectangle"]], 
         "InlineCharacterName"], ""},
       {"\[FilledRectangle]", Cell[BoxData[
         ButtonBox["\\[FilledRectangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledRectangle"]], 
         "InlineCharacterName"], ""},
       {"\[EmptyDiamond]", Cell[BoxData[
         ButtonBox["\\[EmptyDiamond]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptyDiamond"]], 
         "InlineCharacterName"], ""},
       {"\[FilledDiamond]", Cell[BoxData[
         ButtonBox["\\[FilledDiamond]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledDiamond"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[EmptySmallCircle]", Cell[BoxData[
         ButtonBox["\\[EmptySmallCircle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptySmallCircle"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["esci\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[FilledSmallCircle]", Cell[BoxData[
         ButtonBox["\\[FilledSmallCircle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledSmallCircle"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["fsci\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EmptyCircle]", Cell[BoxData[
         ButtonBox["\\[EmptyCircle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptyCircle"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["eci\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GrayCircle]", Cell[BoxData[
         ButtonBox["\\[GrayCircle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GrayCircle"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["gci\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[FilledCircle]", Cell[BoxData[
         ButtonBox["\\[FilledCircle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledCircle"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["fci\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EmptyUpTriangle]", Cell[BoxData[
         ButtonBox["\\[EmptyUpTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptyUpTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[FilledUpTriangle]", Cell[BoxData[
         ButtonBox["\\[FilledUpTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledUpTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[EmptyDownTriangle]", Cell[BoxData[
         ButtonBox["\\[EmptyDownTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptyDownTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[FilledDownTriangle]", Cell[BoxData[
         ButtonBox["\\[FilledDownTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FilledDownTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[FivePointedStar]", Cell[BoxData[
         ButtonBox["\\[FivePointedStar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FivePointedStar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["*5\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SixPointedStar]", Cell[BoxData[
         ButtonBox["\\[SixPointedStar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SixPointedStar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["*6\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->15062],

Cell["Shapes. ", "Caption",
 CellID->29229],

Cell[TextData[{
 "Shapes are most often used as \[OpenCurlyDoubleQuote]dingbats\
\[CloseCurlyDoubleQuote] to emphasize pieces of text. But ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats them as letter\[Hyphen]like forms, and also allows them to appear \
in the names of symbols. "
}], "Text",
 CellID->27560],

Cell[TextData[{
 "In addition to shapes such as ",
 Cell[BoxData[
  ButtonBox["\\[EmptySquare]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/EmptySquare"]], "InlineCharacterName"],
 ", there are characters such as ",
 Cell[BoxData[
  ButtonBox["\\[Square]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Square"]], "InlineCharacterName"],
 " which are treated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as operators rather than letter\[Hyphen]like forms. "
}], "Text",
 CellID->7718],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[MathematicaIcon]", Cell[BoxData[
         ButtonBox["\\[MathematicaIcon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/MathematicaIcon"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["math\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[KernelIcon]", Cell[BoxData[
         ButtonBox["\\[KernelIcon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/KernelIcon"]], 
         "InlineCharacterName"], ""},
       {"\[LightBulb]", Cell[BoxData[
         ButtonBox["\\[LightBulb]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LightBulb"]], 
         "InlineCharacterName"], ""},
       {"\[WarningSign]", Cell[BoxData[
         ButtonBox["\\[WarningSign]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/WarningSign"]], 
         "InlineCharacterName"], ""},
       {"\[WatchIcon]", Cell[BoxData[
         ButtonBox["\\[WatchIcon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/WatchIcon"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "aliases", "TableHeader"]},
       {"\[HappySmiley]", Cell[BoxData[
         ButtonBox["\\[HappySmiley]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HappySmiley"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         Cell[BoxData[
          RowBox[{":", ")", "\[AliasIndicator]"}]], "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox[":-)\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NeutralSmiley]", Cell[BoxData[
         ButtonBox["\\[NeutralSmiley]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NeutralSmiley"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[":-|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SadSmiley]", Cell[BoxData[
         ButtonBox["\\[SadSmiley]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SadSmiley"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[":-(\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[FreakedSmiley]", Cell[BoxData[
         ButtonBox["\\[FreakedSmiley]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/FreakedSmiley"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[":-@\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Wolf]", Cell[BoxData[
         ButtonBox["\\[Wolf]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Wolf"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["wf\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["wolf\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->29073],

Cell["Icons. ", "Caption",
 CellID->8079],

Cell["\<\
You can use icon characters just like any other letter\[Hyphen]like forms. \
\>", "MathCaption",
 CellID->8709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[HappySmiley]", "+", "\[Wolf]"}], ")"}], "^", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->9662],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[HappySmiley]", "4"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["\[HappySmiley]", "3"], " ", "\[Wolf]"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["\[HappySmiley]", "2"], " ", 
   SuperscriptBox["\[Wolf]", "2"]}], "+", 
  RowBox[{"4", " ", "\[HappySmiley]", " ", 
   SuperscriptBox["\[Wolf]", "3"]}], "+", 
  SuperscriptBox["\[Wolf]", "4"]}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->10224]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[Angle]", Cell[BoxData[
         ButtonBox["\\[Angle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Angle"]], "InlineCharacterName"], 
        ""},
       {"\[RightAngle]", Cell[BoxData[
         ButtonBox["\\[RightAngle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightAngle"]], 
         "InlineCharacterName"], ""},
       {"\[MeasuredAngle]", Cell[BoxData[
         ButtonBox["\\[MeasuredAngle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/MeasuredAngle"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[SphericalAngle]", Cell[BoxData[
         ButtonBox["\\[SphericalAngle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SphericalAngle"]], 
         "InlineCharacterName"], ""},
       {"\[EmptyUpTriangle]", Cell[BoxData[
         ButtonBox["\\[EmptyUpTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptyUpTriangle"]], 
         "InlineCharacterName"], ""},
       {"\[Diameter]", Cell[BoxData[
         ButtonBox["\\[Diameter]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Diameter"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->11574],

Cell["Notation for geometrical constructs. ", "Caption",
 CellID->7682],

Cell[TextData[{
 "Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats characters like ",
 Cell[BoxData[
  FormBox["\[Angle]", TraditionalForm]], "InlineMath"],
 " as letter\[Hyphen]like forms, constructs like ",
 Cell[BoxData[
  FormBox["\[Angle]BC", TraditionalForm]], "InlineMath"],
 " are treated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as single symbols. "
}], "Text",
 CellID->7475]
}, Open  ]],

Cell[CellGroupData[{

Cell["Textual Elements", "Section",
 CellID->28815],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Dash]", Cell[BoxData[
         ButtonBox["\\[Dash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Dash"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LongDash]", Cell[BoxData[
         ButtonBox["\\[LongDash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LongDash"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["--\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Bullet]", Cell[BoxData[
         ButtonBox["\\[Bullet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Bullet"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["bu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Paragraph]", Cell[BoxData[
         ButtonBox["\\[Paragraph]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Paragraph"]], 
         "InlineCharacterName"], ""},
       {"\[Section]", Cell[BoxData[
         ButtonBox["\\[Section]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Section"]], 
         "InlineCharacterName"], ""},
       {"\[DownQuestion]", Cell[BoxData[
         ButtonBox["\\[DownQuestion]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownQuestion"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["d?\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DownExclamation]", Cell[BoxData[
         ButtonBox["\\[DownExclamation]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DownExclamation"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["d!\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Prime]", Cell[BoxData[
         ButtonBox["\\[Prime]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Prime"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoublePrime]", Cell[BoxData[
         ButtonBox["\\[DoublePrime]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoublePrime"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["''\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ReversePrime]", Cell[BoxData[
         ButtonBox["\\[ReversePrime]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ReversePrime"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ReverseDoublePrime]", Cell[BoxData[
         ButtonBox["\\[ReverseDoublePrime]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ReverseDoublePrime"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["``\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftGuillemet]", Cell[BoxData[
         ButtonBox["\\[LeftGuillemet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftGuillemet"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["g<<\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightGuillemet]", Cell[BoxData[
         ButtonBox["\\[RightGuillemet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightGuillemet"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["g>>\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Ellipsis]", Cell[BoxData[
         ButtonBox["\\[Ellipsis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Ellipsis"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["...\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->29343],

Cell["Characters used for punctuation and annotation. ", "Caption",
 CellID->27446],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
       {"\[Copyright]", Cell[BoxData[
         ButtonBox["\\[Copyright]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Copyright"]], 
         "InlineCharacterName"], ""},
       {"\[RegisteredTrademark]", Cell[BoxData[
         ButtonBox["\\[RegisteredTrademark]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RegisteredTrademark"]], 
         "InlineCharacterName"], ""},
       {"\[Trademark]", Cell[BoxData[
         ButtonBox["\\[Trademark]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Trademark"]], 
         "InlineCharacterName"], ""},
       {"\[Flat]", Cell[BoxData[
         ButtonBox["\\[Flat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Flat"]], "InlineCharacterName"], 
        ""},
       {"\[Natural]", Cell[BoxData[
         ButtonBox["\\[Natural]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Natural"]], 
         "InlineCharacterName"], ""},
       {"\[Sharp]", Cell[BoxData[
         ButtonBox["\\[Sharp]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sharp"]], "InlineCharacterName"], 
        ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[Dagger]", Cell[BoxData[
         ButtonBox["\\[Dagger]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Dagger"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dg\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleDagger]", Cell[BoxData[
         ButtonBox["\\[DoubleDagger]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleDagger"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ddg\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ClubSuit]", Cell[BoxData[
         ButtonBox["\\[ClubSuit]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ClubSuit"]], 
         "InlineCharacterName"], ""},
       {"\[DiamondSuit]", Cell[BoxData[
         ButtonBox["\\[DiamondSuit]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DiamondSuit"]], 
         "InlineCharacterName"], ""},
       {"\[HeartSuit]", Cell[BoxData[
         ButtonBox["\\[HeartSuit]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HeartSuit"]], 
         "InlineCharacterName"], ""},
       {"\[SpadeSuit]", Cell[BoxData[
         ButtonBox["\\[SpadeSuit]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SpadeSuit"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->27532],

Cell["Other characters used in text. ", "Caption",
 CellID->14568],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[HorizontalLine]", Cell[BoxData[
         ButtonBox["\\[HorizontalLine]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HorizontalLine"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["hline\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[VerticalLine]", Cell[BoxData[
         ButtonBox["\\[VerticalLine]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalLine"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["vline\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Ellipsis]", Cell[BoxData[
         ButtonBox["\\[Ellipsis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Ellipsis"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["...\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CenterEllipsis]", Cell[BoxData[
         ButtonBox["\\[CenterEllipsis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CenterEllipsis"]], 
         "InlineCharacterName"], ""},
       {"\[VerticalEllipsis]", Cell[BoxData[
         ButtonBox["\\[VerticalEllipsis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalEllipsis"]], 
         "InlineCharacterName"], ""},
       {"\[AscendingEllipsis]", Cell[BoxData[
         ButtonBox["\\[AscendingEllipsis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/AscendingEllipsis"]], 
         "InlineCharacterName"], ""},
       {"\[DescendingEllipsis]", Cell[BoxData[
         ButtonBox["\\[DescendingEllipsis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DescendingEllipsis"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[UnderParenthesis]", Cell[BoxData[
         ButtonBox["\\[UnderParenthesis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UnderParenthesis"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u(\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OverParenthesis]", Cell[BoxData[
         ButtonBox["\\[OverParenthesis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OverParenthesis"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o(\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UnderBracket]", Cell[BoxData[
         ButtonBox["\\[UnderBracket]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UnderBracket"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u[\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OverBracket]", Cell[BoxData[
         ButtonBox["\\[OverBracket]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OverBracket"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o[\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UnderBrace]", Cell[BoxData[
         ButtonBox["\\[UnderBrace]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UnderBrace"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u{\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OverBrace]", Cell[BoxData[
         ButtonBox["\\[OverBrace]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OverBrace"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o{\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->32684],

Cell["Characters used in building sequences and arrays. ", "Caption",
 CellID->4361],

Cell["\<\
The under and over braces grow to enclose the whole expression. \
\>", "MathCaption",
 CellID->5472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underoverscript", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "4"}], "]"}], ",", "\[UnderBrace]",
    ",", "\[OverBrace]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->25286],

Cell[BoxData[
 UnderoverscriptBox[
  RowBox[{"1", "+", 
   RowBox[{"4", " ", "x"}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   SuperscriptBox["x", "4"]}], "\[UnderBrace]", "\[OverBrace]"]], "Output",
 ImageSize->{136, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->8266]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extended Latin Letters", "Section",
 CellID->6089],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports all the characters commonly used in Western European languages \
based on Latin scripts. "
}], "Text",
 CellID->32151],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[AGrave]", Cell[BoxData[
         ButtonBox["\\[AGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/AGrave"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["a`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[AAcute]", Cell[BoxData[
         ButtonBox["\\[AAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/AAcute"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["a'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[AHat]", Cell[BoxData[
         ButtonBox["\\[AHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/AHat"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["a^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ATilde]", Cell[BoxData[
         ButtonBox["\\[ATilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ATilde"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["a~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ADoubleDot]", Cell[BoxData[
         ButtonBox["\\[ADoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ADoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["a\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ARing]", Cell[BoxData[
         ButtonBox["\\[ARing]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ARing"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ao\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ABar]", Cell[BoxData[
         ButtonBox["\\[ABar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ABar"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["a-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ACup]", Cell[BoxData[
         ButtonBox["\\[ACup]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ACup"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["au\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[AE]", Cell[BoxData[
         ButtonBox["\\[AE]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/AE"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["ae\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CAcute]", Cell[BoxData[
         ButtonBox["\\[CAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CAcute"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CCedilla]", Cell[BoxData[
         ButtonBox["\\[CCedilla]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CCedilla"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c,\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CHacek]", Cell[BoxData[
         ButtonBox["\\[CHacek]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CHacek"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["cv\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EGrave]", Cell[BoxData[
         ButtonBox["\\[EGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EGrave"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["e`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EAcute]", Cell[BoxData[
         ButtonBox["\\[EAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EAcute"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["e'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EBar]", Cell[BoxData[
         ButtonBox["\\[EBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EBar"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["e-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EHat]", Cell[BoxData[
         ButtonBox["\\[EHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EHat"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["e^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EDoubleDot]", Cell[BoxData[
         ButtonBox["\\[EDoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EDoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["e\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ECup]", Cell[BoxData[
         ButtonBox["\\[ECup]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ECup"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["eu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[IGrave]", Cell[BoxData[
         ButtonBox["\\[IGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/IGrave"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["i`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[IAcute]", Cell[BoxData[
         ButtonBox["\\[IAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/IAcute"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["i'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[IHat]", Cell[BoxData[
         ButtonBox["\\[IHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/IHat"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["i^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[IDoubleDot]", Cell[BoxData[
         ButtonBox["\\[IDoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/IDoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["i\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ICup]", Cell[BoxData[
         ButtonBox["\\[ICup]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ICup"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["iu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Eth]", Cell[BoxData[
         ButtonBox["\\[Eth]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Eth"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["d-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LSlash]", Cell[BoxData[
         ButtonBox["\\[LSlash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LSlash"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["l/\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NTilde]", Cell[BoxData[
         ButtonBox["\\[NTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NTilde"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["n~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OGrave]", Cell[BoxData[
         ButtonBox["\\[OGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OGrave"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OAcute]", Cell[BoxData[
         ButtonBox["\\[OAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OAcute"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OHat]", Cell[BoxData[
         ButtonBox["\\[OHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OHat"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OTilde]", Cell[BoxData[
         ButtonBox["\\[OTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OTilde"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ODoubleDot]", Cell[BoxData[
         ButtonBox["\\[ODoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ODoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ODoubleAcute]", Cell[BoxData[
         ButtonBox["\\[ODoubleAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ODoubleAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o''\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[OSlash]", Cell[BoxData[
         ButtonBox["\\[OSlash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/OSlash"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["o/\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SHacek]", Cell[BoxData[
         ButtonBox["\\[SHacek]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SHacek"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sv\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UGrave]", Cell[BoxData[
         ButtonBox["\\[UGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UGrave"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UAcute]", Cell[BoxData[
         ButtonBox["\\[UAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UAcute"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UHat]", Cell[BoxData[
         ButtonBox["\\[UHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UHat"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UDoubleDot]", Cell[BoxData[
         ButtonBox["\\[UDoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UDoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UDoubleAcute]", Cell[BoxData[
         ButtonBox["\\[UDoubleAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UDoubleAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["u''\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[YAcute]", Cell[BoxData[
         ButtonBox["\\[YAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/YAcute"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["y'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Thorn]", Cell[BoxData[
         ButtonBox["\\[Thorn]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Thorn"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["thn\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SZ]", Cell[BoxData[
         ButtonBox["\\[SZ]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SZ"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sz\[AliasIndicator]", "InlineCode"],
         ", \[AliasIndicator]",
         StyleBox["ss\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
        "alias", "TableHeader"]},
       {"\[CapitalAGrave]", Cell[BoxData[
         ButtonBox["\\[CapitalAGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalAGrave"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["A`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalAAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalAAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalAAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["A'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalAHat]", Cell[BoxData[
         ButtonBox["\\[CapitalAHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalAHat"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["A^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalATilde]", Cell[BoxData[
         ButtonBox["\\[CapitalATilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalATilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["A~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalADoubleDot]", Cell[BoxData[
         ButtonBox["\\[CapitalADoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalADoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["A\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalARing]", Cell[BoxData[
         ButtonBox["\\[CapitalARing]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalARing"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Ao\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalABar]", Cell[BoxData[
         ButtonBox["\\[CapitalABar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalABar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["A-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalACup]", Cell[BoxData[
         ButtonBox["\\[CapitalACup]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalACup"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Au\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalAE]", Cell[BoxData[
         ButtonBox["\\[CapitalAE]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalAE"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["AE\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalCAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalCAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalCAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["C'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalCCedilla]", Cell[BoxData[
         ButtonBox["\\[CapitalCCedilla]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalCCedilla"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["C,\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalCHacek]", Cell[BoxData[
         ButtonBox["\\[CapitalCHacek]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalCHacek"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Cv\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEGrave]", Cell[BoxData[
         ButtonBox["\\[CapitalEGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEGrave"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["E`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalEAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["E'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEBar]", Cell[BoxData[
         ButtonBox["\\[CapitalEBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["E-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEHat]", Cell[BoxData[
         ButtonBox["\\[CapitalEHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEHat"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["E^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEDoubleDot]", Cell[BoxData[
         ButtonBox["\\[CapitalEDoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEDoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["E\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalECup]", Cell[BoxData[
         ButtonBox["\\[CapitalECup]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalECup"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Eu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalIGrave]", Cell[BoxData[
         ButtonBox["\\[CapitalIGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalIGrave"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["I`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalIAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalIAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalIAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["I'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalIHat]", Cell[BoxData[
         ButtonBox["\\[CapitalIHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalIHat"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["I^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalIDoubleDot]", Cell[BoxData[
         ButtonBox["\\[CapitalIDoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalIDoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["I\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalICup]", Cell[BoxData[
         ButtonBox["\\[CapitalICup]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalICup"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Iu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalEth]", Cell[BoxData[
         ButtonBox["\\[CapitalEth]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalEth"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["D-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalLSlash]", Cell[BoxData[
         ButtonBox["\\[CapitalLSlash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalLSlash"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["L/\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalNTilde]", Cell[BoxData[
         ButtonBox["\\[CapitalNTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalNTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["N~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalOGrave]", Cell[BoxData[
         ButtonBox["\\[CapitalOGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOGrave"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalOAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalOAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalOHat]", Cell[BoxData[
         ButtonBox["\\[CapitalOHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOHat"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalOTilde]", Cell[BoxData[
         ButtonBox["\\[CapitalOTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalODoubleDot]", Cell[BoxData[
         ButtonBox["\\[CapitalODoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalODoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalODoubleAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalODoubleAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalODoubleAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O''\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalOSlash]", Cell[BoxData[
         ButtonBox["\\[CapitalOSlash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOSlash"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["O/\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalSHacek]", Cell[BoxData[
         ButtonBox["\\[CapitalSHacek]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalSHacek"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Sv\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalUGrave]", Cell[BoxData[
         ButtonBox["\\[CapitalUGrave]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalUGrave"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["U`\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalUAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalUAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalUAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["U'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalUHat]", Cell[BoxData[
         ButtonBox["\\[CapitalUHat]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalUHat"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["U^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalUDoubleDot]", Cell[BoxData[
         ButtonBox["\\[CapitalUDoubleDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalUDoubleDot"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["U\"\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalUDoubleAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalUDoubleAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalUDoubleAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["U''\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalYAcute]", Cell[BoxData[
         ButtonBox["\\[CapitalYAcute]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalYAcute"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Y'\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CapitalThorn]", Cell[BoxData[
         ButtonBox["\\[CapitalThorn]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalThorn"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Thn\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->4604],

Cell["Variants of English letters. ", "Caption",
 CellID->17233],

Cell[TextData[{
 "Most of the characters shown are formed by adding diacritical marks to \
ordinary English letters. Exceptions include ",
 Cell[BoxData[
  ButtonBox["\\[SZ]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/SZ"]], "InlineCharacterName"],
 " ",
 Cell[BoxData[
  FormBox["\[SZ]", TraditionalForm]], "InlineMath"],
 ", used in German, and ",
 Cell[BoxData[
  ButtonBox["\\[Thorn]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Thorn"]], "InlineCharacterName"],
 " ",
 Cell[BoxData[
  FormBox["\[Thorn]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  ButtonBox["\\[Eth]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Eth"]], "InlineCharacterName"],
 " ",
 Cell[BoxData[
  FormBox["\[Eth]", TraditionalForm]], "InlineMath"],
 ", used primarily in Old English. "
}], "Text",
 CellID->25594],

Cell["\<\
You can make additional characters by explicitly adding diacritical marks \
yourself. \
\>", "Text",
 CellID->9076],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["char", "TI"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ",
     StyleBox["mark", "TI"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell["add a mark above a character", "TableText"]},
   {Cell[TextData[{
     StyleBox["char", "TI"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["+", "KeyEvent"],
     " ",
     StyleBox["mark", "TI"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell["add a mark below a character", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->598],

Cell["Adding marks above and below characters. ", "Caption",
 CellID->18604],

Cell[BoxData[GridBox[{
   {Cell["form", "TableHeader"], Cell["alias", "TableHeader"], Cell[
    "full name", "TableHeader"], ""},
   {"'", Cell["(keyboard character)", "TableText"], Cell[BoxData[
     ButtonBox["\\[RawQuote]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/RawQuote"]], "InlineCharacterName"], 
    Cell["acute accent", "TableText"]},
   {"\[Prime]", Cell[TextData[{
     "\[AliasIndicator]",
     Cell[BoxData[
      RowBox[{"'", "\[AliasIndicator]"}]], "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[Prime]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Prime"]], "InlineCharacterName"], 
    Cell["acute accent", "TableText"]},
   {"`", Cell["(keyboard character)", "TableText"], Cell[BoxData[
     ButtonBox["\\[RawBackquote]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/RawBackquote"]], 
     "InlineCharacterName"], Cell["grave accent", "TableText"]},
   {"\[ReversePrime]", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["`\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[ReversePrime]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/ReversePrime"]], 
     "InlineCharacterName"], Cell["grave accent", "TableText"]},
   {
    RowBox[{".", " ", "."}], Cell["(keyboard characters)", "TableText"], Cell[
    "", "TableText"], Cell["umlaut or diaeresis", "TableText"]},
   {"^", Cell["(keyboard character)", "TableText"], Cell[BoxData[
     ButtonBox["\\[RawWedge]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/RawWedge"]], "InlineCharacterName"], 
    Cell["circumflex or hat", "TableText"]},
   {"\[EmptySmallCircle]", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["esci\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[EmptySmallCircle]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/EmptySmallCircle"]], 
     "InlineCharacterName"], Cell["ring", "TableText"]},
   {".", Cell["(keyboard character)", "TableText"], Cell[BoxData[
     ButtonBox["\\[RawDot]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/RawDot"]], "InlineCharacterName"], 
    Cell["dot", "TableText"]},
   {"~", Cell["(keyboard character)", "TableText"], Cell[BoxData[
     ButtonBox["\\[RawTilde]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/RawTilde"]], "InlineCharacterName"], 
    Cell["tilde", "TableText"]},
   {"_", Cell["(keyboard character)", "TableText"], Cell[BoxData[
     ButtonBox["\\[RawUnderscore]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/RawUnderscore"]], 
     "InlineCharacterName"], Cell["bar or macron", "TableText"]},
   {"\[Hacek]", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["hc\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[Hacek]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Hacek"]], "InlineCharacterName"], 
    Cell["hacek or check", "TableText"]},
   {"\[Breve]", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["bv\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[Breve]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Breve"]], "InlineCharacterName"], 
    Cell["breve", "TableText"]},
   {"\[DownBreve]", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["dbv\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[DownBreve]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/DownBreve"]], "InlineCharacterName"], 
    Cell["tie accent", "TableText"]},
   {"\[DoublePrime]", Cell[TextData[{
     "\[AliasIndicator]",
     Cell[BoxData[
      RowBox[{"''", "\[AliasIndicator]"}]], "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[DoublePrime]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/DoublePrime"]], 
     "InlineCharacterName"], Cell["long umlaut", "TableText"]},
   {"\[Cedilla]", Cell[TextData[{
     "\[AliasIndicator]",
     StyleBox["cd\[AliasIndicator]", "InlineCode"]
    }], "TableText"], Cell[BoxData[
     ButtonBox["\\[Cedilla]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Cedilla"]], "InlineCharacterName"], 
    Cell["cedilla", "TableText"]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.05], 
     Scaled[0.3], 
     Scaled[0.3], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23533],

Cell["Diacritical marks to add to characters. ", "Caption",
 CellID->468],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->150221361],

Cell[TextData[ButtonBox["Mathematical and Other Notation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "RelatedTutorials",\

 CellID->5715683]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Letters and Letter-like Forms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical and Other Notation", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LettersAndLetterLikeForms#15689"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 21.8503554}", "context" -> "", 
    "keywords" -> {
     "above parenthesis", "accented characters", "accents", "ligature", 
      "\\ae (TeX)", "\\AE (TeX)", "agemo", "aggregating brace", "Aleph", 
      "antique fonts", "Bar", "below parenthesis", "bet", "\\beth (TeX)", 
      "\\bigcirc (TeX)", "blackboard characters", "black letter characters", 
      "\\blacklozenge (TeX)", "bottom parenthesis", "brace", "bracket", 
      "breve", "breve mark", "bulb", "bullet", "calligraphic characters", 
      "\\cal (TeX)", "CapitalAE", "CapitalDifferentialD", "CapitalEth", 
      "CapitalLSlash", "CapitalOSlash", "cards", "cascade hyperons", 
      "\\cdots (TeX)", "CenterEllipsis", "check", "\\circledR (TeX)", 
      "\\circ (TeX)", "circumflex", "commercial notation", "continuation", 
      "cup accent", "CurlyEpsilon", "curly epsilon", "CurlyPhi", "curly phi", 
      "CurlyPi", "curly pi", "CurlyRho", "curly rho", "CurlyTheta", 
      "curly theta", "currency", "currency signs", "cursive characters", 
      "Dalet", "\\daleth (TeX)", "danger", "star of David", "Dbar", 
      "\\ddots (TeX)", "\\ddot (TeX)", "Del", "DescendingEllipsis", 
      "diacritical marks", "diagonal ellipsis", "diereses", "dingbat", 
      "Dirac constant", "DotlessI", "DotlessJ", "DoubledGamma", "DoublePrime",
       "DoubleStruckCapitalN", "DoubleStruckCapitalP", "DoubleStruckCapitalQ",
       "DoubleStruckCapitalR", "DoubleStruckCapitalZ", "DownBreve", 
      "ellipsis", "\\ell (TeX)", "emf", "EmptyCircle", "EmptySet", 
      "\\emptyset (TeX)", "EmptySmallCircle", "EmptySquare", 
      "EmptyUpTriangle", "end of proof", "equinox", "Esszed", "Euler gamma", 
      "euro", "European characters", "European currency", "face", "feet", 
      "FilledCircle", "FilledDiamond", "FilledRectangle", "FilledSmallCircle",
       "FilledSquare", "FinalSigma", "FivePointedStar", "foreign characters", 
      "Fraktur characters", "Fraktur typeface", "FreakedSmiley", 
      "French characters", "frowning smiley", "functional derivative", 
      "geometry", "German characters", "German gothic characters", 
      "GothicCapitalI", "GothicCapitalR", "Hacek", "Hamiltonian density", 
      "HappySmiley", "hat", "HBar", "\\hbar (TeX)", "HorizontalLine", 
      "\\hslash (TeX)", "\\H (TeX)", "Hungarian long umlaut", "hyperon", "I", 
      "\\imath (TeX)", "\\Im (TeX)", "inches", "\\infty (TeX)", "inspiration",
       "integers", "Italian characters", "\\i (TeX)", "j", "\\jmath (TeX)", 
      "\\j (TeX)", "Lagrangian density", "\\ldots (TeX)", "LeftGuillemet", 
      "Lie derivative", "LightBulb", "Long characters", "LSlash", "\\l (TeX)",
       "\\L (TeX)", "macron mark", "MathematicaIcon", "Mho", "minutes", 
      "musical notation", "\\nabla (TeX)", "natural numbers", "ohm", 
      "old English", "Omegapi", "omitted elements", "Openface characters", 
      "OSlash", "\\o (TeX)", "\\O (TeX)", "OverBrace", "\\overbrace (TeX)", 
      "OverParenthesis", "paragraph", "parenthesis", "\\partial (TeX)", 
      "path integral", "Pilcrow sign", "Planck constant", "Pomeron", 
      "Pound sterling", "\\prime (TeX)", "proof", "\\P (TeX)", "QED", 
      "\\qed (TeX)", "quad", "quantum units", "quotation marks", 
      "rational numbers", "real numbers", "RegisteredTrademark", "\\Re (TeX)",
       "SadSmiley", "scream", "ScriptA", "ScriptCapitalE", "ScriptCapitalH", 
      "ScriptCapitalL", "ScriptL", "seconds", "section", "Short characters", 
      "SixPointedStar", "smiley", "so forth", "Spanish characters", 
      "\\ss (TeX)", "star", "\\star (TeX)", "stellated icosahedron", 
      "Sterling", "\\S (TeX)", "suits", "tailed rho", "tie", "TM", 
      "top parenthesis", "trademark", "trademark sign", 
      "transfinite cardinals", "triangle", "\\triangle (TeX)", "umlauts", 
      "UnderBrace", "\\underbrace (TeX)", "UnderBracket", "UnderParenthesis", 
      "\\u (TeX)", "\\varepsilon (TeX)", "\\varnothing (TeX)", 
      "\\varphi (TeX)", "\\varpi (TeX)", "\\varrho (TeX)", "\\varsigma (TeX)",
       "\\vartheta (TeX)", "\\vdots (TeX)", "vernal equinox", 
      "VerticalEllipsis", "Vinculum", "\\v (TeX)", "wait cursor", 
      "WarningSign", "WatchIcon", "\\wp (TeX)", "yen"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The complete collection of Greek letters in Mathematica. You can use \
Greek letters as the names of symbols. The only Greek letter with a built-in \
meaning in StandardForm is \\[Pi], which Mathematica takes to stand for the \
symbol Pi. Note that even though \\[Pi] on its own is assigned a built-in \
meaning, combinations such as \\[Pi]2 or x\\[Pi] have no built-in meanings. ",
     "synonyms" -> {"3.10.3"}, "title" -> "Letters and Letter-like Forms", 
    "type" -> "Tutorial", "uri" -> "tutorial/LettersAndLetterLikeForms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.10.3"->{
  Cell[1293, 44, 101, 2, 70, "Title",
   CellTags->{"S3.10.3", "3.1"},
   CellID->19606]},
 "3.1"->{
  Cell[1293, 44, 101, 2, 70, "Title",
   CellTags->{"S3.10.3", "3.1"},
   CellID->19606]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.10.3", 138389, 3652},
 {"3.1", 138490, 3656}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 668, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1293, 44, 101, 2, 70, "Title",
 CellTags->{"S3.10.3", "3.1"},
 CellID->19606],
Cell[CellGroupData[{
Cell[1419, 50, 48, 1, 70, "Section",
 CellID->11221],
Cell[1470, 53, 28398, 691, 70, "DoubleBox",
 CellID->17975],
Cell[29871, 746, 150, 6, 70, "Caption",
 CellID->31520],
Cell[30024, 754, 543, 19, 70, "Text",
 CellID->2792],
Cell[30570, 775, 350, 11, 70, "Text",
 CellID->24565],
Cell[30923, 788, 540, 16, 70, "Text",
 CellID->25547],
Cell[31466, 806, 525, 19, 70, "Text",
 CellID->24258],
Cell[31994, 827, 800, 24, 70, "Text",
 CellID->27684],
Cell[32797, 853, 441, 11, 70, "Text",
 CellID->21531],
Cell[33241, 866, 697, 19, 70, "Text",
 CellID->2829],
Cell[33941, 887, 401, 9, 70, "Text",
 CellID->31782],
Cell[34345, 898, 277, 9, 70, "Text",
 CellID->32705],
Cell[34625, 909, 943, 34, 70, "Text",
 CellID->26162]
}, Open  ]],
Cell[CellGroupData[{
Cell[35605, 948, 62, 1, 70, "Section",
 CellID->15689],
Cell[35670, 951, 5928, 139, 70, "DoubleBox",
 CellID->15923],
Cell[41601, 1092, 83, 1, 70, "Caption",
 CellID->30870],
Cell[41687, 1095, 297, 8, 70, "Text",
 CellID->25342],
Cell[41987, 1105, 662, 19, 70, "Text",
 CellID->9282],
Cell[42652, 1126, 194, 4, 70, "MathCaption",
 CellID->14196],
Cell[CellGroupData[{
Cell[42871, 1134, 226, 8, 70, "Input",
 CellID->12180],
Cell[43100, 1144, 254, 8, 36, "Output",
 CellID->742283631]
}, Open  ]],
Cell[43369, 1155, 570, 12, 70, "Text",
 CellID->19072],
Cell[43942, 1169, 215, 5, 70, "Text",
 CellID->18715],
Cell[44160, 1176, 359, 11, 70, "Text",
 CellID->16051],
Cell[44522, 1189, 5212, 143, 70, "DefinitionBox3Col",
 CellID->24736],
Cell[49737, 1334, 82, 1, 70, "Caption",
 CellID->11755]
}, Open  ]],
Cell[CellGroupData[{
Cell[49856, 1340, 49, 1, 70, "Section",
 CellID->15174],
Cell[49908, 1343, 1556, 39, 70, "DoubleBox",
 CellID->18477],
Cell[51467, 1384, 53, 1, 70, "Caption",
 CellID->1154],
Cell[51523, 1387, 256, 7, 70, "Text",
 CellID->24729]
}, Open  ]],
Cell[CellGroupData[{
Cell[51816, 1399, 93, 3, 70, "Section",
 CellID->10882],
Cell[51912, 1404, 5546, 139, 70, "DoubleBox",
 CellID->15851],
Cell[57461, 1545, 95, 3, 70, "Caption",
 CellID->19769],
Cell[57559, 1550, 716, 27, 70, "Text",
 CellID->11237],
Cell[58278, 1579, 1126, 40, 70, "Text",
 CellID->28301],
Cell[59407, 1621, 1372, 51, 70, "Text",
 CellID->15676],
Cell[60782, 1674, 1036, 34, 70, "Text",
 CellID->13604],
Cell[61821, 1710, 3339, 81, 70, "DoubleBox",
 CellID->27073],
Cell[65163, 1793, 69, 1, 70, "Caption",
 CellID->24161],
Cell[65235, 1796, 401, 14, 70, "MathCaption",
 CellID->21197],
Cell[CellGroupData[{
Cell[65661, 1814, 281, 9, 70, "Input",
 CellID->8595],
Cell[65945, 1825, 654, 22, 50, "Output",
 CellID->2125]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66648, 1853, 74, 1, 70, "Section",
 CellID->5485],
Cell[66725, 1856, 7090, 166, 70, "DoubleBox",
 CellID->15062],
Cell[73818, 2024, 43, 1, 70, "Caption",
 CellID->29229],
Cell[73864, 2027, 323, 8, 70, "Text",
 CellID->27560],
Cell[74190, 2037, 526, 16, 70, "Text",
 CellID->7718],
Cell[74719, 2055, 3725, 90, 70, "DoubleBox",
 CellID->29073],
Cell[78447, 2147, 41, 1, 70, "Caption",
 CellID->8079],
Cell[78491, 2150, 121, 3, 70, "MathCaption",
 CellID->8709],
Cell[CellGroupData[{
Cell[78637, 2157, 192, 7, 70, "Input",
 CellID->9662],
Cell[78832, 2166, 531, 15, 36, "Output",
 CellID->10224]
}, Open  ]],
Cell[79378, 2184, 1888, 45, 70, "DoubleBox",
 CellID->11574],
Cell[81269, 2231, 71, 1, 70, "Caption",
 CellID->7682],
Cell[81343, 2234, 421, 15, 70, "Text",
 CellID->7475]
}, Open  ]],
Cell[CellGroupData[{
Cell[81801, 2254, 51, 1, 70, "Section",
 CellID->28815],
Cell[81855, 2257, 5047, 123, 70, "DoubleBox",
 CellID->29343],
Cell[86905, 2382, 83, 1, 70, "Caption",
 CellID->27446],
Cell[86991, 2385, 3335, 82, 70, "DoubleBox",
 CellID->27532],
Cell[90329, 2469, 66, 1, 70, "Caption",
 CellID->14568],
Cell[90398, 2472, 4605, 109, 70, "DoubleBox",
 CellID->32684],
Cell[95006, 2583, 84, 1, 70, "Caption",
 CellID->4361],
Cell[95093, 2586, 110, 3, 70, "MathCaption",
 CellID->5472],
Cell[CellGroupData[{
Cell[95228, 2593, 280, 9, 70, "Input",
 CellID->25286],
Cell[95511, 2604, 412, 13, 46, "Output",
 CellID->8266]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95972, 2623, 56, 1, 70, "Section",
 CellID->6089],
Cell[96031, 2626, 195, 6, 70, "Text",
 CellID->32151],
Cell[96229, 2634, 27736, 683, 70, "DoubleBox",
 CellID->4604],
Cell[123968, 3319, 64, 1, 70, "Caption",
 CellID->17233],
Cell[124035, 3322, 855, 28, 70, "Text",
 CellID->25594],
Cell[124893, 3352, 125, 4, 70, "Text",
 CellID->9076],
Cell[125021, 3358, 1291, 38, 70, "DefinitionBox",
 CellID->598],
Cell[126315, 3398, 76, 1, 70, "Caption",
 CellID->18604],
Cell[126394, 3401, 4974, 118, 70, "DefinitionBox4Col",
 CellID->23533],
Cell[131371, 3521, 73, 1, 70, "Caption",
 CellID->468],
Cell[CellGroupData[{
Cell[131469, 3526, 72, 1, 70, "RelatedTutorialsSection",
 CellID->150221361],
Cell[131544, 3529, 192, 5, 70, "RelatedTutorials",
 CellID->5715683]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[131775, 3539, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

