(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34560,       1176]
NotebookOptionsPosition[     28167,        969]
NotebookOutlinePosition[     30862,       1037]
CellTagsIndexPosition[     30769,       1031]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/ExpressionsOverview"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Depth" :> Documentation`HelpLookup["paclet:ref/Depth"], 
          "False" :> Documentation`HelpLookup["paclet:ref/False"], "Heads" :> 
          Documentation`HelpLookup["paclet:ref/Heads"], "Infinity" :> 
          Documentation`HelpLookup["paclet:ref/Infinity"], "Level" :> 
          Documentation`HelpLookup["paclet:ref/Level"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Depth\"\>", 2->"\<\"False\"\>", 
       3->"\<\"Heads\"\>", 4->"\<\"Infinity\"\>", 5->"\<\"Level\"\>", 
       6->"\<\"Position\"\>", 7->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Levels in Expressions", "Title",
 CellTags->{"S2.1.7", "7.1"},
 CellID->31184],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " function allows you to access specific parts of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. But particularly when your expressions have fairly uniform \
structure, it is often convenient to be able to refer to a whole collection \
of parts at the same time. "
}], "Text",
 CellID->31417],

Cell[TextData[{
 StyleBox["Levels",
  FontSlant->"Italic"],
 " provide a general way of specifying collections of parts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Many ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions allow you to specify the levels in an expression on which they \
should act. "
}], "Text",
 CellID->2964],

Cell["Here is a simple expression, displayed in tree form. ", "MathCaption",
 CellID->29616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"t", "=", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "y"}], "}"}]}], ")"}], "//", 
  "TreeForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11014],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.8164965809277261, 1.6329931618554523`}, {0., 
    0.8164965809277261}, {0.8164965809277261, 0.8164965809277261}, {
    1.6329931618554523`, 0.8164965809277261}, {0.4082482904638631, 0.}, {
    1.2247448713915892`, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{3, 5}], LineBox[{3, 6}]}, 
     {RGBColor[0.55, 0.45, 0.45], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        RowBox[{"{", 
          RowBox[{"x", ",", 
            RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}], ",", "y"}], "}"}]],
       Annotation[#, {$CellContext`x, {$CellContext`x, $CellContext`y}, \
$CellContext`y}, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["x", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        "x"],
       Annotation[#, $CellContext`x, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}]],
       Annotation[#, {$CellContext`x, $CellContext`y}, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["y", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        "y"],
       Annotation[#, $CellContext`y, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["x", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        "x"],
       Annotation[#, $CellContext`x, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["y", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        "y"],
       Annotation[#, $CellContext`y, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8164965809277261, 1.6329931618554523`}, {0., 
     0.8164965809277261}, {0.8164965809277261, 0.8164965809277261}, {
     1.6329931618554523`, 0.8164965809277261}, {0.4082482904638631, 0.}, {
     1.2247448713915892`, 0.}}]& ],
  AspectRatio->1,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.03]]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1939449860]
}, Open  ]],

Cell[TextData[{
 "This searches for ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the expression ",
 Cell[BoxData["t"], "InlineFormula"],
 " down to level 1. It finds only one occurrence. "
}], "MathCaption",
 CellID->14996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"t", ",", "x", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "1", "}"}], "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1827002854]
}, Open  ]],

Cell[TextData[{
 "This searches down to level 2. Now it finds both occurrences of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"t", ",", "x", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1715782372]
}, Open  ]],

Cell[TextData[{
 "This searches only at level 2. It finds just one occurrence of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"t", ",", "x", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->743914288]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Position",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Position"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the positions at which ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " occurs in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " down to level\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Position",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Position"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", "{", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "give the positions exactly at level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4020],

Cell[TextData[{
 "Controlling ",
 StyleBox["Position", "MR"],
 " using levels. "
}], "Caption",
 CellID->23355],

Cell["\<\
You can think of levels in expressions in terms of trees. The level of a \
particular part in an expression is simply the distance down the tree at \
which that part appears, with the top of the tree considered as level 0. \
\>", "Text",
 CellID->15948],

Cell[TextData[{
 "It is equivalent to say that the parts which appear at level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " are those that can be specified by a sequence of exactly ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices. "
}], "Text",
 CellID->28251],

Cell[BoxData[GridBox[{
   {
    StyleBox["n", "TI"], Cell[TextData[{
     "levels 1 through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "all levels (except 0)", "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Heads",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Heads"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell["include heads", "TableText"]},
   {
    RowBox[{
     ButtonBox["Heads",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Heads"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell["exclude heads", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5081],

Cell["Level specifications. ", "Caption",
 CellID->32271],

Cell["Here is an expression, displayed in tree form. ", "MathCaption",
 CellID->31825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"u", "=", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"g", "[", "a", "]"}], ",", "a"}], "]"}], ",", "a", ",", 
      RowBox[{"h", "[", "a", "]"}], ",", "f"}], "]"}]}], ")"}], "//", 
  "TreeForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->9228],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.539600717839002, 2.309401076758503}, {
    0.3849001794597505, 1.5396007178390019`}, {1.1547005383792515`, 
    1.5396007178390019`}, {1.9245008972987525`, 1.5396007178390019`}, {
    2.6943012562182536`, 1.5396007178390019`}, {0., 0.7698003589195008}, {
    0.769800358919501, 0.7698003589195008}, {0., 0.}, {1.9245008972987525`, 
    0.7698003589195008}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{1, 5}], LineBox[{2, 6}], LineBox[{2, 7}], 
      LineBox[{4, 9}], LineBox[{6, 8}]}, 
     {RGBColor[0.55, 0.45, 0.45], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        RowBox[{"f", "[", 
          RowBox[{
            RowBox[{"f", "[", 
              RowBox[{
                RowBox[{"g", "[", "a", "]"}], ",", "a"}], "]"}], ",", "a", 
            ",", 
            RowBox[{"h", "[", "a", "]"}], ",", "f"}], "]"}]],
       Annotation[#, 
        $CellContext`f[
         $CellContext`f[
          $CellContext`g[$CellContext`a], $CellContext`a], $CellContext`a, 
         $CellContext`h[$CellContext`a], $CellContext`f], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        RowBox[{"f", "[", 
          RowBox[{
            RowBox[{"g", "[", "a", "]"}], ",", "a"}], "]"}]],
       Annotation[#, 
        $CellContext`f[
         $CellContext`g[$CellContext`a], $CellContext`a], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["a", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        "a"],
       Annotation[#, $CellContext`a, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["h", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        RowBox[{"h", "[", "a", "]"}]],
       Annotation[#, 
        $CellContext`h[$CellContext`a], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        "f"],
       Annotation[#, $CellContext`f, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["g", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        RowBox[{"g", "[", "a", "]"}]],
       Annotation[#, 
        $CellContext`g[$CellContext`a], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["a", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        "a"],
       Annotation[#, $CellContext`a, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["a", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        "a"],
       Annotation[#, $CellContext`a, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["a", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        "a"],
       Annotation[#, $CellContext`a, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.539600717839002, 2.309401076758503}, {
     0.3849001794597505, 1.5396007178390019`}, {1.1547005383792515`, 
     1.5396007178390019`}, {1.9245008972987525`, 1.5396007178390019`}, {
     2.6943012562182536`, 1.5396007178390019`}, {0., 0.7698003589195008}, {
     0.769800358919501, 0.7698003589195008}, {0., 0.}, {1.9245008972987525`, 
     0.7698003589195008}}]& ],
  AspectRatio->NCache[2^Rational[1, 2], 1.4142135623730951`],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.03]]], "Output",
 ImageSize->{162, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//TreeForm=",
 CellID->317645582]
}, Open  ]],

Cell[TextData[{
 "This searches for ",
 Cell[BoxData["a"], "InlineFormula"],
 " at levels from ",
 Cell[BoxData["2"], "InlineFormula"],
 " downwards. "
}], "MathCaption",
 CellID->13454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"u", ",", "a", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->24950232]
}, Open  ]],

Cell[TextData[{
 "This shows where ",
 Cell[BoxData["f"], "InlineFormula"],
 " appears other than in the head of an expression. "
}], "MathCaption",
 CellID->31238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"u", ",", "f", ",", 
   RowBox[{"Heads", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->13991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "4", "}"}], "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->579238059]
}, Open  ]],

Cell[TextData[{
 "This includes occurrences of ",
 Cell[BoxData["f"], "InlineFormula"],
 " in heads of expressions. "
}], "MathCaption",
 CellID->24853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"u", ",", "f", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->710685762]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Level",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Level"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "a list of the parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at the levels specified by ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Depth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Depth"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "the total number of levels in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17054],

Cell["Testing and extracting levels. ", "Caption",
 CellID->29877],

Cell[TextData[{
 "This gives a list of all parts of ",
 Cell[BoxData["u"], "InlineFormula"],
 " that occur down to level 2. "
}], "MathCaption",
 CellID->22490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{"u", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->31197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], ",", "a", ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", "a", "]"}], ",", "a"}], "]"}], ",", "a", ",", "a", ",",
    
   RowBox[{"h", "[", "a", "]"}], ",", "f"}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->191557320]
}, Open  ]],

Cell["\<\
Here are the parts specifically at level\[NonBreakingSpace]2. \
\>", "MathCaption",
 CellID->10773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->30589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], ",", "a", ",", "a"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->425890387]
}, Open  ]],

Cell[TextData[{
 "When you have got the hang of ordinary levels, you can try thinking about \
",
 StyleBox["negative levels",
  FontSlant->"Italic"],
 ". Negative levels label parts of expressions starting at the ",
 StyleBox["bottom",
  FontSlant->"Italic"],
 " of the tree. Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " contains all the leaves of the tree: objects like symbols and numbers."
}], "Text",
 CellID->27536],

Cell[TextData[{
 "This shows the parts of ",
 Cell[BoxData["u"], "InlineFormula"],
 " at level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->12888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "a", ",", "a", ",", "a", ",", "f"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->376738858]
}, Open  ]],

Cell[TextData[{
 "You can think of expressions as having a \"depth\", as shown by ",
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 ". In general, level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " in an expression is defined to consist of all subexpressions whose depth \
is ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->17585],

Cell[TextData[{
 "The depth of ",
 Cell[BoxData[
  RowBox[{"g", "[", "a", "]"}]], "InlineFormula"],
 " is 2. "
}], "MathCaption",
 CellID->21841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"g", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->4167],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1068195050]
}, Open  ]],

Cell[TextData[{
 "The parts of ",
 Cell[BoxData["u"], "InlineFormula"],
 " at level ",
 Cell[BoxData[
  RowBox[{"-", "2"}]], "InlineFormula"],
 " are those that have depth exactly 2."
}], "MathCaption",
 CellID->11560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"-", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->21047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], ",", 
   RowBox[{"h", "[", "a", "]"}]}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->190916430]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->11884061],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsOverview"]], "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Levels in Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Expressions", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/ExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ExpressionsAsTrees"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 26.0067118}", "context" -> "", 
    "keywords" -> {
     "all parts of expressions", "atoms", "depth", "expressions", 
      "function names", "heads", "indices", "leaf", "leaves", "level", 
      "levels", "nesting level", "position", "tags", "trees"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The Part function allows you to access specific parts of Mathematica \
expressions. But particularly when your expressions have fairly uniform \
structure, it is often convenient to be able to refer to a whole collection \
of parts at the same time. Levels provide a general way of specifying \
collections of parts in Mathematica expressions. Many Mathematica functions \
allow you to specify the levels in an expression on which they should act. \
Here is a simple expression, displayed in tree form. ", 
    "synonyms" -> {"2.1.7"}, "title" -> "Levels in Expressions", "type" -> 
    "Tutorial", "uri" -> "tutorial/LevelsInExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.1.7"->{
  Cell[2310, 64, 84, 2, 70, "Title",
   CellTags->{"S2.1.7", "7.1"},
   CellID->31184]},
 "7.1"->{
  Cell[2310, 64, 84, 2, 70, "Title",
   CellTags->{"S2.1.7", "7.1"},
   CellID->31184]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.1.7", 30558, 1020},
 {"7.1", 30657, 1024}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1685, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2310, 64, 84, 2, 70, "Title",
 CellTags->{"S2.1.7", "7.1"},
 CellID->31184],
Cell[2397, 68, 450, 13, 70, "Text",
 CellID->31417],
Cell[2850, 83, 366, 12, 70, "Text",
 CellID->2964],
Cell[3219, 97, 92, 1, 70, "MathCaption",
 CellID->29616],
Cell[CellGroupData[{
Cell[3336, 102, 262, 10, 28, "Input",
 CellID->11014],
Cell[3601, 114, 4311, 117, 217, "Output",
 CellID->1939449860]
}, Open  ]],
Cell[7927, 234, 225, 7, 70, "MathCaption",
 CellID->14996],
Cell[CellGroupData[{
Cell[8177, 245, 133, 4, 70, "Input",
 CellID->16873],
Cell[8313, 251, 204, 7, 36, "Output",
 CellID->1827002854]
}, Open  ]],
Cell[8532, 261, 162, 5, 70, "MathCaption",
 CellID->2510],
Cell[CellGroupData[{
Cell[8719, 270, 133, 4, 70, "Input",
 CellID->10396],
Cell[8855, 276, 277, 10, 36, "Output",
 CellID->1715782372]
}, Open  ]],
Cell[9147, 289, 162, 5, 70, "MathCaption",
 CellID->25791],
Cell[CellGroupData[{
Cell[9334, 298, 157, 5, 70, "Input",
 CellID->16866],
Cell[9494, 305, 227, 8, 36, "Output",
 CellID->743914288]
}, Open  ]],
Cell[9736, 316, 1272, 39, 70, "DefinitionBox",
 CellID->4020],
Cell[11011, 357, 111, 5, 70, "Caption",
 CellID->23355],
Cell[11125, 364, 263, 5, 70, "Text",
 CellID->15948],
Cell[11391, 371, 300, 9, 70, "Text",
 CellID->28251],
Cell[11694, 382, 1840, 64, 70, "DefinitionBox",
 CellID->5081],
Cell[13537, 448, 57, 1, 70, "Caption",
 CellID->32271],
Cell[13597, 451, 86, 1, 70, "MathCaption",
 CellID->31825],
Cell[CellGroupData[{
Cell[13708, 456, 347, 12, 70, "Input",
 CellID->9228],
Cell[14058, 470, 6645, 178, 70, "Output",
 CellID->317645582]
}, Open  ]],
Cell[20718, 651, 186, 7, 70, "MathCaption",
 CellID->13454],
Cell[CellGroupData[{
Cell[20929, 662, 189, 6, 70, "Input",
 CellID->10309],
Cell[21121, 670, 370, 13, 36, "Output",
 CellID->24950232]
}, Open  ]],
Cell[21506, 686, 164, 5, 70, "MathCaption",
 CellID->31238],
Cell[CellGroupData[{
Cell[21695, 695, 166, 5, 70, "Input",
 CellID->13991],
Cell[21864, 702, 203, 7, 36, "Output",
 CellID->579238059]
}, Open  ]],
Cell[22082, 712, 152, 5, 70, "MathCaption",
 CellID->24853],
Cell[CellGroupData[{
Cell[22259, 721, 165, 5, 70, "Input",
 CellID->20448],
Cell[22427, 728, 311, 11, 36, "Output",
 CellID->710685762]
}, Open  ]],
Cell[22753, 742, 1052, 33, 70, "DefinitionBox",
 CellID->17054],
Cell[23808, 777, 66, 1, 70, "Caption",
 CellID->29877],
Cell[23877, 780, 160, 5, 70, "MathCaption",
 CellID->22490],
Cell[CellGroupData[{
Cell[24062, 789, 120, 4, 70, "Input",
 CellID->31197],
Cell[24185, 795, 401, 13, 36, "Output",
 CellID->191557320]
}, Open  ]],
Cell[24601, 811, 109, 3, 70, "MathCaption",
 CellID->10773],
Cell[CellGroupData[{
Cell[24735, 818, 145, 5, 70, "Input",
 CellID->30589],
Cell[24883, 825, 243, 8, 36, "Output",
 CellID->425890387]
}, Open  ]],
Cell[25141, 836, 443, 13, 70, "Text",
 CellID->27536],
Cell[25587, 851, 194, 8, 70, "MathCaption",
 CellID->29429],
Cell[CellGroupData[{
Cell[25806, 863, 165, 6, 70, "Input",
 CellID->12888],
Cell[25974, 871, 234, 7, 36, "Output",
 CellID->376738858]
}, Open  ]],
Cell[26223, 881, 478, 16, 70, "Text",
 CellID->17585],
Cell[26704, 899, 145, 6, 70, "MathCaption",
 CellID->21841],
Cell[CellGroupData[{
Cell[26874, 909, 125, 4, 70, "Input",
 CellID->4167],
Cell[27002, 915, 160, 5, 36, "Output",
 CellID->1068195050]
}, Open  ]],
Cell[27177, 923, 218, 8, 70, "MathCaption",
 CellID->11560],
Cell[CellGroupData[{
Cell[27420, 935, 165, 6, 70, "Input",
 CellID->21047],
Cell[27588, 943, 262, 9, 36, "Output",
 CellID->190916430]
}, Open  ]],
Cell[CellGroupData[{
Cell[27887, 957, 71, 1, 70, "RelatedTutorialsSection",
 CellID->11884061],
Cell[27961, 960, 152, 3, 70, "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],
Cell[28140, 967, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

