(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    239039,       4510]
NotebookOptionsPosition[    231337,       4290]
NotebookOutlinePosition[    235181,       4376]
CellTagsIndexPosition[    235083,       4370]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Glow" :> Documentation`HelpLookup["paclet:ref/Glow"], 
          "GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"], 
          "Lighting" :> Documentation`HelpLookup["paclet:ref/Lighting"], 
          "RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "Specularity" :> 
          Documentation`HelpLookup["paclet:ref/Specularity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Glow\"\>", 2->"\<\"GrayLevel\"\>", 
       3->"\<\"Lighting\"\>", 4->"\<\"RGBColor\"\>", 
       5->"\<\"Specularity\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Lighting and Surface Properties", "Title",
 CellTags->{"S2.10.12", "12.1"},
 CellID->20392],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a simulated lighting model to determine how to color polygons in \
three\[Hyphen]dimensional graphics. "
}], "Text",
 CellID->26843],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to specify various components to the illumination of an object. \
One component is the \"ambient lighting\", which produces uniform shading all \
over the object. Other components are directional, and produce different \
shading on different parts of the object. \"Point lighting\" simulates light \
emanating in all directions from one point in space. \"Spot lighting\" is \
similar to point lighting, but emanates a cone of light in a particular \
direction. \"Directional lighting\" simulates a uniform field of light \
pointing in the given direction. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " adds together the light from all of these sources in determining the total \
illumination of a particular polygon. "
}], "Text",
 CellID->14063],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     RowBox[{"\"\<Ambient\>\"", ",", 
      StyleBox["color", "TI"]}], 
     StyleBox["}", "TI"]}], Cell["uniform ambient lighting", "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{"\"\<Directional\>\"", ",", 
      StyleBox["color", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["pos", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["pos", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}], "}"}], Cell[TextData[{
     "directional lighting parallel to the vector from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Point\>\"", ",", 
       StyleBox["color", "TI"], ",", 
       StyleBox["pos", "TI"]}], "}"}], "}"}], Cell[TextData[{
     "spherical point light source at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{"\"\<Spot\>\"", ",", 
      StyleBox["color", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["pos", "TI"], ",", 
        StyleBox["tar", "TI"]}], "}"}], ",", 
      StyleBox["\[Alpha]", "TR"]}], "}"}], Cell[TextData[{
     "spotlight at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " aimed at the target position ",
     Cell[BoxData[
      StyleBox["tar", "TI"]], "InlineFormula"],
     " with a half-angle opening of ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Lighting",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Lighting"], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["light", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["light", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}]}], Cell[
    "a number of lights", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, {False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16923],

Cell["Methods for specifying light sources. ", "Caption",
 CellID->14611],

Cell[TextData[{
 "The default lighting used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " involves three point light sources, and no ambient component. The light \
sources are colored respectively red, green and blue, and are placed at ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["45", "\[EmptySmallCircle]"], TraditionalForm]], 
  "InlineMath"],
 " angles on the right\[Hyphen]hand side of the object. "
}], "Text",
 CellID->24740],

Cell["\<\
Here is a sphere, shaded using simulated lighting using the default set of \
lights. \
\>", "MathCaption",
 CellID->692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spheres", "=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[73]:=",
 CellID->22443],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{-1, -1, 0}], SphereBox[{-1, 1, 0}], 
   SphereBox[{1, 1, 0}], SphereBox[{1, -1, 0}]},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]}]], "Output",
 ImageSize->{184, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[73]=",
 CellID->260445734,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "This shows the result of adding ambient light, and removing all point light \
sources. Note the ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " option takes a list of light sources. "
}], "MathCaption",
 CellID->3919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"spheres", ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Ambient\>\"", ",", "Blue"}], "}"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[74]:=",
 CellID->28849],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{-1, -1, 0}], SphereBox[{-1, 1, 0}], 
   SphereBox[{1, 1, 0}], SphereBox[{1, -1, 0}]},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  Lighting->{{"Ambient", 
     RGBColor[0, 0, 1]}}]], "Output",
 ImageSize->{184, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[74]=",
 CellID->7558356,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This adds a single point light source positioned at the red point. The lights \
are combined as appropriate. \
\>", "MathCaption",
 CellID->20576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"spheres", ",", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Ambient\>\"", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[87]:=",
 CellID->11845],

Cell[BoxData[
 Graphics3DBox[{{SphereBox[{-1, -1, 0}], SphereBox[{-1, 1, 0}], 
    SphereBox[{1, 1, 0}], SphereBox[{1, -1, 0}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{0, 0, 2}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  Lighting->{{"Ambient", 
     RGBColor[0, 0, 1]}, {"Point", 
     RGBColor[1, 0, 0], {0, 0, 2}}}]], "Output",
 ImageSize->{184, 194},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[87]=",
 CellID->57289416,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Objects do not block light sources or cast shadows, so all objects in a scene \
will be lit evenly by light sources.\
\>", "MathCaption",
 CellID->22593180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"spheres", ",", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Ambient\>\"", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[91]:=",
 CellID->239630966],

Cell[BoxData[
 Graphics3DBox[{{SphereBox[{-1, -1, 0}], SphereBox[{-1, 1, 0}], 
    SphereBox[{1, 1, 0}], SphereBox[{1, -1, 0}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{3, 0, 0}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  Lighting->{{"Ambient", 
     RGBColor[0, 0, 1]}, {"Point", 
     RGBColor[1, 0, 0], {3, 0, 0}}}]], "Output",
 ImageSize->{184, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[91]=",
 CellID->449944904,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylXAmYVcWVPn3fe73v+wLdDU3TNCAIiCAGaERBjahRkaCDgMgmRFY1iXFB
EWMIgooKIYwYIItEUUPUmDEomOioEVGj0RljFCfKjE7GaExm8tU3U/WfOrfr
1r0Pmgzfx+O9u5w6/9nPuXWZMnvlgrlfmb1y4ZzZrZOXz166YOGcFa2TlizX
h1I5RLRH/72lnvT3/9Xf8HePUkqfcD7X68+0PtUHvzaYz5T+iV9y9FZ7Tdo5
a7624uwd3tEWHJ1n7xmQeHa+t06Td1We+Uh3/xZOFnjX1euPwBBI8VXmM98e
64tDC707qvVHyrnD/DFXD068usJenYvjc+fO1d/N56AQY5TLCrt2gVxvFxkU
ojZnyyzVItzPVPnPQFw3zkNl/gy38iyRe8I1+Z7xnkSHWRqGI8qE19uznfi3
y0N7nOWrKrqGpTQgcZ1B9p5aB7H5Gni0+2dFNsAea/AopDwK7aEFmIM+fX99
31b7hRoza2WOcnfKXldsV6vD3XPsrz5HWaswiTrNsnf38+72eQmspn38TOUS
Fbd4n2LaXlOUSOFke7bZ8tPp3Z3r3ZWfSGWM8m2/0dIb7NHL8+73f2ejJ749
NEFe5nbx8/os99dYOR6fpK1MeKVyI12cSqVd7QSPSoGHojnL/eWWy1He/cK9
nC+N6KbUrnqSd5dvWWXeb2iczrB3n+zd7dtDaeLdk+zd4xLWdjkuxtUT7dUT
vKuLPdolkbsm2F+neneVeHeJJWdicmVex1kdn5awevJ94tmB/bcwlLtZ1vfk
iUfhL4jRR+yE3gLr6/n6rB8xekrnRMuXyWXl+mzvBDqBBIOE+yutfJpVPGqY
7F2tvzZ5NMtitPxYi5zCK3g53Pxs0//W6qOUSpMqwj3so9nXsNxVg1KxSq42
6lR3/GwA/WLSAFQr8bkkubh4OYbXeFSr7ZUmPzUaqulCUG0hdRwpPy9UeHfX
JNKUqsGP0U2Gfm4eqSrQH0xqDKkz9XLeKuJhdaEO4zFFIncvQzMvFzSbSQ0C
zdNJTdeHqzy6lQnYWY9SlZh/TUbvLVQrhepJWalWeVTZ8vqo7mwAagU5pDJC
cCAITiY1jdRCEs6inAY2hndnqiH632ZDq5BpVWiHAK3RoHUhqQWkrtHHPWrV
HodYjXrZNUx+aAXVkGSnkJxKaj6pr5FaT6rco+prPaWcqg7VjPk1PJH6KFKT
HOq3xamLXfrZmOOV+MII/W8fQ71I+1p5lPoFpOaR+iqpb5P6Hkmu6F6hNoH/
+Er5KrneikTXsNAdLvwUMz+9SA0AP6eBn7mkria1Fvz8kw4OhrYpf83Slkat
xZ1YU8WybjzuufcZ0jbyKaPzvjHOTgRn5wtn3yJ1H6knSOVbzjJHsHXKymW2
Ci7OrZuNfNvKNdzma0vXblgMx2ki1Q9hY7g+EuLJRPGcCjyXkbqK1K2ktpF6
XDuLxVOQsE68FiruoayF+5RH1cg6X6yyEGbfQKoNEVVzOB6h5BzwCftqM9eW
Mo4mB8d5wHElqW+SupfUo6RexeJmqeIEzaSdmHusOOKeEM1WhYbHEq2KElI1
iGEDoIcvwNc0mC+TmoUAtIi4hgaqIn1HGVB1kBpJaiJQzRFU/0i80NFiS8kx
asS3WyOJYsNPWT6kXK9LEliSFnQXcpD2zksQjpYiZlxH6lri+gs48vOgxjgO
9t89pA5ypvdjr4+EdSLVb65K9naf/0Lhv0L7Q4HjDEORSDQ3Z0MDl5JaDNle
T+oWxNXbieUEFJlcoG8UFNzSZ1bg4u+S0jAOJGQjN38Yu2JtSKTK8642v0vN
apUB6p9qhOX+pIaROhnWci6pixByliD634QQfRc40O5qYgE8O6WxsrqYz4JT
SH0JGEOGf0LqJVL/lcCz4SKTYDNFIe/xnizaY5UZHqpSCD6uxY9FZtTanwF7
WU7qG6TWkNpA6juI7PeT2q1vNRIH38Us7xNIMYDZuEnfsYXUI6R+Teo/dfni
cWAsI9exFLabPOVGnG6NiA2ZQ36MM9eWA0sa3luL4qsTDI0jdYbY/kLI9TpE
zTtJbSX1AwB5TN/aKljKtE7y4NIN0OkIUhMcUDdDBhrUi6Q+JrGcaO+ZpyjW
x4FnzvURf4ZekuOzN2thhDqGlpKqQ1E8ECY+Ht49FcHpcrjGDchzdyGk/ggm
pFMx9bYIU4gSAbJOaRTluSDiofzoGFAaTaQl28UmcOz0Dnh/CuhYQiBVg+HW
MBxF3wclK8e2Lwr6RUiJq+BsdyPR70JO2atvbbTokXPLOOeWJKFfJugfBvr/
IIlwUfS5nueF8FybPZLOY6hNr14JlJxR6h2UE4DyQhjhYhQyjPIeuOMDMOGn
TZdkUSKXlaYFYnsM4mpSm0k9ROoFQEyajmUUxXp8P4rnZEGYUclRvyQR4+As
GG8ktY7UJlLbST1I6mek9htbtBhLgDFwMA6HOehMPTMJo99BSldkuDfDdIPl
SHiOVEkbOVX9P3A9YxKfxQU/r8wBrvosuDY5uC5DkF4A+n6MTepgolgl3ibF
3Qiy6rhVdh0R2W7U2c8g4ZZYbKBUEyDjxLEtRaYMsa1Aq7cKmfBWFFMa+RUU
r0CqY/oKYjil2zIWWA08HOTjseRCJ5Z4mgrxFFo8mILUpQVPP5QA2fCsQmN0
B6xyGxx3O75sxJXkV4jypMFEwsDVTqzbLQ4x5cayQ5eTHdz4eE/U+g6YpMeY
MHmpz0QxjUf9dUkM01rkGV3kfh/E9iASaTH9FD83xbtePBnxOsLc0OuSLNDN
/Ka2qXGQcqYfiEw/XjL9TCcPujEyRJq2SDFZaeAZVt0Rkb4IvXHB8BAo6Wj7
S1L/TOp5Us/i5wMJHXixRZv2jnMijM8u07EjvjRCCdS4nUonAjzXOudLrbMS
RfJayYU/Rp+4H/Xkm7bibDGUmlI9kMBaMRlONk8Bu5blayD2W1K/gT08gSvt
3Dk6Czc/873j6WOSg9QGNRJpi6X2jtetC5xabyPcbBcY36dvNR6F+rsmRN4W
Rb5EkD+MFkNXAzshhZ9D6xr266TeNpQOmZ7jPVK/R+e6D2vF0KMq0j+LsqLP
UNKEN6vuyxl7FYYCHWCdu1Rdpv6D1OzXImTeCe9kj3sRfL+rCWCC08tFfzzM
x0W/GZXjBnQhP8D3J0k9R+oVUm+ByodIPx+jQnwfB7VVxLDrr75XOFr3Kvxj
kEEJ+y33ie0AMAaznrD3Wor8wZ1V7g+BYC/8VZvqO8RTrN5MpTa7DG7CaHAL
ZPCIyEDr+l8B+iP0Zn8i9Rm+fABXeJK40jEr+11bzy3en8eFll+YRofMba52
2SFOhzzd6rrwZqhuCwKzy/bvwKTpdqg5iGGf4mDf4mD3iPyLYNfAPyf1V3xq
+IcxJNCJv8Ci96defjZgaZjIn3KqRtfXkWHzUkBcioTEU6ZRotkS3S1/BRON
m+CrWmU7xFd/BX60pv7NdnjUkoN5VRzzUlQXKyVpbAIVLmGYijbvQw7m/yb1
P6T+TOqPMKbn4WnAYzw918OZ7AHmqjQld/DAnQ7QixbDSYG2Ilu/42a5MMa/
x90bonxrkAX5MkyRl0uwvEuSBQdL3bu/AYSHoeE/C/K/kPoUpvQ6sr7Vd2GP
cEvlHeq3QfM2V/54rbuXzrix3Sat3dPIza8jAB+GMgjPD1rjfs1op2GmpavI
r6PPux1ZnYPDL5DTXhWD0ZL7RFTNaP8dQX8/nMKPc/7vbqRujJNqGrqsZz+u
QgbrkFnjZCeKL8Pk5ZtSfPwoyubbwmaIuBiI+zqRbKZTEYW2Etazj6Mi+jUE
+A60+TFAfwa4f0J8fwcXaMPydZmU5aI+nDS/kRq83J1GNLCdV0Rj+amooy9C
h7NEFBYGtdDDX4apcz46bOcc1BpOtVxpcHa4GAYfypYzZCjbZ4Witqg/SID/
IyZYH0IaB+AafiQrSZRGPKonz3uMLKVHyoNEMjKC4nA3GqO1s2C/HPC8busB
aHMf3OE3CPOHAGGFSfSGYmPoESyR8VlauFUgeo8TBbjWewVCeQc2pwURGFFn
3kcueBlRZ31C/XtMUvFqfiMT6bMKpU4tcTo2t7thC3dDxL0YU+6BTp9DBH8T
LsMT2dXIFZgKUZ8M/DCUTFhQxV3xFkSMLSgHd0PiTyP2H0SUfBsSfxdx93c4
whXxpoTuzp/wHVEykSNGxtKrYQbSiyN7tUxwRziVcJz578J7Hob3sPO/ClZX
Riej9ZpykGM8qQhuxI8U+krunQBjZLtZ5Awd2Zl+KF3SPsj+JbQJb0ADbyHY
HISfPQpR+t28XyVnk4xfLdg9d90zlJrwSUIvTPncqDIdUeUKmc7fBiVxAuWB
4XOmun/J1B5fFUdjn7gfgQKTNurLETzjdCIdzjOjcyV6XYH65EZ5CnCv00fu
RUfxAoT0MgTzEtztKVRcm5Hnfds5FgnF9qB4u4MMGcwOmnOjEcdV8qyokjeK
kh+BFe2DMp+SCL0e/dIOp1NE1dqWQ3aWy8VcmRhU4jOqZajdV0Pud8uAYTfm
Cj+H0z2D2P8svjyNhXZBtvMT5kN+VRLNVDL5khmL9OzQcJ+UZNVWmTOEZUni
0xEOxT/FyP0X4nlrHM/bLY7xvAQlgnzqc6TWq3IMlgv7KaKFhVjvGsh5HfBu
RSzaBY9+FKQDM+zPfQIyeRAMrQejfifiS4Wn1f4OEuncjXWhVmsPolULP/M6
TbxqThZr341Y/IgTi+4QiTyEILkfXsDNxbtSi5h6DvPiOq4QSpzhFoe58NHs
pcgAK0B9NaYQG6GQbVh+F2RBwcNGNruR2Xbg9Bqw7M9N/SdMybKRZ+7GgmAt
HbnRtiz0ofDpzAr05bfAWjYjnjBzXJBcK4LZGhPMayhLD0mVyx3n5/jCz0ZM
Z5PG48QKcNAGz+LnQ5MlFoVCugYK+hb4uFueS27HqjshmvsgnfVICjMovico
WUL+7qmUlVDY0XSkk/yJE+3F8sSUrWctsglrcCtOZXOmRAl9hqqda3dCPqjN
QewpEuNtFx11YbvCl2C/syGhZWDiBvjZWqy3ERki+I6xn82w69uQOVYgFPjP
x/w5F0tH9g8l7bRB52invSaTISZ0hL4WDwjTHJNik/82TGcjYITjj7Bk3ikV
P1cs7GjvSV/H0vobWjv2uOqM8yy1A2uPhjmfAVHxZoj58PYrZVB/MwoIzUdg
iqvcdfh5I2Q5DwWs/yTNfyoddGeyo+6CkOkK7KpfJppRRsomlPNgV5ehZL4K
HrYaTjYFEOZIDbBaZgfbpQbgqvegDLs+QAfwKcQU/I34mUhl+AyhBZUXy6gL
Bn0OVDQDay+CNq5ChtQcBKtMXXEjDOwbOL4IShtK8X3q/iShpxLyJ86Vrk2F
1SLH7zFOkpkJpS6BUr8OIWZ78LhNCuwnkYoPyKDgD9JFfg5rcm2qMZD9DvUI
AAOAeRSWmQQOzkeYmgUDvhzKWY7S9EqIaQXkuBBFwlnxJ3p/r6z8vShGVtUi
q3wpi0LDGicBlX1gHtQ3H9nIfQDBzcitTrnERfd+9Givwf8OYajA0eqvMlph
WVWF8ZzFxV44BMXSWCjsTDAxFQY+E7Y8D3NvCsyGy8x8hPuLcdFYiu/Q9VH3
VFp4TmOe5YmU+ruT+P5QKXvBGVh7GrqQC3F8THRK7QZ0rhkfdDrOgximhm34
J5g+/QWCwrr1KRFPHYy5HQoagRjZhZLki2DgAvBwERadgc+LILYpCGedWrlH
kUxODyXjR32TDREn+gdS8nL10gm3OwnrT4Yp18oD49HOJNftUNY5PscbOn6J
5i3Meh+K230KOcHXy1Jiv7VQThty7lDY0MkQ0qkIkmdhRQrONVH7HPyeDKcc
BrX2TD7Sh8lzPL++7JZGxtkz2FekMQrWEUYmHgF2Rfe2hC51h1MAcEp7Du3T
GzL5OCzl4ydIb5BGaUp2fVShQmqFtQ5C2B4JdYzFijpPBRONB50CGZyEC1rM
AMJD5MdYloPvZyaawKPbw360AYu3o0wkZ/TVPzZ5mOfkcW5S73NMIKyZ3wTu
9+WZzEe8bwWZsZjjSCEcpRaVRB+sNBDRZBjknDrR4D0BPwcCbKkZLHhI/F2T
jLfBxgNTA6HOygTS45UwHcz4msO9O31lojVR0jBv6rvKGSJslYLlMbRRv5JB
BY+g3sMU6gNEhkPEtXcF2zrvo62FOFtg8e3IM50A1gnkfaH+ErLv9PgxMIbQ
17uJfLWSz4qiFjsODhV2h2Efe5v4L+eBnyHIPSuwfgsvTv3eCOtt6ZNZf+Vs
tYVguByL1YH/Jrh0L3yph00XQO49w+Trtla8szHf6WGGysjk7Kiersfk9Hbp
eHehs3sCjsiYXsGYR2sreMtgeh3eiaBtPlK8+6zAxBwtP8ovQZAqx2cpwGpr
0Re1ItyEXCre8c39e28PgUGEHaSN4ZNxb28Aa4Vd6mvSY2yEse1AS7gHIJ6C
vb2AkkbnoOBVw/EBpCSSmWFuAK/SXHLbrpcM0ua6cMrB75t1v2NpZt3g29dP
k/DdEjjP9dqdna9c7c92qv2bZTDCfvIAAgJPk/YjFj4PALw3YS86Seqn12iL
8cRZv8X6sOEFM8WWXJmfJ/ZpYT19HYrp9TKk2Sm28BhKnb2wiP343IupyA7e
Q2yevvfLwov/JlW98NQcyM7MsMEeLdurLhDVLkGRegPscz18jrV7P6LJT1Da
Pw5ZPQ59/5j7OsXvcPR31jaWxhz19TgydSf2//ZORSevw5FW2V2moShbIMYW
csS7gO9D9rofqnsIaexBPIO4F7qFhZunOgOsXpiPtgSfBR91HOPd4fgJMgQO
N64vdNraNbCfO4F9K7jZYXxxp1l6OzRpdlWbPG+eHXRGuOhnfxkpYPJQnScz
h37RFwDCjnohpHA1zGU1Qvx6rH6P7ajTW/B9A7oL0xOaKGHeK8rR63Tv4erv
4a8WDhr5qW5VUgXKTMyCKtxedQ0KiXVgZQPi81ocv5yfXpsK07x3nQ79tiPb
6pEd1B1OF3i6dAkz0c8shgKuBgPXI/xQcJOR+Cr49BLipwLlVu9pO1mSN+yj
+adMZoZumx5vQaeiirgU6BdDCyvht1dLP7UY4pH3HzqUs1OFRO9hZi8Pczh3
I9y8jUOtfRZ67S/DDy8FXr1kcLnBtwDNiT6FtznDHSH8zrxXIVbI7IF3dzVD
n8fBnk9GaXY64uF56CimOzX9dAjbVJEWA78D5r+rXCFYSkPZVSOLcm3MhehY
rDQJxadeLDDFcWoKjphCaZRdgd9rPi4bivJwh0qDFJuDscKJyKpj4SZdkN8Y
RLORVjqNoDvESr9SOC5jjgsRAqulhG1H5TEYyjgen4MQA/j/E9D3I0/G3pEu
Fy6LORcXQeJVUC5XFi2QfhMADLW0+B3qYQm0UOFmUpIVC+ASFJgiy7zFyV0S
NG7otIPO8AQ6/F5pdxYdaGXC/5/BCEcmNY6f8P/tMDKLJvrbqyADvHF7pD0p
RfYOcwjvhMfe7PaffA+x9HEdjbY8+ldJNME72/we+RGe6QjP+N8YYu95+71V
m+UXbzPTF7yz/qy2xdKehKvHemf9LrbJXn0mrh5n0flX1dmrzsZVXd5Zv2Os
tvyeh6v9N8v9vqrc0p6Kq0/xzvpdSbG9ejqunmj59a+SHUozcNVpyq9F8iyV
WTg/yblbKlBz9jKcnaw/TZGK/7uEKOf/AEAP9XY=\
\>"]]
}, Open  ]],

Cell["\<\
This adds a directional green light shining from the negative y direction, \
effectively an infinite distance away\
\>", "MathCaption",
 CellID->55742807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Lighting", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Ambient\>\"", ",", "Blue"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Directional\>\"", ",", "Green", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[92]:=",
 CellID->130619236],

Cell[BoxData[
 Graphics3DBox[{{SphereBox[{-1, -1, 0}], SphereBox[{-1, 1, 0}], 
    SphereBox[{1, 1, 0}], SphereBox[{1, -1, 0}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{3, 0, 0}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  Lighting->{{"Ambient", 
     RGBColor[0, 0, 1]}, {"Point", 
     RGBColor[1, 0, 0], {3, 0, 0}}, {"Directional", 
     RGBColor[0, 1, 0], {{0, 0, 0}, {0, 1, 0}}}}]], "Output",
 ImageSize->{184, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[92]=",
 CellID->40672376,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This shows a spot light positioned above the plot combined with ambient \
lighting.\
\>", "MathCaption",
 CellID->241533521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"Sin", "[", "y", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Ambient\>\"", ",", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "0", ",", ".6"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Spot\>\"", ",", "Red", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
        RowBox[{"15", " ", "Degree"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[63]:=",
 CellID->325018243],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[63]=",
 CellID->523677703]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " option controls the lighting of all objects in a scene when used as an \
option to ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " can also be used inline as a directive which specifies lighting for \
particular objects. The ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " directive replaces the inherited lighting specifications."
}], "TutorialAbstract",
 CellID->511708024],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " directive replaces the default value of ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " for the two spheres after the directive."
}], "MathCaption",
 CellID->484678311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"Lighting", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", " ", "Green", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "5"}], "}"}]}], "}"}], "}"}]}], ",", " ",
     
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->284578889],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], 
   StyleBox[{SphereBox[{1, 1, 1}], SphereBox[{2, 2, 2}]},
    Lighting->{{"Point", 
       RGBColor[0, 1, 0], {0, 0, 5}}}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->112486,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "This example uses list braces to restrict the effect of the ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 " directive to the middle sphere."
}], "MathCaption",
 CellID->496630679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighting", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Point\>\"", ",", " ", "Green", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "5"}], "}"}]}], "}"}], "}"}]}], ",", 
      " ", 
      RowBox[{"Sphere", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->48526151],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], 
   StyleBox[SphereBox[{1, 1, 1}],
    Lighting->{{"Point", 
       RGBColor[0, 1, 0], {0, 0, 5}}}], SphereBox[{2, 2, 2}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->318351098,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "The perceived color of a polygon depends not only on the light which falls \
on the polygon, but also on how the polygon reflects that light. You can use \
the graphics directives ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " to specify the way that polygons reflect or emit light. "
}], "Text",
 CellID->2508],

Cell[TextData[{
 "If you do not explicitly use these coloring directives, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively assumes that all polygons have matte white surfaces. Thus the \
polygons reflect light of any color incident on them, and do so equally in \
all directions. This is an appropriate model for materials such as uncoated \
white paper. "
}], "Text",
 CellID->12878],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " , however, you can specify more complicated models. These directives \
separately specify three kinds of light emission: ",
 StyleBox["diffuse reflection,",
  FontSlant->"Italic"],
 " ",
 StyleBox["specular reflection",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["glow",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->3338],

Cell[TextData[{
 "In diffuse reflection, light incident on a surface is scattered equally in \
all directions. When this kind of reflection occurs, a surface has a \
\[OpenCurlyDoubleQuote]dull\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]matte\[CloseCurlyDoubleQuote] appearance. Diffuse \
reflectors obey Lambert\[CloseCurlyQuote]s Law of light reflection, which \
states that the intensity of reflected light is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", "\[Alpha]", ")"}], TraditionalForm]], "InlineMath"],
 " times the intensity of the incident light, where ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " is the angle between the incident light direction and the surface normal \
vector. Note that when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ">", 
    SuperscriptBox["90", "\[EmptySmallCircle]"]}], TraditionalForm]], 
  "InlineMath"],
 ", there is no reflected light. "
}], "Text",
 CellID->6723],

Cell[TextData[{
 "In specular reflection, a surface reflects light in a mirror\[Hyphen]like \
way. As a result, the surface has a \[OpenCurlyDoubleQuote]shiny\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]gloss\
\[CloseCurlyDoubleQuote] appearance. With a perfect mirror, light incident at \
a particular angle is reflected at exactly the same angle. Most materials, \
however, scatter light to some extent, and so lead to reflected light that is \
distributed over a range of angles. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to specify how broad the distribution is by giving a ",
 StyleBox["specular exponent",
  FontSlant->"Italic"],
 ", defined according to the Phong lighting model. With specular exponent ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", the intensity of light at an angle ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " away from the mirror reflection direction is assumed to vary like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    SuperscriptBox[
     RowBox[{"(", "\[Theta]", ")"}], "n"]}], TraditionalForm]], 
  "InlineMath"],
 ". As ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Rule]", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ", therefore, the surface behaves like a perfect mirror. As ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " decreases, however, the surface becomes less \[OpenCurlyDoubleQuote]shiny\
\[CloseCurlyDoubleQuote], and for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", the surface is a completely diffuse reflector. Typical values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " for actual materials range from about 1 to several hundred. "
}], "Text",
 CellID->3005],

Cell["\<\
Glow is light radiated from a surface at a certain color and intensity of \
light that is independent of incident light.\
\>", "Text",
 CellID->10389777],

Cell["\<\
Most actual materials show a mixture of diffuse and specular reflection, and \
some objects glow in addition to reflecting light. For each kind of light \
emission, an object can have an intrinsic color. For diffuse reflection, when \
the incident light is white, the color of the reflected light is the \
material's intrinsic color. When the incident light is not white, each color \
component in the reflected light is a product of the corresponding component \
in the incident light and in the intrinsic color of the material. Similarly, \
an object may have an intrinsic specular reflection color, which may be \
different from its diffuse reflection color, and the specularly reflected \
light is a component-wise product of the incident light and the intrinsic \
specular color. For glow, the color emitted is determined by intrinsic \
properties alone, with no dependence on incident light.\
\>", "Text",
 CellID->284482497],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can specify light properties by giving any combination of diffuse \
reflection, specular reflection, and glow directives. To get no reflection of \
a particular kind, you may give the corresponding intrinsic color as ",
 Cell[BoxData[
  ButtonBox["Black",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Black"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}]], "InlineFormula"],
 ". For materials that are effectively \[OpenCurlyDoubleQuote]white\
\[CloseCurlyDoubleQuote], you can specify intrinsic colors of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is the reflectance or albedo of the surface. "
}], "Text",
 CellID->4193],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "matte surface with albedo ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RGBColor"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["g", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[
    "matte surface with intrinsic color", "TableText"]},
   {
    RowBox[{
     ButtonBox["Specularity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Specularity"], "[", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "surface with specularity ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " and specular exponent ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "; ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " can be number between 0 and 1 or an ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Glow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Glow"], "[", 
     StyleBox["col", "TI"], "]"}], Cell[TextData[{
     "glowing surface with color ",
     Cell[BoxData[
      StyleBox["col", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23117],

Cell["Specifying surface properties of lighted objects. ", "Caption",
 CellID->943],

Cell["\<\
This shows a sphere with the default matte white surface, illuminated by \
several colored light sources. \
\>", "MathCaption",
 CellID->20801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Sphere", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->30339],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->584912444,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This makes the sphere have low diffuse reflectance, but high specular \
reflectance. As a result, the sphere has a \[OpenCurlyDoubleQuote]specular \
highlight\[CloseCurlyDoubleQuote] near the light sources, and is quite dark \
elsewhere. \
\>", "MathCaption",
 CellID->20236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GrayLevel", "[", "0.2", "]"}], ",", 
    RowBox[{"Specularity", "[", 
     RowBox[{"0.8", ",", "5"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20012],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.2], Specularity[
    GrayLevel[0.8], 5], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->105947869,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
When you set up light sources and surface colors, it is important to make \
sure that the total intensity of light reflected from a particular polygon is \
never larger than 1. You will get strange effects if the intensity is larger \
than 1. \
\>", "Text",
 CellID->5433],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->129418628],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Lighting and Surface Properties - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CoordinateSystemsForThreeDimensionalGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LabelingThreeDimensionalGraphics"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 26.3660960}", "context" -> "", 
    "keywords" -> {
     "albedo", "AmbientLight", "ambient light", "background lighting", 
      "color", "diffuse reflection", "dull surfaces", "gloss surfaces", 
      "highlights", "illumination", "Lambert law", "lighting", 
      "light sources", "LightSources", "materials", "matte surfaces", 
      "metallic surfaces", "mirrors", "modeling lights", 
      "Phong lighting model", "polygons", "reflectivity of surfaces", 
      "shading models", "shiny surfaces", "specular exponent", 
      "specular reflection", "SurfaceColor", "White light"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "With the default option setting Lighting->Automatic, Mathematica uses a \
simulated lighting model to determine how to color polygons in \
three-dimensional graphics. Mathematica allows you to specify various \
components to the illumination of an object. One component is the \"ambient \
lighting\", which produces uniform shading all over the object. Other \
components are directional, and produce different shading on different parts \
of the object. \"Point lighting\" simulates light emanating in all directions \
from one point in space. \"Spot lighting\" is similar to point lighting, but \
emanates a cone of light in a particular direction. \"Directional lighting\" \
simulates a uniform field of light pointing in the given direction. \
Mathematica adds together the light from all of these sources in determining \
the total illumination of a particular polygon. Methods for specifying light \
sources. ", "synonyms" -> {}, "title" -> "Lighting and Surface Properties", 
    "type" -> "Tutorial", "uri" -> "tutorial/LightingAndSurfaceProperties"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.12"->{
  Cell[2256, 65, 97, 2, 70, "Title",
   CellTags->{"S2.10.12", "12.1"},
   CellID->20392]},
 "12.1"->{
  Cell[2256, 65, 97, 2, 70, "Title",
   CellTags->{"S2.10.12", "12.1"},
   CellID->20392]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.12", 234865, 4359},
 {"12.1", 234968, 4363}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1631, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2256, 65, 97, 2, 70, "Title",
 CellTags->{"S2.10.12", "12.1"},
 CellID->20392],
Cell[2356, 69, 481, 16, 70, "Text",
 CellID->26843],
Cell[2840, 87, 834, 16, 70, "Text",
 CellID->14063],
Cell[3677, 105, 2553, 81, 70, "DefinitionBox",
 CellID->16923],
Cell[6233, 188, 73, 1, 70, "Caption",
 CellID->14611],
Cell[6309, 191, 447, 12, 70, "Text",
 CellID->24740],
Cell[6759, 205, 130, 4, 70, "MathCaption",
 CellID->692],
Cell[CellGroupData[{
Cell[6914, 213, 920, 28, 65, "Input",
 CellID->22443],
Cell[7837, 243, 32418, 538, 175, 287, 7, "CachedBoxData", "BoxData", "Output",
 
 CellID->260445734]
}, Open  ]],
Cell[40270, 784, 312, 9, 70, "MathCaption",
 CellID->3919],
Cell[CellGroupData[{
Cell[40607, 797, 261, 9, 70, "Input",
 CellID->28849],
Cell[40871, 808, 3404, 64, 175, 339, 9, "CachedBoxData", "BoxData", "Output",
 CellID->7558356]
}, Open  ]],
Cell[44290, 875, 156, 4, 70, "MathCaption",
 CellID->20576],
Cell[CellGroupData[{
Cell[44471, 883, 748, 24, 70, "Input",
 CellID->11845],
Cell[45222, 909, 12325, 210, 215, 455, 11, "CachedBoxData", "BoxData", \
"Output",
 CellID->57289416]
}, Open  ]],
Cell[57562, 1122, 166, 4, 70, "MathCaption",
 CellID->22593180],
Cell[CellGroupData[{
Cell[57753, 1130, 752, 24, 70, "Input",
 CellID->239630966],
Cell[58508, 1156, 8434, 146, 156, 455, 11, "CachedBoxData", "BoxData", \
"Output",
 CellID->449944904]
}, Open  ]],
Cell[66957, 1305, 164, 4, 70, "MathCaption",
 CellID->55742807],
Cell[CellGroupData[{
Cell[67146, 1313, 735, 22, 70, "Input",
 CellID->130619236],
Cell[67884, 1337, 17922, 302, 156, 521, 12, "CachedBoxData", "BoxData", \
"Output",
 CellID->40672376]
}, Open  ]],
Cell[85821, 1642, 134, 4, 70, "MathCaption",
 CellID->241533521],
Cell[CellGroupData[{
Cell[85980, 1650, 962, 29, 47, "Input",
 CellID->325018243],
Cell[86945, 1681, 8436, 142, 159, "Output",
 Evaluatable->False,
 CellID->523677703]
}, Open  ]],
Cell[95396, 1826, 926, 30, 70, "TutorialAbstract",
 CellID->511708024],
Cell[96325, 1858, 392, 13, 70, "MathCaption",
 CellID->484678311],
Cell[CellGroupData[{
Cell[96742, 1875, 700, 22, 70, "Input",
 CellID->284578889],
Cell[97445, 1899, 18958, 316, 216, 189, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->112486]
}, Open  ]],
Cell[116418, 2218, 274, 8, 70, "MathCaption",
 CellID->496630679],
Cell[CellGroupData[{
Cell[116717, 2230, 760, 24, 70, "Input",
 CellID->48526151],
Cell[117480, 2256, 24909, 414, 216, 187, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->318351098]
}, Open  ]],
Cell[142404, 2673, 661, 20, 70, "Text",
 CellID->2508],
Cell[143068, 2695, 402, 9, 70, "Text",
 CellID->12878],
Cell[143473, 2706, 732, 28, 70, "Text",
 CellID->3338],
Cell[144208, 2736, 961, 22, 70, "Text",
 CellID->6723],
Cell[145172, 2760, 1813, 43, 70, "Text",
 CellID->3005],
Cell[146988, 2805, 163, 4, 70, "Text",
 CellID->10389777],
Cell[147154, 2811, 941, 14, 70, "Text",
 CellID->284482497],
Cell[148098, 2827, 1037, 30, 70, "Text",
 CellID->4193],
Cell[149138, 2859, 1977, 64, 70, "DefinitionBox",
 CellID->23117],
Cell[151118, 2925, 83, 1, 70, "Caption",
 CellID->943],
Cell[151204, 2928, 153, 4, 70, "MathCaption",
 CellID->20801],
Cell[CellGroupData[{
Cell[151382, 2936, 130, 4, 70, "Input",
 CellID->30339],
Cell[151515, 2942, 38467, 635, 216, 62, 1, "CachedBoxData", "BoxData", \
"Output",
 CellID->584912444]
}, Open  ]],
Cell[189997, 3580, 285, 6, 70, "MathCaption",
 CellID->20236],
Cell[CellGroupData[{
Cell[190307, 3590, 297, 9, 70, "Input",
 CellID->20012],
Cell[190607, 3601, 40078, 662, 216, 120, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->105947869]
}, Open  ]],
Cell[230700, 4266, 282, 6, 70, "Text",
 CellID->5433],
Cell[CellGroupData[{
Cell[231007, 4276, 72, 1, 70, "RelatedTutorialsSection",
 CellID->129418628],
Cell[231082, 4279, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[231310, 4288, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

