(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10678,        380]
NotebookOptionsPosition[      6868,        263]
NotebookOutlinePosition[      9324,        329]
CellTagsIndexPosition[      9233,        323]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Limit" :> Documentation`HelpLookup["paclet:ref/Limit"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Limit\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Limits", "Title",
 CellTags->{"S1.5.11", "11.1"},
 CellID->29740],

Cell[TextData[{
 "Here is the expression ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}], "/", "x"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->24401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "/", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20183],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", "x", "]"}], "x"]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81669203]
}, Open  ]],

Cell[TextData[{
 "If you replace ",
 Cell[BoxData["x"], "InlineFormula"],
 " by ",
 Cell[BoxData["0"], "InlineFormula"],
 ", the expression becomes ",
 Cell[BoxData[
  RowBox[{"0", "/", "0"}]], "InlineFormula"],
 ", and you get an indeterminate result. "
}], "MathCaption",
 CellID->24828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "/.", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30633],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[2]:=",
 CellID->516228118],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[2]:=",
 CellID->242372678],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137908243]
}, Open  ]],

Cell[TextData[{
 "If you find the numerical value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}], "/", "x"}], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " close to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ", however, you get a result that is close to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "/.", 
  RowBox[{"x", "->", "0.01"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8722],

Cell[BoxData["0.9999833334166665`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32648824]
}, Open  ]],

Cell[TextData[{
 "This finds the ",
 StyleBox["limit",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}], "/", "x"}], TraditionalForm]], "InlineMath"],
 " as ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " approaches ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". The result is indeed ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->19659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"t", ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24540],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->596071026]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "]"}], Cell[TextData[{
     "the limit of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " approaches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10282],

Cell["Limits. ", "Caption",
 CellID->1848],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->29705643],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Limits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PowerSeries"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/IntegralTransforms"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 27.3817470}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Here is the expression sin(x)/x. If you replace x by 0, the expression \
becomes 0/0, and you get an indeterminate result. If you find the numerical \
value of sin(x)/x for x close to 0, however, you get a result that is close \
to 1. ", "synonyms" -> {"1.5.11"}, "title" -> "Limits", "type" -> "Tutorial", 
    "uri" -> "tutorial/Limits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.11"->{
  Cell[1797, 58, 71, 2, 70, "Title",
   CellTags->{"S1.5.11", "11.1"},
   CellID->29740]},
 "11.1"->{
  Cell[1797, 58, 71, 2, 70, "Title",
   CellTags->{"S1.5.11", "11.1"},
   CellID->29740]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.11", 9017, 312},
 {"11.1", 9119, 316}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1172, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1797, 58, 71, 2, 70, "Title",
 CellTags->{"S1.5.11", "11.1"},
 CellID->29740],
Cell[1871, 62, 204, 8, 70, "MathCaption",
 CellID->24401],
Cell[CellGroupData[{
Cell[2100, 74, 142, 5, 28, "Input",
 CellID->20183],
Cell[2245, 81, 207, 7, 51, "Output",
 CellID->81669203]
}, Open  ]],
Cell[2467, 91, 289, 10, 70, "MathCaption",
 CellID->24828],
Cell[CellGroupData[{
Cell[2781, 105, 113, 4, 70, "Input",
 CellID->30633],
Cell[2897, 111, 411, 8, 70, "Message",
 CellID->516228118],
Cell[3311, 121, 446, 9, 19, "Message",
 CellID->242372678],
Cell[3760, 132, 170, 5, 36, "Output",
 CellID->137908243]
}, Open  ]],
Cell[3945, 140, 482, 17, 70, "MathCaption",
 CellID->3671],
Cell[CellGroupData[{
Cell[4452, 161, 115, 4, 28, "Input",
 CellID->8722],
Cell[4570, 167, 175, 5, 36, "Output",
 CellID->32648824]
}, Open  ]],
Cell[4760, 175, 494, 20, 70, "MathCaption",
 CellID->19659],
Cell[CellGroupData[{
Cell[5279, 199, 145, 5, 70, "Input",
 CellID->24540],
Cell[5427, 206, 158, 5, 36, "Output",
 CellID->596071026]
}, Open  ]],
Cell[5600, 214, 898, 29, 70, "DefinitionBox",
 CellID->10282],
Cell[6501, 245, 42, 1, 70, "Caption",
 CellID->1848],
Cell[CellGroupData[{
Cell[6568, 250, 71, 1, 70, "RelatedTutorialsSection",
 CellID->29705643],
Cell[6642, 253, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[6841, 261, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

