(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17599,        610]
NotebookOptionsPosition[      9784,        346]
NotebookOutlinePosition[     14896,        512]
CellTagsIndexPosition[     14303,        485]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Algebra in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/LinearAlgebraOverview"], 
          "Matrix and Tensor Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"], 
          "Working with Sparse Arrays" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraSparseArrays"], 
          "Matrix Computations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixComputations"], "Matrix Types" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixTypes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Algebra in Mathematica\"\>", 
       2->"\<\"Matrix and Tensor Operations\"\>", 
       3->"\<\"Working with Sparse Arrays\"\>", 
       4->"\<\"Matrix Computations\"\>", 
       5->"\<\"Matrix Types\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Linear Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Linear Algebra in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": References"
}], "Title",
 ShowCellBracket->True,
 CellTags->{"t:60", "c:168"},
 CellID->342426796],

Cell[CellGroupData[{

Cell["Software References", "Section",
 CellTags->{"t:94", "c:169"},
 CellID->2058470059],

Cell[CellGroupData[{

Cell["ARPACK", "Subsubsection",
 CellTags->{"t:160", "c:170"},
 CellID->744728443],

Cell[TextData[{
 "ARPACK is a collection of Fortran77 subroutines designed to solve large \
scale eigenvalue problems. ",
 ButtonBox["http://www.caam.rice.edu/software/ARPACK/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.caam.rice.edu/software/ARPACK/"], None}]
}], "Text",
 CellID->1116246785]
}, Open  ]],

Cell[CellGroupData[{

Cell["ATLAS", "Subsubsection",
 CellTags->{"t:221", "c:171"},
 CellID->342575303],

Cell[TextData[{
 "The ATLAS (Automatically Tuned Linear Algebra Software) project provides C \
and Fortran77 interfaces to a portable efficient BLAS implementation, as well \
as a few routines from LAPACK. ",
 ButtonBox["http://math-atlas.sourceforge.net/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://math-atlas.sourceforge.net"], None}]
}], "Text",
 CellID->259459914]
}, Open  ]],

Cell[CellGroupData[{

Cell["Harwell-Boeing", "Subsubsection",
 CellTags->{"t:143", "c:172"},
 CellID->1350971188],

Cell[TextData[{
 "The Harwell-Boeing matrix format is a popular storage and description \
format for sparse matrix data, ",
 ButtonBox["http://math.nist.gov/MatrixMarket/formats.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://math.nist.gov/MatrixMarket/formats.html"], None}],
 ". Many examples of matrices in this format can be found at ",
 ButtonBox["http://math.nist.gov/MatrixMarket/index.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://math.nist.gov/MatrixMarket/index.html"], None}],
 "."
}], "Text",
 CellID->428156985]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Market", "Subsubsection",
 CellTags->{"t:144", "c:173"},
 CellID->1964229445],

Cell[TextData[{
 "The Matrix Market matrix format provides a simple mechanism to facilitate \
the exchange of sparse and dense matrix data, ",
 ButtonBox["http://math.nist.gov/MatrixMarket/formats.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://math.nist.gov/MatrixMarket/formats.html"], None}],
 ". Many examples of matrices in this format can be found at ",
 ButtonBox["http://math.nist.gov/MatrixMarket/index.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://math.nist.gov/MatrixMarket/index.html"], None}],
 "."
}], "Text",
 CellID->1685660431]
}, Open  ]],

Cell[CellGroupData[{

Cell["METIS", "Subsubsection",
 CellTags->{"t:222", "c:174"},
 CellID->1290592593],

Cell[TextData[{
 "METIS is a family of programs for partitioning unstructured graphs and \
hypergraphs and computing fill-reducing orderings of sparse matrices. ",
 ButtonBox["http://www-users.cs.umn.edu/~karypis/metis/index.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www-users.cs.umn.edu/~karypis/metis/index.html"], None}]
}], "Text",
 CellID->1404875851]
}, Open  ]],

Cell[CellGroupData[{

Cell["TAUCS", "Subsubsection",
 CellTags->{"t:95", "c:175"},
 CellID->165728992],

Cell[TextData[{
 "TAUCS is a library of sparse linear solvers. ",
 ButtonBox["http://www.tau.ac.il/~stoledo/taucs/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.tau.ac.il/~stoledo/taucs/"], None}]
}], "Text",
 CellID->120878385]
}, Open  ]],

Cell[CellGroupData[{

Cell["UMFPACK", "Subsubsection",
 CellTags->{"t:142", "c:176"},
 CellID->83486633],

Cell[TextData[{
 "UMFPACK is a set of routines for solving unsymmetric sparse linear systems, \
Ax = b, using the Unsymmetric MultiFrontal method. ",
 ButtonBox["http://www.cise.ufl.edu/research/sparse/umfpack/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.cise.ufl.edu/research/sparse/umfpack/"], None}]
}], "Text",
 CellID->853019340]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other References", "Section",
 CellTags->{"t:94", "c:177"},
 CellID->95220008],

Cell[TextData[{
 "[",
 
 CounterBox["Reference"],
 "] Eric W. Weisstein. From ",
 StyleBox["MathWorld",
  FontSlant->"Italic"],
 "--A Wolfram Web Resource, ",
 ButtonBox["http://mathworld.wolfram.com/.",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://mathworld.wolfram.com/"], None}]
}], "Reference",
 CellTags->"t:189",
 CellID->487357441],

Cell[TextData[{
 "[",
 
 CounterBox["Reference"],
 "]  E. Anderson, Z. Bai, C. Bischof, S. Blackford, J. Demmel, J. Dongarra, \
J. Du Croz, A. Greenbaum, S. Hammarling, A. McKenney, and D. Sorensen, ",
 StyleBox["LAPACK Users' Guide",
  FontSlant->"Italic"],
 ", Third Edition, Philadelphia, PA: Society for Industrial and Applied \
Mathematics, 1999."
}], "Reference",
 CellTags->"t:152",
 CellID->513881229],

Cell[TextData[{
 "[",
 
 CounterBox["Reference"],
 "] G.H. Golub and  C.F. van Loan, ",
 StyleBox["Matrix Computations",
  FontSlant->"Italic"],
 ", Third Edition, Baltimore, Maryland: The Johns Hopkins University Press, \
1996."
}], "Reference",
 CellTags->"t:110",
 CellID->1770071216],

Cell[TextData[{
 "[",
 
 CounterBox["Reference"],
 "] C. D. Meyer, ",
 StyleBox["Matrix Analysis and Applied Linear Algebra",
  FontSlant->"Italic"],
 ", First Edition, Philadelphia, PA: The Society for Industrial and Applied \
Mathematics, 2000."
}], "Reference",
 CellTags->"t:192",
 CellID->495965421],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->55231329],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "TutorialMoreAbout",
 CellID->4791866],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->67077536],

Cell[TextData[{
 ButtonBox["Linear Algebra in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->315063104],

Cell[TextData[ButtonBox["Matrix and Tensor Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"]], \
"RelatedTutorials",
 CellID->3571032],

Cell[TextData[ButtonBox["Working with Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays"]], "RelatedTutorials",\

 CellID->560755906],

Cell[TextData[ButtonBox["Matrix Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations"]], "RelatedTutorials",
 CellID->335456077],

Cell[TextData[ButtonBox["Matrix Types",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes"]], "RelatedTutorials",\

 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Algebra in Mathematica: References - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 27.7411312}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "ARPACK is a collection of Fortran77 subroutines designed to solve large \
scale eigenvalue problems. http://www.caam.rice.edu/software/ARPACK/ The \
ATLAS (Automatically Tuned Linear Algebra Software) project provides C and \
Fortran77 interfaces to a portable efficient BLAS implementation, as well as \
a few routines from LAPACK. http://math-atlas.sourceforge.net/ The \
Harwell-Boeing matrix format is a popular storage and description format for \
sparse matrix data, http://math.nist.gov/MatrixMarket/formats.html. Many \
examples of matrices in this format can be found at \
http://math.nist.gov/MatrixMarket/index.html.", "synonyms" -> {}, "title" -> 
    "Linear Algebra in Mathematica: References", "type" -> "Tutorial", "uri" -> 
    "tutorial/LinearAlgebraAppendix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:60"->{
  Cell[2706, 74, 190, 8, 70, "Title",
   CellTags->{"t:60", "c:168"},
   CellID->342426796]},
 "c:168"->{
  Cell[2706, 74, 190, 8, 70, "Title",
   CellTags->{"t:60", "c:168"},
   CellID->342426796]},
 "t:94"->{
  Cell[2921, 86, 89, 2, 70, "Section",
   CellTags->{"t:94", "c:169"},
   CellID->2058470059],
  Cell[6731, 224, 84, 2, 70, "Section",
   CellTags->{"t:94", "c:177"},
   CellID->95220008]},
 "c:169"->{
  Cell[2921, 86, 89, 2, 70, "Section",
   CellTags->{"t:94", "c:169"},
   CellID->2058470059]},
 "t:160"->{
  Cell[3035, 92, 82, 2, 70, "Subsubsection",
   CellTags->{"t:160", "c:170"},
   CellID->744728443]},
 "c:170"->{
  Cell[3035, 92, 82, 2, 70, "Subsubsection",
   CellTags->{"t:160", "c:170"},
   CellID->744728443]},
 "t:221"->{
  Cell[3470, 109, 81, 2, 70, "Subsubsection",
   CellTags->{"t:221", "c:171"},
   CellID->342575303]},
 "c:171"->{
  Cell[3470, 109, 81, 2, 70, "Subsubsection",
   CellTags->{"t:221", "c:171"},
   CellID->342575303]},
 "t:143"->{
  Cell[3975, 127, 91, 2, 70, "Subsubsection",
   CellTags->{"t:143", "c:172"},
   CellID->1350971188]},
 "c:172"->{
  Cell[3975, 127, 91, 2, 70, "Subsubsection",
   CellTags->{"t:143", "c:172"},
   CellID->1350971188]},
 "t:144"->{
  Cell[4666, 150, 90, 2, 70, "Subsubsection",
   CellTags->{"t:144", "c:173"},
   CellID->1964229445]},
 "c:173"->{
  Cell[4666, 150, 90, 2, 70, "Subsubsection",
   CellTags->{"t:144", "c:173"},
   CellID->1964229445]},
 "t:222"->{
  Cell[5376, 173, 82, 2, 70, "Subsubsection",
   CellTags->{"t:222", "c:174"},
   CellID->1290592593]},
 "c:174"->{
  Cell[5376, 173, 82, 2, 70, "Subsubsection",
   CellTags->{"t:222", "c:174"},
   CellID->1290592593]},
 "t:95"->{
  Cell[5877, 190, 80, 2, 70, "Subsubsection",
   CellTags->{"t:95", "c:175"},
   CellID->165728992]},
 "c:175"->{
  Cell[5877, 190, 80, 2, 70, "Subsubsection",
   CellTags->{"t:95", "c:175"},
   CellID->165728992]},
 "t:142"->{
  Cell[6243, 206, 82, 2, 70, "Subsubsection",
   CellTags->{"t:142", "c:176"},
   CellID->83486633]},
 "c:176"->{
  Cell[6243, 206, 82, 2, 70, "Subsubsection",
   CellTags->{"t:142", "c:176"},
   CellID->83486633]},
 "c:177"->{
  Cell[6731, 224, 84, 2, 70, "Section",
   CellTags->{"t:94", "c:177"},
   CellID->95220008]},
 "t:189"->{
  Cell[6818, 228, 351, 14, 70, "Reference",
   CellTags->"t:189",
   CellID->487357441]},
 "t:152"->{
  Cell[7172, 244, 409, 12, 70, "Reference",
   CellTags->"t:152",
   CellID->513881229]},
 "t:110"->{
  Cell[7584, 258, 287, 11, 70, "Reference",
   CellTags->"t:110",
   CellID->1770071216]},
 "t:192"->{
  Cell[7874, 271, 304, 11, 70, "Reference",
   CellTags->"t:192",
   CellID->495965421]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:60", 11646, 387},
 {"c:168", 11752, 391},
 {"t:94", 11857, 395},
 {"c:169", 12059, 402},
 {"t:160", 12167, 406},
 {"c:170", 12281, 410},
 {"t:221", 12395, 414},
 {"c:171", 12510, 418},
 {"t:143", 12625, 422},
 {"c:172", 12741, 426},
 {"t:144", 12857, 430},
 {"c:173", 12973, 434},
 {"t:222", 13089, 438},
 {"c:174", 13205, 442},
 {"t:95", 13320, 446},
 {"c:175", 13434, 450},
 {"t:142", 13548, 454},
 {"c:176", 13662, 458},
 {"c:177", 13776, 462},
 {"t:189", 13883, 466},
 {"t:152", 13985, 470},
 {"t:110", 14087, 474},
 {"t:192", 14190, 478}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2081, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2706, 74, 190, 8, 70, "Title",
 CellTags->{"t:60", "c:168"},
 CellID->342426796],
Cell[CellGroupData[{
Cell[2921, 86, 89, 2, 70, "Section",
 CellTags->{"t:94", "c:169"},
 CellID->2058470059],
Cell[CellGroupData[{
Cell[3035, 92, 82, 2, 70, "Subsubsection",
 CellTags->{"t:160", "c:170"},
 CellID->744728443],
Cell[3120, 96, 313, 8, 70, "Text",
 CellID->1116246785]
}, Open  ]],
Cell[CellGroupData[{
Cell[3470, 109, 81, 2, 70, "Subsubsection",
 CellTags->{"t:221", "c:171"},
 CellID->342575303],
Cell[3554, 113, 384, 9, 70, "Text",
 CellID->259459914]
}, Open  ]],
Cell[CellGroupData[{
Cell[3975, 127, 91, 2, 70, "Subsubsection",
 CellTags->{"t:143", "c:172"},
 CellID->1350971188],
Cell[4069, 131, 560, 14, 70, "Text",
 CellID->428156985]
}, Open  ]],
Cell[CellGroupData[{
Cell[4666, 150, 90, 2, 70, "Subsubsection",
 CellTags->{"t:144", "c:173"},
 CellID->1964229445],
Cell[4759, 154, 580, 14, 70, "Text",
 CellID->1685660431]
}, Open  ]],
Cell[CellGroupData[{
Cell[5376, 173, 82, 2, 70, "Subsubsection",
 CellTags->{"t:222", "c:174"},
 CellID->1290592593],
Cell[5461, 177, 379, 8, 70, "Text",
 CellID->1404875851]
}, Open  ]],
Cell[CellGroupData[{
Cell[5877, 190, 80, 2, 70, "Subsubsection",
 CellTags->{"t:95", "c:175"},
 CellID->165728992],
Cell[5960, 194, 246, 7, 70, "Text",
 CellID->120878385]
}, Open  ]],
Cell[CellGroupData[{
Cell[6243, 206, 82, 2, 70, "Subsubsection",
 CellTags->{"t:142", "c:176"},
 CellID->83486633],
Cell[6328, 210, 354, 8, 70, "Text",
 CellID->853019340]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6731, 224, 84, 2, 70, "Section",
 CellTags->{"t:94", "c:177"},
 CellID->95220008],
Cell[6818, 228, 351, 14, 70, "Reference",
 CellTags->"t:189",
 CellID->487357441],
Cell[7172, 244, 409, 12, 70, "Reference",
 CellTags->"t:152",
 CellID->513881229],
Cell[7584, 258, 287, 11, 70, "Reference",
 CellTags->"t:110",
 CellID->1770071216],
Cell[7874, 271, 304, 11, 70, "Reference",
 CellTags->"t:192",
 CellID->495965421],
Cell[CellGroupData[{
Cell[8203, 286, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->55231329],
Cell[8271, 289, 169, 3, 70, "TutorialMoreAbout",
 CellID->4791866],
Cell[8443, 294, 147, 3, 70, "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],
Cell[CellGroupData[{
Cell[8627, 302, 71, 1, 70, "RelatedTutorialsSection",
 CellID->67077536],
Cell[8701, 305, 304, 9, 70, "RelatedTutorials",
 CellID->315063104],
Cell[9008, 316, 191, 5, 70, "RelatedTutorials",
 CellID->3571032],
Cell[9202, 323, 175, 4, 70, "RelatedTutorials",
 CellID->560755906],
Cell[9380, 329, 175, 4, 70, "RelatedTutorials",
 CellID->335456077],
Cell[9558, 335, 160, 4, 70, "RelatedTutorials",
 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9757, 344, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

