(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    364965,      11953]
NotebookOptionsPosition[    303960,       9746]
NotebookOutlinePosition[    318940,      10258]
CellTagsIndexPosition[    317071,      10183]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Algebra in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/LinearAlgebraOverview"], 
          "Matrix and Tensor Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"], 
          "Working with Sparse Arrays" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraSparseArrays"], 
          "Matrix Computations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixComputations"], "Matrix Types" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixTypes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Algebra in Mathematica\"\>", 
       2->"\<\"Matrix and Tensor Operations\"\>", 
       3->"\<\"Working with Sparse Arrays\"\>", 
       4->"\<\"Matrix Computations\"\>", 
       5->"\<\"Matrix Types\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Linear Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], "Append" :> 
          Documentation`HelpLookup["paclet:ref/Append"], "Array" :> 
          Documentation`HelpLookup["paclet:ref/Array"], "ArrayDepth" :> 
          Documentation`HelpLookup["paclet:ref/ArrayDepth"], "ArrayQ" :> 
          Documentation`HelpLookup["paclet:ref/ArrayQ"], "ConstantArray" :> 
          Documentation`HelpLookup["paclet:ref/ConstantArray"], 
          "DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], "Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "Export" :> 
          Documentation`HelpLookup["paclet:ref/Export"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "Flatten" :> 
          Documentation`HelpLookup["paclet:ref/Flatten"], "HankelMatrix" :> 
          Documentation`HelpLookup["paclet:ref/HankelMatrix"], 
          "HilbertMatrix" :> 
          Documentation`HelpLookup["paclet:ref/HilbertMatrix"], 
          "IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "Import" :> 
          Documentation`HelpLookup["paclet:ref/Import"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "Join" :> 
          Documentation`HelpLookup["paclet:ref/Join"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"], "MatrixForm" :> 
          Documentation`HelpLookup["paclet:ref/MatrixForm"], "MatrixPlot" :> 
          Documentation`HelpLookup["paclet:ref/MatrixPlot"], "MatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/MatrixQ"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "Prepend" :> 
          Documentation`HelpLookup["paclet:ref/Prepend"], "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"], "Range" :> 
          Documentation`HelpLookup["paclet:ref/Range"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "Tr" :> 
          Documentation`HelpLookup["paclet:ref/Tr"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "VectorQ" :> 
          Documentation`HelpLookup["paclet:ref/VectorQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"Append\"\>", 
       3->"\<\"Array\"\>", 4->"\<\"ArrayDepth\"\>", 5->"\<\"ArrayQ\"\>", 
       6->"\<\"ConstantArray\"\>", 7->"\<\"DiagonalMatrix\"\>", 
       8->"\<\"Dimensions\"\>", 9->"\<\"Drop\"\>", 10->"\<\"Export\"\>", 
       11->"\<\"False\"\>", 12->"\<\"Flatten\"\>", 13->"\<\"HankelMatrix\"\>",
        14->"\<\"HilbertMatrix\"\>", 15->"\<\"IdentityMatrix\"\>", 
       16->"\<\"Import\"\>", 17->"\<\"Insert\"\>", 18->"\<\"Join\"\>", 
       19->"\<\"List\"\>", 20->"\<\"MatrixForm\"\>", 21->"\<\"MatrixPlot\"\>",
        22->"\<\"MatrixQ\"\>", 23->"\<\"Normal\"\>", 24->"\<\"Partition\"\>", 
       25->"\<\"Prepend\"\>", 26->"\<\"RandomReal\"\>", 27->"\<\"Range\"\>", 
       28->"\<\"SparseArray\"\>", 29->"\<\"Table\"\>", 30->"\<\"Tr\"\>", 
       31->"\<\"True\"\>", 32->"\<\"VectorQ\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Matrix and Tensor Operations", "Title",
 CellTags->{"t:3", "c:6"},
 CellID->1023128168],

Cell[TextData[{
 "This tutorial will review the functions that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides for building and working with matrices, vectors, and tensors. It \
will focus on functions that are specific to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and will use matrices for many of the examples. However, all of the \
functions are general, and they will also work for vectors and tensors."
}], "Text",
 CellID->813558047],

Cell[CellGroupData[{

Cell["Building Matrices", "Section",
 CellTags->{"t:4", "c:7"},
 CellID->441715480],

Cell[TextData[{
 "Matrices are represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with lists. They can be entered directly with the {  } notation that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides for lists. An example of a matrix is shown below; by default a \
matrix prints with the list notation. "
}], "Text",
 CellID->61104681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5", ",", "1.6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7", ",", "1.8"}], "}"}]}], "}"}]], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->489190301],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "1.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7`", ",", "1.8`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78477768]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a number of ways to build matrices."
}], "Text",
 CellID->375014479],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["m", "TI"], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " matrix where ",
     StyleBox["f", "TI"],
     " is a function of ",
     StyleBox["i", "TI"],
     " and ",
     StyleBox["j", "TI"],
     " that gives the value of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " matrix whose ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry is ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DiagonalMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiagonalMatrix"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "build a diagonal matrix with the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " on the diagonal "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IdentityMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IdentityMatrix"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " identity matrix "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["ConstantArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ConstantArray"], "[", 
      RowBox[{
       StyleBox["val", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["n", "TI"]}], "}"}]}], "]"}], "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " matrix each element being ",
     StyleBox["val", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["RandomReal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RandomReal"], "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         StyleBox["val", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["n", "TI"]}], "}"}]}], "]"}], "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " matrix with random entries"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{
       ButtonBox["Normal",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Normal"], "[", 
       RowBox[{
        ButtonBox["SparseArray",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SparseArray"], "[", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["1", "TR"]], ",", 
           RowBox[{
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["1", "TR"]], "}", "->", 
            RowBox[{
             SubscriptBox[
              StyleBox["v", "TI"], 
              StyleBox["1", "TR"]], ",", 
             RowBox[{"{", 
              RowBox[{
               SubscriptBox[
                StyleBox["i", "TI"], 
                StyleBox["2", "TR"]], ",", 
               RowBox[{
                SubscriptBox[
                 StyleBox["j", "TI"], 
                 StyleBox["2", "TR"]], "}", "->", 
                SubscriptBox[
                 StyleBox["v", "TI"], 
                 StyleBox["2", "TR"]]}], ",", 
               StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               StyleBox["m", "TI"], ",", 
               StyleBox["n", "TI"]}], "}"}]}]}]}]}]}]}]}], "]"}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "build an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " matrix with nonzero values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Nu]", "TR"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " at positions ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["k", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["k", "TI"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.1",
 CellID->3844608],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " is particularly important to generate matrices, when there is not a \
built-in function to generate your matrix. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " documentation contains more information on ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". In this example a 3\[Times]3 matrix is built."
}], "Text",
 CellID->191817246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"i", ",", "j"}]], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->499499375],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV9tOwkAU3F6goAJeeDCxKj/gb+iTXyCYNMQEHowG+f+625Zap7OXFjEQ
bdJmz9k5Z2e2Z7fbx2S9eHlN1st5MnlYJe+L5fxjcv+2kq7AE8KbCiFGl0K2
U9nK7jhNUxGoVnaJG7Bvwb7bMX6sHiIEL9qRfHSk6YOf+QZVbFj65aVAmFmP
9gka7WOwe8UogQPPYRVr5alHt+XJ4nQ8S6wTT45W3o6FZzZ2bfYQdQR2sKFe
jiUKBmrMU4b+YiYbXRMS2RnsoMiDs91nerR8RwxN+VLkD/BF2zfyPWNoypci
LfxM+rxUWy3fKi8iVR1Zxuo4xtVWUMvxME//X8WvqbDtnoY606yS8lmLYlrV
2ohaRYeNonuMMcmG++tfU4ZvtttImS3arIydfJrviUy/7ovp/k5OnKKqelX/
sFUUnhSGTgp8yIJ1wRVgVJS6KLBFHb4CVrnytyKrsW32ROX1C22+kZ3qxdPT
oBEaGeIZz21v25xg3GoZ1w1n7LJ/HibzXX5PY+q9pt6LVjO4XyOM289l7V8t
h+Wpr4gvJj6qcM8zbzFnFXtmebe2/mcnFra18gT2ecP+qSV//setmjOHlvA+
AeHTZGM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83493786]
}, Open  ]],

Cell["MatrixForm prints the matrix in a two-dimensional form.", "Text",
 CellID->2075315201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->393188633],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV7luwkAQXWyIuRKFHECiFPxAfiOp8gUpEEKRcBElIhR0lJSUlHwCJSUl
JSUlJSUlJZm97PWwNsthgaJYwnhm5/bsPs9brdX4+Ky13Hqt8tqsfTfc+k/l
5asJLDtBCHHh91wm8LyGJ/Zz12v4L9G7TWl2kactdIFp0bsFzCRaTRG0lvTW
4KKCN6GrlHvFrKeY1cFgIKzmkBdLuvJ04Znc66R8D/BQ1ElE0DyOTqcjaJuZ
4TnPZrPRaCS1HFDC2g6iM0eWu5BVmk6nOLp+v6/GLGrl3Tfe2wWiszFq4Tx4
lVerVbvd9vOwJZenwq1s2FZrROm0UURYy0F0bi8t7rvb7ULQXjexPKzJZJLS
2rQ1FaX7IG8kjSupz3abFqehmaGlg3GzPlosFuH1f9yBy0+a4L6RfoJ7zPbC
5soPhryS7Bl+dIR4qMrMBJ2IkPLpvyjFzvIdzv5LI6t099iavpPY4K1psUG/
SvdE1ti76lXtW8GC61YnFcCKO51EBFY4RtFR+hRYkTaKTr/H4zl1zLTweW5W
5fPHiswR38cpMOOQftoFM8pGfg7BDDMP1X8pwY0HM2gXpjTnGOVdq2sbmFEI
XfUxo9frRXrPI6/qN7NgaRABoRTZnEDwLtKf0v6co0YH3yfL5VJaOQVmcHo+
nw+HQy96ER18womp4/wxg08p4/FY830LJRbZxZmHOieFY8Y2LZ4X9HJgvjCb
96isJWyEY4WUyhhlGSaNMdqP04KeORwT6BRvwVtjlvj0mPTyX++PBEVdJcV0
yocg+viOaC7lKneS+AWOIGIa\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->385390372]
}, Open  ]],

Cell[TextData[{
 "Another way to build matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is with the ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " command. Here it is used to build a 3\[Times]3 matrix."
}], "Text",
 CellID->231617156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1549172528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"1", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"3", ",", "2"}], "]"}], ",", 
     RowBox[{"m", "[", 
      RowBox[{"3", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{566, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->21116938]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a number of functions for building certain specialized matrices. This \
builds the identity matrix."
}], "Text",
 CellID->1686370103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IdentityMatrix", "[", "5", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->333148015],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->184395067]
}, Open  ]],

Cell[TextData[{
 "Note that the identity matrix that is generated is an integer matrix. If \
you want to compute with floating point numbers it can be advantageous to use \
matrices that contain floating point entries; this is described in more \
detail under ",
 ButtonBox["Performance of Linear Algebra Computation: Matrix Contents",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraPerformance#478605279"],
 ". If you start with an integer matrix, such as the identity matrix \
generated previously, it can be converted to a floating point matrix by using \
the function ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". This is shown in the following."
}], "Text",
 CellID->37336944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"IdentityMatrix", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->456792884],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "1.`", ",", "0.`", ",", "0.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "1.`", ",", "0.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "1.`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{427, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->421690127]
}, Open  ]],

Cell["Here a diagonal matrix is constructed.", "Text",
 CellID->1290418441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagonalMatrix", "[", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->625386834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->512026402]
}, Open  ]],

Cell[TextData[{
 "In this example, the elements are put on the first diagonal. ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " is useful for showing the results."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "1"}], "]"}], "//",
   "MatrixForm"}]], "Input",
 CellLabel->"In[8]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmDtvwjAQgB2nodBS5o78mlYMzMwRqgRD1YoyZMvIyJiRn5AxY0ZGxoyM
jIyM7vkRbNIU3EfsqE2kxBfLnD/u5eiG/nzy9OzPp2O//zjzXyfT8Vv/4WUG
U66DEBrBPbhHIBOQ2D0iBEb16dGnu1qtCLvQgL2HYSjeXbbqiolZliVJQkX6
7oLC7oXxOte+2WyK2qIoUvfwKF9+gYxuKpptsS0Ph0MQBJLJzWc5Fmc0xsTt
tFgsAICK+MiE1+u1Z4EFHA3uPmVhPtvtdrbsI+NPZZKxaoMJHMaTpxZMbXKa
WU4pE40nneztFH5Xrm3YrNK0a4+oVfGStqoip8f2Oc6KemiLhs62rNvkXDbZ
YrplyqWfbPN0iYwb+9b5Ho1OhmJtbXWtQ/WrfF87Uf5mlhfrbruhOc7S+MB5
zWtsUlEMN999ZqofjWJPjP+v+rEcVrKoPKdN0ajfCVS0a5u7Ak3HKo1evavj
t3FTBX9z1XK51Fgle4TqqiiK9vu9atfPql8+ci9tt9s4jqmo9k2SJBGdwvLI
+Uk2n+vipGla0u2CPyYYzdKAP076gHr90qpoZBxIGgxeMmUT2p/A4Ae2n+hX
S1tggxQffCBoeEvUPI3cl9OoGYfFaVOWgewUEv1/5LwDQVnR+A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->654308855]
}, Open  ]],

Cell["\<\
This makes a 5\[Times]5 matrix, each element is 2.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->20997071]
}, Open  ]],

Cell["\<\
Here a 2\[Times]4 matrix with pseudorandom real numbers in the range 0 to 5 \
is built.\
\>", "Text",
 CellTags->{"S3.7.1", "1.8"},
 CellID->1269425995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->2140148667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "4.071403816431561`", ",", "0.08670398363849974`", ",", 
     "2.17357223411211`", ",", "0.14976120799600645`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8044279298700452`", ",", "0.5521563723516931`", ",", 
     "2.9104324258027683`", ",", "2.08587494658687`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->164445120]
}, Open  ]],

Cell["\<\
This makes a 3\[Times]4 matrix with pseudorandom integers in the range -5 to \
5.\
\>", "Text",
 CellTags->{"S3.7.1", "1.8"},
 CellID->308650782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->76716924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", "0", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->714917963]
}, Open  ]],

Cell[TextData[{
 "This makes a 3\[Times]4 matrix with two nonzero values filled in. ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " expressions are described under \"",
 ButtonBox["Working with Sparse Arrays",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#1619024906"],
 "\"."
}], "Text",
 CellTags->{"S3.7.1", "1.6"},
 CellID->1885957666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "a"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "b"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->431862742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->87306648]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", "}", ",", "{", 
     StyleBox["n", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell["a zero matrix ", "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox[
          RowBox[{
           StyleBox["i", "TI"], "_"}]], ",", 
         StyleBox[
          RowBox[{
           StyleBox["i", "TI"], "_"}]]}], "}"}], 
       StyleBox["->", "MR"], "1"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " identity matrix "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox[
          RowBox[{
           StyleBox["i", "TI"], "_"}]], ",", 
         StyleBox[
          RowBox[{
           StyleBox["j", "TI"], "_"}]]}], "}"}], 
       StyleBox["/;", "MR"], 
       RowBox[{
        StyleBox["i", "TI"], 
        StyleBox[">=", "MR"], 
        StyleBox["j", "TI"]}]}], 
      StyleBox["->", "MR"], 
      RowBox[{
       RowBox[{"1", ","}], 
       RowBox[{"{", 
        RowBox[{
         StyleBox["n", "TI"], ",", 
         StyleBox["n", "TI"]}], "}"}]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["a lower triangular matrix ", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.1",
 CellID->2050257696],

Cell[TextData[{
 "Constructing special types of matrices with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ". "
}], "Caption",
 CellTags->"S3.7.1",
 CellID->158496910],

Cell["This sets up a general lower triangular matrix. ", "Text",
 CellTags->{"S3.7.1", "1.9"},
 CellID->977844090],

Cell[CellGroupData[{

Cell["SparseArray[{i_, j_}/;i>=j -> f[i, j], {3, 3}] // MatrixForm", "Input",
 CellTags->"S3.7.1",
 CellLabel->"In[13]:=",
 CellID->2080753786],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWL1vGjEUN3eQRNdC86FKGdkrtUnUzlWXdsofgaJIyRA1IqhiY2RkZGTM
iDIxMjIyMjIyMjJen7+w87DDGfuAIMHde3738/swP7/zda1xd/tQa9zf1Kp/
6rXHu/ubp+rvv3VQxQVCyAt8v5wTuE/hjn1f0hSu/PcMfiNQfqBSTEfZhxwL
/WfP8QqbpcRGe72eGMXWibA+RfqzwHYHTG61WkKOmXdFdjuZTAaDgdSWiNSr
p6meiiWkP7TYJzvCObLoD2QVxuMxjr7b7QorPAtGiZhyKTMMjkIzniBrjIYr
74Z+ZB3d9hw8l4vFotlsqlzGUsvTuTKzuSJKrnhmD+OV19i74h2bMolWMInb
7TakYDnOshKNRiOMtu1shMbLlg0gFaCW19lg/7fZbGaaBctyXZ54ei9xMCfG
G+KciKuJxXQ21aNWzEtRTJzmWjMbN7rWKhQOjx6WP9/sLNGvq7mZofDcYXiv
YtRuE5sxrrYDFYw5o5WINZ4uCll2GqVUdRw2O12f1S5Bfpi9e37XVuXUr8v7
lXmWkN3cz0yz2pgmsuhduzBXHJpDKl5m8n4zptinbiwxWl0EiR7vXb57JMbD
jIvt84wN++7L/q54ecaG5U+esWEZx4br6hPbPnYuedVp//oQn2hDdxDl1IXJ
93XvD9Mh8JfgTqezFiXLzv6Pyeq8SEeDPnE+n6dv/BM33ZG/iytfTdPptN/v
Szw5O7zUiNMTV/7OuiebV/iVUfuNPTscDg1vmJAk4X/oncbdQ1gXr04EXM+c
8vdQrVHlYQSV3mXuvlIfoIYMQ8yscmZb5Xl7pPsQa57x44yldoc5W/GFfExX
GR2fYeiMLpngB3uan5STwn/09gNP\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S3.7.1",
 CellLabel->"Out[13]//MatrixForm=",
 CellID->465688059]
}, Open  ]],

Cell[TextData[{
 "Functions that can read in matrices from files are discussed in the section \
",
 ButtonBox["Import and Export",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#2053293398"],
 "."
}], "Text",
 CellID->1462348464],

Cell[CellGroupData[{

Cell["Special Matrices", "Subsection",
 CellTags->{"t:102", "c:8"},
 CellID->1887778180],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains definitions for a number of special matrices."
}], "Text",
 CellID->964470482],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox[
      ButtonBox["HilbertMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HilbertMatrix"], "MR"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "create an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " Hilbert matrix, with elements given by ",
     Cell[BoxData[
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["i", "TI"], "+", 
         StyleBox["j", "TI"], "-", "1"}], ")"}]}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox[
      ButtonBox["HilbertMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HilbertMatrix"], "MR"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["m", "TI"], ",", 
       StyleBox["n", "TI"]}], 
      StyleBox["}", "TI"]}], "]"}], Cell[TextData[{
     "create an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " Hilbert matrix"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox[
      ButtonBox["HankelMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HankelMatrix"], "MR"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "create an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], "\[Times]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " Hankel matrix with the first column given by ",
     Cell[BoxData["1"], "InlineFormula"],
     ", ",
     Cell[BoxData["2"], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ", ",
     Cell[BoxData["n"], "InlineFormula"],
     " and zeros beneath the main antidiagonal"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox[
      ButtonBox["HankelMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HankelMatrix"], "MR"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "create a Hankel matrix with the first column given by ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " and zeros beneath the main antidiagonal"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox[
      ButtonBox["HankelMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HankelMatrix"], "MR"], "[", 
     RowBox[{
      StyleBox["col", "TI"], ",", 
      StyleBox["row", "TI"]}], "]"}], Cell[TextData[{
     "create a Hankel matrix with the first column given by the list ",
     Cell[BoxData[
      StyleBox["col", "TI"]], "InlineFormula"],
     " and the last row given by the list ",
     Cell[BoxData[
      StyleBox["row", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S5.48.1",
 CellID->648823418],

Cell["Special matrices. ", "Caption",
 CellTags->"S5.48.1",
 CellID->2000710507],

Cell["Here is a 2\[Times]4 Hilbert matrix. ", "Text",
 CellTags->{"S5.48.1", "1.20"},
 CellID->559898982],

Cell[CellGroupData[{

Cell["HilbertMatrix[{2, 4}]//MatrixForm", "Input",
 CellTags->"S5.48.1",
 CellLabel->"In[1]:=",
 CellID->2096332967],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVj1TAjEQDQmgoKIyFooNf8B/4UcFNe0N4wwUjg5S0FFSUlLyEygpKSkp
KSkpKSnPzSZHwk4wgQErmblLNtl9eXnksluJ2o33j6jdrEflt1b01WjWv8uv
ny0YEinGWA2ep3sG/Rh6+NTiGNoreAswb6Dl0BYtm8lOjD9W2Hjbo0ViO6O0
DW92jW0GR4fDofbKelBkVBrMWzJ+hna329W2QPQ0dufz+Xg8Nl4miqJQjokS
+YTlbDaj6IPBwMGdEd2Y5swdeubQXq/XnU7HoItkVC3Azj3KuPYiNtx7vR5A
yS7foPPpdFrFWZAHRNqexZ0tl0vZrRAdbS+jeSVhrP7OHV5VolrK6aW0nEwm
TP0EvsDW8/kTz2cJHzfL6hG95IoZIFHY0eaDUHynxGf/r3KaVeTNw607gLaX
QSjHPG9/71WK3fklTMES0d2Xb3JBqI8elCTfhHGkaL78crH3zn/LK2Fovh1T
zmE6HvOcyLwqb7yXIG9aMaiofr+/V5RS4dT5xNQ5NivIhavVysXqGe3FYjEa
jWTXzqiQinU14o6CtR05HRbSWC4FXHknl+i5VT/Q2idD0Hxfp+9rNatw2KVE
lyf8bk9Uebdz2C+y1RwN54cD0Ox4YaGqQulwVBOvUMuxO09gNFP1Okv9AIZT
ufw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{88, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.48.1",
 CellLabel->"Out[1]//MatrixForm=",
 CellID->113664022]
}, Open  ]],

Cell["The elements of the Hankel matrix can be given as a list. ", "Text",
 CellTags->{"S5.48.1", "1.21"},
 CellID->1483441136],

Cell[CellGroupData[{

Cell["HankelMatrix[{w, x, y, z}]//MatrixForm", "Input",
 CellTags->"S5.48.1",
 CellLabel->"In[2]:=",
 CellID->2057514729],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"w", "x", "y", "z"},
     {"x", "y", "z", "0"},
     {"y", "z", "0", "0"},
     {"z", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$104]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.48.1",
 CellLabel->"Out[2]//MatrixForm=",
 CellID->811142667]
}, Open  ]],

Cell["\<\
The Hankel matrix can be filled with nonzero values by giving the final row. \
This also allows a non\[Hyphen]square matrix to be generated. Note that the \
last element of the first column and the first element of the final row must \
be identical. \
\>", "Text",
 CellTags->{"S5.48.1", "1.22"},
 CellID->1126668929],

Cell[CellGroupData[{

Cell["HankelMatrix[{w, x, y, z}, {z, m, n}]//MatrixForm", "Input",
 CellTags->"S5.48.1",
 CellLabel->"In[3]:=",
 CellID->1561374104],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"w", "x", "y"},
     {"x", "y", "z"},
     {"y", "z", "m"},
     {"z", "m", "n"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$108]]]], "Output",
 ImageSize->{61, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.48.1",
 CellLabel->"Out[3]//MatrixForm=",
 CellID->544037929]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Structural Operations", "Section",
 CellTags->{"t:6", "c:9"},
 CellID->223720584],

Cell[TextData[{
 "These operations are all related to the structure of matrices. Many of the \
techniques shown in this section can be applied to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions and are not specific just to matrices."
}], "Text",
 CellID->1975473038],

Cell[CellGroupData[{

Cell["Getting Pieces of Matrices", "Subsection",
 CellTags->{"t:7", "c:10"},
 CellID->1678167046],

Cell[TextData[{
 "Extracting elements, rows, or columns of a matrix is quite straightforward \
with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 ". Typically ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " is entered with ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{"[", " ", "]"}], "]"}]], "InlineFormula"],
 " notation."
}], "Text",
 CellID->2050806071],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " row "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ";;", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     " rows ",
     StyleBox["i", "TI"],
     " through ",
     StyleBox["j", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " column "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["i", "TI"], ";;", 
     StyleBox["j", "TI"], "]", "]"}], Cell[TextData[{
     " columns ",
     StyleBox["i", "TI"],
     " through ",
     StyleBox["j", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["r", "TI"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["s", "TI"]]}], "}"}]}], "]"}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      RowBox[{
       StyleBox["r", "TI"], "\[Times]", 
       StyleBox["s", "TI"]}]], "InlineFormula"],
     " submatrix with elements having row indices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " and column indices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Tr",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tr"], "[", 
     StyleBox["m", "TI"], ",", 
     ButtonBox["List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/List"], "]"}], Cell[TextData[{
     "list of the diagonal elements of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->785100947],

Cell["Ways to get pieces of matrices. ", "Caption",
 CellTags->"S3.7.2",
 CellID->1052089061],

Cell["Define the following matrix.", "Text",
 CellID->80498829],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->29121393],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9z2jAUwIUNISTkDkibpr0O+TTtlA/B5XqXDL320gxsjIyMXIceIyMj
IyMjIyMjIyOjK8mSLD8/WbIxNKTOHY6l9yS99/Tvh9B99+Xx2/fuy9ND9+7r
c/fn49PDr7svP55pll8hhEzo5/6W0PeAvvHPJAjo/w/s6bM0/yOf90y3ea0d
kOuBdI0YdKoqTf+Y8Nqq5dHEO0t7nqjNZhdMN7k3NZ47Ho9FbkPTok9SlS4p
mwiwXGlFlgOrlUaKNa0i9M90C8Jnnev1+32R7/PssPbVajWbzWTtdartg1bO
QLpxJD3WKyycJnkd0ee9uFwuoZej0Uj3vaZCIyLHfPdEW3qdFwVqXyB+m7XP
Qd9eWrWjUrvdrtfrRTHwZW4Yhth4jtel23ceuHpn6pV0u/cvJb3O3kbk32Aw
oIEJ5OzisfIWi0XNWKcvZhRruZmq5R7B7Npw7JlHk7Q3aoNOeDrt4z7zObLZ
bMzj49OBcsMdKr4OSZviaxbzQAxpXvhjwXmhJXQ4hFuBwZI/MloiXUnRitJv
UYuzQIFsceXUKptzPjK/JXMoGcoauFQyBlavzhYmeXJdsXlxhdWSYIz3mFaM
MW4s1sB0VkJC9RHGaDh5zdJ1bdbxNYqQxNrcOJIeYxGdMaAcrsmQpHAv7fsr
Qeq276/5S7nvFnqp7LuyLBXxTr5Y+UGSgszeSm03e/Npp7MGVqeKc84YQPqv
BWnMAbUhZeORK6YU6rWTPxHJ5IvRoZjk1smmYzCJmyWvlRD+FyZhq4KHjXH6
2tZlCSbpGKUs99pQr2SSdoq8ZJJsTGL7vtg4kh5kEtv38n2Y5DR3Dfuubdo7
92GSYkgsP1NlL+V+PgLbUP2xB7/BEWJmF9vJnpn69i8FexEfhZg/JbuU7PJW
2MVHxrhkFyVD2QWXSnbB6tXZxSTPzi6XoJT9NxulZfzNRmmkWNcqQr9kl1Qv
3faY09g13E4csL2zZBe3NlR/lOxSskvJLkfS+jfswuZJjST3GZbX0mUJdmkb
pWyudwz1SnZppciTM3Q4HKZ60QSl9DsKIoskyQRQF0mezNjICvZZLn0ju0T3
aXSvR6PRdruVpU+ZXcLdfL1eT6dTFS3h5Ww2E7dQSnaJbsrM53Pk3gEdDiKC
h4xVfvuzl5K/gGVvI+ofumbE7qVku8ck6cl8P+X13XbyCUl814t89+h8Oi6L
sFNsj45M3mp47lhV8Q8OTyA3WI+L88/wog57/Q3SodZEe5LKX0er0zU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->258094810]
}, Open  ]],

Cell["This gets the second element in the first row.", "Text",
 CellID->1337598596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1160786176],

Cell[BoxData[
 SubscriptBox["m", 
  RowBox[{"1", ",", "2"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48821821]
}, Open  ]],

Cell[TextData[{
 "This gets the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["3", "rd"], TraditionalForm]]],
 " row."
}], "Text",
 CellID->210891662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1108145684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["m", 
    RowBox[{"3", ",", "1"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"3", ",", "2"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"3", ",", "3"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"3", ",", "4"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"3", ",", "5"}]]}], "}"}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->20519402]
}, Open  ]],

Cell[TextData[{
 "It can also obtain a column by using ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " to specify all rows."
}], "Text",
 CellID->459037612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1283884860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["m", 
    RowBox[{"1", ",", "3"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"2", ",", "3"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"3", ",", "3"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"4", ",", "3"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"5", ",", "3"}]]}], "}"}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->12257182]
}, Open  ]],

Cell["\<\
Negative indices are used to refer to the end of the matrix. The following \
gets the last element of the last row.\
\>", "Text",
 CellID->1535233162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->647735029],

Cell[BoxData[
 SubscriptBox["m", 
  RowBox[{"5", ",", "5"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->89196877]
}, Open  ]],

Cell[TextData[{
 "You can get ranges of a matrix using ",
 Cell[BoxData[";;"], "InlineFormula"],
 ". This gets the second through the fourth rows."
}], "Text",
 CellID->507977834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->432468603],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wdtu2zAMVezY6WWNd+mAAku3vg0Dtt/YnvYRQTGgfRg6tP2fbvtR13Js
Tzk+EkXZWYAYJsUjkkcUrTjft483P35uH2+vt1ff7re/bm6vH66+3t03qnxh
TPbRGFNdmOa+bu7a76aua5Pbu/Zj3oP8QZDR/ovSXpr/88R4cPytvZglaFE+
ai5WzEFfNLcZ6Nau7XLQd1qc2W+dEevKE0fW6YOxgL0r4zj6PSF8sPgYH5Vr
O+IDPa+91lZbhKwJH8HZA3ygLPFx7OG/IDFUrq1YH37rUH2wfBgfIXtNfbTj
otUxGy/cnEyXk82tYtb/GGhuypAlZjPi7mUSivoq3ah2V6zUvMNj5Zwyr15O
Xodj7Pxay1fMUpBnxxFeWOWk8xLMltZKVH6jVT80K1gttBb5/tqLdUX28oow
vtejInGjXp/or/TgrH5JepTPz5Hghz3Dp7Pli/5/s9yzFWuPbElPOM5W1+jb
j63v2OgPhfOxjDiJLbTX1lZgf3p62HAdoViOQ+5q9FKFZlUy8CGiS0c2xih9
9x26rHkGeHrgbCLnOFvPJs8oFs0zQrRuJVltumwWajQ7MevYzCAGrI/wCs+L
ZhHHo1cgh9lkaF9tjvuA1FvzJLZeJOW5PiCq/xV4pvZRk711NgtL+lhMUgZ6
lvQrUUMXiGdpr8uJ7Oz1JTE/n3V47jALbE5WI7iTFi1+nudu//zxRxjq7f7s
p6NwFU+j87EiVhD+gtWxUyXlyXvXYdiJ89Wzw96g6E8Z/dOEsyOdKnieEorn
KZ1B4lBFzWtnznPvhmovFVo+w3nSimo8aGJ8M2M002NEblLfM+TDltpN/Y7o
NpE6hqVrGIwgdubYqOi6qSOYEtWEtXLkPywPxfjfqCik/0+eQMb3YtL4b2H+
HW39ynxSSmbxDETNd0U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{551, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->262982233]
}, Open  ]],

Cell["This gets the second through the fourth columns.", "Text",
 CellID->148521699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"2", ";;", "4"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->368642283],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWM1O20AQ3tgOCS2QQjlUasrPA/AacOoTlFSKokrhULWiFA7Amcc2u3Yc
bSbf7Myug+QQKZZ3PN/uN7Pj8cx+n97Nf/2e3t3MpmdXt9O/85vZv7PLP7dW
lPeM6V0bY86/GHtf2rvq734T+zdm7K55IyvNCRmfkvHFG+sfV6w+EunQXjI7
LNygWMrtzynlRPuA1XbSfkjbk2eL2TMip3qU666PE7mOWG3EdUV7Q1zpPDrO
YRTHfQ0FbKCroX0x5oNgGeG04ON4HSp40HEqzh/ni3ko0+1l7kePWX/fPOYj
pKlgHouTYqdXLmNnJV4H4N0ZCHP3lTjKgcPt2EuhiP9dyL6G1T/nOS17Ccex
p7h27ClqR8lewnHs0XwFiK9A/NAo7C+jtMSximxaelxEo/3Uo/1cjJ4Xi9l0
lmVktmEUN4qm36A49KDctGVZEie0hg7le8/J6XcTxyBiGO+t/STUgToquHpL
Zr7iO5Exp42ZNtrtGIbyvs63CCX71t02zFG+syV/FSMxuYrmQ5pt9pJQ/F5R
W0Lf9E8qC6Rsiy2QUNgCKTenWdDUv9QfmDmnzUedU4JZY0PfuzGUfoPSz0ke
6tYKx3rfrXVUTfXkrl+BbAxk0KKOzxzhI086EfZOev5TtSrtZn6Q8VHk82th
1bpvdbeTxLu3Pqt5qVaRamCX7fpGe76xz2qjL++KNvFdDuTS+cbQZ6U6N8La
XJWAZtFyva+8LWVgVFPiHpu+BYgXHafiUJUrnS3pTgeQDzSnA1ocYv7A78Q7
OyXYFvb/+R1pXcuGuzKpOo1D+/Wke96uO91Gy+osJ+VCvgcMranrLyiK7wmp
bzfTGxrTjb77sUx/p7hzEb43Qdq81ew7EKjytq+TfWqxA93qfegKAcs63qFE
WOKNYzuUelapso7tQJ6rWd2tpnswvVdihziG\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->418015694]
}, Open  ]],

Cell["You can also give a step. This gets every other column.", "Text",
 CellID->299733056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"1", ";;", 
     RowBox[{"-", "1"}], ";;", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->31191635],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWM1uE0EMnuw2TVtIQ38OSA1QHoDXgBNPQIMUVUjtoWpV2nIAzjz2MrOb
WSbO57G9SaUNkbKZ8dqezx6PY8/n+cPVt5v5w/Xl/PzT/fzu6vry+/nH23tP
KgfODS6cc+9fOz+u/Kj+hs/Mf52bhmcZaZV7S+bvyPzDM/Of1qheEOqefxR+
ukPoQz8sCO0w5d1p6QvqMMed0KlWOqf8FPG+f5QAHUI8SXlFxBNG8yYQ5+Q5
5CsyKgssyEvBkprfHQj2FdGIFptb7HvAeGTEVOTkdv/N6wGIr3IhT1FuJ+o0
diI+HvUEcStQQzmAmsYb1T+o2nhZitURiPAR8MDSqVDKrWQuRm5P8AXVsw+t
aGA2n+A5rRWSHGcFlduMFRTlrtIKSY6zgspJXsvEFXOC+ZhHtrU7IEojpHrp
YYXzdDyvOovSPXYgBvKYqDT9N7JJjzZmUdEJC1pDJxUrHSlmm1hDyOw781Lt
03R+aJaKsUbrL9mC6Dsd8iVPi4gRd3ekUj6XfV2R86zzNZWqQE4JMeQbgjp2
LLkK5dMi688cqrF6jTClcf9KhZjLcBixlIsxYrRGd8TFQjpmLn7HS3AOMMJU
Z/g11EUi3imkvoHUk04e6dcKp3rfLdUxZRvcjaozQJsCGrSo55oNPkqoM2Hv
pPdfVavSjuULmR8b318IqzY9aRjOOo6e+2bmT70KxY0qS9T5I9o45RVvAcaM
5nXvMUJuLN3qPwp3V9Tyqu6KkGYr4qfa81I3gepHvqemp0KDkZXb0E1Aa5Xq
JgD5QHMT0MoZUP/gd+A/vRHYNise+R0y16u27phK2/pYrlZerxPdJoua7Cbt
L9/n5ezk+z2ufg/vdX0KrfrX7//CvE+99s+q+5mi9xM8InRjwvcnUWdg7tY5
9ak7/bWGh/vV79AVMpb1vCsxWJLMrV1Jo1Wqpq1dx+9aaxhqOgY3+AufrjiG
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->6022287]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " works on the diagonal elements of a matrix. The one argument form adds \
them up."
}], "Text",
 CellID->37601670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", "mat", "]"}]], "Input",
 CellID->611075472],

Cell[BoxData[
 RowBox[{
  SubscriptBox["m", 
   RowBox[{"1", ",", "1"}]], "+", 
  SubscriptBox["m", 
   RowBox[{"2", ",", "2"}]], "+", 
  SubscriptBox["m", 
   RowBox[{"3", ",", "3"}]], "+", 
  SubscriptBox["m", 
   RowBox[{"4", ",", "4"}]], "+", 
  SubscriptBox["m", 
   RowBox[{"5", ",", "5"}]]}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1078657950]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " can also take a function, as its second argument, to apply to the diagonal \
elements. If ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " is used this returns the diagonal elements."
}], "Text",
 CellID->2094701323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"mat", ",", "List"}], "]"}]], "Input",
 CellID->1945710390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["m", 
    RowBox[{"1", ",", "1"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"2", ",", "2"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"3", ",", "3"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"4", ",", "4"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"5", ",", "5"}]]}], "}"}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1821031861]
}, Open  ]],

Cell[TextData[{
 "It should be noted that these commands for extracting parts of matrices \
will work for any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression."
}], "Text",
 CellID->145550783],

Cell[CellGroupData[{

Cell["Getting Multiple Pieces", "Subsubsection",
 CellTags->"c:11",
 CellID->288135948],

Cell["\<\
It is possible to extract multiple elements by using indices in lists. This \
will be demonstrated with the following sample matrix.\
\>", "Text",
 CellID->125254051],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->610861097],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9z2jAUwIUNISTkDkibpr0O+TTtlA/B5XqXDL320gxsjIyMXIceIyMj
IyMjIyMjIyOjK8mSLD8/WbIxNKTOHY6l9yS99/Tvh9B99+Xx2/fuy9ND9+7r
c/fn49PDr7svP55pll8hhEzo5/6W0PeAvvHPJAjo/w/s6bM0/yOf90y3ea0d
kOuBdI0YdKoqTf+Y8Nqq5dHEO0t7nqjNZhdMN7k3NZ47Ho9FbkPTok9SlS4p
mwiwXGlFlgOrlUaKNa0i9M90C8Jnnev1+32R7/PssPbVajWbzWTtdartg1bO
QLpxJD3WKyycJnkd0ee9uFwuoZej0Uj3vaZCIyLHfPdEW3qdFwVqXyB+m7XP
Qd9eWrWjUrvdrtfrRTHwZW4Yhth4jtel23ceuHpn6pV0u/cvJb3O3kbk32Aw
oIEJ5OzisfIWi0XNWKcvZhRruZmq5R7B7Npw7JlHk7Q3aoNOeDrt4z7zObLZ
bMzj49OBcsMdKr4OSZviaxbzQAxpXvhjwXmhJXQ4hFuBwZI/MloiXUnRitJv
UYuzQIFsceXUKptzPjK/JXMoGcoauFQyBlavzhYmeXJdsXlxhdWSYIz3mFaM
MW4s1sB0VkJC9RHGaDh5zdJ1bdbxNYqQxNrcOJIeYxGdMaAcrsmQpHAv7fsr
Qeq276/5S7nvFnqp7LuyLBXxTr5Y+UGSgszeSm03e/Npp7MGVqeKc84YQPqv
BWnMAbUhZeORK6YU6rWTPxHJ5IvRoZjk1smmYzCJmyWvlRD+FyZhq4KHjXH6
2tZlCSbpGKUs99pQr2SSdoq8ZJJsTGL7vtg4kh5kEtv38n2Y5DR3Dfuubdo7
92GSYkgsP1NlL+V+PgLbUP2xB7/BEWJmF9vJnpn69i8FexEfhZg/JbuU7PJW
2MVHxrhkFyVD2QWXSnbB6tXZxSTPzi6XoJT9NxulZfzNRmmkWNcqQr9kl1Qv
3faY09g13E4csL2zZBe3NlR/lOxSskvJLkfS+jfswuZJjST3GZbX0mUJdmkb
pWyudwz1SnZppciTM3Q4HKZ60QSl9DsKIoskyQRQF0mezNjICvZZLn0ju0T3
aXSvR6PRdruVpU+ZXcLdfL1eT6dTFS3h5Ww2E7dQSnaJbsrM53Pk3gEdDiKC
h4xVfvuzl5K/gGVvI+ofumbE7qVku8ck6cl8P+X13XbyCUl814t89+h8Oi6L
sFNsj45M3mp47lhV8Q8OTyA3WI+L88/wog57/Q3SodZEe5LKX0er0zU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->310541404]
}, Open  ]],

Cell["\<\
The following gets the first and third elements of the second row.\
\>", "Text",
 CellID->1207075054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32419369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["m", 
    RowBox[{"2", ",", "1"}]], ",", 
   SubscriptBox["m", 
    RowBox[{"2", ",", "3"}]]}], "}"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32169338]
}, Open  ]],

Cell["The following gets the second and fourth rows.", "Text",
 CellID->195973197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1629091128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"2", ",", "1"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"2", ",", "2"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"2", ",", "3"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"2", ",", "4"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"2", ",", "5"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"4", ",", "1"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"4", ",", "2"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"4", ",", "3"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"4", ",", "4"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"4", ",", "5"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->150843666]
}, Open  ]],

Cell["\<\
The following gets the first and third elements of the second and fourth \
rows.\
\>", "Text",
 CellID->1419005051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1411992222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"2", ",", "1"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"2", ",", "3"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"4", ",", "1"}]], ",", 
     SubscriptBox["m", 
      RowBox[{"4", ",", "3"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->400546248]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Pieces of Matrices", "Subsection",
 CellTags->{"t:9", "c:12"},
 CellID->1626148827],

Cell[TextData[{
 "Setting elements, rows, and columns so that a matrix is updated is quite \
straightforward using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " on the left-hand side of an assignment."
}], "Text",
 CellID->1806443667],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], 
     StyleBox["=", "MR"], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["21", "TR"]], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["22", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "assign ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " to be a matrix "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]", 
     StyleBox["=", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "reset element ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", 
     StyleBox["=", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "reset all elements in row ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       StyleBox["i", "TI"], "]", "]", 
       StyleBox["=", "MR"], 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}]}], Cell[TextData[{
     "reset elements in row ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["j", "TI"], "]", "]", 
     StyleBox["=", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "reset all elements in column ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       ButtonBox["All",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/All"], ",", 
       RowBox[{
        StyleBox["j", "TI"], "]", "]", 
        StyleBox["=", "MR"], 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}]}]}], Cell[TextData[{
     "reset elements in column ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->1922393630],

Cell["Resetting parts of matrices. ", "Caption",
 CellTags->"S3.7.2",
 CellID->778270295],

Cell["Here is a 5\[Times]5 matrix.", "Text",
 CellID->65954188],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->390475864],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9z2jAUwIUNISTkDkibpr0O+TTtlA/B5XqXDL320gxsjIyMXIceIyMj
IyMjIyMjIyOjK8mSLD8/WbIxNKTOHY6l9yS99/Tvh9B99+Xx2/fuy9ND9+7r
c/fn49PDr7svP55pll8hhEzo5/6W0PeAvvHPJAjo/w/s6bM0/yOf90y3ea0d
kOuBdI0YdKoqTf+Y8Nqq5dHEO0t7nqjNZhdMN7k3NZ47Ho9FbkPTok9SlS4p
mwiwXGlFlgOrlUaKNa0i9M90C8Jnnev1+32R7/PssPbVajWbzWTtdartg1bO
QLpxJD3WKyycJnkd0ee9uFwuoZej0Uj3vaZCIyLHfPdEW3qdFwVqXyB+m7XP
Qd9eWrWjUrvdrtfrRTHwZW4Yhth4jtel23ceuHpn6pV0u/cvJb3O3kbk32Aw
oIEJ5OzisfIWi0XNWKcvZhRruZmq5R7B7Npw7JlHk7Q3aoNOeDrt4z7zObLZ
bMzj49OBcsMdKr4OSZviaxbzQAxpXvhjwXmhJXQ4hFuBwZI/MloiXUnRitJv
UYuzQIFsceXUKptzPjK/JXMoGcoauFQyBlavzhYmeXJdsXlxhdWSYIz3mFaM
MW4s1sB0VkJC9RHGaDh5zdJ1bdbxNYqQxNrcOJIeYxGdMaAcrsmQpHAv7fsr
Qeq276/5S7nvFnqp7LuyLBXxTr5Y+UGSgszeSm03e/Npp7MGVqeKc84YQPqv
BWnMAbUhZeORK6YU6rWTPxHJ5IvRoZjk1smmYzCJmyWvlRD+FyZhq4KHjXH6
2tZlCSbpGKUs99pQr2SSdoq8ZJJsTGL7vtg4kh5kEtv38n2Y5DR3Dfuubdo7
92GSYkgsP1NlL+V+PgLbUP2xB7/BEWJmF9vJnpn69i8FexEfhZg/JbuU7PJW
2MVHxrhkFyVD2QWXSnbB6tXZxSTPzi6XoJT9NxulZfzNRmmkWNcqQr9kl1Qv
3faY09g13E4csL2zZBe3NlR/lOxSskvJLkfS+jfswuZJjST3GZbX0mUJdmkb
pWyudwz1SnZppciTM3Q4HKZ60QSl9DsKIoskyQRQF0mezNjICvZZLn0ju0T3
aXSvR6PRdruVpU+ZXcLdfL1eT6dTFS3h5Ww2E7dQSnaJbsrM53Pk3gEdDiKC
h4xVfvuzl5K/gGVvI+ofumbE7qVku8ck6cl8P+X13XbyCUl814t89+h8Oi6L
sFNsj45M3mp47lhV8Q8OTyA3WI+L88/wog57/Q3SodZEe5LKX0er0zU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->304459730]
}, Open  ]],

Cell[TextData[{
 "To update parts of a matrix you can use ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " on the left-hand side of an assignment."
}], "Text",
 CellID->1017588979],

Cell["This sets the third element of the third row.", "Text",
 CellID->58205345],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "3"}], "]"}], "]"}], "=", "x"}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1152174030],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr1T2zAUV2xMCIS7JLQUWgb+hQ6dutOJPyLH9Q6GXnuUgY2RkTHXoZeR
kTEjY8aMGTNmzJjRlWTJkp+fLPkjJs2FuxhL7/ek954+3s+yL/t3199/9O9u
rvrn3277v65vrn6fX/y8pVV+gxDyTH+XJ4Teh/SO/57DkP7/wK4+K/M/clay
3OWt9kCtB8oBMWB24jL9Y8IjK8qjhXeW/jzRms0uWG5zbwJeOxwORW1LQ9Er
2ZEuxTYRYHmMUpYDq2NEhjWdKvC7ugXRtclxDw8Pot7n1VHr0+l0NBrJ1psU
7YNedkG5VROOjQoLp0neRPB8FCeTCfRyMBjovgdxaETkmO+e6Etvc79C9D7i
txm9B8b2wIpWWsvl8v7+XsXAl7VRGBLzOdmWbt9e6OqdaVSy7S6vJb3O34fy
7/HxkQYmlKuLx8obj8eBsU1frCjWczsT5R7B/Gg498yzSdqr+qALni77pM98
jcznc/P8+Lii2ihDJfchaVNyz2IeiCnNlU8rrossodMhSgUGS/7KaIlyIwOl
ypuI4lygQm5x6NQrW3M+sr4l54hlKNfApZJjYO3q3MIkT+8rNi8OsVZSHOM9
hkpwjGOLNbCclyGheIRjtJy8ZuWmtur4HkVIam9u1YRjXETnGFAO92TIpHAv
7fmVIG3b82txLfdsoWvlz8pSS/GdYrHywzQLMnsr0W72FkNncw2szTjOBWMA
2X8QZnEOiIYsG49cNVqo107+KCZTLEar4iQnTjbVwUncLFlXhrB+nOSrRe7G
Qdgu4GFzmt52dVmKg3w2aEqW0c2Qvx3L+GKxph7WYHuia+XAeUQ9PZ8a9CA7
sD0hl2EHK9y/EyP5yamdQCszOZ71TBmqTOavhu/A3N4Wlp059+l2rgD7CsNy
OR87KzPnfNuJmNylcK+hNow0nsUxC1eYxR3mbl0ZHO4Y2+xdPeptThTYOvGR
uS2zeSxLZfOeUcpmyZGhXT3Xm+T5c/0B0LK/tYhRxrcWMSLDuk4V+LXiBmVw
dXIG2/5vflour1U8W7g9c2NZcP14RX6G4K61KSxkPWfh9uRhy102gbuwdRKQ
dJ5hdR1dluIuXaOUrfWeoV3JXToZ8vQKfXp6yvSiDbT0t/SiiqSZCWBdJH2S
YWNWcMwK4Y3cRX1Rons9GAwWi4XU/p+5S5TNZ7PZy8tLHC3h5Wg0Et9hbLmL
+lbk9fUVefNOp4OI4CpjVdz+/FryHVD+PtT40D0j8WVGvi95JHsyf6Gxft/7
+ISknvWU7x5dT/VyEfZu2aMzk/canQnuxPEPV89AjrERF2eT0acq7PYPKEeo
Z+1KGv8ABJtStg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->540022989]
}, Open  ]],

Cell["This sets the second row to have a particular value.", "Text",
 CellID->992562789],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->349824827],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtv2zAQpkUrjtMEsNPWtZ1H8xc6dOreTvkRRlAgGYoWaQZvGTN6NDoU
HjN69OjRo8eMGTNmzKiSFClSp6NEvVwDrQHLIu9I3h2Pdx9Jn49uLr9+G91c
XYzOvlyPflxeXfw8+/z9mlXRBiHknn3P+4S9B+xNfO+DgP2Gz3f8SXmt+JDj
kuWu6NUXtbPZTNbuAS4PlH32eojxNKMy+3Di60wujxXeZIznyd7QMVPKO6J8
e3sry1Ro2xSvDw8Pi8UCasueId03ZSRAk4hLawK0iDhSpOtUwb9jShA+W2o2
1+s11Ho6nRq9txg3RW2my+0N8XEf5Oa00VsIP6EvLy/j8VhrSVVtqGhsLrXl
uO6eHMvsc69CbriG2qncu2BuX2Vya4nu7u6YwpHHCBt4q9XKt/ZhyrUbuGpl
m410ecu3UtrmH0Prx5Y6W/BxG4nV8PT0lO4nVK4oLsF+Kpe7JfNzQ9+ze5OS
V4+hI52pu46KuO7DmmrDDMYcNkw3Fpmo1EAua9F4UHFdX/mAHLOBSvIblP9d
LoEVKsQeB06j8jVHkXWuMEhEQ7EHTlWYA+vXxBo2ejK+ZGlxgPWSwBhvMa4Y
xuhlSAPLeRETyo9gjLaT1rzcMladiFGEJGJ0e0N8HIuYGAPSYUxuOWlpzx1m
rsufZ4u3cs8WZqv82Vm10ninmK1okERBdm0Vt5u8xbjTMQfWZ2TngjaA6N8P
0jAH5IYoG7dcNa1QrZ300UimmI3qwiR9J5k2h0m2L/dvK1cWJvmUQXfDIDwK
eJhPs9euSUtgkA+WlgpldFPofw9lfMyQZjOoIWtn187B5xG9ex5Y2kF0kLVT
LoMOaozfsZk8curHN8qcjmc9W4Yqk/mrwTswt+9LyY6dx3Q7X4BjBUG5nI+d
ldlzftaJmIpSuNawNbQ0nsUxCWvM4g6+u6kMDiPG/+y93Vzc13zpH770Hj4/
p/J3KH8HTr3ByGp6nawCvqhrT0HbPsrl5itQjiNQfo+MxRPvCajvFRoNoiU3
zSBXsbGhBlzzKLol4kTxmYXSQp2HRpmoqGTQ6/cnU6LiEqhsfSKtdRzo9eHJ
XpvOfrmtUWCbTzI5lvEJfpLZMWmJXUTXSuUzd2jpV+0xOin0JCKYTCapWuyD
VlSpEMnEfRTe6NK45CS5C4FIA0oH56wQv3VPou++Ta2n0+nz87NqXfWepAxf
3r1KGH8eHx/n83lkLanlYrGQN8VuKBXKaD+lK9+qOEp1O+vD0HfoEcvlErkx
ZO4gLVinrYrLn7+VOr/NP4aeHxYzYjfQ8L8GFO0b3mbbb1e3766eEpI4k9G6
e2w9bfYEk2Msj3mmGDXczzcj+wf1n1v2sBmX5wrhFTt//QXKIZf5/ybS+ANQ
KmuB\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->177034912]
}, Open  ]],

Cell["This sets the second column.", "Text",
 CellID->2106994522],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "5"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->251592224],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWTtPHDEQXta3HMcjAZKQ4xGEeCRKICmS/xCKiCb/4ISIQFGUiFBcR0lJ
FV15P4HySkpKSkpKSkrKje21177ZsT27dyCinHR3a3s8L8/ON7Z3Wkf7ez9a
Rwe7rZXtw9av/YPd3yuffx7yLjYSRVGXf3eaEX9O+ZP8dtOU/2e/L8UvE73y
E30C7aVAe0ZySWRvt9tVveOAKgbthD++xWhqeZt/Yt54HuAk2qI5S6Cz26Oy
fXx8rNpM2lGTj1dXV71eD9rBf7PxxNZR9L7DqDyyp4dBP2rG9UBdr8Ll5SW0
qdPpWNzrnJqhHjHtZ8qz40T6hoNOxIZYVtd4HaGP2N3dXbvdNlYw3ZsZ0rcS
xjPCtljJsnnOous27uUBY7jhpR4DazQRpDZ6npyccMPylZe2xhcXF4mTh63X
GGgLvZM8GgBdkJs9y28H5B2TqVHNGH/l+IvX7wUZtzc3N/4VZ8paoUGTbDUD
q6Z956aGUeWOCK2RkWFyim2dyT+4dWuKB+7XhRK9WZ7nYZYlaYcWTMlTL52c
vIb4CNLME/uaek0VrxFUiy0g8RsYd88SeWaPRP3nn6aaAR4qi9pTJCmTabaC
LvTOx1DUxmbaaO0aL2aGkJ5TGJdCtodRFZJdtqJA6RGUbpBsEu269fbIzIJk
9RepyTIU+oaDTqC5jdJwHGbKOskKd862MQbyngPtMHJFpbKzPas83ulZpkao
5gWWFisH8ajxW4yParucs2n627LcOI3xzD1Z0UpY2yapVdcTKzLIA1aetFmo
VSR9DfZX84FEUJMjnXaWwfMmSR8Mz9dBxDQQmnJ4HtLiPZBIQ+gPaRYp/yOe
fwXtavg9oTxYiGn+uO0Y0wg94xm/L4T+EpD1MIgb2q3Y++I4Mnu6ecd8iKyh
/dsgyBrKlJ59cF9+WiRxT6x25EQVFwIMgp2hCsK1B24o2UtkrrRdbeSQNUht
ANcR29367YFcoJfclQWUPSgCrtueJETasDHvNbBJ12/2uzs8vNu0tM8NJeLY
lpJK2/M+Vjx7eCoRd8Llq+p/QvlxWf0vqP95EjeYNwVXf7VqepfB3CZKRYsk
qMeCsg7m1KeITAGEr0D/XCWp66D9hGQh9EM12RugrWsamfEKmaT6CsMMMYl4
3s72i2D8/uPKrgGra6DRd0N5S5/xLKt+wbVGjs/Hmg0e0ymarkWwU7Q39ljh
FG3WMVPX6NOe8SLun56eevWEEc+0krlOIuo2MSqPbOjjSvTOmt7cONo2dTqd
29tbPZtS02tPu2p01ynaoLV+lg+ur6/Pzs5ybygrer2eusej1YhQR3hzip85
DK9GpJ1CYVVttpbn5+fI/Q9fSOWbal7Qb1+C9N+XXbq6pHsBfVv77gThLS5D
ecP7RXiS6r/xhCeow74fZVFUOC8w1sU82t27h7BeZU7PhF9iHldSXhYbtdy3
qf/MTNta9cxsDltJFZ/ZVad4hHl2F4xnsz4q736XrW4mZOQvqAMCag==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->251564182]
}, Open  ]],

Cell["\<\
It is also possible to use negative indices to count from the end of the \
matrix. The following example sets the last element of the last row.\
\>", "Text",
 CellID->1415148828],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}], "=", "x"}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1024961671],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWT9PGzEUP+5yhAvQQtqmCVCESmjVQquq/Q5lqFj6DSJEBaqqVpQhGyMj
U5UxH4ExI2PGjIyMjIyMV9tn3/nePduPS0BURSJ3tp/fPz+/3zt7p3O0v/ej
c3Sw21nbPuz82j/Y/b32+ech6wqmPM/rs/+dpsfeY/Ym/vtxzJ7J73P+G/Be
8ed9Au0V0P4gZoWit9/vy94aoPJBO2SvbzCaStpmfz5rPHVw4m3e3BD9x8fH
sj8QelXE68XFxWAwgHqx32Q81GXy3rcYlUWHhVvSt5W3RqMR1LXX62mzqmxS
AGZPg/YT6YEakT4y0PE15O6PpOd9+WwIupubm263m2kbqN5E4ZwnM08oHhGQ
VUf9XrPygDEVWalnwJrMxrnoYi9NQXFycsKMSFdJ2OUPh8PQyF3XYQa0uY58
UhWjc3LTZ6U6k3TgFs/JZ0uMs4BnYZ+3S0TX1dWVfb0Cqb+f+ohiRwB8rrxh
poYxUcvpn+1ZXf9sf+P6r0veuOeWzL1IZLCwSBKaQYNAypIbQrBbR2yCNC1D
n77nmmq1JJ8pVIMtIO0bGDfP4ubukaj//NNUi8BDLjSD7XmSFL7zAmRnKpRL
x1B0w2aqPVK3jBfzkEvPeYxLIQvDqHLJrk+Cflrff8lvRLKJt6vabhIZBsnA
z+IsR1HoIwMdR1OFktg4zIFVkhXmbKzjAeTdAG03ynhI3jXjqD7r9tikZmXY
Xc4LQVxEdP6qsJaPTyu7jLNp+uuyfCcVFjNlrYQ1Yxhr9S+xUoI8YOVHm4Va
RdI3Q/VyPhDomUNiXGMLjhd6myR9MCxvg4iJEBoTlsM+mhbvgEQaQr+Pk0j5
H/H8K2iXw+9Z6cFCTLPXbcOYQuhFy/hdIfQXh6z7QVzb1wt/1b9L9dq2ZZgP
kdX1rTUOsroypeX7NJeflkncQ63tGVHFhADjYKergjB9r6ozgBUyVzNa2ioJ
JWuc2gCuI/bdarcHcoFeMlcWUPa4CNjWPUmItElj3itgk6rf9L07Obzb1LRP
DSXi2JaUSvvmfah4dv9UPO64y1/K56z046p8Lslni8QN5k3O1V6tZr2rYG4T
paJFEtRjSVoHc+pjRCYHwhegv1FKahu0H5EshH4oJ3sDtFVNIzJeIZOUX2GY
IeYQz+vZfhmM331c6TVgeQ0U+m5Ib6kznlXZz7lWyPH5ULPBQzpFU7UIdor2
Wh8rnKLVDTNVjb5gGS/i/unpqVVPGPGBUjLViUfdJkZlkQ19XIreWNNnN3O6
Tb1e7/r6Ws2m1PTK06Ya3XSKNm6tn+SDy8vLs7Oz1BvSisFgIO/RaDUi1BHe
MOJnDpOrEWmnUFhVm6zl+fk5crPDFlL6ppwX1O4Lkf67sktVl3QvoLs1d38H
b1EDlLd+S5jdcbqsNt1mTvreMvC8wnlBZp3Pot389eDW6zanZ9wvPosrIS+J
jUrq29h+ZqZsLXtm1sBWUsZnconJX2Ge3QXjyayP0rvfRaufCJn6C91MkM0=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MatrixForm=",
 CellID->72468259]
}, Open  ]],

Cell[TextData[{
 "You can also use the range syntax for setting pieces of the matrix. This \
sets every element in every other row to be ",
 StyleBox["z", "MR"],
 "."
}], "Text",
 CellID->515100245],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "1"}], ";;", "2"}]}], "]"}], "]"}], "=", "z"}], 
  ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[10]:=",
 CellID->249228003],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"z", 
      RowBox[{"-", "1"}], "z", 
      SubscriptBox["m", 
       RowBox[{"1", ",", "4"}]], "z"},
     {"z", 
      RowBox[{"-", "2"}], "z", "4", "z"},
     {"z", 
      RowBox[{"-", "3"}], "z", 
      SubscriptBox["m", 
       RowBox[{"3", ",", "4"}]], "z"},
     {"z", 
      RowBox[{"-", "4"}], "z", 
      SubscriptBox["m", 
       RowBox[{"4", ",", "4"}]], "z"},
     {"z", 
      RowBox[{"-", "5"}], "z", 
      SubscriptBox["m", 
       RowBox[{"5", ",", "4"}]], "z"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$426]]]], "Output",
 ImageSize->{115, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//MatrixForm=",
 CellID->612177350]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Multiple Pieces", "Subsubsection",
 CellTags->"c:13",
 CellID->289617502],

Cell["\<\
It is possible to set multiple elements by using indices in lists. This will \
be demonstrated with the following sample matrix.\
\>", "Text",
 CellID->1403412012],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1332790683],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9z2jAUwIUNISTkDkibpr0O+TTtlA/B5XqXDL320gxsjIyMXIceIyMj
IyMjIyMjIyOjK8mSLD8/WbIxNKTOHY6l9yS99/Tvh9B99+Xx2/fuy9ND9+7r
c/fn49PDr7svP55pll8hhEzo5/6W0PeAvvHPJAjo/w/s6bM0/yOf90y3ea0d
kOuBdI0YdKoqTf+Y8Nqq5dHEO0t7nqjNZhdMN7k3NZ47Ho9FbkPTok9SlS4p
mwiwXGlFlgOrlUaKNa0i9M90C8Jnnev1+32R7/PssPbVajWbzWTtdartg1bO
QLpxJD3WKyycJnkd0ee9uFwuoZej0Uj3vaZCIyLHfPdEW3qdFwVqXyB+m7XP
Qd9eWrWjUrvdrtfrRTHwZW4Yhth4jtel23ceuHpn6pV0u/cvJb3O3kbk32Aw
oIEJ5OzisfIWi0XNWKcvZhRruZmq5R7B7Npw7JlHk7Q3aoNOeDrt4z7zObLZ
bMzj49OBcsMdKr4OSZviaxbzQAxpXvhjwXmhJXQ4hFuBwZI/MloiXUnRitJv
UYuzQIFsceXUKptzPjK/JXMoGcoauFQyBlavzhYmeXJdsXlxhdWSYIz3mFaM
MW4s1sB0VkJC9RHGaDh5zdJ1bdbxNYqQxNrcOJIeYxGdMaAcrsmQpHAv7fsr
Qeq276/5S7nvFnqp7LuyLBXxTr5Y+UGSgszeSm03e/Npp7MGVqeKc84YQPqv
BWnMAbUhZeORK6YU6rWTPxHJ5IvRoZjk1smmYzCJmyWvlRD+FyZhq4KHjXH6
2tZlCSbpGKUs99pQr2SSdoq8ZJJsTGL7vtg4kh5kEtv38n2Y5DR3Dfuubdo7
92GSYkgsP1NlL+V+PgLbUP2xB7/BEWJmF9vJnpn69i8FexEfhZg/JbuU7PJW
2MVHxrhkFyVD2QWXSnbB6tXZxSTPzi6XoJT9NxulZfzNRmmkWNcqQr9kl1Qv
3faY09g13E4csL2zZBe3NlR/lOxSskvJLkfS+jfswuZJjST3GZbX0mUJdmkb
pWyudwz1SnZppciTM3Q4HKZ60QSl9DsKIoskyQRQF0mezNjICvZZLn0ju0T3
aXSvR6PRdruVpU+ZXcLdfL1eT6dTFS3h5Ww2E7dQSnaJbsrM53Pk3gEdDiKC
h4xVfvuzl5K/gGVvI+ofumbE7qVku8ck6cl8P+X13XbyCUl814t89+h8Oi6L
sFNsj45M3mp47lhV8Q8OTyA3WI+L88/wog57/Q3SodZEe5LKX0er0zU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->504388574]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second row.\
\>", "Text",
 CellID->1072968381],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", "x"}], 
  ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->959395608],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjFT2zAUFnZCCIS7JLSUUgZmpvYYu7cTPyLH9Q6GXnuUIRsjI2OuQy9j
xowZM2bMyMiYMWNGV5IlW35+siTb8ZE23MVY0vek956e9D7Zvurd33z73ru/
ve6df73r/by5vf51/uXHHa3ydwghI/q7OiH0PqB3/DcKAvr/Hbv6rMz/yFnB
cof32gW1HijXiQZTi8r0jzUeGVEeLbwxjOeJ3kx6wXKLW1PntcPhUNQ2FRS9
kpo0KdKJAM0jVKw50DpCZGjTLgO/q2oQXhsc9/DwIOp9Xh32/vz8PJlMZO8N
ivbBKLug3KwIx2aFuVPX3kDwfBbn8zm0cjAYqLbXI9cIzzHbPTGW2ud+ieh9
xG49eg/M7YERHUutVqt+vx/7wJe1oRsS8ZzsS9VvL7C1Tjcr2XoXl5JWu48R
2/f4+EgdE8jVxX3lzWazurZPX6woNnIrE2XvQXc0jD19NEl94zHogqfLPmkz
XyOLxUIfH6drqg0zVHIfkjol9yxmgQhpLvy+5LpQExoOYSrQaPJHekuUdzJQ
cflfRHEuUCK3OLQala05H1nfknNEbSjXwFslx8D6VbmFrj29r5isOMR6SXGM
txgqwTGODdrAsitDQvEIx2haWc3KDWXV8T2KkNTe3KwIx7iIyjFgO9yTIZPC
rTTnV4L0bc6v+aXss4Uq5Z6VpVTMd/L5yg/SLEhvrUTb6ZsPnc01sD4jP+f0
AWT/9SCLc0A0ZNm458qRQq22sidmMvl8tC5OcmKlUxWcxE6T18oQ/hdOwnYF
D4txettR21KcpKttZbVHmn4lJ+lktG85iRsnMZ0XmxXhICcxncuLcJLNzBrm
rK3LnUU4STlMLD+ncpeyfz4Cx4jmowB/gxGi5y6mJ3t61ldcCs4iHoWYPVvu
suUu5aI+Bsko+wzK+bjJRRDODK9P8Y9PaquGYeja3RnGBZBKvzO5xBAZ47Yx
fCEu4JH4uTqLattcbiO3xtye8OKHANsZrHbMHP2o+Z9o840uJ9jlZJnBz9C+
Tfmy5SRdRd7Mtsc0UwdO0pXlOIvYOXXBFchtcDVi+coGs81pm3geZ3tKHdlf
WV1bbUvlw462lUVJV9OvzJbtjPb0inx6esq0ogWk1HfXooqkv40AeZ6kT+ym
XA7nLBdem4Pj7yxUqweDwXK5lNKbfB4Ps+HLy8t4PI68JaycTCbi6wS7c9Nm
nITy5/4wIqbTKfI+moaD8OA6fZVff3cp+WbEfYx4fuiekfhewe37Fsls9N8t
vL6vYHxCUqeL2HaPrqdqz9fs6aZHI5OPGj6PqkX+D9Z/qj7GZlw8Fws/4GC3
v0E5RI2UK9n5C1PR3hw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->15115168]
}, Open  ]],

Cell["\<\
If the right-hand side of the assignment is a list that matches the number of \
elements being assigned, the assignment is done element by element. Thus, the \
following gives two different values for the first and third elements of the \
second row.\
\>", "Text",
 CellID->495184320],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1063734115],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr9T2zAUFnZCCIRrAi2lLQPtyMTevZ34I3Jc72DotUcZsmVkZMx16DEy
MmZkZGRkzJgxI6MryZItP71nyT8SoA13MZb06em9pye9T7aP+ucn3773z0+P
+/tfz/o/T06Pf+1/+XHGq8IVxtg1/x3tMn4f8Tv5u44i/v+tuIaiLP/YXsVy
T0rdArUBKDcZgWkkZf4nGredqIAXXjvGC5Q0l16w3JHWNGXt1dWVqm0bKH5l
DW1SohMDmieoVHOgdYLI0aZbB37V1CC+tiRuOByq+lBWx9IfHh7G47GW3uLo
EIyyCsrtBeHErAh3Uu0tBC9n8f7+Hlo5Go1M25uJa5TnhO2BGsuUuV4jeh2x
m0avgbndcKLTXo+Pj4PBIPVBqGtjN2TiOSvL1G8t8rWOmpV8vav30lYXHyO1
7+Ligjsm0qtL+iq4u7trkjJDtaLEyJ1clL8Hi6Nh7NHRpPVNx+ALni/7rM1y
jUynUzo+3s+pNs5Q2X1I65Tds4QFKqRl53c118Wa8HCIUwGhyR/tLVVeyUGl
5X8RJblAjdxi02tUseZCZH1rzpG0oVwDb9UcA5Nrcguq3d5XXFZsYlIsjvEG
Q2U4xo5DG1guypBQPMIx2l5Wi3LLWHVyj2LM2pvbC8IJLmJyDNgO92TIpHAr
3fmVIbLd+bV8L/9sYfYqnpV1r5TvlPNVGNksiLZWo/30LYfO5xqYzMTPJX0A
2X8zyuMcEA1ZNu65enqhVnvZkzKZcj6aFyfZ9dJpEZzET5PnyhD+F04idoUA
i3F+2zPbLE6yRbaK2m1CruYkvZz2JScpxklc58X2gnCQk7jO5VU4ycvMGu6s
TeXOKpykHiZWnlMV7+X/fASOkcxHBf4GI4TmLq4nezTrq94LziIehZg9S+6y
5C71og6jbJR9BuVy3OQgimdG1lv8Q+wNovKTiSKYBtVenGkcgF72u5NXAPER
65GjRxfDV+IIAUuft4to98nxHVCm+s0x52e8+iHCdgzXTtpRVvv1NtkAI7MP
lSH8MrTO53uobFf27IAybtdTZNN8u1zztGHNN54hniwHesSiqXECnVP+gyua
zGkNJZpp+cvsVz/qaU7uYr9pIjuuqOuabVbm7JGtIp62CLk6n3Zz2u21eXl5
mWsFzDPmW25VxeyvKAAjYPbZ3pXt4ZyVwpNZOf0iw7R6NBrNZjPd+yWf3ONM
OZlMbm5uEm8pK8fjsfqOwe+E9TLOTOV5QRwRt7e3yJtrHg7Kg/P0VXn9i/fS
71CKj5HOD98zMl82FPsSRrMd+guH5/e9TMiYdf5IbQ/4elrsSVw8Bw14ZMb0
QT65aiT+j+Z//t7BZlw9QYs/9RC3v0E5Rl0bV7byF2tL8wc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->527985961]
}, Open  ]],

Cell["The following sets the second and fourth rows.", "Text",
 CellID->1416326531],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1491263169],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWb1vGjEUN3dcCAmRgLSUkI/mr0mHqn8EiiolQ9UqzcDGyMh46lAxMjLe
yMjIyMiYkZHx6uezz7539n3xIaKCxB3Pfvb7tP1++Fv39en7j+7r82P3/stL
99fT8+Pv+4efL7TJLhFCxvT7tU3ob5/+Yt+x79P3J3jaQLMPudmQbrBZm6jV
QrRDDDzlkKYf6LxM5bIo8SFFnsVnS9ML0zVmjcNaR6MRb60qXPRJysKkUCeC
NA+5pOZI65AjQZv6NvhPVA2CZ4Xx9ft93m6z5mD2xWLheZ6YvUK5bSTlBNHV
PfFBVMCdpv6Khp9FcT6fYytd11Vtd0LXcM+B7RaXpc55tkXuM43dZu5TFNvz
VG45ar1e93o96QNbtAZuiORzdC5Vv1M/q3WmqCTrvfkoYXV+GdK+wWBAHeOL
1cV8Zc1mM8c4p81XFEiuJXJl92B+bpx75mwS+koZdMHTZR+1ma2Rt7c3c350
dtQanFDRfUjoFN2zwAKe0mzw1ZbbAk1oOgRHgUGTv8JbnC4lcEn6yJXMBTnn
8ByB97UfxOeOvzv8fZVpNnzGqJnHm1A+ytY7NLat5WoX0uMa0Z81suAAv0Xt
rULScO2WzTLMVUw2tgAshx2T6RSpkkSki0UWa4tt7ig04dLU/t3nk6pRcQ0c
7r9b7q0bX64Pi89azpyXh7oLZONqIA9uimkuMkk9557GVTkEvKH2xTBO09gL
rZeGecXZ3Ujoj9czaVZc6GaJ5exHHVdk1bZStMF0XmSm5ddgm2omq4EGDJFW
E1b3xAf7iYpt0mpvjODMZ2i8vsJ5g/cyfZ25nVE6f6SPchQa+vX1vW6UxFnF
fGUhyfkxEND50UzxUdkxEJYRxqOgr3S43oyJ0tC73rPbGYWjqM9CnT0SaRXz
0a4wU7ZTfh+Y6X+oNw6V64iZhKwjZsoj54iZjphpP5gJzmcIru5+qK72xTBT
w9gLkWsa5hWYqZ7QH68MhsNhohU1NEq9Q+BNJH5HZUc1J3FUhSsOrB2OWSF+
I2aS912q1a7rrlYrMfo9Y6Zg/1kul5PJJPQWt9LzPH5LlK22fR/Vajp6MNXs
QUZMp1PNvQBNB+7BXfqquP75R4nbm/wyZHzonhG5N8p3zyhQm/n+6PBuI21C
Yv8xSdstup72i4GgxrJoZjKpwX8G5dD//u6RT0sXcf7fRXCRBj//IDrgGitP
UvoHV/IPhA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->406487942]
}, Open  ]],

Cell["\<\
The following gives two different values for the second and fourth rows.\
\>", "Text",
 CellID->1695714755],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->622407948],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWT9PGzEUN3c5IBBQEloaKFA+TTtU/RARqgRD1YoysDEyMkYdqoyMjBkZ
GRkZGRkZGa9+vuez75199jmXNKiNlLv4+fn987P9fvGX4dnx12/Ds5Oj4eGn
0+GP45Ojn4cfv59yUrzEGLvm388Dxn+n/Jf4Xqcpf7+DZwxt8WF7U7Z7Qmqf
UCPSTpiFp5W3+Qc6t5xcEW+8ceiLUJrLLtruCG8SQR2Px0hta1z8yVrSpdwm
RizPuZTlxOqco8KabhP8y7oF2XNF8F1cXCA9FuRM+sPDw2QykdJXOHdMtCyT
dntOfDArEE5b/4qBX8zi/f099XI0Gum+J3loMHLge4S6dJlrDXKvGfy2c6+S
uV13cqtRLy8v5+fnKgaxpGZhKORzUZZu32rq651tVqrtnn6U9Lq+DuXf5eUl
D0wqV5eIVXR3d5dYZca4okBzp5LLP4L1uWnu2bNJ2qt08AXPl33RZ7FGnp6e
7PmxOyNqdkIV9yFpU3HPAg8wpcXgnYZpmSU8HbKjwGLJbxktbC9VcKn2f65q
LlhJCeYIvN+n2fwc4HsX3z0vaZtpcXXomYckko+KekDGDoxcXS87WuhNQmT2
kU5P+C2k072qi3SQv4xRMPFtBkWH1nh+EaBcYbr3SRvmHXZWYVOhmpIZEZYB
1Frq867WZqitVPfONO90i8It2MD47WO09lK1jiKU2vLO30XdLfy4eiSC02Kf
DS+t6xhpurYTzN28r4SF+tZeoG5Z5MozvlfRX657fPKoJKWUs29NXIVVu+2w
hrbrIjgjvwEDtb28hjZgDVft2J4TH2AlHQO5anSK9OynUrkOo3lDcZq5Hm1m
lCke7lH6qQr9ZhxgGqXwWFisIqK5PlaCdn3UEz7KHytRHfl8BMbKhP/t2MmF
8s2RbWYUnUVzFpr8UYgsLEazwlYDL5vmga38LFnUSuJ1c0kU4sJWO17S6A7f
PLbyyxVqB62XPxh0QWFAEcd2kLZmMFOY7vqYKWxmp8VMs88nF2bys0BWBC7M
9C/sYX8HM8H5DJNrukfq6n0lzNSz9sLM9S1yJWbqVvSXK4Orq6tKLzpklH7X
gCRWvsuKi5azMqqiFQe1js5ZEL8VM6l7Md3r0Wj0/PwsR79mzJTtP4+Pjzc3
N3m00MvJZIK3SX617euoVt3owVazZxlxe3truD/g6YARnGWswu2vP0re8tTX
oeaH7xmF+6V695EStdnvmRbv1jJmrPQfk/I94utpvhgIaqyIZ6bQmv1n0Mrj
n84e+WybZhz/u8gu3ODnL9LOuK61J1v6A4S9HnU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MatrixForm=",
 CellID->512332631]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second and fourth \
rows.\
\>", "Text",
 CellID->1723670944],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", "x"}], 
  ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->183157778],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtTGzEQlu9sjMHM2JAQQiioSQqSTKr0ScWP8DCZgSKTDKFw59IlpSdF
hpKS0iUlJaVLl5SUlBc973Sr1Uk6nw0keMbmJO2udlcrfbsnDnqnR9++906P
D3u7X096P4+OD3/tfvlxQrviGiHkgn4Ptgh9TugT/14kCf37iv3GrM0/ZGfG
dpdLXQe9EWg3iIWmnrbphw1uOKki2njhmC+S0lx6wXabW9Pgvefn57K3pVHR
X1JXJqU6EaB5SpVpDrROKQq06VRBv6RrIH6bnG4wGMj+mHcL6ZPJZDweK+lN
Sh2DWZZAu7UgOrYqzJ228SZCz1fx5uYGWjkajXTbG6lrpOeY7ZGcS5e5UiH1
CmK3nXoZrO2qkzrjur+/7/f7mQ9i1SvckIvnvCxdv+XE1zrbqhTrPTuXsjp8
jsy+4XBIHZOo3cV9FV1fXzesMmO5o9jM7UIqfw+GU8PYs0eT0jebg254uu3z
NvM9cnt7a4+P7Tn1CoTKn0NKp/yZxSyQIc2ZX1fcJzSh4SCgwKLJH+Ut2a4V
UGXtf5FqP8nH4GfQhrnDmpfUt4lYGTxf+KCPWjIA27i5+126vMOk5DD+k2Me
2EYzFASzW1768dNKwwEW1U0tqvkZQIhx9rU8+RhW6xgMx+GZBTMNXGszU3qT
YCeD7jtiOyFLyAlHG8WV4bjLxoak3kFlq3WDmrS9uIpxD5Ot1nxWvWFGCnO5
1SBuVEMnF9MwQ8CqYm07hM7o3fLSBdutGC750MA+Pw0eK5IsnorXsRXWxX7Y
pvaHEdP0sauPGbi3bh1lvRsWuQoVuwXj4ai4hkkx6uOXGFVuh206tPHCzoVi
bZO464rWguggNrvqtwBsDj738VqlGq7yKOHGeIzLH+PddTRrh9fRrF0+Rwnn
8q+j4RzpepT0FfZuyF5Xu94A4Z6thguuIh6FmD2BucrC6m7/nGXedfdz7hJG
NZ+6ey8RK8P7jfzjvT5qyTBs4+EZxh7gMrP4jxhFwbwdjL7yutsHy3345ojt
HjWO14lZQo6O/8SKNzZMqKLuduFlcf39ELjpfo9QtFLF9fiDYdxzPS57HyvC
/C/1ODtTGsj5yvo6+piBh13rKIuSdYtchZadgnFzR56dnRVa0QZc+h2n7CLm
HTrAeWJW7C4sh2tWit6Kwdl9vG71aDS6u7tT3E+5HhdoOJ1OLy8vU29JK8fj
sbzF9qubnkYlVB77RURcXV0h95Y0HKQH5+mr8vqHc6mbhvA5svWhZ0buXjvs
/yBUZmO/3358/y0RE2JUF5ntEd1Pi62v2dvNiEYmn1W8j6qn/k/mX1VvYisu
34uJi372+Bu0BdWF9ktqfwHoIAD6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//MatrixForm=",
 CellID->424733598]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second and fourth rows \
with different values.\
\>", "Text",
 CellID->2146060026],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->1843005617],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWj1MGzEUNnc5QviRktDSlHZgph36o06dWql0YquqqluEKsFQtaIMbIyM
jFGHipGRMSNjRkZGRkZGxqvts8++5+ezfUlOAaQcZ/u95/ee/fy9d3fb/YPd
Hz/7B3s7/Y3P+/3fu3s7fza2fu3TrniOEHJGf9s9Qu9Tesd/Z2lK/z9h15i1
+R95Pma7w6V2QW8E2gmx0DTyNv1jg6tOqog2Hjnmi4Q0l16wvcytSXjv6emp
6G1pVPRKGtKkXCcCNM+plOZA65yiRJv2JOjndQ2ya5PTHR0dif6Yd2fSr66u
hsOhlN6k1DGYZR60WzXRsVVh7rSNNxF6voqXl5fQysFgoNue5K4RnmO2R2Iu
XebiBKkXEbvt1AtgbZec1Irr7u7u8PBQ+SCWvZkbCvu5KEvXbyH1tc62KuV6
j88lrQ6fQ9l3fHxMHZPK6OK+ikajUWKVGYuIYjMvl1L5ezCcGu49+26S+qo5
aMDTsC/azGPk5ubGvj/Wp9SbIVTxHJI6Fc8sZoHY0pz56YT7Mk3odsigwKLJ
P+kt0Z4roVLth0j1Ki3uwfegDXOHFS+pL9JsZfB84Y0+askAbONm9Lt0eYlJ
KWD8O8c8sI1mKAhmt7z0S4S1LLKa2m7msU+Iceaxk5IFYM9Cz7BZx1w4Ds8o
mFngWuL5E34a6P4ijlMxVFY4ykguhd9etsIYMOaIhcwyjVzWSRnlKIjNxG79
9pefNZAKZnghawZloXo7uWRcBFjpqd86mCkqpzR6e14aydwXQ6lnYkX1vh5C
h/H6zb4FbPzixfVJ6PXVi3pWMc2PqgM8NG5V7YeMS8LDxm6ntx19zEDNrnWU
9a5a5EpM7ZSMh2PqCibFiL7HGFUBedcc2nghb21IzdpN4q5KWjXRQaR3VX/h
SF8NHybNVR0/3JkCxhWYKYyV/9i5qmc64Vz+VTicI1+Pir7CnizZq3LX8yPc
s5PhgquI70LMnmpZjJI5rardL5Ooo2r302RWM4mHUrVvptnK8H4j/3itj1oy
DNt4eIaxCbjMJ/NvMYqSedsY/VhVu16F+2B4QlSVXz+W52aW1KK+p2SoLB33
iRVnbFgQjsUu/UJQM1RWHVgqa8v6V7JuFHTpty68DeOlZ6Uep56Xz+kgfnG5
DSURp6qOfB+Bdd+8uD4I33z3op5VrJvlap5FUoLsPtbX1scMNO1YR9mKdS1y
Jda2S8bNaD05OSm1Yhlw6e9XRRcx39+DLIGY9b4rE4BrVoneiuDqWwDd6sFg
cHt7K7nvczWfYer19fX5+XnuLWHlcDgUb9D9qq77UUdVzyCyHXFxcYG8M6Xb
QXhwmr6qrn84l3zbET6HWh96ZhTeqYd9gyFzIPu79dn7UiMmxKhNlO0Rjad6
q3P2bDSiO5PPmj3NauT+T6dfk69hKy6eqmUfGbDbv6CdUZ1pVzL3HwXwV6M=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//MatrixForm=",
 CellID->122833937]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extracting Submatrices", "Subsection",
 CellTags->{"t:8", "c:14"},
 CellID->849568979],

Cell["The range syntax is useful to extract a submatrix.", "Text",
 CellID->87061150],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["0", "TR"]], ";;", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["1", "TR"]]}], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["0", "TR"]], ";;", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]]}]}], "]"}], "]"}], Cell[TextData[{
     "extract the submatrix with rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and columns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["0", "TR"]], ";;", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]]}], "]"}], "]"}], Cell[TextData[{
     "extract the submatrix with rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       ButtonBox["All",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/All"], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["0", "TR"]], ";;", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]]}]}], "]"}], "]"}], Cell[TextData[{
     "extract the submatrix with columns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->298293044],

Cell["Extracting submatrices. ", "Caption",
 CellTags->"S3.7.2",
 CellID->223768693],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->636557354],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9z2jAUwIUNISTkDkibpr0O+TTtlA/B5XqXDL320gxsjIyMXIceIyMj
IyMjIyMjIyOjK8mSLD8/WbIxNKTOHY6l9yS99/Tvh9B99+Xx2/fuy9ND9+7r
c/fn49PDr7svP55pll8hhEzo5/6W0PeAvvHPJAjo/w/s6bM0/yOf90y3ea0d
kOuBdI0YdKoqTf+Y8Nqq5dHEO0t7nqjNZhdMN7k3NZ47Ho9FbkPTok9SlS4p
mwiwXGlFlgOrlUaKNa0i9M90C8Jnnev1+32R7/PssPbVajWbzWTtdartg1bO
QLpxJD3WKyycJnkd0ee9uFwuoZej0Uj3vaZCIyLHfPdEW3qdFwVqXyB+m7XP
Qd9eWrWjUrvdrtfrRTHwZW4Yhth4jtel23ceuHpn6pV0u/cvJb3O3kbk32Aw
oIEJ5OzisfIWi0XNWKcvZhRruZmq5R7B7Npw7JlHk7Q3aoNOeDrt4z7zObLZ
bMzj49OBcsMdKr4OSZviaxbzQAxpXvhjwXmhJXQ4hFuBwZI/MloiXUnRitJv
UYuzQIFsceXUKptzPjK/JXMoGcoauFQyBlavzhYmeXJdsXlxhdWSYIz3mFaM
MW4s1sB0VkJC9RHGaDh5zdJ1bdbxNYqQxNrcOJIeYxGdMaAcrsmQpHAv7fsr
Qeq276/5S7nvFnqp7LuyLBXxTr5Y+UGSgszeSm03e/Npp7MGVqeKc84YQPqv
BWnMAbUhZeORK6YU6rWTPxHJ5IvRoZjk1smmYzCJmyWvlRD+FyZhq4KHjXH6
2tZlCSbpGKUs99pQr2SSdoq8ZJJsTGL7vtg4kh5kEtv38n2Y5DR3Dfuubdo7
92GSYkgsP1NlL+V+PgLbUP2xB7/BEWJmF9vJnpn69i8FexEfhZg/JbuU7PJW
2MVHxrhkFyVD2QWXSnbB6tXZxSTPzi6XoJT9NxulZfzNRmmkWNcqQr9kl1Qv
3faY09g13E4csL2zZBe3NlR/lOxSskvJLkfS+jfswuZJjST3GZbX0mUJdmkb
pWyudwz1SnZppciTM3Q4HKZ60QSl9DsKIoskyQRQF0mezNjICvZZLn0ju0T3
aXSvR6PRdruVpU+ZXcLdfL1eT6dTFS3h5Ww2E7dQSnaJbsrM53Pk3gEdDiKC
h4xVfvuzl5K/gGVvI+ofumbE7qVku8ck6cl8P+X13XbyCUl814t89+h8Oi6L
sFNsj45M3mp47lhV8Q8OTyA3WI+L88/wog57/Q3SodZEe5LKX0er0zU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->371610238]
}, Open  ]],

Cell[TextData[{
 "This extracts the submatrix from ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m", "MR",
     FontSlant->"Plain"], 
    RowBox[{"2", ",", "1"}]], TraditionalForm]]],
 " to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m", "MR",
     FontSlant->"Plain"], 
    RowBox[{"3", ",", "2"}]], TraditionalForm]]],
 "."
}], "Text",
 CellID->797632284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"2", ";;", "3"}], ",", 
     RowBox[{"1", ";;", "2"}]}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->1212872614],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVttuwjAMNU1Zue0BIS5DTOI/pmlvQ0LiIyo0CR6mIdb/L3YoAU7N5nER
L4vUNMc5dpw2Pu0szRYfn2m2nKfjyTpdLZbz7/H715pNrkJEU76eB8TjnEf+
muY53/vSO8G+0Qhw27Okj9gYw2yVYC4Oc9yE+Oj9q+DXBBztggVfHlNXY+1X
4EENGD6HUpbilzCMwJ4Arht5D4Cduqo72FPoSyyM1TjL65KMDndLyjPVM0Kv
5Ae8z8hp76sUG1myOzlhLRMbV0Yc/SGToWrFmtEjCnYhwa3zk2KzRXv7ZxXW
NmBUrJYpSrN4E2jfKVqYKyka1sfp+KfOV2Hi1tFYRwrXMK0m+JoKd0nN/FaP
up7csopvo3C2c3A/hbOpv65wPc1X/a5aFM4W7VVl4Z/Di/Z8afsvQ5UNQB6U
2Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{74, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->348929658]
}, Open  ]],

Cell["This extracts the submatrix of rows 1 to 3.", "Text",
 CellID->2029329626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "3"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->607742528],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1uGkEQXu44zmAiYRI7TpTCL5DXSKo8BLIi2UWUyHZBR0lJiVJElJSU
lJSUlJSUlJSUl9n/vbndYw13KNhB4rj5252Znd39mG+dp7vvPzpP97edm68P
nV9397ePN19+PgArrBBCxvD9fE3gPYE39h0nCfy+p8+Q0uxDPh1IX7BR6TMA
ZhVJI4JkVSWDD1VsO6WU+9YxbiCsXfMGiG4yLyPGHY1Ggntus4pMH+CdXNq0
tKfwcrVjdky3i9CvmR7wZ8z0er2e4IeMzXOzXC6n06m0jkEbzxIjun4kvRo8
aDpd8jNEq1VcLBY4yuFwaMYeqdSItcR1UkN0o0QrWz52W0UGTeXn3lZ0X/Dc
bbfbbrercxVKLk8Xt86MGaCZ8TrYo8ZWsZf/xVidiaifP4eus36/D4lJ5C5j
uQrm83lkHTO0VAb1oOmljT2wZ7QYK7x69uqzxROqtYcDBI6RdG7Ynluv1+46
+lgSl99k6XNN+pQ+A0MVGjf+UDCPewJlw68Whyd/ZLYEXcnR0vRL1GKYoUAM
8sZrVnoqhJYalxhFyawYxS6VGMU2rolRXPLsDvWJwrQy95xgCZ8yWinM8s6m
keNdqwh9C2ape0VN6VPGLBiZ2aO0n5+neWvsvr1dd2fjgFy9Nszit3v86uql
YpdDclQWdrn28ukY2MXPk38VSbwW7EL3SUSy9wzltUxZBrtcOKV0r7cd40rs
0sqRZ3foYDDIjaKJrMz/6IJFssgEoS6S7cjsQlZ4zfbSd2IX3U8yowacv9ls
pPUpYxd+m69Wq8lkorIlooS/XqIL8x+7BKoiZrOZ5X8ylIPIYJm52t//51vF
SR52yZtDrw+cGal+i18fL0h0f8uNWaRW3SuT+2k3vKrM9Ff3U/TJqGMPYD8d
F4vQ7nUAlclm5f3Gqsp/Uj4CubKtuOh78sYSff2NaK41Np6k8hd/NALh\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->168069475]
}, Open  ]],

Cell["This extracts the submatrix of columns 2 to 4.", "Text",
 CellID->1919112243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"2", ";;", "4"}]}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->1462573808],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWTtv2zAQliUrsvMAmqR5tOiQX9NO+QUdAiMoEA1FgzSDN48ePWr0T/Co
0aNHjx49evTo0eVb0vlIUa8iSGRAso734PF4vE8i7wevT79+D17Dx8Hdj5fB
81P4+Pfu+58X0uR1HMcJyXV/65DnPXliV7jfk/8bevcozX7Otxz6nGldgFaX
3rqKJj/KvMyVcgnxGZMCNCVPWc8+406nU8Htp6TJ3elm+wD2lYShv08F5blH
o9FI0B7T41qr1SqOY6kVECUPaB8Bul9RjnpDh38k47RcLqFXURSlffXVWMWI
XTEzfWD72Ch9jHiol+6BKAeM3u12w+Ew8deTrdxl7j9qM91zAGyfNKjVy4xn
PB4TZ1WWMP/dxWLha215IBbmOBeXhnPI84IkJUnNrJ8sLzabjT7OXwu08rqS
zX/ZT3atUOfEdDPlL5ZtNzI3eDHQ9PAgRybojkEqod+jFKvcBSr9mZVVWpU9
uS5QBMC5svIrLlLxe1YenCHaWQS4xiQMNIpuBjqw8pPSQSqH2SpVle+wspeV
oyu8ax29/IrqFKo5aS1Ye/SIcIgE0Eq5cbD6i9jEa3s5aYkAVfyE7xgQ7fF4
16MF88oum6sjxK1VP1UQwq6Hh1ZKtDaDEHT1uM7Bm/mez9eFlktbL9PcD4MQ
pjdT+tivKFcHQjRTe3CEgFp+iq6KEHnok/8VUF6rDuSA338wovg81KMF3wpa
5PioUs0hhycnBkUOnCuRQ3FLI8cJ0DbvLikJy90lG/n3hxzN1B4cOUy7aC1y
1DEPLXK0yPH2kINmoe/odqXOtVxX4IriapFjMpkYPTgF2gClyMMVJmFAAhip
PHm+ppKTkrSfURRtt1tp5X8iB5dfr9ez2Ux5LbyK41icVrx95OBW5vM5so9O
QitGZzcOaFu/31Rdi8YsOa8gWZw5r2jyfKjaaRIfbbK+En9dkjPVkYHuALhk
1pgl/oXZVXHYl8eDayyi4guWH7bQx5+A5lJh6u50/gESmObW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->252102903]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 StyleBox["n", "MR"],
 "egative indices to count from the end."
}], "Text",
 CellID->1504200411],

Cell["\<\
This returns the matrix with the first and last columns dropped.\
\>", "Text",
 CellID->918815193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"2", ";;", 
      RowBox[{"-", "2"}]}]}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2119526821],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWTtv2zAQliUrsvMAmqR5tOiQX9NO+QUdAiMoEA1FgzSDN48ePWr0T/Co
0aNHjx49evTo0eVb0vlIUa8iSGRAso734PF4vE8i7wevT79+D17Dx8Hdj5fB
81P4+Pfu+58X0uR1HMcJyXV/65DnPXliV7jfk/8bevcozX7Otxz6nGldgFaX
3rqKJj/KvMyVcgnxGZMCNCVPWc8+406nU8Htp6TJ3elm+wD2lYShv08F5blH
o9FI0B7T41qr1SqOY6kVECUPaB8Bul9RjnpDh38k47RcLqFXURSlffXVWMWI
XTEzfWD72Ch9jHiol+6BKAeM3u12w+Ew8deTrdxl7j9qM91zAGyfNKjVy4xn
PB4TZ1WWMP/dxWLha215IBbmOBeXhnPI84IkJUnNrJ8sLzabjT7OXwu08rqS
zX/ZT3atUOfEdDPlL5ZtNzI3eDHQ9PAgRybojkEqod+jFKvcBSr9mZVVWpU9
uS5QBMC5svIrLlLxe1YenCHaWQS4xiQMNIpuBjqw8pPSQSqH2SpVle+wspeV
oyu8ax29/IrqFKo5aS1Ye/SIcIgE0Eq5cbD6i9jEa3s5aYkAVfyE7xgQ7fF4
16MF88oum6sjxK1VP1UQwq6Hh1ZKtDaDEHT1uM7Bm/mez9eFlktbL9PcD4MQ
pjdT+tivKFcHQjRTe3CEgFp+iq6KEHnok/8VUF6rDuSA338wovg81KMF3wpa
5PioUs0hhycnBkUOnCuRQ3FLI8cJ0DbvLikJy90lG/n3hxzN1B4cOUy7aC1y
1DEPLXK0yPH2kINmoe/odqXOtVxX4IriapFjMpkYPTgF2gClyMMVJmFAAhip
PHm+ppKTkrSfURRtt1tp5X8iB5dfr9ez2Ux5LbyK41icVrx95OBW5vM5so9O
QitGZzcOaFu/31Rdi8YsOa8gWZw5r2jyfKjaaRIfbbK+En9dkjPVkYHuALhk
1pgl/oXZVXHYl8eDayyi4guWH7bQx5+A5lJh6u50/gESmObW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->52499707]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Deleting Rows and Columns", "Subsection",
 CellTags->{"t:179", "c:15"},
 CellID->2028205186],

Cell[TextData[{
 "If you want to delete rows or columns you can use ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1036632271],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["m", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["0", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], "}", "]"}], Cell[TextData[{
     "delete",
     " ",
     "rows",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["m", "TI"], ",", "{", "}", ",", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["0", "TR"]], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["1", "TR"]], "}", "]"}], Cell[TextData[{
     "delete",
     " ",
     "columns",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]]}], "}"}]}], "]"}], Cell[TextData[{
     "delete",
     " ",
     "rows",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " ",
     "and",
     " ",
     "columns",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->143750586],

Cell["Deleting rows and columns. ", "Caption",
 CellTags->"S3.7.2",
 CellID->96996027],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->272137716],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9z2jAUwIUNISTkDkibpr0O+TTtlA/B5XqXDL320gxsjIyMXIceIyMj
IyMjIyMjIyOjK8mSLD8/WbIxNKTOHY6l9yS99/Tvh9B99+Xx2/fuy9ND9+7r
c/fn49PDr7svP55pll8hhEzo5/6W0PeAvvHPJAjo/w/s6bM0/yOf90y3ea0d
kOuBdI0YdKoqTf+Y8Nqq5dHEO0t7nqjNZhdMN7k3NZ47Ho9FbkPTok9SlS4p
mwiwXGlFlgOrlUaKNa0i9M90C8Jnnev1+32R7/PssPbVajWbzWTtdartg1bO
QLpxJD3WKyycJnkd0ee9uFwuoZej0Uj3vaZCIyLHfPdEW3qdFwVqXyB+m7XP
Qd9eWrWjUrvdrtfrRTHwZW4Yhth4jtel23ceuHpn6pV0u/cvJb3O3kbk32Aw
oIEJ5OzisfIWi0XNWKcvZhRruZmq5R7B7Npw7JlHk7Q3aoNOeDrt4z7zObLZ
bMzj49OBcsMdKr4OSZviaxbzQAxpXvhjwXmhJXQ4hFuBwZI/MloiXUnRitJv
UYuzQIFsceXUKptzPjK/JXMoGcoauFQyBlavzhYmeXJdsXlxhdWSYIz3mFaM
MW4s1sB0VkJC9RHGaDh5zdJ1bdbxNYqQxNrcOJIeYxGdMaAcrsmQpHAv7fsr
Qeq276/5S7nvFnqp7LuyLBXxTr5Y+UGSgszeSm03e/Npp7MGVqeKc84YQPqv
BWnMAbUhZeORK6YU6rWTPxHJ5IvRoZjk1smmYzCJmyWvlRD+FyZhq4KHjXH6
2tZlCSbpGKUs99pQr2SSdoq8ZJJsTGL7vtg4kh5kEtv38n2Y5DR3Dfuubdo7
92GSYkgsP1NlL+V+PgLbUP2xB7/BEWJmF9vJnpn69i8FexEfhZg/JbuU7PJW
2MVHxrhkFyVD2QWXSnbB6tXZxSTPzi6XoJT9NxulZfzNRmmkWNcqQr9kl1Qv
3faY09g13E4csL2zZBe3NlR/lOxSskvJLkfS+jfswuZJjST3GZbX0mUJdmkb
pWyudwz1SnZppciTM3Q4HKZ60QSl9DsKIoskyQRQF0mezNjICvZZLn0ju0T3
aXSvR6PRdruVpU+ZXcLdfL1eT6dTFS3h5Ww2E7dQSnaJbsrM53Pk3gEdDiKC
h4xVfvuzl5K/gGVvI+ofumbE7qVku8ck6cl8P+X13XbyCUl814t89+h8Oi6L
sFNsj45M3mp47lhV8Q8OTyA3WI+L88/wog57/Q3SodZEe5LKX0er0zU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->302451773]
}, Open  ]],

Cell["This drops rows 2 through 4.", "Text",
 CellID->500306013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{"mat", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1244682486],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMlOwzAQdeOkISWHtOwIpH4NnPiIqKrUHhCo9GMQ4t7PDJ7ESc10vGUT
ByIlzYyf7Tfj7aUv+X6zfs3321W+fN7l75vt6mP59LYTLj5hjB3E/XjLxHsh
3sr7UBTi9waeHOzyYg8d7XnZ6gJ5A2RHTIMJG1tcUHhhRQXCuLT0F8jWbLyw
nZbRRMibKLZ4srAOqeHEEPMGdWSOWDcIA5usD/xUZVA9p6heiSNbj4XJkR/X
TkbCwahAOnXlMYFXbU5GyZWxPGYOYg9kXyp61iN6RsStR5+hsT23onGtNjlQ
UbgtfXS6UTHz7l6rjtq/D8qucoVnWahtG0CxZJAaUe6Z9EfjOaifVTVfqo/A
I/b7gbz4pKI5cRmBHK6y8l3PPjcm3/8o6Z0ju6vGSJ16hXUREescfJladqI5
5tpSWMsLTbv1GsoM5ab9hY4Cx6ruzdLFTvUP/81cvFxRCAM7PGat8ITWcNtZ
wI6JHOKcJSPhQJOoWsN2FmIN47N/2nQMvd/3UwvHQZ8WJsUG5fR5S9WiVNL4
uWrP379WrQj8+6DGxydXWAvqNcnfU7p6TeKmXYfSJNdU7+SX09CaxI3JF4nC
X0af1Hxi1f8FbPID1agjdA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->19958674]
}, Open  ]],

Cell["This drops columns 2 through 4.", "Text",
 CellID->319926707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{"mat", ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1856596108],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtPwzAQduuGEigS7wJi4IcwMIFUqT+iQkgwIBAwdOvYsWPG/oSOGTt2
7NixY8eOHYOfiXM9xykEBFUj5eHz57vz+fzJuWbr4/HhufXxdN+6untrvT4+
3b9f3b68MREtEUIa7G6eEfYdsS9xN6KIvev8SXlbXOQStA8E6hBIy6DtETcG
tmtCsyek/X5fSX0DxZ6kotVH+uLSIwy1lejWHVWB63Q6Sk6FWKDpZDIJw1B7
VmVoCjzcAm3fgqvCaOg5jcdjaDUIAtMXL3ZVzYT7UmZvH+jcyURvG29CF4tF
u91OLFMtlcZTMU3rMi1u5/YgKxZSS7fbZebjLBAelUejkWfVSdXq8VnVnCga
z50tKVvYtCUR9dlsZp/7BSqtI3miNaZzittXwRaDzxFZXa+CTHaLthuQJaUM
VNJeR5Rgngxm2sulpaZWwsZYWB++E1yW9jAtS8x1gqEQ5vJz2eTtqpFnYl/E
vLfMXBAH9zjkS9yqmz8IotvNH8TY8zvf8IRGJhu6PNBoLGZf9aACdHlRFpNh
aJo7B1ZhtLNcGvMyWj5tf5Vf/iuj7UYyl5ayhn0eWPr+H6O5zhW+BVcko8Eo
wvMgzie2vf8dRiuOW4tiOOysbGc4DL1huPVDFcdwFMkazXBY39cYbheMcv9t
xqi1YDjXn6z9xITt/Q3DbRhu3VHFMBzPZg/Z21y2b+nDeaDX62VaqoFRZtVJ
idh1jKGsDJdU60ybQRDM53M9ukiGk+eu6XQ6GAziSCirYRiqKttvMJyc/3A4
RGpMbPLKv5/2BM2CVH1ttVqjrh7a62waldTZkgxLLJbZSqzCZKd8DIuZGCOr
ppXY5ygff51iM1UVWFny45/XoC1RDeNJSp95lbxb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{74, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->695550960]
}, Open  ]],

Cell["\<\
In this example rows 2 and 3, and columns 1, 2, and 3 are all dropped.\
\>", "Text",
 CellID->1119979277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{"mat", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->797542584],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVr1OAkEQXu6AA4RELQCNBS/gG1hYaULiQxBiAoXRIAUdJSUlJY9ASUlJ
SUlJSUlJec7+3d4Ns3eLNirJ/czuzPfN7C7fzUtn2Ht96wz73U7redD56PW7
n62n9wEM+TnGWBuu+yaD9xDexNUOQ3g2+N3ntvixO2RfCa9rNOoRNjdd/OJ2
VaAXxOh8Plej5ZgX3Fk+A+WS8i+aeT0RCL/xeKzGfTEs0bfb7XK51OgBePuI
hWeZB7NsmQ8If1HVZrPBbLPZLJ5DIUpRVcBz8OBZQpVdZHqbqOPxOBqNDLOv
RyW5zITEilehMe3MaWsgM5lMJkAb7ZzIxFuv1wUrpq/WOY5VTvUO1FMywlbC
hiYZxarv93t77bfkaIM4HxoxeZY4v1psEXxDjDX0LsjjbkF7RKckl+Jl7P/o
JfQnRZ9qTihVtRNpumWbPz3PWWy1DBRsk6pJ6FfZiZ3bQezUiX8JXMUwqV94
voSywGpJs2WrCIuU10XHcBTPrPKDTPwwqY00s/bC+uW24jQz/mqR2JlRXCON
Gn4vE1rXmk6IrrrmhvZbVeav6hr/ZxRSdO0yZf5U16bTaSpbFUXhDgij4hqF
v1XXTP8XZ4dv4OFw0NEBUQvWNbq2pD/zd7vdYrGIslZs8IlX3ZpdTU6xsnSN
ivKiulerFdGrQNEqP7dMtFa6Z0Duf6JPO69XrSBMe7+m9dj0a+aMGWYPduIc
PavzGFgzESO773yUe+imYnWqYtXJy9aRvz4gW3q1Y3eW+wIcHk56\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{74, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->335422950]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inserting Rows and Columns", "Subsection",
 CellTags->{"t:223", "c:16"},
 CellID->964961827],

Cell[TextData[{
 "If you want to insert a row, you can use ",
 Cell[BoxData[
  ButtonBox["Insert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Insert"]], "InlineFormula"],
 "."
}], "Text",
 CellID->316924245],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Insert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Insert"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["r", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "insert row ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " into matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->786341155],

Cell["Inserting a row. ", "Caption",
 CellTags->"S3.7.2",
 CellID->421428447],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     SubscriptBox["m", 
      RowBox[{"i", ",", "j"}]], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->546840923],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9z2jAUwIUNISTkDkibpr0O+TTtlA/B5XqXDL320gxsjIyMXIceIyMj
IyMjIyMjIyOjK8mSLD8/WbIxNKTOHY6l9yS99/Tvh9B99+Xx2/fuy9ND9+7r
c/fn49PDr7svP55pll8hhEzo5/6W0PeAvvHPJAjo/w/s6bM0/yOf90y3ea0d
kOuBdI0YdKoqTf+Y8Nqq5dHEO0t7nqjNZhdMN7k3NZ47Ho9FbkPTok9SlS4p
mwiwXGlFlgOrlUaKNa0i9M90C8Jnnev1+32R7/PssPbVajWbzWTtdartg1bO
QLpxJD3WKyycJnkd0ee9uFwuoZej0Uj3vaZCIyLHfPdEW3qdFwVqXyB+m7XP
Qd9eWrWjUrvdrtfrRTHwZW4Yhth4jtel23ceuHpn6pV0u/cvJb3O3kbk32Aw
oIEJ5OzisfIWi0XNWKcvZhRruZmq5R7B7Npw7JlHk7Q3aoNOeDrt4z7zObLZ
bMzj49OBcsMdKr4OSZviaxbzQAxpXvhjwXmhJXQ4hFuBwZI/MloiXUnRitJv
UYuzQIFsceXUKptzPjK/JXMoGcoauFQyBlavzhYmeXJdsXlxhdWSYIz3mFaM
MW4s1sB0VkJC9RHGaDh5zdJ1bdbxNYqQxNrcOJIeYxGdMaAcrsmQpHAv7fsr
Qeq276/5S7nvFnqp7LuyLBXxTr5Y+UGSgszeSm03e/Npp7MGVqeKc84YQPqv
BWnMAbUhZeORK6YU6rWTPxHJ5IvRoZjk1smmYzCJmyWvlRD+FyZhq4KHjXH6
2tZlCSbpGKUs99pQr2SSdoq8ZJJsTGL7vtg4kh5kEtv38n2Y5DR3Dfuubdo7
92GSYkgsP1NlL+V+PgLbUP2xB7/BEWJmF9vJnpn69i8FexEfhZg/JbuU7PJW
2MVHxrhkFyVD2QWXSnbB6tXZxSTPzi6XoJT9NxulZfzNRmmkWNcqQr9kl1Qv
3faY09g13E4csL2zZBe3NlR/lOxSskvJLkfS+jfswuZJjST3GZbX0mUJdmkb
pWyudwz1SnZppciTM3Q4HKZ60QSl9DsKIoskyQRQF0mezNjICvZZLn0ju0T3
aXSvR6PRdruVpU+ZXcLdfL1eT6dTFS3h5Ww2E7dQSnaJbsrM53Pk3gEdDiKC
h4xVfvuzl5K/gGVvI+ofumbE7qVku8ck6cl8P+X13XbyCUl814t89+h8Oi6L
sFNsj45M3mp47lhV8Q8OTyA3WI+L88/wog57/Q3SodZEe5LKX0er0zU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->355375948]
}, Open  ]],

Cell["This inserts a row before row 3.", "Text",
 CellID->1025611312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Insert", "[", 
   RowBox[{"mat", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", "3"}],
    "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1745569962],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtzGjEQFicwxo8ZwIljnGTGvyap8hNSMJ7M2EUmGceFO5eUlEyKjEuX
LikpKV26pKSkpLxIutODvZVO9+Dh8TEDnLSfpN3V69uTvvVvr3787N9eX/Yv
vt70f19dX/65+PLrhmXRGiHkkX2/nxH2HLIn8X0MQ/Yf/X7gv5Tnig/5VDDd
EbU2RO7Dw0OcewBQAUg32GMXw9RVmn248CQVFbDEu5T2grg2tE1Hek+k7+/v
4zQV1tbF48vLy3g8htay30jeMHUkwBKF0pYAKxTCoV27DPyeqUH025S9+fz8
DK0ejUZG7U2GpqjPdLq1IRwfg9ydNnkTwRO6XC7v7u60lVTmRoau9KX2HLc9
iNsy6zwoEQ3nUMuJ3gd9e5iK1hoNBgNmsBoxwgfBdDptWOsw9doPfa2y9YZb
3+KlpLXZ29D2sanOJvyqj8RsmM/n7nFC4xnFNThyovw9mR0Nx559NEl9dRt6
pTNt16sibvv5mnKjHYwN2Gi7sehEYwviaS0K90rOO5NjIG6zhmryD6TfLkpw
hRK5x7FXq3zOUWSeSw6iZCj3wKWSc2D1mlzDJk+uL2lWHGO1JDjGewy1wjFO
U7SB6ayMCcUjHKPlZTVPN41ZJ9YoQhJrdGtDOM5FTI4B5XBNbnpZad87zL0u
+z6bv5T/bmGWyr47y1Ka7+TzFQ2TLMhurUT76ZsP7eYcWJ3Kzzl9ANl/I3Rx
DoiGLBv3XDmlUKu97NFMJp+P1sVJzrx02hwn2b29f1dR2+EkfFUIsDHOHjum
LMFJulYpzz2x1Cs5ScchrzhJNk6SFje2NoSDnCQtPi/CSV7nrpG+a9v2ziKc
pBwmlp9TZS/l/54EtqH6owB/gyPEzl3S3uzZWV/xUrAX8VGI2VNxl4q77C5K
RiTyDXGvYNqvL5NnIB9Lyul5tS/X+c8p/+dbqG3bvtnOiNjV+fGWIhOK7GAy
MlEyNDLBpTIyweo1IxObPHtkcghKpZ/IKpT1RFYhHNq1y8BXkYnTSj8G+To4
od/7RIwZV5GJXxuqP6rIpIpMqshkQ6jtcBc+Txokuc/wvLYpS3CXjlXK53rX
Uq/kLm2HPDlDh8Oh04ojUIpKE5ROfHBCZgJYF0m+d01jVrDPcuGt3EXfDTSt
Ho1Gi8VCln7N3CXazWez2dPTk/JWbOV4PI5v0lXcRd86m0wmyI0qNhxiD67T
V/n1z15Knm9nb0P3D1szVm7owbuYFK0b3vaz3z7bvbuMlJBErKdtD9h82iwX
4WdUARuZotXoVKGu/B+un4GcYj0en25EVxD541+QjlDm/W9S+w+cZg9+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->58806543]
}, Open  ]],

Cell["\<\
If you want to insert a column, you must transpose the matrix, insert the \
column as a row, and then transpose the matrix back. This inserts a column \
before column 5.\
\>", "Text",
 CellID->1826715621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Insert", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", "mat", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     "5"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1183224635],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr9PGzEUx80dRwgEiUBLaVWJdO7/0U78ERGqBEPVijKwMTIy3pi1Q6Vs
ZMyYMWPGjBkzMh62z/b53j3/uEtIovSQSGL7a/u951+fXHzZvbv+8bN7d3PV
7Xy/7f6+vrn60/n265ZmhTuEkGf6f3lO6OeEfuL/z0lC3z+w15Cl+R/5XDL9
FaTbvNUTkBuAdEQMml2Vpn+s8NSpCmjinaO/QLT2xUOnp1vcm4jn9no9kdvU
VPSV7EqXlE0EWK5UmeXAaqWwWHNcUn+B6fd0C9LXBtc9PDyI/JBnp61PJpPB
YCBbb1B1CHrZA+nminRsVFg4WTmbA4F4N+kbSH0+quPxGHodx7Eei0iFSkRS
70tv82CJ6gMkDmb1PhjrwwTOtkNn/aydl5eX+/v7LCqhzE0Dk5vx+bZ0i/cT
X39N40Ssdi9eS3rd0t7L9ZX5+fj4SAOUyHXIYxaMRqPI2GYo1p695xCMrj2S
5dXYrHRb1Mj1RbcIulHkfeeraDabmefLp+Xkeszy9JTL72XSyvy+x3wSk55X
/rhgHtyZoCa1jE6c9HgxWPZPxlOkdyyqLL2NKs4XS+SVI69e2VoIkZ1Acowq
Q/kFL5XcgrWr84qpvLgDubw4wlopcMt7TJVbY2cOa2DaRYMwjVIawi1NL69Z
uqGtOr6LEVLYxZsr0jG+sXEL1MPdHNIa7rX7hCZI2+4TunoteM6YeUavhZ7r
nlwD28moqlr0wqTIWmb/pdqPTKqp/fgFa1uNQMVYwO8ekdUCqIaMj0dwObWg
13a+wfzKKKlarFbHOedeVq6Dc/ws21Tq+F84h82qAFsF9GNbLytwzomxlOWe
GtqVnNOxlNecU45zXN9WmyvSuTjH9bRgEc7ZpPMG5xzsnKnCOaZzeBHOWQ7v
lX8iU71W+ec4sC81UguwIZw7diJzMcpb1cJG099S5lfNQ+68moe2hYdCZBVI
HlJlKA/hpZKHsHZ1HjKVl+ehQ1DL/XuVUhl/r1IKi3XHJfUXmL7moVw/yzmd
1nne4Dxk+xWQEH8eMp3DNQ/VPOQ3P2seqnlo81Xr4SG2NiJSPKtY3rFeVuCh
trGUzYgTQ7uShy4s5cW1/PT0ZPWiBWrpdzxEFinSDiA5UnyC5KI1OGYufQfT
G3kou5+kex3H8Xw+l7W3iYdSQphOp/1+X0VPeD0YDMStnpqHiu1kd5GGwyFy
b4NOGBHTt4we6tEb1dJv2ZQ729HdJXfPp9yNsX2rBeu4V+a+7yPtDgkpfOPM
YhDQFbduvmFP7AM6d7kd6TPVXTUyyeqp5gybG+JZb3o1in38C9Kp6ll7JTuv
TSKLIg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->74052917]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extending Matrices", "Subsection",
 CellTags->{"t:10", "c:17"},
 CellID->782554218],

Cell[TextData[{
 "You can increase the size of a matrix by padding it with ",
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1198887698],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->2013964132],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " adds the elements to the beginning of the matrix."
}], "Text",
 CellID->57922510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadLeft", "[", 
   RowBox[{"mat", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->693533479],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0"},
     {"0", "0", "0", "0"},
     {"0", "0", "1", "2"},
     {"0", "0", "3", "4"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$182]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->208724395]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 " adds the elements to the end of the matrix."
}], "Text",
 CellID->1784333498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadRight", "[", 
   RowBox[{"mat", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1831454178],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "0", "0"},
     {"3", "4", "0", "0"},
     {"0", "0", "0", "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$186]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->6618384]
}, Open  ]],

Cell["\<\
One important use of the padding functions is to replicate and tile a matrix. \
In this example the input matrix is extended to have two versions in every \
row and three in every column.\
\>", "Text",
 CellID->1416653465],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"PadRight", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "9"}], "}"}], ",", "mat"}], "]"}]}], "InputOnly",
 CellLabel->"In[4]:=",
 CellID->543591966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "1", ",", "2", ",", "3", ",", "1", ",", "2",
      ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "5", ",", "6", ",", "4", ",", "5", ",", "6", ",", "4", ",", "5",
      ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "1", ",", "2", ",", "3", ",", "1", ",", "2",
      ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "5", ",", "6", ",", "4", ",", "5", ",", "6", ",", "4", ",", "5",
      ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{363, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->228084530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1846911586],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "1", "2", "3", "1", "2", "3"},
     {"4", "5", "6", "4", "5", "6", "4", "5", "6"},
     {"1", "2", "3", "1", "2", "3", "1", "2", "3"},
     {"4", "5", "6", "4", "5", "6", "4", "5", "6"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$191]]]], "Output",
 ImageSize->{151, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->338113737]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 " have a number of extra features and are completely general so that they \
work for arbitrary rank tensors. These are described in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " documentation."
}], "Text",
 CellID->1972307306]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose", "Subsection",
 CellTags->{"t:11", "c:18"},
 CellID->11316850],

Cell["Transposition of elements is a general matrix operation.", "Text",
 CellID->1223737014],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->897106979],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVc0OgjAMLr+iol49eODswTsvoCcfghATPBgN8v64jkWXjxKG8SgJ69q1
X9eu685FU11uRXMti+xUF4/qWj6z471WosAjolz9uy2peatm+s/bVtFujHgM
WKo/2gMfaq0QpLEamF0Ymho6A71AtEathIfozWubDrsvjZ08sDRW7MrJk4wZ
SJno2a6dPGDEvuhBn0X44YmWJq9MeSFxwrHjIWNtryM//wlqKmViFJUz41sR
DlWSbH34axkpV2dkbk1kVc70iuGpfPdkqdtJoQesng3w2JfcULEG8XZ+h4pd
hPfuD+YWexH6xD3hnqVeNo465cTcemhoouTox3u82zvSvTnkvQBXVYua\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->796605768]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " swaps elements at specific indices."
}], "Text",
 CellID->1600858622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", "mat", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1955730338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->524496292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1857588188],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "4"},
     {"2", "5"},
     {"3", "6"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$201]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->81668711]
}, Open  ]],

Cell[TextData[{
 "If you wish to compute the conjugate transpose of a matrix, use the \
function ",
 Cell[BoxData[
  ButtonBox["ConjugateTranspose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConjugateTranspose"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1139008285],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", 
       RowBox[{"-", "I"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"I", ",", "10."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"matCT", "=", 
  RowBox[{"ConjugateTranspose", "[", "mat", "]"}]}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->643016637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ImaginaryI]", ",", "10.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->443061245]
}, Open  ]],

Cell["\<\
If a matrix is equal to its conjugate transpose, it is said to be hermitian.\
\>", "Text",
 CellID->365581671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "===", "matCT"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->380430430],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->206793666]
}, Open  ]],

Cell[TextData[{
 "You can also test with the function ",
 Cell[BoxData[
  ButtonBox["HermitianMatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermitianMatrixQ"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->69451272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermitianMatrixQ", "[", "mat", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->986225542],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->404156265]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotating Elements", "Subsection",
 CellTags->{"t:12", "c:19"},
 CellID->654023951],

Cell[TextData[{
 "Another structural operation is to rotate elements within an index. This \
can be done with the functions ",
 Cell[BoxData[
  ButtonBox["RotateLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateLeft"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RotateRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateRight"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1359239111],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"m", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1948185438],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3"},
     {"4", "5", "6"},
     {"7", "8", "9"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$209]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->619669574]
}, Open  ]],

Cell["\<\
This rotates left by one step in the first level, which operates on the rows.\
\
\>", "Text",
 CellID->874553121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotateLeft", "[", 
   RowBox[{"m", ",", "1"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1236224579],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4", "5", "6"},
     {"7", "8", "9"},
     {"1", "2", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$213]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->81396536]
}, Open  ]],

Cell["\<\
This rotates left by one step in the second level, which operates on the \
columns.\
\>", "Text",
 CellID->1653298009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotateLeft", "[", 
   RowBox[{"m", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->688728730],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "3", "1"},
     {"5", "6", "4"},
     {"8", "9", "7"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$217]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->68777727]
}, Open  ]],

Cell["This rotates the columns in the opposite direction.", "Text",
 CellID->1663981879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotateRight", "[", 
   RowBox[{"m", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2011389119],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3", "1", "2"},
     {"6", "4", "5"},
     {"9", "7", "8"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$221]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->645637999]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing Matrices", "Subsection",
 CellTags->{"t:13", "c:20"},
 CellID->1736222906],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a number of functions for testing matrices and extracting size \
information."
}], "Text",
 CellID->690585706],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " has the form of a matrix, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "a list of the dimensions of a vector or matrix ", "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["i", "TI"]], 
     StyleBox["==", "MR"], 
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["j", "TI"]]}], Cell[
    "compare elements of two matrices for equality ", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1672332354],

Cell["\<\
Functions for testing the structure of vectors, matrices, and arrays. \
\>", "Caption",
 CellTags->"S3.7.3",
 CellID->623901742],

Cell[TextData[{
 "If you want to test that an expression is a matrix, you can use the \
predicate ",
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1901413140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->346492973],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125327772]
}, Open  ]],

Cell["The integer 5 is not a matrix.", "Text",
 CellID->591781684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", " ", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1077993731],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113289671]
}, Open  ]],

Cell["A matrix has to have the same lengths in every dimension.", "Text",
 CellID->17049602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->937335763],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->154453423]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 " takes an optional second argument that specifies a test to apply to every \
element. In this example every element is tested to see if it is an integer."
}], "Text",
 CellID->26858756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ",", "IntegerQ"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->443546222],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->182690115]
}, Open  ]],

Cell["\<\
In the example below every element must be an integer greater than 1.\
\>", "Text",
 CellID->2106977342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"IntegerQ", "[", "#", "]"}], " ", "&&", " ", 
     RowBox[{"#", ">", "1"}]}], " ", "&"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2110331611],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->238623850]
}, Open  ]],

Cell[TextData[{
 "The command ",
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " is useful for extracting size information."
}], "Text",
 CellID->772116395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1864055591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->642780532]
}, Open  ]],

Cell[TextData[{
 "To compare if the elements of two matrices are equal, it is possible to use \
",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ", typically entered using a ",
 Cell[BoxData["=="], "InlineFormula"],
 " short-cut notation. For example, comparing a matrix with itself returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Text",
 CellID->893444556],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat1", "\[Equal]", "mat1"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->916992868],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->162254039]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " uses the value of numbers so it can be used to compare integer and real \
values."
}], "Text",
 CellID->1288014321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat1", "\[Equal]", 
  RowBox[{"N", "[", "mat1", "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1021531287],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->95306621]
}, Open  ]],

Cell[TextData[{
 "It should be noted that ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " works on any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. If you want to compare two matrices for equality using \
properties of the matrix as a whole, it may be better to compare matrix \
norms. These are discussed in a ",
 ButtonBox["later",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1973408751"],
 " section."
}], "Text",
 CellID->23669461]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further Structural Operations", "Subsection",
 CellTags->{"t:23", "c:21"},
 CellID->528156332],

Cell["\<\
This section discusses some further structural operations that are useful for \
working with matrices.\
\>", "Text",
 CellID->1173558873],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "flatten out nested lists in ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "flatten out nested lists in ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " to level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "partition ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " into sublists of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Join",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Join"], "[", 
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell[TextData[{
     "concatenate ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Append",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Append"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "insert row ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " at the end of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Prepend",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prepend"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "insert row ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " at the beginning of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1514164463],

Cell["This generates a sample matrix for demonstration.", "Text",
 CellID->880912691],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->747335219],

Cell["This flattens the matrix into a vector.", "Text",
 CellID->1978658077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{"Flatten", "[", "mat", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1522026344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23165134]
}, Open  ]],

Cell[TextData[{
 "Here the vector is partitioned back into a matrix with rows of length 4 \
using ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1686611890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"vec", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->101894830],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->268481359]
}, Open  ]],

Cell[TextData[{
 "Matrices can be joined together with the function ",
 StyleBox["Join", "MR"],
 ". This inserts the new matrix as new rows. "
}], "Text",
 CellID->1205648730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", " ", 
  RowBox[{"mat", ",", "mat"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1829995665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->4099315]
}, Open  ]],

Cell["Alternatively, you can join the new matrix as new columns.", "Text",
 CellID->20075361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Join", "[", " ", 
  RowBox[{"mat", ",", "mat", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->251834163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1", ",", "2", ",", "3"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6", ",", "4", ",", "5", ",", "6"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9", ",", "7", ",", "8", ",", "9"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{377, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->36973084]
}, Open  ]],

Cell[TextData[{
 "A new row can be inserted at the end of a matrix with ",
 Cell[BoxData[
  ButtonBox["Append",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Append"]], "InlineFormula"],
 "."
}], "Text",
 CellID->184002031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Append", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->145683337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->569029869]
}, Open  ]],

Cell[TextData[{
 "It should be noted that this can also be done with ",
 Cell[BoxData[
  ButtonBox["Insert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Insert"]], "InlineFormula"],
 "; see the section \"",
 ButtonBox["Inserting Rows and Columns",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#964961827"],
 "\"."
}], "Text",
 CellID->1972024552]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Element-wise Operations", "Section",
 CellTags->{"t:15", "c:22"},
 CellID->1701521313],

Cell[TextData[{
 "If you want to operate on the elements of a matrix, you can do this easily \
with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". First, build a matrix of floating point numbers."
}], "Text",
 CellID->1576464139],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2127031134],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.23927928270726198`", "0.4767125904097935`", "0.0801061646352921`"},
     {"0.44714964937279406`", "0.2759219235750695`", "0.821974195204704`"},
     {"0.853004264488417`", "0.637285204085753`", "0.08269118507816274`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$242]]]], "Output",
 ImageSize->{215, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->66347788]
}, Open  ]],

Cell["\<\
Arithmetic operations applied to a matrix thread down to work on each \
element. Thus, if 5 is added to the matrix, the result is equivalent to \
adding 5 to each element.\
\>", "Text",
 CellID->1456016776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "+", "5"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->697796667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "5.239279282707262`", ",", "5.476712590409793`", ",", 
     "5.080106164635292`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5.447149649372794`", ",", "5.275921923575069`", ",", 
     "5.821974195204704`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5.853004264488417`", ",", "5.637285204085753`", ",", 
     "5.082691185078163`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{577, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->464564948]
}, Open  ]],

Cell["Here, every element of the matrix is doubled.", "Text",
 CellID->323955473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "mat"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->848589566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.47855856541452396`", ",", "0.953425180819587`", ",", 
     "0.1602123292705842`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8942992987455881`", ",", "0.551843847150139`", ",", 
     "1.643948390409408`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.706008528976834`", ",", "1.274570408171506`", ",", 
     "0.16538237015632548`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{417, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->635746483]
}, Open  ]],

Cell["Here, every element of the matrix is squared.", "Text",
 CellID->1187578616],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["mat", "2"]], "Input",
 CellLabel->"In[5]:=",
 CellID->920783894],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.0572545751329018`", ",", "0.22725489385521558`", ",", 
     "0.006416997612576523`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.19994280893421265`", ",", "0.0761329079093665`", ",", 
     "0.6756415775824209`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7276162752354254`", ",", "0.4061324313466198`", ",", 
     "0.006837832089630964`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{459, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->558994860]
}, Open  ]],

Cell["\<\
If one matrix is divided by another, the division is done element by element. \
If the dimensions of the two matrices do not agree, there is an error.\
\>", "Text",
 CellID->1663465834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "^", "2"}], "/", "mat"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1928155392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.23927928270726198`", ",", "0.4767125904097935`", ",", 
     "0.08010616463529209`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.447149649372794`", ",", "0.2759219235750695`", ",", 
     "0.821974195204704`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8530042644884172`", ",", "0.637285204085753`", ",", 
     "0.08269118507816274`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->631479844]
}, Open  ]],

Cell[TextData[{
 "To apply the ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " function to every element, you apply ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " to the entire matrix."
}], "Text",
 CellID->987841743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "mat", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->460099644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.23700250467683043`", ",", "0.458860769942151`", ",", 
     "0.08002051860822561`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.4323971806863867`", ",", "0.27243410390964573`", ",", 
     "0.732491241887509`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.7532597757082384`", ",", "0.5950157170520797`", ",", 
     "0.08259697921898096`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->166234779]
}, Open  ]],

Cell["\<\
If both of the arguments of an operation are matrices, the operation is \
carried out on corresponding elements.\
\>", "Text",
 CellID->1067767973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", " ", "+", "mat"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1602967879],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.47855856541452396`", ",", "0.953425180819587`", ",", 
     "0.1602123292705842`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8942992987455881`", ",", "0.551843847150139`", ",", 
     "1.643948390409408`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.706008528976834`", ",", "1.274570408171506`", ",", 
     "0.16538237015632548`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{417, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->368811604]
}, Open  ]],

Cell["\<\
Note that the dimensions of the two matrices have to be compatible.\
\>", "Text",
 CellID->575960568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "+", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1460469347],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in \
\\!\\(\\(\\({\\(\\({0.23927928270726198`, 0.4767125904097935`, \
0.0801061646352921`}\\)\\), \\(\\({\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)}\\)\\), \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)}\\)\\) + \\(\\({\\(\\({1, 2}\\)\\), \\(\\({2, \
3}\\)\\)}\\)\\)\\) cannot be combined. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Thread/tdlen\\\", \
ButtonNote -> \\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->126324152],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "0.23927928270726198`", ",", "0.4767125904097935`", ",", 
      "0.0801061646352921`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0.44714964937279406`", ",", "0.2759219235750695`", ",", 
      "0.821974195204704`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0.853004264488417`", ",", "0.637285204085753`", ",", 
      "0.08269118507816274`"}], "}"}]}], "}"}]}]], "Output",
 ImageSize->{445, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->405259668]
}, Open  ]],

Cell["\<\
If one of the arguments is a matrix and the other is a vector, the operation \
is carried out between rows of the matrix and elements of the vector.\
\>", "Text",
 CellID->1064947414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "+", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1442473000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.23927928270726198`", "\[InvisibleSpace]", "+", "x"}], ",", 
     RowBox[{"0.4767125904097935`", "\[InvisibleSpace]", "+", "x"}], ",", 
     RowBox[{"0.0801061646352921`", "\[InvisibleSpace]", "+", "x"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.44714964937279406`", "\[InvisibleSpace]", "+", "y"}], ",", 
     RowBox[{"0.2759219235750695`", "\[InvisibleSpace]", "+", "y"}], ",", 
     RowBox[{"0.821974195204704`", "\[InvisibleSpace]", "+", "y"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.853004264488417`", "\[InvisibleSpace]", "+", "z"}], ",", 
     RowBox[{"0.637285204085753`", "\[InvisibleSpace]", "+", "z"}], ",", 
     RowBox[{"0.08269118507816274`", "\[InvisibleSpace]", "+", "z"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{556, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->285263193]
}, Open  ]],

Cell[TextData[{
 "Note that the multiplication of two matrices using the operator ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " (typically this is entered by placing two arguments together) produces a \
matrix with elements that are products of the corresponding elements of the \
matrices. If you want to carry out matrix multiplication, this can be done \
with the function ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " and is described in the section \"",
 ButtonBox["Matrix Multiplication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1896011669"],
 "\".",
 " ",
 "An example of element-wise multiplication is shown in the following \
example."
}], "Text",
 CellID->1881705571],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mat2", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat1", "  ", "mat2"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->1981346075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "12"}], "}"}]}], "}"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->201168909]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listability", "Subsection",
 CellTags->{"t:16", "c:23"},
 CellID->540401315],

Cell[TextData[{
 "If you want to apply your own function to each element in a matrix, you may \
do this by giving your function the attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". This function squares each element and divides the result by 3."
}], "Text",
 CellID->816558042],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"fun", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fun", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "/", "3"}]}]}], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->1470507564],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "5."}], "}"}]}], "}"}]}], ";"}]], "InputOnly",
 CellLabel->"In[3]:=",
 CellID->1578818472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fun", "[", " ", "mat", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->894116572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.3333333333333333`", ",", "5.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.333333333333333`", ",", "8.333333333333332`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->27459790]
}, Open  ]],

Cell["\<\
Of course, the function will still work with symbolic matrices.\
\>", "Text",
 CellID->478953376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fun", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1000681476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "2"], "3"], ",", 
     FractionBox["16", "3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{137, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->347561867]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Map", "Subsection",
 CellTags->{"t:17", "c:24"},
 CellID->188079645],

Cell[TextData[{
 "Instead of using listability you can use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to apply a function to every element in a matrix."
}], "Text",
 CellID->2106148778],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "5."}], "}"}]}], "}"}]}], ";"}]], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->1069558345],

Cell[TextData[{
 "This says that the function ",
 StyleBox["f", "MR"],
 " should be applied to every element in the matrix."
}], "Text",
 CellID->1628979025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "mat", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2128941219],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "1.`", "]"}], ",", 
     RowBox[{"f", "[", "4.`", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "4.`", "]"}], ",", 
     RowBox[{"f", "[", "5.`", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->498957984]
}, Open  ]],

Cell["\<\
Here, a function that squares its argument and divides the result by 3 is \
applied to every element in the matrix.\
\>", "Text",
 CellID->73177838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "/", "3"}], " ", "&"}], ",", "mat", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1539277182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.3333333333333333`", ",", "5.333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.333333333333333`", ",", "8.333333333333332`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->450716]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors and Tensors", "Section",
 CellTags->{"t:18", "c:25"},
 CellID->112899229],

Cell[TextData[{
 "In addition to supporting matrices, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports vectors and tensors. All of these are built from lists. As \
described in the ",
 ButtonBox["Introduction",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#374996618"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the term tensor to refer to generalized matrices. All the operations \
for building matrices can be generalized to work for vectors and tensors. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " vectors have one level of list. Here a vector is constructed."
}], "Text",
 CellID->1269281502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1859138463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->632853063]
}, Open  ]],

Cell["\<\
In addition, there are a number of functions that generate vectors.\
\>", "Text",
 CellID->590355520],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build a length\[Hyphen]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vector by evaluating ",
     StyleBox["f", "TI"],
     " with ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["i", "TI"], "=", "1"}], ",", "2", ",", 
       StyleBox["\[Ellipsis]", "TR"], " ", ",", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "build a length\[Hyphen]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " vector of the form ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         StyleBox["a", "TI"], "[", 
         StyleBox["1", "TR"], "]"}], ",", 
        RowBox[{
         StyleBox["a", "TI"], "[", 
         StyleBox["2", "TR"], "]"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], " ", "}"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Range"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "create the list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", 
        StyleBox["\[Ellipsis]", "TR"], " ", ",", 
        StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Range"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell[TextData[{
     "create the list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], "+", 
         RowBox[{"1", 
          StyleBox["\[Ellipsis]", "TR"]}]}], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Range"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["dn", "TI"], "]"}], Cell[TextData[{
     "create the list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], "+", 
         RowBox[{
          StyleBox["dn", "TI"], " ", 
          StyleBox["\[Ellipsis]", "TR"]}]}], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 AutoMultiplicationSymbol->False,
 CellTags->"S1.8.3",
 CellID->730775500],

Cell["Functions for generating vectors. ", "Caption",
 CellTags->"S1.8.3",
 CellID->684851307],

Cell[TextData[{
 "One very efficient way to generate a vector is to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 ". This generates a vector of integers."
}], "Text",
 CellID->1931052476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->278607021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10"}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132000494]
}, Open  ]],

Cell["\<\
This generates a vector of reals, starting with 1., incrementing in 0.1, and \
ending at 4.\
\>", "Text",
 CellID->651754132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"1.", ",", "4", ",", "0.1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1865096824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.1`", ",", "1.2`", ",", "1.3`", ",", "1.4`", ",", "1.5`", ",",
    "1.6`", ",", "1.7`", ",", "1.8`", ",", "1.9000000000000001`", ",", "2.`", 
   ",", "2.1`", ",", "2.2`", ",", "2.3000000000000003`", ",", "2.4`", ",", 
   "2.5`", ",", "2.6`", ",", "2.7`", ",", "2.8000000000000003`", ",", "2.9`", 
   ",", "3.`", ",", "3.1`", ",", "3.2`", ",", "3.3000000000000003`", ",", 
   "3.4000000000000004`", ",", "3.5`", ",", "3.6`", ",", "3.7`", ",", 
   "3.8000000000000003`", ",", "3.9000000000000004`", ",", "4.`"}], 
  "}"}]], "Output",
 ImageSize->{508, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->169257582]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " can also be used to programmatically construct a vector; this can be \
useful if you want to execute a function to determine the elements of the \
vector."
}], "Text",
 CellID->1936609806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"i", "/", "2."}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1338855510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7071067811865476`", ",", "1.`", ",", "1.224744871391589`", ",", 
   "1.4142135623730951`", ",", "1.5811388300841898`"}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->571741554]
}, Open  ]],

Cell["\<\
Though it is often more efficient to use listable operations.\
\>", "Text",
 CellID->96872268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Range", "[", "5", "]"}], "/", "2."}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->33007754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7071067811865475`", ",", "1.`", ",", "1.224744871391589`", ",", 
   "1.414213562373095`", ",", "1.5811388300841898`"}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->58539418]
}, Open  ]],

Cell["\<\
The operations and functions discussed in previous sections have equivalent \
versions for vectors.\
\>", "Text",
 CellID->920606466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", " ", "+", "4"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->13197427],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.707106781186548`", ",", "5.`", ",", "5.224744871391589`", ",", 
   "5.414213562373095`", ",", "5.58113883008419`"}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->155169112]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->766138203],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->224277841]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vec", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "=", "x"}], ";"}], "\n", "vec"}], "Input",\

 CellLabel->"In[8]:=",
 CellID->1362793319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7071067811865475`", ",", "1.`", ",", "1.224744871391589`", ",", "x", ",",
    "1.5811388300841898`"}], "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->376353370]
}, Open  ]],

Cell[TextData[{
 "It should be noted that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has no concept of a row or a column vector; a vector has a single index \
that can be used to reference an element of the vector."
}], "Text",
 CellID->1884512185],

Cell[TextData[{
 "Tensors can also be built using the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command. Here, three iterators are used to generate a 2\[Cross]3\[Cross]4 \
tensor."
}], "Text",
 CellID->1907467339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tensor", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"i", " ", "j", " ", "k"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1167684157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "3"], ",", 
       FractionBox["1", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "6"], ",", 
       FractionBox["1", "8"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "3"], ",", 
       FractionBox["1", "6"], ",", 
       FractionBox["1", "9"], ",", 
       FractionBox["1", "12"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "6"], ",", 
       FractionBox["1", "8"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       FractionBox["1", "8"], ",", 
       FractionBox["1", "12"], ",", 
       FractionBox["1", "16"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "6"], ",", 
       FractionBox["1", "12"], ",", 
       FractionBox["1", "18"], ",", 
       FractionBox["1", "24"]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{366, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->571324286]
}, Open  ]],

Cell[TextData[{
 "One can extract an element by using ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " with three indices."
}], "Text",
 CellID->561776716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tensor", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "2", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1443153600],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->23231142]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing Vectors and Tensors", "Subsection",
 CellTags->"c:26",
 CellID->1062677296],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a number of functions for testing vectors and tensors and \
extracting size information."
}], "Text",
 CellID->1943305420],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " has the form of a vector, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " has the form of a matrix, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayQ"], "[", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " is a tensor of rank ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "a list of the dimensions of a vector or matrix ", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayDepth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayDepth"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[
    "find the rank of a tensor ", "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["i", "TI"]], 
     StyleBox["==", "MR"], 
     SubscriptBox[
      StyleBox["t", "TI"], 
      StyleBox["j", "TI"]]}], Cell[
    "compare elements of two tensors for equality ", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->55406717],

Cell["\<\
Functions for testing the structure of vectors, matrices, and arrays. \
\>", "Caption",
 CellTags->"S3.7.3",
 CellID->1360273468],

Cell[TextData[{
 "If you want to test that an expression is a matrix you can use the \
predicate ",
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 "."
}], "Text",
 CellID->5270714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538060671],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491595342]
}, Open  ]],

Cell[TextData[{
 "In addition to ",
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VectorQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VectorQ"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 " are useful for testing vectors and tensors."
}], "Text",
 CellID->1181476509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1441886601],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34948000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "7"}], "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->534311271],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->245755540]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 " can also take a rank argument to test the depth of the array."
}], "Text",
 CellID->1647772545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "7"}], "}"}]}], "}"}]}], "}"}], ",", " ", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->164052103],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->71569711]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 " also takes a third argument that tests each element. In this example the \
result is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " because not all the elements are ",
 Cell[BoxData[
  ButtonBox["NumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberQ"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1651103297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "7"}], "}"}]}], "}"}]}], "}"}], ",", " ", "3", ",", 
   "NumberQ"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->309426145],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->379218027]
}, Open  ]],

Cell[TextData[{
 "The command ",
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " is useful for extracting size information."
}], "Text",
 CellID->1518199295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "7"}], "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2122341058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->124767931]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " returns a list of length 2 when the input is a matrix, stating that two \
indices are used to reference any element in the matrix. Another way to test \
the number of indices required to reference elements is with ",
 Cell[BoxData[
  ButtonBox["ArrayDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayDepth"]], "InlineFormula"],
 ". In this example the result is 2."
}], "Text",
 CellID->976562386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->2013991128],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->674321477]
}, Open  ]],

Cell[TextData[{
 "To compare if the elements of two tensors are equal it is possible to use \
",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ", typically entered using a ",
 Cell[BoxData["=="], "InlineFormula"],
 " short-cut notation. For example, comparing a tensor with itself returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Text",
 CellID->680924986],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ten", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "7"}], "}"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"ten", "\[Equal]", "ten"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->365884839],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->300184784]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " uses the value of numbers so it can be used to compare integer and real \
values."
}], "Text",
 CellID->938833657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ten", "\[Equal]", 
  RowBox[{"N", "[", "ten", "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1414918690],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->41831978]
}, Open  ]],

Cell["\<\
If the structure of two objects does not match they are not equal.\
\>", "Text",
 CellID->1900579532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ten", "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1368428846],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->742656508]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization of Matrices", "Section",
 CellTags->{"t:19", "c:27"},
 CellID->1361817013],

Cell["\<\
This section reviews the functions that are available for formatting and \
plotting matrices.\
\>", "Text",
 CellID->177827765],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MatrixForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixForm"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell["\<\
print a matrix with the elements arranged in a two\[Hyphen]dimensional array \
\
\>", "TableText"]},
   {
    RowBox[{
     StyleBox[
      ButtonBox["MatrixPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MatrixPlot"], "MR"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "show the structural pattern of ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1601493378],

Cell[CellGroupData[{

Cell["Formatting Matrices", "Subsection",
 CellTags->{"t:20", "c:28"},
 CellID->1886656195],

Cell[TextData[{
 "Matrices can be formatted with the function ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1434621410],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1883133001],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwaAGxjAQDkP0fyAJj
rf//gTSEZAWRzCBRMGCQRuOzgFWxYBEFcXmANCsDpinMWHWBRVnhfLAaBgYu
rKJsxJuIxOchwSx0vehmYzeLHU0VE26zsPsUWS/R5oHClwXI5QbSIF1QL4Ck
MXyH3QRxLCYS1iUGtY84V8qPqkIKXVD0cyDRFKUa6qdDMk2EpUTauAqU1piw
2IhpJq4SiRvMgWYNBmxuwl6SCKHx0WMMuy5BqJvRczZENXFlK6QcZmAEALkf
DGU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{42, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->124057933]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " also works for vectors and higher rank tensors; the braces can help to \
understand the grouping."
}], "Text",
 CellID->1569687846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", " ", 
  RowBox[{"Array", "[", " ", 
   RowBox[{"m", ",", " ", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2054507974],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{600, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->137530178]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting Matrices", "Subsection",
 CellTags->{"t:22", "c:29"},
 CellID->1336717728],

Cell[TextData[{
 "A convenient way to plot matrices is with the function ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1388423229],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1179511381],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnD1z2jAYx40dmoaknTvm07RTPwSX610y9NpLM7AxMjJ0cDfu8gUYPTIy
MjIyMjIyqnqxK6NKluQXsC5/7kC2/GD7Zz3SX35k6+v45fHb9/HL08P4/svz
+Ofj08Ov+88/nmlWMoii6JV+f3+K6DKhS/z7SghNy79D9pssFgvCP1FMf4bU
9JamSZ66rI+UtNh+zfc/nU7z/Sf8qFd8cbvdZlnGFsVZsDMUViOe+W+d/yeK
7jq0sq3r9/KuuHqbzUalS9M0Nwyb7ng8TiYTSZcUuQIwtwqPTnjmbDajKCT3
fEEXr9fr66CpaLWileuUinvkfr8nwZeZbDfKdLKNCZuOuqNojg10rDWJqfUH
IlrYO491NWXbb8hpazXQHvWPsv52rYal66pTwFtlu2qnKud7p6NyTfnPY+p5
o/5fPrn1agVIQQpSkIZGqrb4OkXVtfgmJR45HbWv+nd5xTUpr+keVLVv37/b
6RU2qRXd12EwghGMYGzKaGrNq+5TTSoLNfW3Yj5WpY429VRV1q3U3WIy3fce
fesD6EAHOtBdgk4X6XW9/9QpKJTSz0pVyrqR3iL/xumo9UYvLhVR0ee2WXtB
ClKQgvQcpFVjq76RXvcWv6/6d/lIr0lJbU8d+V3/JiMZXfYS2/dvkIIUpCDt
D2nV2KprdBiKW9+qKhrvorTq9nONc3Tpz+1Eb8AIRjCC8ZyMttbcRUURMa5v
VTdibFLdsOIzTWoNSEEKUpCGRtokYqxTZiiun1XR47G9l2pT3jaeDW6np9cv
/wYpSEEK0v6Qlu9xmyrv21Lc+XzuYCXngihbpWl6OBwIkfe4akTYlNrGbsVb
z7vdbrlcssXyW89ZluUzK6g9St+oS5s+btuXIFqtVpp38OlFzDnDI6L+czJX
gm2ei/4TSd+XRDH1uJDKhp1rTH2Kl0ZeBrJMrgIjKZ97UiISE1eESSTPXRCx
FtD2povP870f+V7FfD7R4C+7qY3q\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->77464917]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "mat", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->314459123],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW82O0zAQdpN0W0jZCqFdcWnVB1hegL2DhMQVca0qpN0DAi37LBx4jj3w
RLyGsRO7mdgz/mlcSKJUu3GdzHwej+fPbvtx/3j35ev+8f6w371/2H+/uz/8
2L379iBu5TPG2JP4//2aifdcvKv+nzgXrX29EtdcEJSiLVQr+y/kU/mGVy/2
HNzPkOelur9SrcbJVP+6Gu0a4dJ9cWWXyKiwb476TF6Kpl+PbyG0KPwYmUHx
CpXdHMnEXSqNmnOyxwublSSwZxMmK7aaepWg/tfRsmqklUWZStaSGFFbotaN
X89lMhltPmx0zE9MqwmR6XS5rwhdYVJhdKVxX+s+59CrqdgiuX7p0awxFx7N
oJqKoO/Kb8pXjngWP2mqxsrE6/LPoYoRa9Feqlb2b0T7cvQYrKib+qUz2zwe
uUUNs2ReDZC1aRDvzuLHpLkVviwcZrIdmAyyWylOjCL+2MohxVrRF6PSwHll
UEbJtJpT2DzMITV8X3w8GQa4uxWXjaC+AdwSNZ+4Afdc2cPFiSiSt6r5rJxn
UgYjGv1KsuqqY4hsKbR2tsgV9eI417bfFTEyOiPCfDQjXHAQbeJxFfeS/2/L
Tsv9RlzeCurtwLmo1UW5iVX126AHrYN1n4oM5y0fmjh23BjPfE9d5/5bcwcu
q9rQ8WHD6ypjPLxmbi/CseaQih1zfXpEtHqIni9eO2DY2P7FRG/HBNMzaexU
chPRIQw9MEYg+7IwVA4rqyF6Bb3ngFXCbuI1s0kYRlztEIsZmVGp0wo4wpY3
p0JtBOfuIankeZyOYdw5ajgsNqN4jticxc3XiG2ZJ1L02/qxncQaxJehcrUs
LoK7sbUlstZRSEZ//o9R9UkCRNNxwNSKf3dsyUTEQNRDfVghvhmhI8Qre22r
abhueXMivQneVfSPy3fW5kMJr5O7o0pPKRAL9aEV7cyrnjDWxC0Twf6kCHI1
vof5LyqNw3+7YpxH1/233A5cZPb+wON3+/3mDasFKQxPfo7HM/rufErV2Rq9
7aUBWTZM3hg/i9YA7m3n1G4qCxii9ZsxQn8OqLlvR8pNZcpQlCZjwgqTxSIu
4Ko1GDWyL2+FyhruUbJLoYbEEt9uIlRi2k/dJ/hO/A4n+YG43HWiPxzfSMDd
0slntXeIqTn6w0Of3Fq8xImtPy+6pIjYP5wB06wyPgHUNGf2/Zg7XQW5V9nw
957a8Mk84O44vgc63Fk03zOmvo08/d6Bwph+7xAu6/R7h5pv+r0DvLLZX6vS
5t0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->601954219]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " has a number of graphics options for controlling the appearance of the \
plot. Many of these are the typical options of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["DensityGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityGraphics"]], "InlineFormula"],
 " objects. It also has a special option, ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 ", that controls the maximum size for the display of a matrix. Above this \
size the matrix is downsampled. Some of the important options are summarized \
in the following."
}], "Text",
 CellID->1075588348],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    StyleBox[
     ButtonBox["MaxPlotPoints",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MaxPlotPoints"], "MR"], 
    StyleBox["200", "MR"], Cell[
    "maximum size of matrix to display", "TableText"]},
   {
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    StyleBox["1", "MR"], Cell[
    "scaling for the final image shape", "TableText"]},
   {
    ButtonBox["ColorRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "coloring for each element", "TableText"]},
   {
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function for coloring each element", "TableText"]},
   {
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a mesh", "TableText"]},
   {
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    StyleBox[
     RowBox[{
      ButtonBox["GrayLevel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], "MR"], Cell[
    "the style of the mesh", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S5.27.1",
 CellID->2043508037],

Cell[TextData[{
 "Options of ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 ". "
}], "Caption",
 CellTags->"S3.7.2",
 CellID->533611388],

Cell[TextData[{
 "One useful feature of ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " is that it can plot very large matrices. Here a very large sparse matrix \
is generated."
}], "Text",
 CellID->213675174],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "10000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nz", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "n"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"nz", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
      RowBox[{"Table", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", "nz", "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "=", 
  RowBox[{"sp", "+", 
   RowBox[{"Transpose", "[", "sp", "]"}]}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->362251893],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4000", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4000, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"10000", ",", "10000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->342375401]
}, Open  ]],

Cell[TextData[{
 "You can still plot this out with ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 ". Here the number of points that are plotted is reduced to 100. "
}], "Text",
 CellID->70411894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "100"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->271973335],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->155199871]
}, Open  ]],

Cell["", "Text",
 CellID->69674460],

Cell[TextData[{
 "By default, no mesh is drawn around the elements; this can be enabled with \
the ",
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 " option. Typically you would not want to draw the mesh if the matrix is \
very large. When the mesh is drawn, it is sometimes useful to change the \
style of the mesh with the ",
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " option."
}], "Text",
 CellID->514888244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "White"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1515103145],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->89537722]
}, Open  ]],

Cell[TextData[{
 "You can change the coloring with the ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " option. This example plots zero as white and everything else black."
}], "Text",
 CellID->478175105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "White"}], ",", 
      RowBox[{"0.", "\[Rule]", "White"}], ",", 
      RowBox[{"_", "\[Rule]", "Black"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->29825653],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->412942752]
}, Open  ]],

Cell[TextData[{
 "You can also use the ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " option to add color."
}], "Text",
 CellID->1078154653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"#", ",", "0", ",", "0"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->78239585],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->30413489]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import and Export of Matrices", "Section",
 CellTags->{"t:21", "c:30"},
 CellID->2053293398],

Cell["\<\
This section reviews the functions that are available for importing and \
exporting matrices.\
\>", "Text",
 CellID->1787416543],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     StyleBox["file", "TI"], ",", 
     StyleBox["format", "TI"], "]"}], Cell[
    "import data in the specified format from a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", 
     StyleBox["file", "TI"], ",", 
     StyleBox["mat", "TI"], ",", 
     StyleBox["format", "TI"], "]"}], Cell["\<\
export matrix to a file, converting it to the specified format\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->2108583965],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a number of different tools for input/output. If you want to save \
your data in a file so that later you or a colleague can continue to work \
with it in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you might want to use some of the functions that work with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in files. These are discussed under \"",
 ButtonBox["Expression Input and Output",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#1564598842"],
 "\"."
}], "Text",
 CellID->1195556961],

Cell[TextData[{
 "If you want to work with matrices from a source external to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using specific data formats, the functions ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " are useful. The ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " function supports a variety of different formats, some of which are \
relevant to matrices."
}], "Text",
 CellID->1868842195],

Cell[CellGroupData[{

Cell[BoxData["$ImportFormats"], "Input",
 CellLabel->"In[1]:=",
 CellID->534950343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3DS\"\>", ",", "\<\"ACO\"\>", ",", "\<\"AIFF\"\>", 
   ",", "\<\"ApacheLog\"\>", ",", "\<\"AU\"\>", ",", "\<\"AVI\"\>", 
   ",", "\<\"Base64\"\>", ",", "\<\"Binary\"\>", ",", "\<\"Bit\"\>", 
   ",", "\<\"BMP\"\>", ",", "\<\"Byte\"\>", ",", "\<\"BYU\"\>", 
   ",", "\<\"BZIP2\"\>", ",", "\<\"CDED\"\>", ",", "\<\"CDF\"\>", 
   ",", "\<\"Character16\"\>", ",", "\<\"Character8\"\>", 
   ",", "\<\"Complex128\"\>", ",", "\<\"Complex256\"\>", 
   ",", "\<\"Complex64\"\>", ",", "\<\"CSV\"\>", ",", "\<\"CUR\"\>", 
   ",", "\<\"DBF\"\>", ",", "\<\"DICOM\"\>", ",", "\<\"DIF\"\>", 
   ",", "\<\"Directory\"\>", ",", "\<\"Dump\"\>", ",", "\<\"DXF\"\>", 
   ",", "\<\"EDF\"\>", ",", "\<\"ExpressionML\"\>", ",", "\<\"FASTA\"\>", 
   ",", "\<\"FITS\"\>", ",", "\<\"FLAC\"\>", ",", "\<\"GIF\"\>", 
   ",", "\<\"Graph6\"\>", ",", "\<\"GTOPO30\"\>", ",", "\<\"GZIP\"\>", 
   ",", "\<\"HarwellBoeing\"\>", ",", "\<\"HDF\"\>", ",", "\<\"HDF5\"\>", 
   ",", "\<\"HTML\"\>", ",", "\<\"ICO\"\>", ",", "\<\"Integer128\"\>", 
   ",", "\<\"Integer16\"\>", ",", "\<\"Integer24\"\>", 
   ",", "\<\"Integer32\"\>", ",", "\<\"Integer64\"\>", 
   ",", "\<\"Integer8\"\>", ",", "\<\"JPEG\"\>", ",", "\<\"JPEG2000\"\>", 
   ",", "\<\"JVX\"\>", ",", "\<\"LaTeX\"\>", ",", "\<\"List\"\>", 
   ",", "\<\"LWO\"\>", ",", "\<\"MAT\"\>", ",", "\<\"MathML\"\>", 
   ",", "\<\"MBOX\"\>", ",", "\<\"MDB\"\>", ",", "\<\"MGF\"\>", 
   ",", "\<\"MOL\"\>", ",", "\<\"MPS\"\>", ",", "\<\"MTP\"\>", 
   ",", "\<\"MTX\"\>", ",", "\<\"NB\"\>", ",", "\<\"NetCDF\"\>", 
   ",", "\<\"NOFF\"\>", ",", "\<\"OBJ\"\>", ",", "\<\"ODS\"\>", 
   ",", "\<\"OFF\"\>", ",", "\<\"Package\"\>", ",", "\<\"PBM\"\>", 
   ",", "\<\"PCX\"\>", ",", "\<\"PDB\"\>", ",", "\<\"PDF\"\>", 
   ",", "\<\"PGM\"\>", ",", "\<\"PLY\"\>", ",", "\<\"PNG\"\>", 
   ",", "\<\"PNM\"\>", ",", "\<\"PPM\"\>", ",", "\<\"PXR\"\>", 
   ",", "\<\"QuickTime\"\>", ",", "\<\"RawBitmap\"\>", ",", "\<\"Real128\"\>",
    ",", "\<\"Real32\"\>", ",", "\<\"Real64\"\>", ",", "\<\"RIB\"\>", 
   ",", "\<\"RSS\"\>", ",", "\<\"RTF\"\>", ",", "\<\"SCT\"\>", 
   ",", "\<\"SDTS\"\>", ",", "\<\"SND\"\>", ",", "\<\"Sparse6\"\>", 
   ",", "\<\"STL\"\>", ",", "\<\"String\"\>", ",", "\<\"SXC\"\>", 
   ",", "\<\"Table\"\>", ",", "\<\"TAR\"\>", ",", "\<\"TerminatedString\"\>", 
   ",", "\<\"Text\"\>", ",", "\<\"TGA\"\>", ",", "\<\"TIFF\"\>", 
   ",", "\<\"TSV\"\>", ",", "\<\"UnsignedInteger128\"\>", 
   ",", "\<\"UnsignedInteger16\"\>", ",", "\<\"UnsignedInteger24\"\>", 
   ",", "\<\"UnsignedInteger32\"\>", ",", "\<\"UnsignedInteger64\"\>", 
   ",", "\<\"UnsignedInteger8\"\>", ",", "\<\"USGSDEM\"\>", 
   ",", "\<\"UUE\"\>", ",", "\<\"VCF\"\>", ",", "\<\"WAV\"\>", 
   ",", "\<\"Wave64\"\>", ",", "\<\"WDX\"\>", ",", "\<\"XBM\"\>", 
   ",", "\<\"XLS\"\>", ",", "\<\"XML\"\>", ",", "\<\"XPORT\"\>", 
   ",", "\<\"XYZ\"\>", ",", "\<\"ZIP\"\>"}], "}"}]], "Output",
 ImageSize->{580, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46511687]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " format will read tabular data into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This format is not specific to matrices and can process different types \
of information such as numbers, dates, and currencies. However, this is often \
a simple way to read in a matrix. This example displays a sample data file."
}], "Text",
 CellID->1899767359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", 
  "\"\<LinearAlgebraExamples/Data/simplematrix.dat\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->603139117],

Cell["\<\
4.5 6.7
3.2 1.2\
\>", "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->22156131]
}, Open  ]],

Cell[TextData[{
 "Now the data file is read into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " command using a format of ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "; the result is a matrix."
}], "Text",
 CellID->843536638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<LinearAlgebraExamples/Data/simplematrix.dat\>\"", ",", 
   "\"\<Table\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1780721019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.5`", ",", "6.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2`", ",", "1.2`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82984887]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can be used to write out a matrix in some particular format. Here it uses \
the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " format."
}], "Text",
 CellID->299155443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<fileout.dat\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->646312874],

Cell[BoxData["\<\"fileout.dat\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->516652420]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<fileout.dat\>\"", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1920737071],

Cell["\<\
1\t2
3\t4\
\>", "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->28672280]
}, Open  ]],

Cell[TextData[{
 "This example shows how to write a matrix into a ",
 StyleBox["CSV", "MR"],
 " format. This could be read into another application such as a \
spreadsheet."
}], "Text",
 CellID->1984110944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<filecsvout.dat\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "\"\<CSV\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->826565192],

Cell[BoxData["\<\"filecsvout.dat\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->483917042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<filecsvout.dat\>\"", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->240113429],

Cell["\<\
1,2
3,4\
\>", "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->281625828]
}, Open  ]],

Cell[TextData[{
 "There are other matrix formats. For example, Harwell\[Dash]Boeing, used for \
sparse matrices, and Matrix Market, used for both sparse and dense matrices. \
These are discussed under \"",
 ButtonBox["Import and Export of Sparse Matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#212323487"],
 "\". In addition the MAT matrix format and the FITS astronomical data format \
can also be useful as import or export formats."
}], "Text",
 CellID->760490938]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Multiplication", "Section",
 CellTags->{"t:24", "c:31"},
 CellID->1896011669],

Cell[TextData[{
 "Matrix multiplication (also called dot or inner product) is carried out in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the function ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", typically entered with a dot short-hand syntax."
}], "Text",
 CellID->1905766697],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502281474],

Cell["\<\
This demonstrates matrix multiplication of a matrix with itself.\
\>", "Text",
 CellID->86517161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", ".", "mat"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->247495908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "22"}], "}"}]}], "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->592424952]
}, Open  ]],

Cell["This multiplies a matrix with a vector.", "Text",
 CellID->671742684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", ".", 
  RowBox[{"{", 
   RowBox[{"4", ",", "5"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->657757709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "32"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->631372255]
}, Open  ]],

Cell[TextData[{
 "The matrix product can be computed with two matrices of different sizes so \
long as they are compatible. For matrices this means that to multiply a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "1"], "\[Times]", 
    SubscriptBox["n", "1"]}], TraditionalForm]], "InlineMath"],
 " matrix by a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["m", "2"], "\[Times]", 
    SubscriptBox["n", "2"]}], TraditionalForm]], "InlineMath"],
 "matrix, it is required that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 "is equal to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", "2"], TraditionalForm]], "InlineMath"],
 ". Here, a 2\[Times]3 matrix is multiplied by a 3\[Times]2 matrix."
}], "Text",
 CellID->377906423],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mat2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}], ";"}]}], "InputOnly",
 CellLabel->"In[4]:=",
 CellID->1364107182],

Cell["\<\
This will result in a 2\[Times]2 matrix.\
\>", "Text",
 CellID->13992502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat1", ".", "mat2"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1096263591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"23", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59", ",", "40"}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->57197826]
}, Open  ]],

Cell["This generates a 3\[Times]3 matrix.", "Text",
 CellID->2108881870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat2", ".", "mat1"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1907479002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"8", ",", "13", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "40", ",", "51"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "11", ",", "15"}], "}"}]}], "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->53665440]
}, Open  ]],

Cell["If the dimensions do not match, an error is generated.", "Text",
 CellID->1830975002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat1", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1903680751],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dot", "::", "\<\"dotsh\"\>"}], ":", 
  " ", "\<\"Tensors \\!\\({\\(\\({1, 2, 3}\\)\\), \\(\\({4, 5, 6}\\)\\)}\\) \
and \\!\\({1, 2}\\) have incompatible shapes. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Dot/dotsh\\\", ButtonNote -> \
\\\"Dot::dotsh\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[8]:=",
 CellID->374486252],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->113826304]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " can be used to multiply vectors of equal length; the result will be a \
scalar."
}], "Text",
 CellID->463508194],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"vec", ".", "vec"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1259028889],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->665831093]
}, Open  ]],

Cell["\<\
Multiplication of a matrix by a vector works equivalently. This multiples a 2\
\[Times]3 matrix by a length 3 vector.\
\>", "Text",
 CellID->574254236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat1", ".", "vec"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->699434834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "32"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->120504390]
}, Open  ]],

Cell["\<\
This multiples the length 3 vector by a 3\[Times]2 matrix.\
\>", "Text",
 CellID->31444849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", ".", "mat2"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->212599981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23", ",", "16"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->19472771]
}, Open  ]],

Cell[TextData[{
 "The definition of matrix multiplication is such that the product ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 " of two matrices ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "\[LongEqual]", 
    RowBox[{"A", ".", "B"}]}], TraditionalForm]], "InlineMath"],
 ", is given as below."
}], "Text",
 CellID->558386912],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["c", 
    RowBox[{"i", "\[VeryThinSpace]", "j"}]], "\[LongEqual]", 
   RowBox[{
    UnderscriptBox["\[Sum]", "k"], 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"i", "\[VeryThinSpace]", "k"}]], 
     SubscriptBox["b", 
      RowBox[{"k", "\[VeryThinSpace]", "j"}]]}]}]}], 
  TraditionalForm]], "NumberedEquation",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->305292594],

Cell[TextData[{
 "The definition generalizes, so that the product ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " of two arbitrary rank tensors ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]]],
 " is as follows."
}], "Text",
 CellID->714194675],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["s", 
    RowBox[{
     SubscriptBox[
      RowBox[{"i", "\[VeryThinSpace]"}], "1"], 
     SubscriptBox["i", "2"], "\[Ellipsis]", "\[VeryThinSpace]", 
     SubscriptBox["i", 
      RowBox[{"m", "-", "1"}]], 
     SubscriptBox["j", "2"], "\[Ellipsis]", "\[VeryThinSpace]", 
     SubscriptBox["j", "m"]}]], "\[LongEqual]", 
   RowBox[{
    UnderscriptBox["\[Sum]", "k"], 
    RowBox[{
     SubscriptBox["t", 
      RowBox[{
       SubscriptBox["i", "1"], 
       SubscriptBox["i", "2"], "\[Ellipsis]", "\[VeryThinSpace]", 
       SubscriptBox["i", 
        RowBox[{"m", "-", "1"}]], "\[VeryThinSpace]", "k"}]], "  ", 
     SubscriptBox["u", 
      RowBox[{"k", "\[VeryThinSpace]", 
       SubscriptBox["j", "2"], "\[Ellipsis]", "\[VeryThinSpace]", 
       SubscriptBox["j", "m"]}]]}]}]}], TraditionalForm]], "NumberedEquation",\

 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->1183799642],

Cell[TextData[{
 "Thus applying ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " to a rank ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " tensor and a rank ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " tensor results in a rank ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "m", "-", "2"}], TraditionalForm]], "InlineMath"],
 " tensor. An example is shown below. First, a 2\[Times]3\[Times]4 tensor is \
defined."
}], "Text",
 CellID->1832077286],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tensor1", "=", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{"tensor1", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[13]:=",
 CellID->1102415116],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz2P2jAYDiSBUIm2J7VVx6v6X9qpPwKdKt2pqlpd7yQ2RkbGjIwZGTMy
MjIyZszIeGPqz9jxOeAPAgR8EhDHj/0+9uuvvM/lx+jp/ufv0dPD3ej2++Po
7/3D3b/bb38ewS2/43neM/x89sB1Aa7Q57kowC//HcJvfz6fF+jP66N0HMck
3QVfPiiK77+8vGCodyPgfILrGeIilJ5MJhzO8wJ0udls0jRl7EAiz3N4iWuB
LcOlQloLyX8n4FGtYYlHNigX21J92pPr9VpsAWs/Rs1ms0qatQDjsyzDRQiX
5vClX8fjMWPt07sVFGjYcrmk/RyUo4JZGwq4SOofczy2N51OAbWCjE7Mtrta
rSKKJrmB1G9yzqwUtAkpRIa4coyCYVvliMZBZbSAlvB+qeGaJAkpNRRKhUJ/
RZZ4bI/NN547m5s63IFjgWfUuZjjxRVqF3eW5r3YBZW9leTTka6SP6B+Jvkd
JRbva2rfd38g3HfWnLV2WlOZhzr5ZizqVzKZzUOizfjK9kvH1I4pPNd1d4w0
aDPQyD9Cf3G4gSbuGPNEtnPr4JpZUXoFe7JRyW/DKuqsOWvnZg2uFeGeNVwn
/zp2dts1s9m1VYy77FpDbXBm7MSYR6/Gqi2u2Z3dFnc98+T0zw2XvH47a86a
WgyQ7tKev1gssiyDl2IUzxYn6gS72LGYrGx/4aN0w4bx6qxhHFvcb2TWD4lT
Y4dRTCkSTxS4D/I8x91ClIjm8GrjtGTNRe1f1wqqrGg/zeF1WIMqkySR1RrS
fDxh0NxtEv9GifWAeoikxZhDWet2u4WXNw3j1VhDD8J4zxfh94NS6V8ORe6K
ygc9WQXUKzWKcK0XDfFqXsczjGm8cp10UqsJy+e5OV5nXWD7DszveVTFr1eB
5Tq5OV7njMDUXR09lpWSPX3Z4DVPEPy6HrBa9+vIarzV8Tq82TmK9yTr7XqF
WK7Am+MPybpeGzZToNVK6bRAOMudPOp1eU8czpqzpmPtPOJDbYuqtUetbQ9T
pys7XVmW34ZV1Flz1s7N2r4TtNvZZXxV18zTqI+qevFp2KnqxccZeap9cJpd
8hJ2crP//T7vVdNZu0ZrLIp4DGtMw+OtxXFMdBlT7Rjms3fH9HG4fpAAt+Al
/4ZImqbkvS1b7VgeETXHl/FIyftEoENJW3S1Y2ilV/aRer4YF8ds5G+5mWu/
u964sy0lxnNZC7pgBNjqxagnKjqBfQnkW+BnhHw1Pso3KQ+g/XqllmSOjwR+
Pseaabd9IW2j/VZYGOIjAY9ZfyxwzOZrUdWGP6Fc/Aat1/kPWMVFvQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{117, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//MatrixForm=",
 CellID->347857061]
}, Open  ]],

Cell["\<\
Now, a 4\[Times]2\[Times]1 tensor is defined.\
\>", "Text",
 CellID->2092147369],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tensor2", "=", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "4", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "7", "}"}], ",", 
       RowBox[{"{", "1", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "8", "}"}], ",", 
       RowBox[{"{", "3", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "9", "}"}], ",", 
       RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"tensor2", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->1971078452],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWCtzAjEQDvcCOn3JSv5IbVtTwz+4YToDotMOReCQSCSSn4BEIpFIJBKJ
RF43yUGO7eaSewxMW5g5yCZZvm832b1kX8Ne++097HVaYeO5G362O62vxtNH
F7rcCmOsCc/jA4N2BC3xNKMIfuX3Lf92ea/4sBsk3xvGhT7zRe9kMol7fTTr
jtJKGa8KeTAYxLIrUDzRXK1Ws9mMQuEyF+uo/5qY54NYRf3B3orlcolRx+Ox
xrYa+S96dIxKs9jtdv1+X7Fw972SyA8UbDNmmZWFlIfDIUDypnNg4SwWC4qz
R3g0HyosLyzyMapYgc1mQ9kubPUPstApi4vabUkuameekgsshQwxDRes5ZFc
MGMci3ic3mkqHiokFxwVnItLoOP8wuc5hMeu0P/TqC//YBb2bNaMbedJ7P+s
GbxuhULtNS5iG3G86ObVcqHmi1k7rVMyMr0Dfj8X2/3B2Tln3h/leKCcnG6n
ZRezRTI7Ne+S2XWe/UuZ3XTCsT2j54vgrOim+flYlH1TuLAoyqLsW9Mpc7rd
OT1rzuHjnAr2xOWcfp5sPhqNUlHKyeaqcpNEgTvedruNiL2ly844XrgPqHe+
1Fuv19PplDeT91m4bsf1l6JZ3BTdUn8+nxPVBjA85lbGmyzQ+gDW96jCYqo2
5UE3n11xvU1xcWAtinpA6HtKpitvDvhbWB/brHzgFcRPjlPWBwjPTbCQJSdq
JUz5Ny1fU/m9ivAkC+okT+VdnE2CeB5mLeu1svbLKt9Ua+ae\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{82, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]//MatrixForm=",
 CellID->137638720]
}, Open  ]],

Cell[TextData[{
 "This multiplies ",
 Cell[BoxData["tensor1"], "InlineFormula"],
 " by ",
 Cell[BoxData[
  RowBox[{"tensor2", "."}]], "InlineFormula"],
 " They are compatible because the length of the innermost index of ",
 Cell[BoxData["tensor1"], "InlineFormula"],
 " equals the length of the outermost index of ",
 Cell[BoxData["tensor2"], "InlineFormula"],
 "."
}], "Text",
 CellID->1788287095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tensor1", ".", "tensor2"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->1707565900],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjuP2kAQNrZ5JVFyUhLlpBR3/yN9UuVHoFOkuyJKdLmCjpKSKqLkJ1BS
UlJSUlJSUlI6+/KDz4N3Fszh6HwSnHc9M57v293Z8bDfe0/3P372nh7uerff
Hnu/7x/u/tx+/fUouoKG53kT8fly7YnrSFypzySKxH/9/VZ+B7JX/XmfoX11
4n1l32uq3slkYnqbIBWKr6an5WT3G8oKIe8b+XcnyrdVezAYmHagvA7V5Wq1
ms1m8rJFWPWaSVvpeDmp1wzf8laQIQ4j7lba8bgsl0vEPR6PjRQiQqtSq8UY
NdRrOzLlqq/v73a7fr+fogviXg0whw6t+iSz6BvN7D5HYYl6Wm44HAogiZdK
2l8sFmilQ2EK07bdrw7JQmDRKseKRiMWoViK+1jVLN1sNhExjl0Ks2lzRrCb
48gVrbsFjTSNOFmkaXQi12OO1dARL23luNl/iq1k1ertgsmBbAcm+voMD2P5
MKJ3BFd5vcLSmNlgeX1jearr/Q48r/ai9qL2ogwvZESLM8imieTyNu6sVCTM
yocl6x2Hhpfj0L2oa8tgqmq7HOZwRw8ujqv6nIURx6OaM3tGhbOP975nw8WN
badZ4/GCz6DyvuIcG2cbZoZo0WWsUfectrul8FVVdNVjTq4l+SYR16TiHRjl
qCrFOfV4aHC1lV3Xe8Xy4u8LkEKmP0D707MwTe2x2YonevkR2m0jF8vj7KTe
0ovky4lWuJ9hG1EolIW7ga3G6G6hHKRkbbkAqbzfSlIA1b1X4eJgPcYGDy0n
aw6J2PYe2lWpSZ3zLcvGQT7D8Q17nJoVT/OS+LL3kxEpiI9FWShHv0pYMbbY
RtRV/ziscQ01zkRw70BUHSMfZyyc3xKK5I/z+tri5Y3FK7xfe1F7UXvB8WI0
Gjl5QWUDnDjzPLXU9JRCFs14PN5utxw0p+8Mh61cvpql2+v1ejqdJrYMR7PZ
zJwjQI6QaVteb2PHXvVxrYS5W9QW5vM58au0mCqGn5fDhIgCe2cR8BQJalFn
EjhR4FD0KKfy7mYNzw2lyH2xEshKcM4mnlPANz2cQbxfHFzra8dZlQh9MdPV
WJsRPjzi9BklfDKy9r/xkWUgyPCij6kc4iXen0LCKjKQrRSGmX3NpcJYpNcG
fzUKtFZ2nUufFJxoZhv/AMFo56c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//MatrixForm=",
 CellID->248815299]
}, Open  ]],

Cell["\<\
The result is a 2\[Times]3\[Times]2\[Times]1 tensor.\
\>", "Text",
 CellID->1277097773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->83219046],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->759911400]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outer Product", "Subsection",
 CellTags->{"t:201", "c:32"},
 CellID->520172951],

Cell[TextData[{
 "The outer product is a way to build a higher rank tensor from those of \
lower rank. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides this functionality with the function ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 ". One use of this is to combine two vectors to form a matrix as an outer \
product."
}], "Text",
 CellID->140860520],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec1", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec2", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", "vec1", ",", "vec2"}], "]"}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->915780646],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdF7tuwjAw5MEjtFtFu5V2KKqq/karDszMEaoEQ9WKMrAxMjIy8gmMjIyM
jIyMjIyM7tk+Y8d2QqAqrRop8d3lXr67nC/1qNt6fYu67WZUfe5EH61287P6
9N4BkpdzHKcB98OVAzABiN0NQmDlz0d4+kC8Y1hAn954PCbscmoMpzIcv2Z4
v99H3GNSPgOXy+V0OqUgxakQ1ebC6uJaRnpR0yroeVgDXJkXi8VCtzIajVTb
wU4L48Ed+FI3t2ryFRSfErQYVO7Xdrvt9XrSL09QuWvop/SgiJbOLHSBO8KT
hPcSHwwGYIqC7s66O5/Pg0OsxuITahwlDS8wHFILCY7bZdlYr9e7XR+dDXu8
w4w6eWRk/akeylqlclTMJ2ZVCjrdNt+KuEJ8S6UDrBuWbf6RJNiqi+ggnkvh
kvh/5Kph/G4zcd+TeO3dZJKieGDpNyWk61+SoOdj7/dZ+V6FH9NvvuNXnijf
f0In03pPKpeI2w/6Y3YlaxTNnpjFI1EXqrRnWC2ncVr7Uza9B0TOl1kxKzq0
cphdq2TwHVHryo4qe/CLTFo93MWltlYySf/VDndMHxwOh6nc9j4o5zJVCk6Z
zWZDQXFGiTirJ5ycq6RWQfeJeratVqvJZEJB9WyDoxWnsdP3Qe7XbDazTCCw
dfT2dH2wKHIYm8T0+dTHjAsPzhXcjJRv6W4cl1Uh7biQi9+cuFgWIe686QTa
zmlm0uZ/e88Kie0vQJv30RYfOin4ouGcS/3DcXJfd40vRw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->333304921]
}, Open  ]],

Cell["\<\
The function that is used to combine corresponding elements is given as the \
first argument. It can be an unknown function as in the following example.\
\>", "Text",
 CellID->1286686134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ap", ",", "bp"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->173528848],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"f", "[", 
       RowBox[{"a", ",", "ap"}], "]"}], 
      RowBox[{"f", "[", 
       RowBox[{"a", ",", "bp"}], "]"}]},
     {
      RowBox[{"f", "[", 
       RowBox[{"b", ",", "ap"}], "]"}], 
      RowBox[{"f", "[", 
       RowBox[{"b", ",", "bp"}], "]"}]},
     {
      RowBox[{"f", "[", 
       RowBox[{"c", ",", "ap"}], "]"}], 
      RowBox[{"f", "[", 
       RowBox[{"c", ",", "bp"}], "]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$879]]]], "Output",
 ImageSize->{140, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->205606706]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization of the Outer Product", "Subsubsection",
 CellTags->{"t:202", "c:33"},
 CellID->1814519952],

Cell[TextData[{
 "One way to visualize the operation of ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " is demonstrated in this example. First, a list of points is created."
}], "Text",
 CellID->221562217],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"Pi", "/", "8."}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59537221],

Cell[TextData[{
 "This shows how ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " joins each point to each other point."
}], "Text",
 CellID->2062177492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Outer", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Line", "[", " ", 
        RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", "pts", ",", "pts", ",", 
      "1"}], "]"}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->778529111],

Cell[BoxData[
 GraphicsBox[{{LineBox[{{0., 1.}, {0., 1.}}], 
    LineBox[{{0., 1.}, {0.3826834323650898, 0.9238795325112867}}], 
    LineBox[{{0., 1.}, {0.7071067811865475, 0.7071067811865476}}], 
    LineBox[{{0., 1.}, {0.9238795325112867, 0.38268343236508984`}}], 
    LineBox[{{0., 1.}, {1., 6.123233995736766*^-17}}], 
    LineBox[{{0., 1.}, {0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{0., 1.}, {0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{0., 1.}, {0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{0., 1.}, {1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{0., 1.}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{0., 1.}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{0., 1.}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{0., 1.}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{0., 1.}, {-0.9238795325112866, 0.38268343236509}}], 
    LineBox[{{0., 1.}, {-0.7071067811865477, 0.7071067811865474}}], 
    LineBox[{{0., 1.}, {-0.3826834323650904, 0.9238795325112865}}], 
    LineBox[{{0., 1.}, {-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {0., 1.}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{0.3826834323650898, 
     0.9238795325112867}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{0.3826834323650898, 
     0.9238795325112867}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{0.3826834323650898, 
     0.9238795325112867}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{0.3826834323650898, 
     0.9238795325112867}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{0.3826834323650898, 0.9238795325112867}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{0.3826834323650898, 
     0.9238795325112867}, {-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {0., 1.}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{0.7071067811865475, 
     0.7071067811865476}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{0.7071067811865475, 
     0.7071067811865476}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{0.7071067811865475, 
     0.7071067811865476}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{0.7071067811865475, 
     0.7071067811865476}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{0.7071067811865475, 0.7071067811865476}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{0.7071067811865475, 
     0.7071067811865476}, {-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {0., 1.}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{0.9238795325112867, 
     0.38268343236508984`}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{0.9238795325112867, 
     0.38268343236508984`}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{0.9238795325112867, 
     0.38268343236508984`}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{0.9238795325112867, 
     0.38268343236508984`}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {-0.9238795325112866,
      0.38268343236509}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {-0.7071067811865477,
      0.7071067811865474}}], 
    LineBox[{{0.9238795325112867, 0.38268343236508984`}, {-0.3826834323650904,
      0.9238795325112865}}], 
    LineBox[{{0.9238795325112867, 
     0.38268343236508984`}, {-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{1., 6.123233995736766*^-17}, {0., 1.}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {1., 6.123233995736766*^-17}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{1., 
     6.123233995736766*^-17}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{1., 
     6.123233995736766*^-17}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{1., 
     6.123233995736766*^-17}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {-1., -1.8369701987210297`*^-16}}],
     LineBox[{{1., 6.123233995736766*^-17}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{1., 6.123233995736766*^-17}, {-2.4492935982947064`*^-16, 
     1.}}]}, {LineBox[{{0.9238795325112867, -0.3826834323650897}, {0., 1.}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{
     0.9238795325112867, -0.3826834323650897}, {-0.38268343236508967`, \
-0.9238795325112868}}], 
    LineBox[{{
     0.9238795325112867, -0.3826834323650897}, {-0.7071067811865475, \
-0.7071067811865477}}], 
    LineBox[{{
     0.9238795325112867, -0.3826834323650897}, {-0.9238795325112865, \
-0.38268343236509034`}}], 
    LineBox[{{
     0.9238795325112867, -0.3826834323650897}, {-1., \
-1.8369701987210297`*^-16}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{0.9238795325112867, -0.3826834323650897}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{
     0.9238795325112867, -0.3826834323650897}, {-2.4492935982947064`*^-16, 
     1.}}]}, {LineBox[{{0.7071067811865476, -0.7071067811865475}, {0., 1.}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{
     0.7071067811865476, -0.7071067811865475}, {-0.38268343236508967`, \
-0.9238795325112868}}], 
    LineBox[{{
     0.7071067811865476, -0.7071067811865475}, {-0.7071067811865475, \
-0.7071067811865477}}], 
    LineBox[{{
     0.7071067811865476, -0.7071067811865475}, {-0.9238795325112865, \
-0.38268343236509034`}}], 
    LineBox[{{
     0.7071067811865476, -0.7071067811865475}, {-1., \
-1.8369701987210297`*^-16}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{0.7071067811865476, -0.7071067811865475}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{
     0.7071067811865476, -0.7071067811865475}, {-2.4492935982947064`*^-16, 
     1.}}]}, {LineBox[{{0.3826834323650899, -0.9238795325112867}, {0., 1.}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{
     0.3826834323650899, -0.9238795325112867}, {-0.38268343236508967`, \
-0.9238795325112868}}], 
    LineBox[{{
     0.3826834323650899, -0.9238795325112867}, {-0.7071067811865475, \
-0.7071067811865477}}], 
    LineBox[{{
     0.3826834323650899, -0.9238795325112867}, {-0.9238795325112865, \
-0.38268343236509034`}}], 
    LineBox[{{
     0.3826834323650899, -0.9238795325112867}, {-1., \
-1.8369701987210297`*^-16}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{0.3826834323650899, -0.9238795325112867}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{
     0.3826834323650899, -0.9238795325112867}, {-2.4492935982947064`*^-16, 
     1.}}]}, {LineBox[{{1.2246467991473532`*^-16, -1.}, {0., 1.}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {1., 6.123233995736766*^-17}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{
     1.2246467991473532`*^-16, -1.}, {-0.38268343236508967`, \
-0.9238795325112868}}], 
    LineBox[{{
     1.2246467991473532`*^-16, -1.}, {-0.7071067811865475, \
-0.7071067811865477}}], 
    LineBox[{{
     1.2246467991473532`*^-16, -1.}, {-0.9238795325112865, \
-0.38268343236509034`}}], 
    LineBox[{{
     1.2246467991473532`*^-16, -1.}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{1.2246467991473532`*^-16, -1.}, {-2.4492935982947064`*^-16, 
     1.}}]}, {LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {0., 
     1.}}], LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {
     0.3826834323650898, 0.9238795325112867}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {
     0.7071067811865475, 0.7071067811865476}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {
     0.9238795325112867, 0.38268343236508984`}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, \
{-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, \
{-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, \
{-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, {-1., \
-1.8369701987210297`*^-16}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, \
{-0.9238795325112866, 0.38268343236509}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, \
{-0.7071067811865477, 0.7071067811865474}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, \
{-0.3826834323650904, 0.9238795325112865}}], 
    LineBox[{{-0.38268343236508967`, -0.9238795325112868}, \
{-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {0., 1.}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, \
{-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, \
{-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, \
{-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {-1., \
-1.8369701987210297`*^-16}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {-0.9238795325112866,
      0.38268343236509}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {-0.7071067811865477,
      0.7071067811865474}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, {-0.3826834323650904,
      0.9238795325112865}}], 
    LineBox[{{-0.7071067811865475, -0.7071067811865477}, \
{-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {0., 1.}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {
     0.3826834323650898, 0.9238795325112867}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {
     0.7071067811865475, 0.7071067811865476}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {
     0.9238795325112867, 0.38268343236508984`}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, \
{-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, \
{-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, \
{-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, {-1., \
-1.8369701987210297`*^-16}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, \
{-0.9238795325112866, 0.38268343236509}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, \
{-0.7071067811865477, 0.7071067811865474}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, \
{-0.3826834323650904, 0.9238795325112865}}], 
    LineBox[{{-0.9238795325112865, -0.38268343236509034`}, \
{-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{-1., -1.8369701987210297`*^-16}, {0., 1.}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {1., 6.123233995736766*^-17}}],
     LineBox[{{-1., -1.8369701987210297`*^-16}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-0.38268343236508967`, \
-0.9238795325112868}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-0.7071067811865475, \
-0.7071067811865477}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-0.9238795325112865, \
-0.38268343236509034`}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-1., \
-1.8369701987210297`*^-16}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{-1., -1.8369701987210297`*^-16}, {-2.4492935982947064`*^-16, 
     1.}}]}, {LineBox[{{-0.9238795325112866, 0.38268343236509}, {0., 1.}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-0.9238795325112866, 
     0.38268343236509}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{-0.9238795325112866, 
     0.38268343236509}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{-0.9238795325112866, 
     0.38268343236509}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{-0.9238795325112866, 
     0.38268343236509}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{-0.9238795325112866, 0.38268343236509}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{-0.9238795325112866, 
     0.38268343236509}, {-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {0., 1.}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-0.7071067811865477, 
     0.7071067811865474}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{-0.7071067811865477, 
     0.7071067811865474}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{-0.7071067811865477, 
     0.7071067811865474}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{-0.7071067811865477, 
     0.7071067811865474}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{-0.7071067811865477, 0.7071067811865474}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{-0.7071067811865477, 
     0.7071067811865474}, {-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {0., 1.}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {1., 
     6.123233995736766*^-17}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-0.3826834323650904, 
     0.9238795325112865}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{-0.3826834323650904, 
     0.9238795325112865}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{-0.3826834323650904, 
     0.9238795325112865}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{-0.3826834323650904, 
     0.9238795325112865}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{-0.3826834323650904, 0.9238795325112865}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{-0.3826834323650904, 
     0.9238795325112865}, {-2.4492935982947064`*^-16, 1.}}]}, {
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {0., 1.}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {0.3826834323650898, 
     0.9238795325112867}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {0.7071067811865475, 
     0.7071067811865476}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {0.9238795325112867, 
     0.38268343236508984`}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {1., 6.123233995736766*^-17}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {
     0.9238795325112867, -0.3826834323650897}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {
     0.7071067811865476, -0.7071067811865475}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {
     0.3826834323650899, -0.9238795325112867}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {
     1.2246467991473532`*^-16, -1.}}], 
    LineBox[{{-2.4492935982947064`*^-16, 
     1.}, {-0.38268343236508967`, -0.9238795325112868}}], 
    LineBox[{{-2.4492935982947064`*^-16, 
     1.}, {-0.7071067811865475, -0.7071067811865477}}], 
    LineBox[{{-2.4492935982947064`*^-16, 
     1.}, {-0.9238795325112865, -0.38268343236509034`}}], 
    LineBox[{{-2.4492935982947064`*^-16, 
     1.}, {-1., -1.8369701987210297`*^-16}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {-0.9238795325112866, 
     0.38268343236509}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {-0.7071067811865477, 
     0.7071067811865474}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {-0.3826834323650904, 
     0.9238795325112865}}], 
    LineBox[{{-2.4492935982947064`*^-16, 1.}, {-2.4492935982947064`*^-16, 
     1.}}]}},
  AspectRatio->Automatic]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->353897834]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generalized Inner Product", "Subsection",
 CellTags->{"t:203", "c:34"},
 CellID->1622139970],

Cell[TextData[{
 "Matrix multiplication is a fundamental operation of linear algebra \
computation. Consequently, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " as a dedicated function, which is heavily optimized. However, a \
generalization of matrix multiplication is provided by ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 ". This allows the two operations that are used to form the product to be \
specified."
}], "Text",
 CellID->1001577125],

Cell["Here are two vectors.", "Text",
 CellID->1529914689],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec1", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec2", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1454472492],

Cell["This is the scalar product.", "Text",
 CellID->512819243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec1", ".", "vec2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1101141690],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}], "+", 
  RowBox[{"c", " ", "z"}]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2504129]
}, Open  ]],

Cell[TextData[{
 "This is the equivalent operation using ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 "."
}], "Text",
 CellID->719037736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Times", ",", "vec1", ",", "vec2", ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->976747283],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}], "+", 
  RowBox[{"c", " ", "z"}]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->180229987]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " is used instead of ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 "."
}], "Text",
 CellID->387979948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Power", ",", "vec1", ",", "vec2", ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1018633744],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "x"], "+", 
  SuperscriptBox["b", "y"], "+", 
  SuperscriptBox["c", "z"]}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->10294678]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Permutations", "Section",
 CellTags->{"t:149", "c:35"},
 CellID->1318022893],

Cell[TextData[{
 "Many matrix techniques rely on ordering a matrix in particular ways. For \
example, some techniques try to order the matrix to put elements on the \
diagonal, while others try to group certain elements into dense blocks. The \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " is very well suited to applying permutations to the rows and columns of a \
matrix."
}], "Text",
 CellID->716943846],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["perm", "TI"], "]", "]"}], Cell[
    "apply a permutation to the rows of a matrix", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["perm", "TI"], "]", "]"}], Cell[
    "apply a permutation to the columns of a matrix", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["perm", "TI"], ",", 
     StyleBox["perm", "TI"], "]", "]"}], Cell[
    "apply a permutation to the rows and columns of a matrix", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["perm", "TI"], "]", "]", "=", "m"}], Cell[
    "apply the inverse of a permutation to the rows of a matrix", 
     "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["perm", "TI"], "]", "]", "=", "m"}], Cell["\<\
apply the inverse of a permutation to the columns of a matrix\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->144476405],

Cell["Applying permutations to matrices. ", "Caption",
 CellID->1558417725],

Cell["This generates a random matrix.", "Text",
 CellID->1616145263],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1180267985],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "2", "0", "2"},
     {"1", "0", "1", "0"},
     {"3", "3", "2", "3"},
     {"0", "1", "0", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$894]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->140747375]
}, Open  ]],

Cell[TextData[{
 "Now the matrix will be reordered so that the rows are ordered by increasing \
size of 2-norm. (",
 "Norms are discussed under ",
 ButtonBox["Matrix Computations: Norms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#832278785"],
 ".) First, the norm of each row is computed."
}], "Text",
 CellID->350236785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", " ", 
  RowBox[{"Norm", ",", " ", "mat"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->176969068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox["3"]}], ",", 
   SqrtBox["2"], ",", 
   SqrtBox["31"], ",", 
   SqrtBox["10"]}], "}"}]], "Output",
 ImageSize->{172, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->844156533]
}, Open  ]],

Cell["\<\
This computes the permutation that puts the smallest numbers first.\
\>", "Text",
 CellID->1663177939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "=", 
  RowBox[{"Ordering", "[", 
   RowBox[{"%", ",", "All", ",", "Less"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1384471421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->547671074]
}, Open  ]],

Cell["\<\
This applies the ordering to the rows of the matrix; the result has rows \
ordered by increasing size of 2-norm.\
\>", "Text",
 CellID->1000225553],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pmat", "=", 
   RowBox[{"mat", "[", 
    RowBox[{"[", "perm", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"pmat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->288880555],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "1", "0"},
     {"0", "1", "0", "3"},
     {"2", "2", "0", "2"},
     {"3", "3", "2", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$900]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->223341484]
}, Open  ]],

Cell[TextData[{
 "Now the inverse permutation is applied by using part assignment. Note that \
this modifies the matrix held by the symbol ",
 StyleBox["pmat", "MR"],
 ". Part assignment is described ",
 ButtonBox["previously",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1626148827"],
 "."
}], "Text",
 CellID->520271472],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"pmat", "[", 
    RowBox[{"[", "perm", "]"}], "]"}], "=", "pmat"}], ";"}], "\n", 
 RowBox[{"pmat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1796702967],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "2", "0", "2"},
     {"1", "0", "1", "0"},
     {"3", "3", "2", "3"},
     {"0", "1", "0", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$904]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->482660308]
}, Open  ]],

Cell["\<\
If the inverse permutation is applied to the permuted matrix, the original \
matrix is restored.\
\>", "Text",
 CellID->492727685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pmat", "\[Equal]", "mat"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->577258963],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->620795759]
}, Open  ]],

Cell[CellGroupData[{

Cell["Permutation Matrices", "Subsection",
 CellTags->{"t:204", "c:36"},
 CellID->384051338],

Cell["\<\
Another way to work with permutations is to compute a matrix that applies the \
permutation by multiplication. For example, this builds a 4\[Times]4 matrix.\
\>", "Text",
 CellID->1562478531],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1146635001],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "2", "3", "0"},
     {"2", "3", "1", "0"},
     {"0", "1", "1", "3"},
     {"3", "2", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$910]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->126426707]
}, Open  ]],

Cell["\<\
This computes the permutation necessary to order the rows according to \
ascending 2-norm.\
\>", "Text",
 CellID->1801904592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "=", 
  RowBox[{"Ordering", "[", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"Norm", ",", "mat"}], "]"}], ",", "All", ",", "Less"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->796087750],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1", ",", "4", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->256854692]
}, Open  ]],

Cell[TextData[{
 "The permutation matrix is typically a sparse matrix, which is discussed \
under \"",
 ButtonBox["Working with Sparse Arrays",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#1619024906"],
 "\" . This input generates a sparse identity matrix."
}], "Text",
 CellID->1724149963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1791579170],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->130763788]
}, Open  ]],

Cell["\<\
If the permutation is applied to the identity matrix, a permutation matrix is \
generated.\
\>", "Text",
 CellID->655346763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"permMat", "=", 
  RowBox[{"sp", "[", 
   RowBox[{"[", "perm", "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2116903925],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->306846570]
}, Open  ]],

Cell["\<\
This applies the permutation. Note that the rows with smallest norms are at \
the top.\
\>", "Text",
 CellID->13071905],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pmat", "=", 
   RowBox[{"permMat", ".", "mat"}]}], ";"}], "\n", 
 RowBox[{"pmat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->656175341],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "1", "1", "3"},
     {"0", "2", "3", "0"},
     {"3", "2", "1", "0"},
     {"2", "3", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$917]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->737919835]
}, Open  ]],

Cell["This applies the inverse permutation.", "Text",
 CellID->2124350665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "permMat", "]"}], ".", "pmat"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->2045995280],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "2", "3", "0"},
     {"2", "3", "1", "0"},
     {"0", "1", "1", "3"},
     {"3", "2", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$921]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->14801468]
}, Open  ]],

Cell[TextData[{
 "Typically it is faster to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " to apply a permutation, but sometimes it is convenient to work with a \
permutation matrix."
}], "Text",
 CellID->1465782349],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->49963858],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "TutorialMoreAbout",
 CellID->4791866],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->274735117],

Cell[TextData[{
 ButtonBox["Linear Algebra in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->315063104],

Cell[TextData[ButtonBox["Matrix and Tensor Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"]], \
"RelatedTutorials",
 CellID->3571032],

Cell[TextData[ButtonBox["Working with Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays"]], "RelatedTutorials",\

 CellID->560755906],

Cell[TextData[ButtonBox["Matrix Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations"]], "RelatedTutorials",
 CellID->335456077],

Cell[TextData[ButtonBox["Matrix Types",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes"]], "RelatedTutorials",\

 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrix and Tensor Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 35.8819646}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This tutorial will review the functions that Mathematica provides for \
building and working with matrices, vectors, and tensors. It will focus on \
functions that are specific to Mathematica, and will use matrices for many of \
the examples. However, all of the functions are general, and they will also \
work for vectors and tensors. Matrices are represented in Mathematica with \
lists. They can be entered directly with the { } notation that Mathematica \
provides for lists. An example of a matrix is shown below; by default a \
matrix prints with the list notation. Mathematica provides a number of ways \
to build matrices.", "synonyms" -> {}, "title" -> 
    "Matrix and Tensor Operations", "type" -> "Tutorial", "uri" -> 
    "tutorial/LinearAlgebraMatrixAndTensorOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:3"->{
  Cell[6328, 132, 93, 2, 70, "Title",
   CellTags->{"t:3", "c:6"},
   CellID->1023128168]},
 "c:6"->{
  Cell[6328, 132, 93, 2, 70, "Title",
   CellTags->{"t:3", "c:6"},
   CellID->1023128168]},
 "t:4"->{
  Cell[6918, 151, 83, 2, 70, "Section",
   CellTags->{"t:4", "c:7"},
   CellID->441715480]},
 "c:7"->{
  Cell[6918, 151, 83, 2, 70, "Section",
   CellTags->{"t:4", "c:7"},
   CellID->441715480]},
 "S3.7.1"->{
  Cell[8102, 200, 5685, 195, 70, "DefinitionBox",
   CellTags->"S3.7.1",
   CellID->3844608],
  Cell[24019, 736, 162, 5, 70, "Text",
   CellTags->{"S3.7.1", "1.8"},
   CellID->1269425995],
  Cell[24962, 774, 155, 5, 70, "Text",
   CellTags->{"S3.7.1", "1.8"},
   CellID->308650782],
  Cell[25938, 815, 454, 13, 70, "Text",
   CellTags->{"S3.7.1", "1.6"},
   CellID->1885957666],
  Cell[27303, 865, 1840, 65, 70, "DefinitionBox",
   CellTags->"S3.7.1",
   CellID->2050257696],
  Cell[29146, 932, 251, 9, 70, "Caption",
   CellTags->"S3.7.1",
   CellID->158496910],
  Cell[29400, 943, 114, 2, 70, "Text",
   CellTags->{"S3.7.1", "1.9"},
   CellID->977844090],
  Cell[29539, 949, 143, 3, 28, "Input",
   CellTags->"S3.7.1",
   CellID->2080753786],
  Cell[29685, 954, 1128, 23, 78, "Output",
   Evaluatable->False,
   CellTags->"S3.7.1",
   CellID->465688059]},
 "1.8"->{
  Cell[24019, 736, 162, 5, 70, "Text",
   CellTags->{"S3.7.1", "1.8"},
   CellID->1269425995],
  Cell[24962, 774, 155, 5, 70, "Text",
   CellTags->{"S3.7.1", "1.8"},
   CellID->308650782]},
 "1.6"->{
  Cell[25938, 815, 454, 13, 70, "Text",
   CellTags->{"S3.7.1", "1.6"},
   CellID->1885957666]},
 "1.9"->{
  Cell[29400, 943, 114, 2, 70, "Text",
   CellTags->{"S3.7.1", "1.9"},
   CellID->977844090]},
 "t:102"->{
  Cell[31130, 993, 88, 2, 70, "Subsection",
   CellTags->{"t:102", "c:8"},
   CellID->1887778180]},
 "c:8"->{
  Cell[31130, 993, 88, 2, 70, "Subsection",
   CellTags->{"t:102", "c:8"},
   CellID->1887778180]},
 "S5.48.1"->{
  Cell[31379, 1004, 2829, 93, 70, "DefinitionBox",
   CellTags->"S5.48.1",
   CellID->648823418],
  Cell[34211, 1099, 80, 2, 70, "Caption",
   CellTags->"S5.48.1",
   CellID->2000710507],
  Cell[34294, 1103, 105, 2, 70, "Text",
   CellTags->{"S5.48.1", "1.20"},
   CellID->559898982],
  Cell[34424, 1109, 116, 3, 28, "Input",
   CellTags->"S5.48.1",
   CellID->2096332967],
  Cell[34543, 1114, 920, 20, 80, "Output",
   Evaluatable->False,
   CellTags->"S5.48.1",
   CellID->113664022],
  Cell[35478, 1137, 127, 2, 70, "Text",
   CellTags->{"S5.48.1", "1.21"},
   CellID->1483441136],
  Cell[35630, 1143, 121, 3, 70, "Input",
   CellTags->"S5.48.1",
   CellID->2057514729],
  Cell[35754, 1148, 839, 25, 92, "Output",
   CellTags->"S5.48.1",
   CellID->811142667],
  Cell[36608, 1176, 327, 7, 70, "Text",
   CellTags->{"S5.48.1", "1.22"},
   CellID->1126668929],
  Cell[36960, 1187, 132, 3, 70, "Input",
   CellTags->"S5.48.1",
   CellID->1561374104],
  Cell[37095, 1192, 819, 25, 92, "Output",
   CellTags->"S5.48.1",
   CellID->544037929]},
 "1.20"->{
  Cell[34294, 1103, 105, 2, 70, "Text",
   CellTags->{"S5.48.1", "1.20"},
   CellID->559898982]},
 "1.21"->{
  Cell[35478, 1137, 127, 2, 70, "Text",
   CellTags->{"S5.48.1", "1.21"},
   CellID->1483441136]},
 "1.22"->{
  Cell[36608, 1176, 327, 7, 70, "Text",
   CellTags->{"S5.48.1", "1.22"},
   CellID->1126668929]},
 "t:6"->{
  Cell[37975, 1224, 87, 2, 70, "Section",
   CellTags->{"t:6", "c:9"},
   CellID->223720584]},
 "c:9"->{
  Cell[37975, 1224, 87, 2, 70, "Section",
   CellTags->{"t:6", "c:9"},
   CellID->223720584]},
 "t:7"->{
  Cell[38375, 1239, 97, 2, 70, "Subsection",
   CellTags->{"t:7", "c:10"},
   CellID->1678167046]},
 "c:10"->{
  Cell[38375, 1239, 97, 2, 70, "Subsection",
   CellTags->{"t:7", "c:10"},
   CellID->1678167046]},
 "S3.7.2"->{
  Cell[39041, 1266, 3334, 121, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->785100947],
  Cell[42378, 1389, 93, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->1052089061],
  Cell[59228, 1976, 4185, 150, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->1922393630],
  Cell[63416, 2128, 89, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->778270295],
  Cell[91825, 2890, 2518, 93, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->298293044],
  Cell[94346, 2985, 84, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->223768693],
  Cell[102887, 3236, 2742, 115, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->143750586],
  Cell[105632, 3353, 86, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->96996027],
  Cell[112673, 3561, 77, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->421428447],
  Cell[203310, 6881, 216, 9, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->533611388]},
 "c:11"->{
  Cell[53758, 1778, 87, 2, 70, "Subsubsection",
   CellTags->"c:11",
   CellID->288135948]},
 "t:9"->{
  Cell[58752, 1958, 97, 2, 70, "Subsection",
   CellTags->{"t:9", "c:12"},
   CellID->1626148827]},
 "c:12"->{
  Cell[58752, 1958, 97, 2, 70, "Subsection",
   CellTags->{"t:9", "c:12"},
   CellID->1626148827]},
 "c:13"->{
  Cell[76060, 2471, 87, 2, 70, "Subsubsection",
   CellTags->"c:13",
   CellID->289617502]},
 "t:8"->{
  Cell[91642, 2883, 92, 2, 70, "Subsection",
   CellTags->{"t:8", "c:14"},
   CellID->849568979]},
 "c:14"->{
  Cell[91642, 2883, 92, 2, 70, "Subsection",
   CellTags->{"t:8", "c:14"},
   CellID->849568979]},
 "t:179"->{
  Cell[102564, 3222, 98, 2, 70, "Subsection",
   CellTags->{"t:179", "c:15"},
   CellID->2028205186]},
 "c:15"->{
  Cell[102564, 3222, 98, 2, 70, "Subsection",
   CellTags->{"t:179", "c:15"},
   CellID->2028205186]},
 "t:223"->{
  Cell[111759, 3524, 98, 2, 70, "Subsection",
   CellTags->{"t:223", "c:16"},
   CellID->964961827]},
 "c:16"->{
  Cell[111759, 3524, 98, 2, 70, "Subsection",
   CellTags->{"t:223", "c:16"},
   CellID->964961827]},
 "S3.7.3"->{
  Cell[112076, 3538, 594, 21, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->786341155],
  Cell[135409, 4344, 1196, 41, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->1672332354],
  Cell[136608, 4387, 138, 4, 70, "Caption",
   CellTags->"S3.7.3",
   CellID->623901742],
  Cell[143230, 4663, 2555, 91, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->1514164463],
  Cell[180454, 6088, 2413, 84, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->55406717],
  Cell[182870, 6174, 139, 4, 70, "Caption",
   CellTags->"S3.7.3",
   CellID->1360273468],
  Cell[192081, 6558, 682, 23, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->1601493378],
  Cell[224488, 7371, 665, 21, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->2108583965]},
 "t:10"->{
  Cell[118809, 3717, 89, 2, 70, "Subsection",
   CellTags->{"t:10", "c:17"},
   CellID->782554218]},
 "c:17"->{
  Cell[118809, 3717, 89, 2, 70, "Subsection",
   CellTags->{"t:10", "c:17"},
   CellID->782554218]},
 "t:11"->{
  Cell[125161, 3948, 79, 2, 70, "Subsection",
   CellTags->{"t:11", "c:18"},
   CellID->11316850]},
 "c:18"->{
  Cell[125161, 3948, 79, 2, 70, "Subsection",
   CellTags->{"t:11", "c:18"},
   CellID->11316850]},
 "t:12"->{
  Cell[129974, 4142, 88, 2, 70, "Subsection",
   CellTags->{"t:12", "c:19"},
   CellID->654023951]},
 "c:19"->{
  Cell[129974, 4142, 88, 2, 70, "Subsection",
   CellTags->{"t:12", "c:19"},
   CellID->654023951]},
 "t:13"->{
  Cell[135128, 4332, 88, 2, 70, "Subsection",
   CellTags->{"t:13", "c:20"},
   CellID->1736222906]},
 "c:20"->{
  Cell[135128, 4332, 88, 2, 70, "Subsection",
   CellTags->{"t:13", "c:20"},
   CellID->1736222906]},
 "t:23"->{
  Cell[142977, 4653, 100, 2, 70, "Subsection",
   CellTags->{"t:23", "c:21"},
   CellID->528156332]},
 "c:21"->{
  Cell[142977, 4653, 100, 2, 70, "Subsection",
   CellTags->{"t:23", "c:21"},
   CellID->528156332]},
 "t:15"->{
  Cell[150623, 4953, 92, 2, 70, "Section",
   CellTags->{"t:15", "c:22"},
   CellID->1701521313]},
 "c:22"->{
  Cell[150623, 4953, 92, 2, 70, "Section",
   CellTags->{"t:15", "c:22"},
   CellID->1701521313]},
 "t:16"->{
  Cell[162772, 5393, 82, 2, 70, "Subsection",
   CellTags->{"t:16", "c:23"},
   CellID->540401315]},
 "c:23"->{
  Cell[162772, 5393, 82, 2, 70, "Subsection",
   CellTags->{"t:16", "c:23"},
   CellID->540401315]},
 "t:17"->{
  Cell[165164, 5493, 74, 2, 70, "Subsection",
   CellTags->{"t:17", "c:24"},
   CellID->188079645]},
 "c:24"->{
  Cell[165164, 5493, 74, 2, 70, "Subsection",
   CellTags->{"t:17", "c:24"},
   CellID->188079645]},
 "t:18"->{
  Cell[167475, 5592, 87, 2, 70, "Section",
   CellTags->{"t:18", "c:25"},
   CellID->112899229]},
 "c:25"->{
  Cell[167475, 5592, 87, 2, 70, "Section",
   CellTags->{"t:18", "c:25"},
   CellID->112899229]},
 "S1.8.3"->{
  Cell[168763, 5640, 3475, 122, 70, "DefinitionBox",
   CellTags->"S1.8.3",
   CellID->730775500],
  Cell[172241, 5764, 94, 2, 70, "Caption",
   CellTags->"S1.8.3",
   CellID->684851307]},
 "c:26"->{
  Cell[180160, 6076, 89, 2, 70, "Subsection",
   CellTags->"c:26",
   CellID->1062677296]},
 "t:19"->{
  Cell[191844, 6548, 94, 2, 70, "Section",
   CellTags->{"t:19", "c:27"},
   CellID->1361817013]},
 "c:27"->{
  Cell[191844, 6548, 94, 2, 70, "Section",
   CellTags->{"t:19", "c:27"},
   CellID->1361817013]},
 "t:20"->{
  Cell[192788, 6585, 91, 2, 70, "Subsection",
   CellTags->{"t:20", "c:28"},
   CellID->1886656195]},
 "c:28"->{
  Cell[192788, 6585, 91, 2, 70, "Subsection",
   CellTags->{"t:20", "c:28"},
   CellID->1886656195]},
 "t:22"->{
  Cell[197087, 6702, 89, 2, 70, "Subsection",
   CellTags->{"t:22", "c:29"},
   CellID->1336717728]},
 "c:29"->{
  Cell[197087, 6702, 89, 2, 70, "Subsection",
   CellTags->{"t:22", "c:29"},
   CellID->1336717728]},
 "S5.27.1"->{
  Cell[201523, 6823, 1784, 56, 70, "DefinitionBox3Col",
   CellTags->"S5.27.1",
   CellID->2043508037]},
 "t:21"->{
  Cell[224246, 7361, 98, 2, 70, "Section",
   CellTags->{"t:21", "c:30"},
   CellID->2053293398]},
 "c:30"->{
  Cell[224246, 7361, 98, 2, 70, "Section",
   CellTags->{"t:21", "c:30"},
   CellID->2053293398]},
 "t:24"->{
  Cell[234160, 7682, 90, 2, 70, "Section",
   CellTags->{"t:24", "c:31"},
   CellID->1896011669]},
 "c:31"->{
  Cell[234160, 7682, 90, 2, 70, "Section",
   CellTags->{"t:24", "c:31"},
   CellID->1896011669]},
 "t:201"->{
  Cell[250856, 8270, 85, 2, 70, "Subsection",
   CellTags->{"t:201", "c:32"},
   CellID->520172951]},
 "c:32"->{
  Cell[250856, 8270, 85, 2, 70, "Subsection",
   CellTags->{"t:201", "c:32"},
   CellID->520172951]},
 "t:202"->{
  Cell[254510, 8390, 110, 2, 70, "Subsubsection",
   CellTags->{"t:202", "c:33"},
   CellID->1814519952]},
 "c:33"->{
  Cell[254510, 8390, 110, 2, 70, "Subsubsection",
   CellTags->{"t:202", "c:33"},
   CellID->1814519952]},
 "t:203"->{
  Cell[284737, 9010, 98, 2, 70, "Subsection",
   CellTags->{"t:203", "c:34"},
   CellID->1622139970]},
 "c:34"->{
  Cell[284737, 9010, 98, 2, 70, "Subsection",
   CellTags->{"t:203", "c:34"},
   CellID->1622139970]},
 "t:149"->{
  Cell[287794, 9141, 89, 2, 70, "Section",
   CellTags->{"t:149", "c:35"},
   CellID->1318022893]},
 "c:35"->{
  Cell[287794, 9141, 89, 2, 70, "Section",
   CellTags->{"t:149", "c:35"},
   CellID->1318022893]},
 "t:204"->{
  Cell[295599, 9426, 92, 2, 70, "Subsection",
   CellTags->{"t:204", "c:36"},
   CellID->384051338]},
 "c:36"->{
  Cell[295599, 9426, 92, 2, 70, "Subsection",
   CellTags->{"t:204", "c:36"},
   CellID->384051338]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:3", 305814, 9786},
 {"c:6", 305916, 9790},
 {"t:4", 306018, 9794},
 {"c:7", 306121, 9798},
 {"S3.7.1", 306227, 9802},
 {"1.8", 307095, 9831},
 {"1.6", 307295, 9838},
 {"1.9", 307402, 9842},
 {"t:102", 307509, 9846},
 {"c:8", 307619, 9850},
 {"S5.48.1", 307733, 9854},
 {"1.20", 308786, 9889},
 {"1.21", 308895, 9893},
 {"1.22", 309005, 9897},
 {"t:6", 309114, 9901},
 {"c:9", 309219, 9905},
 {"t:7", 309324, 9909},
 {"c:10", 309435, 9913},
 {"S3.7.2", 309548, 9917},
 {"c:11", 310485, 9948},
 {"t:9", 310588, 9952},
 {"c:12", 310699, 9956},
 {"c:13", 310810, 9960},
 {"t:8", 310913, 9964},
 {"c:14", 311023, 9968},
 {"t:179", 311134, 9972},
 {"c:15", 311248, 9976},
 {"t:223", 311363, 9980},
 {"c:16", 311476, 9984},
 {"S3.7.3", 311591, 9988},
 {"t:10", 312372, 10013},
 {"c:17", 312484, 10017},
 {"t:11", 312596, 10021},
 {"c:18", 312707, 10025},
 {"t:12", 312818, 10029},
 {"c:19", 312930, 10033},
 {"t:13", 313042, 10037},
 {"c:20", 313155, 10041},
 {"t:23", 313268, 10045},
 {"c:21", 313381, 10049},
 {"t:15", 313494, 10053},
 {"c:22", 313604, 10057},
 {"t:16", 313714, 10061},
 {"c:23", 313826, 10065},
 {"t:17", 313938, 10069},
 {"c:24", 314050, 10073},
 {"t:18", 314162, 10077},
 {"c:25", 314271, 10081},
 {"S1.8.3", 314382, 10085},
 {"c:26", 314582, 10092},
 {"t:19", 314685, 10096},
 {"c:27", 314795, 10100},
 {"t:20", 314905, 10104},
 {"c:28", 315018, 10108},
 {"t:22", 315131, 10112},
 {"c:29", 315244, 10116},
 {"S5.27.1", 315360, 10120},
 {"t:21", 315476, 10124},
 {"c:30", 315586, 10128},
 {"t:24", 315696, 10132},
 {"c:31", 315806, 10136},
 {"t:201", 315917, 10140},
 {"c:32", 316030, 10144},
 {"t:202", 316144, 10148},
 {"c:33", 316262, 10152},
 {"t:203", 316381, 10156},
 {"c:34", 316495, 10160},
 {"t:149", 316610, 10164},
 {"c:35", 316721, 10168},
 {"t:204", 316833, 10172},
 {"c:36", 316946, 10176}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5703, 105, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6328, 132, 93, 2, 70, "Title",
 CellTags->{"t:3", "c:6"},
 CellID->1023128168],
Cell[6424, 136, 469, 11, 70, "Text",
 CellID->813558047],
Cell[CellGroupData[{
Cell[6918, 151, 83, 2, 70, "Section",
 CellTags->{"t:4", "c:7"},
 CellID->441715480],
Cell[7004, 155, 369, 10, 70, "Text",
 CellID->61104681],
Cell[CellGroupData[{
Cell[7398, 169, 225, 8, 30, "InputOnly",
 CellID->489190301],
Cell[7626, 179, 313, 11, 36, "Output",
 CellID->78477768]
}, Open  ]],
Cell[7954, 193, 145, 5, 70, "Text",
 CellID->375014479],
Cell[8102, 200, 5685, 195, 70, "DefinitionBox",
 CellTags->"S3.7.1",
 CellID->3844608],
Cell[13790, 397, 563, 17, 70, "Text",
 CellID->191817246],
Cell[CellGroupData[{
Cell[14378, 418, 312, 11, 28, "Input",
 CellID->499499375],
Cell[14693, 431, 829, 18, 36, "Output",
 Evaluatable->False,
 CellID->83493786]
}, Open  ]],
Cell[15537, 452, 92, 1, 70, "Text",
 CellID->2075315201],
Cell[CellGroupData[{
Cell[15654, 457, 106, 3, 28, "Input",
 CellID->393188633],
Cell[15763, 462, 1041, 21, 80, "Output",
 Evaluatable->False,
 CellID->385390372]
}, Open  ]],
Cell[16819, 486, 324, 11, 70, "Text",
 CellID->231617156],
Cell[CellGroupData[{
Cell[17168, 501, 174, 6, 70, "Input",
 CellID->1549172528],
Cell[17345, 509, 912, 31, 36, "Output",
 CellID->21116938]
}, Open  ]],
Cell[18272, 543, 205, 6, 70, "Text",
 CellID->1686370103],
Cell[CellGroupData[{
Cell[18502, 553, 110, 3, 70, "Input",
 CellID->333148015],
Cell[18615, 558, 632, 18, 36, "Output",
 CellID->184395067]
}, Open  ]],
Cell[19262, 579, 765, 17, 70, "Text",
 CellID->37336944],
Cell[CellGroupData[{
Cell[20052, 600, 138, 4, 70, "Input",
 CellID->456792884],
Cell[20193, 606, 698, 22, 54, "Output",
 CellID->421690127]
}, Open  ]],
Cell[20906, 631, 75, 1, 70, "Text",
 CellID->1290418441],
Cell[CellGroupData[{
Cell[21006, 636, 182, 5, 70, "Input",
 CellID->625386834],
Cell[21191, 643, 500, 15, 36, "Output",
 CellID->512026402]
}, Open  ]],
Cell[21706, 661, 255, 7, 70, "Text"],
Cell[CellGroupData[{
Cell[21986, 672, 221, 7, 28, "Input"],
Cell[22210, 681, 885, 18, 108, "Output",
 Evaluatable->False,
 CellID->654308855]
}, Open  ]],
Cell[23110, 702, 74, 2, 70, "Text"],
Cell[CellGroupData[{
Cell[23209, 708, 161, 5, 70, "Input"],
Cell[23373, 715, 631, 18, 36, "Output",
 CellID->20997071]
}, Open  ]],
Cell[24019, 736, 162, 5, 70, "Text",
 CellTags->{"S3.7.1", "1.8"},
 CellID->1269425995],
Cell[CellGroupData[{
Cell[24206, 745, 229, 8, 70, "Input",
 CellID->2140148667],
Cell[24438, 755, 509, 16, 36, "Output",
 CellID->164445120]
}, Open  ]],
Cell[24962, 774, 155, 5, 70, "Text",
 CellTags->{"S3.7.1", "1.8"},
 CellID->308650782],
Cell[CellGroupData[{
Cell[25142, 783, 251, 9, 70, "Input",
 CellID->76716924],
Cell[25396, 794, 527, 18, 36, "Output",
 CellID->714917963]
}, Open  ]],
Cell[25938, 815, 454, 13, 70, "Text",
 CellTags->{"S3.7.1", "1.6"},
 CellID->1885957666],
Cell[CellGroupData[{
Cell[26417, 832, 447, 15, 70, "Input",
 CellID->431862742],
Cell[26867, 849, 421, 13, 36, "Output",
 CellID->87306648]
}, Open  ]],
Cell[27303, 865, 1840, 65, 70, "DefinitionBox",
 CellTags->"S3.7.1",
 CellID->2050257696],
Cell[29146, 932, 251, 9, 70, "Caption",
 CellTags->"S3.7.1",
 CellID->158496910],
Cell[29400, 943, 114, 2, 70, "Text",
 CellTags->{"S3.7.1", "1.9"},
 CellID->977844090],
Cell[CellGroupData[{
Cell[29539, 949, 143, 3, 28, "Input",
 CellTags->"S3.7.1",
 CellID->2080753786],
Cell[29685, 954, 1128, 23, 78, "Output",
 Evaluatable->False,
 CellTags->"S3.7.1",
 CellID->465688059]
}, Open  ]],
Cell[30828, 980, 277, 9, 70, "Text",
 CellID->1462348464],
Cell[CellGroupData[{
Cell[31130, 993, 88, 2, 70, "Subsection",
 CellTags->{"t:102", "c:8"},
 CellID->1887778180],
Cell[31221, 997, 155, 5, 70, "Text",
 CellID->964470482],
Cell[31379, 1004, 2829, 93, 70, "DefinitionBox",
 CellTags->"S5.48.1",
 CellID->648823418],
Cell[34211, 1099, 80, 2, 70, "Caption",
 CellTags->"S5.48.1",
 CellID->2000710507],
Cell[34294, 1103, 105, 2, 70, "Text",
 CellTags->{"S5.48.1", "1.20"},
 CellID->559898982],
Cell[CellGroupData[{
Cell[34424, 1109, 116, 3, 28, "Input",
 CellTags->"S5.48.1",
 CellID->2096332967],
Cell[34543, 1114, 920, 20, 80, "Output",
 Evaluatable->False,
 CellTags->"S5.48.1",
 CellID->113664022]
}, Open  ]],
Cell[35478, 1137, 127, 2, 70, "Text",
 CellTags->{"S5.48.1", "1.21"},
 CellID->1483441136],
Cell[CellGroupData[{
Cell[35630, 1143, 121, 3, 70, "Input",
 CellTags->"S5.48.1",
 CellID->2057514729],
Cell[35754, 1148, 839, 25, 92, "Output",
 CellTags->"S5.48.1",
 CellID->811142667]
}, Open  ]],
Cell[36608, 1176, 327, 7, 70, "Text",
 CellTags->{"S5.48.1", "1.22"},
 CellID->1126668929],
Cell[CellGroupData[{
Cell[36960, 1187, 132, 3, 70, "Input",
 CellTags->"S5.48.1",
 CellID->1561374104],
Cell[37095, 1192, 819, 25, 92, "Output",
 CellTags->"S5.48.1",
 CellID->544037929]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37975, 1224, 87, 2, 70, "Section",
 CellTags->{"t:6", "c:9"},
 CellID->223720584],
Cell[38065, 1228, 285, 7, 70, "Text",
 CellID->1975473038],
Cell[CellGroupData[{
Cell[38375, 1239, 97, 2, 70, "Subsection",
 CellTags->{"t:7", "c:10"},
 CellID->1678167046],
Cell[38475, 1243, 563, 21, 70, "Text",
 CellID->2050806071],
Cell[39041, 1266, 3334, 121, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->785100947],
Cell[42378, 1389, 93, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->1052089061],
Cell[42474, 1393, 63, 1, 70, "Text",
 CellID->80498829],
Cell[CellGroupData[{
Cell[42562, 1398, 388, 13, 49, "InputOnly",
 CellID->29121393],
Cell[42953, 1413, 1500, 28, 112, "Output",
 Evaluatable->False,
 CellID->258094810]
}, Open  ]],
Cell[44468, 1444, 83, 1, 70, "Text",
 CellID->1337598596],
Cell[CellGroupData[{
Cell[44576, 1449, 147, 5, 70, "Input",
 CellID->1160786176],
Cell[44726, 1456, 201, 7, 36, "Output",
 CellID->48821821]
}, Open  ]],
Cell[44942, 1466, 151, 7, 70, "Text",
 CellID->210891662],
Cell[CellGroupData[{
Cell[45118, 1477, 123, 4, 70, "Input",
 CellID->1108145684],
Cell[45244, 1483, 473, 17, 36, "Output",
 CellID->20519402]
}, Open  ]],
Cell[45732, 1503, 223, 8, 70, "Text",
 CellID->459037612],
Cell[CellGroupData[{
Cell[45980, 1515, 149, 5, 70, "Input",
 CellID->1283884860],
Cell[46132, 1522, 473, 17, 36, "Output",
 CellID->12257182]
}, Open  ]],
Cell[46620, 1542, 160, 4, 70, "Text",
 CellID->1535233162],
Cell[CellGroupData[{
Cell[46805, 1550, 186, 7, 70, "Input",
 CellID->647735029],
Cell[46994, 1559, 201, 7, 36, "Output",
 CellID->89196877]
}, Open  ]],
Cell[47210, 1569, 179, 5, 70, "Text",
 CellID->507977834],
Cell[CellGroupData[{
Cell[47414, 1578, 147, 5, 28, "Input",
 CellID->432468603],
Cell[47564, 1585, 1147, 23, 36, "Output",
 Evaluatable->False,
 CellID->262982233]
}, Open  ]],
Cell[48726, 1611, 84, 1, 70, "Text",
 CellID->148521699],
Cell[CellGroupData[{
Cell[48835, 1616, 175, 6, 28, "Input",
 CellID->368642283],
Cell[49013, 1624, 1164, 23, 54, "Output",
 Evaluatable->False,
 CellID->418015694]
}, Open  ]],
Cell[50192, 1650, 91, 1, 70, "Text",
 CellID->299733056],
Cell[CellGroupData[{
Cell[50308, 1655, 206, 7, 28, "Input",
 CellID->31191635],
Cell[50517, 1664, 1187, 24, 54, "Output",
 Evaluatable->False,
 CellID->6022287]
}, Open  ]],
Cell[51719, 1691, 257, 9, 70, "Text",
 CellID->37601670],
Cell[CellGroupData[{
Cell[52001, 1704, 77, 2, 70, "Input",
 CellID->611075472],
Cell[52081, 1708, 419, 15, 36, "Output",
 CellID->1078657950]
}, Open  ]],
Cell[52515, 1726, 410, 13, 70, "Text",
 CellID->2094701323],
Cell[CellGroupData[{
Cell[52950, 1743, 104, 3, 70, "Input",
 CellID->1945710390],
Cell[53057, 1748, 452, 16, 36, "Output",
 CellID->1821031861]
}, Open  ]],
Cell[53524, 1767, 209, 7, 70, "Text",
 CellID->145550783],
Cell[CellGroupData[{
Cell[53758, 1778, 87, 2, 70, "Subsubsection",
 CellTags->"c:11",
 CellID->288135948],
Cell[53848, 1782, 176, 4, 70, "Text",
 CellID->125254051],
Cell[CellGroupData[{
Cell[54049, 1790, 385, 13, 47, "Input",
 CellID->610861097],
Cell[54437, 1805, 1500, 28, 112, "Output",
 Evaluatable->False,
 CellID->310541404]
}, Open  ]],
Cell[55952, 1836, 111, 3, 70, "Text",
 CellID->1207075054],
Cell[CellGroupData[{
Cell[56088, 1843, 196, 7, 70, "Input",
 CellID->32419369],
Cell[56287, 1852, 298, 11, 36, "Output",
 CellID->32169338]
}, Open  ]],
Cell[56600, 1866, 82, 1, 70, "Text",
 CellID->195973197],
Cell[CellGroupData[{
Cell[56707, 1871, 172, 6, 70, "Input",
 CellID->1629091128],
Cell[56882, 1879, 882, 31, 36, "Output",
 CellID->150843666]
}, Open  ]],
Cell[57779, 1913, 125, 4, 70, "Text",
 CellID->1419005051],
Cell[CellGroupData[{
Cell[57929, 1921, 249, 9, 70, "Input",
 CellID->1411992222],
Cell[58181, 1932, 510, 19, 36, "Output",
 CellID->400546248]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58752, 1958, 97, 2, 70, "Subsection",
 CellTags->{"t:9", "c:12"},
 CellID->1626148827],
Cell[58852, 1962, 373, 12, 70, "Text",
 CellID->1806443667],
Cell[59228, 1976, 4185, 150, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->1922393630],
Cell[63416, 2128, 89, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->778270295],
Cell[63508, 2132, 63, 1, 70, "Text",
 CellID->65954188],
Cell[CellGroupData[{
Cell[63596, 2137, 385, 13, 47, "Input",
 CellID->390475864],
Cell[63984, 2152, 1500, 28, 112, "Output",
 Evaluatable->False,
 CellID->304459730]
}, Open  ]],
Cell[65499, 2183, 248, 8, 70, "Text",
 CellID->1017588979],
Cell[65750, 2193, 80, 1, 70, "Text",
 CellID->58205345],
Cell[CellGroupData[{
Cell[65855, 2198, 240, 8, 47, "Input",
 CellID->1152174030],
Cell[66098, 2208, 1582, 30, 112, "Output",
 Evaluatable->False,
 CellID->540022989]
}, Open  ]],
Cell[67695, 2241, 88, 1, 70, "Text",
 CellID->992562789],
Cell[CellGroupData[{
Cell[67808, 2246, 295, 10, 47, "Input",
 CellID->349824827],
Cell[68106, 2258, 1631, 31, 112, "Output",
 Evaluatable->False,
 CellID->177034912]
}, Open  ]],
Cell[69752, 2292, 65, 1, 70, "Text",
 CellID->2106994522],
Cell[CellGroupData[{
Cell[69842, 2297, 425, 15, 47, "Input",
 CellID->251592224],
Cell[70270, 2314, 1744, 32, 112, "Output",
 Evaluatable->False,
 CellID->251564182]
}, Open  ]],
Cell[72029, 2349, 188, 4, 70, "Text",
 CellID->1415148828],
Cell[CellGroupData[{
Cell[72242, 2357, 284, 10, 47, "Input",
 CellID->1024961671],
Cell[72529, 2369, 1749, 33, 112, "Output",
 Evaluatable->False,
 CellID->72468259]
}, Open  ]],
Cell[74293, 2405, 198, 6, 70, "Text",
 CellID->515100245],
Cell[CellGroupData[{
Cell[74516, 2415, 307, 11, 70, "Input",
 CellID->249228003],
Cell[74826, 2428, 1197, 38, 112, "Output",
 CellID->612177350]
}, Open  ]],
Cell[CellGroupData[{
Cell[76060, 2471, 87, 2, 70, "Subsubsection",
 CellTags->"c:13",
 CellID->289617502],
Cell[76150, 2475, 173, 4, 70, "Text",
 CellID->1403412012],
Cell[CellGroupData[{
Cell[76348, 2483, 386, 13, 47, "Input",
 CellID->1332790683],
Cell[76737, 2498, 1500, 28, 112, "Output",
 Evaluatable->False,
 CellID->504388574]
}, Open  ]],
Cell[78252, 2529, 111, 3, 70, "Text",
 CellID->1072968381],
Cell[CellGroupData[{
Cell[78388, 2536, 297, 11, 47, "Input",
 CellID->959395608],
Cell[78688, 2549, 1585, 30, 112, "Output",
 Evaluatable->False,
 CellID->15115168]
}, Open  ]],
Cell[80288, 2582, 294, 6, 70, "Text",
 CellID->495184320],
Cell[CellGroupData[{
Cell[80607, 2592, 344, 12, 47, "Input",
 CellID->1063734115],
Cell[80954, 2606, 1614, 30, 112, "Output",
 Evaluatable->False,
 CellID->527985961]
}, Open  ]],
Cell[82583, 2639, 83, 1, 70, "Text",
 CellID->1416326531],
Cell[CellGroupData[{
Cell[82691, 2644, 349, 12, 47, "Input",
 CellID->1491263169],
Cell[83043, 2658, 1456, 28, 110, "Output",
 Evaluatable->False,
 CellID->406487942]
}, Open  ]],
Cell[84514, 2689, 117, 3, 70, "Text",
 CellID->1695714755],
Cell[CellGroupData[{
Cell[84656, 2696, 596, 20, 47, "Input",
 CellID->622407948],
Cell[85255, 2718, 1546, 29, 110, "Output",
 Evaluatable->False,
 CellID->512332631]
}, Open  ]],
Cell[86816, 2750, 125, 4, 70, "Text",
 CellID->1723670944],
Cell[CellGroupData[{
Cell[86966, 2758, 632, 23, 65, "Input",
 CellID->183157778],
Cell[87601, 2783, 1595, 30, 112, "Output",
 Evaluatable->False,
 CellID->424733598]
}, Open  ]],
Cell[89211, 2816, 147, 4, 70, "Text",
 CellID->2146060026],
Cell[CellGroupData[{
Cell[89383, 2824, 506, 18, 47, "Input",
 CellID->1843005617],
Cell[89892, 2844, 1689, 32, 112, "Output",
 Evaluatable->False,
 CellID->122833937]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91642, 2883, 92, 2, 70, "Subsection",
 CellTags->{"t:8", "c:14"},
 CellID->849568979],
Cell[91737, 2887, 85, 1, 70, "Text",
 CellID->87061150],
Cell[91825, 2890, 2518, 93, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->298293044],
Cell[94346, 2985, 84, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->223768693],
Cell[CellGroupData[{
Cell[94455, 2991, 385, 13, 47, "Input",
 CellID->636557354],
Cell[94843, 3006, 1500, 28, 112, "Output",
 Evaluatable->False,
 CellID->371610238]
}, Open  ]],
Cell[96358, 3037, 387, 17, 70, "Text",
 CellID->797632284],
Cell[CellGroupData[{
Cell[96770, 3058, 238, 9, 28, "Input",
 CellID->1212872614],
Cell[97011, 3069, 654, 15, 64, "Output",
 Evaluatable->False,
 CellID->348929658]
}, Open  ]],
Cell[97680, 3087, 80, 1, 70, "Text",
 CellID->2029329626],
Cell[CellGroupData[{
Cell[97785, 3092, 182, 6, 28, "Input",
 CellID->607742528],
Cell[97970, 3100, 1195, 23, 80, "Output",
 Evaluatable->False,
 CellID->168069475]
}, Open  ]],
Cell[99180, 3126, 83, 1, 70, "Text",
 CellID->1919112243],
Cell[CellGroupData[{
Cell[99288, 3131, 213, 8, 28, "Input",
 CellID->1462573808],
Cell[99504, 3141, 1248, 24, 112, "Output",
 Evaluatable->False,
 CellID->252102903]
}, Open  ]],
Cell[100767, 3168, 129, 5, 70, "Text",
 CellID->1504200411],
Cell[100899, 3175, 108, 3, 70, "Text",
 CellID->918815193],
Cell[CellGroupData[{
Cell[101032, 3182, 233, 8, 28, "Input",
 CellID->2119526821],
Cell[101268, 3192, 1247, 24, 112, "Output",
 Evaluatable->False,
 CellID->52499707]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102564, 3222, 98, 2, 70, "Subsection",
 CellTags->{"t:179", "c:15"},
 CellID->2028205186],
Cell[102665, 3226, 219, 8, 70, "Text",
 CellID->1036632271],
Cell[102887, 3236, 2742, 115, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->143750586],
Cell[105632, 3353, 86, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->96996027],
Cell[CellGroupData[{
Cell[105743, 3359, 385, 13, 47, "Input",
 CellID->272137716],
Cell[106131, 3374, 1500, 28, 112, "Output",
 Evaluatable->False,
 CellID->302451773]
}, Open  ]],
Cell[107646, 3405, 64, 1, 70, "Text",
 CellID->500306013],
Cell[CellGroupData[{
Cell[107735, 3410, 211, 7, 28, "Input",
 CellID->1244682486],
Cell[107949, 3419, 857, 18, 64, "Output",
 Evaluatable->False,
 CellID->19958674]
}, Open  ]],
Cell[108821, 3440, 67, 1, 70, "Text",
 CellID->319926707],
Cell[CellGroupData[{
Cell[108913, 3445, 241, 8, 28, "Input",
 CellID->1856596108],
Cell[109157, 3455, 1117, 22, 112, "Output",
 Evaluatable->False,
 CellID->695550960]
}, Open  ]],
Cell[110289, 3480, 115, 3, 70, "Text",
 CellID->1119979277],
Cell[CellGroupData[{
Cell[110429, 3487, 271, 9, 28, "Input",
 CellID->797542584],
Cell[110703, 3498, 1007, 20, 80, "Output",
 Evaluatable->False,
 CellID->335422950]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111759, 3524, 98, 2, 70, "Subsection",
 CellTags->{"t:223", "c:16"},
 CellID->964961827],
Cell[111860, 3528, 213, 8, 70, "Text",
 CellID->316924245],
Cell[112076, 3538, 594, 21, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->786341155],
Cell[112673, 3561, 77, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->421428447],
Cell[CellGroupData[{
Cell[112775, 3567, 385, 13, 47, "Input",
 CellID->546840923],
Cell[113163, 3582, 1500, 28, 112, "Output",
 Evaluatable->False,
 CellID->355375948]
}, Open  ]],
Cell[114678, 3613, 69, 1, 70, "Text",
 CellID->1025611312],
Cell[CellGroupData[{
Cell[114772, 3618, 257, 8, 28, "Input",
 CellID->1745569962],
Cell[115032, 3628, 1560, 29, 128, "Output",
 Evaluatable->False,
 CellID->58806543]
}, Open  ]],
Cell[116607, 3660, 214, 5, 70, "Text",
 CellID->1826715621],
Cell[CellGroupData[{
Cell[116846, 3669, 338, 10, 28, "Input",
 CellID->1183224635],
Cell[117187, 3681, 1573, 30, 112, "Output",
 Evaluatable->False,
 CellID->74052917]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118809, 3717, 89, 2, 70, "Subsection",
 CellTags->{"t:10", "c:17"},
 CellID->782554218],
Cell[118901, 3721, 361, 13, 70, "Text",
 CellID->1198887698],
Cell[119265, 3736, 272, 10, 70, "InputOnly",
 CellID->2013964132],
Cell[119540, 3748, 217, 7, 70, "Text",
 CellID->57922510],
Cell[CellGroupData[{
Cell[119782, 3759, 213, 7, 70, "Input",
 CellID->693533479],
Cell[119998, 3768, 817, 24, 92, "Output",
 CellID->208724395]
}, Open  ]],
Cell[120830, 3795, 215, 7, 70, "Text",
 CellID->1784333498],
Cell[CellGroupData[{
Cell[121070, 3806, 215, 7, 70, "Input",
 CellID->1831454178],
Cell[121288, 3815, 815, 24, 92, "Output",
 CellID->6618384]
}, Open  ]],
Cell[122118, 3842, 232, 5, 70, "Text",
 CellID->1416653465],
Cell[CellGroupData[{
Cell[122375, 3851, 424, 14, 70, "InputOnly",
 CellID->543591966],
Cell[122802, 3867, 744, 23, 54, "Output",
 CellID->228084530]
}, Open  ]],
Cell[CellGroupData[{
Cell[123583, 3895, 103, 3, 70, "Input",
 CellID->1846911586],
Cell[123689, 3900, 918, 24, 92, "Output",
 CellID->338113737]
}, Open  ]],
Cell[124622, 3927, 502, 16, 70, "Text",
 CellID->1972307306]
}, Open  ]],
Cell[CellGroupData[{
Cell[125161, 3948, 79, 2, 70, "Subsection",
 CellTags->{"t:11", "c:18"},
 CellID->11316850],
Cell[125243, 3952, 93, 1, 70, "Text",
 CellID->1223737014],
Cell[CellGroupData[{
Cell[125361, 3957, 334, 11, 47, "Input",
 CellID->897106979],
Cell[125698, 3970, 584, 13, 63, "Output",
 Evaluatable->False,
 CellID->796605768]
}, Open  ]],
Cell[126297, 3986, 209, 7, 70, "Text",
 CellID->1600858622],
Cell[CellGroupData[{
Cell[126531, 3997, 108, 3, 70, "Input",
 CellID->1955730338],
Cell[126642, 4002, 361, 13, 36, "Output",
 CellID->524496292]
}, Open  ]],
Cell[CellGroupData[{
Cell[127040, 4020, 103, 3, 70, "Input",
 CellID->1857588188],
Cell[127146, 4025, 759, 23, 78, "Output",
 CellID->81668711]
}, Open  ]],
Cell[127920, 4051, 276, 9, 70, "Text",
 CellID->1139008285],
Cell[CellGroupData[{
Cell[128221, 4064, 379, 13, 70, "Input",
 CellID->643016637],
Cell[128603, 4079, 352, 12, 36, "Output",
 CellID->443061245]
}, Open  ]],
Cell[128970, 4094, 120, 3, 70, "Text",
 CellID->365581671],
Cell[CellGroupData[{
Cell[129115, 4101, 100, 3, 70, "Input",
 CellID->380430430],
Cell[129218, 4106, 161, 5, 36, "Output",
 CellID->206793666]
}, Open  ]],
Cell[129394, 4114, 228, 8, 70, "Text",
 CellID->69451272],
Cell[CellGroupData[{
Cell[129647, 4126, 114, 3, 70, "Input",
 CellID->986225542],
Cell[129764, 4131, 161, 5, 36, "Output",
 CellID->404156265]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129974, 4142, 88, 2, 70, "Subsection",
 CellTags->{"t:12", "c:19"},
 CellID->654023951],
Cell[130065, 4146, 422, 14, 70, "Text",
 CellID->1359239111],
Cell[CellGroupData[{
Cell[130512, 4164, 404, 13, 70, "Input",
 CellID->1948185438],
Cell[130919, 4179, 775, 23, 78, "Output",
 CellID->619669574]
}, Open  ]],
Cell[131709, 4205, 123, 4, 70, "Text",
 CellID->874553121],
Cell[CellGroupData[{
Cell[131857, 4213, 164, 5, 70, "Input",
 CellID->1236224579],
Cell[132024, 4220, 774, 23, 78, "Output",
 CellID->81396536]
}, Open  ]],
Cell[132813, 4246, 128, 4, 70, "Text",
 CellID->1653298009],
Cell[CellGroupData[{
Cell[132966, 4254, 214, 7, 70, "Input",
 CellID->688728730],
Cell[133183, 4263, 774, 23, 78, "Output",
 CellID->68777727]
}, Open  ]],
Cell[133972, 4289, 88, 1, 70, "Text",
 CellID->1663981879],
Cell[CellGroupData[{
Cell[134085, 4294, 216, 7, 70, "Input",
 CellID->2011389119],
Cell[134304, 4303, 775, 23, 78, "Output",
 CellID->645637999]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135128, 4332, 88, 2, 70, "Subsection",
 CellTags->{"t:13", "c:20"},
 CellID->1736222906],
Cell[135219, 4336, 187, 6, 70, "Text",
 CellID->690585706],
Cell[135409, 4344, 1196, 41, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1672332354],
Cell[136608, 4387, 138, 4, 70, "Caption",
 CellTags->"S3.7.3",
 CellID->623901742],
Cell[136749, 4393, 255, 9, 70, "Text",
 CellID->1901413140],
Cell[CellGroupData[{
Cell[137029, 4406, 272, 9, 70, "Input",
 CellID->346492973],
Cell[137304, 4417, 161, 5, 36, "Output",
 CellID->125327772]
}, Open  ]],
Cell[137480, 4425, 66, 1, 70, "Text",
 CellID->591781684],
Cell[CellGroupData[{
Cell[137571, 4430, 109, 3, 70, "Input",
 CellID->1077993731],
Cell[137683, 4435, 162, 5, 36, "Output",
 CellID->113289671]
}, Open  ]],
Cell[137860, 4443, 92, 1, 70, "Text",
 CellID->17049602],
Cell[CellGroupData[{
Cell[137977, 4448, 267, 9, 70, "Input",
 CellID->937335763],
Cell[138247, 4459, 162, 5, 36, "Output",
 CellID->154453423]
}, Open  ]],
Cell[138424, 4467, 320, 8, 70, "Text",
 CellID->26858756],
Cell[CellGroupData[{
Cell[138769, 4479, 311, 11, 70, "Input",
 CellID->443546222],
Cell[139083, 4492, 161, 5, 36, "Output",
 CellID->182690115]
}, Open  ]],
Cell[139259, 4500, 114, 3, 70, "Text",
 CellID->2106977342],
Cell[CellGroupData[{
Cell[139398, 4507, 426, 14, 70, "Input",
 CellID->2110331611],
Cell[139827, 4523, 161, 5, 36, "Output",
 CellID->238623850]
}, Open  ]],
Cell[140003, 4531, 234, 8, 70, "Text",
 CellID->772116395],
Cell[CellGroupData[{
Cell[140262, 4543, 276, 9, 70, "Input",
 CellID->1864055591],
Cell[140541, 4554, 203, 7, 36, "Output",
 CellID->642780532]
}, Open  ]],
Cell[140759, 4564, 509, 16, 70, "Text",
 CellID->893444556],
Cell[CellGroupData[{
Cell[141293, 4584, 316, 11, 70, "Input",
 CellID->916992868],
Cell[141612, 4597, 161, 5, 36, "Output",
 CellID->162254039]
}, Open  ]],
Cell[141788, 4605, 247, 8, 70, "Text",
 CellID->1288014321],
Cell[CellGroupData[{
Cell[142060, 4617, 134, 4, 70, "Input",
 CellID->1021531287],
Cell[142197, 4623, 160, 5, 36, "Output",
 CellID->95306621]
}, Open  ]],
Cell[142372, 4631, 568, 17, 70, "Text",
 CellID->23669461]
}, Open  ]],
Cell[CellGroupData[{
Cell[142977, 4653, 100, 2, 70, "Subsection",
 CellTags->{"t:23", "c:21"},
 CellID->528156332],
Cell[143080, 4657, 147, 4, 70, "Text",
 CellID->1173558873],
Cell[143230, 4663, 2555, 91, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1514164463],
Cell[145788, 4756, 85, 1, 70, "Text",
 CellID->880912691],
Cell[145876, 4759, 360, 12, 70, "Input",
 CellID->747335219],
Cell[146239, 4773, 76, 1, 70, "Text",
 CellID->1978658077],
Cell[CellGroupData[{
Cell[146340, 4778, 131, 4, 70, "Input",
 CellID->1522026344],
Cell[146474, 4784, 280, 9, 36, "Output",
 CellID->23165134]
}, Open  ]],
Cell[146769, 4796, 259, 9, 70, "Text",
 CellID->1686611890],
Cell[CellGroupData[{
Cell[147053, 4809, 130, 4, 70, "Input",
 CellID->101894830],
Cell[147186, 4815, 342, 11, 36, "Output",
 CellID->268481359]
}, Open  ]],
Cell[147543, 4829, 175, 5, 70, "Text",
 CellID->1205648730],
Cell[CellGroupData[{
Cell[147743, 4838, 133, 4, 70, "Input",
 CellID->1829995665],
Cell[147879, 4844, 596, 19, 36, "Output",
 CellID->4099315]
}, Open  ]],
Cell[148490, 4866, 93, 1, 70, "Text",
 CellID->20075361],
Cell[CellGroupData[{
Cell[148608, 4871, 142, 4, 70, "Input",
 CellID->251834163],
Cell[148753, 4877, 491, 16, 36, "Output",
 CellID->36973084]
}, Open  ]],
Cell[149259, 4896, 226, 8, 70, "Text",
 CellID->184002031],
Cell[CellGroupData[{
Cell[149510, 4908, 186, 6, 70, "Input",
 CellID->145683337],
Cell[149699, 4916, 460, 15, 36, "Output",
 CellID->569029869]
}, Open  ]],
Cell[150174, 4934, 400, 13, 70, "Text",
 CellID->1972024552]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[150623, 4953, 92, 2, 70, "Section",
 CellTags->{"t:15", "c:22"},
 CellID->1701521313],
Cell[150718, 4957, 238, 7, 70, "Text",
 CellID->1576464139],
Cell[CellGroupData[{
Cell[150981, 4968, 365, 12, 70, "Input",
 CellID->2127031134],
Cell[151349, 4982, 937, 23, 78, "Output",
 CellID->66347788]
}, Open  ]],
Cell[152301, 5008, 216, 5, 70, "Text",
 CellID->1456016776],
Cell[CellGroupData[{
Cell[152542, 5017, 94, 3, 70, "Input",
 CellID->697796667],
Cell[152639, 5022, 577, 19, 36, "Output",
 CellID->464564948]
}, Open  ]],
Cell[153231, 5044, 81, 1, 70, "Text",
 CellID->323955473],
Cell[CellGroupData[{
Cell[153337, 5049, 94, 3, 70, "Input",
 CellID->848589566],
Cell[153434, 5054, 583, 19, 54, "Output",
 CellID->635746483]
}, Open  ]],
Cell[154032, 5076, 82, 1, 70, "Text",
 CellID->1187578616],
Cell[CellGroupData[{
Cell[154139, 5081, 95, 3, 70, "Input",
 CellID->920783894],
Cell[154237, 5086, 592, 19, 54, "Output",
 CellID->558994860]
}, Open  ]],
Cell[154844, 5108, 195, 4, 70, "Text",
 CellID->1663465834],
Cell[CellGroupData[{
Cell[155064, 5116, 120, 4, 70, "Input",
 CellID->1928155392],
Cell[155187, 5122, 586, 19, 54, "Output",
 CellID->631479844]
}, Open  ]],
Cell[155788, 5144, 352, 13, 70, "Text",
 CellID->987841743],
Cell[CellGroupData[{
Cell[156165, 5161, 101, 3, 70, "Input",
 CellID->460099644],
Cell[156269, 5166, 588, 19, 54, "Output",
 CellID->166234779]
}, Open  ]],
Cell[156872, 5188, 157, 4, 70, "Text",
 CellID->1067767973],
Cell[CellGroupData[{
Cell[157054, 5196, 102, 3, 70, "Input",
 CellID->1602967879],
Cell[157159, 5201, 583, 19, 54, "Output",
 CellID->368811604]
}, Open  ]],
Cell[157757, 5223, 111, 3, 70, "Text",
 CellID->575960568],
Cell[CellGroupData[{
Cell[157893, 5230, 244, 9, 70, "Input",
 CellID->1460469347],
Cell[158140, 5241, 685, 13, 70, "Message",
 CellID->126324152],
Cell[158828, 5256, 771, 26, 54, "Output",
 CellID->405259668]
}, Open  ]],
Cell[159614, 5285, 193, 4, 70, "Text",
 CellID->1064947414],
Cell[CellGroupData[{
Cell[159832, 5293, 153, 5, 70, "Input",
 CellID->1442473000],
Cell[159988, 5300, 990, 25, 54, "Output",
 CellID->285263193]
}, Open  ]],
Cell[160993, 5328, 874, 24, 70, "Text",
 CellID->1881705571],
Cell[CellGroupData[{
Cell[161892, 5356, 536, 19, 70, "Input",
 CellID->1981346075],
Cell[162431, 5377, 304, 11, 36, "Output",
 CellID->201168909]
}, Open  ]],
Cell[CellGroupData[{
Cell[162772, 5393, 82, 2, 70, "Subsection",
 CellTags->{"t:16", "c:23"},
 CellID->540401315],
Cell[162857, 5397, 364, 9, 70, "Text",
 CellID->816558042],
Cell[163224, 5408, 279, 9, 70, "InputOnly",
 CellID->1470507564],
Cell[163506, 5419, 276, 10, 70, "InputOnly",
 CellID->1578818472],
Cell[CellGroupData[{
Cell[163807, 5433, 106, 3, 70, "Input",
 CellID->894116572],
Cell[163916, 5438, 373, 12, 36, "Output",
 CellID->27459790]
}, Open  ]],
Cell[164304, 5453, 107, 3, 70, "Text",
 CellID->478953376],
Cell[CellGroupData[{
Cell[164436, 5460, 249, 9, 70, "Input",
 CellID->1000681476],
Cell[164688, 5471, 427, 16, 54, "Output",
 CellID->347561867]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[165164, 5493, 74, 2, 70, "Subsection",
 CellTags->{"t:17", "c:24"},
 CellID->188079645],
Cell[165241, 5497, 257, 8, 70, "Text",
 CellID->2106148778],
Cell[165501, 5507, 286, 10, 70, "InputOnly",
 CellID->1069558345],
Cell[165790, 5519, 157, 5, 70, "Text",
 CellID->1628979025],
Cell[CellGroupData[{
Cell[165972, 5528, 179, 6, 70, "Input",
 CellID->2128941219],
Cell[166154, 5536, 434, 15, 36, "Output",
 CellID->498957984]
}, Open  ]],
Cell[166603, 5554, 158, 4, 70, "Text",
 CellID->73177838],
Cell[CellGroupData[{
Cell[166786, 5562, 254, 9, 70, "Input",
 CellID->1539277182],
Cell[167043, 5573, 371, 12, 36, "Output",
 CellID->450716]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[167475, 5592, 87, 2, 70, "Section",
 CellTags->{"t:18", "c:25"},
 CellID->112899229],
Cell[167565, 5596, 676, 18, 70, "Text",
 CellID->1269281502],
Cell[CellGroupData[{
Cell[168266, 5618, 152, 5, 70, "Input",
 CellID->1859138463],
Cell[168421, 5625, 213, 7, 36, "Output",
 CellID->632853063]
}, Open  ]],
Cell[168649, 5635, 111, 3, 70, "Text",
 CellID->590355520],
Cell[168763, 5640, 3475, 122, 70, "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->730775500],
Cell[172241, 5764, 94, 2, 70, "Caption",
 CellTags->"S1.8.3",
 CellID->684851307],
Cell[172338, 5768, 330, 11, 70, "Text",
 CellID->1931052476],
Cell[CellGroupData[{
Cell[172693, 5783, 102, 3, 70, "Input",
 CellID->278607021],
Cell[172798, 5788, 292, 9, 36, "Output",
 CellID->132000494]
}, Open  ]],
Cell[173105, 5800, 135, 4, 70, "Text",
 CellID->651754132],
Cell[CellGroupData[{
Cell[173265, 5808, 138, 4, 70, "Input",
 CellID->1865096824],
Cell[173406, 5814, 718, 15, 54, "Output",
 CellID->169257582]
}, Open  ]],
Cell[174139, 5832, 320, 9, 70, "Text",
 CellID->1936609806],
Cell[CellGroupData[{
Cell[174484, 5845, 262, 9, 70, "Input",
 CellID->1338855510],
Cell[174749, 5856, 314, 9, 36, "Output",
 CellID->571741554]
}, Open  ]],
Cell[175078, 5868, 104, 3, 70, "Text",
 CellID->96872268],
Cell[CellGroupData[{
Cell[175207, 5875, 183, 6, 70, "Input",
 CellID->33007754],
Cell[175393, 5883, 312, 9, 36, "Output",
 CellID->58539418]
}, Open  ]],
Cell[175720, 5895, 143, 4, 70, "Text",
 CellID->920606466],
Cell[CellGroupData[{
Cell[175888, 5903, 98, 3, 70, "Input",
 CellID->13197427],
Cell[175989, 5908, 310, 9, 36, "Output",
 CellID->155169112]
}, Open  ]],
Cell[CellGroupData[{
Cell[176336, 5922, 122, 4, 70, "Input",
 CellID->766138203],
Cell[176461, 5928, 160, 5, 36, "Output",
 CellID->224277841]
}, Open  ]],
Cell[CellGroupData[{
Cell[176658, 5938, 184, 7, 70, "Input",
 CellID->1362793319],
Cell[176845, 5947, 296, 9, 36, "Output",
 CellID->376353370]
}, Open  ]],
Cell[177156, 5959, 260, 7, 70, "Text",
 CellID->1884512185],
Cell[177419, 5968, 290, 9, 70, "Text",
 CellID->1907467339],
Cell[CellGroupData[{
Cell[177734, 5981, 416, 14, 70, "Input",
 CellID->1167684157],
Cell[178153, 5997, 1365, 46, 81, "Output",
 CellID->571324286]
}, Open  ]],
Cell[179533, 6046, 223, 8, 70, "Text",
 CellID->561776716],
Cell[CellGroupData[{
Cell[179781, 6058, 161, 5, 70, "Input",
 CellID->1443153600],
Cell[179945, 6065, 178, 6, 51, "Output",
 CellID->23231142]
}, Open  ]],
Cell[CellGroupData[{
Cell[180160, 6076, 89, 2, 70, "Subsection",
 CellTags->"c:26",
 CellID->1062677296],
Cell[180252, 6080, 199, 6, 70, "Text",
 CellID->1943305420],
Cell[180454, 6088, 2413, 84, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->55406717],
Cell[182870, 6174, 139, 4, 70, "Caption",
 CellTags->"S3.7.3",
 CellID->1360273468],
Cell[183012, 6180, 251, 9, 70, "Text",
 CellID->5270714],
Cell[CellGroupData[{
Cell[183288, 6193, 272, 9, 70, "Input",
 CellID->538060671],
Cell[183563, 6204, 161, 5, 36, "Output",
 CellID->491595342]
}, Open  ]],
Cell[183739, 6212, 482, 18, 70, "Text",
 CellID->1181476509],
Cell[CellGroupData[{
Cell[184246, 6234, 161, 5, 70, "Input",
 CellID->1441886601],
Cell[184410, 6241, 160, 5, 36, "Output",
 CellID->34948000]
}, Open  ]],
Cell[CellGroupData[{
Cell[184607, 6251, 476, 17, 70, "Input",
 CellID->534311271],
Cell[185086, 6270, 161, 5, 36, "Output",
 CellID->245755540]
}, Open  ]],
Cell[185262, 6278, 229, 7, 70, "Text",
 CellID->1647772545],
Cell[CellGroupData[{
Cell[185516, 6289, 521, 19, 70, "Input",
 CellID->164052103],
Cell[186040, 6310, 160, 5, 36, "Output",
 CellID->71569711]
}, Open  ]],
Cell[186215, 6318, 528, 18, 70, "Text",
 CellID->1651103297],
Cell[CellGroupData[{
Cell[186768, 6340, 538, 19, 70, "Input",
 CellID->309426145],
Cell[187309, 6361, 162, 5, 36, "Output",
 CellID->379218027]
}, Open  ]],
Cell[187486, 6369, 235, 8, 70, "Text",
 CellID->1518199295],
Cell[CellGroupData[{
Cell[187746, 6381, 476, 17, 70, "Input",
 CellID->2122341058],
Cell[188225, 6400, 213, 7, 36, "Output",
 CellID->124767931]
}, Open  ]],
Cell[188453, 6410, 551, 14, 70, "Text",
 CellID->976562386],
Cell[CellGroupData[{
Cell[189029, 6428, 281, 9, 70, "Input",
 CellID->2013991128],
Cell[189313, 6439, 158, 5, 36, "Output",
 CellID->674321477]
}, Open  ]],
Cell[189486, 6447, 507, 16, 70, "Text",
 CellID->680924986],
Cell[CellGroupData[{
Cell[190018, 6467, 541, 19, 70, "Input",
 CellID->365884839],
Cell[190562, 6488, 161, 5, 36, "Output",
 CellID->300184784]
}, Open  ]],
Cell[190738, 6496, 246, 8, 70, "Text",
 CellID->938833657],
Cell[CellGroupData[{
Cell[191009, 6508, 133, 4, 70, "Input",
 CellID->1414918690],
Cell[191145, 6514, 161, 5, 36, "Output",
 CellID->41831978]
}, Open  ]],
Cell[191321, 6522, 111, 3, 70, "Text",
 CellID->1900579532],
Cell[CellGroupData[{
Cell[191457, 6529, 160, 5, 70, "Input",
 CellID->1368428846],
Cell[191620, 6536, 163, 5, 36, "Output",
 CellID->742656508]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[191844, 6548, 94, 2, 70, "Section",
 CellTags->{"t:19", "c:27"},
 CellID->1361817013],
Cell[191941, 6552, 137, 4, 70, "Text",
 CellID->177827765],
Cell[192081, 6558, 682, 23, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1601493378],
Cell[CellGroupData[{
Cell[192788, 6585, 91, 2, 70, "Subsection",
 CellTags->{"t:20", "c:28"},
 CellID->1886656195],
Cell[192882, 6589, 225, 8, 70, "Text",
 CellID->1434621410],
Cell[CellGroupData[{
Cell[193132, 6601, 319, 11, 47, "Input",
 CellID->1883133001],
Cell[193454, 6614, 532, 13, 63, "Output",
 Evaluatable->False,
 CellID->124057933]
}, Open  ]],
Cell[194001, 6630, 273, 8, 70, "Text",
 CellID->1569687846],
Cell[CellGroupData[{
Cell[194299, 6642, 239, 7, 28, "Input",
 CellID->2054507974],
Cell[194541, 6651, 2497, 45, 126, "Output",
 Evaluatable->False,
 CellID->137530178]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[197087, 6702, 89, 2, 70, "Subsection",
 CellTags->{"t:22", "c:29"},
 CellID->1336717728],
Cell[197179, 6706, 236, 8, 70, "Text",
 CellID->1388423229],
Cell[CellGroupData[{
Cell[197440, 6718, 354, 12, 47, "Input",
 CellID->1179511381],
Cell[197797, 6732, 1228, 24, 182, "Output",
 Evaluatable->False,
 CellID->77464917]
}, Open  ]],
Cell[CellGroupData[{
Cell[199062, 6761, 108, 3, 28, "Input",
 CellID->314459123],
Cell[199173, 6766, 1498, 29, 205, "Output",
 Evaluatable->False,
 CellID->601954219]
}, Open  ]],
Cell[200686, 6798, 834, 23, 70, "Text",
 CellID->1075588348],
Cell[201523, 6823, 1784, 56, 70, "DefinitionBox3Col",
 CellTags->"S5.27.1",
 CellID->2043508037],
Cell[203310, 6881, 216, 9, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->533611388],
Cell[203529, 6892, 290, 9, 70, "Text",
 CellID->213675174],
Cell[CellGroupData[{
Cell[203844, 6905, 782, 25, 70, "Input",
 CellID->362251893],
Cell[204629, 6932, 493, 17, 36, "Output",
 CellID->342375401]
}, Open  ]],
Cell[205137, 6952, 275, 8, 70, "Text",
 CellID->70411894],
Cell[CellGroupData[{
Cell[205437, 6964, 174, 5, 28, "Input",
 CellID->271973335],
Cell[205614, 6971, 7427, 126, 171, "Output",
 Evaluatable->False,
 CellID->155199871]
}, Open  ]],
Cell[213056, 7100, 35, 1, 70, "Text",
 CellID->69674460],
Cell[213094, 7103, 558, 16, 70, "Text",
 CellID->514888244],
Cell[CellGroupData[{
Cell[213677, 7123, 397, 12, 28, "Input",
 CellID->1515103145],
Cell[214077, 7137, 3103, 55, 205, "Output",
 Evaluatable->False,
 CellID->89537722]
}, Open  ]],
Cell[217195, 7195, 284, 8, 70, "Text",
 CellID->478175105],
Cell[CellGroupData[{
Cell[217504, 7207, 520, 16, 47, "Input",
 CellID->29825653],
Cell[218027, 7225, 2710, 48, 205, "Output",
 Evaluatable->False,
 CellID->412942752]
}, Open  ]],
Cell[220752, 7276, 228, 8, 70, "Text",
 CellID->1078154653],
Cell[CellGroupData[{
Cell[221005, 7288, 476, 16, 28, "Input",
 CellID->78239585],
Cell[221484, 7306, 2701, 48, 205, "Output",
 Evaluatable->False,
 CellID->30413489]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[224246, 7361, 98, 2, 70, "Section",
 CellTags->{"t:21", "c:30"},
 CellID->2053293398],
Cell[224347, 7365, 138, 4, 70, "Text",
 CellID->1787416543],
Cell[224488, 7371, 665, 21, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->2108583965],
Cell[225156, 7394, 628, 17, 70, "Text",
 CellID->1195556961],
Cell[225787, 7413, 684, 22, 70, "Text",
 CellID->1868842195],
Cell[CellGroupData[{
Cell[226496, 7439, 83, 2, 70, "Input",
 CellID->534950343],
Cell[226582, 7443, 3041, 49, 207, "Output",
 CellID->46511687]
}, Open  ]],
Cell[229638, 7495, 495, 13, 70, "Text",
 CellID->1899767359],
Cell[CellGroupData[{
Cell[230158, 7512, 158, 4, 70, "Input",
 CellID->603139117],
Cell[230319, 7518, 103, 5, 70, "Print",
 CellID->22156131]
}, Open  ]],
Cell[230437, 7526, 436, 16, 70, "Text",
 CellID->843536638],
Cell[CellGroupData[{
Cell[230898, 7546, 195, 6, 70, "Input",
 CellID->1780721019],
Cell[231096, 7554, 313, 11, 36, "Output",
 CellID->82984887]
}, Open  ]],
Cell[231424, 7568, 373, 13, 70, "Text",
 CellID->299155443],
Cell[CellGroupData[{
Cell[231822, 7585, 323, 11, 70, "Input",
 CellID->646312874],
Cell[232148, 7598, 176, 5, 36, "Output",
 CellID->516652420]
}, Open  ]],
Cell[CellGroupData[{
Cell[232361, 7608, 124, 3, 70, "Input",
 CellID->1920737071],
Cell[232488, 7613, 97, 5, 70, "Print",
 CellID->28672280]
}, Open  ]],
Cell[232600, 7621, 206, 6, 70, "Text",
 CellID->1984110944],
Cell[CellGroupData[{
Cell[232831, 7631, 324, 11, 70, "Input",
 CellID->826565192],
Cell[233158, 7644, 180, 5, 36, "Output",
 CellID->483917042]
}, Open  ]],
Cell[CellGroupData[{
Cell[233375, 7654, 126, 3, 70, "Input",
 CellID->240113429],
Cell[233504, 7659, 96, 5, 70, "Print",
 CellID->281625828]
}, Open  ]],
Cell[233615, 7667, 508, 10, 70, "Text",
 CellID->760490938]
}, Open  ]],
Cell[CellGroupData[{
Cell[234160, 7682, 90, 2, 70, "Section",
 CellTags->{"t:24", "c:31"},
 CellID->1896011669],
Cell[234253, 7686, 365, 12, 70, "Text",
 CellID->1905766697],
Cell[234621, 7700, 267, 10, 70, "Input",
 CellID->502281474],
Cell[234891, 7712, 107, 3, 70, "Text",
 CellID->86517161],
Cell[CellGroupData[{
Cell[235023, 7719, 96, 3, 70, "Input",
 CellID->247495908],
Cell[235122, 7724, 305, 11, 36, "Output",
 CellID->592424952]
}, Open  ]],
Cell[235442, 7738, 75, 1, 70, "Text",
 CellID->671742684],
Cell[CellGroupData[{
Cell[235542, 7743, 141, 5, 70, "Input",
 CellID->657757709],
Cell[235686, 7750, 205, 7, 36, "Output",
 CellID->631372255]
}, Open  ]],
Cell[235906, 7760, 798, 24, 70, "Text",
 CellID->377906423],
Cell[236707, 7786, 567, 20, 70, "InputOnly",
 CellID->1364107182],
Cell[237277, 7808, 83, 3, 70, "Text",
 CellID->13992502],
Cell[CellGroupData[{
Cell[237385, 7815, 99, 3, 70, "Input",
 CellID->1096263591],
Cell[237487, 7820, 305, 11, 36, "Output",
 CellID->57197826]
}, Open  ]],
Cell[237807, 7834, 72, 1, 70, "Text",
 CellID->2108881870],
Cell[CellGroupData[{
Cell[237904, 7839, 99, 3, 70, "Input",
 CellID->1907479002],
Cell[238006, 7844, 397, 13, 36, "Output",
 CellID->53665440]
}, Open  ]],
Cell[238418, 7860, 91, 1, 70, "Text",
 CellID->1830975002],
Cell[CellGroupData[{
Cell[238534, 7865, 143, 5, 70, "Input",
 CellID->1903680751],
Cell[238680, 7872, 470, 9, 70, "Message",
 CellID->374486252],
Cell[239153, 7883, 397, 14, 36, "Output",
 CellID->113826304]
}, Open  ]],
Cell[239565, 7900, 240, 8, 70, "Text",
 CellID->463508194],
Cell[CellGroupData[{
Cell[239830, 7912, 211, 7, 70, "Input",
 CellID->1259028889],
Cell[240044, 7921, 160, 5, 36, "Output",
 CellID->665831093]
}, Open  ]],
Cell[240219, 7929, 161, 4, 70, "Text",
 CellID->574254236],
Cell[CellGroupData[{
Cell[240405, 7937, 98, 3, 70, "Input",
 CellID->699434834],
Cell[240506, 7942, 206, 7, 36, "Output",
 CellID->120504390]
}, Open  ]],
Cell[240727, 7952, 101, 3, 70, "Text",
 CellID->31444849],
Cell[CellGroupData[{
Cell[240853, 7959, 98, 3, 70, "Input",
 CellID->212599981],
Cell[240954, 7964, 205, 7, 36, "Output",
 CellID->19472771]
}, Open  ]],
Cell[241174, 7974, 502, 17, 70, "Text",
 CellID->558386912],
Cell[241679, 7993, 530, 17, 70, "NumberedEquation",
 CellID->305292594],
Cell[242212, 8012, 315, 12, 70, "Text",
 CellID->714194675],
Cell[242530, 8026, 1039, 30, 70, "NumberedEquation",
 CellID->1183799642],
Cell[243572, 8058, 562, 19, 70, "Text",
 CellID->1832077286],
Cell[CellGroupData[{
Cell[244159, 8081, 816, 24, 65, "Input",
 CellID->1102415116],
Cell[244978, 8107, 1563, 29, 152, "Output",
 Evaluatable->False,
 CellID->347857061]
}, Open  ]],
Cell[246556, 8139, 90, 3, 70, "Text",
 CellID->2092147369],
Cell[CellGroupData[{
Cell[246671, 8146, 679, 23, 47, "Input",
 CellID->1971078452],
Cell[247353, 8171, 1004, 20, 96, "Output",
 Evaluatable->False,
 CellID->137638720]
}, Open  ]],
Cell[248372, 8194, 398, 12, 70, "Text",
 CellID->1788287095],
Cell[CellGroupData[{
Cell[248795, 8210, 139, 4, 28, "Input",
 CellID->1707565900],
Cell[248937, 8216, 1412, 27, 94, "Output",
 Evaluatable->False,
 CellID->248815299]
}, Open  ]],
Cell[250364, 8246, 97, 3, 70, "Text",
 CellID->1277097773],
Cell[CellGroupData[{
Cell[250486, 8253, 106, 3, 70, "Input",
 CellID->83219046],
Cell[250595, 8258, 224, 7, 36, "Output",
 CellID->759911400]
}, Open  ]],
Cell[CellGroupData[{
Cell[250856, 8270, 85, 2, 70, "Subsection",
 CellTags->{"t:201", "c:32"},
 CellID->520172951],
Cell[250944, 8274, 438, 13, 70, "Text",
 CellID->140860520],
Cell[CellGroupData[{
Cell[251407, 8291, 409, 14, 65, "Input",
 CellID->915780646],
Cell[251819, 8307, 1003, 20, 78, "Output",
 Evaluatable->False,
 CellID->333304921]
}, Open  ]],
Cell[252837, 8330, 197, 4, 70, "Text",
 CellID->1286686134],
Cell[CellGroupData[{
Cell[253059, 8338, 284, 10, 70, "Input",
 CellID->173528848],
Cell[253346, 8350, 1127, 35, 78, "Output",
 CellID->205606706]
}, Open  ]],
Cell[CellGroupData[{
Cell[254510, 8390, 110, 2, 70, "Subsubsection",
 CellTags->{"t:202", "c:33"},
 CellID->1814519952],
Cell[254623, 8394, 276, 8, 70, "Text",
 CellID->221562217],
Cell[254902, 8404, 419, 14, 70, "Input",
 CellID->59537221],
Cell[255324, 8420, 223, 8, 70, "Text",
 CellID->2062177492],
Cell[CellGroupData[{
Cell[255572, 8432, 391, 12, 70, "Input",
 CellID->778529111],
Cell[255966, 8446, 28710, 557, 201, "Output",
 CellID->353897834]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[284737, 9010, 98, 2, 70, "Subsection",
 CellTags->{"t:203", "c:34"},
 CellID->1622139970],
Cell[284838, 9014, 651, 19, 70, "Text",
 CellID->1001577125],
Cell[285492, 9035, 58, 1, 70, "Text",
 CellID->1529914689],
Cell[285553, 9038, 288, 10, 70, "Input",
 CellID->1454472492],
Cell[285844, 9050, 63, 1, 70, "Text",
 CellID->512819243],
Cell[CellGroupData[{
Cell[285932, 9055, 99, 3, 70, "Input",
 CellID->1101141690],
Cell[286034, 9060, 257, 9, 36, "Output",
 CellID->2504129]
}, Open  ]],
Cell[286306, 9072, 209, 8, 70, "Text",
 CellID->719037736],
Cell[CellGroupData[{
Cell[286540, 9084, 157, 4, 70, "Input",
 CellID->976747283],
Cell[286700, 9090, 259, 9, 36, "Output",
 CellID->180229987]
}, Open  ]],
Cell[286974, 9102, 312, 13, 70, "Text",
 CellID->387979948],
Cell[CellGroupData[{
Cell[287311, 9119, 158, 4, 70, "Input",
 CellID->1018633744],
Cell[287472, 9125, 261, 9, 36, "Output",
 CellID->10294678]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[287794, 9141, 89, 2, 70, "Section",
 CellTags->{"t:149", "c:35"},
 CellID->1318022893],
Cell[287886, 9145, 542, 15, 70, "Text",
 CellID->716943846],
Cell[288431, 9162, 1197, 36, 70, "DefinitionBox",
 CellID->144476405],
Cell[289631, 9200, 75, 1, 70, "Caption",
 CellID->1558417725],
Cell[289709, 9203, 68, 1, 70, "Text",
 CellID->1616145263],
Cell[CellGroupData[{
Cell[289802, 9208, 406, 13, 70, "Input",
 CellID->1180267985],
Cell[290211, 9223, 817, 24, 92, "Output",
 CellID->140747375]
}, Open  ]],
Cell[291043, 9250, 363, 9, 70, "Text",
 CellID->350236785],
Cell[CellGroupData[{
Cell[291431, 9263, 137, 4, 70, "Input",
 CellID->176969068],
Cell[291571, 9269, 303, 12, 43, "Output",
 CellID->844156533]
}, Open  ]],
Cell[291889, 9284, 112, 3, 70, "Text",
 CellID->1663177939],
Cell[CellGroupData[{
Cell[292026, 9291, 170, 5, 70, "Input",
 CellID->1384471421],
Cell[292199, 9298, 223, 7, 36, "Output",
 CellID->547671074]
}, Open  ]],
Cell[292437, 9308, 157, 4, 70, "Text",
 CellID->1000225553],
Cell[CellGroupData[{
Cell[292619, 9316, 220, 7, 70, "Input",
 CellID->288880555],
Cell[292842, 9325, 817, 24, 92, "Output",
 CellID->223341484]
}, Open  ]],
Cell[293674, 9352, 373, 11, 70, "Text",
 CellID->520271472],
Cell[CellGroupData[{
Cell[294072, 9367, 222, 7, 70, "Input",
 CellID->1796702967],
Cell[294297, 9376, 817, 24, 92, "Output",
 CellID->482660308]
}, Open  ]],
Cell[295129, 9403, 140, 4, 70, "Text",
 CellID->492727685],
Cell[CellGroupData[{
Cell[295294, 9411, 104, 3, 70, "Input",
 CellID->577258963],
Cell[295401, 9416, 161, 5, 36, "Output",
 CellID->620795759]
}, Open  ]],
Cell[CellGroupData[{
Cell[295599, 9426, 92, 2, 70, "Subsection",
 CellTags->{"t:204", "c:36"},
 CellID->384051338],
Cell[295694, 9430, 201, 4, 70, "Text",
 CellID->1562478531],
Cell[CellGroupData[{
Cell[295920, 9438, 352, 12, 70, "Input",
 CellID->1146635001],
Cell[296275, 9452, 817, 24, 92, "Output",
 CellID->126426707]
}, Open  ]],
Cell[297107, 9479, 135, 4, 70, "Text",
 CellID->1801904592],
Cell[CellGroupData[{
Cell[297267, 9487, 236, 8, 70, "Input",
 CellID->796087750],
Cell[297506, 9497, 223, 7, 36, "Output",
 CellID->256854692]
}, Open  ]],
Cell[297744, 9507, 323, 8, 70, "Text",
 CellID->1724149963],
Cell[CellGroupData[{
Cell[298092, 9519, 293, 10, 70, "Input",
 CellID->1791579170],
Cell[298388, 9531, 479, 17, 36, "Output",
 CellID->130763788]
}, Open  ]],
Cell[298882, 9551, 134, 4, 70, "Text",
 CellID->655346763],
Cell[CellGroupData[{
Cell[299041, 9559, 155, 5, 70, "Input",
 CellID->2116903925],
Cell[299199, 9566, 479, 17, 36, "Output",
 CellID->306846570]
}, Open  ]],
Cell[299693, 9586, 129, 4, 70, "Text",
 CellID->13071905],
Cell[CellGroupData[{
Cell[299847, 9594, 193, 6, 70, "Input",
 CellID->656175341],
Cell[300043, 9602, 817, 24, 92, "Output",
 CellID->737919835]
}, Open  ]],
Cell[300875, 9629, 74, 1, 70, "Text",
 CellID->2124350665],
Cell[CellGroupData[{
Cell[300974, 9634, 175, 6, 70, "Input",
 CellID->2045995280],
Cell[301152, 9642, 816, 24, 92, "Output",
 CellID->14801468]
}, Open  ]],
Cell[301983, 9669, 358, 12, 70, "Text",
 CellID->1465782349],
Cell[CellGroupData[{
Cell[302366, 9685, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->49963858],
Cell[302434, 9688, 169, 3, 70, "TutorialMoreAbout",
 CellID->4791866],
Cell[302606, 9693, 147, 3, 70, "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],
Cell[CellGroupData[{
Cell[302790, 9701, 72, 1, 70, "RelatedTutorialsSection",
 CellID->274735117],
Cell[302865, 9704, 304, 9, 70, "RelatedTutorials",
 CellID->315063104],
Cell[303172, 9715, 191, 5, 70, "RelatedTutorials",
 CellID->3571032],
Cell[303366, 9722, 175, 4, 70, "RelatedTutorials",
 CellID->560755906],
Cell[303544, 9728, 175, 4, 70, "RelatedTutorials",
 CellID->335456077],
Cell[303722, 9734, 160, 4, 70, "RelatedTutorials",
 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[303933, 9744, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

