(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    483312,      17485]
NotebookOptionsPosition[    385198,      14019]
NotebookOutlinePosition[    405908,      14716]
CellTagsIndexPosition[    402947,      14603]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Algebra in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/LinearAlgebraOverview"], 
          "Matrix and Tensor Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"], 
          "Working with Sparse Arrays" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraSparseArrays"], 
          "Matrix Computations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixComputations"], "Matrix Types" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixTypes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Algebra in Mathematica\"\>", 
       2->"\<\"Matrix and Tensor Operations\"\>", 
       3->"\<\"Working with Sparse Arrays\"\>", 
       4->"\<\"Matrix Computations\"\>", 
       5->"\<\"Matrix Types\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Linear Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CharacteristicPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/CharacteristicPolynomial"], 
          "CholeskyDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CholeskyDecomposition"], "Det" :> 
          Documentation`HelpLookup["paclet:ref/Det"], "Eigensystem" :> 
          Documentation`HelpLookup["paclet:ref/Eigensystem"], "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"], "Eigenvectors" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvectors"], "Inverse" :> 
          Documentation`HelpLookup["paclet:ref/Inverse"], 
          "JordanDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/JordanDecomposition"], 
          "LinearSolve" :> Documentation`HelpLookup["paclet:ref/LinearSolve"],
           "LUDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/LUDecomposition"], "MatrixExp" :> 
          Documentation`HelpLookup["paclet:ref/MatrixExp"], "MatrixPower" :> 
          Documentation`HelpLookup["paclet:ref/MatrixPower"], "MatrixRank" :> 
          Documentation`HelpLookup["paclet:ref/MatrixRank"], "Minors" :> 
          Documentation`HelpLookup["paclet:ref/Minors"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "NullSpace" :> 
          Documentation`HelpLookup["paclet:ref/NullSpace"], "Orthogonalize" :> 
          Documentation`HelpLookup["paclet:ref/Orthogonalize"], 
          "PseudoInverse" :> 
          Documentation`HelpLookup["paclet:ref/PseudoInverse"], 
          "QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"], "RowReduce" :> 
          Documentation`HelpLookup["paclet:ref/RowReduce"], 
          "SchurDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SchurDecomposition"], 
          "SingularValueDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueDecomposition"], 
          "SingularValueList" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CharacteristicPolynomial\"\>", 
       2->"\<\"CholeskyDecomposition\"\>", 3->"\<\"Det\"\>", 
       4->"\<\"Eigensystem\"\>", 5->"\<\"Eigenvalues\"\>", 
       6->"\<\"Eigenvectors\"\>", 7->"\<\"Inverse\"\>", 
       8->"\<\"JordanDecomposition\"\>", 9->"\<\"LinearSolve\"\>", 
       10->"\<\"LUDecomposition\"\>", 11->"\<\"MatrixExp\"\>", 
       12->"\<\"MatrixPower\"\>", 13->"\<\"MatrixRank\"\>", 
       14->"\<\"Minors\"\>", 15->"\<\"Norm\"\>", 16->"\<\"NullSpace\"\>", 
       17->"\<\"Orthogonalize\"\>", 18->"\<\"PseudoInverse\"\>", 
       19->"\<\"QRDecomposition\"\>", 20->"\<\"RowReduce\"\>", 
       21->"\<\"SchurDecomposition\"\>", 
       22->"\<\"SingularValueDecomposition\"\>", 
       23->"\<\"SingularValueList\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Matrix Computations", "Title",
 ShowCellBracket->True,
 CellTags->{"t:45", "c:69"},
 CellID->1927833614],

Cell[TextData[{
 "This tutorial reviews the functions that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides for carrying out matrix computations. Further information on \
these functions can be found in standard mathematical texts by such authors \
as ",
 ButtonBox["Golub and van Loan",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#1770071216"],
 " or ",
 ButtonBox["Meyer",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#495965421"],
 ". The operations described in this tutorial are unique to matrices; an \
exception is the computation of norms, which also extends to scalars and \
vectors."
}], "Text",
 CellID->2013768209],

Cell[CellGroupData[{

Cell["Basic Operations", "Section",
 CellTags->"c:70",
 CellID->1060011943],

Cell["\<\
This section gives a review of some basic concepts and operations that will \
be used throughout the tutorial to discuss matrix operations.\
\>", "Text",
 CellID->96390489],

Cell[CellGroupData[{

Cell["Norms", "Subsection",
 CellTags->{"t:49", "c:71"},
 CellID->832278785],

Cell[TextData[{
 "The norm of a mathematical object is a measurement of the length, size, or \
extent of the object. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " norms are available for scalars, vectors, and matrices."
}], "Text",
 CellID->1548546584],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["num", "TI"], "]"}], Cell["norm of a number", "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["vec", "TI"], "]"}], Cell[
    "2\[Hyphen]norm of a vector", "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["vec", "TI"], ",", 
     StyleBox["p", "TI"], "]"}], Cell[
    "p\[Hyphen]norm of a vector", "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[
    "2\[Hyphen]norm of a matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["mat", "TI"], ",", 
     StyleBox["p", "TI"], "]"}], Cell[
    "p\[Hyphen]norm of a matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["mat", "TI"], ",", 
     StyleBox["Frobenius", "MR"], "]"}], Cell[
    "Frobenius norm of a matrix", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1068119295],

Cell[TextData[{
 "Computing norms in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellTags->"S1.8.3",
 CellID->1065185792],

Cell["For numbers, the norm is the absolute value.", "Text",
 CellID->1153924752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"-", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88490807],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1206309525]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{"4.", "  ", "+", 
   RowBox[{"6.", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->51075348],

Cell[BoxData["7.211102550927978`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1577398683]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector Norms", "Subsubsection",
 CellTags->{"t:146", "c:72"},
 CellID->654042966],

Cell[TextData[{
 "For vector spaces, norms allow a measure of distance. This allows the \
definition of many familiar concepts such as neighborhood, closeness of \
approximation, and goodness of fit. A vector norm is a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", ":", 
    RowBox[{
     SuperscriptBox["\[DoubleStruckCapitalR]", "n"], "\[LongRightArrow]", " ",
      "\[DoubleStruckCapitalR]"}]}], TraditionalForm]], "InlineMath"],
 "that satisfies the following relations."
}], "Text",
 CellID->1678824216],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"f", "(", "x", ")"}], ">", "0"}], 
     RowBox[{
      RowBox[{"x", "\[Element]", 
       SuperscriptBox["\[DoubleStruckCapitalR]", "n"]}], ",", "           ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"f", "(", "x", ")"}], "=", 
        RowBox[{
         RowBox[{"0", " ", "iff", " ", "x"}], "=", "0"}]}], ")"}]}]},
    {
     RowBox[{
      RowBox[{"f", "(", 
       RowBox[{"x", "+", "y"}], ")"}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"f", "(", "x", ")"}], "+", 
       RowBox[{"f", "(", "y", ")"}]}]}], 
     RowBox[{"x", ",", 
      RowBox[{"y", "\[Element]", 
       SuperscriptBox["\[DoubleStruckCapitalR]", "n"]}], ","}]},
    {
     RowBox[{
      RowBox[{"f", "(", 
       RowBox[{"\[Alpha]", " ", "x"}], ")"}], "=", 
      RowBox[{"\[VerticalBar]", "\[Alpha]", "\[VerticalBar]", 
       RowBox[{"f", "(", "x", ")"}]}]}], 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Element]", "\[DoubleStruckCapitalR]"}], ",", 
      RowBox[{"x", "\[Element]", 
       SuperscriptBox["\[DoubleStruckCapitalR]", "n"]}]}]}
   }], TraditionalForm]], "NumberedEquation",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->210960379],

Cell[TextData[{
 "Typically this function uses the notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleVerticalBar]", "x", 
    SubscriptBox["\[DoubleVerticalBar]", "p"]}], TraditionalForm]], 
  "InlineMath"],
 ". The subscript is used to distinguish different norms, of which the \
p-norms are particularly important. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LongEqual]", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["x", "2"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], "}"}]}], TraditionalForm]], "InlineMath"],
 ", the p-norm is defined as follows."
}], "Text",
 CellID->115588656],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[DoubleVerticalBar]", "x", 
    SubscriptBox["\[DoubleVerticalBar]", "p"]}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[VerticalBar]", 
        SubscriptBox["x", "1"], 
        SuperscriptBox["\[VerticalBar]", "p"], 
        RowBox[{
         RowBox[{"+", "\[Ellipsis]"}], "+"}], "\[VerticalBar]", 
        SubscriptBox["x", "n"], 
        SuperscriptBox["\[VerticalBar]", "p"]}], ")"}], 
      FractionBox["1", "p"]], "          ", "p"}], "\[GreaterEqual]", "1"}]}],
   TraditionalForm]], "NumberedEquation",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->1373324504],

Cell["\<\
Some common p-norms are the 1-, 2-, and \[Infinity]-norms.\
\>", "Text",
 CellID->310700772],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"\[DoubleVerticalBar]", "x", 
       SubscriptBox["\[DoubleVerticalBar]", "1"]}], "=", 
      RowBox[{"\[VerticalBar]", 
       SubscriptBox["x", "1"], "\[VerticalBar]", 
       RowBox[{
        RowBox[{"+", "\[Ellipsis]"}], "+"}], "\[VerticalBar]", 
       SubscriptBox["x", "n"], "\[VerticalBar]"}]}]},
    {
     RowBox[{
      RowBox[{"\[DoubleVerticalBar]", "x", 
       SubscriptBox["\[DoubleVerticalBar]", "2"]}], "=", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[VerticalBar]", 
         SubscriptBox["x", "1"], 
         SuperscriptBox["\[VerticalBar]", "2"], 
         RowBox[{
          RowBox[{"+", "\[Ellipsis]"}], "+"}], "\[VerticalBar]", 
         SubscriptBox["x", "n"], 
         SuperscriptBox["\[VerticalBar]", "2"]}], ")"}], 
       FractionBox["1", "2"]]}]},
    {
     RowBox[{
      RowBox[{"\[DoubleVerticalBar]", "x", 
       SubscriptBox["\[DoubleVerticalBar]", "\[Infinity]"]}], "=", 
      RowBox[{
       UnderscriptBox["max", 
        RowBox[{"1", "\[LessEqual]", "i", "\[LessEqual]", "n"}]], 
       RowBox[{"\[VerticalBar]", 
        SubscriptBox["x", "i"], "\[VerticalBar]"}]}]}]}
   }], TraditionalForm]], "NumberedEquation",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->1415129147],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", vector p-norms can be computed with the function ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 ". The 1-, 2-, and \[Infinity]-norms are demonstrated in the following \
examples."
}], "Text",
 CellID->694183104],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"1.", ",", " ", "2.", ",", " ", "5.6"}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2004258424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"vec", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142845326],

Cell[BoxData["8.6`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2062160383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"vec", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->490978148],

Cell[BoxData["6.029925372672534`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1237561662]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"vec", ",", "\[Infinity]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1319732039],

Cell[BoxData["5.6`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1525273257]
}, Open  ]],

Cell["The 2-norm is particularly useful and this is the default.", "Text",
 CellID->755336160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "vec", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1159003703],

Cell[BoxData["6.029925372672534`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1698558031]
}, Open  ]],

Cell["\<\
Norms are implemented for vectors with exact numerical entries.\
\>", "Text",
 CellID->1164707446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->924602517],

Cell[BoxData[
 SqrtBox["14"]], "Output",
 ImageSize->{35, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->602833527]
}, Open  ]],

Cell["\<\
Norms are also implemented for vectors with symbolic entries.\
\>", "Text",
 CellID->2142725390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1632353187],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "y", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "z", "]"}], "2"]}]]], "Output",
 ImageSize->{191, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->856423484]
}, Open  ]],

Cell["\<\
In addition, if a symbolic p is used, the result is symbolic.\
\>", "Text",
 CellID->1474093394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"vec", ",", "p"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1716321166],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["1.`", "p"], "+", 
    SuperscriptBox["2.`", "p"], "+", 
    SuperscriptBox["5.6`", "p"]}], ")"}], 
  FractionBox["1", "p"]]], "Output",
 ImageSize->{118, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1209490458]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Norms", "Subsubsection",
 CellTags->{"t:147", "c:73"},
 CellID->1973408751],

Cell["\<\
Matrix norms are used to give a measure of distance in matrix spaces. This is \
necessary if you want to quantify what it means for one matrix to be near to \
another, for example, to say that a matrix is nearly singular.\
\>", "Text",
 CellID->1343433789],

Cell["\<\
Matrix norms also use the double bar notation of vector norms. One of the \
most common matrix norms is the Frobenius norm (also called the Euclidean \
norm).\
\>", "Text",
 CellID->448627165],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[DoubleVerticalBar]", "A", 
    SubscriptBox["\[DoubleVerticalBar]", "E"]}], "=", 
   SqrtBox[
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "m"], 
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"j", "=", "1"}], "n"]}], "\[VerticalBar]", 
     SubscriptBox["a", "ij"], 
     SuperscriptBox["\[VerticalBar]", "2"]}]]}], 
  TraditionalForm]], "NumberedEquation",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->261677538],

Cell["\<\
Other common norms are the p-norms. These are defined in terms of vector \
p-norms as follows.\
\>", "Text",
 CellID->2115355757],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[DoubleVerticalBar]", "x", 
    SubscriptBox["\[DoubleVerticalBar]", "p"]}], "=", 
   RowBox[{
    UnderscriptBox["sup", 
     RowBox[{"x", "\[NotEqual]", "0"}]], 
    FractionBox[
     RowBox[{"\[DoubleVerticalBar]", 
      RowBox[{"A", " ", "x"}], 
      SubscriptBox["\[DoubleVerticalBar]", "p"]}], 
     RowBox[{"\[DoubleVerticalBar]", "x", 
      SubscriptBox["\[DoubleVerticalBar]", "p"]}]]}]}], 
  TraditionalForm]], "NumberedEquation",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->1192431814],

Cell["\<\
Thus the matrix p-norms show the maximum expansion that a matrix can apply to \
any vector. \
\>", "Text",
 CellID->884104094],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the Frobenius norm can be computed as follows."
}], "Text",
 CellID->698154265],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "2.1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28084647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{"mat", ",", "\"\<Frobenius\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1719743436],

Cell[BoxData["5.44609952167604`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->745523879]
}, Open  ]],

Cell["The matrix 2-norm can be computed as follows.", "Text",
 CellID->1600237755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.", ",", "2."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4.5", ",", "2.1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->110753257],

Cell[BoxData["5.287440719943889`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1709152097]
}, Open  ]],

Cell["\<\
It is also possible to give an argument to specify the 1, 2, or \[Infinity] \
matrix p-norms.\
\>", "Text",
 CellID->978032007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "2.1"}], "}"}]}], "}"}], ",", "1"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->944107511],

Cell[BoxData["5.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2005753341]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "2.1"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->1645595228],

Cell[BoxData["5.287440719943889`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->77107283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "2.1"}], "}"}]}], "}"}], ",", "\[Infinity]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1009466240],

Cell[BoxData["6.6`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->978284380]
}, Open  ]],

Cell["\<\
This computes the expansion that a collection of different vectors gets from \
an input matrix. You can see that the maximum value is still less than the \
2-norm.\
\>", "Text",
 CellID->890773228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Table", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"vec", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Random", "[", "]"}], ",", 
        RowBox[{"Random", "[", "]"}]}], "}"}]}], ";", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"mat", ".", "vec"}], "]"}], "/", 
      RowBox[{"Norm", "[", "vec", "]"}]}]}], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1117139759],

Cell[BoxData["5.287439500212727`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->318403792]
}, Open  ]],

Cell["All the p-norms are supported for exact numerical matrices.", "Text",
 CellID->2030767467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1151216098],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1808783263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->441794309],

Cell[BoxData[
 SqrtBox[
  RowBox[{"5", " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]}], ")"}]}]]], "Output",
 ImageSize->{102, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1385983684]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "}"}], ",", "\[Infinity]"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->472657979],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->420642800]
}, Open  ]],

Cell["\<\
However, only the 1, and \[Infinity] matrix p-norms are supported for \
symbolic matrices.\
\>", "Text",
 CellID->227373676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1095964519],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "a", "]"}], "+", 
    RowBox[{"Abs", "[", "c", "]"}]}], ",", 
   RowBox[{
    RowBox[{"Abs", "[", "b", "]"}], "+", 
    RowBox[{"Abs", "[", "d", "]"}]}]}], "]"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->908430514]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "\[Infinity]"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1530402275],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "a", "]"}], "+", 
    RowBox[{"Abs", "[", "b", "]"}]}], ",", 
   RowBox[{
    RowBox[{"Abs", "[", "c", "]"}], "+", 
    RowBox[{"Abs", "[", "d", "]"}]}]}], "]"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1059395806]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NullSpace", "Subsection",
 CellTags->{"t:225", "c:74"},
 CellID->478394165],

Cell["\<\
One of the fundamental subspaces associated with each matrix is the \
nullspace. Vectors in the nullspace of a matrix are mapped to zero by the \
action of the matrix.\
\>", "Text",
 CellID->191956787],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NullSpace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NullSpace"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of basis vectors whose linear combinations satisfy ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["m", "TI"], ".", 
        StyleBox["x", "TI"]}], "==", "0"}]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.8",
 CellID->697281315],

Cell["\<\
For some matrices (for instance, nonsingular square matrices), the nullspace \
is empty.\
\>", "Text",
 CellID->388799526],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"NullSpace", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1908379308],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1462761611]
}, Open  ]],

Cell["This matrix has a nullspace with one vector.", "Text",
 CellID->241605221],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"null", "=", 
  RowBox[{"NullSpace", "[", "mat", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1914856517],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "0.8944271909999157`"}], ",", "0.4472135954999581`"}], "}"}],
   "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->803547277]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", ".", 
  RowBox[{"null", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1841912203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.440892098500626`*^-16", ",", "8.881784197001252`*^-16"}], 
  "}"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1041624316]
}, Open  ]],

Cell["This matrix has a nullspace with two basis vectors.", "Text",
 CellID->293188668],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "1.", ",", "1."}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2.", ",", "2.", ",", "2."}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "3.", ",", "3."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"NullSpace", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->1294456858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.8164965809277259`", ",", 
     RowBox[{"-", "0.40824829046386296`"}], ",", 
     RowBox[{"-", "0.40824829046386296`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.408849290875888`*^-17"}], ",", 
     RowBox[{"-", "0.7071067811865475`"}], ",", "0.7071067811865476`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{503, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1927068296]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rank", "Subsection",
 CellTags->{"t:50", "c:75"},
 CellID->2035970465],

Cell["\<\
The rank of a matrix corresponds to the number of linearly independent rows \
or columns in the matrix.\
\>", "Text",
 CellID->551173957],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MatrixRank",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixRank"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "gives the rank of the matrix ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1483725788],

Cell[TextData[{
 "If an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix has no linear dependencies between its rows, its rank is equal to \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"min", "(", 
    RowBox[{"m", ",", "n"}], ")"}], TraditionalForm]], "InlineMath"],
 " and it is said to be full rank."
}], "Text",
 CellID->399209952],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixRank", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->782750036],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91407209]
}, Open  ]],

Cell[TextData[{
 "If a matrix has any dependencies in its rows then its rank is less than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"min", "(", 
    RowBox[{"m", ",", "n"}], ")"}], TraditionalForm]], "InlineMath"],
 ". In this case the matrix is said to be rank deficient."
}], "Text",
 CellID->868493388],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixRank", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->322023457],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->419485042]
}, Open  ]],

Cell["\<\
Note that the rank of a matrix is equal to the rank of its transpose. This \
means that the number of linearly independent rows is equal to the number of \
linearly independent columns.\
\>", "Text",
 CellID->566927102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", " ", 
  RowBox[{"Transpose", "[", "mat", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2106345222],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->85707687]
}, Open  ]],

Cell[TextData[{
 "For an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " the following relations hold: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Length"], "[", 
     RowBox[{
      ButtonBox["NullSpace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NullSpace"], "[", 
      StyleBox["A", "TI"], "]"}], "]"}], "+", 
    RowBox[{
     ButtonBox["MatrixRank",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixRank"], "[", 
     StyleBox["A", "TI"], "]"}]}], "\[LongEqual]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Length"], "[", 
     RowBox[{
      ButtonBox["NullSpace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NullSpace"], "[", 
      SuperscriptBox[
       StyleBox["A", "TI"], 
       StyleBox["T", "TI"]], "]"}], "]"}], "+", 
    RowBox[{
     ButtonBox["MatrixRank",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixRank"], "[", 
     SuperscriptBox[
      StyleBox["A", "TI"], 
      StyleBox["T", "TI"]], "]"}]}], "\[LongEqual]", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 ". From this it follows that the nullspace is empty if and only if the rank \
is equal to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and that the nullspace of the transpose of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is empty if and only if the rank of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is equal to ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->1219355101],

Cell["\<\
If the rank is equal to the number of columns, it is said to have full column \
rank. If the rank is equal to the number of rows, it is said to have full row \
rank. One way to understand the rank of a matrix is to consider the row \
echelon form.\
\>", "Text",
 CellID->264739186]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduced Row Echelon Form", "Subsection",
 CellTags->{"t:226", "c:76"},
 CellID->2032866165],

Cell["\<\
A matrix can be reduced to a row echelon form by a combination of row \
operations that start with a pivot position at the top-left element and \
subtract multiples of the pivot row from following rows so that all entries \
in the column below the pivot are zero. The next pivot is chosen by going to \
the next row and column. If this pivot is zero and any nonzero entries are in \
the column beneath, the rows are exchanged and the process is repeated. The \
process finishes when the last row or column is reached.\
\>", "Text",
 CellID->2064295032],

Cell[TextData[{
 "A matrix is in row echelon form if any row that consists entirely of zeros \
is followed only by other zero rows and if the first nonzero entry in row ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is in the column ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ", then elements in columns from 1 to ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " in all rows below ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " are zero. The row echelon form is not unique but its form (in the sense of \
the positions of the pivots) is unique. It also gives a way to determine the \
rank of a matrix as the number of nonzero rows."
}], "Text",
 CellID->2008285539],

Cell["\<\
A matrix is in reduced row echelon form if it is in row echelon form, each \
pivot is one, and all the entries above (and below) each pivot are zero. It \
can be formed by a procedure similar to the procedure for the row echelon \
form, also taking steps to reduce the pivot to one (by division) and reduce \
entries in the column above each pivot to zero (by subtracting multiples of \
the current pivot row). The reduced row echelon form of a matrix is unique.\
\>", "Text",
 CellID->1254574074],

Cell[TextData[{
 "The reduced row echelon form (and row echelon form) give a way to determine \
the rank of a matrix as the number of nonzero rows. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the reduced row echelon form of a matrix can be computed by the function \
",
 Cell[BoxData[
  ButtonBox["RowReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowReduce"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1632015472],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RowReduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RowReduce"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "gives the reduced row echelon form of the matrix ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1622898420],

Cell["\<\
The reduced row echelon form of this matrix only has one nonzero row. This \
means that the rank is 1.\
\>", "Text",
 CellID->863944393],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"RowReduce", "[", "mat", "]"}], "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1176475784],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAKxjAQDkP0fyAJj
w///gTSEZAWRzCBRMGBQQuOzgFWxYBEFcXmgNB+aPDNWXWBRVjgfrIaBgQur
KC+dTGTG5l8iTUT3NdOoiXBRULpCTiH8ROlSG1WFFCOs0DgA0SB5JiDNSZRu
NjQ+9pikzExuND5xMYxuCg8an7jUhW4Ket5G50NMQS890Ms+dLvRfYi9DEI3
hZLyjAUaIyDVuMtV4spsSPnOwAgASABF9w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{49, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->583022099]
}, Open  ]],

Cell["\<\
This is a 3\[Times]2 random matrix whose columns are linearly independent.\
\>", "Text",
 CellID->926332982],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1769471371],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.676970140941102`", "0.7859494388374115`"},
     {"0.12230304812864934`", "0.644743111876989`"},
     {"0.742934682304834`", "0.9858494772306027`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$93]]]], "Output",
 ImageSize->{144, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->211997900]
}, Open  ]],

Cell["\<\
The reduced row echelon form has two nonzero rows, thus its rank should be 2.\
\
\>", "Text",
 CellID->695775929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", "mat", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->857580788],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlr1ugzAQgA2GSm3StJU6dIzUoUOnvEQ79SFQVCkZolZpBjZGRkZGHoGR
kZGRkZGRkZGRnv9iQy3VVB0yBAl8HHefz3fg4807bN533mG79pave+9zs11/
LV8+9qDCFkJoBefzAwK5B4meq76HUb265IqTJOnpgR7pfRAE/B5TK4eKVVVl
WUZEco8BOOfjQlDKshx7xXGsslwShzhARlda7TV16LrO931JxELLoGwGQyKL
MQxDcCeifSTaRVG4k0mQCkjIkERX2zTN32KT+VWJshbTibBUVtp/IN6I9XGV
pSWSPKpvxu3oud7r6Ww1yt8MRveY9d+89HWcU6uj9sw6eZb69dgw3hl5neq7
PMUqiiIDK9mnVCvYk9q2FbVw+ddD8ujwPF5Su7qu0zQlorobwpbLu9bFqGb6
fRAPmHmea7oAhMNnMmMuRA4GvWncP90JLJk5ybJhnWbxkO5rwwpoBHxeGYdj
zPjR/TmLtcipLOnFWDNeCfKUIO6plv3XIOsbVLZcbw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{49, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->376845027]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixRank",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixRank"]], "InlineFormula"],
 " also computes the rank as 2."
}], "Text",
 CellID->16307052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "mat", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1342199795],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->42079144]
}, Open  ]],

Cell["\<\
The reduced row echelon form of the transpose of the matrix also has two \
nonzero rows. This is consistent with the fact that the rank of a matrix is \
equal to the rank of its transpose, even when the matrix is rectangular.\
\>", "Text",
 CellID->602393131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{"Transpose", "[", "mat", "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1183440759],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV8FSwjAQDUlbVFBH9ODBA1+jJz+iMjpwcATk/2OSZm19fZRQ7A1myjav
j2Z3u7uvvJa75ftnuVstyvnLtlwvV4vv+fPX1kFmpJTauOPpUblz687CsbHW
2eo799/Go+Gj3mCdBVZGUL+cOJs7O4trj+toPZ5HXEdrIm4afG/HcH9Ddw1o
/rsOHKWmwLqjLNPwrH21CEHV96j4PRHM3qBxXZF7FTHzbTZHiySvaWw9vZ4A
Syf5pXv9Citc/3s0yAo7tOrC7InIxOfiq/NicF+vO3IqfdK8PqaxdFXL8Pm+
pGjTDxYJ7zJeQxzFKcUjk5nnY/HP9MHWs1JqQEf/MjILxabVwseZFVHRHMmz
aNHU1pqjVa1JmG/UptukXbGjwzzeqz43wO5WpWNqE7uQs3D/U2K6BxbvykPa
gjMd+XS2nj3+w5KKFRXBCSydwCv60Pw+1bOWmhyRS3xP4O9PQ3rMVSOt21Br
uffydDzbRD9lbsl8Qp1ozjE2U1Lf66v/AGr0A41GcT0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->217141484]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse", "Subsection",
 CellTags->{"t:56", "c:77"},
 CellID->1798152178],

Cell[TextData[{
 "The inverse of a square matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is defined as follows."
}], "Text",
 CellID->6291415],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"A", ".", 
    SuperscriptBox["A", 
     RowBox[{"-", "1"}]]}], "=", "I"}], TraditionalForm]], "NumberedEquation",\

 CellID->513113202],

Cell[TextData[{
 "Where ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " is the identity matrix. The inverse can be computed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the function ",
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1746743309],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Inverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inverse"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "gives the inverse of the matrix ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1413339873],

Cell["Here is a sample 2\[Times]2 matrix.", "Text",
 CellID->686626044],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "5."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"invMat", "=", 
   RowBox[{"Inverse", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"invMat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1694286177],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVM0KgkAQXtu1OmiUUXaIMOolOnQtLz2ESKCHKMz33/aPwo/NNumYsM5+
48w3PzJzyurifMnqMs+SY5XdijK/J4drJVTUI4Sk4iwXRNy5uKmTci6kfvvy
TaVWPWQHmCkrZtFKKGVPBhDSF5IaPAR7amVRWv+Jlc2LY2WxduceAI5Nhlhv
aGWjoMWYa8AjwD0rS99UsO3k/ZscmLXnm05cspfUeMu6xk5e+7+V0Ya8OUUB
b07RxIkl4G1T1P7VLQIzeeFM4f+OndjQC3OYf9W7GegRa2/cDsGHmFPA9h2D
LJG115jRey4mYGTqwoy0l9u21pudeA/qGzmh\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->295803983]
}, Open  ]],

Cell["This demonstrates that the matrix satisfies the definition.", "Text",
 CellID->438346641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mat", ".", "invMat"}], "//", "Chop"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1423086077],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwWACxjAQDkP0fyAJj
i///gTSEZAWRzCBRMGDQROOzgFWxYBEFcYWANCuQZgbSTECaA00dM1bdYFFW
OB+shoFBGIsqapvJi9UsZmx+JmgWHxqfacSaBUpDzFDdoBgTIEqX7qgqpLhA
zkW80PDkJ0o3GxofZgrPf2wxTFyMopspOAzMQi8x0Es+7GZhLzFoaRaID4o/
kf+QVIDuG4gu4sptSBnPwAgA809Gwg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{56, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->94321381]
}, Open  ]],

Cell["\<\
Not all matrices have an inverse; if a matrix does not have an inverse it is \
said to be singular. If a matrix is rank-deficient then it is singular.\
\>", "Text",
 CellID->1945438855],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixRank", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1552310410],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->101422021]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", " ", "mat", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1810353471],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"sing\"\>"}], ":", 
  " ", "\<\"Matrix \\!\\({\\(\\({1.`, 2.`}\\)\\), \\(\\({2.`, 4.`}\\)\\)}\\) \
is singular. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/sing\\\", ButtonNote -> \
\\\"Inverse::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->202721639],

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.`", ",", "2.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.`", ",", "4.`"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->363054539]
}, Open  ]],

Cell["\<\
The matrix inverse can in principle be used to solve the matrix equation\
\>", "Text",
 CellID->1593114484],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"A", ".", "X"}], "=", "B"}], TraditionalForm]], "NumberedEquation",\

 CellID->649021792],

Cell[TextData[{
 "by multiplying it by the inverse of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->1039815031],

Cell[BoxData[
 FormBox[
  RowBox[{"X", "=", 
   RowBox[{
    SuperscriptBox["A", 
     RowBox[{"-", "1"}]], ".", "B"}]}], TraditionalForm]], "NumberedEquation",\

 CellID->2096790378],

Cell[TextData[{
 "However, it is always better to solve the matrix equation directly. Such \
techniques are discussed in the section \"",
 ButtonBox["Solving Linear Systems",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#81663253"],
 "\"."
}], "Text",
 CellID->549235776]
}, Open  ]],

Cell[CellGroupData[{

Cell["PseudoInverse", "Subsection",
 CellTags->{"t:227", "c:78"},
 CellID->1120972426],

Cell[TextData[{
 "When the matrix is singular or is not square it is still possible to find \
an approximate inverse that minimizes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleVerticalBar]", 
    RowBox[{
     RowBox[{"A", " ", ".", 
      SuperscriptBox["A", 
       RowBox[{"-", "1"}]]}], " ", "-", " ", "I"}], 
    SubscriptBox["\[DoubleVerticalBar]", "p"]}], TraditionalForm]], 
  "InlineMath"],
 ". When the 2-norm is used this will find a least squares solution known as \
the pseudoinverse. "
}], "Text",
 CellID->309528651],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PseudoInverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PseudoInverse"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "gives the pseudoinverse of the matrix ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1042644323],

Cell["\<\
This finds the pseudoinverse for the singular matrix defined above.\
\>", "Text",
 CellID->256577141],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matInv", "=", 
   RowBox[{"PseudoInverse", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"matInv", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->144845611],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVksOgjAQLRSQjwdw4YLLqHHhjgsQYgILo0Huj53iKBlHAhbBhSTtdKbt
68u0ffSQVvnxlFZFlsa7Mr3kRXaNt+dShaQlhEhUWa+EateqpUtS18o2tQu1
hKj+xIb4jh7lMFFwwdqiQUEf7JL0g3WVlff4guBJdhUddR++HtNgIOZrr81G
w04kj6zLY9BRQzgHxlwjA46SRPnMTcWR7r1tzBFPVdSblaNcf3Qexrlq+cFP
saPr9ssdqkJU8+oAcbx/nCrwqPv/KJJfqsKYz/BNP+6DyQ3oVmGqQ/4HGFOp
ByB4b3uH3KXvcOt7Z+dlquc6z7nDWKKC8yfS5B/bnjtO7sZ/B8zFEXUA9Rlm
2S2f6jb/auv3gmxem8K6AS4Bmbo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{84, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->648483347]
}, Open  ]],

Cell["\<\
The result is not the identity matrix, but it is 'close' to the identity \
matrix.\
\>", "Text",
 CellID->629611002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", ".", "matInv"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1220181845],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVs0OgyAMRgF1/tx32MG32GF3d9pDGLNED8sW5/szQNm0qQZm5mkmUFo+
qZT2w0vZ1ddb2TVVmZ/b8lE31TMv7q00UY8QUsh22BM5FnKkWyGElH3PVU+V
VT/kCHSmUQyxKlVJX8pw0GNg54Megvcpuqq28reuMURb1VoRQEeLaIbOBiu+
YydlMEh81tYfxWJsuWLsgIVR9x28az/sg5rzbE4cno6Lr2SE2nKPv/dr8j8T
fVYmg26kXdROfxSIp+EXJfkonpCPYP25ZMcyk+C5MsdVkGWdK3GESlCUYac1
O04Aaqs6TAFqgfkmjIT7tGPzDKDw2wQyxNr7wzaPvvNrbmVTDamYsg++it0f
QP+3QLwXwOpkSg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{70, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->544000257]
}, Open  ]],

Cell["This computes the pseudoinverse of a rectangular matrix.", "Text",
 CellID->50997818],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", "5", ",", " ", "4."}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"matInv", "=", 
   RowBox[{"PseudoInverse", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"matInv", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->274351973],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.055555555555555275`"}], "0.07407407407407392`"},
     {
      RowBox[{"-", "0.5555555555555555`"}], "0.40740740740740744`"},
     {"0.7222222222222221`", 
      RowBox[{"-", "0.2962962962962962`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$115]]]], "Output",
 ImageSize->{167, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->332414613]
}, Open  ]],

Cell["The result is quite close to the identity matrix.", "Text",
 CellID->1505673080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", ".", "matInv"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->2047642959],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.9999999999999998`", "2.220446049250313`*^-16"},
     {"4.440892098500626`*^-16", "1.0000000000000002`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$119]]]], "Output",
 ImageSize->{212, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->10071531]
}, Open  ]],

Cell[TextData[{
 "The solution found by the pseudoinverse is a least squares solution. These \
are discussed in more detail under \"",
 ButtonBox["Least Squares Solutions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#563250646"],
 "\"."
}], "Text",
 CellID->1575797816]
}, Open  ]],

Cell[CellGroupData[{

Cell["Determinant", "Subsection",
 CellTags->{"t:55", "c:79"},
 CellID->1665558708],

Cell[TextData[{
 "The determinant of an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix is defined as follows."
}], "Text",
 CellID->595866711],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"det", "(", "A", ")"}], "=", " ", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "11"], "      ", "if", " ", "n"}], "=", "1"}]}]},
    {
     RowBox[{
      RowBox[{"det", "(", "A", ")"}], "=", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "n"], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "+", "i"}]], 
        SubscriptBox["a", 
         RowBox[{"i", " ", "1"}]], 
        RowBox[{"det", "(", 
         SubscriptBox["A", 
          RowBox[{"i", " ", "1"}]], ")"}]}]}]}]}
   }], TraditionalForm]], "NumberedEquation",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}}},
 CellID->1015565816],

Cell[TextData[{
 "It can be computed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the function ",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 "."
}], "Text",
 CellID->414643156],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Det",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Det"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "determinant of the matrix ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Minors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minors"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "matrix of minors of ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Minors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minors"], "[", 
     StyleBox["mat", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " minors of ",
     Cell[BoxData[
      StyleBox["mat", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->323088377],

Cell["Here is a sample 2\[Times]2 matrix.", "Text",
 CellID->1307692623],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "5."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Det", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1042271363],

Cell[BoxData[
 RowBox[{"-", "1.`"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->430689362]
}, Open  ]],

Cell[TextData[{
 "One useful property of the determinant is that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"det", "(", "A", ")"}], " ", "=", " ", "0"}], ")"}], 
   TraditionalForm]], "InlineMath"],
 " if and only if ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is singular."
}], "Text",
 CellID->1576216744],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Det", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->116547016],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->300611848]
}, Open  ]],

Cell[TextData[{
 "As was pointed out ",
 ButtonBox["above",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1798152178"],
 ", if the matrix is singular, it does not have full rank."
}], "Text",
 CellID->1501791592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "mat", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1235983553],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->566257840]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Minors", "Subsection",
 CellTags->{"t:207", "c:80"},
 CellID->1595477023],

Cell[TextData[{
 "A minor of a matrix is the determinant of any ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "\[Times]", "k"}], TraditionalForm]], "InlineMath"],
 " submatrix. This example uses the function ",
 Cell[BoxData[
  ButtonBox["Minors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minors"]], "InlineFormula"],
 " to compute all the 2",
 "\[Times]",
 "2 minors."
}], "Text",
 CellTags->{"S3.7.7", "7.4"},
 CellID->1701509119],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Minors", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1371519581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "12"}], ",", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40130969]
}, Open  ]],

Cell["\<\
The size of the submatrices can be controlled by a second option. Here the 1\
\[Times]1 minors are computed; these are just the entries of the matrix.\
\>", "Text",
 CellID->171330825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minors", "[", " ", 
  RowBox[{"mat", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1929088795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1634758806]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     StyleBox["n", "TI"], "-", "1"}]}], "]"}]], "InlineFormula"],
 ". In general, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " computes determinants of all the possible ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "\[Times]", "k"}], TraditionalForm]], "InlineMath"],
 " submatrices that can be generated from the matrix ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " (this is done by picking different ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " rows and ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " columns). For the 2\[Times]2 minors of a 4\[Times]4 matrix we obtain a 6\
\[Times]6 matrix because there are only 6 different ways to pick 2 rows from \
4 rows, and to pick 2 columns from 4 columns."
}], "Text",
 CellID->485472724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4", ",", "5", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "0", ",", "4"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2", ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "2"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
  ";", 
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1049697315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.`"}], ",", 
     RowBox[{"-", "10.`"}], ",", "6.`", ",", 
     RowBox[{"-", "15.`"}], ",", "19.`", ",", "20.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10.`"}], ",", 
     RowBox[{"-", "16.`"}], ",", "1.`", ",", 
     RowBox[{"-", "14.`"}], ",", 
     RowBox[{"-", "6.`"}], ",", 
     RowBox[{"-", "11.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "13.`"}], ",", 
     RowBox[{"-", "18.`"}], ",", "5.`", ",", 
     RowBox[{"-", "7.`"}], ",", "7.`", ",", "7.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.`"}], ",", 
     RowBox[{"-", "2.`"}], ",", 
     RowBox[{"-", "16.`"}], ",", 
     RowBox[{"-", "3.`"}], ",", 
     RowBox[{"-", "14.`"}], ",", "4.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.`"}], ",", "4.`", ",", 
     RowBox[{"-", "14.`"}], ",", "6.`", ",", 
     RowBox[{"-", "9.`"}], ",", 
     RowBox[{"-", "8.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0000000000000004`", ",", "10.`", ",", "11.`", ",", "7.`", ",", "8.`", 
     ",", "3.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{455, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->684613100]
}, Open  ]],

Cell[TextData[{
 "One of the properties of the rank of a matrix is that it is equal to the \
size of the largest nonsingular submatrix. This can be demonstrated with ",
 Cell[BoxData[
  ButtonBox["Minors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minors"]], "InlineFormula"],
 ". In this example, the following matrix has a rank of 2."
}], "Text",
 CellID->74991074],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixRank", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1949563576],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->9535906]
}, Open  ]],

Cell["The determinant of the matrix is zero, ", "Text",
 CellID->1356182264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "mat", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->2111365437],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->699116631]
}, Open  ]],

Cell["\<\
When the 2\[Times]2 minors are computed you can see that not all are zero, \
confirming that the rank of the matrix is 2.\
\>", "Text",
 CellID->1170184480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minors", "[", "mat", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->635316134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "18", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->469571254]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving Linear Systems", "Section",
 CellTags->{"t:46", "c:81"},
 CellID->81663253],

Cell[TextData[{
 "One of the most important uses of matrices is to represent and solve linear \
systems. This section will discuss how to solve linear systems with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It will make strong use of ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ", the main function provided for this purpose."
}], "Text",
 CellID->272242738],

Cell[TextData[{
 "Solving a linear system involves solving a matrix equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", ".", "X"}], " ", "\[LongEqual]", " ", "B"}], 
   TraditionalForm]], "InlineMath"],
 ". Because ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix this is a set of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " linear equations in ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " unknowns. "
}], "Text",
 CellID->1443529456],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["a", "11"], 
        SubscriptBox["a", "12"], "\[Ellipsis]", 
        SubscriptBox["a", 
         RowBox[{"1", "n"}]]},
       {
        SubscriptBox["a", "21"], 
        SubscriptBox["a", "22"], "\[Ellipsis]", 
        SubscriptBox["a", 
         RowBox[{"2", "n"}]]},
       {"\[VerticalEllipsis]", "\[VerticalEllipsis]", "\[DescendingEllipsis]",
         "\[VerticalEllipsis]"},
       {
        SubscriptBox["a", "m1"], 
        SubscriptBox["a", "m2"], "\[Ellipsis]", 
        SubscriptBox["a", "mn"]}
      }], ")"}], 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["x", "1"]},
       {
        SubscriptBox["x", "2"]},
       {"\[VerticalEllipsis]"},
       {
        SubscriptBox["x", "n"]}
      }], ")"}]}], "\[LongEqual]", 
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["b", "1"]},
      {
       SubscriptBox["b", "2"]},
      {"\[VerticalEllipsis]"},
      {
       SubscriptBox["b", "m"]}
     }], ")"}]}], TraditionalForm]], "NumberedEquation",
 CellID->1276806833],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", "\[LongEqual]", " ", "n"}], TraditionalForm]], 
  "InlineMath"],
 " the system is said to be square. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", ">", " ", "n"}], TraditionalForm]], "InlineMath"],
 " there are more equations than unknowns and the system is overdetermined. \
If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", "<", " ", "n"}], TraditionalForm]], "InlineMath"],
 " there are fewer equations than unknowns and the system is \
underdetermined."
}], "Text",
 CellID->1635841407],

Cell[BoxData[GridBox[{
   {Cell["Square", "TableHeader"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "=", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     "; solution may or may not exist "
    }], "TableText"]},
   {Cell["Overdetermined", "TableHeader"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], ">", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     "; solutions may or may not exist "
    }], "TableText"]},
   {Cell["Underdetermined", "TableHeader"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "<", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     "; no solutions or infinitely many solutions exist "
    }], "TableText"]},
   {Cell["Nonsingular", "TableHeader"], Cell["\<\
number of independent equations equal to the number of variables and \
determinant nonzero; a unique solution exists\
\>", "TableText"]},
   {Cell["Consistent", "TableHeader"], Cell[
    "at least one solution exists ", "TableText"]},
   {Cell["Inconsistent", "TableHeader"], Cell[
    "no solutions exist ", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellTags->"S3.7.8",
 CellID->1500878555],

Cell["\<\
Classes of linear systems represented by rectangular matrices. \
\>", "Caption",
 CellTags->"S3.7.8",
 CellID->922956223],

Cell[TextData[{
 "Note that even though you could solve the matrix equation by computing the \
inverse via ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "\[LongEqual]", 
    RowBox[{
     SuperscriptBox["A", 
      RowBox[{"-", "1"}]], ".", "B"}]}], TraditionalForm]], "InlineMath"],
 ", this is not a recommended method. You should use a function that is \
designed to solve linear systems directly and in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " this is provided by ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellID->850857680],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LinearSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinearSolve"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "a vector ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " that solves the matrix equation ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["m", "TI"], ".", 
        StyleBox["x", "TI"]}], "==", 
       StyleBox["b", "TI"]}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinearSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinearSolve"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a function that can be applied repeatedly to many ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.8",
 CellID->271422387],

Cell[TextData[{
 "Solving and linear systems with ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ". "
}], "Caption",
 CellTags->"S3.7.8",
 CellID->540792081],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " to solve a matrix equation."
}], "Text",
 CellID->941711263],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "6."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"5.4", ",", "2."}], "}"}]}], ";"}], "\n", 
 RowBox[{"X", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"A", ",", "B"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->386718851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "14.200000000000001`"}], ",", "9.8`"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1298212935]
}, Open  ]],

Cell["\<\
The solution can be tested to demonstrate that it solves the problem.\
\>", "Text",
 CellID->630945025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "X"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18786289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.4`", ",", "2.`"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->61063114]
}, Open  ]],

Cell["\<\
You can always generate the linear equations from the input matrices.\
\>", "Text",
 CellID->1938057379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", " ", 
  RowBox[{
   RowBox[{"A", ".", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "\[Equal]", "B"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2045894804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.`", " ", "x1"}], "+", 
     RowBox[{"2.`", " ", "x2"}]}], "\[Equal]", "5.4`"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"4.`", " ", "x1"}], "+", 
     RowBox[{"6.`", " ", "x2"}]}], "\[Equal]", "2.`"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1993298711]
}, Open  ]],

Cell["Solve can then be used to find the solution.", "Text",
 CellID->626542577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1188770398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x1", "\[Rule]", 
     RowBox[{"-", "14.200000000000001`"}]}], ",", 
    RowBox[{"x2", "\[Rule]", "9.8`"}]}], "}"}], "}"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1623711145]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " also works when the right-hand side of the matrix equation is also a \
matrix."
}], "Text",
 CellID->1638511586],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "6."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.4", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.6", ",", " ", "1.1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"X", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"A", ",", "B"}], "]"}]}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1281420421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10.6`"}], ",", 
     RowBox[{"-", "4.9`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.`", ",", "3.45`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1867003631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "X"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1846459900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.4`", ",", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.600000000000001`", ",", "1.0999999999999996`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->165356503]
}, Open  ]],

Cell[TextData[{
 "If the system is overdetermined, ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " will find a solution if it exists."
}], "Text",
 CellID->302906703],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "6."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "6."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"5.", ",", "6.", ",", "8.25"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->1416713931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "B"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1559844028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4.499999999999984`"}], ",", "4.749999999999986`"}], 
  "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1965699667]
}, Open  ]],

Cell[TextData[{
 "If no solution can be found, the system is inconsistent. In this case it \
might still be useful to find a best-fit solution. This is often done with a \
least squares technique, which is explored under \"",
 ButtonBox["Least Squares Solutions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#563250646"],
 "\". "
}], "Text",
 CellID->625877821],

Cell[TextData[{
 "If the system is underdetermined, there is either no solution or infinitely \
many solutions and ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " will return one."
}], "Text",
 CellID->753634541],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "6.", ",", "7."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"5.", ",", "6."}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->477180581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "B"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->1270086969],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.1666666666666687`"}], ",", "0.08333333333333258`", ",", 
   "2.3333333333333353`"}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->364236803]
}, Open  ]],

Cell[TextData[{
 "A system is consistent if and only if the rank of the matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " equals the rank of the matrix formed by adding ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 " as an extra column to ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " (known as the augmented matrix). The following demonstrates that the \
previous system is consistent."
}], "Text",
 CellID->1399554071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRank", "[", "A", "]"}], "\[Equal]", 
  RowBox[{"MatrixRank", "[", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "3.", ",", "5."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "6.", ",", "7.", ",", "6."}], "}"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[17]:=",
 CellID->916885706],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1902893517]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " can work with all the different types of matrices that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports, including symbolic and exact, machine number, and ",
 "arbitrary-precision",
 ". It also works with both dense and sparse matrices. When a sparse matrix \
is used in ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ", special techniques suitable for sparse matrices are used and the result \
is the solution vector."
}], "Text",
 CellID->1604869095],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{"i", "\[GreaterEqual]", "j"}]}], "\[RuleDelayed]", 
      RowBox[{"Random", "[", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"1.", ",", " ", "2.", ",", " ", "1.1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"X", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"A", ",", "B"}], "]"}]}]}], "Input",
 CellLabel->"In[18]:=",
 CellID->640273345],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0563749220528698`", ",", "1.6446357286954272`", ",", 
   "0.5172934756133131`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->33554298]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for solving ", "TableText"]},
   {
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], 
    StyleBox["0", "MR"], Cell[
    "take the equation to be modulo n  ", "TableText"]},
   {
    ButtonBox["ZeroTest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ZeroTest"], 
    StyleBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", " ", "\[Equal]", " ", "0"}], " ", "&"}], ")"}], "MR"], 
    Cell["\<\
the function to be used by symbolic methods for testing for zero  \
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S5.27.1",
 CellID->1306370972],

Cell[TextData[{
 "Options for ",
 StyleBox["LinearSolve", "MR"],
 ". "
}], "Caption",
 CellTags->"S3.7.8",
 CellID->304119476],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " has three options that allow users more control. The ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ZeroTest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZeroTest"]], "InlineFormula"],
 " options are used by symbolic techniques and are discussed in the section \
\"",
 ButtonBox["Symbolic and Exact Matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1644685080"],
 "\". The ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option allows you to choose methods that are known to be suitable for a \
particular problem; the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " means that ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " chooses a method based on the input."
}], "Text",
 CellID->324953272],

Cell[CellGroupData[{

Cell["Singular Matrices", "Subsection",
 CellTags->{"t:86", "c:82"},
 CellID->438728183],

Cell["\<\
A matrix is singular if its inverse does not exist. One way to test for \
singularity is to compute a determinant; this will be zero if the matrix is \
singular. For example, the following matrix is singular.\
\>", "Text",
 CellID->1393211530],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Det", "[", "A", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1691981469],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->728430488]
}, Open  ]],

Cell["For many right-hand sides there is no solution.", "Text",
 CellID->24664281],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"4.", ",", " ", "1."}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "B"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->68226896],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->62968202],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "1.`"}], "}"}]}], "]"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->405558254]
}, Open  ]],

Cell["However, for certain values there will be a solution.", "Text",
 CellID->1577212973],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"4.", ",", " ", "4."}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "B"}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1827782290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8`", ",", "1.5999999999999999`"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->108431656]
}, Open  ]],

Cell[TextData[{
 "For the first example, the rank of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " does not equal that of the augmented matrix. This confirms that the system \
is not consistent and cannot be solved by ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1361185177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRank", "[", "A", "]"}], "\[Equal]", 
  RowBox[{"MatrixRank", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "1."}], "}"}]}], "}"}], "]"}]}]], "Input",\

 CellLabel->"In[7]:=",
 CellID->295978348],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->197737291]
}, Open  ]],

Cell[TextData[{
 "For the second example, the rank of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " does equal that of the augmented matrix. This confirms that the system is \
consistent and can be solved by ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellID->502915613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRank", "[", "A", "]"}], "\[Equal]", 
  RowBox[{"MatrixRank", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "4."}], "}"}]}], "}"}], "]"}]}]], "Input",\

 CellLabel->"In[8]:=",
 CellID->7073099],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->61245652]
}, Open  ]],

Cell[TextData[{
 "In those cases where a solution cannot be found, it is still possible to \
find a solution that makes a best-fit to the problem. One important class of \
best-fit solutions involves least squares solutions and is discussed in a \
later ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#563250646"],
 "."
}], "Text",
 CellID->1713214438]
}, Open  ]],

Cell[CellGroupData[{

Cell["Homogeneous Equations", "Subsection",
 CellTags->{"t:86", "c:83"},
 CellID->534320490],

Cell["\<\
The homogeneous matrix equation involves a zero right-hand side.\
\>", "Text",
 CellID->1695347323],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"A", ".", "x"}], "\[LongEqual]", "0"}], 
  TraditionalForm]], "NumberedEquation",
 CellID->889429265],

Cell["\<\
This equation has a nonzero solution if the matrix is singular. To test if a \
matrix is singular, you can compute the determinant.\
\>", "Text",
 CellID->3990088],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Det", "[", "A", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->489415959],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->751654903]
}, Open  ]],

Cell[TextData[{
 "To find the solution of the homogeneous equation you can use the function \
",
 Cell[BoxData[
  ButtonBox["NullSpace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NullSpace"]], "InlineFormula"],
 ". This returns a set of orthogonal vectors, each of which solves the \
homogeneous equation. In the example below, there is only one vector."
}], "Text",
 CellID->1565143067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"null", "=", 
  RowBox[{"NullSpace", "[", "A", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->832334966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "0.8944271909999157`"}], ",", "0.4472135954999581`"}], "}"}],
   "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->345297004]
}, Open  ]],

Cell["\<\
This demonstrates that the solution in fact solves the homogeneous equation.\
\>", "Text",
 CellID->905932034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", 
  RowBox[{"null", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->340638208],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.440892098500626`*^-16", ",", "4.440892098500626`*^-16"}], 
  "}"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2062442601]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " can be used to replace approximate numbers close to 0."
}], "Text",
 CellID->939248780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Chop"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1949440010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->80245791]
}, Open  ]],

Cell["\<\
The solution to the homogeneous equation can be used to form an infinite \
number of solutions to the inhomogeneous equation. This solves an \
inhomogeneous equation.\
\>", "Text",
 CellID->71279021],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"4.", ",", "4."}], "}"}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"A", ",", "B"}], "]"}]}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->1838114568],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8`", ",", "1.5999999999999999`"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1639282281]
}, Open  ]],

Cell["The solution does in fact solve the equation.", "Text",
 CellID->1349589404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "sol"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->826833414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.`", ",", "4.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->222509361]
}, Open  ]],

Cell[TextData[{
 "If you add to ",
 StyleBox["sol", "MR"],
 " an arbitrary factor times the homogeneous solution, this new vector also \
solves the matrix equation."
}], "Text",
 CellID->945800900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", 
  RowBox[{"(", 
   RowBox[{"sol", "+", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], "  ", 
     RowBox[{"null", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->401771206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.9999999999999996`", ",", "3.9999999999999996`"}], 
  "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->880073074]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Estimating and Calculating Accuracy", "Subsection",
 CellTags->"c:84",
 CellID->1668277829],

Cell[TextData[{
 "An important way to quantify the accuracy of the solution of a linear \
system is to compute the condition number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Kappa]", "(", "A", ")"}], TraditionalForm]], "InlineMath"],
 ". This is defined as follows for a suitable choice of norm."
}], "Text",
 CellID->1198976771],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Kappa]", "(", "A", ")"}], "\[LongEqual]", 
   "\[DoubleVerticalBar]", "A", "\[DoubleVerticalBar]", " ", 
   "\[DoubleVerticalBar]", 
   SuperscriptBox["A", 
    RowBox[{"-", "1"}]], "\[DoubleVerticalBar]"}], 
  TraditionalForm]], "NumberedEquation",
 CellID->1363530396],

Cell[TextData[{
 "It can be shown that for the matrix equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", "x"}], " ", "\[LongEqual]", " ", "B"}], 
   TraditionalForm]], "InlineMath"],
 " the relative error in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Kappa]", "(", "A", ")"}], TraditionalForm]], "InlineMath"],
 " times the relative error in ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 ". Thus, the condition number quantifies the accuracy of the solution. If \
the condition number of a matrix is large, the matrix is said to be \
ill-conditioned. You cannot expect a good solution from an ill-conditioned \
system. For some extremely ill-conditioned systems it is not possible to \
obtain any solution."
}], "Text",
 CellID->1057368435],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " an approximation of the condition number can be computed with the function \
",
 StyleBox["LinearAlgebra`MatrixConditionNumber", "MR"],
 "."
}], "Text",
 CellID->764108120],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["LinearAlgebra`MatrixConditionNumber", "MR"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell["\<\
infinity\[Hyphen]norm approximate condition number of a matrix of approximate \
numbers \
\>", "TableText"]},
   {
    RowBox[{
     StyleBox["LinearAlgebra`MatrixConditionNumber", "MR"], "[", 
     RowBox[{
      StyleBox["mat", "TI"], ",", 
      RowBox[{"Norm", "\[Rule]", 
       StyleBox["p", "TI"]}]}], "]"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "\[Hyphen]norm approximate condition number of a matrix, where ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " may be 1, 2, or \[Infinity]"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S5.48.1",
 CellID->412963780],

Cell["This computes the condition number of a matrix.", "Text",
 CellID->439033946],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearAlgebra`MatrixConditionNumber", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->89719330],

Cell[BoxData["20.999999999999996`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171847193]
}, Open  ]],

Cell["\<\
This matrix is singular and the condition number is \[Infinity].\
\>", "Text",
 CellID->476498316],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearAlgebra`MatrixConditionNumber", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->540677349],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->139783744]
}, Open  ]],

Cell["\<\
This matrix has a large condition number and is said to be ill-conditioned.\
\>", "Text",
 CellID->1259651107],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6", ",", 
        RowBox[{"9", "+", 
         RowBox[{
          SuperscriptBox["10", "11"], " ", "$MachineEpsilon"}]}]}], "}"}]}], 
     "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"LinearAlgebra`MatrixConditionNumber", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1062363223],

Cell[BoxData["6.4852214635234475`*^6"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->19623054]
}, Open  ]],

Cell["\<\
If a matrix is multiplied with itself, the condition number increases.\
\>", "Text",
 CellID->1198436051],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat2", "=", 
   RowBox[{"mat", ".", "mat"}]}], ";"}], "\n", 
 RowBox[{"LinearAlgebra`MatrixConditionNumber", "[", "mat2", "]"}]}], "Input",\

 CellLabel->"In[7]:=",
 CellID->865583944],

Cell[BoxData["8.761907747829572`*^12"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->156979015]
}, Open  ]],

Cell["\<\
When you solve a matrix equation involving an ill-conditioned matrix, the \
result may not be as accurate. \
\>", "Text",
 CellID->957773997],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "vec"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"mat", ".", "sol"}], "-", "vec"}], "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1917633314],

Cell[BoxData["2.2511831156933222`*^-10"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->8023336]
}, Open  ]],

Cell[TextData[{
 "The solution is less accurate for the matrix ",
 StyleBox["mat2", "MR"],
 "."
}], "Text",
 CellID->1273908318],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat2", ",", "vec"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"mat2", ".", "sol"}], "-", "vec"}], "]"}]}], "Input",
 CellLabel->"In[12]:=",
 CellID->165140036],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(LinearSolve\\) of badly conditioned matrix \
\\!\\({\\(\\({18.`, 30.`, 42.00006661338148`}\\)\\), \
\\(\\({\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)}\\)\\), \
\\(\\({54.00006661338148`, \\(\\(\[LeftSkeleton] 18 \[RightSkeleton]\\)\\), \
126.0003996807819`}\\)\\)}\\) may contain significant numerical errors. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/luc\\\", \
ButtonNote -> \\\"LinearSolve::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[12]:=",
 CellID->609849313],

Cell[BoxData["0.0003049616241515566`"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->40334265]
}, Open  ]],

Cell[TextData[{
 "The solution to these problems is to avoid constructing matrices that may \
be ill-conditioned, for example, by avoiding multiplying matrices by \
themselves. Another method of solving problems more accurately is to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " arbitrary-precision computation; this is discussed under \"",
 ButtonBox["Arbitrary-Precision Matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#2139022291"],
 "\"."
}], "Text",
 CellID->148869679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"matAcc", " ", "=", " ", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"mat2", ",", "16"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"matAcc", ",", "vec"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"matAcc", ".", "sol"}], "-", "vec"}], "]"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->234246198],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->20988720]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic and Exact Matrices", "Subsection",
 CellTags->{"t:87", "c:85"},
 CellID->1644685080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " works for all the different types of matrices that can be represented in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". These are described in more detail in \"",
 ButtonBox["Matrix Types",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#1880892864"],
 "\". Here is an example of working with purely symbolic matrices."
}], "Text",
 CellID->1960119023],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1", ",", "x2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x3", ",", "x4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "A", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1321274581],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x1", "x2"},
     {"x3", "x4"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{60, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1680972887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"y1", ",", "y2"}], "}"}]}], ";"}], "\n", 
 RowBox[{"X", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"A", ",", "b"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1963935524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"x4", " ", "y1"}], "-", 
     RowBox[{"x2", " ", "y2"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", "x2"}], " ", "x3"}], "+", 
     RowBox[{"x1", " ", "x4"}]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"x3", " ", "y1"}], "-", 
     RowBox[{"x1", " ", "y2"}]}], 
    RowBox[{
     RowBox[{"x2", " ", "x3"}], "-", 
     RowBox[{"x1", " ", "x4"}]}]]}], "}"}]], "Output",
 ImageSize->{195, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1040697478]
}, Open  ]],

Cell["The original matrix can be multiplied into the solution.", "Text",
 CellID->1895691578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "X"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->820964554],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"x2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x3", " ", "y1"}], "-", 
        RowBox[{"x1", " ", "y2"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"x2", " ", "x3"}], "-", 
      RowBox[{"x1", " ", "x4"}]}]], "+", 
    FractionBox[
     RowBox[{"x1", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x4", " ", "y1"}], "-", 
        RowBox[{"x2", " ", "y2"}]}], ")"}]}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x2"}], " ", "x3"}], "+", 
      RowBox[{"x1", " ", "x4"}]}]]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"x4", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x3", " ", "y1"}], "-", 
        RowBox[{"x1", " ", "y2"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"x2", " ", "x3"}], "-", 
      RowBox[{"x1", " ", "x4"}]}]], "+", 
    FractionBox[
     RowBox[{"x3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x4", " ", "y1"}], "-", 
        RowBox[{"x2", " ", "y2"}]}], ")"}]}], 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x2"}], " ", "x3"}], "+", 
      RowBox[{"x1", " ", "x4"}]}]]}]}], "}"}]], "Output",
 ImageSize->{494, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->368827103]
}, Open  ]],

Cell[TextData[{
 "The result of multiplication needs some post-processing with ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to reach the expected value. This demonstrates the need for intermediate \
processing in symbolic linear algebra computation. Without care these \
intermediate results can become extremely large and make the computation run \
slowly."
}], "Text",
 CellID->1239314879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Simplify"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->721279100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y1", ",", "y2"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2140130032]
}, Open  ]],

Cell[TextData[{
 "In order to simplify the intermediate expressions, the ",
 Cell[BoxData[
  ButtonBox["ZeroTest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZeroTest"]], "InlineFormula"],
 " option might be useful. "
}], "Text",
 CellID->961844221],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " can also be used to solve exact problems."
}], "Text",
 CellID->1606411378],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "A", "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->791619962],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2"},
     {"3", "4"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->1095508169]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", "8"}], "}"}]}], ";"}], "\n", 
 RowBox[{"X", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"A", ",", "b"}], "]"}]}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1828490652],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", "5"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->951399594]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "X"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->9740796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "8"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->504801200]
}, Open  ]],

Cell[TextData[{
 "There are a number of methods that are specific to symbolic and exact \
computation: ",
 StyleBox["CofactorExpansion", "MR"],
 ", ",
 StyleBox["DivisionFreeRowReduction", "MR"],
 ", and ",
 StyleBox["OneStepRowReduction", "MR"],
 ". These are discussed in the section on \"",
 ButtonBox["Symbolic Methods",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1813753518"],
 "\"."
}], "Text",
 CellID->1633362750],

Cell[CellGroupData[{

Cell["Row Reduction", "Subsubsection",
 CellTags->{"t:148", "c:86"},
 CellID->644279649],

Cell[TextData[{
 "Row reduction involves adding multiples of rows together so as to produce \
zero elements when possible. The final matrix is in reduced row echelon form \
as described ",
 ButtonBox["previously",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#2032866165"],
 ". If the input matrix is a non-singular square matrix, the result will be \
an identity matrix. "
}], "Text",
 CellID->795512569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2094044608],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1645719620]
}, Open  ]],

Cell["This can be used as a way to solve a system of equations.", "Text",
 CellID->20279980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "y"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1543207634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{
      RowBox[{"-", "x"}], "+", 
      RowBox[{"2", " ", "y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"x", "-", "y"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{201, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1530699819]
}, Open  ]],

Cell[TextData[{
 "This can be compared with the following use of ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1765250520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1078906335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    RowBox[{"2", " ", "y"}]}], ",", 
   RowBox[{"x", "-", "y"}]}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1974340724]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Saving the Factorization", "Subsection",
 CellTags->{"t:47", "c:87"},
 CellID->1974718471],

Cell[TextData[{
 "Many applications of linear systems involve the same matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " but different right-hand sides ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 ". Because a significant part of the effort involved in solving the system \
involves processing ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 ", it is common to save the factorization and use it to solve repeated \
problems. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", this is done by using a one-argument form of ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 "; this returns a functional that you can apply to different vectors to \
obtain each solution."
}], "Text",
 CellID->1881061359],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "6."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"fun", "=", 
  RowBox[{"LinearSolve", "[", "A", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1891493226],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92047681]
}, Open  ]],

Cell[TextData[{
 "When you can apply the ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " to a particular right-hand side the solution is obtained."
}], "Text",
 CellID->506424029],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"1.", ",", " ", "20."}], "}"}]}], ";"}], "\n", 
 RowBox[{"X", "=", 
  RowBox[{"fun", "[", "B", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->990962342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17.`", ",", 
   RowBox[{"-", "8.`"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->895485530]
}, Open  ]],

Cell["This solves the matrix equation.", "Text",
 CellID->1288172040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "X"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1524830873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "20.`"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->154706783]
}, Open  ]],

Cell["A different right-hand side yields a different solution.", "Text",
 CellID->701869017],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"11.", ",", " ", "2."}], "}"}]}], ";"}], "\n", 
 RowBox[{"X", "=", 
  RowBox[{"fun", "[", "B", "]"}]}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->184895748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "31.`"}], ",", "21.`"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->299596259]
}, Open  ]],

Cell["This new solution solves this matrix equation.", "Text",
 CellID->1565507533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "X"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->515464087],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11.`", ",", "2.`"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->332824869]
}, Open  ]],

Cell[TextData[{
 "The one argument form of ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " works in a completely equivalent way to the two argument form. It works \
with the same range of input matrices, for example, returning the expected \
results for symbolic, exact, or sparse matrix input. It also accepts the same \
options. "
}], "Text",
 CellID->1870923428],

Cell["\<\
One issue with the one argument form is that for certain input matrices the \
factorization cannot be saved. For example, if the system is overdetermined, \
the exact solution is not certain to exist. In this case a message is \
generated that warns you that the factorization will be repeated each time \
the functional is applied to a particular right-hand side.\
\>", "Text",
 CellID->1154495022],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "6."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "6."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"fun", "=", 
  RowBox[{"LinearSolve", "[", "A", "]"}]}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1083084109],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"sqmat1\"\>"}], ":", 
  " ", "\<\"The matrix \\!\\({\\(\\({1.`, 2.`}\\)\\), \\(\\({5.`, 6.`}\\)\\), \
\\(\\({4.5`, 6.`}\\)\\)}\\) is not square so a factorization will not be \
saved.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->194050909],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->390539149]
}, Open  ]],

Cell["\<\
For this right-hand side there is a solution, and this is returned.\
\>", "Text",
 CellID->311955258],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"5.", ",", "6.", ",", "8.25"}], "}"}]}], ";"}], "\n", 
 RowBox[{"fun", "[", "B", "]"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->1024438879],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4.499999999999985`"}], ",", "4.749999999999987`"}], 
  "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->3416101]
}, Open  ]],

Cell["\<\
However, for this right-hand side there is no solution, and an error is \
encountered.\
\>", "Text",
 CellID->497195543],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"5.", ",", "6.", ",", "1."}], "}"}]}], ";"}], "\n", 
 RowBox[{"fun", "[", "B", "]"}]}], "Input",
 CellLabel->"In[13]:=",
 CellID->506620724],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[13]:=",
 CellID->258154749],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"LinearSolveFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
   False,
   Editable->False], "[", 
  RowBox[{"{", 
   RowBox[{"5.`", ",", "6.`", ",", "1.`"}], "}"}], "]"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->131536475]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Methods", "Subsection",
 CellTags->{"t:89", "c:88"},
 CellID->834729047],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " provides a number of different techniques to solve matrix equations that \
are specialized to particular problems. You can select between these using \
the option ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 ". In this way a uniform interface is provided to all the functionality that \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides for solving matrix equations."
}], "Text",
 CellID->1927910725],

Cell[TextData[{
 "The default setting of the option ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". As is typical for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", this means that the system will make an automatic choice of method to \
use. For ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " if the input matrix is numerical and dense, then a ",
 ButtonBox["method using LAPACK",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1131477137"],
 " routines is used; if it is numerical and sparse, a ",
 ButtonBox["multifrontal direct solver",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1415618539"],
 " is used. If the matrix is symbolic then ",
 ButtonBox["specialized symbolic routines",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1813753518"],
 " are used."
}], "Text",
 CellID->1162289139],

Cell["The details of the different methods are now described.", "Text",
 CellID->1082306061],

Cell[CellGroupData[{

Cell["LAPACK", "Subsubsection",
 CellTags->{"t:145", "c:89"},
 CellID->1131477137],

Cell[TextData[{
 "LAPACK is the default method for solving dense numerical matrices. When the \
matrix is square and non-singular the routines dgesv, dlange, and dgecon are \
used for real matrices and zgesv, zlange, and zgecon for complex matrices. \
When the matrix is non-square or singular dgelss is used for real matrices \
and zgelss for complex matrices. More information on LAPACK is available in \
the ",
 ButtonBox["references",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#513881229"],
 "."
}], "Text",
 CellID->768547374],

Cell["\<\
If the input matrix uses arbitrary-precision numbers, then LAPACK algorithms \
extended for arbitrary-precision computation are used. \
\>", "Text",
 CellID->2009061760]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multifrontal", "Subsubsection",
 CellTags->{"t:90", "c:90"},
 CellID->1415618539],

Cell["\<\
The Multifrontal method is a direct solver used by default if the input \
matrix is sparse; it can also be selected by specifying a method option.\
\>", "Text",
 CellID->329459860],

Cell[TextData[{
 "This reads in a sample sparse matrix stored in the Matrix Market format. \
More information on the importing of matrices is under \"",
 ButtonBox["Import and Export of Sparse Matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#212323487"],
 "\"."
}], "Text",
 CellID->1019025054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<LinearAlgebraExamples/Data/dwg961b.mtx\>\"", ",", 
    "\"\<MatrixMarket\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571997753],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10591", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10591, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"961", ",", "961"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{225, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275219561]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "961", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542199104],

Cell["This solves the matrix equation using the sample matrix.", "Text",
 CellID->967226707],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "[", " ", 
   RowBox[{"sp", ",", "vec", ",", 
    RowBox[{"Method", "\[Rule]", "Multifrontal"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1875540406],

Cell["\<\
If the input matrix to the Multifrontal method is dense, it is converted to a \
sparse matrix.\
\>", "Text",
 CellID->1442632976],

Cell[TextData[{
 "The implementation of the Multifrontal method uses the \"",
 ButtonBox["UMFPACK",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#83486633"],
 "\" library."
}], "Text",
 CellID->1242053002]
}, Open  ]],

Cell[CellGroupData[{

Cell["Krylov", "Subsubsection",
 CellTags->{"t:91", "c:91"},
 CellID->1643755774],

Cell[TextData[{
 "The Krylov method is an iterative solver that is suitable for large sparse \
linear systems, such as those arising from numerical solving of PDEs. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " two Krylov methods are implemented: Conjugate Gradient (for symmetric \
positive definite matrices) and BiCGSTAB (for non-symmetric systems). It is \
possible to set the method that is used and a number of other parameters by \
using appropriate sub-options."
}], "Text",
 CellID->1373658610],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of iterations ", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    StyleBox["BiCGSTAB", "MR"], Cell[
    "the method to use for solving ", "TableText"]},
   {
    StyleBox["Preconditioner", "MR"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the preconditioner ", "TableText"]},
   {"ResidualNormFunction", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the norm to minimize", "TableText"]},
   {
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the tolerance to use to terminate the iteration  ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S5.27.1",
 CellID->1631053020],

Cell["Sub-options of the Krylov method. ", "Caption",
 CellTags->"S3.7.9",
 CellID->479353185],

Cell["\<\
The default method for Krylov, BiCGSTAB, is more expensive but more generally \
applicable. The ConjugateGradient method is suitable for symmetric positive \
definite systems, always converging to a solution (though the convergence may \
be slow). If the matrix is not symmetric positive definite the \
ConjugateGradient may not converge to a solution. In this example, the matrix \
is not symmetric positive definite and the ConjugateGradient method does not \
converge.\
\>", "Text",
 CellID->1277820398],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "100."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3."}], ",", ".1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"1.2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"mat", ",", "vec", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Krylov", ",", 
      RowBox[{"Method", "\[Rule]", "ConjugateGradient"}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1490959186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.9992669110296567`"}], ",", "0.021992669110296566`"}], 
  "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->436969947]
}, Open  ]],

Cell["\<\
The default method, BiCGSTAB, converges and returns the solution.\
\>", "Text",
 CellID->251630266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"mat", ",", "vec", ",", 
    RowBox[{"Method", "\[Rule]", "Krylov"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->754579719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.9992669110296569`"}], ",", "0.02199266911029657`"}], 
  "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->379015713]
}, Open  ]],

Cell["This tests the solution that was found.", "Text",
 CellID->461605722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"mat", ".", "sol"}], "-", "vec"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1496436690],

Cell[BoxData["4.965068306494546`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->14355832]
}, Open  ]],

Cell["\<\
Here is an example that shows the benefit of the Krylov method and the use of \
a preconditioner. First, a function that builds a structured banded sparse \
matrix is defined.\
\>", "Text",
 CellID->641841926],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BandedMatrix", "[", "n_", "]"}], ":=", " ", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "A", ",", "spar", ",", "diag", ",", " ", "udiag", ",", " ", "udiag2", 
       ",", " ", "ldiag", ",", " ", "ldiag2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"diag", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", "i"}], "}"}], "\[Rule]", "14."}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"udiag", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"i", "+", "1"}]}], "}"}], "\[Rule]", "3."}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"udiag2", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"i", "+", "8"}]}], "}"}], "\[Rule]", 
          RowBox[{"-", "1."}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"n", "-", "8"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ldiag", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "+", "1"}], ",", "i"}], "}"}], "\[Rule]", "5."}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ldiag2", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"i", "+", "500"}], ",", "i"}], "}"}], "\[Rule]", 
          RowBox[{"-", "4."}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"n", "-", "500"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"spar", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{
         "diag", ",", "udiag", ",", "udiag2", ",", "ldiag", ",", "ldiag2"}], 
         "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"A", "=", 
       RowBox[{"SparseArray", "[", 
        RowBox[{"spar", ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->626891401],

Cell["\<\
This demonstrates the structure of the matrices generated by this function.\
\>", "Text",
 CellID->609004425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"BandedMatrix", "[", "700", "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->630309373],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW+9zE0UY3uYS2pqS0qQ2pElK2mkRFAYUlQ4oKGgRtCgMKCgl1Pqj6CBQ
wBFGGR2VD37iI3+Fn/j/1t27S7J597nce9dsOoztpLfZu32efd4fu7eXu1te
vb/+7a3V+zfXVhtnNlbvrN9cu9dYur2hdnlDQojn6v/f3UJ9l+qb//9cSlXa
25LaeqrBjCqzqsyoMqNKLyxrupU+IFt/5tEqqbfKEY3y2iiLdcLve5K00hpE
Lqi3tz621YrW9ddKt0IGoqw3O0wED5cz9LWhsagCtHVPKtUaIIbbmiP9tBkr
dyRWhi1s9EBF6qXHY/S/iHbulsEYSGKfl6B9v+yqp/RrUvt0++SjKptSXWBr
KdTYkHj+6j3r1QwL6azngf3BbBc1AxfV9qkIyhAUyqeqclZk9xLr5mPqExaD
R1pQ7Z6lihvXjCu1rFzRp8EhXfr7bC1xeZIJY/lPWGZZDP3o1awv+PX8ZHVk
oqY+4rqOSr1aFLnZQrcPtkbfvKFPf73uMyqBSp76FMpVlF9JdaYZ5ymVsr0R
oTQbHhKt49b4NTTN6f1KkvACUXrfit7kAl1KlPoUKzVBtEk8zwSDtEh6mY3K
oWzQheJXnyxB7YJce2IUtxmDs9DA+WaIrU3ozWEWVx1kjO03utJ1z1Vl++wl
Ft90TH4EZHkWVwXY2T3KMoprbOBc5RifdXKjwOKbivFZEM9xyNU6lwphrzvo
DDHJjjU5V0q8rgm77sN8mlpZunm1D4pLJGZNGP/iFqrV1aKhUkbOFBOSf02A
NSa5oqB1nsYSQcX1SHyYdsVJxhsvR1/295qjpzU6eWpbZ+K4M/44yUE8104B
uxA7Pt8XQHTsebMsbV+55RqLiUZnDFZYfPkYXwZZOM3iGmVnSm1L+EaIrU3o
tzqLaxjE1PbbzMC5cmyfNVh82Zj8CMhmWVwesNMeB3OD4eo+y7NGFL2yhmyK
KaOIcAwXOAwK3YQRe8UV2thrYjuW72NhV6DN+51jr0F7X2Nhv5Qonw+wsFcl
yrmDzrFXYIwOsbCfQz8fZmEvQz+/4Rx7Cdp7hIW9CO190zn2ArT3bYglv+bI
3qufTyXK2KOkVW9OD/XLXF+b9fMSZfFiby2slXWSezTpVMX1QFfSpH/mSlpX
l41c6OTvojSuPpjseHWfVJNZ/1iiHD8Os2ewys4ZXuuMoHc3qSzZWOuhIeFY
o/PDWZgTJ0grPLecgTE7ycIuQYved479QKJZ6xQLe1qi8XzaOfYUjNGHLOx7
MEZLLOxJ6OePnGNPQHvPsrDvQHvPsbDHoeZPnGOPQXuXWdhFaO9559ij0N7P
WNi3JBqDF1hYf9VjjaOLzrFHYIwusbCvQz9fZmEPQz9/4Rx7CNp7hYU9CO29
6hx7ANr7FQv7qkQ5eY2F3Q/zaqXvWPREF10p7INxa5JWiKl1NyEozG3S1fhe
GMMb+tCouToh3Ti9878Ac+OGTP88gNejZ46XsKKvSStOL/3VNQ8zaG3Tuvpx
12cOZtY3ibIiQl2C+3gsFdIeXTF39a1c+I606nHX3Zq5vmdh/d9yrdln3Tm2
DnPsBxa2Cr3/Iws7Df18yzm2Au39iYUtQ3tvO8dOQXvvsrCTEuXkBgtbgnl1
zzm2CGP0gIXdBf38Mws7Dv38i3NsAdr7kIUdg/Y+co7NQ3t/ZWFHJcrJ31jY
EZhXj51jh2GMfmdhc9DPf7CwWejnP51jPWjvX9HY7vOtZe3fEKmzCKz6ohms
Z/X855QEfVqJPNenuDKKSngBmT74hCDo+iYfyaur3Zn7xLSCxdHv53dfhJ6f
RrbWW70iexaWO/2922/WdK8ett+sicJtv1nj1s7tN2vs9v/PN2vE0H/IPGSE
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->188140415]
}, Open  ]],

Cell["\<\
This builds a larger system, with a 10000\[Cross]10000 matrix.\
\>", "Text",
 CellID->1654262377],

Cell[BoxData[{
 RowBox[{
  RowBox[{"num", " ", "=", " ", "10000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"BandedMatrix", "[", "num", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", " ", "=", " ", 
   RowBox[{"mat", ".", 
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "num"}], "}"}]}], "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->1864476177],

Cell[TextData[{
 "This will use the default sparse solver, a ",
 ButtonBox["multifrontal",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1415618539"],
 " direct solver."
}], "Text",
 CellID->169729815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"mat", ",", "vec"}], "]"}]}], ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->790717489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.328`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->667578673]
}, Open  ]],

Cell["The Krylov method is faster.", "Text",
 CellID->1179351598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "vec", ",", 
     RowBox[{"Method", "->", "Krylov"}]}], "]"}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->88245776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.11000000000000004`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->132366419]
}, Open  ]],

Cell["\<\
The use of the ILU preconditioner is even faster. Currently, the \
preconditioner can only work if the matrix has nonzero diagonal elements.\
\>", "Text",
 CellID->403764086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "vec", ",", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Krylov", ",", 
        RowBox[{"Preconditioner", "\[Rule]", "ILU0"}]}], "}"}]}]}], "]"}], 
   ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->14668882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01599999999999993`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->5242608]
}, Open  ]],

Cell["\<\
At present, only the ILU preconditioner is built-in. You can still define \
your own preconditioner by defining a function that is applied to the input \
matrix. An example that involves solving a diagonal matrix is shown below. \
First the problem is set up and solved without a preconditioner.\
\>", "Text",
 CellID->628811354],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"num", "=", "10000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"N", "[", "i", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"num", ",", "num"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rhs", "=", 
   RowBox[{"mat", ".", 
    RowBox[{"Table", "[", 
     RowBox[{"1.", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "rhs", ",", 
     RowBox[{"Method", "\[Rule]", "Krylov"}]}], "]"}], ";"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->665399791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.015999999999999917`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->36419334]
}, Open  ]],

Cell[TextData[{
 "Now, a preconditioner function ",
 StyleBox["fun", "MR"],
 " is used; there is a significant improvement to the speed of the \
computation."
}], "Text",
 CellID->1587130207],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fun", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "/", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"N", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "num"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "rhs", ",", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Krylov", ",", 
        RowBox[{"Preconditioner", "\[Rule]", "fun"}]}], "}"}]}]}], "]"}], 
   ";"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[19]:=",
 CellID->1003009662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01599999999999989`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->22537556]
}, Open  ]],

Cell["\<\
Generally, a problem will not be structured so that it can benefit so much \
from such a simple preconditioner. However, this example is useful since it \
shows how to create and use your own preconditioner.\
\>", "Text",
 CellID->914194054],

Cell["\<\
If the input matrix to the Krylov method is dense, the result is still found \
because the method is based on matrix/vector multiplication.\
\>", "Text",
 CellID->1761454940],

Cell["\<\
The Krylov method can be used to solve systems that are too large for a \
direct solver. However, it is not a general solver, being particularly \
suitable for those problems that have some form of diagonal dominance. \
\>", "Text",
 CellID->1711102685]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cholesky", "Subsubsection",
 CellTags->{"t:92", "c:92"},
 CellID->1549309818],

Cell[TextData[{
 "The ",
 StyleBox["Cholesky", "MR"],
 " method is suitable for solving symmetric positive definite systems."
}], "Text",
 CellID->1010891251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<LinearAlgebraExamples/Data/nos6.mtx\>\"", ",", 
    "\"\<MatrixMarket\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1306124140],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3255", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3255, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"675", ",", "675"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130199739]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "675", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->893342900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"sp", ",", "B"}], "]"}], ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1355944123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01599999999999996`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104099578]
}, Open  ]],

Cell["The Cholesky method is faster for this matrix.", "Text",
 CellID->1686086797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"sp", ",", " ", "B", ",", 
     RowBox[{"Method", "\[Rule]", "Cholesky"}]}], "]"}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2014075014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.015999999999999903`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->239566920]
}, Open  ]],

Cell["\<\
The Cholesky method is also more stable. This can be demonstrated with the \
following matrix.\
\>", "Text",
 CellID->1065101602],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "1000", "}"}], ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"mat", ".", 
    RowBox[{"Transpose", "[", "mat", "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1886427069],

Cell["\<\
For this matrix the default LU decomposition method reports a potential \
error.\
\>", "Text",
 CellID->1878668022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", "mat", "]"}], ";"}], "//", "Timing"}]], "Input",\

 CellLabel->"In[7]:=",
 CellID->321383913],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(LinearSolve\\) of badly conditioned matrix \
\\!\\({\\(\\({339.27127508034033`, 252.02956544940236`, \\(\\(\[LeftSkeleton] \
7 \[RightSkeleton]\\)\\), 251.0981760391908`, \\(\\(\[LeftSkeleton] 990 \
\[RightSkeleton]\\)\\)}\\)\\), \\(\\(\[LeftSkeleton] 9 \
\[RightSkeleton]\\)\\), \\(\\(\[LeftSkeleton] 990 \[RightSkeleton]\\)\\)}\\) \
may contain significant numerical errors. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/luc\\\", ButtonNote -> \
\\\"LinearSolve::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[7]:=",
 CellID->606905512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.265`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->745733211]
}, Open  ]],

Cell["The Cholesky method succeeds.", "Text",
 CellID->280602084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", 
     RowBox[{"Method", "\[Rule]", "Cholesky"}]}], "]"}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->205136976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.12499999999999999`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->660130147]
}, Open  ]],

Cell[TextData[{
 "For dense matrices the Cholesky method uses LAPACK functions such as dpotrf \
and dpotrs for real matrices and zpotrf and zpotrs for complex matrices. For \
sparse matrices the Cholesky method uses the \"",
 ButtonBox["TAUCS",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#165728992"],
 "\" library."
}], "Text",
 CellID->192023216]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Methods", "Subsubsection",
 CellTags->{"t:93", "c:93"},
 CellID->1813753518],

Cell[TextData[{
 "There are a number of methods that are specific to symbolic and exact \
computation: ",
 StyleBox["CofactorExpansion", "MR"],
 ", ",
 StyleBox["DivisionFreeRowReduction", "MR"],
 ", and ",
 StyleBox["OneStepRowReduction", "MR"],
 ". These can be demonstrated for the following symbolic matrix."
}], "Text",
 CellID->225007861],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a13", "*", "a2"}], ",", "a5", ",", 
       RowBox[{
        RowBox[{"6", "^", 
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}]}], "*", "a1"}], ",", 
       RowBox[{"2", "*", "a14"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"18", "*", "a12"}], ",", 
       RowBox[{
        RowBox[{"-", "3"}], "*", "a16"}], ",", 
       RowBox[{"3", "*", "a9"}], ",", 
       RowBox[{"a1", "+", "a3", "+", "a4"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"7", "*", "a15"}], ",", 
       RowBox[{
        RowBox[{"15", "/", "14"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"12", "*", "a11"}], ")"}], "/", "23"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"9", "*", "a2"}], ")"}], "/", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"24", "*", "a5"}], ")"}], "/", "7"}], "+", 
        RowBox[{"a9", "/", "5"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], "/", "23"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"17", "*", "a152"}], ")"}], "/", "29"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"9", "*", "a3"}], ")"}], "/", "4"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"30", "*", "a15", "*", "a5"}], ")"}], "/", "23"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "*", "a52"}], ")"}], "/", "29"}], "-", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"5", "*", "a6"}], ")"}], "/", "24"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "*", "a8"}], ")"}], "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "9"}], "/", "16"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "*", "a12"}], ")"}], "/", "17"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"7", "*", "a122"}], ")"}], "/", "5"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"9", "*", "a163"}], ")"}], "/", "13"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"7", "*", "a13", "*", "a72"}], ")"}], "/", "11"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"10", "*", "a73"}], ")"}], "/", "7"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"a11", "+", "a4"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"11", "*", "a11"}], ")"}], "/", "9"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "9"}], "/", "26"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"13", "*", "a14"}], ")"}], "/", "29"}], "+", 
        RowBox[{"7", "*", "a142"}], "+", 
        RowBox[{"a15", "/", "4"}], "+", 
        RowBox[{"25", "*", "a153"}], "-", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "*", "a2"}], ")"}], "/", "3"}], "-", 
        RowBox[{"a22", "/", "6"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "*", "a15", "*", "a22"}], ")"}], "/", "3"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"29", "*", "a4"}], ")"}], "/", "23"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"25", "*", "a22", "*", "a4"}], ")"}], "/", "21"}]}]}], 
      "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "3", ",", "0"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2135901107],

Cell["The computation is repeated for all three methods.", "Text",
 CellID->753262097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ByteCount", "[", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "vec", ",", " ", 
     RowBox[{"Method", " ", "\[Rule]", " ", "CofactorExpansion"}]}], "]"}], 
   "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->659965214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.7820000000000036`", " ", "Second"}], ",", "55208"}], 
  "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->282314943]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ByteCount", "[", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "vec", ",", " ", 
     RowBox[{"Method", " ", "\[Rule]", " ", "DivisionFreeRowReduction"}]}], 
    "]"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1075870778],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5499999999999972`", " ", "Second"}], ",", "146856"}], 
  "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->347858106]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ByteCount", "[", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"mat", ",", "vec", ",", " ", 
     RowBox[{"Method", " ", "\[Rule]", " ", "OneStepRowReduction"}]}], "]"}], 
   "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1000700408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.15100000000000335`", " ", "Second"}], ",", "655576"}], 
  "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1827317599]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Least Squares Solutions", "Section",
 CellTags->{"t:103", "c:94"},
 CellID->563250646],

Cell[TextData[{
 "This section follows from the previous section. It is concerned with \
finding solutions to the matrix equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", ".", "X"}], " ", "\[LongEqual]", "B"}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", ">", " ", "n"}], TraditionalForm]], "InlineMath"],
 " (i.e., when there are more equations than unknowns). In this case, there \
may well be no solution and ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " will issue an error message."
}], "Text",
 CellID->445691346],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "6."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5", ",", "6."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"5.", ",", "6.", ",", "8."}], "}"}]}], ";"}], "\n", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"A", ",", "B"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->311491486],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->258943337],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.`", ",", "6.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.5`", ",", "6.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "6.`", ",", "8.`"}], "}"}]}], "]"}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->629934800]
}, Open  ]],

Cell[TextData[{
 "In these cases it is possible to find a best-fit solution that minimizes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleVerticalBar]", 
    RowBox[{
     RowBox[{"A", " ", "x"}], " ", "-", " ", "B"}], 
    SubscriptBox["\[DoubleVerticalBar]", "p"]}], TraditionalForm]], 
  "InlineMath"],
 ". A particularly common choice of p is 2; this generates a least squares \
solution. These are often used because the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], "\[DoubleVerticalBar]", 
    RowBox[{
     RowBox[{"A", " ", "x"}], " ", "-", " ", "B"}], 
    SubsuperscriptBox["\[DoubleVerticalBar]", "2", "2"]}], TraditionalForm]], 
  "InlineMath"],
 " is differentiable in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and because the 2-norm is preserved under orthogonal transformations."
}], "Text",
 CellID->1374474750],

Cell[TextData[{
 "If the rank of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " (i.e., it has full column rank), it can be shown (",
 ButtonBox["Golub and van Loan",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#1770071216"],
 ") that there is a unique solution to the least squares problem and it \
solves the linear system."
}], "Text",
 CellID->315532471],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["A", "T"], ".", "A"}], " ", "x"}], " ", "\[LongEqual]", 
   RowBox[{
    SuperscriptBox["A", "T"], " ", "B"}]}], 
  TraditionalForm]], "InlineMath"]], "NumberedEquation",
 CellID->1017115654],

Cell[TextData[{
 "These are called the normal equations. Although they can be solved directly \
to get a least squares solution, this is not recommended because if the \
matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is ill-conditioned then the product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["A", "T"], ".", "A"}], TraditionalForm]], "InlineMath"],
 " will be even more ill-conditioned. Ways of finding least squares solutions \
for full rank matrices are explored in ",
 ButtonBox["Examples: Full Rank Least Squares Solutions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraExamples#967762464"],
 "."
}], "Text",
 CellID->692966658],

Cell[TextData[{
 "It should be noted that best-fit solutions that minimize other norms, such \
as 1 and \[Infinity], are also possible. A number of ways to find solutions \
to overdetermined systems that are suitable for special types of matrix or \
minimize other norms are given under ",
 ButtonBox["Examples: Minimization of 1 and Infinity Norms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraExamples#601898483"],
 "."
}], "Text",
 CellID->886803325],

Cell[TextData[{
 "A general way to find a least squares solution to an overdetermined system \
is to use a singular value decomposition to form a matrix that is known as \
the pseudo-inverse of a matrix. In ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "this is computed with ",
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 ". This technique works even if the input matrix is rank deficient. The \
basis of the technique is given below."
}], "Text",
 CellID->966973095],

Cell[TextData[{
 "Solve A . x \[LongEqual] B\n\tfind p = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "+"], TraditionalForm]], "InlineMath"],
 " (pseudo-inverse)\n\tthen x \[LongEqual] p.B"
}], "NumberedEquation",
 CellID->1908050816],

Cell[TextData[{
 "Here is an overdetermined system; you can see that the matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is rank deficient."
}], "Text",
 CellID->236763861],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "6."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"5.", ",", "6.", ",", "8."}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixRank", "[", "A", "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->3013936],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->11852475]
}, Open  ]],

Cell[TextData[{
 "The least squares solution can still be found using ",
 StyleBox["PseudoInverse", "MR"],
 "."
}], "Text",
 CellID->1020151502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X", "=", 
  RowBox[{
   RowBox[{"PseudoInverse", "[", "A", "]"}], ".", "B"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->176856466],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.585714285714286`", ",", "1.1714285714285717`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->111124193]
}, Open  ]],

Cell["This shows how close the solution actually is.", "Text",
 CellID->765485758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", ".", "X"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->2092089176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.9285714285714293`", ",", "5.8571428571428585`", ",", 
   "8.785714285714288`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->178937007]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data Fitting", "Subsection",
 CellTags->{"t:208", "c:95"},
 CellID->1737956870],

Cell[TextData[{
 "Scientific measurements often result in collections of ordered pairs of \
data, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "i"], ",", 
     SubscriptBox["y", "i"]}], "}"}], TraditionalForm]], "InlineMath"],
 ". In order to make predictions at times other than those that were \
measured, it is common to try to fit a curve through the data points. If the \
curve is a straight line, then the aim is to find unknown coefficients \
\[Alpha] and \[Beta] for which"
}], "Text",
 CellID->1916031243],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["y", "i"], " ", "\[LongEqual]", " ", 
   RowBox[{"\[Alpha]", " ", "+", " ", 
    RowBox[{"\[Beta]", " ", 
     SubscriptBox["x", "i"]}]}]}], 
  TraditionalForm]], "InlineMath"]], "NumberedEquation",
 CellID->1219814336],

Cell["\<\
for all the data pairs. This can be written in a matrix form as below and is \
immediately recognized as being equivalent to solving an overdetermined \
system of linear equations.\
\>", "Text",
 CellID->1540650890],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", GridBox[{
       {"1", 
        SubscriptBox["x", "1"]},
       {"1", 
        SubscriptBox["x", "2"]},
       {"\[VerticalEllipsis]", "\[VerticalEllipsis]"},
       {"1", 
        SubscriptBox["x", "n"]}
      }], ")"}], 
    RowBox[{"(", GridBox[{
       {"\[Alpha]"},
       {"\[Beta]"}
      }], ")"}]}], "\[LongEqual]", 
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["y", "1"]},
      {
       SubscriptBox["y", "2"]},
      {"\[VerticalEllipsis]"},
      {
       SubscriptBox["y", "n"]}
     }], ")"}]}], TraditionalForm]], "NumberedEquation",
 CellID->1509176351],

Cell["Fitting a more general curve, for example,", "Text",
 CellID->797576540],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["y", "i"], " ", "\[LongEqual]", " ", 
   RowBox[{
    SubscriptBox["c", "0"], " ", "+", " ", 
    RowBox[{
     SubscriptBox["c", "1"], " ", 
     SubscriptBox["x", "i"]}], "+", 
    RowBox[{
     SubscriptBox["c", "2"], 
     SubsuperscriptBox["x", "i", "2"]}], "+", "\[Ellipsis]"}]}], 
  TraditionalForm]]]], "NumberedEquation",
 CellID->275983206],

Cell["is equivalent to the matrix equation", "Text",
 CellID->2032549369],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", GridBox[{
       {"1", 
        SubscriptBox["x", "1"], 
        SubsuperscriptBox["x", "1", "2"], "\[Ellipsis]"},
       {"1", 
        SubscriptBox["x", "2"], 
        SubsuperscriptBox["x", "2", "2"], "\[Ellipsis]"},
       {"\[VerticalEllipsis]", "\[VerticalEllipsis]", "\[VerticalEllipsis]", 
        "\[Ellipsis]"},
       {"1", 
        SubscriptBox["x", "n"], 
        SubsuperscriptBox["x", "n", "2"], "\[Ellipsis]"}
      }], ")"}], 
    RowBox[{"(", GridBox[{
       {
        SubscriptBox["c", "0"]},
       {
        SubscriptBox["c", "1"]},
       {"\[VerticalEllipsis]"}
      }], ")"}]}], "\[LongEqual]", 
   RowBox[{"(", GridBox[{
      {
       SubscriptBox["y", "1"]},
      {
       SubscriptBox["y", "2"]},
      {"\[VerticalEllipsis]"},
      {
       SubscriptBox["y", "n"]}
     }], ")"}]}], TraditionalForm]], "NumberedEquation",
 CellID->1034871954],

Cell["\<\
In this case the left-hand matrix is a Vandermonde matrix. In fact any \
function that is linear in the unknown coefficients can be used.\
\>", "Text",
 CellID->622873825],

Cell["\<\
An example of how to find best-fit parameters will now be given. This will \
start with the measurements shown below.\
\>", "Text",
 CellID->1805081297],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.2", ",", "4.59"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4", ",", "5.05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6", ",", "6.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8", ",", "6.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "7.4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499877510],

Cell["These can be plotted graphically.", "Text",
 CellID->485283506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot1", "=", 
  RowBox[{"ListPlot", "[", " ", 
   RowBox[{"data", ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"PointSize", "[", "0.02", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16994036],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
    PointBox[{{0.2, 4.59}, {0.4, 5.05}, {0.6, 6.2}, {0.8, 6.6}, {1., 
     7.4}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.2, 5.},
  PlotRange->{{0.2, 1.}, {4.59, 7.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80443068]
}, Open  ]],

Cell[TextData[{
 "You could try to solve this with the ",
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 " technique introduced above. First, split the data into ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " components."
}], "Text",
 CellID->1947907985],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xData", "=", 
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"yData", "=", 
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->101305380],

Cell["Now form the left-hand side matrix.", "Text",
 CellID->1832473236],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Transpose", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "xData", "]"}], "}"}]}], "]"}], ",", 
      "xData"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"mat", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1314695825],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0.2`"},
     {"1", "0.4`"},
     {"1", "0.6`"},
     {"1", "0.8`"},
     {"1", "1.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$518]]]], "Output",
 ImageSize->{60, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->393365027]
}, Open  ]],

Cell["The best-fit parameter can be found as follows.", "Text",
 CellID->1936074965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PseudoInverse", "[", "mat", "]"}], ".", "yData"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->939717411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.8169999999999993`", ",", "3.5850000000000017`"}], 
  "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->128161560]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides the function ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " that can find best-fit solutions to data. The solution agrees with that \
found by the ",
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1551691536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"FindFit", "[", 
   RowBox[{"data", ",", 
    RowBox[{"\[Alpha]", "+", 
     RowBox[{"\[Beta]", " ", "x"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->238236384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Alpha]", "\[Rule]", "3.817`"}], ",", 
   RowBox[{"\[Beta]", "\[Rule]", "3.5850000000000013`"}]}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->195166108]
}, Open  ]],

Cell["\<\
Finally, a plot is made that shows the data points and the fitted curve.\
\>", "Text",
 CellID->14143327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"\[Beta]", " ", "x"}]}], ")"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"First", "[", "plot1", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1483695719],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzX88E3gcx3EWl8s1m2WzzcjP7qSHS46QPp9SKVIJF3eLdFJxVG53Spdf
jSNWXfNA4ZLq0oldWCl1FYtuyY9UW8Vot9OYmh41pcJ974/34/V4/vW237pr
4zaKkZHROrL/G7RN23NzOGJpb25phHc+FU0COLsH2J6wX7DjbmoBFRedLC1v
YK8Ah62LlzWJqBh8T1FfwQ6HFH+lm88xKm6Ke3v9GDsOaG9YJn5lVOx3/yVA
xBZASGxJ/dJaKlZarc89xBZCu1+xxaoeKmaZNczLZxfB1THx3+FsC4yMOiUZ
e3UG7HadE/4qtUDz6Sx+oK0ERlNU/Vccaegc+lLbWtAIacLSuiWJNEzt9IHS
N1dgVaXKoauJhqxGusrY+Ab4NzlHeBrT8ZI6oKNrSQv88OSd6/n1dGxJqOBG
jcrgycYPUkk5HQ0u/ha1Se2Q0D41laehI2WihsZ1loPvqsO6PR6W6DW95VJY
XQd43rItXrDfEjuEnp1trl0QfUxlSGuxRLujuonzL7vhTpLrhMKCgbq3A6qH
X94H/srUqzMjGXhmpFlOPdwL7vM22AX+zkAq75xeo3kAi2IifaxfM7BwpzS+
0ukRxIpj6dd85+A41mh2ZCigs2e8cFfeHBR4yBqZrUrY9pmozdA9BwfqZAU9
9k9gSajkdIGdFX5IeFD2RdpTCBg18mr43grnL5s5Fd/cB4KDYbm1jVYYWGW/
/SJLBRonj7TLFCam8mIcnvEHIL2F7lYUzES30QhzRcggrLk0V0wRM5FhMWYm
ez8I4Y3NFZmDTDS5USZxLH8GeXWb4ns+Z2GiZ/PjT4PV8LE+4/7CVBbWrNla
+de4GipnK147ylho0HFoQ8X/QHKce6/W3BqlYYEzilZo4OfbjK+vR1ljxuqc
k41DGmhwmCiOq7JG+/4g5emcf4H7aLaoYtgafb2FRWyPIWgV17kMebGRb9s1
Ydw7BEUhG9KNM9hokIvUu7Oewxl6+j63e2wsNYkWbHTSwkDPBQ9XJgcZKmkV
RaaFIO2sU1c2c9D0QFa4z55hMJgZ6iNrOGh0PlqithwBufNgtvw1B1NOSESW
LSOgWrtpPHg5F6/PzzOjJ+vAQT5pG3OEi/SgFLds6igcDThrulLBxb4F3b37
ro3C0nblEV9nG/zzN3DSRL8AZuBsJSXZBjdLvOi8qRdgy9vzkC+1wcycU1l9
f7yE+MktP7VReFir5ZVR1+pB+Tj0ISWYh6F06uL293rIv9mpWHech4dMKdw+
4uqFw4siiWUThskx4jtVM47GEnup+1s5H/TwSc7i1QJiTkPt+mRi4ZqqpuPE
6vCQ7VYf9ZB+/8fjGmJBaWHxd5N6EGhsvk07Qf4LM/ftJRZHeF8+SDyUKeCL
iOvbQhki4sidfIfLxK+qc++eJPb3daubNaWH5KQxv9vEn/TdvX2ROGG81YZW
xkPovlHdRpy/XbWXTbxX1lDwlLha+e6BA/HIhbJQ02k9PL+6QPQVceeBxP5I
4riMkslviGemxNxMIhaOXYyKI8b4sNPZxFWxHdIk4vp1fjsvED8LME7OJNYt
d197i9hIypXnEzt5O7o/Ip7r4uUiJo6ez7LUEWPJhuxy4hI7c8M0cYxZouos
8X89akqg
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 4.},
  Epilog->{{{}, {
      Hue[0.67, 0.6, 0.6], 
      PointSize[0.02], 
      PointBox[{{0.2, 4.59}, {0.4, 5.05}, {0.6, 6.2}, {0.8, 6.6}, {1., 
       7.4}}]}, {}}},
  PlotRange->{{0, 1}, {3.8170000731632654`, 7.401999926836736}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->242088209]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " is quite general; it can also fit functions to data that are not linear in \
the parameters."
}], "Text",
 CellID->332311740]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigensystem Computations", "Section",
 CellTags->{"t:48", "c:96"},
 CellID->1705931980],

Cell[TextData[{
 "The solution of the eigenvalue problem is one of the major areas for matrix \
computations. It has many applications in physics, chemistry, and \
engineering. For an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " the eigenvalues are the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " roots of its characteristic polynomial, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "(", "z", ")"}], "=", 
    RowBox[{"det", "(", 
     RowBox[{
      RowBox[{"z", " ", "I"}], "-", "A"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The set of roots, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Lambda]", "(", "A", ")"}], "=", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["\[Lambda]", "n"]}], "}"}]}], TraditionalForm]], 
  "InlineMath"],
 ", are called the spectrum of the matrix. For each eigenvalue, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "\[Element]", 
    RowBox[{"\[Lambda]", "(", "A", ")"}]}], TraditionalForm]], "InlineMath"],
 ", the vectors, ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", that satisfy"
}], "Text",
 CellID->544616763],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"A", ".", "x"}], "=", 
   RowBox[{"\[Lambda]", " ", "x"}]}], TraditionalForm]], "NumberedEquation",
 CellID->798632227],

Cell[TextData[{
 "are described as eigenvectors. The matrix of the eigenvectors, ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 ", if it exists and is non-singular, may be used as a similarity \
transformation to form a diagonal matrix with the eigenvalues on the diagonal \
elements. Many important applications of eigenvalues involve the \
diagonalization of matrices in this way."
}], "Text",
 CellID->839045439],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"diag", "(", " ", 
    RowBox[{"\[Lambda]", "(", "A", ")"}], ")"}], " ", "=", 
   RowBox[{
    SuperscriptBox["X", 
     RowBox[{"-", "1"}]], ".", "A", ".", "X"}]}], 
  TraditionalForm]], "NumberedEquation",
 CellID->1459067071],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has various functions for computing eigenvalues and eigenvectors."
}], "Text",
 CellID->424497204],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of the eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of the eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigensystem",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigensystem"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of the form ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["eigenvalues", "TI"], ",", 
        StyleBox["eigenvectors", "TI"]}], "}"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacteristicPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "the characteristic polynomial of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->583832294],

Cell["Eigenvalues and eigenvectors. ", "Caption",
 CellTags->"S3.7.9",
 CellID->616582115],

Cell["Here is a sample 2\[Times]2 matrix.", "Text",
 CellID->1287010030],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1322281626],

Cell["This computes the eigenvalues.", "Text",
 CellID->1426509026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "mat", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->829764874],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.372281323269014`", ",", 
   RowBox[{"-", "0.3722813232690143`"}]}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99433700]
}, Open  ]],

Cell["This computes the eigenvectors.", "Text",
 CellID->439918534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvectors", "[", "mat", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2072087964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.41597355791928436`"}], ",", 
     RowBox[{"-", "0.9093767091321241`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8245648401323937`"}], ",", "0.5657674649689923`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{327, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1987591196]
}, Open  ]],

Cell[TextData[{
 "You can compute both the eigenvalues and eigenvectors with ",
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1337102087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"vals", ",", "vecs"}], "}"}], "=", 
  RowBox[{"Eigensystem", "[", "mat", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1405894001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.372281323269014`", ",", 
     RowBox[{"-", "0.3722813232690143`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.41597355791928436`"}], ",", 
       RowBox[{"-", "0.9093767091321241`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8245648401323937`"}], ",", "0.5657674649689923`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->97906866]
}, Open  ]],

Cell["\<\
You can confirm that the first eigenvalue and its eigenvector satisfy the \
definition.\
\>", "Text",
 CellID->548223260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", ".", 
   RowBox[{"vecs", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"vals", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", 
   RowBox[{"vecs", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1283485190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.440892098500626`*^-16", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{133, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->62354215]
}, Open  ]],

Cell[TextData[{
 "You should note that ",
 Cell[BoxData[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 " return a list of eigenvectors. This means that if you want a matrix with \
columns that are the eigenvectors you must take a transpose. Here, the \
eigenvalues and their corresponding eigenvectors are shown to meet the \
definition of the eigenvectors."
}], "Text",
 CellID->15271769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"mat", ".", 
    RowBox[{"Transpose", "[", "vecs", "]"}]}], " ", "-", " ", 
   RowBox[{
    RowBox[{"Transpose", "[", "vecs", "]"}], ".", 
    RowBox[{"DiagonalMatrix", "[", "vals", "]"}]}]}], "//", "Chop"}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->1122067590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1536080823]
}, Open  ]],

Cell["\<\
You can also obtain the characteristic polynomial of the test matrix.\
\>", "Text",
 CellID->2009471574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"poly", "=", 
  RowBox[{
   RowBox[{"CharacteristicPolynomial", "[", 
    RowBox[{"mat", ",", "x"}], "]"}], "//", "Expand"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1860911496],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1.9999999999999998`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"5.`", "\[InvisibleSpace]", "+", 
     RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->387678364]
}, Open  ]],

Cell["\<\
This finds the roots of the characteristic polynomial; they are seen to match \
the eigenvalues of the matrix.\
\>", "Text",
 CellID->244878750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"poly", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1098483598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.3722813232690143`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "5.372281323269014`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->296918327]
}, Open  ]],

Cell["\<\
Eigenvalue computations work for sparse matrices as well as for dense \
matrices. In the following example, one of the eigenvalues is zero.\
\>", "Text",
 CellID->1701809908],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}], "<", "2"}]}], "\[Rule]", "2."}], ",",
      
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->2131913010],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2.`", "2.`", "0", "0", "0"},
     {"2.`", "2.`", "2.`", "0", "0"},
     {"0", "2.`", "2.`", "2.`", "0"},
     {"0", "0", "2.`", "2.`", "2.`"},
     {"0", "0", "0", "2.`", "2.`"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 0, {
    1, {{0, 2, 5, 8, 11, 13}, {{1}, {2}, {1}, {2}, {3}, {3}, {4}, {2}, {3}, {
      4}, {5}, {5}, {4}}}, {2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 
     2.}}]]]], "Output",
 ImageSize->{126, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MatrixForm=",
 CellID->297308875]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "sp", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1823299203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.464101615137754`", ",", "3.9999999999999996`", ",", 
   "1.9999999999999998`", ",", 
   RowBox[{"-", "1.4641016151377546`"}], ",", 
   RowBox[{"-", "1.0842021724855047`*^-19"}]}], "}"}]], "Output",
 ImageSize->{273, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1745545778]
}, Open  ]],

Cell["\<\
An eigenvalue being zero means that the null space of the matrix is not \
empty.\
\>", "Text",
 CellID->613789179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", "sp", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1590774912],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "0.5000000000000002`"}], ",", "0.5000000000000002`", ",", 
    RowBox[{"-", "4.597017211338539`*^-17"}], ",", 
    RowBox[{"-", "0.49999999999999994`"}], ",", "0.4999999999999999`"}], 
   "}"}], "}"}]], "Output",
 ImageSize->{274, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->2130024481]
}, Open  ]],

Cell[TextData[{
 "Certain applications of eigenvalues do not require all of the eigenvalues \
to be computed. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a mechanism for obtaining only some eigenvalues."
}], "Text",
 CellID->769056677],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the largest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the corresponding eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["-", "MR"], 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the smallest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " eigenvalues of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["-", "MR"], 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the corresponding eigenvectors of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1978982693],

Cell["\<\
This is particularly useful if the matrix is very large. Here is a 10000\
\[Times]10000 sparse matrix.\
\>", "Text",
 CellID->535396515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"i", "-", "j"}], "]"}], "<", "4"}]}], "\[RuleDelayed]", 
     RowBox[{"N", "[", 
      RowBox[{"i", "+", "j"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"10000", ",", "10000"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->452746675],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "69988", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 69988, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"10000", ",", "10000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->778805404]
}, Open  ]],

Cell["This is the largest eigenvalue.", "Text",
 CellID->469596563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"sp", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->507031616],

Cell[BoxData[
 RowBox[{"{", "139134.436782961`", "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->465258816]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Cubics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cubics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to return radicals for 3\[Times]3 matrices \
\>", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for solving ", "TableText"]},
   {
    ButtonBox["Quartics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Quartics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to return radicals for 4\[Times]4 matrices \
\>", "TableText"]},
   {
    ButtonBox["ZeroTest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ZeroTest"], 
    StyleBox[
     RowBox[{"(", "#", " ", "\[Equal]", " ", "0", " ", "&", ")"}], "MR"], 
    Cell["\<\
the function to be used by symbolic methods for testing for zero  \
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S5.27.1",
 CellID->616961785],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 ". "
}], "Caption",
 CellTags->"S3.7.8",
 CellID->1225672779],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 " has four options that allow users more control. The ",
 Cell[BoxData[
  ButtonBox["Cubics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cubics"]], "InlineFormula"],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  ButtonBox["Quartics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartics"]], "InlineFormula"],
 StyleBox[",", "MR"],
 " and ",
 Cell[BoxData[
  ButtonBox["ZeroTest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZeroTest"]], "InlineFormula"],
 " options are used by symbolic techniques and are discussed under \"",
 ButtonBox["Symbolic and Exact Matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1937669982"],
 "\". The ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option allows knowledgeable users to choose methods that are particularly \
appropriate for their problems; the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " means that ",
 Cell[BoxData[
  ButtonBox["Eigensystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigensystem"]], "InlineFormula"],
 " makes a choice of a method that is generally suitable."
}], "Text",
 CellID->1219254629],

Cell[CellGroupData[{

Cell["Eigensystem Properties", "Subsection",
 CellTags->{"t:209", "c:97"},
 CellID->723589929],

Cell[TextData[{
 "This section describes certain properties of eigensystem computations. It \
should be remembered that because the eigenvalues of an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix can be associated with the roots of an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " degree polynomial, there will always be ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " eigenvalues."
}], "Text",
 CellID->176043742],

Cell["\<\
Even if a matrix only contains real numbers, its eigenvalues may not be real.\
\
\>", "Text",
 CellID->1682189875],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->943016370],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
     RowBox[{"1", "-", "\[ImaginaryI]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[ImaginaryI]", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->846815730]
}, Open  ]],

Cell["\<\
The eigenvalues of a matrix may be repeated; eigenvalues that are not \
repeated are called simple. In this example, the repeated eigenvalue has as \
many eigenvectors as the number of times it is repeated; this is a semisimple \
eigenvalue.\
\>", "Text",
 CellID->1057845441],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->191213374],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1087640906]
}, Open  ]],

Cell["\<\
The repeated eigenvalue may have fewer eigenvectors than the number of times \
it is repeated. In this case it is referred to as a defective eigenvalue and \
the matrix is referred to as a defective matrix.\
\>", "Text",
 CellID->599903878],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "3", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->148754881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->452319859]
}, Open  ]],

Cell["\<\
A matrix may have a zero eigenvalue, but can still have a complete set of \
eigenvectors.\
\>", "Text",
 CellID->47759833],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"14", ",", "4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "11"}], ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "4", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1688112900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "5"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1707049783]
}, Open  ]],

Cell["\<\
A matrix may have a zero eigenvalue, but not have a complete set of \
eigenvectors.\
\>", "Text",
 CellID->4178961],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1516320823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->615633212]
}, Open  ]],

Cell["\<\
If a matrix is real and symmetric all of the eigenvalues are real, and there \
is an orthonormal basis of eigenvectors.\
\>", "Text",
 CellID->371182838],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "5."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", " ", "1."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"lam", ",", "vec"}], "}"}], "=", 
  RowBox[{"Eigensystem", "[", "mat", "]"}]}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->29963731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6.`", ",", 
     RowBox[{"-", "4.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7071067811865474`", ",", "0.7071067811865476`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", 
       RowBox[{"-", "0.7071067811865476`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1089253519]
}, Open  ]],

Cell["The eigenvectors are an orthonormal basis.", "Text",
 CellID->1933286805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", ".", 
  RowBox[{"Transpose", "[", "vec", "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1323752525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999998`", ",", 
     RowBox[{"-", "1.5701957963021318`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5701957963021318`*^-16"}], ",", "1.0000000000000002`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{289, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->378104755]
}, Open  ]],

Cell["\<\
A symmetric real matrix that has positive eigenvalues is known as positive \
definite.\
\>", "Text",
 CellID->402505812],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10.", ",", " ", "5."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", " ", "16."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->341694234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"18.830951894845303`", ",", "7.1690481051547`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.49269881498359297`", ",", "0.8701999067534789`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.8701999067534788`", ",", 
       RowBox[{"-", "0.49269881498359297`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{425, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->483718760]
}, Open  ]],

Cell["\<\
A symmetric real matrix that has nonzero eigenvalues is known as positive \
semidefinite.\
\>", "Text",
 CellID->1635595425],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[16]:=",
 CellID->1661626375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1077139037]
}, Open  ]],

Cell["\<\
If a matrix is complex and hermitian (i.e. equal to its conjugate transpose), \
all of the eigenvalues are real and there is an orthonormal basis of \
eigenvectors.\
\>", "Text",
 CellID->188650649],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", 
       RowBox[{"5.", "I"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5."}], "I"}], ",", "10."}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"lam", ",", "vec"}], "}"}], "=", 
  RowBox[{"Eigensystem", "[", "mat", "]"}]}]}], "Input",
 CellLabel->"In[18]:=",
 CellID->965594771],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12.226812023536858`", ",", 
     RowBox[{"-", "1.2268120235368551`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.4068385849311434`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.9135000633887361`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.913500063388736`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.40683858493114333`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{441, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->217395818]
}, Open  ]],

Cell["The eigenvectors are an orthonormal basis.", "Text",
 CellID->901829579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", ".", 
  RowBox[{"Transpose", "[", 
   RowBox[{"Conjugate", "[", "vec", "]"}], "]"}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->110153727],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "5.5294310796760726`*^-18"}], "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.5294310796760726`*^-18"}], "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9999999999999999`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{453, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->222785975]
}, Open  ]],

Cell["\<\
A hermitian matrix that has positive eigenvalues is known as positive \
definite.\
\>", "Text",
 CellID->1299885104],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", 
       RowBox[{"5.", "I"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5."}], "I"}], ",", "30."}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"Eigensystem", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[21]:=",
 CellID->817801997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"30.83786165017797`", ",", "0.16213834982203265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.16526799202163714`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.986248696228865`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.9862486962288649`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.16526799202163714`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{469, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->902822779]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Diagonalizing a Matrix", "Subsection",
 CellTags->{"t:200", "c:98"},
 CellID->1770480598],

Cell["\<\
One of the uses of eigensystem computations is to provide a similarity \
transformation that diagonalizes a matrix.\
\>", "Text",
 CellID->933997754],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["X", 
     RowBox[{"-", "1"}]], ".", "A", ".", "X"}], "\[LongEqual]", " ", 
   RowBox[{"diag", "(", " ", 
    RowBox[{"\[Lambda]", "(", "A", ")"}], ")"}]}], 
  TraditionalForm]], "NumberedEquation",
 CellID->1742275555],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", " ", "4."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vecs", "=", 
   RowBox[{"Eigenvectors", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Transpose", "[", "vecs", "]"}], "]"}], ".", "mat", ".", 
    RowBox[{"Transpose", "[", "vecs", "]"}]}], "//", "Chop"}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1485726040],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVrluwzAMZSy5Odx27pAhH5GxyLG0Uz/CCAokQ9EgyZyhe75Z0Zm29AMk
R26mGrDoR9PkE0VRfqsP6/eP+rBZ1ZPXXb1db1b7ycvnTqtEj4hO+h4/kX5W
+sneJ6W0dGNpRmG09qIjw9JaSaA1cOalwQU5b4KaXgs9lBoGKbyd8PiO2QsY
1WrLC7Y2RM9QKzwjCd9yzwW0aqPlHnNmNP2RpebbB+SDz4WvYDRmGn8eC2cX
r0iMN/QdXSNu1UdfZfGulKsknhG0J3hktBe6Z8gzG2NmsfzGzei8hrrnPITa
/H3YZZWEbha6XKV+d63QxSSQRZhjNMrXvxXL97Wnyb2Xy6RouFpvfW6MoHaR
NIMBwxXD3ZwMt2R43RmQwzDUmKmdnC5fteAQ8/nYkkO8nw8guznKfjQazvZf
dW4cLZ259D5S+nboH3zVnPe0P2X3V029M61EKbQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->111591321]
}, Open  ]],

Cell["\<\
Similarity transformations preserve a number of useful properties of a matrix \
such as determinant, rank, and trace.\
\>", "Text",
 CellID->189634261],

Cell["\<\
If the matrix of eigenvectors is singular then the matrix cannot be \
diagonalized. This happens if the matrix is defective (i.e., there is an \
eigenvalue that does not have a complete set of eigenvectors) as in this \
example.\
\>", "Text",
 CellID->317292479],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "1", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "3", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lam", ",", "vec"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"Transpose", "[", "vec", "]"}]}], ";"}], "\n", 
 RowBox[{"vec", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->532799052],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "0", 
      RowBox[{"-", "1"}]},
     {"0", "0", "2"},
     {"2", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{77, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->256827578]
}, Open  ]],

Cell["\<\
The matrix of column eigenvectors is singular and so a similarity \
transformation that diagonalizes the original matrix does not exist.\
\>", "Text",
 CellID->1771364372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "vec", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->755201843],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"sing\"\>"}], ":", 
  " ", "\<\"Matrix \\!\\({\\(\\({\\(\\(-1\\)\\), 0, \\(\\(-1\\)\\)}\\)\\), \
\\(\\({0, 0, 2}\\)\\), \\(\\({2, 0, 1}\\)\\)}\\) is singular. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/sing\\\", \
ButtonNote -> \\\"Inverse::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[8]:=",
 CellID->290103530],

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->31327308]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic and Exact Matrices", "Subsection",
 CellTags->{"t:153", "c:99"},
 CellID->1937669982],

Cell[TextData[{
 "As is typical for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", if a computation is done for a symbolic or exact matrix it will use \
symbolic computer algebra techniques and return a symbolic or exact result."
}], "Text",
 CellID->1977364366],

Cell["\<\
This is a sample 3\[Times]3 matrix of integers.\
\>", "Text",
 CellID->1253462037],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "20"}], ",", "1", ",", "4"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121878789],

Cell[TextData[{
 "This computes the eigenvalues; the result uses ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects."
}], "Text",
 CellID->1864891132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "mat", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->701427559],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"169", "+", 
       RowBox[{"68", " ", "#1"}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"169", "+", 
       RowBox[{"68", " ", "#1"}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"169", "+", 
       RowBox[{"68", " ", "#1"}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{449, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1355245730]
}, Open  ]],

Cell[TextData[{
 "A machine-precision approximation to the result can be computed by using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1403424028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1534743595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"5.451994011072547`", "\[InvisibleSpace]", "+", 
    RowBox[{"7.683542405102409`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"5.451994011072547`", "\[InvisibleSpace]", "-", 
    RowBox[{"7.683542405102409`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "1.9039880221450938`"}]}], "}"}]], "Output",
 ImageSize->{341, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1009517048]
}, Open  ]],

Cell[TextData[{
 "The result can be returned in terms of radicals by setting the ",
 Cell[BoxData[
  ButtonBox["Cubics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cubics"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1832214436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1260011519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2871"}], "+", 
           SqrtBox["9069693"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["3", 
       RowBox[{"2", "/", "3"}]]}]], "+", 
    FractionBox[
     RowBox[{"41", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2871"}], "+", 
           SqrtBox["9069693"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}], ",", 
   RowBox[{"3", "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2871"}], "+", 
           SqrtBox["9069693"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["3", 
       RowBox[{"2", "/", "3"}]]}]], "+", 
    FractionBox[
     RowBox[{"41", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2871"}], "+", 
           SqrtBox["9069693"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}], ",", 
   RowBox[{"3", "-", 
    RowBox[{"41", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2871"}], "+", 
           SqrtBox["9069693"]}], ")"}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2871"}], "+", 
          SqrtBox["9069693"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}]}], "}"}]], "Output",
 ImageSize->{503, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->677356766]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generalized Eigenvalues", "Subsection",
 CellTags->{"t:154", "c:100"},
 CellID->524353415],

Cell[TextData[{
 "For n\[Cross]n matrices ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", ",", "B"}], TraditionalForm]], "InlineMath"],
 " the generalized eigenvalues are the n roots of its characteristic \
polynomial, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "(", "z", ")"}], "=", 
    RowBox[{"det", "(", 
     RowBox[{"A", "-", 
      RowBox[{"z", " ", "B"}]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". For each generalized eigenvalue, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", "\[Element]", 
    RowBox[{"\[Lambda]", "(", 
     RowBox[{"A", ",", "B"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", the vectors, ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", that satisfy"
}], "Text",
 CellID->1682442264],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"A", ".", "x"}], "=", 
   RowBox[{"\[Lambda]", " ", 
    RowBox[{"B", ".", "x"}]}]}], TraditionalForm]], "NumberedEquation",
 CellID->889950999],

Cell["are described as generalized eigenvectors.", "Text",
 CellID->182838838],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized eigenvalues of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized eigenvectors ",
     "of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigensystem",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigensystem"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized eigensystem ",
     "of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->2070735056],

Cell["Generalized eigenvalues and eigenvectors. ", "Caption",
 CellTags->"S3.7.9",
 CellID->724102910],

Cell["Here are two 2\[Times]2 matrices.", "Text",
 CellID->207780821],

Cell[BoxData[{
 RowBox[{
  RowBox[{"matA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.746", ",", "0.940"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.246", ",", "1.898"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matB", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.780", ",", "0.563"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.913", ",", "0.659"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->363848525],

Cell["This computes the generalized eigenvalues.", "Text",
 CellID->1316216666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", " ", 
  RowBox[{"{", 
   RowBox[{"matA", ",", "matB"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->424457715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0713339998600392`*^6", ",", "1.9999999999999998`"}], 
  "}"}]], "Output",
 ImageSize->{123, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2067624318]
}, Open  ]],

Cell["\<\
If the two matrices share a common nonzero nullspace, there will be an \
indeterminate eigenvalue.\
\>", "Text",
 CellID->2129020519],

Cell[BoxData[{
 RowBox[{
  RowBox[{"matA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.5", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matB", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "0"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1075336519],

Cell["These two matrices share a common one-dimensional nullspace.", "Text",
 CellID->2105985328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", "matA", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->469937842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1947940475]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NullSpace", "[", "matB", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->647364810],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1108205968]
}, Open  ]],

Cell[TextData[{
 "One of the generalized eigenvalues is ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 "."
}], "Text",
 CellID->492033745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", " ", 
  RowBox[{"{", 
   RowBox[{"matA", ",", "matB"}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1799111265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "Indeterminate"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1093281095]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Methods", "Subsection",
 CellTags->{"t:155", "c:101"},
 CellID->905279933],

Cell[TextData[{
 "Eigenvalue computations are solved with a number of different techniques \
that are specialized to particular problems. You can select between these \
using the option ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 ". In this way a uniform interface is provided to all the functionality that \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides."
}], "Text",
 CellID->118194936],

Cell[TextData[{
 "The default setting of the option ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". As is typical for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", this means that the system will make an automatic choice of method to \
use. For eigenvalue computation when the input is an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix of machine numbers and the number of eigenvalues requested is less \
than 20% of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " an ",
 ButtonBox["Arnoldi method",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1833787992"],
 " is used. Otherwise, if the input matrix is numerical then a ",
 ButtonBox["method using LAPACK",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1499161194"],
 " routines is used. If the matrix is symbolic then ",
 ButtonBox["specialized symbolic routines",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#344887306"],
 " are used."
}], "Text",
 CellID->79915877],

Cell["The details of the different methods are now described.", "Text",
 CellID->968865364],

Cell[CellGroupData[{

Cell["LAPACK", "Subsubsection",
 CellTags->{"t:157", "c:102"},
 CellID->1499161194],

Cell[TextData[{
 "LAPACK is the default method for computing the entire set of eigenvalues \
and eigenvectors. When the matrix is unsymmetric, dgeev is used for real \
matrices and zgeev is used for complex matrices. For symmetric matrices, \
dsyevr is used for real matrices and zheevr is used for complex matrices. For \
generalized eigenvalues the routine dggev is used for real matrices and zggev \
for complex matrices. More information on LAPACK is available in the ",
 ButtonBox["references section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#513881229"],
 "."
}], "Text",
 CellID->2124040954],

Cell[TextData[{
 "It should be noted that the computation of eigenvalues for a symmetric \
matrix is faster because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " detects this case and switches to the appropriate method."
}], "Text",
 CellID->1135649797],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "700", "}"}], ",", 
     RowBox[{"{", "700", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matSym", "=", 
   RowBox[{"mat", "+", 
    RowBox[{"Transpose", "[", "mat", "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->31483643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Eigenvalues", "[", "mat", "]"}], ";"}], "//", "Timing"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->864610739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"6.309000000000005`", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1638334771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Eigenvalues", "[", "matSym", "]"}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->457174363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.4320000000000022`", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->33029975]
}, Open  ]],

Cell["\<\
If the input matrix uses arbitrary-precision numbers, LAPACK algorithms \
extended for arbitrary-precision computation are used.\
\>", "Text",
 CellID->1084008899]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arnoldi", "Subsubsection",
 CellTags->{"t:158", "c:103"},
 CellID->1833787992],

Cell[TextData[{
 "The Arnoldi method is an iterative method used to compute a finite number \
of eigenvalues. The implementation of the Arnoldi method uses the \"",
 ButtonBox["ARPACK",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#744728443"],
 "\" library. The most general problem that can be solved with this technique \
is to compute a few selected eigenvalues for"
}], "Text",
 CellID->1936963447],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"A", ".", "x"}], "=", 
   RowBox[{"\[Lambda]", " ", 
    RowBox[{"B", ".", "x"}]}]}], TraditionalForm]], "NumberedEquation",
 CellID->840048856],

Cell[TextData[{
 "Because it is an iterative technique and only finds a few eigenvalues, it \
is often suitable for sparse matrices. One of the features of the technique \
is the ability to apply a shift \[Sigma] and solve for a given eigenvector ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and eigenvalue ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " (where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sigma]", "\[NotEqual]", "\[Lambda]"}], TraditionalForm]], 
  "InlineMath"],
 ")."
}], "Text",
 CellID->1143627414],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"A", "-", 
        RowBox[{"\[Sigma]", " ", "B"}]}], ")"}], 
      RowBox[{"-", "1"}]], ".", "B", ".", "x"}], "=", 
    RowBox[{"x", " ", "\[Nu]"}]}], ",", " ", 
   RowBox[{
    RowBox[{"where", " ", "\[Nu]"}], "=", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"\[Lambda]", "-", "\[Sigma]"}], ")"}]}]}]}], 
  TraditionalForm]], "NumberedEquation",
 CellID->967306448],

Cell["\<\
This is effective for finding eigenvalues near to \[Sigma].\
\>", "Text",
 CellID->1068263746],

Cell["\<\
The following sub-options can be given to the Arnoldi method.\
\>", "Text",
 CellID->1345490102],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    StyleBox["BasisSize", "MR"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the size of the Arnoldi basis ", "TableText"]},
   {
    StyleBox["Criteria", "MR"], 
    StyleBox["Magnitude", "MR"], Cell[
    "the method to use for solving ", "TableText"]},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of iterations ", "TableText"]},
   {
    StyleBox["Shift", "MR"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["an Arnoldi shift", "TableText"]},
   {
    StyleBox["StartingVector", "MR"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the initial vector to use  ", "TableText"]},
   {
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the tolerance to use to terminate the iteration  ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S5.27.1",
 CellID->649341404],

Cell["Sub-options of the Arnoldi method. ", "Caption",
 CellTags->"S3.7.9",
 CellID->2116566621],

Cell["Here is a 3\[Times]3 sparse matrix.", "Text",
 CellID->68586592],

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"N", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1683616952],

Cell["\<\
This computes the largest eigenvalue, specifying that the Arnoldi method is \
used.\
\>", "Text",
 CellID->1305579392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"sp", ",", "1", ",", 
   RowBox[{"Method", "\[Rule]", "Arnoldi"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2032419945],

Cell[BoxData[
 RowBox[{"{", "3.`", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75266656]
}, Open  ]],

Cell["This computes the eigenvalue near to -1.", "Text",
 CellID->307853777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"sp", ",", "1", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Arnoldi", ",", 
      RowBox[{"Shift", "\[Rule]", "3.00001"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->810324416],

Cell[BoxData[
 RowBox[{"{", "3.`", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->404007190]
}, Open  ]],

Cell["\<\
If a shift is given that matches an eigenvalue an error may result.\
\>", "Text",
 CellID->771038777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"sp", ",", "1", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Arnoldi", ",", 
      RowBox[{"Shift", "\[Rule]", "3."}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->932399041],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvalues", "::", "\<\"ssing\"\>"}], ":", 
  " ", "\<\"Failed to factor the matrix involving the shift. This may be \
caused by the shift, \\!\\(3.`\\), corresponding exactly to an eigenvalue. \
Changing the shift value slightly might help.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->82235877],

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "9", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 9, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
    False,
    Editable->False], ",", "1", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Arnoldi", ",", 
      RowBox[{"Shift", "\[Rule]", "3.`"}]}], "}"}]}]}], "]"}]], "Output",
 ImageSize->{484, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->444146888]
}, Open  ]],

Cell["\<\
This tries to find eigenvalues of a 1500\[Times]1500 tridiagonal matrix with \
2 on the diagonal and -1 off the diagonal. The algorithm does not converge. \
\>", "Text",
 CellID->1694675974],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"num", "=", "1500"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
       
       RowBox[{"2.", "-", 
        RowBox[{"3.", "*", 
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"num", ",", "num"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"sp", ",", "2"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->343484857],

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvalues", "::", "\<\"maxit2\"\>"}], ":", 
  " ", "\<\"Maximum number of iterations, \\!\\(1000\\), has been reached by \
the Arnoldi algorithm without convergence to the specified tolerance, but the \
current best computed value has been returned.  You can use method options \
with Method -> {Arnoldi, opts} to increase the basis size or the maximum \
number of iterations, reduce the tolerance, or use an estimate as a shift, \
any of which may help.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[5]:=",
 CellID->211583067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.20299999999999999`", ",", 
   RowBox[{"{", 
    RowBox[{"3.999951692345474`", ",", "3.9997267136134957`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->140682982]
}, Open  ]],

Cell["\<\
When the technique does not converge it returns a result, but this may not be \
very accurate. One way to accelerate the convergence would be to use the \
results generated as a shift.\
\>", "Text",
 CellID->91482619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"sp", ",", "2", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Arnoldi\>\"", ",", 
       RowBox[{"Shift", "\[Rule]", "4"}]}], "}"}]}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->2097569928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.030000000000001137`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.999995619353565`", ",", "3.999982477433451`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->766230744]
}, Open  ]],

Cell["\<\
An alternative way to get convergence is to increase the number of \
iterations.\
\>", "Text",
 CellID->1728166996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"sp", ",", "2", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Arnoldi\>\"", ",", 
       RowBox[{"MaxIterations", "\[Rule]", "100000"}]}], "}"}]}]}], "]"}], "//",
   "Timing"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->586376097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8.852999999999994`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.999995619353401`", ",", "3.9999824774186448`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->420606196]
}, Open  ]],

Cell["\<\
Alternatively, the convergence may be achieved by increasing the Arnoldi \
basis size in addition to the number of iterations. In this example, the \
increased basis size makes the algorithm converge in a smaller number of \
iterations. Even though each iteration is more expensive, the overall \
computation is faster.\
\>", "Text",
 CellID->1759653895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"sp", ",", "2", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Arnoldi\>\"", ",", 
       RowBox[{"BasisSize", "\[Rule]", "30"}], ",", 
       RowBox[{"MaxIterations", "\[Rule]", "100000"}]}], "}"}]}]}], "]"}], "//",
   "Timing"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1505710428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.987000000000002`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.999995619353596`", ",", "3.9999824774332273`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->527867148]
}, Open  ]],

Cell["\<\
The Arnoldi algorithm with a basis size of 30 is still often faster and less \
memory intensive than the dense eigenvalue computation. (It should be noted \
that specific timings on individual machines can vary.)\
\>", "Text",
 CellID->608210679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Normal", "[", "sp", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"mat", ",", "2"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->174722233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"9.753999999999998`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.9999956193535655`", ",", "3.9999824774334507`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->946424582]
}, Open  ]],

Cell["\<\
For many large sparse systems that occur in practical computations the \
Arnoldi algorithm is able to converge quite quickly.\
\>", "Text",
 CellID->146576345]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Methods", "Subsubsection",
 CellTags->{"t:159", "c:104"},
 CellID->344887306],

Cell["\<\
Symbolic eigenvalue computations work by interpolating the characteristic \
polynomial. \
\>", "Text",
 CellID->462588689]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Decompositions", "Section",
 CellTags->{"t:51", "c:105"},
 CellID->837293883],

Cell["\<\
This section will discuss a number of standard techniques for working with \
matrices. These are often used as building blocks for solving matrix \
problems. The decompositions fall into the categories of factorizations, \
orthogonal transformations, and similarity transformations.\
\>", "Text",
 CellID->2085436437],

Cell[CellGroupData[{

Cell["LU Decomposition", "Subsection",
 CellTags->{"t:53", "c:106"},
 CellID->849593972],

Cell[TextData[{
 "The LU decomposition of a matrix is frequently used as part of a Gaussian \
elimination process for solving a matrix equation. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " there is no need to use an LU decomposition to solve a matrix equation, \
because the function ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " does this for you, as discussed in the section \"",
 ButtonBox["Solving Linear Systems",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#81663253"],
 "\". Note that if you want to save the factorization of a matrix, so that it \
can be used to solve the same left-hand side, you can use the one argument \
form of ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 ", as demonstrated in the section \"",
 ButtonBox["Saving the Factorization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1974718471"],
 "\"."
}], "Text",
 CellID->507118501],

Cell[TextData[{
 "The LU decomposition with partial pivoting of a square non-singular matrix \
",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " involves the computation of the unique matrices ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " such that"
}], "Text",
 CellID->1925535011],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"P", ".", "A"}], "\[LongEqual]", 
   RowBox[{"L", ".", "U"}]}], TraditionalForm]], "NumberedEquation",
 CellID->2035853234],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 " is lower triangular with ones on the diagonal, ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " is upper triangular, and ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " is a permutation matrix. Once it is found, it can be used to solve the \
matrix equation by finding the solution to the following equivalent system."
}], "Text",
 CellID->728356187],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"L", ".", "U", ".", "x"}], " ", "\[LongEqual]", " ", 
   RowBox[{"P", ".", "B"}]}], 
  TraditionalForm]], "InlineMath"]], "NumberedEquation",
 CellID->825647009],

Cell[TextData[{
 "This can be done by first solving for ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " in the following."
}], "Text",
 CellID->1757436996],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"L", ".", "y"}], " ", "\[LongEqual]", " ", 
   RowBox[{"P", ".", "B"}]}], 
  TraditionalForm]], "InlineMath"]], "NumberedEquation",
 CellID->753510934],

Cell[TextData[{
 "Then solve for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " to get the desired solution."
}], "Text",
 CellID->547201379],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"U", ".", "x"}], " ", "\[LongEqual]", " ", "y"}], 
  TraditionalForm]]]], "NumberedEquation",
 CellID->1288600399],

Cell[TextData[{
 "Because both ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " are triangular matrices it is particularly easy to solve these systems."
}], "Text",
 CellID->134325998],

Cell[TextData[{
 "Despite the fact that in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you do not need to use the LU decomposition for solving matrix equations, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides the function ",
 Cell[BoxData[
  ButtonBox["LUDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUDecomposition"]], "InlineFormula"],
 " for computing the LU decomposition."
}], "Text",
 CellID->611735389],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LUDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LUDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the LU decomposition with partial pivoting", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1432464734],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LUDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUDecomposition"]], "InlineFormula"],
 " returns a list of three elements. The first element is a combination of \
upper and lower triangular matrices, the second element is a vector \
specifying rows used for pivoting (a permutation vector which is equivalent \
to the permutation matrix), and the third element is an estimate of the \
condition number."
}], "Text",
 CellTags->{"S0.1574", "LUDecomposition"},
 CellID->2143101468],

Cell[TextData[{
 "In this example, the three results of the ",
 Cell[BoxData[
  ButtonBox["LUDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUDecomposition"]], "InlineFormula"],
 " computation are shown."
}], "Text",
 CellID->1510645192],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.", ",", "2.", ",", "8."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4.", ",", "1."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"mLU", ",", "vecP", ",", "cond"}], "}"}], "=", 
  RowBox[{"LUDecomposition", "[", "mat", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1862067110],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.`", ",", "0.6000000000000001`", ",", "0.2`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "2.8`", ",", "0.5714285714285715`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8.`", ",", 
       RowBox[{"-", "3.8000000000000007`"}], ",", "3.571428571428572`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", "10.2`"}], "}"}]], "Output",\

 ImageSize->{510, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->482730039]
}, Open  ]],

Cell[TextData[{
 "One of the features of the LU decomposition is that the lower and upper \
matrices are stored in the same matrix. The individual ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " factors can be obtained as follows. Note how they use a vectorized \
operation for element by element multiplication with a sparse matrix. This \
makes the process more efficient; these techniques are discussed further \
under \"",
 ButtonBox["Programming Efficiency",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraPerformance#1030559832"],
 "\"."
}], "Text",
 CellID->50547107],

Cell[TextData[{
 "This generates the ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 " matrix."
}], "Text",
 CellID->1289186784],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mL", "=", 
   RowBox[{"Transpose", "[", "mLU", "]"}]}], ";", " ", 
  RowBox[{"num", "=", 
   RowBox[{"Length", "[", "mL", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{"i", "\[GreaterEqual]", "j"}]}], "->", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"num", ",", "num"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mL", "=", 
   RowBox[{"sp", " ", "mL"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"mL", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "i"}], "]"}], "]"}], "=", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "num"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"mL", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1399764105],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0.6000000000000001`", "1", "0"},
     {"0.2`", "0.5714285714285715`", "1"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{124, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->151959850]
}, Open  ]],

Cell[TextData[{
 "This generates the ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " matrix."
}], "Text",
 CellID->631142667],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mU", "=", 
   RowBox[{"Transpose", "[", "mLU", "]"}]}], ";", " ", 
  RowBox[{"num", "=", 
   RowBox[{"Length", "[", "mU", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{"i", "\[LessEqual]", "j"}]}], "->", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"num", ",", "num"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mU", "=", 
   RowBox[{"mU", " ", "sp"}]}], ";"}], "\n", 
 RowBox[{"mU", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->1193071736],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"5.`", "2.`", "8.`"},
     {"0", "2.8`", 
      RowBox[{"-", "3.8000000000000007`"}]},
     {"0", "0", "3.571428571428572`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{124, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//MatrixForm=",
 CellID->901854913]
}, Open  ]],

Cell[TextData[{
 "The original matrix was non-singular and so this is a factorization. \
Therefore multiplying ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " recreates the original matrix permuted with the row pivot vector."
}], "Text",
 CellID->535942265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mL", ".", "mU"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1035232337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.`", ",", "2.`", ",", "8.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.0000000000000004`", ",", "4.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.`", ",", "3.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->237379965]
}, Open  ]],

Cell[TextData[{
 "The following subtracts the product of the ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " matrices from the permuted original matrix. The difference is very close \
to zero."
}], "Text",
 CellID->1767939276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "[", 
   RowBox[{"[", "vec", "]"}], "]"}], "-", "%"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1171671840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.440892098500626`*^-16"}], ",", "0.`", ",", "0.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{359, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->2011055537]
}, Open  ]],

Cell[TextData[{
 "The diagonal elements in the ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " matrix are known as the pivots. If any zero pivots emerge during a \
computation of the LU factorization this means that the matrix is singular. \
In such a case ",
 Cell[BoxData[
  ButtonBox["LUDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LUDecomposition"]], "InlineFormula"],
 " produces a warning."
}], "Text",
 CellID->565290226],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2.", ",", "3."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"LUDecomposition", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->365174054],

Cell[BoxData[
 RowBox[{
  RowBox[{"LUDecomposition", "::", "\<\"sing\"\>"}], ":", 
  " ", "\<\"Matrix \\!\\({\\(\\({1.`, 2.`, 3.`}\\)\\), \\(\\({1.`, 2.`, \
3.`}\\)\\), \\(\\({1.`, 2.`, 3.`}\\)\\)}\\) is singular. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideNotebookLink\\\", ButtonFrame->None, \
ButtonData:>\\\"General::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"From In[14]:=",
 CellID->2119546099],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "\[Infinity]"}], 
  "}"}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->752549457]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cholesky Decomposition", "Subsection",
 CellTags->{"t:194", "c:107"},
 CellID->1567526616],

Cell[TextData[{
 "The Cholesky decomposition of a symmetric positive definite matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is a factorization into a unique upper triangular ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 " such that"
}], "Text",
 CellID->90453716],

Cell[BoxData[
 FormBox[
  RowBox[{"A", "\[LongEqual]", 
   RowBox[{
    SuperscriptBox["G", "T"], ".", "G"}]}], 
  TraditionalForm]], "NumberedEquation",
 CellID->1984666383],

Cell[TextData[{
 "This factorization has a number of uses, one of which is that, because it \
is a triangular factorization, it can be used to solve systems of equations \
involving symmetric positive definite matrices. (The way that a triangular \
factorization can be used to solve a matrix equation is shown above in the \
section on \"",
 ButtonBox["LU Decomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#849593972"],
 "\".) If a matrix is known to be of this form it is preferred over the LU \
factorization ",
 "because",
 " the Cholesky factorization is faster to compute. If you want to solve a \
matrix equation using the Cholesky factorization you can do this directly \
from ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " using the Cholesky method, this is described in a ",
 ButtonBox["previous",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1549309818"],
 " section."
}], "Text",
 CellID->1571893877],

Cell[TextData[{
 "The Cholesky factorization can be computed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the function ",
 Cell[BoxData[
  ButtonBox["CholeskyDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CholeskyDecomposition"]], "InlineFormula"],
 "."
}], "Text",
 CellID->476565345],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CholeskyDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CholeskyDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the Cholesky decomposition ", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1667233752],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10.", ",", "5."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "20."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matG", "=", 
   RowBox[{"CholeskyDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"matG", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->831043808],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.1622776601683795`", "1.5811388300841898`"},
     {"0.`", "4.183300132670378`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{130, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->119640968]
}, Open  ]],

Cell["This reconstructs the original matrix.", "Text",
 CellID->761055584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", "matG", "]"}], ".", "matG"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->648598756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10.000000000000002`", ",", "5.000000000000001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.000000000000001`", ",", "20.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->372299920]
}, Open  ]],

Cell["\<\
If the matrix is not positive definite then the Cholesky decomposition does \
not exist.\
\>", "Text",
 CellID->1624891729],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10.", ",", "5."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "1."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"CholeskyDecomposition", "[", "mat1", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->5750404],

Cell[BoxData[
 RowBox[{
  RowBox[{"CholeskyDecomposition", "::", "\<\"posdef\"\>"}], ":", 
  " ", "\<\"The matrix \\!\\({\\(\\({\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)}\\)\\), \\(\\({\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)}\\)\\)}\\) is not sufficiently positive definite to \
complete the Cholesky decomposition to reasonable accuracy. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideNotebookLink\\\", ButtonFrame->None, \
ButtonData:>\\\"CholeskyDecomposition::posdef\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"From In[5]:=",
 CellID->10275913],

Cell[BoxData[
 RowBox[{"CholeskyDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10.`", ",", "5.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5.`", ",", "1.`"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->908578031]
}, Open  ]],

Cell["\<\
There are a number of equivalent definitions of positive definite, such as \
the eigenvalues being all positive.\
\>", "Text",
 CellID->1862236847],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10.", ",", "5."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "20."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1188016151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22.071067811865472`", ",", "7.928932188134525`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1831983698]
}, Open  ]],

Cell["\<\
One way to test if a matrix is positive definite is to see if the Cholesky \
decomposition exists.\
\>", "Text",
 CellID->1676965247],

Cell["\<\
Note that if the matrix is complex, the factorization is defined by the \
conjugate transpose. The following computes the Cholesky decomposition of a \
complex matrix.\
\>", "Text",
 CellID->1179523101],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11.", ",", 
       RowBox[{"3.", "+", 
        RowBox[{"1.", "I"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3.", "-", 
        RowBox[{"1.", "I"}]}], ",", "3."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"matG", "=", 
  RowBox[{"CholeskyDecomposition", "[", "mat", "]"}]}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->823213050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3.3166247903554`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9045340337332909`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.30151134457776363`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"1.4459976109624424`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1652077376]
}, Open  ]],

Cell["This demonstrates that the factorization is correct.", "Text",
 CellID->1648386369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Conjugate", "[", 
    RowBox[{"Transpose", "[", "matG", "]"}], "]"}], ".", "matG"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1890657483],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"11.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"3.`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"3.`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"3.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{143, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//MatrixForm=",
 CellID->2112275769]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cholesky and LU Factorizations", "Subsubsection",
 CellTags->{"t:210", "c:108"},
 CellID->966681026],

Cell["\<\
The Cholesky factorization is related to the LU factorization as\
\>", "Text",
 CellID->1294214427],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["G", "T"], "\[LongEqual]", " ", 
   RowBox[{"L", " ", ".", 
    SqrtBox["D"]}]}], TraditionalForm]], "NumberedEquation",
 CellID->14126],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["D", TraditionalForm]], "InlineMath"],
 " is the diagonal matrix of pivots. This can be demonstrated as follows."
}], "Text",
 CellID->237415682],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10.", ",", "5."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "20."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"mLU", ",", "vec", ",", "cond"}], "}"}], "=", 
   RowBox[{"LUDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matG", "=", 
   RowBox[{"CholeskyDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"matG", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->220751248],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.1622776601683795`", "1.5811388300841898`"},
     {"0.`", "4.183300132670378`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{130, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->1461966767]
}, Open  ]],

Cell[TextData[{
 "Now you can compute the ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 " matrix."
}], "Text",
 CellID->1915047642],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mL", "=", 
   RowBox[{"Transpose", "[", "mLU", "]"}]}], ";", " ", 
  RowBox[{"num", "=", 
   RowBox[{"Length", "[", "mL", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{"i", "\[GreaterEqual]", "j"}]}], "->", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"num", ",", "num"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mL", "=", 
   RowBox[{"sp", " ", "mL"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"mL", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "i"}], "]"}], "]"}], "=", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "num"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"mL", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1868301505],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"0.5`", "1"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{60, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//MatrixForm=",
 CellID->37508101]
}, Open  ]],

Cell["This step computes the matrix of pivots.", "Text",
 CellID->1185944936],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"num", ",", "num"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mD", "=", 
   RowBox[{"mLU", " ", "sp"}]}], ";"}], "\n", 
 RowBox[{"mD", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[10]:=",
 CellID->1380811545],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"10.`", "0"},
     {"0", "17.5`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{81, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//MatrixForm=",
 CellID->1591347333]
}, Open  ]],

Cell[TextData[{
 "Finally, this computes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     RowBox[{
      SuperscriptBox["L", " "], "."}],
     TraditionalForm], 
    SqrtBox["D"]}], TraditionalForm]], "InlineMath"],
 "; its transpose is equal to the Cholesky decomposition."
}], "Text",
 CellID->1013285993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"mL", ".", 
     RowBox[{"Sqrt", "[", "mD", "]"}]}], ")"}], "//", "Transpose"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->752363641],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.1622776601683795`", "1.5811388300841898`"},
     {"0.`", "4.183300132670378`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{130, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//MatrixForm=",
 CellID->592000751]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Orthogonalization", "Subsection",
 CellTags->{"t:195", "c:109"},
 CellID->464885506],

Cell[TextData[{
 "Orthogonalization generates an orthonormal basis from an arbitrary basis. \
An orthonormal basis is a basis, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["\[Nu]", "1"], ",", 
     SubscriptBox["\[Nu]", "2"], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ", for which"
}], "Text",
 CellID->785191556],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Nu]", "i"], ".", 
    SubscriptBox["\[Nu]", "j"]}], "\[LongEqual]", 
   RowBox[{"{", GridBox[{
      {
       RowBox[{
        RowBox[{"1", "   ", "i"}], "\[LongEqual]", "j"}]},
      {
       RowBox[{
        RowBox[{"0", "   ", "i"}], "\[NotEqual]", "j"}]}
     }]}]}], TraditionalForm]], "NumberedEquation",
 CellID->427470877],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a set of vectors can be orthogonalized with the function ",
 Cell[BoxData[
  ButtonBox["Orthogonalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orthogonalize"]], "InlineFormula"],
 "."
}], "Text",
 CellID->565059398],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox[
      ButtonBox["Orthogonalize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Orthogonalize"], "MR"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell["\<\
generate an orthonormal set from the given list of real vectors \
\>", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S5.49.1",
 CellID->1409177642],

Cell[TextData[{
 "This creates a set of three vectors that form a basis for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "3"], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->458374344],

Cell[BoxData[{
 RowBox[{
  RowBox[{"w1", "=", 
   RowBox[{"{", 
    RowBox[{"1.", ",", "1", ",", "1."}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1.2", ",", "0.9"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w3", "=", 
   RowBox[{"{", 
    RowBox[{"1.", ",", "1.", ",", "0.8"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->873757819],

Cell["\<\
A plot visualizes the vectors; they all tend to lie in the same direction.\
\>", "Text",
 CellID->754485747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0", "]"}], ",", 
      RowBox[{"Map", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"Line", "[", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "#"}], "}"}], 
          "]"}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}]}], "]"}]}], "}"}], "]"}],
    ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1898497941],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0], Line3DBox[{{0, 0, 0}, {1., 1, 1.}}], 
   Line3DBox[{{0, 0, 0}, {1, 1.2, 0.9}}], 
   Line3DBox[{{0, 0, 0}, {1., 1., 0.8}}]},
  Axes->True]], "Output",
 ImageSize->{184, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->357870145,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["This computes an orthonormal basis.", "Text",
 CellID->2047615616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "=", 
  RowBox[{"Orthogonalize", "[", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->850214937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.5773502691896258`", ",", "0.5773502691896258`", ",", 
     "0.5773502691896258`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.15430334996209347`"}], ",", "0.771516749810458`", ",", 
     RowBox[{"-", "0.6172133998483692`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8017837257372739`", ",", 
     RowBox[{"-", "0.2672612419124238`"}], ",", 
     RowBox[{"-", "0.534522483824848`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{469, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->19652830]
}, Open  ]],

Cell["The orthonormal vectors are obviously much more spread out.", "Text",
 CellID->556759689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0", "]"}], ",", 
      RowBox[{"Map", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"Line", "[", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "#"}], "}"}], 
          "]"}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}]}], "]"}]}], "}"}], "]"}],
    ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->873843044],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0], 
   Line3DBox[{{0, 0, 0}, {0.5773502691896258, 0.5773502691896258, 
     0.5773502691896258}}], 
   Line3DBox[{{0, 0, 0}, {-0.15430334996209347`, 
     0.771516749810458, -0.6172133998483692}}], 
   Line3DBox[{{0, 0, 0}, {
     0.8017837257372739, -0.2672612419124238, -0.534522483824848}}]},
  Axes->True]], "Output",
 ImageSize->{183, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->149302701,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "The vectors ",
 Cell[BoxData["v1"], "InlineFormula"],
 ", ",
 Cell[BoxData["v2"], "InlineFormula"],
 ", and ",
 Cell[BoxData["v3"], "InlineFormula"],
 " are orthonormal, thus the dot product of each vector with itself is 1."
}], "Text",
 CellID->412427449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", ".", "#"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1738406474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0000000000000002`", ",", "1.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->204635167]
}, Open  ]],

Cell["\<\
In addition, the dot product of a vector with another vector is 0.\
\>", "Text",
 CellID->1038782152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v1", ".", "v2"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1917062201],

Cell[BoxData[
 RowBox[{"-", "2.6645352591003757`*^-15"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->304936810]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " to compare all vectors with all other vectors."
}], "Text",
 CellID->1401039762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", " ", 
   RowBox[{"Dot", ",", 
    RowBox[{"{", 
     RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], ",", "1"}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->117090579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.0000000000000002`", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->11904355]
}, Open  ]],

Cell["\<\
By default a Gram-Schmidt orthogonalization is computed, but a number of \
other orthogonalizations can be computed.\
\>", "Text",
 CellID->129867270],

Cell[BoxData[GridBox[{
   {" ", "GramSchmidt"},
   {" ", "ModifiedGramSchmidt"},
   {" ", "Reorthogonalization"},
   {" ", "Householder"}
  }]], "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->45083515],

Cell["Orthogonalization methods.", "Caption",
 CellID->459960165],

Cell[TextData[{
 "This uses a ",
 StyleBox["Householder", "MR"],
 " method."
}], "Text",
 CellID->384226275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orthogonalize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "Householder"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->274127522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5773502691896257`"}], ",", 
     RowBox[{"-", "0.5773502691896257`"}], ",", 
     RowBox[{"-", "0.5773502691896257`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.15430334996209172`", ",", 
     RowBox[{"-", "0.7715167498104595`"}], ",", "0.6172133998483676`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8017837257372732`"}], ",", "0.2672612419124245`", ",", 
     "0.5345224838248487`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{454, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->337018741]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["QR Decomposition", "Subsection",
 CellTags->{"t:196", "c:110"},
 CellID->1662286926],

Cell[TextData[{
 "The QR decomposition of a rectangular matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " with linearly independent columns involves the computation of matrices ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " such that"
}], "Text",
 CellID->1441601459],

Cell[BoxData[
 FormBox[
  RowBox[{"A", "\[LongEqual]", 
   RowBox[{"Q", " ", ".", " ", "R"}]}], TraditionalForm]], "NumberedEquation",\

 CellID->1085215959],

Cell[TextData[{
 "where the columns of ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " form an orthonormal basis for the columns of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is upper triangular. It can be computed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the function ",
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 "."
}], "Text",
 CellID->646008942],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["QRDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/QRDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the QR decomposition of a matrix", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1942452609],

Cell["\<\
This computes the QR decomposition of a sample matrix. The result is a list \
of the two matrices.\
\>", "Text",
 CellID->754597769],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "8."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"matQ", ",", " ", "matR"}], "}"}], "=", 
  RowBox[{"QRDecomposition", "[", " ", "mat", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1633768048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.24253562503633308`"}], ",", 
       RowBox[{"-", "0.970142500145332`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.970142500145332`"}], ",", "0.24253562503633289`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4.123105625617661`"}], ",", 
       RowBox[{"-", "8.488746876271655`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.9701425001453329`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{341, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1013672194]
}, Open  ]],

Cell[TextData[{
 "In fact the first argument that is returned is a list of the orthonormal \
columns. To generate the ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " matrix it is necessary to compute the transpose, as shown below."
}], "Text",
 CellID->800792907],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"matQ", "=", 
   RowBox[{"Transpose", "[", "matQ", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matQ", "//", "MatrixForm"}], ",", " ", 
   RowBox[{"matR", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->646372200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.24253562503633308`"}], 
        RowBox[{"-", "0.970142500145332`"}]},
       {
        RowBox[{"-", "0.970142500145332`"}], "0.24253562503633289`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "4.123105625617661`"}], 
        RowBox[{"-", "8.488746876271655`"}]},
       {"0.`", 
        RowBox[{"-", "0.9701425001453329`"}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{334, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1605278874]
}, Open  ]],

Cell[TextData[{
 "This is a matrix factorization, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", ".", "R"}], TraditionalForm]], "InlineMath"],
 " is equal to ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->1084978057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matQ", ".", "matR"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->942557322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.0000000000000004`", ",", "3.000000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "8.000000000000002`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1721530582]
}, Open  ]],

Cell[TextData[{
 "In addition, the columns of ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " are orthonormal. Because the result of ",
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 " returns the list of columns, they can be extracted with one part index. \
The following two examples demonstrate the orthonormal properties of the \
columns."
}], "Text",
 CellID->717315643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matQ", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}], ".", 
  RowBox[{"matQ", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2098301290],

Cell[BoxData["1.8848854768660495`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->173329996]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matQ", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}], ".", 
  RowBox[{"matQ", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1169417440],

Cell[BoxData["1.0000000000000002`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->628576736]
}, Open  ]],

Cell[TextData[{
 "The QR decomposition is also defined for rectangular matrices. In this case \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", "<", " ", "n"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->1017142359],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "7.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", " ", "5.", ",", " ", "1."}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matQ", ",", " ", "matR"}], "}"}], "=", 
   RowBox[{"QRDecomposition", "[", "mat", "]"}]}], ";", 
  RowBox[{"matQ", "=", 
   RowBox[{"Transpose", "[", "matQ", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matQ", "//", "MatrixForm"}], ",", " ", 
   RowBox[{"matR", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->1141797593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.24253562503633308`"}], 
        RowBox[{"-", "0.970142500145332`"}]},
       {
        RowBox[{"-", "0.970142500145332`"}], "0.24253562503633289`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "4.123105625617661`"}], 
        RowBox[{"-", "6.5484618759809905`"}], 
        RowBox[{"-", "1.6977493752543316`"}]},
       {"0.`", 
        RowBox[{"-", "5.578319375835659`"}], 
        RowBox[{"-", "2.6678918753996634`"}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{392, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->278275959]
}, Open  ]],

Cell[TextData[{
 "For an input matrix where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", "\[LessEqual]", " ", "n"}], TraditionalForm]], 
  "InlineMath"],
 ", the result of ",
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 " are two matrices: an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Times]", "m"}], TraditionalForm]], "InlineMath"],
 " matrix ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " and an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ". When the matrix represents an overdetermined system of equations, that \
is, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", " ", ">", " ", "n"}], TraditionalForm]], "InlineMath"],
 ",",
 " ",
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 " returns an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " and an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 ". (Note that to generate the matrix ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 ", it is necessary to transpose the result from ",
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 ".) This is demonstrated in the following example."
}], "Text",
 CellID->1912143394],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "7."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", " ", 
      RowBox[{"5.", ",", " ", "1."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matQ", ",", " ", "matR"}], "}"}], "=", 
   RowBox[{"QRDecomposition", "[", "mat", "]"}]}], ";", 
  RowBox[{"matQ", "=", 
   RowBox[{"Transpose", "[", "matQ", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matQ", "//", "MatrixForm"}], ",", " ", 
   RowBox[{"matR", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->301245603],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.16903085094570325`"}], "0.8970852271450606`"},
       {
        RowBox[{"-", "0.50709255283711`"}], "0.27602622373694174`"},
       {
        RowBox[{"-", "0.8451542547285166`"}], 
        RowBox[{"-", "0.34503277967117707`"}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "5.916079783099616`"}], 
        RowBox[{"-", "4.056740422696878`"}]},
       {"0.`", "7.038668705292011`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{327, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1415893642]
}, Open  ]],

Cell[TextData[{
 "This is often referred to as the thin QR decomposition, see for example ",
 ButtonBox["Golub and van Loan",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#1770071216"],
 ". If you wish to compute the full QR decomposition, it is possible to pad \
out ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " with extra rows of zeros and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " with extra orthonormal columns. This can be done with the following \
function."
}], "Text",
 CellID->658148687],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullQRDecomposition", "[", " ", "mat_", "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"q", ",", "r", ",", "n", ",", "m"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q", ",", "r"}], "}"}], "=", 
      RowBox[{"QRDecomposition", "[", "mat", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", "m"}], "}"}], "=", 
      RowBox[{"Dimensions", "[", "mat", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{"q", ",", 
         RowBox[{"NullSpace", "[", "q", "]"}]}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Join", "[", 
        RowBox[{"r", ",", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"n", "-", 
             RowBox[{"Length", "[", "r", "]"}]}], "}"}], ",", 
           RowBox[{"{", "m", "}"}]}], "]"}]}], "]"}]}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->1964200359],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " computed by this function are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Cross]", "m"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 ", respectively."
}], "Text",
 CellID->1196812029],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "7."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", " ", 
      RowBox[{"5.", ",", " ", "1."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matQ", ",", " ", "matR"}], "}"}], "=", 
   RowBox[{"FullQRDecomposition", "[", "mat", "]"}]}], ";", 
  RowBox[{"matQ", "=", 
   RowBox[{"Transpose", "[", "matQ", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matQ", "//", "MatrixForm"}], ",", " ", 
   RowBox[{"matR", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->1487933601],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.16903085094570325`"}], "0.8970852271450606`", 
        "0.408248290463863`"},
       {
        RowBox[{"-", "0.50709255283711`"}], "0.27602622373694174`", 
        RowBox[{"-", "0.816496580927726`"}]},
       {
        RowBox[{"-", "0.8451542547285166`"}], 
        RowBox[{"-", "0.34503277967117707`"}], "0.408248290463863`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "5.916079783099616`"}], 
        RowBox[{"-", "4.056740422696878`"}]},
       {"0.`", "7.038668705292011`"},
       {"0", "0"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{399, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->252962692]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matQ", ".", "matR"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->1673827031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999997`", ",", "6.999999999999998`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "3.999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "0.9999999999999997`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->2122617964]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving Systems of Equations", "Subsubsection",
 CellTags->{"t:199", "c:111"},
 CellID->841776984],

Cell[TextData[{
 "For a square non-singular matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " the QR decomposition can be used to solve the matrix equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", ".", " ", "x"}], " ", "\[LongEqual]", " ", "B"}], 
   TraditionalForm]], "InlineMath"],
 ", as is also the case for the LU decomposition. However, when the matrix is \
rectangular, the QR decomposition is also useful for solving the matrix \
equation."
}], "Text",
 CellID->123503652],

Cell[TextData[{
 "One particular application of the QR decomposition is to find ",
 ButtonBox["least squares solutions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#563250646"],
 " to overdetermined systems, by solving the system of normal equations"
}], "Text",
 CellID->1256676162],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["A", "T"], ".", "A", ".", "x"}], "\[LongEqual]", 
   RowBox[{
    SuperscriptBox["A", "T"], ".", "B"}]}], 
  TraditionalForm]], "NumberedEquation",
 CellID->454586489],

Cell[TextData[{
 "because",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["Q", "T"], ".", " ", "Q"}], " ", "\[LongEqual]", " ", 
    "I"}], TraditionalForm]]],
 ", this can be simplified as"
}], "Text",
 CellID->1635788244],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["A", "T"], ".", "A"}], " ", "\[LongEqual]", " ", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"Q", ".", "R"}], ")"}], "T"], ".", 
    RowBox[{"(", 
     RowBox[{"Q", ".", "R"}], ")"}]}], " ", "\[LongEqual]", " ", 
   RowBox[{
    SuperscriptBox["R", "T"], ".", "R"}]}], 
  TraditionalForm]], "InlineMath"]], "NumberedEquation",
 CellID->607368014],

Cell["Thus the normal equations simplify to", "Text",
 CellID->1044437107],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["R", "T"], ".", "R", ".", "x"}], " ", "\[LongEqual]", " ", 
   
   RowBox[{
    SuperscriptBox["R", "T"], ".", 
    SuperscriptBox["Q", "T"], ".", "B"}]}], 
  TraditionalForm]], "InlineMath"]], "NumberedEquation",
 CellID->323126771],

Cell[TextData[{
 "and ",
 "because",
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "T"], TraditionalForm]], "InlineMath"],
 " is non-singular this simplifies to"
}], "Text",
 CellID->1952980581],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"R", ".", "x"}], " ", "\[LongEqual]", " ", 
   RowBox[{
    SuperscriptBox["Q", "T"], ".", "b"}]}], 
  TraditionalForm]], "InlineMath"]], "NumberedEquation",
 CellID->1604564119],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath"],
 " is triangular this is a particularly easy system to solve; sample code to \
implement this technique is given under ",
 ButtonBox["Examples: Least Squares QR",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraExamples#701643607"],
 "."
}], "Text",
 CellID->1956992654]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Singular Value Decomposition", "Subsection",
 CellTags->{"t:197", "c:112"},
 CellID->315998326],

Cell[TextData[{
 "The singular value decomposition of a rectangular matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " involves the computation of orthogonal matrices ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 " and a diagonal matrix ",
 Cell[BoxData[
  FormBox["D", TraditionalForm]], "InlineMath"],
 " such that"
}], "Text",
 CellID->256806051],

Cell[BoxData[
 FormBox[
  RowBox[{"A", "\[LongEqual]", 
   RowBox[{"U", ".", "D", ".", 
    SuperscriptBox["V", "T"]}]}], TraditionalForm]], "NumberedEquation",
 CellID->1844652334],

Cell[TextData[{
 "The diagonal elements of the matrix ",
 Cell[BoxData[
  FormBox["D", TraditionalForm]], "InlineMath"],
 " are called the singular values of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 ". In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the functions ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " computes the singular values and ",
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 " computes the full singular value decomposition."
}], "Text",
 CellID->1997849446],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SingularValueList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueList"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "a list of the nonzero singular values of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "the singular value decomposition of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1948818077],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.", ",", " ", "1."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"SingularValueList", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->364836095],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.236067977499789`", ",", "1.7639320225002102`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->734436480]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matD", ",", "matV"}], "}"}], "=", 
   RowBox[{"SingularValueDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matU", "//", "MatrixForm"}], ",", 
   RowBox[{"matD", "//", "MatrixForm"}], ",", 
   RowBox[{"matV", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->2085400051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.22975292054736127`"}], "0.9732489894677301`"},
       {
        RowBox[{"-", "0.9732489894677301`"}], 
        RowBox[{"-", "0.22975292054736127`"}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"6.236067977499789`", "0.`"},
       {"0.`", "1.7639320225002102`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.9732489894677301`"}], 
        RowBox[{"-", "0.22975292054736118`"}]},
       {
        RowBox[{"-", "0.2297529205473611`"}], "0.9732489894677302`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{478, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->238054470]
}, Open  ]],

Cell["\<\
This is a factorization so the original matrix can be restored.\
\>", "Text",
 CellID->219442929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matU", ".", "matD", ".", 
   RowBox[{"Transpose", "[", "matV", "]"}]}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->947885804],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.0000000000000002`", "1.9999999999999998`"},
     {"5.999999999999998`", "0.999999999999999`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{60, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->1083014382]
}, Open  ]],

Cell[TextData[{
 "Because the matrices ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 " are orthogonal, they can be used as an orthogonal transformation of the \
original matrix to generate the diagonal matrix with the singular values on \
the diagonal."
}], "Text",
 CellID->151326302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "matU", "]"}], ".", "mat", ".", "matV"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->720519666],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"6.236067977499788`", 
      RowBox[{"-", "3.4596891324012446`*^-16"}]},
     {"7.094476915658898`*^-16", "1.7639320225002104`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{220, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->113741029]
}, Open  ]],

Cell["\<\
If the matrix is singular then some of the singular values will be zero.\
\>", "Text",
 CellID->385028573],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matD", ",", "matV"}], "}"}], "=", 
   RowBox[{"SingularValueDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"matD", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->806998000],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.1622776601683795`", "0.`"},
     {"0.`", "0.`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{95, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//MatrixForm=",
 CellID->1856155195]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " only returns the ",
 "nonzero",
 " singular values."
}], "Text",
 CellID->2052906043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", "mat", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1719591999],

Cell[BoxData[
 RowBox[{"{", "3.1622776601683795`", "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->347805867]
}, Open  ]],

Cell["\<\
Note that if the matrix is complex, the definition of the singular value \
decomposition uses the conjugate transpose.\
\>", "Text",
 CellID->122719535],

Cell[TextData[{
 "There are many applications of the singular value decomposition. The \
singular values of a matrix give information on the linear transformation \
represented by ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 ". For example, the action of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " on a unit sphere generates an ellipsoid with semiaxes given by the \
singular values. The singular values can be used to compute the rank of a \
matrix; the number of nonzero singular values is equal to the rank. The \
singular values can be used to compute the 2-norm of a matrix, and the \
columns of the ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 " matrix that correspond to zero singular values are the null space of the \
matrix."
}], "Text",
 CellID->962923625],

Cell[TextData[{
 "Certain applications of singular values do not require all of the singular \
values to be computed. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a mechanism for obtaining only some singular values."
}], "Text",
 CellID->420601583],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SingularValueList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueList"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the largest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " singular values of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the corresponding singular value decomposition of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueList"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["-", "MR"], 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the smallest ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " singular values of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["-", "MR"], 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the corresponding singular value decomposition of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1682123204],

Cell["\<\
This returns the smallest singular value of the input matrix; because it is \
zero, this demonstrates the matrix is not full rank.\
\>", "Text",
 CellID->1969960520],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"SingularValueList", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"-", "1"}]}], "]"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->1371073841],

Cell[BoxData[
 RowBox[{"{", "0.`", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1138513377]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generalized Singular Values", "Subsubsection",
 CellTags->{"t:211", "c:113"},
 CellID->915032469],

Cell[TextData[{
 "For an ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "\[Times]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "\[Times]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " matrix ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 " the generalized singular values are given by the pair of factorizations"
}], "Text",
 CellID->820310316],

Cell[BoxData[
 FormBox[
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"U", " ", ".", " ", 
      SubscriptBox["\[CapitalSigma]", "1"], ".", 
      SuperscriptBox["Q", "T"]}], "    ", "and", "     ", "B"}], "=", 
    RowBox[{"V", " ", ".", " ", 
     SubscriptBox["\[CapitalSigma]", "2"], ".", 
     SuperscriptBox["Q", "T"]}]}]}], TraditionalForm]], "NumberedEquation",
 CellID->110467272],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Times]", "m"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Times]", "p"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 "; ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["V", TraditionalForm]], "InlineMath"],
 " are orthogonal, and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " is invertible."
}], "Text",
 CellID->1197569496],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SingularValueList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueList"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized singular values of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueDecomposition"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized singular value decomposition of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1333779588],

Cell["These are some sample matrices.", "Text",
 CellID->1399228130],

Cell[BoxData[{
 RowBox[{
  RowBox[{"matA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "3."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matB", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "2."}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1881246260],

Cell[TextData[{
 "This returns the generalized singular values of the matrices ",
 Cell[BoxData["matA"], "InlineFormula"],
 " and ",
 Cell[BoxData["matB"], "InlineFormula"],
 "."
}], "Text",
 CellID->704157039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", " ", 
  RowBox[{"{", 
   RowBox[{"matA", ",", "matB"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2132459503],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.2360679774997902`", ",", "0.44721359549995804`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->892282138]
}, Open  ]],

Cell[TextData[{
 "This computes the full generalized singular value decomposition of the \
matrices ",
 Cell[BoxData["matA"], "InlineFormula"],
 " and ",
 Cell[BoxData["matB"], "InlineFormula"],
 "."
}], "Text",
 CellID->707586365],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"matU", ",", "matV"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dU", ",", "dV"}], "}"}], ",", "matQ"}], "}"}], "=", 
   RowBox[{"SingularValueDecomposition", "[", " ", 
    RowBox[{"{", 
     RowBox[{"matA", ",", "matB"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1787083116],

Cell[TextData[{
 "This demonstrates the identity for ",
 Cell[BoxData["matA"], "InlineFormula"],
 "."
}], "Text",
 CellID->799643670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matU", ".", "dU", ".", 
   RowBox[{"Transpose", "[", "matQ", "]"}]}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->658498764],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.0000000000000004`", "2.000000000000001`"},
     {"4.`", "3.`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{60, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->1405493557]
}, Open  ]],

Cell[TextData[{
 "This demonstrates the identity for ",
 Cell[BoxData["matB"], "InlineFormula"],
 "."
}], "Text",
 CellID->1957579146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matV", ".", "dV", ".", 
   RowBox[{"Transpose", "[", "matQ", "]"}]}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1583234782],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4.000000000000001`", "1.0000000000000004`"},
     {"3.`", "1.9999999999999998`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{60, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->2104594744]
}, Open  ]],

Cell["\<\
Finally, the singular values are computed by dividing the corresponding \
diagonal elements.\
\>", "Text",
 CellID->720712671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tr", "[", 
   RowBox[{"dU", ",", "List"}], "]"}], "/", 
  RowBox[{"Tr", "[", 
   RowBox[{"dV", ",", "List"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1210092417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.2360679774997902`", ",", "0.44721359549995804`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1353115429]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "Subsubsection",
 CellTags->{"t:212", "c:114"},
 CellID->2106677120],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 " both take a ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " option. "
}], "Text",
 CellID->1359467751],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the tolerance for treating small singular values as zero ", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S5.27.1",
 CellID->1495970624],

Cell[TextData[{
 "The option controls the size at which singular values are treated as being \
zero. By default, values that are ",
 StyleBox["tol",
  FontSlant->"Italic"],
 " times smaller than the largest singular value are dropped, where ",
 StyleBox["tol",
  FontSlant->"Italic"],
 " is 100\[Times]",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " for machine number matrices. For arbitrary-precision matrices it is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "p"}]], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is the precision of the matrix."
}], "Text",
 CellID->39738492],

Cell["\<\
The smallest singular value of this matrix is just larger than the default \
setting for the tolerance. It is not treated as being equivalent to a zero \
singular value.\
\>", "Text",
 CellID->17420827],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", 
       RowBox[{"4.", "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "13"}]]}]}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"num", "=", 
  RowBox[{"SingularValueList", "[", "mat", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->734063397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.9999999999995195`", ",", "1.1968888694147457`*^-13"}], 
  "}"}]], "Output",
 ImageSize->{133, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109961364]
}, Open  ]],

Cell["\<\
Increasing the setting for the tolerance causes the small singular value to \
be treated as being zero.\
\>", "Text",
 CellID->1284708328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"Tolerance", "\[Rule]", 
    SuperscriptBox["10", 
     RowBox[{"-", "12"}]]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1292281758],

Cell[BoxData[
 RowBox[{"{", "4.9999999999995195`", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1877384595]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Schur Decomposition", "Subsection",
 CellTags->{"t:181", "c:115"},
 CellID->225662794],

Cell[TextData[{
 "The Schur decomposition of a square matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " involves finding a unitary matrix ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " that can be used for a similarity transformation of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " to form a block upper triangular matrix ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " with 1\[Times]1 and 2\[Times]2 blocks on the diagonal (the 2\[Times]2 \
blocks correspond to complex conjugate pairs of eigenvalues for a real matrix \
",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 "). A block upper triangular matrix of this form can be called upper \
quasi-triangular."
}], "Text",
 CellID->258458156],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["U", "T"], ".", "A", ".", "U"}], "\[LongEqual]", "T"}], 
  TraditionalForm]], "NumberedEquation",
 CellID->1694293658],

Cell[TextData[{
 "The Schur decomposition always exists and so the similarity transformation \
of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " to upper triangular always exists. This contrasts with the eigensystem \
similarity transformation, used to ",
 ButtonBox["diagonalize a matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1770480598"],
 ", which does not always exist."
}], "Text",
 CellID->360350786],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SchurDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SchurDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the Schur decomposition of a matrix", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->511775762],

Cell["\<\
This computes the Schur decomposition of a sample matrix. The result is a \
list of the two matrices.\
\>", "Text",
 CellID->743225699],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.", ",", "3."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matT"}], "}"}], "=", 
   RowBox[{"SchurDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matU", "//", "MatrixForm"}], ",", " ", 
   RowBox[{"matT", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1629432141],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.8944271909999159`"}], 
        RowBox[{"-", "0.4472135954999579`"}]},
       {"0.4472135954999579`", 
        RowBox[{"-", "0.8944271909999159`"}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1.`"}], "2.`"},
       {"0.`", "5.`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{249, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1154527243]
}, Open  ]],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " can be used for a similarity transformation on the matrix to generate the \
upper triangular result ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->1624622456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "matU", "]"}], ".", "mat", ".", "matU"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1922530034],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1.`"}], "2.`"},
     {"0.`", "5.`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{68, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->923328676]
}, Open  ]],

Cell["\<\
For this particular matrix, a similarity transformation that generates an \
even simpler form can be found, because the matrix can be diagonalized.\
\>", "Text",
 CellID->668224310],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"matV", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Eigenvectors", "[", "mat", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"invV", "=", 
   RowBox[{"Inverse", "[", "matV", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"invV", ".", "mat", ".", "matV"}], "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1653988007],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"5.`", "0.`"},
     {"0.`", 
      RowBox[{"-", "1.`"}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{68, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->1548106881]
}, Open  ]],

Cell["\<\
This matrix cannot be diagonalized because the matrix of eigenvectors is \
singular.\
\>", "Text",
 CellID->120481915],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"matNoDiag", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "0.", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "0.", ",", "0."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.", ",", "0.", ",", "0."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matV", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Eigenvectors", "[", "matNoDiag", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"invV", " ", "=", " ", 
  RowBox[{"Inverse", "[", " ", "matV", "]"}]}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->2009949931],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"sing\"\>"}], ":", 
  " ", "\<\"Matrix \\!\\(\[LeftSkeleton] 1 \[RightSkeleton]\\) is singular. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideNotebookLink\\\", ButtonFrame->None, \
ButtonData:>\\\"General::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"From In[8]:=",
 CellID->1310723007],

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0.`", ",", "3.006252540013459`*^-292", ",", 
      RowBox[{"-", "3.006252540013459`*^-292"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.`", ",", 
      RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{516, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->434327723]
}, Open  ]],

Cell["\<\
However, the Schur decomposition can be found and the matrix transformed to \
an upper triangular form.\
\>", "Text",
 CellID->449124308],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matQ", ",", "matT"}], "}"}], "=", 
   RowBox[{"SchurDecomposition", "[", "matNoDiag", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matQ", "//", "MatrixForm"}], ",", 
   RowBox[{"matT", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->27225351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`", "0.`"},
       {"1.`", "0.`", "0.`"},
       {"0.`", "0.`", "1.`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`", "0.`"},
       {"0.`", "0.`", "1.`"},
       {"0.`", "0.`", "0.`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{185, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->162457446]
}, Open  ]],

Cell["In this example, the matrix has complex eigenvalues.", "Text",
 CellID->970579585],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", 
       RowBox[{"-", "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "1."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[13]:=",
 CellID->245302483],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1777713188]
}, Open  ]],

Cell[TextData[{
 "Now the resulting matrix ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " has a 2\[Times]2 block on the diagonal."
}], "Text",
 CellID->85570005],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matT"}], "}"}], "=", 
   RowBox[{"SchurDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matU", "//", "MatrixForm"}], ",", 
   RowBox[{"matT", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->1508514192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "1.`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", 
        RowBox[{"-", "1.`"}]},
       {"1.`", "1.`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{149, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->406088462]
}, Open  ]],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " can be used for a similarity transformation on the matrix to generate the \
upper quasi-triangular result. Note that an upper triangular result (with 1\
\[Times]1 blocks on the diagonal) that may involve complex numbers can be \
obtained by using the option ",
 Cell[BoxData[
  ButtonBox["RealBlockForm",
   BaseStyle->"Link",
   ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#35657259"]], 
  "InlineFormula"],
 ". When the result is upper triangular (i.e., has 1\[Times]1 blocks on the \
diagonal) the eigenvalues of the matrix are always found on the diagonal. "
}], "Text",
 CellID->425750668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "matU", "]"}], ".", "mat", ".", "matU"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->175965272],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", 
      RowBox[{"-", "1.`"}]},
     {"1.`", "1.`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{68, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//MatrixForm=",
 CellID->363344585]
}, Open  ]],

Cell["\<\
Note that if the matrix is complex the definition of the Schur decomposition \
uses the conjugate transpose and returns an upper triangular result. This is \
demonstrated for the following complex matrix.\
\>", "Text",
 CellID->1436431674],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.", ",", " ", 
       RowBox[{"4.", "+", 
        RowBox[{"4.", "I"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matT"}], "}"}], "=", 
   RowBox[{"SchurDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matU", "//", "MatrixForm"}], ",", " ", 
   RowBox[{"matT", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[18]:=",
 CellID->95985344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "0.851664051861708`"}], "-", 
         RowBox[{"0.3527708008667425`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.31801102120974567`"}], "-", 
         RowBox[{"0.22156284709190216`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{
         RowBox[{"-", "0.38758367460760634`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"0.9004493241992921`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.19740797786995148`", " ", "\[ImaginaryI]"}]}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"4.19736822693562`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.9101797211244547`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "3.8209322851519096`"}], "-", 
         RowBox[{"2.6620984154044804`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{"0.`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.19736822693562026`"}], "-", 
         RowBox[{"0.9101797211244548`", " ", "\[ImaginaryI]"}]}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{334, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->465457711]
}, Open  ]],

Cell["\<\
This demonstrates that the result satisfies the definition of the Schur \
decomposition.\
\>", "Text",
 CellID->1812306403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matU", ".", "matT", ".", 
    RowBox[{"Conjugate", "[", 
     RowBox[{"Transpose", "[", "matU", "]"}], "]"}]}], "//", "Chop"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1673149820],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.9999999999999987`", 
      RowBox[{"4.`", "\[InvisibleSpace]", "+", 
       RowBox[{"3.9999999999999996`", " ", "\[ImaginaryI]"}]}]},
     {"0.9999999999999997`", "2.`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{98, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]//MatrixForm=",
 CellID->1478150922]
}, Open  ]],

Cell[TextData[{
 "The diagonal of ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " contains the eigenvalues of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->1191717558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "mat", "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->1764505384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.19736822693562`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.9101797211244547`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.19736822693562026`"}], "-", 
    RowBox[{"0.9101797211244548`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{288, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->1440307465]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generalized Schur Decomposition", "Subsubsection",
 CellTags->"c:116",
 CellID->811895271],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrices ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["B", TraditionalForm]], "InlineMath"],
 ", the generalized Schur decomposition is defined as "
}], "Text",
 CellID->412726659],

Cell[BoxData[
 FormBox[
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Q", " ", ".", " ", "S", ".", 
      SuperscriptBox["Z", "T"]}], "    ", "and", "     ", "B"}], "=", 
    RowBox[{"Q", " ", ".", " ", "T", ".", 
     SuperscriptBox["Z", "T"]}]}]}], TraditionalForm]], "NumberedEquation",
 CellID->324778003],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["Z", TraditionalForm]], "InlineMath"],
 " are unitary, ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " is upper triangular, and ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 " is upper quasi-triangular."
}], "Text",
 CellID->1787949394],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SchurDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SchurDecomposition"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized Schur decomposition of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->326792487],

Cell["These are some sample matrices.", "Text",
 CellID->1285643630],

Cell[BoxData[{
 RowBox[{
  RowBox[{"matA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "3."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matB", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "2."}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1979516943],

Cell["This returns the generalized Schur decomposition.", "Text",
 CellID->924601677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"matQ", ",", "matS", ",", "matZ", ",", "matT"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", " ", 
   RowBox[{"{", 
    RowBox[{"matA", ",", "matB"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->588715647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5237579079985649`"}], ",", 
       RowBox[{"-", "0.8518671573719502`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8518671573719502`"}], ",", "0.5237579079985649`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.999355395449287`", ",", "3.5273435758125915`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1.250201471389443`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.10595139565864756`"}], ",", 
       RowBox[{"-", "0.9943713098023217`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9943713098023217`"}], ",", "0.10595139565864756`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.7076954271796847`", ",", "4.38845022132566`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.8465887816666158`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{341, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1086717400]
}, Open  ]],

Cell["\<\
This demonstrates the results are consistent with the definition of the \
decomposition.\
\>", "Text",
 CellID->110924065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matQ", ".", "matS", ".", 
   RowBox[{"Transpose", "[", "matZ", "]"}]}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->284954859],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.9999999999999997`", "2.0000000000000013`"},
     {"4.000000000000001`", "3.000000000000001`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{60, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->347782403]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matQ", ".", "matT", ".", 
   RowBox[{"Transpose", "[", "matZ", "]"}]}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1875843734],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4.000000000000001`", "1.0000000000000004`"},
     {"3.0000000000000004`", "2.0000000000000004`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{60, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->98215731]
}, Open  ]],

Cell[TextData[{
 "For real input, a result involving complex numbers and an upper triangular \
result can be obtained with the option ",
 StyleBox["RealBlockForm", "MR"],
 "."
}], "Text",
 CellID->1444350021]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "Subsubsection",
 CellTags->{"t:231", "c:117"},
 CellID->35657259],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SchurDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFormula"],
 " takes two options."
}], "Text",
 CellID->143614500],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    StyleBox["Pivoting", "MR"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to carry out pivoting and scaling", "TableText"]},
   {
    StyleBox["RealBlockForm", "MR"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to return 2\[Times]2 real blocks for complex eigenvalues\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S5.27.1",
 CellID->2104765919],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["SchurDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFormula"],
 ". "
}], "Caption",
 CellTags->"S3.7.8",
 CellID->1450167249],

Cell[TextData[{
 "The option ",
 Cell[BoxData["Pivoting"], "InlineFormula"],
 " can be used to allow pivoting and scaling to improve the quality of the \
result. When it is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", pivoting and scaling may be used and a matrix ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " that represents the changes to ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is returned. With this new matrix the definition of the Schur \
decomposition can be seen as follows."
}], "Text",
 CellID->1169044140],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["U", "T"], ".", 
    SuperscriptBox["P", 
     RowBox[{"-", "1"}]], ".", "A", ".", "P", ".", "U"}], "\[LongEqual]", 
   "T"}], TraditionalForm]], "NumberedEquation",
 CellID->796974577],

Cell[TextData[{
 "The use of pivoting and scaling is now demonstrated for the following \
matrix. When ",
 Cell[BoxData["Pivoting"], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", pivoting and scaling are used if necessary, and an extra matrix (which \
here only represents scaling) is returned."
}], "Text",
 CellID->896209300],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"10", "^", "16"}], ",", "100", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"10", "^", "16"}]}], ",", "115", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{"10", "^", "16"}]}], ",", "120", ",", "3"}], "}"}]}], "}"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matT", ",", "matP"}], "}"}], "=", 
   RowBox[{"SchurDecomposition", "[", 
    RowBox[{"mat", ",", " ", 
     RowBox[{"Pivoting", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matU", "//", "MatrixForm"}], ",", 
   RowBox[{"matT", "//", "MatrixForm"}], ",", 
   RowBox[{"matP", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->139405042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.9999999999999927`"}], "1.2095988785276395`*^-7", 
        RowBox[{"-", "8.897224675685063`*^-9"}]},
       {
        RowBox[{"-", "1.1920928955077938`*^-7"}], 
        RowBox[{"-", "0.9667052278615047`"}], "0.2558925603162826`"},
       {
        RowBox[{"-", "2.2351741790771054`*^-8"}], 
        RowBox[{"-", "0.25589256031628177`"}], 
        RowBox[{"-", "0.9667052278615119`"}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.0000000000000204`*^16", "4.466086811462755`*^8", 
        RowBox[{"-", "2.1059524963578388`*^8"}]},
       {"0.`", 
        RowBox[{"-", "84.99999999999824`"}], "22.499999999999616`"},
       {"0.`", "0.`", 
        RowBox[{"-", "5.721334864206007`*^-16"}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"5.960464477539063`*^-8", "0.`", "0.`"},
       {"0.`", "1.`", "0.`"},
       {"0.`", "0.`", "8.`"}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{442, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->75882017]
}, Open  ]],

Cell["\<\
This demonstrates the transformation to an upper triangular form.\
\>", "Text",
 CellID->1891257048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "matU", "]"}], ".", 
   RowBox[{"Inverse", "[", "matP", "]"}], ".", "mat", ".", "matP", ".", 
   "matU"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1451746489],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.0000000000000204`*^16", "4.4660868114627594`*^8", 
      RowBox[{"-", "2.105952496357839`*^8"}]},
     {"2.756707402004523`*^-7", 
      RowBox[{"-", "84.99999999999827`"}], "22.499999999999613`"},
     {"8.28003976494121`*^-9", "3.3198907078350875`*^-15", 
      RowBox[{"-", "9.553960348616541`*^-16"}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{313, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->1941527056]
}, Open  ]],

Cell[TextData[{
 "The diagonal elements of ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " are the eigenvalues of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->231214027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "mat", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1216234366],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0000000000000204`*^16", ",", 
   RowBox[{"-", "84.99999999999824`"}], ",", 
   RowBox[{"-", "5.721334864206007`*^-16"}]}], "}"}]], "Output",
 ImageSize->{217, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1501637216]
}, Open  ]],

Cell[TextData[{
 "When the Schur decomposition is computed without pivoting and scaling, the \
diagonal elements of ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " are not as close to the eigenvalues of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 ". This demonstrates the utility of the ",
 Cell[BoxData["Pivoting"], "InlineFormula"],
 " option."
}], "Text",
 CellID->788869768],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matT"}], "}"}], "=", 
   RowBox[{"SchurDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"matT", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->2117637845],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.0000000000000208`*^16", 
      RowBox[{"-", "3.08020156319085`*^16"}], "1.8741286855807464`*^16"},
     {"0.`", 
      RowBox[{"-", "75.10820910541904`"}], "104.23188434584443`"},
     {"0.`", "0.`", 
      RowBox[{"-", "2.4128061961180745`"}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{261, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->892779184]
}, Open  ]],

Cell[TextData[{
 "The option ",
 StyleBox["RealBlockForm", "MR"],
 " controls the generation of the upper quasi-triangular result. If this is \
set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", a result that may have 2\[Times]2 blocks on the diagonal is generated. If \
it is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the result is upper triangular with 1\[Times]1 blocks on the diagonal \
(but which may involve complex numbers). This is demonstrated for the \
following real matrix, which has complex eigenvalues and a Schur \
decomposition with 2\[Times]2 blocks on the diagonal."
}], "Text",
 CellID->471503899],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.0000000000000004", ",", 
       RowBox[{"-", "3.302775637731996"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3027756377319948", ",", "1.0000000000000004"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->351373063],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.0000000000000004`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.0000000000000004`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.0000000000000004`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.0000000000000004`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2094524238]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 Cell[BoxData["RealBlockForm"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " generates a matrix ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " that is upper triangular; both ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 " are complex."
}], "Text",
 CellID->1116926442],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matU", ",", "matT"}], "}"}], "=", 
   RowBox[{"SchurDecomposition", "[", 
    RowBox[{"mat", ",", " ", 
     RowBox[{"RealBlockForm", "\[Rule]", "False"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"matU", "//", "MatrixForm"}], ",", 
   RowBox[{"matT", "//", "MatrixForm"}]}], "}"}]}], "Input",
 CellLabel->"In[10]:=",
 CellID->1028152267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"0.`", "\[InvisibleSpace]", "-", 
         RowBox[{"0.9570920264890528`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.14351486157551618`"}], "+", 
         RowBox[{"0.25175054585449974`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{
         RowBox[{"-", "0.28978414868843005`"}], "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "0.8314755696339732`"}], "-", 
         RowBox[{"0.47399738846409445`", " ", "\[ImaginaryI]"}]}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"1.0000000000000002`", "\[InvisibleSpace]", "+", 
         RowBox[{"1.0000000000000002`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{
         RowBox[{"-", "1.4857423591842542`"}], "+", 
         RowBox[{"2.6062558665882394`", " ", "\[ImaginaryI]"}]}]},
       {
        RowBox[{"0.`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
        RowBox[{"1.0000000000000004`", "\[InvisibleSpace]", "-", 
         RowBox[{"1.0000000000000004`", " ", "\[ImaginaryI]"}]}]}
      }], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{513, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1501727707]
}, Open  ]],

Cell[TextData[{
 "This generates the upper",
 " triangular",
 " result ",
 Cell[BoxData[
  FormBox["T", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->162268358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Conjugate", "[", 
     RowBox[{"Transpose", "[", "matU", "]"}], "]"}], ".", "mat", ".", 
    "matU"}], "//", "MatrixForm"}], "//", "Chop"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->2087544863],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"1.0000000000000002`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.0000000000000002`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "1.485742359184254`"}], "+", 
       RowBox[{"2.6062558665882394`", " ", "\[ImaginaryI]"}]}]},
     {"0", 
      RowBox[{"1.0000000000000004`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.0000000000000004`", " ", "\[ImaginaryI]"}]}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{214, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//MatrixForm=",
 CellID->1926171402]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Jordan Decomposition", "Subsection",
 CellTags->{"t:228", "c:118"},
 CellID->1994258536],

Cell[TextData[{
 "The Jordan decomposition of a square matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " involves finding the non-singular matrix ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]], "InlineMath"],
 " that can be used for a similarity transformation of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " to generate a matrix ",
 Cell[BoxData[
  FormBox["J", TraditionalForm]], "InlineMath"],
 " (known as the Jordan form) that has a particularly simple triangular \
structure."
}], "Text",
 CellID->1725935823],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["X", 
     RowBox[{"-", "1"}]], ".", "A", ".", "X"}], "\[LongEqual]", "J"}], 
  TraditionalForm]], "NumberedEquation",
 CellID->1741757132],

Cell["\<\
The Jordan decomposition always exists, but it is hard to compute with \
floating point arithmetic. However, computation with exact arithmetic avoids \
these problems.\
\>", "Text",
 CellID->1362525267],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JordanDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JordanDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the Jordan decomposition of a matrix", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1344034508],

Cell["This demonstrates the Jordan form for a sample matrix.", "Text",
 CellID->1954976810],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4", ",", "0", ",", "0", ",", "4", ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "1", ",", "0", ",", "5", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "2", ",", "0", ",", "2", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", "2", ",", 
       RowBox[{"-", "12"}], ",", 
       RowBox[{"-", "7"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "8"}], ",", 
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "5"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matX", ",", "matJ"}], "}"}], "=", 
   RowBox[{"JordanDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matX", ".", "matJ", ".", 
   RowBox[{"Inverse", "[", "matX", "]"}]}], "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->795446570],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"5", "4", "0", "0", "4", "3"},
     {"2", "3", "1", "0", "5", "1"},
     {"0", 
      RowBox[{"-", "1"}], "2", "0", "2", "0"},
     {
      RowBox[{"-", "8"}], 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "1"}], "2", 
      RowBox[{"-", "12"}], 
      RowBox[{"-", "7"}]},
     {"0", "0", "0", "0", 
      RowBox[{"-", "1"}], "0"},
     {
      RowBox[{"-", "8"}], 
      RowBox[{"-", "8"}], 
      RowBox[{"-", "1"}], "0", 
      RowBox[{"-", "9"}], 
      RowBox[{"-", "5"}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{153, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->984799415]
}, Open  ]],

Cell["\<\
The Jordan form has the eigenvalues of the matrix along its diagonal. Any \
defective eigenvalues are grouped into blocks by 1s just above the diagonal. \
The Jordan form of the above matrix is shown below.\
\>", "Text",
 CellID->867300476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matJ", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1747587943],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "0", "0", "0", "0", "0"},
     {"0", 
      RowBox[{"-", "1"}], "0", "0", "0", "0"},
     {"0", "0", "2", "0", "0", "0"},
     {"0", "0", "0", "2", "1", "0"},
     {"0", "0", "0", "0", "2", "1"},
     {"0", "0", "0", "0", "0", "2"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{122, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->576717982]
}, Open  ]],

Cell["\<\
The Jordan form shows that there are two eigenvalues: -1 and 2. The \
eigenvalue -1 is repeated twice and has a complete set of eigenvectors. The \
eigenvalue 2 is repeated four times. It appears once with its own \
eigenvector, and then three times with only one full eigenvector. This is \
demonstrated when the eigensystem for the matrix is computed.\
\>", "Text",
 CellID->1305424563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", "mat", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1577692589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", "0", ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "2", ",", "0", ",", "2"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{537, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1298753814]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions of Matrices", "Section",
 CellTags->{"t:229", "c:119"},
 CellID->1131563790],

Cell[TextData[{
 "The computation of functions of matrices is a general problem with \
applications in many areas such as control theory. The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "A", ")"}], TraditionalForm]], "InlineMath"],
 " of a square matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is not the same as the application of the function to each element in the \
matrix. Clearly element-wise application would not maintain properties \
consistent with the application of the function to a scale. For example, each \
element of the following matrix is raised to the zero power."
}], "Text",
 CellID->77440698],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.", ",", "5."}], "}"}]}], "}"}]}], ";"}], "\n", 
 SuperscriptBox["mat", "0"]}], "Input",
 CellLabel->"In[1]:=",
 CellID->170721204],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->273123236]
}, Open  ]],

Cell[TextData[{
 "However, a much better result would be the identity matrix. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a function for raising a matrix to a power, and when a matrix is \
raised to the zero power the result is the identity matrix."
}], "Text",
 CellID->1209673813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixExp", "[", 
  RowBox[{"mat", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->760088942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1582115838]
}, Open  ]],

Cell["\<\
There are a number of ways to define functions of matrices; one useful way is \
to consider a series expansion. For the exponential function this works as \
follows.\
\>", "Text",
 CellID->478372112],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "A"], "\[LongEqual]", 
   RowBox[{"I", "+", "A", "+", 
    FractionBox[
     SuperscriptBox["A", "2"], 
     RowBox[{"2", "!"}]], "+", 
    FractionBox[
     SuperscriptBox["A", "3"], 
     RowBox[{"3", "!"}]], "+", "\[Ellipsis]"}]}], 
  TraditionalForm]], "NumberedEquation",
 CellID->1968795663],

Cell[TextData[{
 "One way to compute this series involves diagonalizing ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 ", so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "\[LongEqual]", 
    RowBox[{"P", ".", "D", ".", 
     SuperscriptBox["P", 
      RowBox[{"-", "1"}]]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["A", "k"], "\[LongEqual]", 
    RowBox[{"P", ".", 
     SuperscriptBox["D", "k"], ".", 
     SuperscriptBox["P", 
      RowBox[{"-", "1"}]]}]}], TraditionalForm]], "InlineMath"],
 ". Therefore, the exponential of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " can be computed as follows."
}], "Text",
 CellID->1120675065],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "A"], "\[LongEqual]", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     SuperscriptBox["A", "k"], 
     RowBox[{"k", "!"}]]}], "\[LongEqual]", 
   RowBox[{"P", ".", 
    RowBox[{"(", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "0"}], "\[Infinity]"], 
      FractionBox[
       SuperscriptBox["D", "k"], 
       RowBox[{"k", "!"}]]}], ")"}], ".", 
    SuperscriptBox["P", 
     RowBox[{"-", "1"}]]}], "\[LongEqual]", 
   RowBox[{"P", ".", 
    RowBox[{"diag", "(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       SubscriptBox["\[Lambda]", "1"]], ",", "\[Ellipsis]", ",", 
      SuperscriptBox["\[ExponentialE]", 
       SubscriptBox["\[Lambda]", "n"]]}], ")"}], ".", 
    SuperscriptBox["P", 
     RowBox[{"-", "1"}]]}]}], TraditionalForm]], "NumberedEquation",
 CellID->1754233265],

Cell[TextData[{
 "This technique can be generalized to functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "\[Lambda]", ")"}], TraditionalForm]], "InlineMath"],
 " of the eigenvalues of ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 ". Note that while this is one way to define functions of matrices, it does \
not provide a good way to compute them."
}], "Text",
 CellID->595495192],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not have a function for computing general functions of matrices, but \
it has some specific functions."
}], "Text",
 CellID->1213896924],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MatrixPower",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixPower"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " matrix power "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixExp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixExp"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["matrix exponential ", "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["1", "TI"]], 
     StyleBox[".", "MR"], 
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["2", "TI"]], "   "}], Cell[
    "matrix multiplication ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Inverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inverse"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["matrix inverse ", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.7",
 CellID->870955168],

Cell["Here is a sample matrix.", "Text",
 CellID->894970624],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.", ",", "1."}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->795813980],

Cell["This raises the matrix to the fourth power.", "Text",
 CellID->717408344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPower", "[", 
  RowBox[{"mat", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1508843350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"161.`", ",", "88.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"220.`", ",", "161.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1643279674]
}, Open  ]],

Cell["\<\
The result is equivalent to squaring the square of the matrix.\
\>", "Text",
 CellID->1961780498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"matSq", "=", 
   RowBox[{"mat", ".", "mat"}]}], ";", 
  RowBox[{"matSq", ".", "matSq"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1328397495],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"161.`", ",", "88.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"220.`", ",", "161.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1136704253]
}, Open  ]],

Cell["This computes the exponential of the matrix.", "Text",
 CellID->573856459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixExp", "[", "mat", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->456447736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"32.16634241136035`", ",", "20.271009131525236`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50.677522828813096`", ",", "32.16634241136035`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->705511868]
}, Open  ]],

Cell["\<\
It is equivalent to the computation that uses the eigensystem of the matrix. \
(It should be noted that this is not an efficient way to compute a function \
of a matrix, the example here is only for exposition.)\
\>", "Text",
 CellID->1280750389],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eigs", ",", "vecs"}], "}"}], "=", 
   RowBox[{"Eigensystem", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vecs", "=", 
   RowBox[{"Transpose", "[", "vecs", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vecsInv", "=", 
   RowBox[{"Inverse", "[", "vecs", "]"}]}], ";"}], "\n", 
 RowBox[{"vecs", ".", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"Exp", "[", "eigs", "]"}], "]"}], ".", "vecsInv"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->1343194042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"32.16634241136035`", ",", "20.271009131525236`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50.67752282881309`", ",", "32.16634241136035`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->714166630]
}, Open  ]],

Cell[TextData[{
 "A technique for computing parametrized functions of matrices by solving \
differential equations is given under ",
 ButtonBox["Examples: Matrix Functions with NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraExamples#747736829"],
 "."
}], "Text",
 CellID->712447327],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->35257418],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "TutorialMoreAbout",
 CellID->4791866],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->6143117],

Cell[TextData[{
 ButtonBox["Linear Algebra in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->315063104],

Cell[TextData[ButtonBox["Matrix and Tensor Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"]], \
"RelatedTutorials",
 CellID->3571032],

Cell[TextData[ButtonBox["Working with Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays"]], "RelatedTutorials",\

 CellID->560755906],

Cell[TextData[ButtonBox["Matrix Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations"]], "RelatedTutorials",
 CellID->335456077],

Cell[TextData[ButtonBox["Matrix Types",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes"]], "RelatedTutorials",\

 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrix Computations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 39.1945494}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This tutorial reviews the functions that Mathematica provides for \
carrying out matrix computations. Further information on these functions can \
be found in standard mathematical texts by such authors as Golub and van Loan \
or Meyer. The operations described in this tutorial are unique to matrices; \
an exception is the computation of norms, which also extends to scalars and \
vectors. This section gives a review of some basic concepts and operations \
that will be used throughout the tutorial to discuss matrix operations. The \
norm of a mathematical object is a measurement of the length, size, or extent \
of the object. In Mathematica norms are available for scalars, vectors, and \
matrices.", "synonyms" -> {}, "title" -> "Matrix Computations", "type" -> 
    "Tutorial", "uri" -> "tutorial/LinearAlgebraMatrixComputations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:45"->{
  Cell[5895, 130, 110, 3, 70, "Title",
   CellTags->{"t:45", "c:69"},
   CellID->1927833614]},
 "c:69"->{
  Cell[5895, 130, 110, 3, 70, "Title",
   CellTags->{"t:45", "c:69"},
   CellID->1927833614]},
 "c:70"->{
  Cell[6732, 157, 75, 2, 70, "Section",
   CellTags->"c:70",
   CellID->1060011943]},
 "t:49"->{
  Cell[7017, 169, 76, 2, 70, "Subsection",
   CellTags->{"t:49", "c:71"},
   CellID->832278785]},
 "c:71"->{
  Cell[7017, 169, 76, 2, 70, "Subsection",
   CellTags->{"t:49", "c:71"},
   CellID->832278785]},
 "S1.8.3"->{
  Cell[7363, 182, 1376, 47, 70, "DefinitionBox",
   CellTags->"S1.8.3",
   CellID->1068119295],
  Cell[8742, 231, 151, 7, 70, "Caption",
   CellTags->"S1.8.3",
   CellID->1065185792],
  Cell[31763, 1153, 387, 13, 70, "DefinitionBox",
   CellTags->"S1.8.3",
   CellID->1483725788],
  Cell[39102, 1400, 405, 13, 70, "DefinitionBox",
   CellTags->"S1.8.3",
   CellID->1622898420],
  Cell[45584, 1630, 384, 13, 70, "DefinitionBox",
   CellTags->"S1.8.3",
   CellID->1413339873],
  Cell[51127, 1835, 402, 13, 70, "DefinitionBox",
   CellTags->"S1.8.3",
   CellID->1042644323],
  Cell[58034, 2078, 1117, 39, 70, "DefinitionBox",
   CellTags->"S1.8.3",
   CellID->323088377]},
 "t:146"->{
  Cell[9693, 278, 87, 2, 70, "Subsubsection",
   CellTags->{"t:146", "c:72"},
   CellID->654042966]},
 "c:72"->{
  Cell[9693, 278, 87, 2, 70, "Subsubsection",
   CellTags->{"t:146", "c:72"},
   CellID->654042966]},
 "t:147"->{
  Cell[18354, 600, 88, 2, 70, "Subsubsection",
   CellTags->{"t:147", "c:73"},
   CellID->1973408751]},
 "c:73"->{
  Cell[18354, 600, 88, 2, 70, "Subsubsection",
   CellTags->{"t:147", "c:73"},
   CellID->1973408751]},
 "t:225"->{
  Cell[27708, 989, 81, 2, 70, "Subsection",
   CellTags->{"t:225", "c:74"},
   CellID->478394165]},
 "c:74"->{
  Cell[27708, 989, 81, 2, 70, "Subsection",
   CellTags->{"t:225", "c:74"},
   CellID->478394165]},
 "S3.7.8"->{
  Cell[28006, 1000, 502, 17, 70, "DefinitionBox",
   CellTags->"S3.7.8",
   CellID->697281315],
  Cell[72000, 2613, 1365, 37, 70, "DefinitionBox",
   CellTags->"S3.7.8",
   CellID->1500878555],
  Cell[73368, 2652, 131, 4, 70, "Caption",
   CellTags->"S3.7.8",
   CellID->922956223],
  Cell[74150, 2680, 939, 32, 70, "DefinitionBox",
   CellTags->"S3.7.8",
   CellID->271422387],
  Cell[75092, 2714, 239, 9, 70, "Caption",
   CellTags->"S3.7.8",
   CellID->540792081],
  Cell[86409, 3159, 126, 6, 70, "Caption",
   CellTags->"S3.7.8",
   CellID->304119476],
  Cell[194621, 7129, 220, 9, 70, "Caption",
   CellTags->"S3.7.8",
   CellID->1225672779],
  Cell[354904, 12940, 234, 9, 70, "Caption",
   CellTags->"S3.7.8",
   CellID->1450167249]},
 "t:50"->{
  Cell[31534, 1143, 76, 2, 70, "Subsection",
   CellTags->{"t:50", "c:75"},
   CellID->2035970465]},
 "c:75"->{
  Cell[31534, 1143, 76, 2, 70, "Subsection",
   CellTags->{"t:50", "c:75"},
   CellID->2035970465]},
 "t:226"->{
  Cell[36722, 1340, 97, 2, 70, "Subsection",
   CellTags->{"t:226", "c:76"},
   CellID->2032866165]},
 "c:76"->{
  Cell[36722, 1340, 97, 2, 70, "Subsection",
   CellTags->{"t:226", "c:76"},
   CellID->2032866165]},
 "t:56"->{
  Cell[44760, 1593, 79, 2, 70, "Subsection",
   CellTags->{"t:56", "c:77"},
   CellID->1798152178]},
 "c:77"->{
  Cell[44760, 1593, 79, 2, 70, "Subsection",
   CellTags->{"t:56", "c:77"},
   CellID->1798152178]},
 "t:227"->{
  Cell[50499, 1814, 86, 2, 70, "Subsection",
   CellTags->{"t:227", "c:78"},
   CellID->1120972426]},
 "c:78"->{
  Cell[50499, 1814, 86, 2, 70, "Subsection",
   CellTags->{"t:227", "c:78"},
   CellID->1120972426]},
 "t:55"->{
  Cell[56598, 2021, 83, 2, 70, "Subsection",
   CellTags->{"t:55", "c:79"},
   CellID->1665558708]},
 "c:79"->{
  Cell[56598, 2021, 83, 2, 70, "Subsection",
   CellTags->{"t:55", "c:79"},
   CellID->1665558708]},
 "t:207"->{
  Cell[61236, 2211, 79, 2, 70, "Subsection",
   CellTags->{"t:207", "c:80"},
   CellID->1595477023]},
 "c:80"->{
  Cell[61236, 2211, 79, 2, 70, "Subsection",
   CellTags->{"t:207", "c:80"},
   CellID->1595477023]},
 "S3.7.7"->{
  Cell[61318, 2215, 439, 15, 70, "Text",
   CellTags->{"S3.7.7", "7.4"},
   CellID->1701509119],
  Cell[378779, 13770, 1135, 39, 70, "DefinitionBox",
   CellTags->"S3.7.7",
   CellID->870955168]},
 "7.4"->{
  Cell[61318, 2215, 439, 15, 70, "Text",
   CellTags->{"S3.7.7", "7.4"},
   CellID->1701509119]},
 "t:46"->{
  Cell[69130, 2509, 89, 2, 70, "Section",
   CellTags->{"t:46", "c:81"},
   CellID->81663253]},
 "c:81"->{
  Cell[69130, 2509, 89, 2, 70, "Section",
   CellTags->{"t:46", "c:81"},
   CellID->81663253]},
 "S5.27.1"->{
  Cell[85317, 3123, 1089, 34, 70, "DefinitionBox3Col",
   CellTags->"S5.27.1",
   CellID->1306370972],
  Cell[130350, 4840, 1400, 42, 70, "DefinitionBox3Col",
   CellTags->"S5.27.1",
   CellID->1631053020],
  Cell[193222, 7083, 1396, 44, 70, "DefinitionBox3Col",
   CellTags->"S5.27.1",
   CellID->616961785],
  Cell[235134, 8646, 1541, 46, 70, "DefinitionBox3Col",
   CellTags->"S5.27.1",
   CellID->649341404],
  Cell[329557, 12005, 622, 18, 70, "DefinitionBox3Col",
   CellTags->"S5.27.1",
   CellID->1495970624],
  Cell[354148, 12916, 753, 22, 70, "DefinitionBox3Col",
   CellTags->"S5.27.1",
   CellID->2104765919]},
 "t:86"->{
  Cell[87818, 3209, 88, 2, 70, "Subsection",
   CellTags->{"t:86", "c:82"},
   CellID->438728183],
  Cell[92877, 3402, 92, 2, 70, "Subsection",
   CellTags->{"t:86", "c:83"},
   CellID->534320490]},
 "c:82"->{
  Cell[87818, 3209, 88, 2, 70, "Subsection",
   CellTags->{"t:86", "c:82"},
   CellID->438728183]},
 "c:83"->{
  Cell[92877, 3402, 92, 2, 70, "Subsection",
   CellTags->{"t:86", "c:83"},
   CellID->534320490]},
 "c:84"->{
  Cell[97854, 3617, 97, 2, 70, "Subsection",
   CellTags->"c:84",
   CellID->1668277829]},
 "S5.48.1"->{
  Cell[99793, 3681, 808, 24, 70, "DefinitionBox",
   CellTags->"S5.48.1",
   CellID->412963780]},
 "t:87"->{
  Cell[106709, 3935, 99, 2, 70, "Subsection",
   CellTags->{"t:87", "c:85"},
   CellID->1644685080]},
 "c:85"->{
  Cell[106709, 3935, 99, 2, 70, "Subsection",
   CellTags->{"t:87", "c:85"},
   CellID->1644685080]},
 "t:148"->{
  Cell[113793, 4222, 88, 2, 70, "Subsubsection",
   CellTags->{"t:148", "c:86"},
   CellID->644279649]},
 "c:86"->{
  Cell[113793, 4222, 88, 2, 70, "Subsubsection",
   CellTags->{"t:148", "c:86"},
   CellID->644279649]},
 "t:47"->{
  Cell[116729, 4343, 96, 2, 70, "Subsection",
   CellTags->{"t:47", "c:87"},
   CellID->1974718471]},
 "c:87"->{
  Cell[116729, 4343, 96, 2, 70, "Subsection",
   CellTags->{"t:47", "c:87"},
   CellID->1974718471]},
 "t:89"->{
  Cell[124509, 4642, 78, 2, 70, "Subsection",
   CellTags->{"t:89", "c:88"},
   CellID->834729047]},
 "c:88"->{
  Cell[124509, 4642, 78, 2, 70, "Subsection",
   CellTags->{"t:89", "c:88"},
   CellID->834729047]},
 "t:145"->{
  Cell[126551, 4707, 82, 2, 70, "Subsubsection",
   CellTags->{"t:145", "c:89"},
   CellID->1131477137]},
 "c:89"->{
  Cell[126551, 4707, 82, 2, 70, "Subsubsection",
   CellTags->{"t:145", "c:89"},
   CellID->1131477137]},
 "t:90"->{
  Cell[127417, 4734, 87, 2, 70, "Subsubsection",
   CellTags->{"t:90", "c:90"},
   CellID->1415618539]},
 "c:90"->{
  Cell[127417, 4734, 87, 2, 70, "Subsubsection",
   CellTags->{"t:90", "c:90"},
   CellID->1415618539]},
 "t:91"->{
  Cell[129748, 4824, 81, 2, 70, "Subsubsection",
   CellTags->{"t:91", "c:91"},
   CellID->1643755774]},
 "c:91"->{
  Cell[129748, 4824, 81, 2, 70, "Subsubsection",
   CellTags->{"t:91", "c:91"},
   CellID->1643755774]},
 "S3.7.9"->{
  Cell[131753, 4884, 94, 2, 70, "Caption",
   CellTags->"S3.7.9",
   CellID->479353185],
  Cell[179393, 6544, 1476, 51, 70, "DefinitionBox",
   CellTags->"S3.7.9",
   CellID->583832294],
  Cell[180872, 6597, 90, 2, 70, "Caption",
   CellTags->"S3.7.9",
   CellID->616582115],
  Cell[189942, 6956, 1662, 59, 70, "DefinitionBox",
   CellTags->"S3.7.9",
   CellID->1978982693],
  Cell[223798, 8218, 1401, 50, 70, "DefinitionBox",
   CellTags->"S3.7.9",
   CellID->2070735056],
  Cell[225202, 8270, 102, 2, 70, "Caption",
   CellTags->"S3.7.9",
   CellID->724102910],
  Cell[236678, 8694, 96, 2, 70, "Caption",
   CellTags->"S3.7.9",
   CellID->2116566621],
  Cell[311911, 11332, 764, 25, 70, "DefinitionBox",
   CellTags->"S3.7.9",
   CellID->1948818077],
  Cell[319480, 11609, 1782, 59, 70, "DefinitionBox",
   CellTags->"S3.7.9",
   CellID->1682123204],
  Cell[323939, 11777, 1002, 32, 70, "DefinitionBox",
   CellTags->"S3.7.9",
   CellID->1333779588],
  Cell[349449, 12736, 529, 17, 70, "DefinitionBox",
   CellTags->"S3.7.9",
   CellID->326792487]},
 "t:92"->{
  Cell[145620, 5351, 83, 2, 70, "Subsubsection",
   CellTags->{"t:92", "c:92"},
   CellID->1549309818]},
 "c:92"->{
  Cell[145620, 5351, 83, 2, 70, "Subsubsection",
   CellTags->{"t:92", "c:92"},
   CellID->1549309818]},
 "t:93"->{
  Cell[150775, 5551, 91, 2, 70, "Subsubsection",
   CellTags->{"t:93", "c:93"},
   CellID->1813753518]},
 "c:93"->{
  Cell[150775, 5551, 91, 2, 70, "Subsubsection",
   CellTags->{"t:93", "c:93"},
   CellID->1813753518]},
 "t:103"->{
  Cell[156819, 5760, 92, 2, 70, "Section",
   CellTags->{"t:103", "c:94"},
   CellID->563250646]},
 "c:94"->{
  Cell[156819, 5760, 92, 2, 70, "Section",
   CellTags->{"t:103", "c:94"},
   CellID->563250646]},
 "t:208"->{
  Cell[164941, 6043, 85, 2, 70, "Subsection",
   CellTags->{"t:208", "c:95"},
   CellID->1737956870]},
 "c:95"->{
  Cell[164941, 6043, 85, 2, 70, "Subsection",
   CellTags->{"t:208", "c:95"},
   CellID->1737956870]},
 "t:48"->{
  Cell[176900, 6460, 93, 2, 70, "Section",
   CellTags->{"t:48", "c:96"},
   CellID->1705931980]},
 "c:96"->{
  Cell[176900, 6460, 93, 2, 70, "Section",
   CellTags->{"t:48", "c:96"},
   CellID->1705931980]},
 "t:209"->{
  Cell[196307, 7187, 94, 2, 70, "Subsection",
   CellTags->{"t:209", "c:97"},
   CellID->723589929]},
 "c:97"->{
  Cell[196307, 7187, 94, 2, 70, "Subsection",
   CellTags->{"t:209", "c:97"},
   CellID->723589929]},
 "t:200"->{
  Cell[210883, 7747, 95, 2, 70, "Subsection",
   CellTags->{"t:200", "c:98"},
   CellID->1770480598]},
 "c:98"->{
  Cell[210883, 7747, 95, 2, 70, "Subsection",
   CellTags->{"t:200", "c:98"},
   CellID->1770480598]},
 "t:153"->{
  Cell[216100, 7926, 100, 2, 70, "Subsection",
   CellTags->{"t:153", "c:99"},
   CellID->1937669982]},
 "c:99"->{
  Cell[216100, 7926, 100, 2, 70, "Subsection",
   CellTags->{"t:153", "c:99"},
   CellID->1937669982]},
 "t:154"->{
  Cell[222657, 8176, 96, 2, 70, "Subsection",
   CellTags->{"t:154", "c:100"},
   CellID->524353415]},
 "c:100"->{
  Cell[222657, 8176, 96, 2, 70, "Subsection",
   CellTags->{"t:154", "c:100"},
   CellID->524353415]},
 "t:155"->{
  Cell[228606, 8417, 80, 2, 70, "Subsection",
   CellTags->{"t:155", "c:101"},
   CellID->905279933]},
 "c:101"->{
  Cell[228606, 8417, 80, 2, 70, "Subsection",
   CellTags->{"t:155", "c:101"},
   CellID->905279933]},
 "t:157"->{
  Cell[230625, 8481, 83, 2, 70, "Subsubsection",
   CellTags->{"t:157", "c:102"},
   CellID->1499161194]},
 "c:102"->{
  Cell[230625, 8481, 83, 2, 70, "Subsubsection",
   CellTags->{"t:157", "c:102"},
   CellID->1499161194]},
 "t:158"->{
  Cell[233129, 8576, 84, 2, 70, "Subsubsection",
   CellTags->{"t:158", "c:103"},
   CellID->1833787992]},
 "c:103"->{
  Cell[233129, 8576, 84, 2, 70, "Subsubsection",
   CellTags->{"t:158", "c:103"},
   CellID->1833787992]},
 "t:159"->{
  Cell[245817, 9028, 92, 2, 70, "Subsubsection",
   CellTags->{"t:159", "c:104"},
   CellID->344887306]},
 "c:104"->{
  Cell[245817, 9028, 92, 2, 70, "Subsubsection",
   CellTags->{"t:159", "c:104"},
   CellID->344887306]},
 "t:51"->{
  Cell[246105, 9043, 90, 2, 70, "Section",
   CellTags->{"t:51", "c:105"},
   CellID->837293883]},
 "c:105"->{
  Cell[246105, 9043, 90, 2, 70, "Section",
   CellTags->{"t:51", "c:105"},
   CellID->837293883]},
 "t:53"->{
  Cell[246550, 9057, 88, 2, 70, "Subsection",
   CellTags->{"t:53", "c:106"},
   CellID->849593972]},
 "c:106"->{
  Cell[246550, 9057, 88, 2, 70, "Subsection",
   CellTags->{"t:53", "c:106"},
   CellID->849593972]},
 "S3.7.10"->{
  Cell[250608, 9198, 324, 10, 70, "DefinitionBox",
   CellTags->"S3.7.10",
   CellID->1432464734],
  Cell[262319, 9610, 321, 10, 70, "DefinitionBox",
   CellTags->"S3.7.10",
   CellID->1667233752],
  Cell[289441, 10502, 202, 7, 70, "DefinitionBox",
   CellTags->"S3.7.10",
   CellID->45083515],
  Cell[292046, 10605, 314, 10, 70, "DefinitionBox",
   CellTags->"S3.7.10",
   CellID->1942452609],
  Cell[334158, 12167, 322, 10, 70, "DefinitionBox",
   CellTags->"S3.7.10",
   CellID->511775762],
  Cell[368421, 13406, 326, 10, 70, "DefinitionBox",
   CellTags->"S3.7.10",
   CellID->1344034508]},
 "S0.1574"->{
  Cell[250935, 9210, 542, 12, 70, "Text",
   CellTags->{"S0.1574", "LUDecomposition"},
   CellID->2143101468]},
 "LUDecomposition"->{
  Cell[250935, 9210, 542, 12, 70, "Text",
   CellTags->{"S0.1574", "LUDecomposition"},
   CellID->2143101468]},
 "t:194"->{
  Cell[260313, 9547, 96, 2, 70, "Subsection",
   CellTags->{"t:194", "c:107"},
   CellID->1567526616]},
 "c:107"->{
  Cell[260313, 9547, 96, 2, 70, "Subsection",
   CellTags->{"t:194", "c:107"},
   CellID->1567526616]},
 "t:210"->{
  Cell[268994, 9857, 106, 2, 70, "Subsubsection",
   CellTags->{"t:210", "c:108"},
   CellID->966681026]},
 "c:108"->{
  Cell[268994, 9857, 106, 2, 70, "Subsubsection",
   CellTags->{"t:210", "c:108"},
   CellID->966681026]},
 "t:195"->{
  Cell[273999, 10060, 90, 2, 70, "Subsection",
   CellTags->{"t:195", "c:109"},
   CellID->464885506]},
 "c:109"->{
  Cell[273999, 10060, 90, 2, 70, "Subsection",
   CellTags->{"t:195", "c:109"},
   CellID->464885506]},
 "S5.49.1"->{
  Cell[275170, 10107, 599, 20, 70, "DefinitionBox",
   CellTags->"S5.49.1",
   CellID->1409177642]},
 "t:196"->{
  Cell[290810, 10558, 90, 2, 70, "Subsection",
   CellTags->{"t:196", "c:110"},
   CellID->1662286926]},
 "c:110"->{
  Cell[290810, 10558, 90, 2, 70, "Subsection",
   CellTags->{"t:196", "c:110"},
   CellID->1662286926]},
 "t:199"->{
  Cell[307247, 11160, 104, 2, 70, "Subsubsection",
   CellTags->{"t:199", "c:111"},
   CellID->841776984]},
 "c:111"->{
  Cell[307247, 11160, 104, 2, 70, "Subsubsection",
   CellTags->{"t:199", "c:111"},
   CellID->841776984]},
 "t:197"->{
  Cell[310426, 11280, 101, 2, 70, "Subsection",
   CellTags->{"t:197", "c:112"},
   CellID->315998326]},
 "c:112"->{
  Cell[310426, 11280, 101, 2, 70, "Subsection",
   CellTags->{"t:197", "c:112"},
   CellID->315998326]},
 "t:211"->{
  Cell[322072, 11704, 103, 2, 70, "Subsubsection",
   CellTags->{"t:211", "c:113"},
   CellID->915032469]},
 "c:113"->{
  Cell[322072, 11704, 103, 2, 70, "Subsubsection",
   CellTags->{"t:211", "c:113"},
   CellID->915032469]},
 "t:212"->{
  Cell[328946, 11981, 84, 2, 70, "Subsubsection",
   CellTags->{"t:212", "c:114"},
   CellID->2106677120]},
 "c:114"->{
  Cell[328946, 11981, 84, 2, 70, "Subsubsection",
   CellTags->{"t:212", "c:114"},
   CellID->2106677120]},
 "t:181"->{
  Cell[332585, 12118, 92, 2, 70, "Subsection",
   CellTags->{"t:181", "c:115"},
   CellID->225662794]},
 "c:115"->{
  Cell[332585, 12118, 92, 2, 70, "Subsection",
   CellTags->{"t:181", "c:115"},
   CellID->225662794]},
 "c:116"->{
  Cell[348252, 12689, 96, 2, 70, "Subsubsection",
   CellTags->"c:116",
   CellID->811895271]},
 "t:231"->{
  Cell[353851, 12903, 82, 2, 70, "Subsubsection",
   CellTags->{"t:231", "c:117"},
   CellID->35657259]},
 "c:117"->{
  Cell[353851, 12903, 82, 2, 70, "Subsubsection",
   CellTags->{"t:231", "c:117"},
   CellID->35657259]},
 "t:228"->{
  Cell[367327, 13368, 94, 2, 70, "Subsection",
   CellTags->{"t:228", "c:118"},
   CellID->1994258536]},
 "c:118"->{
  Cell[367327, 13368, 94, 2, 70, "Subsection",
   CellTags->{"t:228", "c:118"},
   CellID->1994258536]},
 "t:229"->{
  Cell[373666, 13590, 92, 2, 70, "Section",
   CellTags->{"t:229", "c:119"},
   CellID->1131563790]},
 "c:119"->{
  Cell[373666, 13590, 92, 2, 70, "Section",
   CellTags->{"t:229", "c:119"},
   CellID->1131563790]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:45", 387097, 14059},
 {"c:69", 387203, 14063},
 {"c:70", 387309, 14067},
 {"t:49", 387406, 14071},
 {"c:71", 387515, 14075},
 {"S1.8.3", 387626, 14079},
 {"t:146", 388308, 14101},
 {"c:72", 388421, 14105},
 {"t:147", 388535, 14109},
 {"c:73", 388650, 14113},
 {"t:225", 388766, 14117},
 {"c:74", 388877, 14121},
 {"S3.7.8", 388990, 14125},
 {"t:50", 389742, 14150},
 {"c:75", 389854, 14154},
 {"t:226", 389967, 14158},
 {"c:76", 390080, 14162},
 {"t:56", 390193, 14166},
 {"c:77", 390305, 14170},
 {"t:227", 390418, 14174},
 {"c:78", 390531, 14178},
 {"t:55", 390644, 14182},
 {"c:79", 390756, 14186},
 {"t:207", 390869, 14190},
 {"c:80", 390982, 14194},
 {"S3.7.7", 391097, 14198},
 {"7.4", 391304, 14205},
 {"t:46", 391413, 14209},
 {"c:81", 391520, 14213},
 {"S5.27.1", 391630, 14217},
 {"t:86", 392263, 14236},
 {"c:82", 392473, 14243},
 {"c:83", 392584, 14247},
 {"c:84", 392695, 14251},
 {"S5.48.1", 392800, 14255},
 {"t:87", 392909, 14259},
 {"c:85", 393022, 14263},
 {"t:148", 393136, 14267},
 {"c:86", 393252, 14271},
 {"t:47", 393368, 14275},
 {"c:87", 393481, 14279},
 {"t:89", 393594, 14283},
 {"c:88", 393706, 14287},
 {"t:145", 393819, 14291},
 {"c:89", 393936, 14295},
 {"t:90", 394053, 14299},
 {"c:90", 394169, 14303},
 {"t:91", 394285, 14307},
 {"c:91", 394401, 14311},
 {"S3.7.9", 394519, 14315},
 {"t:92", 395582, 14349},
 {"c:92", 395698, 14353},
 {"t:93", 395814, 14357},
 {"c:93", 395930, 14361},
 {"t:103", 396047, 14365},
 {"c:94", 396157, 14369},
 {"t:208", 396268, 14373},
 {"c:95", 396382, 14377},
 {"t:48", 396496, 14381},
 {"c:96", 396606, 14385},
 {"t:209", 396717, 14389},
 {"c:97", 396830, 14393},
 {"t:200", 396944, 14397},
 {"c:98", 397058, 14401},
 {"t:153", 397173, 14405},
 {"c:99", 397288, 14409},
 {"t:154", 397404, 14413},
 {"c:100", 397519, 14417},
 {"t:155", 397634, 14421},
 {"c:101", 397749, 14425},
 {"t:157", 397864, 14429},
 {"c:102", 397983, 14433},
 {"t:158", 398102, 14437},
 {"c:103", 398221, 14441},
 {"t:159", 398340, 14445},
 {"c:104", 398458, 14449},
 {"t:51", 398575, 14453},
 {"c:105", 398686, 14457},
 {"t:53", 398796, 14461},
 {"c:106", 398910, 14465},
 {"S3.7.10", 399026, 14469},
 {"S0.1574", 399635, 14488},
 {"LUDecomposition", 399769, 14492},
 {"t:194", 399893, 14496},
 {"c:107", 400009, 14500},
 {"t:210", 400125, 14504},
 {"c:108", 400244, 14508},
 {"t:195", 400363, 14512},
 {"c:109", 400479, 14516},
 {"S5.49.1", 400597, 14520},
 {"t:196", 400710, 14524},
 {"c:110", 400827, 14528},
 {"t:199", 400944, 14532},
 {"c:111", 401064, 14536},
 {"t:197", 401184, 14540},
 {"c:112", 401301, 14544},
 {"t:211", 401418, 14548},
 {"c:113", 401538, 14552},
 {"t:212", 401658, 14556},
 {"c:114", 401778, 14560},
 {"t:181", 401898, 14564},
 {"c:115", 402014, 14568},
 {"c:116", 402130, 14572},
 {"t:231", 402238, 14576},
 {"c:117", 402356, 14580},
 {"t:228", 402474, 14584},
 {"c:118", 402591, 14588},
 {"t:229", 402708, 14592},
 {"c:119", 402822, 14596}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5270, 103, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5895, 130, 110, 3, 70, "Title",
 CellTags->{"t:45", "c:69"},
 CellID->1927833614],
Cell[6008, 135, 699, 18, 70, "Text",
 CellID->2013768209],
Cell[CellGroupData[{
Cell[6732, 157, 75, 2, 70, "Section",
 CellTags->"c:70",
 CellID->1060011943],
Cell[6810, 161, 182, 4, 70, "Text",
 CellID->96390489],
Cell[CellGroupData[{
Cell[7017, 169, 76, 2, 70, "Subsection",
 CellTags->{"t:49", "c:71"},
 CellID->832278785],
Cell[7096, 173, 264, 7, 70, "Text",
 CellID->1548546584],
Cell[7363, 182, 1376, 47, 70, "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1068119295],
Cell[8742, 231, 151, 7, 70, "Caption",
 CellTags->"S1.8.3",
 CellID->1065185792],
Cell[8896, 240, 81, 1, 70, "Text",
 CellID->1153924752],
Cell[CellGroupData[{
Cell[9002, 245, 117, 4, 70, "Input",
 CellID->88490807],
Cell[9122, 251, 159, 5, 36, "Output",
 CellID->1206309525]
}, Open  ]],
Cell[CellGroupData[{
Cell[9318, 261, 159, 5, 70, "Input",
 CellID->51075348],
Cell[9480, 268, 176, 5, 36, "Output",
 CellID->1577398683]
}, Open  ]],
Cell[CellGroupData[{
Cell[9693, 278, 87, 2, 70, "Subsubsection",
 CellTags->{"t:146", "c:72"},
 CellID->654042966],
Cell[9783, 282, 517, 12, 70, "Text",
 CellID->1678824216],
Cell[10303, 296, 1308, 38, 70, "NumberedEquation",
 CellID->210960379],
Cell[11614, 336, 660, 19, 70, "Text",
 CellID->115588656],
Cell[12277, 357, 765, 22, 70, "NumberedEquation",
 CellID->1373324504],
Cell[13045, 381, 102, 3, 70, "Text",
 CellID->310700772],
Cell[13150, 386, 1405, 39, 70, "NumberedEquation",
 CellID->1415129147],
Cell[14558, 427, 356, 12, 70, "Text",
 CellID->694183104],
Cell[14917, 441, 188, 7, 70, "Input",
 CellID->2004258424],
Cell[CellGroupData[{
Cell[15130, 452, 125, 4, 70, "Input",
 CellID->142845326],
Cell[15258, 458, 162, 5, 36, "Output",
 CellID->2062160383]
}, Open  ]],
Cell[CellGroupData[{
Cell[15457, 468, 125, 4, 70, "Input",
 CellID->490978148],
Cell[15585, 474, 176, 5, 36, "Output",
 CellID->1237561662]
}, Open  ]],
Cell[CellGroupData[{
Cell[15798, 484, 136, 4, 70, "Input",
 CellID->1319732039],
Cell[15937, 490, 162, 5, 36, "Output",
 CellID->1525273257]
}, Open  ]],
Cell[16114, 498, 94, 1, 70, "Text",
 CellID->755336160],
Cell[CellGroupData[{
Cell[16233, 503, 103, 3, 70, "Input",
 CellID->1159003703],
Cell[16339, 508, 176, 5, 36, "Output",
 CellID->1698558031]
}, Open  ]],
Cell[16530, 516, 108, 3, 70, "Text",
 CellID->1164707446],
Cell[CellGroupData[{
Cell[16663, 523, 162, 5, 70, "Input",
 CellID->924602517],
Cell[16828, 530, 170, 6, 38, "Output",
 CellID->602833527]
}, Open  ]],
Cell[17013, 539, 106, 3, 70, "Text",
 CellID->2142725390],
Cell[CellGroupData[{
Cell[17144, 546, 163, 5, 70, "Input",
 CellID->1632353187],
Cell[17310, 553, 374, 13, 45, "Output",
 CellID->856423484]
}, Open  ]],
Cell[17699, 569, 106, 3, 70, "Text",
 CellID->1474093394],
Cell[CellGroupData[{
Cell[17830, 576, 126, 4, 70, "Input",
 CellID->1716321166],
Cell[17959, 582, 346, 12, 45, "Output",
 CellID->1209490458]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18354, 600, 88, 2, 70, "Subsubsection",
 CellTags->{"t:147", "c:73"},
 CellID->1973408751],
Cell[18445, 604, 266, 5, 70, "Text",
 CellID->1343433789],
Cell[18714, 611, 202, 5, 70, "Text",
 CellID->448627165],
Cell[18919, 618, 621, 19, 70, "NumberedEquation",
 CellID->261677538],
Cell[19543, 639, 139, 4, 70, "Text",
 CellID->2115355757],
Cell[19685, 645, 652, 19, 70, "NumberedEquation",
 CellID->1192431814],
Cell[20340, 666, 136, 4, 70, "Text",
 CellID->884104094],
Cell[20479, 672, 155, 6, 70, "Text",
 CellID->698154265],
Cell[20637, 680, 272, 10, 70, "Input",
 CellID->28084647],
Cell[CellGroupData[{
Cell[20934, 694, 147, 4, 70, "Input",
 CellID->1719743436],
Cell[21084, 700, 174, 5, 36, "Output",
 CellID->745523879]
}, Open  ]],
Cell[21273, 708, 82, 1, 70, "Text",
 CellID->1600237755],
Cell[CellGroupData[{
Cell[21380, 713, 260, 9, 70, "Input",
 CellID->110753257],
Cell[21643, 724, 176, 5, 36, "Output",
 CellID->1709152097]
}, Open  ]],
Cell[21834, 732, 137, 4, 70, "Text",
 CellID->978032007],
Cell[CellGroupData[{
Cell[21996, 740, 291, 11, 70, "Input",
 CellID->944107511],
Cell[22290, 753, 162, 5, 36, "Output",
 CellID->2005753341]
}, Open  ]],
Cell[CellGroupData[{
Cell[22489, 763, 292, 11, 70, "Input",
 CellID->1645595228],
Cell[22784, 776, 174, 5, 36, "Output",
 CellID->77107283]
}, Open  ]],
Cell[CellGroupData[{
Cell[22995, 786, 303, 11, 70, "Input",
 CellID->1009466240],
Cell[23301, 799, 161, 5, 36, "Output",
 CellID->978284380]
}, Open  ]],
Cell[23477, 807, 207, 5, 70, "Text",
 CellID->890773228],
Cell[CellGroupData[{
Cell[23709, 816, 494, 16, 70, "Input",
 CellID->1117139759],
Cell[24206, 834, 175, 5, 36, "Output",
 CellID->318403792]
}, Open  ]],
Cell[24396, 842, 96, 1, 70, "Text",
 CellID->2030767467],
Cell[CellGroupData[{
Cell[24517, 847, 284, 10, 70, "Input",
 CellID->1151216098],
Cell[24804, 859, 159, 5, 36, "Output",
 CellID->1808783263]
}, Open  ]],
Cell[CellGroupData[{
Cell[25000, 869, 284, 10, 70, "Input",
 CellID->441794309],
Cell[25287, 881, 285, 11, 60, "Output",
 CellID->1385983684]
}, Open  ]],
Cell[CellGroupData[{
Cell[25609, 897, 298, 11, 70, "Input",
 CellID->472657979],
Cell[25910, 910, 159, 5, 36, "Output",
 CellID->420642800]
}, Open  ]],
Cell[26084, 918, 134, 4, 70, "Text",
 CellID->227373676],
Cell[CellGroupData[{
Cell[26243, 926, 285, 10, 70, "Input",
 CellID->1095964519],
Cell[26531, 938, 388, 13, 36, "Output",
 CellID->908430514]
}, Open  ]],
Cell[CellGroupData[{
Cell[26956, 956, 299, 11, 70, "Input",
 CellID->1530402275],
Cell[27258, 969, 389, 13, 36, "Output",
 CellID->1059395806]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27708, 989, 81, 2, 70, "Subsection",
 CellTags->{"t:225", "c:74"},
 CellID->478394165],
Cell[27792, 993, 211, 5, 70, "Text",
 CellID->191956787],
Cell[28006, 1000, 502, 17, 70, "DefinitionBox",
 CellTags->"S3.7.8",
 CellID->697281315],
Cell[28511, 1019, 132, 4, 70, "Text",
 CellID->388799526],
Cell[CellGroupData[{
Cell[28668, 1027, 332, 11, 70, "Input",
 CellID->1908379308],
Cell[29003, 1040, 176, 6, 36, "Output",
 CellID->1462761611]
}, Open  ]],
Cell[29194, 1049, 80, 1, 70, "Text",
 CellID->241605221],
Cell[CellGroupData[{
Cell[29299, 1054, 358, 12, 70, "Input",
 CellID->1914856517],
Cell[29660, 1068, 287, 10, 36, "Output",
 CellID->803547277]
}, Open  ]],
Cell[CellGroupData[{
Cell[29984, 1083, 150, 5, 70, "Input",
 CellID->1841912203],
Cell[30137, 1090, 252, 8, 39, "Output",
 CellID->1041624316]
}, Open  ]],
Cell[30404, 1101, 87, 1, 70, "Text",
 CellID->293188668],
Cell[CellGroupData[{
Cell[30516, 1106, 440, 13, 70, "Input",
 CellID->1294456858],
Cell[30959, 1121, 526, 16, 39, "Output",
 CellID->1927068296]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31534, 1143, 76, 2, 70, "Subsection",
 CellTags->{"t:50", "c:75"},
 CellID->2035970465],
Cell[31613, 1147, 147, 4, 70, "Text",
 CellID->551173957],
Cell[31763, 1153, 387, 13, 70, "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1483725788],
Cell[32153, 1168, 390, 13, 70, "Text",
 CellID->399209952],
Cell[CellGroupData[{
Cell[32568, 1185, 332, 11, 70, "Input",
 CellID->782750036],
Cell[32903, 1198, 157, 5, 36, "Output",
 CellID->91407209]
}, Open  ]],
Cell[33075, 1206, 303, 8, 70, "Text",
 CellID->868493388],
Cell[CellGroupData[{
Cell[33403, 1218, 332, 11, 70, "Input",
 CellID->322023457],
Cell[33738, 1231, 158, 5, 36, "Output",
 CellID->419485042]
}, Open  ]],
Cell[33911, 1239, 229, 5, 70, "Text",
 CellID->566927102],
Cell[CellGroupData[{
Cell[34165, 1248, 150, 4, 70, "Input",
 CellID->2106345222],
Cell[34318, 1254, 157, 5, 36, "Output",
 CellID->85707687]
}, Open  ]],
Cell[34490, 1262, 1901, 65, 70, "Text",
 CellID->1219355101],
Cell[36394, 1329, 291, 6, 70, "Text",
 CellID->264739186]
}, Open  ]],
Cell[CellGroupData[{
Cell[36722, 1340, 97, 2, 70, "Subsection",
 CellTags->{"t:226", "c:76"},
 CellID->2032866165],
Cell[36822, 1344, 562, 9, 70, "Text",
 CellID->2064295032],
Cell[37387, 1355, 757, 18, 70, "Text",
 CellID->2008285539],
Cell[38147, 1375, 507, 8, 70, "Text",
 CellID->1254574074],
Cell[38657, 1385, 442, 13, 70, "Text",
 CellID->1632015472],
Cell[39102, 1400, 405, 13, 70, "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1622898420],
Cell[39510, 1415, 146, 4, 70, "Text",
 CellID->863944393],
Cell[CellGroupData[{
Cell[39681, 1423, 365, 12, 47, "Input",
 CellID->1176475784],
Cell[40049, 1437, 503, 12, 63, "Output",
 Evaluatable->False,
 CellID->583022099]
}, Open  ]],
Cell[40567, 1452, 118, 3, 70, "Text",
 CellID->926332982],
Cell[CellGroupData[{
Cell[40710, 1459, 311, 10, 70, "Input",
 CellID->1769471371],
Cell[41024, 1471, 866, 23, 78, "Output",
 CellID->211997900]
}, Open  ]],
Cell[41905, 1497, 123, 4, 70, "Text",
 CellID->695775929],
Cell[CellGroupData[{
Cell[42053, 1505, 140, 4, 28, "Input",
 CellID->857580788],
Cell[42196, 1511, 755, 16, 78, "Output",
 Evaluatable->False,
 CellID->376845027]
}, Open  ]],
Cell[42966, 1530, 202, 7, 70, "Text",
 CellID->16307052],
Cell[CellGroupData[{
Cell[43193, 1541, 109, 3, 70, "Input",
 CellID->1342199795],
Cell[43305, 1546, 157, 5, 36, "Output",
 CellID->42079144]
}, Open  ]],
Cell[43477, 1554, 269, 5, 70, "Text",
 CellID->602393131],
Cell[CellGroupData[{
Cell[43771, 1563, 181, 6, 28, "Input",
 CellID->1183440759],
Cell[43955, 1571, 756, 16, 63, "Output",
 Evaluatable->False,
 CellID->217141484]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44760, 1593, 79, 2, 70, "Subsection",
 CellTags->{"t:56", "c:77"},
 CellID->1798152178],
Cell[44842, 1597, 172, 6, 70, "Text",
 CellID->6291415],
Cell[45017, 1605, 182, 7, 70, "NumberedEquation",
 CellID->513113202],
Cell[45202, 1614, 379, 14, 70, "Text",
 CellID->1746743309],
Cell[45584, 1630, 384, 13, 70, "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1413339873],
Cell[45971, 1645, 71, 1, 70, "Text",
 CellID->686626044],
Cell[CellGroupData[{
Cell[46067, 1650, 420, 14, 65, "Input",
 CellID->1694286177],
Cell[46490, 1666, 564, 13, 63, "Output",
 Evaluatable->False,
 CellID->295803983]
}, Open  ]],
Cell[47069, 1682, 95, 1, 70, "Text",
 CellID->438346641],
Cell[CellGroupData[{
Cell[47189, 1687, 164, 6, 28, "Input",
 CellID->1423086077],
Cell[47356, 1695, 498, 12, 63, "Output",
 Evaluatable->False,
 CellID->94321381]
}, Open  ]],
Cell[47869, 1710, 195, 4, 70, "Text",
 CellID->1945438855],
Cell[CellGroupData[{
Cell[48089, 1718, 333, 11, 70, "Input",
 CellID->1552310410],
Cell[48425, 1731, 158, 5, 36, "Output",
 CellID->101422021]
}, Open  ]],
Cell[CellGroupData[{
Cell[48620, 1741, 111, 3, 70, "Input",
 CellID->1810353471],
Cell[48734, 1746, 447, 9, 70, "Message",
 CellID->202721639],
Cell[49184, 1757, 349, 12, 36, "Output",
 CellID->363054539]
}, Open  ]],
Cell[49548, 1772, 117, 3, 70, "Text",
 CellID->1593114484],
Cell[49668, 1777, 135, 5, 70, "NumberedEquation",
 CellID->649021792],
Cell[49806, 1784, 158, 6, 70, "Text",
 CellID->1039815031],
Cell[49967, 1792, 183, 7, 70, "NumberedEquation",
 CellID->2096790378],
Cell[50153, 1801, 309, 8, 70, "Text",
 CellID->549235776]
}, Open  ]],
Cell[CellGroupData[{
Cell[50499, 1814, 86, 2, 70, "Subsection",
 CellTags->{"t:227", "c:78"},
 CellID->1120972426],
Cell[50588, 1818, 536, 15, 70, "Text",
 CellID->309528651],
Cell[51127, 1835, 402, 13, 70, "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->1042644323],
Cell[51532, 1850, 111, 3, 70, "Text",
 CellID->256577141],
Cell[CellGroupData[{
Cell[51668, 1857, 430, 14, 65, "Input",
 CellID->144845611],
Cell[52101, 1873, 617, 14, 63, "Output",
 Evaluatable->False,
 CellID->648483347]
}, Open  ]],
Cell[52733, 1890, 126, 4, 70, "Text",
 CellID->629611002],
Cell[CellGroupData[{
Cell[52884, 1898, 133, 4, 28, "Input",
 CellID->1220181845],
Cell[53020, 1904, 605, 14, 63, "Output",
 Evaluatable->False,
 CellID->544000257]
}, Open  ]],
Cell[53640, 1921, 91, 1, 70, "Text",
 CellID->50997818],
Cell[CellGroupData[{
Cell[53756, 1926, 454, 15, 70, "Input",
 CellID->274351973],
Cell[54213, 1943, 939, 26, 78, "Output",
 CellID->332414613]
}, Open  ]],
Cell[55167, 1972, 86, 1, 70, "Text",
 CellID->1505673080],
Cell[CellGroupData[{
Cell[55278, 1977, 133, 4, 70, "Input",
 CellID->2047642959],
Cell[55414, 1983, 823, 22, 68, "Output",
 CellID->10071531]
}, Open  ]],
Cell[56252, 2008, 309, 8, 70, "Text",
 CellID->1575797816]
}, Open  ]],
Cell[CellGroupData[{
Cell[56598, 2021, 83, 2, 70, "Subsection",
 CellTags->{"t:55", "c:79"},
 CellID->1665558708],
Cell[56684, 2025, 203, 7, 70, "Text",
 CellID->595866711],
Cell[56890, 2034, 877, 29, 70, "NumberedEquation",
 CellID->1015565816],
Cell[57770, 2065, 261, 11, 70, "Text",
 CellID->414643156],
Cell[58034, 2078, 1117, 39, 70, "DefinitionBox",
 CellTags->"S1.8.3",
 CellID->323088377],
Cell[59154, 2119, 72, 1, 70, "Text",
 CellID->1307692623],
Cell[CellGroupData[{
Cell[59251, 2124, 316, 11, 70, "Input",
 CellID->1042271363],
Cell[59570, 2137, 177, 6, 36, "Output",
 CellID->430689362]
}, Open  ]],
Cell[59762, 2146, 362, 13, 70, "Text",
 CellID->1576216744],
Cell[CellGroupData[{
Cell[60149, 2163, 315, 11, 70, "Input",
 CellID->116547016],
Cell[60467, 2176, 160, 5, 36, "Output",
 CellID->300611848]
}, Open  ]],
Cell[60642, 2184, 250, 7, 70, "Text",
 CellID->1501791592],
Cell[CellGroupData[{
Cell[60917, 2195, 109, 3, 70, "Input",
 CellID->1235983553],
Cell[61029, 2200, 158, 5, 36, "Output",
 CellID->566257840]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61236, 2211, 79, 2, 70, "Subsection",
 CellTags->{"t:207", "c:80"},
 CellID->1595477023],
Cell[61318, 2215, 439, 15, 70, "Text",
 CellTags->{"S3.7.7", "7.4"},
 CellID->1701509119],
Cell[CellGroupData[{
Cell[61782, 2234, 408, 13, 70, "Input",
 CellID->1371519581],
Cell[62193, 2249, 580, 22, 36, "Output",
 CellID->40130969]
}, Open  ]],
Cell[62788, 2274, 194, 4, 70, "Text",
 CellID->171330825],
Cell[CellGroupData[{
Cell[63007, 2282, 133, 4, 70, "Input",
 CellID->1929088795],
Cell[63143, 2288, 392, 13, 36, "Output",
 CellID->1634758806]
}, Open  ]],
Cell[63550, 2304, 1370, 44, 70, "Text",
 CellID->485472724],
Cell[CellGroupData[{
Cell[64945, 2352, 677, 21, 70, "Input",
 CellID->1049697315],
Cell[65625, 2375, 1312, 41, 71, "Output",
 CellID->684613100]
}, Open  ]],
Cell[66952, 2419, 374, 9, 70, "Text",
 CellID->74991074],
Cell[CellGroupData[{
Cell[67351, 2432, 412, 13, 70, "Input",
 CellID->1949563576],
Cell[67766, 2447, 156, 5, 36, "Output",
 CellID->9535906]
}, Open  ]],
Cell[67937, 2455, 76, 1, 70, "Text",
 CellID->1356182264],
Cell[CellGroupData[{
Cell[68038, 2460, 102, 3, 70, "Input",
 CellID->2111365437],
Cell[68143, 2465, 158, 5, 36, "Output",
 CellID->699116631]
}, Open  ]],
Cell[68316, 2473, 166, 4, 70, "Text",
 CellID->1170184480],
Cell[CellGroupData[{
Cell[68507, 2481, 104, 3, 70, "Input",
 CellID->635316134],
Cell[68614, 2486, 455, 16, 36, "Output",
 CellID->469571254]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69130, 2509, 89, 2, 70, "Section",
 CellTags->{"t:46", "c:81"},
 CellID->81663253],
Cell[69222, 2513, 456, 12, 70, "Text",
 CellID->272242738],
Cell[69681, 2527, 635, 22, 70, "Text",
 CellID->1443529456],
Cell[70319, 2551, 1102, 40, 70, "NumberedEquation",
 CellID->1276806833],
Cell[71424, 2593, 573, 18, 70, "Text",
 CellID->1635841407],
Cell[72000, 2613, 1365, 37, 70, "DefinitionBox",
 CellTags->"S3.7.8",
 CellID->1500878555],
Cell[73368, 2652, 131, 4, 70, "Caption",
 CellTags->"S3.7.8",
 CellID->922956223],
Cell[73502, 2658, 645, 20, 70, "Text",
 CellID->850857680],
Cell[74150, 2680, 939, 32, 70, "DefinitionBox",
 CellTags->"S3.7.8",
 CellID->271422387],
Cell[75092, 2714, 239, 9, 70, "Caption",
 CellTags->"S3.7.8",
 CellID->540792081],
Cell[75334, 2725, 219, 8, 70, "Text",
 CellID->941711263],
Cell[CellGroupData[{
Cell[75578, 2737, 474, 17, 70, "Input",
 CellID->386718851],
Cell[76055, 2756, 244, 8, 36, "Output",
 CellID->1298212935]
}, Open  ]],
Cell[76314, 2767, 113, 3, 70, "Text",
 CellID->630945025],
Cell[CellGroupData[{
Cell[76452, 2774, 91, 3, 70, "Input",
 CellID->18786289],
Cell[76546, 2779, 207, 7, 36, "Output",
 CellID->61063114]
}, Open  ]],
Cell[76768, 2789, 114, 3, 70, "Text",
 CellID->1938057379],
Cell[CellGroupData[{
Cell[76907, 2796, 215, 7, 70, "Input",
 CellID->2045894804],
Cell[77125, 2805, 438, 15, 36, "Output",
 CellID->1993298711]
}, Open  ]],
Cell[77578, 2823, 80, 1, 70, "Text",
 CellID->626542577],
Cell[CellGroupData[{
Cell[77683, 2828, 102, 3, 70, "Input",
 CellID->1188770398],
Cell[77788, 2833, 335, 11, 36, "Output",
 CellID->1623711145]
}, Open  ]],
Cell[78138, 2847, 256, 8, 70, "Text",
 CellID->1638511586],
Cell[CellGroupData[{
Cell[78419, 2859, 590, 21, 70, "Input",
 CellID->1281420421],
Cell[79012, 2882, 358, 13, 36, "Output",
 CellID->1867003631]
}, Open  ]],
Cell[CellGroupData[{
Cell[79407, 2900, 94, 3, 70, "Input",
 CellID->1846459900],
Cell[79504, 2905, 346, 12, 36, "Output",
 CellID->165356503]
}, Open  ]],
Cell[79865, 2920, 249, 8, 70, "Text",
 CellID->302906703],
Cell[80117, 2930, 454, 16, 70, "Input",
 CellID->1416713931],
Cell[CellGroupData[{
Cell[80596, 2950, 132, 4, 70, "Input",
 CellID->1559844028],
Cell[80731, 2956, 261, 9, 36, "Output",
 CellID->1965699667]
}, Open  ]],
Cell[81007, 2968, 400, 9, 70, "Text",
 CellID->625877821],
Cell[81410, 2979, 295, 9, 70, "Text",
 CellID->753634541],
Cell[81708, 2990, 396, 14, 70, "Input",
 CellID->477180581],
Cell[CellGroupData[{
Cell[82129, 3008, 132, 4, 70, "Input",
 CellID->1270086969],
Cell[82264, 3014, 293, 9, 36, "Output",
 CellID->364236803]
}, Open  ]],
Cell[82572, 3026, 493, 13, 70, "Text",
 CellID->1399554071],
Cell[CellGroupData[{
Cell[83090, 3043, 386, 12, 70, "Input",
 CellID->916885706],
Cell[83479, 3057, 163, 5, 36, "Output",
 CellID->1902893517]
}, Open  ]],
Cell[83657, 3065, 693, 19, 70, "Text",
 CellID->1604869095],
Cell[CellGroupData[{
Cell[84375, 3088, 649, 21, 70, "Input",
 CellID->640273345],
Cell[85027, 3111, 275, 9, 36, "Output",
 CellID->33554298]
}, Open  ]],
Cell[85317, 3123, 1089, 34, 70, "DefinitionBox3Col",
 CellTags->"S5.27.1",
 CellID->1306370972],
Cell[86409, 3159, 126, 6, 70, "Caption",
 CellTags->"S3.7.8",
 CellID->304119476],
Cell[86538, 3167, 1255, 38, 70, "Text",
 CellID->324953272],
Cell[CellGroupData[{
Cell[87818, 3209, 88, 2, 70, "Subsection",
 CellTags->{"t:86", "c:82"},
 CellID->438728183],
Cell[87909, 3213, 253, 5, 70, "Text",
 CellID->1393211530],
Cell[CellGroupData[{
Cell[88187, 3222, 312, 11, 70, "Input",
 CellID->1691981469],
Cell[88502, 3235, 160, 5, 36, "Output",
 CellID->728430488]
}, Open  ]],
Cell[88677, 3243, 82, 1, 70, "Text",
 CellID->24664281],
Cell[CellGroupData[{
Cell[88784, 3248, 238, 8, 70, "Input",
 CellID->68226896],
Cell[89025, 3258, 431, 8, 70, "Message",
 CellID->62968202],
Cell[89459, 3268, 435, 15, 36, "Output",
 CellID->405558254]
}, Open  ]],
Cell[89909, 3286, 90, 1, 70, "Text",
 CellID->1577212973],
Cell[CellGroupData[{
Cell[90024, 3291, 240, 8, 70, "Input",
 CellID->1827782290],
Cell[90267, 3301, 224, 7, 36, "Output",
 CellID->108431656]
}, Open  ]],
Cell[90506, 3311, 407, 12, 70, "Text",
 CellID->1361185177],
Cell[CellGroupData[{
Cell[90938, 3327, 356, 12, 70, "Input",
 CellID->295978348],
Cell[91297, 3341, 162, 5, 36, "Output",
 CellID->197737291]
}, Open  ]],
Cell[91474, 3349, 396, 12, 70, "Text",
 CellID->502915613],
Cell[CellGroupData[{
Cell[91895, 3365, 354, 12, 70, "Input",
 CellID->7073099],
Cell[92252, 3379, 160, 5, 36, "Output",
 CellID->61245652]
}, Open  ]],
Cell[92427, 3387, 413, 10, 70, "Text",
 CellID->1713214438]
}, Open  ]],
Cell[CellGroupData[{
Cell[92877, 3402, 92, 2, 70, "Subsection",
 CellTags->{"t:86", "c:83"},
 CellID->534320490],
Cell[92972, 3406, 109, 3, 70, "Text",
 CellID->1695347323],
Cell[93084, 3411, 147, 5, 70, "NumberedEquation",
 CellID->889429265],
Cell[93234, 3418, 173, 4, 70, "Text",
 CellID->3990088],
Cell[CellGroupData[{
Cell[93432, 3426, 311, 11, 70, "Input",
 CellID->489415959],
Cell[93746, 3439, 160, 5, 36, "Output",
 CellID->751654903]
}, Open  ]],
Cell[93921, 3447, 394, 10, 70, "Text",
 CellID->1565143067],
Cell[CellGroupData[{
Cell[94340, 3461, 131, 4, 70, "Input",
 CellID->832334966],
Cell[94474, 3467, 287, 10, 36, "Output",
 CellID->345297004]
}, Open  ]],
Cell[94776, 3480, 120, 3, 70, "Text",
 CellID->905932034],
Cell[CellGroupData[{
Cell[94921, 3487, 147, 5, 70, "Input",
 CellID->340638208],
Cell[95071, 3494, 252, 8, 39, "Output",
 CellID->2062442601]
}, Open  ]],
Cell[95338, 3505, 235, 8, 70, "Text",
 CellID->939248780],
Cell[CellGroupData[{
Cell[95598, 3517, 97, 3, 70, "Input",
 CellID->1949440010],
Cell[95698, 3522, 202, 7, 36, "Output",
 CellID->80245791]
}, Open  ]],
Cell[95915, 3532, 209, 5, 70, "Text",
 CellID->71279021],
Cell[CellGroupData[{
Cell[96149, 3541, 261, 9, 70, "Input",
 CellID->1838114568],
Cell[96413, 3552, 225, 7, 36, "Output",
 CellID->1639282281]
}, Open  ]],
Cell[96653, 3562, 82, 1, 70, "Text",
 CellID->1349589404],
Cell[CellGroupData[{
Cell[96760, 3567, 94, 3, 70, "Input",
 CellID->826833414],
Cell[96857, 3572, 207, 7, 36, "Output",
 CellID->222509361]
}, Open  ]],
Cell[97079, 3582, 197, 6, 70, "Text",
 CellID->945800900],
Cell[CellGroupData[{
Cell[97301, 3592, 259, 9, 70, "Input",
 CellID->401771206],
Cell[97563, 3603, 242, 8, 36, "Output",
 CellID->880073074]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97854, 3617, 97, 2, 70, "Subsection",
 CellTags->"c:84",
 CellID->1668277829],
Cell[97954, 3621, 330, 8, 70, "Text",
 CellID->1198976771],
Cell[98287, 3631, 319, 9, 70, "NumberedEquation",
 CellID->1363530396],
Cell[98609, 3642, 930, 26, 70, "Text",
 CellID->1057368435],
Cell[99542, 3670, 248, 9, 70, "Text",
 CellID->764108120],
Cell[99793, 3681, 808, 24, 70, "DefinitionBox",
 CellTags->"S5.48.1",
 CellID->412963780],
Cell[100604, 3707, 83, 1, 70, "Text",
 CellID->439033946],
Cell[CellGroupData[{
Cell[100712, 3712, 351, 11, 70, "Input",
 CellID->89719330],
Cell[101066, 3725, 176, 5, 36, "Output",
 CellID->171847193]
}, Open  ]],
Cell[101257, 3733, 108, 3, 70, "Text",
 CellID->476498316],
Cell[CellGroupData[{
Cell[101390, 3740, 352, 11, 70, "Input",
 CellID->540677349],
Cell[101745, 3753, 168, 5, 36, "Output",
 CellID->139783744]
}, Open  ]],
Cell[101928, 3761, 120, 3, 70, "Text",
 CellID->1259651107],
Cell[CellGroupData[{
Cell[102073, 3768, 610, 18, 70, "Input",
 CellID->1062363223],
Cell[102686, 3788, 178, 5, 36, "Output",
 CellID->19623054]
}, Open  ]],
Cell[102879, 3796, 115, 3, 70, "Text",
 CellID->1198436051],
Cell[CellGroupData[{
Cell[103019, 3803, 220, 7, 70, "Input",
 CellID->865583944],
Cell[103242, 3812, 179, 5, 36, "Output",
 CellID->156979015]
}, Open  ]],
Cell[103436, 3820, 151, 4, 70, "Text",
 CellID->957773997],
Cell[CellGroupData[{
Cell[103612, 3828, 389, 13, 70, "Input",
 CellID->1917633314],
Cell[104004, 3843, 180, 5, 36, "Output",
 CellID->8023336]
}, Open  ]],
Cell[104199, 3851, 128, 5, 70, "Text",
 CellID->1273908318],
Cell[CellGroupData[{
Cell[104352, 3860, 279, 9, 70, "Input",
 CellID->165140036],
Cell[104634, 3871, 698, 12, 70, "Message",
 CellID->609849313],
Cell[105335, 3885, 179, 5, 36, "Output",
 CellID->40334265]
}, Open  ]],
Cell[105529, 3893, 527, 12, 70, "Text",
 CellID->148869679],
Cell[CellGroupData[{
Cell[106081, 3909, 418, 13, 70, "Input",
 CellID->234246198],
Cell[106502, 3924, 158, 5, 36, "Output",
 CellID->20988720]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106709, 3935, 99, 2, 70, "Subsection",
 CellTags->{"t:87", "c:85"},
 CellID->1644685080],
Cell[106811, 3939, 536, 15, 70, "Text",
 CellID->1960119023],
Cell[CellGroupData[{
Cell[107372, 3958, 319, 11, 70, "Input",
 CellID->1321274581],
Cell[107694, 3971, 334, 12, 63, "Output",
 CellID->1680972887]
}, Open  ]],
Cell[CellGroupData[{
Cell[108065, 3988, 259, 9, 70, "Input",
 CellID->1963935524],
Cell[108327, 3999, 595, 22, 52, "Output",
 CellID->1040697478]
}, Open  ]],
Cell[108937, 4024, 93, 1, 70, "Text",
 CellID->1895691578],
Cell[CellGroupData[{
Cell[109055, 4029, 92, 3, 70, "Input",
 CellID->820964554],
Cell[109150, 4034, 1302, 47, 52, "Output",
 CellID->368827103]
}, Open  ]],
Cell[110467, 4084, 471, 11, 70, "Text",
 CellID->1239314879],
Cell[CellGroupData[{
Cell[110963, 4099, 100, 3, 70, "Input",
 CellID->721279100],
Cell[111066, 4104, 206, 7, 36, "Output",
 CellID->2140130032]
}, Open  ]],
Cell[111287, 4114, 255, 8, 70, "Text",
 CellID->961844221],
Cell[111545, 4124, 219, 7, 70, "Text",
 CellID->1606411378],
Cell[CellGroupData[{
Cell[111789, 4135, 314, 11, 70, "Input",
 CellID->791619962],
Cell[112106, 4148, 330, 12, 63, "Output",
 CellID->1095508169]
}, Open  ]],
Cell[CellGroupData[{
Cell[112473, 4165, 257, 9, 70, "Input",
 CellID->1828490652],
Cell[112733, 4176, 223, 8, 36, "Output",
 CellID->951399594]
}, Open  ]],
Cell[CellGroupData[{
Cell[112993, 4189, 91, 3, 70, "Input",
 CellID->9740796],
Cell[113087, 4194, 204, 7, 36, "Output",
 CellID->504801200]
}, Open  ]],
Cell[113306, 4204, 462, 14, 70, "Text",
 CellID->1633362750],
Cell[CellGroupData[{
Cell[113793, 4222, 88, 2, 70, "Subsubsection",
 CellTags->{"t:148", "c:86"},
 CellID->644279649],
Cell[113884, 4226, 443, 10, 70, "Text",
 CellID->795512569],
Cell[CellGroupData[{
Cell[114352, 4240, 260, 9, 70, "Input",
 CellID->2094044608],
Cell[114615, 4251, 303, 11, 36, "Output",
 CellID->1645719620]
}, Open  ]],
Cell[114933, 4265, 92, 1, 70, "Text",
 CellID->20279980],
Cell[CellGroupData[{
Cell[115050, 4270, 280, 9, 70, "Input",
 CellID->1543207634],
Cell[115333, 4281, 424, 15, 36, "Output",
 CellID->1530699819]
}, Open  ]],
Cell[115772, 4299, 230, 8, 70, "Text",
 CellID->1765250520],
Cell[CellGroupData[{
Cell[116027, 4311, 340, 12, 70, "Input",
 CellID->1078906335],
Cell[116370, 4325, 298, 11, 36, "Output",
 CellID->1974340724]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116729, 4343, 96, 2, 70, "Subsection",
 CellTags->{"t:47", "c:87"},
 CellID->1974718471],
Cell[116828, 4347, 857, 23, 70, "Text",
 CellID->1881061359],
Cell[CellGroupData[{
Cell[117710, 4374, 350, 12, 70, "Input",
 CellID->1891493226],
Cell[118063, 4388, 326, 12, 36, "Output",
 CellID->92047681]
}, Open  ]],
Cell[118404, 4403, 278, 8, 70, "Text",
 CellID->506424029],
Cell[CellGroupData[{
Cell[118707, 4415, 232, 8, 70, "Input",
 CellID->990962342],
Cell[118942, 4425, 227, 8, 36, "Output",
 CellID->895485530]
}, Open  ]],
Cell[119184, 4436, 69, 1, 70, "Text",
 CellID->1288172040],
Cell[CellGroupData[{
Cell[119278, 4441, 93, 3, 70, "Input",
 CellID->1524830873],
Cell[119374, 4446, 208, 7, 36, "Output",
 CellID->154706783]
}, Open  ]],
Cell[119597, 4456, 92, 1, 70, "Text",
 CellID->701869017],
Cell[CellGroupData[{
Cell[119714, 4461, 232, 8, 70, "Input",
 CellID->184895748],
Cell[119949, 4471, 228, 8, 36, "Output",
 CellID->299596259]
}, Open  ]],
Cell[120192, 4482, 83, 1, 70, "Text",
 CellID->1565507533],
Cell[CellGroupData[{
Cell[120300, 4487, 92, 3, 70, "Input",
 CellID->515464087],
Cell[120395, 4492, 208, 7, 36, "Output",
 CellID->332824869]
}, Open  ]],
Cell[120618, 4502, 448, 11, 70, "Text",
 CellID->1870923428],
Cell[121069, 4515, 409, 7, 70, "Text",
 CellID->1154495022],
Cell[CellGroupData[{
Cell[121503, 4526, 411, 14, 70, "Input",
 CellID->1083084109],
Cell[121917, 4542, 333, 7, 70, "Message",
 CellID->194050909],
Cell[122253, 4551, 328, 12, 36, "Output",
 CellID->390539149]
}, Open  ]],
Cell[122596, 4566, 111, 3, 70, "Text",
 CellID->311955258],
Cell[CellGroupData[{
Cell[122732, 4573, 218, 7, 70, "Input",
 CellID->1024438879],
Cell[122953, 4582, 258, 9, 36, "Output",
 CellID->3416101]
}, Open  ]],
Cell[123226, 4594, 130, 4, 70, "Text",
 CellID->497195543],
Cell[CellGroupData[{
Cell[123381, 4602, 215, 7, 70, "Input",
 CellID->506620724],
Cell[123599, 4611, 433, 8, 70, "Message",
 CellID->258154749],
Cell[124035, 4621, 425, 15, 36, "Output",
 CellID->131536475]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124509, 4642, 78, 2, 70, "Subsection",
 CellTags->{"t:89", "c:88"},
 CellID->834729047],
Cell[124590, 4646, 632, 18, 70, "Text",
 CellID->1927910725],
Cell[125225, 4666, 1206, 34, 70, "Text",
 CellID->1162289139],
Cell[126434, 4702, 92, 1, 70, "Text",
 CellID->1082306061],
Cell[CellGroupData[{
Cell[126551, 4707, 82, 2, 70, "Subsubsection",
 CellTags->{"t:145", "c:89"},
 CellID->1131477137],
Cell[126636, 4711, 562, 12, 70, "Text",
 CellID->768547374],
Cell[127201, 4725, 179, 4, 70, "Text",
 CellID->2009061760]
}, Open  ]],
Cell[CellGroupData[{
Cell[127417, 4734, 87, 2, 70, "Subsubsection",
 CellTags->{"t:90", "c:90"},
 CellID->1415618539],
Cell[127507, 4738, 190, 4, 70, "Text",
 CellID->329459860],
Cell[127700, 4744, 334, 8, 70, "Text",
 CellID->1019025054],
Cell[CellGroupData[{
Cell[128059, 4756, 223, 7, 70, "Input",
 CellID->571997753],
Cell[128285, 4765, 491, 17, 36, "Output",
 CellID->275219561]
}, Open  ]],
Cell[128791, 4785, 229, 8, 70, "Input",
 CellID->542199104],
Cell[129023, 4795, 92, 1, 70, "Text",
 CellID->967226707],
Cell[129118, 4798, 215, 6, 70, "Input",
 CellID->1875540406],
Cell[129336, 4806, 139, 4, 70, "Text",
 CellID->1442632976],
Cell[129478, 4812, 233, 7, 70, "Text",
 CellID->1242053002]
}, Open  ]],
Cell[CellGroupData[{
Cell[129748, 4824, 81, 2, 70, "Subsubsection",
 CellTags->{"t:91", "c:91"},
 CellID->1643755774],
Cell[129832, 4828, 515, 10, 70, "Text",
 CellID->1373658610],
Cell[130350, 4840, 1400, 42, 70, "DefinitionBox3Col",
 CellTags->"S5.27.1",
 CellID->1631053020],
Cell[131753, 4884, 94, 2, 70, "Caption",
 CellTags->"S3.7.9",
 CellID->479353185],
Cell[131850, 4888, 516, 9, 70, "Text",
 CellID->1277820398],
Cell[CellGroupData[{
Cell[132391, 4901, 635, 22, 70, "Input",
 CellID->1490959186],
Cell[133029, 4925, 264, 9, 36, "Output",
 CellID->436969947]
}, Open  ]],
Cell[133308, 4937, 109, 3, 70, "Text",
 CellID->251630266],
Cell[CellGroupData[{
Cell[133442, 4944, 211, 6, 70, "Input",
 CellID->754579719],
Cell[133656, 4952, 263, 9, 36, "Output",
 CellID->379015713]
}, Open  ]],
Cell[133934, 4964, 75, 1, 70, "Text",
 CellID->461605722],
Cell[CellGroupData[{
Cell[134034, 4969, 154, 5, 70, "Input",
 CellID->1496436690],
Cell[134191, 4976, 179, 5, 36, "Output",
 CellID->14355832]
}, Open  ]],
Cell[134385, 4984, 219, 5, 70, "Text",
 CellID->641841926],
Cell[134607, 4991, 2737, 81, 70, "Input",
 CellID->626891401],
Cell[137347, 5074, 119, 3, 70, "Text",
 CellID->609004425],
Cell[CellGroupData[{
Cell[137491, 5081, 147, 4, 28, "Input",
 CellID->630309373],
Cell[137641, 5087, 2104, 39, 195, "Output",
 Evaluatable->False,
 CellID->188140415]
}, Open  ]],
Cell[139760, 5129, 107, 3, 70, "Text",
 CellID->1654262377],
Cell[139870, 5134, 430, 14, 70, "Input",
 CellID->1864476177],
Cell[140303, 5150, 239, 7, 70, "Text",
 CellID->169729815],
Cell[CellGroupData[{
Cell[140567, 5161, 213, 7, 70, "Input",
 CellID->790717489],
Cell[140783, 5170, 212, 7, 36, "Output",
 CellID->667578673]
}, Open  ]],
Cell[141010, 5180, 65, 1, 70, "Text",
 CellID->1179351598],
Cell[CellGroupData[{
Cell[141100, 5185, 234, 8, 70, "Input",
 CellID->88245776],
Cell[141337, 5195, 226, 7, 36, "Output",
 CellID->132366419]
}, Open  ]],
Cell[141578, 5205, 184, 4, 70, "Text",
 CellID->403764086],
Cell[CellGroupData[{
Cell[141787, 5213, 346, 11, 70, "Input",
 CellID->14668882],
Cell[142136, 5226, 224, 7, 36, "Output",
 CellID->5242608]
}, Open  ]],
Cell[142375, 5236, 339, 6, 70, "Text",
 CellID->628811354],
Cell[CellGroupData[{
Cell[142739, 5246, 831, 28, 70, "Input",
 CellID->665399791],
Cell[143573, 5276, 226, 7, 36, "Output",
 CellID->36419334]
}, Open  ]],
Cell[143814, 5286, 191, 6, 70, "Text",
 CellID->1587130207],
Cell[CellGroupData[{
Cell[144030, 5296, 606, 20, 70, "Input",
 CellID->1003009662],
Cell[144639, 5318, 225, 7, 36, "Output",
 CellID->22537556]
}, Open  ]],
Cell[144879, 5328, 251, 5, 70, "Text",
 CellID->914194054],
Cell[145133, 5335, 184, 4, 70, "Text",
 CellID->1761454940],
Cell[145320, 5341, 263, 5, 70, "Text",
 CellID->1711102685]
}, Open  ]],
Cell[CellGroupData[{
Cell[145620, 5351, 83, 2, 70, "Subsubsection",
 CellTags->{"t:92", "c:92"},
 CellID->1549309818],
Cell[145706, 5355, 158, 5, 70, "Text",
 CellID->1010891251],
Cell[CellGroupData[{
Cell[145889, 5364, 221, 7, 70, "Input",
 CellID->1306124140],
Cell[146113, 5373, 489, 17, 36, "Output",
 CellID->130199739]
}, Open  ]],
Cell[146617, 5393, 227, 8, 70, "Input",
 CellID->893342900],
Cell[CellGroupData[{
Cell[146869, 5405, 182, 6, 70, "Input",
 CellID->1355944123],
Cell[147054, 5413, 225, 7, 36, "Output",
 CellID->104099578]
}, Open  ]],
Cell[147294, 5423, 83, 1, 70, "Text",
 CellID->1686086797],
Cell[CellGroupData[{
Cell[147402, 5428, 244, 8, 70, "Input",
 CellID->2014075014],
Cell[147649, 5438, 226, 7, 36, "Output",
 CellID->239566920]
}, Open  ]],
Cell[147890, 5448, 139, 4, 70, "Text",
 CellID->1065101602],
Cell[148032, 5454, 456, 15, 70, "Input",
 CellID->1886427069],
Cell[148491, 5471, 125, 4, 70, "Text",
 CellID->1878668022],
Cell[CellGroupData[{
Cell[148641, 5479, 159, 6, 70, "Input",
 CellID->321383913],
Cell[148803, 5487, 766, 13, 70, "Message",
 CellID->606905512],
Cell[149572, 5502, 211, 7, 36, "Output",
 CellID->745733211]
}, Open  ]],
Cell[149798, 5512, 65, 1, 70, "Text",
 CellID->280602084],
Cell[CellGroupData[{
Cell[149888, 5517, 229, 8, 70, "Input",
 CellID->205136976],
Cell[150120, 5527, 225, 7, 36, "Output",
 CellID->660130147]
}, Open  ]],
Cell[150360, 5537, 378, 9, 70, "Text",
 CellID->192023216]
}, Open  ]],
Cell[CellGroupData[{
Cell[150775, 5551, 91, 2, 70, "Subsubsection",
 CellTags->{"t:93", "c:93"},
 CellID->1813753518],
Cell[150869, 5555, 344, 10, 70, "Text",
 CellID->225007861],
Cell[151216, 5567, 3691, 111, 70, "Input",
 CellID->2135901107],
Cell[154910, 5680, 86, 1, 70, "Text",
 CellID->753262097],
Cell[CellGroupData[{
Cell[155021, 5685, 284, 8, 70, "Input",
 CellID->659965214],
Cell[155308, 5695, 258, 9, 36, "Output",
 CellID->282314943]
}, Open  ]],
Cell[CellGroupData[{
Cell[155603, 5709, 293, 8, 70, "Input",
 CellID->1075870778],
Cell[155899, 5719, 259, 9, 36, "Output",
 CellID->347858106]
}, Open  ]],
Cell[CellGroupData[{
Cell[156195, 5733, 287, 8, 70, "Input",
 CellID->1000700408],
Cell[156485, 5743, 261, 9, 36, "Output",
 CellID->1827317599]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[156819, 5760, 92, 2, 70, "Section",
 CellTags->{"t:103", "c:94"},
 CellID->563250646],
Cell[156914, 5764, 863, 27, 70, "Text",
 CellID->445691346],
Cell[CellGroupData[{
Cell[157802, 5795, 521, 18, 70, "Input",
 CellID->311491486],
Cell[158326, 5815, 432, 8, 70, "Message",
 CellID->258943337],
Cell[158761, 5825, 515, 17, 36, "Output",
 CellID->629934800]
}, Open  ]],
Cell[159291, 5845, 889, 24, 70, "Text",
 CellID->1374474750],
Cell[160183, 5871, 482, 14, 70, "Text",
 CellID->315532471],
Cell[160668, 5887, 285, 9, 70, "NumberedEquation",
 CellID->1017115654],
Cell[160956, 5898, 703, 18, 70, "Text",
 CellID->692966658],
Cell[161662, 5918, 474, 10, 70, "Text",
 CellID->886803325],
Cell[162139, 5930, 562, 14, 70, "Text",
 CellID->966973095],
Cell[162704, 5946, 241, 7, 70, "NumberedEquation",
 CellID->1908050816],
Cell[162948, 5955, 201, 6, 70, "Text",
 CellID->236763861],
Cell[CellGroupData[{
Cell[163174, 5965, 494, 17, 70, "Input",
 CellID->3013936],
Cell[163671, 5984, 157, 5, 36, "Output",
 CellID->11852475]
}, Open  ]],
Cell[163843, 5992, 144, 5, 70, "Text",
 CellID->1020151502],
Cell[CellGroupData[{
Cell[164012, 6001, 156, 5, 70, "Input",
 CellID->176856466],
Cell[164171, 6008, 241, 8, 36, "Output",
 CellID->111124193]
}, Open  ]],
Cell[164427, 6019, 82, 1, 70, "Text",
 CellID->765485758],
Cell[CellGroupData[{
Cell[164534, 6024, 93, 3, 70, "Input",
 CellID->2092089176],
Cell[164630, 6029, 274, 9, 36, "Output",
 CellID->178937007]
}, Open  ]],
Cell[CellGroupData[{
Cell[164941, 6043, 85, 2, 70, "Subsection",
 CellTags->{"t:208", "c:95"},
 CellID->1737956870],
Cell[165029, 6047, 551, 14, 70, "Text",
 CellID->1916031243],
Cell[165583, 6063, 284, 8, 70, "NumberedEquation",
 CellID->1219814336],
Cell[165870, 6073, 225, 5, 70, "Text",
 CellID->1540650890],
Cell[166098, 6080, 643, 26, 70, "NumberedEquation",
 CellID->1509176351],
Cell[166744, 6108, 78, 1, 70, "Text",
 CellID->797576540],
Cell[166825, 6111, 415, 13, 70, "NumberedEquation",
 CellID->275983206],
Cell[167243, 6126, 73, 1, 70, "Text",
 CellID->2032549369],
Cell[167319, 6129, 939, 33, 70, "NumberedEquation",
 CellID->1034871954],
Cell[168261, 6164, 181, 4, 70, "Text",
 CellID->622873825],
Cell[168445, 6170, 162, 4, 70, "Text",
 CellID->1805081297],
Cell[168610, 6176, 478, 16, 70, "Input",
 CellID->499877510],
Cell[169091, 6194, 69, 1, 70, "Text",
 CellID->485283506],
Cell[CellGroupData[{
Cell[169185, 6199, 243, 7, 70, "Input",
 CellID->16994036],
Cell[169431, 6208, 533, 17, 123, "Output",
 CellID->80443068]
}, Open  ]],
Cell[169979, 6228, 434, 14, 70, "Text",
 CellID->1947907985],
Cell[170416, 6244, 341, 12, 70, "Input",
 CellID->101305380],
Cell[170760, 6258, 72, 1, 70, "Text",
 CellID->1832473236],
Cell[CellGroupData[{
Cell[170857, 6263, 401, 13, 70, "Input",
 CellID->1314695825],
Cell[171261, 6278, 808, 25, 108, "Output",
 CellID->393365027]
}, Open  ]],
Cell[172084, 6306, 84, 1, 70, "Text",
 CellID->1936074965],
Cell[CellGroupData[{
Cell[172193, 6311, 138, 4, 70, "Input",
 CellID->939717411],
Cell[172334, 6317, 243, 8, 36, "Output",
 CellID->128161560]
}, Open  ]],
Cell[172592, 6328, 469, 16, 70, "Text",
 CellID->1551691536],
Cell[CellGroupData[{
Cell[173086, 6348, 307, 10, 70, "Input",
 CellID->238236384],
Cell[173396, 6360, 300, 9, 36, "Output",
 CellID->195166108]
}, Open  ]],
Cell[173711, 6372, 115, 3, 70, "Text",
 CellID->14143327],
Cell[CellGroupData[{
Cell[173851, 6379, 389, 12, 70, "Input",
 CellID->1483695719],
Cell[174243, 6393, 2314, 49, 131, "Output",
 CellID->242088209]
}, Open  ]],
Cell[176572, 6445, 279, 9, 70, "Text",
 CellID->332311740]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176900, 6460, 93, 2, 70, "Section",
 CellTags->{"t:48", "c:96"},
 CellID->1705931980],
Cell[176996, 6464, 1341, 42, 70, "Text",
 CellID->544616763],
Cell[178340, 6508, 165, 5, 70, "NumberedEquation",
 CellID->798632227],
Cell[178508, 6515, 436, 9, 70, "Text",
 CellID->839045439],
Cell[178947, 6526, 274, 9, 70, "NumberedEquation",
 CellID->1459067071],
Cell[179224, 6537, 166, 5, 70, "Text",
 CellID->424497204],
Cell[179393, 6544, 1476, 51, 70, "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->583832294],
Cell[180872, 6597, 90, 2, 70, "Caption",
 CellTags->"S3.7.9",
 CellID->616582115],
Cell[180965, 6601, 72, 1, 70, "Text",
 CellID->1287010030],
Cell[181040, 6604, 282, 10, 70, "Input",
 CellID->1322281626],
Cell[181325, 6616, 67, 1, 70, "Text",
 CellID->1426509026],
Cell[CellGroupData[{
Cell[181417, 6621, 109, 3, 70, "Input",
 CellID->829764874],
Cell[181529, 6626, 257, 8, 36, "Output",
 CellID->99433700]
}, Open  ]],
Cell[181801, 6637, 67, 1, 70, "Text",
 CellID->439918534],
Cell[CellGroupData[{
Cell[181893, 6642, 111, 3, 70, "Input",
 CellID->2072087964],
Cell[182007, 6647, 444, 15, 36, "Output",
 CellID->1987591196]
}, Open  ]],
Cell[182466, 6665, 242, 8, 70, "Text",
 CellID->1337102087],
Cell[CellGroupData[{
Cell[182733, 6677, 186, 6, 70, "Input",
 CellID->1405894001],
Cell[182922, 6685, 612, 20, 36, "Output",
 CellID->97906866]
}, Open  ]],
Cell[183549, 6708, 131, 4, 70, "Text",
 CellID->548223260],
Cell[CellGroupData[{
Cell[183705, 6716, 312, 11, 70, "Input",
 CellID->1283485190],
Cell[184020, 6729, 227, 7, 39, "Output",
 CellID->62354215]
}, Open  ]],
Cell[184262, 6739, 591, 16, 70, "Text",
 CellID->15271769],
Cell[CellGroupData[{
Cell[184878, 6759, 310, 10, 70, "Input",
 CellID->1122067590],
Cell[185191, 6771, 303, 11, 36, "Output",
 CellID->1536080823]
}, Open  ]],
Cell[185509, 6785, 114, 3, 70, "Text",
 CellID->2009471574],
Cell[CellGroupData[{
Cell[185648, 6792, 204, 6, 70, "Input",
 CellID->1860911496],
Cell[185855, 6800, 474, 15, 36, "Output",
 CellID->387678364]
}, Open  ]],
Cell[186344, 6818, 154, 4, 70, "Text",
 CellID->244878750],
Cell[CellGroupData[{
Cell[186523, 6826, 159, 5, 70, "Input",
 CellID->1098483598],
Cell[186685, 6833, 372, 13, 36, "Output",
 CellID->296918327]
}, Open  ]],
Cell[187072, 6849, 184, 4, 70, "Text",
 CellID->1701809908],
Cell[CellGroupData[{
Cell[187281, 6857, 500, 17, 70, "Input",
 CellID->2131913010],
Cell[187784, 6876, 666, 19, 108, "Output",
 CellID->297308875]
}, Open  ]],
Cell[CellGroupData[{
Cell[188487, 6900, 110, 3, 70, "Input",
 CellID->1823299203],
Cell[188600, 6905, 375, 11, 39, "Output",
 CellID->1745545778]
}, Open  ]],
Cell[188990, 6919, 124, 4, 70, "Text",
 CellID->613789179],
Cell[CellGroupData[{
Cell[189139, 6927, 108, 3, 70, "Input",
 CellID->1590774912],
Cell[189250, 6932, 419, 12, 39, "Output",
 CellID->2130024481]
}, Open  ]],
Cell[189684, 6947, 255, 7, 70, "Text",
 CellID->769056677],
Cell[189942, 6956, 1662, 59, 70, "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1978982693],
Cell[191607, 7017, 146, 4, 70, "Text",
 CellID->535396515],
Cell[CellGroupData[{
Cell[191778, 7025, 491, 16, 70, "Input",
 CellID->452746675],
Cell[192272, 7043, 496, 17, 36, "Output",
 CellID->778805404]
}, Open  ]],
Cell[192783, 7063, 67, 1, 70, "Text",
 CellID->469596563],
Cell[CellGroupData[{
Cell[192875, 7068, 132, 4, 70, "Input",
 CellID->507031616],
Cell[193010, 7074, 197, 6, 36, "Output",
 CellID->465258816]
}, Open  ]],
Cell[193222, 7083, 1396, 44, 70, "DefinitionBox3Col",
 CellTags->"S5.27.1",
 CellID->616961785],
Cell[194621, 7129, 220, 9, 70, "Caption",
 CellTags->"S3.7.8",
 CellID->1225672779],
Cell[194844, 7140, 1438, 43, 70, "Text",
 CellID->1219254629],
Cell[CellGroupData[{
Cell[196307, 7187, 94, 2, 70, "Subsection",
 CellTags->{"t:209", "c:97"},
 CellID->723589929],
Cell[196404, 7191, 604, 17, 70, "Text",
 CellID->176043742],
Cell[197011, 7210, 124, 4, 70, "Text",
 CellID->1682189875],
Cell[CellGroupData[{
Cell[197160, 7218, 342, 12, 70, "Input",
 CellID->943016370],
Cell[197505, 7232, 534, 19, 36, "Output",
 CellID->846815730]
}, Open  ]],
Cell[198054, 7254, 286, 6, 70, "Text",
 CellID->1057845441],
Cell[CellGroupData[{
Cell[198365, 7264, 504, 17, 70, "Input",
 CellID->191213374],
Cell[198872, 7283, 581, 20, 36, "Output",
 CellID->1087640906]
}, Open  ]],
Cell[199468, 7306, 250, 5, 70, "Text",
 CellID->599903878],
Cell[CellGroupData[{
Cell[199743, 7315, 483, 16, 70, "Input",
 CellID->148754881],
Cell[200229, 7333, 581, 21, 36, "Output",
 CellID->452319859]
}, Open  ]],
Cell[200825, 7357, 132, 4, 70, "Text",
 CellID->47759833],
Cell[CellGroupData[{
Cell[200982, 7365, 439, 14, 70, "Input",
 CellID->1688112900],
Cell[201424, 7381, 582, 20, 36, "Output",
 CellID->1707049783]
}, Open  ]],
Cell[202021, 7404, 125, 4, 70, "Text",
 CellID->4178961],
Cell[CellGroupData[{
Cell[202171, 7412, 320, 11, 70, "Input",
 CellID->1516320823],
Cell[202494, 7425, 409, 15, 36, "Output",
 CellID->615633212]
}, Open  ]],
Cell[202918, 7443, 163, 4, 70, "Text",
 CellID->371182838],
Cell[CellGroupData[{
Cell[203106, 7451, 407, 14, 70, "Input",
 CellID->29963731],
Cell[203516, 7467, 539, 19, 36, "Output",
 CellID->1089253519]
}, Open  ]],
Cell[204070, 7489, 79, 1, 70, "Text",
 CellID->1933286805],
Cell[CellGroupData[{
Cell[204174, 7494, 134, 4, 70, "Input",
 CellID->1323752525],
Cell[204311, 7500, 432, 14, 39, "Output",
 CellID->378104755]
}, Open  ]],
Cell[204758, 7517, 130, 4, 70, "Text",
 CellID->402505812],
Cell[CellGroupData[{
Cell[204913, 7525, 336, 11, 70, "Input",
 CellID->341694234],
Cell[205252, 7538, 548, 18, 36, "Output",
 CellID->483718760]
}, Open  ]],
Cell[205815, 7559, 134, 4, 70, "Text",
 CellID->1635595425],
Cell[CellGroupData[{
Cell[205974, 7567, 321, 11, 70, "Input",
 CellID->1661626375],
Cell[206298, 7580, 434, 16, 36, "Output",
 CellID->1077139037]
}, Open  ]],
Cell[206747, 7599, 208, 5, 70, "Text",
 CellID->188650649],
Cell[CellGroupData[{
Cell[206980, 7608, 472, 18, 70, "Input",
 CellID->965594771],
Cell[207455, 7628, 909, 25, 54, "Output",
 CellID->217395818]
}, Open  ]],
Cell[208379, 7656, 78, 1, 70, "Text",
 CellID->901829579],
Cell[CellGroupData[{
Cell[208482, 7661, 170, 5, 70, "Input",
 CellID->110153727],
Cell[208655, 7668, 723, 21, 39, "Output",
 CellID->222785975]
}, Open  ]],
Cell[209393, 7692, 126, 4, 70, "Text",
 CellID->1299885104],
Cell[CellGroupData[{
Cell[209544, 7700, 398, 15, 70, "Input",
 CellID->817801997],
Cell[209945, 7717, 889, 24, 54, "Output",
 CellID->902822779]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210883, 7747, 95, 2, 70, "Subsection",
 CellTags->{"t:200", "c:98"},
 CellID->1770480598],
Cell[210981, 7751, 159, 4, 70, "Text",
 CellID->933997754],
Cell[211143, 7757, 285, 9, 70, "NumberedEquation",
 CellID->1742275555],
Cell[CellGroupData[{
Cell[211453, 7770, 608, 20, 65, "Input",
 CellID->1485726040],
Cell[212064, 7792, 691, 15, 63, "Output",
 Evaluatable->False,
 CellID->111591321]
}, Open  ]],
Cell[212770, 7810, 161, 4, 70, "Text",
 CellID->189634261],
Cell[212934, 7816, 272, 6, 70, "Text",
 CellID->317292479],
Cell[CellGroupData[{
Cell[213231, 7826, 715, 24, 70, "Input",
 CellID->532799052],
Cell[213949, 7852, 801, 25, 78, "Output",
 CellID->256827578]
}, Open  ]],
Cell[214765, 7880, 181, 4, 70, "Text",
 CellID->1771364372],
Cell[CellGroupData[{
Cell[214971, 7888, 105, 3, 70, "Input",
 CellID->755201843],
Cell[215079, 7893, 494, 9, 70, "Message",
 CellID->290103530],
Cell[215576, 7904, 475, 16, 36, "Output",
 CellID->31327308]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[216100, 7926, 100, 2, 70, "Subsection",
 CellTags->{"t:153", "c:99"},
 CellID->1937669982],
Cell[216203, 7930, 271, 7, 70, "Text",
 CellID->1977364366],
Cell[216477, 7939, 92, 3, 70, "Text",
 CellID->1253462037],
Cell[216572, 7944, 388, 14, 70, "Input",
 CellID->121878789],
Cell[216963, 7960, 224, 8, 70, "Text",
 CellID->1864891132],
Cell[CellGroupData[{
Cell[217212, 7972, 109, 3, 70, "Input",
 CellID->701427559],
Cell[217324, 7977, 956, 32, 58, "Output",
 CellID->1355245730]
}, Open  ]],
Cell[218295, 8012, 236, 8, 70, "Text",
 CellID->1403424028],
Cell[CellGroupData[{
Cell[218556, 8024, 98, 3, 70, "Input",
 CellID->1534743595],
Cell[218657, 8029, 484, 12, 36, "Output",
 CellID->1009517048]
}, Open  ]],
Cell[219156, 8044, 363, 13, 70, "Text",
 CellID->1832214436],
Cell[CellGroupData[{
Cell[219544, 8061, 171, 5, 70, "Input",
 CellID->1260011519],
Cell[219718, 8068, 2890, 102, 180, "Output",
 CellID->677356766]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[222657, 8176, 96, 2, 70, "Subsection",
 CellTags->{"t:154", "c:100"},
 CellID->524353415],
Cell[222756, 8180, 765, 25, 70, "Text",
 CellID->1682442264],
Cell[223524, 8207, 190, 6, 70, "NumberedEquation",
 CellID->889950999],
Cell[223717, 8215, 78, 1, 70, "Text",
 CellID->182838838],
Cell[223798, 8218, 1401, 50, 70, "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->2070735056],
Cell[225202, 8270, 102, 2, 70, "Caption",
 CellTags->"S3.7.9",
 CellID->724102910],
Cell[225307, 8274, 69, 1, 70, "Text",
 CellID->207780821],
Cell[225379, 8277, 511, 18, 70, "Input",
 CellID->363848525],
Cell[225893, 8297, 79, 1, 70, "Text",
 CellID->1316216666],
Cell[CellGroupData[{
Cell[225997, 8302, 165, 5, 70, "Input",
 CellID->424457715],
Cell[226165, 8309, 247, 8, 39, "Output",
 CellID->2067624318]
}, Open  ]],
Cell[226427, 8320, 143, 4, 70, "Text",
 CellID->2129020519],
Cell[226573, 8326, 484, 18, 70, "Input",
 CellID->1075336519],
Cell[227060, 8346, 97, 1, 70, "Text",
 CellID->2105985328],
Cell[CellGroupData[{
Cell[227182, 8351, 108, 3, 70, "Input",
 CellID->469937842],
Cell[227293, 8356, 232, 8, 36, "Output",
 CellID->1947940475]
}, Open  ]],
Cell[CellGroupData[{
Cell[227562, 8369, 108, 3, 70, "Input",
 CellID->647364810],
Cell[227673, 8374, 232, 8, 36, "Output",
 CellID->1108205968]
}, Open  ]],
Cell[227920, 8385, 224, 8, 70, "Text",
 CellID->492033745],
Cell[CellGroupData[{
Cell[228169, 8397, 166, 5, 70, "Input",
 CellID->1799111265],
Cell[228338, 8404, 219, 7, 36, "Output",
 CellID->1093281095]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[228606, 8417, 80, 2, 70, "Subsection",
 CellTags->{"t:155", "c:101"},
 CellID->905279933],
Cell[228689, 8421, 481, 14, 70, "Text",
 CellID->118194936],
Cell[229173, 8437, 1333, 37, 70, "Text",
 CellID->79915877],
Cell[230509, 8476, 91, 1, 70, "Text",
 CellID->968865364],
Cell[CellGroupData[{
Cell[230625, 8481, 83, 2, 70, "Subsubsection",
 CellTags->{"t:157", "c:102"},
 CellID->1499161194],
Cell[230711, 8485, 632, 12, 70, "Text",
 CellID->2124040954],
Cell[231346, 8499, 262, 7, 70, "Text",
 CellID->1135649797],
Cell[231611, 8508, 390, 13, 70, "Input",
 CellID->31483643],
Cell[CellGroupData[{
Cell[232026, 8525, 159, 6, 70, "Input",
 CellID->864610739],
Cell[232188, 8533, 257, 9, 36, "Output",
 CellID->1638334771]
}, Open  ]],
Cell[CellGroupData[{
Cell[232482, 8547, 163, 6, 70, "Input",
 CellID->457174363],
Cell[232648, 8555, 256, 9, 36, "Output",
 CellID->33029975]
}, Open  ]],
Cell[232919, 8567, 173, 4, 70, "Text",
 CellID->1084008899]
}, Open  ]],
Cell[CellGroupData[{
Cell[233129, 8576, 84, 2, 70, "Subsubsection",
 CellTags->{"t:158", "c:103"},
 CellID->1833787992],
Cell[233216, 8580, 431, 9, 70, "Text",
 CellID->1936963447],
Cell[233650, 8591, 190, 6, 70, "NumberedEquation",
 CellID->840048856],
Cell[233843, 8599, 574, 16, 70, "Text",
 CellID->1143627414],
Cell[234420, 8617, 495, 17, 70, "NumberedEquation",
 CellID->967306448],
Cell[234918, 8636, 104, 3, 70, "Text",
 CellID->1068263746],
Cell[235025, 8641, 106, 3, 70, "Text",
 CellID->1345490102],
Cell[235134, 8646, 1541, 46, 70, "DefinitionBox3Col",
 CellTags->"S5.27.1",
 CellID->649341404],
Cell[236678, 8694, 96, 2, 70, "Caption",
 CellTags->"S3.7.9",
 CellID->2116566621],
Cell[236777, 8698, 70, 1, 70, "Text",
 CellID->68586592],
Cell[236850, 8701, 448, 15, 70, "Input",
 CellID->1683616952],
Cell[237301, 8718, 128, 4, 70, "Text",
 CellID->1305579392],
Cell[CellGroupData[{
Cell[237454, 8726, 183, 5, 70, "Input",
 CellID->2032419945],
Cell[237640, 8733, 181, 6, 36, "Output",
 CellID->75266656]
}, Open  ]],
Cell[237836, 8742, 76, 1, 70, "Text",
 CellID->307853777],
Cell[CellGroupData[{
Cell[237937, 8747, 276, 8, 70, "Input",
 CellID->810324416],
Cell[238216, 8757, 182, 6, 36, "Output",
 CellID->404007190]
}, Open  ]],
Cell[238413, 8766, 111, 3, 70, "Text",
 CellID->771038777],
Cell[CellGroupData[{
Cell[238549, 8773, 271, 8, 70, "Input",
 CellID->932399041],
Cell[238823, 8783, 367, 7, 70, "Message",
 CellID->82235877],
Cell[239193, 8792, 704, 23, 36, "Output",
 CellID->444146888]
}, Open  ]],
Cell[239912, 8818, 200, 4, 70, "Text",
 CellID->1694675974],
Cell[CellGroupData[{
Cell[240137, 8826, 784, 26, 70, "Input",
 CellID->343484857],
Cell[240924, 8854, 582, 10, 70, "Message",
 CellID->211583067],
Cell[241509, 8866, 310, 10, 36, "Output",
 CellID->140682982]
}, Open  ]],
Cell[241834, 8879, 227, 5, 70, "Text",
 CellID->91482619],
Cell[CellGroupData[{
Cell[242086, 8888, 316, 10, 70, "Input",
 CellID->2097569928],
Cell[242405, 8900, 339, 11, 36, "Output",
 CellID->766230744]
}, Open  ]],
Cell[242759, 8914, 125, 4, 70, "Text",
 CellID->1728166996],
Cell[CellGroupData[{
Cell[242909, 8922, 328, 10, 70, "Input",
 CellID->586376097],
Cell[243240, 8934, 337, 11, 36, "Output",
 CellID->420606196]
}, Open  ]],
Cell[243592, 8948, 364, 7, 70, "Text",
 CellID->1759653895],
Cell[CellGroupData[{
Cell[243981, 8959, 383, 11, 70, "Input",
 CellID->1505710428],
Cell[244367, 8972, 338, 11, 36, "Output",
 CellID->527867148]
}, Open  ]],
Cell[244720, 8986, 256, 5, 70, "Text",
 CellID->608210679],
Cell[CellGroupData[{
Cell[245001, 8995, 253, 8, 70, "Input",
 CellID->174722233],
Cell[245257, 9005, 339, 11, 36, "Output",
 CellID->946424582]
}, Open  ]],
Cell[245611, 9019, 169, 4, 70, "Text",
 CellID->146576345]
}, Open  ]],
Cell[CellGroupData[{
Cell[245817, 9028, 92, 2, 70, "Subsubsection",
 CellTags->{"t:159", "c:104"},
 CellID->344887306],
Cell[245912, 9032, 132, 4, 70, "Text",
 CellID->462588689]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[246105, 9043, 90, 2, 70, "Section",
 CellTags->{"t:51", "c:105"},
 CellID->837293883],
Cell[246198, 9047, 327, 6, 70, "Text",
 CellID->2085436437],
Cell[CellGroupData[{
Cell[246550, 9057, 88, 2, 70, "Subsection",
 CellTags->{"t:53", "c:106"},
 CellID->849593972],
Cell[246641, 9061, 1122, 28, 70, "Text",
 CellID->507118501],
Cell[247766, 9091, 472, 16, 70, "Text",
 CellID->1925535011],
Cell[248241, 9109, 169, 5, 70, "NumberedEquation",
 CellID->2035853234],
Cell[248413, 9116, 487, 13, 70, "Text",
 CellID->728356187],
Cell[248903, 9131, 221, 6, 70, "NumberedEquation",
 CellID->825647009],
Cell[249127, 9139, 177, 6, 70, "Text",
 CellID->1757436996],
Cell[249307, 9147, 211, 6, 70, "NumberedEquation",
 CellID->753510934],
Cell[249521, 9155, 164, 6, 70, "Text",
 CellID->547201379],
Cell[249688, 9163, 174, 5, 70, "NumberedEquation",
 CellID->1288600399],
Cell[249865, 9170, 279, 9, 70, "Text",
 CellID->134325998],
Cell[250147, 9181, 458, 15, 70, "Text",
 CellID->611735389],
Cell[250608, 9198, 324, 10, 70, "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1432464734],
Cell[250935, 9210, 542, 12, 70, "Text",
 CellTags->{"S0.1574", "LUDecomposition"},
 CellID->2143101468],
Cell[251480, 9224, 255, 8, 70, "Text",
 CellID->1510645192],
Cell[CellGroupData[{
Cell[251760, 9236, 513, 16, 70, "Input",
 CellID->1862067110],
Cell[252276, 9254, 640, 20, 36, "Output",
 CellID->482730039]
}, Open  ]],
Cell[252931, 9277, 688, 17, 70, "Text",
 CellID->50547107],
Cell[253622, 9296, 148, 6, 70, "Text",
 CellID->1289186784],
Cell[CellGroupData[{
Cell[253795, 9306, 930, 31, 70, "Input",
 CellID->1399764105],
Cell[254728, 9339, 401, 13, 78, "Output",
 CellID->151959850]
}, Open  ]],
Cell[255144, 9355, 147, 6, 70, "Text",
 CellID->631142667],
Cell[CellGroupData[{
Cell[255316, 9365, 681, 22, 70, "Input",
 CellID->1193071736],
Cell[256000, 9389, 429, 14, 78, "Output",
 CellID->901854913]
}, Open  ]],
Cell[256444, 9406, 353, 10, 70, "Text",
 CellID->535942265],
Cell[CellGroupData[{
Cell[256822, 9420, 96, 3, 70, "Input",
 CellID->1035232337],
Cell[256921, 9425, 426, 13, 36, "Output",
 CellID->237379965]
}, Open  ]],
Cell[257362, 9441, 322, 10, 70, "Text",
 CellID->1767939276],
Cell[CellGroupData[{
Cell[257709, 9455, 150, 5, 70, "Input",
 CellID->1171671840],
Cell[257862, 9462, 457, 15, 39, "Output",
 CellID->2011055537]
}, Open  ]],
Cell[258334, 9480, 470, 13, 70, "Text",
 CellID->565290226],
Cell[CellGroupData[{
Cell[258829, 9497, 436, 13, 70, "Input",
 CellID->365174054],
Cell[259268, 9512, 440, 9, 70, "Message",
 CellID->2119546099],
Cell[259711, 9523, 553, 18, 36, "Output",
 CellID->752549457]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[260313, 9547, 96, 2, 70, "Subsection",
 CellTags->{"t:194", "c:107"},
 CellID->1567526616],
Cell[260412, 9551, 316, 9, 70, "Text",
 CellID->90453716],
Cell[260731, 9562, 174, 6, 70, "NumberedEquation",
 CellID->1984666383],
Cell[260908, 9570, 1084, 25, 70, "Text",
 CellID->1571893877],
Cell[261995, 9597, 321, 11, 70, "Text",
 CellID->476565345],
Cell[262319, 9610, 321, 10, 70, "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1667233752],
Cell[CellGroupData[{
Cell[262665, 9624, 426, 14, 70, "Input",
 CellID->831043808],
Cell[263094, 9640, 385, 12, 63, "Output",
 CellID->119640968]
}, Open  ]],
Cell[263494, 9655, 74, 1, 70, "Text",
 CellID->761055584],
Cell[CellGroupData[{
Cell[263593, 9660, 134, 4, 70, "Input",
 CellID->648598756],
Cell[263730, 9666, 357, 11, 36, "Output",
 CellID->372299920]
}, Open  ]],
Cell[264102, 9680, 133, 4, 70, "Text",
 CellID->1624891729],
Cell[CellGroupData[{
Cell[264260, 9688, 334, 11, 70, "Input",
 CellID->5750404],
Cell[264597, 9701, 584, 12, 70, "Message",
 CellID->10275913],
Cell[265184, 9715, 364, 12, 36, "Output",
 CellID->908578031]
}, Open  ]],
Cell[265563, 9730, 157, 4, 70, "Text",
 CellID->1862236847],
Cell[CellGroupData[{
Cell[265745, 9738, 326, 11, 70, "Input",
 CellID->1188016151],
Cell[266074, 9751, 242, 8, 36, "Output",
 CellID->1831983698]
}, Open  ]],
Cell[266331, 9762, 143, 4, 70, "Text",
 CellID->1676965247],
Cell[266477, 9768, 212, 5, 70, "Text",
 CellID->1179523101],
Cell[CellGroupData[{
Cell[266714, 9777, 466, 16, 70, "Input",
 CellID->823213050],
Cell[267183, 9795, 730, 20, 36, "Output",
 CellID->1652077376]
}, Open  ]],
Cell[267928, 9818, 89, 1, 70, "Text",
 CellID->1648386369],
Cell[CellGroupData[{
Cell[268042, 9823, 211, 7, 70, "Input",
 CellID->1890657483],
Cell[268256, 9832, 701, 20, 63, "Output",
 CellID->2112275769]
}, Open  ]],
Cell[CellGroupData[{
Cell[268994, 9857, 106, 2, 70, "Subsubsection",
 CellTags->{"t:210", "c:108"},
 CellID->966681026],
Cell[269103, 9861, 109, 3, 70, "Text",
 CellID->1294214427],
Cell[269215, 9866, 189, 6, 70, "NumberedEquation",
 CellID->14126],
Cell[269407, 9874, 197, 6, 70, "Text",
 CellID->237415682],
Cell[CellGroupData[{
Cell[269629, 9884, 588, 19, 70, "Input",
 CellID->220751248],
Cell[270220, 9905, 386, 12, 63, "Output",
 CellID->1461966767]
}, Open  ]],
Cell[270621, 9920, 153, 6, 70, "Text",
 CellID->1915047642],
Cell[CellGroupData[{
Cell[270799, 9930, 930, 31, 70, "Input",
 CellID->1868301505],
Cell[271732, 9963, 331, 12, 63, "Output",
 CellID->37508101]
}, Open  ]],
Cell[272078, 9978, 77, 1, 70, "Text",
 CellID->1185944936],
Cell[CellGroupData[{
Cell[272180, 9983, 448, 15, 70, "Input",
 CellID->1380811545],
Cell[272631, 10000, 338, 12, 63, "Output",
 CellID->1591347333]
}, Open  ]],
Cell[272984, 10015, 317, 12, 70, "Text",
 CellID->1013285993],
Cell[CellGroupData[{
Cell[273326, 10031, 223, 8, 70, "Input",
 CellID->752363641],
Cell[273552, 10041, 386, 12, 63, "Output",
 CellID->592000751]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[273999, 10060, 90, 2, 70, "Subsection",
 CellTags->{"t:195", "c:109"},
 CellID->464885506],
Cell[274092, 10064, 371, 12, 70, "Text",
 CellID->785191556],
Cell[274466, 10078, 397, 14, 70, "NumberedEquation",
 CellID->427470877],
Cell[274866, 10094, 301, 11, 70, "Text",
 CellID->565059398],
Cell[275170, 10107, 599, 20, 70, "DefinitionBox",
 CellTags->"S5.49.1",
 CellID->1409177642],
Cell[275772, 10129, 229, 8, 70, "Text",
 CellID->458374344],
Cell[276004, 10139, 404, 14, 70, "Input",
 CellID->873757819],
Cell[276411, 10155, 118, 3, 70, "Text",
 CellID->754485747],
Cell[CellGroupData[{
Cell[276554, 10162, 649, 21, 70, "Input",
 CellID->1898497941],
Cell[277206, 10185, 3943, 71, 221, 190, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->357870145]
}, Open  ]],
Cell[281164, 10259, 72, 1, 70, "Text",
 CellID->2047615616],
Cell[CellGroupData[{
Cell[281261, 10264, 254, 8, 70, "Input",
 CellID->850214937],
Cell[281518, 10274, 646, 19, 54, "Output",
 CellID->19652830]
}, Open  ]],
Cell[282179, 10296, 95, 1, 70, "Text",
 CellID->556759689],
Cell[CellGroupData[{
Cell[282299, 10301, 648, 21, 70, "Input",
 CellID->873843044],
Cell[282950, 10324, 4092, 75, 237, 359, 9, "CachedBoxData", "BoxData", \
"Output",
 CellID->149302701]
}, Open  ]],
Cell[287057, 10402, 274, 9, 70, "Text",
 CellID->412427449],
Cell[CellGroupData[{
Cell[287356, 10415, 229, 8, 70, "Input",
 CellID->1738406474],
Cell[287588, 10425, 235, 7, 36, "Output",
 CellID->204635167]
}, Open  ]],
Cell[287838, 10435, 111, 3, 70, "Text",
 CellID->1038782152],
Cell[CellGroupData[{
Cell[287974, 10442, 95, 3, 70, "Input",
 CellID->1917062201],
Cell[288072, 10447, 199, 6, 36, "Output",
 CellID->304936810]
}, Open  ]],
Cell[288286, 10456, 227, 8, 70, "Text",
 CellID->1401039762],
Cell[CellGroupData[{
Cell[288538, 10468, 310, 10, 70, "Input",
 CellID->117090579],
Cell[288851, 10480, 412, 13, 36, "Output",
 CellID->11904355]
}, Open  ]],
Cell[289278, 10496, 160, 4, 70, "Text",
 CellID->129867270],
Cell[289441, 10502, 202, 7, 70, "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->45083515],
Cell[289646, 10511, 65, 1, 70, "Caption",
 CellID->459960165],
Cell[289714, 10514, 108, 5, 70, "Text",
 CellID->384226275],
Cell[CellGroupData[{
Cell[289847, 10523, 240, 7, 70, "Input",
 CellID->274127522],
Cell[290090, 10532, 671, 20, 54, "Output",
 CellID->337018741]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[290810, 10558, 90, 2, 70, "Subsection",
 CellTags->{"t:196", "c:110"},
 CellID->1662286926],
Cell[290903, 10562, 391, 12, 70, "Text",
 CellID->1441601459],
Cell[291297, 10576, 157, 5, 70, "NumberedEquation",
 CellID->1085215959],
Cell[291457, 10583, 586, 20, 70, "Text",
 CellID->646008942],
Cell[292046, 10605, 314, 10, 70, "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1942452609],
Cell[292363, 10617, 142, 4, 70, "Text",
 CellID->754597769],
Cell[CellGroupData[{
Cell[292530, 10625, 414, 14, 70, "Input",
 CellID->1633768048],
Cell[292947, 10641, 789, 27, 54, "Output",
 CellID->1013672194]
}, Open  ]],
Cell[293751, 10671, 285, 7, 70, "Text",
 CellID->800792907],
Cell[CellGroupData[{
Cell[294061, 10682, 290, 9, 70, "Input",
 CellID->646372200],
Cell[294354, 10693, 821, 27, 49, "Output",
 CellID->1605278874]
}, Open  ]],
Cell[295190, 10723, 263, 10, 70, "Text",
 CellID->1084978057],
Cell[CellGroupData[{
Cell[295478, 10737, 98, 3, 70, "Input",
 CellID->942557322],
Cell[295579, 10742, 357, 11, 36, "Output",
 CellID->1721530582]
}, Open  ]],
Cell[295951, 10756, 484, 13, 70, "Text",
 CellID->717315643],
Cell[CellGroupData[{
Cell[296460, 10773, 257, 9, 70, "Input",
 CellID->2098301290],
Cell[296720, 10784, 181, 5, 36, "Output",
 CellID->173329996]
}, Open  ]],
Cell[CellGroupData[{
Cell[296938, 10794, 257, 9, 70, "Input",
 CellID->1169417440],
Cell[297198, 10805, 176, 5, 36, "Output",
 CellID->628576736]
}, Open  ]],
Cell[297389, 10813, 234, 8, 70, "Text",
 CellID->1017142359],
Cell[CellGroupData[{
Cell[297648, 10825, 676, 22, 70, "Input",
 CellID->1141797593],
Cell[298327, 10849, 915, 29, 49, "Output",
 CellID->278275959]
}, Open  ]],
Cell[299257, 10881, 1773, 60, 70, "Text",
 CellID->1912143394],
Cell[CellGroupData[{
Cell[301055, 10945, 716, 23, 70, "Input",
 CellID->301245603],
Cell[301774, 10970, 877, 28, 64, "Output",
 CellID->1415893642]
}, Open  ]],
Cell[302666, 11001, 577, 15, 70, "Text",
 CellID->658148687],
Cell[303246, 11018, 1191, 35, 70, "Input",
 CellID->1964200359],
Cell[304440, 11055, 450, 17, 70, "Text",
 CellID->1196812029],
Cell[CellGroupData[{
Cell[304915, 11076, 721, 23, 70, "Input",
 CellID->1487933601],
Cell[305639, 11101, 994, 31, 64, "Output",
 CellID->252962692]
}, Open  ]],
Cell[CellGroupData[{
Cell[306670, 11137, 100, 3, 70, "Input",
 CellID->1673827031],
Cell[306773, 11142, 437, 13, 36, "Output",
 CellID->2122617964]
}, Open  ]],
Cell[CellGroupData[{
Cell[307247, 11160, 104, 2, 70, "Subsubsection",
 CellTags->{"t:199", "c:111"},
 CellID->841776984],
Cell[307354, 11164, 530, 14, 70, "Text",
 CellID->123503652],
Cell[307887, 11180, 323, 7, 70, "Text",
 CellID->1256676162],
Cell[308213, 11189, 233, 8, 70, "NumberedEquation",
 CellID->454586489],
Cell[308449, 11199, 254, 11, 70, "Text",
 CellID->1635788244],
Cell[308706, 11212, 448, 14, 70, "NumberedEquation",
 CellID->607368014],
Cell[309157, 11228, 74, 1, 70, "Text",
 CellID->1044437107],
Cell[309234, 11231, 313, 10, 70, "NumberedEquation",
 CellID->323126771],
Cell[309550, 11243, 203, 9, 70, "Text",
 CellID->1952980581],
Cell[309756, 11254, 238, 7, 70, "NumberedEquation",
 CellID->1604564119],
Cell[309997, 11263, 380, 11, 70, "Text",
 CellID->1956992654]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[310426, 11280, 101, 2, 70, "Subsection",
 CellTags->{"t:197", "c:112"},
 CellID->315998326],
Cell[310530, 11284, 471, 15, 70, "Text",
 CellID->256806051],
Cell[311004, 11301, 181, 5, 70, "NumberedEquation",
 CellID->1844652334],
Cell[311188, 11308, 720, 22, 70, "Text",
 CellID->1997849446],
Cell[311911, 11332, 764, 25, 70, "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1948818077],
Cell[CellGroupData[{
Cell[312700, 11361, 339, 11, 70, "Input",
 CellID->364836095],
Cell[313042, 11374, 241, 8, 36, "Output",
 CellID->734436480]
}, Open  ]],
Cell[CellGroupData[{
Cell[313320, 11387, 414, 12, 70, "Input",
 CellID->2085400051],
Cell[313737, 11401, 1063, 34, 49, "Output",
 CellID->238054470]
}, Open  ]],
Cell[314815, 11438, 107, 3, 70, "Text",
 CellID->219442929],
Cell[CellGroupData[{
Cell[314947, 11445, 181, 5, 70, "Input",
 CellID->947885804],
Cell[315131, 11452, 400, 12, 63, "Output",
 CellID->1083014382]
}, Open  ]],
Cell[315546, 11467, 381, 11, 70, "Text",
 CellID->151326302],
Cell[CellGroupData[{
Cell[315952, 11482, 183, 6, 70, "Input",
 CellID->720519666],
Cell[316138, 11490, 432, 13, 68, "Output",
 CellID->113741029]
}, Open  ]],
Cell[316585, 11506, 116, 3, 70, "Text",
 CellID->385028573],
Cell[CellGroupData[{
Cell[316726, 11513, 504, 16, 70, "Input",
 CellID->806998000],
Cell[317233, 11531, 354, 12, 63, "Output",
 CellID->1856155195]
}, Open  ]],
Cell[317602, 11546, 241, 9, 70, "Text",
 CellID->2052906043],
Cell[CellGroupData[{
Cell[317868, 11559, 117, 3, 70, "Input",
 CellID->1719591999],
Cell[317988, 11564, 199, 6, 36, "Output",
 CellID->347805867]
}, Open  ]],
Cell[318202, 11573, 162, 4, 70, "Text",
 CellID->122719535],
Cell[318367, 11579, 840, 19, 70, "Text",
 CellID->962923625],
Cell[319210, 11600, 267, 7, 70, "Text",
 CellID->420601583],
Cell[319480, 11609, 1782, 59, 70, "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1682123204],
Cell[321265, 11670, 175, 4, 70, "Text",
 CellID->1969960520],
Cell[CellGroupData[{
Cell[321465, 11678, 383, 13, 70, "Input",
 CellID->1371073841],
Cell[321851, 11693, 184, 6, 36, "Output",
 CellID->1138513377]
}, Open  ]],
Cell[CellGroupData[{
Cell[322072, 11704, 103, 2, 70, "Subsubsection",
 CellTags->{"t:211", "c:113"},
 CellID->915032469],
Cell[322178, 11708, 515, 19, 70, "Text",
 CellID->820310316],
Cell[322696, 11729, 402, 11, 70, "NumberedEquation",
 CellID->110467272],
Cell[323101, 11742, 835, 33, 70, "Text",
 CellID->1197569496],
Cell[323939, 11777, 1002, 32, 70, "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->1333779588],
Cell[324944, 11811, 68, 1, 70, "Text",
 CellID->1399228130],
Cell[325015, 11814, 488, 18, 70, "Input",
 CellID->1881246260],
Cell[325506, 11834, 210, 7, 70, "Text",
 CellID->704157039],
Cell[CellGroupData[{
Cell[325741, 11845, 172, 5, 70, "Input",
 CellID->2132459503],
Cell[325916, 11852, 244, 8, 36, "Output",
 CellID->892282138]
}, Open  ]],
Cell[326175, 11863, 231, 8, 70, "Text",
 CellID->707586365],
Cell[326409, 11873, 403, 13, 70, "Input",
 CellID->1787083116],
Cell[326815, 11888, 133, 5, 70, "Text",
 CellID->799643670],
Cell[CellGroupData[{
Cell[326973, 11897, 179, 5, 70, "Input",
 CellID->658498764],
Cell[327155, 11904, 369, 12, 63, "Output",
 CellID->1405493557]
}, Open  ]],
Cell[327539, 11919, 134, 5, 70, "Text",
 CellID->1957579146],
Cell[CellGroupData[{
Cell[327698, 11928, 180, 5, 70, "Input",
 CellID->1583234782],
Cell[327881, 11935, 385, 12, 63, "Output",
 CellID->2104594744]
}, Open  ]],
Cell[328281, 11950, 136, 4, 70, "Text",
 CellID->720712671],
Cell[CellGroupData[{
Cell[328442, 11958, 207, 7, 70, "Input",
 CellID->1210092417],
Cell[328652, 11967, 245, 8, 36, "Output",
 CellID->1353115429]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[328946, 11981, 84, 2, 70, "Subsubsection",
 CellTags->{"t:212", "c:114"},
 CellID->2106677120],
Cell[329033, 11985, 521, 18, 70, "Text",
 CellID->1359467751],
Cell[329557, 12005, 622, 18, 70, "DefinitionBox3Col",
 CellTags->"S5.27.1",
 CellID->1495970624],
Cell[330182, 12025, 765, 23, 70, "Text",
 CellID->39738492],
Cell[330950, 12050, 212, 5, 70, "Text",
 CellID->17420827],
Cell[CellGroupData[{
Cell[331187, 12059, 470, 16, 70, "Input",
 CellID->734063397],
Cell[331660, 12077, 248, 8, 39, "Output",
 CellID->109961364]
}, Open  ]],
Cell[331923, 12088, 148, 4, 70, "Text",
 CellID->1284708328],
Cell[CellGroupData[{
Cell[332096, 12096, 226, 7, 70, "Input",
 CellID->1292281758],
Cell[332325, 12105, 199, 6, 36, "Output",
 CellID->1877384595]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[332585, 12118, 92, 2, 70, "Subsection",
 CellTags->{"t:181", "c:115"},
 CellID->225662794],
Cell[332680, 12122, 808, 21, 70, "Text",
 CellID->258458156],
Cell[333491, 12145, 184, 6, 70, "NumberedEquation",
 CellID->1694293658],
Cell[333678, 12153, 477, 12, 70, "Text",
 CellID->360350786],
Cell[334158, 12167, 322, 10, 70, "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->511775762],
Cell[334483, 12179, 145, 4, 70, "Text",
 CellID->743225699],
Cell[CellGroupData[{
Cell[334653, 12187, 568, 19, 70, "Input",
 CellID->1629432141],
Cell[335224, 12208, 727, 25, 49, "Output",
 CellID->1154527243]
}, Open  ]],
Cell[335966, 12236, 303, 10, 70, "Text",
 CellID->1624622456],
Cell[CellGroupData[{
Cell[336294, 12250, 184, 6, 70, "Input",
 CellID->1922530034],
Cell[336481, 12258, 359, 13, 63, "Output",
 CellID->923328676]
}, Open  ]],
Cell[336855, 12274, 191, 4, 70, "Text",
 CellID->668224310],
Cell[CellGroupData[{
Cell[337071, 12282, 372, 11, 70, "Input",
 CellID->1653988007],
Cell[337446, 12295, 360, 13, 63, "Output",
 CellID->1548106881]
}, Open  ]],
Cell[337821, 12311, 128, 4, 70, "Text",
 CellID->120481915],
Cell[CellGroupData[{
Cell[337974, 12319, 606, 18, 70, "Input",
 CellID->2009949931],
Cell[338583, 12339, 376, 8, 70, "Message",
 CellID->1310723007],
Cell[338962, 12349, 539, 17, 39, "Output",
 CellID->434327723]
}, Open  ]],
Cell[339516, 12369, 147, 4, 70, "Text",
 CellID->449124308],
Cell[CellGroupData[{
Cell[339688, 12377, 351, 11, 70, "Input",
 CellID->27225351],
Cell[340042, 12390, 655, 23, 64, "Output",
 CellID->162457446]
}, Open  ]],
Cell[340712, 12416, 88, 1, 70, "Text",
 CellID->970579585],
Cell[CellGroupData[{
Cell[340825, 12421, 347, 12, 70, "Input",
 CellID->245302483],
Cell[341175, 12435, 378, 11, 36, "Output",
 CellID->1777713188]
}, Open  ]],
Cell[341568, 12449, 184, 6, 70, "Text",
 CellID->85570005],
Cell[CellGroupData[{
Cell[341777, 12459, 347, 11, 70, "Input",
 CellID->1508514192],
Cell[342127, 12472, 591, 22, 49, "Output",
 CellID->406088462]
}, Open  ]],
Cell[342733, 12497, 709, 16, 70, "Text",
 CellID->425750668],
Cell[CellGroupData[{
Cell[343467, 12517, 184, 6, 70, "Input",
 CellID->175965272],
Cell[343654, 12525, 360, 13, 63, "Output",
 CellID->363344585]
}, Open  ]],
Cell[344029, 12541, 249, 5, 70, "Text",
 CellID->1436431674],
Cell[CellGroupData[{
Cell[344303, 12550, 620, 21, 70, "Input",
 CellID->95985344],
Cell[344926, 12573, 1549, 42, 77, "Output",
 CellID->465457711]
}, Open  ]],
Cell[346490, 12618, 133, 4, 70, "Text",
 CellID->1812306403],
Cell[CellGroupData[{
Cell[346648, 12626, 254, 8, 70, "Input",
 CellID->1673149820],
Cell[346905, 12636, 477, 14, 63, "Output",
 CellID->1478150922]
}, Open  ]],
Cell[347397, 12653, 236, 9, 70, "Text",
 CellID->1191717558],
Cell[CellGroupData[{
Cell[347658, 12666, 111, 3, 70, "Input",
 CellID->1764505384],
Cell[347772, 12671, 443, 13, 36, "Output",
 CellID->1440307465]
}, Open  ]],
Cell[CellGroupData[{
Cell[348252, 12689, 96, 2, 70, "Subsubsection",
 CellTags->"c:116",
 CellID->811895271],
Cell[348351, 12693, 360, 13, 70, "Text",
 CellID->412726659],
Cell[348714, 12708, 323, 9, 70, "NumberedEquation",
 CellID->324778003],
Cell[349040, 12719, 406, 15, 70, "Text",
 CellID->1787949394],
Cell[349449, 12736, 529, 17, 70, "DefinitionBox",
 CellTags->"S3.7.9",
 CellID->326792487],
Cell[349981, 12755, 68, 1, 70, "Text",
 CellID->1285643630],
Cell[350052, 12758, 488, 18, 70, "Input",
 CellID->1979516943],
Cell[350543, 12778, 85, 1, 70, "Text",
 CellID->924601677],
Cell[CellGroupData[{
Cell[350653, 12783, 276, 8, 70, "Input",
 CellID->588715647],
Cell[350932, 12793, 1283, 42, 88, "Output",
 CellID->1086717400]
}, Open  ]],
Cell[352230, 12838, 132, 4, 70, "Text",
 CellID->110924065],
Cell[CellGroupData[{
Cell[352387, 12846, 181, 5, 70, "Input",
 CellID->284954859],
Cell[352571, 12853, 399, 12, 63, "Output",
 CellID->347782403]
}, Open  ]],
Cell[CellGroupData[{
Cell[353007, 12870, 182, 5, 70, "Input",
 CellID->1875843734],
Cell[353192, 12877, 399, 12, 63, "Output",
 CellID->98215731]
}, Open  ]],
Cell[353606, 12892, 208, 6, 70, "Text",
 CellID->1444350021]
}, Open  ]],
Cell[CellGroupData[{
Cell[353851, 12903, 82, 2, 70, "Subsubsection",
 CellTags->{"t:231", "c:117"},
 CellID->35657259],
Cell[353936, 12907, 209, 7, 70, "Text",
 CellID->143614500],
Cell[354148, 12916, 753, 22, 70, "DefinitionBox3Col",
 CellTags->"S5.27.1",
 CellID->2104765919],
Cell[354904, 12940, 234, 9, 70, "Caption",
 CellTags->"S3.7.8",
 CellID->1450167249],
Cell[355141, 12951, 650, 18, 70, "Text",
 CellID->1169044140],
Cell[355794, 12971, 251, 8, 70, "NumberedEquation",
 CellID->796974577],
Cell[356048, 12981, 430, 12, 70, "Text",
 CellID->896209300],
Cell[CellGroupData[{
Cell[356503, 12997, 979, 31, 70, "Input",
 CellID->139405042],
Cell[357485, 13030, 1416, 41, 123, "Output",
 CellID->75882017]
}, Open  ]],
Cell[358916, 13074, 110, 3, 70, "Text",
 CellID->1891257048],
Cell[CellGroupData[{
Cell[359051, 13081, 246, 7, 70, "Input",
 CellID->1451746489],
Cell[359300, 13090, 613, 16, 86, "Output",
 CellID->1941527056]
}, Open  ]],
Cell[359928, 13109, 239, 9, 70, "Text",
 CellID->231214027],
Cell[CellGroupData[{
Cell[360192, 13122, 110, 3, 70, "Input",
 CellID->1216234366],
Cell[360305, 13127, 314, 9, 39, "Output",
 CellID->1501637216]
}, Open  ]],
Cell[360634, 13139, 424, 12, 70, "Text",
 CellID->788869768],
Cell[CellGroupData[{
Cell[361083, 13155, 262, 8, 70, "Input",
 CellID->2117637845],
Cell[361348, 13165, 551, 16, 80, "Output",
 CellID->892779184]
}, Open  ]],
Cell[361914, 13184, 775, 20, 70, "Text",
 CellID->471503899],
Cell[CellGroupData[{
Cell[362714, 13208, 414, 13, 70, "Input",
 CellID->351373063],
Cell[363131, 13223, 444, 12, 36, "Output",
 CellID->2094524238]
}, Open  ]],
Cell[363590, 13238, 514, 19, 70, "Text",
 CellID->1116926442],
Cell[CellGroupData[{
Cell[364129, 13261, 425, 13, 70, "Input",
 CellID->1028152267],
Cell[364557, 13276, 1532, 41, 49, "Output",
 CellID->1501727707]
}, Open  ]],
Cell[366104, 13320, 174, 8, 70, "Text",
 CellID->162268358],
Cell[CellGroupData[{
Cell[366303, 13332, 255, 8, 70, "Input",
 CellID->2087544863],
Cell[366561, 13342, 705, 19, 63, "Output",
 CellID->1926171402]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[367327, 13368, 94, 2, 70, "Subsection",
 CellTags->{"t:228", "c:118"},
 CellID->1994258536],
Cell[367424, 13372, 571, 16, 70, "Text",
 CellID->1725935823],
Cell[367998, 13390, 205, 7, 70, "NumberedEquation",
 CellID->1741757132],
Cell[368206, 13399, 212, 5, 70, "Text",
 CellID->1362525267],
Cell[368421, 13406, 326, 10, 70, "DefinitionBox",
 CellTags->"S3.7.10",
 CellID->1344034508],
Cell[368750, 13418, 91, 1, 70, "Text",
 CellID->1954976810],
Cell[CellGroupData[{
Cell[368866, 13423, 1331, 41, 70, "Input",
 CellID->795446570],
Cell[370200, 13466, 783, 28, 122, "Output",
 CellID->984799415]
}, Open  ]],
Cell[370998, 13497, 250, 5, 70, "Text",
 CellID->867300476],
Cell[CellGroupData[{
Cell[371273, 13506, 106, 3, 70, "Input",
 CellID->1747587943],
Cell[371382, 13511, 562, 18, 122, "Output",
 CellID->576717982]
}, Open  ]],
Cell[371959, 13532, 398, 7, 70, "Text",
 CellID->1305424563],
Cell[CellGroupData[{
Cell[372382, 13543, 110, 3, 70, "Input",
 CellID->1577692589],
Cell[372495, 13548, 1110, 35, 54, "Output",
 CellID->1298753814]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[373666, 13590, 92, 2, 70, "Section",
 CellTags->{"t:229", "c:119"},
 CellID->1131563790],
Cell[373761, 13594, 660, 14, 70, "Text",
 CellID->77440698],
Cell[CellGroupData[{
Cell[374446, 13612, 309, 11, 70, "Input",
 CellID->170721204],
Cell[374758, 13625, 302, 11, 36, "Output",
 CellID->273123236]
}, Open  ]],
Cell[375075, 13639, 297, 7, 70, "Text",
 CellID->1209673813],
Cell[CellGroupData[{
Cell[375397, 13650, 130, 4, 70, "Input",
 CellID->760088942],
Cell[375530, 13656, 303, 11, 36, "Output",
 CellID->1582115838]
}, Open  ]],
Cell[375848, 13670, 209, 5, 70, "Text",
 CellID->478372112],
Cell[376060, 13677, 369, 12, 70, "NumberedEquation",
 CellID->1968795663],
Cell[376432, 13691, 748, 25, 70, "Text",
 CellID->1120675065],
Cell[377183, 13718, 966, 29, 70, "NumberedEquation",
 CellID->1754233265],
Cell[378152, 13749, 412, 11, 70, "Text",
 CellID->595495192],
Cell[378567, 13762, 209, 6, 70, "Text",
 CellID->1213896924],
Cell[378779, 13770, 1135, 39, 70, "DefinitionBox",
 CellTags->"S3.7.7",
 CellID->870955168],
Cell[379917, 13811, 60, 1, 70, "Text",
 CellID->894970624],
Cell[379980, 13814, 276, 10, 70, "Input",
 CellID->795813980],
Cell[380259, 13826, 79, 1, 70, "Text",
 CellID->717408344],
Cell[CellGroupData[{
Cell[380363, 13831, 133, 4, 70, "Input",
 CellID->1508843350],
Cell[380499, 13837, 318, 11, 36, "Output",
 CellID->1643279674]
}, Open  ]],
Cell[380832, 13851, 107, 3, 70, "Text",
 CellID->1961780498],
Cell[CellGroupData[{
Cell[380964, 13858, 179, 6, 70, "Input",
 CellID->1328397495],
Cell[381146, 13866, 318, 11, 36, "Output",
 CellID->1136704253]
}, Open  ]],
Cell[381479, 13880, 80, 1, 70, "Text",
 CellID->573856459],
Cell[CellGroupData[{
Cell[381584, 13885, 107, 3, 70, "Input",
 CellID->456447736],
Cell[381694, 13890, 375, 12, 36, "Output",
 CellID->705511868]
}, Open  ]],
Cell[382084, 13905, 256, 5, 70, "Text",
 CellID->1280750389],
Cell[CellGroupData[{
Cell[382365, 13914, 525, 16, 70, "Input",
 CellID->1343194042],
Cell[382893, 13932, 375, 12, 36, "Output",
 CellID->714166630]
}, Open  ]],
Cell[383283, 13947, 310, 8, 70, "Text",
 CellID->712447327],
Cell[CellGroupData[{
Cell[383618, 13959, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->35257418],
Cell[383686, 13962, 169, 3, 70, "TutorialMoreAbout",
 CellID->4791866],
Cell[383858, 13967, 147, 3, 70, "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],
Cell[CellGroupData[{
Cell[384042, 13975, 70, 1, 70, "RelatedTutorialsSection",
 CellID->6143117],
Cell[384115, 13978, 304, 9, 70, "RelatedTutorials",
 CellID->315063104],
Cell[384422, 13989, 191, 5, 70, "RelatedTutorials",
 CellID->3571032],
Cell[384616, 13996, 175, 4, 70, "RelatedTutorials",
 CellID->560755906],
Cell[384794, 14002, 175, 4, 70, "RelatedTutorials",
 CellID->335456077],
Cell[384972, 14008, 160, 4, 70, "RelatedTutorials",
 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[385171, 14017, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

