(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49832,       1778]
NotebookOptionsPosition[     35419,       1313]
NotebookOutlinePosition[     36750,       1350]
CellTagsIndexPosition[     36707,       1347]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[TextData[{
 "Linear Algebra in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "TOCDocumentTitle",
 CellID->942062912],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraIntroduction#509267359"]], "TOCChapter",
 CellID->76147412],

Cell[TextData[ButtonBox["Tensors and Arrays",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraIntroduction#374996618"]], "TOCSection",
 CellID->374996618],

Cell[TextData[{
 ButtonBox["Matrices as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#1127257628"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#1127257628"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#1127257628"]
}], "TOCSection",
 CellID->1127257628],

Cell[TextData[ButtonBox["Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraIntroduction#1564598842"]], "TOCSection",
 CellID->1564598842],

Cell[TextData[{
 ButtonBox["Design Principles of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#207795216"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#207795216"],
  FontSlant->"Italic"]
}], "TOCSection",
 CellID->207795216]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Matrix and Tensor Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1023128168"]], \
"TOCChapter",
 CellID->824511222],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Building Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#441715480"]], \
"TOCSection",
 CellID->441715480],

Cell[TextData[ButtonBox["Special Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1887778180"]], \
"TOCSubsection",
 CellID->1887778180]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#223720584"]], \
"TOCSection",
 CellID->223720584],

Cell[TextData[ButtonBox["Getting Pieces of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1678167046"]], \
"TOCSubsection",
 CellID->1678167046],

Cell[TextData[ButtonBox["Getting Multiple Pieces",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#288135948"]], \
"TOCSubsection",
 CellID->288135948],

Cell[TextData[ButtonBox["Setting Pieces of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1626148827"]], \
"TOCSubsection",
 CellID->1626148827],

Cell[TextData[ButtonBox["Setting Multiple Pieces",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#289617502"]], \
"TOCSubsection",
 CellID->289617502],

Cell[TextData[ButtonBox["Extracting Submatrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#849568979"]], \
"TOCSubsection",
 CellID->849568979],

Cell[TextData[ButtonBox["Deleting Rows and Columns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#2028205186"]], \
"TOCSubsection",
 CellID->2028205186],

Cell[TextData[ButtonBox["Inserting Rows and Columns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#964961827"]], \
"TOCSubsection",
 CellID->964961827],

Cell[TextData[ButtonBox["Extending Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#782554218"]], \
"TOCSubsection",
 CellID->782554218],

Cell[TextData[ButtonBox["Transpose",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#11316850"]], \
"TOCSubsection",
 CellID->11316850],

Cell[TextData[ButtonBox["Rotating Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#654023951"]], \
"TOCSubsection",
 CellID->654023951],

Cell[TextData[ButtonBox["Testing Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1736222906"]], \
"TOCSubsection",
 CellID->1736222906],

Cell[TextData[ButtonBox["Further Structural Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#528156332"]], \
"TOCSubsection",
 CellID->528156332]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Element-wise Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1701521313"]], \
"TOCSection",
 CellID->1701521313],

Cell[TextData[ButtonBox["Listability",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#540401315"]], \
"TOCSubsection",
 CellID->540401315],

Cell[TextData[ButtonBox["Map",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#188079645"]], \
"TOCSubsection",
 CellID->188079645]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Vectors and Tensors",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#112899229"]], \
"TOCSection",
 CellID->112899229],

Cell[TextData[ButtonBox["Testing Vectors and Tensors",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1062677296"]], \
"TOCSubsection",
 CellID->1062677296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Visualization of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1361817013"]], \
"TOCSection",
 CellID->1361817013],

Cell[TextData[ButtonBox["Formatting Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1886656195"]], \
"TOCSubsection",
 CellID->1886656195],

Cell[TextData[ButtonBox["Plotting Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1336717728"]], \
"TOCSubsection",
 CellID->1336717728]
}, Closed]],

Cell[TextData[ButtonBox["Import and Export of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#2053293398"]], \
"TOCSection",
 CellID->2053293398],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Matrix Multiplication",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1896011669"]], \
"TOCSection",
 CellID->1896011669],

Cell[TextData[ButtonBox["Outer Product",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#520172951"]], \
"TOCSubsection",
 CellID->520172951],

Cell[TextData[ButtonBox["Visualization of the Outer Product",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1814519952"]], \
"TOCSubsection",
 CellID->1814519952],

Cell[TextData[ButtonBox["Generalized Inner Product",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1622139970"]], \
"TOCSubsection",
 CellID->1622139970]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Matrix Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1318022893"]], \
"TOCSection",
 CellID->1318022893],

Cell[TextData[ButtonBox["Permutation Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#384051338"]], \
"TOCSubsection",
 CellID->384051338]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Working with Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1619024906"]], "TOCChapter",
 CellID->254590979],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1588951893"]], "TOCSection",
 CellID->1588951893],

Cell[TextData[ButtonBox["SparseArray",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1458825321"]], "TOCSubsection",
 CellID->1458825321],

Cell[TextData[ButtonBox["Rule Inputs for SparseArray",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1126881263"]], "TOCSubsection",
 CellID->1126881263],

Cell[TextData[ButtonBox["Banded Sparse Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#69082539"]], "TOCSubsection",
 CellID->186966591],

Cell[TextData[ButtonBox["Identity and Diagonal Sparse Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#386554746"]], "TOCSubsection",
 CellID->386554746],

Cell[TextData[ButtonBox["Normal",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1483534657"]], "TOCSubsection",
 CellID->1483534657],

Cell[TextData[ButtonBox["ArrayRules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1554122061"]], "TOCSubsection",
 CellID->1554122061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#382555551"]], "TOCSection",
 CellID->382555551],

Cell[TextData[ButtonBox["Getting Pieces of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#43873582"]], "TOCSubsection",
 CellID->43873582],

Cell[TextData[ButtonBox["Getting Multiple Pieces",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#980139236"]], "TOCSubsection",
 CellID->980139236],

Cell[TextData[ButtonBox["Setting Pieces of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1033045979"]], "TOCSubsection",
 CellID->1033045979],

Cell[TextData[ButtonBox["Setting Multiple Pieces",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1718872299"]], "TOCSubsection",
 CellID->1718872299],

Cell[TextData[ButtonBox["Extracting Submatrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#2116455801"]], "TOCSubsection",
 CellID->2116455801],

Cell[TextData[ButtonBox["Deleting Rows and Columns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#503342974"]], "TOCSubsection",
 CellID->503342974],

Cell[TextData[ButtonBox["Inserting Rows and Columns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#812208252"]], "TOCSubsection",
 CellID->812208252],

Cell[TextData[ButtonBox["Extending Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1326060419"]], "TOCSubsection",
 CellID->1326060419],

Cell[TextData[ButtonBox["Transpose",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1525842641"]], "TOCSubsection",
 CellID->1525842641],

Cell[TextData[ButtonBox["Rotating Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#877282493"]], "TOCSubsection",
 CellID->877282493],

Cell[TextData[ButtonBox["Testing Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1013005059"]], "TOCSubsection",
 CellID->1013005059],

Cell[TextData[ButtonBox["Further Structural Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1896109973"]], "TOCSubsection",
 CellID->1896109973]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Element-wise Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#430873687"]], "TOCSection",
 CellID->430873687],

Cell[TextData[ButtonBox["Listability",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1542041473"]], "TOCSubsection",
 CellID->1542041473],

Cell[TextData[ButtonBox["Map",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#2077369385"]], "TOCSubsection",
 CellID->2077369385]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Visualization of Sparse Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1853380947"]], "TOCSection",
 CellID->1853380947],

Cell[TextData[ButtonBox["Formatting Sparse Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1305822102"]], "TOCSubsection",
 CellID->1305822102],

Cell[TextData[ButtonBox["Plotting Sparse Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1191044059"]], "TOCSubsection",
 CellID->1191044059]
}, Closed]],

Cell[TextData[ButtonBox["Import and Export of Sparse Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#212323487"]], "TOCSection",
 CellID->212323487],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Matrix Multiplication",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#243730537"]], "TOCSection",
 CellID->243730537],

Cell[TextData[ButtonBox["Outer Product",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1885795684"]], "TOCSubsection",
 CellID->1885795684]
}, Closed]],

Cell[TextData[ButtonBox["Matrix Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#1180395712"]], "TOCSection",
 CellID->1180395712],

Cell[TextData[ButtonBox["Converting Equations to Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#139087150"]], "TOCSection",
 CellID->139087150],

Cell[TextData[ButtonBox["SparseArray Data Format",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraSparseArrays#483612173"]], "TOCSection",
 CellID->483612173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Matrix Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1927833614"]], "TOCChapter",\

 CellID->70339198],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1060011943"]], "TOCSection",\

 CellID->1060011943],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Norms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#832278785"]], \
"TOCSubsection",
 CellID->832278785],

Cell[TextData[ButtonBox["Vector Norms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#654042966"]], \
"TOCSubsubsection",
 CellID->654042966],

Cell[TextData[ButtonBox["Matrix Norms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1973408751"]], \
"TOCSubsubsection",
 CellID->1973408751]
}, Open  ]],

Cell[TextData[ButtonBox["NullSpace",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#478394165"]], \
"TOCSubsection",
 CellID->478394165],

Cell[TextData[ButtonBox["Rank",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#2035970465"]], \
"TOCSubsection",
 CellID->2035970465],

Cell[TextData[ButtonBox["Reduced Row Echelon Form",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#2032866165"]], \
"TOCSubsection",
 CellID->2032866165],

Cell[TextData[ButtonBox["Inverse",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1798152178"]], \
"TOCSubsection",
 CellID->1798152178],

Cell[TextData[ButtonBox["PseudoInverse",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1120972426"]], \
"TOCSubsection",
 CellID->1120972426],

Cell[TextData[ButtonBox["Determinant",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1665558708"]], \
"TOCSubsection",
 CellID->1665558708],

Cell[TextData[ButtonBox["Minors",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1595477023"]], \
"TOCSubsection",
 CellID->1595477023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#81663253"]], "TOCSection",
 CellID->81663253],

Cell[TextData[ButtonBox["Singular Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#438728183"]], \
"TOCSubsection",
 CellID->438728183],

Cell[TextData[ButtonBox["Homogeneous Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#534320490"]], \
"TOCSubsection",
 CellID->534320490],

Cell[TextData[ButtonBox["Estimating and Calculating Accuracy",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1668277829"]], \
"TOCSubsection",
 CellID->1668277829],

Cell[TextData[ButtonBox["Symbolic and Exact Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1644685080"]], \
"TOCSubsection",
 CellID->1644685080],

Cell[TextData[ButtonBox["Row Reduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#644279649"]], \
"TOCSubsection",
 CellID->644279649],

Cell[TextData[ButtonBox["Saving the Factorization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1974718471"]], \
"TOCSubsection",
 CellID->1974718471],

Cell[TextData[ButtonBox["Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#834729047"]], \
"TOCSubsection",
 CellID->834729047],

Cell[TextData[ButtonBox["LAPACK",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1131477137"]], \
"TOCSubsection",
 CellID->1131477137],

Cell[TextData[ButtonBox["Multifrontal",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1415618539"]], \
"TOCSubsection",
 CellID->1415618539],

Cell[TextData[ButtonBox["Krylov",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1643755774"]], \
"TOCSubsection",
 CellID->1643755774],

Cell[TextData[ButtonBox["Cholesky",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1549309818"]], \
"TOCSubsection",
 CellID->1549309818],

Cell[TextData[ButtonBox["Symbolic Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1813753518"]], \
"TOCSubsection",
 CellID->1813753518]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Least Squares Solutions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#563250646"]], "TOCSection",\

 CellID->563250646],

Cell[TextData[ButtonBox["Data Fitting",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1737956870"]], \
"TOCSubsection",
 CellID->1737956870]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Eigensystem Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1705931980"]], "TOCSection",\

 CellID->1705931980],

Cell[TextData[ButtonBox["Eigensystem Properties",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#723589929"]], \
"TOCSubsection",
 CellID->723589929],

Cell[TextData[ButtonBox["Diagonalizing a Matrix",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1770480598"]], \
"TOCSubsection",
 CellID->1770480598],

Cell[TextData[ButtonBox["Symbolic and Exact Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1937669982"]], \
"TOCSubsection",
 CellID->1937669982],

Cell[TextData[ButtonBox["Generalized Eigenvalues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#524353415"]], \
"TOCSubsection",
 CellID->524353415],

Cell[TextData[ButtonBox["Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#905279933"]], \
"TOCSubsection",
 CellID->905279933],

Cell[TextData[ButtonBox["LAPACK",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1499161194"]], \
"TOCSubsection",
 CellID->1499161194],

Cell[TextData[ButtonBox["Arnoldi",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1833787992"]], \
"TOCSubsection",
 CellID->1833787992],

Cell[TextData[ButtonBox["Symbolic Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#344887306"]], \
"TOCSubsection",
 CellID->344887306]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#837293883"]], "TOCSection",\

 CellID->837293883],

Cell[TextData[ButtonBox["LU Decomposition",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#849593972"]], \
"TOCSubsection",
 CellID->849593972],

Cell[TextData[ButtonBox["Cholesky Decomposition",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1567526616"]], \
"TOCSubsection",
 CellID->1567526616],

Cell[TextData[ButtonBox["Cholesky and LU Factorizations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#966681026"]], \
"TOCSubsection",
 CellID->966681026],

Cell[TextData[ButtonBox["Orthogonalization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#464885506"]], \
"TOCSubsection",
 CellID->464885506],

Cell[TextData[ButtonBox["QR Decomposition",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1662286926"]], \
"TOCSubsection",
 CellID->1662286926],

Cell[TextData[ButtonBox["Solving Systems of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#841776984"]], \
"TOCSubsection",
 CellID->841776984],

Cell[TextData[ButtonBox["Singular Value Decomposition",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#315998326"]], \
"TOCSubsection",
 CellID->315998326],

Cell[TextData[ButtonBox["Generalized Singular Values",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#915032469"]], \
"TOCSubsection",
 CellID->915032469],

Cell[TextData[ButtonBox["Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#2106677120"]], \
"TOCSubsection",
 CellID->2106677120],

Cell[TextData[ButtonBox["Schur Decomposition",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#225662794"]], \
"TOCSubsection",
 CellID->225662794],

Cell[TextData[ButtonBox["Generalized Schur Decomposition",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#811895271"]], \
"TOCSubsection",
 CellID->811895271],

Cell[TextData[ButtonBox["Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#35657259"]], \
"TOCSubsection",
 CellID->35657259],

Cell[TextData[ButtonBox["Jordan Decomposition",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1994258536"]], \
"TOCSubsection",
 CellID->1994258536]
}, Open  ]],

Cell[TextData[ButtonBox["Functions of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations#1131563790"]], "TOCSection",\

 CellID->1131563790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Matrix Types",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#1880892864"]], "TOCChapter",
 CellID->139564664],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Numbers in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#139211047"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#139211047"],
  FontSlant->"Italic"]
}], "TOCSection",
 CellID->139211047],

Cell[TextData[ButtonBox["Exact versus Approximate Numbers",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#1831846039"]], "TOCSubsection",
 CellID->1831846039],

Cell[TextData[ButtonBox["Mixed Mode Arithmetic",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#1284345793"]], "TOCSubsection",
 CellID->1284345793]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Matrices in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#77896732"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#77896732"],
  FontSlant->"Italic"]
}], "TOCSection",
 CellID->77896732],

Cell[TextData[ButtonBox["Standard Numerical Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#963685160"]], "TOCSubsection",
 CellID->963685160],

Cell[TextData[ButtonBox["Arbitrary-Precision Numerical Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#1753145835"]], "TOCSubsection",
 CellID->1753145835],

Cell[TextData[ButtonBox["Symbolic Algebra Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#1095335974"]], "TOCSubsection",
 CellID->1095335974],

Cell[TextData[ButtonBox["Mixed Mode Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#1172699025"]], "TOCSubsection",
 CellID->1172699025]
}, Closed]],

Cell[TextData[ButtonBox["Complex Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#411747335"]], "TOCSection",
 CellID->411747335],

Cell[TextData[ButtonBox["Arbitrary-Precision Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixTypes#2139022291"]], "TOCSection",
 CellID->2139022291]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Performance of Linear Algebra Computation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#195254286"]], "TOCChapter",
 CellID->180149865],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Packed Arrays",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1945433762"]], "TOCSection",
 CellID->1945433762],

Cell[TextData[ButtonBox["Packed Array Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#995975105"]], "TOCSubsection",
 CellID->995975105],

Cell[TextData[ButtonBox["Packed Array Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#41338579"]], "TOCSubsection",
 CellID->41338579],

Cell[TextData[ButtonBox["Packed Array Summary",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#169320987"]], "TOCSubsection",
 CellID->169320987]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Programming Efficiency",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1030559832"]], "TOCSection",
 CellID->1030559832],

Cell[TextData[ButtonBox["Measuring Performance",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1826376848"]], "TOCSubsection",
 CellID->1826376848],

Cell[TextData[ButtonBox["Vectorizing Loops",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1352766973"]], "TOCSubsection",
 CellID->1352766973],

Cell[TextData[ButtonBox["List Creation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1048970201"]], "TOCSubsection",
 CellID->1048970201],

Cell[TextData[ButtonBox["List Updating",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#291032650"]], "TOCSubsection",
 CellID->291032650],

Cell[TextData[ButtonBox["Using Built-in Support",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1145089169"]], "TOCSubsection",
 CellID->1145089169],

Cell[TextData[ButtonBox["A Slow Way",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1855711455"]], "TOCSubsection",
 CellID->1855711455],

Cell[TextData[ButtonBox["A Faster Way",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#460055094"]], "TOCSubsection",
 CellID->460055094],

Cell[TextData[ButtonBox["Also Fast but Neater",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#663127012"]], "TOCSubsection",
 CellID->663127012],

Cell[TextData[ButtonBox["Matrix Contents",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#478605279"]], "TOCSubsection",
 CellID->478605279],

Cell[TextData[ButtonBox["Mixed Symbolic/Numerical Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#92425055"]], "TOCSubsection",
 CellID->92425055],

Cell[TextData[ButtonBox["Mixed Numerical Type Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1705346414"]], "TOCSubsection",
 CellID->1705346414],

Cell[TextData[ButtonBox["Integer Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#535763928"]], "TOCSubsection",
 CellID->535763928]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Expression Efficiency",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1857660297"]], "TOCSection",
 CellID->1857660297],

Cell[TextData[ButtonBox["Updating of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1264346631"]], "TOCSubsection",
 CellID->1264346631],

Cell[TextData[ButtonBox["Appending to Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraPerformance#1750402393"]], "TOCSubsection",
 CellID->1750402393]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Linear Algebra Examples",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraExamples#349852864"]], "TOCChapter",\

 CellID->39782289],

Cell[TextData[ButtonBox["Matrix Ordering",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#1945860599"]], "TOCSection",
 CellID->1945860599],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Full Rank Least Squares Solutions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraExamples#967762464"]], "TOCSection",\

 CellID->967762464],

Cell[TextData[ButtonBox["Least Squares Cholesky",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#899751076"]], "TOCSubsection",
 CellID->899751076],

Cell[TextData[ButtonBox["Least Squares QR",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#701643607"]], "TOCSubsection",
 CellID->701643607]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Minimization of 1 and Infinity Norms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraExamples#601898483"]], "TOCSection",\

 CellID->601898483],

Cell[TextData[ButtonBox["One-Norm Minimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#526704053"]], "TOCSubsection",
 CellID->526704053],

Cell[TextData[ButtonBox["Infinity-Norm Minimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#1503089771"]], "TOCSubsection",
 CellID->1503089771]
}, Closed]],

Cell[TextData[ButtonBox["Finite Difference Solutions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#1711482715"]], "TOCSection",
 CellID->1711482715],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Mesh Partitioning",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#1370044451"]], "TOCSection",
 CellID->1370044451],

Cell[TextData[ButtonBox["Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#1594202747"]], "TOCSubsection",
 CellID->1594202747],

Cell[TextData[ButtonBox["Plotting the Mesh",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#846283239"]], "TOCSubsection",
 CellID->846283239],

Cell[TextData[ButtonBox["The Laplacian",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#455167669"]], "TOCSubsection",
 CellID->455167669],

Cell[TextData[ButtonBox["The Fiedler Vector",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#1726888774"]], "TOCSubsection",
 CellID->1726888774],

Cell[TextData[ButtonBox["Partitioning the Nodes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraExamples#1327004163"]], "TOCSubsection",
 CellID->1327004163]
}, Closed]],

Cell[TextData[ButtonBox["Matrix Functions with NDSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraExamples#747736829"]], "TOCSection",\

 CellID->747736829]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["References",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraAppendix#342426796"]], "TOCChapter",\

 CellID->19694580],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Software References",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#2058470059"]], "TOCSection",
 CellID->2058470059],

Cell[TextData[ButtonBox["ARPACK",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#744728443"]], "TOCSubsection",
 CellID->744728443],

Cell[TextData[ButtonBox["ATLAS",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#342575303"]], "TOCSubsection",
 CellID->342575303],

Cell[TextData[ButtonBox["Harwell-Boeing",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#1350971188"]], "TOCSubsection",
 CellID->1350971188],

Cell[TextData[ButtonBox["Matrix Market",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#1964229445"]], "TOCSubsection",
 CellID->1964229445],

Cell[TextData[ButtonBox["METIS",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#1290592593"]], "TOCSubsection",
 CellID->1290592593],

Cell[TextData[ButtonBox["TAUCS",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#165728992"]], "TOCSubsection",
 CellID->165728992],

Cell[TextData[ButtonBox["UMFPACK",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraAppendix#83486633"]], "TOCSubsection",
 CellID->83486633]
}, Closed]],

Cell[TextData[ButtonBox["Other References",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraAppendix#95220008"]], "TOCSection",\

 CellID->95220008]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Algebra in Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 41.7883658}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Introduction Matrix and Tensor Operations Working with Sparse Arrays", 
    "synonyms" -> {}, "title" -> "Linear Algebra in Mathematica", "type" -> 
    "Tutorial", "uri" -> "tutorial/LinearAlgebraOverview"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[706, 27, 130, 5, 70, "TOCDocumentTitle",
 CellID->942062912],
Cell[CellGroupData[{
Cell[861, 36, 165, 4, 70, "TOCChapter",
 CellID->76147412],
Cell[1029, 42, 172, 4, 70, "TOCSection",
 CellID->374996618],
Cell[1204, 48, 442, 12, 70, "TOCSection",
 CellID->1127257628],
Cell[1649, 62, 183, 4, 70, "TOCSection",
 CellID->1564598842],
Cell[1835, 68, 329, 9, 70, "TOCSection",
 CellID->207795216]
}, Closed]],
Cell[CellGroupData[{
Cell[2201, 82, 198, 5, 70, "TOCChapter",
 CellID->824511222],
Cell[CellGroupData[{
Cell[2424, 91, 186, 5, 70, "TOCSection",
 CellID->441715480],
Cell[2613, 98, 190, 5, 70, "TOCSubsection",
 CellID->1887778180]
}, Closed]],
Cell[CellGroupData[{
Cell[2840, 108, 190, 5, 70, "TOCSection",
 CellID->223720584],
Cell[3033, 115, 200, 5, 70, "TOCSubsection",
 CellID->1678167046],
Cell[3236, 122, 195, 5, 70, "TOCSubsection",
 CellID->288135948],
Cell[3434, 129, 200, 5, 70, "TOCSubsection",
 CellID->1626148827],
Cell[3637, 136, 195, 5, 70, "TOCSubsection",
 CellID->289617502],
Cell[3835, 143, 194, 5, 70, "TOCSubsection",
 CellID->849568979],
Cell[4032, 150, 199, 5, 70, "TOCSubsection",
 CellID->2028205186],
Cell[4234, 157, 198, 5, 70, "TOCSubsection",
 CellID->964961827],
Cell[4435, 164, 190, 5, 70, "TOCSubsection",
 CellID->782554218],
Cell[4628, 171, 179, 5, 70, "TOCSubsection",
 CellID->11316850],
Cell[4810, 178, 189, 5, 70, "TOCSubsection",
 CellID->654023951],
Cell[5002, 185, 190, 5, 70, "TOCSubsection",
 CellID->1736222906],
Cell[5195, 192, 201, 5, 70, "TOCSubsection",
 CellID->528156332]
}, Closed]],
Cell[CellGroupData[{
Cell[5433, 202, 194, 5, 70, "TOCSection",
 CellID->1701521313],
Cell[5630, 209, 183, 5, 70, "TOCSubsection",
 CellID->540401315],
Cell[5816, 216, 175, 5, 70, "TOCSubsection",
 CellID->188079645]
}, Closed]],
Cell[CellGroupData[{
Cell[6028, 226, 188, 5, 70, "TOCSection",
 CellID->112899229],
Cell[6219, 233, 201, 5, 70, "TOCSubsection",
 CellID->1062677296]
}, Closed]],
Cell[CellGroupData[{
Cell[6457, 243, 196, 5, 70, "TOCSection",
 CellID->1361817013],
Cell[6656, 250, 193, 5, 70, "TOCSubsection",
 CellID->1886656195],
Cell[6852, 257, 191, 5, 70, "TOCSubsection",
 CellID->1336717728]
}, Closed]],
Cell[7058, 265, 200, 5, 70, "TOCSection",
 CellID->2053293398],
Cell[CellGroupData[{
Cell[7283, 274, 192, 5, 70, "TOCSection",
 CellID->1896011669],
Cell[7478, 281, 185, 5, 70, "TOCSubsection",
 CellID->520172951],
Cell[7666, 288, 208, 5, 70, "TOCSubsection",
 CellID->1814519952],
Cell[7877, 295, 199, 5, 70, "TOCSubsection",
 CellID->1622139970]
}, Closed]],
Cell[CellGroupData[{
Cell[8113, 305, 190, 5, 70, "TOCSection",
 CellID->1318022893],
Cell[8306, 312, 192, 5, 70, "TOCSubsection",
 CellID->384051338]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[8547, 323, 181, 4, 70, "TOCChapter",
 CellID->254590979],
Cell[CellGroupData[{
Cell[8753, 331, 172, 4, 70, "TOCSection",
 CellID->1588951893],
Cell[8928, 337, 170, 4, 70, "TOCSubsection",
 CellID->1458825321],
Cell[9101, 343, 186, 4, 70, "TOCSubsection",
 CellID->1126881263],
Cell[9290, 349, 178, 4, 70, "TOCSubsection",
 CellID->186966591],
Cell[9471, 355, 194, 4, 70, "TOCSubsection",
 CellID->386554746],
Cell[9668, 361, 165, 4, 70, "TOCSubsection",
 CellID->1483534657],
Cell[9836, 367, 169, 4, 70, "TOCSubsection",
 CellID->1554122061]
}, Open  ]],
Cell[CellGroupData[{
Cell[10042, 376, 175, 4, 70, "TOCSection",
 CellID->382555551],
Cell[10220, 382, 181, 4, 70, "TOCSubsection",
 CellID->43873582],
Cell[10404, 388, 180, 4, 70, "TOCSubsection",
 CellID->980139236],
Cell[10587, 394, 185, 4, 70, "TOCSubsection",
 CellID->1033045979],
Cell[10775, 400, 182, 4, 70, "TOCSubsection",
 CellID->1718872299],
Cell[10960, 406, 181, 4, 70, "TOCSubsection",
 CellID->2116455801],
Cell[11144, 412, 182, 4, 70, "TOCSubsection",
 CellID->503342974],
Cell[11329, 418, 183, 4, 70, "TOCSubsection",
 CellID->812208252],
Cell[11515, 424, 177, 4, 70, "TOCSubsection",
 CellID->1326060419],
Cell[11695, 430, 168, 4, 70, "TOCSubsection",
 CellID->1525842641],
Cell[11866, 436, 174, 4, 70, "TOCSubsection",
 CellID->877282493],
Cell[12043, 442, 175, 4, 70, "TOCSubsection",
 CellID->1013005059],
Cell[12221, 448, 188, 4, 70, "TOCSubsection",
 CellID->1896109973]
}, Closed]],
Cell[CellGroupData[{
Cell[12446, 457, 177, 4, 70, "TOCSection",
 CellID->430873687],
Cell[12626, 463, 170, 4, 70, "TOCSubsection",
 CellID->1542041473],
Cell[12799, 469, 162, 4, 70, "TOCSubsection",
 CellID->2077369385]
}, Closed]],
Cell[CellGroupData[{
Cell[12998, 478, 188, 4, 70, "TOCSection",
 CellID->1853380947],
Cell[13189, 484, 185, 4, 70, "TOCSubsection",
 CellID->1305822102],
Cell[13377, 490, 183, 4, 70, "TOCSubsection",
 CellID->1191044059]
}, Closed]],
Cell[13575, 497, 190, 4, 70, "TOCSection",
 CellID->212323487],
Cell[CellGroupData[{
Cell[13790, 505, 175, 4, 70, "TOCSection",
 CellID->243730537],
Cell[13968, 511, 172, 4, 70, "TOCSubsection",
 CellID->1885795684]
}, Closed]],
Cell[14155, 518, 175, 4, 70, "TOCSection",
 CellID->1180395712],
Cell[14333, 524, 191, 4, 70, "TOCSection",
 CellID->139087150],
Cell[14527, 530, 177, 4, 70, "TOCSection",
 CellID->483612173]
}, Open  ]],
Cell[CellGroupData[{
Cell[14741, 539, 181, 5, 70, "TOCChapter",
 CellID->70339198],
Cell[CellGroupData[{
Cell[14947, 548, 180, 5, 70, "TOCSection",
 CellID->1060011943],
Cell[CellGroupData[{
Cell[15152, 557, 170, 5, 70, "TOCSubsection",
 CellID->832278785],
Cell[15325, 564, 180, 5, 70, "TOCSubsubsection",
 CellID->654042966],
Cell[15508, 571, 182, 5, 70, "TOCSubsubsection",
 CellID->1973408751]
}, Open  ]],
Cell[15705, 579, 174, 5, 70, "TOCSubsection",
 CellID->478394165],
Cell[15882, 586, 171, 5, 70, "TOCSubsection",
 CellID->2035970465],
Cell[16056, 593, 191, 5, 70, "TOCSubsection",
 CellID->2032866165],
Cell[16250, 600, 174, 5, 70, "TOCSubsection",
 CellID->1798152178],
Cell[16427, 607, 180, 5, 70, "TOCSubsection",
 CellID->1120972426],
Cell[16610, 614, 178, 5, 70, "TOCSubsection",
 CellID->1665558708],
Cell[16791, 621, 173, 5, 70, "TOCSubsection",
 CellID->1595477023]
}, Open  ]],
Cell[CellGroupData[{
Cell[17001, 631, 180, 4, 70, "TOCSection",
 CellID->81663253],
Cell[17184, 637, 182, 5, 70, "TOCSubsection",
 CellID->438728183],
Cell[17369, 644, 186, 5, 70, "TOCSubsection",
 CellID->534320490],
Cell[17558, 651, 202, 5, 70, "TOCSubsection",
 CellID->1668277829],
Cell[17763, 658, 194, 5, 70, "TOCSubsection",
 CellID->1644685080],
Cell[17960, 665, 178, 5, 70, "TOCSubsection",
 CellID->644279649],
Cell[18141, 672, 191, 5, 70, "TOCSubsection",
 CellID->1974718471],
Cell[18335, 679, 172, 5, 70, "TOCSubsection",
 CellID->834729047],
Cell[18510, 686, 173, 5, 70, "TOCSubsection",
 CellID->1131477137],
Cell[18686, 693, 179, 5, 70, "TOCSubsection",
 CellID->1415618539],
Cell[18868, 700, 173, 5, 70, "TOCSubsection",
 CellID->1643755774],
Cell[19044, 707, 175, 5, 70, "TOCSubsection",
 CellID->1549309818],
Cell[19222, 714, 183, 5, 70, "TOCSubsection",
 CellID->1813753518]
}, Closed]],
Cell[CellGroupData[{
Cell[19442, 724, 185, 5, 70, "TOCSection",
 CellID->563250646],
Cell[19630, 731, 179, 5, 70, "TOCSubsection",
 CellID->1737956870]
}, Closed]],
Cell[CellGroupData[{
Cell[19846, 741, 188, 5, 70, "TOCSection",
 CellID->1705931980],
Cell[20037, 748, 187, 5, 70, "TOCSubsection",
 CellID->723589929],
Cell[20227, 755, 189, 5, 70, "TOCSubsection",
 CellID->1770480598],
Cell[20419, 762, 194, 5, 70, "TOCSubsection",
 CellID->1937669982],
Cell[20616, 769, 188, 5, 70, "TOCSubsection",
 CellID->524353415],
Cell[20807, 776, 172, 5, 70, "TOCSubsection",
 CellID->905279933],
Cell[20982, 783, 173, 5, 70, "TOCSubsection",
 CellID->1499161194],
Cell[21158, 790, 174, 5, 70, "TOCSubsection",
 CellID->1833787992],
Cell[21335, 797, 181, 5, 70, "TOCSubsection",
 CellID->344887306]
}, Closed]],
Cell[CellGroupData[{
Cell[21553, 807, 183, 5, 70, "TOCSection",
 CellID->837293883],
Cell[21739, 814, 181, 5, 70, "TOCSubsection",
 CellID->849593972],
Cell[21923, 821, 189, 5, 70, "TOCSubsection",
 CellID->1567526616],
Cell[22115, 828, 195, 5, 70, "TOCSubsection",
 CellID->966681026],
Cell[22313, 835, 182, 5, 70, "TOCSubsection",
 CellID->464885506],
Cell[22498, 842, 183, 5, 70, "TOCSubsection",
 CellID->1662286926],
Cell[22684, 849, 193, 5, 70, "TOCSubsection",
 CellID->841776984],
Cell[22880, 856, 193, 5, 70, "TOCSubsection",
 CellID->315998326],
Cell[23076, 863, 192, 5, 70, "TOCSubsection",
 CellID->915032469],
Cell[23271, 870, 174, 5, 70, "TOCSubsection",
 CellID->2106677120],
Cell[23448, 877, 184, 5, 70, "TOCSubsection",
 CellID->225662794],
Cell[23635, 884, 196, 5, 70, "TOCSubsection",
 CellID->811895271],
Cell[23834, 891, 170, 5, 70, "TOCSubsection",
 CellID->35657259],
Cell[24007, 898, 187, 5, 70, "TOCSubsection",
 CellID->1994258536]
}, Open  ]],
Cell[24209, 906, 185, 5, 70, "TOCSection",
 CellID->1131563790]
}, Open  ]],
Cell[CellGroupData[{
Cell[24431, 916, 166, 4, 70, "TOCChapter",
 CellID->139564664],
Cell[CellGroupData[{
Cell[24622, 924, 317, 9, 70, "TOCSection",
 CellID->139211047],
Cell[24942, 935, 190, 4, 70, "TOCSubsection",
 CellID->1831846039],
Cell[25135, 941, 179, 4, 70, "TOCSubsection",
 CellID->1284345793]
}, Closed]],
Cell[CellGroupData[{
Cell[25351, 950, 315, 9, 70, "TOCSection",
 CellID->77896732],
Cell[25669, 961, 185, 4, 70, "TOCSubsection",
 CellID->963685160],
Cell[25857, 967, 198, 4, 70, "TOCSubsection",
 CellID->1753145835],
Cell[26058, 973, 185, 4, 70, "TOCSubsection",
 CellID->1095335974],
Cell[26246, 979, 177, 4, 70, "TOCSubsection",
 CellID->1172699025]
}, Closed]],
Cell[26438, 986, 169, 4, 70, "TOCSection",
 CellID->411747335],
Cell[26610, 992, 183, 4, 70, "TOCSection",
 CellID->2139022291]
}, Closed]],
Cell[CellGroupData[{
Cell[26830, 1001, 194, 4, 70, "TOCChapter",
 CellID->180149865],
Cell[CellGroupData[{
Cell[27049, 1009, 168, 4, 70, "TOCSection",
 CellID->1945433762],
Cell[27220, 1015, 178, 4, 70, "TOCSubsection",
 CellID->995975105],
Cell[27401, 1021, 177, 4, 70, "TOCSubsection",
 CellID->41338579],
Cell[27581, 1027, 176, 4, 70, "TOCSubsection",
 CellID->169320987]
}, Closed]],
Cell[CellGroupData[{
Cell[27794, 1036, 177, 4, 70, "TOCSection",
 CellID->1030559832],
Cell[27974, 1042, 179, 4, 70, "TOCSubsection",
 CellID->1826376848],
Cell[28156, 1048, 175, 4, 70, "TOCSubsection",
 CellID->1352766973],
Cell[28334, 1054, 171, 4, 70, "TOCSubsection",
 CellID->1048970201],
Cell[28508, 1060, 169, 4, 70, "TOCSubsection",
 CellID->291032650],
Cell[28680, 1066, 180, 4, 70, "TOCSubsection",
 CellID->1145089169],
Cell[28863, 1072, 168, 4, 70, "TOCSubsection",
 CellID->1855711455],
Cell[29034, 1078, 168, 4, 70, "TOCSubsection",
 CellID->460055094],
Cell[29205, 1084, 176, 4, 70, "TOCSubsection",
 CellID->663127012],
Cell[29384, 1090, 171, 4, 70, "TOCSubsection",
 CellID->478605279],
Cell[29558, 1096, 187, 4, 70, "TOCSubsection",
 CellID->92425055],
Cell[29748, 1102, 187, 4, 70, "TOCSubsection",
 CellID->1705346414],
Cell[29938, 1108, 172, 4, 70, "TOCSubsection",
 CellID->535763928]
}, Closed]],
Cell[CellGroupData[{
Cell[30147, 1117, 176, 4, 70, "TOCSection",
 CellID->1857660297],
Cell[30326, 1123, 178, 4, 70, "TOCSubsection",
 CellID->1264346631],
Cell[30507, 1129, 179, 4, 70, "TOCSubsection",
 CellID->1750402393]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30735, 1139, 171, 4, 70, "TOCChapter",
 CellID->39782289],
Cell[30909, 1145, 167, 4, 70, "TOCSection",
 CellID->1945860599],
Cell[CellGroupData[{
Cell[31101, 1153, 182, 4, 70, "TOCSection",
 CellID->967762464],
Cell[31286, 1159, 175, 4, 70, "TOCSubsection",
 CellID->899751076],
Cell[31464, 1165, 169, 4, 70, "TOCSubsection",
 CellID->701643607]
}, Closed]],
Cell[CellGroupData[{
Cell[31670, 1174, 185, 4, 70, "TOCSection",
 CellID->601898483],
Cell[31858, 1180, 174, 4, 70, "TOCSubsection",
 CellID->526704053],
Cell[32035, 1186, 181, 4, 70, "TOCSubsection",
 CellID->1503089771]
}, Closed]],
Cell[32231, 1193, 179, 4, 70, "TOCSection",
 CellID->1711482715],
Cell[CellGroupData[{
Cell[32435, 1201, 169, 4, 70, "TOCSection",
 CellID->1370044451],
Cell[32607, 1207, 159, 4, 70, "TOCSubsection",
 CellID->1594202747],
Cell[32769, 1213, 170, 4, 70, "TOCSubsection",
 CellID->846283239],
Cell[32942, 1219, 166, 4, 70, "TOCSubsection",
 CellID->455167669],
Cell[33111, 1225, 173, 4, 70, "TOCSubsection",
 CellID->1726888774],
Cell[33287, 1231, 177, 4, 70, "TOCSubsection",
 CellID->1327004163]
}, Closed]],
Cell[33479, 1238, 178, 4, 70, "TOCSection",
 CellID->747736829]
}, Closed]],
Cell[CellGroupData[{
Cell[33694, 1247, 158, 4, 70, "TOCChapter",
 CellID->19694580],
Cell[CellGroupData[{
Cell[33877, 1255, 171, 4, 70, "TOCSection",
 CellID->2058470059],
Cell[34051, 1261, 159, 4, 70, "TOCSubsection",
 CellID->744728443],
Cell[34213, 1267, 158, 4, 70, "TOCSubsection",
 CellID->342575303],
Cell[34374, 1273, 169, 4, 70, "TOCSubsection",
 CellID->1350971188],
Cell[34546, 1279, 168, 4, 70, "TOCSubsection",
 CellID->1964229445],
Cell[34717, 1285, 160, 4, 70, "TOCSubsection",
 CellID->1290592593],
Cell[34880, 1291, 158, 4, 70, "TOCSubsection",
 CellID->165728992],
Cell[35041, 1297, 158, 4, 70, "TOCSubsection",
 CellID->83486633]
}, Closed]],
Cell[35214, 1304, 163, 4, 70, "TOCSection",
 CellID->95220008]
}, Open  ]],
Cell[35392, 1311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

