(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12518,        429]
NotebookOptionsPosition[      8467,        309]
NotebookOutlinePosition[     11249,        380]
CellTagsIndexPosition[     11158,        374]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complement" :> 
          Documentation`HelpLookup["paclet:ref/Complement"], "Intersection" :> 
          Documentation`HelpLookup["paclet:ref/Intersection"], "Subsets" :> 
          Documentation`HelpLookup["paclet:ref/Subsets"], "Union" :> 
          Documentation`HelpLookup["paclet:ref/Union"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Complement\"\>", 2->"\<\"Intersection\"\>", 
       3->"\<\"Subsets\"\>", 4->"\<\"Union\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Lists as Sets", "Title",
 CellTags->{"S1.8.8", "8.1"},
 CellID->20366],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " usually keeps the elements of a list in exactly the order you originally \
entered them. If you want to treat a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list like a mathematical ",
 StyleBox["set",
  FontSlant->"Italic"],
 ", however, you may want to ignore the order of elements in the list."
}], "Text",
 CellID->23290],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Union",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Union"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "give a list of the distinct elements in the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Intersection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Intersection"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "give a list of the elements that are common to all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Complement",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Complement"], "[", 
     StyleBox["universal", "TI"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "give a list of the elements that are in ",
     Cell[BoxData[
      StyleBox["universal", "TI"]], "InlineFormula"],
     ", but not in any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Subsets",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subsets"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "give a list of all subsets of the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3227],

Cell["Set theoretical functions. ", "Caption",
 CellID->14458],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " gives the elements that occur in ",
 StyleBox["any",
  FontSlant->"Italic"],
 " of the lists. "
}], "MathCaption",
 CellID->32071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "e"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->30106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->6305]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Intersection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Intersection"]], "InlineFormula"],
 " gives only elements that occur in ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the lists. "
}], "MathCaption",
 CellID->11001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "d", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->25434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1770]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Complement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complement"]], "InlineFormula"],
 " gives elements that occur in the first list, but not in any of the others. \
"
}], "MathCaption",
 CellID->9555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->8507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4299]
}, Open  ]],

Cell["This gives all the subsets of the list. ", "MathCaption",
 CellID->7730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->4075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}], ",", 
   RowBox[{"{", "c", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->8803]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->126992002],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Lists as Sets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CombiningLists"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RearrangingLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 44.8978204}", "context" -> "", 
    "keywords" -> {
     "absent from list", "complement", "disjointness", 
      "distinct elements in lists", "duplicates", "intersection", "lists", 
      "overlap between lists", "Powerset", "set exponential", "sets", 
      "subsets", "Union", "unique elements in lists"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica usually keeps the elements of a list in exactly the order \
you originally entered them. If you want to treat a Mathematica list like a \
mathematical set, however, you may want to ignore the order of elements in \
the list. Set theoretical functions. Union gives the elements that occur in \
any of the lists. ", "synonyms" -> {"1.8.8"}, "title" -> "Lists as Sets", 
    "type" -> "Tutorial", "uri" -> "tutorial/ListsAsSets"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.8"->{
  Cell[2057, 61, 76, 2, 70, "Title",
   CellTags->{"S1.8.8", "8.1"},
   CellID->20366]},
 "8.1"->{
  Cell[2057, 61, 76, 2, 70, "Title",
   CellTags->{"S1.8.8", "8.1"},
   CellID->20366]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.8", 10947, 363},
 {"8.1", 11046, 367}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1432, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2057, 61, 76, 2, 70, "Title",
 CellTags->{"S1.8.8", "8.1"},
 CellID->20366],
Cell[2136, 65, 403, 12, 70, "Text",
 CellID->23290],
Cell[2542, 79, 2390, 75, 70, "DefinitionBox",
 CellID->3227],
Cell[4935, 156, 62, 1, 70, "Caption",
 CellID->14458],
Cell[5000, 159, 262, 10, 70, "MathCaption",
 CellID->32071],
Cell[CellGroupData[{
Cell[5287, 173, 298, 10, 28, "Input",
 CellID->30106],
Cell[5588, 185, 229, 7, 36, "Output",
 CellID->6305]
}, Open  ]],
Cell[5832, 195, 274, 10, 70, "MathCaption",
 CellID->11001],
Cell[CellGroupData[{
Cell[6131, 209, 256, 8, 28, "Input",
 CellID->25434],
Cell[6390, 219, 199, 7, 36, "Output",
 CellID->1770]
}, Open  ]],
Cell[6604, 229, 254, 8, 70, "MathCaption",
 CellID->9555],
Cell[CellGroupData[{
Cell[6883, 241, 243, 8, 70, "Input",
 CellID->8507],
Cell[7129, 251, 199, 7, 36, "Output",
 CellID->4299]
}, Open  ]],
Cell[7343, 261, 78, 1, 70, "MathCaption",
 CellID->7730],
Cell[CellGroupData[{
Cell[7446, 266, 156, 5, 70, "Input",
 CellID->4075],
Cell[7605, 273, 557, 19, 36, "Output",
 CellID->8803]
}, Open  ]],
Cell[CellGroupData[{
Cell[8199, 297, 72, 1, 70, "RelatedTutorialsSection",
 CellID->126992002],
Cell[8274, 300, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[8440, 307, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

