(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29462,       1015]
NotebookOptionsPosition[     14021,        516]
NotebookOutlinePosition[     23090,        796]
CellTagsIndexPosition[     22854,        784]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Logging",
 StyleBox[" MathLM",
  FontSlant->"Italic"]
}], "Title",
 CellTags->"i:1",
 CellID->526428705],

Cell[CellGroupData[{

Cell["Enabling Logging", "Section",
 CellTags->{"i:4", "b:2.1.1", "net: 2"},
 CellID->875178607],

Cell["You can enable logging in two ways. ", "Text",
 CellTags->"b:2.1.0",
 CellID->874133784],

Cell[TextData[{
 "Log server messages to ",
 StyleBox["stdout", "InlineCode"],
 " by",
 " using the option ",
 StyleBox["-foreground", "InlineCode"],
 " to keep ",
 StyleBox["mathlm", "InlineCode"],
 " in the foreground. "
}], "BulletedText",
 CellMargins->{{Inherited, Inherited}, {Inherited, 3}},
 CellTags->"b:2.1.0",
 CellID->246885],

Cell[CellGroupData[{

Cell[TextData[{
 "Log server messages to a specific file using the option ",
 StyleBox["-logfile ", "InlineCode"],
 StyleBox["file", "TI"],
 "."
}], "BulletedText",
 CellMargins->{{Inherited, Inherited}, {Inherited, 3}},
 CellTags->"b:2.1.0",
 CellID->581102753],

Cell["\<\
The log file records messages as they occur, building up a detailed record of \
license activity over a period of time.\
\>", "Text",
 CellTags->"b:2.1.0",
 CellID->493002678]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax of the Log File", "Section",
 CellTags->{"i:4b", "b:2.1.1", "net: 2"},
 CellID->12514840],

Cell[TextData[{
 "By default, ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " generates all log files in the W3C Common Logfile Format used by web \
servers such as Apache. However, you can customize the format by using the \
option ",
 StyleBox["-logformat", "InlineCode"],
 ". This option takes a string argument that specifies the format in which \
server messages are displayed. The string contains a series of commands of \
the form ",
 StyleBox["%", "InlineCode"],
 StyleBox["var", "TI"],
 StyleBox["#", "InlineCode"],
 ", where"
}], "Text",
 CellTags->"b:2.1.1",
 CellID->633729005],

Cell[TextData[{
 StyleBox["var", "TI"],
 " is a letter representing one of nine variables, such as the host, user, \
day, time, or event. "
}], "BulletedText",
 CellTags->"b:2.1.1",
 CellID->78461994],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["#", "InlineCode"],
 " is a number defining a specific format for the variable ",
 StyleBox["var", "TI"],
 "."
}], "BulletedText",
 CellTags->"b:2.1.1",
 CellID->194715797],

Cell[TextData[{
 "For example, ",
 StyleBox["%y1", "InlineCode"],
 " means that the year is displayed in two-digit format (e.g., 06), while ",
 StyleBox["%y2", "InlineCode"],
 " displays the year in four-digit format (e.g., 2006)."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->506819677],

Cell[TextData[{
 "In addition to the ",
 StyleBox["%", "InlineCode"],
 StyleBox["var", "TI"],
 StyleBox["#", "InlineCode"],
 " commands, the string can also include plain text such as brackets, dashes, \
quotation marks, and arbitrary comments. The text can be used to include \
comments and separators in the server messages for formatting purposes. All \
text included in the string appears literally in the server message with the \
following two exceptions: use ",
 StyleBox["%q", "InlineCode"],
 " to include a double quote (\"), and use ",
 StyleBox["%%", "InlineCode"],
 " to include a percentage sign (%)."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->820792186],

Cell[TextData[{
 "You must specify the type of messages that should be logged using the \
option ",
 StyleBox["-loglevel", "InlineCode"],
 ", as explained in \"",
 ButtonBox["Launching ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LaunchingMathLM"],
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LaunchingMathLM"],
  FontSlant->"Italic"],
 "\"."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->89928321],

Cell["\<\
Here is a list of variables that can be included in the string, along with \
their numeric values and formats.\
\>", "Text",
 CellTags->"b:2.1.1",
 CellID->7589973]
}, Open  ]],

Cell[TextData[StyleBox["%h#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->446095955],

Cell[TextData[StyleBox["Host", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->154801470],

Cell["1 \[Dash] IP address", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->385936679],

Cell["2 \[Dash] Hostname", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->231752268],

Cell["\<\
3 \[Dash] Fully qualified domain name\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->200017370],

Cell[TextData[StyleBox["%u#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->785769717],

Cell[TextData[StyleBox["User", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->330052903],

Cell["1 \[Dash] User ID ", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->165550392],

Cell["2 \[Dash] Username", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->55412157],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " All Windows clients on a network have the same user ID ",
 "(set to the number 65535 by default). Hence, the user ID setting is only \
meaningful for clients running Unix, Linux, or Mac OS X."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->191617310],

Cell[TextData[StyleBox["%d", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->25657748],

Cell[TextData[StyleBox["Day of month", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->28432228],

Cell["[ 1 ... 31 ]", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->138527761],

Cell[TextData[StyleBox["%w#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->97028256],

Cell[TextData[StyleBox["Day of week", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->32363060],

Cell["1 \[Dash] Numeric [ 1 ... 7 ] ", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->126387122],

Cell["\<\
2 \[Dash] Abbreviated [ Sun ... Sat ] \
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->127445271],

Cell["\<\
3 \[Dash] Verbose [ Sunday ... Saturday ]\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->88278112],

Cell[TextData[StyleBox["%m#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->770722875],

Cell[TextData[StyleBox["Month", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->613868546],

Cell["1 \[Dash] Numeric [ 01 ... 12 ] ", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->139572830],

Cell["\<\
2 \[Dash] Abbreviated [ Jan ... Dec ] \
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->91586182],

Cell["\<\
3 \[Dash] Verbose [ January ... December ]\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->66574282],

Cell[TextData[StyleBox["%y#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->26624042],

Cell[TextData[StyleBox["Year", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->84698321],

Cell["1 \[Dash] Two-digit [ 06 ] ", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->499027260],

Cell["2 \[Dash] Four-digit [ 2006 ]", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->85614070],

Cell[TextData[StyleBox["%t#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->441387293],

Cell[TextData[StyleBox["Time", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->113654455],

Cell["1 \[Dash] Twelve-hour (10:20:15) ", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->41038436],

Cell["\<\
2 \[Dash] Twenty-four-hour (22:20:15) \
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->424562851],

Cell["3 \[Dash] GMT offset (-0500)", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->211022406],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " To use the GMT offset format (",
 StyleBox["%t3", "InlineCode"],
 "), you must also use the ",
 StyleBox["-localtime", "InlineCode"],
 " option when starting ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->11415644],

Cell[TextData[StyleBox["%e#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->120604351],

Cell[TextData[StyleBox["Event", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->160454172],

Cell["1 \[Dash] Numeric", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->524793291],

Cell["2 \[Dash] Verbose", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->259124023],

Cell[TextData[StyleBox["%r#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.1",
 CellID->135636484],

Cell[TextData[StyleBox["Response", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->130935919],

Cell["1 \[Dash] Numeric ", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->478040424],

Cell["2 \[Dash] Verbose", "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->14794751]
}, Open  ]],

Cell[CellGroupData[{

Cell["Samples and Behavior", "Section",
 CellTags->{"b:2.1.1", "i:4c", "net: 3"},
 CellID->91282893],

Cell[TextData[{
 "Running the command ",
 StyleBox["mathlm -logfile log.txt", "InlineCode"],
 ", without the option ",
 StyleBox["-logformat", "InlineCode"],
 ", generates messages in the default format. An example of messages in the \
default format, as contained in ",
 StyleBox["log.txt", "InlineCode"],
 ", follows."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->75185663],

Cell["\<\
hostname.domain.com - username [01/Jan/2006:22:01:35] \"MathLM 6.0 executable \
launched\" \".\\mathlm\" -
hostname.domain.com - username [01/Jan/2006:22:01:35] \"Verbosity level \
specified\" \"1\" -
hostname.domain.com - username [01/Jan/2006:22:01:35] \"Logging verbosity \
level specified\" \"3\" -
hostname.domain.com - username [01/Jan/2006:22:01:35] \"Hostname\" \
\"hostname.domain.com\" -\
\>", "Program",
 CellTags->"b:2.1.1",
 CellID->216189130],

Cell["\<\
The default format string, which mimics the Common Logfile Format, can be \
invoked by the following.\
\>", "Text",
 CellTags->"b:2.1.1",
 CellID->192468660],

Cell[TextData[StyleBox["%h3 - %u2 [%d/%m2/%y2:%t2 %t3] %q%e2%q %q%r2%q -", \
"InlineCode"]], "Text",
 CellTags->"b:2.1.1",
 CellID->275025322],

Cell[TextData[{
 "To specify the Common Logfile Format manually, you must specify this string \
as the value of the ",
 StyleBox["-logformat", "InlineCode"],
 " option, as in the following command. The messages generated by this \
command are in the same format as the previous example."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->123633214],

Cell[TextData[StyleBox["mathlm -logfile log.txt -logformat \"%h3 - %u2 \
[%d/%m2/%y2:%t2 %t3] %q%e2%q %q%r2%q -\" ", "InlineCode"]], "Text",
 CellTags->"b:2.1.1",
 CellID->425379999],

Cell[TextData[{
 "By default, time is displayed in GMT. If you want local time to be \
displayed instead, you must use the",
 StyleBox[" -localtime", "InlineCode"],
 " command-line option with either the ",
 StyleBox["%t1", "InlineCode"],
 " tag or the ",
 StyleBox["%t2", "InlineCode"],
 " tag. The ",
 StyleBox["%t3", "InlineCode"],
 " tag should not appear in the format string if you want local time to be \
displayed."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->120674711],

Cell["An alternate format string using local time follows.", "Text",
 CellTags->"b:2.1.1",
 CellID->39985399],

Cell[TextData[StyleBox["mathlm -logfile log.txt -localtime -logformat \"%h1 - \
%u2 [%m1-%d-%y1: %t1] %q%e2%q %q%r2%q -\" ", "InlineCode"]], "Text",
 CellTags->"b:2.1.1",
 CellID->324172440],

Cell[TextData[{
 "An example of server messages in this user-specified format, as contained \
in ",
 StyleBox["log.txt", "InlineCode"],
 ", is displayed here."
}], "Text",
 CellTags->"b:2.1.1",
 CellID->32807661],

Cell["\<\
192.168.1.9 - username [01-01-06: 04:32:51 PM] \"MathLM 6.0 executable \
launched\" \".\\mathlm\" -
192.168.1.9 - username [01-01-06: 04:32:51 PM] \"Default (Common Logfile \
Format) log format specified\" \"%h1 - %u2 [%m1-%d-%y1: %t1] %q%e2%q %q%r2%q \
-\" -
192.168.1.9 - username [01-01-06: 04:32:51 PM] \"Verbosity level specified\" \
\"1\" -
192.168.1.9 - username [01-01-06: 04:32:51 PM] \"Logging verbosity level \
specified\" \"3\" -
192.168.1.9 - username [01-01-06: 04:32:51 PM] \"Hostname\" \
\"hostname.domain.com\" -\
\>", "Program",
 CellTags->"b:2.1.1",
 CellID->644021947],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->420358658],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Logging MathLM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 45.9603476}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "You can enable logging in two ways. The log file records messages as \
they occur, building up a detailed record of license activity over a period \
of time. By default, MathLM generates all log files in the W3C Common Logfile \
Format used by web servers such as Apache. However, you can customize the \
format by using the option -logformat. This option takes a string argument \
that specifies the format in which server messages are displayed. The string \
contains a series of commands of the form %var#, where", "synonyms" -> {}, 
    "title" -> "Logging MathLM", "type" -> "Tutorial", "uri" -> 
    "tutorial/LoggingMathLM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:1"->{
  Cell[1319, 44, 122, 6, 70, "Title",
   CellTags->"i:1",
   CellID->526428705]},
 "i:4"->{
  Cell[1466, 54, 96, 2, 70, "Section",
   CellTags->{"i:4", "b:2.1.1", "net: 2"},
   CellID->875178607]},
 "b:2.1.1"->{
  Cell[1466, 54, 96, 2, 70, "Section",
   CellTags->{"i:4", "b:2.1.1", "net: 2"},
   CellID->875178607],
  Cell[2523, 99, 102, 2, 70, "Section",
   CellTags->{"i:4b", "b:2.1.1", "net: 2"},
   CellID->12514840],
  Cell[2628, 103, 666, 19, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->633729005],
  Cell[3297, 124, 200, 6, 70, "BulletedText",
   CellTags->"b:2.1.1",
   CellID->78461994],
  Cell[3522, 134, 198, 7, 70, "BulletedText",
   CellTags->"b:2.1.1",
   CellID->194715797],
  Cell[3723, 143, 285, 8, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->506819677],
  Cell[4011, 153, 668, 16, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->820792186],
  Cell[4682, 171, 443, 15, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->89928321],
  Cell[5128, 188, 174, 5, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->7589973],
  Cell[5317, 196, 103, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->446095955],
  Cell[5423, 200, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->154801470],
  Cell[5531, 204, 95, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->385936679],
  Cell[5629, 208, 93, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->231752268],
  Cell[5725, 212, 120, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->200017370],
  Cell[5848, 218, 103, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->785769717],
  Cell[5954, 222, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->330052903],
  Cell[6062, 226, 93, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->165550392],
  Cell[6158, 230, 92, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->55412157],
  Cell[6253, 234, 308, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->191617310],
  Cell[6564, 243, 101, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->25657748],
  Cell[6668, 247, 112, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->28432228],
  Cell[6783, 251, 87, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->138527761],
  Cell[6873, 255, 102, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->97028256],
  Cell[6978, 259, 111, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->32363060],
  Cell[7092, 263, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->126387122],
  Cell[7200, 267, 121, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->127445271],
  Cell[7324, 273, 123, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->88278112],
  Cell[7450, 279, 103, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->770722875],
  Cell[7556, 283, 106, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->613868546],
  Cell[7665, 287, 107, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->139572830],
  Cell[7775, 291, 120, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->91586182],
  Cell[7898, 297, 124, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->66574282],
  Cell[8025, 303, 102, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->26624042],
  Cell[8130, 307, 104, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->84698321],
  Cell[8237, 311, 102, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->499027260],
  Cell[8342, 315, 103, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->85614070],
  Cell[8448, 319, 103, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->441387293],
  Cell[8554, 323, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->113654455],
  Cell[8662, 327, 107, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->41038436],
  Cell[8772, 331, 121, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->424562851],
  Cell[8896, 337, 103, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->211022406],
  Cell[9002, 341, 399, 14, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->11415644],
  Cell[9404, 357, 103, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->120604351],
  Cell[9510, 361, 106, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->160454172],
  Cell[9619, 365, 92, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->524793291],
  Cell[9714, 369, 92, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->259124023],
  Cell[9809, 373, 103, 2, 70, "IndentedText",
   CellTags->"b:2.1.1",
   CellID->135636484],
  Cell[9915, 377, 109, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->130935919],
  Cell[10027, 381, 93, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->478040424],
  Cell[10123, 385, 91, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.1",
   CellID->14794751],
  Cell[10251, 392, 100, 2, 70, "Section",
   CellTags->{"b:2.1.1", "i:4c", "net: 3"},
   CellID->91282893],
  Cell[10354, 396, 373, 11, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->75185663],
  Cell[10730, 409, 466, 11, 70, "Program",
   CellTags->"b:2.1.1",
   CellID->216189130],
  Cell[11199, 422, 167, 5, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->192468660],
  Cell[11369, 429, 142, 3, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->275025322],
  Cell[11514, 434, 341, 8, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->123633214],
  Cell[11858, 444, 182, 3, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->425379999],
  Cell[12043, 449, 477, 14, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->120674711],
  Cell[12523, 465, 109, 2, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->39985399],
  Cell[12635, 469, 190, 3, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->324172440],
  Cell[12828, 474, 212, 7, 70, "Text",
   CellTags->"b:2.1.1",
   CellID->32807661],
  Cell[13043, 483, 598, 14, 70, "Program",
   CellTags->"b:2.1.1",
   CellID->644021947]},
 "net: 2"->{
  Cell[1466, 54, 96, 2, 70, "Section",
   CellTags->{"i:4", "b:2.1.1", "net: 2"},
   CellID->875178607],
  Cell[2523, 99, 102, 2, 70, "Section",
   CellTags->{"i:4b", "b:2.1.1", "net: 2"},
   CellID->12514840]},
 "b:2.1.0"->{
  Cell[1565, 58, 94, 2, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->874133784],
  Cell[1662, 62, 337, 12, 70, "BulletedText",
   CellTags->"b:2.1.0",
   CellID->246885],
  Cell[2024, 78, 262, 8, 70, "BulletedText",
   CellTags->"b:2.1.0",
   CellID->581102753],
  Cell[2289, 88, 185, 5, 70, "Text",
   CellTags->"b:2.1.0",
   CellID->493002678]},
 "i:4b"->{
  Cell[2523, 99, 102, 2, 70, "Section",
   CellTags->{"i:4b", "b:2.1.1", "net: 2"},
   CellID->12514840]},
 "i:4c"->{
  Cell[10251, 392, 100, 2, 70, "Section",
   CellTags->{"b:2.1.1", "i:4c", "net: 3"},
   CellID->91282893]},
 "net: 3"->{
  Cell[10251, 392, 100, 2, 70, "Section",
   CellTags->{"b:2.1.1", "i:4c", "net: 3"},
   CellID->91282893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:1", 15706, 554},
 {"i:4", 15798, 558},
 {"b:2.1.1", 15918, 562},
 {"net: 2", 21895, 749},
 {"b:2.1.0", 22121, 756},
 {"i:4b", 22482, 769},
 {"i:4c", 22600, 773},
 {"net: 3", 22722, 777}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 694, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1319, 44, 122, 6, 70, "Title",
 CellTags->"i:1",
 CellID->526428705],
Cell[CellGroupData[{
Cell[1466, 54, 96, 2, 70, "Section",
 CellTags->{"i:4", "b:2.1.1", "net: 2"},
 CellID->875178607],
Cell[1565, 58, 94, 2, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->874133784],
Cell[1662, 62, 337, 12, 70, "BulletedText",
 CellTags->"b:2.1.0",
 CellID->246885],
Cell[CellGroupData[{
Cell[2024, 78, 262, 8, 70, "BulletedText",
 CellTags->"b:2.1.0",
 CellID->581102753],
Cell[2289, 88, 185, 5, 70, "Text",
 CellTags->"b:2.1.0",
 CellID->493002678]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2523, 99, 102, 2, 70, "Section",
 CellTags->{"i:4b", "b:2.1.1", "net: 2"},
 CellID->12514840],
Cell[2628, 103, 666, 19, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->633729005],
Cell[3297, 124, 200, 6, 70, "BulletedText",
 CellTags->"b:2.1.1",
 CellID->78461994],
Cell[CellGroupData[{
Cell[3522, 134, 198, 7, 70, "BulletedText",
 CellTags->"b:2.1.1",
 CellID->194715797],
Cell[3723, 143, 285, 8, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->506819677],
Cell[4011, 153, 668, 16, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->820792186],
Cell[4682, 171, 443, 15, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->89928321],
Cell[5128, 188, 174, 5, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->7589973]
}, Open  ]],
Cell[5317, 196, 103, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->446095955],
Cell[5423, 200, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->154801470],
Cell[5531, 204, 95, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->385936679],
Cell[5629, 208, 93, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->231752268],
Cell[5725, 212, 120, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->200017370],
Cell[5848, 218, 103, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->785769717],
Cell[5954, 222, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->330052903],
Cell[6062, 226, 93, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->165550392],
Cell[6158, 230, 92, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->55412157],
Cell[6253, 234, 308, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->191617310],
Cell[6564, 243, 101, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->25657748],
Cell[6668, 247, 112, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->28432228],
Cell[6783, 251, 87, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->138527761],
Cell[6873, 255, 102, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->97028256],
Cell[6978, 259, 111, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->32363060],
Cell[7092, 263, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->126387122],
Cell[7200, 267, 121, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->127445271],
Cell[7324, 273, 123, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->88278112],
Cell[7450, 279, 103, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->770722875],
Cell[7556, 283, 106, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->613868546],
Cell[7665, 287, 107, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->139572830],
Cell[7775, 291, 120, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->91586182],
Cell[7898, 297, 124, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->66574282],
Cell[8025, 303, 102, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->26624042],
Cell[8130, 307, 104, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->84698321],
Cell[8237, 311, 102, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->499027260],
Cell[8342, 315, 103, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->85614070],
Cell[8448, 319, 103, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->441387293],
Cell[8554, 323, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->113654455],
Cell[8662, 327, 107, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->41038436],
Cell[8772, 331, 121, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->424562851],
Cell[8896, 337, 103, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->211022406],
Cell[9002, 341, 399, 14, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->11415644],
Cell[9404, 357, 103, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->120604351],
Cell[9510, 361, 106, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->160454172],
Cell[9619, 365, 92, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->524793291],
Cell[9714, 369, 92, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->259124023],
Cell[9809, 373, 103, 2, 70, "IndentedText",
 CellTags->"b:2.1.1",
 CellID->135636484],
Cell[9915, 377, 109, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->130935919],
Cell[10027, 381, 93, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->478040424],
Cell[10123, 385, 91, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.1",
 CellID->14794751]
}, Open  ]],
Cell[CellGroupData[{
Cell[10251, 392, 100, 2, 70, "Section",
 CellTags->{"b:2.1.1", "i:4c", "net: 3"},
 CellID->91282893],
Cell[10354, 396, 373, 11, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->75185663],
Cell[10730, 409, 466, 11, 70, "Program",
 CellTags->"b:2.1.1",
 CellID->216189130],
Cell[11199, 422, 167, 5, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->192468660],
Cell[11369, 429, 142, 3, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->275025322],
Cell[11514, 434, 341, 8, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->123633214],
Cell[11858, 444, 182, 3, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->425379999],
Cell[12043, 449, 477, 14, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->120674711],
Cell[12523, 465, 109, 2, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->39985399],
Cell[12635, 469, 190, 3, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->324172440],
Cell[12828, 474, 212, 7, 70, "Text",
 CellTags->"b:2.1.1",
 CellID->32807661],
Cell[13043, 483, 598, 14, 70, "Program",
 CellTags->"b:2.1.1",
 CellID->644021947],
Cell[CellGroupData[{
Cell[13666, 501, 72, 1, 70, "RelatedTutorialsSection",
 CellID->420358658],
Cell[13741, 504, 214, 5, 70, "RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[13994, 514, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

