(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20739,        751]
NotebookOptionsPosition[     15390,        583]
NotebookOutlinePosition[     18303,        657]
CellTagsIndexPosition[     18212,        651]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], 
          "PiecewiseExpand" :> 
          Documentation`HelpLookup["paclet:ref/PiecewiseExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LogicalExpand\"\>", 
       2->"\<\"PiecewiseExpand\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Logical and Piecewise Functions", "Title",
 CellTags->{"S3.3.9", "9.1"},
 CellID->16713],

Cell[TextData[{
 "Nested logical and piecewise functions can be expanded out much like nested \
arithmetic functions. You can do this using ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27666],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LogicalExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogicalExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "expand out logical functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PiecewiseExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PiecewiseExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "expand out piecewise functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PiecewiseExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PiecewiseExpand"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["assum", "TI"], "]"}], Cell[
    "expand out with the specified assumptions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16030],

Cell["Expanding out logical and piecewise functions. ", "Caption",
 CellID->10806],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " puts logical expressions into a standard ",
 StyleBox["disjunctive normal form",
  FontSlant->"Italic"],
 " (DNF), consisting of an OR of ANDs."
}], "Text",
 CellID->27109],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves this expression unchanged. "
}], "MathCaption",
 CellID->24290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "||", "b"}], ")"}], "&&", "c"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29059],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "||", "b"}], ")"}], "&&", "c"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->31684]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " expands this into an OR of ANDs. "
}], "MathCaption",
 CellID->4546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->32759],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "c"}], ")"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->31103]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " works on all logical functions, always converting them into a standard OR \
of ANDs form. Sometimes the results are inevitably quite large. "
}], "Text",
 CellID->606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 " can be expressed as an OR of ANDs. "
}], "MathCaption",
 CellID->391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Xor", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->2093],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "b", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"a", "&&", 
    RowBox[{"!", "b"}], "&&", 
    RowBox[{"!", "c"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", 
    RowBox[{"!", "a"}], "&&", 
    RowBox[{"!", "c"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"c", "&&", 
    RowBox[{"!", "a"}], "&&", 
    RowBox[{"!", "b"}]}], ")"}]}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->13196]
}, Open  ]],

Cell[TextData[{
 "Any collection of nested conditionals can always in effect be flattened \
into a ",
 StyleBox["piecewise normal form",
  FontSlant->"Italic"],
 " consisting of a single ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " object. You can do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20583],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves this expression unchanged. "
}], "MathCaption",
 CellID->17950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"x", "<", "1"}], ",", "a", ",", "b"}], "]"}], ",", "c"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->17557],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"x", "<", "1"}], ",", "a", ",", "b"}], "]"}], ",", "c"}], 
  "]"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->7435]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " flattens it into a single ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->12],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->6667],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"a", 
     RowBox[{"0", "<", "x", "<", "1"}]},
    {"b", 
     RowBox[{"x", "\[GreaterEqual]", "1"}]},
    {"c", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.84}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{82, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->10869]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ", as well as ",
 Cell[BoxData[
  ButtonBox["Clip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clip"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 ", implicitly involve conditionals, and combinations of them can again be \
reduced to a single ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " object using ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->10165],

Cell[TextData[{
 "This gives a result as a single ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->1903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30973],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"a", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "-", "c"}], ">", "0"}], "&&", 
      RowBox[{
       RowBox[{"a", "-", "b"}], "\[LessEqual]", "0"}]}]},
    {"b", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "-", "b"}], ">", "0"}], "&&", 
      RowBox[{
       RowBox[{"b", "-", "c"}], ">", "0"}]}]},
    {"c", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.84}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{148, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->27791]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["x"], "InlineFormula"],
 " assumed real, this can also be written as a ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->2516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"x", " ", "\[Element]", " ", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->6149],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VM0OgjAMrjJEjRoP/pCYGJ5D9OBFTz7EYkzkYDTI+2MHBWc3EDVxydb1
6/pfOMjkfLrIJDrKYB/L2zk63oPdNUbIaQHAFvfCB7yneMv2Nk2R6qeDp4Mi
F2kbaZvolHAld4kqPLtAvtRbQZQESiXNFnTUIZ48wJy94BqcL+LRMWH15VF0
fhMPbslTKv/y4f5YK+VdVGdgRw1fvNMzXnXCqQyQS3SNYmYcq/2lkQuv76RS
zyviMaRhhhYRbEpOf7OuQe32fkEHrCqc71nqXl21oVG1kYF0ybL3QbfVZOnf
71izUUbZ0NaI2eh9EU+TPPtMp2bmy1l8141xjY1VjSx86Vr+z4TWA68nsgw=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->12678197]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FractionalPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionalPart"]], "InlineFormula"],
 " can also be expressed in terms of ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 " objects, though in principle they can involve an infinite number of cases. \
"
}], "Text",
 CellID->30118],

Cell[TextData[{
 "Without a bound on ",
 Cell[BoxData["x"], "InlineFormula"],
 ", this would yield an infinite number of cases. "
}], "MathCaption",
 CellID->24243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "2"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->3388],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"1", "\[LessEqual]", "x", "<", 
      SqrtBox["2"]}]},
    {"2", 
     RowBox[{
      SqrtBox["2"], "\[LessEqual]", "x", "<", 
      SqrtBox["3"]}]},
    {"3", 
     RowBox[{"x", "\[GreaterEqual]", 
      SqrtBox["3"]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.84}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{116, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->2497]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default limits the number of cases that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will explicitly generate in the expansion of any single piecewise function \
such as ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 " at any stage in a computation. You can change this limit by resetting the \
value of ",
 Cell[BoxData[
  ButtonBox["$MaxPiecewiseCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPiecewiseCases"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27711],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->53785251],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Logical and Piecewise Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExpressionsInvolvingComplexVariables"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Simplification"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 46.1634778}", "context" -> "", 
    "keywords" -> {
     "Boolean expansion", "CNF", "conditionals", "conjunctive normal form", 
      "de-nesting", "disjunctive normal form", "DNF", "expansion", 
      "flattening", "LogicalExpand", "PiecewiseExpand", "PNF", 
      "two-level logic", "MaxPiecewiseCases"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Nested logical and piecewise functions can be expanded out much like \
nested arithmetic functions. You can do this using LogicalExpand and \
PiecewiseExpand. Expanding out logical and piecewise functions. LogicalExpand \
puts logical expressions into a standard disjunctive normal form (DNF), \
consisting of an OR of ANDs.", "synonyms" -> {"3.3.9"}, "title" -> 
    "Logical and Piecewise Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/LogicalAndPiecewiseFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.9"->{
  Cell[1966, 61, 94, 2, 70, "Title",
   CellTags->{"S3.3.9", "9.1"},
   CellID->16713]},
 "9.1"->{
  Cell[1966, 61, 94, 2, 70, "Title",
   CellTags->{"S3.3.9", "9.1"},
   CellID->16713]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.9", 18001, 640},
 {"9.1", 18100, 644}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1341, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1966, 61, 94, 2, 70, "Title",
 CellTags->{"S3.3.9", "9.1"},
 CellID->16713],
Cell[2063, 65, 448, 14, 70, "Text",
 CellID->27666],
Cell[2514, 81, 1258, 37, 70, "DefinitionBox",
 CellID->16030],
Cell[3775, 120, 82, 1, 70, "Caption",
 CellID->10806],
Cell[3860, 123, 320, 10, 70, "Text",
 CellID->27109],
Cell[4183, 135, 155, 6, 70, "MathCaption",
 CellID->24290],
Cell[CellGroupData[{
Cell[4363, 145, 138, 5, 28, "Input",
 CellID->29059],
Cell[4504, 152, 226, 8, 36, "Output",
 CellID->31684]
}, Open  ]],
Cell[4745, 163, 216, 7, 70, "MathCaption",
 CellID->4546],
Cell[CellGroupData[{
Cell[4986, 174, 106, 3, 28, "Input",
 CellID->32759],
Cell[5095, 179, 275, 10, 36, "Output",
 CellID->31103]
}, Open  ]],
Cell[5385, 192, 315, 8, 70, "Text",
 CellID->606],
Cell[5703, 202, 197, 7, 70, "MathCaption",
 CellID->391],
Cell[CellGroupData[{
Cell[5925, 213, 169, 5, 70, "Input",
 CellID->2093],
Cell[6097, 220, 557, 20, 36, "Output",
 CellID->13196]
}, Open  ]],
Cell[6669, 243, 571, 20, 70, "Text",
 CellID->20583],
Cell[7243, 265, 155, 6, 70, "MathCaption",
 CellID->17950],
Cell[CellGroupData[{
Cell[7423, 275, 246, 9, 70, "Input",
 CellID->17557],
Cell[7672, 286, 334, 12, 36, "Output",
 CellID->7435]
}, Open  ]],
Cell[8021, 301, 346, 12, 70, "MathCaption",
 CellID->12],
Cell[CellGroupData[{
Cell[8392, 317, 107, 3, 70, "Input",
 CellID->6667],
Cell[8502, 322, 683, 22, 64, "Output",
 CellID->10869]
}, Open  ]],
Cell[9200, 347, 928, 34, 70, "Text",
 CellID->10165],
Cell[10131, 383, 220, 8, 70, "MathCaption",
 CellID->1903],
Cell[CellGroupData[{
Cell[10376, 395, 220, 7, 70, "Input",
 CellID->30973],
Cell[10599, 404, 893, 30, 64, "Output",
 CellID->27791]
}, Open  ]],
Cell[11507, 437, 281, 10, 70, "MathCaption",
 CellID->2516],
Cell[CellGroupData[{
Cell[11813, 451, 208, 6, 28, "Input",
 CellID->6149],
Cell[12024, 459, 577, 14, 48, "Output",
 Evaluatable->False,
 CellID->12678197]
}, Open  ]],
Cell[12616, 476, 676, 24, 70, "Text",
 CellID->30118],
Cell[13295, 502, 164, 5, 70, "MathCaption",
 CellID->24243],
Cell[CellGroupData[{
Cell[13484, 511, 222, 7, 70, "Input",
 CellID->3388],
Cell[13709, 520, 708, 23, 78, "Output",
 CellID->2497]
}, Open  ]],
Cell[14432, 546, 630, 20, 70, "Text",
 CellID->27711],
Cell[CellGroupData[{
Cell[15087, 570, 71, 1, 70, "RelatedTutorialsSection",
 CellID->53785251],
Cell[15161, 573, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[15363, 581, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

