(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25157,        888]
NotebookOptionsPosition[     17823,        648]
NotebookOutlinePosition[     20875,        723]
CellTagsIndexPosition[     20784,        717]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MachineEpsilon" :> 
          Documentation`HelpLookup["paclet:ref/$MachineEpsilon"], 
          "$MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MachinePrecision"], 
          "$MaxMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MaxMachineNumber"], 
          "$MaxNumber" :> Documentation`HelpLookup["paclet:ref/$MaxNumber"], 
          "$MinMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinMachineNumber"], 
          "$MinNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MachineEpsilon\"\>", 
       2->"\<\"$MachinePrecision\"\>", 3->"\<\"$MaxMachineNumber\"\>", 
       4->"\<\"$MaxNumber\"\>", 5->"\<\"$MinMachineNumber\"\>", 
       6->"\<\"$MinNumber\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Machine\[Hyphen]Precision Numbers", "Title",
 CellTags->{"S3.1.6", "6.1"},
 CellID->22593],

Cell[TextData[{
 "Whenever machine\[Hyphen]precision numbers appear in a calculation, the \
whole calculation is typically done in machine precision. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will then give machine\[Hyphen]precision numbers as the result. "
}], "Text",
 CellID->18664],

Cell[TextData[{
 "Whenever the input contains any machine\[Hyphen]precision numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does the computation to machine precision. "
}], "MathCaption",
 CellID->14442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.4444444444444444444", "^", "5.7"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27444],

Cell[BoxData["8.133824626581532`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->15833]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"], "[", "5.6", "]"}]], "InlineFormula"],
 " yields a machine\[Hyphen]precision result, so the ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " is irrelevant. "
}], "MathCaption",
 CellID->30736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", "5.6", "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->6502],

Cell[BoxData["1.0233754792270298`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->21025]
}, Open  ]],

Cell["\<\
This gives a higher\[Hyphen]precision result. \
\>", "MathCaption",
 CellID->27559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", 
    RowBox[{"56", "/", "10"}], "]"}], ",", "30"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->17953],

Cell[BoxData["1.02337547922702991086041788102601281145090840545`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->11007]
}, Open  ]],

Cell[TextData[{
 "When you do calculations with arbitrary\[Hyphen]precision numbers, as \
discussed in \"",
 ButtonBox["Arbitrary\[Hyphen]Precision Numbers\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always keeps track of the precision of your results, and gives only those \
digits which are known to be correct, given the precision of your input. When \
you do calculations with machine\[Hyphen]precision numbers, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always gives you a machine\[Hyphen]precision result, whether or not all \
the digits in the result can, in fact, be determined to be correct on the \
basis of your input. "
}], "Text",
 CellID->8750299],

Cell["\<\
This subtracts two machine\[Hyphen]precision numbers. \
\>", "MathCaption",
 CellID->31543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diff", "=", 
  RowBox[{"1.11111111", "-", "1.11111000"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21129],

Cell[BoxData["1.1099999999153454`*^-6"], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->2751]
}, Open  ]],

Cell["The result is taken to have machine precision. ", "MathCaption",
 CellID->21070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "diff", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->27395],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->21228]
}, Open  ]],

Cell["Here are all the digits in the result. ", "MathCaption",
 CellID->17541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "diff", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30059],

Cell["1.1099999999153454`*^-6", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//InputForm= ",
 CellID->3220]
}, Open  ]],

Cell[TextData[{
 "The fact that you can get spurious digits in machine\[Hyphen]precision \
numerical calculations with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is in many respects quite unsatisfactory. The ultimate reason, however, \
that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses fixed precision for these calculations is a matter of computational \
efficiency. "
}], "Text",
 CellID->22715],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is usually set up to insulate you as much as possible from the details of \
the computer system you are using. In dealing with machine\[Hyphen]precision \
numbers, you would lose too much, however, if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " did not make use of some specific features of your computer. "
}], "Text",
 CellID->20944],

Cell[TextData[{
 "The important point is that almost all computers have special hardware or \
microcode for doing floating\[Hyphen]point calculations to a particular fixed \
precision. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes use of these features when doing machine\[Hyphen]precision numerical \
calculations. "
}], "Text",
 CellID->22178],

Cell[TextData[{
 "The typical arrangement is that all machine\[Hyphen]precision numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are represented as \"double\[Hyphen]precision floating\[Hyphen]point \
numbers\" in the underlying computer system. On most current computers, such \
numbers contain a total of 64 binary bits, typically yielding 16 decimal \
digits of mantissa. "
}], "Text",
 CellID->7658],

Cell["\<\
The main advantage of using the built\[Hyphen]in floating\[Hyphen]point \
capabilities of your computer is speed. Arbitrary\[Hyphen]precision numerical \
calculations, which do not make such direct use of these capabilities, are \
usually many times slower than machine\[Hyphen]precision calculations. \
\>", "Text",
 CellID->5384],

Cell["\<\
There are several disadvantages of using built\[Hyphen]in \
floating\[Hyphen]point capabilities. One already mentioned is that it forces \
all numbers to have a fixed precision, independent of what precision can be \
justified for them. \
\>", "Text",
 CellID->7738],

Cell[TextData[{
 "A second disadvantage is that the treatment of machine\[Hyphen]precision \
numbers can vary slightly from one computer system to another. In working \
with machine\[Hyphen]precision numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is at the mercy of the floating\[Hyphen]point arithmetic system of each \
particular computer. If floating\[Hyphen]point arithmetic is done differently \
on two computers, you may get slightly different results for \
machine\[Hyphen]precision ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calculations on those computers."
}], "Text",
 CellID->30383],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachinePrecision"], Cell[
    "the number of decimal digits of precision", "TableText"]},
   {
    ButtonBox["$MachineEpsilon",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachineEpsilon"], Cell["\<\
the minimum positive machine\[Hyphen]precision number which can be added to \
1.0 to give a result distinguishable from 1.0\
\>", "TableText"]},
   {
    ButtonBox["$MaxMachineNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MaxMachineNumber"], Cell["\<\
the maximum machine\[Hyphen]precision number\
\>", "TableText"]},
   {
    ButtonBox["$MinMachineNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MinMachineNumber"], Cell["\<\
the minimum positive machine\[Hyphen]precision number\
\>", "TableText"]},
   {
    ButtonBox["$MaxNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MaxNumber"], Cell["\<\
the maximum magnitude of an arbitrary\[Hyphen]precision number\
\>", "TableText"]},
   {
    ButtonBox["$MinNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MinNumber"], Cell["\<\
the minimum magnitude of a positive arbitrary\[Hyphen]precision number\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4638],

Cell["Properties of numbers on a particular computer system. ", "Caption",
 CellID->3737],

Cell[TextData[{
 "Since machine\[Hyphen]precision numbers on any particular computer system \
are represented by a definite number of binary bits, numbers which are too \
close together will have the same bit pattern, and so cannot be \
distinguished. The parameter ",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " gives the distance between ",
 Cell[BoxData["1.0"], "InlineFormula"],
 " and the closest number which has a distinct binary representation. "
}], "Text",
 CellID->13635],

Cell[TextData[{
 "This gives the value of ",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 " for the computer system on which these examples are run. "
}], "MathCaption",
 CellID->5030],

Cell[CellGroupData[{

Cell[BoxData["$MachineEpsilon"], "Input",
 CellLabel->"In[7]:= ",
 CellID->19782],

Cell[BoxData["2.220446049250313`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->32315]
}, Open  ]],

Cell[TextData[{
 "Although this prints as ",
 Cell[BoxData["1."], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that the result is larger than 1. "
}], "MathCaption",
 CellID->32080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "+", "$MachineEpsilon"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2021],

Cell[BoxData["1.0000000000000002`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252992728]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " reveals that the result is not exactly 1."
}], "MathCaption",
 CellID->14270935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17024685],

Cell["1.0000000000000002", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->259392547]
}, Open  ]],

Cell[TextData[{
 "Subtracting 1 gives ",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", "1."}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->9204],

Cell[BoxData["2.220446049250313`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->5446]
}, Open  ]],

Cell[TextData[{
 "This again prints as ",
 Cell[BoxData["1."], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->19412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "+", 
  RowBox[{"$MachineEpsilon", "/", "2"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->13004],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->21585472]
}, Open  ]],

Cell[TextData[{
 "In this case, however, the result is not distinguished from ",
 Cell[BoxData["1."], "InlineFormula"],
 " to machine precision."
}], "MathCaption",
 CellID->271085306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->504442533],

Cell["1.", "Output",
 ImageSize->{14, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//InputForm=",
 CellID->391762531]
}, Open  ]],

Cell["Subtracting 1 from the result yields 0. ", "MathCaption",
 CellID->28825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", "1."}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->1244],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->2549]
}, Open  ]],

Cell[TextData[{
 "Machine numbers have not only limited precision, but also limited \
magnitude. If you generate a number which lies outside the range specified by \
",
 Cell[BoxData[
  ButtonBox["$MinMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MaxMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically convert the number to arbitrary\[Hyphen]precision form. \
"
}], "Text",
 CellID->26994],

Cell["\<\
This is the maximum machine\[Hyphen]precision number which can be handled on \
the computer system used for this example. \
\>", "MathCaption",
 CellID->8529],

Cell[CellGroupData[{

Cell[BoxData["$MaxMachineNumber"], "Input",
 CellLabel->"In[12]:= ",
 CellID->20132],

Cell[BoxData["1.7976931348623157`*^308"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->9]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically converts any result larger than $MaxMachineNumber to \
arbitrary precision. "
}], "MathCaption",
 CellID->147443912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "$MaxMachineNumber"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->290054667],

Cell[BoxData["3.5953862697246314162905484746`15.954589770191005*^308"], \
"Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->11099710]
}, Open  ]],

Cell["\<\
Here is another computation whose result is outside the range of \
machine-precision numbers.\
\>", "MathCaption",
 CellID->22316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "1000.", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->2429],

Cell[BoxData["1.97007111401704699388887935224`12.954589770191003*^434"], \
"Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->7761]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->505740000],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Machine-Precision Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ArbitraryPrecisionNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/IntervalArithmetic"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 49.9917008}", "context" -> "", 
    "keywords" -> {
     "arithmetic", "double-precision", "double precision numbers", "epsilon", 
      "fixed-precision", "fixed precision numbers", "floating-point", 
      "floating point hardware", "hardware floating point", 
      "machine arithmetic", "machine-precision", "machine precision numbers", 
      "MachineEpsilon", "MachinePrecision", "MaxMachineNumber", "MaxNumber", 
      "MinMachineNumber", "MinNumber"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Whenever machine-precision numbers appear in a calculation, the whole \
calculation is typically done in machine precision. Mathematica will then \
give machine-precision numbers as the result. Whenever the input contains any \
machine-precision numbers, Mathematica does the computation to machine \
precision. Zeta[5.6] yields a machine-precision result, so the N is \
irrelevant. ", "synonyms" -> {"3.1.6"}, "title" -> 
    "Machine-Precision Numbers", "type" -> "Tutorial", "uri" -> 
    "tutorial/MachinePrecisionNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.6"->{
  Cell[2426, 69, 96, 2, 70, "Title",
   CellTags->{"S3.1.6", "6.1"},
   CellID->22593]},
 "6.1"->{
  Cell[2426, 69, 96, 2, 70, "Title",
   CellTags->{"S3.1.6", "6.1"},
   CellID->22593]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.6", 20573, 706},
 {"6.1", 20672, 710}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1801, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2426, 69, 96, 2, 70, "Title",
 CellTags->{"S3.1.6", "6.1"},
 CellID->22593],
Cell[2525, 73, 298, 7, 70, "Text",
 CellID->18664],
Cell[2826, 82, 219, 6, 70, "MathCaption",
 CellID->14442],
Cell[CellGroupData[{
Cell[3070, 92, 111, 3, 28, "Input",
 CellID->27444],
Cell[3184, 97, 172, 5, 36, "Output",
 CellID->15833]
}, Open  ]],
Cell[3371, 105, 375, 13, 70, "MathCaption",
 CellID->30736],
Cell[CellGroupData[{
Cell[3771, 122, 151, 5, 28, "Input",
 CellID->6502],
Cell[3925, 129, 173, 5, 36, "Output",
 CellID->21025]
}, Open  ]],
Cell[4113, 137, 93, 3, 70, "MathCaption",
 CellID->27559],
Cell[CellGroupData[{
Cell[4231, 144, 177, 6, 28, "Input",
 CellID->17953],
Cell[4411, 152, 210, 6, 36, "Output",
 CellID->11007]
}, Open  ]],
Cell[4636, 161, 782, 18, 70, "Text",
 CellID->8750299],
Cell[5421, 181, 101, 3, 70, "MathCaption",
 CellID->31543],
Cell[CellGroupData[{
Cell[5547, 188, 133, 4, 70, "Input",
 CellID->21129],
Cell[5683, 194, 176, 5, 36, "Output",
 CellID->2751]
}, Open  ]],
Cell[5874, 202, 86, 1, 70, "MathCaption",
 CellID->21070],
Cell[CellGroupData[{
Cell[5985, 207, 105, 3, 70, "Input",
 CellID->27395],
Cell[6093, 212, 171, 5, 36, "Output",
 CellID->21228]
}, Open  ]],
Cell[6279, 220, 78, 1, 70, "MathCaption",
 CellID->17541],
Cell[CellGroupData[{
Cell[6382, 225, 105, 3, 70, "Input",
 CellID->30059],
Cell[6490, 230, 179, 5, 50, "Output",
 CellID->3220]
}, Open  ]],
Cell[6684, 238, 424, 12, 70, "Text",
 CellID->22715],
Cell[7111, 252, 414, 10, 70, "Text",
 CellID->20944],
Cell[7528, 264, 360, 9, 70, "Text",
 CellID->22178],
Cell[7891, 275, 419, 9, 70, "Text",
 CellID->7658],
Cell[8313, 286, 341, 6, 70, "Text",
 CellID->5384],
Cell[8657, 294, 276, 6, 70, "Text",
 CellID->7738],
Cell[8936, 302, 623, 14, 70, "Text",
 CellID->30383],
Cell[9562, 318, 1614, 46, 70, "DefinitionBox",
 CellID->4638],
Cell[11179, 366, 89, 1, 70, "Caption",
 CellID->3737],
Cell[11271, 369, 574, 13, 70, "Text",
 CellID->13635],
Cell[11848, 384, 273, 8, 70, "MathCaption",
 CellID->5030],
Cell[CellGroupData[{
Cell[12146, 396, 81, 2, 70, "Input",
 CellID->19782],
Cell[12230, 400, 177, 5, 36, "Output",
 CellID->32315]
}, Open  ]],
Cell[12422, 408, 219, 8, 70, "MathCaption",
 CellID->32080],
Cell[CellGroupData[{
Cell[12666, 420, 102, 3, 70, "Input",
 CellID->2021],
Cell[12771, 425, 176, 5, 36, "Output",
 CellID->252992728]
}, Open  ]],
Cell[12962, 433, 220, 7, 70, "MathCaption",
 CellID->14270935],
Cell[CellGroupData[{
Cell[13207, 444, 100, 3, 70, "Input",
 CellID->17024685],
Cell[13310, 449, 178, 5, 50, "Output",
 CellID->259392547]
}, Open  ]],
Cell[13503, 457, 214, 8, 70, "MathCaption",
 CellID->17752],
Cell[CellGroupData[{
Cell[13742, 469, 89, 3, 70, "Input",
 CellID->9204],
Cell[13834, 474, 176, 5, 36, "Output",
 CellID->5446]
}, Open  ]],
Cell[14025, 482, 120, 5, 70, "MathCaption",
 CellID->19412],
Cell[CellGroupData[{
Cell[14170, 491, 126, 4, 70, "Input",
 CellID->13004],
Cell[14299, 497, 159, 5, 36, "Output",
 CellID->21585472]
}, Open  ]],
Cell[14473, 505, 184, 5, 70, "MathCaption",
 CellID->271085306],
Cell[CellGroupData[{
Cell[14682, 514, 101, 3, 70, "Input",
 CellID->504442533],
Cell[14786, 519, 161, 5, 50, "Output",
 CellID->391762531]
}, Open  ]],
Cell[14962, 527, 79, 1, 70, "MathCaption",
 CellID->28825],
Cell[CellGroupData[{
Cell[15066, 532, 90, 3, 70, "Input",
 CellID->1244],
Cell[15159, 537, 157, 5, 36, "Output",
 CellID->2549]
}, Open  ]],
Cell[15331, 545, 618, 19, 70, "Text",
 CellID->26994],
Cell[15952, 566, 168, 4, 70, "MathCaption",
 CellID->8529],
Cell[CellGroupData[{
Cell[16145, 574, 84, 2, 70, "Input",
 CellID->20132],
Cell[16232, 578, 175, 5, 36, "Output",
 CellID->9]
}, Open  ]],
Cell[16422, 586, 198, 6, 70, "MathCaption",
 CellID->147443912],
Cell[CellGroupData[{
Cell[16645, 596, 108, 3, 70, "Input",
 CellID->290054667],
Cell[16756, 601, 213, 6, 36, "Output",
 CellID->11099710]
}, Open  ]],
Cell[16984, 610, 140, 4, 70, "MathCaption",
 CellID->22316],
Cell[CellGroupData[{
Cell[17149, 618, 100, 3, 70, "Input",
 CellID->2429],
Cell[17252, 623, 262, 8, 36, "Output",
 CellID->7761]
}, Open  ]],
Cell[CellGroupData[{
Cell[17551, 636, 72, 1, 70, "RelatedTutorialsSection",
 CellID->505740000],
Cell[17626, 639, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[17796, 646, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

