(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21025,        742]
NotebookOptionsPosition[     14859,        563]
NotebookOutlinePosition[     18468,        645]
CellTagsIndexPosition[     18377,        639]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Transformation Rules and Definitions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Making Definitions for Functions", "Title",
 CellTags->{"S2.5.6", "6.1"},
 CellID->9133],

Cell[TextData[{
 ButtonBox["\"Defining Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DefiningFunctions"],
 " discussed how you can define functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In a typical case, you would type in ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 " to define a function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". (Actually, the definitions in \"",
 ButtonBox["Defining Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DefiningFunctions"],
 " used the ",
 Cell[BoxData[":="], "InlineFormula"],
 " operator, rather than the ",
 Cell[BoxData["="], "InlineFormula"],
 " one. \"",
 ButtonBox["Immediate and Delayed Definitions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ImmediateAndDelayedDefinitions"],
 " will explain exactly when to use each of the ",
 Cell[BoxData[":="], "InlineFormula"],
 " and ",
 Cell[BoxData["="], "InlineFormula"],
 " operators.) "
}], "Text",
 CellID->12930],

Cell[TextData[{
 "The definition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 " specifies that whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encounters an expression which matches the pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 ", it should replace the expression by ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 ". Since the pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " matches all expressions of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["anything", "TI"], "]"}]], "InlineFormula"],
 ", the definition applies to functions ",
 Cell[BoxData["f"], "InlineFormula"],
 " with any \[OpenCurlyDoubleQuote]argument\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->10746],

Cell[TextData[{
 "Function definitions like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 " can be compared with definitions like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], "=", "b"}]], "InlineFormula"],
 " for indexed variables discussed in \"",
 ButtonBox["Making Definitions for Indexed Objects\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MakingDefinitionsForIndexedObjects"],
 ". The definition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], "=", "b"}]], "InlineFormula"],
 " specifies that whenever the ",
 StyleBox["particular",
  FontSlant->"Italic"],
 " expression ",
 Cell[BoxData[
  RowBox[{"f", "[", "a", "]"}]], "InlineFormula"],
 " occurs, it is to be replaced by ",
 Cell[BoxData["b"], "InlineFormula"],
 ". But the definition says nothing about expressions such as ",
 Cell[BoxData[
  RowBox[{"f", "[", "y", "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData["f"], "InlineFormula"],
 " appears with another \[OpenCurlyDoubleQuote]index\[CloseCurlyDoubleQuote]. \
"
}], "Text",
 CellID->5532],

Cell[TextData[{
 "To define a \[OpenCurlyDoubleQuote]function\[CloseCurlyDoubleQuote], you \
need to specify values for expressions of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", where the argument ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " can be anything. You can do this by giving a definition for the pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 ", where the pattern object ",
 Cell[BoxData["x_"], "InlineFormula"],
 " stands for any expression. "
}], "Text",
 CellID->25283],

Cell[BoxData[GridBox[{
   {
    RowBox[{"f", "[", 
     StyleBox["x", "TI"], "]", "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "definition for a ",
     StyleBox["specific",
      FontSlant->"Italic"],
     " ",
     StyleBox["expression",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"f", "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "]", "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "definition for ",
     StyleBox["any expression",
      FontSlant->"Italic"],
     ", referred to as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30873],

Cell["\<\
The difference between defining an indexed variable and a function. \
\>", "Caption",
 CellID->30439],

Cell[TextData[{
 "Making definitions for ",
 Cell[BoxData[
  RowBox[{"f", "[", "2", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"f", "[", "a", "]"}]], "InlineFormula"],
 " can be thought of as being like giving values to various elements of an \
\[OpenCurlyDoubleQuote]array\[CloseCurlyDoubleQuote] named ",
 Cell[BoxData["f"], "InlineFormula"],
 ". Making a definition for ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " is like giving a value for a set of \[OpenCurlyDoubleQuote]array elements\
\[CloseCurlyDoubleQuote] with arbitrary \[OpenCurlyDoubleQuote]indices\
\[CloseCurlyDoubleQuote]. In fact, you can actually think of any function as \
being like an array with an arbitrarily variable index."
}], "Text",
 CellID->21880],

Cell[TextData[{
 "In mathematical terms, you can think of ",
 Cell[BoxData["f"], "InlineFormula"],
 " as a ",
 StyleBox["mapping",
  FontSlant->"Italic"],
 ". When you define values for, say, ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"f", "[", "2", "]"}]], "InlineFormula"],
 ", you specify the image of this mapping for various discrete points in its \
domain. Defining a value for ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " specifies the image of ",
 Cell[BoxData["f"], "InlineFormula"],
 " on a continuum of points. "
}], "Text",
 CellID->8835],

Cell[TextData[{
 "This defines a transformation rule for the ",
 StyleBox["specific",
  FontSlant->"Italic"],
 " ",
 StyleBox["expression",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "=", "u"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->20570],

Cell[BoxData["u"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->25589]
}, Open  ]],

Cell[TextData[{
 "When the specific expression ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " appears, it is replaced by ",
 Cell[BoxData["u"], "InlineFormula"],
 ". Other expressions of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["argument", "TI"], "]"}]], "InlineFormula"],
 " are, however, not modified. "
}], "MathCaption",
 CellID->7629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "+", 
  RowBox[{"f", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5560],

Cell[BoxData[
 RowBox[{"u", "+", 
  RowBox[{"f", "[", "y", "]"}]}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->29521]
}, Open  ]],

Cell[TextData[{
 "This defines a value for ",
 Cell[BoxData["f"], "InlineFormula"],
 " with ",
 StyleBox["any expression",
  FontSlant->"Italic"],
 " as an \[OpenCurlyDoubleQuote]argument\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->10597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->32189],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->13163]
}, Open  ]],

Cell[TextData[{
 "The old definition for the ",
 StyleBox["specific",
  FontSlant->"Italic"],
 " ",
 StyleBox["expression",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " is still used, but the new general definition for ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " is now used to find a value for ",
 Cell[BoxData[
  RowBox[{"f", "[", "y", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->30444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "+", 
  RowBox[{"f", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->18621],

Cell[BoxData[
 RowBox[{"u", "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->24705]
}, Open  ]],

Cell[TextData[{
 "This removes all definitions for ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2815],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->10713],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to define transformation rules for any expression or pattern. \
You can mix definitions for specific expressions such as ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"f", "[", "a", "]"}]], "InlineFormula"],
 " with definitions for patterns such as ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22334],

Cell[TextData[{
 "Many kinds of mathematical functions can be set up by mixing specific and \
general definitions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". As an example, consider the factorial function. This particular function \
is in fact built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (it is written ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "!"}]], "InlineFormula"],
 "). But you can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions to set up the function for yourself. "
}], "Text",
 CellID->16999],

Cell[TextData[{
 "The standard mathematical definition for the factorial function can be \
entered almost directly into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", in the form: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "n_", "]"}], ":=", 
    RowBox[{"n", " ", 
     RowBox[{"f", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}]}], ";", 
   RowBox[{
    RowBox[{"f", "[", "1", "]"}], "=", "1"}]}]], "InlineFormula"],
 ". This definition specifies that for any ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " should be replaced by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", 
   RowBox[{"f", "[", 
    RowBox[{
     StyleBox["n", "TI"], "-", "1"}], "]"}]}]], "InlineFormula"],
 ", except that when ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["1"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"f", "[", "1", "]"}]], "InlineFormula"],
 " should simply be replaced by\[NonBreakingSpace]",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Text",
 CellID->13137],

Cell["\<\
Here is the value of the factorial function with argument 1. \
\>", "MathCaption",
 CellID->25615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "1", "]"}], "=", "1"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->14164],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->32058]
}, Open  ]],

Cell["\<\
Here is the general recursion relation for the factorial function. \
\>", "MathCaption",
 CellID->23511],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"f", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->8383],

Cell["\<\
Now you can use these definitions to find values for the factorial function. \
\
\>", "MathCaption",
 CellID->6846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->20943],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->32737]
}, Open  ]],

Cell["\<\
The results are the same as you get from the built\[Hyphen]in version of \
factorial. \
\>", "MathCaption",
 CellID->29831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", "!"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->28655],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->12251]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->497990601],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Making Definitions for Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MakingDefinitionsForIndexedObjects"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheOrderingOfDefinitions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 50.3979612}", "context" -> "", 
    "keywords" -> {
     "arrays", "defining functions", "definitions", "factorial function", 
      "function definitions", "functions", "general definitions", "mappings", 
      "recursion", "specific definitions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "\"Defining Functions\" discussed how you can define functions in \
Mathematica. In a typical case, you would type in f[x_]=x^2 to define a \
function f. (Actually, the definitions in \"Defining Functions\" used the := \
operator, rather than the = one. \"Immediate and Delayed Definitions\" will \
explain exactly when to use each of the := and = operators.) The definition \
f[x_]=x^2 specifies that whenever Mathematica encounters an expression which \
matches the pattern f[x_], it should replace the expression by x^2. Since the \
pattern f[x_] matches all expressions of the form f[anything], the definition \
applies to functions f with any 'argument'. Function definitions like \
f[x_]=x^2 can be compared with definitions like f[a]=b for indexed variables \
discussed in \"Making Definitions for Indexed Objects\". The definition \
f[a]=b specifies that whenever the particular expression f[a] occurs, it is \
to be replaced by b. But the definition says nothing about expressions such \
as f[y], where f appears with another 'index'. ", "synonyms" -> {"2.5.6"}, 
    "title" -> "Making Definitions for Functions", "type" -> "Tutorial", 
    "uri" -> "tutorial/MakingDefinitionsForFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.6"->{
  Cell[1309, 44, 94, 2, 70, "Title",
   CellTags->{"S2.5.6", "6.1"},
   CellID->9133]},
 "6.1"->{
  Cell[1309, 44, 94, 2, 70, "Title",
   CellTags->{"S2.5.6", "6.1"},
   CellID->9133]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.6", 18168, 628},
 {"6.1", 18266, 632}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 94, 2, 70, "Title",
 CellTags->{"S2.5.6", "6.1"},
 CellID->9133],
Cell[1406, 48, 1049, 32, 70, "Text",
 CellID->12930],
Cell[2458, 82, 864, 26, 70, "Text",
 CellID->10746],
Cell[3325, 110, 1127, 34, 70, "Text",
 CellID->5532],
Cell[4455, 146, 591, 16, 70, "Text",
 CellID->25283],
Cell[5049, 164, 1028, 35, 70, "DefinitionBox",
 CellID->30873],
Cell[6080, 201, 111, 3, 70, "Caption",
 CellID->30439],
Cell[6194, 206, 773, 18, 70, "Text",
 CellID->21880],
Cell[6970, 226, 639, 20, 70, "Text",
 CellID->8835],
Cell[7612, 248, 276, 12, 70, "MathCaption",
 CellID->24987],
Cell[CellGroupData[{
Cell[7913, 264, 117, 4, 70, "Input",
 CellID->20570],
Cell[8033, 270, 155, 5, 36, "Output",
 CellID->25589]
}, Open  ]],
Cell[8203, 278, 383, 12, 70, "MathCaption",
 CellID->7629],
Cell[CellGroupData[{
Cell[8611, 294, 144, 5, 70, "Input",
 CellID->5560],
Cell[8758, 301, 205, 7, 36, "Output",
 CellID->29521]
}, Open  ]],
Cell[8978, 311, 249, 8, 70, "MathCaption",
 CellID->10597],
Cell[CellGroupData[{
Cell[9252, 323, 141, 5, 70, "Input",
 CellID->32189],
Cell[9396, 330, 178, 6, 36, "Output",
 CellID->13163]
}, Open  ]],
Cell[9589, 339, 486, 18, 70, "MathCaption",
 CellID->30444],
Cell[CellGroupData[{
Cell[10100, 361, 145, 5, 70, "Input",
 CellID->18621],
Cell[10248, 368, 201, 7, 36, "Output",
 CellID->24705]
}, Open  ]],
Cell[10464, 378, 131, 5, 70, "MathCaption",
 CellID->2815],
Cell[10598, 385, 98, 3, 70, "Input",
 CellID->10713],
Cell[10699, 390, 488, 15, 70, "Text",
 CellID->22334],
Cell[11190, 407, 573, 18, 70, "Text",
 CellID->16999],
Cell[11766, 427, 1152, 41, 70, "Text",
 CellID->13137],
Cell[12921, 470, 108, 3, 70, "MathCaption",
 CellID->25615],
Cell[CellGroupData[{
Cell[13054, 477, 117, 4, 70, "Input",
 CellID->14164],
Cell[13174, 483, 155, 5, 36, "Output",
 CellID->32058]
}, Open  ]],
Cell[13344, 491, 114, 3, 70, "MathCaption",
 CellID->23511],
Cell[13461, 496, 195, 7, 70, "Input",
 CellID->8383],
Cell[13659, 505, 125, 4, 70, "MathCaption",
 CellID->6846],
Cell[CellGroupData[{
Cell[13809, 513, 95, 3, 70, "Input",
 CellID->20943],
Cell[13907, 518, 161, 5, 36, "Output",
 CellID->32737]
}, Open  ]],
Cell[14083, 526, 133, 4, 70, "MathCaption",
 CellID->29831],
Cell[CellGroupData[{
Cell[14241, 534, 85, 3, 70, "Input",
 CellID->28655],
Cell[14329, 539, 161, 5, 36, "Output",
 CellID->12251]
}, Open  ]],
Cell[CellGroupData[{
Cell[14527, 549, 72, 1, 70, "RelatedTutorialsSection",
 CellID->497990601],
Cell[14602, 552, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[14832, 561, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

