(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20520,        725]
NotebookOptionsPosition[     13898,        524]
NotebookOutlinePosition[     17690,        618]
CellTagsIndexPosition[     17517,        610]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
          "Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Array\"\>", 2->"\<\"Clear\"\>", 
       3->"\<\"List\"\>", 4->"\<\"Table\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Making Definitions for Indexed Objects", "Title",
 CellTags->{"S2.5.5", "5.1"},
 CellID->24351],

Cell[TextData[{
 "In many kinds of calculations, you need to set up \"arrays\" which contain \
sequences of expressions, each specified by a certain index. One way to \
implement arrays in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is by using lists. You can define a list, say ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "=", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", then access its elements using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
 ", or modify them using ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["a", "TI"], "[", 
    RowBox[{"[", 
     StyleBox["i", "TI"], "]"}], "]"}], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". This approach has a drawback, however, in that it requires you to fill in \
all the elements when you first create the list. "
}], "Text",
 CellID->13290],

Cell[TextData[{
 "Often, it is more convenient to set up arrays in which you can fill in only \
those elements that you need at a particular time. You can do this by making \
definitions for expressions such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16052],

Cell[TextData[{
 "This defines a value for ",
 Cell[BoxData[
  RowBox[{"a", "[", "1", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "1", "]"}], "=", "9"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24420],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2046454751]
}, Open  ]],

Cell[TextData[{
 "This defines a value for ",
 Cell[BoxData[
  RowBox[{"a", "[", "2", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "2", "]"}], "=", "7"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29767],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1819312842]
}, Open  ]],

Cell[TextData[{
 "This shows all the values you have defined for expressions associated with \
",
 Cell[BoxData["a"], "InlineFormula"],
 " so far. "
}], "MathCaption",
 CellID->8034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "a"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32133],

Cell[CellGroupData[{

Cell["Global`a", "Print", "PrintUsage",
 CellTags->"Info3371545245-3425186",
 CellID->2117086424],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"a", "[", "1", "]"}], "=", "9"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"a", "[", "2", "]"}], "=", "7"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["a"],
  Editable->False]], "Print",
 CellTags->"Info3371545245-3425186",
 CellID->1697791031]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "You can define a value for ",
 Cell[BoxData[
  RowBox[{"a", "[", "5", "]"}]], "InlineFormula"],
 ", even though you have not yet given values to ",
 Cell[BoxData[
  RowBox[{"a", "[", "3", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"a", "[", "4", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "5", "]"}], "=", "0"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25387],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1468493875]
}, Open  ]],

Cell[TextData[{
 "This generates a list of the values of the ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"a", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->6615],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "7", ",", 
   RowBox[{"a", "[", "3", "]"}], ",", 
   RowBox[{"a", "[", "4", "]"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1743135727]
}, Open  ]],

Cell[TextData[{
 "You can think of the expression ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " as being like an \[OpenCurlyDoubleQuote]indexed\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]subscripted\[CloseCurlyDoubleQuote] variable."
}], "Text",
 CellID->24072],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["a", "TI"], "[", 
     StyleBox["i", "TI"], "]", "=", 
     StyleBox["value", "TI"]}], Cell[
    "add or overwrite a value", "TableText"]},
   {
    RowBox[{
     StyleBox["a", "TI"], "[", 
     StyleBox["i", "TI"], "]"}], Cell["access a value", "TableText"]},
   {
    RowBox[{
     StyleBox["a", "TI"], "[", 
     StyleBox["i", "TI"], "]", "=."}], Cell["remove a value", "TableText"]},
   {
    RowBox[{"?", 
     StyleBox["a", "TI"]}], Cell["show all defined values", "TableText"]},
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[
    "clear all defined values", "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Table",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Table"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["a", "TI"], "[", 
        StyleBox["i", "TI"], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["i", "TI"], ",", "1", ",", 
         StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     RowBox[{
      ButtonBox["Array",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Array"], "[", 
      RowBox[{
       StyleBox["a", "TI"], ",", 
       StyleBox["n", "TI"]}], "]"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "convert to an explicit ",
     Cell[BoxData[
      ButtonBox["List",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/List"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25061],

Cell["Manipulating indexed variables. ", "Caption",
 CellID->19952],

Cell[TextData[{
 "When you have an expression of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ", there is no requirement that the \[OpenCurlyDoubleQuote]index\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " be a number. In fact, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows the index to be any expression whatsoever. By using indices that \
are symbols, you can for example build up simple databases in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->10970],

Cell[TextData[{
 "This defines the \[OpenCurlyDoubleQuote]object\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["area"], "InlineFormula"],
 " with \[OpenCurlyDoubleQuote]index\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["square"], "InlineFormula"],
 " to have value ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"area", "[", "square", "]"}], "=", "1"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->18064],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1947588709]
}, Open  ]],

Cell[TextData[{
 "This adds another result to the ",
 Cell[BoxData["area"], "InlineFormula"],
 " \[OpenCurlyDoubleQuote]database\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->22050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"area", "[", "triangle", "]"}], "=", 
  RowBox[{"1", "/", "2"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1610],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->584626662]
}, Open  ]],

Cell[TextData[{
 "Here are the entries in the ",
 Cell[BoxData["area"], "InlineFormula"],
 " database so far. "
}], "MathCaption",
 CellID->12978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "area"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->22443],

Cell[CellGroupData[{

Cell["Global`area", "Print", "PrintUsage",
 CellTags->"Info3371545245-6231930",
 CellID->770171192],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"area", "[", "square", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"area", "[", "triangle", "]"}], "=", 
         FractionBox["1", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["area"],
  Editable->False]], "Print",
 CellTags->"Info3371545245-6231930",
 CellID->1332405385]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "You can use these definitions wherever you want. You have not yet assigned \
a value for ",
 Cell[BoxData[
  RowBox[{"area", "[", "pentagon", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   RowBox[{"area", "[", "square", "]"}]}], "+", 
  RowBox[{"area", "[", "pentagon", "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->22298],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"area", "[", "pentagon", "]"}]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1377864954]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->39338361],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Making Definitions for Indexed Objects - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SpecialFormsOfAssignment"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MakingDefinitionsForFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 50.7417200}", "context" -> "", 
    "keywords" -> {
     "arrays", "clear", "databases", "indexed variables", "lists", "objects", 
      "set", "sparse arrays", "subscripted variables", "table", "unset", 
      "variables"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In many kinds of calculations, you need to set up \"arrays\" which \
contain sequences of expressions, each specified by a certain index. One way \
to implement arrays in Mathematica is by using lists. You can define a list, \
say a={x,y,z,...}, then access its elements using a[[i]], or modify them \
using a[[i]]=value. This approach has a drawback, however, in that it \
requires you to fill in all the elements when you first create the list. \
Often, it is more convenient to set up arrays in which you can fill in only \
those elements that you need at a particular time. You can do this by making \
definitions for expressions such as a[i]. This defines a value for a[1]. ", 
    "synonyms" -> {"2.5.5"}, "title" -> 
    "Making Definitions for Indexed Objects", "type" -> "Tutorial", "uri" -> 
    "tutorial/MakingDefinitionsForIndexedObjects"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.5"->{
  Cell[2106, 62, 101, 2, 70, "Title",
   CellTags->{"S2.5.5", "5.1"},
   CellID->24351]},
 "5.1"->{
  Cell[2106, 62, 101, 2, 70, "Title",
   CellTags->{"S2.5.5", "5.1"},
   CellID->24351]},
 "Info3371545245-3425186"->{
  Cell[4902, 178, 97, 2, 70, "Print",
   CellTags->"Info3371545245-3425186",
   CellID->2117086424],
  Cell[5002, 182, 837, 26, 70, "Print",
   CellTags->"Info3371545245-3425186",
   CellID->1697791031]},
 "Info3371545245-6231930"->{
  Cell[11856, 444, 99, 2, 70, "Print",
   CellTags->"Info3371545245-6231930",
   CellID->770171192],
  Cell[11958, 448, 886, 27, 70, "Print",
   CellTags->"Info3371545245-6231930",
   CellID->1332405385]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.5", 16835, 585},
 {"5.1", 16935, 589},
 {"Info3371545245-3425186", 17054, 593},
 {"Info3371545245-6231930", 17288, 600}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1481, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2106, 62, 101, 2, 70, "Title",
 CellTags->{"S2.5.5", "5.1"},
 CellID->24351],
Cell[2210, 66, 1078, 33, 70, "Text",
 CellID->13290],
Cell[3291, 101, 353, 10, 70, "Text",
 CellID->16052],
Cell[3647, 113, 152, 6, 70, "MathCaption",
 CellID->12295],
Cell[CellGroupData[{
Cell[3824, 123, 116, 4, 28, "Input",
 CellID->24420],
Cell[3943, 129, 159, 5, 36, "Output",
 CellID->2046454751]
}, Open  ]],
Cell[4117, 137, 152, 6, 70, "MathCaption",
 CellID->14360],
Cell[CellGroupData[{
Cell[4294, 147, 116, 4, 28, "Input",
 CellID->29767],
Cell[4413, 153, 159, 5, 36, "Output",
 CellID->1819312842]
}, Open  ]],
Cell[4587, 161, 182, 6, 70, "MathCaption",
 CellID->8034],
Cell[CellGroupData[{
Cell[4794, 171, 83, 3, 70, "Input",
 CellID->32133],
Cell[CellGroupData[{
Cell[4902, 178, 97, 2, 70, "Print",
 CellTags->"Info3371545245-3425186",
 CellID->2117086424],
Cell[5002, 182, 837, 26, 70, "Print",
 CellTags->"Info3371545245-3425186",
 CellID->1697791031]
}, Open  ]]
}, Open  ]],
Cell[5866, 212, 346, 12, 70, "MathCaption",
 CellID->378],
Cell[CellGroupData[{
Cell[6237, 228, 116, 4, 70, "Input",
 CellID->25387],
Cell[6356, 234, 159, 5, 36, "Output",
 CellID->1468493875]
}, Open  ]],
Cell[6530, 242, 190, 7, 70, "MathCaption",
 CellID->13500],
Cell[CellGroupData[{
Cell[6745, 253, 197, 7, 70, "Input",
 CellID->6615],
Cell[6945, 262, 293, 9, 36, "Output",
 CellID->1743135727]
}, Open  ]],
Cell[7253, 274, 316, 8, 70, "Text",
 CellID->24072],
Cell[7572, 284, 2083, 66, 70, "DefinitionBox",
 CellID->25061],
Cell[9658, 352, 67, 1, 70, "Caption",
 CellID->19952],
Cell[9728, 355, 620, 19, 70, "Text",
 CellID->10970],
Cell[10351, 376, 338, 9, 70, "MathCaption",
 CellID->22823],
Cell[CellGroupData[{
Cell[10714, 389, 124, 4, 70, "Input",
 CellID->18064],
Cell[10841, 395, 159, 5, 36, "Output",
 CellID->1947588709]
}, Open  ]],
Cell[11015, 403, 190, 5, 70, "MathCaption",
 CellID->22050],
Cell[CellGroupData[{
Cell[11230, 412, 148, 5, 70, "Input",
 CellID->1610],
Cell[11381, 419, 178, 6, 51, "Output",
 CellID->584626662]
}, Open  ]],
Cell[11574, 428, 146, 5, 70, "MathCaption",
 CellID->12978],
Cell[CellGroupData[{
Cell[11745, 437, 86, 3, 70, "Input",
 CellID->22443],
Cell[CellGroupData[{
Cell[11856, 444, 99, 2, 70, "Print",
 CellTags->"Info3371545245-6231930",
 CellID->770171192],
Cell[11958, 448, 886, 27, 70, "Print",
 CellTags->"Info3371545245-6231930",
 CellID->1332405385]
}, Open  ]]
}, Open  ]],
Cell[12871, 479, 225, 7, 70, "MathCaption",
 CellID->2718],
Cell[CellGroupData[{
Cell[13121, 490, 186, 6, 70, "Input",
 CellID->22298],
Cell[13310, 498, 220, 7, 36, "Output",
 CellID->1377864954]
}, Open  ]],
Cell[CellGroupData[{
Cell[13567, 510, 71, 1, 70, "RelatedTutorialsSection",
 CellID->39338361],
Cell[13641, 513, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[13871, 522, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

