(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34480,       1172]
NotebookOptionsPosition[     28443,        972]
NotebookOutlinePosition[     30975,       1039]
CellTagsIndexPosition[     30882,       1033]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Series\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Making Power Series Expansions", "Title",
 CellTags->{"S3.6.1", "1.1"},
 CellID->31665],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "find the power series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " about the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     " to order at most ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["x", "TI"], "-", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}], ")"}], 
       StyleBox["n", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["x", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["y", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find series expansions with respect to ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " then ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3845],

Cell["Functions for creating power series. ", "Caption",
 CellID->13950],

Cell[TextData[{
 "Here is the power series expansion for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " about the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " to order\[NonBreakingSpace]",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "4"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->6826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8591],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{166, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->721571964]
}, Open  ]],

Cell[TextData[{
 "Here is the series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " about the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->23213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22371],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[ExponentialE]", "+", 
   RowBox[{"\[ExponentialE]", " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "5"],
    SeriesData[$CellContext`x, 1, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   E, E, Rational[1, 2] E, Rational[1, 6] E, Rational[1, 24] E}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{396, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->385470644]
}, Open  ]],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know the series expansion of a particular function, it writes the \
result symbolically in terms of derivatives. "
}], "MathCaption",
 CellID->14662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15190],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWF1PwjAU7dZN/EAlqImJigomRuOLiRpffVBU4o8YaKIPRkX/Hz9t9nOU
s442AyLRhLWn9/bc9ty2dntKfl5f3pOft15y0O4nn69vve+Du48+a6IBIUGL
ENLYJqyespr48b8j9pNVWUvYM2bGB1ZSVn5lrSTWfVLRRsi9tfVTlF3+pJlN
8BX59sB3HO8z+LbZI8rG+QLWO8D9MbN5AN+vbB68saNKOYpl9gwZWlHlHuBr
wG3AJ4CXMlZzBCuAdxz2K4f91mE/dtgrUimqBONV9ovAiyqlYmhfAMztPAmL
nv0jpVWoSuTbUHw4al++agHf5pT4Fsx+kbn6zF6optQ8tGhnYmHPrWjkQsUQ
L5VihfmwSgU8UEFUpmycVUecrRnFib14whwPZm2aueU4tuyKcjnlLHqPDVkH
g4Ha95HY/Awb0SfPsI5aLRm1XL4xql92aWo/heZ/v+r54rk7nV2q2dcc7JPl
Ctn/e87m94xFlVx4Ps9g153Gb9R8VdpuNP4nuHkT2E3t95lybE3FRm3zh36T
R9ss7vUnN591wKgCYj9WvC/T0flZVpsfL9+7HDY8RhlaopSbTVWx1by8i27Z
gfDXSK+LCHBdYcwuLfA/Nf1zCtt64H+I/YKI1vXuMaIa+K2lw9u9+WbHz/9A
6SK1OYeeN7k5NcGj5cgv4kPAXL0oy41+w78Er5pqR+VcCuFoTwxMtOK5d/wL
8NoAu9ixFViFynfcfLn9LB2eLPnIOO+6RYf8+seYmBMeczTPGPcRsP3bx+y9
ukqdjirlNxHuIL8AkeAXYnCVyA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{291, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->98006014]
}, Open  ]],

Cell[TextData[{
 "In mathematical terms, ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can be viewed as a way of constructing Taylor series for functions. "
}], "Text",
 CellID->21906],

Cell[TextData[{
 "The standard formula for the Taylor series expansion about the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    SubscriptBox["x", "0"]}], TraditionalForm]], "InlineMath"],
 " of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " derivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"(", "k", ")"}]], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"(", "k", ")"}]], "(", 
       SubscriptBox["x", "0"], ")"}], 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", 
          SubscriptBox["x", "0"]}], ")"}], "k"], 
       RowBox[{"k", "!"}]]}]}]}], TraditionalForm]], "InlineMath"],
 ". Whenever this formula applies, it gives the same results as ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ". (For common functions, ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " nevertheless internally uses somewhat more efficient algorithms.) "
}], "Text",
 CellID->5418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can also generate some power series that involve fractional and negative \
powers, not directly covered by the standard Taylor series formula. "
}], "Text",
 CellID->21622],

Cell[TextData[{
 "Here is a power series that contains negative powers of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29666],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox["1", "x"], "+", 
   FractionBox["1", "2"], "+", 
   FractionBox["x", "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "120"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "720"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, -2, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120], 
    Rational[1, 720]}, -2, 5, 1],
  Editable->False]], "Output",
 ImageSize->{245, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1275811684]
}, Open  ]],

Cell[TextData[{
 "Here is a power series involving fractional powers of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Sqrt", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->30959],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   SqrtBox["x"], "+", 
   FractionBox["x", "2"], "+", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"5", "/", "2"}]],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24]}, 0, 5, 2],
  Editable->False]], "Output",
 ImageSize->{198, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1640427645]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can also handle series that involve logarithmic terms."
}], "MathCaption",
 CellID->17103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"2", "x"}], "]"}], " ", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->23279],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", "x", "]"}], " ", "x"}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", "x", "]"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Log[$CellContext`x], 2 Log[$CellContext`x], 2 Log[$CellContext`x]}, 0, 3, 
   1],
  Editable->False]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->255977661]
}, Open  ]],

Cell[TextData[{
 "There are, of course, mathematical functions for which no standard power \
series exist. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " recognizes many such cases. "
}], "Text",
 CellID->4867],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " sees that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", 
    FractionBox["1", "x"], ")"}], TraditionalForm]], "InlineMath"],
 " has an essential singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and does not produce a power series."
}], "MathCaption",
 CellID->21345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->26103],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox["1", "x"]]], "Output",
 ImageSize->{20, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->689799258]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can nevertheless give you the power series for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", 
    FractionBox["1", "x"], ")"}], TraditionalForm]], "InlineMath"],
 " about the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->6025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1534],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox["1", "x"], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], "4"],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[1], {1, 1, 
    Rational[1, 2], 
    Rational[1, 6]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{200, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->483595779]
}, Open  ]],

Cell[TextData[{
 "Especially when negative powers occur, there is some subtlety in exactly \
how many terms of a particular power series the function ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " will generate. "
}], "Text",
 CellID->31833],

Cell["\<\
One way to understand what happens is to think of the analogy between power \
series taken to a certain order, and real numbers taken to a certain \
precision. Power series are \"approximate formulas\" in much the same sense \
as finite\[Hyphen]precision real numbers are approximate numbers.\
\>", "Text",
 CellID->16235],

Cell[TextData[{
 "The procedure that ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " follows in constructing a power series is largely analogous to the \
procedure that ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " follows in constructing a real\[Hyphen]number approximation. Both \
functions effectively start by replacing the smallest pieces of your \
expression by finite\[Hyphen]order, or finite\[Hyphen]precision, \
approximations, and then evaluating the resulting expression. If there are, \
for example, cancellations, this procedure may give a final result whose \
order or precision is less than the order or precision that you originally \
asked for. Like ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ", however, ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " has some ability to retry its computations so as to get results to the \
order you ask for. In cases where it does not succeed, you can usually still \
get results to a particular order by asking for a higher order than you need. \
"
}], "Text",
 CellID->10287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " compensates for cancellations in this computation, and succeeds in giving \
you a result to order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "3"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->28393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->4827],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "-", 
   FractionBox["x", "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, -1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120]}, -1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{123, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2120688165]
}, Open  ]],

Cell[TextData[{
 "When you make a power series expansion in a variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that all objects that do not explicitly contain ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " are in fact independent of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " thus does partial derivatives (effectively using ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ") to build up Taylor series. "
}], "Text",
 CellID->16624],

Cell[TextData[{
 "Both ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["n"], "InlineFormula"],
 " are assumed to be independent of ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->32692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "x"}], ")"}], "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->11918],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V8lOwzAQdZuEtlAKUgNlE0JCwAEOCA5IcAckxK0HClyqCgkOCAT9BfgJ
tk/pf3EJXsbBvIxLWpZKif0mM/ab57XH7e7lxXW7e9VpLx3ctW8vrzr3S/s3
d9IUFIQQ7/JZnBGynsiaft6TRJbmfSLfkTS+pEgomNifSL+11DtIv4lXbT0F
q/E9A+uztp6D9SlXnyrA9PUI8cuAt+WrKOEYlRUd9QBeK4C3AI8BLulWiqQT
fh0he4OYipAS0L+AmBSpLEF0TNFzYB8lO/qH3l7yeblcqkwmCka6CXc83KiQ
VcdQ0Ebtibm4OGLHe5a1AhdZKUNrdTZuHrwwV9SV54S58l5ZjuNDtV7MtBMN
rLVSJ7KROTVW427nZkRYBL1ej+ZNqCePxBQS5FLcrhfMIerLMJ/ilnF1oLbs
/B9hVVV8Q8+qCL/VrgJRMUX95zy0XGpDtdlfnd9Z33YfwX7/a4Vz/SP2+WV5
/u0qV37KOE0ljmqZeNqRsTuRu1cvemLxDEPtap628Yz5rv/Yr8iA50vJMyrq
1I24UWVsu6QGnpacL2aLijUYrOCEP+M+rdncjZTlr/rIylRidpMMy3RgHGex
Q964ZnlvXG0V4jIDdsSTyedtwb1zqf1DXTsLqvTkw50VWdUw272hog4BrwM2
HEuk2QLXhzvrZXWFtIxz+B6BbSOjzhp4bAKuO1jl1wS8DlizEKs0Gni3Rc7N
JI86/B3/59YWsXzTyPwfEYUP2LeKLw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{250, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->739910111]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"a", "[", "x", "]"}]], "InlineFormula"],
 " is now given as an explicit function of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "x", "]"}], "+", "x"}], ")"}], "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->6431],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWs1OE1EUns5PCwURC1FASKnREEQN0fgTXagbdeOCra4aArYmBoO8ib6F
8Rl4AoML1+71Jeqc+1OHb07nng4znUgTOnPuPff833PvOeV196i396F71N/t
rr887H7s9Xc/rb84OIyHgprn1T57nndnyYvfB/Gb+qPPl/hPv+q3S/F3FE9+
N8+vanSWvgO7ZuD59BUNYYWj16RH38Ha52p8BkZDgE8A7gP8jKUSOaj0RFTq
DiqokabShNGpMak8ZamEY1gabcRTJBsReGKe70WrFgG+BvBK/OV72pb0bMN8
B+bR3w9hfgtg9MkGzE+zUi8AfB3gZYAxElYdWiN+APADB/6mYx6ttOHAb7BW
aAFMtqLgaTDcCNRs7Qd14rEiQxOxA4ONO/MqwP4ImeojxkfRRYth5moVIv2K
wUdLS6UimKLWN0+Usp6kEyb3eXIVUpV5n40ZzKGp3IK8eCzZWv70QCyMEFZb
p0SYhWW8XVG0ULr2yywW+i6fNhBV8csFkS1ZTU7RwbjnI1LvsuPjY7P7QpVm
YjjJnckNnB6R2O7VR2y2vMVEatPwqDtsHJRujTIjmLSzeVMeAcGAv0tUnzdJ
orC0uOPO1LCwiJPlxrNpuGJWFxs9cyLfTD6K7Bmf0lSAx+/r83kCl63/eT6D
XXE5Z+yrDao/3K0WcYgbdwOWWQlt4KqH5g236UJ8YmvU8vRpGmqyfopLXqwi
FkdTOWMNgXU0zl8BGOtqmX7W1liFcfsc/YFrLjvmZRKNqge3c1GztWwqtzNj
KqIz93X+PErgRdFqLtf5ww3i6hFNGewlGLe9IttJCBNwmNh/lmM0TD4Jc+hz
JRXXyCvI4JVlp22HjKl4ZGWcYb3I0cXbBGYIm+ns+mRfrBY/a/RkvXLA+DDt
edTnBsBrAL/KRbWZsgdmCsyYWwDzOpIVifk+J1USL35FyefN2nuCtTcd0t5y
egP9vJeAyWI7AGPmRSkRnoX1WwD7IqnQjjsA4+3h7kBH4/1c3iyni18lFdy9
rl83+N9IWsaqP8zzmxolBPzV5t9bc3A6P2wC3AZO6zCPkv4ZUs06F1x9aeyj
dxz4eO7+VlLYs0DapeW8QOBkO9e4t/L2iJH+T60EnJVZGUx2Y0CrVd83k9WZ
iFVUXYb1a1l2t5276u2d3acsxs62B9MwvLRViVb+LpEscqvptRVrNax3J5kL
/o+u02SzAVHncrqMq+1lVd9HKaZXhyfXL7UO7xAZtNluRXJtO5ec49Tf4/YX
8u0v/p5j73BszXoqGjsZmPIqVVZJ+xm80jfGtZSsj0UWctWhSjqFu2p0fOLw
hBXitlr1lqGn/kvDe2P0oZFHWpraX04a2Qg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{403, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->221949960]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " to generate power series in a sequence of different variables. ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and so on, and expands first with respect to the last variable you \
specify."
}], "Text",
 CellID->9695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " performs a series expansion successively with respect to each variable. \
The result in this case is a series in ",
 Cell[BoxData["x"], "InlineFormula"],
 ", whose coefficients are series in ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->21753],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWbtTE0EY39zlgoHIhNFBHF8BnEEcGxQBaYiNVvwRkZEJhWOIjFKZkpKS
kpKSkpKSMiUlZcqUlOc+s7u/23skx8PMJNlv9/u+3/fax+1tNvaa33809na2
GrWv7UarubP1q/blZ5t2+QVCCg1CyOwMoe2QtviXfb7RLyFt9uufnZ31ej3W
3OD06elpt9tlzdecPjk5ub6+1uNHR0eS/7Oh5fDwkGsOSUB/Agq0wvtbrZbs
nwe+Ev3xB3wUYn9/X2vd5b3UkIuLC8VNAmU/VzCQpTqvrq5Yc055IC1MkqJw
0q+6gajtG+P0QJascrrf7wsWiWX7E4d1eXlJwxiP9cCJpcdnM2GhFM8Xaan4
HhwcsOY4YK2AVA0sZnEoUvY1p/YZ0PYR6Becpuk5Pj5mzQknP60pA907Pz/H
iHwCPoH+xBk3TT93+BIXN9sGPi9k7aEtayPbwjwrh6LuhZZOp2Oh0jDJWlZ8
q8BnoBVNTxjxlGHQf1/SRUljzpUtizH8lRTb3mSUW5D9E/K/zG2fBmuKQGNN
4TjSZaCfGd4No2c8g9d59C3AOM4FXp0iqER82GDJxZWAiuNqnQ1yRlXl2JP/
iDMmo47ZGxUfo4f4FaffOls4H+/KDgvHmqGmlDNrIvWgKy33TBuuUBw7ss65
PPUcEcHMgycOvLjc57MDIx+146EzPvE1cNf2ZMPzInoQ2V0dTE/gmIkmH5Er
SKC0plqD0mnVUQr1eqCsYbUg9NKGXMvKfEGr1+sGzs1ZhblRVlWsGOnK8P8r
67KjeCRmRxh67eD8VtUhxxC+W3rSdhLlPfbnW0XS7YjLwqQzUnlXkZuz5z6q
w3NijlYhbl1pVXLbu042q+5rD7ot6253R6racqE4CQn16jMZb0GKJKKlnVCn
QlEftRtDTDsLiicbnftXd4b8OCPS8GfQKtDT8UgJzza+9BK1q2e1hBxl0FqE
6FRk/1T2fIyIwuJYzaW1wPlVTh45oq2eJswnafcN0EsZTcbN0j6TJB05v9ie
meMYx2JO/bjDTSboKcgYiTjharokLfGgX91w4I71PtQ3FqZFuE5WwWP0KKue
t5Iv3nrz3IizI8mL6HkznzdJ+jBfi8DPox+5t1kK9Xpj9os7QX0rp849y6H5
3KXv1yqAJqpR388NK//OtItsgnV8JTJuLAOQxhtOH9BcsWc5LOXUw6y254K4
RRbXuqGclfauvc458G6X+iYjHz0voMSGgaR7ua2R1WcdPMBb62xSJqJIAWuy
XPmD0lQfFaJl3uj1ejJnc5mlvUEmut0uLSnWrBsW0CqluWNNvENdVt7Jdw0C
k6qQcwzXUDHH6Jyy3jq0wXtE+cDpZrMp6fkUfoHS7/ettyn4psctpcfxzQ/u
XUswLlD+GlwsvttA/+H/HdC1DfRvzsWa4i0VKfwDTD/SPQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{353, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->503603702]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->448342742],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Making Power Series Expansions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfPowerSeries"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 52.3980124}", "context" -> "", 
    "keywords" -> {
     "approximate formulas", "approximation of functions", "approximations", 
      "asymptotic expansions", "essential singularities", "expansion", 
      "Laurent series", "Maclaurin series", "order", "power series", "series",
       "series expansions", "Taylor series"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Functions for creating power series. Here is the power series expansion \
for exp(x) about the point x=0 to order x^4. Here is the series expansion of \
exp(x) about the point x=1. ", "synonyms" -> {"3.6.1"}, "title" -> 
    "Making Power Series Expansions", "type" -> "Tutorial", "uri" -> 
    "tutorial/MakingPowerSeriesExpansions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.1"->{
  Cell[1826, 59, 93, 2, 70, "Title",
   CellTags->{"S3.6.1", "1.1"},
   CellID->31665]},
 "1.1"->{
  Cell[1826, 59, 93, 2, 70, "Title",
   CellTags->{"S3.6.1", "1.1"},
   CellID->31665]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.1", 30671, 1022},
 {"1.1", 30770, 1026}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1201, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1826, 59, 93, 2, 70, "Title",
 CellTags->{"S3.6.1", "1.1"},
 CellID->31665],
Cell[1922, 63, 2169, 69, 70, "DefinitionBox",
 CellID->3845],
Cell[4094, 134, 72, 1, 70, "Caption",
 CellID->13950],
Cell[4169, 137, 426, 15, 70, "MathCaption",
 CellID->6826],
Cell[CellGroupData[{
Cell[4620, 156, 210, 7, 28, "Input",
 CellID->8591],
Cell[4833, 165, 670, 23, 54, "Output",
 CellID->721571964]
}, Open  ]],
Cell[5518, 191, 298, 11, 70, "MathCaption",
 CellID->23213],
Cell[CellGroupData[{
Cell[5841, 206, 211, 7, 28, "Input",
 CellID->22371],
Cell[6055, 215, 1101, 34, 51, "Output",
 CellID->385470644]
}, Open  ]],
Cell[7171, 252, 234, 7, 70, "MathCaption",
 CellID->14662],
Cell[CellGroupData[{
Cell[7430, 263, 209, 7, 28, "Input",
 CellID->15190],
Cell[7642, 272, 1032, 21, 51, "Output",
 Evaluatable->False,
 CellID->98006014]
}, Open  ]],
Cell[8689, 296, 259, 8, 70, "Text",
 CellID->21906],
Cell[8951, 306, 1621, 55, 70, "Text",
 CellID->5418],
Cell[10575, 363, 306, 8, 70, "Text",
 CellID->21622],
Cell[10884, 373, 174, 6, 70, "MathCaption",
 CellID->27719],
Cell[CellGroupData[{
Cell[11083, 383, 261, 9, 70, "Input",
 CellID->29666],
Cell[11347, 394, 857, 30, 55, "Output",
 CellID->1275811684]
}, Open  ]],
Cell[12219, 427, 171, 6, 70, "MathCaption",
 CellID->1991],
Cell[CellGroupData[{
Cell[12415, 437, 244, 8, 70, "Input",
 CellID->30959],
Cell[12662, 447, 710, 25, 54, "Output",
 CellID->1640427645]
}, Open  ]],
Cell[13387, 475, 224, 7, 70, "MathCaption",
 CellID->17103],
Cell[CellGroupData[{
Cell[13636, 486, 289, 10, 70, "Input",
 CellID->23279],
Cell[13928, 498, 700, 22, 36, "Output",
 CellID->255977661]
}, Open  ]],
Cell[14643, 523, 218, 7, 70, "Text",
 CellID->4867],
Cell[14864, 532, 467, 16, 70, "MathCaption",
 CellID->21345],
Cell[CellGroupData[{
Cell[15356, 552, 236, 8, 70, "Input",
 CellID->26103],
Cell[15595, 562, 216, 7, 43, "Output",
 CellID->689799258]
}, Open  ]],
Cell[15826, 572, 460, 16, 70, "MathCaption",
 CellID->6025],
Cell[CellGroupData[{
Cell[16311, 592, 242, 8, 70, "Input",
 CellID->1534],
Cell[16556, 602, 834, 30, 52, "Output",
 CellID->483595779]
}, Open  ]],
Cell[17405, 635, 315, 9, 70, "Text",
 CellID->31833],
Cell[17723, 646, 332, 6, 70, "Text",
 CellID->16235],
Cell[18058, 654, 1308, 33, 70, "Text",
 CellID->10287],
Cell[19369, 689, 364, 12, 70, "MathCaption",
 CellID->28393],
Cell[CellGroupData[{
Cell[19758, 705, 260, 9, 70, "Input",
 CellID->4827],
Cell[20021, 716, 586, 20, 54, "Output",
 CellID->2120688165]
}, Open  ]],
Cell[20622, 739, 738, 25, 70, "Text",
 CellID->16624],
Cell[21363, 766, 228, 9, 70, "MathCaption",
 CellID->32692],
Cell[CellGroupData[{
Cell[21616, 779, 256, 9, 28, "Input",
 CellID->11918],
Cell[21875, 790, 977, 20, 51, "Output",
 Evaluatable->False,
 CellID->739910111]
}, Open  ]],
Cell[22867, 813, 206, 7, 70, "MathCaption",
 CellID->17244],
Cell[CellGroupData[{
Cell[23098, 824, 287, 10, 28, "Input",
 CellID->6431],
Cell[23388, 836, 1591, 30, 67, "Output",
 Evaluatable->False,
 CellID->221949960]
}, Open  ]],
Cell[24994, 869, 694, 24, 70, "Text",
 CellID->9695],
Cell[25691, 895, 406, 12, 70, "MathCaption",
 CellID->11508],
Cell[CellGroupData[{
Cell[26122, 911, 306, 10, 28, "Input",
 CellID->21753],
Cell[26431, 923, 1664, 31, 54, "Output",
 Evaluatable->False,
 CellID->503603702]
}, Open  ]],
Cell[CellGroupData[{
Cell[28132, 959, 72, 1, 70, "RelatedTutorialsSection",
 CellID->448342742],
Cell[28207, 962, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[28416, 970, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

