(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41840,       1583]
NotebookOptionsPosition[     33232,       1292]
NotebookOutlinePosition[     36086,       1364]
CellTagsIndexPosition[     35993,       1358]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "TableForm" :> 
          Documentation`HelpLookup["paclet:ref/TableForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Part\"\>", 2->"\<\"Table\"\>", 
       3->"\<\"TableForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Making Tables of Values", "Title",
 CellTags->{"S1.8.2", "2.1"},
 CellID->23192],

Cell["\<\
You can use lists as tables of values. You can generate the tables, for \
example, by evaluating an expression for a sequence of different parameter \
values. \
\>", "Text",
 CellID->31121],

Cell[TextData[{
 "This gives a table of the values of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["i", "2"], TraditionalForm]], "InlineMath"],
 ", with ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " running from 1 to 6. "
}], "MathCaption",
 CellID->2819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->29071]
}, Open  ]],

Cell[TextData[{
 "Here is a table of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"n", "/", "5"}], ")"}], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " from ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"n", "/", "5"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"Sin", "[", 
    FractionBox["1", "5"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["2", "5"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["3", "5"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["4", "5"], "]"}]}], "}"}]], "Output",
 ImageSize->{255, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1991]
}, Open  ]],

Cell["This gives the numerical values. ", "MathCaption",
 CellID->22052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->5251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.19866933079506122`", ",", "0.3894183423086505`", ",", 
   "0.5646424733950354`", ",", "0.7173560908995228`"}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->1523]
}, Open  ]],

Cell["You can also make tables of formulas. ", "MathCaption",
 CellID->28965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "+", 
    RowBox[{"2", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->24956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x"}], ",", 
   RowBox[{"4", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"6", "+", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"8", "+", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{"10", "+", 
    SuperscriptBox["x", "5"]}]}], "}"}]], "Output",
 ImageSize->{225, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->26980]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " uses exactly the same iterator notation as the functions ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 ", which were discussed in \"",
 ButtonBox["Sums and Products\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SumsAndProducts"],
 ". "
}], "MathCaption",
 CellID->15061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "+", 
    RowBox[{"2", "i"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->28465],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"6", "+", 
    SuperscriptBox["x", "3"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"8", "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"10", "+", 
    SuperscriptBox["x", "5"]}], ")"}]}]], "Output",
 ImageSize->{249, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->27523]
}, Open  ]],

Cell[TextData[{
 "This makes a table with values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " running from ",
 Cell[BoxData["0"], "InlineFormula"],
 " to ",
 Cell[BoxData["1"], "InlineFormula"],
 " in steps of ",
 Cell[BoxData["0.25"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1", ",", "0.25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->25828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0.5`", ",", "0.7071067811865476`", ",", "0.8660254037844386`", 
   ",", "1.`"}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->29235]
}, Open  ]],

Cell[TextData[{
 "You can perform other operations on the lists you get from ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "^", "2"}], "+", "3"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->24612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3.25`", ",", "3.5`", ",", "3.75`", ",", "4.`"}], 
  "}"}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->13682]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " displays lists in a \"tabular\" format. Notice that both words in the name \
",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " begin with capital letters."
}], "MathCaption",
 CellID->23876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "TableForm"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->6157],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVVMEOgjAMLWwoSjyYqHjg4NdoPPgRxJjowWjQ/5/t3GDMTkRPktBu3evy
+krZlffj4VzeT/tytanK6/G0v63WlwpDIgKAAt/tEnCtcKXfQin0r1aiFQiI
0cfopzqakJWUZ5/mDMTT0UOQeStKlu4CUWfDTB/F7TtxsdBOOGjoiErDZBGo
JmRjU6XNH3gMhaMCU8uLEn6+RiUuijhHjZYOduzt6Tz6Ei0MnwnDp6nHvzNj
2crOPg7ZPKEYLWoGxD8xKFnz/r5zidmPPuyUZDmnYV2c/aAHynYia/Hzc1Nv
H6iiM8OqkhlV0x9VlU6X+swBr26fafDro28sPA0jRvt/mgb7dUj12zTknexm
bK3vola9/A3ms798w/DJGqIHAzBRpg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{28, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//TableForm= ",
 CellID->121935188]
}, Open  ]],

Cell[TextData[{
 "All the examples so far have been of tables obtained by varying a single \
parameter. You can also make tables that involve several parameters. These \
multidimensional tables are specified using the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iterator notation, discussed in \"",
 ButtonBox["Sums and Products\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SumsAndProducts"],
 ". "
}], "Text",
 CellID->3292],

Cell[TextData[{
 "This makes a table of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{" ", "i"}]], "+", 
    SuperscriptBox["y", 
     RowBox[{" ", "j"}]]}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->15199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "+", 
    RowBox[{"y", "^", "j"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->1776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"x", "+", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", "y"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "+", "y"}], ",", 
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["y", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{315, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->2461]
}, Open  ]],

Cell[TextData[{
 "The table in this example is a ",
 StyleBox["list of lists",
  FontSlant->"Italic"],
 ". The elements of the outer list correspond to successive values of ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 ". The elements of each inner list correspond to successive values of ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ", with ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " fixed. "
}], "Text",
 CellID->20842],

Cell["\<\
Sometimes you may want to generate a table by evaluating a particular \
expression many times, without incrementing any variables. \
\>", "Text",
 CellID->19131],

Cell[TextData[{
 "This creates a list containing four copies of the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", "4", "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->8700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->11638]
}, Open  ]],

Cell[TextData[{
 "This gives a list of four pairs of numbers sampled from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " re\[Hyphen]evaluates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomSample",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomSample"], 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "2"}], 
    "]"}]}]], "InlineFormula"],
 " for each element in the list, so that you get four different samples. "
}], "MathCaption",
 CellID->21080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RandomSample", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "2"}], "]"}], 
   ",", 
   RowBox[{"{", "4", "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->24620],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->48355012]
}, Open  ]],

Cell[TextData[{
 "This evaluates ",
 Cell[BoxData[
  SqrtBox["i"]], "InlineFormula"],
 " for each of the values of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " in the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "9", ",", "16"}], "}"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->127282870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SqrtBox["i"], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9", ",", "16"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->273792749],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->172822209]
}, Open  ]],

Cell["This creates a 3\[Times]2 table.", "MathCaption",
 CellID->461739716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "+", 
    RowBox[{"2", "j"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->58465720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->647973593]
}, Open  ]],

Cell[TextData[{
 "In this table, the length of the rows depends on the more slowly varying \
iterator variable, ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->407985285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "+", 
    RowBox[{"2", "j"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->184018772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->970196234]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " to generate arrays with any number of dimensions. "
}], "Text",
 CellID->5984],

Cell["\<\
This generates a three\[Hyphen]dimensional 2\[Times]2\[Times]2 array. It is a \
list of lists of lists. \
\>", "MathCaption",
 CellID->27110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", " ", 
    RowBox[{"j", "^", "2"}], " ", 
    RowBox[{"k", "^", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->24417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "32"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "64"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->29397]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "give a list of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " values of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "give a list of the values of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " runs from ",
     Cell[BoxData["1"], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "give a list of values with ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " running from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], ",", 
     StyleBox["di", "TI"], "}", "]"}], Cell[TextData[{
     "use steps of ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["max", "TI"]], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["generate a multidimensional table", "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Table",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Table"], "[", 
      RowBox[{
       StyleBox["f", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["i", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}]}]}], "]"}], Cell[
    TextData[{
     "give a list of the values of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " successively takes the values ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["i", "1"], ",", 
        SubscriptBox["i", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TableForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TableForm"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "display a list in tabular form", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->30929],

Cell["Functions for generating tables. ", "Caption",
 CellID->30168],

Cell[TextData[{
 "You can use the operations discussed in \"",
 ButtonBox["Manipulating Elements of Lists\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingElementsOfLists"],
 " to extract elements of the table."
}], "Text",
 CellID->14141],

Cell[TextData[{
 "This creates a table and gives it the name ",
 Cell[BoxData[
  StyleBox["sq", "TR"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->459487148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sq", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "7"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[25]:=",
 CellID->30728983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49"}], 
  "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->321685028]
}, Open  ]],

Cell["This gives the third part of the table.", "MathCaption",
 CellID->421788682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sq", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->293474533],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->710097956]
}, Open  ]],

Cell["This gives a list of the third through fifth parts.", "MathCaption",
 CellID->76296484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sq", "[", 
  RowBox[{"[", 
   RowBox[{"3", ";;", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->55322000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "16", ",", "25"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->147082431]
}, Open  ]],

Cell[TextData[{
 "This creates a 2\[Times]2 table, and gives it the name ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "-", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[23]:=",
 CellID->20834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->138287210]
}, Open  ]],

Cell["\<\
This extracts the first sublist from the list of lists that makes up the \
table. \
\>", "MathCaption",
 CellID->32270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->23082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->10000]
}, Open  ]],

Cell["This extracts the second element of that sublist. ", "MathCaption",
 CellID->14560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->1364],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->6141]
}, Open  ]],

Cell["This does the two operations together. ", "MathCaption",
 CellID->16099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->6336],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->7665]
}, Open  ]],

Cell[TextData[{
 "This displays ",
 Cell[BoxData["m"], "InlineFormula"],
 " in a \"tabular\" form. "
}], "MathCaption",
 CellID->6833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "m", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->29029],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwyAGxtAQDkP0fyAJj
uf//gTQyycAMoUCAGYi5gVwQzQUWBkuCuP/BACLKCudDtXIOe7VMQJIJyONF
CR3M0MRFMkH1CQFpkBVMKGEPIpnQXCOIxiesgwNqNgvJOkm3a+B0wEJSGBoj
LEihzMAIAAHkiU8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{30, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]//TableForm= ",
 CellID->161386755]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["t", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["t", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sublist in ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " (also input as ",
     Cell[BoxData[
      FormBox[
       RowBox[{"t", "[", 
        RowBox[{"[", "i", "]"}], "]"}], TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["t", "TI"], "[", 
      RowBox[{"[", 
       RowBox[{
        StyleBox["i", "TI"], ";;", 
        StyleBox["j", "TI"]}], "]"}], "]"}], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     RowBox[{
      ButtonBox["Part",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Part"], "[", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{
        StyleBox["i", "TI"], ";;", 
        StyleBox["j", "TI"]}]}], "]"}]}], Cell[TextData[{
     "give a list of the parts ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["t", "TI"], "[", "[", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["t", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a list of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     ", \[Ellipsis]",
     " ",
     "parts of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["t", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["t", "TI"], ",", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the part of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " corresponding to ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{"t", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "[", 
         RowBox[{"[", "j", "]"}], "]"}], "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->27254],

Cell["Ways to extract parts of tables. ", "Caption",
 CellID->21028],

Cell[TextData[{
 "As mentioned in \"",
 ButtonBox["Manipulating Elements of Lists\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingElementsOfLists"],
 ", you can think of lists in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as being analogous to \"arrays\". Lists of lists are then like \
two\[Hyphen]dimensional arrays. When you lay them out in a tabular form, the \
two indices of each element are like its ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates."
}], "Text",
 CellID->10319],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->487249946],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Making Tables of Values - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CollectingObjectsTogether"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/VectorsAndMatrices"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 52.8355236}", "context" -> "", 
    "keywords" -> {
     "]]", "[[", "arrays", "dyads", "elements of table", "tabular format", 
      "lists as tables", "repeating expressions", "replicating expressions", 
      "table", "Table", "TableForm", "tables", "tabulation of values", 
      "tensors as tables", "tabulated data", "tabulated values", 
      "table of function values"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "You can use lists as tables of values. You can generate the tables, for \
example, by evaluating an expression for a sequence of different parameter \
values. This gives a table of the values of i^2, with i running from 1 to 6. \
Here is a table of sin(n/5) for n from 0 to 4. ", "synonyms" -> {"1.8.2"}, 
    "title" -> "Making Tables of Values", "type" -> "Tutorial", "uri" -> 
    "tutorial/MakingTablesOfValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.2"->{
  Cell[1925, 59, 86, 2, 70, "Title",
   CellTags->{"S1.8.2", "2.1"},
   CellID->23192]},
 "2.1"->{
  Cell[1925, 59, 86, 2, 70, "Title",
   CellTags->{"S1.8.2", "2.1"},
   CellID->23192]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.2", 35782, 1347},
 {"2.1", 35881, 1351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1300, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1925, 59, 86, 2, 70, "Title",
 CellTags->{"S1.8.2", "2.1"},
 CellID->23192],
Cell[2014, 63, 199, 5, 70, "Text",
 CellID->31121],
Cell[2216, 70, 281, 10, 70, "MathCaption",
 CellID->2819],
Cell[CellGroupData[{
Cell[2522, 84, 193, 7, 28, "Input",
 CellID->8907],
Cell[2718, 93, 247, 8, 36, "Output",
 CellID->29071]
}, Open  ]],
Cell[2980, 104, 421, 17, 70, "MathCaption",
 CellID->5022],
Cell[CellGroupData[{
Cell[3426, 125, 236, 8, 28, "Input",
 CellID->20561],
Cell[3665, 135, 446, 15, 51, "Output",
 CellID->1991]
}, Open  ]],
Cell[4126, 153, 72, 1, 70, "MathCaption",
 CellID->22052],
Cell[CellGroupData[{
Cell[4223, 158, 93, 3, 28, "Input",
 CellID->5251],
Cell[4319, 163, 312, 9, 36, "Output",
 CellID->1523]
}, Open  ]],
Cell[4646, 175, 77, 1, 70, "MathCaption",
 CellID->28965],
Cell[CellGroupData[{
Cell[4748, 180, 239, 9, 70, "Input",
 CellID->24956],
Cell[4990, 191, 456, 16, 39, "Output",
 CellID->26980]
}, Open  ]],
Cell[5461, 210, 606, 21, 70, "MathCaption",
 CellID->15061],
Cell[CellGroupData[{
Cell[6092, 235, 241, 9, 70, "Input",
 CellID->28465],
Cell[6336, 246, 548, 20, 39, "Output",
 CellID->27523]
}, Open  ]],
Cell[6899, 269, 296, 11, 70, "MathCaption",
 CellID->12300],
Cell[CellGroupData[{
Cell[7220, 284, 225, 7, 70, "Input",
 CellID->25828],
Cell[7448, 293, 279, 9, 36, "Output",
 CellID->29235]
}, Open  ]],
Cell[7742, 305, 233, 8, 70, "MathCaption",
 CellID->27953],
Cell[CellGroupData[{
Cell[8000, 317, 112, 4, 70, "Input",
 CellID->24612],
Cell[8115, 323, 247, 8, 36, "Output",
 CellID->13682]
}, Open  ]],
Cell[8377, 334, 407, 13, 70, "MathCaption",
 CellID->23876],
Cell[CellGroupData[{
Cell[8809, 351, 97, 3, 28, "Input",
 CellID->6157],
Cell[8909, 356, 621, 14, 108, "Output",
 Evaluatable->False,
 CellID->121935188]
}, Open  ]],
Cell[9545, 373, 456, 12, 70, "Text",
 CellID->3292],
Cell[10004, 387, 726, 29, 70, "MathCaption",
 CellID->15199],
Cell[CellGroupData[{
Cell[10755, 420, 302, 11, 70, "Input",
 CellID->1776],
Cell[11060, 433, 709, 26, 39, "Output",
 CellID->2461]
}, Open  ]],
Cell[11784, 462, 493, 15, 70, "Text",
 CellID->20842],
Cell[12280, 479, 171, 4, 70, "Text",
 CellID->19131],
Cell[12454, 485, 156, 5, 70, "MathCaption",
 CellID->27660],
Cell[CellGroupData[{
Cell[12635, 494, 145, 5, 70, "Input",
 CellID->8700],
Cell[12783, 501, 221, 7, 36, "Output",
 CellID->11638]
}, Open  ]],
Cell[13019, 511, 713, 23, 70, "MathCaption",
 CellID->21080],
Cell[CellGroupData[{
Cell[13757, 538, 287, 10, 70, "Input",
 CellID->24620],
Cell[14047, 550, 420, 15, 36, "Output",
 CellID->48355012]
}, Open  ]],
Cell[14482, 568, 342, 13, 70, "MathCaption",
 CellID->127282870],
Cell[CellGroupData[{
Cell[14849, 585, 264, 10, 70, "Input",
 CellID->273792749],
Cell[15116, 597, 224, 7, 36, "Output",
 CellID->172822209]
}, Open  ]],
Cell[15355, 607, 75, 1, 70, "MathCaption",
 CellID->461739716],
Cell[CellGroupData[{
Cell[15455, 612, 276, 10, 70, "Input",
 CellID->58465720],
Cell[15734, 624, 362, 13, 36, "Output",
 CellID->647973593]
}, Open  ]],
Cell[16111, 640, 215, 7, 70, "MathCaption",
 CellID->407985285],
Cell[CellGroupData[{
Cell[16351, 651, 277, 10, 70, "Input",
 CellID->184018772],
Cell[16631, 663, 347, 12, 36, "Output",
 CellID->970196234]
}, Open  ]],
Cell[16993, 678, 227, 8, 70, "Text",
 CellID->5984],
Cell[17223, 688, 151, 4, 70, "MathCaption",
 CellID->27110],
Cell[CellGroupData[{
Cell[17399, 696, 373, 13, 70, "Input",
 CellID->24417],
Cell[17775, 711, 515, 19, 36, "Output",
 CellID->29397]
}, Open  ]],
Cell[18305, 733, 4916, 165, 70, "DefinitionBox",
 CellID->30929],
Cell[23224, 900, 68, 1, 70, "Caption",
 CellID->30168],
Cell[23295, 903, 258, 7, 70, "Text",
 CellID->14141],
Cell[23556, 912, 165, 6, 70, "MathCaption",
 CellID->459487148],
Cell[CellGroupData[{
Cell[23746, 922, 225, 8, 70, "Input",
 CellID->30728983],
Cell[23974, 932, 265, 9, 36, "Output",
 CellID->321685028]
}, Open  ]],
Cell[24254, 944, 82, 1, 70, "MathCaption",
 CellID->421788682],
Cell[CellGroupData[{
Cell[24361, 949, 122, 4, 70, "Input",
 CellID->293474533],
Cell[24486, 955, 159, 5, 36, "Output",
 CellID->710097956]
}, Open  ]],
Cell[24660, 963, 93, 1, 70, "MathCaption",
 CellID->76296484],
Cell[CellGroupData[{
Cell[24778, 968, 146, 5, 70, "Input",
 CellID->55322000],
Cell[24927, 975, 216, 7, 36, "Output",
 CellID->147082431]
}, Open  ]],
Cell[25158, 985, 154, 5, 70, "MathCaption",
 CellID->18762],
Cell[CellGroupData[{
Cell[25337, 994, 282, 10, 70, "Input",
 CellID->20834],
Cell[25622, 1006, 324, 12, 36, "Output",
 CellID->138287210]
}, Open  ]],
Cell[25961, 1021, 129, 4, 70, "MathCaption",
 CellID->32270],
Cell[CellGroupData[{
Cell[26115, 1029, 118, 4, 70, "Input",
 CellID->23082],
Cell[26236, 1035, 220, 8, 36, "Output",
 CellID->10000]
}, Open  ]],
Cell[26471, 1046, 89, 1, 70, "MathCaption",
 CellID->14560],
Cell[CellGroupData[{
Cell[26585, 1051, 117, 4, 70, "Input",
 CellID->1364],
Cell[26705, 1057, 172, 6, 36, "Output",
 CellID->6141]
}, Open  ]],
Cell[26892, 1066, 78, 1, 70, "MathCaption",
 CellID->16099],
Cell[CellGroupData[{
Cell[26995, 1071, 141, 5, 70, "Input",
 CellID->6336],
Cell[27139, 1078, 172, 6, 36, "Output",
 CellID->7665]
}, Open  ]],
Cell[27326, 1087, 134, 5, 70, "MathCaption",
 CellID->6833],
Cell[CellGroupData[{
Cell[27485, 1096, 103, 3, 28, "Input",
 CellID->29029],
Cell[27591, 1101, 423, 11, 62, "Output",
 Evaluatable->False,
 CellID->161386755]
}, Open  ]],
Cell[28029, 1115, 4212, 138, 70, "DefinitionBox",
 CellID->27254],
Cell[32244, 1255, 68, 1, 70, "Caption",
 CellID->21028],
Cell[32315, 1258, 624, 18, 70, "Text",
 CellID->10319],
Cell[CellGroupData[{
Cell[32964, 1280, 72, 1, 70, "RelatedTutorialsSection",
 CellID->487249946],
Cell[33039, 1283, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[33205, 1290, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

