(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12718,        387]
NotebookOptionsPosition[      8757,        280]
NotebookOutlinePosition[     11835,        354]
CellTagsIndexPosition[     11742,        348]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CompiledFunction" :> 
          Documentation`HelpLookup["paclet:ref/CompiledFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"CompiledFunction\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Compiled Code", "Title",
 CellTags->{"S2.6.17", "17.1"},
 CellID->8125],

Cell[TextData[{
 "If you use compiled code created by ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " only within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself, then you should never need to know the details of its internal \
form. Nevertheless, the compiled code can be represented by an ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, and it is sometimes useful to manipulate it. "
}], "Text",
 CellID->7406],

Cell[TextData[{
 "For example, you can take compiled code generated by ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 ", and feed it to external programs or devices. You can also create ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " objects yourself, then execute them in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->11410],

Cell[TextData[{
 "In all of these cases, you need to know the internal form of ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " objects. The first element of a ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " object is always a list of patterns which specifies the types of arguments \
accepted by the object. The fifth element of a ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " object is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pure function that is used if the compiled code instruction stream fails \
for any reason to give a result. "
}], "Text",
 CellID->28463],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CompiledFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CompiledFunction"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["arg", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["arg", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["reg", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["reg", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["l", "TI"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["r", "TI"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["c", "TI"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["t", "TI"]]}], "}"}], ",", 
      StyleBox["instr", "TI"], ",", 
      StyleBox["func", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "compiled code taking arguments of type ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["arg", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " and executing the instruction stream ",
     Cell[BoxData[
      StyleBox["instr", "TI"]], "InlineFormula"],
     " using ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " registers of type ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32048],

Cell["The structure of a compiled code object. ", "Caption",
 CellID->4690],

Cell[TextData[{
 "This shows the explicit form of the compiled code generated by ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"x", "^", "2"}]}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->5344],

Cell["\<\
CompiledFunction[{_Real}, {{3, 0, 0}, {3, 0, 1}}, {0, 1, 2, 0, 0}, 
 {{1, 5}, {7, 2, 0}, {94, 264, 3, 0, 0, 2, 0, 0, 3, 0, 1}, {2}}, 
 Function[{x}, x^2], Evaluate]\
\>", "Output",
 ImageSize->{469, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]//InputForm=",
 CellID->157998025]
}, Open  ]],

Cell[TextData[{
 "The instruction stream in a ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " object consists of a list of instructions for a simple idealized computer. \
The computer is assumed to have numbered \"registers\", on which operations \
can be performed. There are five basic types of registers: logical, integer, \
real, complex and tensor. For each of these basic types it is then possible \
to have either a single scalar register or an array of registers of any rank. \
A list of the total number of registers of each type required to evaluate a \
particular ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " object is given as the second element of the object. "
}], "Text",
 CellID->14643],

Cell["\<\
The actual instructions in the compiled code object are given as lists. The \
first element is an integer \"opcode\" which specifies what operation should \
be performed. Subsequent elements are either the numbers of registers of \
particular types, or literal constants. Typically the last element of the \
list is the number of a \"destination register\", into which the result of \
the operation should be put. \
\>", "Text",
 CellID->10155],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->17628278],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Compiled Code - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CompilingMathematicaExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 53.3355364}", "context" -> "", 
    "keywords" -> {
     "code", "compiled code", "CompiledFunction", "external programs", 
      "opcode", "pseudocode", "registers"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "If you use compiled code created by Compile only within Mathematica \
itself, then you should never need to know the details of its internal form. \
Nevertheless, the compiled code can be represented by an ordinary Mathematica \
expression, and it is sometimes useful to manipulate it. For example, you can \
take compiled code generated by Compile, and feed it to external programs or \
devices. You can also create CompiledFunction objects yourself, then execute \
them in Mathematica. In all of these cases, you need to know the internal \
form of CompiledFunction objects. The first element of a CompiledFunction \
object is always a list of patterns which specifies the types of arguments \
accepted by the object. The fifth element of a CompiledFunction object is a \
Mathematica pure function that is used if the compiled code instruction \
stream fails for any reason to give a result. ", "synonyms" -> {"2.6.16"}, 
    "title" -> "Manipulating Compiled Code", "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingCompiledCode"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.17"->{
  Cell[1854, 59, 90, 2, 70, "Title",
   CellTags->{"S2.6.17", "17.1"},
   CellID->8125]},
 "17.1"->{
  Cell[1854, 59, 90, 2, 70, "Title",
   CellTags->{"S2.6.17", "17.1"},
   CellID->8125]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.17", 11528, 337},
 {"17.1", 11629, 341}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1229, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1854, 59, 90, 2, 70, "Title",
 CellTags->{"S2.6.17", "17.1"},
 CellID->8125],
Cell[1947, 63, 529, 15, 70, "Text",
 CellID->7406],
Cell[2479, 80, 524, 16, 70, "Text",
 CellID->11410],
Cell[3006, 98, 862, 23, 70, "Text",
 CellID->28463],
Cell[3871, 123, 2303, 73, 70, "DefinitionBox",
 CellID->32048],
Cell[6177, 198, 75, 1, 70, "Caption",
 CellID->4690],
Cell[6255, 201, 240, 8, 70, "MathCaption",
 CellID->4969],
Cell[CellGroupData[{
Cell[6520, 213, 205, 7, 28, "Input",
 CellID->5344],
Cell[6728, 222, 333, 9, 82, "Output",
 CellID->157998025]
}, Open  ]],
Cell[7076, 234, 891, 19, 70, "Text",
 CellID->14643],
Cell[7970, 255, 454, 8, 70, "Text",
 CellID->10155],
Cell[CellGroupData[{
Cell[8449, 267, 71, 1, 70, "RelatedTutorialsSection",
 CellID->17628278],
Cell[8523, 270, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[8730, 278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

