(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14586,        414]
NotebookOptionsPosition[     10161,        305]
NotebookOutlinePosition[     13945,        391]
CellTagsIndexPosition[     13853,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CopyDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CopyDirectory"], "CopyFile" :> 
          Documentation`HelpLookup["paclet:ref/CopyFile"], "CreateDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CreateDirectory"], 
          "DeleteContents" :> 
          Documentation`HelpLookup["paclet:ref/DeleteContents"], 
          "DeleteDirectory" :> 
          Documentation`HelpLookup["paclet:ref/DeleteDirectory"], 
          "DeleteFile" :> Documentation`HelpLookup["paclet:ref/DeleteFile"], 
          "Directory" :> Documentation`HelpLookup["paclet:ref/Directory"], 
          "FileByteCount" :> 
          Documentation`HelpLookup["paclet:ref/FileByteCount"], "FileDate" :> 
          Documentation`HelpLookup["paclet:ref/FileDate"], "FileType" :> 
          Documentation`HelpLookup["paclet:ref/FileType"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "RenameDirectory" :> 
          Documentation`HelpLookup["paclet:ref/RenameDirectory"], 
          "RenameFile" :> Documentation`HelpLookup["paclet:ref/RenameFile"], 
          "SetFileDate" :> Documentation`HelpLookup["paclet:ref/SetFileDate"],
           "True" :> Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CopyDirectory\"\>", 
       2->"\<\"CopyFile\"\>", 3->"\<\"CreateDirectory\"\>", 
       4->"\<\"DeleteContents\"\>", 5->"\<\"DeleteDirectory\"\>", 
       6->"\<\"DeleteFile\"\>", 7->"\<\"Directory\"\>", 
       8->"\<\"FileByteCount\"\>", 9->"\<\"FileDate\"\>", 
       10->"\<\"FileType\"\>", 11->"\<\"None\"\>", 
       12->"\<\"RenameDirectory\"\>", 13->"\<\"RenameFile\"\>", 
       14->"\<\"SetFileDate\"\>", 15->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Files and Directories", "Title",
 CellTags->{"S2.12.6", "6.1"},
 CellID->29355],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CopyFile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CopyFile"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[TextData[{
     "copy ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], "1"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RenameFile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RenameFile"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], "1"]], "InlineFormula"],
     " the name ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DeleteFile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteFile"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "delete a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["FileByteCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileByteCount"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "give the number of bytes in a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["FileDate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileDate"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "give the modification date for a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetFileDate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetFileDate"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "set the modification date for a file to be the current date", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["FileType",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FileType"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "give the type of a file as ",
     Cell[BoxData["File"], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Directory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Directory"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25560],

Cell["Functions for manipulating files. ", "Caption",
 CellID->22133],

Cell[TextData[{
 "Different operating systems have different commands for manipulating files. \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a simple set of file manipulation functions, intended to work in \
the same way under all operating systems. "
}], "Text",
 CellID->15452],

Cell[TextData[{
 "Notice that ",
 Cell[BoxData[
  ButtonBox["CopyFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CopyFile"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RenameFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RenameFile"]], "InlineFormula"],
 " give the final file the same modification date as the original one. ",
 Cell[BoxData[
  ButtonBox["FileDate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileDate"]], "InlineFormula"],
 " returns modification dates in the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["year", "TI"], ",", 
    StyleBox["month", "TI"], ",", 
    StyleBox["day", "TI"], ",", 
    StyleBox["hour", "TI"], ",", 
    StyleBox["minute", "TI"], ",", 
    StyleBox["second", "TI"]}], "}"}]], "InlineFormula"],
 " format used by ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList",
   ButtonNote->"ObsLink: Date -> DateList"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24800],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CreateDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CreateDirectory"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "create a new directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["DeleteDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteDirectory"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "delete an empty directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["DeleteDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteDirectory"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     ButtonBox["DeleteContents",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteContents"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "delete a directory and all files and directories it contains", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["RenameDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RenameDirectory"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[
    "rename a directory", "TableText"]},
   {
    RowBox[{
     ButtonBox["CopyDirectory",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CopyDirectory"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[
    "copy a directory and all the files in it", "TableText"]}
  }]], "DefinitionBox",
 CellID->603],

Cell["Functions for manipulating directories. ", "Caption",
 CellID->31688],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->85114083],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Files and Directories - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FilesForPackages"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ImportingAndExportingFiles"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 59.2575630}", "context" -> "", 
    "keywords" -> {
     "bytes", "clobbering files", "CopyDirectory", "copy directory", 
      "CopyFile", "copy file", "CreateDirectory", "create directory", "dates",
       "del DOS command", "DeleteContents", "delete contents", 
      "DeleteDirectory", "delete directory", "DeleteFile", "delete file", 
      "directories", "disk file operations", "duplicating files", 
      "erasing files", "FileByteCount", "file byte count", "file length", 
      "file size", "FileDate", "file date", "file modification time", 
      "file creation time", "file access time", "FileType", "file type", 
      "folders", "directories", "ls -l Unix command", 
      "list directory files Unix command", "mkdir command", 
      "modification date", "moving directories", "moving files", 
      "purging directories", "removing files", "RenameDirectory", 
      "rename directory", "RenameFile", "rename file", "rmdir command", 
      "remove directory", "rm Unix command", "SetFileDate", "set file date", 
      "touch Unix command"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Functions for manipulating files. Different operating systems have \
different commands for manipulating files. Mathematica provides a simple set \
of file manipulation functions, intended to work in the same way under all \
operating systems. Notice that CopyFile and RenameFile give the final file \
the same modification date as the original one. FileDate returns modification \
dates in the {year,month,day,hour,minute,second} format used by DateList. ", 
    "synonyms" -> {"2.12.6"}, "title" -> "Manipulating Files and Directories",
     "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingFilesAndDirectories"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.6"->{
  Cell[3362, 82, 98, 2, 70, "Title",
   CellTags->{"S2.12.6", "6.1"},
   CellID->29355]},
 "6.1"->{
  Cell[3362, 82, 98, 2, 70, "Title",
   CellTags->{"S2.12.6", "6.1"},
   CellID->29355]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.6", 13640, 374},
 {"6.1", 13740, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2737, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3362, 82, 98, 2, 70, "Title",
 CellTags->{"S2.12.6", "6.1"},
 CellID->29355],
Cell[3463, 86, 3093, 96, 70, "DefinitionBox",
 CellID->25560],
Cell[6559, 184, 69, 1, 70, "Caption",
 CellID->22133],
Cell[6631, 187, 298, 8, 70, "Text",
 CellID->15452],
Cell[6932, 197, 1008, 34, 70, "Text",
 CellID->24800],
Cell[7943, 233, 1825, 53, 70, "DefinitionBox",
 CellID->603],
Cell[9771, 288, 75, 1, 70, "Caption",
 CellID->31688],
Cell[CellGroupData[{
Cell[9871, 293, 71, 1, 70, "RelatedTutorialsSection",
 CellID->85114083],
Cell[9945, 296, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[10134, 303, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

