(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61831,       2321]
NotebookOptionsPosition[     50260,       1917]
NotebookOutlinePosition[     53041,       1988]
CellTagsIndexPosition[     52948,       1982]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Manipulating Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], "Append" :> 
          Documentation`HelpLookup["paclet:ref/Append"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Prepend" :> 
          Documentation`HelpLookup["paclet:ref/Prepend"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"Append\"\>", 
       3->"\<\"Delete\"\>", 4->"\<\"Drop\"\>", 5->"\<\"Extract\"\>", 
       6->"\<\"Insert\"\>", 7->"\<\"None\"\>", 8->"\<\"Part\"\>", 
       9->"\<\"Prepend\"\>", 10->"\<\"ReplacePart\"\>", 
       11->"\<\"Take\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Lists by Their Indices", "Title",
 CellTags->{"S2.4.2", "2.1"},
 CellID->32425],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["spec", "TI"], "]", Cell["  or  ", "TableText"], 
     StyleBox["list", "TI"], "[", "[", 
     StyleBox["spec", "TI"], "]", "]"}], Cell[
    "part or parts of a list", "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", Cell["  or  ", "TableText"], 
     StyleBox["list", "TI"], "[", "[", 
     SubscriptBox[
      StyleBox["spec", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell["part or parts of a nested list", "TableText"]},
   {
    StyleBox["n", "TI"], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " part from the beginning"
    }], "TableText"]},
   {
    RowBox[{"-", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " part from the end"
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "a list of parts", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], ";;", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "parts ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["all parts", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->1699],

Cell["Getting parts of lists. ", "Caption",
 CellID->20770],

Cell["This gives a list of parts 1 and 3. ", "MathCaption",
 CellID->32014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->32510],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->12355]
}, Open  ]],

Cell["Here is a nested list. ", "MathCaption",
 CellID->24232],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "g", ",", "h"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5765],

Cell["This gives a list of its first and third parts. ", "MathCaption",
 CellID->18618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->16237]
}, Open  ]],

Cell["This gives a list of the first part of each of these. ", "MathCaption",
 CellID->28264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "f"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->30703]
}, Open  ]],

Cell["And this gives a list of the first two parts. ", "MathCaption",
 CellID->32544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->32050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->12541]
}, Open  ]],

Cell[TextData[{
 "This gives the first two parts of ",
 Cell[BoxData["m"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->17564639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->795831636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->443761221]
}, Open  ]],

Cell["This gives the last part of each of these.", "MathCaption",
 CellID->22780561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"1", ";;", "2"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->694941458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "e"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->331460183]
}, Open  ]],

Cell["This gives the second part of all sublists. ", "MathCaption",
 CellID->4301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->12344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "e", ",", "g"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->17427]
}, Open  ]],

Cell["This gives the last two parts of all sublists.", "MathCaption",
 CellID->84408224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{
     RowBox[{"-", "2"}], ";;", 
     RowBox[{"-", "1"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->62398583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->45761492]
}, Open  ]],

Cell[TextData[{
 "You can always reset one or more pieces of a list by doing an assignment \
like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->26141],

Cell[TextData[{
 "This resets part 1,2 of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->19696],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->14824]
}, Open  ]],

Cell[TextData[{
 "This is now the form of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19683],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[8]:= ",
 CellID->31098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->10640]
}, Open  ]],

Cell[TextData[{
 "This resets part 1 to ",
 Cell[BoxData["x"], "InlineFormula"],
 " and part 3 to ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";", "m"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->19570],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", "y"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->23754]
}, Open  ]],

Cell[TextData[{
 "This resets parts 1 and 3 both to ",
 Cell[BoxData["p"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}], "=", "p"}], ";", 
  "m"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->20903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", "p"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->19445]
}, Open  ]],

Cell[TextData[{
 "This restores the original form of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27609],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "g", ",", "h"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->15414],

Cell[TextData[{
 "This now resets all parts specified by ",
 Cell[BoxData[
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "=", "x"}], ";", 
  "m"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->22917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->11630]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox[";;",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Span"]], "InlineFormula"],
 " to indicate all indices in a given range. "
}], "MathCaption",
 CellID->25318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", ";;", "3"}], ",", "2"}], "]"}], "]"}], "=", "y"}], ";", 
  "m"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->380599757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "h"}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->47262813]
}, Open  ]],

Cell[TextData[{
 "It is sometimes useful to think of a nested list as being laid out in \
space, with each element being at a coordinate position given by its indices. \
There is then a direct geometrical interpretation for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ". If a given ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["spec", "TI"], "k"], TraditionalForm]], "InlineMath"],
 " is a single integer, then it represents extracting a single slice in the \
",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " dimension, while if it is a list, it represents extracting a list of \
parallel slices. The final result for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 " is then the collection of elements obtained by slicing in each successive \
dimension. "
}], "Text",
 CellID->24090],

Cell["\<\
Here is a nested list laid out as a two\[Hyphen]dimensional array. \
\>", "MathCaption",
 CellID->18461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"m", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}], ")"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->132],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNU80KwjAM7i/onCjiYSDCLp58Dz35EEUEPYgyff+ZtumcMf4exEKTJku+
pvmWlTtvN3t33q1duazccbtbn8rFoQKXlkKIGex5IeBcwynsWV2DjlKB1OAs
g2W99GYdlpg2MQacXYwVJrhxea8FLaNTR+WlImgdL2xjI0hOov4UxzQ4sBSc
MtQUNWPzFUanelLnhMHiwuphh2PQkCCNgneASPSrbLH6jlTIW4bsZp/x2LL7
xFY/QrDYMSaTZeueaz6bcpVY1Zhx7RKdl4LFM4g3QYxvmUpvzhHnzT7fvZrv
xbfzQv933dRsHt7F57y6m5s2vqbrzCXObucsx+pi3PM5G7eYEPICsDmuXw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//TableForm= ",
 CellID->655233342]
}, Open  ]],

Cell["This picks out rows 1 and 3, then columns 1 and 2. ", "MathCaption",
 CellID->21517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->26645],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFUc0KwjAMTtMOtgn+XMrAy55mnnyIMoTtIMrc+9ckjUWGB2GggeZLPpIv
bXoO83C5hnnsQ3uawn0Y+0fb3SairAEAT+fYAMWRIjk+RkIkbyk9SFaw5zSK
wTbXOCIrrQUrtJhJoAx7XGiU7Iqca6tJ+Os+l/vIkKJakVVMrkNl31/Krwen
Q8VkMuwX81PLThVko+C/9qzJly8V8S97ev14vUL781a5aLN6k2CerbhemQ==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//TableForm= ",
 CellID->85685687]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " is set up to make it easy to pick out structured slices of nested lists. \
Sometimes, however, you may want to pick out arbitrary collections of \
individual parts. You can do this conveniently with ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1818],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "the list ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["list", "TI"], "[", "["}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "1"]], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"]", "]", ",", 
       StyleBox["list", "TI"], "[", "["}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"]", "]", ",", 
       StyleBox["\[Ellipsis]", "TR"], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Extract",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extract"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "the element ",
     Cell[BoxData[
      RowBox[{
       StyleBox["list", "TI"], "[", "["}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "1"]], "InlineFormula"],
     Cell[BoxData[","], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData[
      RowBox[{",", 
       StyleBox["\[Ellipsis]", "TR"], "]", "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "parts specified by successive slicing", "TableText"]},
   {
    RowBox[{
     ButtonBox["Extract",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extract"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the list of individual parts ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         StyleBox["list", "TI"], "[", 
         RowBox[{"[", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}], ",", 
        RowBox[{
         StyleBox["list", "TI"], "[", 
         RowBox[{"[", 
          RowBox[{
           SubscriptBox[
            StyleBox["j", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["j", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->21805],

Cell["Getting slices versus lists of individual parts. ", "Caption",
 CellID->4333],

Cell["This extracts the individual parts 1,3 and 1,2. ", "MathCaption",
 CellID->4721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->15246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->4970]
}, Open  ]],

Cell[TextData[{
 "An important feature of ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 " is that it takes lists of part positions in the same form as they are \
returned by functions like ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15788],

Cell["This sets up a nested list. ", "MathCaption",
 CellID->26394],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "[", "1", "]"}], ",", 
       RowBox[{"a", "[", "2", "]"}], ",", 
       RowBox[{"b", "[", "1", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", "2", "]"}], ",", 
       RowBox[{"c", "[", "1", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"b", "[", "3", "]"}], "}"}], "}"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[17]:= ",
 CellID->31008],

Cell[TextData[{
 "This gives a list of positions in ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"m", ",", 
   RowBox[{"b", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->8835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->20577]
}, Open  ]],

Cell["This extracts the elements at those positions. ", "MathCaption",
 CellID->5675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"m", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->205],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"b", "[", "1", "]"}], ",", 
   RowBox[{"b", "[", "2", "]"}], ",", 
   RowBox[{"b", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->20050]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Take"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["spec", "TI"], "]"}], Cell[
    "take the specified parts of a list", "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["spec", "TI"], "]"}], Cell[
    "drop the specified parts of a list", "TableText"]},
   {
    RowBox[{
     ButtonBox["Take",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Take"], "[", 
     StyleBox["list", "TI"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", Cell[", ", "TableText"], 
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["list", "TI"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["spec", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "take or drop specified parts at each level in nested lists", 
     "TableText"]},
   {
    StyleBox["n", "TI"], Cell[TextData[{
     "the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements"
    }], "TableText"]},
   {
    RowBox[{"-", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the last ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " only"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " (inclusive)"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["s", "TI"], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in steps of ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["all parts", "TableText"]},
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no parts", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, True, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}}},
 CellID->14642],

Cell["Taking and dropping sequences of elements in lists. ", "Caption",
 CellID->19254],

Cell["This takes every second element starting at position 2. ", "MathCaption",
 CellID->30318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->1390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "f"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->18724]
}, Open  ]],

Cell["This drops every second element. ", "MathCaption",
 CellID->979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->31365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "e", ",", "g"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->14754]
}, Open  ]],

Cell[TextData[{
 "Much like ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " can be viewed as picking out sequences of slices at successive levels in a \
nested list. You can use ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " to work with blocks of elements in arrays. "
}], "Text",
 CellID->3171],

Cell[TextData[{
 "Here is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "3"}], TraditionalForm]], "InlineMath"],
 " array. "
}], "MathCaption",
 CellID->14022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"m", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}], ")"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->5844],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNU80KwjAM7i/onCjiYSDCLp58Dz35EEUEPYgyff+ZtumcMf4exEKTJku+
pvmWlTtvN3t33q1duazccbtbn8rFoQKXlkKIGex5IeBcwynsWV2DjlKB1OAs
g2W99GYdlpg2MQacXYwVJrhxea8FLaNTR+WlImgdL2xjI0hOov4UxzQ4sBSc
MtQUNWPzFUanelLnhMHiwuphh2PQkCCNgneASPSrbLH6jlTIW4bsZp/x2LL7
xFY/QrDYMSaTZeueaz6bcpVY1Zhx7RKdl4LFM4g3QYxvmUpvzhHnzT7fvZrv
xbfzQv933dRsHt7F57y6m5s2vqbrzCXObucsx+pi3PM5G7eYEPICsDmuXw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]//TableForm= ",
 CellID->925126760]
}, Open  ]],

Cell[TextData[{
 "Here is the first ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", "2"}], TraditionalForm]], "InlineMath"],
 " subarray. "
}], "MathCaption",
 CellID->22509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", 
   RowBox[{"m", ",", "2", ",", "2"}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->2410],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1UdsKwjAMTdMWREH3NARf9jXuaR9RhrA9iDL3/13SZrNOnSJYaG49OU1P
K9c3p7Pr29oVZeeuTVvfiuOlo5JWAJDTPuyBYk9R2Ln35FOLZC0drckb8ipU
QUfHlhGgY8LhapbrP3XY+zRmQtJCmRbsVIrHgkbBpPyMZ/pwD9jZbdtQNdKX
PWm0bEcFx5nxOz3eTP9rH8r/LSnziRtlevXAyqANZ0Zaw4qvzF7+7E64bKIS
qAHR7Umu\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]//TableForm= ",
 CellID->29424757]
}, Open  ]],

Cell["This takes all elements in the first two columns. ", "MathCaption",
 CellID->16552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", 
   RowBox[{"m", ",", "All", ",", "2"}], "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->15874],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9U9sKwjAMTW/gBXS+jD3u3f/QJz+iDGF7EGXu/2vSZmXM6cYmBnrShpyk
PaQX25TXm22qwubn2j7Kqnjmp3uNISUAIMV1zAD3Dnd+pc6hDygRFQYP/mQI
6ei8wS7maAyuOReUD3sTwXGEUPZqrAhMPDNVBP9vno48NIm7DXuqImKe5Gj3
pfR60NzUm+8MSa9/oOy5guloPQWppuF76envfev/e4YZUfGT5n0tCSlfRQWH
p04zL5mpYHtnuWxiZvLaP/NNmbHaw3NJSVu3dBZBvABAvgRz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]//TableForm= ",
 CellID->58683830]
}, Open  ]],

Cell["This leaves no elements from the first two columns. ", "MathCaption",
 CellID->13697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{"m", ",", "None", ",", "2"}], "]"}], "//", "TableForm"}]], "Input",\

 CellLabel->"In[25]:= ",
 CellID->15370],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwsAOxtgQDkP0fyAJj
9v//gTQmycAMoUCAGYgZwVywIIj7HwyoJsrAgrANZjU7HvW4XE2sP5jQTGWi
kigptoGUItQQ7yMmqD5UG2HmMsJNRJZhIUIEVTeIx4LHdQyMABE6G7c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{7, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]//TableForm= ",
 CellID->57104366]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Prepend",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prepend"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["elem", "TI"], "]"}], Cell[TextData[{
     "add ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     " at the beginning of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Append",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Append"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["elem", "TI"], "]"}], Cell[TextData[{
     "add ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     " at the end of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Insert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Insert"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["elem", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "insert ",
     Cell[BoxData[
      StyleBox["element", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Insert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Insert"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["elem", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "insert at position ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "\[Ellipsis]"}], "}"}], TraditionalForm]],
       "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Delete",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Delete"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "delete the element at position ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Delete",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Delete"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "delete at position ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "\[Ellipsis]"}], "}"}], TraditionalForm]],
       "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->20267],

Cell["Adding and deleting elements in lists. ", "Caption",
 CellID->12341],

Cell[TextData[{
 "This makes the 2,1 element of the list be ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->24968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->25065]
}, Open  ]],

Cell["This deletes the element again. ", "MathCaption",
 CellID->27321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->18655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->16727]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       StyleBox["i", "TI"], "->", 
       StyleBox["new", "TI"]}]}], "]"}], Cell[TextData[{
     "replace the element at position ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["new", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["i", "TI"], ",", 
         StyleBox["j", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
       StyleBox["new", "TI"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "replace ",
     Cell[BoxData[
      RowBox[{
       StyleBox["list", "TI"], "[", "[", 
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"], "]", "]"}]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["new", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["1", "TR"]], "->", 
         SubscriptBox[
          StyleBox["new", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["2", "TR"]], "->", 
         SubscriptBox[
          StyleBox["new", "TI"], 
          StyleBox["2", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {" ", Cell[TextData[{
     "replaces parts at positions ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["i", "n"], TraditionalForm]], "InlineMath"],
     " by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["new", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["j", "TI"], 
            StyleBox["1", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
         SubscriptBox[
          StyleBox["new", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {" ", Cell[TextData[{
     "replace parts at positions ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["i", "n"], ",", 
         SubscriptBox["j", "n"], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["new", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplacePart"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["j", "TI"], 
            StyleBox["1", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
       StyleBox["new", "TI"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "replace all parts ",
     Cell[BoxData[
      RowBox[{
       StyleBox["list", "TI"], "[", 
       RowBox[{"[", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["k", "TI"]], ",", 
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["k", "TI"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["new", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->26914],

Cell["Replacing parts of lists. ", "Caption",
 CellID->8283],

Cell[TextData[{
 "This replaces the third element in the list with ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"3", "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->6932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->26549]
}, Open  ]],

Cell["\<\
This replaces the first and fourth parts of the list. Notice the need for \
double lists in specifying multiple parts to replace. \
\>", "MathCaption",
 CellID->1162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "4", "}"}]}], "}"}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->12882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "b", ",", "c", ",", "x"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]= ",
 CellID->14035]
}, Open  ]],

Cell[TextData[{
 "Here is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "3"}], TraditionalForm]], "InlineMath"],
 " identity matrix. "
}], "MathCaption",
 CellID->28592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IdentityMatrix", "[", "3", "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->25135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->8930]
}, Open  ]],

Cell[TextData[{
 "This replaces the 2,2 component of the matrix by ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->17520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "x", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]= ",
 CellID->17728]
}, Open  ]],

Cell[TextData[{
 "It is important to understand that ",
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " always creates a new list. It does not modify a list that has already been \
assigned to a symbol, the way ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], "[", 
    RowBox[{"[", 
     StyleBox["\[Ellipsis]", "TI"], "]"}], "]"}], "=", 
   StyleBox["val", "TI"]}]], "InlineFormula"],
 " does."
}], "Text",
 CellID->471203847],

Cell[TextData[{
 "This assigns a list of values to ",
 Cell[BoxData["alist"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->60215277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"alist", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[29]:=",
 CellID->384839588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->613755225]
}, Open  ]],

Cell[TextData[{
 "This gives a copy of the list in which the third element has been replaced \
with ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->282396461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{"alist", ",", 
   RowBox[{"3", "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->841728092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->92205992]
}, Open  ]],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["alist"], "InlineFormula"],
 " has not changed."
}], "MathCaption",
 CellID->26916948],

Cell[CellGroupData[{

Cell[BoxData["alist"], "Input",
 CellLabel->"In[31]:=",
 CellID->153738084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->18274248]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->343523059],

Cell[TextData[ButtonBox["Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsOverview"]], "RelatedTutorials",\

 CellID->30468725]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Lists by Their Indices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Lists", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/ManipulatingListsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ConstructingLists"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NestedLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 0.5857220}", "context" -> "", 
    "keywords" -> {
     "addition", "Append", "appending", "changing parts", "columns", "Delete",
       "deleting elements", "discard elements", "Drop", "Extract", "indices", 
      "Insert", "lists", "matrices", "Part", "parts", "Prepend", 
      "removing elements from lists", "replacements", "ReplacePart", "rows", 
      "sequence of elements", "shortening lists", "slices", "stride", 
      "Sublists", "take"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Getting parts of lists. This gives a list of parts 1 and 3. Here is a \
nested list. ", "synonyms" -> {"2.4.2"}, "title" -> 
    "Manipulating Lists by Their Indices", "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingListsByTheirIndices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.4.2"->{
  Cell[2717, 71, 98, 2, 70, "Title",
   CellTags->{"S2.4.2", "2.1"},
   CellID->32425]},
 "2.1"->{
  Cell[2717, 71, 98, 2, 70, "Title",
   CellTags->{"S2.4.2", "2.1"},
   CellID->32425]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.4.2", 52737, 1971},
 {"2.1", 52836, 1975}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2092, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2717, 71, 98, 2, 70, "Title",
 CellTags->{"S2.4.2", "2.1"},
 CellID->32425],
Cell[2818, 75, 2445, 80, 70, "DefinitionBox",
 CellID->1699],
Cell[5266, 157, 59, 1, 70, "Caption",
 CellID->20770],
Cell[5328, 160, 75, 1, 70, "MathCaption",
 CellID->32014],
Cell[CellGroupData[{
Cell[5428, 165, 233, 8, 28, "Input",
 CellID->32510],
Cell[5664, 175, 200, 7, 36, "Output",
 CellID->12355]
}, Open  ]],
Cell[5879, 185, 62, 1, 70, "MathCaption",
 CellID->24232],
Cell[5944, 188, 344, 12, 70, "Input",
 CellID->5765],
Cell[6291, 202, 87, 1, 70, "MathCaption",
 CellID->18618],
Cell[CellGroupData[{
Cell[6403, 207, 166, 6, 28, "Input",
 CellID->31720],
Cell[6572, 215, 319, 11, 36, "Output",
 CellID->16237]
}, Open  ]],
Cell[6906, 229, 93, 1, 70, "MathCaption",
 CellID->28264],
Cell[CellGroupData[{
Cell[7024, 234, 190, 7, 70, "Input",
 CellID->709],
Cell[7217, 243, 200, 7, 36, "Output",
 CellID->30703]
}, Open  ]],
Cell[7432, 253, 85, 1, 70, "MathCaption",
 CellID->32544],
Cell[CellGroupData[{
Cell[7542, 258, 243, 9, 70, "Input",
 CellID->32050],
Cell[7788, 269, 299, 11, 36, "Output",
 CellID->12541]
}, Open  ]],
Cell[8102, 283, 135, 5, 70, "MathCaption",
 CellID->17564639],
Cell[CellGroupData[{
Cell[8262, 292, 145, 5, 70, "Input",
 CellID->795831636],
Cell[8410, 299, 312, 11, 36, "Output",
 CellID->443761221]
}, Open  ]],
Cell[8737, 313, 84, 1, 70, "MathCaption",
 CellID->22780561],
Cell[CellGroupData[{
Cell[8846, 318, 190, 7, 70, "Input",
 CellID->694941458],
Cell[9039, 327, 203, 7, 36, "Output",
 CellID->331460183]
}, Open  ]],
Cell[9257, 337, 82, 1, 70, "MathCaption",
 CellID->4301],
Cell[CellGroupData[{
Cell[9364, 342, 143, 5, 70, "Input",
 CellID->12344],
Cell[9510, 349, 210, 7, 36, "Output",
 CellID->17427]
}, Open  ]],
Cell[9735, 359, 88, 1, 70, "MathCaption",
 CellID->84408224],
Cell[CellGroupData[{
Cell[9848, 364, 213, 8, 70, "Input",
 CellID->62398583],
Cell[10064, 374, 360, 13, 36, "Output",
 CellID->45761492]
}, Open  ]],
Cell[10439, 390, 325, 12, 70, "Text",
 CellID->26141],
Cell[10767, 404, 122, 5, 70, "MathCaption",
 CellID->2910],
Cell[CellGroupData[{
Cell[10914, 413, 166, 6, 70, "Input",
 CellID->19696],
Cell[11083, 421, 155, 5, 36, "Output",
 CellID->14824]
}, Open  ]],
Cell[11253, 429, 123, 5, 70, "MathCaption",
 CellID->19683],
Cell[CellGroupData[{
Cell[11401, 438, 67, 2, 70, "Input",
 CellID->31098],
Cell[11471, 442, 378, 13, 36, "Output",
 CellID->10640]
}, Open  ]],
Cell[11864, 458, 178, 7, 70, "MathCaption",
 CellID->1131],
Cell[CellGroupData[{
Cell[12067, 469, 268, 10, 70, "Input",
 CellID->19570],
Cell[12338, 481, 259, 9, 36, "Output",
 CellID->23754]
}, Open  ]],
Cell[12612, 493, 133, 5, 70, "MathCaption",
 CellID->23535],
Cell[CellGroupData[{
Cell[12770, 502, 223, 9, 70, "Input",
 CellID->20903],
Cell[12996, 513, 260, 9, 36, "Output",
 CellID->19445]
}, Open  ]],
Cell[13271, 525, 134, 5, 70, "MathCaption",
 CellID->27609],
Cell[13408, 532, 346, 12, 70, "Input",
 CellID->15414],
Cell[13757, 546, 321, 12, 70, "MathCaption",
 CellID->26032],
Cell[CellGroupData[{
Cell[14103, 562, 306, 12, 70, "Input",
 CellID->22917],
Cell[14412, 576, 379, 13, 36, "Output",
 CellID->11630]
}, Open  ]],
Cell[14806, 592, 223, 8, 70, "MathCaption",
 CellID->25318],
Cell[CellGroupData[{
Cell[15054, 604, 227, 9, 70, "Input",
 CellID->380599757],
Cell[15284, 615, 381, 13, 36, "Output",
 CellID->47262813]
}, Open  ]],
Cell[15680, 631, 1466, 45, 70, "Text",
 CellID->24090],
Cell[17149, 678, 114, 3, 70, "MathCaption",
 CellID->18461],
Cell[CellGroupData[{
Cell[17288, 685, 403, 14, 28, "Input",
 CellID->132],
Cell[17694, 701, 590, 14, 78, "Output",
 Evaluatable->False,
 CellID->655233342]
}, Open  ]],
Cell[18299, 718, 90, 1, 70, "MathCaption",
 CellID->21517],
Cell[CellGroupData[{
Cell[18414, 723, 285, 11, 28, "Input",
 CellID->26645],
Cell[18702, 736, 467, 12, 62, "Output",
 Evaluatable->False,
 CellID->85685687]
}, Open  ]],
Cell[19184, 751, 480, 14, 70, "Text",
 CellID->1818],
Cell[19667, 767, 4388, 138, 70, "DefinitionBox",
 CellID->21805],
Cell[24058, 907, 83, 1, 70, "Caption",
 CellID->4333],
Cell[24144, 910, 86, 1, 70, "MathCaption",
 CellID->4721],
Cell[CellGroupData[{
Cell[24255, 915, 279, 10, 70, "Input",
 CellID->15246],
Cell[24537, 927, 200, 7, 36, "Output",
 CellID->4970]
}, Open  ]],
Cell[24752, 937, 419, 14, 70, "Text",
 CellID->15788],
Cell[25174, 953, 67, 1, 70, "MathCaption",
 CellID->26394],
Cell[25244, 956, 536, 19, 70, "Input",
 CellID->31008],
Cell[25783, 977, 133, 5, 70, "MathCaption",
 CellID->17227],
Cell[CellGroupData[{
Cell[25941, 986, 153, 5, 70, "Input",
 CellID->8835],
Cell[26097, 993, 369, 13, 36, "Output",
 CellID->20577]
}, Open  ]],
Cell[26481, 1009, 85, 1, 70, "MathCaption",
 CellID->5675],
Cell[CellGroupData[{
Cell[26591, 1014, 122, 4, 70, "Input",
 CellID->205],
Cell[26716, 1020, 299, 10, 36, "Output",
 CellID->20050]
}, Open  ]],
Cell[27030, 1033, 3089, 105, 70, "DefinitionBox",
 CellID->14642],
Cell[30122, 1140, 87, 1, 70, "Caption",
 CellID->19254],
Cell[30212, 1143, 95, 1, 70, "MathCaption",
 CellID->30318],
Cell[CellGroupData[{
Cell[30332, 1148, 304, 10, 70, "Input",
 CellID->1390],
Cell[30639, 1160, 211, 7, 36, "Output",
 CellID->18724]
}, Open  ]],
Cell[30865, 1170, 70, 1, 70, "MathCaption",
 CellID->979],
Cell[CellGroupData[{
Cell[30960, 1175, 305, 10, 70, "Input",
 CellID->31365],
Cell[31268, 1187, 221, 7, 36, "Output",
 CellID->14754]
}, Open  ]],
Cell[31504, 1197, 795, 29, 70, "Text",
 CellID->3171],
Cell[32302, 1228, 172, 7, 70, "MathCaption",
 CellID->14022],
Cell[CellGroupData[{
Cell[32499, 1239, 404, 14, 28, "Input",
 CellID->5844],
Cell[32906, 1255, 590, 14, 78, "Output",
 Evaluatable->False,
 CellID->925126760]
}, Open  ]],
Cell[33511, 1272, 183, 7, 70, "MathCaption",
 CellID->22509],
Cell[CellGroupData[{
Cell[33719, 1283, 163, 5, 28, "Input",
 CellID->2410],
Cell[33885, 1290, 475, 12, 62, "Output",
 Evaluatable->False,
 CellID->29424757]
}, Open  ]],
Cell[34375, 1305, 89, 1, 70, "MathCaption",
 CellID->16552],
Cell[CellGroupData[{
Cell[34489, 1310, 166, 5, 28, "Input",
 CellID->15874],
Cell[34658, 1317, 515, 12, 78, "Output",
 Evaluatable->False,
 CellID->58683830]
}, Open  ]],
Cell[35188, 1332, 91, 1, 70, "MathCaption",
 CellID->13697],
Cell[CellGroupData[{
Cell[35304, 1337, 169, 6, 28, "Input",
 CellID->15370],
Cell[35476, 1345, 400, 10, 78, "Output",
 Evaluatable->False,
 CellID->57104366]
}, Open  ]],
Cell[35891, 1358, 2646, 89, 70, "DefinitionBox",
 CellID->20267],
Cell[38540, 1449, 74, 1, 70, "Caption",
 CellID->12341],
Cell[38617, 1452, 139, 5, 70, "MathCaption",
 CellID->617],
Cell[CellGroupData[{
Cell[38781, 1461, 347, 12, 70, "Input",
 CellID->24968],
Cell[39131, 1475, 320, 11, 36, "Output",
 CellID->25065]
}, Open  ]],
Cell[39466, 1489, 71, 1, 70, "MathCaption",
 CellID->27321],
Cell[CellGroupData[{
Cell[39562, 1494, 172, 6, 70, "Input",
 CellID->18655],
Cell[39737, 1502, 310, 11, 36, "Output",
 CellID->16727]
}, Open  ]],
Cell[40062, 1516, 4728, 161, 70, "DefinitionBox",
 CellID->26914],
Cell[44793, 1679, 60, 1, 70, "Caption",
 CellID->8283],
Cell[44856, 1682, 147, 5, 70, "MathCaption",
 CellID->2137],
Cell[CellGroupData[{
Cell[45028, 1691, 221, 7, 70, "Input",
 CellID->6932],
Cell[45252, 1700, 221, 7, 36, "Output",
 CellID->26549]
}, Open  ]],
Cell[45488, 1710, 176, 4, 70, "MathCaption",
 CellID->1162],
Cell[CellGroupData[{
Cell[45689, 1718, 327, 11, 70, "Input",
 CellID->12882],
Cell[46019, 1731, 221, 7, 36, "Output",
 CellID->14035]
}, Open  ]],
Cell[46255, 1741, 182, 7, 70, "MathCaption",
 CellID->28592],
Cell[CellGroupData[{
Cell[46462, 1752, 108, 3, 70, "Input",
 CellID->25135],
Cell[46573, 1757, 388, 13, 36, "Output",
 CellID->8930]
}, Open  ]],
Cell[46976, 1773, 147, 5, 70, "MathCaption",
 CellID->2534],
Cell[CellGroupData[{
Cell[47148, 1782, 204, 7, 70, "Input",
 CellID->17520],
Cell[47355, 1791, 389, 13, 36, "Output",
 CellID->17728]
}, Open  ]],
Cell[47759, 1807, 525, 17, 70, "Text",
 CellID->471203847],
Cell[48287, 1826, 139, 5, 70, "MathCaption",
 CellID->60215277],
Cell[CellGroupData[{
Cell[48451, 1835, 164, 5, 70, "Input",
 CellID->384839588],
Cell[48618, 1842, 224, 7, 36, "Output",
 CellID->613755225]
}, Open  ]],
Cell[48857, 1852, 185, 6, 70, "MathCaption",
 CellID->282396461],
Cell[CellGroupData[{
Cell[49067, 1862, 160, 5, 70, "Input",
 CellID->841728092],
Cell[49230, 1869, 223, 7, 36, "Output",
 CellID->92205992]
}, Open  ]],
Cell[49468, 1879, 134, 5, 70, "MathCaption",
 CellID->26916948],
Cell[CellGroupData[{
Cell[49627, 1888, 75, 2, 70, "Input",
 CellID->153738084],
Cell[49705, 1892, 223, 7, 36, "Output",
 CellID->18274248]
}, Open  ]],
Cell[CellGroupData[{
Cell[49965, 1904, 72, 1, 70, "RelatedTutorialsSection",
 CellID->343523059],
Cell[50040, 1907, 166, 4, 70, "RelatedTutorials",
 CellID->30468725]
}, Open  ]]
}, Open  ]],
Cell[50233, 1915, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

