(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    218014,       4931]
NotebookOptionsPosition[    202378,       4439]
NotebookOutlinePosition[    207200,       4540]
CellTagsIndexPosition[    207104,       4534]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], "All" :> 
          Documentation`HelpLookup["paclet:ref/All"], "Automatic" :> 
          Documentation`HelpLookup["paclet:ref/Automatic"], "ButtonNotebook" :> 
          Documentation`HelpLookup["paclet:ref/ButtonNotebook"], "CellLabel" :> 
          Documentation`HelpLookup["paclet:ref/CellLabel"], "CellTags" :> 
          Documentation`HelpLookup["paclet:ref/CellTags"], "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], 
          "EvaluationNotebook" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationNotebook"], 
          "IgnoreCase" :> Documentation`HelpLookup["paclet:ref/IgnoreCase"], 
          "InputNotebook" :> 
          Documentation`HelpLookup["paclet:ref/InputNotebook"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "NotebookApply" :> 
          Documentation`HelpLookup["paclet:ref/NotebookApply"], 
          "NotebookClose" :> 
          Documentation`HelpLookup["paclet:ref/NotebookClose"], 
          "NotebookDelete" :> 
          Documentation`HelpLookup["paclet:ref/NotebookDelete"], 
          "NotebookFind" :> 
          Documentation`HelpLookup["paclet:ref/NotebookFind"], "NotebookGet" :> 
          Documentation`HelpLookup["paclet:ref/NotebookGet"], 
          "NotebookLocate" :> 
          Documentation`HelpLookup["paclet:ref/NotebookLocate"], 
          "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], 
          "NotebookPrint" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPrint"], "NotebookPut" :> 
          Documentation`HelpLookup["paclet:ref/NotebookPut"], "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], "Notebooks" :> 
          Documentation`HelpLookup["paclet:ref/Notebooks"], "NotebookSave" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSave"], 
          "NotebookSelection" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSelection"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"], "Options" :> 
          Documentation`HelpLookup["paclet:ref/Options"], "SelectionAnimate" :> 
          Documentation`HelpLookup["paclet:ref/SelectionAnimate"], 
          "SelectionCreateCell" :> 
          Documentation`HelpLookup["paclet:ref/SelectionCreateCell"], 
          "SelectionEvaluate" :> 
          Documentation`HelpLookup["paclet:ref/SelectionEvaluate"], 
          "SelectionEvaluateCreateCell" :> 
          Documentation`HelpLookup["paclet:ref/SelectionEvaluateCreateCell"], 
          "SelectionMove" :> 
          Documentation`HelpLookup["paclet:ref/SelectionMove"], "SetOptions" :> 
          Documentation`HelpLookup["paclet:ref/SetOptions"], 
          "SetSelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SetSelectedNotebook"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AbsoluteOptions\"\>", 2->"\<\"All\"\>", 
       3->"\<\"Automatic\"\>", 4->"\<\"ButtonNotebook\"\>", 
       5->"\<\"CellLabel\"\>", 6->"\<\"CellTags\"\>", 
       7->"\<\"CreateDocument\"\>", 8->"\<\"CurrentValue\"\>", 
       9->"\<\"EvaluationNotebook\"\>", 10->"\<\"IgnoreCase\"\>", 
       11->"\<\"InputNotebook\"\>", 12->"\<\"None\"\>", 
       13->"\<\"NotebookApply\"\>", 14->"\<\"NotebookClose\"\>", 
       15->"\<\"NotebookDelete\"\>", 16->"\<\"NotebookFind\"\>", 
       17->"\<\"NotebookGet\"\>", 18->"\<\"NotebookLocate\"\>", 
       19->"\<\"NotebookOpen\"\>", 20->"\<\"NotebookPrint\"\>", 
       21->"\<\"NotebookPut\"\>", 22->"\<\"NotebookRead\"\>", 
       23->"\<\"Notebooks\"\>", 24->"\<\"NotebookSave\"\>", 
       25->"\<\"NotebookSelection\"\>", 26->"\<\"NotebookWrite\"\>", 
       27->"\<\"Options\"\>", 28->"\<\"SelectionAnimate\"\>", 
       29->"\<\"SelectionCreateCell\"\>", 30->"\<\"SelectionEvaluate\"\>", 
       31->"\<\"SelectionEvaluateCreateCell\"\>", 32->"\<\"SelectionMove\"\>",
        33->"\<\"SetOptions\"\>", 34->"\<\"SetSelectedNotebook\"\>", 
       35->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Notebooks from the Kernel", "Title",
 CellTags->{"S2.11.3", "3.1"},
 CellID->29688],

Cell[TextData[{
 "If you want to do simple operations on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks, then you will usually find it convenient just to use the \
interactive capabilities of the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. But if you want to do more complicated and systematic \
operations, then you will often find it better to use the kernel. "
}], "Text",
 CellID->19724],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Notebooks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Notebooks"], "[", "]"}], Cell[
    "a list of all your open notebooks", "TableText"]},
   {
    RowBox[{
     ButtonBox["Notebooks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Notebooks"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "a list of all open notebooks with the specified name", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputNotebook"], "[", "]"}], Cell[
    "the notebook into which typed input will go", "TableText"]},
   {
    RowBox[{
     ButtonBox["EvaluationNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EvaluationNotebook"], "[", "]"}], Cell[
    "the notebook in which this function is being evaluated", "TableText"]},
   {
    RowBox[{
     ButtonBox["ButtonNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ButtonNotebook"], "[", "]"}], Cell["\<\
the notebook containing the button (if any) which initiated this evaluation\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26634],

Cell["\<\
Functions that give the notebook objects corresponding to particular \
notebooks. \
\>", "Caption",
 CellID->25233],

Cell[TextData[{
 "Within the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, notebooks that you have open in the front end are referred to by \
",
 StyleBox["notebook objects",
  FontSlant->"Italic"],
 " of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookObject"], "[", 
   RowBox[{
    StyleBox["fe", "TI"], ",", 
    StyleBox["id", "TI"]}], "]"}]], "InlineFormula"],
 ". The first argument of ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " specifies the ",
 Cell[BoxData["FrontEndObject"], "InlineFormula"],
 " for the front end in which the notebook resides, while the second argument \
gives a unique serial number for the notebook. "
}], "Text",
 CellID->5603],

Cell[TextData[{
 "Here is a notebook named ",
 Cell[BoxData[
  RowBox[{"Example", ".", "nb"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17125],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->1086609923],

Cell["\<\
This finds the corresponding notebook object in the front end. \
\>", "MathCaption",
 CellID->12782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Notebooks", "[", "\"\<Example.nb\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->20760],

Cell["{NotebookObject[<<Example.nb>>]}", "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17065]
}, Open  ]],

Cell["\<\
This gets the expression corresponding to the notebook into the kernel. \
\>", "MathCaption",
 CellID->31930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookGet", "[", 
  RowBox[{"First", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->28264],

Cell["\<\
Notebook[{Cell[First Heading, Section],
    Cell[Second Heading, Section]}]\
\>", "Output",
 ImageSize->{273, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5423]
}, Open  ]],

Cell[TextData[{
 "This replaces every occurrence of the string ",
 Cell[BoxData["\"\<Section\>\""], "InlineFormula"],
 " by ",
 Cell[BoxData[
  ButtonBox["\"\<Text\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Text"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"\"\<Section\>\"", "->", "\"\<Text\>\""}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->4486],

Cell["\<\
Notebook[{Cell[First Heading, Text],
    Cell[Second Heading, Text]}]\
\>", "Output",
 ImageSize->{252, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28908]
}, Open  ]],

Cell["This creates a new modified notebook in the front end. ", "MathCaption",
 CellID->14638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookPut", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->8631],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->1485416934],

Cell["{NotebookObject[<<Untitled-1.nb>>]}", "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->6426]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NotebookGet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookGet"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "get the notebook expression corresponding to the notebook object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookPut",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookPut"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "replaces the notebook represented by the notebook object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " with one corresponding to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookPut",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookPut"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "creates a notebook corresponding to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " and makes it the currently selected notebook in the front end"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4362],

Cell["\<\
Exchanging whole notebook expressions between the kernel and front end. \
\>", "Caption",
 CellID->563],

Cell[TextData[{
 "If you want to do extensive manipulations on a particular notebook you will \
usually find it convenient to use ",
 Cell[BoxData[
  ButtonBox["NotebookGet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookGet"]], "InlineFormula"],
 " to get the whole notebook into the kernel as a single expression. But if \
instead you want to do a sequence of small operations on a notebook, then it \
is often better to leave the notebook in the front end, and then to send \
specific commands from the kernel to the front end to tell it what operations \
to do. "
}], "Text",
 CellID->8378],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up so that anything you can do interactively to a notebook in the \
front end you can also do by sending appropriate commands to the front end \
from the kernel. "
}], "Text",
 CellID->14419],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[TextData[{
     "give a list of all options set for the notebook corresponding to \
notebook object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[
    "gives the option setting", "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsoluteOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[TextData[{
     "gives the option setting with absolute option values even when the \
actual setting is ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CurrentValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CurrentValue"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["option", "TI"]}], "]"}], Cell[TextData[{
     "gives and sets the value of ",
     Cell[BoxData[
      StyleBox["option", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"], "]"}], Cell[
    "set the value of an option", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31851],

Cell["Finding and setting options for notebooks. ", "Caption",
 CellID->8741],

Cell[TextData[{
 "This gives the setting of the ",
 Cell[BoxData[
  ButtonBox["WindowSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowSize"]], "InlineFormula"],
 " option for your currently selected notebook. "
}], "MathCaption",
 CellID->25315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{
   RowBox[{"InputNotebook", "[", "]"}], ",", "WindowSize"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->13076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WindowSize", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"250.`", ",", "100.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->21168]
}, Open  ]],

Cell["\<\
This changes the size of the currently selected notebook on the screen. \
\>", "MathCaption",
 CellID->11521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"InputNotebook", "[", "]"}], ",", 
   RowBox[{"WindowSize", "->", 
    RowBox[{"{", 
     RowBox[{"250", ",", "100"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30098],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{250, 100},
 ImageMargins->0,
 CellID->1963747081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WindowSize", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"250.`", ",", "100.`"}], "}"}]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->20531]
}, Open  ]],

Cell[TextData[{
 "Alternatively, use ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " to directly get the value of the ",
 Cell[BoxData[
  ButtonBox["WindowSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowSize"]], "InlineFormula"],
 " option."
}], "MathCaption",
 CellID->488518183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CurrentValue", "[", 
  RowBox[{
   RowBox[{"InputNotebook", "[", "]"}], ",", "WindowSize"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->436379784],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WindowSize", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"250.`", ",", "100.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->954359254]
}, Open  ]],

Cell[TextData[{
 "This changes the option using ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " with simple assignment."
}], "MathCaption",
 CellID->3619019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CurrentValue", "[", 
   RowBox[{
    RowBox[{"InputNotebook", "[", "]"}], ",", " ", "WindowSize"}], "]"}], "=",
   
  RowBox[{"{", 
   RowBox[{"400", ",", "300"}], "}"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->191037634],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{400, 300},
 ImageMargins->0,
 CellID->859318188]
}, Open  ]],

Cell[TextData[{
 "Within any open notebook, the front end always maintains a ",
 StyleBox["current selection",
  FontSlant->"Italic"],
 ". The selection can consist for example of a region of text within a cell \
or of a complete cell. Usually the selection is indicated on the screen by \
some form of highlighting. The selection can also be between two characters \
of text, or between two cells, in which case it is usually indicated on the \
screen by a vertical or horizontal insertion bar."
}], "Text",
 CellID->7239],

Cell["\<\
You can modify the current selection in an open notebook by issuing commands \
from the kernel.\
\>", "Text",
 CellID->8339],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SelectionMove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionMove"], "[", 
     StyleBox["obj", "TI"], ",", "Next", ",", 
     StyleBox["unit", "TI"], "]"}], Cell["\<\
move the current selection to make it be the next unit of the specified type\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionMove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionMove"], "[", 
     StyleBox["obj", "TI"], ",", "Previous", ",", 
     StyleBox["unit", "TI"], "]"}], Cell[
    "move to the previous unit", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionMove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionMove"], "[", 
     StyleBox["obj", "TI"], ",", "After", ",", 
     StyleBox["unit", "TI"], "]"}], Cell["\<\
move to just after the end of the present unit of the specified type\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionMove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionMove"], "[", 
     StyleBox["obj", "TI"], ",", "Before", ",", 
     StyleBox["unit", "TI"], "]"}], Cell[
    "move to just before the beginning of the present unit", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionMove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionMove"], "[", 
     StyleBox["obj", "TI"], ",", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["unit", "TI"], "]"}], Cell["\<\
extend the current selection to cover the whole unit of the specified type\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20552],

Cell["Moving the current selection in a notebook. ", "Caption",
 CellID->26830],

Cell[BoxData[GridBox[{
   {"Character", Cell["individual character", "TableText"]},
   {"Word", Cell["word or other token", "TableText"]},
   {"Expression", Cell["complete subexpression", "TableText"]},
   {"TextLine", Cell["line of text", "TableText"]},
   {"TextParagraph", Cell["paragraph of text", "TableText"]},
   {"GraphicsContents", Cell["the contents of the graphic", "TableText"]},
   {"Graphics", Cell["graphic", "TableText"]},
   {"CellContents", Cell["the contents of the cell", "TableText"]},
   {"Cell", Cell["complete cell", "TableText"]},
   {"CellGroup", Cell["cell group", "TableText"]},
   {"EvaluationCell", Cell[
    "cell associated with the current evaluation", "TableText"]},
   {"ButtonCell", Cell["\<\
cell associated with any button that initiated the evaluation\
\>", "TableText"]},
   {"GeneratedCell", Cell[
    "cell generated by the current evaluation", "TableText"]},
   {"Notebook", Cell["complete notebook", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20474],

Cell["Units used in specifying selections. ", "Caption",
 CellID->20781],

Cell["Here is a simple notebook. ", "MathCaption",
 CellID->3742],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->1332028623],

Cell[TextData[{
 "This sets ",
 Cell[BoxData["nb"], "InlineFormula"],
 " to be the notebook object corresponding to the current input notebook. "
}], "MathCaption",
 CellID->2900],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"InputNotebook", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29700],

Cell["\<\
This moves the current selection within the notebook to be the next word. \
\>", "MathCaption",
 CellID->24234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->25606],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->282281797]
}, Open  ]],

Cell["This extends the selection to the complete first cell. ", "MathCaption",
 CellID->9790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->6923],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXAdsVD0SfsluevtpCSGUAKJX0YsoPx0Bx9Eh4YAQQHRClTgQAtE5CSEi
RBEcLfRDoogqeu+9twQieu+E5vM3z3beZnezm80mR/7D0nu7bmPP+PPM2LNJ
m5hR/fsOiRk1IDYmsvmImLj+A2JHRjYbNoIXmTw0zTOfpmndIjV8Z/yreKWm
MLw0zaTnqI6/8uDlIUpMqkqT9ek1unfvHq/fuHEjvYLx8qRCExVKOrKjV+rA
PPF27Nq1a5r+Da8A6mtGqaxl27Zt87Q9OD5S+/6RzriWfTz1PjIF4pXerL0t
Zi3nRkxL8fhTB7NiSzRIZ+JpB9SZkcmH8l5pRYXWmluJ4uESdi9RmzP1sStF
S5T62plllrDuVqIGnrJhpr+cPMVm/cUXKWfJ8/d+z/Asvwh6C5ceZ937rqIn
KjaBTf3XHs0vi8Z68/Yze/TkLT33H7xi7aOXWY2VWe3wjb6a2JOn7zg/qyjn
tOycWIzvmaHvmIey9Dazr1+/ssuXL7Pbt2+zHz9++ItR79+/z86fP88+ffqk
BYqmiYmJ7Pjx47Kpj2j6+vVrao6cn2j68uVLdvr0aXbx4kX24cMHs+3BzAYK
J0+eZE+fPtVdEl4GCih7+PChFizKnj17xm7cuMF+/vypRkpJSWGXLl2S5ZLk
mzdv2JkzZ9BFF9U/nBSni1qziCAfFBREZXfu3NF7cW8lTx7y1tjVq1eJzvr1
61loaCiNwKuLFCnCjh49SlWzZ8+mpuPGjZO9Ias6depIL4h5e3uzmTNneolq
yA7FnCBRwEpUr17dRMRNrHTp0uzKlStCWHj7sNGjRxMVdKtWrRqLjo6Wg2pS
flyUbMCAAcxkMmlyouBt4cKFTCYLPrws+OCLy+Li4jSTqGvbti17//491b19
+5Z17txZ1Hmz2rVrs6SkJKp78eIFTaVYsWKegkGMgiLeRZEeOHCgp/DwypQp
w3r06EFNEhISdLH4sy1btrBcuXIpqRUuXJjwTDvr+3c2ePBg8KZTCWZt2rQh
xCEtWbKEugwbNozyLVq0oPyRI0coz6VL+Z07d1K+bdZu1CBBHpsBQ/KHE8bb
xD5+/CgXQ5Pb0RqBwRYIBMB9fHyYr68vmzp1KqGBS4JFRESwL1++GCHoKXiB
yCXX3bp1oyaRkZGU37dvn46ZACsoduzYkfKtW7dm69atY+PHj6d8o0aNBM68
aEsDi3nz5mW7du1CG4E3E9u8ebPiTp9KcaIDGsWLF2fz5s1ja9asYblz5yYO
uPpwyB3ao3/+/PnZtGnTWMOGDSk/ZswYGgiYR75QoUJswoQJrEKFCpTHDkwD
UDEnPyuELlu2jPKYw6BBg1jVqlUVTxyiaXiKYK9evWLBwcHUZ+jQoWzIkCHM
09MTY9A+nDFjBtWVL1+excfHs+bNm1Mec80gYDWnEZsJ8ygRW69ePbn/dMK8
jKPSCcRa6sxJkybR9969e0ulALty+PBh9u7dO1uAvX79OhUBVZ8/f6bhuCGh
Lny+9gC7YsUKNmfOHNIE0KOcItVXqlRJANaX5CIBCEWCVLZsWSrbunWrJA07
CVInTpygSUI+Uh/dvHnTyJPAQagFU1CYqF+0aBEN8fjxY8IgMAYce3npS3Xr
1i2qh2X196djL+k5K0XqYwVTvg0pz7eRmIKJ1KTQpMoUALIoa9q0qZpqnz59
aDpgBbBE/Y4dO4guLDLYOHXqlFPwhKnGdMGCs+h00bGSjoS7kCkNDweIGduS
y2zPnj0KkWPHjpWC5dCgorCwME1vaiL9IkeUi5QWkoDYypUrWeXKlTVp06H3
LPv5kp6QC1qyZEnSOzCsApbSq4JPBrXM4aNJu/3nn38SLQMzmpEbPrRcLwkJ
uQnCw8OVXBo3bkxl0LBOoA/KDfkLFy4o9HXv3t0KfVDiAj3KN/Tz86OyZs2a
iZn6EuocIa1DZpCVdXqP6wme43LjUgwMDFTowhrie61atTxZz549eTXMGIo2
bNigUMYtshTgwYMH1broXUysbt26UvDK6qZFGcaWFgplUVFR7OzZs/pNG+8F
Hbpp0yb4Xdj2silAbQnEAFJeUhHBAMLAAsBSVxqY0mxxJUFM14w6suA4guyD
Bw+oKiAgAMpCVnO8Spgr4HHFL4G3du1aC+Bxa0x57m0o4HXo0MEKePPnz6ey
Xr16iXa5SQ6Yybdv30hOqO/atSvYIJkhD8uN3eguMLp4IHEVjKntQgmEcPhR
DoMEPxDee0hICDlVMEoShQDu6tWr2d27d8kRM5vNtFDPnz+ngbp06SKtjT3z
279/f8pPnDiRJAiPF5LlNlBsfR9y1Bs0aIBzKfWpUaOGWk2dblG2d+9eKoPf
ww+ftFrczrK+ffsSXUcsDR8+nOrRHgkrhnzBggWpf4ECBSgPdpHOnTvHPDw8
yCbDy+Ag1OTBAkYQfeDXCXtPffCJPJAHA4gzGsQlUKizEsaOHTtGRXBHATxM
tVSpUlQGF6NJkyb0HZ4LEnYQ8hARUjog1DKEwmxWiSNHjuQ57qBr+ZU2ARrh
+hQtWpTyOIFItzkmJoYISTTCO8Mn/BkkKX6IWFoenFf5UtlDI/SdbAaTKYda
vny5QiMQIqw6q1mzJqEAp48nT54INIYT3Xz58pHRAp0SJUpQn1atWtE4jlhK
Tk5WyAACMQa+yxPL4sWLBdr8yfLLepwikKRKBF2Iko8hm8vDPMAnHUrsY8mG
AKPObagCG/YKHulrwHE7dOiQGrlcuXL0HfsJ53AHQMw8DrPa6QuzusJ59OgR
nYSxL2F/cLSFKkGCpwOrh/GxSBgXCRZwypQp5C8DlzBIfHGVVwMzh37t2rUT
BseLbBoMDFQOVN+CBQuEUfYm1YZFBj2ACqpy//79shpnIJx+AXdgkzujUMbS
atrhQFYDEji3A/0YGNZQ2dwQsugwpEALTj+TJ09W/ENHwRmEOoeKhAPCrT3t
TS4D5eryubL69evTBPl+N97iaPJ2Cxcc2Lu45cFVFVzmxMREKR64pxAv9h/c
WI42RT6nqr5U2JmMsOOaRC+DD4KDKZRjM1EGXSFFl9dZ/ttRQ7O6mO/WO4F1
6L7c1p28i6EPKYLp06fTFPnDCeOtX9a4KgKDqnaPCGS84NLVRxCDvbBEJu6F
caUATcw3iWJNlmFTSNawiYAODnLFGnwdsMz3n2INVgN9oQSQ4Bwgz30dfc5/
FzwYwy5/6/JvfNoMu7gaM0oRtIwhFzyfPn11e3iH0u/QcdbL83fo+NdYIIpn
Ejl7W9bVVSLKFAJy95zptlXTncd+vWqxlYui6Fm1OJr9cxTdEbk1TvrFMF5I
sC8LDwump3ChXGxjQs+MjZcRHs3CmIeFBnHmouwOlJnfDWRoIBdNVNZEgsNE
U5uRYBPZL7gAKSkpwqHVR0LMFiN52RidOBmWadGnj6lIMXBOD+TqZAPU9Z/o
SwEF5HEPl2ai6jrMOvjraxX8nTt3Lh3w0JfLziy4wB2dvJPBg2NlfHy8vECz
IwOiiPMPynDWsZWfNWsW5WNjYynfO6N743fwVXMt+GpyGUtBDgO2SJI9SCMp
KUnMrwBOwlSO2yycnOU9MZSEA7H80mj6fwyMuq6PAh0GU5EqVqxI+eTkZH1G
EcQg7qHwIMaOhAsJKCDcZzgQhkMI4VyGMxcv1zKGoV8ouJ7DQpjOA4jPXJ20
rcOe3irsaRM8JrJUYrGVM2ItAV+SgCOg9HMWF9l8w/mXCDxm1DjxWSuophOs
VM6QARsqNijv1AMCAjSpeRFlAj1M2SAOXRr+RmlkA15+xwdtxAf1NuFOI8U4
ZUcxxTRaRJMxE0RsULZ7925qFxcXR/kRI0Y4EoN7YZLNYeS/TAAvgrxL2bdK
lSr0gwJ7kDFO21Hgr1OnTko0iKUcOHBAjBmq6MuzgfwOD8iBOHK0dsmhMTcv
ARXAQTqmiJbiEAVyGAIObHpTtROvozrQlRHXli1bAgaCBS/6tSncJEAPcObe
m2Al2B77NmGRU5yWjMTHwgWF9u3bS5+QHDv4g2jD10YLEf2M2ltGWdKRkZYq
JPlDOnnbuXpJNPvPyh5ZtaeyMpomBbZ9+3b1KzuOf6O+UwJbunQp3d1wp8dF
gcnr2gplw0lo6dkuFwRWREzUldgbTZ9vePgROGLiNzrw7lDPd2UpUQ0S8miJ
ZMz3EzLBdIwX4ZvXxtBnevBw9Vr/s2AFhUK6vDHe+NWkGkdz51+NUQTQbpAi
h8f7LPk3OFKp/FPKuX8lm73xPtvydHskTSzQ/2KWOfzPRLNk1S3/Yt8oT71Q
c/kv9lP/2UEgDWty9m7NlX9U4Fofmf6gvCU2Hf2bh9x46d6cgZL4vxGax38B
lxBt7A==\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->1665559259]
}, Open  ]],

Cell["This puts the selection at the end of the whole notebook. ", \
"MathCaption",
 CellID->8168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "After", ",", "Notebook"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->485],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->1977935602]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NotebookFind",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookFind"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], "]"}], Cell["\<\
move the current selection to the next occurrence of the specified data in a \
notebook\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookFind",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookFind"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], ",", "Previous", "]"}], Cell[
    "move to the previous occurrence", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookFind",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookFind"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], ",", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], "]"}], Cell[
    "make the current selection cover all occurrences", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookFind",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookFind"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], ",", 
     StyleBox["dir", "TI"], ",", 
     StyleBox["elems", "TI"], "]"}], Cell[TextData[{
     "search in the specified elements of each cell, going in direction ",
     Cell[BoxData[
      StyleBox["dir", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookFind",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookFind"], "[", 
     StyleBox["obj", "TI"], ",", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", ",", 
     ButtonBox["IgnoreCase",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IgnoreCase"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
do not distinguish upper\[Hyphen] and lower\[Hyphen]case letters in text\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25455],

Cell["Searching the contents of a notebook. ", "Caption",
 CellID->7544],

Cell[TextData[{
 "This moves the current selection to the position of the previous occurrence \
of the word ",
 Cell[BoxData["cell"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookFind", "[", 
  RowBox[{"nb", ",", "\"\<cell\>\"", ",", "Previous"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->30708],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->20800]
}, Open  ]],

Cell[TextData[{
 "The letter ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " does not appear in the current notebook, so ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " is returned, and the selection is not moved. "
}], "MathCaption",
 CellID->25219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookFind", "[", 
  RowBox[{"nb", ",", "\"\<\[Alpha]\>\"", ",", "Next"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->30518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->16349],

Cell["$Failed", "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->28947]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"CellContents", Cell["contents of each cell", "TableText"]},
   {"CellStyle", Cell["the name of the style for each cell", "TableText"]},
   {
    ButtonBox["CellLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellLabel"], Cell[
    "the label for each cell", "TableText"]},
   {
    ButtonBox["CellTags",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CellTags"], Cell[
    "tags associated with each cell", "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["elem", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["elem", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "several kinds of elements", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7580],

Cell[TextData[{
 "Possible elements of cells to be searched by ",
 StyleBox["NotebookFind", "MR"],
 ". "
}], "Caption",
 CellID->29299],

Cell[TextData[{
 "In setting up large notebooks, it is often convenient to insert tags which \
are not usually displayed, but which mark particular cells in such a way that \
they can be found using ",
 Cell[BoxData[
  ButtonBox["NotebookFind",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookFind"]], "InlineFormula"],
 ". You can set up tags for cells either interactively in the front end, or \
by explicitly setting the ",
 Cell[BoxData[
  ButtonBox["CellTags",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellTags"]], "InlineFormula"],
 " option for a cell. "
}], "Text",
 CellID->21448],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NotebookLocate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookLocate"], "[", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", "]"}], Cell["\<\
locate and select cells with the specified tag in the current notebook\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookLocate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookLocate"], "[", "{", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", "}", "]"}], Cell[
    "open another notebook if necessary", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->684],

Cell["Globally locating cells in notebooks. ", "Caption",
 CellID->26119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NotebookLocate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookLocate"]], "InlineFormula"],
 " is typically the underlying function that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " calls when you follow a hyperlink in a notebook. The ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Hyperlink"], "MenuName"],
 StyleBox[ButtonBox[" \[FilledRightTriangle] ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Hyperlink"], "MenuNameDelimiter"],
 StyleBox[ButtonBox["Hyperlink",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Hyperlink"], "MenuName"],
 " menu item sets up the appropriate ",
 Cell[BoxData[
  ButtonBox["NotebookLocate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookLocate"]], "InlineFormula"],
 " as part of the script for a particular hyperlink button."
}], "Text",
 CellID->29132],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NotebookWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookWrite"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "write ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " into a notebook at the current selection"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookApply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookApply"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "write ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " into a notebook, inserting the current selection in place of the first \
",
     Cell[BoxData["\[SelectionPlaceholder]"], "InlineFormula"],
     " that appears in ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookDelete",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookDelete"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "delete whatever is currently selected in a notebook", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookRead"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell["\<\
get the expression that corresponds to the current selection in a notebook\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23340],

Cell["Writing and reading in notebooks. ", "Caption",
 CellID->11888],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " is similar to a ",
 StyleBox["Paste", "SR"],
 " operation in the front end: it replaces the current selection in your \
notebook by ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". If the current selection is a cell ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " ",
 "will replace the cell with ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". If the current selection lies between two cells, however, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " will create an appropriate new cell or cells. "
}], "Text",
 CellID->9770],

Cell["Here is a notebook with a word of text selected. ", "MathCaption",
 CellID->19297],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->21433],

Cell["This replaces the selected word by new text. ", "MathCaption",
 CellID->15140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", "\"\<<<inserted text>>\>\""}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->2622],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->356012326]
}, Open  ]],

Cell["\<\
This moves the current selection to just after the first cell in the \
notebook. \
\>", "MathCaption",
 CellID->5540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "After", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->20727],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 89},
 ImageMargins->0,
 CellID->1564338623]
}, Open  ]],

Cell["\<\
This now inserts a text cell after the first cell in the notebook. \
\>", "MathCaption",
 CellID->21082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\<This cell contains text.\>\"", ",", "\"\<Text\>\""}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->29247],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->2005337537]
}, Open  ]],

Cell["\<\
This makes the current selection be the next cell in the notebook. \
\>", "MathCaption",
 CellID->20050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->17730],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->1382398134]
}, Open  ]],

Cell["\<\
This reads the current selection, returning it as an expression in the \
kernel. \
\>", "MathCaption",
 CellID->28304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->16331],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->18805],

Cell[BoxData[
 RowBox[{"Cell", "[", 
  RowBox[{"\<\"Here is a second one.\"\>", ",", "\<\"Section\"\>"}], 
  "]"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->28051]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
 " just discards the current selection and replaces it with ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". But particularly if you are setting up palettes, it is often convenient \
first to modify ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " by inserting the current selection somewhere inside it. You can do this \
using ",
 StyleBox["selection placeholders",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  ButtonBox["NotebookApply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookApply"]], "InlineFormula"],
 ". The first time the character \"\[SelectionPlaceholder]\", entered as ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", "SelectionPlaceholder", "]"}]}]], "InlineFormula"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]spl\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", appears anywhere in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NotebookApply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookApply"]], "InlineFormula"],
 " will replace this character by the current selection."
}], "Text",
 CellID->13139],

Cell["\<\
Here is a simple notebook with the current selection being the contents of a \
cell. \
\>", "MathCaption",
 CellID->6767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"InputNotebook", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->24370],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 67},
 ImageMargins->0,
 CellID->1888674931]
}, Open  ]],

Cell["\<\
This replaces the current selection by a string that contains a copy of its \
previous form. \
\>", "MathCaption",
 CellID->10143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookApply", "[", 
  RowBox[{"nb", ",", "\"\<x + 1/\[SelectionPlaceholder]\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->30556],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 67},
 ImageMargins->0,
 CellID->1200720930]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SelectionEvaluate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionEvaluate"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "evaluate the current selection in place", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionCreateCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionCreateCell"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "create a new cell containing just the current selection", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionEvaluateCreateCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionEvaluateCreateCell"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell["\<\
evaluate the current selection and create a new cell for the result\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionAnimate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionAnimate"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "animate graphics in the current selection", "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionAnimate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionAnimate"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "animate graphics for ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " seconds"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27116],

Cell["Operations on the current selection. ", "Caption",
 CellID->11957],

Cell["\<\
This makes the current selection be the whole contents of the cell. \
\>", "MathCaption",
 CellID->28286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellContents"}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->27366],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 67},
 ImageMargins->0,
 CellID->1483973693]
}, Open  ]],

Cell["This evaluates the current selection in place. ", "MathCaption",
 CellID->10843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluate", "[", "nb", "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->30672],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 67},
 ImageMargins->0,
 CellID->464989744]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectionEvaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluate"]], "InlineFormula"],
 " allows you to take material from a notebook and send it through the kernel \
for evaluation. On its own, however, ",
 Cell[BoxData[
  ButtonBox["SelectionEvaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluate"]], "InlineFormula"],
 " always overwrites the material you took. But by using functions like ",
 Cell[BoxData[
  ButtonBox["SelectionCreateCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionCreateCell"]], "InlineFormula"],
 " you can maintain a record of the sequence of forms that are generated\
\[LongDash]just like in a standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->21298],

Cell["This makes the current selection be the whole cell. ", "MathCaption",
 CellID->11471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->8937],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 67},
 ImageMargins->0,
 CellID->462895633]
}, Open  ]],

Cell["\<\
This creates a new cell, and copies the current selection into it. \
\>", "MathCaption",
 CellID->12809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionCreateCell", "[", "nb", "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->20920],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 123},
 ImageMargins->0,
 CellID->2128825919]
}, Open  ]],

Cell[TextData[{
 "This wraps ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " around the contents of the current cell. "
}], "MathCaption",
 CellID->17327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookApply", "[", 
  RowBox[{"nb", ",", "\"\<Factor[\[SelectionPlaceholder]]\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->28441],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 123},
 ImageMargins->0,
 CellID->188538220]
}, Open  ]],

Cell["\<\
This evaluates the contents of the current cell, and creates a new cell to \
give the result. \
\>", "MathCaption",
 CellID->3323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluateCreateCell", "[", "nb", "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->32528],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXQlsFccZXvvZj2IbMBgIV4IhgEIggDgKpVCgIaHCAcTZFFyQa06FG8RV
CFcQ4hLFnEakMXfJpTRRIkUCkhLAJUDBIG4I9xEggLkMJOTvfv/OPK/tfft2
9+3aJvFKb/32mH/+a2b+/5uZ5y4p44cOGpEyflhqSmKnsSmjhw5LHZf4+qix
6i1fhKJEVlIUJSNRwXdSv4pT7vEcTori0674mXpKwClC3PEFHinyudlL3333
nfr8o48+4lNZnCL5po9vSjqyYHRuxeqhvkdHjx5VtG84xXLZKNyVT+nzzz+P
NK4cf3LLxpvUm7dMpFZGHnE4mXHtz8O15I2FluqJ4QJRAbHECyaM569QE0Ye
pfg6Or+q8LbiKlF8VA27S9SQ01JBtZjXS38ThEtPRHeVqE6mQuC02OlTNNZi
bqRnS58l7b3IXakfn3304MEDOnDgAF89L+6dOHGCbty4kVv5JFFv+nuZlDxo
I3/6pm6gOQu2KrH5eAraXZhrLlnUPXnyZBo3blweftauXUtJSUkF+bmTnUNX
rmXz5/yFW9SjX0YBfhy2DKmfixcvUqVKlej69evKC+LeTz/9RC+99BJt27ZN
K/x38eDa93dVvWzkqxj3bNVXkH/nnXcoOVlqCmc/9e/fX47s/ImJiaFr1675
xUtt27bFJV/xOK6Kvf/IPfI32UlRjb+hnf/Lppjmu0hp+A29veycWr1Wbs6c
OdSnT59clU+xKKLD7lKK2LVrV0pLS8sj4pkzZ+izzz6juLg46tevH23fvp1+
/vlnKWKFChXYSnoRcx49pZkrzlO0KubuA9lUoXUmdR1+hM5dzgmIqFqPatWq
ZV/EMK1YvXp12rVrlyCcK8Ps2bN196Jp5MiR1LlzZ4qOjqYOHTrguxazqVJO
+cdZ8jX6htr2z4KsPkHm7t27FBERQT/88IMLIllrIC+//DJ98sknIcVZt24d
zZ8/n0qXLk1TpkzB98Az1ZrUc/RRim2xi/4wIIseP3mqSJnOnz/PKnj06FGh
mgmeNnHixKBylTJxv0vXHlHvsce4VW3fc5sSfp9JfxpymI6eeRBwvw8++ICa
NGmi8/QoOn36NDVq1IjlnTdvHvM6zqK4DsdVKe6KFSuoVatWIcUdNWoU3bp1
K4+4/826S/W77KN6SXvpP3vvULM+B/j7v7ffDIg7ZswYGjp0qOBDq2Xv3r30
5ptvUvfu3Sk2NpaWLVum2JLZ4bAvZc7JyeHWuGfPnoAJ8N4rr7xCUVFRNGvW
rOfEq3fu3OFhQLWQeDWaa2/RogXt27ePatSoQYcOHbLHvoMAQ3b+q1evZrXl
eo+Pvv32W+63d+7cqUi+Z86cSSNGjNCZy0czZsygRYsWUWJiolbJeBvqduBi
swR5tQVT06ZNC63e2Tq9vP/++3xl2T7hZj2Pw5HNQpD5xFvd2ZLB4Zgvw6m5
c+dSp06d8FHe47NPxgC5vPzWW3klL7t376bNmzfjo/KCs4+7Kfd4eQZtWxht
wGn2FpYc5rboJUg/ffqULly4kFvnem/tU5PPtkJ7v6gdo7N83e/308mTJy2F
/UY0ZXAGtdSsWZNp1qlThxuFFZpxNvn0OaTplBcr5dhW7QrH3DbSHGkaJO9q
YkpffPEFk/v000/FM/MUKDhNP40ePZoaNmzIcfegQYPY9CobPgtk42yyaiVb
M6LpZTnLFreIc+jGR+5Uauv4spLxyaDtypUrssWoV9oZgY04xHsFMkMz0tLi
sPZbb73FdJCVoJrjx49HG1OMdYFZn33SQTJfB0WYhfbetulaJlY2SoSlZz55
8gThMa1atQphPNNbvnw50DjTZNkKbYTfoIeMB+Ew+kJ8V+mJd4xpx4bJtxlt
mbpgiEXvEEpPZjow49MK0PDw4UMAJ3zFBm5d+D5iBCpI3tGDAHVEdaCBOUbZ
2ZsBDmYDCFJa2C0yMpIqV65M69evF/aKM6MZ6CYwdqPJqWmmXda1asqYVoMD
nWf58uWpdu3ajJfcvn3bUCTr2EsBnCU4udDsoVsDdoFhEmCA2vVpnvE7i97j
MHky8x49RiM7wd69e3MnKdQvHccMuvEbkJODAiKDBg0a0KVLlzC0RwufMSHH
bXzgwIH0xhtv8AxDVlaWDYalPcxqwPHjjz9KUvTqq69Senq6oSBW6RlhVMHp
WcHColgTOEATmL7eXU6c+p56JGfQrdsPnOaUunSHx95EUW0+aKu8uH358mX2
IqHoaqLS+/fv84hav359Gj9+PIf9ZQSTuG7ZsiUsr8QbkykrXoUJ4SjHjh1T
KgnSRsCZfAagbcKECTznA3Qe1bJUrQTBrMOXqXvf96hX/3VuzfXItqQH0CqI
e2qcymCZqg6lhhAV3RlAtOnTp2MuSJoJZhUDCIuckZGhlDcgI1Xz9ddfc7eB
3rCyuKfH5ioLukeOHKFy5crxYPbxxx+jSk2OloIfqAQ+89WO0+hqLGsldC/z
N0Hq1KlTVLVqVZ6ZQ36SmZkp3Cqax340VrCOZ4cPHw6Io4f89OJgbMZMFj5q
nqOHVaID4uCv6D2tWzq0TKk6ayNOUP8GonLMhC5evBgwkFJF956ED6WXIpvZ
sGFD4KMmSxpfLfgFfx4ZcAg5LE+WWkQ/7gseL1y6TUvTd9LCtK/Ul5MHbVTv
df3zP3miluyELRbQqRxBSz/5is/Dh0/cNBMFjpJVGYWjz5JVGcXYlRzCDZ6I
ns5nA2C0r6jDyjqRMOofzGfXAFIrwGNxAEg9BzrLicqtLqtx2AlL87kEeFpB
9YoJ4GkFmw0LuJRRqwszU/mziGE6vtwELoNggcUTuAyCsjpFIRPCMVfohtZZ
kMciAETnyF2rm5jRC4SvOCOTZqigXLeiRyb9JvWZ0YoRLgDbwA74XL16le0n
19p47AI+n49XM6WlpRm6gDP0zgvgMTTkZgA+mtYVHDg1BzkNkMfgi77MSeHI
BzrKrgTSTJs2jUmKhbjhOYV5LJykcwgsF8SVmUNYhuZcxhJDI3MGeKJhNaYI
qDlkaQAmBl8HZ07KAEeUzNatWzewBJurkqNRIfQJ0gWqCkGsYYRVBTNGGKFE
t/QYYTljMnYxwrAV5jDLNVJYNXEvFGZYXYieDzOUQ5cRZhhvQMYqZijdMyyf
chDTG6koWZA3Ag9rimdWwcOw5XIAGxh1lX/VmV2ChxI+DgUeFlV7ryvI37x5
kx4/fiwIa/dwnZ2dLZxUuweb5L+HsEbekxmKXi8bi0g2CcmvXLmSV77jvhrn
aElFWe7A27Rpw48QLvTq1Yv/Dh7MSSjSakpNTaX4+HgORZBRfPjhh1rwV46W
Ll3KwzWovvjii+i0uRikxiQFWiJ6SqxeRCaLY//+/ahCE0TlFmQxxmtqwDlW
rzmtjE3kYVk42g4Dc5baBh+I3pDjnD17Vmr7yy+/5FeXLFnCyX3Pnj1ZfIzO
ONCYy5QpQ++++y7t2LGDM+9u3bpp2k5g7ARjj2oAGjt2LA0ZMoSLDR8+nMmq
4xFt3bqVmjdvTqVKleKACku4QQ7PQQ5l1WFZ+G1BTdsFCcLStMMQ7QWhZcSc
cM5z585hOixS1KGGoaxF7IiCY2EOBVrGgV1bIDtgwAApDaJruaFK+l+9evV4
zJYHRhoUgyZxQHpcqz1XQCv61u4gZ5dk9It95xgs9pWrMQq7I3lep3QkJ2ju
6oCssVOawxBE6dif1KxZM+5EcNy7d487F/W+SBn92E7A78oD5CZPnixdsnHj
xlStWrXALDBmOsHFpk2b8ih/6tSphsqXuyfsZtuSln6J8xyDJc5hW8AhLKhZ
II4tgG5A7Rn4L/QhOj7eRQK5wG/79u2pXbt2mjpqUI8ePbgvxiaTBQsWUMWK
FdmISLTxF00EgXeVKlU4DZPqX7hwIbPQpUsXTn4QqaDNYLTEgawZzxMSEhil
hAeobATryu0mxN50MPa0jU4Gjoz6gakjt8GxZs0aDkqBq7du3Vr7zQKtGKbp
U1JSWCsQB9rr2LEjx2wwEIpg4EVct3z5cq1YWVY6egDM7KMPQ+9w8OBBrg1F
0bVjGMD+OIwemPZWO69gyrabcRZFby43sW7ZsoXDDFVbanE1pRGOgISAONrQ
3sO4KhaFKBXFveIQaTWT5NWmCFN5xp+LSZorunIpG/oLn4NOWr3uidrsJziS
zSCTM2Gz6SJmIXeg6mGrTqH4c7S+yh5/SCLUwcuQv9f4HEWTJk3iUQhxhET9
JItmK5wcTgOzpSMZNfBx3CwOYW5jHoHHgQg+osWTjPy8W3L0LwOOuFCSqMPj
5UGbhIT5kDAdC5ZX94QRDG0WWtDDS1xIOppHK37yz/rxzWKz4qdkhcqzuELl
17OC6he7Ik3bt2+w4mehoO/xih8t+CzZEun2ip8/isrtrPgJw3wlWxxdX/Hz
mijsUSbTQsdbyXZFd1b9yBzKg4xO/jJByb7Dwtt3aMumDsc/o2ZYslewKPYK
cj3tis7aJXv7vN3bZ9m+Dn/nsLngsFhvxgvfyc2VIB28mG24Y0LtwxE7dNue
IEi5saPOFr8O89OJOlPZ3S0Xvht58ENDjqZv7KeKTGy/t7LXELzZzYNs8eYw
5ZOLGDxYIsDnNjZU63gy2rtJdlsyOEgEpNvaDfYK023txieFwRu/YKU7+ZX/
PqD2041BATkuP90iCw5HJslCEFDJFgthDeYGc1UzxAMXfs0hv3UnBqtTyuro
BxLCkPVt/mppStDhWBK06mmiDjtTgo49zXhKcJrwQptTgjaNLjVQYDpwqnjg
2nSgxe7roaBXZFOCxWk/dHAufwGzTRbmh93QpzBQUXD5jM8se2L1vP8cSK9P
7abi+J8D5f5fpTiu1mc1lNJqwcn6/0RyVkYeciOO3jcLllGkQvjEmIuGHeoo
iX9RpUT8H4e8+Q0=\
\>"], "Picture",
 ImageSize->{533, 160},
 ImageMargins->0,
 CellID->1009958667]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SelectionEvaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluate"]], "InlineFormula"],
 " by default leave the current selection just after whatever material they \
insert into your notebook. You can then always move the selection by \
explicitly using ",
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 ". But functions like ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SelectionEvaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluate"]], "InlineFormula"],
 " can also take an additional argument which specifies where the current \
selection should be left after they do their work. "
}], "Text",
 CellID->24597],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NotebookWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookWrite"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], ",", 
     StyleBox["sel", "TI"], "]"}], Cell[TextData[{
     "write ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " into a notebook, leaving the current selection as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookApply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookApply"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["data", "TI"], ",", 
     StyleBox["sel", "TI"], "]"}], Cell[TextData[{
     "write ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " replacing ",
     Cell[BoxData["\[SelectionPlaceholder]"], "InlineFormula"],
     " by the previous current selection, then leaving the current selection \
as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionEvaluate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionEvaluate"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["sel", "TI"], "]"}], Cell[TextData[{
     "evaluate the current selection, making the new current selection be as \
specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionCreateCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionCreateCell"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["sel", "TI"], "]"}], Cell[TextData[{
     "create a new cell containing just the current selection, and make the \
new current selection be as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SelectionEvaluateCreateCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SelectionEvaluateCreateCell"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["sel", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "evaluate the current selection, make a new cell for the result, and \
make the new current selection be as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7099],

Cell["\<\
Performing operations and specifying what the new current selection should \
be.\
\>", "Caption",
 CellID->1881],

Cell[BoxData[GridBox[{
   {"After", Cell[
    "immediately after whatever material is inserted (default)", 
     "TableText"]},
   {"Before", Cell[
    "immediately before whatever material is inserted", "TableText"]},
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the inserted material itself", "TableText"]},
   {"Placeholder", Cell[TextData[{
     "the first ",
     Cell[BoxData["\[SelectionPlaceholder]"], "InlineFormula"],
     " in the inserted material"
    }], "TableText"]},
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "leave the current selection unchanged", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21823],

Cell["Specifications for the new current selection. ", "Caption",
 CellID->13310],

Cell["Here is a blank notebook. ", "MathCaption",
 CellID->3671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"InputNotebook", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->27578],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV11uwjAMdhM6ECBUbZr22lvsBuOJQ1RoEjxMoI5r9bFX6WOvUmInJg0q
HararqBawiR2/Jt8qryJTrvvn+i030bhOo6Ou/32N/w6xEokPQDxDgCfIeC6
UEvDLH0gA5B6RzrF3pB5RiIvKmB93aE8z5U+SRJiK2SChJKE7IcNfRtYkTpX
ZFkGeoVsQbYTlLK2SNNUVAfHP2sb1MR1bYS2YVoiq8v6xcmac6OiuT1zMphc
yjIHahK/DqiLYZrS3r9uFZ6GVp3iT3W4XaeVmU5vdtF9pbMbWXZSeqtOSzX1
kOng+mnAOvBLeqx+jngf8FMa8T7ifcT7YPvZH97d0kvYeJrS+8V7dT9bf0rm
gv4jywfHeie37o5Z5X5qITQes+yEuqSw8t5Pd5PpspkNU0B7923+NZu/IhNa
Zz2ZYR+8M3fJU7A=\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->23993]
}, Open  ]],

Cell[TextData[{
 "This writes ",
 Cell[BoxData[
  RowBox[{"10", "!"}]], "InlineFormula"],
 " into the notebook, making the current selection be what was written. "
}], "MathCaption",
 CellID->15090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", "\"\<10!\>\"", ",", "All"}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->21653],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWE1IW0EQXvOeseRHJKUWkhakdw966dlLe2qxUigYCQQR9VBajBfBgyg5
SHNKT16qlooeFA+ip2qgJLFIPZSKUhOFSlOTg5r0x6Ko0915u0meJukjPm3q
ws57M7Mz++282Z3HPnB3d7Q9dXd3trpr7ne5n3d0tnpq7j3roiKpjBDDDULI
3RrC3oG+cpJpNxkhRFI41FFynZEyLpHSKiL0hQZtbm5S/dTUFJJKRgwolFAo
/AjD8szEtNFxsLq6SpQ3RsxoKzOp0MLs7Kwh9+TskbGtKjCv2sag2IhmYaQQ
aqMKtcCGixbhMaGBnF4WH1AA+OkJlcWIVoF8+elQsdFEV6es0wjr6zQn0oq8
UVRn6bU8KC9k6bo6zVrTJSAtuXjyzVriH+n/imdJ7fcf3N/Q8CK0tI1hb259
A94Xb0ml1gVoCPNP7iuZ+g3f4insX7Z2ock5knOeIqN/B6kEx8fHsLGxAQcH
Bwo6KkskEiKKyjyLXBFPfKdrHkPOqh8WO1ILuFwuUX6wm0wmiMfjaL+8vAx2
ux3lZrMZJicnyzmqUCiEYr/fr0B5rwHuOY4rO3fIwjYzMwMWiwWcTicsLCzA
yckJ2tfV1UF1dTWMjo5CbW0tWK1WSKVSSpGk/nZ2dqC9vR1WVla0Yy5y995G
pRlsNhsMDAyITwuRSARtent7kZ+enkZ+YmKCiNh6PB6WGpeWCrfyYJ2fnxfY
kI9Go8gPDg6msTocDtje3j6L9XMkAU0tI7C79ysn1iLP7nxYA4EAjhkfH0d+
fX0deZ/Pl8bKUnttbS2DNcwVHz/F4FHzMDx2vdZzu+fDGovFQJIk6OnpQV7Y
zM3NpXOVfX8mC4fD2VhlxMriGngXZbmgGW7hdHVw74xnW0eWZejv75e4976+
PjAajVBfX4+7qrGxMR3VZDIJDQ0NsLS0pPgOcSOBlD155uoZXQefn84LXq8X
gsEgj56MJwSLLjsJjo6O0NcH1BlVsFjj0DSXE42lK8XhbX3dg5dDQfD5A3Qw
LWBU9vDJKyxlUGAfn7dkZpcy1vf3D3Utmdiu4J+zeulZJ9WVWfrl/jnnjqfu
qcQ/0L9AWXJ/zXmdXhjSM07VFxjZ8VSEpOgLjMzdjwWnlbT+VRZzb1OcjWhV
yKtz82+3XjZGDIou44lfo5GyP/fGeW8=\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->466336708]
}, Open  ]],

Cell["\<\
This evaluates the current selection, creating a new cell for the result, and \
making the current selection be the whole of the result.\
\>", "MathCaption",
 CellID->6266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluateCreateCell", "[", 
  RowBox[{"nb", ",", "All"}], "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->24247],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 81},
 ImageMargins->0,
 CellID->518571646]
}, Open  ]],

Cell[TextData[{
 "This wraps ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " around the current selection. "
}], "MathCaption",
 CellID->27422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookApply", "[", 
  RowBox[{
  "nb", ",", "\"\<FactorInteger[\[SelectionPlaceholder]]\>\"", ",", "All"}], 
  "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->10745],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 81},
 CellID->1156417942]
}, Open  ]],

Cell["\<\
This evaluates the current selection, leaving the selection just before the \
result. \
\>", "MathCaption",
 CellID->23488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluate", "[", 
  RowBox[{"nb", ",", "Before"}], "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->3022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 81},
 ImageMargins->0,
 CellID->32116123]
}, Open  ]],

Cell["\<\
This now inserts additional text at the position of the current selection. \
\>", "MathCaption",
 CellID->17519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", "\"\<a = \>\""}], "]"}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->24083],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 81},
 ImageMargins->0,
 CellID->1470229469]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[
    "find the value of an option for a complete notebook", "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     ButtonBox["NotebookSelection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookSelection"], "[", 
     StyleBox["obj", "TI"], "]", ",", 
     StyleBox["option", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["find the value for the current selection", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     StyleBox["obj", "TI"], ",", 
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"], "]"}], Cell[
    "set the value of an option for a complete notebook", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     ButtonBox["NotebookSelection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookSelection"], "[", 
     StyleBox["obj", "TI"], "]", ",", 
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["set the value for the current selection", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20805],

Cell["\<\
Finding and setting options for whole notebooks and for the current \
selection. \
\>", "Caption",
 CellID->2794],

Cell["Make the current selection be a complete cell. ", "MathCaption",
 CellID->7646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[32]:= ",
 CellID->8324],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 81},
 ImageMargins->0,
 CellID->1013880388]
}, Open  ]],

Cell["Put a frame around the cell that is the current selection. ", \
"MathCaption",
 CellID->31089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"CellFrame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[33]:= ",
 CellID->27098],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 99},
 ImageMargins->0,
 CellID->1353228441]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CreateDocument",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CreateDocument",
      ButtonNote->
       "ObsLink: NotebookCreate -> CreateDocument (CreatePalette)"], "[", 
     "]"}], Cell["create a new notebook", "TableText"]},
   {
    RowBox[{
     ButtonBox["CreateDocument",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CreateDocument",
      ButtonNote->
       "ObsLink: NotebookCreate -> CreateDocument (CreatePalette)"], "[", 
     StyleBox["options", "TI"], "]"}], Cell[
    "create a notebook with specified options", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookOpen",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookOpen"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "open an existing notebook", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookOpen",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookOpen"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     StyleBox["options", "TI"], "]"}], Cell[
    "open a notebook with specified notebook options", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetSelectedNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetSelectedNotebook"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "make the specified notebook the selected one", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookPrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookPrint"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "send a notebook to your printer", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookPrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookPrint"], "[", 
     StyleBox["obj", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "send a PostScript version of a notebook to a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookPrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookPrint"], "[", 
     StyleBox["obj", "TI"], ",", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}], Cell["\<\
send a PostScript version of a notebook to an external command\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookSave",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookSave"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell[
    "save the current version of a notebook in a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookSave",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookSave"], "[", 
     StyleBox["obj", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "save the notebook in a file with the specified name", "TableText"]},
   {
    RowBox[{
     ButtonBox["NotebookClose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookClose"], "[", 
     StyleBox["obj", "TI"], "]"}], Cell["close a notebook", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12066],

Cell["Operations on whole notebooks. ", "Caption",
 CellID->6460],

Cell[TextData[{
 "If you call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument",
    ButtonNote->"ObsLink: NotebookCreate -> CreateDocument (CreatePalette)"], 
   "[", "]"}]], "InlineFormula"],
 " a new empty notebook will appear on your screen."
}], "Text",
 CellID->20391],

Cell[TextData[{
 "By executing commands like ",
 Cell[BoxData[
  ButtonBox["SetSelectedNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetSelectedNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 ", you tell the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end to change the windows you see. Sometimes you may want to \
manipulate a notebook without ever having it displayed on the screen. You can \
do this by using the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Visible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Visible"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["NotebookOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookOpen"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["CreateDocument",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDocument",
   ButtonNote->"ObsLink: NotebookCreate -> CreateDocument (CreatePalette)"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellID->30573],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->42746463],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Notebooks from the Kernel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NotebooksAsMathematicaExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingTheFrontEndFromTheKernel"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 5.8202310}", "context" -> "", 
    "keywords" -> {
     "AbsoluteOptions", "animate selection", "black square", "blank notebook",
       "blanks", "ButtonCell", "ButtonNotebook", "buttons", "CellContents", 
      "CellGroup", "CellLabel", "CellStyle", "CellTags", "character", 
      "close notebook", "create notebook", "current selection", 
      "empty notebook", "evaluate selection", "EvaluationCell", 
      "EvaluationNotebook", "exchanging", "exit notebook", "expression", 
      "extend selection", "find", "focus notebook", "fresh notebook", 
      "FrontEndObject", "GeneratedCell", "go to", "goto", "graphics", 
      "Hardcopy", "highlighted notebook", "highlighting", "hyperlinks", 
      "InputNotebook", "insertion bar", "invisible notebooks", "jump", 
      "keyboard notebook", "keywords", "laser printer", "location", 
      "move selection", "new notebook", "NotebookApply", "NotebookClose", 
      "NotebookCreate", "NotebookDelete", "NotebookFind", "NotebookGet", 
      "NotebookLocate", "NotebookObject", "NotebookOpen", "NotebookPrint", 
      "NotebookPut", "NotebookRead", "notebooks", "NotebookSave", 
      "NotebookSelection", "NotebookWrite", "objects", "open notebook", 
      "options", "palette notebook", "paper copy", "pasting", "print", 
      "reading files", "save notebook", "scroll notebook", "search", "seek", 
      "selected notebook", "SelectedNotebook", "selection", 
      "SelectionAnimate", "SelectionCreateCell", "SelectionEvaluate", 
      "SelectionEvaluateCreateCell", "SelectionMove", "SetOptions", 
      "SetSelectedNotebook", "shut notebook", "square", "start notebook", 
      "store notebook", "Target notebook", "TextLine", "TextParagraph", 
      "units", "word", "writing"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "If you want to do simple operations on Mathematica notebooks, then you \
will usually find it convenient just to use the interactive capabilities of \
the standard Mathematica front end. But if you want to do more complicated \
and systematic operations, then you will often find it better to use the \
kernel. Functions that give the notebook objects corresponding to particular \
notebooks. Within the Mathematica kernel, notebooks that you have open in the \
front end are referred to by notebook objects of the form \
NotebookObject[fe,id]. The first argument of NotebookObject specifies the \
FrontEndObject for the front end in which the notebook resides, while the \
second argument gives a unique serial number for the notebook. ", 
    "synonyms" -> {"2.11.3"}, "title" -> 
    "Manipulating Notebooks from the Kernel", "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingNotebooksFromTheKernel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.3"->{
  Cell[5921, 125, 102, 2, 70, "Title",
   CellTags->{"S2.11.3", "3.1"},
   CellID->29688]},
 "3.1"->{
  Cell[5921, 125, 102, 2, 70, "Title",
   CellTags->{"S2.11.3", "3.1"},
   CellID->29688]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.3", 206887, 4523},
 {"3.1", 206989, 4527}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5296, 98, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5921, 125, 102, 2, 70, "Title",
 CellTags->{"S2.11.3", "3.1"},
 CellID->29688],
Cell[6026, 129, 440, 11, 70, "Text",
 CellID->19724],
Cell[6469, 142, 1499, 42, 70, "DefinitionBox",
 CellID->26634],
Cell[7971, 186, 125, 4, 70, "Caption",
 CellID->25233],
Cell[8099, 192, 850, 27, 70, "Text",
 CellID->5603],
Cell[8952, 221, 154, 6, 70, "MathCaption",
 CellID->17125],
Cell[9109, 229, 4474, 76, 70, "Picture",
 CellID->1086609923],
Cell[13586, 307, 110, 3, 70, "MathCaption",
 CellID->12782],
Cell[CellGroupData[{
Cell[13721, 314, 119, 3, 28, "Input",
 CellID->20760],
Cell[13843, 319, 177, 5, 36, "Output",
 CellID->17065]
}, Open  ]],
Cell[14035, 327, 119, 3, 70, "MathCaption",
 CellID->31930],
Cell[CellGroupData[{
Cell[14179, 334, 136, 4, 70, "Input",
 CellID->28264],
Cell[14318, 340, 227, 8, 52, "Output",
 CellID->5423]
}, Open  ]],
Cell[14560, 351, 293, 10, 70, "MathCaption",
 CellID->23322],
Cell[CellGroupData[{
Cell[14878, 365, 138, 4, 70, "Input",
 CellID->4486],
Cell[15019, 371, 222, 8, 52, "Output",
 CellID->28908]
}, Open  ]],
Cell[15256, 382, 94, 1, 70, "MathCaption",
 CellID->14638],
Cell[CellGroupData[{
Cell[15375, 387, 103, 3, 70, "Input",
 CellID->8631],
Cell[15481, 392, 3547, 61, 70, "Picture",
 CellID->1485416934],
Cell[19031, 455, 179, 5, 36, "Output",
 CellID->6426]
}, Open  ]],
Cell[19225, 463, 1544, 44, 70, "DefinitionBox",
 CellID->4362],
Cell[20772, 509, 113, 3, 70, "Caption",
 CellID->563],
Cell[20888, 514, 605, 13, 70, "Text",
 CellID->8378],
Cell[21496, 529, 266, 7, 70, "Text",
 CellID->14419],
Cell[21765, 538, 2074, 63, 70, "DefinitionBox",
 CellID->31851],
Cell[23842, 603, 77, 1, 70, "Caption",
 CellID->8741],
Cell[23922, 606, 258, 8, 70, "MathCaption",
 CellID->25315],
Cell[CellGroupData[{
Cell[24205, 618, 168, 5, 70, "Input",
 CellID->13076],
Cell[24376, 625, 273, 9, 36, "Output",
 CellID->21168]
}, Open  ]],
Cell[24664, 637, 119, 3, 70, "MathCaption",
 CellID->11521],
Cell[CellGroupData[{
Cell[24808, 644, 251, 8, 70, "Input",
 CellID->30098],
Cell[25062, 654, 3446, 59, 70, "Picture",
 CellID->1963747081],
Cell[28511, 715, 322, 11, 36, "Output",
 CellID->20531]
}, Open  ]],
Cell[28848, 729, 379, 13, 70, "MathCaption",
 CellID->488518183],
Cell[CellGroupData[{
Cell[29252, 746, 177, 5, 70, "Input",
 CellID->436379784],
Cell[29432, 753, 277, 9, 36, "Output",
 CellID->954359254]
}, Open  ]],
Cell[29724, 765, 242, 8, 70, "MathCaption",
 CellID->3619019],
Cell[CellGroupData[{
Cell[29991, 777, 261, 9, 70, "Input",
 CellID->191037634],
Cell[30255, 788, 3856, 66, 70, "Picture",
 CellID->859318188]
}, Open  ]],
Cell[34126, 857, 523, 10, 70, "Text",
 CellID->7239],
Cell[34652, 869, 134, 4, 70, "Text",
 CellID->8339],
Cell[34789, 875, 2117, 60, 70, "DefinitionBox",
 CellID->20552],
Cell[36909, 937, 79, 1, 70, "Caption",
 CellID->26830],
Cell[36991, 940, 1366, 29, 70, "DefinitionBox",
 CellID->20474],
Cell[38360, 971, 72, 1, 70, "Caption",
 CellID->20781],
Cell[38435, 974, 65, 1, 70, "MathCaption",
 CellID->3742],
Cell[38503, 977, 5552, 94, 70, "Picture",
 CellID->1332028623],
Cell[44058, 1073, 179, 5, 70, "MathCaption",
 CellID->2900],
Cell[44240, 1080, 144, 5, 70, "Input",
 CellID->29700],
Cell[44387, 1087, 121, 3, 70, "MathCaption",
 CellID->24234],
Cell[CellGroupData[{
Cell[44533, 1094, 146, 4, 70, "Input",
 CellID->25606],
Cell[44682, 1100, 5583, 94, 70, "Picture",
 CellID->282281797]
}, Open  ]],
Cell[50280, 1197, 93, 1, 70, "MathCaption",
 CellID->9790],
Cell[CellGroupData[{
Cell[50398, 1202, 144, 4, 70, "Input",
 CellID->6923],
Cell[50545, 1208, 4523, 77, 70, "Picture",
 CellID->1665559259]
}, Open  ]],
Cell[55083, 1288, 98, 2, 70, "MathCaption",
 CellID->8168],
Cell[CellGroupData[{
Cell[55206, 1294, 150, 4, 70, "Input",
 CellID->485],
Cell[55359, 1300, 4576, 78, 70, "Picture",
 CellID->1977935602]
}, Open  ]],
Cell[59950, 1381, 2467, 72, 70, "DefinitionBox",
 CellID->25455],
Cell[62420, 1455, 72, 1, 70, "Caption",
 CellID->7544],
Cell[62495, 1458, 191, 6, 70, "MathCaption",
 CellID->2444],
Cell[CellGroupData[{
Cell[62711, 1468, 158, 4, 70, "Input",
 CellID->30708],
Cell[62872, 1474, 5579, 94, 70, "Picture",
 CellID->20800]
}, Open  ]],
Cell[68466, 1571, 354, 11, 70, "MathCaption",
 CellID->25219],
Cell[CellGroupData[{
Cell[68845, 1586, 158, 4, 70, "Input",
 CellID->30518],
Cell[69006, 1592, 5579, 94, 70, "Picture",
 CellID->16349],
Cell[74588, 1688, 152, 5, 36, "Output",
 CellID->28947]
}, Open  ]],
Cell[74755, 1696, 1061, 30, 70, "DefinitionBox",
 CellID->7580],
Cell[75819, 1728, 135, 5, 70, "Caption",
 CellID->29299],
Cell[75957, 1735, 606, 16, 70, "Text",
 CellID->21448],
Cell[76566, 1753, 1073, 28, 70, "DefinitionBox",
 CellID->684],
Cell[77642, 1783, 73, 1, 70, "Caption",
 CellID->26119],
Cell[77718, 1786, 928, 25, 70, "Text",
 CellID->29132],
Cell[78649, 1813, 1804, 53, 70, "DefinitionBox",
 CellID->23340],
Cell[80456, 1868, 69, 1, 70, "Caption",
 CellID->11888],
Cell[80528, 1871, 1194, 39, 70, "Text",
 CellID->9770],
Cell[81725, 1912, 88, 1, 70, "MathCaption",
 CellID->19297],
Cell[81816, 1915, 5579, 94, 70, "Picture",
 CellID->21433],
Cell[87398, 2011, 84, 1, 70, "MathCaption",
 CellID->15140],
Cell[CellGroupData[{
Cell[87507, 2016, 154, 4, 70, "Input",
 CellID->2622],
Cell[87664, 2022, 7381, 124, 70, "Picture",
 CellID->356012326]
}, Open  ]],
Cell[95060, 2149, 127, 4, 70, "MathCaption",
 CellID->5540],
Cell[CellGroupData[{
Cell[95212, 2157, 148, 4, 70, "Input",
 CellID->20727],
Cell[95363, 2163, 7284, 122, 70, "Picture",
 CellID->1564338623]
}, Open  ]],
Cell[102662, 2288, 114, 3, 70, "MathCaption",
 CellID->21082],
Cell[CellGroupData[{
Cell[102801, 2295, 235, 7, 70, "Input",
 CellID->29247],
Cell[103039, 2304, 7444, 125, 70, "Picture",
 CellID->2005337537]
}, Open  ]],
Cell[110498, 2432, 114, 3, 70, "MathCaption",
 CellID->20050],
Cell[CellGroupData[{
Cell[110637, 2439, 147, 4, 70, "Input",
 CellID->17730],
Cell[110787, 2445, 7590, 127, 70, "Picture",
 CellID->1382398134]
}, Open  ]],
Cell[118392, 2575, 128, 4, 70, "MathCaption",
 CellID->28304],
Cell[CellGroupData[{
Cell[118545, 2583, 107, 3, 70, "Input",
 CellID->16331],
Cell[118655, 2588, 7585, 127, 70, "Picture",
 CellID->18805],
Cell[126243, 2717, 255, 8, 36, "Output",
 CellID->28051]
}, Open  ]],
Cell[126513, 2728, 1431, 43, 70, "Text",
 CellID->13139],
Cell[127947, 2773, 131, 4, 70, "MathCaption",
 CellID->6767],
Cell[CellGroupData[{
Cell[128103, 2781, 145, 5, 70, "Input",
 CellID->24370],
Cell[128251, 2788, 2872, 50, 70, "Picture",
 CellID->1888674931]
}, Open  ]],
Cell[131138, 2841, 140, 4, 70, "MathCaption",
 CellID->10143],
Cell[CellGroupData[{
Cell[131303, 2849, 170, 5, 70, "Input",
 CellID->30556],
Cell[131476, 2856, 3136, 54, 70, "Picture",
 CellID->1200720930]
}, Open  ]],
Cell[134627, 2913, 1894, 54, 70, "DefinitionBox",
 CellID->27116],
Cell[136524, 2969, 72, 1, 70, "Caption",
 CellID->11957],
Cell[136599, 2972, 115, 3, 70, "MathCaption",
 CellID->28286],
Cell[CellGroupData[{
Cell[136739, 2979, 154, 4, 70, "Input",
 CellID->27366],
Cell[136896, 2985, 3364, 58, 70, "Picture",
 CellID->1483973693]
}, Open  ]],
Cell[140275, 3046, 86, 1, 70, "MathCaption",
 CellID->10843],
Cell[CellGroupData[{
Cell[140386, 3051, 112, 3, 70, "Input",
 CellID->30672],
Cell[140501, 3056, 2403, 42, 70, "Picture",
 CellID->464989744]
}, Open  ]],
Cell[142919, 3101, 828, 22, 70, "Text",
 CellID->21298],
Cell[143750, 3125, 91, 1, 70, "MathCaption",
 CellID->11471],
Cell[CellGroupData[{
Cell[143866, 3130, 145, 4, 70, "Input",
 CellID->8937],
Cell[144014, 3136, 2505, 44, 70, "Picture",
 CellID->462895633]
}, Open  ]],
Cell[146534, 3183, 114, 3, 70, "MathCaption",
 CellID->12809],
Cell[CellGroupData[{
Cell[146673, 3190, 114, 3, 70, "Input",
 CellID->20920],
Cell[146790, 3195, 5585, 94, 70, "Picture",
 CellID->2128825919]
}, Open  ]],
Cell[152390, 3292, 227, 8, 70, "MathCaption",
 CellID->17327],
Cell[CellGroupData[{
Cell[152642, 3304, 172, 5, 70, "Input",
 CellID->28441],
Cell[152817, 3311, 5775, 97, 70, "Picture",
 CellID->188538220]
}, Open  ]],
Cell[158607, 3411, 140, 4, 70, "MathCaption",
 CellID->3323],
Cell[CellGroupData[{
Cell[158772, 3419, 122, 3, 70, "Input",
 CellID->32528],
Cell[158897, 3424, 5081, 86, 70, "Picture",
 CellID->1009958667]
}, Open  ]],
Cell[163993, 3513, 1068, 31, 70, "Text",
 CellID->24597],
Cell[165064, 3546, 2931, 83, 70, "DefinitionBox",
 CellID->7099],
Cell[167998, 3631, 122, 4, 70, "Caption",
 CellID->1881],
Cell[168123, 3637, 1041, 30, 70, "DefinitionBox",
 CellID->21823],
Cell[169167, 3669, 81, 1, 70, "Caption",
 CellID->13310],
Cell[169251, 3672, 64, 1, 70, "MathCaption",
 CellID->3671],
Cell[CellGroupData[{
Cell[169340, 3677, 145, 5, 70, "Input",
 CellID->27578],
Cell[169488, 3684, 561, 12, 70, "Picture",
 CellID->23993]
}, Open  ]],
Cell[170064, 3699, 198, 6, 70, "MathCaption",
 CellID->15090],
Cell[CellGroupData[{
Cell[170287, 3709, 153, 4, 70, "Input",
 CellID->21653],
Cell[170443, 3715, 1313, 24, 70, "Picture",
 CellID->466336708]
}, Open  ]],
Cell[171771, 3742, 182, 4, 70, "MathCaption",
 CellID->6266],
Cell[CellGroupData[{
Cell[171978, 3750, 147, 4, 70, "Input",
 CellID->24247],
Cell[172128, 3756, 2643, 46, 70, "Picture",
 CellID->518571646]
}, Open  ]],
Cell[174786, 3805, 230, 8, 70, "MathCaption",
 CellID->27422],
Cell[CellGroupData[{
Cell[175041, 3817, 194, 6, 70, "Input",
 CellID->10745],
Cell[175238, 3825, 4444, 75, 70, "Picture",
 CellID->1156417942]
}, Open  ]],
Cell[179697, 3903, 133, 4, 70, "MathCaption",
 CellID->23488],
Cell[CellGroupData[{
Cell[179855, 3911, 139, 4, 70, "Input",
 CellID->3022],
Cell[179997, 3917, 3232, 56, 70, "Picture",
 CellID->32116123]
}, Open  ]],
Cell[183244, 3976, 122, 3, 70, "MathCaption",
 CellID->17519],
Cell[CellGroupData[{
Cell[183391, 3983, 142, 4, 70, "Input",
 CellID->24083],
Cell[183536, 3989, 3400, 58, 70, "Picture",
 CellID->1470229469]
}, Open  ]],
Cell[186951, 4050, 1934, 53, 70, "DefinitionBox",
 CellID->20805],
Cell[188888, 4105, 123, 4, 70, "Caption",
 CellID->2794],
Cell[189014, 4111, 85, 1, 70, "MathCaption",
 CellID->7646],
Cell[CellGroupData[{
Cell[189124, 4116, 145, 4, 70, "Input",
 CellID->8324],
Cell[189272, 4122, 3575, 61, 70, "Picture",
 CellID->1013880388]
}, Open  ]],
Cell[192862, 4186, 100, 2, 70, "MathCaption",
 CellID->31089],
Cell[CellGroupData[{
Cell[192987, 4192, 209, 6, 70, "Input",
 CellID->27098],
Cell[193199, 4200, 3722, 64, 70, "Picture",
 CellID->1353228441]
}, Open  ]],
Cell[196936, 4267, 3494, 98, 70, "DefinitionBox",
 CellID->12066],
Cell[200433, 4367, 65, 1, 70, "Caption",
 CellID->6460],
Cell[200501, 4370, 351, 11, 70, "Text",
 CellID->20391],
Cell[200855, 4383, 1195, 39, 70, "Text",
 CellID->30573],
Cell[CellGroupData[{
Cell[202075, 4426, 71, 1, 70, "RelatedTutorialsSection",
 CellID->42746463],
Cell[202149, 4429, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[202351, 4437, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

