(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23436,        803]
NotebookOptionsPosition[     18023,        633]
NotebookOutlinePosition[     20738,        702]
CellTagsIndexPosition[     20647,        696]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindFit" :> Documentation`HelpLookup["paclet:ref/FindFit"], 
          "Fit" :> Documentation`HelpLookup["paclet:ref/Fit"], "Fourier" :> 
          Documentation`HelpLookup["paclet:ref/Fourier"], "InverseFourier" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourier"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindFit\"\>", 2->"\<\"Fit\"\>", 
       3->"\<\"Fourier\"\>", 
       4->"\<\"InverseFourier\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Numerical Data", "Title",
 CellTags->{"S1.6.6", "6.1"},
 CellID->25465],

Cell["\<\
When you have numerical data, it is often convenient to find a simple formula \
that approximates it. For example, you can try to \"fit\" a line or curve \
through the points in your data. \
\>", "Text",
 CellID->26605],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Fit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fit"], "[", "{", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["1", "TR"]], Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "fit the values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " to a linear combination of functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Fit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fit"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["1", "TR"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["2", "TR"]], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["1", "TR"]], Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "fit the points ",
     Cell[BoxData[
      RowBox[{"(", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["n", "TI"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["n", "TI"]], ")"}]], "InlineFormula"],
     " to a linear combination of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26806],

Cell["Fitting curves to linear combinations of functions. ", "Caption",
 CellID->17438],

Cell[TextData[{
 "This generates a table of the numerical values of the exponential function. \
",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " is discussed in\[NonBreakingSpace]\"",
 ButtonBox["Making Tables of Values\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MakingTablesOfValues"],
 ". "
}], "MathCaption",
 CellID->16396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"x", "/", "5."}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "7"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2214027581601699`", ",", "1.4918246976412703`", ",", 
   "1.822118800390509`", ",", "2.225540928492468`", ",", "2.718281828459045`",
    ",", "3.320116922736548`", ",", "4.055199966844675`"}], "}"}]], "Output",
 ImageSize->{415, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14025717]
}, Open  ]],

Cell[TextData[{
 "This finds a least\[Hyphen]squares fit to ",
 Cell[BoxData["data"], "InlineFormula"],
 " of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], "+", 
    SubscriptBox["c", "2"], "x", "+", 
    SubscriptBox["c", "3"], 
    SuperscriptBox["x", "2"]}], TraditionalForm]], "InlineMath"],
 ". The elements of ",
 Cell[BoxData["data"], "InlineFormula"],
 " are assumed to correspond to values ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["...", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->27944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21726],

Cell[BoxData[
 RowBox[{"1.0942849747025403`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.09863372758205044`", " ", "x"}], "+", 
  RowBox[{"0.04594819076792495`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2016445419]
}, Open  ]],

Cell[TextData[{
 "This finds a fit of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], "+", 
    SubscriptBox["c", "2"], "x", "+", 
    SubscriptBox["c", "3"], 
    SuperscriptBox["x", "3"], "+", 
    SubscriptBox["c", "4"], 
    SuperscriptBox["x", "5"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->22893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     RowBox[{"x", "^", "3"}], ",", 
     RowBox[{"x", "^", "5"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19323],

Cell[BoxData[
 RowBox[{"0.9680596480276634`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.24682874521153245`", " ", "x"}], "+", 
  RowBox[{"0.004282807454629642`", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"6.579479585683238`*^-6", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1616378549]
}, Open  ]],

Cell[TextData[{
 "This gives a table of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " pairs. "
}], "MathCaption",
 CellID->1124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Exp", "[", 
       RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0.", ",", "1.", ",", "0.2"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "1.219778556000619`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "1.4761219464457283`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6000000000000001`", ",", "1.7588188457669929`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "2.0490086501642746`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.319776824715853`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{319, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1051046521]
}, Open  ]],

Cell[TextData[{
 "This finds a fit to the new data, of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], "+", 
    SubscriptBox["c", "2"], "sin", 
    RowBox[{"(", "x", ")"}], "+", 
    SubscriptBox["c", "3"], "sin", 
    RowBox[{"(", 
     RowBox[{"2", "x"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1670],

Cell[BoxData[
 RowBox[{"0.989559222665401`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.0419920584273306`", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{"0.4181764794290774`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}]}]}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1792130403]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindFit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindFit"], "[", 
     StyleBox["data", "TI"], ",", 
     StyleBox["form", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find a fit to ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " with parameters ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28015],

Cell["Fitting data to general forms. ", "Caption",
 CellID->27825],

Cell["This finds the best parameters for a linear fit. ", "MathCaption",
 CellID->22729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1494],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.9912512908782974`"}], ",", 
   RowBox[{"b", "\[Rule]", "1.164211191590086`"}], ",", 
   RowBox[{"c", "\[Rule]", "0.1742561377515561`"}]}], "}"}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->578999185]
}, Open  ]],

Cell["This does a nonlinear fit. ", "MathCaption",
 CellID->24195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindFit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"a", "+", 
    RowBox[{"b", "^", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->3830],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", 
    RowBox[{"-", "3.6519903307712576`"}]}], ",", 
   RowBox[{"b", "\[Rule]", "1.6583755353059793`"}], ",", 
   RowBox[{"c", "\[Rule]", "3.0349608425614134`"}], ",", 
   RowBox[{"d", "\[Rule]", "0.5010696141397314`"}]}], "}"}]], "Output",
 ImageSize->{348, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2092429529]
}, Open  ]],

Cell[TextData[{
 "One common way of picking out \"signals\" in numerical data is to find the \
",
 StyleBox["Fourier transform",
  FontSlant->"Italic"],
 ", or frequency spectrum, of the data. "
}], "Text",
 CellID->5300],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Fourier",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fourier"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "numerical Fourier transform", "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourier",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourier"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "inverse Fourier transform", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1701],

Cell["Fourier transforms. ", "Caption",
 CellID->10794],

Cell["Here is a simple square pulse. ", "MathCaption",
 CellID->18561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}]}], "}"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->13303],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->240853212]
}, Open  ]],

Cell["This takes the Fourier transform of the pulse. ", "MathCaption",
 CellID->13959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", "data", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->4948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.7071067811865476`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.7071067811865475`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.7071067811865476`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.29289321881345254`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.7071067811865476`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.29289321881345254`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.7071067811865476`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.7071067811865475`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{420, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2132688507]
}, Open  ]],

Cell[TextData[{
 "Note that the ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is defined with the sign convention typically used in the physical \
sciences\[LongDash]opposite to the one often used in electrical engineering. \
\"",
 ButtonBox["Fourier Transforms\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FourierTransforms"],
 " gives more details. "
}], "Text",
 CellID->14613],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->727892452],

Cell[TextData[ButtonBox["Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematicsOverview"]], "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Numerical Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalMathematicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalDifferentialEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 7.3671456}", "context" -> "", 
    "keywords" -> {
     "approximation of functions", "curves", "FFT", "FindFit", "Fit", 
      "Fourier", "Fourier transforms", "frequency spectrum", "InverseFourier",
       "least squares fits", "nonlinear fitting", "numerical data", 
      "power spectrum", "spectrum", "testing models", "trend line"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you have numerical data, it is often convenient to find a simple \
formula that approximates it. For example, you can try to \"fit\" a line or \
curve through the points in your data. Fitting curves to linear combinations \
of functions. This generates a table of the numerical values of the \
exponential function. Table is discussed in \"Making Tables of Values\". ", 
    "synonyms" -> {"1.6.6"}, "title" -> "Manipulating Numerical Data", "type" -> 
    "Tutorial", "uri" -> "tutorial/ManipulatingNumericalData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.6.6"->{
  Cell[2104, 62, 90, 2, 70, "Title",
   CellTags->{"S1.6.6", "6.1"},
   CellID->25465]},
 "6.1"->{
  Cell[2104, 62, 90, 2, 70, "Title",
   CellTags->{"S1.6.6", "6.1"},
   CellID->25465]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.6.6", 20436, 685},
 {"6.1", 20535, 689}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1479, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2104, 62, 90, 2, 70, "Title",
 CellTags->{"S1.6.6", "6.1"},
 CellID->25465],
Cell[2197, 66, 229, 5, 70, "Text",
 CellID->26605],
Cell[2429, 73, 2700, 86, 70, "DefinitionBox",
 CellID->26806],
Cell[5132, 161, 87, 1, 70, "Caption",
 CellID->17438],
Cell[5222, 164, 410, 13, 70, "MathCaption",
 CellID->16396],
Cell[CellGroupData[{
Cell[5657, 181, 257, 9, 28, "Input",
 CellID->27518],
Cell[5917, 192, 385, 10, 36, "Output",
 CellID->14025717]
}, Open  ]],
Cell[6317, 205, 755, 27, 70, "MathCaption",
 CellID->27944],
Cell[CellGroupData[{
Cell[7097, 236, 216, 7, 28, "Input",
 CellID->21726],
Cell[7316, 245, 340, 9, 36, "Output",
 CellID->2016445419]
}, Open  ]],
Cell[7671, 257, 361, 13, 70, "MathCaption",
 CellID->22893],
Cell[CellGroupData[{
Cell[8057, 274, 252, 8, 70, "Input",
 CellID->19323],
Cell[8312, 284, 420, 11, 36, "Output",
 CellID->1616378549]
}, Open  ]],
Cell[8747, 298, 223, 9, 70, "MathCaption",
 CellID->1124],
Cell[CellGroupData[{
Cell[8995, 311, 345, 12, 70, "Input",
 CellID->4218],
Cell[9343, 325, 660, 19, 54, "Output",
 CellID->1051046521]
}, Open  ]],
Cell[10018, 347, 372, 13, 70, "MathCaption",
 CellID->30472],
Cell[CellGroupData[{
Cell[10415, 364, 274, 9, 70, "Input",
 CellID->1670],
Cell[10692, 375, 399, 11, 36, "Output",
 CellID->1792130403]
}, Open  ]],
Cell[11106, 389, 1195, 37, 70, "DefinitionBox",
 CellID->28015],
Cell[12304, 428, 66, 1, 70, "Caption",
 CellID->27825],
Cell[12373, 431, 88, 1, 70, "MathCaption",
 CellID->22729],
Cell[CellGroupData[{
Cell[12486, 436, 313, 10, 70, "Input",
 CellID->1494],
Cell[12802, 448, 357, 10, 36, "Output",
 CellID->578999185]
}, Open  ]],
Cell[13174, 461, 66, 1, 70, "MathCaption",
 CellID->24195],
Cell[CellGroupData[{
Cell[13265, 466, 346, 12, 70, "Input",
 CellID->3830],
Cell[13614, 480, 437, 12, 36, "Output",
 CellID->2092429529]
}, Open  ]],
Cell[14066, 495, 221, 7, 70, "Text",
 CellID->5300],
Cell[14290, 504, 762, 23, 70, "DefinitionBox",
 CellID->1701],
Cell[15055, 529, 55, 1, 70, "Caption",
 CellID->10794],
Cell[15113, 532, 70, 1, 70, "MathCaption",
 CellID->18561],
Cell[CellGroupData[{
Cell[15208, 537, 278, 9, 70, "Input",
 CellID->13303],
Cell[15489, 548, 340, 11, 36, "Output",
 CellID->240853212]
}, Open  ]],
Cell[15844, 562, 86, 1, 70, "MathCaption",
 CellID->13959],
Cell[CellGroupData[{
Cell[15955, 567, 101, 3, 70, "Input",
 CellID->4948],
Cell[16059, 572, 1086, 24, 54, "Output",
 CellID->2132688507]
}, Open  ]],
Cell[17160, 599, 535, 17, 70, "Text",
 CellID->14613],
Cell[CellGroupData[{
Cell[17720, 620, 72, 1, 70, "RelatedTutorialsSection",
 CellID->727892452],
Cell[17795, 623, 174, 4, 70, "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],
Cell[17996, 631, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

