(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14077,        478]
NotebookOptionsPosition[      9649,        342]
NotebookOutlinePosition[     12390,        413]
CellTagsIndexPosition[     12299,        407]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dispatch" :> 
          Documentation`HelpLookup["paclet:ref/Dispatch"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dispatch\"\>"}, "\<\"functions\"\>",
        
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Sets of Transformation Rules", "Title",
 CellTags->{"S2.5.2", "2.1"},
 CellID->30497],

Cell[TextData[{
 "You can manipulate lists of transformation rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just like other symbolic expressions. It is common to assign a name to a \
rule or set of rules. "
}], "Text",
 CellID->19466],

Cell[TextData[{
 "This assigns the \[OpenCurlyDoubleQuote]name\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["sinexp"], "InlineFormula"],
 " to the trigonometric expansion rule. "
}], "MathCaption",
 CellID->27443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sinexp", "=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x_"}], "]"}], "->", 
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19448],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", "x_"}], "]"}], "\[Rule]", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->26392]
}, Open  ]],

Cell["\<\
You can now request the rule \[OpenCurlyDoubleQuote]by name\
\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",
 CellID->13531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}], "]"}], "/.", 
  "sinexp"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->10204],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], "]"}], " ", 
  RowBox[{"Sin", "[", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], "]"}]}]], "Output",
 ImageSize->{180, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->19695]
}, Open  ]],

Cell["\<\
You can use lists of rules to represent mathematical and other relations. \
Typically you will find it convenient to give names to the lists, so that you \
can easily specify the list you want in a particular case. \
\>", "Text",
 CellID->27294],

Cell[TextData[{
 "In most situations, it is only one rule from any given list that actually \
applies to a particular expression. Nevertheless, the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator tests each of the rules in the list in turn. If the list is very \
long, this process can take a long time. "
}], "Text",
 CellID->5450],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to preprocess lists of rules so that ",
 Cell[BoxData["/."], "InlineFormula"],
 " can operate more quickly on them. You can take any list of rules and apply \
the function ",
 Cell[BoxData[
  ButtonBox["Dispatch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dispatch"]], "InlineFormula"],
 " to them. The result is a representation of the original list of rules, but \
including dispatch tables which allow ",
 Cell[BoxData["/."], "InlineFormula"],
 " to \[OpenCurlyDoubleQuote]dispatch\[CloseCurlyDoubleQuote] to potentially \
applicable rules immediately, rather than testing all the rules in turn. "
}], "Text",
 CellID->19149],

Cell["Here is a list of rules for the first five factorials. ", "MathCaption",
 CellID->1951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"facs", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "i", "]"}], "->", 
     RowBox[{"i", "!"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->32581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "2", "]"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "3", "]"}], "\[Rule]", "6"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "4", "]"}], "\[Rule]", "24"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "5", "]"}], "\[Rule]", "120"}]}], "}"}]], "Output",
 ImageSize->{339, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->31598]
}, Open  ]],

Cell["\<\
This sets up dispatch tables that make the rules faster to use. \
\>", "MathCaption",
 CellID->21845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dfacs", "=", 
  RowBox[{"Dispatch", "[", "facs", "]"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->13675],

Cell[BoxData[
 TagBox[
  RowBox[{"Dispatch", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"f", "[", "2", "]"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"f", "[", "3", "]"}], "\[Rule]", "6"}], ",", 
      RowBox[{
       RowBox[{"f", "[", "4", "]"}], "\[Rule]", "24"}], ",", 
      RowBox[{
       RowBox[{"f", "[", "5", "]"}], "\[Rule]", "120"}]}], "}"}], ",", 
    TagBox[
     InterpretationBox[
      RowBox[{"-", "DispatchTables", "-"}],
      1],
     DisplayForm]}], "]"}],
  Function[BoxForm`arg, 
   ReplacePart[
    HoldComplete[
     Dispatch[ProgrammingDump`dumy]], 
    HoldComplete[BoxForm`arg], {1, 1}, {1, 1}], {HoldAllComplete}]]], "Output",\

 ImageSize->{536, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->245]
}, Open  ]],

Cell[TextData[{
 "You can apply the rules using the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. "
}], "MathCaption",
 CellID->31584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "4", "]"}], "/.", "dfacs"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->21433],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->6100]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Dispatch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dispatch"], "[", 
     StyleBox["rules", "TI"], "]"}], Cell["\<\
create a representation of a list of rules that includes dispatch tables\
\>", "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", 
     StyleBox["drules", "TI"]}], Cell[
    "apply rules that include dispatch tables", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14399],

Cell["Creating and using dispatch tables. ", "Caption",
 CellID->21567],

Cell[TextData[{
 "For long lists of rules, you will find that setting up dispatch tables \
makes replacement operations much faster. This is particularly true when your \
rules are for individual symbols or other expressions that do not involve \
pattern objects. Once you have built dispatch tables in such cases, you will \
find that the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator takes a time that is more or less independent of the number of \
rules you have. Without dispatch tables, however, ",
 Cell[BoxData["/."], "InlineFormula"],
 " will take a time directly proportional to the total number of rules. "
}], "Text",
 CellID->32297],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->192180247],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Sets of Transformation Rules - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ApplyingTransformationRules"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MakingDefinitions"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 8.7109300}", "context" -> "", 
    "keywords" -> {
     "dispatch", "efficiency", "hashing", "rules", "tables", 
      "transformation rules"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "You can manipulate lists of transformation rules in Mathematica just \
like other symbolic expressions. It is common to assign a name to a rule or \
set of rules. This assigns the 'name' sinexp to the trigonometric expansion \
rule. You can now request the rule 'by name'. ", "synonyms" -> {"2.5.2"}, 
    "title" -> "Manipulating Sets of Transformation Rules", "type" -> 
    "Tutorial", "uri" -> "tutorial/ManipulatingSetsOfTransformationRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.2"->{
  Cell[1865, 60, 104, 2, 70, "Title",
   CellTags->{"S2.5.2", "2.1"},
   CellID->30497]},
 "2.1"->{
  Cell[1865, 60, 104, 2, 70, "Title",
   CellTags->{"S2.5.2", "2.1"},
   CellID->30497]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.2", 12086, 396},
 {"2.1", 12186, 400}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1240, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1865, 60, 104, 2, 70, "Title",
 CellTags->{"S2.5.2", "2.1"},
 CellID->30497],
Cell[1972, 64, 251, 7, 70, "Text",
 CellID->19466],
Cell[2226, 73, 209, 5, 70, "MathCaption",
 CellID->27443],
Cell[CellGroupData[{
Cell[2460, 82, 273, 9, 28, "Input",
 CellID->19448],
Cell[2736, 93, 334, 11, 36, "Output",
 CellID->26392]
}, Open  ]],
Cell[3085, 107, 134, 4, 70, "MathCaption",
 CellID->13531],
Cell[CellGroupData[{
Cell[3244, 115, 230, 9, 28, "Input",
 CellID->10204],
Cell[3477, 126, 400, 14, 39, "Output",
 CellID->19695]
}, Open  ]],
Cell[3892, 143, 255, 5, 70, "Text",
 CellID->27294],
Cell[4150, 150, 338, 7, 70, "Text",
 CellID->5450],
Cell[4491, 159, 714, 17, 70, "Text",
 CellID->19149],
Cell[5208, 178, 93, 1, 70, "MathCaption",
 CellID->1951],
Cell[CellGroupData[{
Cell[5326, 183, 277, 10, 70, "Input",
 CellID->32581],
Cell[5606, 195, 534, 17, 36, "Output",
 CellID->31598]
}, Open  ]],
Cell[6155, 215, 111, 3, 70, "MathCaption",
 CellID->21845],
Cell[CellGroupData[{
Cell[6291, 222, 131, 4, 70, "Input",
 CellID->13675],
Cell[6425, 228, 910, 31, 36, "Output",
 CellID->245]
}, Open  ]],
Cell[7350, 262, 143, 5, 70, "MathCaption",
 CellID->31584],
Cell[CellGroupData[{
Cell[7518, 271, 122, 4, 70, "Input",
 CellID->21433],
Cell[7643, 277, 155, 5, 36, "Output",
 CellID->6100]
}, Open  ]],
Cell[7813, 285, 750, 22, 70, "DefinitionBox",
 CellID->14399],
Cell[8566, 309, 71, 1, 70, "Caption",
 CellID->21567],
Cell[8640, 312, 652, 12, 70, "Text",
 CellID->32297],
Cell[CellGroupData[{
Cell[9317, 328, 72, 1, 70, "RelatedTutorialsSection",
 CellID->192180247],
Cell[9392, 331, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[9622, 340, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

