(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14915,        454]
NotebookOptionsPosition[     10773,        333]
NotebookOutlinePosition[     13616,        407]
CellTagsIndexPosition[     13524,        401]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], 
          "FrontEndTokenExecute" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndTokenExecute"], 
          "Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "SetOptions" :> Documentation`HelpLookup["paclet:ref/SetOptions"], 
          "$FrontEnd" :> Documentation`HelpLookup["paclet:ref/$FrontEnd"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"AbsoluteOptions\"\>", 
       2->"\<\"CurrentValue\"\>", 3->"\<\"FrontEndTokenExecute\"\>", 
       4->"\<\"Options\"\>", 5->"\<\"SetOptions\"\>", 
       6->"\<\"$FrontEnd\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating the Front End from the Kernel", "Title",
 CellTags->{"S2.11.4", "4.1"},
 CellID->14938],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$FrontEnd",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$FrontEnd"], Cell[
    "the front end currently in use", "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     ButtonBox["$FrontEnd",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$FrontEnd"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[
    "the setting for a global option in the front end", "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsoluteOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
     ButtonBox["$FrontEnd",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$FrontEnd"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[
    "the absolute setting for an option", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     ButtonBox["$FrontEnd",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$FrontEnd"], ",", 
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"], "]"}], Cell[
    "reset an option in the front end", "TableText"]},
   {
    RowBox[{
     ButtonBox["CurrentValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CurrentValue"], "[", 
     RowBox[{
      ButtonBox["$FrontEnd",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$FrontEnd"], ",", " ", 
      StyleBox["option", "TI"]}], "]"}], Cell["\<\
returns option value, and also allows setting of option when used as the \
left-hand side of an assignment\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.44], {
      Scaled[0.56]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25005],

Cell["Manipulating global options in the front end. ", "Caption",
 CellID->26866],

Cell[TextData[{
 "Just like cells and notebooks, the complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end has various options, which you can look at and manipulate from \
the kernel."
}], "Text",
 CellID->16666],

Cell["\<\
This gives the object corresponding to the front end currently in use. \
\>", "MathCaption",
 CellID->32171],

Cell[CellGroupData[{

Cell[BoxData["$FrontEnd"], "Input",
 CellLabel->"In[7]:=",
 CellID->3080],

Cell[BoxData[
 PanelBox[
  TooltipBox[
   RowBox[{
   "\[SkeletonIndicator]", " ", "FrontEndObject", " ", 
    "\[SkeletonIndicator]"}],
   InterpretationBox[
    StyleBox[
    "FrontEndObject[LinkObject[\"p7d_shm\", 1, 1]]", ShowStringCharacters -> 
     True, NumberMarks -> True], 
    InputForm[
     FrontEndObject[
      LinkObject["p7d_shm", 1, 1]]], Editable -> True, AutoDelete -> 
    True]]]], "Output",
 ImageSize->{114, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->514001049]
}, Open  ]],

Cell["\<\
This gives the current directory used by the front end for notebook files. \
\>", "MathCaption",
 CellID->27541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"$FrontEnd", ",", "NotebookBrowseDirectory"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->15026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "NotebookBrowseDirectory", 
   "\[Rule]", "\<\"C:\\\\Documents and Settings\\\\All \
Users\\\\Documents\"\>"}], "}"}]], "Output",
 ImageSize->{510, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->702335305]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {"NotebookBrowseDirectory", Cell["(system dependent)", "TableText"], Cell[
    "the default directory for opening and saving notebook files", 
     "TableText"]},
   {
    ButtonBox["NotebookPath",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NotebookPath"], Cell[
    "(system dependent)", "TableText"], Cell[
    "the path to search when trying to open notebooks", "TableText"]},
   {
    ButtonBox["Language",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Language"], "\"\<English\>\"", Cell[
    "default language for text", "TableText"]},
   {"MessageOptions", Cell["(list of settings)", "TableText"], Cell[
    "how to handle various help and warning messages", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1935],

Cell[TextData[{
 "A few global options for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. "
}], "Caption",
 CellID->12733],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 " you can effectively input to the front end any ordinary text that you can \
enter on the keyboard. ",
 Cell[BoxData[
  ButtonBox["FrontEndTokenExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndTokenExecute"]], "InlineFormula"],
 " allows you to send from the kernel any command that the front end can \
execute. These commands include both menu items and control sequences. "
}], "Text",
 CellID->23251],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FrontEndTokenExecute",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrontEndTokenExecute"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "execute a named command in the front end", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10724],

Cell["Executing a named command in the front end. ", "Caption",
 CellID->23076],

Cell[BoxData[GridBox[{
   {"\"\<Indent\>\"", Cell[
    "indent all selected lines by one tab", "TableText"]},
   {"\"\<NotebookStatisticsDialog\>\"", Cell[
    "display statistics about the current notebook", "TableText"]},
   {"\"\<OpenCloseGroup\>\"", Cell[
    "toggle a cell group between open and closed", "TableText"]},
   {"\"\<CellSplit\>\"", Cell[
    "split a cell in two at the current insertion point", "TableText"]},
   {"\"\<DuplicatePreviousInput\>\"", Cell["\<\
create a new cell which is a duplicate of the nearest input cell above\
\>", "TableText"]},
   {"\"\<FindDialog\>\"", Cell["bring up the find dialog", "TableText"]},
   {"\"\<ColorSelectorDialog\>\"", Cell[
    "bring up the color selector dialog", "TableText"]},
   {"\"\<GraphicsAlign\>\"", Cell["align selected graphics", "TableText"]},
   {"\"\<CompleteSelection\>\"", Cell[
    "complete the command name that is the current selection", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15292],

Cell["\<\
A few named commands that can be given to the front end. These commands \
usually correspond to menu items. \
\>", "Caption",
 CellID->8159],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->137365561],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating the Front End from the Kernel - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingNotebooksFromTheKernel"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExecutingNotebookCommandsDirectlyInTheFrontEnd"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 9.3203206}", "context" -> "", 
    "keywords" -> {
     "commands", "directory", "FrontEnd", "FrontEndTokenExecute", "language", 
      "menus", "MessageOptions", "NotebookDirectory", "NotebookPath", 
      "scripts"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Manipulating global options in the front end. Just like cells and \
notebooks, the complete Mathematica front end has various options, which you \
can look at and manipulate from the kernel. This gives the object \
corresponding to the front end currently in use. ", "synonyms" -> {"2.11.4"}, 
    "title" -> "Manipulating the Front End from the Kernel", "type" -> 
    "Tutorial", "uri" -> "tutorial/ManipulatingTheFrontEndFromTheKernel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.4"->{
  Cell[2421, 68, 106, 2, 70, "Title",
   CellTags->{"S2.11.4", "4.1"},
   CellID->14938]},
 "4.1"->{
  Cell[2421, 68, 106, 2, 70, "Title",
   CellTags->{"S2.11.4", "4.1"},
   CellID->14938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.4", 13309, 390},
 {"4.1", 13410, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1796, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2421, 68, 106, 2, 70, "Title",
 CellTags->{"S2.11.4", "4.1"},
 CellID->14938],
Cell[2530, 72, 2140, 63, 70, "DefinitionBox",
 CellID->25005],
Cell[4673, 137, 81, 1, 70, "Caption",
 CellID->26866],
Cell[4757, 140, 232, 7, 70, "Text",
 CellID->16666],
Cell[4992, 149, 118, 3, 70, "MathCaption",
 CellID->32171],
Cell[CellGroupData[{
Cell[5135, 156, 73, 2, 28, "Input",
 CellID->3080],
Cell[5211, 160, 545, 18, 58, "Output",
 CellID->514001049]
}, Open  ]],
Cell[5771, 181, 122, 3, 70, "MathCaption",
 CellID->27541],
Cell[CellGroupData[{
Cell[5918, 188, 153, 4, 28, "Input",
 CellID->15026],
Cell[6074, 194, 303, 10, 36, "Output",
 CellID->702335305]
}, Open  ]],
Cell[6392, 207, 1155, 27, 70, "DefinitionBox3Col",
 CellID->1935],
Cell[7550, 236, 145, 6, 70, "Caption",
 CellID->12733],
Cell[7698, 244, 582, 15, 70, "Text",
 CellID->23251],
Cell[8283, 261, 604, 16, 70, "DefinitionBox",
 CellID->10724],
Cell[8890, 279, 79, 1, 70, "Caption",
 CellID->23076],
Cell[8972, 282, 1319, 28, 70, "DefinitionBox",
 CellID->15292],
Cell[10294, 312, 150, 4, 70, "Caption",
 CellID->8159],
Cell[CellGroupData[{
Cell[10469, 320, 72, 1, 70, "RelatedTutorialsSection",
 CellID->137365561],
Cell[10544, 323, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[10746, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

