(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13881,        473]
NotebookOptionsPosition[      9721,        350]
NotebookOutlinePosition[     12418,        418]
CellTagsIndexPosition[     12325,        412]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DownValues" :> 
          Documentation`HelpLookup["paclet:ref/DownValues"], "UpValues" :> 
          Documentation`HelpLookup["paclet:ref/UpValues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DownValues\"\>", 
       2->"\<\"UpValues\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Value Lists", "Title",
 CellTags->{"S2.5.13", "13.1"},
 CellID->30951],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DownValues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DownValues"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the list of downvalues of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UpValues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UpValues"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the list of upvalues of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DownValues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DownValues"], "[", 
     StyleBox["f", "TI"], "]", "=", 
     StyleBox["rules", "TI"]}], Cell[TextData[{
     "set the downvalues of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UpValues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UpValues"], "[", 
     StyleBox["f", "TI"], "]", "=", 
     StyleBox["rules", "TI"]}], Cell[TextData[{
     "set the upvalues of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15596],

Cell["Finding and setting values of symbols. ", "Caption",
 CellID->9527],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively stores all definitions you give as lists of transformation \
rules. When a particular symbol is encountered, the lists of rules associated \
with it are tried. "
}], "Text",
 CellID->10807],

Cell[TextData[{
 "Under most circumstances, you do not need direct access to the actual \
transformation rules associated with definitions you have given. Instead, you \
can simply use ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "=."}]], "InlineFormula"],
 " to add and remove rules. In some cases, however, you may find it useful to \
have direct access to the actual rules. "
}], "Text",
 CellID->4287],

Cell[TextData[{
 "Here is a definition for ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12027],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->1920],

Cell[TextData[{
 "This gives the explicit rule corresponding to the definition you made for \
",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->11127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{173, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24837]
}, Open  ]],

Cell[TextData[{
 "Notice that the rules returned by ",
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " are set up so that neither their left\[Hyphen] nor right\[Hyphen]hand \
sides get evaluated. The left\[Hyphen]hand sides are wrapped in ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 ", and the rules are delayed, so that the right\[Hyphen]hand sides are not \
immediately evaluated. "
}], "Text",
 CellID->29710],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Making Definitions for Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MakingDefinitionsForFunctions"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to order definitions so that more specific ones appear before more \
general ones. In general, however, there is no unique way to make this \
ordering, and you may want to choose a different ordering from the one that \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " chooses by default. You can do this by reordering the list of rules \
obtained from ",
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16583],

Cell[TextData[{
 "Here are some definitions for the object\[NonBreakingSpace]",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9803],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", "+", "y_"}], "]"}], ":=", 
   RowBox[{"gp", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", " ", "y_"}], "]"}], ":=", 
   RowBox[{"gm", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->15137],

Cell["This shows the default ordering used for the definitions. ", \
"MathCaption",
 CellID->29483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"g", "[", 
      RowBox[{"x_", "+", "y_"}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"gp", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"g", "[", 
      RowBox[{"x_", " ", "y_"}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"gm", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->5635]
}, Open  ]],

Cell[TextData[{
 "This reverses the order of the definitions for ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DownValues", "[", "g", "]"}], "=", 
  RowBox[{"Reverse", "[", 
   RowBox[{"DownValues", "[", "g", "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->23277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"g", "[", 
      RowBox[{"x_", " ", "y_"}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"gm", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"g", "[", 
      RowBox[{"x_", "+", "y_"}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"gp", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->22278]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->152024614],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Value Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ModifyingBuiltInFunctions"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 9.5703270}", "context" -> "", 
    "keywords" -> {
     "assignments", "definitions", "DownValues", "reordering", "rules", 
      "UpValues", "values"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Finding and setting values of symbols. Mathematica effectively stores \
all definitions you give as lists of transformation rules. When a particular \
symbol is encountered, the lists of rules associated with it are tried. Under \
most circumstances, you do not need direct access to the actual \
transformation rules associated with definitions you have given. Instead, you \
can simply use lhs=rhs and lhs=. to add and remove rules. In some cases, \
however, you may find it useful to have direct access to the actual rules. ", 
    "synonyms" -> {"2.5.13"}, "title" -> "Manipulating Value Lists", "type" -> 
    "Tutorial", "uri" -> "tutorial/ManipulatingValueLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.13"->{
  Cell[1968, 61, 89, 2, 70, "Title",
   CellTags->{"S2.5.13", "13.1"},
   CellID->30951]},
 "13.1"->{
  Cell[1968, 61, 89, 2, 70, "Title",
   CellTags->{"S2.5.13", "13.1"},
   CellID->30951]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.13", 12109, 401},
 {"13.1", 12211, 405}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1343, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1968, 61, 89, 2, 70, "Title",
 CellTags->{"S2.5.13", "13.1"},
 CellID->30951],
Cell[2060, 65, 1597, 51, 70, "DefinitionBox",
 CellID->15596],
Cell[3660, 118, 73, 1, 70, "Caption",
 CellID->9527],
Cell[3736, 121, 269, 7, 70, "Text",
 CellID->10807],
Cell[4008, 130, 530, 15, 70, "Text",
 CellID->4287],
Cell[4541, 147, 124, 5, 70, "MathCaption",
 CellID->12027],
Cell[4668, 154, 141, 5, 70, "Input",
 CellID->1920],
Cell[4812, 161, 175, 6, 70, "MathCaption",
 CellID->10805],
Cell[CellGroupData[{
Cell[5012, 171, 103, 3, 28, "Input",
 CellID->11127],
Cell[5118, 176, 309, 10, 39, "Output",
 CellID->24837]
}, Open  ]],
Cell[5442, 189, 704, 20, 70, "Text",
 CellID->29710],
Cell[6149, 211, 884, 27, 70, "Text",
 CellID->16583],
Cell[7036, 240, 157, 5, 70, "MathCaption",
 CellID->9803],
Cell[7196, 247, 359, 13, 70, "Input",
 CellID->15137],
Cell[7558, 262, 99, 2, 70, "MathCaption",
 CellID->29483],
Cell[CellGroupData[{
Cell[7682, 268, 103, 3, 70, "Input",
 CellID->21341],
Cell[7788, 273, 588, 19, 36, "Output",
 CellID->5635]
}, Open  ]],
Cell[8391, 295, 146, 5, 70, "MathCaption",
 CellID->28621],
Cell[CellGroupData[{
Cell[8562, 304, 198, 6, 70, "Input",
 CellID->23277],
Cell[8763, 312, 589, 19, 36, "Output",
 CellID->22278]
}, Open  ]],
Cell[CellGroupData[{
Cell[9389, 336, 72, 1, 70, "RelatedTutorialsSection",
 CellID->152024614],
Cell[9464, 339, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[9694, 348, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

