(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    252116,       7558]
NotebookOptionsPosition[    133956,       4320]
NotebookOutlinePosition[    210962,       6332]
CellTagsIndexPosition[    210170,       6305]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C Language Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkCLanguageFunctions"],
           "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Functions for Exchanging Integers" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingIntegers"], 
          "MathLink C Functions for Exchanging Multidimensional Arrays" :> 
          Documentation`HelpLookup[
           "paclet:guide/\
MathLinkCFunctionsForExchangingMultidimensionalArrays"], 
          "MathLink C Functions for Exchanging Reals" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingReals"], 
          "MathLink C Functions for Exchanging Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingStrings"], 
          "MathLink C Functions for Exchanging Symbols" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingSymbols"], 
          "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"], 
          "MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"], 
          "Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathLink C Language Functions\"\>", 
       2->"\<\"MathLink Connection Management\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       5->"\<\"MathLink C Functions for Exchanging Integers\"\>", 
       6->"\<\"MathLink C Functions for Exchanging Multidimensional \
Arrays\"\>", 7->"\<\"MathLink C Functions for Exchanging Reals\"\>", 
       8->"\<\"MathLink C Functions for Exchanging Strings\"\>", 
       9->"\<\"MathLink C Functions for Exchanging Symbols\"\>", 
       10->"\<\"MathLink Expression Packet Handling\"\>", 
       11->"\<\"MathLink Packets\"\>", 
       12->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Development in C (Windows)"
}], "Title",
 CellTags->"WindowsIntroduction",
 CellID->90],

Cell[TextData[{
 "This document describes how to compile and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs written in the C language on computers running a Microsoft \
Windows operating system. (\"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\" describes how to write ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs in both the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language and the C language.)",
 " ",
 "This document also describes how ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is implemented for Windows."
}], "Text",
 CellTags->"WindowsIntroduction",
 CellID->19725],

Cell[TextData[{
 "This document does not teach you, in general, how to use your compiler and \
other development tools, nor does it teach you how to program in C or \
generally how to use a Windows-based computer. It is assumed that you have at \
least worked through the tutorial introduction that came with your set of \
tools. If you have any trouble building or running your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs, see the troubleshooting ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#15385"],
 " at the end of this document."
}], "Text",
 CellTags->"WindowsIntroduction",
 CellID->14107],

Cell[TextData[{
 "Most of what is described in this document is Windows specific.",
 " ",
 "To learn how to compile and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs for another platform, see the Developer Guide for that platform."
}], "Text",
 CellTags->"WindowsIntroduction",
 CellID->5883],

Cell[CellGroupData[{

Cell["Overview", "Section",
 CellTags->"WindowsOverview",
 CellID->15002],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is implemented as a collection of dynamically linked, shared libraries. \
When a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is launched, the main shared library is found in a standard place \
on disk, loaded by the operating system, and bound to the client ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program so that calls to ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions are directed to code within the shared library. On a computer \
running a 32-bit Windows operating system (2000, XP, Vista), the main shared \
library is called ml32i3.dll and is typically placed in the Windows system \
directory. Any additional shared libraries (such as mlshm32.mlp, \
mltcpip32.mlp, mltcp32.mlp and mlmap32.mlp) are found by ml32i3.dll by \
reading their locations from the configuration file mathlink.ini. If \
mathlink.ini is not present, the additional shared libraries are found by an \
algorithm internal to ml32i3.dll.",
 " ",
 "This configuration file is typically located in the Windows directory."
}], "Text",
 CellTags->"WindowsOverview",
 CellID->17960],

Cell[TextData[{
 "O",
 "n Windows 64 platforms (XP 64, Server 2003, Vista 64), the main shared \
library for 64-bit ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs is ml64i3.dll, and the additional shared libraries are \
mlshm64.mlp, mltcpip64.mlp, and mltcp64.mlp."
}], "Text",
 CellID->235319443],

Cell[TextData[{
 "An import library (a .lib file) is used when a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is built. This import library is added to a project file or \
included in the link command in a makefile. (This import library contains no \
code; it simply exports the same function names as the shared library in \
order to satisfy the linker.)",
 " "
}], "Text",
 CellTags->"WindowsOverview",
 CellID->6968],

Cell[TextData[{
 "The C interface to ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is specified in the header file ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 ".",
 " ",
 "This file is included in any C or C++ source files that call functions in \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " shared library."
}], "Text",
 CellTags->"WindowsOverview",
 CellID->7373],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " shared library ml32i3.dll or ml64i3.dll is needed at the time a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is run and needs to be placed where the Windows operating system \
can find it. The import library and header file are needed at the time a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is built and need to be placed where your compiler and linker can \
find them.",
 " ",
 "The installation and use of these components and others are described in \
more detail below."
}], "Text",
 CellTags->"WindowsOverview",
 CellID->7666]
}, Open  ]],

Cell[CellGroupData[{

Cell["Supported Development Platforms", "Section",
 CellTags->"WindowsCompilers",
 CellID->14658],

Cell[TextData[{
 "As a shared library, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " can be used with any development environment that adheres to the standard \
calling conventions and binary interface for DLLs specified by Microsoft.",
 " ",
 "However, this document only describes how to build C programs that use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " using Microsoft C++ development environment."
}], "Text",
 CellTags->"WindowsCompilers",
 CellID->5140],

Cell["\<\
Each development environment supports the notion of a \
\[OpenCurlyDoubleQuote]project document\[CloseCurlyDoubleQuote] whereby \
source files and options for the compiler, linker and debugger are managed \
using a project window, a collection of dialog boxes and other interactive \
interface elements. In addition to this integrated development environment \
(IDE), all the vendors supply tools that can be run from the command prompt \
or invoked by a make utility.\
\>", "Text",
 CellTags->"WindowsCompilers",
 CellID->26887]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Components"
}], "Section",
 CellTags->"WindowsInstalling",
 CellID->26660],

Cell[TextData[{
 "This section describes how to install the components from the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit so that you can build and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs.",
 " ",
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit is copied to your hard disk when you install ",
 StyleBox["Mathematica. ",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"WindowsInstalling",
 CellID->18916],

Cell[TextData[{
 "The following instructions assume that the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kits for Windows have been installed in the location ",
 StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\\SystemFiles\
\\Links\\MathLink\\DeveloperKit\\", "InlineCode"],
 " by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installer. For Windows there are normally two Developer Kits installed, \
one for 32-bit Windows platforms, in a folder named ",
 StyleBox["Windows", "InlineCode"],
 ", and one for Windows 64 platforms, in a folder named ",
 StyleBox["Windows-x86-64", "InlineCode"],
 ".",
 StyleBox[" ",
  FontSlant->"Italic"],
 "If you have received a Developer Kit as a component separate from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", copy the folder ",
 StyleBox["Windows", "InlineCode",
  FontFamily->"Courier"],
 " or ",
 StyleBox["Windows-x86-64", "InlineCode"],
 " to your hard drive, for example to ",
 StyleBox["C:\\MathLink", "InlineCode"],
 ". In this case, you will need to modify the following installation \
instructions to reflect the location of your Developer Kit."
}], "Text",
 CellTags->"WindowsInstalling",
 CellID->3163],

Cell[CellGroupData[{

Cell["Recommended Installation", "Subsection",
 CellTags->{"Recommended Installation", "WindowsInstalling"},
 CellID->14115],

Cell[CellGroupData[{

Cell["SystemAdditions Installation for All Compilers", "Subsubsection",
 CellTags->{"Recommended Installation", "WindowsInstalling"},
 CellID->366],

Cell[TextData[{
 "If your Developer Kit was installed as part of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then the runtime ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " components have already been installed into your Windows system directory \
by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installer.",
 " ",
 "However, as a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " developer, you should be aware of how to properly install these \
components. "
}], "Text",
 CellTags->{"Recommended Installation", "WindowsInstalling"},
 CellID->1465]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompilerAdditions Installation for Microsoft Compilers", "Subsubsection",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->15232],

Cell[TextData[{
 "Note that the following instructions assume that you have installed \
Microsoft's Visual Studio 2005 in the directory ",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio 8\\VC", "InlineCode"],
 ". This is the default directory for V8.0 of the Developer Studio. For V7.0, \
the default directory is ",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Vc7", 
  "InlineCode"],
 ". For Windows 64",
 " ",
 "systems you will find the default Visual Studio installation in the ",
 StyleBox["C:\\Program Files (x86)\\Microsoft Visual Studio 8\\VC", 
  "InlineCode"],
 "."
}], "Text",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->19874],

Cell[CellGroupData[{

Cell[TextData[{
 "Select the \[OpenCurlyDoubleQuote]Lib\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]Include\[CloseCurlyDoubleQuote], and \
\[OpenCurlyDoubleQuote]Bin\[CloseCurlyDoubleQuote] directories within the \
\[OpenCurlyDoubleQuote]MLDev32\[CloseCurlyDoubleQuote] (on ",
 "Windows 64",
 " systems you will use the \"",
 StyleBox["Windows-x86-64\\CompilerAdditions\\MLDev64", "InlineCode"],
 "\" folder) folder within the CompilerAdditions folder. You can open a \
window containing these folders by running the following command:"
}], "ItemizedText",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->19078],

Cell["\<\
explorer \"C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\\SystemFiles\
\\Links\\MathLink\\DeveloperKit\\Windows\\CompilerAdditions\\MLDev32\"\
\>", "Program",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->4337]
}, Open  ]],

Cell[TextData[{
 "The word ",
 StyleBox["explorer",
  FontFamily->"Helvetica"],
 " is optional but the quotation marks are not."
}], "ItemizedTextParagraph",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->16800],

Cell[TextData[{
 "While holding down the ",
 StyleBox["Ctrl", "KeyEvent"],
 " key, drag and drop these three folders into your ",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio 8\\VC\\PlatformSDK", 
  "InlineCode"],
 " folder (",
 StyleBox["C:\\Program Files (x86)\\Microsoft Visual Studio \
8\\VC\\PlatformSDK", "InlineCode"],
 " on Windows 64 systems)."
}], "ItemizedText",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->12848],

Cell["\<\
Click \[OpenCurlyQuote]Yes\[CloseCurlyQuote] or \[OpenCurlyQuote]Yes to All\
\[CloseCurlyQuote] in any confirmation boxes that appear.\
\>", "ItemizedText",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->27993],

Cell["\<\
This will copy the files from these subdirectories of the \
\[OpenCurlyDoubleQuote]MLDev32\[CloseCurlyDoubleQuote] directory into the \
appropriate subdirectories of your \[OpenCurlyDoubleQuote]PlatformSDK\
\[CloseCurlyDoubleQuote] directory.\
\>", "ItemizedTextParagraph",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->5958],

Cell[TextData[{
 "On ",
 "Windows 64",
 " systems the contents of the \[OpenCurlyDoubleQuote]",
 StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\CompilerAdditions\\MLDev64\\lib", "InlineCode"],
 "\[CloseCurlyDoubleQuote] directory will need to go into the ",
 StyleBox["C:\\Program Files (x86)\\Microsoft Visual Studio \
8\\VC\\PlatformSDK\\Lib\\AMD64", "InlineCode"],
 " folder."
}], "ItemizedTextParagraph",
 CellID->70735498]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Elements of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit"
}], "Subsection",
 CellTags->"WindowsInstalling",
 CellID->19058],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is a layered software system consisting of components that are independent \
of the operating system and components that make direct use of the \
communication mechanisms provided by the operating system."
}], "Text",
 CellTags->"WindowsInstalling",
 CellID->24682],

Cell[TextData[{
 "The primary role of the system-independent component is to encode \
expressions as a string of bytes. This software is implemented in the shared \
library called ml32i3.dll (for 32-bit programs) and in ml64i3.dll (for 64-bit \
programs). The role of the OS-specific component is to transfer the bytes \
from one program to another. There may be several implementations of this \
service.",
 " ",
 "Each implementation is called a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " device and is implemented in a shared library with the .mlp extension."
}], "Text",
 CellTags->"WindowsInstalling",
 CellID->26617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Shared Libraries and Header Files"
}], "Subsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->31065],

Cell[TextData[{
 "The following is a description of each file or directory in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit (MLDK) for Windows. See the section \"",
 ButtonBox["Recommended Installation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#14115"],
 "\" above to install these components. "
}], "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->32706],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit for Windows 64 platform has a similar set of files, with the \
main difference appearing in the file names of the components",
 ". ",
 "Where 32-bit Windows components contain a 32 in the component file name, 64 \
bit versions contain a 64 in the component file name."
}], "Text",
 CellID->466277946],

Cell[CellGroupData[{

Cell["SystemAdditions Directory", "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->25820],

Cell[TextData[{
 "The files in the ",
 StyleBox["SystemAdditions", "InlineCode"],
 " directory are shared libraries which implement ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", and are usually installed into a place where the system can find them \
whenever ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs are executed. (See the section \"",
 ButtonBox["Recommended Installation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#14115"],
 "\" above to install these components.) The six shared libraries needed by \
most ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs are at the top level of this directory. These seven files for \
32-bit Windows are ml32i3.dll, ml32i2.dll, ml32i1.dll, mlshm32.mlp, \
mltcpip32.mlp, mlmap32.mlp, and mltcp32.mlp",
 ". ",
 "The five files for Windows 64 are ml64i3.dll, ml64i2.dll, mlshm64.mlp, \
mltcpip64, and mltcp64.mlp"
}], "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->5312],

Cell[CellGroupData[{

Cell["ml32i3.dll/ml64i3.dll", "Subsubsubsection",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->20204],

Cell[TextData[{
 "This is the shared library used by 32-bit ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Windows (64-bit ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Windows programs use ml64i3.dll) programs that implements Interface 3 of \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " application programming interface (API). It should be placed where the \
operating system's loader will find it when your 32-bit ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is run. (It is not needed to build 32-bit ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs\[LongDash]only to run them.) You could place this file next to \
your built ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program, or in the Windows system directory, or someplace on your PATH. \
See the discussion below for more information and alternative installation \
options. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installer places this file in your Windows system directory and (for the \
convenience of installers and uninstallers) adds a reference to it in the \
system registry under ",
 StyleBox["[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\\
SharedDLLs]", "InlineCode"]
}], "Text",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->19602]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ml32i2.dll/ml64i2.dll\[LineSeparator]ml32i1.dll\
\>", "Subsubsubsection",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->29197],

Cell[TextData[{
 "These shared libraries are similar to \[OpenCurlyDoubleQuote]ML32I3.DLL\
\[CloseCurlyDoubleQuote] but implements Interface 1 and Interface 2 of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API instead of Interface 3. Like \[OpenCurlyDoubleQuote]ML32I3.DLL\
\[CloseCurlyDoubleQuote], it is used by 32-bit V3 ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs. There is no shared library for the Interface 1 implementation \
for ",
 "Windows 64",
 "."
}], "Text",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->32136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Devices"
}], "Subsubsubsection",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->8643],

Cell[TextData[{
 "The following shared libraries appropriate for your operating system should \
be placed where the operating system's loader will find them when your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is run. (They are not needed to build ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs\[LongDash]only to run them.) Typically they are placed next to \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " libraries (any of the above .DLL files) in the Windows system directory.",
 " "
}], "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->29116],

Cell[TextData[{
 "All of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " devices follow a naming scheme that describes what protocol they implement \
and what type of programs may use them. "
}], "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->12306],

Cell[TextData[{
 "All devices and libraries in the SystemAdditions folder should be copied to \
the Windows system directory. On some 32-bit versions of Microsoft Windows, \
the Windows system directory is ",
 StyleBox["C:\\WINDOWS\\SYSTEM", "InlineCode"],
 ", whereas on others versions it is ",
 StyleBox["C:\\WINNT\\SYSTEM32", "InlineCode"],
 " or ",
 StyleBox["C:\\WINDOWS\\SYSTEM32", "InlineCode"],
 "."
}], "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->22978],

Cell[TextData[{
 "On 64-bit systems the device files will need to be copied to the correct \
Windows system folder depending on whether the device libraries are 32-bit or \
64-bit libraries. The 32-bit libraries are located in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " layout at ",
 StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows\\SystemAdditions", "InlineCode"],
 ". The 64 bit device libraries are located in ",
 StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\SystemAdditions", "InlineCode"],
 ".",
 " ",
 "The 32-bit device libraries must go in ",
 StyleBox["C:\\Windows\\SysWOW64", "InlineCode"],
 " and the 64-bit libraries must go ",
 StyleBox["C:\\Windows\\system32", "InlineCode"],
 "."
}], "Text",
 CellID->1208933910],

Cell[TextData[{
 StyleBox["\[WarningSign] ",
  FontSize->24],
 "Some ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " devices, when loaded, in turn load other ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " devices\[LongDash]they will not work on their own. Therefore it is not \
recommended to install only some of the appropriate components",
 "\[LongDash]",
 "you should make all of the appropriate devices available to your operating \
system."
}], "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->32624],

Cell["SharedMemory Device", "Text",
 FontWeight->"Bold",
 FontSlant->"Italic",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->25115],

Cell[TextData[StyleBox["\"MLSHM32.MLP\"/\"MLSHM64.MLP\"", "InlineCode"]], \
"Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->12473],

Cell[TextData[{
 "This is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " device that uses the Win32 memory-mapped file mechanism to transfer data \
between processes. These shared libraries are used when the ",
 Cell[BoxData["\"\<SharedMemory\>\""], "InlineFormula"],
 " protocol is specified when opening a link. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0, it is the default device for local connections."
}], "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->26160],

Cell["For example, a C program that executes:", "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->4678],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"foo\", \
\"-linkprotocol\", \"SharedMemory\", \"-linkmode\", \"connect\"};\nlink = \
MLOpenArgv( stdenv, argv, argv + 6, 0);", "MR"]], "Program",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->22336],

Cell[TextData[{
 "will connect to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that evaluates:"
}], "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->24719],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"LinkOpen", "[", 
   RowBox[{"\"\<foo\>\"", ",", " ", 
    RowBox[{"LinkProtocol", "->", "\"\<SharedMemory\>\""}], ",", " ", 
    RowBox[{"LinkMode", "->", "Listen"}]}], "]"}]}]], "Input",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->24608],

Cell["TCPIP Device", "Text",
 FontWeight->"Bold",
 FontSlant->"Italic",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->25188],

Cell[TextData[StyleBox["\"MLTCPIP32.MLP\"/\"MLTCPIP64.MLP\"", "InlineCode"]], \
"Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->7782],

Cell[TextData[{
 "This is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " device that uses the services of the TCP internet protocol to transfer \
data between processes. These shared libraries are used when the ",
 Cell[BoxData["\"\<TCPIP\>\""], "InlineFormula"],
 " protocol is specified when opening a link. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0, it is the preferred device for remote connections."
}], "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->4321],

Cell["For example, a C program that executes:", "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->14616],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"6000\", \
\"-linkprotocol\", \"TCPIP\", \"-linkmode\", \"connect\"};\nlink = \
MLOpenArgv( stdenv, argv, argv + 6, 0);", "MR"]], "Program",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->10223],

Cell[TextData[{
 "will connect to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that evaluates:"
}], "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->12712],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"LinkOpen", "[", 
   RowBox[{"\"\<6000\>\"", ",", " ", 
    RowBox[{"LinkProtocol", "->", "\"\<TCPIP\>\""}], ",", " ", 
    RowBox[{"LinkMode", "->", "Listen"}]}], "]"}]}]], "Input",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->11186],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkProtocol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkProtocol"], "->", "\"\<TCPIP\>\""}]], 
  "InlineFormula"],
 " can be used to connect ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs running on different computers on a network."
}], "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->27170],

Cell["FileMap Device", "Text",
 FontWeight->"Bold",
 FontSlant->"Italic",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->4766],

Cell[TextData[StyleBox["\"MLMAP32.MLP\"", "InlineCode"]], "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->29042],

Cell[TextData[{
 "This is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " device that uses the Win32 memory-mapped file mechanism to transfer data \
between processes. These shared libraries are used when the ",
 Cell[BoxData["\"\<FileMap\>\""], "InlineFormula"],
 " protocol is specified when opening a link."
}], "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->268],

Cell["For example, a C program that executes:", "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->28458],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"foo\", \
\"-linkprotocol\", \"FileMap\", \"-linkmode\", \"connect\"};\nlink = \
MLOpenArgv( stdenv, argv, argv + 6, 0);", "MR"]], "Program",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->10876],

Cell[TextData[{
 "will connect to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that evaluates:"
}], "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->4662],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"LinkOpen", "[", 
   RowBox[{"\"\<foo\>\"", ",", " ", 
    RowBox[{"LinkProtocol", "->", "\"\<FileMap\>\""}], ",", " ", 
    RowBox[{"LinkMode", "->", "Listen"}]}], "]"}]}]], "Input",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->19946],

Cell[TextData[{
 "These devices are used by default by ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs when no linkprotocol is specified."
}], "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->16981],

Cell[TextData[{
 "Windows 64 does not support the ",
 Cell[BoxData["\"\<FileMap\>\""], "InlineFormula"],
 " protocol."
}], "Text",
 CellID->1209441103],

Cell["TCP Device", "Text",
 FontWeight->"Bold",
 FontSlant->"Italic",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->11753],

Cell[TextData[StyleBox["\"MLTCP32.MLP\"/\"MLTCP64.MLP\"", "InlineCode"]], \
"Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->4704],

Cell[TextData[{
 "This is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " device that uses the services of the TCP internet protocol to transfer \
data between processes. These shared libraries are used when the ",
 Cell[BoxData["\"\<TCP\>\""], "InlineFormula"],
 " protocol is specified when opening a link."
}], "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->10838],

Cell["For example, a C program that executes:", "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->8597],

Cell[TextData[StyleBox["char* argv[] = {\"-linkname\", \"6000\", \
\"-linkprotocol\", \"TCP\", \"-linkmode\", \"connect\"};\nlink = MLOpenArgv( \
stdenv, argv, argv + 6, 0);", "MR"]], "Program",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->4322],

Cell[TextData[{
 "will connect to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that evaluates:"
}], "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->19595],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"LinkOpen", "[", 
   RowBox[{"\"\<6000\>\"", ",", " ", 
    RowBox[{"LinkProtocol", "->", "\"\<TCP\>\""}], ",", " ", 
    RowBox[{"LinkMode", "->", "Listen"}]}], "]"}]}]], "Input",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->8911],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<TCP\>\""], "InlineFormula"],
 " linkprotocol can be used to connect ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs running on different computers on a network."
}], "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->21115],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<TCP\>\""], "InlineFormula"],
 " linkprotocol was deprecated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 and only continues to exist for backwards compatibility. Users of ",
 Cell[BoxData["\"\<TCP\>\""], "InlineFormula"],
 " should convert their code to use ",
 Cell[BoxData["\"\<TCPIP\>\""], "InlineFormula"],
 "."
}], "Text",
 CellID->387]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompilerAdditions Directory", "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->31221],

Cell[CellGroupData[{

Cell["\"MLDev32\\INCLUDE\\\", \"MLDev64\\INCLUDE\"", "Subsubsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->237],

Cell[TextData[Cell[BoxData[
 ButtonBox[
  RowBox[{"mathlink", ".", "h"}],
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"]], "Text",
 CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
 CellID->22604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " is the header file that must be included in your C and C++ source files. \
It should be placed where your compiler can find it. You could place this \
header file in the same directory as your source files that include it, or in \
the same location as the standard header files provided with your development \
tools. Alternatively, you could add the location of ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " to the search path for header files.",
 " ",
 "(This is typically done using command-line switches, an environment \
variable, or a setting in a dialog box.)"
}], "Text",
 CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
 CellID->5578]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"MLDev32\\LIB\\\", \"MLDev64\\LIB\"", "Subsubsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->14640],

Cell[TextData[{
 "This folder contains import libraries that your linker would use to resolve \
references in your code to functions in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " shared library. One of these ",
 StyleBox[".LIB", "InlineCode"],
 " files would be referenced in your project file, makefile, or link \
commandline. Because the format of an import library is not standardized, one \
import library is supplied for each of the most popular development \
environments."
}], "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->1864],

Cell[TextData[StyleBox["\"ML32I3M.LIB\"/\"ML64I3M.LIB\"", "InlineCode"]], \
"Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->20566],

Cell[TextData[{
 "This is the import library for use with the Microsoft C/C++ development \
tools including Microsoft Visual Studio. (It is a COFF import library created \
by the Microsoft linker.) This file should be placed where it will be found \
by the Microsoft linker. To avoid having to specify a path, place this file \
in your ",
 StyleBox["C:\\", "InlineCode"],
 StyleBox["Program Files\\Microsoft Visual Studio 8\\VC\\PlatformSDK\\LIB", 
  "InlineCode"],
 " directory. Place the 64-bit ",
 StyleBox[".LIB", "InlineCode"],
 " file in ",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio 8\\VC\\PlatformSDK\\Lib\
\\AMD64", "InlineCode"],
 " directory."
}], "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->1694]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"MLDev32\\BIN\\\", \"MLDev64\\BIN\"", "Subsubsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->25411],

Cell[TextData[StyleBox["\"MPREP.EXE\"", "InlineCode"]], "Text",
 CellTags->{"mprep", "parts", "WindowsInstalling"},
 CellID->8957],

Cell[TextData[{
 StyleBox["\"MPREP\"", "InlineCode"],
 " is a 32-bit console program that writes ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs automatically by processing \[OpenCurlyDoubleQuote]template\
\[CloseCurlyDoubleQuote] files. It may be convenient to place this file in \
the ",
 StyleBox["\"Bin\"", "InlineCode"],
 " directory of your development tools. On Windows 64, ",
 StyleBox["\"MPREP\"", "InlineCode"],
 " is a 64-bit console program."
}], "Text",
 CellTags->{"mprep", "parts", "WindowsInstalling"},
 CellID->31807]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrebuiltExamples Directory", "Subsubsection",
 CellTags->{"prebuilt", "parts", "WindowsInstalling"},
 CellID->24407],

Cell[TextData[{
 "This folder contains prebuilt versions of the example programs. The ",
 ButtonBox["following section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#25303"],
 " describes how to build them yourself using the source code in the ",
 StyleBox["\"MathLinkExamples\"", "InlineCode"],
 " folder. The ",
 ButtonBox["section after that",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#26613"],
 " describes how to run these programs. "
}], "Text",
 CellTags->{"prebuilt", "parts", "WindowsInstalling"},
 CellID->227]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkExamples Directory", "Subsubsection",
 CellTags->{"parts", "sample code", "WindowsInstalling"},
 CellID->13686],

Cell[TextData[{
 "This folder contains the source code for some very simple ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs.",
 " ",
 "By using this source code, you can learn how to build and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs without having to write any code yourself."
}], "Text",
 CellTags->{"parts", "sample code", "WindowsInstalling"},
 CellID->7943]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extras Directory", "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->5035],

Cell["\<\
This folder contains sample programs and utilities that you may find useful.\
\>", "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->3112]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alternative Components Directory", "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->8231],

Cell[TextData[StyleBox["\"DebugLibraries\"", "InlineCode"]], "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->17049],

Cell[TextData[{
 "This is a copy of ",
 StyleBox["\"MathLinkLibraries\"", "InlineCode"],
 " that does extensive error checking and logs information that may be \
useful. See the \"",
 ButtonBox["Troubleshooting",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#15385"],
 "\" section below for a description of how to use this library."
}], "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->1206]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "Section",
 CellTags->"WindowsBuilding",
 CellID->25303],

Cell[TextData[{
 "The general procedure for building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs is to include ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " in any C or C++ source files that make ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " function calls, to compile your source files, and then to link the \
resulting object code with the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " import library and any other standard libraries required by your \
application. If your application uses the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template mechanism, then your template files must first be processed into \
a C source file using ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 ".",
 " ",
 "The details for several popular development environments are provided \
below."
}], "Text",
 CellTags->"WindowsBuilding",
 CellID->30323],

Cell[TextData[{
 "The build instructions below assume you have followed the recommended \
installation instructions for the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " compiler additions.",
 " ",
 "If you have placed the compiler additions elsewhere on your hard disk, you \
may need to modify the instructions below by setting environment variables, \
specifying additional command-line arguments, or specifying full pathnames \
when referring to the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " compiler additions."
}], "Text",
 CellTags->"WindowsBuilding",
 CellID->18001],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink ",
  FontSlant->"Italic"],
 "Versioning"
}], "Subsection",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->17041],

Cell[TextData[{
 "As a shared library, each revision of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " must maintain compatibility with previous revisions. Yet, at times, new \
functionality needs to be added.",
 " ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " adopts a simple versioning strategy that can be adapted to many \
compile-time and run-time environments."
}], "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->9845],

Cell[CellGroupData[{

Cell["Strategy", "Subsubsection",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->23630],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " evolves by improving its implementation and by improving its interface.",
 " ",
 "The values of ",
 StyleBox["MLREVISION", "InlineCode"],
 " or ",
 StyleBox["MLINTERFACE", "InlineCode"],
 " defined in ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " are incremented whenever an improvement is made and released."
}], "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->5094],

Cell[TextData[{
 StyleBox["MLREVISION", "InlineCode"],
 " is the current revision number. It is incremented every time a change is \
made to the source and ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is rebuilt and distributed on any platform.",
 " ",
 "(Bug fixes, optimizations, or other improvements transparent to the \
interface increment only this number.)"
}], "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->10400],

Cell[TextData[{
 StyleBox["MLINTERFACE", "InlineCode"],
 " is a name for a documented interface to ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". This number is incremented whenever a named constant or function is \
added, removed, or its behavior is changed in a way that could break existing \
correct client programs. It is expected that the interface to ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will be improved over time so that implementations of higher numbered \
interfaces are more complete or more convenient to use for writing effective \
client programs.",
 " ",
 "In particular, a specific interface provides all the useful functionality \
of an earlier interface."
}], "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->8993],

Cell[TextData[{
 "For Windows, the different interfaces of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " libraries are implemented in different shared libraries. The file \
\[OpenCurlyDoubleQuote]ml32i1.dll\[CloseCurlyDoubleQuote] contains the \
implementation of interface 1 of the latest ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " revision, the file \[OpenCurlyDoubleQuote]ml32i2.dll\
\[CloseCurlyDoubleQuote] contains the implementation of interface 2, and the \
file \[OpenCurlyDoubleQuote]ml32i3.dll\[CloseCurlyDoubleQuote] contains the \
implementation of interface 3.",
 " ",
 "You need only keep the latest revision (as shown in the Properties box for \
the shared library) of these files in your Windows system folder to run any \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program."
}], "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->12038],

Cell[TextData[{
 "In addition, each ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " interface has a separate import library to link against so that developers \
make a conscious decision as to which interface they require at compile time. \
So, for example, a developer using Microsoft's Visual Studio who needs \
functionality that was added for interface 3 must link with \
\[OpenCurlyDoubleQuote]ml32i3m.lib\[CloseCurlyDoubleQuote] rather than \
\[OpenCurlyDoubleQuote]ml32i2m.lib\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]ml32i1m.lib\[CloseCurlyDoubleQuote].",
 " "
}], "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->3561]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Template Files"
}], "Subsection",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->4205],

Cell[TextData[{
 "If your program uses the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template mechanism as described in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\", you must preprocess your source files that contain template entries \
using the ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " console program. A template entry is a sequence of lines that contain \
template keywords. (Each entry defines a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that when evaluated calls an associated C function.) When ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " processes such source files, it converts template entries into C \
functions, passes other text through unmodified, and writes out additional C \
functions that implement a remote procedure call mechanism using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ".",
 " ",
 "The result is a C source file that is ready for compilation."
}], "Text",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->6900],

Cell["For example, the command:", "Text",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->4732],

Cell[TextData[{
 StyleBox["mprep", "MR"],
 " ",
 StyleBox["addtwo.tm", "MR"],
 " ",
 StyleBox["-o addtwotm.c", "MR"]
}], "Program",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->11456],

Cell["\<\
will produce a C source file \[OpenCurlyDoubleQuote]addtwotm.c\
\[CloseCurlyDoubleQuote] from the template entries and other text in \
\[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote]. You would then \
compile the output file using the C compiler. If you use the \
\[OpenCurlyDoubleQuote]Make\[CloseCurlyDoubleQuote] utility to build your \
program, you could add a rule similar to the following one to your makefile.\
\>", "Text",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->18636],

Cell[TextData[{
 StyleBox["addtwotm.c", "MR"],
 " ",
 StyleBox[":", "MR"],
 " ",
 StyleBox["addtwo.tm\n", "MR"],
 "  ",
 StyleBox["mprep", "MR"],
 " ",
 StyleBox["addtwo.tm", "MR"],
 " ",
 StyleBox["-o addtwotm.c", "MR"]
}], "Program",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->11210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs with Microsoft Visual Studio"
}], "Subsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13917],

Cell[CellGroupData[{

Cell["Using the command-line tools", "Subsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->12593],

Cell[TextData[{
 "In order to use the command-line tools from a command window, you must run \
the batch file ",
 StyleBox["VCVARSALL.BAT", "InlineCode"],
 " to configure the environment. You can find the file in ",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio 8\\VC\\VCVARSALL.BAT", 
  "InlineCode"],
 ". Alternatively, you can use the shortcut provided in ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 Command Prompt", "MenuName"],
 ". ",
 StyleBox["VCVARSALL.BAT", "InlineCode"],
 " takes an argument to indicate which set of compiler tools the environment \
should use. For 32-bit Windows development use: ",
 StyleBox["VCVARSALL.BAT x86", "InlineCode"],
 ". For Windows 64 development use: ",
 StyleBox["VCVARSALL.BAT amd64", "InlineCode"],
 ". Alternatively on Windows 64 machines you can use the shortcut provided in \
",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 x64 Win64 Command Prompt", 
  "MenuName"],
 ". ",
 StyleBox["VCVARSALL.BAT", "InlineCode"],
 " will correctly configure the ",
 StyleBox["PATH", "InlineCode"],
 ", ",
 StyleBox["INCLUDE", "InlineCode"],
 ", and ",
 StyleBox["LIB", "InlineCode"],
 " environment variables so that you can use the Microsoft Compiler tools \
from your command-line environment."
}], "Text",
 CellID->661921821],

Cell[CellGroupData[{

Cell[TextData[{
 "Building a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program to be called by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel"
}], "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15467],

Cell["To build the ADDTWO.EXE example program", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15605],

Cell[TextData[{
 "Start a command prompt window by running ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 Command Prompt", "MenuName"],
 " (On Windows 64 use ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 x64 Win64 Command Prompt", 
  "MenuName"],
 ")."
}], "ItemizedText",
 CellID->764827484],

Cell[CellGroupData[{

Cell["\<\
Change to the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] directory \
within the \[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] \
directory.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22383],

Cell[TextData[{
 StyleBox["C:\ncd \"C:\\Program Files\\Wolfram Research\\Mathematica\\", 
  "MR"],
 "6.0",
 StyleBox["\\\"\ncd \
SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\addtwo\
\\", "MR"]
}], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->24653]
}, Open  ]],

Cell[CellGroupData[{

Cell["On Windows 64 use the following commands:", "ItemizedTextParagraph",
 CellID->1765896293],

Cell["\<\
C:
cd \"C:\\Program Files (x86)\\Wolfram Research\\Mathematica\\6.0\\\"
cd SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows-x86-64\\\
MathLinkExamples\\addtwo\\\
\>", "Program",
 CellID->1194994911]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type the following five commands.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1439],

Cell[TextData[{
 StyleBox["SET CL=/nologo /c /DWIN32 /D_WINDOWS /W3 /O2 /DNDEBUG\nSET \
LINK=/NOLOGO /SUBSYSTEM:windows /INCREMENTAL:no /PDB:NONE", "MR"],
 " ",
 StyleBox["kernel32.lib user32.lib gdi32.lib\nMPREP addtwo.tm -o addtwotm.c\n\
CL addtwo.c addtwotm.c\nLINK", "MR"],
 " ",
 StyleBox["addtwo.obj addtwotm.obj ml32i3m.lib /OUT:addtwo.exe", "MR"]
}], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4826]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
On Windows 64 use the following command in place of the last command.\
\>", "ItemizedTextParagraph",
 CellID->1012402433],

Cell["LINK addtwo.obj addtwotm.obj ml64i3m.lib /OUT:addtwo.exe", "Program",
 CellID->934756250]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program that calls the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel"
}], "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31942],

Cell["To build the FACTOR.EXE example program", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11929],

Cell[TextData[{
 "Start a command prompt window by running ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 Command Prompt", "MenuName"],
 " (On Windows 64 use ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 x64 Win64 Command Prompt", 
  "MenuName"],
 ")."
}], "ItemizedText",
 CellID->185955467],

Cell[CellGroupData[{

Cell["\<\
Change to the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] directory \
within the \[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] \
directory.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3527],

Cell[TextData[{
 StyleBox["C:\ncd \"C:\\Program Files\\Wolfram Research\\Mathematica\\", 
  "MR"],
 "5.1",
 StyleBox["\\\"\ncd AddOns\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\
\\factor\\", "MR"]
}], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->28540]
}, Open  ]],

Cell[CellGroupData[{

Cell["On Windows 64 use the following commands:", "ItemizedTextParagraph",
 CellID->1605415945],

Cell["\<\
C:
cd \"C:\\Program Files (x86)\\Wolfram Research\\Mathematica\\6.0\\\"
cd SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows-x86-64\\\
MathLinkExamples\\factor\\\
\>", "Program",
 CellID->1241246707]
}, Open  ]],

Cell[CellGroupData[{

Cell["Type the following four commands.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13886],

Cell[TextData[{
 StyleBox["SET CL=/nologo /c /DWIN32 /D_CONSOLE /W3 /O2 /DNDEBUG\nSET \
LINK=/NOLOGO /SUBSYSTEM:console /INCREMENTAL:no /PDB:NONE kernel32.lib \
user32.lib\nCL", "MR"],
 " ",
 StyleBox["factor.c\nLINK factor.obj ml32i2m.lib /OUT:factor.exe", "MR"]
}], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18443]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
On Windows 64 use the following command in place of the last command.\
\>", "ItemizedTextParagraph",
 CellID->977257591],

Cell["LINK factor.obj ml64i3m.lib /OUT:factor.exe", "Program",
 CellID->813399681]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Debugging a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Program called from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel"
}], "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->23792],

Cell["To build a debug version of ADDTWO.EXE", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22910],

Cell[CellGroupData[{

Cell[TextData[{
 "Follow steps 1-3 in \"",
 ButtonBox["Building a ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#15467"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#15467"],
  FontSlant->"Italic"],
 ButtonBox[" program to be called by the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#15467"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#15467"],
  FontSlant->"Italic"],
 ButtonBox[" Kernel",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#15467"],
 "\", replacing the commands in step 3 with the following."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17889],

Cell[TextData[{
 StyleBox["SET CL=/nologo /c /DWIN32 /D_WINDOWS /W3 /Z7 /Od /D_DEBUG\nSET \
LINK=/NOLOGO /SUBSYSTEM:windows /DEBUG /PDB:NONE /INCREMENTAL:no", "MR"],
 " ",
 StyleBox["kernel32.lib user32.lib gdi32.lib\nMPREP addtwo.tm -o addtwotm.c\n\
CL addtwo.c addtwotm.c\nLINK addtwo.obj addtwotm.obj ml32i3m.lib \
/OUT:addtwo.exe", "MR"]
}], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->12069]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
On Windows 64 use the following command in place of the last command.\
\>", "ItemizedTextParagraph",
 CellID->1126698308],

Cell["LINK addtwo.obj addtwotm.obj ml64i3m.lib /OUT:addtwo.exe", "Program",
 CellID->2055146957]
}, Open  ]],

Cell["To debug ADDTWO.EXE ", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31391],

Cell["Start Microsoft Visual Studio.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->16139],

Cell[TextData[{
 "From the ",
 StyleBox["File", "MenuName"],
 " menu, choose ",
 StyleBox["Open \[FilledRightTriangle] Project/Solution", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1835],

Cell["The Open Solution dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4306],

Cell["\<\
Select Executable Files from the \[OpenCurlyDoubleQuote]Files of type\
\[CloseCurlyDoubleQuote] drop-down list to display .EXE files in the File \
Name list.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->10039],

Cell["Select the drive and directory containing ADDTWO.EXE.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32173],

Cell["Select ADDTWO.EXE and click the Open button.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->21069],

Cell[TextData[{
 "To start debugging, press ",
 StyleBox["F5", "KeyEvent"],
 " or choose the \[OpenCurlyDoubleQuote]Start Debugging\
\[CloseCurlyDoubleQuote] command under the ",
 StyleBox["Debug", "MenuName"],
 " menu."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7573],

Cell["\<\
When you are done debugging and close the project solution, you will be asked \
if you want to save the new solution associated with ADDTWO.EXE. Choose OK if \
you want to retain your breakpoints and other debugger settings.\
\>", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11444]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Debugging a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program that calls the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel"
}], "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1827],

Cell["To build a debug version of FACTOR.EXE", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4195],

Cell[CellGroupData[{

Cell[TextData[{
 "Follow steps 1-3 in \"",
 ButtonBox["Building a ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#31942"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#31942"],
  FontSlant->"Italic"],
 ButtonBox[" program that calls the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#31942"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#31942"],
  FontSlant->"Italic"],
 ButtonBox[" Kernel",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#31942"],
 "\", replacing the commands in step 3 with the following."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4316],

Cell[TextData[StyleBox["SET CL=/nologo /c /DWIN32 /D_CONSOLE /W3 /Z7 /Od \
/D_DEBUG\nSET LINK=/NOLOGO /SUBSYSTEM:console /INCREMENTAL:no /PDB:NONE \
/DEBUG kernel32.lib user32.lib\nCL factor.c\nLINK factor.obj ml32i3m.lib \
/OUT:factor.exe", "MR"]], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->29007]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
On Windows 64 use the following command in place of the last command.\
\>", "ItemizedTextParagraph",
 CellID->1050915969],

Cell["LINK factor.obj ml64i3m.lib /OUT:factor.exe", "Program",
 CellID->1839178055],

Cell["To debug FACTOR.EXE ", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3022]
}, Open  ]],

Cell["Start Microsoft Visual Studio.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->16764],

Cell[TextData[{
 "From the ",
 StyleBox["File", "MenuName"],
 " menu, choose ",
 StyleBox["Open \[FilledRightTriangle] Project/Solution", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9948],

Cell["The Open Solution dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->25008],

Cell["\<\
Select Executable Files from the \[OpenCurlyDoubleQuote]Files of type\
\[CloseCurlyDoubleQuote] drop-down list to display .EXE files in the File \
Name list.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13772],

Cell["Select the drive and directory containing FACTOR.EXE.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7008],

Cell["Select FACTOR.EXE and click the Open button.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13790],

Cell[TextData[{
 "From the ",
 StyleBox["Project", "MenuName"],
 " menu, choose ",
 StyleBox["Properties", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->29157],

Cell["The Project Settings dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->5047],

Cell["Click the Debugging item under Configuration Properties.", \
"ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->831],

Cell["The Debug Settings page appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->29086],

Cell[TextData[{
 "In the Command Arguments textbox, type: ",
 StyleBox["-linklaunch", "InlineCode"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31696],

Cell["Click the OK button.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30906],

Cell[TextData[{
 "To start debugging, press ",
 StyleBox["F5", "KeyEvent"],
 " or choose the \[OpenCurlyDoubleQuote]Start Debugging\
\[CloseCurlyDoubleQuote] command under the ",
 StyleBox["Debug", "MenuName"],
 " menu."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7467],

Cell[TextData[{
 "When ",
 Cell[TextData[ButtonBox["MLOpenArgcArgv()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineCode"],
 " is executed, the Choose a MathLink Program to Launch dialog box appears.",
 " ",
 "Open \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MathKernel", ".", "exe"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/MathKernel"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote]."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->21814],

Cell["\<\
When you are done debugging and close the project solution, you will be asked \
if you want to save the new solution associated with FACTOR.EXE. Choose OK if \
you want to retain your breakpoints and other debugger settings.\
\>", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->6190]
}, Open  ]],

Cell[CellGroupData[{

Cell["Short summary of Compiler switches", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9047],

Cell[BoxData[GridBox[{
   {Cell["Switch", "TableHeader"], Cell["Action", "TableHeader"]},
   {
    RowBox[{"/", "nologo"}], Cell[
    "don't display the copyright notice", "TableText"]},
   {
    RowBox[{"/", "W3"}], Cell["display extended warnings", "TableText"]},
   {
    RowBox[{"/", "Z7"}], Cell[
    "store debugging information in the object files", "TableText"]},
   {
    RowBox[{"/", "Zi"}], Cell["\<\
store debugging information in a separate project database file\
\>", "TableText"]},
   {
    RowBox[{"/", 
     RowBox[{"Fdaddtwo", ".", "pdb"}]}], Cell[TextData[{
     "specify name of the project database file\[LongDash]used with ",
     StyleBox["/Zi", "InlineCode"]
    }], "TableText"]},
   {
    RowBox[{"/", "Od"}], Cell[
    "turn off optimization (default)", "TableText"]},
   {
    RowBox[{"/", "O2"}], Cell[
    "optimizer prefers faster code over smaller code", "TableText"]},
   {
    RowBox[{"/", "D"}], Cell[TextData[{
     "defines used by some standard header files and ",
     Cell[BoxData[
      ButtonBox[
       RowBox[{"mathlink", ".", "h"}],
       BaseStyle->"Link",
       ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"/", "c"}], Cell["compile only without linking", "TableText"]},
   {
    RowBox[{"@", "filename"}], Cell[
    "read more command-line arguments from the file", "TableText"]},
   {"CFLAGS", Cell[
    "environment variable containing more command-line arguments", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.75]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22153]
}, Open  ]],

Cell[CellGroupData[{

Cell["Short summary of Linker switches", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18470],

Cell[BoxData[GridBox[{
   {Cell["Switch", "TableHeader"], Cell["Action", "TableHeader"]},
   {
    RowBox[{"/", "NOLOGO"}], Cell[
    "don't display the copyright notice", "TableText"]},
   {
    RowBox[{"/", "DEBUG"}], Cell["\<\
store debugging information into the executable or project database\
\>", "TableText"]},
   {
    RowBox[{"/", 
     RowBox[{"PDB", ":", "NONE"}]}], Cell[TextData[{
     "store debugging information in the executable\[LongDash]used with ",
     StyleBox["/DEBUG", "InlineCode"]
    }], "TableText"]},
   {
    RowBox[{"/", 
     RowBox[{"PDB", ":", 
      RowBox[{"addtwo", ".", "pdb"}]}]}], Cell[
    "override the default name for the project database", "TableText"]},
   {
    RowBox[{"/", 
     RowBox[{"OUT", ":", 
      RowBox[{"addtwo", ".", "exe"}]}]}], Cell[
    "name the output file", "TableText"]},
   {
    RowBox[{"/", 
     RowBox[{"INCREMENTAL", ":", "no"}]}], Cell[
    "links more slowly but keeps things smaller and neater", "TableText"]},
   {
    RowBox[{"/", 
     RowBox[{"SUBSYSTEM", ":", "windows"}]}], Cell[TextData[{
     "the application doesn't need a console because it creates its own \
windows (default when ",
     StyleBox["WinMain()", "InlineCode"],
     " is defined"
    }], "TableText"]},
   {
    RowBox[{"/", 
     RowBox[{"SUBSYSTEM", ":", "console"}]}], Cell[TextData[{
     "a console is provided (default when ",
     StyleBox["main()", "InlineCode"],
     " is defined)"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.75]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->610]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard system Libraries", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->21605],

Cell[BoxData[GridBox[{
   {Cell["Import library", "TableHeader"], Cell[
    "Base system services", "TableHeader"]},
   {
    RowBox[{"kernel32", ".", "lib"}], Cell["\<\
base OS support such as the file system, interprocess communication, process \
control, memory, and the console\
\>", "TableText"]},
   {
    RowBox[{"advapi32", ".", "lib"}], Cell[
    "support for security and Registry calls", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.75]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4709],

Cell["", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22971],

Cell[BoxData[GridBox[{
   {Cell["Import library", "TableHeader"], Cell[
    "GUI system services", "TableHeader"]},
   {
    RowBox[{"user32", ".", "lib"}], Cell["\<\
support for user interface elements such as windows, messages, menus, \
controls, and dialog boxes \
\>", "TableText"]},
   {
    RowBox[{"gdi32", ".", "lib"}], Cell[
    "support for drawing text and graphics", "TableText"]},
   {
    RowBox[{"winspool", ".", "lib"}], Cell[
    "support for printing and print jobs", "TableText"]},
   {
    RowBox[{"comdlg32", ".", "lib"}], Cell["\<\
support for the common dialogs such as those for opening and saving files and \
printing\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.75]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26471],

Cell["", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7242],

Cell[BoxData[GridBox[{
   {Cell["Import library", "TableHeader"], Cell[
    "Shell system services", "TableHeader"]},
   {
    RowBox[{"shell32", ".", "lib"}], Cell["\<\
support for drag and drop, associations between executables and filename \
extensions, and icon extraction from executables\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.75]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->2332],

Cell["", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->28842],

Cell[BoxData[GridBox[{
   {Cell["Import library", "TableHeader"], Cell[
    "OLE system services", "TableHeader"]},
   {
    RowBox[{"ole32", ".", "lib"}], Cell["support OLE v2 .1", "TableText"]},
   {
    RowBox[{"oleaut32", ".", "lib"}], Cell[
    "support for OLE automation", "TableText"]},
   {
    RowBox[{"uuid", ".", "lib"}], Cell["\<\
support for universally unique identifiers used in OLE and RPC (static \
library)\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.75]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32420],

Cell["", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->659339814],

Cell[BoxData[GridBox[{
   {Cell["Import library", "TableHeader"], Cell[
    "Database system services", "TableHeader"]},
   {
    RowBox[{"odbc32", ".", "lib"}], Cell[
    "access to database management systems through ODBC", "TableText"]},
   {
    RowBox[{"odbccp32", ".", "lib"}], Cell[
    "ODBC setup and administration", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.75]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30881],

Cell["", "Text",
 CellID->258979291]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using the program build utility NMAKE", "Subsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31718],

Cell[TextData[{
 StyleBox["NMAKE", "InlineCode"],
 " is a utility provided with Microsoft's development tools that manages the \
process of building programs. ",
 StyleBox["NMAKE", "InlineCode"],
 " reads a makefile which describes the dependencies and commands required to \
build and rebuild one or more programs. ",
 StyleBox["NMAKE", "InlineCode"],
 " rebuilds any components that have become out of date when one or more \
prerequisite files have been updated. This document does not describe ",
 StyleBox["NMAKE", "InlineCode"],
 " or makefiles in detail. A simple makefile is provided below that \
illustrates how the build commands listed above can be automatically executed \
by simply typing ",
 StyleBox["NMAKE", "InlineCode"],
 " at a command prompt. To learn more about ",
 StyleBox["NMAKE", "InlineCode"],
 ", its general and powerful mechanisms and how to use macros or special \
forms, see the ",
 StyleBox["NMAKE", "InlineCode"],
 " Reference in your \[OpenCurlyDoubleQuote]Microsoft Visual Studio Guide\
\[CloseCurlyDoubleQuote]."
}], "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->16588],

Cell[CellGroupData[{

Cell["\<\
Using a makefile to build a template program that uses the WIN32 API\
\>", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->5351],

Cell[TextData[{
 "To build ADDTWO.EXE using the ",
 StyleBox["NMAKE", "InlineCode"],
 " utility."
}], "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17252],

Cell[CellGroupData[{

Cell["\<\
Using a text editor, create a file containing the following text.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15857],

Cell[TextData[{
 StyleBox["# addtwo.mak", "MR"],
 " ",
 StyleBox["a makefile for building the addtwo.exe example program\n\nCFLAGS = \
/nologo /c /W3 /Z7 /Od /DWIN32 /D_DEBUG /D_WINDOWS\n\n# Linking against \
gdi32.lib for access to windowing mechanisms\nLFLAGS = /DEBUG /PDB:NONE \
/NOLOGO /SUBSYSTEM:windows /INCREMENTAL:no", "MR"],
 " ",
 StyleBox["kernel32.lib user32.lib gdi32.lib\n\n# Uncomment the value below \
for working on a ", "MR"],
 "Windows 64",
 StyleBox[" system\n# PLATFORM = WIN64\nPLATFORM = WIN32\n\n!if \"$(PLATFORM)\
\" == \"WIN32\"\nLIBFILE = ml32i3m.lib\n!else\nLIBFILE = ml64i3m.lib\n!endif\n\
\naddtwo.exe : addtwo.obj addtwotm.obj\n", "MR"],
 "  ",
 StyleBox["LINK addtwo.obj addtwotm.obj $(LIBFILE) /OUT:addtwo.exe @<<\n\
$(LFLAGS)\n<<\n\naddtwo.obj : addtwo.c\n", "MR"],
 "  ",
 StyleBox["CL", "MR"],
 " ",
 StyleBox["@<< addtwo.c\n$(CFLAGS)\n<<\n\naddtwotm.obj : addtwotm.c\n", 
  "MR"],
 "  ",
 StyleBox["CL @<< addtwotm.c\n$(CFLAGS)\n<<\n\n# Need to call mprep to \
preprocess MathLink template\naddtwotm.c : addtwo.tm\n", "MR"],
 "  ",
 StyleBox["mprep addtwo.tm -o addtwotm.c", "MR"]
}], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26865]
}, Open  ]],

Cell["\<\
Save the file as \[OpenCurlyDoubleQuote]addtwo.mak\[CloseCurlyDoubleQuote] in \
the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] directory within \
the \[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] \
directory.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->20975],

Cell[TextData[{
 "Start a command prompt window by running ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 Command Prompt", "MenuName"],
 " (On Windows 64 use ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 x64 Win64 Command Prompt", 
  "MenuName"],
 ")."
}], "ItemizedText",
 CellID->75896897],

Cell["\<\
Change to the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] \
directory.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11351],

Cell[CellGroupData[{

Cell["Type the following command.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26102],

Cell[TextData[StyleBox["NMAKE /f addtwo.mak", "MR"]], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->5750],

Cell["\<\
Makefiles consist of a collection of build rules, macros and other special \
forms.\
\>", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11788],

Cell[TextData[{
 "A build rule consists of a target file, followed by a colon, followed by a \
list of the target's prerequisite files (which must either exist or can be \
built by other build rules in the makefile), followed by one or more indented \
lines containing the commands required to build the target from its \
prerequisites. For example, the makefile above states that the file \
\[OpenCurlyDoubleQuote]addtwotm.c\[CloseCurlyDoubleQuote] depends on \
\[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote] and should be \
rebuilt any time \[OpenCurlyDoubleQuote]addtwo.tm\[CloseCurlyDoubleQuote] is \
modified.",
 " ",
 "The build command ",
 StyleBox["mprep addtwo.tm -o addtwotm.c", "InlineCode"],
 " is used to rebuild the target \[OpenCurlyDoubleQuote]addtwotm.c\
\[CloseCurlyDoubleQuote]."
}], "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26747],

Cell[TextData[{
 "Macros are named strings of text that can be inserted into the makefile \
using the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["notation", "TR"], " ", "$", 
   RowBox[{"(", 
    StyleBox["name", "TI"], ")"}]}]], "InlineFormula"],
 ". For example, in this makefile, ",
 StyleBox["$(CFLAGS)", "InlineCode"],
 " is expanded by ",
 StyleBox["NMAKE", "InlineCode"],
 " wherever it appears into the string ",
 StyleBox["/nologo /c /W3 /Z7 /Od /DWIN32 /D_DEBUG /D_WINDOWS", 
  "InlineCode"],
 "."
}], "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->72],

Cell[TextData[{
 "You might expect that the command to compile \
\[OpenCurlyDoubleQuote]addtwo.c\[CloseCurlyDoubleQuote] would appear in the \
makefile simply as ",
 StyleBox["CL $(CFLAGS) addtwo.c", "InlineCode"],
 ". However it would then be possible for you to edit the definition of ",
 StyleBox["CFLAGS", "InlineCode"],
 " so that the resulting compiler command exceeds the maximum allowable \
length of a commandline. Because commandlines are restricted in length, \
command-line tools often provide a mechanism to read command-line arguments \
from so-called response files. The syntax is generally ",
 Cell[BoxData[
  RowBox[{"@", 
   StyleBox["responsefile", "TI"]}]], "InlineFormula"],
 StyleBox[".",
  FontSlant->"Italic"],
 " This mechanism is used above along with ",
 StyleBox["NMAKE", "InlineCode"],
 "'s ability to produce temporary files using the following special form.\n",
 StyleBox["<<", "InlineCode"],
 "\n",
 StyleBox["text to put in temporary file\n",
  FontSlant->"Italic"],
 StyleBox["<<", "InlineCode"]
}], "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using a makefile to build a console program", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31219],

Cell[TextData[{
 "To build FACTOR.EXE using the ",
 StyleBox["NMAKE", "InlineCode"],
 " utility."
}], "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13717],

Cell[CellGroupData[{

Cell["\<\
Using a text editor, create a file containing the following text.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1993],

Cell[TextData[{
 StyleBox["# factor.mak", "MR"],
 " ",
 StyleBox["a makefile for building the factor.exe example program\n# This \
makefile builds a console program\n\nCFLAGS = /nologo /c /MLd /W3 /Z7 /Od \
/DWIN32 /D_DEBUG /D_CONSOLE\nLFLAGS = /DEBUG /PDB:NONE /NOLOGO \
/SUBSYSTEM:console /INCREMENTAL:no", "MR"],
 " ",
 StyleBox["kernel32.lib user32.lib\n\n# Uncomment the value below for working \
on a ", "MR"],
 "Windows 64",
 StyleBox[" system\n# PLATFORM = WIN64\nPLATFORM = WIN32\n\n!if \"$(PLATFORM)\
\" == \"WIN32\"\nLIBFILE = ml32i3m.lib\n!else\nLIBFILE = ml64i3m.lib\n!endif\n\
\nfactor.exe : factor.obj\n", "MR"],
 "  ",
 StyleBox["LINK factor.obj", "MR"],
 " ",
 StyleBox["$(LIBFILE) /OUT:factor.exe @<<\n$(LFLAGS)\n<<\n\nfactor.obj : \
factor.c\n", "MR"],
 "  ",
 StyleBox["CL", "MR"],
 " ",
 StyleBox["@<< factor.c\n$(CFLAGS)\n<<", "MR"]
}], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->23760]
}, Open  ]],

Cell["\<\
Save the file as \[OpenCurlyDoubleQuote]factor.mak\[CloseCurlyDoubleQuote] in \
the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] directory within \
the \[OpenCurlyDoubleQuote]MathLinkExamples\[CloseCurlyDoubleQuote] \
directory.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->10756],

Cell[TextData[{
 "Start a command prompt window by running ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 Command Prompt", "MenuName"],
 " (On Windows 64 use ",
 StyleBox["Start \[FilledRightTriangle] All Programs \[FilledRightTriangle] \
Microsoft Visual Studio 2005 \[FilledRightTriangle] Visual Studio Tools \
\[FilledRightTriangle] Visual Studio 2005 x64 Win64 Command Prompt", 
  "MenuName"],
 ")."
}], "ItemizedText",
 CellID->2141345208],

Cell["\<\
Change to the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
directory.\
\>", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7693],

Cell[CellGroupData[{

Cell["Type the following two commands.", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31199],

Cell[TextData[StyleBox["NMAKE /f factor.mak", "MR"]], "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17032]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Using the integrated development environment, Visual Studio 2005\
\>", "Subsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18849],

Cell[CellGroupData[{

Cell["Steps common to all projects", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->28873],

Cell[TextData[{
 "Steps required to use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " with Microsoft Visual Studio 2005"
}], "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->2057954430],

Cell[TextData[{
 "Copy ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " from the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit to the Microsoft Visual Studio 2005 Include directory."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->668486428],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->455532002],

Cell[TextData[{
 "Developer kit path 32-bit Windows: ",
 StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\\SystemFiles\
\\Links\\MathLink\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\\
include", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->992523500],

Cell[TextData[{
 "Visual Studio 2005 Include directory 32-bit Windows: ",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio \
8\\VC\\PlatformSDK\\Include", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->1836978251],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->347156059],

Cell[TextData[{
 "Developer kit path ",
 "Windows 64",
 ": ",
 StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\CompilerAdditions\\mldev64\\include", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->1868555285],

Cell[TextData[{
 "Visual Studio 2005 Include directory ",
 "Windows 64",
 ": ",
 StyleBox["C:\\Program Files (x86)\\Microsoft Visual Studio \
8\\VC\\PlatformSDK\\Include", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->7821267],

Cell[TextData[{
 "Copy the ",
 StyleBox[".lib", "InlineCode"],
 " files to the Microsoft Visual Studio Lib directory"
}], "ItemizedText",
 CellID->306759350],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->1593379077],

Cell[TextData[{
 "Copy ",
 StyleBox["ml32i1m.lib", "InlineCode"],
 ",",
 StyleBox[" ml32i2m.lib", "InlineCode"],
 ", and",
 StyleBox[" ml32i3m.lib ", "InlineCode"],
 "from:\n",
 StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\\SystemFiles\
\\Links\\MathLink\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\lib\n", 
  "InlineCode"],
 "to:\n",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio \
8\\VC\\PlatformSDK\\Lib", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->893907885],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->801069049],

Cell[TextData[{
 "Copy ",
 StyleBox["ml64i2m.lib", "InlineCode"],
 ",",
 StyleBox[" and ml64i3m.lib ", "InlineCode"],
 "from:\n",
 StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\AddOns\\MathLink\\DeveloperKit\\Windows-x86-64\\\
CompilerAdditions\\mldev64\\lib\n", "InlineCode"],
 "to:\n",
 StyleBox["C:\\Program Files (x86)\\Microsoft Visual Studio \
8\\VC\\PlatformSDK\\Lib\\AMD64", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->114228783],

Cell[TextData[{
 StyleBox["Copy ",
  FontWeight->"Plain"],
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"], "InlineCode",
  FontWeight->"Plain"],
 StyleBox[".exe", "InlineCode",
  FontWeight->"Plain"],
 StyleBox[":",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->840171588],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->661478876],

Cell[TextData[{
 "from:\n",
 StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\\SystemFiles\
\\Links\\MathLink\\DeveloperKit\\Windows\\CompilerAdditions\\mldev32\\bin", 
  "InlineCode"],
 "\nto:\n",
 StyleBox["C:\\Program Files\\Microsoft Visual Studio \
8\\VC\\PlatformSDK\\bin", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->2140259110],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->2100112060],

Cell[TextData[{
 "from:\n",
 StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\CompilerAdditions\\mldev64\\bin", "InlineCode"],
 "\nto:\n",
 StyleBox["C:\\Program Files (x86)\\Microsoft Visual Studio \
8\\VC\\PlatformSDK\\bin", "InlineCode"]
}], "ItemizedTextParagraph",
 CellID->983774520]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating a project for \"addtwo.exe\"", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18025],

Cell["\<\
To create a project solution that can be used to edit, build, and debug, \
\"addtwo.exe\"\
\>", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32364],

Cell[TextData[StyleBox["Start Microsoft Visual Studio 2005.",
 FontWeight->"Plain"]], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4000],

Cell[TextData[{
 StyleBox["Click ",
  FontWeight->"Plain"],
 StyleBox["File", "MenuName",
  FontWeight->"Plain"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["New", "MenuName",
  FontWeight->"Plain"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["Project", "MenuName",
  FontWeight->"Plain"],
 StyleBox[".",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22332],

Cell["The \"New Project\" dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->23022],

Cell[TextData[{
 StyleBox["In the 'Project Types' pane click the tree expand icon next to the \
'Visual C++ Projects.'",
  FontWeight->"Plain"],
 " ",
 StyleBox["Select Win32.",
  FontWeight->"Plain"],
 " ",
 StyleBox["In the 'Templates' pane click on the 'Win32 Project' icon.",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9145],

Cell[TextData[StyleBox["In the 'Location' text field type:",
 FontWeight->"Plain"]], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30053],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->695636565],

Cell[TextData[StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\
\\SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples", \
"InlineCode"]], "ItemizedTextParagraph",
 CellID->821759387],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->662773687],

Cell[TextData[StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\MathLinkExamples", "InlineCode"]], "ItemizedTextParagraph",
 CellID->842683452],

Cell[TextData[StyleBox["In the 'Name' text field type 'addtwo'",
 FontWeight->"Plain"]], "ItemizedTextParagraph",
 CellID->239680420],

Cell[TextData[StyleBox["Click 'OK'",
 FontWeight->"Plain"]], "ItemizedTextParagraph",
 CellID->1776980815],

Cell["The 'Win32 Application Wizard' dialog box appears.", \
"ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17709],

Cell[TextData[{
 StyleBox["Click on 'Application Settings.'",
  FontWeight->"Plain"],
 " ",
 StyleBox["Under the 'Additional options' set, click on the 'Empty Project' \
text box.",
  FontWeight->"Plain"],
 " ",
 StyleBox["Click 'Finish.'",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->20895],

Cell[TextData[{
 "Select the addtwo project in the 'Solution Explorer' by clicking once. From \
the ",
 StyleBox["Project", "MenuName"],
 " menu select ",
 StyleBox["Project \[FilledRightTriangle] Add Existing Item", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->6747],

Cell["The 'Add Existing Item' dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4508],

Cell["\<\
From the \[OpenCurlyQuote]Look in\[CloseCurlyQuote] pull down menu select the \
following directory:\
\>", "ItemizedText",
 CellID->2086298361],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->303565111],

Cell[TextData[StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\
\\SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\\
addtwo", "InlineCode"]], "ItemizedTextParagraph",
 CellID->1745158952],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->554855538],

Cell[TextData[StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\MathLinkExamples\\addtwo", "InlineCode"]], \
"ItemizedTextParagraph",
 CellID->1083031892],

Cell[TextData[{
 StyleBox["In the 'File name:' text box enter: ",
  FontWeight->"Plain"],
 StyleBox["\"addtwo.c\" \"addtwo.tm\"", "InlineCode",
  FontWeight->"Plain"],
 StyleBox[" separated by spaces.",
  FontWeight->"Plain"],
 " ",
 StyleBox["Click 'Add'.",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9319],

Cell["\<\
A prompt box might appear asking if you want to create a \[OpenCurlyQuote]New \
Rule\[CloseCurlyQuote] for building .tm files. Click \[OpenCurlyQuote]No\
\[CloseCurlyQuote].\
\>", "ItemizedText",
 CellID->1058900491],

Cell["\<\
In the \[OpenCurlyQuote]Solution Explorer\[CloseCurlyQuote] drag the \
addtwo.tm file into the \[OpenCurlyQuote]Source Files\[CloseCurlyQuote] \
folder. \
\>", "ItemizedText",
 CellID->445616872],

Cell[TextData[{
 "Select the addtwo project in the 'Solution Explorer' by clicking once. From \
the ",
 StyleBox["Project", "MenuName"],
 " menu select ",
 StyleBox["Project \[FilledRightTriangle] Add New Item", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31634],

Cell["The 'Add New Item' dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7136],

Cell["\<\
In the \[OpenCurlyQuote]Location\[CloseCurlyQuote] text field add:\
\>", "ItemizedTextParagraph",
 CellID->1207290615],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->1507869449],

Cell[TextData[StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\
\\SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\\
addtwo", "InlineCode"]], "ItemizedTextParagraph",
 CellID->307311096],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->279419437],

Cell[TextData[StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows\\MathLinkExamples\\addtwo", "InlineCode"]], "ItemizedTextParagraph",
 CellID->1803225317],

Cell[TextData[StyleBox["In the 'Name:' text field type 'addtwotm.c.' Click \
'Add'",
 FontWeight->"Plain"]], "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3123],

Cell["\<\
Right click on the addtwo project in the \[OpenCurlyQuote]Solution Explorer\
\[CloseCurlyQuote] and select \[OpenCurlyQuote]Properties\[CloseCurlyQuote].\
\>", "ItemizedText",
 CellID->1518676355],

Cell["\<\
Click on the expand tree button next to \[OpenCurlyQuote]Configuration \
Properties.\[CloseCurlyQuote]\
\>", "ItemizedText",
 CellID->1550353890],

Cell["\<\
Click on the expand tree button next to \[OpenCurlyQuote]Linker.\
\[CloseCurlyQuote]\
\>", "ItemizedText",
 CellID->1378740179],

Cell["Click on the \[OpenCurlyQuote]Input\[CloseCurlyQuote] entry.", \
"ItemizedText",
 CellID->1137637323],

Cell[TextData[{
 "In the \[OpenCurlyQuote]Additional Dependencies\[CloseCurlyQuote] text \
field enter ",
 StyleBox["ml32i3.lib", "InlineCode"],
 "."
}], "ItemizedText",
 CellID->1223578420],

Cell["Click \[OpenCurlyQuote]Ok\[CloseCurlyQuote]", "ItemizedTextParagraph",
 CellID->379101268],

Cell[TextData[{
 StyleBox["Click on addtwo.tm in the 'Solution Explorer.'",
  FontWeight->"Plain"],
 " ",
 StyleBox["From the ",
  FontWeight->"Plain"],
 StyleBox["Project", "MenuName",
  FontWeight->"Plain"],
 StyleBox[" menu select ",
  FontWeight->"Plain"],
 StyleBox["Project", "MenuName",
  FontWeight->"Plain"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["Properties", "MenuName",
  FontWeight->"Plain"],
 StyleBox[".",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3375],

Cell["The 'addtwo.tm Property Pages' dialog box appears.", \
"ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->6546],

Cell["\<\
Click the expand tree button next to \[OpenCurlyQuote]Configuration \
Properties.\[CloseCurlyQuote]\
\>", "ItemizedText",
 CellID->2118514274],

Cell["\<\
Click the expand tree button next to \[OpenCurlyQuote]Custom Build Step.\
\[CloseCurlyQuote]\
\>", "ItemizedText",
 CellID->590535858],

Cell["Click on the \[OpenCurlyQuote]General\[CloseCurlyQuote] entry.", \
"ItemizedText",
 CellID->1614232619],

Cell[TextData[{
 "In the rightmost pane click on the empty box across from the 'Command \
Line.' In this text box type(include the quotes): ",
 StyleBox["\"$(VCInstallDir)PlatformSDK\\bin\\mprep.exe\" \"$(InputPath)\" -o \
\"$(ProjectDir)..\\addtwotm.c\"", "InlineCode"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30439],

Cell[TextData[{
 StyleBox["In the text field across from the 'Outputs' text type: ",
  FontWeight->"Plain"],
 StyleBox["..\\addtwotm.c", "InlineCode",
  FontWeight->"Plain"],
 StyleBox[".",
  FontWeight->"Plain"],
 " ",
 StyleBox["Click 'OK'",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->25048],

Cell[TextData[{
 "From the ",
 StyleBox["Build", "MenuName"],
 " menu, select ",
 StyleBox["Build \[FilledRightTriangle] Build Solution", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->14565],

Cell[TextData[{
 StyleBox["After the project builds, Microsoft Visual Studio 2005 will \
display a dialog box informing you that the file addtwotm.c has changed and \
asking you if you would like to reload the file.",
  FontWeight->"Plain"],
 " ",
 StyleBox["Click 'Yes'.",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18962],

Cell["The addtwo.exe binary is now in:", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31168],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->540758695],

Cell[TextData[StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\
\\SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\\
addtwo\\Debug", "InlineCode"]], "ItemizedTextParagraph",
 FontSize->12,
 CellID->1246714982],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->380592761],

Cell[TextData[{
 StyleBox["C:\\Program Files (x86)\\Wolfram Research\\", "InlineCode"],
 StyleBox["Mathematica", "InlineCode",
  FontSlant->"Plain"],
 StyleBox["\\6.0\\SystemFiles\\Links\\", "InlineCode"],
 StyleBox["MathLink", "InlineCode",
  FontSlant->"Plain"],
 StyleBox["\\DeveloperKit\\Windows-x86-64\\MathLinkExamples\\addtwo\\Debug", 
  "InlineCode"]
}], "ItemizedTextParagraph",
 FontSize->12,
 CellID->1416233361]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Creating a project for \[OpenCurlyDoubleQuote]factor.exe\
\[CloseCurlyDoubleQuote]\
\>", "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3719],

Cell["\<\
To create a project solution that can be used to edit, build, and debug \
\[OpenCurlyDoubleQuote]factor.exe\[CloseCurlyDoubleQuote]\
\>", "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15469],

Cell[TextData[StyleBox["Start Microsoft Visual Studio .NET.",
 FontWeight->"Plain"]], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9982],

Cell[TextData[{
 "Click ",
 StyleBox["File \[FilledRightTriangle] New \[FilledRightTriangle] Project", 
  "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->8113],

Cell["The \"New Project\" dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3287],

Cell[TextData[{
 StyleBox["In the 'Project Types' pane click the tree expand icon next to the \
'Visual C++ Projects.'",
  FontWeight->"Plain"],
 " ",
 StyleBox["Select Win32.",
  FontWeight->"Plain"],
 " ",
 StyleBox["In the 'Templates' pane click on the 'Win32 Console Application' \
icon.",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32340],

Cell[TextData[StyleBox["In the 'Location' text field type:",
 FontWeight->"Plain"]], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->2072838626],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->1719065548],

Cell[TextData[StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\
\\SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples", \
"InlineCode"]], "ItemizedTextParagraph",
 CellID->326125799],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->89678498],

Cell[TextData[StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\MathLinkExamples", "InlineCode"]], "ItemizedTextParagraph",
 CellID->818036649],

Cell[TextData[StyleBox["In the 'Name' text field type 'factor'",
 FontWeight->"Plain"]], "ItemizedTextParagraph",
 CellID->1840479339],

Cell[TextData[StyleBox["Click 'OK'",
 FontWeight->"Plain"]], "ItemizedTextParagraph",
 CellID->581799185],

Cell["The 'Win32 Application Wizard' dialog box appears.", \
"ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->805857504],

Cell[TextData[{
 StyleBox["Click on 'Application Settings.'",
  FontWeight->"Plain"],
 " ",
 StyleBox["Under the 'Additional options' set, click on the 'Empty Project' \
text box.",
  FontWeight->"Plain"],
 " ",
 StyleBox["Click 'Finish.'",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30290],

Cell[TextData[{
 "Select the factor project in the 'Solution Explorer' by clicking once. From \
the ",
 StyleBox["Project", "MenuName"],
 " menu select ",
 StyleBox["Project \[FilledRightTriangle] Add Existing Item", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18321],

Cell["The 'Add Existing Item' dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->636],

Cell["\<\
From the \[OpenCurlyQuote]Look in\[CloseCurlyQuote] pull down menu select the \
following directory:\
\>", "ItemizedText",
 CellID->2015191746],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->1363078185],

Cell[TextData[StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\
\\SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\\
factor", "InlineCode"]], "ItemizedTextParagraph",
 CellID->2046992746],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->1119057082],

Cell[TextData[StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\MathLinkExamples\\factor", "InlineCode"]], \
"ItemizedTextParagraph",
 CellID->330596748],

Cell[TextData[{
 StyleBox["In the 'File name:' text box enter: factor.c.",
  FontWeight->"Plain"],
 " ",
 StyleBox["Click 'Add'.",
  FontWeight->"Plain"]
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18677],

Cell["\<\
Right click on the factor project in the \[OpenCurlyQuote]Solution Explorer\
\[CloseCurlyQuote] and select \[OpenCurlyQuote]Properties\[CloseCurlyQuote].\
\>", "ItemizedText",
 CellID->799348847],

Cell["\<\
Click on the expand tree button next to \[OpenCurlyQuote]Configuration \
Properties.\[CloseCurlyQuote]\
\>", "ItemizedText",
 CellID->2145859544],

Cell["\<\
Click on the expand tree button next to \[OpenCurlyQuote]Linker.\
\[CloseCurlyQuote]\
\>", "ItemizedText",
 CellID->620988290],

Cell["Click on the \[OpenCurlyQuote]Input\[CloseCurlyQuote] entry.", \
"ItemizedText",
 CellID->179665610],

Cell[TextData[{
 "In the \[OpenCurlyQuote]Additional Dependencies\[CloseCurlyQuote] text \
field enter ",
 StyleBox["ml32i3.lib", "InlineCode"],
 "."
}], "ItemizedText",
 CellID->277899588],

Cell["Click \[OpenCurlyQuote]Ok\[CloseCurlyQuote]", "ItemizedTextParagraph",
 CellID->2028926938],

Cell[TextData[{
 "From the ",
 StyleBox["Build", "MenuName"],
 " menu, select ",
 StyleBox["Build \[FilledRightTriangle] Build Solution", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11620],

Cell["The factor.exe binary is now in:", "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->282216253],

Cell[TextData[StyleBox["32-bit Windows",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->1564671595],

Cell[TextData[StyleBox["C:\\Program Files\\Wolfram Research\\Mathematica\\6.0\
\\SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\MathLinkExamples\\\
factor\\Debug", "InlineCode"]], "ItemizedTextParagraph",
 CellID->1498239650],

Cell[TextData[StyleBox["Windows 64",
 FontSize->13,
 FontWeight->"Bold"]], "ItemizedTextParagraph",
 CellID->1668036475],

Cell[TextData[StyleBox["C:\\Program Files (x86)\\Wolfram \
Research\\Mathematica\\6.0\\SystemFiles\\Links\\MathLink\\DeveloperKit\\\
Windows-x86-64\\MathLinkExamples\\factor\\Debug", "InlineCode"]], \
"ItemizedTextParagraph",
 CellID->1437507387]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Running ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "Section",
 CellTags->"WindowsRunning",
 CellID->26613],

Cell[TextData[{
 "The instructions in the next section describe how to build two ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs using source code in the \"",
 StyleBox["MathLinkExamples", "InlineCode"],
 "\" directory. These two programs, \"",
 StyleBox["addtwo.exe", "InlineCode"],
 "\" and \"",
 StyleBox["factor.exe", "InlineCode"],
 "\", are already built for you in the \"",
 StyleBox["PrebuiltExamples", "InlineCode"],
 "\" folder. Before building them on your own, you should try to run the \
prebuilt examples to verify that the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " system additions are installed and working and to learn what to expect \
from these examples when they are properly built. "
}], "Text",
 CellTags->"WindowsRunning",
 CellID->16696],

Cell[TextData[{
 "After trying out the two examples, you should read the following \
subsections to learn about other issues you will confront running ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs on a Windows computer."
}], "Text",
 CellTags->"WindowsRunning",
 CellID->12389],

Cell[TextData[{
 "There are two basic types of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program, epitomized by the \"addtwo\" and \"factor\" programs. The first \
is an Installable program. An Installable program provides new functionality \
to the kernel by linking a C program to the kernel through a calling \
mechanism. In order to get this new functionality, the user of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " must run the ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 StyleBox["[]", "InlineFormula"],
 " function. With the addtwo example we'll be adding a new function called ",
 StyleBox["AddTwo[]", "InlineFormula"],
 " that adds two numbers (provided as arguments) together. The Kernel and \
Installable programs have a special relationship that allows them only to \
communicate with one another. When an installable program is run it requires \
that you provide some information in order for it to connect. The other type \
of program is a Front End. Front Ends do all of the work of creating and \
managing their own links. In addition to the \"factor\" example, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Front End and the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel are also example of the Front End type.",
 " ",
 "A Front End does not require any extra information in order to run, but it \
will usually make a connection at some point during its execution."
}], "Text",
 CellTags->"WindowsRunning",
 CellID->6894],

Cell[CellGroupData[{

Cell[TextData[{
 "Running a Prebuilt Example from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel"
}], "Subsection",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->30804],

Cell[TextData[{
 "The first example program, \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote], is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template program that is installed into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". That is, this program runs in the background, providing, as a service to \
",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " one or more externally compiled functions. To the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " user, these functions appear to be built-in. The \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] program uses a template \
file that defines the ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "function ",
 StyleBox["AddTwo[]", "InlineFormula"],
 " as a call to the C function ",
 StyleBox["addtwo()", "InlineCode"],
 ". ",
 "(The template mechanism is described in \"",
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"],
 "\".) The source code for this program looks likes this:"
}], "Text",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->31119],

Cell[TextData[{
 StyleBox[":Begin:\n:Function:", "MR"],
 "      ",
 StyleBox[" addtwo\n:Pattern:", "MR"],
 "   ",
 StyleBox["     AddTwo[i_Integer, j_Integer]\n:Arguments:      { i, j }\n\
:ArgumentTypes:  { Integer, Integer }\n:ReturnType:     Integer\n:End:\n\n\
:Evaluate: AddTwo::usage = \"AddTwo[x, y] gives the sum of two machine \
integers x and y.\"\n\nint addtwo( int i, int j)\n{\n    return i+j;\n}\n\n\
int __stdcall WinMain( HINSTANCE hinstCurrent, HINSTANCE hinstPrevious, LPSTR \
lpszCmdLine, int nCmdShow)\n{\n\tchar  buff[512];\n\tchar FAR * buff_start = \
buff;\n\tchar FAR * argv[32];\n\tchar FAR * FAR * argv_end = argv + 32;\n\n\t\
if( !MLInitializeIcon( hinstCurrent, nCmdShow)) return 1;\n\tMLScanString( \
argv, &argv_end, &lpszCmdLine, &buff_start);\n\treturn MLMain( argv_end - \
argv, argv);\n}\n", "MR"]
}], "Program",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->6219],

Cell["Evaluate the following two cells:", "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->9425],

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID", 
   "<>", "\"\</PrebuiltExamples\>\""}], "]"}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->19900],

Cell[BoxData[
 RowBox[{"link", " ", "=", " ", 
  RowBox[{"Install", "[", "\"\<./addtwo\>\"", "]"}]}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->3248],

Cell["\<\
To see a list of the newly available functions, evaluate the following cell:\
\>", "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->18461],

Cell[BoxData[
 RowBox[{"LinkPatterns", "[", "link", "]"}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->19295],

Cell[TextData[{
 "This displays the usage message for the ",
 Cell[BoxData[
  RowBox[{"AddTwo", "[", "]"}]], "InlineFormula"],
 " function as defined in the file \"",
 StyleBox["addtwo.tm", "InlineCode"],
 "\":"
}], "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->32652],

Cell[BoxData[
 RowBox[{"?", "AddTwo"}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->23643],

Cell["Now try it:", "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->371719980],

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"2", ",", " ", "3"}], "]"}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->12747],

Cell["\<\
See what happens if the sum of the two machine integers won't fit in a \
machine integer or if either argument is not a machine integer:\
\>", "Text",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->7965],

Cell[TextData[{
 "2^31-1 is the largest machine integer. If your compiler uses 2-byte \
integers, then 2^15-1 is the largest C ",
 StyleBox["int", "InlineCode"],
 ":"
}], "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->30284],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "^", "31"}], "-", "1"}], ",", " ", "1"}], "]"}], 
  "  "}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->1124],

Cell["The AddTwo program is not prepared for big integers:", "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->15953],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{
    RowBox[{"2", "^", "31"}], ",", " ", "1"}], "]"}], "     "}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->32525],

Cell[TextData[{
 "This doesn't match ",
 StyleBox["AddTwo[_Integer, _Integer]", "InlineCode"],
 ":"
}], "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->12110],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{"x", ",", " ", "1"}], "]"}], "          "}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->21792],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "]"}]], "InlineFormula"],
 " called ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 " and then exchanged information with the external program to set up the \
definition for ",
 StyleBox["AddTwo[]", "InlineCode"],
 ". You really don't have to worry about these details, but if you are \
curious, evaluate:"
}], "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->12197],

Cell[BoxData[
 RowBox[{"??", "AddTwo"}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->497],

Cell["When you are finished using the external program evaluate:", \
"MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->20805],

Cell[BoxData[
 RowBox[{"Uninstall", "[", "link", "]"}]], "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->4112]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Invoking the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel from Within a Prebuilt Example"
}], "Subsection",
 CellTags->{"factor", "WindowsRunning"},
 CellID->3856],

Cell[TextData[{
 "The second example program, \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote], is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end in the sense that the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel runs in the background providing, as a service to \
\[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote], the computational \
services of the kernel\[LongDash]in this case the ability to factor an \
integer typed by the user."
}], "Text",
 CellTags->{"factor", "WindowsRunning"},
 CellID->23256],

Cell[TextData[{
 "This example program, like several of the others, is a console program. \
That is, rather than presenting a graphical user interface, it interacts with \
the user in a console window using the standard error, input and output \
streams defined by ANSI C. (As you experiment with ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", you may find it convenient, initially, to use a console window.",
 " ",
 "This is discussed in detail in the section \"",
 ButtonBox["Building ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#25303"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#25303"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows#25303"],
 "\".)"
}], "Text",
 CellTags->{"factor", "WindowsRunning"},
 CellID->27730],

Cell["To run the example program FACTOR.EXE", "Text",
 CellTags->{"factor", "WindowsRunning"},
 CellID->11231],

Cell["Start a command prompt.", "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->23034],

Cell["\<\
Change to the \[OpenCurlyDoubleQuote]PrebuiltExamples\[CloseCurlyDoubleQuote] \
directory.\
\>", "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->28501],

Cell[CellGroupData[{

Cell["Type the following commands.", "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->24171],

Cell[TextData[StyleBox["factor -linklaunch", "MR"]], "Program",
 CellTags->{"factor", "WindowsRunning"},
 CellID->6438]
}, Open  ]],

Cell["The Choose a MathLink Program To Launch dialog box appears.", \
"ItemizedTextParagraph",
 CellTags->{"factor", "WindowsRunning"},
 CellID->20656],

Cell["Open MathKernel.exe", "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->13265],

Cell["\<\
After a moment, a prompt will appear requesting that you type an integer.\
\>", "ItemizedTextParagraph",
 CellTags->{"factor", "WindowsRunning"},
 CellID->27236],

Cell[CellGroupData[{

Cell[TextData[{
 "Type an integer with fewer than 10 digits and press the ",
 StyleBox["Enter", "KeyEvent"],
 " key. (The other factor examples relax the restriction on the size of \
integer you may type in.)"
}], "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->28469],

Cell[TextData[StyleBox["Integer to factor: 123456789", "MR"]], "Program",
 CellTags->{"factor", "WindowsRunning"},
 CellID->19924]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The prime factors returned by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are printed and \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] \
closes its link with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "ItemizedTextParagraph",
 CellTags->{"factor", "WindowsRunning"},
 CellID->30386],

Cell[TextData[{
 StyleBox["Integer to factor: 123456789\n3 ", "MR"],
 StyleBox["^", "MR", "InlineCode"],
 StyleBox[" 2\n3607 ", "MR"],
 StyleBox["^", "MR", "InlineCode"],
 StyleBox[" 1\n3803 ", "MR"],
 StyleBox["^", "MR", "InlineCode"],
 StyleBox[" 1", "MR"]
}], "Program",
 CellTags->{"factor", "WindowsRunning"},
 CellID->18972]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Supported Link Protocols", "Subsection",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->20802],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " links are opened by the C function ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLOpenArgcArgv", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineFormula"],
 " and the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 ", each of which accepts an option for specifying a link protocol. On 32-bit \
Windows platforms, the legal values for the ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " option are \"",
 StyleBox["SharedMemory", "InlineCode"],
 "\", \"",
 StyleBox["TCPIP", "InlineCode"],
 "\", \"",
 StyleBox["FileMap", "InlineCode"],
 "\", and \"",
 StyleBox["TCP", "InlineCode"],
 "\". On Windows 64 platforms the leval values for the ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " option are \"",
 StyleBox["SharedMemory", "InlineCode"],
 "\", \"",
 StyleBox["TCPIP", "InlineCode"],
 "\", and \"",
 StyleBox["TCP", "InlineCode"],
 "\". A link protocol is the mechanism used to transport data from one end of \
a connection to the other. The default is \"",
 StyleBox["SharedMemory", "InlineCode"],
 "\" for all link modes except ",
 StyleBox["LoopBack", "InlineCode"],
 "."
}], "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->13652],

Cell[TextData[{
 "Note that the \"",
 StyleBox["FileMap", "InlineCode"],
 "\" and \"",
 StyleBox["SharedMemory", "InlineCode"],
 "\" protocols allow link names to be arbitrary words with 31 or fewer \
characters, while link names are often unsigned 16-bit integers for the \"",
 StyleBox["TCPIP", "InlineCode"],
 "\" and \"",
 StyleBox["TCP", "InlineCode"],
 "\" protocols. Even though \"",
 StyleBox["TCPIP", "InlineCode"],
 "\" and \"",
 StyleBox["TCP", "InlineCode"],
 "\" link names are integers, they are still given as strings (of digits) to \
",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLOpenArgcArgv", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->25471],

Cell[TextData[{
 "Note that for ",
 Cell[BoxData[
  RowBox[{"LinkMode", "->", "Launch"}]], "InlineFormula"],
 ", the link name is not just a pathname to a file to launch, but a \
commandline with space-separated arguments. Hence, spaces in filenames need \
to be properly quoted. For example"
}], "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->13580],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinkOpen", "[", " ", "\"\<My Prog.exe\>\"", "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"wrong", "!"}], "*)"}]}]], "Input",
 FontWeight->"Bold",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->10925],

Cell["\<\
would try to launch the program \[OpenCurlyDoubleQuote]My\
\[CloseCurlyDoubleQuote] with command-line argument of \
\[OpenCurlyDoubleQuote]Prog.exe\[CloseCurlyDoubleQuote]. Whereas, \
\>", "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->20380],

Cell[BoxData[
 RowBox[{"LinkOpen", "[", " ", "\"\<\\\"My Prog.exe\\\"\>\"", "]"}]], "Input",\

 FontWeight->"Bold",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->16708],

Cell[" would launch \[OpenCurlyDoubleQuote]My \
Prog.exe\[CloseCurlyDoubleQuote].", "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->13599]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Troubleshooting", "Section",
 CellTags->"WindowsTroubleshooting",
 CellID->15385],

Cell[TextData[{
 "Check that the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " system additions are placed in the Windows system directory or are placed \
next to your executable. For Windows 9x and ME use ",
 StyleBox["C:\\Windows\\system", "InlineCode"],
 ". For Windows 2000, 32-bit Windows XP, and 32-bit Windows Vista use ",
 StyleBox["C:\\Windows\\system32", "InlineCode"],
 ". For Windows 64 XP, Windows Server 2003, and Windows 64 Vista, use ",
 StyleBox["C:\\Windows\\system32", "InlineCode"],
 " for the 64-bit system additions and ",
 StyleBox["C:\\Windows\\SysWOW64", "InlineCode"],
 " for the 32-bit system additions."
}], "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->4139],

Cell[TextData[{
 "Make sure that the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " system additions you are using are from the latest Developer Kit.",
 " ",
 "Two programs that are using runtime components from different Revisions of \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " may not work, or if they do work may be slower than using the latest \
components."
}], "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->26927],

Cell["\<\
Turn off compiler optimization until your program is working. This makes \
compiling faster, debugging easier, and, besides, the optimizer may be broken \
and the cause of some problems. (Optimized code uses the stack and registers \
differently than unoptimized code in such a way that may expose or mask a bug \
in your code. For example, the common mistake of returning a pointer to a \
local variable may or may not cause a problem depending on stack and register \
use.)\
\>", "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->26728],

Cell[TextData[{
 "Check the return values from the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions or call ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLError", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLError"]], "InlineFormula"],
 " at key points in your program. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will often be able to tell you what has gone wrong. (If you don't assign \
the return value to a variable, you can still check the return value of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions using your debugger's register window.",
 " ",
 "The 32-bit library returns its results in register EAX.)"
}], "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->11304],

Cell["\<\
While developing your program, place the debug version \
\[OpenCurlyDoubleQuote]ML32I3.DLL\[CloseCurlyDoubleQuote] in the same folder. \
This library will do more extensive error checking and log information that \
may be useful.\
\>", "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->14368],

Cell[TextData[{
 "The files ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 ", \[OpenCurlyDoubleQuote]ML32I3.DLL\[CloseCurlyDoubleQuote], and the ",
 StyleBox[".LIB", "InlineCode"],
 " import libraries are a matched set. If you have used an earlier release of \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", or a different interface of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", you should take care that you don't mix components when building your \
application."
}], "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->26396],

Cell[TextData[{
 "The network control panel must show that TCP/IP is installed before you can \
use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkProtocol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkProtocol"], "->", "\"\<TCPIP\>\""}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkProtocol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkProtocol"], "->", "\"\<TCP\>\""}]], 
  "InlineFormula"],
 ". Try typing \[OpenCurlyDoubleQuote]telnet\[CloseCurlyDoubleQuote] at a \
command prompt. Telnet will not function without TCP/IP installed."
}], "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->12975],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->179833080],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "TutorialMoreAbout",
 CellID->558589989],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "TutorialMoreAbout",
 CellID->40858578],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "TutorialMoreAbout",
 CellID->8146795],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "TutorialMoreAbout",
 CellID->424932163],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"]
}], "TutorialMoreAbout",
 CellID->2262398],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Multidimensional Arrays",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"]
}], "TutorialMoreAbout",
 CellID->101684538],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"]
}], "TutorialMoreAbout",
 CellID->655130],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"]
}], "TutorialMoreAbout",
 CellID->148916145],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]
}], "TutorialMoreAbout",
 CellID->182367630],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "TutorialMoreAbout",
 CellID->113882963],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkPackets"],
  FontSlant->"Italic"],
 ButtonBox[" Packets",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkPackets"]
}], "TutorialMoreAbout",
 CellID->5094559],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "TutorialMoreAbout",
 CellID->246479563]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->52096731],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "RelatedTutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "RelatedTutorials",
 CellID->309869466]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink Development in C (Windows) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 22.5081582}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This document describes how to compile and run MathLink programs written \
in the C language on computers running a Microsoft Windows operating system. \
(\"MathLink and External Program Communication\" describes how to write \
MathLink programs in both the Mathematica language and the C language.) This \
document also describes how MathLink is implemented for Windows. This \
document does not teach you, in general, how to use your compiler and other \
development tools, nor does it teach you how to program in C or generally how \
to use a Windows-based computer. It is assumed that you have at least worked \
through the tutorial introduction that came with your set of tools. If you \
have any trouble building or running your MathLink programs, see the \
troubleshooting section at the end of this document. Most of what is \
described in this document is Windows specific. To learn how to compile and \
run MathLink programs for another platform, see the Developer Guide for that \
platform.", "synonyms" -> {}, "title" -> "MathLink Development in C Windows", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/MathLinkDeveloperGuide-Windows"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "WindowsIntroduction"->{
  Cell[4585, 108, 152, 6, 70, "Title",
   CellTags->"WindowsIntroduction",
   CellID->90],
  Cell[4740, 116, 910, 29, 70, "Text",
   CellTags->"WindowsIntroduction",
   CellID->19725],
  Cell[5653, 147, 676, 15, 70, "Text",
   CellTags->"WindowsIntroduction",
   CellID->14107],
  Cell[6332, 164, 311, 9, 70, "Text",
   CellTags->"WindowsIntroduction",
   CellID->5883]},
 "WindowsOverview"->{
  Cell[6668, 177, 73, 2, 70, "Section",
   CellTags->"WindowsOverview",
   CellID->15002],
  Cell[6744, 181, 1161, 26, 70, "Text",
   CellTags->"WindowsOverview",
   CellID->17960],
  Cell[8222, 220, 434, 11, 70, "Text",
   CellTags->"WindowsOverview",
   CellID->6968],
  Cell[8659, 233, 493, 19, 70, "Text",
   CellTags->"WindowsOverview",
   CellID->7373],
  Cell[9155, 254, 638, 18, 70, "Text",
   CellTags->"WindowsOverview",
   CellID->7666]},
 "WindowsCompilers"->{
  Cell[9830, 277, 97, 2, 70, "Section",
   CellTags->"WindowsCompilers",
   CellID->14658],
  Cell[9930, 281, 477, 13, 70, "Text",
   CellTags->"WindowsCompilers",
   CellID->5140],
  Cell[10410, 296, 539, 10, 70, "Text",
   CellTags->"WindowsCompilers",
   CellID->26887]},
 "WindowsInstalling"->{
  Cell[10986, 311, 159, 7, 70, "Section",
   CellTags->"WindowsInstalling",
   CellID->26660],
  Cell[11148, 320, 475, 17, 70, "Text",
   CellTags->"WindowsInstalling",
   CellID->18916],
  Cell[11626, 339, 1214, 32, 70, "Text",
   CellTags->"WindowsInstalling",
   CellID->3163],
  Cell[12865, 375, 124, 2, 70, "Subsection",
   CellTags->{"Recommended Installation", "WindowsInstalling"},
   CellID->14115],
  Cell[13014, 381, 147, 2, 70, "Subsubsection",
   CellTags->{"Recommended Installation", "WindowsInstalling"},
   CellID->366],
  Cell[13164, 385, 583, 20, 70, "Text",
   CellTags->{"Recommended Installation", "WindowsInstalling"},
   CellID->1465],
  Cell[13784, 410, 170, 2, 70, "Subsubsection",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->15232],
  Cell[13957, 414, 706, 16, 70, "Text",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->19874],
  Cell[14688, 434, 653, 12, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->19078],
  Cell[15344, 448, 266, 5, 70, "Program",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->4337],
  Cell[15625, 456, 248, 7, 70, "ItemizedTextParagraph",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->16800],
  Cell[15876, 465, 473, 12, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->12848],
  Cell[16352, 479, 257, 5, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->27993],
  Cell[16612, 486, 373, 7, 70, "ItemizedTextParagraph",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->5958],
  Cell[17552, 513, 166, 7, 70, "Subsection",
   CellTags->"WindowsInstalling",
   CellID->19058],
  Cell[17721, 522, 330, 8, 70, "Text",
   CellTags->"WindowsInstalling",
   CellID->24682],
  Cell[18054, 532, 631, 14, 70, "Text",
   CellTags->"WindowsInstalling",
   CellID->26617],
  Cell[18722, 551, 176, 6, 70, "Subsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->31065],
  Cell[18901, 559, 432, 11, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->32706],
  Cell[19749, 586, 109, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->25820],
  Cell[19861, 590, 997, 26, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->5312],
  Cell[20883, 620, 129, 2, 70, "Subsubsubsection",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->20204],
  Cell[21015, 624, 1325, 34, 70, "Text",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->19602],
  Cell[22377, 663, 163, 4, 70, "Subsubsubsection",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->29197],
  Cell[22543, 669, 580, 15, 70, "Text",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->32136],
  Cell[23160, 689, 175, 7, 70, "Subsubsubsection",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->8643],
  Cell[23338, 698, 608, 16, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->29116],
  Cell[23949, 716, 281, 8, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->12306],
  Cell[24233, 726, 490, 12, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->22978],
  Cell[25641, 764, 537, 16, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->32624],
  Cell[26181, 782, 159, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->25115],
  Cell[26343, 788, 164, 3, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->12473],
  Cell[26510, 793, 525, 13, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->26160],
  Cell[27038, 808, 135, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4678],
  Cell[27176, 812, 283, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->22336],
  Cell[27462, 818, 208, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24719],
  Cell[27673, 827, 308, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24608],
  Cell[27984, 836, 148, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->25188],
  Cell[28135, 842, 163, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->7782],
  Cell[28301, 847, 519, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4321],
  Cell[28823, 862, 132, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->14616],
  Cell[28958, 866, 273, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10223],
  Cell[29234, 872, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->12712],
  Cell[29441, 881, 298, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11186],
  Cell[29742, 890, 406, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->27170],
  Cell[30151, 905, 153, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4766],
  Cell[30307, 911, 146, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->29042],
  Cell[30456, 915, 407, 10, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->268],
  Cell[30866, 927, 136, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->28458],
  Cell[31005, 931, 278, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->10876],
  Cell[31286, 937, 207, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4662],
  Cell[31496, 946, 303, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->19946],
  Cell[31802, 955, 244, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->16981],
  Cell[32203, 971, 146, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11753],
  Cell[32352, 977, 159, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4704],
  Cell[32514, 982, 404, 10, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10838],
  Cell[32921, 994, 131, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8597],
  Cell[33055, 998, 270, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4322],
  Cell[33328, 1004, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->19595],
  Cell[33535, 1013, 295, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8911],
  Cell[33833, 1022, 307, 9, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->21115],
  Cell[34594, 1051, 111, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->31221],
  Cell[34730, 1057, 129, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->237],
  Cell[34862, 1061, 240, 6, 70, "Text",
   CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
   CellID->22604],
  Cell[35105, 1069, 930, 22, 70, "Text",
   CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
   CellID->5578],
  Cell[36072, 1096, 123, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->14640],
  Cell[36198, 1100, 562, 13, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->1864],
  Cell[36763, 1115, 142, 3, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->20566],
  Cell[36908, 1120, 735, 17, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->1694],
  Cell[37680, 1142, 123, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->25411],
  Cell[37806, 1146, 130, 2, 70, "Text",
   CellTags->{"mprep", "parts", "WindowsInstalling"},
   CellID->8957],
  Cell[37939, 1150, 547, 14, 70, "Text",
   CellTags->{"mprep", "parts", "WindowsInstalling"},
   CellID->31807],
  Cell[38535, 1170, 122, 2, 70, "Subsubsection",
   CellTags->{"prebuilt", "parts", "WindowsInstalling"},
   CellID->24407],
  Cell[38660, 1174, 599, 14, 70, "Text",
   CellTags->{"prebuilt", "parts", "WindowsInstalling"},
   CellID->227],
  Cell[39296, 1193, 125, 2, 70, "Subsubsection",
   CellTags->{"parts", "sample code", "WindowsInstalling"},
   CellID->13686],
  Cell[39424, 1197, 399, 12, 70, "Text",
   CellTags->{"parts", "sample code", "WindowsInstalling"},
   CellID->7943],
  Cell[39860, 1214, 99, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->5035],
  Cell[39962, 1218, 158, 4, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->3112],
  Cell[40157, 1227, 115, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->8231],
  Cell[40275, 1231, 127, 2, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->17049],
  Cell[40405, 1235, 440, 11, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->1206]},
 "Recommended Installation"->{
  Cell[12865, 375, 124, 2, 70, "Subsection",
   CellTags->{"Recommended Installation", "WindowsInstalling"},
   CellID->14115],
  Cell[13014, 381, 147, 2, 70, "Subsubsection",
   CellTags->{"Recommended Installation", "WindowsInstalling"},
   CellID->366],
  Cell[13164, 385, 583, 20, 70, "Text",
   CellTags->{"Recommended Installation", "WindowsInstalling"},
   CellID->1465],
  Cell[13784, 410, 170, 2, 70, "Subsubsection",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->15232],
  Cell[13957, 414, 706, 16, 70, "Text",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->19874],
  Cell[14688, 434, 653, 12, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->19078],
  Cell[15344, 448, 266, 5, 70, "Program",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->4337],
  Cell[15625, 456, 248, 7, 70, "ItemizedTextParagraph",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->16800],
  Cell[15876, 465, 473, 12, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->12848],
  Cell[16352, 479, 257, 5, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->27993],
  Cell[16612, 486, 373, 7, 70, "ItemizedTextParagraph",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->5958]},
 "Microsoft"->{
  Cell[13784, 410, 170, 2, 70, "Subsubsection",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->15232],
  Cell[13957, 414, 706, 16, 70, "Text",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->19874],
  Cell[14688, 434, 653, 12, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->19078],
  Cell[15344, 448, 266, 5, 70, "Program",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->4337],
  Cell[15625, 456, 248, 7, 70, "ItemizedTextParagraph",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->16800],
  Cell[15876, 465, 473, 12, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->12848],
  Cell[16352, 479, 257, 5, 70, "ItemizedText",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->27993],
  Cell[16612, 486, 373, 7, 70, "ItemizedTextParagraph",
   CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
   CellID->5958],
  Cell[49584, 1538, 196, 7, 70, "Subsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13917],
  Cell[49805, 1549, 114, 2, 70, "Subsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->12593],
  Cell[51520, 1592, 256, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15467],
  Cell[51779, 1604, 116, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15605],
  Cell[52516, 1624, 260, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22383],
  Cell[52779, 1632, 294, 9, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->24653],
  Cell[53456, 1660, 117, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1439],
  Cell[53576, 1664, 429, 10, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4826],
  Cell[54320, 1691, 251, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31942],
  Cell[54574, 1703, 116, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11929],
  Cell[55311, 1723, 259, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3527],
  Cell[55573, 1731, 280, 8, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->28540],
  Cell[56236, 1758, 118, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13886],
  Cell[56357, 1762, 339, 8, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18443],
  Cell[56997, 1787, 253, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->23792],
  Cell[57253, 1799, 115, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22910],
  Cell[57393, 1805, 850, 22, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17889],
  Cell[58246, 1829, 417, 9, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->12069],
  Cell[58945, 1852, 114, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31391],
  Cell[59062, 1856, 115, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->16139],
  Cell[59180, 1860, 235, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1835],
  Cell[59418, 1870, 130, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4306],
  Cell[59551, 1874, 250, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->10039],
  Cell[59804, 1882, 138, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32173],
  Cell[59945, 1886, 129, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->21069],
  Cell[60077, 1890, 300, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7573],
  Cell[60380, 1901, 326, 6, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11444],
  Cell[60743, 1912, 251, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1827],
  Cell[60997, 1924, 114, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4195],
  Cell[61136, 1930, 844, 22, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4316],
  Cell[61983, 1954, 321, 5, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->29007],
  Cell[62561, 1972, 96, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3022],
  Cell[62672, 1977, 115, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->16764],
  Cell[62790, 1981, 235, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9948],
  Cell[63028, 1991, 131, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->25008],
  Cell[63162, 1995, 250, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13772],
  Cell[63415, 2003, 137, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7008],
  Cell[63555, 2007, 129, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13790],
  Cell[63687, 2011, 205, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->29157],
  Cell[63895, 2021, 133, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->5047],
  Cell[64031, 2025, 141, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->831],
  Cell[64175, 2030, 126, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->29086],
  Cell[64304, 2034, 186, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31696],
  Cell[64493, 2042, 105, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30906],
  Cell[64601, 2046, 300, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7467],
  Cell[64904, 2057, 537, 16, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->21814],
  Cell[65444, 2075, 325, 6, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->6190],
  Cell[65806, 2086, 122, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9047],
  Cell[65931, 2090, 1880, 53, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22153],
  Cell[67848, 2148, 121, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18470],
  Cell[67972, 2152, 1852, 54, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->610],
  Cell[69861, 2211, 114, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->21605],
  Cell[69978, 2215, 798, 21, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4709],
  Cell[70779, 2238, 77, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22971],
  Cell[70859, 2242, 1049, 29, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26471],
  Cell[71911, 2273, 76, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7242],
  Cell[71990, 2277, 699, 18, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->2332],
  Cell[72692, 2297, 77, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->28842],
  Cell[72772, 2301, 832, 23, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32420],
  Cell[73607, 2326, 81, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->659339814],
  Cell[73691, 2330, 727, 19, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30881],
  Cell[74506, 2358, 123, 2, 70, "Subsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31718],
  Cell[74632, 2362, 1121, 24, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->16588],
  Cell[75778, 2390, 164, 4, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->5351],
  Cell[75945, 2396, 170, 6, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17252],
  Cell[76140, 2406, 158, 4, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15857],
  Cell[76301, 2412, 1194, 29, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26865],
  Cell[77510, 2444, 330, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->20975],
  Cell[78438, 2467, 173, 5, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11351],
  Cell[78636, 2476, 112, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26102],
  Cell[78751, 2480, 124, 2, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->5750],
  Cell[78878, 2484, 168, 5, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11788],
  Cell[79049, 2491, 881, 17, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26747],
  Cell[79933, 2510, 575, 18, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->72],
  Cell[80511, 2530, 1102, 26, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17290],
  Cell[81662, 2562, 132, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31219],
  Cell[81797, 2566, 170, 6, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13717],
  Cell[81992, 2576, 157, 4, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1993],
  Cell[82152, 2582, 930, 25, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->23760],
  Cell[83097, 2610, 330, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->10756],
  Cell[84027, 2633, 172, 5, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7693],
  Cell[84224, 2642, 117, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31199],
  Cell[84344, 2646, 125, 2, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17032],
  Cell[84530, 2655, 158, 4, 70, "Subsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18849],
  Cell[84713, 2663, 117, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->28873],
  Cell[84833, 2667, 204, 7, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->2057954430],
  Cell[85040, 2676, 394, 13, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->668486428],
  Cell[88123, 2784, 368, 13, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->840171588],
  Cell[89516, 2834, 126, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18025],
  Cell[89645, 2838, 174, 5, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32364],
  Cell[89822, 2845, 161, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4000],
  Cell[89986, 2850, 444, 15, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22332],
  Cell[90433, 2867, 133, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->23022],
  Cell[90569, 2871, 382, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9145],
  Cell[90954, 2885, 161, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30053],
  Cell[92060, 2918, 146, 3, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17709],
  Cell[92209, 2923, 344, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->20895],
  Cell[92556, 2937, 314, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->6747],
  Cell[92873, 2948, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4508],
  Cell[93885, 2979, 361, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9319],
  Cell[94686, 3007, 310, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31634],
  Cell[94999, 3018, 131, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7136],
  Cell[95972, 3047, 193, 4, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3123],
  Cell[97077, 3086, 546, 19, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3375],
  Cell[97626, 3107, 145, 3, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->6546],
  Cell[98188, 3128, 351, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30439],
  Cell[98542, 3137, 347, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->25048],
  Cell[98892, 3151, 236, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->14565],
  Cell[99131, 3161, 377, 10, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18962],
  Cell[99511, 3173, 117, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31168],
  Cell[100588, 3209, 178, 5, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3719],
  Cell[100769, 3216, 216, 5, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15469],
  Cell[100988, 3223, 161, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9982],
  Cell[101152, 3228, 203, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->8113],
  Cell[101358, 3237, 132, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3287],
  Cell[101493, 3241, 397, 13, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32340],
  Cell[101893, 3256, 166, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->2072838626],
  Cell[103004, 3289, 150, 3, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->805857504],
  Cell[103157, 3294, 344, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30290],
  Cell[103504, 3308, 315, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18321],
  Cell[103822, 3319, 135, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->636],
  Cell[104834, 3350, 234, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18677],
  Cell[105977, 3393, 236, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11620],
  Cell[106216, 3403, 121, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->282216253]},
 "parts"->{
  Cell[18722, 551, 176, 6, 70, "Subsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->31065],
  Cell[18901, 559, 432, 11, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->32706],
  Cell[19749, 586, 109, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->25820],
  Cell[19861, 590, 997, 26, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->5312],
  Cell[20883, 620, 129, 2, 70, "Subsubsubsection",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->20204],
  Cell[21015, 624, 1325, 34, 70, "Text",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->19602],
  Cell[22377, 663, 163, 4, 70, "Subsubsubsection",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->29197],
  Cell[22543, 669, 580, 15, 70, "Text",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->32136],
  Cell[23160, 689, 175, 7, 70, "Subsubsubsection",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->8643],
  Cell[23338, 698, 608, 16, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->29116],
  Cell[23949, 716, 281, 8, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->12306],
  Cell[24233, 726, 490, 12, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->22978],
  Cell[25641, 764, 537, 16, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->32624],
  Cell[26181, 782, 159, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->25115],
  Cell[26343, 788, 164, 3, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->12473],
  Cell[26510, 793, 525, 13, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->26160],
  Cell[27038, 808, 135, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4678],
  Cell[27176, 812, 283, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->22336],
  Cell[27462, 818, 208, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24719],
  Cell[27673, 827, 308, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24608],
  Cell[27984, 836, 148, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->25188],
  Cell[28135, 842, 163, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->7782],
  Cell[28301, 847, 519, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4321],
  Cell[28823, 862, 132, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->14616],
  Cell[28958, 866, 273, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10223],
  Cell[29234, 872, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->12712],
  Cell[29441, 881, 298, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11186],
  Cell[29742, 890, 406, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->27170],
  Cell[30151, 905, 153, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4766],
  Cell[30307, 911, 146, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->29042],
  Cell[30456, 915, 407, 10, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->268],
  Cell[30866, 927, 136, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->28458],
  Cell[31005, 931, 278, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->10876],
  Cell[31286, 937, 207, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4662],
  Cell[31496, 946, 303, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->19946],
  Cell[31802, 955, 244, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->16981],
  Cell[32203, 971, 146, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11753],
  Cell[32352, 977, 159, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4704],
  Cell[32514, 982, 404, 10, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10838],
  Cell[32921, 994, 131, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8597],
  Cell[33055, 998, 270, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4322],
  Cell[33328, 1004, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->19595],
  Cell[33535, 1013, 295, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8911],
  Cell[33833, 1022, 307, 9, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->21115],
  Cell[34594, 1051, 111, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->31221],
  Cell[34730, 1057, 129, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->237],
  Cell[34862, 1061, 240, 6, 70, "Text",
   CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
   CellID->22604],
  Cell[35105, 1069, 930, 22, 70, "Text",
   CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
   CellID->5578],
  Cell[36072, 1096, 123, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->14640],
  Cell[36198, 1100, 562, 13, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->1864],
  Cell[36763, 1115, 142, 3, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->20566],
  Cell[36908, 1120, 735, 17, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->1694],
  Cell[37680, 1142, 123, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->25411],
  Cell[37806, 1146, 130, 2, 70, "Text",
   CellTags->{"mprep", "parts", "WindowsInstalling"},
   CellID->8957],
  Cell[37939, 1150, 547, 14, 70, "Text",
   CellTags->{"mprep", "parts", "WindowsInstalling"},
   CellID->31807],
  Cell[38535, 1170, 122, 2, 70, "Subsubsection",
   CellTags->{"prebuilt", "parts", "WindowsInstalling"},
   CellID->24407],
  Cell[38660, 1174, 599, 14, 70, "Text",
   CellTags->{"prebuilt", "parts", "WindowsInstalling"},
   CellID->227],
  Cell[39296, 1193, 125, 2, 70, "Subsubsection",
   CellTags->{"parts", "sample code", "WindowsInstalling"},
   CellID->13686],
  Cell[39424, 1197, 399, 12, 70, "Text",
   CellTags->{"parts", "sample code", "WindowsInstalling"},
   CellID->7943],
  Cell[39860, 1214, 99, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->5035],
  Cell[39962, 1218, 158, 4, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->3112],
  Cell[40157, 1227, 115, 2, 70, "Subsubsection",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->8231],
  Cell[40275, 1231, 127, 2, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->17049],
  Cell[40405, 1235, 440, 11, 70, "Text",
   CellTags->{"parts", "WindowsInstalling"},
   CellID->1206]},
 "MathLinkLibraries"->{
  Cell[20883, 620, 129, 2, 70, "Subsubsubsection",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->20204],
  Cell[21015, 624, 1325, 34, 70, "Text",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->19602],
  Cell[22377, 663, 163, 4, 70, "Subsubsubsection",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->29197],
  Cell[22543, 669, 580, 15, 70, "Text",
   CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
   CellID->32136]},
 "devices"->{
  Cell[23160, 689, 175, 7, 70, "Subsubsubsection",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->8643],
  Cell[23338, 698, 608, 16, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->29116],
  Cell[23949, 716, 281, 8, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->12306],
  Cell[24233, 726, 490, 12, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->22978],
  Cell[25641, 764, 537, 16, 70, "Text",
   CellTags->{"devices", "parts", "WindowsInstalling"},
   CellID->32624],
  Cell[26181, 782, 159, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->25115],
  Cell[26343, 788, 164, 3, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->12473],
  Cell[26510, 793, 525, 13, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->26160],
  Cell[27038, 808, 135, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4678],
  Cell[27176, 812, 283, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->22336],
  Cell[27462, 818, 208, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24719],
  Cell[27673, 827, 308, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24608],
  Cell[27984, 836, 148, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->25188],
  Cell[28135, 842, 163, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->7782],
  Cell[28301, 847, 519, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4321],
  Cell[28823, 862, 132, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->14616],
  Cell[28958, 866, 273, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10223],
  Cell[29234, 872, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->12712],
  Cell[29441, 881, 298, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11186],
  Cell[29742, 890, 406, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->27170],
  Cell[30151, 905, 153, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4766],
  Cell[30307, 911, 146, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->29042],
  Cell[30456, 915, 407, 10, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->268],
  Cell[30866, 927, 136, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->28458],
  Cell[31005, 931, 278, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->10876],
  Cell[31286, 937, 207, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4662],
  Cell[31496, 946, 303, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->19946],
  Cell[31802, 955, 244, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->16981],
  Cell[32203, 971, 146, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11753],
  Cell[32352, 977, 159, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4704],
  Cell[32514, 982, 404, 10, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10838],
  Cell[32921, 994, 131, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8597],
  Cell[33055, 998, 270, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4322],
  Cell[33328, 1004, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->19595],
  Cell[33535, 1013, 295, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8911],
  Cell[33833, 1022, 307, 9, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->21115]},
 "FileMap"->{
  Cell[26181, 782, 159, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->25115],
  Cell[26343, 788, 164, 3, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->12473],
  Cell[26510, 793, 525, 13, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->26160],
  Cell[27038, 808, 135, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4678],
  Cell[27176, 812, 283, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->22336],
  Cell[27462, 818, 208, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24719],
  Cell[27673, 827, 308, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->24608],
  Cell[30151, 905, 153, 4, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4766],
  Cell[30307, 911, 146, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->29042],
  Cell[30456, 915, 407, 10, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->268],
  Cell[30866, 927, 136, 2, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->28458],
  Cell[31005, 931, 278, 4, 70, "Program",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->10876],
  Cell[31286, 937, 207, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->4662],
  Cell[31496, 946, 303, 7, 70, "Input",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->19946],
  Cell[31802, 955, 244, 7, 70, "Text",
   CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
   CellID->16981]},
 "TCP"->{
  Cell[27984, 836, 148, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->25188],
  Cell[28135, 842, 163, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->7782],
  Cell[28301, 847, 519, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4321],
  Cell[28823, 862, 132, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->14616],
  Cell[28958, 866, 273, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10223],
  Cell[29234, 872, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->12712],
  Cell[29441, 881, 298, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11186],
  Cell[29742, 890, 406, 13, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->27170],
  Cell[32203, 971, 146, 4, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->11753],
  Cell[32352, 977, 159, 3, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4704],
  Cell[32514, 982, 404, 10, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->10838],
  Cell[32921, 994, 131, 2, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8597],
  Cell[33055, 998, 270, 4, 70, "Program",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->4322],
  Cell[33328, 1004, 204, 7, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->19595],
  Cell[33535, 1013, 295, 7, 70, "Input",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->8911],
  Cell[33833, 1022, 307, 9, 70, "Text",
   CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
   CellID->21115]},
 "mathlink.h"->{
  Cell[34862, 1061, 240, 6, 70, "Text",
   CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
   CellID->22604],
  Cell[35105, 1069, 930, 22, 70, "Text",
   CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
   CellID->5578]},
 "mprep"->{
  Cell[37806, 1146, 130, 2, 70, "Text",
   CellTags->{"mprep", "parts", "WindowsInstalling"},
   CellID->8957],
  Cell[37939, 1150, 547, 14, 70, "Text",
   CellTags->{"mprep", "parts", "WindowsInstalling"},
   CellID->31807],
  Cell[46851, 1444, 165, 7, 70, "Subsection",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->4205],
  Cell[47019, 1453, 1433, 39, 70, "Text",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->6900],
  Cell[48455, 1494, 97, 2, 70, "Text",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->4732],
  Cell[48555, 1498, 188, 8, 70, "Program",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->11456],
  Cell[48746, 1508, 506, 9, 70, "Text",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->18636],
  Cell[49255, 1519, 292, 14, 70, "Program",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->11210]},
 "prebuilt"->{
  Cell[38535, 1170, 122, 2, 70, "Subsubsection",
   CellTags->{"prebuilt", "parts", "WindowsInstalling"},
   CellID->24407],
  Cell[38660, 1174, 599, 14, 70, "Text",
   CellTags->{"prebuilt", "parts", "WindowsInstalling"},
   CellID->227]},
 "sample code"->{
  Cell[39296, 1193, 125, 2, 70, "Subsubsection",
   CellTags->{"parts", "sample code", "WindowsInstalling"},
   CellID->13686],
  Cell[39424, 1197, 399, 12, 70, "Text",
   CellTags->{"parts", "sample code", "WindowsInstalling"},
   CellID->7943]},
 "WindowsBuilding"->{
  Cell[40906, 1253, 149, 7, 70, "Section",
   CellTags->"WindowsBuilding",
   CellID->25303],
  Cell[41058, 1262, 1061, 33, 70, "Text",
   CellTags->"WindowsBuilding",
   CellID->30323],
  Cell[42122, 1297, 590, 16, 70, "Text",
   CellTags->"WindowsBuilding",
   CellID->18001],
  Cell[42737, 1317, 156, 6, 70, "Subsection",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->17041],
  Cell[42896, 1325, 451, 13, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->9845],
  Cell[43372, 1342, 95, 2, 70, "Subsubsection",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->23630],
  Cell[43470, 1346, 557, 18, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->5094],
  Cell[44030, 1366, 445, 12, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->10400],
  Cell[44478, 1380, 768, 18, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->8993],
  Cell[45249, 1400, 894, 22, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->12038],
  Cell[46146, 1424, 656, 14, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->3561],
  Cell[46851, 1444, 165, 7, 70, "Subsection",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->4205],
  Cell[47019, 1453, 1433, 39, 70, "Text",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->6900],
  Cell[48455, 1494, 97, 2, 70, "Text",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->4732],
  Cell[48555, 1498, 188, 8, 70, "Program",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->11456],
  Cell[48746, 1508, 506, 9, 70, "Text",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->18636],
  Cell[49255, 1519, 292, 14, 70, "Program",
   CellTags->{"mprep", "WindowsBuilding"},
   CellID->11210],
  Cell[49584, 1538, 196, 7, 70, "Subsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13917],
  Cell[49805, 1549, 114, 2, 70, "Subsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->12593],
  Cell[51520, 1592, 256, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15467],
  Cell[51779, 1604, 116, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15605],
  Cell[52516, 1624, 260, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22383],
  Cell[52779, 1632, 294, 9, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->24653],
  Cell[53456, 1660, 117, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1439],
  Cell[53576, 1664, 429, 10, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4826],
  Cell[54320, 1691, 251, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31942],
  Cell[54574, 1703, 116, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11929],
  Cell[55311, 1723, 259, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3527],
  Cell[55573, 1731, 280, 8, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->28540],
  Cell[56236, 1758, 118, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13886],
  Cell[56357, 1762, 339, 8, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18443],
  Cell[56997, 1787, 253, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->23792],
  Cell[57253, 1799, 115, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22910],
  Cell[57393, 1805, 850, 22, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17889],
  Cell[58246, 1829, 417, 9, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->12069],
  Cell[58945, 1852, 114, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31391],
  Cell[59062, 1856, 115, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->16139],
  Cell[59180, 1860, 235, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1835],
  Cell[59418, 1870, 130, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4306],
  Cell[59551, 1874, 250, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->10039],
  Cell[59804, 1882, 138, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32173],
  Cell[59945, 1886, 129, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->21069],
  Cell[60077, 1890, 300, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7573],
  Cell[60380, 1901, 326, 6, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11444],
  Cell[60743, 1912, 251, 10, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1827],
  Cell[60997, 1924, 114, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4195],
  Cell[61136, 1930, 844, 22, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4316],
  Cell[61983, 1954, 321, 5, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->29007],
  Cell[62561, 1972, 96, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3022],
  Cell[62672, 1977, 115, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->16764],
  Cell[62790, 1981, 235, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9948],
  Cell[63028, 1991, 131, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->25008],
  Cell[63162, 1995, 250, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13772],
  Cell[63415, 2003, 137, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7008],
  Cell[63555, 2007, 129, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13790],
  Cell[63687, 2011, 205, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->29157],
  Cell[63895, 2021, 133, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->5047],
  Cell[64031, 2025, 141, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->831],
  Cell[64175, 2030, 126, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->29086],
  Cell[64304, 2034, 186, 6, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31696],
  Cell[64493, 2042, 105, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30906],
  Cell[64601, 2046, 300, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7467],
  Cell[64904, 2057, 537, 16, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->21814],
  Cell[65444, 2075, 325, 6, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->6190],
  Cell[65806, 2086, 122, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9047],
  Cell[65931, 2090, 1880, 53, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22153],
  Cell[67848, 2148, 121, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18470],
  Cell[67972, 2152, 1852, 54, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->610],
  Cell[69861, 2211, 114, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->21605],
  Cell[69978, 2215, 798, 21, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4709],
  Cell[70779, 2238, 77, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22971],
  Cell[70859, 2242, 1049, 29, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26471],
  Cell[71911, 2273, 76, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7242],
  Cell[71990, 2277, 699, 18, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->2332],
  Cell[72692, 2297, 77, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->28842],
  Cell[72772, 2301, 832, 23, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32420],
  Cell[73607, 2326, 81, 2, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->659339814],
  Cell[73691, 2330, 727, 19, 70, "DefinitionBox",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30881],
  Cell[74506, 2358, 123, 2, 70, "Subsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31718],
  Cell[74632, 2362, 1121, 24, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->16588],
  Cell[75778, 2390, 164, 4, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->5351],
  Cell[75945, 2396, 170, 6, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17252],
  Cell[76140, 2406, 158, 4, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15857],
  Cell[76301, 2412, 1194, 29, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26865],
  Cell[77510, 2444, 330, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->20975],
  Cell[78438, 2467, 173, 5, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11351],
  Cell[78636, 2476, 112, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26102],
  Cell[78751, 2480, 124, 2, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->5750],
  Cell[78878, 2484, 168, 5, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11788],
  Cell[79049, 2491, 881, 17, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->26747],
  Cell[79933, 2510, 575, 18, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->72],
  Cell[80511, 2530, 1102, 26, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17290],
  Cell[81662, 2562, 132, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31219],
  Cell[81797, 2566, 170, 6, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->13717],
  Cell[81992, 2576, 157, 4, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->1993],
  Cell[82152, 2582, 930, 25, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->23760],
  Cell[83097, 2610, 330, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->10756],
  Cell[84027, 2633, 172, 5, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7693],
  Cell[84224, 2642, 117, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31199],
  Cell[84344, 2646, 125, 2, 70, "Program",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17032],
  Cell[84530, 2655, 158, 4, 70, "Subsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18849],
  Cell[84713, 2663, 117, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->28873],
  Cell[84833, 2667, 204, 7, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->2057954430],
  Cell[85040, 2676, 394, 13, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->668486428],
  Cell[88123, 2784, 368, 13, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->840171588],
  Cell[89516, 2834, 126, 2, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18025],
  Cell[89645, 2838, 174, 5, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32364],
  Cell[89822, 2845, 161, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4000],
  Cell[89986, 2850, 444, 15, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->22332],
  Cell[90433, 2867, 133, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->23022],
  Cell[90569, 2871, 382, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9145],
  Cell[90954, 2885, 161, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30053],
  Cell[92060, 2918, 146, 3, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->17709],
  Cell[92209, 2923, 344, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->20895],
  Cell[92556, 2937, 314, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->6747],
  Cell[92873, 2948, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->4508],
  Cell[93885, 2979, 361, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9319],
  Cell[94686, 3007, 310, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31634],
  Cell[94999, 3018, 131, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->7136],
  Cell[95972, 3047, 193, 4, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3123],
  Cell[97077, 3086, 546, 19, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3375],
  Cell[97626, 3107, 145, 3, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->6546],
  Cell[98188, 3128, 351, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30439],
  Cell[98542, 3137, 347, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->25048],
  Cell[98892, 3151, 236, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->14565],
  Cell[99131, 3161, 377, 10, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18962],
  Cell[99511, 3173, 117, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->31168],
  Cell[100588, 3209, 178, 5, 70, "Subsubsubsection",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3719],
  Cell[100769, 3216, 216, 5, 70, "Text",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->15469],
  Cell[100988, 3223, 161, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->9982],
  Cell[101152, 3228, 203, 7, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->8113],
  Cell[101358, 3237, 132, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->3287],
  Cell[101493, 3241, 397, 13, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->32340],
  Cell[101893, 3256, 166, 3, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->2072838626],
  Cell[103004, 3289, 150, 3, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->805857504],
  Cell[103157, 3294, 344, 12, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->30290],
  Cell[103504, 3308, 315, 9, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18321],
  Cell[103822, 3319, 135, 2, 70, "ItemizedTextParagraph",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->636],
  Cell[104834, 3350, 234, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->18677],
  Cell[105977, 3393, 236, 8, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->11620],
  Cell[106216, 3403, 121, 2, 70, "ItemizedText",
   CellTags->{"Microsoft", "WindowsBuilding"},
   CellID->282216253]},
 "Versioning"->{
  Cell[42737, 1317, 156, 6, 70, "Subsection",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->17041],
  Cell[42896, 1325, 451, 13, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->9845],
  Cell[43372, 1342, 95, 2, 70, "Subsubsection",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->23630],
  Cell[43470, 1346, 557, 18, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->5094],
  Cell[44030, 1366, 445, 12, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->10400],
  Cell[44478, 1380, 768, 18, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->8993],
  Cell[45249, 1400, 894, 22, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->12038],
  Cell[46146, 1424, 656, 14, 70, "Text",
   CellTags->{"Versioning", "WindowsBuilding"},
   CellID->3561]},
 "WindowsRunning"->{
  Cell[107143, 3434, 147, 7, 70, "Section",
   CellTags->"WindowsRunning",
   CellID->26613],
  Cell[107293, 3443, 784, 20, 70, "Text",
   CellTags->"WindowsRunning",
   CellID->16696],
  Cell[108080, 3465, 292, 8, 70, "Text",
   CellTags->"WindowsRunning",
   CellID->12389],
  Cell[108375, 3475, 1566, 35, 70, "Text",
   CellTags->"WindowsRunning",
   CellID->6894],
  Cell[109966, 3514, 191, 7, 70, "Subsection",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->30804],
  Cell[110160, 3523, 1347, 38, 70, "Text",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->31119],
  Cell[111510, 3563, 902, 17, 70, "Program",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->6219],
  Cell[112971, 3601, 164, 4, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->18461],
  Cell[113138, 3607, 125, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->19295],
  Cell[113266, 3612, 287, 9, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->32652],
  Cell[113556, 3623, 106, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->23643],
  Cell[113665, 3628, 95, 2, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->371719980],
  Cell[113763, 3632, 144, 4, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->12747],
  Cell[113910, 3638, 216, 5, 70, "Text",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->7965],
  Cell[114129, 3645, 242, 7, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->30284],
  Cell[114374, 3654, 218, 8, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->1124],
  Cell[114595, 3664, 132, 2, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->15953],
  Cell[114730, 3668, 193, 6, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->32525],
  Cell[114926, 3676, 175, 6, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->12110],
  Cell[115104, 3684, 172, 5, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->21792],
  Cell[115279, 3691, 616, 19, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->12197],
  Cell[115898, 3712, 105, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->497],
  Cell[116006, 3717, 140, 3, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->20805],
  Cell[116149, 3722, 121, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->4112],
  Cell[116307, 3730, 198, 7, 70, "Subsection",
   CellTags->{"factor", "WindowsRunning"},
   CellID->3856],
  Cell[116508, 3739, 553, 14, 70, "Text",
   CellTags->{"factor", "WindowsRunning"},
   CellID->23256],
  Cell[117064, 3755, 928, 23, 70, "Text",
   CellTags->{"factor", "WindowsRunning"},
   CellID->27730],
  Cell[117995, 3780, 110, 2, 70, "Text",
   CellTags->{"factor", "WindowsRunning"},
   CellID->11231],
  Cell[118108, 3784, 104, 2, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->23034],
  Cell[118215, 3788, 179, 5, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->28501],
  Cell[118419, 3797, 109, 2, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->24171],
  Cell[118531, 3801, 119, 2, 70, "Program",
   CellTags->{"factor", "WindowsRunning"},
   CellID->6438],
  Cell[118665, 3806, 151, 3, 70, "ItemizedTextParagraph",
   CellTags->{"factor", "WindowsRunning"},
   CellID->20656],
  Cell[118819, 3811, 100, 2, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->13265],
  Cell[118922, 3815, 171, 4, 70, "ItemizedTextParagraph",
   CellTags->{"factor", "WindowsRunning"},
   CellID->27236],
  Cell[119118, 3823, 286, 7, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->28469],
  Cell[119407, 3832, 130, 2, 70, "Program",
   CellTags->{"factor", "WindowsRunning"},
   CellID->19924],
  Cell[119574, 3839, 338, 11, 70, "ItemizedTextParagraph",
   CellTags->{"factor", "WindowsRunning"},
   CellID->30386],
  Cell[119915, 3852, 330, 10, 70, "Program",
   CellTags->{"factor", "WindowsRunning"},
   CellID->18972],
  Cell[120294, 3868, 106, 2, 70, "Subsection",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->20802],
  Cell[120403, 3872, 1848, 61, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->13652],
  Cell[122254, 3935, 956, 31, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->25471],
  Cell[123213, 3968, 364, 9, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->13580],
  Cell[123580, 3979, 236, 7, 70, "Input",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->10925],
  Cell[123819, 3988, 266, 6, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->20380],
  Cell[124088, 3996, 175, 5, 70, "Input",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->16708],
  Cell[124266, 4003, 151, 3, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->13599]},
 "addtwo"->{
  Cell[109966, 3514, 191, 7, 70, "Subsection",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->30804],
  Cell[110160, 3523, 1347, 38, 70, "Text",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->31119],
  Cell[111510, 3563, 902, 17, 70, "Program",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->6219],
  Cell[112415, 3582, 108, 2, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->9425],
  Cell[112526, 3586, 276, 7, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->19900],
  Cell[112805, 3595, 163, 4, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->3248],
  Cell[112971, 3601, 164, 4, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->18461],
  Cell[113138, 3607, 125, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->19295],
  Cell[113266, 3612, 287, 9, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->32652],
  Cell[113556, 3623, 106, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->23643],
  Cell[113665, 3628, 95, 2, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->371719980],
  Cell[113763, 3632, 144, 4, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->12747],
  Cell[113910, 3638, 216, 5, 70, "Text",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->7965],
  Cell[114129, 3645, 242, 7, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->30284],
  Cell[114374, 3654, 218, 8, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->1124],
  Cell[114595, 3664, 132, 2, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->15953],
  Cell[114730, 3668, 193, 6, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->32525],
  Cell[114926, 3676, 175, 6, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->12110],
  Cell[115104, 3684, 172, 5, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->21792],
  Cell[115279, 3691, 616, 19, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->12197],
  Cell[115898, 3712, 105, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->497],
  Cell[116006, 3717, 140, 3, 70, "MathCaption",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->20805],
  Cell[116149, 3722, 121, 3, 70, "Input",
   CellTags->{"addtwo", "WindowsRunning"},
   CellID->4112]},
 "MacRunning"->{
  Cell[112415, 3582, 108, 2, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->9425],
  Cell[112526, 3586, 276, 7, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->19900],
  Cell[112805, 3595, 163, 4, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->3248]},
 "factor"->{
  Cell[116307, 3730, 198, 7, 70, "Subsection",
   CellTags->{"factor", "WindowsRunning"},
   CellID->3856],
  Cell[116508, 3739, 553, 14, 70, "Text",
   CellTags->{"factor", "WindowsRunning"},
   CellID->23256],
  Cell[117064, 3755, 928, 23, 70, "Text",
   CellTags->{"factor", "WindowsRunning"},
   CellID->27730],
  Cell[117995, 3780, 110, 2, 70, "Text",
   CellTags->{"factor", "WindowsRunning"},
   CellID->11231],
  Cell[118108, 3784, 104, 2, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->23034],
  Cell[118215, 3788, 179, 5, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->28501],
  Cell[118419, 3797, 109, 2, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->24171],
  Cell[118531, 3801, 119, 2, 70, "Program",
   CellTags->{"factor", "WindowsRunning"},
   CellID->6438],
  Cell[118665, 3806, 151, 3, 70, "ItemizedTextParagraph",
   CellTags->{"factor", "WindowsRunning"},
   CellID->20656],
  Cell[118819, 3811, 100, 2, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->13265],
  Cell[118922, 3815, 171, 4, 70, "ItemizedTextParagraph",
   CellTags->{"factor", "WindowsRunning"},
   CellID->27236],
  Cell[119118, 3823, 286, 7, 70, "ItemizedText",
   CellTags->{"factor", "WindowsRunning"},
   CellID->28469],
  Cell[119407, 3832, 130, 2, 70, "Program",
   CellTags->{"factor", "WindowsRunning"},
   CellID->19924],
  Cell[119574, 3839, 338, 11, 70, "ItemizedTextParagraph",
   CellTags->{"factor", "WindowsRunning"},
   CellID->30386],
  Cell[119915, 3852, 330, 10, 70, "Program",
   CellTags->{"factor", "WindowsRunning"},
   CellID->18972]},
 "protocols"->{
  Cell[120294, 3868, 106, 2, 70, "Subsection",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->20802],
  Cell[120403, 3872, 1848, 61, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->13652],
  Cell[122254, 3935, 956, 31, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->25471],
  Cell[123213, 3968, 364, 9, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->13580],
  Cell[123580, 3979, 236, 7, 70, "Input",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->10925],
  Cell[123819, 3988, 266, 6, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->20380],
  Cell[124088, 3996, 175, 5, 70, "Input",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->16708],
  Cell[124266, 4003, 151, 3, 70, "Text",
   CellTags->{"protocols", "WindowsRunning"},
   CellID->13599]},
 "WindowsTroubleshooting"->{
  Cell[124466, 4012, 87, 2, 70, "Section",
   CellTags->"WindowsTroubleshooting",
   CellID->15385],
  Cell[124556, 4016, 709, 16, 70, "BulletedText",
   CellTags->"WindowsTroubleshooting",
   CellID->4139],
  Cell[125268, 4034, 450, 14, 70, "BulletedText",
   CellTags->"WindowsTroubleshooting",
   CellID->26927],
  Cell[125721, 4050, 560, 10, 70, "BulletedText",
   CellTags->"WindowsTroubleshooting",
   CellID->26728],
  Cell[126284, 4062, 764, 23, 70, "BulletedText",
   CellTags->"WindowsTroubleshooting",
   CellID->11304],
  Cell[127051, 4087, 314, 7, 70, "BulletedText",
   CellTags->"WindowsTroubleshooting",
   CellID->14368],
  Cell[127368, 4096, 788, 25, 70, "BulletedText",
   CellTags->"WindowsTroubleshooting",
   CellID->26396],
  Cell[128159, 4123, 664, 20, 70, "BulletedText",
   CellTags->"WindowsTroubleshooting",
   CellID->12975]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"WindowsIntroduction", 136200, 4365},
 {"WindowsOverview", 136594, 4378},
 {"WindowsCompilers", 137067, 4394},
 {"WindowsInstalling", 137366, 4404},
 {"Recommended Installation", 147105, 4648},
 {"Microsoft", 148652, 4682},
 {"parts", 163982, 5079},
 {"MathLinkLibraries", 171620, 5272},
 {"devices", 172158, 5285},
 {"FileMap", 176581, 5394},
 {"TCP", 178472, 5440},
 {"mathlink.h", 180434, 5489},
 {"mprep", 180683, 5496},
 {"prebuilt", 181548, 5521},
 {"sample code", 181807, 5528},
 {"WindowsBuilding", 182077, 5535},
 {"Versioning", 198035, 5959},
 {"WindowsRunning", 198929, 5984},
 {"addtwo", 203958, 6126},
 {"MacRunning", 206414, 6196},
 {"factor", 206732, 6206},
 {"protocols", 208402, 6252},
 {"WindowsTroubleshooting", 209291, 6277}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3960, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4585, 108, 152, 6, 70, "Title",
 CellTags->"WindowsIntroduction",
 CellID->90],
Cell[4740, 116, 910, 29, 70, "Text",
 CellTags->"WindowsIntroduction",
 CellID->19725],
Cell[5653, 147, 676, 15, 70, "Text",
 CellTags->"WindowsIntroduction",
 CellID->14107],
Cell[6332, 164, 311, 9, 70, "Text",
 CellTags->"WindowsIntroduction",
 CellID->5883],
Cell[CellGroupData[{
Cell[6668, 177, 73, 2, 70, "Section",
 CellTags->"WindowsOverview",
 CellID->15002],
Cell[6744, 181, 1161, 26, 70, "Text",
 CellTags->"WindowsOverview",
 CellID->17960],
Cell[7908, 209, 311, 9, 70, "Text",
 CellID->235319443],
Cell[8222, 220, 434, 11, 70, "Text",
 CellTags->"WindowsOverview",
 CellID->6968],
Cell[8659, 233, 493, 19, 70, "Text",
 CellTags->"WindowsOverview",
 CellID->7373],
Cell[9155, 254, 638, 18, 70, "Text",
 CellTags->"WindowsOverview",
 CellID->7666]
}, Open  ]],
Cell[CellGroupData[{
Cell[9830, 277, 97, 2, 70, "Section",
 CellTags->"WindowsCompilers",
 CellID->14658],
Cell[9930, 281, 477, 13, 70, "Text",
 CellTags->"WindowsCompilers",
 CellID->5140],
Cell[10410, 296, 539, 10, 70, "Text",
 CellTags->"WindowsCompilers",
 CellID->26887]
}, Open  ]],
Cell[CellGroupData[{
Cell[10986, 311, 159, 7, 70, "Section",
 CellTags->"WindowsInstalling",
 CellID->26660],
Cell[11148, 320, 475, 17, 70, "Text",
 CellTags->"WindowsInstalling",
 CellID->18916],
Cell[11626, 339, 1214, 32, 70, "Text",
 CellTags->"WindowsInstalling",
 CellID->3163],
Cell[CellGroupData[{
Cell[12865, 375, 124, 2, 70, "Subsection",
 CellTags->{"Recommended Installation", "WindowsInstalling"},
 CellID->14115],
Cell[CellGroupData[{
Cell[13014, 381, 147, 2, 70, "Subsubsection",
 CellTags->{"Recommended Installation", "WindowsInstalling"},
 CellID->366],
Cell[13164, 385, 583, 20, 70, "Text",
 CellTags->{"Recommended Installation", "WindowsInstalling"},
 CellID->1465]
}, Open  ]],
Cell[CellGroupData[{
Cell[13784, 410, 170, 2, 70, "Subsubsection",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->15232],
Cell[13957, 414, 706, 16, 70, "Text",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->19874],
Cell[CellGroupData[{
Cell[14688, 434, 653, 12, 70, "ItemizedText",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->19078],
Cell[15344, 448, 266, 5, 70, "Program",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->4337]
}, Open  ]],
Cell[15625, 456, 248, 7, 70, "ItemizedTextParagraph",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->16800],
Cell[15876, 465, 473, 12, 70, "ItemizedText",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->12848],
Cell[16352, 479, 257, 5, 70, "ItemizedText",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->27993],
Cell[16612, 486, 373, 7, 70, "ItemizedTextParagraph",
 CellTags->{"Recommended Installation", "Microsoft", "WindowsInstalling"},
 CellID->5958],
Cell[16988, 495, 515, 12, 70, "ItemizedTextParagraph",
 CellID->70735498]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17552, 513, 166, 7, 70, "Subsection",
 CellTags->"WindowsInstalling",
 CellID->19058],
Cell[17721, 522, 330, 8, 70, "Text",
 CellTags->"WindowsInstalling",
 CellID->24682],
Cell[18054, 532, 631, 14, 70, "Text",
 CellTags->"WindowsInstalling",
 CellID->26617]
}, Open  ]],
Cell[CellGroupData[{
Cell[18722, 551, 176, 6, 70, "Subsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->31065],
Cell[18901, 559, 432, 11, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->32706],
Cell[19336, 572, 388, 10, 70, "Text",
 CellID->466277946],
Cell[CellGroupData[{
Cell[19749, 586, 109, 2, 70, "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->25820],
Cell[19861, 590, 997, 26, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->5312],
Cell[CellGroupData[{
Cell[20883, 620, 129, 2, 70, "Subsubsubsection",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->20204],
Cell[21015, 624, 1325, 34, 70, "Text",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->19602]
}, Open  ]],
Cell[CellGroupData[{
Cell[22377, 663, 163, 4, 70, "Subsubsubsection",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->29197],
Cell[22543, 669, 580, 15, 70, "Text",
 CellTags->{"MathLinkLibraries", "parts", "WindowsInstalling"},
 CellID->32136]
}, Open  ]],
Cell[CellGroupData[{
Cell[23160, 689, 175, 7, 70, "Subsubsubsection",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->8643],
Cell[23338, 698, 608, 16, 70, "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->29116],
Cell[23949, 716, 281, 8, 70, "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->12306],
Cell[24233, 726, 490, 12, 70, "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->22978],
Cell[24726, 740, 912, 22, 70, "Text",
 CellID->1208933910],
Cell[25641, 764, 537, 16, 70, "Text",
 CellTags->{"devices", "parts", "WindowsInstalling"},
 CellID->32624],
Cell[26181, 782, 159, 4, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->25115],
Cell[26343, 788, 164, 3, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->12473],
Cell[26510, 793, 525, 13, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->26160],
Cell[27038, 808, 135, 2, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->4678],
Cell[27176, 812, 283, 4, 70, "Program",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->22336],
Cell[27462, 818, 208, 7, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->24719],
Cell[27673, 827, 308, 7, 70, "Input",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->24608],
Cell[27984, 836, 148, 4, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->25188],
Cell[28135, 842, 163, 3, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->7782],
Cell[28301, 847, 519, 13, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->4321],
Cell[28823, 862, 132, 2, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->14616],
Cell[28958, 866, 273, 4, 70, "Program",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->10223],
Cell[29234, 872, 204, 7, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->12712],
Cell[29441, 881, 298, 7, 70, "Input",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->11186],
Cell[29742, 890, 406, 13, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->27170],
Cell[30151, 905, 153, 4, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->4766],
Cell[30307, 911, 146, 2, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->29042],
Cell[30456, 915, 407, 10, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->268],
Cell[30866, 927, 136, 2, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->28458],
Cell[31005, 931, 278, 4, 70, "Program",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->10876],
Cell[31286, 937, 207, 7, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->4662],
Cell[31496, 946, 303, 7, 70, "Input",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->19946],
Cell[31802, 955, 244, 7, 70, "Text",
 CellTags->{"devices", "FileMap", "parts", "WindowsInstalling"},
 CellID->16981],
Cell[32049, 964, 151, 5, 70, "Text",
 CellID->1209441103],
Cell[32203, 971, 146, 4, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->11753],
Cell[32352, 977, 159, 3, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->4704],
Cell[32514, 982, 404, 10, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->10838],
Cell[32921, 994, 131, 2, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->8597],
Cell[33055, 998, 270, 4, 70, "Program",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->4322],
Cell[33328, 1004, 204, 7, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->19595],
Cell[33535, 1013, 295, 7, 70, "Input",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->8911],
Cell[33833, 1022, 307, 9, 70, "Text",
 CellTags->{"devices", "TCP", "parts", "WindowsInstalling"},
 CellID->21115],
Cell[34143, 1033, 402, 12, 70, "Text",
 CellID->387]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34594, 1051, 111, 2, 70, "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->31221],
Cell[CellGroupData[{
Cell[34730, 1057, 129, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->237],
Cell[34862, 1061, 240, 6, 70, "Text",
 CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
 CellID->22604],
Cell[35105, 1069, 930, 22, 70, "Text",
 CellTags->{"mathlink.h", "parts", "WindowsInstalling"},
 CellID->5578]
}, Open  ]],
Cell[CellGroupData[{
Cell[36072, 1096, 123, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->14640],
Cell[36198, 1100, 562, 13, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->1864],
Cell[36763, 1115, 142, 3, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->20566],
Cell[36908, 1120, 735, 17, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->1694]
}, Open  ]],
Cell[CellGroupData[{
Cell[37680, 1142, 123, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->25411],
Cell[37806, 1146, 130, 2, 70, "Text",
 CellTags->{"mprep", "parts", "WindowsInstalling"},
 CellID->8957],
Cell[37939, 1150, 547, 14, 70, "Text",
 CellTags->{"mprep", "parts", "WindowsInstalling"},
 CellID->31807]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38535, 1170, 122, 2, 70, "Subsubsection",
 CellTags->{"prebuilt", "parts", "WindowsInstalling"},
 CellID->24407],
Cell[38660, 1174, 599, 14, 70, "Text",
 CellTags->{"prebuilt", "parts", "WindowsInstalling"},
 CellID->227]
}, Open  ]],
Cell[CellGroupData[{
Cell[39296, 1193, 125, 2, 70, "Subsubsection",
 CellTags->{"parts", "sample code", "WindowsInstalling"},
 CellID->13686],
Cell[39424, 1197, 399, 12, 70, "Text",
 CellTags->{"parts", "sample code", "WindowsInstalling"},
 CellID->7943]
}, Open  ]],
Cell[CellGroupData[{
Cell[39860, 1214, 99, 2, 70, "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->5035],
Cell[39962, 1218, 158, 4, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->3112]
}, Open  ]],
Cell[CellGroupData[{
Cell[40157, 1227, 115, 2, 70, "Subsubsection",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->8231],
Cell[40275, 1231, 127, 2, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->17049],
Cell[40405, 1235, 440, 11, 70, "Text",
 CellTags->{"parts", "WindowsInstalling"},
 CellID->1206]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40906, 1253, 149, 7, 70, "Section",
 CellTags->"WindowsBuilding",
 CellID->25303],
Cell[41058, 1262, 1061, 33, 70, "Text",
 CellTags->"WindowsBuilding",
 CellID->30323],
Cell[42122, 1297, 590, 16, 70, "Text",
 CellTags->"WindowsBuilding",
 CellID->18001],
Cell[CellGroupData[{
Cell[42737, 1317, 156, 6, 70, "Subsection",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->17041],
Cell[42896, 1325, 451, 13, 70, "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->9845],
Cell[CellGroupData[{
Cell[43372, 1342, 95, 2, 70, "Subsubsection",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->23630],
Cell[43470, 1346, 557, 18, 70, "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->5094],
Cell[44030, 1366, 445, 12, 70, "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->10400],
Cell[44478, 1380, 768, 18, 70, "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->8993],
Cell[45249, 1400, 894, 22, 70, "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->12038],
Cell[46146, 1424, 656, 14, 70, "Text",
 CellTags->{"Versioning", "WindowsBuilding"},
 CellID->3561]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46851, 1444, 165, 7, 70, "Subsection",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->4205],
Cell[47019, 1453, 1433, 39, 70, "Text",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->6900],
Cell[48455, 1494, 97, 2, 70, "Text",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->4732],
Cell[48555, 1498, 188, 8, 70, "Program",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->11456],
Cell[48746, 1508, 506, 9, 70, "Text",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->18636],
Cell[49255, 1519, 292, 14, 70, "Program",
 CellTags->{"mprep", "WindowsBuilding"},
 CellID->11210]
}, Open  ]],
Cell[CellGroupData[{
Cell[49584, 1538, 196, 7, 70, "Subsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13917],
Cell[CellGroupData[{
Cell[49805, 1549, 114, 2, 70, "Subsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->12593],
Cell[49922, 1553, 1573, 35, 70, "Text",
 CellID->661921821],
Cell[CellGroupData[{
Cell[51520, 1592, 256, 10, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15467],
Cell[51779, 1604, 116, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15605],
Cell[51898, 1608, 593, 12, 70, "ItemizedText",
 CellID->764827484],
Cell[CellGroupData[{
Cell[52516, 1624, 260, 6, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22383],
Cell[52779, 1632, 294, 9, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->24653]
}, Open  ]],
Cell[CellGroupData[{
Cell[53110, 1646, 95, 1, 70, "ItemizedTextParagraph",
 CellID->1765896293],
Cell[53208, 1649, 211, 6, 70, "Program",
 CellID->1194994911]
}, Open  ]],
Cell[CellGroupData[{
Cell[53456, 1660, 117, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1439],
Cell[53576, 1664, 429, 10, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4826]
}, Open  ]],
Cell[CellGroupData[{
Cell[54042, 1679, 131, 3, 70, "ItemizedTextParagraph",
 CellID->1012402433],
Cell[54176, 1684, 95, 1, 70, "Program",
 CellID->934756250]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54320, 1691, 251, 10, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31942],
Cell[54574, 1703, 116, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11929],
Cell[54693, 1707, 593, 12, 70, "ItemizedText",
 CellID->185955467],
Cell[CellGroupData[{
Cell[55311, 1723, 259, 6, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3527],
Cell[55573, 1731, 280, 8, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->28540]
}, Open  ]],
Cell[CellGroupData[{
Cell[55890, 1744, 95, 1, 70, "ItemizedTextParagraph",
 CellID->1605415945],
Cell[55988, 1747, 211, 6, 70, "Program",
 CellID->1241246707]
}, Open  ]],
Cell[CellGroupData[{
Cell[56236, 1758, 118, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13886],
Cell[56357, 1762, 339, 8, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18443]
}, Open  ]],
Cell[CellGroupData[{
Cell[56733, 1775, 130, 3, 70, "ItemizedTextParagraph",
 CellID->977257591],
Cell[56866, 1780, 82, 1, 70, "Program",
 CellID->813399681]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56997, 1787, 253, 10, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->23792],
Cell[57253, 1799, 115, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22910],
Cell[CellGroupData[{
Cell[57393, 1805, 850, 22, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17889],
Cell[58246, 1829, 417, 9, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->12069]
}, Open  ]],
Cell[CellGroupData[{
Cell[58700, 1843, 131, 3, 70, "ItemizedTextParagraph",
 CellID->1126698308],
Cell[58834, 1848, 96, 1, 70, "Program",
 CellID->2055146957]
}, Open  ]],
Cell[58945, 1852, 114, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31391],
Cell[59062, 1856, 115, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->16139],
Cell[59180, 1860, 235, 8, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1835],
Cell[59418, 1870, 130, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4306],
Cell[59551, 1874, 250, 6, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->10039],
Cell[59804, 1882, 138, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32173],
Cell[59945, 1886, 129, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->21069],
Cell[60077, 1890, 300, 9, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7573],
Cell[60380, 1901, 326, 6, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11444]
}, Open  ]],
Cell[CellGroupData[{
Cell[60743, 1912, 251, 10, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1827],
Cell[60997, 1924, 114, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4195],
Cell[CellGroupData[{
Cell[61136, 1930, 844, 22, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4316],
Cell[61983, 1954, 321, 5, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->29007]
}, Open  ]],
Cell[CellGroupData[{
Cell[62341, 1964, 131, 3, 70, "ItemizedTextParagraph",
 CellID->1050915969],
Cell[62475, 1969, 83, 1, 70, "Program",
 CellID->1839178055],
Cell[62561, 1972, 96, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3022]
}, Open  ]],
Cell[62672, 1977, 115, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->16764],
Cell[62790, 1981, 235, 8, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9948],
Cell[63028, 1991, 131, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->25008],
Cell[63162, 1995, 250, 6, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13772],
Cell[63415, 2003, 137, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7008],
Cell[63555, 2007, 129, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13790],
Cell[63687, 2011, 205, 8, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->29157],
Cell[63895, 2021, 133, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->5047],
Cell[64031, 2025, 141, 3, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->831],
Cell[64175, 2030, 126, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->29086],
Cell[64304, 2034, 186, 6, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31696],
Cell[64493, 2042, 105, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30906],
Cell[64601, 2046, 300, 9, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7467],
Cell[64904, 2057, 537, 16, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->21814],
Cell[65444, 2075, 325, 6, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->6190]
}, Open  ]],
Cell[CellGroupData[{
Cell[65806, 2086, 122, 2, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9047],
Cell[65931, 2090, 1880, 53, 70, "DefinitionBox",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22153]
}, Open  ]],
Cell[CellGroupData[{
Cell[67848, 2148, 121, 2, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18470],
Cell[67972, 2152, 1852, 54, 70, "DefinitionBox",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->610]
}, Open  ]],
Cell[CellGroupData[{
Cell[69861, 2211, 114, 2, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->21605],
Cell[69978, 2215, 798, 21, 70, "DefinitionBox",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4709],
Cell[70779, 2238, 77, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22971],
Cell[70859, 2242, 1049, 29, 70, "DefinitionBox",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26471],
Cell[71911, 2273, 76, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7242],
Cell[71990, 2277, 699, 18, 70, "DefinitionBox",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->2332],
Cell[72692, 2297, 77, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->28842],
Cell[72772, 2301, 832, 23, 70, "DefinitionBox",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32420],
Cell[73607, 2326, 81, 2, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->659339814],
Cell[73691, 2330, 727, 19, 70, "DefinitionBox",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30881],
Cell[74421, 2351, 36, 1, 70, "Text",
 CellID->258979291]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74506, 2358, 123, 2, 70, "Subsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31718],
Cell[74632, 2362, 1121, 24, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->16588],
Cell[CellGroupData[{
Cell[75778, 2390, 164, 4, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->5351],
Cell[75945, 2396, 170, 6, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17252],
Cell[CellGroupData[{
Cell[76140, 2406, 158, 4, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15857],
Cell[76301, 2412, 1194, 29, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26865]
}, Open  ]],
Cell[77510, 2444, 330, 7, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->20975],
Cell[77843, 2453, 592, 12, 70, "ItemizedText",
 CellID->75896897],
Cell[78438, 2467, 173, 5, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11351],
Cell[CellGroupData[{
Cell[78636, 2476, 112, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26102],
Cell[78751, 2480, 124, 2, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->5750],
Cell[78878, 2484, 168, 5, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11788],
Cell[79049, 2491, 881, 17, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->26747],
Cell[79933, 2510, 575, 18, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->72],
Cell[80511, 2530, 1102, 26, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81662, 2562, 132, 2, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31219],
Cell[81797, 2566, 170, 6, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->13717],
Cell[CellGroupData[{
Cell[81992, 2576, 157, 4, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->1993],
Cell[82152, 2582, 930, 25, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->23760]
}, Open  ]],
Cell[83097, 2610, 330, 7, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->10756],
Cell[83430, 2619, 594, 12, 70, "ItemizedText",
 CellID->2141345208],
Cell[84027, 2633, 172, 5, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7693],
Cell[CellGroupData[{
Cell[84224, 2642, 117, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31199],
Cell[84344, 2646, 125, 2, 70, "Program",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17032]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84530, 2655, 158, 4, 70, "Subsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18849],
Cell[CellGroupData[{
Cell[84713, 2663, 117, 2, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->28873],
Cell[84833, 2667, 204, 7, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->2057954430],
Cell[85040, 2676, 394, 13, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->668486428],
Cell[85437, 2691, 123, 3, 70, "ItemizedTextParagraph",
 CellID->455532002],
Cell[85563, 2696, 279, 6, 70, "ItemizedTextParagraph",
 CellID->992523500],
Cell[85845, 2704, 223, 5, 70, "ItemizedTextParagraph",
 CellID->1836978251],
Cell[86071, 2711, 119, 3, 70, "ItemizedTextParagraph",
 CellID->347156059],
Cell[86193, 2716, 299, 8, 70, "ItemizedTextParagraph",
 CellID->1868555285],
Cell[86495, 2726, 232, 7, 70, "ItemizedTextParagraph",
 CellID->7821267],
Cell[86730, 2735, 157, 5, 70, "ItemizedText",
 CellID->306759350],
Cell[86890, 2742, 124, 3, 70, "ItemizedTextParagraph",
 CellID->1593379077],
Cell[87017, 2747, 506, 15, 70, "ItemizedTextParagraph",
 CellID->893907885],
Cell[87526, 2764, 119, 3, 70, "ItemizedTextParagraph",
 CellID->801069049],
Cell[87648, 2769, 472, 13, 70, "ItemizedTextParagraph",
 CellID->114228783],
Cell[88123, 2784, 368, 13, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->840171588],
Cell[88494, 2799, 123, 3, 70, "ItemizedTextParagraph",
 CellID->661478876],
Cell[88620, 2804, 358, 9, 70, "ItemizedTextParagraph",
 CellID->2140259110],
Cell[88981, 2815, 120, 3, 70, "ItemizedTextParagraph",
 CellID->2100112060],
Cell[89104, 2820, 375, 9, 70, "ItemizedTextParagraph",
 CellID->983774520]
}, Open  ]],
Cell[CellGroupData[{
Cell[89516, 2834, 126, 2, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18025],
Cell[89645, 2838, 174, 5, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32364],
Cell[89822, 2845, 161, 3, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4000],
Cell[89986, 2850, 444, 15, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->22332],
Cell[90433, 2867, 133, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->23022],
Cell[90569, 2871, 382, 12, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9145],
Cell[90954, 2885, 161, 3, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30053],
Cell[91118, 2890, 123, 3, 70, "ItemizedTextParagraph",
 CellID->695636565],
Cell[91244, 2895, 215, 3, 70, "ItemizedTextParagraph",
 CellID->821759387],
Cell[91462, 2900, 119, 3, 70, "ItemizedTextParagraph",
 CellID->662773687],
Cell[91584, 2905, 228, 3, 70, "ItemizedTextParagraph",
 CellID->842683452],
Cell[91815, 2910, 133, 2, 70, "ItemizedTextParagraph",
 CellID->239680420],
Cell[91951, 2914, 106, 2, 70, "ItemizedTextParagraph",
 CellID->1776980815],
Cell[92060, 2918, 146, 3, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->17709],
Cell[92209, 2923, 344, 12, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->20895],
Cell[92556, 2937, 314, 9, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->6747],
Cell[92873, 2948, 136, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->4508],
Cell[93012, 2952, 153, 4, 70, "ItemizedText",
 CellID->2086298361],
Cell[93168, 2958, 123, 3, 70, "ItemizedTextParagraph",
 CellID->303565111],
Cell[93294, 2963, 224, 3, 70, "ItemizedTextParagraph",
 CellID->1745158952],
Cell[93521, 2968, 119, 3, 70, "ItemizedTextParagraph",
 CellID->554855538],
Cell[93643, 2973, 239, 4, 70, "ItemizedTextParagraph",
 CellID->1083031892],
Cell[93885, 2979, 361, 12, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9319],
Cell[94249, 2993, 226, 5, 70, "ItemizedText",
 CellID->1058900491],
Cell[94478, 3000, 205, 5, 70, "ItemizedText",
 CellID->445616872],
Cell[94686, 3007, 310, 9, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31634],
Cell[94999, 3018, 131, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->7136],
Cell[95133, 3022, 128, 3, 70, "ItemizedTextParagraph",
 CellID->1207290615],
Cell[95264, 3027, 124, 3, 70, "ItemizedTextParagraph",
 CellID->1507869449],
Cell[95391, 3032, 223, 3, 70, "ItemizedTextParagraph",
 CellID->307311096],
Cell[95617, 3037, 119, 3, 70, "ItemizedTextParagraph",
 CellID->279419437],
Cell[95739, 3042, 230, 3, 70, "ItemizedTextParagraph",
 CellID->1803225317],
Cell[95972, 3047, 193, 4, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3123],
Cell[96168, 3053, 206, 4, 70, "ItemizedText",
 CellID->1518676355],
Cell[96377, 3059, 155, 4, 70, "ItemizedText",
 CellID->1550353890],
Cell[96535, 3065, 137, 4, 70, "ItemizedText",
 CellID->1378740179],
Cell[96675, 3071, 107, 2, 70, "ItemizedText",
 CellID->1137637323],
Cell[96785, 3075, 190, 6, 70, "ItemizedText",
 CellID->1223578420],
Cell[96978, 3083, 96, 1, 70, "ItemizedTextParagraph",
 CellID->379101268],
Cell[97077, 3086, 546, 19, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3375],
Cell[97626, 3107, 145, 3, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->6546],
Cell[97774, 3112, 152, 4, 70, "ItemizedText",
 CellID->2118514274],
Cell[97929, 3118, 144, 4, 70, "ItemizedText",
 CellID->590535858],
Cell[98076, 3124, 109, 2, 70, "ItemizedText",
 CellID->1614232619],
Cell[98188, 3128, 351, 7, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30439],
Cell[98542, 3137, 347, 12, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->25048],
Cell[98892, 3151, 236, 8, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->14565],
Cell[99131, 3161, 377, 10, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18962],
Cell[99511, 3173, 117, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->31168],
Cell[99631, 3177, 123, 3, 70, "ItemizedTextParagraph",
 CellID->540758695],
Cell[99757, 3182, 246, 4, 70, "ItemizedTextParagraph",
 CellID->1246714982],
Cell[100006, 3188, 119, 3, 70, "ItemizedTextParagraph",
 CellID->380592761],
Cell[100128, 3193, 423, 11, 70, "ItemizedTextParagraph",
 CellID->1416233361]
}, Open  ]],
Cell[CellGroupData[{
Cell[100588, 3209, 178, 5, 70, "Subsubsubsection",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3719],
Cell[100769, 3216, 216, 5, 70, "Text",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->15469],
Cell[100988, 3223, 161, 3, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->9982],
Cell[101152, 3228, 203, 7, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->8113],
Cell[101358, 3237, 132, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->3287],
Cell[101493, 3241, 397, 13, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->32340],
Cell[101893, 3256, 166, 3, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->2072838626],
Cell[102062, 3261, 124, 3, 70, "ItemizedTextParagraph",
 CellID->1719065548],
Cell[102189, 3266, 215, 3, 70, "ItemizedTextParagraph",
 CellID->326125799],
Cell[102407, 3271, 118, 3, 70, "ItemizedTextParagraph",
 CellID->89678498],
Cell[102528, 3276, 228, 3, 70, "ItemizedTextParagraph",
 CellID->818036649],
Cell[102759, 3281, 134, 2, 70, "ItemizedTextParagraph",
 CellID->1840479339],
Cell[102896, 3285, 105, 2, 70, "ItemizedTextParagraph",
 CellID->581799185],
Cell[103004, 3289, 150, 3, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->805857504],
Cell[103157, 3294, 344, 12, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->30290],
Cell[103504, 3308, 315, 9, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18321],
Cell[103822, 3319, 135, 2, 70, "ItemizedTextParagraph",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->636],
Cell[103960, 3323, 153, 4, 70, "ItemizedText",
 CellID->2015191746],
Cell[104116, 3329, 124, 3, 70, "ItemizedTextParagraph",
 CellID->1363078185],
Cell[104243, 3334, 224, 3, 70, "ItemizedTextParagraph",
 CellID->2046992746],
Cell[104470, 3339, 120, 3, 70, "ItemizedTextParagraph",
 CellID->1119057082],
Cell[104593, 3344, 238, 4, 70, "ItemizedTextParagraph",
 CellID->330596748],
Cell[104834, 3350, 234, 8, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->18677],
Cell[105071, 3360, 205, 4, 70, "ItemizedText",
 CellID->799348847],
Cell[105279, 3366, 155, 4, 70, "ItemizedText",
 CellID->2145859544],
Cell[105437, 3372, 136, 4, 70, "ItemizedText",
 CellID->620988290],
Cell[105576, 3378, 106, 2, 70, "ItemizedText",
 CellID->179665610],
Cell[105685, 3382, 189, 6, 70, "ItemizedText",
 CellID->277899588],
Cell[105877, 3390, 97, 1, 70, "ItemizedTextParagraph",
 CellID->2028926938],
Cell[105977, 3393, 236, 8, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->11620],
Cell[106216, 3403, 121, 2, 70, "ItemizedText",
 CellTags->{"Microsoft", "WindowsBuilding"},
 CellID->282216253],
Cell[106340, 3407, 124, 3, 70, "ItemizedTextParagraph",
 CellID->1564671595],
Cell[106467, 3412, 231, 3, 70, "ItemizedTextParagraph",
 CellID->1498239650],
Cell[106701, 3417, 120, 3, 70, "ItemizedTextParagraph",
 CellID->1668036475],
Cell[106824, 3422, 246, 4, 70, "ItemizedTextParagraph",
 CellID->1437507387]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107143, 3434, 147, 7, 70, "Section",
 CellTags->"WindowsRunning",
 CellID->26613],
Cell[107293, 3443, 784, 20, 70, "Text",
 CellTags->"WindowsRunning",
 CellID->16696],
Cell[108080, 3465, 292, 8, 70, "Text",
 CellTags->"WindowsRunning",
 CellID->12389],
Cell[108375, 3475, 1566, 35, 70, "Text",
 CellTags->"WindowsRunning",
 CellID->6894],
Cell[CellGroupData[{
Cell[109966, 3514, 191, 7, 70, "Subsection",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->30804],
Cell[110160, 3523, 1347, 38, 70, "Text",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->31119],
Cell[111510, 3563, 902, 17, 70, "Program",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->6219],
Cell[112415, 3582, 108, 2, 70, "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->9425],
Cell[112526, 3586, 276, 7, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->19900],
Cell[112805, 3595, 163, 4, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->3248],
Cell[112971, 3601, 164, 4, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->18461],
Cell[113138, 3607, 125, 3, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->19295],
Cell[113266, 3612, 287, 9, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->32652],
Cell[113556, 3623, 106, 3, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->23643],
Cell[113665, 3628, 95, 2, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->371719980],
Cell[113763, 3632, 144, 4, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->12747],
Cell[113910, 3638, 216, 5, 70, "Text",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->7965],
Cell[114129, 3645, 242, 7, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->30284],
Cell[114374, 3654, 218, 8, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->1124],
Cell[114595, 3664, 132, 2, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->15953],
Cell[114730, 3668, 193, 6, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->32525],
Cell[114926, 3676, 175, 6, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->12110],
Cell[115104, 3684, 172, 5, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->21792],
Cell[115279, 3691, 616, 19, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->12197],
Cell[115898, 3712, 105, 3, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->497],
Cell[116006, 3717, 140, 3, 70, "MathCaption",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->20805],
Cell[116149, 3722, 121, 3, 70, "Input",
 CellTags->{"addtwo", "WindowsRunning"},
 CellID->4112]
}, Open  ]],
Cell[CellGroupData[{
Cell[116307, 3730, 198, 7, 70, "Subsection",
 CellTags->{"factor", "WindowsRunning"},
 CellID->3856],
Cell[116508, 3739, 553, 14, 70, "Text",
 CellTags->{"factor", "WindowsRunning"},
 CellID->23256],
Cell[117064, 3755, 928, 23, 70, "Text",
 CellTags->{"factor", "WindowsRunning"},
 CellID->27730],
Cell[117995, 3780, 110, 2, 70, "Text",
 CellTags->{"factor", "WindowsRunning"},
 CellID->11231],
Cell[118108, 3784, 104, 2, 70, "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->23034],
Cell[118215, 3788, 179, 5, 70, "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->28501],
Cell[CellGroupData[{
Cell[118419, 3797, 109, 2, 70, "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->24171],
Cell[118531, 3801, 119, 2, 70, "Program",
 CellTags->{"factor", "WindowsRunning"},
 CellID->6438]
}, Open  ]],
Cell[118665, 3806, 151, 3, 70, "ItemizedTextParagraph",
 CellTags->{"factor", "WindowsRunning"},
 CellID->20656],
Cell[118819, 3811, 100, 2, 70, "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->13265],
Cell[118922, 3815, 171, 4, 70, "ItemizedTextParagraph",
 CellTags->{"factor", "WindowsRunning"},
 CellID->27236],
Cell[CellGroupData[{
Cell[119118, 3823, 286, 7, 70, "ItemizedText",
 CellTags->{"factor", "WindowsRunning"},
 CellID->28469],
Cell[119407, 3832, 130, 2, 70, "Program",
 CellTags->{"factor", "WindowsRunning"},
 CellID->19924]
}, Open  ]],
Cell[CellGroupData[{
Cell[119574, 3839, 338, 11, 70, "ItemizedTextParagraph",
 CellTags->{"factor", "WindowsRunning"},
 CellID->30386],
Cell[119915, 3852, 330, 10, 70, "Program",
 CellTags->{"factor", "WindowsRunning"},
 CellID->18972]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[120294, 3868, 106, 2, 70, "Subsection",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->20802],
Cell[120403, 3872, 1848, 61, 70, "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->13652],
Cell[122254, 3935, 956, 31, 70, "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->25471],
Cell[123213, 3968, 364, 9, 70, "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->13580],
Cell[123580, 3979, 236, 7, 70, "Input",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->10925],
Cell[123819, 3988, 266, 6, 70, "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->20380],
Cell[124088, 3996, 175, 5, 70, "Input",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->16708],
Cell[124266, 4003, 151, 3, 70, "Text",
 CellTags->{"protocols", "WindowsRunning"},
 CellID->13599]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124466, 4012, 87, 2, 70, "Section",
 CellTags->"WindowsTroubleshooting",
 CellID->15385],
Cell[124556, 4016, 709, 16, 70, "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->4139],
Cell[125268, 4034, 450, 14, 70, "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->26927],
Cell[125721, 4050, 560, 10, 70, "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->26728],
Cell[126284, 4062, 764, 23, 70, "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->11304],
Cell[127051, 4087, 314, 7, 70, "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->14368],
Cell[127368, 4096, 788, 25, 70, "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->26396],
Cell[128159, 4123, 664, 20, 70, "BulletedText",
 CellTags->"WindowsTroubleshooting",
 CellID->12975],
Cell[CellGroupData[{
Cell[128848, 4147, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->179833080],
Cell[128917, 4150, 309, 9, 70, "TutorialMoreAbout",
 CellID->558589989],
Cell[129229, 4161, 313, 9, 70, "TutorialMoreAbout",
 CellID->40858578],
Cell[129545, 4172, 336, 9, 70, "TutorialMoreAbout",
 CellID->8146795],
Cell[129884, 4183, 359, 9, 70, "TutorialMoreAbout",
 CellID->424932163],
Cell[130246, 4194, 348, 9, 70, "TutorialMoreAbout",
 CellID->2262398],
Cell[130597, 4205, 401, 11, 70, "TutorialMoreAbout",
 CellID->101684538],
Cell[131001, 4218, 338, 9, 70, "TutorialMoreAbout",
 CellID->655130],
Cell[131342, 4229, 347, 9, 70, "TutorialMoreAbout",
 CellID->148916145],
Cell[131692, 4240, 347, 9, 70, "TutorialMoreAbout",
 CellID->182367630],
Cell[132042, 4251, 327, 9, 70, "TutorialMoreAbout",
 CellID->113882963],
Cell[132372, 4262, 272, 9, 70, "TutorialMoreAbout",
 CellID->5094559],
Cell[132647, 4273, 457, 12, 70, "TutorialMoreAbout",
 CellID->246479563]
}, Open  ]],
Cell[CellGroupData[{
Cell[133141, 4290, 71, 1, 70, "RelatedTutorialsSection",
 CellID->52096731],
Cell[133215, 4293, 338, 9, 70, "RelatedTutorials",
 CellID->403767969],
Cell[133556, 4304, 334, 9, 70, "RelatedTutorials",
 CellID->309869466]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[133929, 4318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

