(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33988,       1036]
NotebookOptionsPosition[     27761,        853]
NotebookOutlinePosition[     30931,        930]
CellTagsIndexPosition[     30793,        922]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup["paclet:tutorial/NamingAndFindingFiles"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Naming and Finding Files\"\>", 
       2->"\<\"System Administration for Single-User Licenses\"\>", 
       3->"\<\"System Administration for Network Licenses\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"Mathematica System Setup\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"math" :> Documentation`HelpLookup["paclet:ref/program/math"], 
          "Mathematica" :> 
          Documentation`HelpLookup["paclet:ref/program/Mathematica"], 
          "MathKernel" :> 
          Documentation`HelpLookup["paclet:ref/program/MathKernel"], "mcc" :> 
          Documentation`HelpLookup["paclet:ref/program/mcc"], 
          "$BaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$BaseDirectory"], 
          "$UserBaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserBaseDirectory"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"math\"\>", 
       2->"\<\"Mathematica\"\>", 3->"\<\"MathKernel\"\>", 4->"\<\"mcc\"\>", 
       5->"\<\"$BaseDirectory\"\>", 
       6->"\<\"$UserBaseDirectory\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " File Organization"
}], "Title",
 CellID->647750847],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Distribution Files"
}], "Section",
 CellTags->{"SA.8.1", "1.1"},
 CellID->30080],

Cell[TextData[{
 "A full ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation consists of thousands of separate files, arranged in several \
hundred directories under the main installation directory. The location of \
the main installation directory is determined at install time. From within a \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, its name is given by the value of ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16434],

Cell[BoxData[GridBox[{
   {Cell["\<\
C:\[Backslash]Program Files\[Backslash]Wolfram \
Research\[Backslash]Mathematica\[Backslash]6.0\
\>", "InlineCode"], "\[SpanFromLeft]"},
   {"", Cell["Windows", "TableText"]},
   {Cell["/Applications/Mathematica.app", "InlineCode"], "\[SpanFromLeft]"},
   {"", Cell["Macintosh", "TableText"]},
   {Cell["/usr/local/Wolfram/Mathematica/6.0", "InlineCode"], 
    "\[SpanFromLeft]"},
   {"", Cell["Unix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4711],

Cell[TextData[{
 "Default locations for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation directory. "
}], "Caption",
 CellID->22229],

Cell[TextData[{
 "The executable programs that launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are typically in the main installation directory. Sometimes there may also \
be links to them, or scripts accessing them, in other locations. From within \
a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"], "[", 
   ButtonBox["$CommandLine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CommandLine"], "]"}]], "InlineFormula"],
 " gives the full name of the executable program corresponding to that \
kernel. "
}], "Text",
 CellID->8853],

Cell[BoxData[GridBox[{
   {Cell[TextData[ButtonBox["Mathematica",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/program/Mathematica"]], "InlineCode"], Cell[
    TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end"
    }], "TableText"]},
   {Cell[TextData[ButtonBox["MathKernel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/program/MathKernel"]], "InlineCode"], Cell[
    TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel, usually with its own text-based interface"
    }], "TableText"]},
   {Cell[TextData[ButtonBox["math",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/program/math"]], "InlineCode"], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel to be run in a terminal or shell"
    }], "TableText"]},
   {Cell[TextData[ButtonBox["mcc",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/program/mcc"]], "InlineCode"], Cell[TextData[{
     "script for preprocessing and compiling ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " C source files"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21930],

Cell["\<\
Typical executable programs accessible from the installation directory. \
\>", "Caption",
 CellID->5408],

Cell[TextData[{
 "The main installation directory has three standard subdirectories that \
contain material distributed with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Under normal circumstances, none of the contents of these directories \
should ever be modified, except, for example, if you choose to edit a shared \
stylesheet. "
}], "Text",
 CellID->14730],

Cell[BoxData[GridBox[{
   {Cell["AddOns", "InlineCode"], Cell[TextData[{
     "bundled ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " add-ons"
    }], "TableText"]},
   {Cell["Documentation", "InlineCode"], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " system documentation"
    }], "TableText"]},
   {Cell["SystemFiles", "InlineCode"], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " system files"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7448],

Cell["\<\
Top\[Hyphen]level subdirectories of the main installation directory. \
\>", "Caption",
 CellID->21632],

Cell[TextData[{
 "Particularly on Unix systems, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " often has executable files for different computer architectures and \
systems stored in a single overall directory structure. Each system is in a \
subdirectory with a name given by ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 ". Some resource directories may also contain files specific both to \
particular languages and particular computing environments. These files are \
given in subdirectories such as ",
 Cell[BoxData[
  RowBox[{"Japanese", "/", "Windows"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19141],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Kernel/Binaries/",
     StyleBox["system", "TI"]
    }], "InlineCode"], Cell[
    "kernel binaries or elements for each computer system", "TableText"]},
   {Cell[TextData[{
     "Kernel/SystemResources/",
     StyleBox["system", "TI"]
    }], "InlineCode"], Cell[TextData[{
     "system-specific ",
     Cell[BoxData[
      RowBox[{".", "mx"}]], "InlineFormula"],
     " files used by the kernel"
    }], "TableText"]},
   {Cell["Kernel/TextResources", "InlineCode"], Cell[
    "message and text files used by the kernel", "TableText"]},
   {Cell[TextData[{
     "FrontEnd/Binaries/",
     StyleBox["system", "TI"]
    }], "InlineCode"], Cell[
    "front end binaries or elements for each computer system", "TableText"]},
   {Cell["FrontEnd/SystemResources", "InlineCode"], Cell["\<\
files used by the front end in each window system environment\
\>", "TableText"]},
   {Cell["FrontEnd/TextResources", "InlineCode"], Cell[
    "message and text files used by the front end", "TableText"]},
   {Cell["FrontEnd/StyleSheets", "InlineCode"], Cell[
    "default notebook stylesheets", "TableText"]},
   {Cell["FrontEnd/Palettes", "InlineCode"], Cell[
    "default palette notebooks", "TableText"]},
   {Cell[TextData[{
     "Libraries/",
     StyleBox["system", "TI"]
    }], "InlineCode"], Cell[TextData[{
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " and other libraries used by the kernel and front end"
    }], "TableText"]},
   {Cell["Links", "InlineCode"], Cell[TextData[{
     "developer kits for ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " and other connection technologies"
    }], "TableText"]},
   {Cell["Fonts", "InlineCode"], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " fonts, often copied to a central directory"
    }], "TableText"]},
   {Cell["CharacterEncodings", "InlineCode"], Cell[
    "specifications of character encodings", "TableText"]},
   {Cell["SpellingDictionaries", "InlineCode"], Cell[
    "spelling dictionaries", "TableText"]},
   {Cell[TextData[{
     "SystemDocumentation/",
     StyleBox["env", "TI"]
    }], "InlineCode"], Cell[TextData[{
     "Unix ",
     Cell[BoxData["man"], "InlineFormula"],
     " pages and other environment-specific documentation"
    }], "TableText"]},
   {Cell[TextData[{
     "Graphics/Binaries/",
     StyleBox["system", "TI"]
    }], "InlineCode"], Cell[
    "PostScript interpreters and graphics programs", "TableText"]},
   {Cell["Graphics/SystemResources", "InlineCode"], Cell[
    "PostScript definitions and other resources for graphics", "TableText"]},
   {Cell["Graphics/Packages", "InlineCode"], Cell[
    "packages for setting up graphics", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, True, False, False, False, False, True, False, False,
      False, False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2670],

Cell[TextData[{
 "Typical subdirectories of the ",
 Cell[BoxData["SystemFiles"], "InlineFormula"],
 " directory, part one. "
}], "Caption",
 CellID->15416],

Cell[BoxData[GridBox[{
   {Cell["Installation", "InlineCode"], Cell["\<\
various auxiliary programs used in installation, called automatically by the \
main installer program\
\>", "TableText"]},
   {Cell["IncludeFiles", "InlineCode"], Cell[
    "files for inclusion in other programs", "TableText"]},
   {Cell["Java", "InlineCode"], Cell[
    "files for the Java Runtime Environment (if needed)", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3063],

Cell[TextData[{
 "Typical subdirectories of the ",
 Cell[BoxData["SystemFiles"], "InlineFormula"],
 " directory, part two. "
}], "Caption",
 CellID->1818],

Cell[TextData[{
 "Files of information to be displayed by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Help Viewer are stored in the ",
 Cell[BoxData["Documentation"], "InlineFormula"],
 " directory. "
}], "Text",
 CellID->17974],

Cell[BoxData[GridBox[{
   {Cell["System/Guides", "InlineCode"], Cell[
    "pages that categorize and link to related functions", "TableText"]},
   {Cell["System/ReferencePages/Symbols", "InlineCode"], Cell[TextData[{
     "reference pages for each of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "'s built-in objects"
    }], "TableText"]},
   {Cell["System/ReferencePages/Formats", "InlineCode"], Cell[TextData[{
     "reference pages for file formats that ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " handles"
    }], "TableText"]},
   {Cell[TextData[{
     "Packages/",
     StyleBox["name", "TI"],
     "/Guides",
     ", etc."
    }], "InlineCode"], Cell["documentation for add-on items", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1741],

Cell[TextData[{
 "Typical subdirectories of the ",
 Cell[BoxData["Documentation"], "InlineFormula"],
 " directory. "
}], "Caption",
 CellID->21885]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loadable Files", "Section",
 CellTags->{"SA.8.2", "2.1"},
 CellID->21439],

Cell[TextData[{
 "You can customize your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by adding files that can be loaded into the system under different \
circumstances. Such files are conventionally placed in either systemwide or \
user\[Hyphen]specific ",
 StyleBox["base directories",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->26194],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$BaseDirectory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$BaseDirectory"], Cell[TextData[{
     "systemwide base directory for files to be loaded by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    ButtonBox["$UserBaseDirectory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$UserBaseDirectory"], Cell[TextData[{
     "user-specific base directory for files to be loaded by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22488],

Cell[TextData[{
 "Base directories for files to be loaded by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->28664],

Cell[BoxData[GridBox[{
   {Cell["\<\
C:\[Backslash]Documents and Settings\[Backslash]All \
Users\[Backslash]Application Data\[Backslash]Mathematica\
\>", "InlineCode"], "\[SpanFromLeft]"},
   {"", Cell["Windows", "TableText"]},
   {Cell["/Library/Mathematica", "InlineCode"], Cell[
    "Macintosh", "TableText"]},
   {Cell["/usr/share/Mathematica", "InlineCode"], Cell["Unix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26673],

Cell[TextData[{
 "Typical values of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->27048],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "C:\[Backslash]Documents and Settings\[Backslash]",
     StyleBox["username", "TI"],
     "\[Backslash]Application Data\[Backslash]Mathematica"
    }], "InlineCode"], "\[SpanFromLeft]"},
   {"", Cell["Windows", "TableText"]},
   {Cell["~/Library/Mathematica", "InlineCode"], Cell[
    "Macintosh", "TableText"]},
   {Cell["~ /. Mathematica", "InlineCode"], Cell["Unix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25358],

Cell[TextData[{
 "Typical values of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->2280],

Cell[TextData[{
 "You can specify different locations for these directories by setting \
operating system environment variables when you launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", as discussed in \"",
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
 "\". "
}], "Text",
 CellID->32487],

Cell[BoxData[GridBox[{
   {"Applications", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " application packages"
    }], "TableText"]},
   {"Autoload", Cell["packages to be autoloaded on startup", "TableText"]},
   {"FrontEnd", Cell["front end initialization files", "TableText"]},
   {"Kernel", Cell["kernel initialization files", "TableText"]},
   {"Licensing", Cell["license management files", "TableText"]},
   {"SystemFiles", Cell["general system files", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19764],

Cell[TextData[{
 "Typical subdirectories of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " base directories. "
}], "Caption",
 CellID->23713],

Cell[TextData[{
 "Some files in base directories serve as configuration files, automatically \
used by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel or front end. "
}], "Text",
 CellID->24013],

Cell[BoxData[GridBox[{
   {Cell["Kernel/init.m", "InlineCode"], Cell[
    "run when the kernel is started", "TableText"]},
   {Cell["Kernel/end.m", "InlineCode"], Cell[
    "run when the kernel is terminated", "TableText"]},
   {Cell["FrontEnd/init.m", "InlineCode"], Cell[
    "read when the front end is started", "TableText"]},
   {Cell["SystemFiles/FrontEnd/StyleSheets/", "InlineCode"], 
    "\[SpanFromLeft]"},
   {"", Cell["customized notebook stylesheets", "TableText"]},
   {Cell["SystemFiles/FrontEnd/Palettes/", "InlineCode"], Cell[
    "additional palettes to appear in the front end menu", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12452],

Cell["Some typical kernel and front end configuration files. ", "Caption",
 CellID->18170],

Cell[TextData[{
 "Kernel configuration files can contain any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands. These commands can test global variables such as ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MachineName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineName"]], "InlineFormula"],
 " to determine what operations to perform. Front end configuration files can \
contain only certain special commands, as described in\[NonBreakingSpace]\"",
 ButtonBox["Input Syntax\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax"],
 ". "
}], "Text",
 CellID->24978],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Applications/",
     StyleBox["name", "TI"],
     "/"
    }], "InlineCode"], Cell["named add-on applications", "TableText"]},
   {Cell[TextData[{
     "Autoload/",
     StyleBox["name", "TI"],
     "/"
    }], "InlineCode"], Cell[TextData[{
     "add-ons to be loaded automatically when ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is started"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6766],

Cell[TextData[{
 "Subdirectories under ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->12704],

Cell[TextData[{
 "With the default setting for the kernel ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " variable, an add\[Hyphen]on can be loaded from within a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session simply by using the command ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox[
    RowBox[{
     StyleBox["name", "TI"], "`"}]]}]], "InlineFormula"],
 ". This will load the ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " file for the add\[Hyphen]on, which should in turn be set up to load other \
necessary files or packages. "
}], "Text",
 CellID->21416],

Cell[TextData[{
 "By placing an add\[Hyphen]on under the ",
 Cell[BoxData["Autoload"], "InlineFormula"],
 " subdirectory of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ", you can have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically load the add\[Hyphen]on whenever you start the kernel or the \
front end."
}], "Text",
 CellID->28649],

Cell[BoxData[GridBox[{
   {Cell["Kernel/init.m", "InlineCode"], Cell[
    "an initialization file to be loaded by the kernel", "TableText"]},
   {Cell["FrontEnd/init.m", "InlineCode"], Cell[
    "an initialization file to be loaded by the front end", "TableText"]},
   {Cell["Documentation/", "InlineCode"], Cell[
    "documentation to be found by the front end", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10377],

Cell["\<\
Typical possible contents of the directory for an add\[Hyphen]on. \
\>", "Caption",
 CellID->22837],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->35363],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DirectoriesAndDirectoryOperations"]], "TutorialMoreAbout",
 CellID->74069176],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSystemSetup"],
  FontSlant->"Italic"],
 ButtonBox[" System Setup",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSystemSetup"]
}], "TutorialMoreAbout",
 CellID->454905762]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->91165042],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "RelatedTutorials",
 CellID->183121913],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->309296652],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->518845713]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematica File Organization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 9.8515842}", "context" -> "", 
    "keywords" -> {
     "add-ons", "additions", "addons", "autoload directory", "base directory",
       "browser index", "browser index files", "BrowserCategory files", 
      "configuration files", "customization files", "documentation files", 
      "files", "help files", "home directory", "init.m files", 
      "initialization", "initialization files", "installation directory", 
      "InstallationDirectory", "loadable files", "master files", "packages", 
      "plug-ins", "plugins", "preferences directory", "system resource files",
       "text resource files", "user base directory", 
      "user configuration files", "$BaseDirectory", "$UserBaseDirectory"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "A full Mathematica installation consists of thousands of separate files, \
arranged in several hundred directories under the main installation \
directory. The location of the main installation directory is determined at \
install time. From within a Mathematica kernel, its name is given by the \
value of $InstallationDirectory. Default locations for the Mathematica \
installation directory. The executable programs that launch Mathematica are \
typically in the main installation directory. Sometimes there may also be \
links to them, or scripts accessing them, in other locations. From within a \
Mathematica kernel, First[$CommandLine] gives the full name of the executable \
program corresponding to that kernel. ", "synonyms" -> {"A.8.1", "A.8.2"}, 
    "title" -> "Mathematica File Organization", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathematicaFileOrganization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.8.1"->{
  Cell[3823, 105, 148, 6, 70, "Section",
   CellTags->{"SA.8.1", "1.1"},
   CellID->30080]},
 "1.1"->{
  Cell[3823, 105, 148, 6, 70, "Section",
   CellTags->{"SA.8.1", "1.1"},
   CellID->30080]},
 "SA.8.2"->{
  Cell[15871, 469, 79, 2, 70, "Section",
   CellTags->{"SA.8.2", "2.1"},
   CellID->21439]},
 "2.1"->{
  Cell[15871, 469, 79, 2, 70, "Section",
   CellTags->{"SA.8.2", "2.1"},
   CellID->21439]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.8.1", 30365, 903},
 {"1.1", 30468, 907},
 {"SA.8.2", 30574, 911},
 {"2.1", 30677, 915}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3054, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3679, 96, 119, 5, 70, "Title",
 CellID->647750847],
Cell[CellGroupData[{
Cell[3823, 105, 148, 6, 70, "Section",
 CellTags->{"SA.8.1", "1.1"},
 CellID->30080],
Cell[3974, 113, 592, 17, 70, "Text",
 CellID->16434],
Cell[4569, 132, 939, 23, 70, "DefinitionBox",
 CellID->4711],
Cell[5511, 157, 155, 6, 70, "Caption",
 CellID->22229],
Cell[5669, 165, 678, 21, 70, "Text",
 CellID->8853],
Cell[6350, 188, 1457, 40, 70, "DefinitionBox",
 CellID->21930],
Cell[7810, 230, 114, 3, 70, "Caption",
 CellID->5408],
Cell[7927, 235, 373, 9, 70, "Text",
 CellID->14730],
Cell[8303, 246, 840, 25, 70, "DefinitionBox",
 CellID->7448],
Cell[9146, 273, 112, 3, 70, "Caption",
 CellID->21632],
Cell[9261, 278, 701, 18, 70, "Text",
 CellID->19141],
Cell[9965, 298, 3306, 84, 70, "DefinitionBox",
 CellID->2670],
Cell[13274, 384, 155, 5, 70, "Caption",
 CellID->15416],
Cell[13432, 391, 745, 17, 70, "DefinitionBox",
 CellID->3063],
Cell[14180, 410, 154, 5, 70, "Caption",
 CellID->1818],
Cell[14337, 417, 243, 8, 70, "Text",
 CellID->17974],
Cell[14583, 427, 1101, 30, 70, "DefinitionBox",
 CellID->1741],
Cell[15687, 459, 147, 5, 70, "Caption",
 CellID->21885]
}, Open  ]],
Cell[CellGroupData[{
Cell[15871, 469, 79, 2, 70, "Section",
 CellTags->{"SA.8.2", "2.1"},
 CellID->21439],
Cell[15953, 473, 354, 11, 70, "Text",
 CellID->26194],
Cell[16310, 486, 874, 25, 70, "DefinitionBox",
 CellID->22488],
Cell[17187, 513, 149, 6, 70, "Caption",
 CellID->28664],
Cell[17339, 521, 860, 20, 70, "DefinitionBox",
 CellID->26673],
Cell[18202, 543, 205, 8, 70, "Caption",
 CellID->27048],
Cell[18410, 553, 901, 21, 70, "DefinitionBox",
 CellID->25358],
Cell[19314, 576, 212, 8, 70, "Caption",
 CellID->2280],
Cell[19529, 586, 489, 15, 70, "Text",
 CellID->32487],
Cell[20021, 603, 865, 20, 70, "DefinitionBox",
 CellID->19764],
Cell[20889, 625, 149, 6, 70, "Caption",
 CellID->23713],
Cell[21041, 633, 212, 7, 70, "Text",
 CellID->24013],
Cell[21256, 642, 1111, 24, 70, "DefinitionBox",
 CellID->12452],
Cell[22370, 668, 90, 1, 70, "Caption",
 CellID->18170],
Cell[22463, 671, 723, 21, 70, "Text",
 CellID->24978],
Cell[23189, 694, 749, 24, 70, "DefinitionBox",
 CellID->6766],
Cell[23941, 720, 358, 13, 70, "Caption",
 CellID->12704],
Cell[24302, 735, 670, 21, 70, "Text",
 CellID->21416],
Cell[24975, 758, 594, 19, 70, "Text",
 CellID->28649],
Cell[25572, 779, 712, 15, 70, "DefinitionBox",
 CellID->10377],
Cell[26287, 796, 109, 3, 70, "Caption",
 CellID->22837],
Cell[CellGroupData[{
Cell[26421, 803, 62, 1, 70, "TutorialMoreAboutSection",
 CellID->35363],
Cell[26486, 806, 189, 4, 70, "TutorialMoreAbout",
 CellID->74069176],
Cell[26678, 812, 296, 9, 70, "TutorialMoreAbout",
 CellID->454905762]
}, Open  ]],
Cell[CellGroupData[{
Cell[27011, 826, 71, 1, 70, "RelatedTutorialsSection",
 CellID->91165042],
Cell[27085, 829, 167, 3, 70, "RelatedTutorials",
 CellID->183121913],
Cell[27255, 834, 222, 5, 70, "RelatedTutorials",
 CellID->309296652],
Cell[27480, 841, 215, 5, 70, "RelatedTutorials",
 CellID->518845713]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[27734, 851, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

