(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17629,        551]
NotebookOptionsPosition[     12434,        409]
NotebookOutlinePosition[     15983,        492]
CellTagsIndexPosition[     15890,        486]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using the Mathematica System" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UsingTheMathematicaSystemOverview"], 
          "Packages for Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PackagesForSymbolicMathematics"], 
          "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Using the Mathematica System\"\>", 
       2->"\<\"Packages for Symbolic Mathematics\"\>", 
       3->"\<\"Setting Up Mathematica Packages\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Remove" :> Documentation`HelpLookup["paclet:ref/Remove"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Remove\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Packages"
}], "Title",
 CellTags->{"S1.3.10", "10.1"},
 CellID->3780],

Cell[TextData[{
 "One of the most important features of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that it is an extensible system. There is a certain amount of \
mathematical and other functionality that is built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". But by using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language, it is always possible to add more functionality. "
}], "Text",
 CellID->18554],

Cell[TextData[{
 "For many kinds of calculations, what is built into the standard version of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will be quite sufficient. However, if you work in a particular specialized \
area, you may find that you often need to use certain functions that are not \
built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->3078],

Cell[TextData[{
 "In such cases, you may well be able to find a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package that contains the functions you need. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages are files written in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. They consist of collections of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions which \[OpenCurlyDoubleQuote]teach\[CloseCurlyDoubleQuote] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " about particular application areas. "
}], "Text",
 CellID->18061],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", 
     StyleBox["package", "TI"]}], Cell[TextData[{
     "read in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " package"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16868],

Cell[TextData[{
 "Reading in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages. "
}], "Caption",
 CellID->24521],

Cell[TextData[{
 "If you want to use functions from a particular package, you must first read \
the package into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The details of how to do this are discussed in \"",
 ButtonBox["Files and External Operations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FilesAndExternalOperationsOverview"],
 ". There are various conventions that govern the names you should use to \
refer to packages. "
}], "Text",
 CellID->25673],

Cell[TextData[{
 "This command reads in a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package. "
}], "MathCaption",
 CellID->21098],

Cell[BoxData[
 RowBox[{"<<", "PrimalityProving`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4757],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ProvablePrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:PrimalityProving/ref/ProvablePrimeQ"]], 
  "InlineFormula"],
 " function is defined in the package. "
}], "MathCaption",
 CellID->31258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", "1093", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13419],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1399434710]
}, Open  ]],

Cell[TextData[{
 "There are a number of subtleties associated with such issues as conflicts \
between names of functions in different packages. These are discussed in \"",
 ButtonBox["Contexts and Packages\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ContextsAndPackages"],
 ". One point to note, however, is that you should not refer to a function \
that you will read from a package before actually reading in the package. If \
you do this by mistake, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will issue a message warning about the duplicate names and use the one \
last defined. This means that your version of the function will not be used; \
it will be the one from the package. You can execute the command ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " to get rid of the package function."
}], "Text",
 CellID->70199801],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Remove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Remove"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "remove a function that has been introduced in error", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->189],

Cell[TextData[{
 "Making sure that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses correct definitions from packages. "
}], "Caption",
 CellID->22216],

Cell[TextData[{
 "The fact that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be extended using packages means that the boundary of exactly what is \
\[OpenCurlyDoubleQuote]part of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] is quite blurred. As far as usage is concerned, \
there is actually no difference between functions defined in packages and \
functions that are fundamentally built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->25956],

Cell[TextData[{
 "In fact, a fair number of the functions built into the core ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system are actually implemented as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages. However, on most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " systems, the necessary packages have been preloaded, so that the functions \
they define are always present. "
}], "Text",
 CellID->23239],

Cell[TextData[{
 "To blur the boundary of what is part of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " even further, \"",
 ButtonBox["Automatic Loading of Packages\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AutomaticLoadingOfPackages"],
 " describes how you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically to load a particular package if you ever try to use a \
certain function. If you never use that function, then it will not be \
present. But as soon as you try to use it, its definition will be read in \
from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package. "
}], "Text",
 CellID->23725],

Cell[TextData[{
 "As a practical matter, the functions that should be considered \
\[OpenCurlyDoubleQuote]part of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote] are probably those that are present in all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " systems. It is these functions that are primarily discussed in this \
documentation. "
}], "Text",
 CellID->8125],

Cell[TextData[{
 "Nevertheless, most versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " come with a standard set of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages, which contain definitions for many more functions. To use these \
functions, you must usually read in the necessary packages explicitly. "
}], "Text",
 CellID->28532],

Cell[TextData[{
 "It is possible to set your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system up so that particular packages are pre\[Hyphen]loaded, or are \
automatically loaded when needed. If you do this, then there may be many \
functions that appear as standard in your version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but which are not documented in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system reference pages. "
}], "Text",
 CellID->8716],

Cell[TextData[{
 "One point that should be mentioned is the relationship between packages and \
notebooks. Both are stored as files on your computer system, and both can be \
read into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". However, a notebook is intended to be displayed, typically with a \
notebook interface, while a package is intended only to be used as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. Many notebooks in fact contain sections that can be considered as \
packages, and which contain sequences of definitions intended for input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". There are also capabilities that allow packages set up to correspond to \
notebooks to be maintained automatically."
}], "Text",
 CellID->21762],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->108622829],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261],

Cell[TextData[ButtonBox["Packages for Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PackagesForSymbolicMathematics"]], "RelatedTutorials",
 CellID->270625667],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "RelatedTutorials",
 CellID->133910369]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematica Packages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GettingHelpWithATextBasedInterface"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/WarningsAndMessages"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 15.0704678}", "context" -> "", 
    "keywords" -> {
     "<<", "Needs", "application packages", "autoloading", "batch files", 
      "definitions", "errors", "extensions", "packages", "external files", 
      "functions", "Get", "inactivity", "inert functions", "input", 
      "library packages", "loading packages", "names", "notebooks", 
      "packages", "reading", "remove", "scripts", "shadowing of names", 
      "taking"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "One of the most important features of Mathematica is that it is an \
extensible system. There is a certain amount of mathematical and other \
functionality that is built into Mathematica. But by using the Mathematica \
language, it is always possible to add more functionality. For many kinds of \
calculations, what is built into the standard version of Mathematica will be \
quite sufficient. However, if you work in a particular specialized area, you \
may find that you often need to use certain functions that are not built into \
Mathematica. In such cases, you may well be able to find a Mathematica \
package that contains the functions you need. Mathematica packages are files \
written in the Mathematica language. They consist of collections of \
Mathematica definitions which 'teach' Mathematica about particular \
application areas. ", "synonyms" -> {"1.3.10"}, "title" -> 
    "Mathematica Packages", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathematicaPackages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.10"->{
  Cell[2220, 66, 137, 6, 70, "Title",
   CellTags->{"S1.3.10", "10.1"},
   CellID->3780]},
 "10.1"->{
  Cell[2220, 66, 137, 6, 70, "Title",
   CellTags->{"S1.3.10", "10.1"},
   CellID->3780]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.10", 15674, 475},
 {"10.1", 15776, 479}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1595, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2220, 66, 137, 6, 70, "Title",
 CellTags->{"S1.3.10", "10.1"},
 CellID->3780],
Cell[2360, 74, 450, 13, 70, "Text",
 CellID->18554],
Cell[2813, 89, 401, 12, 70, "Text",
 CellID->3078],
Cell[3217, 103, 596, 18, 70, "Text",
 CellID->18061],
Cell[3816, 123, 529, 17, 70, "DefinitionBox",
 CellID->16868],
Cell[4348, 142, 126, 6, 70, "Caption",
 CellID->24521],
Cell[4477, 150, 481, 12, 70, "Text",
 CellID->25673],
Cell[4961, 164, 153, 6, 70, "MathCaption",
 CellID->21098],
Cell[5117, 172, 99, 3, 70, "Input",
 CellID->4757],
Cell[5219, 177, 251, 9, 70, "MathCaption",
 CellID->31258],
Cell[CellGroupData[{
Cell[5495, 190, 109, 3, 70, "Input",
 CellID->13419],
Cell[5607, 195, 162, 5, 36, "Output",
 CellID->1399434710]
}, Open  ]],
Cell[5784, 203, 998, 22, 70, "Text",
 CellID->70199801],
Cell[6785, 227, 585, 16, 70, "DefinitionBox",
 CellID->189],
Cell[7373, 245, 162, 6, 70, "Caption",
 CellID->22216],
Cell[7538, 253, 528, 15, 70, "Text",
 CellID->25956],
Cell[8069, 270, 443, 13, 70, "Text",
 CellID->23239],
Cell[8515, 285, 663, 19, 70, "Text",
 CellID->23725],
Cell[9181, 306, 404, 11, 70, "Text",
 CellID->8125],
Cell[9588, 319, 363, 10, 70, "Text",
 CellID->28532],
Cell[9954, 331, 498, 14, 70, "Text",
 CellID->8716],
Cell[10455, 347, 781, 17, 70, "Text",
 CellID->21762],
Cell[CellGroupData[{
Cell[11261, 368, 72, 1, 70, "RelatedTutorialsSection",
 CellID->108622829],
Cell[11336, 371, 431, 12, 70, "RelatedTutorials",
 CellID->344194261],
Cell[11770, 385, 188, 4, 70, "RelatedTutorials",
 CellID->270625667],
Cell[11961, 391, 419, 12, 70, "RelatedTutorials",
 CellID->133910369]
}, Open  ]]
}, Open  ]],
Cell[12407, 407, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

