(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38023,       1348]
NotebookOptionsPosition[     29570,       1066]
NotebookOutlinePosition[     33467,       1184]
CellTagsIndexPosition[     33129,       1168]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Main Loop\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Stand-alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica Sessions\"\>", 
       2->"\<\"Stand-alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exit" :> Documentation`HelpLookup["paclet:ref/Exit"], 
          "General" :> Documentation`HelpLookup["paclet:ref/General"], "Quit" :> 
          Documentation`HelpLookup["paclet:ref/Quit"], "$BaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$BaseDirectory"], "$Epilog" :> 
          Documentation`HelpLookup["paclet:ref/$Epilog"], "$IgnoreEOF" :> 
          Documentation`HelpLookup["paclet:ref/$IgnoreEOF"], 
          "$UserBaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserBaseDirectory"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Exit\"\>", 2->"\<\"General\"\>", 3->"\
\<\"Quit\"\>", 4->"\<\"$BaseDirectory\"\>", 5->"\<\"$Epilog\"\>", 
       6->"\<\"$IgnoreEOF\"\>", 
       7->"\<\"$UserBaseDirectory\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Sessions"
}], "Title",
 CellID->122753064],

Cell[CellGroupData[{

Cell["\<\
Command\[Hyphen]Line Options and Environment Variables\
\>", "Section",
 CellTags->{"SA.7.1", "1.1"},
 CellID->24464],

Cell[BoxData[GridBox[{
   {
    RowBox[{"-", "pwfile"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " password file"
    }], "TableText"]},
   {
    RowBox[{"-", "pwpath"}], Cell[TextData[{
     "path to search for a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " password file"
    }], "TableText"]},
   {
    RowBox[{"-", "run"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input to run (kernel only)"
    }], "TableText"]},
   {
    RowBox[{"-", "initfile"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " initialization file"
    }], "TableText"]},
   {
    RowBox[{"-", "initpath"}], Cell[
    "path to search for initialization files", "TableText"]},
   {
    RowBox[{"-", "noinit"}], Cell[
    "do not run initialization files", "TableText"]},
   {
    RowBox[{"-", "mathlink"}], Cell[TextData[{
     "communicate only via ",
     StyleBox["MathLink",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5705],

Cell[TextData[{
 "Typical command\[Hyphen]line options for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " executables. "
}], "Caption",
 CellID->28145],

Cell[TextData[{
 "If the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end is called with a notebook file as a command\[Hyphen]line \
argument, then this notebook will be made the initial selected notebook. \
Otherwise, a new notebook will be created for this purpose. "
}], "Text",
 CellID->23281],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernels and front ends can also take additional command\[Hyphen]line \
options specific to particular window environments. "
}], "Text",
 CellID->16827],

Cell[BoxData[GridBox[{
   {"MATHINIT", Cell[TextData[{
     "command\[Hyphen]line environment for the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end, as well as ",
     StyleBox["MathReader",
      FontSlant->"Italic"],
     " "
    }], "TableText"]},
   {"MATHKERNELINIT", Cell[TextData[{
     "command\[Hyphen]line environment for the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel"
    }], "TableText"]},
   {"MATHEMATICA_BASE", Cell[TextData[{
     "setting for ",
     Cell[BoxData[
      ButtonBox["$BaseDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"]
    }], "TableText"]},
   {"MATHEMATICA_USERBASE", Cell[TextData[{
     "setting for ",
     Cell[BoxData[
      ButtonBox["$UserBaseDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9961],

Cell["Environment variables. ", "Caption",
 CellID->491],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will read the values of operating system environment variables, and will \
use these values in addition to any command-line options explicitly given."
}], "Text",
 CellID->2995]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialization", "Section",
 CellTags->{"SA.7.2", "2.1"},
 CellID->9923],

Cell[TextData[{
 "On startup, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel does the following: "
}], "Text",
 CellID->30542],

Cell["Perform license management operations.", "Notes",
 CellID->14659],

Cell[TextData[{
 "Run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands specified in any ",
 Cell[BoxData[
  RowBox[{"-", "run"}]], "InlineFormula"],
 " options passed to the kernel executable."
}], "Notes",
 CellID->38381039],

Cell[TextData[{
 "Run the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands in the systemwide kernel ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " file."
}], "Notes",
 CellID->60140484],

Cell[TextData[{
 "Run the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands in the user\[Hyphen]specific kernel ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " file."
}], "Notes",
 CellID->73211040],

Cell[TextData[{
 "Load ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"Kernel", "/", 
   RowBox[{"init", ".", "m"}]}]], "InlineFormula"],
 " files in ",
 Cell[BoxData["Autoload"], "InlineFormula"],
 " directories."
}], "Notes",
 CellID->166044018],

Cell["Begin running the main loop.", "Notes",
 CellID->622007977]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Main Loop", "Section",
 CellTags->{"SA.7.3", "3.1"},
 CellID->16448],

Cell[TextData[{
 "All ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions repeatedly execute the following main loop: "
}], "Text",
 CellID->25636],

Cell["Read in input.", "Notes",
 CellID->12353],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " function, if defined, to the input string."
}], "Notes",
 CellID->145656002],

Cell["Print syntax warnings if necessary.", "Notes",
 CellID->921216496],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 " function if there is a syntax error."
}], "Notes",
 CellID->71964803],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->39978771],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " function, if defined, to the input expression."
}], "Notes",
 CellID->11645711],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->74735302],

Cell["Evaluate expression.", "Notes",
 CellID->23966918],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " function, if defined."
}], "Notes",
 CellID->28085948],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", stripping off any formatting wrappers."
}], "Notes",
 CellID->255691232],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 " function, if defined."
}], "Notes",
 CellID->84099801],

Cell[TextData[{
 "Assign ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " and clear ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3038955],

Cell[TextData[{
 "Print expression, if it is not ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->161464173],

Cell[TextData[{
 "Increment ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->296191971],

Cell["Clear any pending aborts.", "Notes",
 CellID->7706729],

Cell[TextData[{
 "Note that if you call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " from within an external program, then you must effectively create your own \
main loop, which will usually differ from the one described above. "
}], "Text",
 CellID->7549]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messages", "Section",
 CellTags->{"SA.7.4", "4.1"},
 CellID->5096],

Cell[TextData[{
 "During a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session messages can be generated either by explicit calls to ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 ", or in the course of executing other built\[Hyphen]in functions. "
}], "Text",
 CellID->30498],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "::", 
     StyleBox["name", "TI"], "::", 
     StyleBox["lang", "TI"]}], Cell[
    "a message in a specific language", "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "::", 
     StyleBox["name", "TI"]}], Cell[
    "a message in a default language", "TableText"]},
   {
    RowBox[{
     ButtonBox["General",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/General"], "::", 
     StyleBox["name", "TI"]}], Cell[
    "a general message with a given name", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30979],

Cell["Message names. ", "Caption",
 CellID->15138],

Cell[TextData[{
 "If no language is specified for a particular message, text for the message \
is sought in each of the languages specified by ",
 Cell[BoxData[
  ButtonBox["$Language",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Language"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "::", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 " is not defined, a definition for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 " is sought. If still no message is found, any value defined for ",
 Cell[BoxData[
  ButtonBox["$NewMessage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewMessage"]], "InlineFormula"],
 " is applied to ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellID->32306],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quiet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quiet"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " while preventing messages from being printed during the evaluation. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   StyleBox["message", "TI"], "]"}]], "InlineFormula"],
 " prevents a specified message from ever being printed. ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 " allows you to determine whether particular messages were generated during \
the evaluation of an expression. ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " record all the messages that were generated during the evaluation of a \
particular line in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->13991],

Cell[TextData[{
 "Messages are specified as strings to be used as the first argument of ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " is applied to each expression to be spliced into the string. "
}], "Text",
 CellID->28301]
}, Open  ]],

Cell[CellGroupData[{

Cell["Termination", "Section",
 CellTags->{"SA.7.5", "5.1"},
 CellID->2990],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Exit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exit"], "[", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Quit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quit"], "[", "]"}], Cell[TextData[{
     "terminate ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    ButtonBox["$Epilog",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Epilog"], Cell[TextData[{
     "symbol to evaluate before ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " exits"
    }], "TableText"]},
   {
    ButtonBox["$IgnoreEOF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$IgnoreEOF"], Cell[TextData[{
     "whether to exit an interactive ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session when an end\[Hyphen]of\[Hyphen]file character is received"
    }], "TableText"]},
   {
    RowBox[{"end", ".", "m"}], Cell[TextData[{
     "file to read when ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " terminates"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25412],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " termination. "
}], "Caption",
 CellID->14000],

Cell[TextData[{
 "There are several ways to end a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. If you are using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interactively, typing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exit"], "[", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quit"], "[", "]"}]], "InlineFormula"],
 " on an input line will always terminate ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->18064],

Cell[TextData[{
 "If you are taking input for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a file, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will exit when it reaches the end of the file. If you are using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interactively, it will still exit if it receives an \
end\[Hyphen]of\[Hyphen]file character (typically ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["d", "KeyEvent"],
 "). You can stop ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from doing this by setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$IgnoreEOF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$IgnoreEOF"], "=", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->28275]
}, Open  ]],

Cell[CellGroupData[{

Cell["Network License Management", "Section",
 CellTags->{"SA.7.6", "6.1"},
 CellID->24466],

Cell[BoxData[GridBox[{
   {Cell["single-machine license", "TableHeader"], Cell[
    "a process must always run on a specific machine", "TableText"]},
   {Cell["network license", "TableHeader"], Cell[
    "a process can run on any machine on a network", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10828],

Cell["\<\
Single\[Hyphen]machine and network licenses. \
\>", "Caption",
 CellID->16288],

Cell[TextData[{
 "Copies of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be set up with either single\[Hyphen]machine or network licenses. A \
network license is indicated by a line in the ",
 Cell[BoxData["mathpass"], "InlineFormula"],
 " file starting with ",
 Cell[BoxData[
  RowBox[{"!", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is the name of the server machine for the network license. "
}], "Text",
 CellID->8012],

Cell[TextData[{
 "Network licenses are controlled by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " license management program ",
 Cell[BoxData["mathlm"], "InlineFormula"],
 ", which is run on the server machine. This program must be running whenever \
a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a network license is being used. Typically you will want to set up \
your system so that ",
 Cell[BoxData["mathlm"], "InlineFormula"],
 " is started whenever the system boots."
}], "Text",
 CellID->24764],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Type ",
     Cell[BoxData[
      RowBox[{".", "\[Backslash]", "mathlm"}]], "InlineFormula"],
     " directly on the command line"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Add ",
     Cell[BoxData["mathlm"], "InlineFormula"],
     " as a Windows service"
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31935],

Cell["\<\
Ways to start the network license manager under Microsoft Windows. \
\>", "Caption",
 CellID->17072],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Type ",
     Cell[BoxData[
      RowBox[{".", "/", "mathlm"}]], "InlineFormula"],
     " directly on the Unix command line"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Add a line to start ",
     Cell[BoxData["mathlm"], "InlineFormula"],
     " in your central system startup script"
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12833],

Cell["\<\
Ways to start the network license manager on Macintosh and Unix systems. \
\>", "Caption",
 CellID->12920],

Cell[TextData[{
 "When ",
 Cell[BoxData["mathlm"], "InlineFormula"],
 " is not started directly from a command line, it normally sets itself up as \
a background process, and continues running until it is explicitly \
terminated. Note that if one ",
 Cell[BoxData["mathlm"], "InlineFormula"],
 " process is running, any other ",
 Cell[BoxData["mathlm"], "InlineFormula"],
 " processes you try to start will automatically exit immediately. "
}], "Text",
 CellID->20002],

Cell[BoxData[GridBox[{
   {
    RowBox[{"-", "logfile", " ", 
     StyleBox["file", "TI"]}], Cell[TextData[{
     "write a log of license server actions to ",
     Cell[BoxData[
      StyleBox["file", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"-", "loglevel", " ", 
     StyleBox["n", "TI"]}], Cell[
    "how verbose to make log entries (1 to 4)", "TableText"]},
   {
    RowBox[{"-", "logformat", " ", 
     StyleBox["string", "TI"]}], Cell[TextData[{
     "use a log format specified by ",
     Cell[BoxData[
      StyleBox["string", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"-", "language", " ", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "language to use for messages (default ",
     Cell[BoxData["English"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"-", "pwfile", " ", 
     StyleBox["file", "TI"]}], Cell[TextData[{
     "use the specified ",
     Cell[BoxData["mathpass"], "InlineFormula"],
     " file (default ",
     Cell[BoxData[
      RowBox[{".", "/", "mathpass"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"-", "timeout", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "suspend authorization on stopped ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " jobs after ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " hours"
    }], "TableText"]},
   {
    RowBox[{"-", "restrict", " ", 
     StyleBox["file", "TI"]}], Cell[
    "use the specified restriction file", "TableText"]},
   {
    RowBox[{"-", "mathid"}], Cell[
    "print the MathID for the license server, and exit", "TableText"]},
   {
    RowBox[{"-", "foreground"}], Cell[TextData[{
     "run ",
     Cell[BoxData["mathlm"], "InlineFormula"],
     " in the foreground, logging to ",
     Cell[BoxData["stdout"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"-", "install"}], Cell[TextData[{
     "install ",
     Cell[BoxData["mathlm"], "InlineFormula"],
     " as a Windows service (Microsoft Windows only)"
    }], "TableText"]},
   {
    RowBox[{"-", "uninstall"}], Cell[TextData[{
     "uninstall ",
     Cell[BoxData["mathlm"], "InlineFormula"],
     " as a Windows service (Microsoft Windows only)"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19202],

Cell[TextData[{
 "Some command\[Hyphen]line options for ",
 Cell[BoxData["mathlm"], "InlineFormula"],
 ". "
}], "Caption",
 CellID->13048],

Cell[TextData[{
 "For more detailed information on ",
 Cell[BoxData["mathlm"], "InlineFormula"],
 ", see \"",
 ButtonBox["System Administration for Network Licenses",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"],
 "\"."
}], "Text",
 CellID->13506],

Cell[BoxData[GridBox[{
   {"monitorlm", Cell[
    "a program to monitor network license activity", "TableText"]},
   {
    RowBox[{"monitorlm", " ", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "monitor activity for license server ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16913],

Cell["Monitoring network license activity. ", "Caption",
 CellID->25361],

Cell[TextData[{
 "If ",
 Cell[BoxData["monitorlm"], "InlineFormula"],
 " is run in an environment where a web browser can be started, it will \
automatically generate HTML output in the browser. Otherwise it will generate \
plain text. "
}], "Text",
 CellID->25210],

Cell[BoxData[GridBox[{
   {
    RowBox[{"-", "file", " ", 
     StyleBox["file", "TI"]}], Cell["write output to a file", "TableText"]},
   {
    RowBox[{"-", "format", " ", 
     StyleBox["spec", "TI"]}], Cell[TextData[{
     "use the specified format (",
     Cell[BoxData["text"], "InlineFormula"],
     ", ",
     Cell[BoxData["html"], "InlineFormula"],
     " or ",
     Cell[BoxData["cgi"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"-", "template", " ", 
     StyleBox["file", "TI"]}], Cell[
    "use the specified file as a template for the output", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17784],

Cell[TextData[{
 "Some command\[Hyphen]line options for ",
 Cell[BoxData["monitorlm"], "InlineFormula"],
 ". "
}], "Caption",
 CellID->8064],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->469529812],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"]
}], "TutorialMoreAbout",
 CellID->83059526],

Cell[TextData[{
 ButtonBox["Stand-alone ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
  FontSlant->"Italic"],
 ButtonBox[" Kernels",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"]
}], "TutorialMoreAbout",
 CellID->235631966]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->470183357],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "RelatedTutorials",
 CellID->960756]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematica Sessions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Global Aspects of Mathematica Sessions", "OverviewNavText"],
         BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GlobalSystemInformation"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 15.8517378}", "context" -> "", 
    "keywords" -> {
     "command line switch", "command line options", "kernel options", 
      "environment variables", "main loop", "evaluation loop", 
      "evaluation cycle"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Typical command-line options for Mathematica executables. If the \
Mathematica front end is called with a notebook file as a command-line \
argument, then this notebook will be made the initial selected notebook. \
Otherwise, a new notebook will be created for this purpose. Mathematica \
kernels and front ends can also take additional command-line options specific \
to particular window environments. ", "synonyms" -> {}, "title" -> 
    "Mathematica Sessions", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathematicaSessions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.7.1"->{
  Cell[3287, 93, 127, 4, 70, "Section",
   CellTags->{"SA.7.1", "1.1"},
   CellID->24464]},
 "1.1"->{
  Cell[3287, 93, 127, 4, 70, "Section",
   CellTags->{"SA.7.1", "1.1"},
   CellID->24464]},
 "SA.7.2"->{
  Cell[7140, 228, 78, 2, 70, "Section",
   CellTags->{"SA.7.2", "2.1"},
   CellID->9923]},
 "2.1"->{
  Cell[7140, 228, 78, 2, 70, "Section",
   CellTags->{"SA.7.2", "2.1"},
   CellID->9923]},
 "SA.7.3"->{
  Cell[8556, 296, 78, 2, 70, "Section",
   CellTags->{"SA.7.3", "3.1"},
   CellID->16448]},
 "3.1"->{
  Cell[8556, 296, 78, 2, 70, "Section",
   CellTags->{"SA.7.3", "3.1"},
   CellID->16448]},
 "SA.7.4"->{
  Cell[11999, 458, 72, 2, 70, "Section",
   CellTags->{"SA.7.4", "4.1"},
   CellID->5096]},
 "4.1"->{
  Cell[11999, 458, 72, 2, 70, "Section",
   CellTags->{"SA.7.4", "4.1"},
   CellID->5096]},
 "SA.7.5"->{
  Cell[16154, 602, 75, 2, 70, "Section",
   CellTags->{"SA.7.5", "5.1"},
   CellID->2990]},
 "5.1"->{
  Cell[16154, 602, 75, 2, 70, "Section",
   CellTags->{"SA.7.5", "5.1"},
   CellID->2990]},
 "SA.7.6"->{
  Cell[19336, 722, 91, 2, 70, "Section",
   CellTags->{"SA.7.6", "6.1"},
   CellID->24466]},
 "6.1"->{
  Cell[19336, 722, 91, 2, 70, "Section",
   CellTags->{"SA.7.6", "6.1"},
   CellID->24466]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.7.1", 31877, 1117},
 {"1.1", 31979, 1121},
 {"SA.7.2", 32084, 1125},
 {"2.1", 32185, 1129},
 {"SA.7.3", 32289, 1133},
 {"3.1", 32391, 1137},
 {"SA.7.4", 32496, 1141},
 {"4.1", 32598, 1145},
 {"SA.7.5", 32703, 1149},
 {"5.1", 32805, 1153},
 {"SA.7.6", 32910, 1157},
 {"6.1", 33013, 1161}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2527, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3152, 84, 110, 5, 70, "Title",
 CellID->122753064],
Cell[CellGroupData[{
Cell[3287, 93, 127, 4, 70, "Section",
 CellTags->{"SA.7.1", "1.1"},
 CellID->24464],
Cell[3417, 99, 1399, 47, 70, "DefinitionBox",
 CellID->5705],
Cell[4819, 148, 159, 6, 70, "Caption",
 CellID->28145],
Cell[4981, 156, 313, 8, 70, "Text",
 CellID->23281],
Cell[5297, 166, 220, 6, 70, "Text",
 CellID->16827],
Cell[5520, 174, 1276, 38, 70, "DefinitionBox",
 CellID->9961],
Cell[6799, 214, 56, 1, 70, "Caption",
 CellID->491],
Cell[6858, 217, 245, 6, 70, "Text",
 CellID->2995]
}, Open  ]],
Cell[CellGroupData[{
Cell[7140, 228, 78, 2, 70, "Section",
 CellTags->{"SA.7.2", "2.1"},
 CellID->9923],
Cell[7221, 232, 145, 6, 70, "Text",
 CellID->30542],
Cell[7369, 240, 71, 1, 70, "Notes",
 CellID->14659],
Cell[7443, 243, 240, 9, 70, "Notes",
 CellID->38381039],
Cell[7686, 254, 223, 9, 70, "Notes",
 CellID->60140484],
Cell[7912, 265, 234, 9, 70, "Notes",
 CellID->73211040],
Cell[8149, 276, 302, 12, 70, "Notes",
 CellID->166044018],
Cell[8454, 290, 65, 1, 70, "Notes",
 CellID->622007977]
}, Open  ]],
Cell[CellGroupData[{
Cell[8556, 296, 78, 2, 70, "Section",
 CellTags->{"SA.7.3", "3.1"},
 CellID->16448],
Cell[8637, 300, 159, 6, 70, "Text",
 CellID->25636],
Cell[8799, 308, 47, 1, 70, "Notes",
 CellID->12353],
Cell[8849, 311, 225, 8, 70, "Notes",
 CellID->145656002],
Cell[9077, 321, 72, 1, 70, "Notes",
 CellID->921216496],
Cell[9152, 324, 230, 8, 70, "Notes",
 CellID->71964803],
Cell[9385, 334, 234, 10, 70, "Notes",
 CellID->39978771],
Cell[9622, 346, 220, 8, 70, "Notes",
 CellID->11645711],
Cell[9845, 356, 222, 10, 70, "Notes",
 CellID->74735302],
Cell[10070, 368, 56, 1, 70, "Notes",
 CellID->23966918],
Cell[10129, 371, 197, 8, 70, "Notes",
 CellID->28085948],
Cell[10329, 381, 264, 10, 70, "Notes",
 CellID->255691232],
Cell[10596, 393, 205, 8, 70, "Notes",
 CellID->84099801],
Cell[10804, 403, 382, 15, 70, "Notes",
 CellID->3038955],
Cell[11189, 420, 200, 8, 70, "Notes",
 CellID->161464173],
Cell[11392, 430, 181, 8, 70, "Notes",
 CellID->296191971],
Cell[11576, 440, 60, 1, 70, "Notes",
 CellID->7706729],
Cell[11639, 443, 323, 10, 70, "Text",
 CellID->7549]
}, Open  ]],
Cell[CellGroupData[{
Cell[11999, 458, 72, 2, 70, "Section",
 CellTags->{"SA.7.4", "4.1"},
 CellID->5096],
Cell[12074, 462, 361, 11, 70, "Text",
 CellID->30498],
Cell[12438, 475, 889, 27, 70, "DefinitionBox",
 CellID->30979],
Cell[13330, 504, 50, 1, 70, "Caption",
 CellID->15138],
Cell[13383, 507, 989, 32, 70, "Text",
 CellID->32306],
Cell[14375, 541, 1290, 41, 70, "Text",
 CellID->13991],
Cell[15668, 584, 449, 13, 70, "Text",
 CellID->28301]
}, Open  ]],
Cell[CellGroupData[{
Cell[16154, 602, 75, 2, 70, "Section",
 CellTags->{"SA.7.5", "5.1"},
 CellID->2990],
Cell[16232, 606, 1474, 47, 70, "DefinitionBox",
 CellID->25412],
Cell[17709, 655, 113, 5, 70, "Caption",
 CellID->14000],
Cell[17825, 662, 621, 24, 70, "Text",
 CellID->18064],
Cell[18449, 688, 850, 29, 70, "Text",
 CellID->28275]
}, Open  ]],
Cell[CellGroupData[{
Cell[19336, 722, 91, 2, 70, "Section",
 CellTags->{"SA.7.6", "6.1"},
 CellID->24466],
Cell[19430, 726, 580, 13, 70, "DefinitionBox",
 CellID->10828],
Cell[20013, 741, 88, 3, 70, "Caption",
 CellID->16288],
Cell[20104, 746, 518, 16, 70, "Text",
 CellID->8012],
Cell[20625, 764, 531, 15, 70, "Text",
 CellID->24764],
Cell[21159, 781, 684, 20, 70, "FramedBox",
 CellID->31935],
Cell[21846, 803, 110, 3, 70, "Caption",
 CellID->17072],
Cell[21959, 808, 711, 20, 70, "FramedBox",
 CellID->12833],
Cell[22673, 830, 116, 3, 70, "Caption",
 CellID->12920],
Cell[22792, 835, 468, 11, 70, "Text",
 CellID->20002],
Cell[23263, 848, 2676, 83, 70, "DefinitionBox",
 CellID->19202],
Cell[25942, 933, 138, 5, 70, "Caption",
 CellID->13048],
Cell[26083, 940, 307, 10, 70, "Text",
 CellID->13506],
Cell[26393, 952, 644, 18, 70, "DefinitionBox",
 CellID->16913],
Cell[27040, 972, 72, 1, 70, "Caption",
 CellID->25361],
Cell[27115, 975, 265, 7, 70, "Text",
 CellID->25210],
Cell[27383, 984, 930, 27, 70, "DefinitionBox",
 CellID->17784],
Cell[28316, 1013, 140, 5, 70, "Caption",
 CellID->8064],
Cell[CellGroupData[{
Cell[28481, 1022, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->469529812],
Cell[28550, 1025, 285, 9, 70, "TutorialMoreAbout",
 CellID->83059526],
Cell[28838, 1036, 411, 12, 70, "TutorialMoreAbout",
 CellID->235631966]
}, Open  ]],
Cell[CellGroupData[{
Cell[29286, 1053, 72, 1, 70, "RelatedTutorialsSection",
 CellID->470183357],
Cell[29361, 1056, 143, 3, 70, "RelatedTutorials",
 CellID->960756]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[29543, 1064, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

