(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15131,        477]
NotebookOptionsPosition[     10756,        359]
NotebookOutlinePosition[     14088,        438]
CellTagsIndexPosition[     13997,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Catalan" :> Documentation`HelpLookup["paclet:ref/Catalan"], 
          "Degree" :> Documentation`HelpLookup["paclet:ref/Degree"], "E" :> 
          Documentation`HelpLookup["paclet:ref/E"], "EulerGamma" :> 
          Documentation`HelpLookup["paclet:ref/EulerGamma"], "Glaisher" :> 
          Documentation`HelpLookup["paclet:ref/Glaisher"], "GoldenRatio" :> 
          Documentation`HelpLookup["paclet:ref/GoldenRatio"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "Infinity" :> 
          Documentation`HelpLookup["paclet:ref/Infinity"], "Khinchin" :> 
          Documentation`HelpLookup["paclet:ref/Khinchin"], "Pi" :> 
          Documentation`HelpLookup["paclet:ref/Pi"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Catalan\"\>", 2->"\<\"Degree\"\>", 
       3->"\<\"E\"\>", 4->"\<\"EulerGamma\"\>", 5->"\<\"Glaisher\"\>", 
       6->"\<\"GoldenRatio\"\>", 7->"\<\"I\"\>", 8->"\<\"Infinity\"\>", 
       9->"\<\"Khinchin\"\>", 10->"\<\"Pi\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mathematical Constants", "Title",
 CellTags->{"S3.2.9", "9.1"},
 CellID->1408],

Cell[BoxData[GridBox[{
   {
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], Cell[BoxData[
     FormBox[
      RowBox[{"i", "=", 
       SqrtBox[
        RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineMath"]},
   {
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[BoxData[
     FormBox["\[Infinity]", TraditionalForm]], "InlineMath"]},
   {
    ButtonBox["Pi",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pi"], Cell[BoxData[
     FormBox[
      RowBox[{"\[Pi]", "\[TildeEqual]", "3.14159"}], TraditionalForm]], 
     "InlineMath"]},
   {
    ButtonBox["Degree",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Degree"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Pi]", "/", "180"}], TraditionalForm]], "InlineMath"],
     ": degrees to radians conversion factor"
    }], "TableText"]},
   {
    ButtonBox["GoldenRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GoldenRatio"], Cell[BoxData[
     FormBox[
      RowBox[{"\[Phi]", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["5"]}], ")"}], "/", "2"}], "\[TildeEqual]", "1.61803"}]}], 
      TraditionalForm]], "InlineMath"]},
   {
    ButtonBox["E",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/E"], Cell[BoxData[
     FormBox[
      RowBox[{"e", "\[TildeEqual]", "2.71828"}], TraditionalForm]], 
     "InlineMath"]},
   {
    ButtonBox["EulerGamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EulerGamma"], Cell[TextData[{
     "Euler\[CloseCurlyQuote]s constant ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Gamma]", "\[TildeEqual]", "0.577216"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Catalan",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Catalan"], Cell[TextData[{
     "Catalan\[CloseCurlyQuote]s constant ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        TagBox["C",
         Function[{}, Catalan]], "\[TildeEqual]", "0.915966"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Khinchin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Khinchin"], Cell[TextData[{
     "Khinchin\[CloseCurlyQuote]s constant ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        TagBox["K",
         Function[{}, Khinchin]], "\[TildeEqual]", "2.68545"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Glaisher",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Glaisher"], Cell[TextData[{
     "Glaisher\[CloseCurlyQuote]s constant ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        TagBox["A",
         Function[{}, Glaisher]], "\[TildeEqual]", "1.28243"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}}},
 CellID->30960],

Cell["Mathematical constants.", "Caption",
 CellID->19748],

Cell[TextData[{
 StyleBox["Euler\[CloseCurlyQuote]s constant", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 " is given by the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "=", 
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"m", "\[Rule]", "\[Infinity]"}],
      LimitsPositioning->True], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"k", "=", "1"}], "m",
         LimitsPositioning->True], 
        FractionBox["1", "k"]}], " ", "-", " ", 
       RowBox[{"log", "m"}]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". It appears in many integrals, and asymptotic formulas. It is sometimes \
known as the ",
 StyleBox["Euler\[Hyphen]Mascheroni constant", "TB"],
 ", and denoted ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->23085],

Cell[TextData[{
 StyleBox["Catalan\[CloseCurlyQuote]s constant", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Catalan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catalan"]], "InlineFormula"],
 " is given by the sum ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "k", "+", "1"}], ")"}], 
     RowBox[{"-", "2"}]]}], TraditionalForm]], "InlineMath"],
 ". It often appears in asymptotic estimates of combinatorial functions. It \
is variously denoted by ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData[
  FormBox["G", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->5778],

Cell[TextData[{
 StyleBox["Khinchin\[CloseCurlyQuote]s constant", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Khinchin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Khinchin"]], "InlineFormula"],
 " (sometimes called Khintchine\[CloseCurlyQuote]s constant) is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Product]", 
     RowBox[{"s", "=", "1"}], "\[Infinity]",
     LimitsPositioning->True], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"s", 
         RowBox[{"(", 
          RowBox[{"s", "+", "2"}], ")"}]}]]}], ")"}], 
     RowBox[{
      SubscriptBox["log", "2"], "s"}]]}], TraditionalForm]], "InlineMath"],
 ". It gives the geometric mean of the terms in the continued fraction \
representation for a typical real number. "
}], "Text",
 CellID->30101],

Cell[TextData[{
 StyleBox["Glaisher\[CloseCurlyQuote]s constant", "TB"],
 " ",
 Cell[BoxData[
  ButtonBox["Glaisher",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glaisher"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " (sometimes called the Glaisher\[Hyphen]Kinkelin constant) satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", 
    RowBox[{"(", "A", ")"}], "=", 
    FractionBox["1", "12"], "-", 
    SuperscriptBox["\[Zeta]", "\[Prime]"], 
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Zeta]", TraditionalForm]], "InlineMath"],
 " is the Riemann zeta function. It appears in various sums and integrals, \
particularly those involving gamma and zeta functions."
}], "Text",
 CellID->8171],

Cell["\<\
Mathematical constants can be evaluated to arbitrary precision. \
\>", "MathCaption",
 CellID->32505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"EulerGamma", ",", "40"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27401],

Cell[BoxData["0.57721566490153286060651209008240243104215862740892644486`40."]\
, "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->638603015]
}, Open  ]],

Cell["Exact computations can also be done with them. ", "MathCaption",
 CellID->4172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"GoldenRatio", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21109],

Cell[BoxData["792070839848372253126"], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->246376469]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->167205761],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematical Constants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FunctionsThatDoNotHaveUniqueValues"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OrthogonalPolynomials"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 13.8048104}", "context" -> "", 
    "keywords" -> {
     "Catalan", "Catalan constant", "constants", "continued fractions", 
      "Degree", "E", "EulerGamma", "Euler-Mascheroni constant", 
      "Euler's constant", "exponential constant", "Glaisher", "golden mean", 
      "GoldenRatio", "golden ratio", "I", "infinity", "Khinchin", 
      "Kinkelin constant", "logarithms", "mathematical constants", "phi", 
      "pi"}, "index" -> True, "label" -> "Mathematica Tutorial", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematical constants. Euler's constant EulerGamma is given by the \
limit \\[Gamma]=UnderscriptBox[lim, RowBox[{m, ->, Infinity}], \
LimitsPositioning -> True](UnderoverscriptBox[\\[Sum], RowBox[{k, =, 1}], m, \
LimitsPositioning -> True]FractionBox[1, k] - logm). It appears in many \
integrals, and asymptotic formulas. It is sometimes known as the \
Euler-Mascheroni constant, and denoted C. Catalan's constant Catalan is given \
by the sum UnderoverscriptBox[\\[Sum], RowBox[{k, =, 0}], Infinity, \
LimitsPositioning -> True](-1)^k(2k+1)^-2. It often appears in asymptotic \
estimates of combinatorial functions. It is variously denoted by C, K, or G. \
", "synonyms" -> {"3.2.9"}, "title" -> "Mathematical Constants", "type" -> 
    "Tutorial", "uri" -> "tutorial/MathematicalConstants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.9"->{
  Cell[2647, 69, 84, 2, 70, "Title",
   CellTags->{"S3.2.9", "9.1"},
   CellID->1408]},
 "9.1"->{
  Cell[2647, 69, 84, 2, 70, "Title",
   CellTags->{"S3.2.9", "9.1"},
   CellID->1408]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.9", 13788, 421},
 {"9.1", 13886, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2022, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2647, 69, 84, 2, 70, "Title",
 CellTags->{"S3.2.9", "9.1"},
 CellID->1408],
Cell[2734, 73, 3102, 102, 70, "DefinitionBox",
 CellID->30960],
Cell[5839, 177, 58, 1, 70, "Caption",
 CellID->19748],
Cell[5900, 180, 953, 31, 70, "Text",
 CellID->23085],
Cell[6856, 213, 940, 33, 70, "Text",
 CellID->5778],
Cell[7799, 248, 850, 26, 70, "Text",
 CellID->30101],
Cell[8652, 276, 828, 25, 70, "Text",
 CellID->8171],
Cell[9483, 303, 111, 3, 70, "MathCaption",
 CellID->32505],
Cell[CellGroupData[{
Cell[9619, 310, 126, 4, 28, "Input",
 CellID->27401],
Cell[9748, 316, 222, 6, 36, "Output",
 CellID->638603015]
}, Open  ]],
Cell[9985, 325, 85, 1, 70, "MathCaption",
 CellID->4172],
Cell[CellGroupData[{
Cell[10095, 330, 138, 4, 70, "Input",
 CellID->21109],
Cell[10236, 336, 179, 5, 36, "Output",
 CellID->246376469]
}, Open  ]],
Cell[CellGroupData[{
Cell[10452, 346, 72, 1, 70, "RelatedTutorialsSection",
 CellID->167205761],
Cell[10527, 349, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[10729, 357, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

