(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24922,        781]
NotebookOptionsPosition[     18653,        601]
NotebookOutlinePosition[     22309,        684]
CellTagsIndexPosition[     22217,        678]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Aspects of Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"], 
          "Basic Internal Architecture" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BasicInternalArchitecture"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Global Aspects of Mathematica Sessions\"\>", 
       2->"\<\"Basic Internal Architecture\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"],
           "LeafCount" :> Documentation`HelpLookup["paclet:ref/LeafCount"], 
          "MaxMemoryUsed" :> 
          Documentation`HelpLookup["paclet:ref/MaxMemoryUsed"], 
          "MemoryConstrained" :> 
          Documentation`HelpLookup["paclet:ref/MemoryConstrained"], 
          "MemoryInUse" :> Documentation`HelpLookup["paclet:ref/MemoryInUse"],
           "Share" :> Documentation`HelpLookup["paclet:ref/Share"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ByteCount\"\>", 
       2->"\<\"LeafCount\"\>", 3->"\<\"MaxMemoryUsed\"\>", 
       4->"\<\"MemoryConstrained\"\>", 5->"\<\"MemoryInUse\"\>", 
       6->"\<\"Share\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Memory Management", "Title",
 CellTags->{"S2.14.4", "4.1"},
 CellID->15717],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MemoryInUse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MemoryInUse"], "[", "]"}], Cell[TextData[{
     "number of bytes of memory currently being used by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MaxMemoryUsed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MaxMemoryUsed"], "[", "]"}], Cell[TextData[{
     "maximum number of bytes of memory used by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " in this session"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13965],

Cell["Finding memory usage. ", "Caption",
 CellID->4539],

Cell["\<\
Particularly for symbolic computations, memory is usually the primary \
resource which limits the size of computations you can do. If a computation \
runs slowly, you can always potentially let it run longer. But if the \
computation generates intermediate expressions which simply cannot fit in the \
memory of your computer system, then you cannot proceed with the computation. \
\
\>", "Text",
 CellID->19501],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is careful about the way it uses memory. Every time an intermediate \
expression you have generated is no longer needed, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " immediately reclaims the memory allocated to it. This means that at any \
point in a session, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores only those expressions that are actually needed; it does not keep \
unnecessary objects which have to be \[OpenCurlyDoubleQuote]garbage collected\
\[CloseCurlyDoubleQuote] later. "
}], "Text",
 CellID->6423],

Cell[TextData[{
 "This gives the number of bytes of memory currently being used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->23815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29409],

Cell[BoxData["947712"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->10053]
}, Open  ]],

Cell["\<\
This generates a 10000\[Hyphen]element list. \
\>", "MathCaption",
 CellID->6002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Range", "[", "10000", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->4431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", 
   RowBox[{"\[LeftSkeleton]", "9985", "\[RightSkeleton]"}], ",", "9994", ",", 
   "9995", ",", "9996", ",", "9997", ",", "9998", ",", "9999", ",", "10000"}],
   "}"}]], "Output",
 ImageSize->{503, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11585]
}, Open  ]],

Cell["Additional memory is needed to store the list. ", "MathCaption",
 CellID->17089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->29807],

Cell[BoxData["989616"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->15944]
}, Open  ]],

Cell[TextData[{
 "This list is kept because it is the value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", "2", "]"}]], "InlineFormula"],
 ". If you clear ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", "2", "]"}]], "InlineFormula"],
 ", the list is no longer needed. "
}], "MathCaption",
 CellID->25535],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "Out", "]"}], ";", 
  RowBox[{
   RowBox[{"Out", "[", "2", "]"}], "=."}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->19264],

Cell["The memory in use goes down again. ", "MathCaption",
 CellID->10812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryInUse", "[", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->13627],

Cell[BoxData["954408"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->8984]
}, Open  ]],

Cell["\<\
This shows the maximum memory needed at any point in the session. \
\>", "MathCaption",
 CellID->22755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxMemoryUsed", "[", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30095],

Cell[BoxData["1467536"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->28885]
}, Open  ]],

Cell[TextData[{
 "One issue that often comes up is exactly how much memory ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can actually use on a particular computer system. Usually there is a \
certain amount of memory available for ",
 StyleBox["all",
  FontSlant->"Italic"],
 " processes running on the computer at a particular time. Sometimes this \
amount of memory is equal to the physical number of bytes of RAM in the \
computer. Often, it includes a certain amount of \
\[OpenCurlyDoubleQuote]virtual memory\[CloseCurlyDoubleQuote], obtained by \
swapping data on and off a mass storage device. "
}], "Text",
 CellID->10449],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " runs, it needs space both for data and for code. The complete code of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is typically several megabytes in size. For any particular calculation, \
only a small fraction of this code is usually used. However, in trying to \
work out the total amount of space available for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " data, you should not forget what is needed for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. In addition, you must include the space that is taken up by other \
processes running in the computer. If there are fewer jobs running, you will \
usually find that your job can use more memory. "
}], "Text",
 CellID->27238],

Cell[TextData[{
 "It is also worth realizing that the time needed to do a calculation can \
depend very greatly on how much physical memory you have. Although virtual \
memory allows you in principle to use large amounts of memory space, it is \
usually hundreds or even thousands of times slower to access than physical \
memory. As a result, if your calculation becomes so large that it needs to \
make use of virtual memory, it may run ",
 StyleBox["much",
  FontSlant->"Italic"],
 " more slowly. "
}], "Text",
 CellID->29755],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MemoryConstrained",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MemoryConstrained"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "try to evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", aborting if more than ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " additional bytes of memory are requested"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MemoryConstrained",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MemoryConstrained"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["failexpr", "TI"], "]"}], Cell[TextData[{
     "return ",
     Cell[BoxData[
      StyleBox["failexpr", "TI"]], "InlineFormula"],
     " if the memory constraint is not met"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2415],

Cell["\<\
Memory\[Hyphen]constrained computation. \
\>", "Caption",
 CellID->5741],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemoryConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFormula"],
 " works much like ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 ". If more than the specified amount of memory is requested, ",
 Cell[BoxData[
  ButtonBox["MemoryConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFormula"],
 " attempts to abort your computation. As with ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 ", there may be some overshoot in the actual amount of memory used before \
the computation is aborted. "
}], "Text",
 CellID->7056],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ByteCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ByteCount"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "the maximum number of bytes of memory needed to store ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LeafCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LeafCount"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "the number of terminal nodes in the expression tree for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4609],

Cell["Finding the size of expressions. ", "Caption",
 CellID->16019],

Cell[TextData[{
 "Although you may find ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " useful in estimating how large an expression of a particular kind you can \
handle, you should realize that the specific results given by ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " can differ substantially from one version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to another. "
}], "Text",
 CellID->25827],

Cell[TextData[{
 "Another important point is that ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " always gives you the ",
 StyleBox["maximum",
  FontSlant->"Italic"],
 " amount of memory needed to store a particular expression. Often ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will actually use a much smaller amount of memory to store the expression. \
The main issue is how many of the subexpressions in the expression can be ",
 StyleBox["shared",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->6862],

Cell[TextData[{
 "In an expression like ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"1", "+", "x"}], ",", 
    RowBox[{"1", "+", "x"}]}], "]"}]], "InlineFormula"],
 ", the two subexpressions ",
 Cell[BoxData[
  RowBox[{"1", "+", "x"}]], "InlineFormula"],
 " are identical, but they may or may not actually be stored in the same \
piece of computer memory. ",
 Cell[BoxData[
  ButtonBox["ByteCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteCount"]], "InlineFormula"],
 " gives you the number of bytes needed to store expressions with the \
assumption that no subexpressions are shared. You should realize that the \
sharing of subexpressions is often destroyed as soon as you use an operation \
like the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. "
}], "Text",
 CellID->14248],

Cell[TextData[{
 "Nevertheless, you can explicitly tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to share subexpressions using the function ",
 Cell[BoxData[
  ButtonBox["Share",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Share"]], "InlineFormula"],
 ". In this way, you can significantly reduce the actual amount of memory \
needed to store a particular expression. "
}], "Text",
 CellID->14779],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Share",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Share"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "share common subexpressions in the storage of ",
     StyleBox["expr", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Share",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Share"], "[", "]"}], Cell[
    "share common subexpressions throughout memory", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11343],

Cell["Optimizing memory usage. ", "Caption",
 CellID->8731],

Cell["\<\
On most computer systems, the memory used by a running program is divided \
into two parts: memory explicitly allocated by the program, and \
\[OpenCurlyDoubleQuote]stack space\[CloseCurlyDoubleQuote]. Every time an \
internal routine is called in the program, a certain amount of stack space is \
used to store parameters associated with the call. On many computer systems, \
the maximum amount of stack space that can be used by a program must be \
specified in advance. If the specified stack space limit is exceeded, the \
program usually just exits. \
\>", "Text",
 CellID->28751],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", one of the primary uses of stack space is in handling the calling of one \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function by another. All such calls are explicitly recorded in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " discussed in \"",
 ButtonBox["The Evaluation Stack\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheEvaluationStack"],
 ". You can control the size of this stack by setting the global parameter ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 ". You should be sure that this parameter is set small enough that you do \
not run out of stack space on your particular computer system. "
}], "Text",
 CellID->28251],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->161340511],

Cell[TextData[{
 ButtonBox["Global Aspects of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]
}], "RelatedTutorials",
 CellID->1006056654],

Cell[TextData[ButtonBox["Basic Internal Architecture",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicInternalArchitecture"]], "RelatedTutorials",\

 CellID->916523645]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Memory Management - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Global Aspects of Mathematica Sessions", "OverviewNavText"],
         BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Dialogs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GlobalSystemInformation"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 27.3364068}", "context" -> "", 
    "keywords" -> {
     "atoms", "ByteCount", "byte count", "common subexpressions", 
      "compacting expressions", "constraints", "core usage", "crashing", 
      "evaluation", "expressions", "freeing memory", "garbage collection", 
      "LeafCount", "leaf count", "MaxMemoryUsed", "megabytes", "memory", 
      "memory management", "MemoryConstrained", "MemoryInUse", "process size",
       "RAM", "recursion", "RecursionLimit", "share", "size", 
      "size of computation", "space", "stack space", "storage", 
      "swapping (virtual memory)", "trees", "virtual memory"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Finding memory usage. Particularly for symbolic computations, memory is \
usually the primary resource which limits the size of computations you can \
do. If a computation runs slowly, you can always potentially let it run \
longer. But if the computation generates intermediate expressions which \
simply cannot fit in the memory of your computer system, then you cannot \
proceed with the computation. Mathematica is careful about the way it uses \
memory. Every time an intermediate expression you have generated is no longer \
needed, Mathematica immediately reclaims the memory allocated to it. This \
means that at any point in a session, Mathematica stores only those \
expressions that are actually needed; it does not keep unnecessary objects \
which have to be 'garbage collected' later. ", "synonyms" -> {"2.14.4"}, 
    "title" -> "Memory Management", "type" -> "Tutorial", "uri" -> 
    "tutorial/MemoryManagement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.14.4"->{
  Cell[2615, 71, 81, 2, 70, "Title",
   CellTags->{"S2.14.4", "4.1"},
   CellID->15717]},
 "4.1"->{
  Cell[2615, 71, 81, 2, 70, "Title",
   CellTags->{"S2.14.4", "4.1"},
   CellID->15717]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.14.4", 22004, 667},
 {"4.1", 22104, 671}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1990, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2615, 71, 81, 2, 70, "Title",
 CellTags->{"S2.14.4", "4.1"},
 CellID->15717],
Cell[2699, 75, 924, 28, 70, "DefinitionBox",
 CellID->13965],
Cell[3626, 105, 56, 1, 70, "Caption",
 CellID->4539],
Cell[3685, 108, 422, 8, 70, "Text",
 CellID->19501],
Cell[4110, 118, 607, 15, 70, "Text",
 CellID->6423],
Cell[4720, 135, 175, 6, 70, "MathCaption",
 CellID->23815],
Cell[CellGroupData[{
Cell[4920, 145, 99, 3, 28, "Input",
 CellID->29409],
Cell[5022, 150, 160, 5, 36, "Output",
 CellID->10053]
}, Open  ]],
Cell[5197, 158, 91, 3, 70, "MathCaption",
 CellID->6002],
Cell[CellGroupData[{
Cell[5313, 165, 129, 4, 28, "Input",
 CellID->4431],
Cell[5445, 171, 433, 12, 36, "Output",
 CellID->11585]
}, Open  ]],
Cell[5893, 186, 86, 1, 70, "MathCaption",
 CellID->17089],
Cell[CellGroupData[{
Cell[6004, 191, 99, 3, 70, "Input",
 CellID->29807],
Cell[6106, 196, 160, 5, 36, "Output",
 CellID->15944]
}, Open  ]],
Cell[6281, 204, 436, 15, 70, "MathCaption",
 CellID->25535],
Cell[6720, 221, 177, 6, 70, "Input",
 CellID->19264],
Cell[6900, 229, 74, 1, 70, "MathCaption",
 CellID->10812],
Cell[CellGroupData[{
Cell[6999, 234, 99, 3, 70, "Input",
 CellID->13627],
Cell[7101, 239, 159, 5, 36, "Output",
 CellID->8984]
}, Open  ]],
Cell[7275, 247, 113, 3, 70, "MathCaption",
 CellID->22755],
Cell[CellGroupData[{
Cell[7413, 254, 101, 3, 70, "Input",
 CellID->30095],
Cell[7517, 259, 161, 5, 36, "Output",
 CellID->28885]
}, Open  ]],
Cell[7693, 267, 639, 14, 70, "Text",
 CellID->10449],
Cell[8335, 283, 789, 19, 70, "Text",
 CellID->27238],
Cell[9127, 304, 529, 11, 70, "Text",
 CellID->29755],
Cell[9659, 317, 1380, 40, 70, "DefinitionBox",
 CellID->2415],
Cell[11042, 359, 82, 3, 70, "Caption",
 CellID->5741],
Cell[11127, 364, 826, 23, 70, "Text",
 CellID->7056],
Cell[11956, 389, 986, 29, 70, "DefinitionBox",
 CellID->4609],
Cell[12945, 420, 68, 1, 70, "Caption",
 CellID->16019],
Cell[13016, 423, 573, 17, 70, "Text",
 CellID->25827],
Cell[13592, 442, 598, 18, 70, "Text",
 CellID->6862],
Cell[14193, 462, 819, 23, 70, "Text",
 CellID->14248],
Cell[15015, 487, 416, 12, 70, "Text",
 CellID->14779],
Cell[15434, 501, 797, 24, 70, "DefinitionBox",
 CellID->11343],
Cell[16234, 527, 59, 1, 70, "Caption",
 CellID->8731],
Cell[16296, 530, 595, 10, 70, "Text",
 CellID->28751],
Cell[16894, 542, 957, 28, 70, "Text",
 CellID->28251],
Cell[CellGroupData[{
Cell[17876, 574, 72, 1, 70, "RelatedTutorialsSection",
 CellID->161340511],
Cell[17951, 577, 469, 12, 70, "RelatedTutorials",
 CellID->1006056654],
Cell[18423, 591, 176, 4, 70, "RelatedTutorials",
 CellID->916523645]
}, Open  ]]
}, Open  ]],
Cell[18626, 599, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

