(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48454,       1678]
NotebookOptionsPosition[     38621,       1359]
NotebookOutlinePosition[     41890,       1437]
CellTagsIndexPosition[     41795,       1431]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Check" :> Documentation`HelpLookup["paclet:ref/Check"], 
          "Message" :> Documentation`HelpLookup["paclet:ref/Message"], 
          "MessageList" :> Documentation`HelpLookup["paclet:ref/MessageList"],
           "Messages" :> Documentation`HelpLookup["paclet:ref/Messages"], 
          "Off" :> Documentation`HelpLookup["paclet:ref/Off"], "On" :> 
          Documentation`HelpLookup["paclet:ref/On"], "Quiet" :> 
          Documentation`HelpLookup["paclet:ref/Quiet"], "$MessageList" :> 
          Documentation`HelpLookup["paclet:ref/$MessageList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Check\"\>", 2->"\<\"Message\"\>", 
       3->"\<\"MessageList\"\>", 4->"\<\"Messages\"\>", 5->"\<\"Off\"\>", 
       6->"\<\"On\"\>", 7->"\<\"Quiet\"\>", 
       8->"\<\"$MessageList\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Messages", "Title",
 CellTags->{"S2.9.21", "21.1"},
 CellID->12413],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a general mechanism for handling messages generated during \
computations. Many built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions use this mechanism to produce error and warning messages. You \
can also use the mechanism for messages associated with functions you write. \
"
}], "Text",
 CellID->17781],

Cell[TextData[{
 "The basic idea is that every message has a definite name, of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". You can use this name to refer to the message. (The object ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " has head ",
 Cell[BoxData[
  ButtonBox["MessageName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessageName"]], "InlineFormula"],
 ".) "
}], "Text",
 CellID->28451],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Quiet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quiet"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " without printing any messages"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Quiet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quiet"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["s", "TI"], 
          StyleBox["1", "TR"]], "::", 
         StyleBox["tag", "TI"]}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["s", "TI"], 
          StyleBox["2", "TR"]], "::", 
         StyleBox["tag", "TI"]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " without printing the specified messages"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Off",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Off"], "[", 
     StyleBox["s", "TI"], "::", 
     StyleBox["tag", "TI"], "]"}], Cell[
    "switch off a message, so it is not printed", "TableText"]},
   {
    RowBox[{
     ButtonBox["On",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/On"], "[", 
     StyleBox["s", "TI"], "::", 
     StyleBox["tag", "TI"], "]"}], Cell["switch on a message", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3469],

Cell["Controlling the printing of messages. ", "Caption",
 CellID->8286],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Warnings and Messages\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WarningsAndMessages"],
 ", you can use ",
 Cell[BoxData[
  ButtonBox["Quiet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quiet"]], "InlineFormula"],
 " to control the printing of particular messages during an evaluation. Most \
messages associated with built\[Hyphen]in functions are switched on by \
default. If you want to suppress a message permanently, you can use ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->107541266],

Cell["\<\
This prints a warning message. Also, the front end highlights the extra \
argument in red.\
\>", "MathCaption",
 CellID->63228177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32853303],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "::", "\<\"argt\"\>"}], ":", 
  " ", "\<\"\\!\\(Log\\) called with \\!\\(3\\) arguments; \\!\\(1\\) or \
\\!\\(2\\) arguments are expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argt\\\", \
ButtonNote -> \\\"Log::argt\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->262903226],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->359101457]
}, Open  ]],

Cell["This suppresses the warning message. ", "MathCaption",
 CellID->8329726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141563161],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->296107062]
}, Open  ]],

Cell["The message reappears with the next evaluation. ", "MathCaption",
 CellID->31040319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->214523063],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "::", "\<\"argt\"\>"}], ":", 
  " ", "\<\"\\!\\(Log\\) called with \\!\\(3\\) arguments; \\!\\(1\\) or \
\\!\\(2\\) arguments are expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argt\\\", \
ButtonNote -> \\\"Log::argt\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->3559266],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->465294102]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["On",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/On"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 " to make global changes to the printing of particular messages. You can use \
",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 " to switch off a message if you never want to see it. "
}], "Text",
 CellID->7277],

Cell["You can switch off the message like this. ", "MathCaption",
 CellID->26658],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"Log", "::", "argt"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14799],

Cell["Now no warning message is produced. ", "MathCaption",
 CellID->15961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->8380],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->15725380]
}, Open  ]],

Cell[TextData[{
 "Although most messages associated with built\[Hyphen]in functions are \
switched on by default, there are some which are switched off by default, and \
which you will see only if you explicitly switch them on. An example is the \
message ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", "newsym"}]], "InlineFormula"],
 ", discussed in \"",
 ButtonBox["Intercepting the Creation of New Symbols\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InterceptingTheCreationOfNewSymbols"],
 ", which tells you every time a new symbol is created. "
}], "Text",
 CellID->28584],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["s", "TI"], "::", 
     StyleBox["tag", "TI"]}], Cell[
    "give the text of a message", "TableText"]},
   {
    RowBox[{
     StyleBox["s", "TI"], "::", 
     StyleBox["tag", "TI"], "=", 
     StyleBox["string", "TI"]}], Cell[
    "set the text of a message", "TableText"]},
   {
    RowBox[{
     ButtonBox["Messages",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Messages"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "show all messages associated with ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30538],

Cell["Manipulating messages. ", "Caption",
 CellID->8113],

Cell[TextData[{
 "The text of a message with the name ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " is stored simply as the value of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ", associated with the symbol ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 ". You can therefore see the text of a message simply by asking for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". You can set the text by assigning a value to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11656],

Cell[TextData[{
 "If you give ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " a singular matrix, it prints a warning message. "
}], "MathCaption",
 CellID->24593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->8373],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[6]:=",
 CellID->148282610],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], "]"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->466199132]
}, Open  ]],

Cell["Here is the text of the message. ", "MathCaption",
 CellID->24252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "::", "nosol"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->7253],

Cell[BoxData["\<\"Linear equation encountered that has no solution.\"\>"], \
"Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->319684732]
}, Open  ]],

Cell["This redefines the message. ", "MathCaption",
 CellID->12623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "nosol"}], "=", 
  "\"\<Matrix encountered is not invertible.\>\""}]], "Input",
 CellLabel->"In[8]:=",
 CellID->16100],

Cell[BoxData["\<\"Matrix encountered is not invertible.\"\>"], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->462075064]
}, Open  ]],

Cell["Now the new form will be used. ", "MathCaption",
 CellID->20600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->28366],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Matrix encountered is not invertible. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", ButtonNote -> \
\\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[9]:=",
 CellID->152532978],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}]}], "]"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->102648339]
}, Open  ]],

Cell[TextData[{
 "Messages are always stored as strings suitable for use with ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". When the message is printed, the appropriate expressions are \
\[OpenCurlyDoubleQuote]spliced\[CloseCurlyDoubleQuote] into it. The \
expressions are wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to prevent evaluation. In addition, any function that is assigned as the \
value of the global variable ",
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " is applied to the resulting expressions before they are given to ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". The default for ",
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " for text formatting and a combination of ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " for typesetting. "
}], "Text",
 CellID->6164],

Cell["\<\
Most messages are associated directly with the functions that generate them. \
There are, however, some \[OpenCurlyDoubleQuote]general\
\[CloseCurlyDoubleQuote] messages, which can be produced by a variety of \
functions. \
\>", "Text",
 CellID->7303],

Cell[TextData[{
 "If you give the wrong number of arguments to a function ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will warn you by printing a message such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["F", "TI"], "::", "argx"}]], "InlineFormula"],
 ". If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot find a message named ",
 Cell[BoxData[
  RowBox[{
   StyleBox["F", "TI"], "::", "argx"}]], "InlineFormula"],
 ", it will use the text of the \[OpenCurlyDoubleQuote]general\
\[CloseCurlyDoubleQuote] message ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", "argx"}]], "InlineFormula"],
 " instead. You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    StyleBox["F", "TI"], "::", "argx"}], "]"}]], "InlineFormula"],
 " to switch off the argument count message specifically for the function ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 ". You can also use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    ButtonBox["General",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/General"], "::", "argx"}], "]"}]], 
  "InlineFormula"],
 " to switch off all messages that use the text of the general message."
}], "Text",
 CellID->16281],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a message if you give the wrong number of arguments to a built\
\[Hyphen]in function. "
}], "MathCaption",
 CellID->23952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->25809],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sqrt\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sqrt::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[10]:=",
 CellID->327478920],

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->105999746]
}, Open  ]],

Cell["\<\
This argument count message is a general one, used by many different \
functions.\
\>", "MathCaption",
 CellID->1482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"General", "::", "argx"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->20089],

Cell[BoxData["\<\"`1` called with `2` arguments; 1 argument is \
expected.\"\>"], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->775695851]
}, Open  ]],

Cell[TextData[{
 "If something goes very wrong with a calculation you are doing, it is common \
to find that the same warning message is generated over and over again. This \
is usually more confusing than useful. As a result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " keeps track of all messages that are produced during a particular \
calculation, and stops printing a particular message if it comes up more than \
three times. Whenever this happens, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints the message ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", "stop"}]], "InlineFormula"],
 " to let you know. If you really want to see all the messages that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to print, you can do this by switching off ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", "stop"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->21704],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$MessageList",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MessageList"], Cell["\<\
a list of the messages produced during a particular computation\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MessageList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MessageList"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "a list of the messages produced during the processing of the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " input line in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22869],

Cell["\<\
Finding out what messages were produced during a computation. \
\>", "Caption",
 CellID->17940],

Cell[TextData[{
 "In every computation you do, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " maintains a list ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " of all the messages that are produced. In a standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, this list is cleared after each line of output is generated. \
However, during a computation, you can access the list. In addition, when the \
",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " output line in a session is generated, the value of ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " is assigned to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21136],

Cell[TextData[{
 "This returns ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 ", which gives a list of the messages produced. "
}], "MathCaption",
 CellID->12065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], ";", 
  RowBox[{"Exp", "[", 
   RowBox[{"a", ",", "b"}], "]"}], ";", "$MessageList"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->25805],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sqrt\\) called with \\!\\(3\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sqrt::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[12]:=",
 CellID->464177185],

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Exp\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Exp::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[12]:=",
 CellID->240016788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"Sqrt", "::", "\<\"argx\"\>"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Exp", "::", "\<\"argx\"\>"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->260089778]
}, Open  ]],

Cell[TextData[{
 "The message names are wrapped in ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to stop them from evaluating. "
}], "MathCaption",
 CellID->29955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->625],

Cell["{HoldForm[Sqrt::argx], HoldForm[Exp::argx]}", "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//InputForm=",
 CellID->6682140]
}, Open  ]],

Cell["\<\
In writing programs, it is often important to be able to check automatically \
whether any messages were generated during a particular calculation. If \
messages were generated, say as a consequence of producing indeterminate \
numerical results, then the result of the calculation may be meaningless.\
\>", "Text",
 CellID->17156],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Check",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Check"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["failexpr", "TI"], "]"}], Cell[TextData[{
     "if no messages are generated during the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", then return ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", otherwise return ",
     Cell[BoxData[
      StyleBox["failexpr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Check",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Check"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["failexpr", "TI"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], "1"], "::", 
     SubscriptBox[
      StyleBox["t", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], "2"], "::", 
     SubscriptBox[
      StyleBox["t", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "check only for the messages ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     Cell[BoxData["::"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.45], {
      Scaled[0.55]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27388],

Cell["Checking for warning messages. ", "Caption",
 CellID->29646],

Cell[TextData[{
 "Evaluating ",
 Cell[BoxData[
  RowBox[{"1", "^", "0"}]], "InlineFormula"],
 " produces no messages, so the result of the evaluation is returned. "
}], "MathCaption",
 CellID->14868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Check", "[", 
  RowBox[{
   RowBox[{"1", "^", "0"}], ",", "err"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->23614],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->73792500]
}, Open  ]],

Cell[TextData[{
 "Evaluating ",
 Cell[BoxData[
  RowBox[{"0", "^", "0"}]], "InlineFormula"],
 " produces a message, so the second argument of ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 " is returned. "
}], "MathCaption",
 CellID->28796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Check", "[", 
  RowBox[{
   RowBox[{"0", "^", "0"}], ",", "err"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->9726],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\^0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Power::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[15]:=",
 CellID->355356937],

Cell[BoxData["err"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->453464638]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["failexpr", "TI"]}], "]"}]], "InlineFormula"],
 " tests for all messages that are actually printed out. It does not test for \
messages whose output has been suppressed using ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2181],

Cell[TextData[{
 "In some cases you may want to test only for a specific set of messages, say \
ones associated with numerical overflow. You can do this by explicitly \
telling ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 " the names of the messages you want to look for. "
}], "Text",
 CellID->27829],

Cell[TextData[{
 "The message generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   RowBox[{"1", ",", "2"}], "]"}]], "InlineFormula"],
 " is ignored by ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 ", since it is not the one specified. "
}], "MathCaption",
 CellID->5256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Check", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", "err", ",", 
   RowBox[{"General", "::", "ind"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->4188],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[16]:=",
 CellID->432397137],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->269751893]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Message",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Message"], "[", 
     StyleBox["s", "TI"], "::", 
     StyleBox["tag", "TI"], "]"}], Cell["print a message", "TableText"]},
   {
    RowBox[{
     ButtonBox["Message",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Message"], "[", 
     StyleBox["s", "TI"], "::", 
     StyleBox["tag", "TI"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "print a message, with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " spliced into its string form"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20998],

Cell["Generating messages. ", "Caption",
 CellID->11915],

Cell[TextData[{
 "By using the function ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 ", you can mimic all aspects of the way in which built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions generate messages. You can for example switch on and off \
messages using ",
 Cell[BoxData[
  ButtonBox["On",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/On"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " will automatically look for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " if it does not find the specific message ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17499],

Cell[TextData[{
 "This defines the text of a message associated with ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "::", "overflow"}], "=", 
  "\"\<Factorial argument `1` too large.\>\""}]], "Input",
 CellLabel->"In[17]:=",
 CellID->6733],

Cell[BoxData["\<\"Factorial argument `1` too large.\"\>"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->56899842]
}, Open  ]],

Cell[TextData[{
 "Here is the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17629],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", ">", "10"}], ",", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"f", "::", "overflow"}], ",", "x"}], "]"}], ";", "Infinity"}],
      ")"}], ",", 
    RowBox[{"x", "!"}]}], "]"}]}]], "Input",
 CellLabel->"In[18]:=",
 CellID->32143],

Cell[TextData[{
 "When the argument of ",
 Cell[BoxData["f"], "InlineFormula"],
 " is greater than 10, the message is generated. "
}], "MathCaption",
 CellID->16916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "20", "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->21028],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "::", "\<\"overflow\"\>"}], ":", 
  " ", "\<\"Factorial argument \\!\\(20\\) too large.\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[19]:=",
 CellID->230232337],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->49926783]
}, Open  ]],

Cell["This switches off the message. ", "MathCaption",
 CellID->18424],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"f", "::", "overflow"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->29741],

Cell["Now the message is no longer generated. ", "MathCaption",
 CellID->10447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "20", "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->24347],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->6462102]
}, Open  ]],

Cell[TextData[{
 "When you call ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 ", it first tries to find a message with the explicit name you have \
specified. If this fails, it tries to find a message with the appropriate tag \
associated with the symbol ",
 Cell[BoxData[
  ButtonBox["General",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/General"]], "InlineFormula"],
 ". If this too fails, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes any function you have defined as the value of the global variable ",
 Cell[BoxData[
  ButtonBox["$NewMessage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewMessage"]], "InlineFormula"],
 ", and applies this function to the symbol and tag of the message you have \
requested. "
}], "Text",
 CellID->21081],

Cell[TextData[{
 "By setting up the value of ",
 Cell[BoxData[
  ButtonBox["$NewMessage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewMessage"]], "InlineFormula"],
 " appropriately, you can, for example, get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read in the text of a message from a file when that message is first \
needed. "
}], "Text",
 CellID->32382],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->192834825],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Messages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RequestingInput"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/InternationalMessages"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 27.8520450}", "context" -> "", 
    "keywords" -> {
     "::", "abends", "argx message", "calculations", "check", 
      "condition codes", "display", "double colon", "error messages", 
      "errors", "exceptions", "files", "functions", "General", 
      "general messages", "handling errors", "message", "MessageList", 
      "MessageName", "MessagePrePrint", "messages", "numerical overflow", 
      "off", "on", "output", "overflow", "printing", "Quiet", "stop message", 
      "StringForm", "text", "trapping errors", "verbosity", 
      "warning messages", "$NewMessage"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica has a general mechanism for handling messages generated \
during computations. Many built-in Mathematica functions use this mechanism \
to produce error and warning messages. You can also use the mechanism for \
messages associated with functions you write. The basic idea is that every \
message has a definite name, of the form symbol::tag. You can use this name \
to refer to the message. (The object symbol::tag has head MessageName.) \
Controlling the printing of messages. ", "synonyms" -> {"2.9.21"}, "title" -> 
    "Messages", "type" -> "Tutorial", "uri" -> "tutorial/Messages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.21"->{
  Cell[2477, 67, 73, 2, 70, "Title",
   CellTags->{"S2.9.21", "21.1"},
   CellID->12413]},
 "21.1"->{
  Cell[2477, 67, 73, 2, 70, "Title",
   CellTags->{"S2.9.21", "21.1"},
   CellID->12413]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.21", 41579, 1420},
 {"21.1", 41681, 1424}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1852, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2477, 67, 73, 2, 70, "Title",
 CellTags->{"S2.9.21", "21.1"},
 CellID->12413],
Cell[2553, 71, 406, 11, 70, "Text",
 CellID->17781],
Cell[2962, 84, 549, 18, 70, "Text",
 CellID->28451],
Cell[3514, 104, 1839, 60, 70, "DefinitionBox",
 CellID->3469],
Cell[5356, 166, 72, 1, 70, "Caption",
 CellID->8286],
Cell[5431, 169, 653, 19, 70, "Text",
 CellID->107541266],
Cell[6087, 190, 140, 4, 70, "MathCaption",
 CellID->63228177],
Cell[CellGroupData[{
Cell[6252, 198, 131, 4, 70, "Input",
 CellID->32853303],
Cell[6386, 204, 457, 9, 19, "Message",
 CellID->262903226],
Cell[6846, 215, 220, 7, 36, "Output",
 CellID->359101457]
}, Open  ]],
Cell[7081, 225, 78, 1, 70, "MathCaption",
 CellID->8329726],
Cell[CellGroupData[{
Cell[7184, 230, 165, 5, 70, "Input",
 CellID->141563161],
Cell[7352, 237, 220, 7, 36, "Output",
 CellID->296107062]
}, Open  ]],
Cell[7587, 247, 90, 1, 70, "MathCaption",
 CellID->31040319],
Cell[CellGroupData[{
Cell[7702, 252, 132, 4, 70, "Input",
 CellID->214523063],
Cell[7837, 258, 455, 9, 70, "Message",
 CellID->3559266],
Cell[8295, 269, 220, 7, 36, "Output",
 CellID->465294102]
}, Open  ]],
Cell[8530, 279, 535, 19, 70, "Text",
 CellID->7277],
Cell[9068, 300, 81, 1, 70, "MathCaption",
 CellID->26658],
Cell[9152, 303, 124, 4, 70, "Input",
 CellID->14799],
Cell[9279, 309, 75, 1, 70, "MathCaption",
 CellID->15961],
Cell[CellGroupData[{
Cell[9379, 314, 127, 4, 70, "Input",
 CellID->8380],
Cell[9509, 320, 219, 7, 36, "Output",
 CellID->15725380]
}, Open  ]],
Cell[9743, 330, 663, 16, 70, "Text",
 CellID->28584],
Cell[10409, 348, 968, 30, 70, "DefinitionBox",
 CellID->30538],
Cell[11380, 380, 57, 1, 70, "Caption",
 CellID->8113],
Cell[11440, 383, 767, 26, 70, "Text",
 CellID->11656],
Cell[12210, 411, 245, 8, 70, "MathCaption",
 CellID->24593],
Cell[CellGroupData[{
Cell[12480, 423, 329, 12, 70, "Input",
 CellID->8373],
Cell[12812, 437, 432, 8, 70, "Message",
 CellID->148282610],
Cell[13247, 447, 423, 15, 36, "Output",
 CellID->466199132]
}, Open  ]],
Cell[13685, 465, 72, 1, 70, "MathCaption",
 CellID->24252],
Cell[CellGroupData[{
Cell[13782, 470, 102, 3, 70, "Input",
 CellID->7253],
Cell[13887, 475, 217, 6, 36, "Output",
 CellID->319684732]
}, Open  ]],
Cell[14119, 484, 67, 1, 70, "MathCaption",
 CellID->12623],
Cell[CellGroupData[{
Cell[14211, 489, 173, 5, 70, "Input",
 CellID->16100],
Cell[14387, 496, 203, 5, 36, "Output",
 CellID->462075064]
}, Open  ]],
Cell[14605, 504, 70, 1, 70, "MathCaption",
 CellID->20600],
Cell[CellGroupData[{
Cell[14700, 509, 330, 12, 70, "Input",
 CellID->28366],
Cell[15033, 523, 420, 8, 70, "Message",
 CellID->152532978],
Cell[15456, 533, 423, 15, 36, "Output",
 CellID->102648339]
}, Open  ]],
Cell[15894, 551, 1548, 46, 70, "Text",
 CellID->6164],
Cell[17445, 599, 261, 6, 70, "Text",
 CellID->7303],
Cell[17709, 607, 1494, 49, 70, "Text",
 CellID->16281],
Cell[19206, 658, 197, 6, 70, "MathCaption",
 CellID->23952],
Cell[CellGroupData[{
Cell[19428, 668, 120, 4, 70, "Input",
 CellID->25809],
Cell[19551, 674, 436, 9, 70, "Message",
 CellID->327478920],
Cell[19990, 685, 212, 7, 36, "Output",
 CellID->105999746]
}, Open  ]],
Cell[20217, 695, 127, 4, 70, "MathCaption",
 CellID->1482],
Cell[CellGroupData[{
Cell[20369, 703, 99, 3, 70, "Input",
 CellID->20089],
Cell[20471, 708, 223, 6, 36, "Output",
 CellID->775695851]
}, Open  ]],
Cell[20709, 717, 1044, 28, 70, "Text",
 CellID->21704],
Cell[21756, 747, 1065, 32, 70, "DefinitionBox",
 CellID->22869],
Cell[22824, 781, 105, 3, 70, "Caption",
 CellID->17940],
Cell[22932, 786, 1076, 34, 70, "Text",
 CellID->21136],
Cell[24011, 822, 246, 8, 70, "MathCaption",
 CellID->12065],
Cell[CellGroupData[{
Cell[24282, 834, 229, 7, 70, "Input",
 CellID->25805],
Cell[24514, 843, 436, 9, 70, "Message",
 CellID->464177185],
Cell[24953, 854, 433, 9, 70, "Message",
 CellID->240016788],
Cell[25389, 865, 336, 13, 36, "Output",
 CellID->260089778]
}, Open  ]],
Cell[25740, 881, 242, 8, 70, "MathCaption",
 CellID->29955],
Cell[CellGroupData[{
Cell[26007, 893, 100, 3, 70, "Input",
 CellID->625],
Cell[26110, 898, 202, 5, 50, "Output",
 CellID->6682140]
}, Open  ]],
Cell[26327, 906, 341, 6, 70, "Text",
 CellID->17156],
Cell[26671, 914, 1861, 57, 70, "DefinitionBox",
 CellID->27388],
Cell[28535, 973, 66, 1, 70, "Caption",
 CellID->29646],
Cell[28604, 976, 199, 6, 70, "MathCaption",
 CellID->14868],
Cell[CellGroupData[{
Cell[28828, 986, 147, 5, 70, "Input",
 CellID->23614],
Cell[28978, 993, 158, 5, 36, "Output",
 CellID->73792500]
}, Open  ]],
Cell[29151, 1001, 310, 11, 70, "MathCaption",
 CellID->28796],
Cell[CellGroupData[{
Cell[29486, 1016, 146, 5, 70, "Input",
 CellID->9726],
Cell[29635, 1023, 420, 8, 70, "Message",
 CellID->355356937],
Cell[30058, 1033, 161, 5, 36, "Output",
 CellID->453464638]
}, Open  ]],
Cell[30234, 1041, 508, 17, 70, "Text",
 CellID->2181],
Cell[30745, 1060, 373, 10, 70, "Text",
 CellID->27829],
Cell[31121, 1072, 417, 15, 70, "MathCaption",
 CellID->5256],
Cell[CellGroupData[{
Cell[31563, 1091, 221, 7, 70, "Input",
 CellID->4188],
Cell[31787, 1100, 433, 9, 70, "Message",
 CellID->432397137],
Cell[32223, 1111, 211, 7, 36, "Output",
 CellID->269751893]
}, Open  ]],
Cell[32449, 1121, 1075, 33, 70, "DefinitionBox",
 CellID->20998],
Cell[33527, 1156, 56, 1, 70, "Caption",
 CellID->11915],
Cell[33586, 1159, 1107, 39, 70, "Text",
 CellID->17499],
Cell[34696, 1200, 150, 5, 70, "MathCaption",
 CellID->12222],
Cell[CellGroupData[{
Cell[34871, 1209, 162, 5, 70, "Input",
 CellID->6733],
Cell[35036, 1216, 199, 5, 36, "Output",
 CellID->56899842]
}, Open  ]],
Cell[35250, 1224, 120, 5, 70, "MathCaption",
 CellID->17629],
Cell[35373, 1231, 395, 14, 70, "Input",
 CellID->32143],
Cell[35771, 1247, 165, 5, 70, "MathCaption",
 CellID->16916],
Cell[CellGroupData[{
Cell[35961, 1256, 95, 3, 70, "Input",
 CellID->21028],
Cell[36059, 1261, 220, 6, 70, "Message",
 CellID->230232337],
Cell[36282, 1269, 168, 5, 36, "Output",
 CellID->49926783]
}, Open  ]],
Cell[36465, 1277, 70, 1, 70, "MathCaption",
 CellID->18424],
Cell[36538, 1280, 127, 4, 70, "Input",
 CellID->29741],
Cell[36668, 1286, 79, 1, 70, "MathCaption",
 CellID->10447],
Cell[CellGroupData[{
Cell[36772, 1291, 95, 3, 70, "Input",
 CellID->24347],
Cell[36870, 1296, 167, 5, 36, "Output",
 CellID->6462102]
}, Open  ]],
Cell[37052, 1304, 851, 24, 70, "Text",
 CellID->21081],
Cell[37906, 1330, 383, 12, 70, "Text",
 CellID->32382],
Cell[CellGroupData[{
Cell[38314, 1346, 72, 1, 70, "RelatedTutorialsSection",
 CellID->192834825],
Cell[38389, 1349, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[38594, 1357, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

