(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39258,       1378]
NotebookOptionsPosition[     32171,       1141]
NotebookOutlinePosition[     34877,       1211]
CellTagsIndexPosition[     34782,       1205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Equations and Inequalities\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Maximize" :> Documentation`HelpLookup["paclet:ref/Maximize"], 
          "Minimize" :> Documentation`HelpLookup["paclet:ref/Minimize"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Maximize\"\>", 
       2->"\<\"Minimize\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Minimization and Maximization", "Title",
 CellTags->{"S3.4.12", "12.1"},
 CellID->2489],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Minimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minimize"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "minimize ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Minimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Minimize"], "[", "{", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["cons", "TI"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "minimize ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " subject to the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Maximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Maximize"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "maximize ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Maximize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Maximize"], "[", "{", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["cons", "TI"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "maximize ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " subject to the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2105],

Cell["Minimization and maximization. ", "Caption",
 CellID->32403],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " yield lists giving the value attained at the minimum or maximum, together \
with rules specifying where the minimum or maximum occurs. "
}], "Text",
 CellID->3749],

Cell["This finds the minimum of a quadratic function. ", "MathCaption",
 CellID->27390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"3", "x"}], "+", "6"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->15991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["15", "4"], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["3", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{96, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->8168]
}, Open  ]],

Cell[TextData[{
 "Applying the rule for ",
 Cell[BoxData["x"], "InlineFormula"],
 " gives the value at the minimum. "
}], "MathCaption",
 CellID->26545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "-", 
   RowBox[{"3", "x"}], "+", "6"}], "/.", 
  RowBox[{"Last", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->3317],

Cell[BoxData[
 FractionBox["15", "4"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->9345]
}, Open  ]],

Cell[TextData[{
 "This maximizes with respect to ",
 Cell[BoxData["x"], "InlineFormula"],
 " and\[NonBreakingSpace]",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"5", " ", "x", " ", "y"}], "-", 
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"y", "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->7270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["25", "8"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["5"], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["5"], "2"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{190, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->5538]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " minimizes ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " allowing ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " to range over all possible values from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["cons", "TI"]}], "}"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " minimizes ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " subject to the constraints ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " being satisfied. The constraints can consist of any combination of \
equations and inequalities. "
}], "Text",
 CellID->27986],

Cell[TextData[{
 "This finds the minimum subject to the constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[GreaterEqual]", "3"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->1925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", "x"}], "+", "6"}], ",", 
     RowBox[{"x", ">=", "3"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->27182]
}, Open  ]],

Cell["This finds the maximum within the unit circle. ", "MathCaption",
 CellID->9095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", " ", "x", " ", "y"}], "-", 
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"y", "^", "4"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->30628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->16255]
}, Open  ]],

Cell["\<\
This finds the maximum within an ellipse. The result is fairly complicated. \
\>", "MathCaption",
 CellID->3396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", " ", "x", " ", "y"}], "-", 
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"y", "^", "4"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}]}], "<=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->7720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "811219"}], "+", 
        RowBox[{"320160", " ", "#1"}], "+", 
        RowBox[{"274624", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"170240", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"25600", " ", 
         SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"25", "-", 
          RowBox[{"102", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"122", " ", 
           SuperscriptBox["#1", "4"]}], "-", 
          RowBox[{"70", " ", 
           SuperscriptBox["#1", "6"]}], "+", 
          RowBox[{"50", " ", 
           SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"25", "-", 
          RowBox[{"264", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"848", " ", 
           SuperscriptBox["#1", "4"]}], "-", 
          RowBox[{"1040", " ", 
           SuperscriptBox["#1", "6"]}], "+", 
          RowBox[{"800", " ", 
           SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{453, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->32341]
}, Open  ]],

Cell["This finds the maximum along a line. ", "MathCaption",
 CellID->24813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", " ", "x", " ", "y"}], "-", 
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"y", "^", "4"}]}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->15546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["9", "8"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->14278]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " can solve any ",
 StyleBox["linear programming",
  FontSlant->"Italic"],
 " problem in which both the objective function ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " and the constraints ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " involve the variables ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " only linearly."
}], "Text",
 CellID->4027],

Cell["Here is a typical linear programming problem. ", "MathCaption",
 CellID->3903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"3", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "-", 
        RowBox[{"3", " ", "y"}]}], "<=", "7"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], ">=", "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->4724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["53", "5"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["44", "5"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["3", "5"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{148, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->31686]
}, Open  ]],

Cell[TextData[{
 "They can also in principle solve any ",
 StyleBox["polynomial programming",
  FontSlant->"Italic"],
 " problem in which the objective function and the constraints involve \
arbitrary polynomial functions of the variables. There are many important \
geometrical and other problems that can be formulated in this way. "
}], "Text",
 CellID->15986],

Cell["\<\
This solves the simple geometrical problem of maximizing the area of a \
rectangle with fixed perimeter. \
\>", "MathCaption",
 CellID->13365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "y"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->11397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "4"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->15868]
}, Open  ]],

Cell["\<\
This finds the maximal volume of a cuboid that fits inside the unit sphere. \
\>", "MathCaption",
 CellID->17616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"8", " ", "x", " ", "y", " ", "z"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "<=", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->16218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["8", 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["3"]]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["3"]]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["3"]]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{272, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->8344]
}, Open  ]],

Cell[TextData[{
 "An important feature of ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " is that they always find ",
 StyleBox["global",
  FontSlant->"Italic"],
 " minima and maxima. Often functions will have various local minima and \
maxima at which derivatives vanish. But ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " use global methods to find absolute minima or maxima, not just local \
extrema. "
}], "Text",
 CellID->20604],

Cell["Here is a function with many local maxima and minima. ", "MathCaption",
 CellID->13163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->10879],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1mDlQHEcUhgd2V6yQDMiHiirrWE4hcYjDkvFZOLFIbCNbkrFdZUOpXIUC
25SsQBkhISEhmQlJVEVISKiQkFAhIeH4e+/1bM80zRjWNlXMdve8/t/f7+ru
+Wr5xcqvvy2/ePZ0ufHg+fLqyrOnfza+/OM5Q5W2JEle8f97b0I7paX/r9KU
3/zza54VXrXz287vLzr6jTyrMkP/3Puk4kcqQf+Jir2jo7u7uy9fvpybm0va
5VFZX18/ODiQV+M8BLbSIn6PPGtHR0cbGxuNRmN+fh7spLK3t5dUUTkyMsLQ
4eHhzJnwpWu4XYp7fHwMHLirq6uAJB3ZasDd3t5Opltk/ZbOMxxYQr9T5dC3
uLgoK5hqEfmSzoPrwsKCrVxXUkHL2tqaNCecXyvu90IU56Li4KSlpSXWv7Oz
c0XloMfCpflxdF5dRzE/K9va2nL+Z134fX9/X2eJ1u9V+qa+heTs7OybN2+S
j6KYDR2FAmuS5mxUqk9HoYtaaX5YIgUfFiUa41L9mZ8xoTTvF1gPBJa4F8Uw
KXSgCX2nSA3qKMFLhEnzgxIpUCYnJ/GJSnk+Q4F9ZqIYwzqKCILSnC6RQgea
hHVc6paOQhni0pwqkfK2niqwHtG3m5ubKysr0pyMYtzWUci8fv1amndLpIgv
4kiasorKqbF9J/DfSCAVz6w7mT+JbBJWo1IStBqZ7evIaLDKW2fSNaajLIYl
SXMwLctVk8ZATBCfDQZSteis8dTVBcpNXkeZtM/jXulX6e9lf90F706kLrNx
nVjrXZWnRXZCs16vV3QnYAKOgHtyOarX/A080tLUKiR1mWpGWJHuwkY5V3En
2ohKXndG0SzGoMA8aXZn84ACEHpa9yQf0Se8L0ZxpgIc5V61+GM5BMnlLCId
Tj2KM53hICUZYlUXqwFi3u/OfOtwOgpWtl0N6xh/IMwSVC6r2yzt7RwTiY54
DGnd6TS79vb2IguA7dn4ijIIyfcy27haFY+UjrR4fhjM9ZMaXEEi5GgIG42j
XFUKsymbPRSgat6YVUt3yTAXrmkfS5LFYvFQX5ifA1ENcphqk18bMjL61+RW
yur91GpHaMHrQbRne3RYoc7C6vy2uaF9ChXlSpqhfCu2+WcW/W6NfYFnQrkh
Jzf8n2nN91V7rZnRzqHhiofOoDvL0Mx3w+5XNVZ9TTevZhmSn2HhtJi6zKem
qTeaWf+DvrHdV1gu5kaxHPJ+9MfU5ayRdghSZ/7K4u9EbQorRBilYf+88i3P
d+ebf6v//+abq0250a6gfzXo3zgNleJLPT8hH+INR1n8lLqIbR4PHhfH+bVI
8uMSaflz2yM/o9bEZ2dhk8q/u9B8xx8FjDL2nX/bkX/rzyrfeokcd8tWfzZ5
WOBmZyZ/Gn4YxTApr2khKmX1HzUoa3qlA+rsg3P6R9DxWm5/01EE85PfwXS/
lRMKNrWdFKikXW6kNUTQg1kRF8tOliCCAHM5GemZp0pRtosoE+0eChq1kqed
kpr2sbcwRrfYRyOlancyqjvz7XRErYWH3NImojyaOPAQ+vm7pUFbDPo711gU
x6ox2phkt11FLr1djkaRlPel5pWctGAxjMHOjmyn3DrjaLqeun07IMlwFu+Y
ATKAV7PVuxPsnYKN7VxvSSDN21ENo8GqdB9PJCsqkd1/NPOK2wFN+kk0N3x/
LIsFVx1vnWmWneettKRZ9YjOku54ZguYSS6Z9KM0fmPQLwwEvZc6mXFF6Xy1
0T02eeywQ+m7wWoHo3a3c77VIGkOFHxnp3dfGQaiGCbl77j9JVK26wr7uJSd
8/3Jua/AZyazgMv3vijGTLDyRlTKvh/4anSzRMpbIC51z/nRvxW29zO2rvre
iM41KX+SvR6Vsq8vvs5fK5Hy9olL2Veh4MYps/Jx11yFfb3yX3iuZNL2HdH2
+BM6bJa/zdv90eqwVWabJ19L87eVMEM+0T6mdTh2f8Satt+wCK2ZtmeVnmPD
/qcZQ9ZVuFFSaSGJQzpbRP5MZ9g3S4yEie2uCaRVcQrv5XNgS/dz6XQChfF6
enrwL7FAGzPY1glmV4t8v5BHjepPbMEXmmKPnhbRnjT9mj+p/6yjJ7+hJ21/
A/ZFmHM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->167169623]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " finds the global maximum. "
}], "MathCaption",
 CellID->19372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "<=", "x", "<=", "10"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->26843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["3"], "+", 
    FractionBox[
     RowBox[{"8", " ", "\[Pi]"}], "3"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{"8", " ", "\[Pi]"}], "3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{147, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->8807]
}, Open  ]],

Cell[TextData[{
 "If you give functions that are unbounded, ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " will return ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " as the minima and maxima. And if you give constraints that can never be \
satisfied, they will return ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " as the minima and maxima, and ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " as the values of variables."
}], "Text",
 CellID->26217],

Cell[TextData[{
 "One subtle issue is that ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " allow both ",
 StyleBox["non\[Hyphen]strict",
  FontSlant->"Italic"],
 " inequalities of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<=", "v"}], TraditionalForm]], "InlineMath"],
 ", and ",
 StyleBox["strict",
  FontSlant->"Italic"],
 " ones of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "v"}], TraditionalForm]], "InlineMath"],
 ". With non\[Hyphen]strict inequalities there is no problem with a minimum \
or maximum lying exactly on the boundary ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "->", "v"}], TraditionalForm]], "InlineMath"],
 ". But with strict inequalities, a minimum or maximum must in principle be \
at least infinitesimally inside the boundary. "
}], "Text",
 CellID->7326],

Cell[TextData[{
 "With a strict inequality, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a warning, then returns the point on the boundary. "
}], "MathCaption",
 CellID->14017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", "x"}], "+", "6"}], ",", 
     RowBox[{"x", ">", "3"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->10180],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
contraints; returning a result on the boundary.\"\>"}]], "Message", "MSG",
 CellID->30057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->19869]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " normally assume that all variables you give are real. But by giving a \
constraint such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 " you can specify that a variable must in fact be an integer. "
}], "Text",
 CellID->22536],

Cell[TextData[{
 "This does maximization only over integer values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "120"}], "&&", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "|", "y"}], ")"}], " ", "\[Element]", " ", 
       "Integers"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->3700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"56", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "8"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "7"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->15622]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " can compute maxima and minima of linear functions over the integers in \
bounded polyhedra. This is known as integer linear programming."
}], "Text",
 CellID->347789995],

Cell[TextData[{
 "This does maximization over integer values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " in a triangle."
}], "MathCaption",
 CellID->522494580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "+", 
      RowBox[{"3", "y"}], "+", 
      RowBox[{"7", "x"}]}], ",", 
     RowBox[{
      RowBox[{"x", ">=", "0"}], "&&", 
      RowBox[{"y", ">=", "0"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"3", "x"}], "+", 
        RowBox[{"4", "y"}]}], "<=", "100"}], "&&", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "|", "y"}], ")"}], " ", "\[Element]", " ", 
       "Integers"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5980280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"236", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "33"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->287518667]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " can produce exact symbolic results for polynomial optimization problems \
with parameters."
}], "Text",
 CellID->449775137],

Cell["This finds the minimum of a general quadratic polynomial.", \
"MathCaption",
 CellID->756639818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "c"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->498115958],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{372, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->267478595]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->485328500],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Minimization and Maximization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Quantifiers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 28.4145594}", "context" -> "", 
    "keywords" -> {
     "constrained optimization", "cost function", "extremization", 
      "global minimization", "goal functions", "inequalities", 
      "infeasible constraints", "linear programming", 
      "LP (linear programming)", "maximize", "Maximize", "minimization", 
      "minimize", "Minimize", "objective functions", "operations research", 
      "optimization", "payoff functions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Minimization and maximization. Minimize and Maximize yield lists giving \
the value attained at the minimum or maximum, together with rules specifying \
where the minimum or maximum occurs. This finds the minimum of a quadratic \
function. ", "synonyms" -> {"3.4.12"}, "title" -> 
    "Minimization and Maximization", "type" -> "Tutorial", "uri" -> 
    "tutorial/MinimizationAndMaximization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.12"->{
  Cell[1953, 60, 93, 2, 70, "Title",
   CellTags->{"S3.4.12", "12.1"},
   CellID->2489]},
 "12.1"->{
  Cell[1953, 60, 93, 2, 70, "Title",
   CellTags->{"S3.4.12", "12.1"},
   CellID->2489]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.12", 34568, 1194},
 {"12.1", 34669, 1198}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1328, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1953, 60, 93, 2, 70, "Title",
 CellTags->{"S3.4.12", "12.1"},
 CellID->2489],
Cell[2049, 64, 2446, 77, 70, "DefinitionBox",
 CellID->2105],
Cell[4498, 143, 66, 1, 70, "Caption",
 CellID->32403],
Cell[4567, 146, 430, 13, 70, "Text",
 CellID->3749],
Cell[5000, 161, 87, 1, 70, "MathCaption",
 CellID->27390],
Cell[CellGroupData[{
Cell[5112, 166, 203, 7, 28, "Input",
 CellID->15991],
Cell[5318, 175, 301, 11, 51, "Output",
 CellID->8168]
}, Open  ]],
Cell[5634, 189, 152, 5, 70, "MathCaption",
 CellID->26545],
Cell[CellGroupData[{
Cell[5811, 198, 196, 7, 28, "Input",
 CellID->3317],
Cell[6010, 207, 175, 6, 51, "Output",
 CellID->9345]
}, Open  ]],
Cell[6200, 216, 195, 7, 70, "MathCaption",
 CellID->4167],
Cell[CellGroupData[{
Cell[6420, 227, 291, 10, 70, "Input",
 CellID->7270],
Cell[6714, 239, 468, 18, 56, "Output",
 CellID->5538]
}, Open  ]],
Cell[7197, 260, 1226, 44, 70, "Text",
 CellID->27986],
Cell[8426, 306, 211, 7, 70, "MathCaption",
 CellID->1925],
Cell[CellGroupData[{
Cell[8662, 317, 285, 10, 70, "Input",
 CellID->21202],
Cell[8950, 329, 255, 9, 36, "Output",
 CellID->27182]
}, Open  ]],
Cell[9220, 341, 85, 1, 70, "MathCaption",
 CellID->9095],
Cell[CellGroupData[{
Cell[9330, 346, 459, 16, 70, "Input",
 CellID->30628],
Cell[9792, 364, 446, 17, 55, "Output",
 CellID->16255]
}, Open  ]],
Cell[10253, 384, 122, 3, 70, "MathCaption",
 CellID->3396],
Cell[CellGroupData[{
Cell[10400, 391, 482, 17, 70, "Input",
 CellID->7720],
Cell[10885, 410, 1569, 49, 77, "Output",
 CellID->32341]
}, Open  ]],
Cell[12469, 462, 76, 1, 70, "MathCaption",
 CellID->24813],
Cell[CellGroupData[{
Cell[12570, 467, 403, 14, 70, "Input",
 CellID->15546],
Cell[12976, 483, 386, 14, 51, "Output",
 CellID->14278]
}, Open  ]],
Cell[13377, 500, 697, 25, 70, "Text",
 CellID->4027],
Cell[14077, 527, 84, 1, 70, "MathCaption",
 CellID->3903],
Cell[CellGroupData[{
Cell[14186, 532, 467, 17, 70, "Input",
 CellID->4724],
Cell[14656, 551, 388, 14, 51, "Output",
 CellID->31686]
}, Open  ]],
Cell[15059, 568, 363, 8, 70, "Text",
 CellID->15986],
Cell[15425, 578, 152, 4, 70, "MathCaption",
 CellID->13365],
Cell[CellGroupData[{
Cell[15602, 586, 302, 11, 70, "Input",
 CellID->11397],
Cell[15907, 599, 386, 14, 51, "Output",
 CellID->15868]
}, Open  ]],
Cell[16308, 616, 123, 3, 70, "MathCaption",
 CellID->17616],
Cell[CellGroupData[{
Cell[16456, 623, 427, 14, 70, "Input",
 CellID->16218],
Cell[16886, 639, 592, 23, 55, "Output",
 CellID->8344]
}, Open  ]],
Cell[17493, 665, 846, 28, 70, "Text",
 CellID->20604],
Cell[18342, 695, 93, 1, 70, "MathCaption",
 CellID->13163],
Cell[CellGroupData[{
Cell[18460, 700, 285, 10, 28, "Input",
 CellID->10879],
Cell[18748, 712, 2358, 43, 131, "Output",
 Evaluatable->False,
 CellID->167169623]
}, Open  ]],
Cell[21121, 758, 200, 7, 70, "MathCaption",
 CellID->19372],
Cell[CellGroupData[{
Cell[21346, 769, 327, 12, 70, "Input",
 CellID->26843],
Cell[21676, 783, 402, 15, 51, "Output",
 CellID->8807]
}, Open  ]],
Cell[22093, 801, 1053, 35, 70, "Text",
 CellID->26217],
Cell[23149, 838, 1016, 33, 70, "Text",
 CellID->7326],
Cell[24168, 873, 193, 6, 70, "MathCaption",
 CellID->14017],
Cell[CellGroupData[{
Cell[24386, 883, 285, 10, 70, "Input",
 CellID->10180],
Cell[24674, 895, 241, 5, 70, "Message",
 CellID->30057],
Cell[24918, 902, 256, 9, 36, "Output",
 CellID->19869]
}, Open  ]],
Cell[25189, 914, 627, 20, 70, "Text",
 CellID->22536],
Cell[25819, 936, 198, 7, 70, "MathCaption",
 CellID->15458],
Cell[CellGroupData[{
Cell[26042, 947, 508, 18, 70, "Input",
 CellID->3700],
Cell[26553, 967, 360, 13, 36, "Output",
 CellID->15622]
}, Open  ]],
Cell[26928, 983, 436, 13, 70, "Text",
 CellID->347789995],
Cell[27367, 998, 210, 7, 70, "MathCaption",
 CellID->522494580],
Cell[CellGroupData[{
Cell[27602, 1009, 632, 22, 70, "Input",
 CellID->5980280],
Cell[28237, 1033, 320, 11, 36, "Output",
 CellID->287518667]
}, Open  ]],
Cell[28572, 1047, 390, 13, 70, "Text",
 CellID->449775137],
Cell[28965, 1062, 102, 2, 70, "MathCaption",
 CellID->756639818],
Cell[CellGroupData[{
Cell[29092, 1068, 237, 8, 28, "Input",
 CellID->498115958],
Cell[29332, 1078, 2465, 44, 133, "Output",
 Evaluatable->False,
 CellID->267478595]
}, Open  ]],
Cell[CellGroupData[{
Cell[31834, 1127, 72, 1, 70, "RelatedTutorialsSection",
 CellID->485328500],
Cell[31909, 1130, 208, 5, 70, "RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],
Cell[32144, 1139, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

