(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17680,        426]
NotebookOptionsPosition[     14022,        324]
NotebookOutlinePosition[     16875,        397]
CellTagsIndexPosition[     16781,        391]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mixing Text and Formulas", "Title",
 CellTags->{"S1.10.10", "10.1"},
 CellID->7274],

Cell[TextData[{
 "The simplest way to mix text and formulas in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook is to put each kind of material in a separate cell. Sometimes, \
however, you may want to embed a formula within a cell of text, or vice \
versa."
}], "Text",
 CellID->28835],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["(", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["9", "KeyEvent"]
    }], "TableText"], Cell["\<\
begin entering a formula within text, or text within a formula\
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox[")", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["0", "KeyEvent"]
    }], "TableText"], Cell[
    "end entering a formula within text, or text within a formula", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16828],

Cell["Entering a formula within text, or vice versa. ", "Caption",
 CellID->13914],

Cell["Here is a notebook with formulas embedded in a text cell.", \
"MathCaption",
 CellID->27958],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 104},
 ImageMargins->0,
 CellID->585212962],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks often contain both formulas that are intended for actual \
evaluation by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and ones that are intended just to be read in a more passive way. "
}], "Text",
 CellID->22427],

Cell[TextData[{
 "When you insert a formula in text, you can use the ",
 StyleBox["Convert to StandardForm", "MenuName"],
 " and ",
 StyleBox["Convert to TraditionalForm", "MenuName"],
 " menu items within the formula to convert it to ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is normally appropriate whenever the formula is thought of as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program fragment."
}], "Text",
 CellID->8592],

Cell[TextData[{
 "In general, however, you can use exactly the same mechanisms for entering \
formulas, whether or not they will ultimately be given as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Text",
 CellID->3921],

Cell[TextData[{
 "You should realize, however, that to make the detailed typography of \
typical formulas look as good as possible, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically does things such as inserting spaces around certain \
operators. But these kinds of adjustments can potentially be inappropriate if \
you use notation in very different ways from the ones ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is expecting. In such cases, you may have to make detailed typographical \
adjustments by hand."
}], "Text",
 CellID->5340],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->137270646],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mixing Text and Formulas - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OtherMathematicalNotation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 29.6645914}", "context" -> "", 
    "keywords" -> {
     "embedded formulas", "equations in text", "formulas", "inline code", 
      "inline formulas", "inline text", "mixing text and formulas", 
      "program fragments", "text"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The simplest way to mix text and formulas in a Mathematica notebook is \
to put each kind of material in a separate cell. Sometimes, however, you may \
want to embed a formula within a cell of text, or vice versa. Entering a \
formula within text, or vice versa. Here is a notebook with formulas embedded \
in a text cell.", "synonyms" -> {"1.10.10"}, "title" -> 
    "Mixing Text and Formulas", "type" -> "Tutorial", "uri" -> 
    "tutorial/MixingTextAndFormulas"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.10"->{
  Cell[1286, 44, 89, 2, 70, "Title",
   CellTags->{"S1.10.10", "10.1"},
   CellID->7274]},
 "10.1"->{
  Cell[1286, 44, 89, 2, 70, "Title",
   CellTags->{"S1.10.10", "10.1"},
   CellID->7274]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.10", 16565, 380},
 {"10.1", 16667, 384}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 89, 2, 70, "Title",
 CellTags->{"S1.10.10", "10.1"},
 CellID->7274],
Cell[1378, 48, 303, 8, 70, "Text",
 CellID->28835],
Cell[1684, 58, 1064, 31, 70, "DefinitionBox",
 CellID->16828],
Cell[2751, 91, 82, 1, 70, "Caption",
 CellID->13914],
Cell[2836, 94, 98, 2, 70, "MathCaption",
 CellID->27958],
Cell[2937, 98, 8813, 147, 70, "Picture",
 CellID->585212962],
Cell[11753, 247, 302, 9, 70, "Text",
 CellID->22427],
Cell[12058, 258, 808, 25, 70, "Text",
 CellID->8592],
Cell[12869, 285, 242, 7, 70, "Text",
 CellID->3921],
Cell[13114, 294, 567, 13, 70, "Text",
 CellID->5340],
Cell[CellGroupData[{
Cell[13706, 311, 72, 1, 70, "RelatedTutorialsSection",
 CellID->137270646],
Cell[13781, 314, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[13995, 322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

