(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    198090,       4547]
NotebookOptionsPosition[    161741,       3399]
NotebookOutlinePosition[    182141,       4016]
CellTagsIndexPosition[    181714,       3997]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Monitoring",
 StyleBox[" MathLM",
  FontSlant->"Italic"]
}], "Title",
 CellID->450596779],

Cell[CellGroupData[{

Cell[TextData[{
 "What is ",
 StyleBox["MonitorLM",
  FontSlant->"Italic"],
 "?"
}], "Section",
 CellTags->{"i:5", "b:2.1.2", "net: 1"},
 CellID->2472981],

Cell[TextData[{
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " gives information on the total number of licenses available and checked \
out, the fully qualified domain name and username of those who have them \
checked out, and so on. ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " can send output to the terminal, open a web browser, or write to a file. \
The output for ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " is customizable by means of a configuration file."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->201319271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Starting ",
 StyleBox["MonitorLM",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"b:2.1.2", "i:5b", "net: 2"},
 CellID->8995171],

Cell[TextData[{
 "To start ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 ", change directory to the location in which ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is installed, and type ",
 StyleBox[".\\monitorlm ", "InlineCode"],
 StyleBox["servername", "TI"],
 " (on Windows) or ",
 StyleBox["./monitorlm ", "InlineCode"],
 StyleBox["servername", "TI"],
 " (on Unix, Linux, or Mac OS X). The first argument of the ",
 StyleBox["monitorlm", "InlineCode"],
 " command specifies the name of the license server running ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ". If you do not specify a server name explicitly, the local machine name is \
chosen as the default."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->396740147]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MonitorLM",
  FontSlant->"Italic"],
 " Command-Line Options"
}], "Section",
 CellTags->{"i:6", "b:2.1.2", "net: 3"},
 CellID->849015738],

Cell[TextData[{
 "The following options are available using the ",
 StyleBox["monitorlm", "InlineCode"],
 " command. The syntax for specifying an option is ",
 StyleBox["monitorlm", "InlineCode"],
 " ",
 StyleBox["servername", "TI"],
 " ",
 StyleBox["options", "TI"],
 "."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->95664982],

Cell[TextData[{
 StyleBox["-file ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->216414686],

Cell[TextData[{
 "Specifies the file to which output should be directed. If this option is \
not set, ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " will write to ",
 StyleBox["stdout", "InlineCode"],
 ". The format of the output is determined by the ",
 StyleBox["-format", "InlineCode"],
 " option."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->329816948],

Cell[TextData[{
 StyleBox["-format ", "InlineCode"],
 StyleBox["f", "TI"]
}], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->314923500],

Cell[TextData[{
 "Specifies the format for the output of ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 ". The possible values follow."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->794342334],

Cell[TextData[{
 StyleBox["text", "InlineCode"],
 "\[LongDash]Sends output in text format to ",
 StyleBox["stdout", "InlineCode"],
 ". This is the default for Unix and Linux."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->615761780],

Cell[TextData[{
 StyleBox["html", "InlineCode"],
 "\[LongDash]Sends output in HTML format to a temporary file and launches a \
web browser to display the file. This is the default for Windows and Mac OS \
X."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->247028905],

Cell[TextData[{
 StyleBox["cgi", "InlineCode"],
 "\[LongDash]Sends output in HTML format to ",
 StyleBox["stdout", "InlineCode"],
 ". This is used when ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " is launched directly by a web browser."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->43001631],

Cell[TextData[StyleBox["-localtime", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->433519869],

Cell["\<\
Specifies that all references to time should be in local time, instead of \
GMT.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->535102540],

Cell[TextData[{
 StyleBox["-template ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->235720836],

Cell[CellGroupData[{

Cell[TextData[{
 "Specifies the file that acts as a template for the output of ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->249726188],

Cell[TextData[{
 "This shows what the output of ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " looks like, with ",
 StyleBox["-format", "InlineCode"],
 " set to ",
 StyleBox["text", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->95923699],

Cell["\<\
Online help is available at
http://support.wolfram.com/networkmathematica/
and
http://documents.wolfram.com

MathLM Version 6.0 
MathLM Server hostname.domain.com 
Date : Thursday, March 11 2006 15:11:59 
\t
\t
License Type                In Use / Authorized 

Mathematica Unix Front End      [1] [5] 
Mathematica Unix Kernel         [1] [5]

\t
Licenses in use: 
\t
                                    License 
Program\t                Version     Type        Username        Hostname     \
       Duration
------------------------------------------------------------------------------\
-----------------
Mathematica FE          6.0         Unix        username        \
client.domain.com   08:04 
Mathematica KE          6.0         Unix        username        \
client.domain.com   08:04 \
\>", "Program",
 CellTags->"b:2.1.2",
 CellID->405118077],

Cell[TextData[{
 "This shows what the output of ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " looks like in a web browser, with ",
 StyleBox["-format", "InlineCode"],
 " set to ",
 StyleBox["html", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->65925579],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{562, 601},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.2",
 CellID->168349907],

Cell[TextData[{
 "Note that when ",
 StyleBox["-format", "InlineCode"],
 " is set to ",
 StyleBox["cgi", "InlineCode"],
 ", the output of ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " is sent to ",
 StyleBox["stdout", "InlineCode"],
 " in HTML format. This shows what that output looks like when displayed in a \
web browser."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->798926993],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{562, 617},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.2",
 CellID->92661183]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Customizing the Output of ",
 StyleBox["MonitorLM",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"i:7", "b:2.1.2", "net: 4"},
 CellID->169444205],

Cell[TextData[{
 "You can customize the content and format of the output from ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " by editing a template file. This is a plain text file, which can contain \
the following types of elements. "
}], "Text",
 CellTags->"b:2.1.2",
 CellID->89752331],

Cell[TextData[{
 "Constant tags\[LongDash]These tags represent data that is static during the \
execution of ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " and license-independent, such as the current date. Each of these tag names \
has the prefix ",
 StyleBox["CONST", "InlineCode"],
 "."
}], "BulletedText",
 CellTags->"b:2.1.2",
 CellID->311069140],

Cell[TextData[{
 "Variable tags\[LongDash]These tags act as wrappers to constant tags. They \
are useful in defining the format for data to be output in series, such as a \
table of current ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " users. They are useful for improving readability of the template file. \
Each of these tag names has the prefix ",
 StyleBox["VAR", "InlineCode"],
 "."
}], "BulletedText",
 CellTags->"b:2.1.2",
 CellID->75728831],

Cell[TextData[{
 "Process-dependent tags\[LongDash]The value of these tags depends upon which \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process is being displayed and includes data like the process owner\
\[CloseCurlyQuote]s username and IP address. Each of these tag names has the \
prefix ",
 StyleBox["PROC", "InlineCode"],
 "."
}], "BulletedText",
 CellTags->"b:2.1.2",
 CellID->463444474],

Cell[TextData[{
 "Repeated tags\[LongDash]These tags serve as placeholders for information \
regarding an unknown number of licenses. They are the only tags whose size is \
not predetermined. Only the checkout lines are repeated, and there is one \
checkout line per license. Each of these tag names has the prefix ",
 StyleBox["REP", "InlineCode"],
 "."
}], "BulletedText",
 CellTags->"b:2.1.2",
 CellID->82713745],

Cell[CellGroupData[{

Cell["\<\
Text wrappers\[LongDash]This is the text that a user can wrap around the \
tags, for presentation and formatting.\
\>", "BulletedText",
 CellTags->"b:2.1.2",
 CellID->677536407],

Cell[TextData[{
 "Each tag in the template file has the form ",
 StyleBox["%", "InlineCode"],
 StyleBox["var", "TI"],
 StyleBox["#", "InlineCode"],
 ", where "
}], "Text",
 CellTags->"b:2.1.2",
 CellID->827294641]
}, Open  ]],

Cell[TextData[{
 StyleBox["var", "TI"],
 " represents a variable whose value is provided by the server."
}], "BulletedText",
 CellTags->"b:2.1.2",
 CellID->745806553],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["#", "InlineCode"],
 " is a number defining a specific format for the display of the variable ",
 StyleBox["var", "TI"],
 "."
}], "BulletedText",
 CellTags->"b:2.1.2",
 CellID->515704766],

Cell[TextData[{
 "In addition to the ",
 StyleBox["%", "InlineCode"],
 StyleBox["var", "TI"],
 StyleBox["#", "InlineCode"],
 " commands, the template file can also include plain text such as brackets, \
dashes, quotation marks, and arbitrary comments. The text can be used to \
include comments and separators in the server messages for formatting \
purposes. All text included in the string appears literally in the server \
message with the following two exceptions: use ",
 StyleBox["%q", "InlineCode"],
 " to include a double quote (",
 StyleBox["\"", "InlineCode"],
 "), and use ",
 StyleBox["%%", "InlineCode"],
 " to include a percentage sign (",
 StyleBox["%", "InlineCode"],
 ")."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->313729670],

Cell["\<\
Here is a list of tag names that can be included in the template file along \
with the numeric values for their possible formats.\
\>", "Text",
 CellTags->"b:2.1.2",
 CellID->392329339]
}, Open  ]],

Cell[CellGroupData[{

Cell["Predefined Constant Tags", "Subsection",
 CellTags->{"i:8", "b:2.1.2"},
 CellID->18275796],

Cell[TextData[StyleBox["%CONST_DATE_D# ", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->177056234],

Cell[TextData[{
 StyleBox["Day of month", "TI"],
 " "
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->158618674],

Cell["[ 1 ... 31 ]", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->508792254],

Cell[TextData[StyleBox["%CONST_DATE_W#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->52573483],

Cell[TextData[StyleBox["Day of week", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->145417762],

Cell["1 \[Dash] Numeric [ 1 ... 7 ] ", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->29850956],

Cell["\<\
2 \[Dash] Abbreviated [ Sun ... Sat ] \
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->411883708],

Cell["\<\
3 \[Dash] Verbose [ Sunday ... Saturday ]\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->310805268],

Cell[TextData[StyleBox["%CONST_DATE_M#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->2336550],

Cell[TextData[StyleBox["Month", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->1016565841],

Cell["1 \[Dash] Numeric [ 1 ... 12 ] ", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->608789859],

Cell["\<\
2 \[Dash] Abbreviated [ Jan ... Dec ] \
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->649587129],

Cell["\<\
3 \[Dash] Verbose [ January ... December ]\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->48204198],

Cell[TextData[StyleBox["%CONST_DATE_Y#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->164909202],

Cell[TextData[StyleBox["Year", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->340943193],

Cell["1 \[Dash] Two-digit [ 06 ] ", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->18135921],

Cell["2 \[Dash] Four-digit [ 2006 ]", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->50237161],

Cell[TextData[StyleBox["%CONST_DATE_T#", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->201250616],

Cell[TextData[StyleBox["Time", "TI"]], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->540845115],

Cell["1 \[Dash] Twelve-hour [ 10:20:15 ] ", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->310330735],

Cell["\<\
2 \[Dash] Twenty-four-hour [ 22:20:15 ] \
\>", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->158777591],

Cell[TextData[StyleBox["%CONST_SERVER_IP", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->44608177],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " IP address."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->114423859],

Cell[TextData[StyleBox["%CONST_SERVER_HOST", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->136384],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " hostname."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->21309803],

Cell[TextData[StyleBox["%CONST_SERVER_DOMAIN", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->6553357],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " domain."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->165550495],

Cell[TextData[StyleBox["%CONST_SERVER_FQDN", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->141780962],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " fully qualified domain name."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->8258961],

Cell[TextData[StyleBox["%CONST_SERVER_VERSION", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->362579284],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " version."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->808942389],

Cell[TextData[StyleBox["%CONST_CA_FE_AUTHORIZED", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->7877465],

Cell["Number of class A front ends authorized.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->608387729],

Cell[TextData[StyleBox["%CONST_CB_FE_AUTHORIZED", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->152673010],

Cell["Number of class B front ends authorized.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->33917501],

Cell[TextData[StyleBox["%CONST_TOTAL_FE_AUTHORIZED", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->326846239],

Cell["Total number of front ends authorized.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->13058254],

Cell[TextData[StyleBox["%CONST_CA_KE_AUTHORIZED", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->83852343],

Cell["Number of class A kernels authorized.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->114473269],

Cell[TextData[StyleBox["%CONST_CB_KE_AUTHORIZED", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->541729359],

Cell["Number of class B kernels authorized.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->199406149],

Cell[TextData[StyleBox["%CONST_TOTAL_KE_AUTHORIZED", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->203774475],

Cell["Total number of kernels authorized.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->107039485],

Cell[TextData[StyleBox["%CONST_CA_FE_AVAILABLE", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->711878862],

Cell["Number of class A front ends available.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->535537096],

Cell[TextData[StyleBox["%CONST_CB_FE_AVAILABLE", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->26817073],

Cell["Number of class B front ends available.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->34827262],

Cell[TextData[StyleBox["%CONST_TOTAL_FE_AVAILABLE", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->149148475],

Cell["Total number of front ends available.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->25518559],

Cell[TextData[StyleBox["%CONST_CA_KE_AVAILABLE", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->491874396],

Cell["Number of class A kernels available.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->417723805],

Cell[TextData[StyleBox["%CONST_CB_KE_AVAILABLE", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->163287343],

Cell["Number of class B kernels available.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->795862342],

Cell[TextData[StyleBox["%CONST_TOTAL_KE_AVAILABLE", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->79982852],

Cell["Total number of kernels available.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->32466880],

Cell[TextData[StyleBox["%CONST_CA_FE_OUT", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->15483442],

Cell["Number of class A front ends in use.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->356750493],

Cell[TextData[StyleBox["%CONST_CB_FE_OUT", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->369717529],

Cell["Number of class B front ends in use.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->471947431],

Cell[TextData[StyleBox["%CONST_TOTAL_FE_OUT", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->243183681],

Cell["Total number of front ends in use.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->45757475],

Cell[TextData[StyleBox["%CONST_CA_KE_OUT", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->127865650],

Cell["Number of class A kernels in use.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->102553346],

Cell[TextData[StyleBox["%CONST_CB_KE_OUT", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->163406572],

Cell["Number of class B kernels in use.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->657855000],

Cell[TextData[StyleBox["%CONST_TOTAL_KE_OUT", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->25601642],

Cell["Total number of kernels in use.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->362037966],

Cell[CellGroupData[{

Cell["Customizable Variable Tags", "Subsubsection",
 CellTags->{"i:9", "b:2.1.2"},
 CellID->103646856],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " The strings provided in this section are examples of possible values, not \
default settings. To use these tags, you must define them in your template."
}], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->456545771],

Cell[TextData[StyleBox["%VAR_DATE_AMPM = \"A.M.\" \"P.M.\"", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->245541684],

Cell["Text to use for a.m. and p.m. when displaying time.", \
"ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->108834369],

Cell[TextData[StyleBox["%VAR_MPROCESS = \"Front End\" \"Kernel\"", \
"InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->609446842],

Cell[TextData[{
 "Title for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " processes. The first string in quotes is the front end title and the \
second is the kernel title."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->135901631],

Cell[TextData[StyleBox["%VAR_LIC_CLASS = \"Class A\" \"Class B\" ", \
"InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->274645091],

Cell["Labels for each license class.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->137136549],

Cell[TextData[StyleBox["%VAR_CA_AUTHORIZED_HEADER = \"Class A Authorized \\t \
Front End \\t Kernel\"", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->85467261],

Cell[TextData[{
 "Header for number of authorized class A licenses. Use with the predefined \
constant tags ",
 StyleBox["%CONST_CA_FE_AUTHORIZED", "InlineCode"],
 " and ",
 StyleBox["%CONST_CA_KE_AUTHORIZED", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->99379981],

Cell[TextData[StyleBox["%VAR_CB_AUTHORIZED_HEADER = \"Class B Authorized \\t \
Front End \\t Kernel\"", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->314880933],

Cell[TextData[{
 "Header for number of authorized class B licenses. Use with the predefined \
constant tags ",
 StyleBox["%CONST_CB_FE_AUTHORIZED", "InlineCode"],
 " and ",
 StyleBox["%CONST_CB_KE_AUTHORIZED", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->124448893],

Cell[TextData[StyleBox["%VAR_TOTAL_AUTHORIZED_HEADER = \"Total Authorized \\t \
Front End \\t Kernel\"", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->80050971],

Cell[TextData[{
 "Header for total number of authorized licenses. Use with the predefined \
constant tags ",
 StyleBox["%CONST_TOTAL_FE_AUTHORIZED", "InlineCode"],
 " and ",
 StyleBox["%CONST_TOTAL_KE_AUTHORIZED", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->64683433],

Cell[TextData[StyleBox["%VAR_CA_CHECKEDOUT_HEADER = \"Class A Licenses in Use\
\\nUsername \\t Hostname \\t Program \\t Slot # \\t Duration\"", \
"InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->163329968],

Cell[TextData[{
 "Header for information about class A licenses in use. Use with the repeated \
tag ",
 StyleBox["%REP_CA_CHECKOUT_LINE", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->173248379],

Cell[TextData[StyleBox["%VAR_CB_CHECKEDOUT_HEADER = \"Class B Licenses in Use\
\\nUsername \\t Hostname \\t Program \\t Slot # \\t Duration\"", \
"InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->146690945],

Cell[TextData[{
 "Header for information about class A licenses in use. Use with the repeated \
tag ",
 StyleBox["%REP_CB_CHECKOUT_LINE", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->95788847],

Cell[TextData[StyleBox["%VAR_CHECKEDOUT_HEADER = \"Licenses in Use\\nUsername \
\\t Hostname \\t Program \\t License Class \\t Slot # \\t Duration\"", \
"InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->575457332],

Cell[TextData[{
 "Header for information about all licenses in use. Use with the repeated tag \
",
 StyleBox["%REP_GENERAL_CHECKOUT_LINE", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->943898]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process-Dependent Tags", "Subsection",
 CellTags->{"i:10", "b:2.1.2"},
 CellID->1011902122],

Cell[TextData[StyleBox["%PROC_UID", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->395760940],

Cell[TextData[{
 "User ID of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process owner."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->8417441],

Cell[TextData[StyleBox["%PROC_USER", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->759133988],

Cell[TextData[{
 "Username of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process owner."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->555455378],

Cell[TextData[StyleBox["%PROC_IP", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->528758718],

Cell[TextData[{
 "IP address of machine using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->199312960],

Cell[TextData[StyleBox["%PROC_HOST", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->185822387],

Cell[TextData[{
 "Hostname of machine using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->73065074],

Cell[TextData[StyleBox["%PROC_DOMAIN", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->637504357],

Cell[TextData[{
 "Domain of machine using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->55157806],

Cell[TextData[StyleBox["%PROC_FQDN", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->206604864],

Cell[TextData[{
 "Fully qualified domain name of machine using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->791981158],

Cell[TextData[StyleBox["%PROC_SLOTNUM", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->578940820],

Cell[TextData[{
 "Slot number of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->162643814],

Cell[TextData[StyleBox["%PROC_VERSION", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->291373686],

Cell["Version of client.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->52219279],

Cell[TextData[StyleBox["%PROC_DURATION", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->128472803],

Cell["Time client has been running.", "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->128744749]
}, Open  ]],

Cell[CellGroupData[{

Cell["Repeated Tags", "Subsection",
 CellTags->{"i:11", "b:2.1.2"},
 CellID->310565419],

Cell[TextData[{
 StyleBox["Note:",
  FontWeight->"Bold"],
 " The strings provided in this section are examples of possible values, not \
default settings. To use these tags, you must define them in your template."
}], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->105278211],

Cell[TextData[StyleBox["%REP_CA_CHECKOUT_LINE = \"%PROC_USER \\t %PROC_HOST \
\\t %VAR_MPROCESS \\t %PROC_SLOTNUM \\t %PROC_DURATION\\n\"", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->120467798],

Cell[TextData[{
 "Class A checkout line. This specifies the format of each line in the table \
or block that lists the class A processes in use. Corresponds to the \
customizable variable tag ",
 StyleBox["%VAR_CA_CHECKEDOUT_HEADER", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->82106674],

Cell[TextData[StyleBox["%REP_CB_CHECKOUT_LINE = \"%PROC_USER \\t %PROC_HOST \
\\t %VAR_MPROCESS \\t %PROC_SLOTNUM \\t %PROC_DURATION\\n\"", "InlineCode"]], \
"IndentedText",
 CellTags->"b:2.1.2",
 CellID->393417426],

Cell[TextData[{
 "Class B checkout line. This specifies the format of each line in the table \
or block that lists the class B processes in use. Corresponds to the \
customizable variable tag ",
 StyleBox["%VAR_CB_CHECKEDOUT_HEADER", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->93827313],

Cell[TextData[StyleBox["%REP_GENERAL_CHECKOUT_LINE = \"%PROC_USER \\t \
%PROC_HOST \\t %VAR_MPROCESS \\t %VAR_LIC_CLASS \\t %PROC_SLOTNUM \\t \
%PROC_DURATION\\n\"", "InlineCode"]], "IndentedText",
 CellTags->"b:2.1.2",
 CellID->7503886],

Cell[CellGroupData[{

Cell[TextData[{
 "General checkout line. Use this if you do not want to separate classes. \
Corresponds to the customizable variable tag ",
 StyleBox["%VAR_CHECKEDOUT_HEADER", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->85052122],

Cell[TextData[{
 "In the template file, the text wrappers and tags that make up the output to \
",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " must follow a line containing only the keyword ",
 StyleBox["%TEXT", "InlineCode"],
 " with no whitespace before or after it. Definitions for customized variable \
tags must precede the ",
 StyleBox["%TEXT", "InlineCode"],
 " line. If no variable tags are customized, the ",
 StyleBox["%TEXT", "InlineCode"],
 " line can be the first line of the file."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->224531539]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Samples and Behavior", "Section",
 CellTags->{"i:12", "b:2.1.2", "net: 5"},
 CellID->357167471],

Cell["\<\
Here is a simple text file that shows only the number of processes \
authorized, available, and in use. This example does not need to define any \
variable definition tags. \
\>", "Text",
 CellTags->"b:2.1.2",
 CellID->312098361],

Cell["\<\
%TEXT
Time/Date : [%CONST_DATE_T2] [%CONST_DATE_M3 %CONST_DATE_D, %CONST_DATE_Y2]
Front End Processes Authorized: %CONST_TOTAL_FE_AUTHORIZED
Kernel Processes Authorized: %CONST_TOTAL_KE_AUTHORIZED
Front End Processes Available: %CONST_TOTAL_FE_AVAILABLE
Kernel Processes Available: %CONST_TOTAL_KE_AVAILABLE
Front End Processes In Use: %CONST_TOTAL_FE_OUT
Kernel Processes In Use: %CONST_TOTAL_KE_OUT\
\>", "Program",
 CellTags->"b:2.1.2",
 CellID->32294106],

Cell["The resulting output has the form shown here.", "Text",
 CellTags->"b:2.1.2",
 CellID->424973750],

Cell["\<\
Time/Date : [00:05:26] [January 30, 2006]
Front End Processes Authorized: 5
Kernel Processes Authorized: 5
Front End Processes Available: 4
Kernel Processes Available: 4
Front End Processes In Use: 1
Kernel Processes In Use: 1\
\>", "Program",
 CellTags->"b:2.1.2",
 CellID->248607942],

Cell["\<\
Here is a slightly more sophisticated example. It is identical to the \
preceding example except that it also lists the processes in use and \
customizes variable tags. \
\>", "Text",
 CellTags->"b:2.1.2",
 CellID->359183696],

Cell["\<\
# Begin variable tag definitions
%VAR_MPROCESS = \"FE\" \"KE\"
%VAR_TOTAL_CHECKEDOUT_HEADER = \"Slot\\t Program\\t User\\t Host\\n\"
%REP_GENERAL_CHECKOUT_LINE = \"%PROC_SLOTNUM\\t %VAR_MPROCESS\\t \
%PROC_USER\\t %PROC_HOST\\n\"

%TEXT
Time/Date : [%CONST_DATE_T2] [%CONST_DATE_M3 %CONST_DATE_D, %CONST_DATE_Y2]
Front End Processes Authorized: %CONST_TOTAL_FE_AUTHORIZED
Kernel Processes Authorized: %CONST_TOTAL_KE_AUTHORIZED
Front End Processes Available: %CONST_TOTAL_FE_AVAILABLE
Kernel Processes Available: %CONST_TOTAL_KE_AVAILABLE
Front End Processes In Use: %CONST_TOTAL_FE_OUT
Kernel Processes In Use: %CONST_TOTAL_KE_OUT 

%VAR_TOTAL_CHECKEDOUT_HEADER
%REP_GENERAL_CHECKOUT_LINE\
\>", "Program",
 CellTags->"b:2.1.2",
 CellID->41191271],

Cell["The resulting output has the form shown here.", "Text",
 CellTags->"b:2.1.2",
 CellID->670691877],

Cell["\<\
Time/Date : [00:05:26] [January 30, 2006]
Front End Processes Authorized: 5
Kernel Processes Authorized: 5
Front End Processes Available: 4
Kernel Processes Available: 4
Front End Processes In Use: 1
Kernel Processes In Use: 1

Slot    Program   User       Host
6       FE        username   hostname
1       KE        username   hostname\
\>", "Program",
 CellTags->"b:2.1.2",
 CellID->247703598],

Cell[TextData[{
 "The following example demonstrates HTML output. This is useful, for \
example, if you want to view the ",
 StyleBox[ButtonBox["MonitorLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/monitorlm"],
  FontSlant->"Italic"],
 " output in a web browser."
}], "Text",
 CellTags->"b:2.1.2",
 CellID->448526262],

Cell["\<\
%VAR_MPROCESS = \"Front End\" \"Kernel\"
%VAR_TOTAL_CHECKEDOUT_HEADER = \"<TR><TD><B>Slot</B></TD> \
<TD><B>Program</B></TD> <TD><B>User</B></TD> <TD><B>FQDN</B></TD> </TR>\\n\"
%REP_GENERAL_CHECKOUT_LINE = \"<TR> <TD>%PROC_SLOTNUM</TD> \
<TD>%VAR_MPROCESS</TD> <TD>%PROC_USER</TD> <TD>%PROC_FQDN</TD> </TR>\\n\"

%TEXT
<HTML>
<HEAD> <TITLE> MathLM Status </TITLE> </HEAD>
<BODY>
<TABLE BORDER=1 CELLPADDING=5>
<TR><TD COLSPAN=2><B>MathLM Server</B></TD> <TD \
COLSPAN=2><B>%CONST_SERVER_FQDN</B></TD> </TR>
<TR><TD COLSPAN=2>Time/Date</TD> <TD COLSPAN=2>[%CONST_DATE_T2] \
[%CONST_DATE_M3 %CONST_DATE_D, %CONST_DATE_Y2]</TD> </TR>
<TR><TD COLSPAN=2>Authorized</TD> <TD>%CONST_TOTAL_FE_AUTHORIZED</TD> \
<TD>%CONST_TOTAL_KE_AUTHORIZED</TD></TR>
<TR><TD COLSPAN=2>Available</TD> <TD>%CONST_TOTAL_FE_AVAILABLE</TD> \
<TD>%CONST_TOTAL_KE_AVAILABLE</TD></TR>
<TR><TD COLSPAN=2>In Use</TD> <TD>%CONST_TOTAL_FE_OUT</TD> \
<TD>%CONST_TOTAL_KE_OUT</TD></TR>
 
%VAR_TOTAL_CHECKEDOUT_HEADER
%REP_GENERAL_CHECKOUT_LINE

</TABLE>
</BODY>
</HTML>\
\>", "Program",
 CellTags->"b:2.1.2",
 CellID->34815273],

Cell["The resulting output has the form shown here.", "Text",
 CellTags->"b:2.1.2",
 CellID->360167342],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{487, 500},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.1.2",
 CellID->480183068],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->787350899],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Monitoring MathLM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 31.6802680}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MonitorLM gives information on the total number of licenses available \
and checked out, the fully qualified domain name and username of those who \
have them checked out, and so on. MonitorLM can send output to the terminal, \
open a web browser, or write to a file. The output for MonitorLM is \
customizable by means of a configuration file. To start MonitorLM, change \
directory to the location in which MathLM is installed, and type .\\monitorlm \
servername (on Windows) or ./monitorlm servername (on Unix, Linux, or Mac OS \
X). The first argument of the monitorlm command specifies the name of the \
license server running MathLM. If you do not specify a server name \
explicitly, the local machine name is chosen as the default. The following \
options are available using the monitorlm command. The syntax for specifying \
an option is monitorlm servername options.", "synonyms" -> {}, "title" -> 
    "Monitoring MathLM", "type" -> "Tutorial", "uri" -> 
    "tutorial/MonitoringMathLM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:5"->{
  Cell[1451, 53, 154, 7, 70, "Section",
   CellTags->{"i:5", "b:2.1.2", "net: 1"},
   CellID->2472981]},
 "b:2.1.2"->{
  Cell[1451, 53, 154, 7, 70, "Section",
   CellTags->{"i:5", "b:2.1.2", "net: 1"},
   CellID->2472981],
  Cell[1608, 62, 773, 21, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->201319271],
  Cell[2418, 88, 150, 6, 70, "Section",
   CellTags->{"b:2.1.2", "i:5b", "net: 2"},
   CellID->8995171],
  Cell[2571, 96, 959, 28, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->396740147],
  Cell[3567, 129, 163, 6, 70, "Section",
   CellTags->{"i:6", "b:2.1.2", "net: 3"},
   CellID->849015738],
  Cell[3733, 137, 325, 12, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->95664982],
  Cell[4061, 151, 136, 5, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->216414686],
  Cell[4200, 158, 456, 14, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->329816948],
  Cell[4659, 174, 135, 5, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->314923500],
  Cell[4797, 181, 288, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->794342334],
  Cell[5088, 192, 246, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->615761780],
  Cell[5337, 201, 279, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->247028905],
  Cell[5619, 210, 392, 12, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->43001631],
  Cell[6014, 224, 110, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->433519869],
  Cell[6127, 228, 163, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->535102540],
  Cell[6293, 235, 140, 5, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->235720836],
  Cell[6458, 244, 282, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->249726188],
  Cell[6743, 255, 338, 13, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->95923699],
  Cell[7084, 270, 860, 30, 70, "Program",
   CellTags->"b:2.1.2",
   CellID->405118077],
  Cell[7947, 302, 355, 13, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->65925579],
  Cell[8305, 317, 44096, 727, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:2.1.2",
   CellID->168349907],
  Cell[52404, 1046, 465, 16, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->798926993],
  Cell[52872, 1064, 44489, 733, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:2.1.2",
   CellID->92661183],
  Cell[97410, 1803, 168, 6, 70, "Section",
   CellTags->{"i:7", "b:2.1.2", "net: 4"},
   CellID->169444205],
  Cell[97581, 1811, 371, 10, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->89752331],
  Cell[97955, 1823, 435, 13, 70, "BulletedText",
   CellTags->"b:2.1.2",
   CellID->311069140],
  Cell[98393, 1838, 527, 14, 70, "BulletedText",
   CellTags->"b:2.1.2",
   CellID->75728831],
  Cell[98923, 1854, 408, 12, 70, "BulletedText",
   CellTags->"b:2.1.2",
   CellID->463444474],
  Cell[99334, 1868, 415, 9, 70, "BulletedText",
   CellTags->"b:2.1.2",
   CellID->82713745],
  Cell[99774, 1881, 187, 5, 70, "BulletedText",
   CellTags->"b:2.1.2",
   CellID->677536407],
  Cell[99964, 1888, 213, 8, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->827294641],
  Cell[100192, 1899, 166, 5, 70, "BulletedText",
   CellTags->"b:2.1.2",
   CellID->745806553],
  Cell[100383, 1908, 213, 7, 70, "BulletedText",
   CellTags->"b:2.1.2",
   CellID->515704766],
  Cell[100599, 1917, 743, 20, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->313729670],
  Cell[101345, 1939, 195, 5, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->392329339],
  Cell[101577, 1949, 96, 2, 70, "Subsection",
   CellTags->{"i:8", "b:2.1.2"},
   CellID->18275796],
  Cell[101676, 1953, 115, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->177056234],
  Cell[101794, 1957, 124, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->158618674],
  Cell[101921, 1964, 87, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->508792254],
  Cell[102011, 1968, 113, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->52573483],
  Cell[102127, 1972, 112, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->145417762],
  Cell[102242, 1976, 104, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->29850956],
  Cell[102349, 1980, 121, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->411883708],
  Cell[102473, 1986, 124, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->310805268],
  Cell[102600, 1992, 112, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->2336550],
  Cell[102715, 1996, 107, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->1016565841],
  Cell[102825, 2000, 106, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->608789859],
  Cell[102934, 2004, 121, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->649587129],
  Cell[103058, 2010, 124, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->48204198],
  Cell[103185, 2016, 114, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->164909202],
  Cell[103302, 2020, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->340943193],
  Cell[103410, 2024, 101, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->18135921],
  Cell[103514, 2028, 103, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->50237161],
  Cell[103620, 2032, 114, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->201250616],
  Cell[103737, 2036, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->540845115],
  Cell[103845, 2040, 110, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->310330735],
  Cell[103958, 2044, 123, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->158777591],
  Cell[104084, 2050, 115, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->44608177],
  Cell[104202, 2054, 221, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->114423859],
  Cell[104426, 2064, 115, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->136384],
  Cell[104544, 2068, 218, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->21309803],
  Cell[104765, 2078, 118, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->6553357],
  Cell[104886, 2082, 217, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->165550495],
  Cell[105106, 2092, 118, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->141780962],
  Cell[105227, 2096, 236, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->8258961],
  Cell[105466, 2106, 121, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->362579284],
  Cell[105590, 2110, 218, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->808942389],
  Cell[105811, 2120, 123, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->7877465],
  Cell[105937, 2125, 115, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->608387729],
  Cell[106055, 2129, 125, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->152673010],
  Cell[106183, 2134, 114, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->33917501],
  Cell[106300, 2138, 128, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->326846239],
  Cell[106431, 2143, 112, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->13058254],
  Cell[106546, 2147, 124, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->83852343],
  Cell[106673, 2152, 112, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->114473269],
  Cell[106788, 2156, 125, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->541729359],
  Cell[106916, 2161, 112, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->199406149],
  Cell[107031, 2165, 128, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->203774475],
  Cell[107162, 2170, 110, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->107039485],
  Cell[107275, 2174, 124, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->711878862],
  Cell[107402, 2179, 114, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->535537096],
  Cell[107519, 2183, 123, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->26817073],
  Cell[107645, 2188, 113, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->34827262],
  Cell[107761, 2192, 127, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->149148475],
  Cell[107891, 2197, 111, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->25518559],
  Cell[108005, 2201, 124, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->491874396],
  Cell[108132, 2206, 111, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->417723805],
  Cell[108246, 2210, 124, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->163287343],
  Cell[108373, 2215, 111, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->795862342],
  Cell[108487, 2219, 126, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->79982852],
  Cell[108616, 2224, 108, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->32466880],
  Cell[108727, 2228, 115, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->15483442],
  Cell[108845, 2232, 111, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->356750493],
  Cell[108959, 2236, 116, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->369717529],
  Cell[109078, 2240, 111, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->471947431],
  Cell[109192, 2244, 119, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->243183681],
  Cell[109314, 2248, 108, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->45757475],
  Cell[109425, 2252, 116, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->127865650],
  Cell[109544, 2256, 108, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->102553346],
  Cell[109655, 2260, 116, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->163406572],
  Cell[109774, 2264, 108, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->657855000],
  Cell[109885, 2268, 118, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->25601642],
  Cell[110006, 2272, 106, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->362037966],
  Cell[110137, 2278, 102, 2, 70, "Subsubsection",
   CellTags->{"i:9", "b:2.1.2"},
   CellID->103646856],
  Cell[110242, 2282, 259, 6, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->456545771],
  Cell[110504, 2290, 136, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->245541684],
  Cell[110643, 2295, 128, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->108834369],
  Cell[110774, 2300, 142, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->609446842],
  Cell[110919, 2305, 253, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->135901631],
  Cell[111175, 2315, 143, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->274645091],
  Cell[111321, 2320, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->137136549],
  Cell[111429, 2324, 176, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->85467261],
  Cell[111608, 2329, 299, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->99379981],
  Cell[111910, 2340, 177, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->314880933],
  Cell[112090, 2345, 300, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->124448893],
  Cell[112393, 2356, 177, 3, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->80050971],
  Cell[112573, 2361, 303, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->64683433],
  Cell[112879, 2372, 219, 4, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->163329968],
  Cell[113101, 2378, 228, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->173248379],
  Cell[113332, 2387, 219, 4, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->146690945],
  Cell[113554, 2393, 227, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->95788847],
  Cell[113784, 2402, 226, 4, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->575457332],
  Cell[114013, 2408, 226, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->943898],
  Cell[114288, 2421, 97, 2, 70, "Subsection",
   CellTags->{"i:10", "b:2.1.2"},
   CellID->1011902122],
  Cell[114388, 2425, 109, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->395760940],
  Cell[114500, 2429, 168, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->8417441],
  Cell[114671, 2438, 110, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->759133988],
  Cell[114784, 2442, 171, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->555455378],
  Cell[114958, 2451, 108, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->528758718],
  Cell[115069, 2455, 181, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->199312960],
  Cell[115253, 2464, 110, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->185822387],
  Cell[115366, 2468, 178, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->73065074],
  Cell[115547, 2477, 112, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->637504357],
  Cell[115662, 2481, 176, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->55157806],
  Cell[115841, 2490, 110, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->206604864],
  Cell[115954, 2494, 198, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->791981158],
  Cell[116155, 2503, 113, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->578940820],
  Cell[116271, 2507, 168, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->162643814],
  Cell[116442, 2516, 113, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->291373686],
  Cell[116558, 2520, 92, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->52219279],
  Cell[116653, 2524, 114, 2, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->128472803],
  Cell[116770, 2528, 104, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->128744749],
  Cell[116911, 2535, 87, 2, 70, "Subsection",
   CellTags->{"i:11", "b:2.1.2"},
   CellID->310565419],
  Cell[117001, 2539, 275, 7, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->105278211],
  Cell[117279, 2548, 215, 4, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->120467798],
  Cell[117497, 2554, 323, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->82106674],
  Cell[117823, 2564, 215, 4, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->393417426],
  Cell[118041, 2570, 323, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->93827313],
  Cell[118367, 2580, 237, 4, 70, "IndentedText",
   CellTags->"b:2.1.2",
   CellID->7503886],
  Cell[118629, 2588, 265, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:2.1.2",
   CellID->85052122],
  Cell[118897, 2597, 633, 17, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->224531539],
  Cell[119591, 2621, 101, 2, 70, "Section",
   CellTags->{"i:12", "b:2.1.2", "net: 5"},
   CellID->357167471],
  Cell[119695, 2625, 239, 6, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->312098361],
  Cell[119937, 2633, 468, 11, 70, "Program",
   CellTags->"b:2.1.2",
   CellID->32294106],
  Cell[120408, 2646, 103, 2, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->424973750],
  Cell[120514, 2650, 295, 10, 70, "Program",
   CellTags->"b:2.1.2",
   CellID->248607942],
  Cell[120812, 2662, 235, 6, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->359183696],
  Cell[121050, 2670, 757, 20, 70, "Program",
   CellTags->"b:2.1.2",
   CellID->41191271],
  Cell[121810, 2692, 103, 2, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->670691877],
  Cell[121916, 2696, 406, 14, 70, "Program",
   CellTags->"b:2.1.2",
   CellID->247703598],
  Cell[122325, 2712, 331, 10, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->448526262],
  Cell[122659, 2724, 1101, 31, 70, "Program",
   CellTags->"b:2.1.2",
   CellID->34815273],
  Cell[123763, 2757, 103, 2, 70, "Text",
   CellTags->"b:2.1.2",
   CellID->360167342],
  Cell[123869, 2761, 37492, 619, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:2.1.2",
   CellID->480183068]},
 "net: 1"->{
  Cell[1451, 53, 154, 7, 70, "Section",
   CellTags->{"i:5", "b:2.1.2", "net: 1"},
   CellID->2472981]},
 "i:5b"->{
  Cell[2418, 88, 150, 6, 70, "Section",
   CellTags->{"b:2.1.2", "i:5b", "net: 2"},
   CellID->8995171]},
 "net: 2"->{
  Cell[2418, 88, 150, 6, 70, "Section",
   CellTags->{"b:2.1.2", "i:5b", "net: 2"},
   CellID->8995171]},
 "i:6"->{
  Cell[3567, 129, 163, 6, 70, "Section",
   CellTags->{"i:6", "b:2.1.2", "net: 3"},
   CellID->849015738]},
 "net: 3"->{
  Cell[3567, 129, 163, 6, 70, "Section",
   CellTags->{"i:6", "b:2.1.2", "net: 3"},
   CellID->849015738]},
 "i:7"->{
  Cell[97410, 1803, 168, 6, 70, "Section",
   CellTags->{"i:7", "b:2.1.2", "net: 4"},
   CellID->169444205]},
 "net: 4"->{
  Cell[97410, 1803, 168, 6, 70, "Section",
   CellTags->{"i:7", "b:2.1.2", "net: 4"},
   CellID->169444205]},
 "i:8"->{
  Cell[101577, 1949, 96, 2, 70, "Subsection",
   CellTags->{"i:8", "b:2.1.2"},
   CellID->18275796]},
 "i:9"->{
  Cell[110137, 2278, 102, 2, 70, "Subsubsection",
   CellTags->{"i:9", "b:2.1.2"},
   CellID->103646856]},
 "i:10"->{
  Cell[114288, 2421, 97, 2, 70, "Subsection",
   CellTags->{"i:10", "b:2.1.2"},
   CellID->1011902122]},
 "i:11"->{
  Cell[116911, 2535, 87, 2, 70, "Subsection",
   CellTags->{"i:11", "b:2.1.2"},
   CellID->310565419]},
 "i:12"->{
  Cell[119591, 2621, 101, 2, 70, "Section",
   CellTags->{"i:12", "b:2.1.2", "net: 5"},
   CellID->357167471]},
 "net: 5"->{
  Cell[119591, 2621, 101, 2, 70, "Section",
   CellTags->{"i:12", "b:2.1.2", "net: 5"},
   CellID->357167471]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:5", 163796, 3442},
 {"b:2.1.2", 163915, 3446},
 {"net: 1", 180160, 3942},
 {"i:5b", 180276, 3946},
 {"net: 2", 180395, 3950},
 {"i:6", 180511, 3954},
 {"net: 3", 180632, 3958},
 {"i:7", 180750, 3962},
 {"net: 4", 180873, 3966},
 {"i:8", 180993, 3970},
 {"i:9", 181105, 3974},
 {"i:10", 181223, 3978},
 {"i:11", 181339, 3982},
 {"i:12", 181454, 3986},
 {"net: 5", 181579, 3990}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 694, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1319, 44, 107, 5, 70, "Title",
 CellID->450596779],
Cell[CellGroupData[{
Cell[1451, 53, 154, 7, 70, "Section",
 CellTags->{"i:5", "b:2.1.2", "net: 1"},
 CellID->2472981],
Cell[1608, 62, 773, 21, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->201319271]
}, Open  ]],
Cell[CellGroupData[{
Cell[2418, 88, 150, 6, 70, "Section",
 CellTags->{"b:2.1.2", "i:5b", "net: 2"},
 CellID->8995171],
Cell[2571, 96, 959, 28, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->396740147]
}, Open  ]],
Cell[CellGroupData[{
Cell[3567, 129, 163, 6, 70, "Section",
 CellTags->{"i:6", "b:2.1.2", "net: 3"},
 CellID->849015738],
Cell[3733, 137, 325, 12, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->95664982],
Cell[4061, 151, 136, 5, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->216414686],
Cell[4200, 158, 456, 14, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->329816948],
Cell[4659, 174, 135, 5, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->314923500],
Cell[4797, 181, 288, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->794342334],
Cell[5088, 192, 246, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->615761780],
Cell[5337, 201, 279, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->247028905],
Cell[5619, 210, 392, 12, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->43001631],
Cell[6014, 224, 110, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->433519869],
Cell[6127, 228, 163, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->535102540],
Cell[6293, 235, 140, 5, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->235720836],
Cell[CellGroupData[{
Cell[6458, 244, 282, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->249726188],
Cell[6743, 255, 338, 13, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->95923699],
Cell[7084, 270, 860, 30, 70, "Program",
 CellTags->"b:2.1.2",
 CellID->405118077],
Cell[7947, 302, 355, 13, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->65925579],
Cell[8305, 317, 44096, 727, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:2.1.2",
 CellID->168349907],
Cell[52404, 1046, 465, 16, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->798926993],
Cell[52872, 1064, 44489, 733, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:2.1.2",
 CellID->92661183]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97410, 1803, 168, 6, 70, "Section",
 CellTags->{"i:7", "b:2.1.2", "net: 4"},
 CellID->169444205],
Cell[97581, 1811, 371, 10, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->89752331],
Cell[97955, 1823, 435, 13, 70, "BulletedText",
 CellTags->"b:2.1.2",
 CellID->311069140],
Cell[98393, 1838, 527, 14, 70, "BulletedText",
 CellTags->"b:2.1.2",
 CellID->75728831],
Cell[98923, 1854, 408, 12, 70, "BulletedText",
 CellTags->"b:2.1.2",
 CellID->463444474],
Cell[99334, 1868, 415, 9, 70, "BulletedText",
 CellTags->"b:2.1.2",
 CellID->82713745],
Cell[CellGroupData[{
Cell[99774, 1881, 187, 5, 70, "BulletedText",
 CellTags->"b:2.1.2",
 CellID->677536407],
Cell[99964, 1888, 213, 8, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->827294641]
}, Open  ]],
Cell[100192, 1899, 166, 5, 70, "BulletedText",
 CellTags->"b:2.1.2",
 CellID->745806553],
Cell[CellGroupData[{
Cell[100383, 1908, 213, 7, 70, "BulletedText",
 CellTags->"b:2.1.2",
 CellID->515704766],
Cell[100599, 1917, 743, 20, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->313729670],
Cell[101345, 1939, 195, 5, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->392329339]
}, Open  ]],
Cell[CellGroupData[{
Cell[101577, 1949, 96, 2, 70, "Subsection",
 CellTags->{"i:8", "b:2.1.2"},
 CellID->18275796],
Cell[101676, 1953, 115, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->177056234],
Cell[101794, 1957, 124, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->158618674],
Cell[101921, 1964, 87, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->508792254],
Cell[102011, 1968, 113, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->52573483],
Cell[102127, 1972, 112, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->145417762],
Cell[102242, 1976, 104, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->29850956],
Cell[102349, 1980, 121, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->411883708],
Cell[102473, 1986, 124, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->310805268],
Cell[102600, 1992, 112, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->2336550],
Cell[102715, 1996, 107, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->1016565841],
Cell[102825, 2000, 106, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->608789859],
Cell[102934, 2004, 121, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->649587129],
Cell[103058, 2010, 124, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->48204198],
Cell[103185, 2016, 114, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->164909202],
Cell[103302, 2020, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->340943193],
Cell[103410, 2024, 101, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->18135921],
Cell[103514, 2028, 103, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->50237161],
Cell[103620, 2032, 114, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->201250616],
Cell[103737, 2036, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->540845115],
Cell[103845, 2040, 110, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->310330735],
Cell[103958, 2044, 123, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->158777591],
Cell[104084, 2050, 115, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->44608177],
Cell[104202, 2054, 221, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->114423859],
Cell[104426, 2064, 115, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->136384],
Cell[104544, 2068, 218, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->21309803],
Cell[104765, 2078, 118, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->6553357],
Cell[104886, 2082, 217, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->165550495],
Cell[105106, 2092, 118, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->141780962],
Cell[105227, 2096, 236, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->8258961],
Cell[105466, 2106, 121, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->362579284],
Cell[105590, 2110, 218, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->808942389],
Cell[105811, 2120, 123, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->7877465],
Cell[105937, 2125, 115, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->608387729],
Cell[106055, 2129, 125, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->152673010],
Cell[106183, 2134, 114, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->33917501],
Cell[106300, 2138, 128, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->326846239],
Cell[106431, 2143, 112, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->13058254],
Cell[106546, 2147, 124, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->83852343],
Cell[106673, 2152, 112, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->114473269],
Cell[106788, 2156, 125, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->541729359],
Cell[106916, 2161, 112, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->199406149],
Cell[107031, 2165, 128, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->203774475],
Cell[107162, 2170, 110, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->107039485],
Cell[107275, 2174, 124, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->711878862],
Cell[107402, 2179, 114, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->535537096],
Cell[107519, 2183, 123, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->26817073],
Cell[107645, 2188, 113, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->34827262],
Cell[107761, 2192, 127, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->149148475],
Cell[107891, 2197, 111, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->25518559],
Cell[108005, 2201, 124, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->491874396],
Cell[108132, 2206, 111, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->417723805],
Cell[108246, 2210, 124, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->163287343],
Cell[108373, 2215, 111, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->795862342],
Cell[108487, 2219, 126, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->79982852],
Cell[108616, 2224, 108, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->32466880],
Cell[108727, 2228, 115, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->15483442],
Cell[108845, 2232, 111, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->356750493],
Cell[108959, 2236, 116, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->369717529],
Cell[109078, 2240, 111, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->471947431],
Cell[109192, 2244, 119, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->243183681],
Cell[109314, 2248, 108, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->45757475],
Cell[109425, 2252, 116, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->127865650],
Cell[109544, 2256, 108, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->102553346],
Cell[109655, 2260, 116, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->163406572],
Cell[109774, 2264, 108, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->657855000],
Cell[109885, 2268, 118, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->25601642],
Cell[110006, 2272, 106, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->362037966],
Cell[CellGroupData[{
Cell[110137, 2278, 102, 2, 70, "Subsubsection",
 CellTags->{"i:9", "b:2.1.2"},
 CellID->103646856],
Cell[110242, 2282, 259, 6, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->456545771],
Cell[110504, 2290, 136, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->245541684],
Cell[110643, 2295, 128, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->108834369],
Cell[110774, 2300, 142, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->609446842],
Cell[110919, 2305, 253, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->135901631],
Cell[111175, 2315, 143, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->274645091],
Cell[111321, 2320, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->137136549],
Cell[111429, 2324, 176, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->85467261],
Cell[111608, 2329, 299, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->99379981],
Cell[111910, 2340, 177, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->314880933],
Cell[112090, 2345, 300, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->124448893],
Cell[112393, 2356, 177, 3, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->80050971],
Cell[112573, 2361, 303, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->64683433],
Cell[112879, 2372, 219, 4, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->163329968],
Cell[113101, 2378, 228, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->173248379],
Cell[113332, 2387, 219, 4, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->146690945],
Cell[113554, 2393, 227, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->95788847],
Cell[113784, 2402, 226, 4, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->575457332],
Cell[114013, 2408, 226, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->943898]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[114288, 2421, 97, 2, 70, "Subsection",
 CellTags->{"i:10", "b:2.1.2"},
 CellID->1011902122],
Cell[114388, 2425, 109, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->395760940],
Cell[114500, 2429, 168, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->8417441],
Cell[114671, 2438, 110, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->759133988],
Cell[114784, 2442, 171, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->555455378],
Cell[114958, 2451, 108, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->528758718],
Cell[115069, 2455, 181, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->199312960],
Cell[115253, 2464, 110, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->185822387],
Cell[115366, 2468, 178, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->73065074],
Cell[115547, 2477, 112, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->637504357],
Cell[115662, 2481, 176, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->55157806],
Cell[115841, 2490, 110, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->206604864],
Cell[115954, 2494, 198, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->791981158],
Cell[116155, 2503, 113, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->578940820],
Cell[116271, 2507, 168, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->162643814],
Cell[116442, 2516, 113, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->291373686],
Cell[116558, 2520, 92, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->52219279],
Cell[116653, 2524, 114, 2, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->128472803],
Cell[116770, 2528, 104, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->128744749]
}, Open  ]],
Cell[CellGroupData[{
Cell[116911, 2535, 87, 2, 70, "Subsection",
 CellTags->{"i:11", "b:2.1.2"},
 CellID->310565419],
Cell[117001, 2539, 275, 7, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->105278211],
Cell[117279, 2548, 215, 4, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->120467798],
Cell[117497, 2554, 323, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->82106674],
Cell[117823, 2564, 215, 4, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->393417426],
Cell[118041, 2570, 323, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->93827313],
Cell[118367, 2580, 237, 4, 70, "IndentedText",
 CellTags->"b:2.1.2",
 CellID->7503886],
Cell[CellGroupData[{
Cell[118629, 2588, 265, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:2.1.2",
 CellID->85052122],
Cell[118897, 2597, 633, 17, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->224531539]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[119591, 2621, 101, 2, 70, "Section",
 CellTags->{"i:12", "b:2.1.2", "net: 5"},
 CellID->357167471],
Cell[119695, 2625, 239, 6, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->312098361],
Cell[119937, 2633, 468, 11, 70, "Program",
 CellTags->"b:2.1.2",
 CellID->32294106],
Cell[120408, 2646, 103, 2, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->424973750],
Cell[120514, 2650, 295, 10, 70, "Program",
 CellTags->"b:2.1.2",
 CellID->248607942],
Cell[120812, 2662, 235, 6, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->359183696],
Cell[121050, 2670, 757, 20, 70, "Program",
 CellTags->"b:2.1.2",
 CellID->41191271],
Cell[121810, 2692, 103, 2, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->670691877],
Cell[121916, 2696, 406, 14, 70, "Program",
 CellTags->"b:2.1.2",
 CellID->247703598],
Cell[122325, 2712, 331, 10, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->448526262],
Cell[122659, 2724, 1101, 31, 70, "Program",
 CellTags->"b:2.1.2",
 CellID->34815273],
Cell[123763, 2757, 103, 2, 70, "Text",
 CellTags->"b:2.1.2",
 CellID->360167342],
Cell[123869, 2761, 37492, 619, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:2.1.2",
 CellID->480183068],
Cell[CellGroupData[{
Cell[161386, 3384, 72, 1, 70, "RelatedTutorialsSection",
 CellID->787350899],
Cell[161461, 3387, 214, 5, 70, "RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[161714, 3397, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

