(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9717,        312]
NotebookOptionsPosition[      5800,        197]
NotebookOutlinePosition[      9094,        289]
CellTagsIndexPosition[      8940,        280]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mounting a CD on Unix and Linux", "Title",
 CellTags->{"b:8.0", "net: 1", "i:1"},
 CellID->25163392],

Cell[TextData[{
 "When installing ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on a Unix or Linux system, you may need to mount the CD. On some systems, \
such as Solaris and some Linux platforms, there is a daemon running in the \
background that will automatically mount the CD. For systems that do not have \
such a daemon, you must mount the CD manually. You may need ",
 StyleBox["root", "InlineCode"],
 " privileges in order to give the ",
 StyleBox["mount", "InlineCode"],
 " command. "
}], "Text",
 CellTags->"b:8.0",
 CellID->197811929],

Cell[TextData[{
 "Following are typical ",
 StyleBox["mount", "InlineCode"],
 " commands for various systems. The name of the device representing the \
CD-ROM is different on different systems. To determine the device name, \
consult the documentation for your platform. In the following commands, the \
CD mount point (represented by ",
 "/",
 StyleBox["cdrom", "TI"],
 ") could be different for your platform. Common CD mount points are ",
 StyleBox["/cdrom", "InlineCode"],
 " and ",
 StyleBox["/mnt/cdrom", "InlineCode"],
 "."
}], "Text",
 CellTags->{"b:8.0", "i:3"},
 CellID->209812623],

Cell[BoxData[GridBox[{
   {"AIX", 
    RowBox[{"mount", "-", "r", " ", "-", 
     RowBox[{"v", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"cdrfs", " ", "/", "dev"}], "/", 
        StyleBox["device", "TI"]}], 
       StyleBox["   ", "TI"], "/", 
       StyleBox["cdrom", "TI"]}]}]}]},
   {
    RowBox[{"HP", " ", "Tru64"}], 
    RowBox[{"mount", "-", "r", " ", "-", 
     RowBox[{"t", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"cdfs", " ", "/", "dev"}], "/", 
        StyleBox["device", "TI"]}], 
       StyleBox["   ", "TI"], "/", 
       StyleBox["cdrom", "TI"]}]}]}]},
   {"\[ThickSpace]", "or"},
   {"\[ThickSpace]", 
    RowBox[{"mount", "-", "orrip", " ", "-", 
     RowBox[{"t", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"cdfs", " ", "/", "dev"}], "/", 
        StyleBox["device", "TI"]}], 
       StyleBox["   ", "TI"], "/", 
       StyleBox["cdrom", "TI"]}]}]}]},
   {
    RowBox[{"HP", "-", "UX"}], 
    RowBox[{"pfs_mount", "-", 
     RowBox[{"t", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"rrip", " ", "/", "dev"}], "/", 
        StyleBox["device", "TI"]}], 
       StyleBox["   ", "TI"], "/", 
       StyleBox["cdrom", "TI"]}]}]}]},
   {"IRIX", 
    RowBox[{"mount", "-", "r", " ", "-", 
     RowBox[{"t", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"iso9660", " ", "/", "dev"}], "/", 
        StyleBox["device", "TI"]}], 
       StyleBox["  ", "TI"], "/", 
       StyleBox["cdrom", "TI"]}]}]}]},
   {"Linux", 
    RowBox[{"mount", "-", "r", " ", "-", 
     RowBox[{"t", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"iso9660", " ", "/", "dev"}], "/", 
        StyleBox["device", "TI"]}], 
       StyleBox["   ", "TI"], "/", 
       StyleBox["cdrom", "TI"]}]}]}]},
   {"\[ThickSpace]", "or"},
   {"\[ThickSpace]", 
    RowBox[{"mount", "-", 
     RowBox[{
      RowBox[{
       RowBox[{"r", " ", "/", "dev"}], "/", 
       StyleBox["device", "TI"]}], 
      StyleBox["   ", "TI"], "/", 
      StyleBox["cdrom", "TI"]}]}]},
   {"Solaris", 
    RowBox[{"mount", "-", "r", " ", "-", 
     RowBox[{"F", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"hsfs", " ", "/", "dev"}], "/", 
        StyleBox["device", "TI"]}], 
       StyleBox["   ", "TI"], "/", 
       StyleBox["cdrom", "TI"]}]}]}]}
  },
  GridBoxAlignment->{
   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "DefinitionBox",
 GridBoxOptions->{GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[1.4]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}},
 CellTags->"b:8.0",
 CellID->824680323],

Cell[TextData[{
 "Typical ",
 StyleBox["mount", "InlineCode"],
 " commands for mounting the CD on various Unix platforms."
}], "Caption",
 CellTags->"b:8.0",
 CellID->426594658],

Cell[TextData[{
 "If the filenames on the CD appear in the wrong case, it means the CD is \
mounted incorrectly. Note that on HP-UX you must use the command ",
 StyleBox["pfs_mount", "InlineCode"],
 " instead of ",
 StyleBox["mount", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:8.0",
 CellID->278616990],

Cell[TextData[{
 "After you have finished using the CD, you must unmount it. Typically, the \
unmount command is ",
 StyleBox["umount", "InlineCode"],
 " /",
 StyleBox["cdrom", "TI"],
 ". Before unmounting the CD make sure that no programs are running from the \
CD, no files are open, and no users have a directory on the CD as their \
current working directory."
}], "Text",
 CellTags->{"b:8.0", "i:2"},
 CellID->723023871]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mounting a CD on Unix and Linux - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 32.2584078}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "When installing MathLM and Mathematica on a Unix or Linux system, you \
may need to mount the CD. On some systems, such as Solaris and some Linux \
platforms, there is a daemon running in the background that will \
automatically mount the CD. For systems that do not have such a daemon, you \
must mount the CD manually. You may need root privileges in order to give the \
mount command. Following are typical mount commands for various systems. The \
name of the device representing the CD-ROM is different on different systems. \
To determine the device name, consult the documentation for your platform. In \
the following commands, the CD mount point (represented by /cdrom) could be \
different for your platform. Common CD mount points are /cdrom and \
/mnt/cdrom. Typical mount commands for mounting the CD on various Unix \
platforms.", "synonyms" -> {}, "title" -> "Mounting a CD on Unix and Linux", 
    "type" -> "Tutorial", "uri" -> "tutorial/MountingACDOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:8.0"->{
  Cell[728, 29, 106, 2, 70, "Title",
   CellTags->{"b:8.0", "net: 1", "i:1"},
   CellID->25163392],
  Cell[837, 33, 684, 19, 70, "Text",
   CellTags->"b:8.0",
   CellID->197811929],
  Cell[1524, 54, 591, 16, 70, "Text",
   CellTags->{"b:8.0", "i:3"},
   CellID->209812623],
  Cell[2118, 72, 2724, 88, 70, "DefinitionBox",
   CellTags->"b:8.0",
   CellID->824680323],
  Cell[4845, 162, 177, 6, 70, "Caption",
   CellTags->"b:8.0",
   CellID->426594658],
  Cell[5025, 170, 305, 9, 70, "Text",
   CellTags->"b:8.0",
   CellID->278616990],
  Cell[5333, 181, 425, 11, 70, "Text",
   CellTags->{"b:8.0", "i:2"},
   CellID->723023871]},
 "net: 1"->{
  Cell[728, 29, 106, 2, 70, "Title",
   CellTags->{"b:8.0", "net: 1", "i:1"},
   CellID->25163392]},
 "i:1"->{
  Cell[728, 29, 106, 2, 70, "Title",
   CellTags->{"b:8.0", "net: 1", "i:1"},
   CellID->25163392]},
 "i:3"->{
  Cell[1524, 54, 591, 16, 70, "Text",
   CellTags->{"b:8.0", "i:3"},
   CellID->209812623]},
 "i:2"->{
  Cell[5333, 181, 425, 11, 70, "Text",
   CellTags->{"b:8.0", "i:2"},
   CellID->723023871]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:8.0", 7855, 239},
 {"net: 1", 8498, 261},
 {"i:1", 8609, 265},
 {"i:3", 8720, 269},
 {"i:2", 8823, 273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 106, 2, 70, "Title",
 CellTags->{"b:8.0", "net: 1", "i:1"},
 CellID->25163392],
Cell[837, 33, 684, 19, 70, "Text",
 CellTags->"b:8.0",
 CellID->197811929],
Cell[1524, 54, 591, 16, 70, "Text",
 CellTags->{"b:8.0", "i:3"},
 CellID->209812623],
Cell[2118, 72, 2724, 88, 70, "DefinitionBox",
 CellTags->"b:8.0",
 CellID->824680323],
Cell[4845, 162, 177, 6, 70, "Caption",
 CellTags->"b:8.0",
 CellID->426594658],
Cell[5025, 170, 305, 9, 70, "Text",
 CellTags->"b:8.0",
 CellID->278616990],
Cell[5333, 181, 425, 11, 70, "Text",
 CellTags->{"b:8.0", "i:2"},
 CellID->723023871]
}, Open  ]],
Cell[5773, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

