(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21808,        839]
NotebookOptionsPosition[     12599,        532]
NotebookOutlinePosition[     17694,        688]
CellTagsIndexPosition[     17625,        683]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Basic Editing Techniques" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BasicEditingTechniquesOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Basic Editing Techniques\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Moving through Expressions", "Title",
 CellID->392201114],

Cell[CellGroupData[{

Cell["Moving the Cursor by Typing", "Section",
 CellID->688737095],

Cell["\<\
You can use the keyboard to move the cursor forward or backward one character \
or one word at a time. You can also delete the character or word to the right \
or the left of the cursor, and you can move the cursor to the beginning or \
end of a line. \
\>", "Text",
 CellID->667498335]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting out of an Expression", "Section",
 CellID->189944417],

Cell[TextData[{
 "Move to the end of the next-higher subexpression by pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 " and ",
 StyleBox["Space", "KeyEvent"],
 " at the same time. "
}], "Text",
 CellID->1235117077],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " repeatedly."
}], "MathCaption",
 CellID->1035781237],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"2", "+", 
     FractionBox["1", 
      RowBox[{"3", 
       StyleBox["\[VerticalSeparator]",
        FontWeight->"Plain"]}]]}]]}]]], "Input",
 CellTags->"moving",
 CellID->872807677],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", "+", 
      FractionBox["1", "3"]}], "\[VerticalSeparator]"}]]}]]], "Input",
 CellTags->"moving",
 CellID->1965318329],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"1", "+", 
    FractionBox["1", 
     RowBox[{"2", "+", 
      FractionBox["1", "3"]}]]}], 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellTags->"moving",
 CellID->659180996],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "+", 
    FractionBox["1", 
     RowBox[{"2", "+", 
      FractionBox["1", "3"]}]]}]], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellTags->"moving",
 CellID->2134348546]
}, Open  ]],

Cell[CellGroupData[{

Cell["Selecting the Next Placeholder", "Section",
 CellID->429173134],

Cell[TextData[{
 "Select the next placeholder by pressing the ",
 StyleBox["Tab", "KeyEvent"],
 " key. "
}], "Text",
 CellID->1862776512],

Cell[BoxData[
 RowBox[{
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"], 
  RowBox[{
   RowBox[{"(", GridBox[{
      {"a", "\[Placeholder]", "\[Placeholder]"},
      {"\[Placeholder]", "b", "\[Placeholder]"},
      {"\[Placeholder]", "\[Placeholder]", "c"}
     }], ")"}], 
   StyleBox["\[Rule]",
    ShowContents->False]}]}]], "Input",
 CellTags->"moving",
 CellID->1668231218],

Cell[TextData[{
 "Pressing the ",
 StyleBox["Tab", "KeyEvent"],
 " key."
}], "MathCaption",
 CellID->415585694],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]"},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->1131939014],

Cell[TextData[{
 "Press ",
 StyleBox["Tab", "KeyEvent"],
 " repeatedly."
}], "MathCaption",
 CellID->2088863172],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->460670648],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "b", "\[Placeholder]"},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->813033501],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {"\[Placeholder]", "b", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->215605446],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->875818433],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {"\[Placeholder]", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->1027486893],

Cell[TextData[{
 "Select the previous placeholder by pressing ",
 StyleBox["Shift", "KeyEvent"],
 " and ",
 StyleBox["Tab", "KeyEvent"],
 " at the same time."
}], "Text",
 CellID->1056205124],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", GridBox[{
     {"a", "\[Placeholder]", "\[Placeholder]"},
     {"\[Placeholder]", "b", "\[Placeholder]"},
     {"\[Placeholder]", "\[Placeholder]", "c"}
    }], ")"}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"moving",
 CellID->539692966],

Cell[TextData[{
 "Press ",
 StyleBox["Shift", "KeyEvent"],
 " and ",
 StyleBox["Tab", "KeyEvent"],
 " at the same time."
}], "MathCaption",
 CellID->1796238281],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {"\[Placeholder]", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->51679241],

Cell[TextData[{
 "Press ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Tab", "KeyEvent"],
 " repeatedly."
}], "MathCaption",
 CellID->989610099],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->116087878],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {"\[Placeholder]", "b", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->1173814070],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", "\[Placeholder]"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "b", "\[Placeholder]"},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->1508293148],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "\[Placeholder]", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->985969248],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]"},
    {"\[Placeholder]", "b", "\[Placeholder]"},
    {"\[Placeholder]", "\[Placeholder]", "c"}
   }], ")"}]], "Input",
 CellTags->"moving",
 CellID->1201330884]
}, Open  ]],

Cell[CellGroupData[{

Cell["Switching Positions", "Section",
 CellID->126918294],

Cell[TextData[{
 "Move back and forth between complementary positions by pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["5", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 "."
}], "Text",
 CellID->664505787],

Cell["First, alternate between a radicand and an index. ", "MathCaption",
 CellID->1433797709],

Cell[BoxData[
 RadicalBox[
  RowBox[{"x", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}], "n"]], "Input",
 CellTags->"moving",
 CellID->924092176],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->615466928],

Cell[BoxData[
 RadicalBox["x", 
  RowBox[{"n", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellTags->"moving",
 CellID->1871414944],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 ".\[AutoOperand]"
}], "MathCaption",
 CellTags->"moving",
 CellID->825469846],

Cell[BoxData[
 RadicalBox[
  RowBox[{"x", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}], "n"]], "Input",
 CellTags->"moving",
 CellID->927342102],

Cell["Next, alternate between a superscript and a subscript. ", "MathCaption",
 CellTags->"moving",
 CellID->1549882035],

Cell[BoxData[
 SubsuperscriptBox["x", "j", 
  RowBox[{"i", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellTags->"moving",
 CellID->2038207782],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 ".\[AutoOperand]"
}], "MathCaption",
 CellTags->"moving",
 CellID->1646538777],

Cell[BoxData[
 SubsuperscriptBox["x", 
  RowBox[{"j", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}], "i"]], "Input",
 CellTags->"moving",
 CellID->902949797],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 StyleBox[".",
  FontSize->16],
 "\[AutoOperand]"
}], "MathCaption",
 CellTags->"moving",
 CellID->1757788477],

Cell[BoxData[
 SubsuperscriptBox["x", "j", 
  RowBox[{"i", 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellTags->"moving",
 CellID->218401160],

Cell["\<\
Finally, alternate between an overscript and an underscript. \
\>", "MathCaption",
 CellTags->"moving",
 CellID->618743397],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"n", "=", "1"}], 
   RowBox[{"\[Infinity]", 
    StyleBox["\[VerticalSeparator]",
     FontWeight->"Plain"]}]], 
  FractionBox["1", 
   SuperscriptBox["n", "2"]]}]], "Input",
 CellTags->"moving",
 CellID->1104454605],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1867385214],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"n", "=", 
    RowBox[{"1", 
     StyleBox["\[VerticalSeparator]",
      FontWeight->"Plain"]}]}], "\[Infinity]"], 
  FractionBox["1", 
   SuperscriptBox["n", "2"]]}]], "Input",
 CellTags->"moving",
 CellID->1817274440],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 ".\[AutoOperand]"
}], "MathCaption",
 CellTags->"moving",
 CellID->1419085446],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"n", "=", "1"}], 
   RowBox[{"\[Infinity]", 
    StyleBox["\[VerticalSeparator]",
     FontWeight->"Plain"]}]], 
  FractionBox["1", 
   SuperscriptBox["n", "2"]]}]], "Input",
 CellTags->"moving",
 CellID->615707340],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->106449259],

Cell[TextData[ButtonBox["Basic Editing Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BasicEditingTechniquesOverview"]], "RelatedTutorials",
 CellID->46484032]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Moving through Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Basic Editing Techniques", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BasicEditingTechniquesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SelectingAndDeletingInExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 32.4771634}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "You can use the keyboard to move the cursor forward or backward one \
character or one word at a time. You can also delete the character or word to \
the right or the left of the cursor, and you can move the cursor to the \
beginning or end of a line. Move to the end of the next-higher subexpression \
by pressing Ctrl and Space at the same time. Press Ctrl+Space repeatedly.", 
    "synonyms" -> {}, "title" -> "Moving through Expressions", "type" -> 
    "Tutorial", "uri" -> "tutorial/MovingThroughExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "moving"->{
  Cell[2229, 83, 270, 10, 70, "Input",
   CellTags->"moving",
   CellID->872807677],
  Cell[2502, 95, 224, 8, 70, "Input",
   CellTags->"moving",
   CellID->1965318329],
  Cell[2729, 105, 262, 10, 70, "Input",
   CellTags->"moving",
   CellID->659180996],
  Cell[2994, 117, 261, 10, 70, "Input",
   CellTags->"moving",
   CellID->2134348546],
  Cell[3504, 142, 389, 13, 70, "Input",
   CellTags->"moving",
   CellID->1668231218],
  Cell[4010, 164, 285, 9, 70, "Input",
   CellTags->"moving",
   CellID->1131939014],
  Cell[4413, 182, 284, 9, 70, "Input",
   CellTags->"moving",
   CellID->460670648],
  Cell[4700, 193, 284, 9, 70, "Input",
   CellTags->"moving",
   CellID->813033501],
  Cell[4987, 204, 284, 9, 70, "Input",
   CellTags->"moving",
   CellID->215605446],
  Cell[5274, 215, 284, 9, 70, "Input",
   CellTags->"moving",
   CellID->875818433],
  Cell[5561, 226, 285, 9, 70, "Input",
   CellTags->"moving",
   CellID->1027486893],
  Cell[6043, 246, 283, 8, 70, "Input",
   CellTags->"moving",
   CellID->539692966],
  Cell[6492, 265, 283, 9, 70, "Input",
   CellTags->"moving",
   CellID->51679241],
  Cell[6961, 285, 284, 9, 70, "Input",
   CellTags->"moving",
   CellID->116087878],
  Cell[7248, 296, 285, 9, 70, "Input",
   CellTags->"moving",
   CellID->1173814070],
  Cell[7536, 307, 285, 9, 70, "Input",
   CellTags->"moving",
   CellID->1508293148],
  Cell[7824, 318, 284, 9, 70, "Input",
   CellTags->"moving",
   CellID->985969248],
  Cell[8111, 329, 285, 9, 70, "Input",
   CellTags->"moving",
   CellID->1201330884],
  Cell[8916, 362, 163, 6, 70, "Input",
   CellTags->"moving",
   CellID->924092176],
  Cell[9251, 379, 164, 6, 70, "Input",
   CellTags->"moving",
   CellID->1871414944],
  Cell[9418, 387, 201, 8, 70, "MathCaption",
   CellTags->"moving",
   CellID->825469846],
  Cell[9622, 397, 163, 6, 70, "Input",
   CellTags->"moving",
   CellID->927342102],
  Cell[9788, 405, 120, 2, 70, "MathCaption",
   CellTags->"moving",
   CellID->1549882035],
  Cell[9911, 409, 176, 6, 70, "Input",
   CellTags->"moving",
   CellID->2038207782],
  Cell[10090, 417, 202, 8, 70, "MathCaption",
   CellTags->"moving",
   CellID->1646538777],
  Cell[10295, 427, 175, 6, 70, "Input",
   CellTags->"moving",
   CellID->902949797],
  Cell[10473, 435, 233, 10, 70, "MathCaption",
   CellTags->"moving",
   CellID->1757788477],
  Cell[10709, 447, 175, 6, 70, "Input",
   CellTags->"moving",
   CellID->218401160],
  Cell[10887, 455, 133, 4, 70, "MathCaption",
   CellTags->"moving",
   CellID->618743397],
  Cell[11023, 461, 283, 10, 70, "Input",
   CellTags->"moving",
   CellID->1104454605],
  Cell[11479, 482, 286, 10, 70, "Input",
   CellTags->"moving",
   CellID->1817274440],
  Cell[11768, 494, 202, 8, 70, "MathCaption",
   CellTags->"moving",
   CellID->1419085446],
  Cell[11973, 504, 282, 10, 70, "Input",
   CellTags->"moving",
   CellID->615707340]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"moving", 14730, 580}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 646, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1271, 43, 63, 1, 70, "Title",
 CellID->392201114],
Cell[CellGroupData[{
Cell[1359, 48, 66, 1, 70, "Section",
 CellID->688737095],
Cell[1428, 51, 296, 6, 70, "Text",
 CellID->667498335]
}, Open  ]],
Cell[CellGroupData[{
Cell[1761, 62, 67, 1, 70, "Section",
 CellID->189944417],
Cell[1831, 65, 210, 7, 70, "Text",
 CellID->1235117077],
Cell[2044, 74, 182, 7, 70, "MathCaption",
 CellID->1035781237],
Cell[2229, 83, 270, 10, 70, "Input",
 CellTags->"moving",
 CellID->872807677],
Cell[2502, 95, 224, 8, 70, "Input",
 CellTags->"moving",
 CellID->1965318329],
Cell[2729, 105, 262, 10, 70, "Input",
 CellTags->"moving",
 CellID->659180996],
Cell[2994, 117, 261, 10, 70, "Input",
 CellTags->"moving",
 CellID->2134348546]
}, Open  ]],
Cell[CellGroupData[{
Cell[3292, 132, 69, 1, 70, "Section",
 CellID->429173134],
Cell[3364, 135, 137, 5, 70, "Text",
 CellID->1862776512],
Cell[3504, 142, 389, 13, 70, "Input",
 CellTags->"moving",
 CellID->1668231218],
Cell[3896, 157, 111, 5, 70, "MathCaption",
 CellID->415585694],
Cell[4010, 164, 285, 9, 70, "Input",
 CellTags->"moving",
 CellID->1131939014],
Cell[4298, 175, 112, 5, 70, "MathCaption",
 CellID->2088863172],
Cell[4413, 182, 284, 9, 70, "Input",
 CellTags->"moving",
 CellID->460670648],
Cell[4700, 193, 284, 9, 70, "Input",
 CellTags->"moving",
 CellID->813033501],
Cell[4987, 204, 284, 9, 70, "Input",
 CellTags->"moving",
 CellID->215605446],
Cell[5274, 215, 284, 9, 70, "Input",
 CellTags->"moving",
 CellID->875818433],
Cell[5561, 226, 285, 9, 70, "Input",
 CellTags->"moving",
 CellID->1027486893],
Cell[5849, 237, 191, 7, 70, "Text",
 CellID->1056205124],
Cell[6043, 246, 283, 8, 70, "Input",
 CellTags->"moving",
 CellID->539692966],
Cell[6329, 256, 160, 7, 70, "MathCaption",
 CellID->1796238281],
Cell[6492, 265, 283, 9, 70, "Input",
 CellTags->"moving",
 CellID->51679241],
Cell[6778, 276, 180, 7, 70, "MathCaption",
 CellID->989610099],
Cell[6961, 285, 284, 9, 70, "Input",
 CellTags->"moving",
 CellID->116087878],
Cell[7248, 296, 285, 9, 70, "Input",
 CellTags->"moving",
 CellID->1173814070],
Cell[7536, 307, 285, 9, 70, "Input",
 CellTags->"moving",
 CellID->1508293148],
Cell[7824, 318, 284, 9, 70, "Input",
 CellTags->"moving",
 CellID->985969248],
Cell[8111, 329, 285, 9, 70, "Input",
 CellTags->"moving",
 CellID->1201330884]
}, Open  ]],
Cell[CellGroupData[{
Cell[8433, 343, 58, 1, 70, "Section",
 CellID->126918294],
Cell[8494, 346, 322, 11, 70, "Text",
 CellID->664505787],
Cell[8819, 359, 94, 1, 70, "MathCaption",
 CellID->1433797709],
Cell[8916, 362, 163, 6, 70, "Input",
 CellTags->"moving",
 CellID->924092176],
Cell[9082, 370, 166, 7, 70, "MathCaption",
 CellID->615466928],
Cell[9251, 379, 164, 6, 70, "Input",
 CellTags->"moving",
 CellID->1871414944],
Cell[9418, 387, 201, 8, 70, "MathCaption",
 CellTags->"moving",
 CellID->825469846],
Cell[9622, 397, 163, 6, 70, "Input",
 CellTags->"moving",
 CellID->927342102],
Cell[9788, 405, 120, 2, 70, "MathCaption",
 CellTags->"moving",
 CellID->1549882035],
Cell[9911, 409, 176, 6, 70, "Input",
 CellTags->"moving",
 CellID->2038207782],
Cell[10090, 417, 202, 8, 70, "MathCaption",
 CellTags->"moving",
 CellID->1646538777],
Cell[10295, 427, 175, 6, 70, "Input",
 CellTags->"moving",
 CellID->902949797],
Cell[10473, 435, 233, 10, 70, "MathCaption",
 CellTags->"moving",
 CellID->1757788477],
Cell[10709, 447, 175, 6, 70, "Input",
 CellTags->"moving",
 CellID->218401160],
Cell[10887, 455, 133, 4, 70, "MathCaption",
 CellTags->"moving",
 CellID->618743397],
Cell[11023, 461, 283, 10, 70, "Input",
 CellTags->"moving",
 CellID->1104454605],
Cell[11309, 473, 167, 7, 70, "MathCaption",
 CellID->1867385214],
Cell[11479, 482, 286, 10, 70, "Input",
 CellTags->"moving",
 CellID->1817274440],
Cell[11768, 494, 202, 8, 70, "MathCaption",
 CellTags->"moving",
 CellID->1419085446],
Cell[11973, 504, 282, 10, 70, "Input",
 CellTags->"moving",
 CellID->615707340],
Cell[CellGroupData[{
Cell[12280, 518, 72, 1, 70, "RelatedTutorialsSection",
 CellID->106449259],
Cell[12355, 521, 178, 4, 70, "RelatedTutorials",
 CellID->46484032]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[12572, 530, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

