(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35988,       1301]
NotebookOptionsPosition[     27233,        992]
NotebookOutlinePosition[     30167,       1090]
CellTagsIndexPosition[     29849,       1075]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Design of the NDSolve Framework", "Title",
 CellTags->"s:2",
 CellID->575523943],

Cell[CellGroupData[{

Cell["Features", "Section",
 CellTags->"s:2.1",
 CellID->75354863],

Cell["\<\
Supporting a large number of numerical integration methods for differential \
equations is a lot of work.\
\>", "Text",
 CellID->1994558172],

Cell["\<\
In order to cut down on maintenance and duplication of code, common \
components are shared between methods.\
\>", "Text",
 CellID->1642883206],

Cell["\<\
This approach also allows code optimization to be carried out in just a few \
central routines.\
\>", "Text",
 CellID->1379780337],

Cell[TextData[{
 "The principal features of the ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " framework are:"
}], "Text",
 CellID->425803786],

Cell["Uniform design and interface.", "BulletedText",
 CellID->1855165617],

Cell["Code reuse (common code base).", "BulletedText",
 CellID->717850842],

Cell["\<\
Objection orientation (method property specification and communication).\
\>", "BulletedText",
 CellID->2030612929],

Cell["Data hiding.", "BulletedText",
 CellID->1764125149],

Cell["\<\
Separation of method initialization phase and run-time computation.\
\>", "BulletedText",
 CellID->944163580],

Cell["Numerical methods are hierarchical and reentrant.", "BulletedText",
 CellID->1200751644],

Cell[TextData[{
 "Uniform treatment of rounding errors (see [",
 ButtonBox["HLW02",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#2433"],
 "], [",
 ButtonBox["SS03",
  BaseStyle->"Hyperlink",
  ButtonData:>{"NDSolveReferences.nb", "SS03"}],
 "] and the references therein)."
}], "BulletedText",
 CellID->1399725438],

Cell[TextData[{
 "Vectorized framework based on a generalization of the BLAS model [",
 ButtonBox["LAPACK99",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#18138"],
 "] using optimized in-place arithmetic."
}], "BulletedText",
 CellID->655510672],

Cell[TextData[{
 "Many schemes such as ",
 StyleBox["ExplicitRungeKutta", "MR"],
 " and",
 " ",
 StyleBox["ImplicitRungeKutta", "MR"],
 " use a tensor framework that allows families of methods to share one \
implementation."
}], "BulletedText",
 CellID->152402202],

Cell["All methods are type and precision dynamic.", "BulletedText",
 CellID->492514806],

Cell["\<\
Plug-in capabilities allow user extensibility and prototyping.\
\>", "BulletedText",
 CellID->667408182],

Cell["Specialized data structures.", "BulletedText",
 CellID->901444173]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common time stepping", "Section",
 CellTags->"s:2.2",
 CellID->1791028983],

Cell["\<\
A common time stepping mechanism is used for all one-step methods. The \
routine handles a number of different criteria including:\
\>", "Text",
 CellID->1533871087],

Cell["\<\
step sizes in a numerical integration do not become too small in value, which \
may happen in solving stiff systems\
\>", "BulletedText",
 CellID->1804383111],

Cell["\<\
step sizes do not change sign unexpectedly, which may be a consequence of \
user programming error\
\>", "BulletedText",
 CellID->1247110769],

Cell["step sizes are not increased after a step rejection", "BulletedText",
 CellID->1292447415],

Cell["\<\
step sizes are not decreased drastically towards the end of an integration\
\>", "BulletedText",
 CellID->747505215],

Cell["\<\
specified (or detected) singularities are handled by restarting the \
integration\
\>", "BulletedText",
 CellID->1954177199],

Cell["\<\
divergence of iterations in implicit methods (e.g. using fixed large step \
sizes)\
\>", "BulletedText",
 CellID->791091763],

Cell["unrecoverable integration errors (e.g. numerical exceptions)", \
"BulletedText",
 CellID->2058559829],

Cell["\<\
rounding error feedback (compensated summation) is particularly advantageous \
for high order methods or methods that conserve specific quantities during \
the numerical integration.\
\>", "BulletedText",
 CellID->276853705]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data encapsulation", "Section",
 CellTags->"s:2.3",
 CellID->587411179],

Cell[TextData[{
 "Each method has its own data object that contains information that is \
needed for the invocation of the method. This includes, but is not limited \
to, coefficients, workspaces, step size control parameters, step size \
acceptance/rejection information, and Jacobian matrices. This is a \
generalization of the ideas used in codes like LSODA ([",
 ButtonBox["H83",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#18460"],
 "], [",
 ButtonBox["P83",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#2690"],
 "])."
}], "Text",
 CellID->1277749363]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method hierarchy", "Section",
 CellTags->"s:2.4",
 CellID->154961554],

Cell[TextData[{
 "Methods are reentrant and hierarchical, meaning that one method can call \
another. This is a generalization of the ideas used in the Generic ODE \
Solving System, Godess (see [",
 ButtonBox["O95",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#6718"],
 "], [",
 ButtonBox["O98",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#25038"],
 "] and the references therein), which is implemented in C++."
}], "Text",
 CellID->1162935122],

Cell[CellGroupData[{

Cell["Initial design", "Subsection",
 CellID->1353104226],

Cell["\<\
The original method framework design allowed a number of methods to be \
invoked in the solver.\
\>", "Text",
 CellID->2036078],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["NDSolve", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " ",
 "\[LongRightArrow]",
 " ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["ExplicitRungeKutta", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text",
 CellID->658334680],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["NDSolve", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " ",
 "\[LongRightArrow]",
 " ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["ImplicitRungeKutta", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text",
 CellID->585400916]
}, Open  ]],

Cell[CellGroupData[{

Cell["First revision", "Subsection",
 CellID->427839864],

Cell["\<\
This was later extended to allow one method to call another in a sequential \
fashion, with an arbitrary number of levels of nesting.\
\>", "Text",
 CellID->366016649],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["NDSolve", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " \[LongRightArrow] ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["Extrapolation", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " ",
 "\[LongRightArrow]",
 " ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["ExplicitMidpoint", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text",
 CellID->1303251758],

Cell["\<\
The construction of compound integration methods is particularly useful in \
geometric numerical integration.\
\>", "Text",
 CellID->310969145],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["NDSolve", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " ",
 "\[LongRightArrow]",
 " ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["Projection", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " \[LongRightArrow] ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["ExplicitRungeKutta", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]]
}], "Text",
 CellID->2130141798]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second revision", "Subsection",
 CellID->99931690],

Cell["\<\
A more general tree invocation process was required to implement composition \
methods:\
\>", "Text",
 CellID->1511720789],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["NDSolve", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[GridBox[{
     {"\[LongRightArrow]", 
      RowBox[{
       FrameBox[
        StyleBox["Composition", "MR"],
        FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], " ", 
       FormBox[GridBox[{
          {"\[UpperRightArrow]", 
           FrameBox[
            StyleBox["ExplicitEuler", "MR"],
            FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}]},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]"},
          {"\[LongRightArrow]", GridBox[{
             {
              FrameBox[
               StyleBox["ImplicitEuler", "MR"],
               FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
            }]},
          {"\[VerticalEllipsis]", "\[VerticalEllipsis]"},
          {"\[LowerRightArrow]", GridBox[{
             {
              FrameBox[
               StyleBox["ExplicitEuler", "MR"],
               FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
            }]}
         }],
        TraditionalForm]}]}
    }], TraditionalForm]]]
}], "Text",
 CellID->1382383588],

Cell["This is an example of a method composed with its adjoint.", "Text",
 CellID->755442362]
}, Open  ]],

Cell[CellGroupData[{

Cell["Current state", "Subsection",
 CellID->1664122991],

Cell["\<\
The tree invocation process was extended to allow for a subfield to be solved \
by each method, instead of the entire vector field.\
\>", "Text",
 CellID->1874898394],

Cell[TextData[{
 "This example turns up in the ABC flow (see \"",
 ButtonBox["Composition and Splitting Methods for NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveSplitting"],
 "\")."
}], "Text",
 CellID->1422850545],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FrameBox[
    StyleBox["NDSolve", "MR"],
    FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[GridBox[{
     {"\[LongRightArrow]", 
      RowBox[{
       FrameBox[
        RowBox[{
         RowBox[{
          StyleBox["Splitting", "MR"], 
          StyleBox[" ", "Text"], 
          StyleBox["f", "Text"]}], 
         StyleBox["=", "Text"], 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "Text"], "1"], "+", 
          SubscriptBox["f", "2"]}]}],
        FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], " ", " ", 
       FormBox[GridBox[{
          {"\[UpperRightArrow]", 
           FrameBox[
            RowBox[{
             StyleBox["LocallyExact", "MR"], "  ", 
             SubscriptBox["f", "1"]}],
            FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}]},
          {"\[LongRightArrow]", GridBox[{
             {
              FrameBox[
               RowBox[{
                StyleBox["ImplicitMidpoint", "MR"], " ", 
                SubscriptBox["f", "2"]}],
               FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
            }]},
          {"\[LowerRightArrow]", GridBox[{
             {
              FrameBox[
               RowBox[{
                StyleBox["LocallyExact", "MR"], " ", 
                SubscriptBox["f", "1"]}],
               FrameMargins->{{0.2, 0.2}, {0.4, 0.4}}], ""}
            }]}
         }],
        TraditionalForm]}]}
    }], TraditionalForm]]]
}], "Text",
 CellID->418083517]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["User extensibility", "Section",
 CellTags->"s:2.5",
 CellID->1518443729],

Cell["\<\
Built-in methods can be used as building blocks for the efficient \
construction of special purpose (compound) integrators. User defined methods \
can also be added.\
\>", "Text",
 CellID->809237984]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method classes", "Section",
 CellTags->"s:2.6",
 CellID->74982980],

Cell[TextData[{
 "Methods such as ",
 StyleBox["ExplicitRungeKutta", "MR"],
 " include a number of schemes of different orders. Moreover, alternative \
coefficient choices can be specified by the user. This is a generalization of \
the ideas found in RKSUITE [",
 ButtonBox["BGS93",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#6300"],
 "]."
}], "Text",
 CellID->618070850]
}, Open  ]],

Cell[CellGroupData[{

Cell["Automatic selection and user controllability", "Section",
 CellTags->"s:2.7",
 CellID->2101685400],

Cell["\<\
The framework provides automatic step size selection and method order \
selection. Methods are user configurable via method options.\
\>", "Text",
 CellID->822488195],

Cell[TextData[{
 "For example a user can select the class of ",
 StyleBox["ExplicitRungeKutta", "MR"],
 " methods and the code will automatically attempt to ascertain the \"optimal\
\" order according to problem, the relative and absolute local error \
tolerances, and the initial step size estimate."
}], "Text",
 CellID->424764402],

Cell[TextData[{
 "Here is a list of options appropriate for ",
 StyleBox["ExplicitRungeKutta", "MR"],
 "."
}], "Text",
 CellID->745293515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "NDSolve`ExplicitRungeKutta", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->733564376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Coefficients\"\>", 
    "\[Rule]", "\<\"EmbeddedExplicitRungeKuttaCoefficients\"\>"}], ",", 
   RowBox[{"\<\"DifferenceOrder\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"EmbeddedDifferenceOrder\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"StepSizeControlParameters\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"StepSizeRatioBounds\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", "8"], ",", "4"}], "}"}]}], ",", 
   RowBox[{"\<\"StepSizeSafetyFactors\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"StiffnessTest\"\>", "\[Rule]", "Automatic"}]}], 
  "}"}]], "Output",
 ImageSize->{476, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1705164643]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shared features", "Section",
 CellTags->"s:2.8",
 CellID->1332704694],

Cell[TextData[{
 "These features are not necessarily restricted to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " since they can also be used for other types of numerical methods."
}], "Text",
 CellID->2011313739],

Cell[TextData[{
 "Function evaluation is performed using a ",
 StyleBox["NumericalFunction", "MR"],
 " that dynamically changes type as needed, such as when IEEE floating point \
overflow or underflow occurs. It also calls ",
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s compiler ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " for efficiency when appropriate."
}], "BulletedText",
 CellID->856579661],

Cell["\<\
Jacobian evaluation uses symbolic differentiation or finite difference \
approximations, including automatic or user specifiable sparsity detection.\
\>", "BulletedText",
 CellID->348156168],

Cell["\<\
Dense linear algebra is based on LAPACK and sparse linear algebra uses \
special purpose packages such as UMFPACK.\
\>", "BulletedText",
 CellID->1216934318],

Cell["\<\
Common subexpressions in the numerical evaluation of the function \
representing a differential system are detected and collected to avoid \
repeated work.\
\>", "BulletedText",
 CellID->858615739],

Cell[CellGroupData[{

Cell[TextData[{
 "Other supporting functionality that has been implemented is described in \
\"",
 ButtonBox["Norms in NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveVectorNorm"],
 "\"."
}], "BulletedText",
 CellID->1006490849],

Cell["\<\
This system dynamically switches type from real to complex during the \
numerical integration, automatically recompiling as needed.\
\>", "Text",
 CellID->1802335234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "/.", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"y", "[", "t", "]"}], "]"}], "-", "1"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
       RowBox[{"1", "/", "10"}]}]}], "}"}], ",", "y", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "ExplicitRungeKutta"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1286455603],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.34904262534543373`"}], "+", 
   RowBox[{"0.15044127076168856`", " ", "\[ImaginaryI]"}]}], "}"}]], "Output",\

 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1216665508]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some basic methods", "Section",
 CellTags->"s:2.9",
 CellID->958103344],

Cell["\<\
The following table gives some of the one-step methods that have been \
implemented:\
\>", "Text",
 CellID->1597424748],

Cell[BoxData[GridBox[{
   {Cell["Order", "TableText"], Cell["Method", "TableText"], Cell[
    "Formula", "TableText"]},
   {Cell["1", "TableText"], Cell["Explicit Euler", "TableText"], Cell[
    TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"n", "+", "1"}]], "=", 
       RowBox[{
        SubscriptBox["y", "n"], "+", 
        RowBox[{
         SubscriptBox["h", "n"], 
         RowBox[{"f", "(", 
          RowBox[{
           SubscriptBox["t", "n"], ",", 
           SubscriptBox["y", "n"]}], ")"}]}]}]}], TraditionalForm]], "Text"]],
      "TableText"]},
   {Cell["2", "TableText"], Cell["Explicit Midpoint", "TableText"], Cell[
    TextData[Cell[BoxData[{
     FormBox[
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"n", "+", 
         RowBox[{"1", "/", "2"}]}]], "=", " ", 
       RowBox[{
        SubscriptBox["y", "n"], "+", " ", 
        RowBox[{
         FractionBox[
          SubscriptBox["h", "n"], "2"], 
         RowBox[{"f", "(", 
          RowBox[{
           SubscriptBox["t", "n"], ",", 
           SubscriptBox["y", "n"]}], ")"}]}]}]}], TraditionalForm], "\n", 
     FormBox[
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"n", "+", "1"}]], "=", " ", 
       RowBox[{
        SubscriptBox["y", "n"], "+", " ", 
        RowBox[{
         SubscriptBox["h", "n"], 
         RowBox[{"f", "(", 
          RowBox[{
           SubscriptBox["t", 
            RowBox[{"n", "+", 
             RowBox[{"1", "/", "2"}]}]], ",", 
           SubscriptBox["y", 
            RowBox[{"n", "+", 
             RowBox[{"1", "/", "2"}]}]]}], ")"}]}]}]}], TraditionalForm]}], 
     "InlineMath"]], "TableText"]},
   {Cell["1", "TableText"], Cell[
    "Backward or Implicit Euler (1 stage RadauIIA)", "TableText"], Cell[
    TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"n", "+", "1"}]], "=", " ", 
       RowBox[{
        SubscriptBox["y", "n"], "+", " ", 
        RowBox[{
         SubscriptBox["h", "n"], 
         RowBox[{"f", "(", 
          RowBox[{
           SubscriptBox["t", 
            RowBox[{"n", "+", "1"}]], ",", 
           SubscriptBox["y", 
            RowBox[{"n", "+", "1"}]]}], ")"}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["2", "TableText"], Cell[
    "Implicit Midpoint (1 stage Gauss)", "TableText"], Cell[TextData[Cell[
    BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"n", "+", "1"}]], "=", 
       RowBox[{
        SubscriptBox["y", "n"], "+", " ", 
        RowBox[{
         SubscriptBox["h", "n"], " ", 
         RowBox[{"f", "(", 
          RowBox[{
           SubscriptBox["t", 
            RowBox[{"n", "+", 
             RowBox[{"1", "/", "2"}]}]], ",", 
           RowBox[{
            FractionBox["1", "2"], 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["y", 
               RowBox[{"n", "+", "1"}]], "+", " ", 
              SubscriptBox["y", "n"]}], ")"}]}]}], ")"}]}]}]}], 
      TraditionalForm]], "InlineMath"]], "TableText"]},
   {Cell["2", "TableText"], Cell[
    "Trapezoidal (2 stage Lobatto IIIA)", "TableText"], Cell[TextData[Cell[
    BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["y", 
        RowBox[{"n", "+", "1"}]], "=", 
       RowBox[{
        SubscriptBox["y", "n"], "+", 
        RowBox[{
         FractionBox[
          SubscriptBox["h", "n"], "2"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"f", "(", 
            RowBox[{
             SubscriptBox["t", "n"], ",", 
             SubscriptBox["y", "n"]}], ")"}], "+", 
           RowBox[{"f", "(", 
            RowBox[{
             SubscriptBox["t", 
              RowBox[{"n", "+", "1"}]], ",", 
             SubscriptBox["y", 
              RowBox[{"n", "+", "1"}]]}], ")"}]}], ")"}]}]}]}], 
      TraditionalForm]], "InlineMath"]], "TableText"]},
   {Cell["1", "TableText"], Cell["Linearly Implicit Euler", "TableText"], 
    Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "-", 
          RowBox[{
           SubscriptBox["h", "n"], "J"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["y", 
           RowBox[{"n", "+", "1"}]], "-", 
          SubscriptBox["y", "n"]}], ")"}]}], " ", "=", " ", 
       RowBox[{
        SubscriptBox["h", "n"], 
        RowBox[{"f", "(", 
         RowBox[{
          SubscriptBox["t", "n"], ",", 
          SubscriptBox["y", "n"]}], ")"}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {Cell["2", "TableText"], Cell["Linearly Implicit Midpoint", "TableText"], 
    Cell[TextData[Cell[BoxData[{
     FormBox[
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", "-", 
          RowBox[{
           FractionBox[
            SubscriptBox["h", "n"], "2"], "J"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["y", 
           RowBox[{"n", "+", 
            RowBox[{"1", "/", "2"}]}]], "-", 
          SubscriptBox["y", "n"]}], ")"}]}], " ", "=", " ", 
       RowBox[{
        FractionBox[
         SubscriptBox["h", "n"], "2"], 
        RowBox[{"f", "(", 
         RowBox[{
          SubscriptBox["t", "n"], ",", 
          SubscriptBox["y", "n"]}], ")"}]}]}], TraditionalForm], "\n", 
     FormBox[
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"I", " ", "-", " ", 
          RowBox[{
           FractionBox[
            SubscriptBox["h", "n"], "2"], "J"}]}], ")"}], " ", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[CapitalDelta]y", "n"], "-", 
           SubscriptBox["\[CapitalDelta]y", 
            RowBox[{"n", "-", 
             RowBox[{"1", "/", "2"}]}]]}], ")"}], "2"]}], "=", " ", 
       RowBox[{
        RowBox[{
         FractionBox[
          SubscriptBox["h", "n"], "2"], 
         RowBox[{"f", "(", 
          RowBox[{
           SubscriptBox["t", 
            RowBox[{"n", "+", 
             RowBox[{"1", "/", "2"}]}]], ",", 
           SubscriptBox["y", 
            RowBox[{"n", "+", 
             RowBox[{"1", "/", "2"}]}]]}], ")"}]}], "-", 
        SubscriptBox["\[CapitalDelta]y", 
         RowBox[{"n", "-", 
          RowBox[{"1", "/", "2"}]}]]}]}], TraditionalForm]}], "InlineMath"]], 
     "TableText"]}
  },
  GridBoxDividers->{"Rows" -> {False, 
      AbsoluteThickness[0.5], {False}, False}},
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.1], 
      Scaled[0.3], {
       Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}]], "DefinitionBox3Col",
 CellID->81128075],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalDelta]y", "n"], "=", " ", 
    RowBox[{
     SubscriptBox["y", 
      RowBox[{"n", "+", "1"}]], "-", " ", 
     SubscriptBox["y", 
      RowBox[{"n", "+", 
       RowBox[{"1", "/", "2"}]}]]}]}], TraditionalForm]]],
 ", I denotes the identity matrix and J denotes the Jacobian matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", "f"}], 
     RowBox[{"\[PartialD]", "y"}]], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["t", "n"], ",", 
      SubscriptBox["y", "n"]}], ")"}]}], TraditionalForm]]]
}], "Text",
 CellID->1058035034],

Cell[TextData[{
 "Although the implicit midpoint method has not been implemented as a \
separate method, it is available through the one stage Gauss scheme of the ",
 StyleBox["ImplicitRungeKutta", "MR"],
 " method."
}], "Text",
 CellID->961661889]
}, Open  ]],

Cell[CellGroupData[{

Cell["Acknowledgements", "Section",
 CellTags->"s:2.10",
 CellID->590065589],

Cell[TextData[{
 "A number of people have helped in shaping the design and implementation of \
the methods and framework in ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ". We would like to thank them for sharing their experience and their \
enthusiasm for the project."
}], "Text",
 CellID->1813477396],

Cell["\<\
Thanks to Giulia Spaletta who collaborated in the development of a number of \
methods.\
\>", "Text",
 CellID->478301233],

Cell["\<\
Thanks to Alan Hindmarsh for allowing us to use the codes LSODA, CVODE and \
IDA.\
\>", "Text",
 CellID->317480336],

Cell["Thanks to Steven Lee for constructive feedback.", "Text",
 CellID->1088844293],

Cell["\<\
Thanks also to the following people for fruitful discussions: John Butcher, \
Jeff Cash, Ernst Hairer, Robert McLachlan, Per Christian Moan, Reinout \
Quispel.\
\>", "Text",
 CellID->896384750],

Cell[TextData[{
 "Aspects of the new framework have been presented at various symposia and \
workshops over the years. We would particularly like to thank the groups at \
",
 ButtonBox["Bergen and Trondheim, Norway,",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.math.ntnu.no/num/synode/people.php"], None}],
 " and ",
 ButtonBox["Bari, Italy",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.dm.uniba.it/%7Edelbuono/homegnig.htm"], None}],
 "."
}], "Text",
 CellID->1835924065],

Cell["\<\
Thanks also to Andrew Hunt of Wolfram Research for a number of stylistic \
improvements to the documentation.\
\>", "Text",
 CellID->1898082278]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Design of the NDSolve Framework - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 41.5086446}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Supporting a large number of numerical integration methods for \
differential equations is a lot of work. In order to cut down on maintenance \
and duplication of code, common components are shared between methods. This \
approach also allows code optimization to be carried out in just a few \
central routines.", "synonyms" -> {}, "title" -> 
    "The Design of the NDSolve Framework", "type" -> "Tutorial", "uri" -> 
    "tutorial/NDSolveDesign"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "s:2"->{
  Cell[728, 29, 90, 2, 70, "Title",
   CellTags->"s:2",
   CellID->575523943]},
 "s:2.1"->{
  Cell[843, 35, 66, 2, 70, "Section",
   CellTags->"s:2.1",
   CellID->75354863]},
 "s:2.2"->{
  Cell[3344, 136, 80, 2, 70, "Section",
   CellTags->"s:2.2",
   CellID->1791028983]},
 "s:2.3"->{
  Cell[4813, 192, 77, 2, 70, "Section",
   CellTags->"s:2.3",
   CellID->587411179]},
 "s:2.4"->{
  Cell[5537, 216, 75, 2, 70, "Section",
   CellTags->"s:2.4",
   CellID->154961554]},
 "s:2.5"->{
  Cell[12110, 475, 78, 2, 70, "Section",
   CellTags->"s:2.5",
   CellID->1518443729]},
 "s:2.6"->{
  Cell[12437, 489, 72, 2, 70, "Section",
   CellTags->"s:2.6",
   CellID->74982980]},
 "s:2.7"->{
  Cell[12947, 509, 104, 2, 70, "Section",
   CellTags->"s:2.7",
   CellID->2101685400]},
 "s:2.8"->{
  Cell[14727, 568, 75, 2, 70, "Section",
   CellTags->"s:2.8",
   CellID->1332704694]},
 "s:2.9"->{
  Cell[17683, 677, 77, 2, 70, "Section",
   CellTags->"s:2.9",
   CellID->958103344]},
 "s:2.10"->{
  Cell[25498, 927, 76, 2, 70, "Section",
   CellTags->"s:2.10",
   CellID->590065589]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"s:2", 28757, 1028},
 {"s:2.1", 28849, 1032},
 {"s:2.2", 28944, 1036},
 {"s:2.3", 29043, 1040},
 {"s:2.4", 29141, 1044},
 {"s:2.5", 29239, 1048},
 {"s:2.6", 29339, 1052},
 {"s:2.7", 29437, 1056},
 {"s:2.8", 29538, 1060},
 {"s:2.9", 29638, 1064},
 {"s:2.10", 29738, 1068}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 90, 2, 70, "Title",
 CellTags->"s:2",
 CellID->575523943],
Cell[CellGroupData[{
Cell[843, 35, 66, 2, 70, "Section",
 CellTags->"s:2.1",
 CellID->75354863],
Cell[912, 39, 150, 4, 70, "Text",
 CellID->1994558172],
Cell[1065, 45, 153, 4, 70, "Text",
 CellID->1642883206],
Cell[1221, 51, 140, 4, 70, "Text",
 CellID->1379780337],
Cell[1364, 57, 218, 8, 70, "Text",
 CellID->425803786],
Cell[1585, 67, 74, 1, 70, "BulletedText",
 CellID->1855165617],
Cell[1662, 70, 74, 1, 70, "BulletedText",
 CellID->717850842],
Cell[1739, 73, 125, 3, 70, "BulletedText",
 CellID->2030612929],
Cell[1867, 78, 57, 1, 70, "BulletedText",
 CellID->1764125149],
Cell[1927, 81, 119, 3, 70, "BulletedText",
 CellID->944163580],
Cell[2049, 86, 94, 1, 70, "BulletedText",
 CellID->1200751644],
Cell[2146, 89, 339, 11, 70, "BulletedText",
 CellID->1399725438],
Cell[2488, 102, 270, 7, 70, "BulletedText",
 CellID->655510672],
Cell[2761, 111, 264, 9, 70, "BulletedText",
 CellID->152402202],
Cell[3028, 122, 87, 1, 70, "BulletedText",
 CellID->492514806],
Cell[3118, 125, 114, 3, 70, "BulletedText",
 CellID->667408182],
Cell[3235, 130, 72, 1, 70, "BulletedText",
 CellID->901444173]
}, Open  ]],
Cell[CellGroupData[{
Cell[3344, 136, 80, 2, 70, "Section",
 CellTags->"s:2.2",
 CellID->1791028983],
Cell[3427, 140, 175, 4, 70, "Text",
 CellID->1533871087],
Cell[3605, 146, 168, 4, 70, "BulletedText",
 CellID->1804383111],
Cell[3776, 152, 151, 4, 70, "BulletedText",
 CellID->1247110769],
Cell[3930, 158, 96, 1, 70, "BulletedText",
 CellID->1292447415],
Cell[4029, 161, 126, 3, 70, "BulletedText",
 CellID->747505215],
Cell[4158, 166, 134, 4, 70, "BulletedText",
 CellID->1954177199],
Cell[4295, 172, 134, 4, 70, "BulletedText",
 CellID->791091763],
Cell[4432, 178, 107, 2, 70, "BulletedText",
 CellID->2058559829],
Cell[4542, 182, 234, 5, 70, "BulletedText",
 CellID->276853705]
}, Open  ]],
Cell[CellGroupData[{
Cell[4813, 192, 77, 2, 70, "Section",
 CellTags->"s:2.3",
 CellID->587411179],
Cell[4893, 196, 607, 15, 70, "Text",
 CellID->1277749363]
}, Open  ]],
Cell[CellGroupData[{
Cell[5537, 216, 75, 2, 70, "Section",
 CellTags->"s:2.4",
 CellID->154961554],
Cell[5615, 220, 495, 13, 70, "Text",
 CellID->1162935122],
Cell[CellGroupData[{
Cell[6135, 237, 57, 1, 70, "Subsection",
 CellID->1353104226],
Cell[6195, 240, 137, 4, 70, "Text",
 CellID->2036078],
Cell[6335, 246, 361, 15, 70, "Text",
 CellID->658334680],
Cell[6699, 263, 361, 15, 70, "Text",
 CellID->585400916]
}, Open  ]],
Cell[CellGroupData[{
Cell[7097, 283, 56, 1, 70, "Subsection",
 CellID->427839864],
Cell[7156, 286, 177, 4, 70, "Text",
 CellID->366016649],
Cell[7336, 292, 525, 21, 70, "Text",
 CellID->1303251758],
Cell[7864, 315, 153, 4, 70, "Text",
 CellID->310969145],
Cell[8020, 321, 524, 21, 70, "Text",
 CellID->2130141798]
}, Open  ]],
Cell[CellGroupData[{
Cell[8581, 347, 56, 1, 70, "Subsection",
 CellID->99931690],
Cell[8640, 350, 132, 4, 70, "Text",
 CellID->1511720789],
Cell[8775, 356, 1153, 37, 70, "Text",
 CellID->1382383588],
Cell[9931, 395, 93, 1, 70, "Text",
 CellID->755442362]
}, Open  ]],
Cell[CellGroupData[{
Cell[10061, 401, 56, 1, 70, "Subsection",
 CellID->1664122991],
Cell[10120, 404, 176, 4, 70, "Text",
 CellID->1874898394],
Cell[10299, 410, 238, 7, 70, "Text",
 CellID->1422850545],
Cell[10540, 419, 1521, 50, 70, "Text",
 CellID->418083517]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12110, 475, 78, 2, 70, "Section",
 CellTags->"s:2.5",
 CellID->1518443729],
Cell[12191, 479, 209, 5, 70, "Text",
 CellID->809237984]
}, Open  ]],
Cell[CellGroupData[{
Cell[12437, 489, 72, 2, 70, "Section",
 CellTags->"s:2.6",
 CellID->74982980],
Cell[12512, 493, 398, 11, 70, "Text",
 CellID->618070850]
}, Open  ]],
Cell[CellGroupData[{
Cell[12947, 509, 104, 2, 70, "Section",
 CellTags->"s:2.7",
 CellID->2101685400],
Cell[13054, 513, 176, 4, 70, "Text",
 CellID->822488195],
Cell[13233, 519, 333, 7, 70, "Text",
 CellID->424764402],
Cell[13569, 528, 138, 5, 70, "Text",
 CellID->745293515],
Cell[CellGroupData[{
Cell[13732, 537, 128, 3, 70, "Input",
 CellID->733564376],
Cell[13863, 542, 815, 20, 112, "Output",
 CellID->1705164643]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14727, 568, 75, 2, 70, "Section",
 CellTags->"s:2.8",
 CellID->1332704694],
Cell[14805, 572, 289, 8, 70, "Text",
 CellID->2011313739],
Cell[15097, 582, 485, 14, 70, "BulletedText",
 CellID->856579661],
Cell[15585, 598, 200, 4, 70, "BulletedText",
 CellID->348156168],
Cell[15788, 604, 167, 4, 70, "BulletedText",
 CellID->1216934318],
Cell[15958, 610, 207, 5, 70, "BulletedText",
 CellID->858615739],
Cell[CellGroupData[{
Cell[16190, 619, 249, 8, 70, "BulletedText",
 CellID->1006490849],
Cell[16442, 629, 176, 4, 70, "Text",
 CellID->1802335234],
Cell[CellGroupData[{
Cell[16643, 637, 676, 21, 70, "Input",
 CellID->1286455603],
Cell[17322, 660, 300, 10, 36, "Output",
 CellID->1216665508]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17683, 677, 77, 2, 70, "Section",
 CellTags->"s:2.9",
 CellID->958103344],
Cell[17763, 681, 129, 4, 70, "Text",
 CellID->1597424748],
Cell[17895, 687, 6647, 201, 70, "DefinitionBox3Col",
 CellID->81128075],
Cell[24545, 890, 665, 24, 70, "Text",
 CellID->1058035034],
Cell[25213, 916, 248, 6, 70, "Text",
 CellID->961661889]
}, Open  ]],
Cell[CellGroupData[{
Cell[25498, 927, 76, 2, 70, "Section",
 CellTags->"s:2.10",
 CellID->590065589],
Cell[25577, 931, 378, 10, 70, "Text",
 CellID->1813477396],
Cell[25958, 943, 131, 4, 70, "Text",
 CellID->478301233],
Cell[26092, 949, 125, 4, 70, "Text",
 CellID->317480336],
Cell[26220, 955, 84, 1, 70, "Text",
 CellID->1088844293],
Cell[26307, 958, 203, 5, 70, "Text",
 CellID->896384750],
Cell[26513, 965, 509, 15, 70, "Text",
 CellID->1835924065],
Cell[27025, 982, 154, 4, 70, "Text",
 CellID->1898082278]
}, Open  ]]
}, Open  ]],
Cell[27206, 990, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

