(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30249,        936]
NotebookOptionsPosition[     24647,        754]
NotebookOutlinePosition[     27633,        836]
CellTagsIndexPosition[     27501,        828]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FixedStep Method for NDSolve", "Title",
 CellTags->"c:1",
 CellID->260524443],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->"s:1",
 CellID->552163729],

Cell["\<\
It is often useful to carry out a numerical integration using fixed step \
sizes.\
\>", "Text",
 CellID->1708117999],

Cell[TextData[{
 "For example, certain methods such as ",
 StyleBox["DoubleStep", "MR"],
 " and ",
 StyleBox["Extrapolation", "MR"],
 " carry out a sequence of fixed-step integrations before combining the \
solutions to obtain a more accurate method with an error estimate that allows \
adaptive step sizes to be taken."
}], "Text",
 CellID->106371517],

Cell[TextData[{
 "The method ",
 StyleBox["FixedStep", "MR"],
 " allows any one-step integration method to be invoked using fixed step \
sizes."
}], "Text",
 CellID->410636435],

Cell["\<\
This loads a package with some example problems and a package with some \
utility functions.\
\>", "Text",
 CellID->1546901868],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveProblems`\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveUtilities`\>\"", "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",
 CellID->1628549113]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
 CellTags->"s:2",
 CellID->338012536],

Cell["Define an example problem.", "Text",
 CellID->227631863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"system", " ", "=", " ", 
  RowBox[{
  "GetNDSolveProblem", "[", "\"\<BrusselatorODE\>\"", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->178702411],

Cell[BoxData[
 RowBox[{"NDSolveProblem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["Y", "1"], "\[Prime]",
         MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SubscriptBox["Y", "1"], "[", "T", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], " ", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["Y", "2"], "\[Prime]",
         MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{
          SubscriptBox["Y", "1"], "[", "T", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], " ", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}]}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["Y", "1"], "[", "0", "]"}], "\[Equal]", 
       FractionBox["3", "2"]}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["Y", "2"], "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["Y", "1"], "[", "T", "]"}], ",", 
      RowBox[{
       SubscriptBox["Y", "2"], "[", "T", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"T", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{540, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->374272],

Cell[BoxData[
 RowBox[{"NDSolveProblem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["Y", "1"], "\[Prime]",
         MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SubscriptBox["Y", "1"], "[", "T", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], " ", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["Y", "2"], "\[Prime]",
         MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{
          SubscriptBox["Y", "1"], "[", "T", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], " ", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}]}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["Y", "1"], "[", "0", "]"}], "\[Equal]", 
       FractionBox["3", "2"]}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["Y", "2"], "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["Y", "1"], "[", "T", "]"}], ",", 
      RowBox[{
       SubscriptBox["Y", "2"], "[", "T", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"T", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{540, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->1866864568],

Cell[BoxData[
 RowBox[{"NDSolveProblem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["Y", "1"], "\[Prime]",
         MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SubscriptBox["Y", "1"], "[", "T", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], " ", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["Y", "2"], "\[Prime]",
         MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"3", " ", 
         RowBox[{
          SubscriptBox["Y", "1"], "[", "T", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{
           SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], " ", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}]}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["Y", "1"], "[", "0", "]"}], "\[Equal]", 
       FractionBox["3", "2"]}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["Y", "2"], "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["Y", "1"], "[", "T", "]"}], ",", 
      RowBox[{
       SubscriptBox["Y", "2"], "[", "T", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"T", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{540, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->822425199]
}, Open  ]],

Cell[TextData[{
 "This integrates a differential system using the method ",
 StyleBox["ExplicitEuler", "MR"],
 " with a fixed step size of",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "10"}], TraditionalForm]]],
 "."
}], "Text",
 CellID->110794427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"-", 
       RowBox[{"y", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "y", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"StartingStepSize", "\[Rule]", 
    RowBox[{"1", "/", "10"}]}], ",", " ", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<FixedStep\>\"", ",", " ", 
      RowBox[{"Method", "\[Rule]", "\"\<ExplicitEuler\>\""}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1833553557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1397957140]
}, Open  ]],

Cell[TextData[{
 "Actually the ",
 StyleBox["ExplicitEuler", "MR"],
 " method has no adaptive step size control. Therefore, the integration is \
already carried out using fixed step sizes so the specification of ",
 StyleBox["FixedStep", "MR"],
 " is unnecessary."
}], "Text",
 CellID->1918372727],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"system", ",", 
     RowBox[{"StartingStepSize", "\[Rule]", 
      RowBox[{"1", "/", "10"}]}], ",", "  ", 
     RowBox[{"Method", "\[Rule]", "\"\<ExplicitEuler\>\""}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"StepDataPlot", "[", 
  RowBox[{"sol", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.2"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1959988252],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtPHDEQ9r4uVegikVT8EZQCEV45cop4KBJIXFCku4IQAb8iaZMCiSZR
FClKGSnpKRAU9NRp+BmLxw/O65XX+7g1vtxYnO3xjMefx97xA3f7J4N3B/2T
4X5/bumo/2Ew3D+ee3F4RIuigJBgQAi5nSU0n9Ic+0EY0h/PmnPPaBzSCus0
jWjaFWkoytcETWImLsIKJWJFijOfQhzL1kG6B0k0KlnLSYSaxIpGRxq9BFHC
6fs4pyVwhmfZqsEdFpVfxSrr6WgOlEAwkhD1XjZoV5Xrlms/UduH9lYh7aj1
ikZCzviegh7SKB3NeDmnQzHXVT6f66BQ/5b4gPCgj42qAQrecNFMb+OS/YBo
q0H9UHA3ONTaOlQ61ujHFnqmZXnX7Y0bH9g3wPHxFl/b46P7xlcV+Qo+xSt1
0qwvS5yheKJxIOpNAFcy5f7IZ6xoo0nlogXRRixYdpCh6LvutzUt+RUpX1Kw
FjXXJrfoqyLvGpM8lzazk22NNo+dXGdjJfVvtuEXiTbyn4sWRBuxULA2QraO
zwc/Xezzq6xD1bWxfnS+fb1+Pn9K/zZef+dxSBMS3ZOE0R1OW+Xq1hu3HOJw
i2Na+ukLjtr1Pn08V77/+p4kka5we/MHKE5ptMhaWFw4E84yHp+fSq8u/73d
+7W78/PL54vD979pbCJLitWrhRgmDsN/0EFCln2AMXblf//cJG3tjircPGdr
+rkDLb8Ph/9kxg+Oxk/uNJxV0IIPzZ0GG9lOxNk3O5XPxfr+r8mp2KEu292z
tqqlNW8Ncq9QdGzmscLbYd+w+slFC6KN0IImrpsXM+oKw2hivmluEVFm/WHt
Wt/A4guwdvGZRqf6qRlHxs3IPFLkTF+M6V2srS5ETd7kKvULbk1Air8chpz5
VT8J7gBaXrA9\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->70872009]
}, Open  ]],

Cell[TextData[{
 "Here are the step sizes taken by the method ",
 StyleBox["ExplicitRungeKutta", "MR"],
 " for this problem."
}], "Text",
 CellID->2046666749],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"system", ",", 
     RowBox[{"StartingStepSize", "\[Rule]", 
      RowBox[{"1", "/", "10"}]}], ",", " ", 
     RowBox[{"Method", "\[Rule]", "\"\<ExplicitRungeKutta\>\""}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"StepDataPlot", "[", "sol", "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1189970202],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF0nlQE3YWB/BYscoRScQWucMpKjcU3F3hPRYYUFGohRJZgQgoVg1SVKh4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      "]]}}, {
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxF0nlQE3YWB/BYscoRScQWucMpKjcU3F3hPRYYUFGohRJZgQgoVg1SVKh4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      "]]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->{0, 0.05},
  Frame->True,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  RotateLabel->False]], "Output",
 ImageSize->{364, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->766570362]
}, Open  ]],

Cell[TextData[{
 "This specifies that fixed step sizes should be used for the method ",
 StyleBox["ExplicitRungeKutta", "MR"],
 "."
}], "Text",
 CellID->983477787],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"system", ",", 
     RowBox[{"StartingStepSize", "\[Rule]", 
      RowBox[{"1", "/", "10"}]}], ",", " ", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<FixedStep\>\"", ",", " ", 
        RowBox[{"Method", "\[Rule]", "\"\<ExplicitRungeKutta\>\""}]}], 
       "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"StepDataPlot", "[", 
  RowBox[{"sol", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.2"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->1890788542],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtPHDEQ9r4uVegikVT8EZQCEV45cop4KBJIXFCku4IQAb8iaZMCiSZR
FClKGSnpKRAU9NRp+BmLxw/O65XX+7g1vtxYnO3xjMefx97xA3f7J4N3B/2T
4X5/bumo/2Ew3D+ee3F4RIuigJBgQAi5nSU0n9Ic+0EY0h/PmnPPaBzSCus0
jWjaFWkoytcETWImLsIKJWJFijOfQhzL1kG6B0k0KlnLSYSaxIpGRxq9BFHC
6fs4pyVwhmfZqsEdFpVfxSrr6WgOlEAwkhD1XjZoV5Xrlms/UduH9lYh7aj1
ikZCzviegh7SKB3NeDmnQzHXVT6f66BQ/5b4gPCgj42qAQrecNFMb+OS/YBo
q0H9UHA3ONTaOlQ61ujHFnqmZXnX7Y0bH9g3wPHxFl/b46P7xlcV+Qo+xSt1
0qwvS5yheKJxIOpNAFcy5f7IZ6xoo0nlogXRRixYdpCh6LvutzUt+RUpX1Kw
FjXXJrfoqyLvGpM8lzazk22NNo+dXGdjJfVvtuEXiTbyn4sWRBuxULA2QraO
zwc/Xezzq6xD1bWxfnS+fb1+Pn9K/zZef+dxSBMS3ZOE0R1OW+Xq1hu3HOJw
i2Na+ukLjtr1Pn08V77/+p4kka5we/MHKE5ptMhaWFw4E84yHp+fSq8u/73d
+7W78/PL54vD979pbCJLitWrhRgmDsN/0EFCln2AMXblf//cJG3tjircPGdr
+rkDLb8Ph/9kxg+Oxk/uNJxV0IIPzZ0GG9lOxNk3O5XPxfr+r8mp2KEu292z
tqqlNW8Ncq9QdGzmscLbYd+w+slFC6KN0IImrpsXM+oKw2hivmluEVFm/WHt
Wt/A4guwdvGZRqf6qRlHxs3IPFLkTF+M6V2srS5ETd7kKvULbk1Air8chpz5
VT8J7gBaXrA9\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->43569603]
}, Open  ]],

Cell[TextData[{
 "The option ",
 StyleBox["MaxStepFraction", "MR"],
 " provides an absolute bound on the step size that depends on the \
integration interval."
}], "Text",
 CellID->768903858],

Cell[TextData[{
 "Since the default value of ",
 StyleBox["MaxStepFraction", "MR"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/", "10"}], ","}], TraditionalForm]]],
 " the step size in this example is bounded by one-tenth of the integration \
interval, which leads to using a constant step size of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "20"}], TraditionalForm]]],
 "."
}], "Text",
 CellID->942009060],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"time", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"T", ",", " ", "0", ",", " ", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"system", ",", "time", ",", " ", 
     RowBox[{"StartingStepSize", "\[Rule]", 
      RowBox[{"1", "/", "10"}]}], ",", " ", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<FixedStep\>\"", ",", " ", 
        RowBox[{"Method", "\[Rule]", "\"\<ExplicitRungeKutta\>\""}]}], 
       "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"StepDataPlot", "[", 
  RowBox[{"sol", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.2"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[13]:=",
 CellID->2089787126],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztGrtO5DBw8tilgBZ0XAUN8A08T4c4BAgoeIlyxUO7BXDs8RnwASDEq6Ck
uRN8AA1I0FPT8BkhEztLZDvxZkNY5zSR4njs8Xg8Mx6PHc9XDqpbO5WD2kal
b7pe+V2tbfzp+7VX94scC8CqAsDbN/Dznp8LXnxq/suy8bkeP7X9Bg5CTtjS
Aywbj6nD7JiiDhBOqJNolho0OcZQ8O3G1P3oD8CVSkalkrLA5YiEURL4kWl0
CDSGtb0M5MqxHkPPMXKCBYO5cqrnA6Vvc+tQcBDRS75WkF7Hakuyc+e0GSrN
y53xGs73Mv+ONwkjFScCi/2yeYBZ0cOwqc4elZdxOEUsWOcDl6RQjpaw1BZo
YbKaob3Na5f818pIJwq7AtwpwF2a+rT4n02v3f2npYewzcyN9GdA/6br77sG
Nh2/90NeEU8b+u/Qu5a8ZKlMZYQxurAanrNbqMVkscAYIcI8z5vHYXEwSJYk
7WJikCxBG83bXDbieqOgpNnriCuUKt7/XIpsPFeXzxNjx9ubN9B/fvYETn3/
nwHw0eF9wH+20eKBS1CxtnLtE/3544T1MTdzwUBoC+wyeGry1GNnFc2NEEek
im2YHh8fXvd2/97dvkC/YXA6PeriWcU8UMSBbuRrgh8hr11EjBBhwWPWZB6H
/xMGWS7J8qtiNydhPVVQkk+yE9estLFbuyiGP6Rmvfg4xNDRpjj7kVubYqE0
24uIQVEBWa6JGGSXoF3z2YYwfFpa+aWdd6p1q+30WljzvQxxknTnReQxWYe0
nycPSdIuJgbJklb/1jHy/WMfFycEMMSfDeTMlXx/s9Tgi3NH93fMohd3fyf9
KQdpzgzNRe96xs04rFhuoS0mWW5tRtonnIAhFrtbirn42/BgvQPJcYoo\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->14051029]
}, Open  ]],

Cell[TextData[{
 "By setting the value of ",
 StyleBox["MaxStepFraction", "MR"],
 " to a different value, the dependence of the step size on the integration \
interval can be relaxed or removed entirely."
}], "Text",
 CellID->821329701],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"system", ",", "time", ",", " ", 
     RowBox[{"StartingStepSize", "\[Rule]", 
      RowBox[{"1", "/", "10"}]}], ",", 
     RowBox[{"MaxStepFraction", "\[Rule]", "Infinity"}], ",", "  ", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<FixedStep\>\"", ",", " ", 
        RowBox[{"Method", "\[Rule]", "\"\<ExplicitRungeKutta\>\""}]}], 
       "}"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"StepDataPlot", "[", 
  RowBox[{"sol", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.2"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[16]:=",
 CellID->1708694735],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{0., 0.1}, {0.1, 0.1}, {0.2, 0.10000000000000003`}, {
      0.30000000000000004`, 0.09999999999999998}, {0.4, 
      0.09999999999999998}}]}}, {
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{0., 0.1}, {0.1, 0.1}, {0.2, 0.10000000000000003`}, {
      0.30000000000000004`, 0.09999999999999998}, {0.4, 
      0.09999999999999998}}]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->{0, 0},
  Frame->True,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->{{0., 0.4}, {0, 0.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic},
  RotateLabel->False]], "Output",
 ImageSize->{364, 231},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->2073628363]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
 CellTags->"s:3",
 CellID->2046799400],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "Specifies the method to use with fixed step sizes.", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->1969219178],

Cell[TextData[{
 "Options of the method ",
 Cell[BoxData["FixedStep"], "InlineFormula"],
 ". "
}], "Caption",
 CellID->287193397]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FixedStep Method for NDSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Advanced Numerical Differential Equation Solving in Mathematica", 
         "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NDSolveOverview"]], "Text", FontFamily -> "Verdana"],
     "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolveExtrapolation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NDSolveOrthogonalProjection"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 49.6651034}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "It is often useful to carry out a numerical integration using fixed step \
sizes. For example, certain methods such as DoubleStep and Extrapolation \
carry out a sequence of fixed-step integrations before combining the \
solutions to obtain a more accurate method with an error estimate that allows \
adaptive step sizes to be taken. The method FixedStep allows any one-step \
integration method to be invoked using fixed step sizes.", "synonyms" -> {}, 
    "title" -> "FixedStep Method for NDSolve", "type" -> "Tutorial", "uri" -> 
    "tutorial/NDSolveFixedStep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[728, 29, 83, 2, 70, "Title",
   CellTags->"c:1",
   CellID->260524443]},
 "s:1"->{
  Cell[836, 35, 69, 2, 70, "Section",
   CellTags->"s:1",
   CellID->552163729]},
 "s:2"->{
  Cell[2060, 86, 65, 2, 70, "Section",
   CellTags->"s:2",
   CellID->338012536]},
 "s:3"->{
  Cell[23795, 721, 72, 2, 70, "Section",
   CellTags->"s:3",
   CellID->2046799400]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 27117, 809},
 {"s:1", 27207, 813},
 {"s:2", 27299, 817},
 {"s:3", 27392, 821}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 83, 2, 70, "Title",
 CellTags->"c:1",
 CellID->260524443],
Cell[CellGroupData[{
Cell[836, 35, 69, 2, 70, "Section",
 CellTags->"s:1",
 CellID->552163729],
Cell[908, 39, 126, 4, 70, "Text",
 CellID->1708117999],
Cell[1037, 45, 352, 9, 70, "Text",
 CellID->106371517],
Cell[1392, 56, 176, 6, 70, "Text",
 CellID->410636435],
Cell[1571, 64, 137, 4, 70, "Text",
 CellID->1546901868],
Cell[1711, 70, 312, 11, 70, "Input",
 InitializationCell->True,
 CellID->1628549113]
}, Open  ]],
Cell[CellGroupData[{
Cell[2060, 86, 65, 2, 70, "Section",
 CellTags->"s:2",
 CellID->338012536],
Cell[2128, 90, 62, 1, 70, "Text",
 CellID->227631863],
Cell[CellGroupData[{
Cell[2215, 95, 175, 5, 70, "Input",
 CellID->178702411],
Cell[2393, 102, 1879, 61, 73, "Output",
 CellID->374272],
Cell[4275, 165, 1884, 61, 73, "Output",
 CellID->1866864568],
Cell[6162, 228, 1852, 60, 73, "Output",
 CellID->822425199]
}, Open  ]],
Cell[8029, 291, 258, 10, 70, "Text",
 CellID->110794427],
Cell[CellGroupData[{
Cell[8312, 305, 820, 26, 70, "Input",
 CellID->1833553557],
Cell[9135, 333, 467, 17, 36, "Output",
 CellID->1397957140]
}, Open  ]],
Cell[9617, 353, 297, 8, 70, "Text",
 CellID->1918372727],
Cell[CellGroupData[{
Cell[9939, 365, 506, 15, 47, "Input",
 CellID->1959988252],
Cell[10448, 382, 1139, 23, 252, "Output",
 Evaluatable->False,
 CellID->70872009]
}, Open  ]],
Cell[11602, 408, 158, 5, 70, "Text",
 CellID->2046666749],
Cell[CellGroupData[{
Cell[11785, 417, 396, 11, 70, "Input",
 CellID->1189970202],
Cell[12184, 430, 5145, 95, 247, "Output",
 CellID->766570362]
}, Open  ]],
Cell[17344, 528, 163, 5, 70, "Text",
 CellID->983477787],
Cell[CellGroupData[{
Cell[17532, 537, 632, 18, 65, "Input",
 CellID->1890788542],
Cell[18167, 557, 1140, 23, 252, "Output",
 Evaluatable->False,
 CellID->43569603]
}, Open  ]],
Cell[19322, 583, 191, 6, 70, "Text",
 CellID->768903858],
Cell[19516, 591, 435, 15, 70, "Text",
 CellID->942009060],
Cell[CellGroupData[{
Cell[19976, 610, 809, 23, 83, "Input",
 CellID->2089787126],
Cell[20788, 635, 1123, 22, 252, "Output",
 Evaluatable->False,
 CellID->14051029]
}, Open  ]],
Cell[21926, 660, 236, 6, 70, "Text",
 CellID->821329701],
Cell[CellGroupData[{
Cell[22187, 670, 714, 19, 70, "Input",
 CellID->1708694735],
Cell[22904, 691, 842, 24, 252, "Output",
 CellID->2073628363]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23795, 721, 72, 2, 70, "Section",
 CellTags->"s:3",
 CellID->2046799400],
Cell[23870, 725, 591, 16, 70, "DefinitionBox3Col",
 CellID->1969219178],
Cell[24464, 743, 129, 5, 70, "Caption",
 CellID->287193397]
}, Open  ]]
}, Open  ]],
Cell[24620, 752, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

