(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48393,       1395]
NotebookOptionsPosition[     40424,       1126]
NotebookOutlinePosition[     43578,       1216]
CellTagsIndexPosition[     43419,       1207]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ImplicitRungeKutta Method for NDSolve", "Title",
 CellTags->"c:1",
 CellID->478471212],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->"s:1",
 CellID->809171758],

Cell["\<\
Implicit Runge-Kutta methods have a number of desirable properties.\
\>", "Text",
 CellID->1178805418],

Cell["\<\
The Gauss-Legendre methods, for example, are self-adjoint meaning that they \
provide the same solution when integrating forwards or backwards in time.\
\>", "Text",
 CellID->2032572883],

Cell["\<\
This loads packages defining some example problems and utility functions.\
\>", "Text",
 CellID->1863522326],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveProblems`\>\"", "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveUtilities`\>\"", "]"}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",
 CellID->960491581]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coefficients", "Section",
 CellTags->"s:2",
 CellID->1990498196],

Cell["\<\
A generic framework for implicit Runge Kutta methods has been implemented. \
The focus so far is on methods with interesting geometric properties and \
currently covers the following schemes:\
\>", "Text",
 CellID->1023480152],

Cell[TextData[{
 StyleBox["ImplicitRungeKuttaGaussCoefficients", "MR"],
 "\n",
 StyleBox["ImplicitRungeKuttaLobattoIIIACoefficients", "MR"],
 "\n",
 StyleBox["ImplicitRungeKuttaLobattoIIIBCoefficients", "MR"],
 "\n",
 StyleBox["ImplicitRungeKuttaLobattoIIICCoefficients", "MR"],
 "\n",
 StyleBox["ImplicitRungeKuttaRadauIACoefficients", "MR"],
 "\n",
 StyleBox["ImplicitRungeKuttaRadauIIACoefficients", "MR"]
}], "Text",
 CellID->694216675],

Cell["\<\
The derivation of the method coefficients can be carried out to arbitrary \
order and arbitrary precision.\
\>", "Text",
 CellID->199624518]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coefficient generation", "Section",
 CellID->2105903498],

Cell[TextData[{
 "Start with the definition of the polynomial defining the abscissas of the \
",
 Cell[BoxData[
  FormBox["s", TraditionalForm]]],
 " stage coefficients. For example, the abscissas for Gauss-Legendre methods \
are defined as ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SuperscriptBox["d", "s"], 
    SuperscriptBox["dx", "s"]], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{
     FormBox[
      SuperscriptBox["x", "s"],
      TraditionalForm], "(", 
     RowBox[{"1", "-", "x"}], ")"}], "s"], TraditionalForm]]],
 "."
}], "BulletedText",
 CellID->635264257],

Cell["\<\
Univariate polynomial factorization gives the underlying irreducible \
polynomials defining the roots of the polynomials.\
\>", "BulletedText",
 CellID->1882342207],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects are constructed to represent the solutions (using unique root \
isolation and Jenkins-Traub for the numerical approximation)."
}], "BulletedText",
 CellID->960385003],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects are then approximated numerically for precision coefficients."
}], "BulletedText",
 CellID->1663037271],

Cell["\<\
Condition estimates for Vandermonde systems governing the coefficients yield \
the precision to take in approximating the roots numerically.\
\>", "BulletedText",
 CellID->1521113161],

Cell[TextData[{
 "Specialized solvers for nonconfluent Vandermonde systems are then used to \
solve equations for the coefficients (see [",
 ButtonBox["GVL96",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveReferences#18126"],
 "])."
}], "BulletedText",
 CellID->2000855841],

Cell[CellGroupData[{

Cell["\<\
One step of iterative refinement is used to polish the approximate solutions \
and to check that the coefficients are obtained to the requested precision.\
\>", "BulletedText",
 CellID->692643658],

Cell["\<\
This generates the coefficients for the two-stage fourth-order Gauss-Legendre \
method to 50-decimal digits of precision.\
\>", "Text",
 CellID->1330400771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve`ImplicitRungeKuttaGaussCoefficients", "[", 
  RowBox[{"4", ",", " ", "50"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->607031499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.25`50.", ",", 
       RowBox[{
       "-", "0.038675134594812882254574390250978727823800875635063438009301163\
242`50."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.538675134594812882254574390250978727823800875635063438009301163242`\
50.", ",", "0.25`50."}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`50.", ",", "0.5`50."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.211324865405187117745425609749021272176199124364936561990698836758`50.\
", ",", "0.788675134594812882254574390250978727823800875635063438009301163242`\
50."}], "}"}]}], "}"}]], "Output",
 ImageSize->{418, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2049871528]
}, Open  ]],

Cell[TextData[{
 "The coefficients have the form ",
 StyleBox["{a,", "MR"],
 StyleBox[Cell[BoxData[
  FormBox[
   SuperscriptBox["b", "T"], TraditionalForm]], "MR"], "MR"],
 StyleBox[",", "MR"],
 StyleBox[Cell[BoxData[
  FormBox[
   SuperscriptBox["c", "T"], TraditionalForm]], "MR"], "MR"],
 StyleBox["}", "MR"],
 "."
}], "Text",
 CellID->249724719],

Cell["\<\
This generates the coefficients for the two-stage fourth-order Gauss-Legendre \
method exactly. For high-order methods, generating the coefficients exactly \
can often take a very long time.\
\>", "Text",
 CellID->535569124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve`ImplicitRungeKuttaGaussCoefficients", "[", 
  RowBox[{"4", ",", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->420114343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"2", " ", 
           SqrtBox["3"]}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", 
           SqrtBox["3"]}]}], ")"}]}], ",", 
       FractionBox["1", "4"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SqrtBox["3"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SqrtBox["3"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{532, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->479982586]
}, Open  ]],

Cell["\<\
This generates the coefficients for the six-stage tenth-order RaduaIA \
implicit Runge-Kutta method to 20-decimal digits of precision.\
\>", "Text",
 CellID->1945691278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve`ImplicitRungeKuttaRadauIACoefficients", "[", 
  RowBox[{"10", ",", " ", "20"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1316330249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.04`20.", ",", 
       RowBox[{"-", "0.08761801872527423505017362306498456052`20."}], ",", 
       "0.08531798763860029375989387300744514058`20.", ",", 
       RowBox[{
       "-", "0.05581807848329811483703952661318756651`19.999999999999996"}], 
       ",", "0.01811810956997205612731927667072698645`20."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.04`20.", ",", "0.12875675325490976115823836749179707516`20.", ",", 
       RowBox[{"-", "0.04747773040319743429495247634449983651`20."}], ",", 
       "0.0267769859677478706880550044955126023`20.", ",", 
       RowBox[{"-", "0.00829614447567964539925381451792960769`20."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "0.04`20.", ",", "0.23310008036710237091548551667442882271`20.", ",", 
       "0.16758507013524896344206140916157860597`20.", ",", 
       RowBox[{"-", "0.03288334354350140177498131770290095956`20."}], ",", 
       "0.00860776067223324736073672320397628219`20."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.04`20.", ",", "0.21925333267709602304611354942268816425`20.", ",", 
       "0.33134489917971587453120843732816154118`20.", ",", 
       "0.14621486784749350664968724512404244842`20.", ",", 
       RowBox[{
       "-", "0.01365611334242923190705522956051729497`19.999999999999996"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.04`20.", ",", "0.22493691761630663460402379815045336174`20.", ",", 
       "0.30390571559725175839650152645073468243`20.", ",", 
       "0.30105430635402060050078494906655890859`20.", ",", 
       "0.07299886431790332430556853377813742601`20."}], "}"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
    "0.04`20.", ",", "0.22310390108357074440256021822858935965`20.", ",", 
     "0.31182652297574125408185491157664052199`20.", ",", 
     "0.2813560151494620601921726503406598912`20.", ",", 
     "0.14371356079122594132341221985411022716`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0.13975986434378055215208708112488023326`20.", ",", 
     "0.41640956763108317994330233133708275131`20.", ",", 
     "0.72315698636187617231995400231437485889`20.", ",", 
     "0.94289580388548231780687880744588437876`20."}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{553, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1261448693]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
 CellTags->"s:3",
 CellID->1456237599],

Cell["Load an example problem.", "Text",
 CellID->1069400663],

Cell[BoxData[{
 RowBox[{
  RowBox[{"system", " ", "=", " ", 
   RowBox[{"GetNDSolveProblem", "[", "\"\<PerturbedKepler\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"system", "[", "\"\<DependentVariables\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->1725878050],

Cell["\<\
This problem has two invariants that should remain constant. A numerical \
method may not be able to conserve these invariants.\
\>", "Text",
 CellID->1934708811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"invs", " ", "=", " ", 
  RowBox[{"system", "[", "\"\<Invariants\>\"", "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1878572421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"400", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{
            SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{
            SubscriptBox["Y", "2"], "[", "T", "]"}], "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]]}], "-", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{
         SubscriptBox["Y", "1"], "[", "T", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{
         SubscriptBox["Y", "2"], "[", "T", "]"}], "2"]}]]], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{
         SubscriptBox["Y", "3"], "[", "T", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{
         SubscriptBox["Y", "4"], "[", "T", "]"}], "2"]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["Y", "2"], "[", "T", "]"}]}], " ", 
     RowBox[{
      SubscriptBox["Y", "3"], "[", "T", "]"}]}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "1"], "[", "T", "]"}], " ", 
     RowBox[{
      SubscriptBox["Y", "4"], "[", "T", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{432, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->167811344]
}, Open  ]],

Cell[TextData[{
 "This solves the system using an implicit Runge-Kutta Gauss method. The \
order of the scheme is selected using the ",
 StyleBox["DifferenceOrder", "MR"],
 " method option."
}], "Text",
 CellID->1819798046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{"system", ",", " ", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<FixedStep\>\"", ",", " ", 
       RowBox[{"Method", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<ImplicitRungeKutta\>\"", ",", 
          RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "10"}]}], "}"}]}]}], 
      "}"}]}], ",", " ", 
    RowBox[{"StartingStepSize", "\[Rule]", 
     RowBox[{"1", "/", "10"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1594611100],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWd9v0zAQdpOmXTfE6DRtAwkxJMQb0oQED0g8IcETf0Q1IW0PMDT2/4fY
sdPL5RL/SJq67UXq4nPsu8/2ne379nP1dPfr9+rp/nZ1/eNx9ffu/vbf9feH
x6IqnQgx+SOE+HYlinJelNRPPg/FryyWpcvib1p8TIt3UrxP9Puzrr/R76+6
fiZ7pUZbLqZIfoHkd5b2WL4AdiCezNIvVaO5QrUJkk+Q/AnJH5H8xRP9UqN9
74BWtsN4cTuM12ZfjVetgVnTqX5j6ykxp5S1TJiG5jGNUmQl0a0TLU/B9wy9
U9Ce1p4ArQarnDG90OqR9eUUmAe2hjagzWYvPD+2WTbapjkdEzNkdWppb7N3
rCrXshBHjghtUUP7z5Kq1XI1eR5anyEZo1L6s0rWVtSqzFGt/jYnxtvUQOsl
x0xbp2utfTs0YsxQV2vPsRD6rms7LriDL3rOmWvEGFtJj0gLmoFGvBjUvtpk
XCwI1GH+hKNsQzHiHdceo3Hsi095jKMPLvKeYbuHNLRc9ECAd09qd5XedpSH
eR3lhV3fJznl86THjHNGoNnPWur7rDh1ixrK2ys5Qm8POwH6eLvtxnuab2OH
h1mNRHnsqQWPitrh28//jKyFp0zVt3ZLJO8Cg+zqtD3zBWYG9Lp34G20x3e9
dm+qtPbYh8b36GVjHmy3+zh8+ryOOyfys7yeBxmPBdkX0ctkS9T9JQVaE6wV
6cB1OIuBHkOjkhU4szXIUtgTWAnKuEb1t9eeCMO865TEtmgfR+fOdY5k7Ktv
Ld9fknYvUatXISPd/toFzKfbGj7PKbbE3DNlmzmIArlGEsoHIEOdcr+ZFeIb
VH+Wu53kJvoMQ2ii0OwXLnMH81KM341hlEXMofqX4Bh2iXVVcbX3LCvkwtds
qi0TZFaVWdVSVqdcTBkys6jd+phFreRNsahST3l6DP3fBWZNw9Ayazoka6pu
YOR/AnzmgVlRuBPE6s3x5YVDs6KlNzPr2YKVWU+EIQbWcxifZVbzMFnN0nuY
tRxtbQLms1yjw2Ilz9QgZdNhWEeDbfdYR+yhttsGs47YOrOOh8c6bjEDZdax
Wx+zjpXMrOMoMeEdx8w6MuvIrGMc3hxfXseso6iaMOvIrGO4zzLryKwjts2s
Y23MzDqieUrFbrCONs+Y5+udbfdYSdvdGkcXbr9frKVLxmX81JaxUOcWs5pu
q75vrGbI+LtkZj1d7DLrGTZn8bCetoyM5B17xA2zomFomRUdnhX19V1z9/XN
OpktjdHL48tHN8OWOkUzWC9mU5lNjZ1N3bRPM9t6yGyrzbtobMzG1sa8ZTbW
mv/Xo0IwU1uWxOQ/8Hag/A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{366, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->42017603]
}, Open  ]],

Cell["\<\
A plot of the error in the invariants shows an increase as the integration \
proceeds.\
\>", "Text",
 CellID->1662812594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvariantErrorPlot", "[", 
  RowBox[{
  "invs", ",", " ", "vars", ",", " ", "T", ",", " ", "sol", ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", " ", "Blue"}], "}"}]}], ",", " ", 
   RowBox[{"InvariantErrorSampleRate", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->470607604],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 322},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->100568620]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["ImplicitSolver", "MR"],
 " method of ",
 StyleBox["ImplicitRungeKutta", "MR"],
 " has options ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " that specify the absolute and relative error to aim for in solving the \
nonlinear system of equations."
}], "Text",
 CellID->1862437112],

Cell[TextData[{
 "These options have the same default values as the corresponding options in \
",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", since often there is little point in solving the nonlinear system to much \
higher accuracy than the local error of the method."
}], "Text",
 CellID->429027455],

Cell["\<\
However, for certain types of problems it can be useful to solve the \
nonlinear system up to the working precision.\
\>", "Text",
 CellID->899688686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{"system", ",", " ", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<FixedStep\>\"", ",", " ", 
       RowBox[{"Method", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<ImplicitRungeKutta\>\"", ",", 
          RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "10"}], ",", 
          RowBox[{"\"\<ImplicitSolver\>\"", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<Newton\>\"", ",", " ", 
             RowBox[{"AccuracyGoal", "\[Rule]", "MachinePrecision"}], ",", 
             " ", 
             RowBox[{"PrecisionGoal", "\[Rule]", "MachinePrecision"}], ",", 
             RowBox[{"\"\<IterationSafetyFactor\>\"", "\[Rule]", "1"}]}], 
            "}"}]}]}], "}"}]}]}], "}"}]}], ",", " ", 
    RowBox[{"StartingStepSize", "\[Rule]", 
     RowBox[{"1", "/", "10"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1597295671],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWd9v0zAQdpOmXTfE6DRtAwkxJMQb0oQED0g8IcETf0Q1IW0PMDT2/4fY
sdPL5RL/SJq67UXq4nPsu8/2ne379nP1dPfr9+rp/nZ1/eNx9ffu/vbf9feH
x6IqnQgx+SOE+HYlinJelNRPPg/FryyWpcvib1p8TIt3UrxP9Puzrr/R76+6
fiZ7pUZbLqZIfoHkd5b2WL4AdiCezNIvVaO5QrUJkk+Q/AnJH5H8xRP9UqN9
74BWtsN4cTuM12ZfjVetgVnTqX5j6ykxp5S1TJiG5jGNUmQl0a0TLU/B9wy9
U9Ce1p4ArQarnDG90OqR9eUUmAe2hjagzWYvPD+2WTbapjkdEzNkdWppb7N3
rCrXshBHjghtUUP7z5Kq1XI1eR5anyEZo1L6s0rWVtSqzFGt/jYnxtvUQOsl
x0xbp2utfTs0YsxQV2vPsRD6rms7LriDL3rOmWvEGFtJj0gLmoFGvBjUvtpk
XCwI1GH+hKNsQzHiHdceo3Hsi095jKMPLvKeYbuHNLRc9ECAd09qd5XedpSH
eR3lhV3fJznl86THjHNGoNnPWur7rDh1ixrK2ys5Qm8POwH6eLvtxnuab2OH
h1mNRHnsqQWPitrh28//jKyFp0zVt3ZLJO8Cg+zqtD3zBWYG9Lp34G20x3e9
dm+qtPbYh8b36GVjHmy3+zh8+ryOOyfys7yeBxmPBdkX0ctkS9T9JQVaE6wV
6cB1OIuBHkOjkhU4szXIUtgTWAnKuEb1t9eeCMO865TEtmgfR+fOdY5k7Ktv
Ld9fknYvUatXISPd/toFzKfbGj7PKbbE3DNlmzmIArlGEsoHIEOdcr+ZFeIb
VH+Wu53kJvoMQ2ii0OwXLnMH81KM341hlEXMofqX4Bh2iXVVcbX3LCvkwtds
qi0TZFaVWdVSVqdcTBkys6jd+phFreRNsahST3l6DP3fBWZNw9Ayazoka6pu
YOR/AnzmgVlRuBPE6s3x5YVDs6KlNzPr2YKVWU+EIQbWcxifZVbzMFnN0nuY
tRxtbQLms1yjw2Ilz9QgZdNhWEeDbfdYR+yhttsGs47YOrOOh8c6bjEDZdax
Wx+zjpXMrOMoMeEdx8w6MuvIrGMc3hxfXseso6iaMOvIrGO4zzLryKwjts2s
Y23MzDqieUrFbrCONs+Y5+udbfdYSdvdGkcXbr9frKVLxmX81JaxUOcWs5pu
q75vrGbI+LtkZj1d7DLrGTZn8bCetoyM5B17xA2zomFomRUdnhX19V1z9/XN
OpktjdHL48tHN8OWOkUzWC9mU5lNjZ1N3bRPM9t6yGyrzbtobMzG1sa8ZTbW
mv/Xo0IwU1uWxOQ/8Hag/A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{366, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->38650140]
}, Open  ]],

Cell["\<\
The first invariant is the Hamiltonian of the system and the error is now \
bounded, as it should be since the Gauss implicit Runge-Kutta method is a \
symplectic integrator.\
\>", "Text",
 CellID->415242309],

Cell["\<\
The second invariant is conserved exactly (up to roundoff) since the Gauss \
implicit Runge-Kutta method conserves quadratic invariants.\
\>", "Text",
 CellID->970925185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InvariantErrorPlot", "[", 
  RowBox[{
  "invs", ",", " ", "vars", ",", " ", "T", ",", " ", "sol", ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", " ", "Blue"}], "}"}]}], ",", " ", 
   RowBox[{"InvariantErrorSampleRate", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->1242784651],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 327},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->93496951]
}, Open  ]],

Cell["\<\
This defines the implicit midpoint method as the one-stage implicit \
Runge-Kutta method of order two.\
\>", "Text",
 CellID->153842308],

Cell["\<\
For this problem it can be more efficient to use a fixed-point iteration \
instead of a Newton iteration to solve the nonlinear system.\
\>", "Text",
 CellID->1849816151],

Cell[BoxData[
 RowBox[{
  RowBox[{"ImplicitMidpoint", " ", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<FixedStep\>\"", ",", " ", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<ImplicitRungeKutta\>\"", ",", 
        RowBox[{
        "\"\<Coefficients\>\"", "->", 
         "\"\<ImplicitRungeKuttaGaussCoefficients\>\""}], ",", " ", 
        RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "2"}], ",", 
        RowBox[{"\"\<ImplicitSolver\>\"", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<FixedPoint\>\"", ",", 
           RowBox[{"\"\<AccuracyGoal\>\"", "\[Rule]", "MachinePrecision"}], 
           ",", 
           RowBox[{"\"\<PrecisionGoal\>\"", "\[Rule]", "MachinePrecision"}], 
           ",", 
           RowBox[{"\"\<IterationSafetyFactor\>\"", "\[Rule]", "1"}]}], " ", 
          "}"}]}]}], "}"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1421951171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{"system", ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "ImplicitMidpoint"}], ",", " ", 
   RowBox[{"StartingStepSize", "\[Rule]", 
    RowBox[{"1", "/", "100"}]}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->403567027],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFFv0zAQdpOmXTfE6DRtA2li/AAkhDQekHhCgif+A9WEtD0g0Nj/N7Fj
t5fLJWcnaZtmF6lN7mKfz/Z3zt33Y/V0/+v36unhbnXz/XH19/7h7t/Ntz+P
uSqdKDX5qZT6eqXyZ50/2Z+5VvmveCyeLvP/NH+Z5vckv5+4+yen/+DuX5x+
Znql3ppWUyS/QvIF0x7LF2Ac6E/G9EvtbK6QNkHyCZJvkfwRyZ8jvV86b7Ef
lLch7bC/3Ph2vnYP/J5O3R2PnhJrSo2WKd/QX75RikZJXOvEyVPwPkP3FLSn
rSfAqvfVrJjbaHsZfbEE/oKt4RhwzGovvD7cKntrU03HxAyMGhIzWD62yo2s
1FGgR1yU0HhZUlonrxcrwuoLJGOvrP1sLbtR7C7Mkda9mxPzrVqg7ZJzpken
tWzfBovYZ2irtueuPIzd13q/4Im9IOYdGgW+f9IQXbFet4sB73WsNYP1BeF1
O4zgyNkS7qNjNWI2gX3xlxr70cUvMlfgcomKFZzJ4FOOOgUNgo50OyRRyGp6
P9EUjkkU7OYsRyua1ei77CKV3fSF4Pozd/8IbndSYwRz2eWp3sdJDCsI4/Vx
pBU8K+okrv/2ZqQWfg3WfUsZGvkd7uX0pcfzb2AWTqOpwd9Ke5xn1WN0bbXD
2dIPSpeVuXHZ8jBwel72WxP1jS5XLx6FoHohevm6i8odUmA1wVaRDazDVQFE
Ae2VUeDK0HuWwp5glFYVTGcMXe8EMaekrwtSy58w50jG+HvHvH9NjnuJWr0Z
zn60WKOwfXmpKVbA522mzRyg1ay7ceU9kKFNcy7McvEt0p/psK+ojxLPhHF5
5rUu11/Y3zDmzDxibjD+yfvs2ZpDYRNtbIyePYQc74Yl5KojYQufK1tov0xD
qiiFHWy2J+xgq0zN2Cm+AH0z4cIGtvNW2EBOtpkRyVrHzE3YPhjdQ0XoYbJ9
BUKFzavxVdg80kr/bF4/OBS2bjxsXYEIYeM6rXeLNSrWfdxs25mdlGnaD5uW
gvg+LDaNsy5sGheDwqaNn03bY8UmbFqzPWHThE0TNi1yJYRNq5+FsGlDQKiw
aRtZ2DRh0/aBQ2HThE2rRBzGB67KgCxsmrBpsU/c7s51mTk4LLaNy01xhOD2
42LjQqqQVAlbJ2xdXbtFEI5C8BPTX9g8qq+wefxo22fzuAqG5NM6xIKwfe28
FbYvrGKJxaPPSWOrNGEBh4jcQ2YBg6IO7IGwhMIScrXZNljCbeNUWMSxsYgc
YmhfhWXcNsvI1r1l9KrnykCqyX9gdi+W\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{352, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->307946454]
}, Open  ]],

Cell["\<\
At present, the implicit Runge-Kutta method framework does not use banded \
Newton techniques for uncoupling the nonlinear system.\
\>", "Text",
 CellID->1842065514]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
 CellTags->"s:4",
 CellID->922101906],

Cell[CellGroupData[{

Cell["ImplicitRungeKutta options", "Subsection",
 CellTags->"s:4",
 CellID->36109258],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"Coefficients", "ImplicitRungeKuttaGaussCoefficients", Cell["\<\
specifies the coefficients to use in the implicit Runge-Kutta method\
\>", "TableText"]},
   {"DifferenceOrder", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the order of local accuracy of the method", "TableText"]},
   {"ImplicitSolver", "Newton", Cell[TextData[{
     "specifies the solver to use for the nonlinear system; valid settings \
are ",
     Cell[BoxData[
      ButtonBox["FixedPoint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
     " or ",
     Cell[BoxData["Newton"], "InlineFormula"]
    }], "TableText"]},
   {"StepSizeControlParameters", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the step control parameters", "TableText"]},
   {"StepSizeRatioBounds", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", "8"], ",", "4"}], "}"}], Cell["\<\
specifies the bounds on a relative change in the new step size\
\>", "TableText"]},
   {"StepSizeSafetyFactors", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specifies the safety factors to use in the step size estimate\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->1010912116],

Cell[TextData[{
 "Options of the method ",
 Cell[BoxData["ImplicitRungeKutta"], "InlineFormula"],
 "."
}], "Caption",
 CellID->2104637757],

Cell[TextData[{
 "The default setting of ",
 StyleBox["Automatic", "MR"],
 " for the option ",
 StyleBox["StepSizeSafetyFactors", "MR"],
 " uses the values ",
 StyleBox["{9/10,9/10}", "MR"],
 "."
}], "Text",
 CellID->197255785]
}, Open  ]],

Cell[CellGroupData[{

Cell["ImplicitSolver options", "Subsection",
 CellTags->"s:4",
 CellID->1492346857],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specifies the absolute tolerance to use in solving the nonlinear system\
\>", "TableText"]},
   {"IterationSafetyFactor", 
    FractionBox["1", "100"], Cell["\<\
specifies the safety factor to use in solving the nonlinear system\
\>", "TableText"]},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specifies the maximum number of iterations to use in solving the nonlinear \
system\
\>", "TableText"]},
   {
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specifies the relative tolerance to use in solving the nonlinear system\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->2080312779],

Cell[TextData[{
 "Common options of ",
 Cell[BoxData["ImplicitSolver"], "InlineFormula"],
 "."
}], "Caption",
 CellID->1683032159],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"JacobianEvaluationParameter", 
    FractionBox["1", "1000"], Cell["\<\
specifies when to recompute the Jacobian matrix in Newton iterations\
\>", "TableText"]},
   {"LinearSolveMethod", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the linear solver to use in Newton iterations", "TableText"]},
   {"LUDecompositionEvaluationParameter", 
    FractionBox["6", "5"], Cell["\<\
specifies when to compute LUDecompositions in Newton iterations\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->1279572020],

Cell[TextData[{
 "Options specific to the ",
 Cell[BoxData["Newton"], "InlineFormula"],
 " method of ",
 Cell[BoxData["ImplicitSolver"], "InlineFormula"],
 "."
}], "Caption",
 CellID->1811401552]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImplicitRungeKutta Method for NDSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Advanced Numerical Differential Equation Solving in Mathematica", 
         "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NDSolveOverview"]], "Text", FontFamily -> "Verdana"],
     "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolveExplicitRungeKutta"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NDSolveSPRK"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 51.3057704}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Implicit Runge-Kutta methods have a number of desirable properties. The \
Gauss-Legendre methods, for example, are self-adjoint meaning that they \
provide the same solution when integrating forwards or backwards in time. \
This loads packages defining some example problems and utility functions.", 
    "synonyms" -> {}, "title" -> "ImplicitRungeKutta Method for NDSolve", 
    "type" -> "Tutorial", "uri" -> "tutorial/NDSolveImplicitRungeKutta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[728, 29, 92, 2, 70, "Title",
   CellTags->"c:1",
   CellID->478471212]},
 "s:1"->{
  Cell[845, 35, 69, 2, 70, "Section",
   CellTags->"s:1",
   CellID->809171758]},
 "s:2"->{
  Cell[1700, 71, 70, 2, 70, "Section",
   CellTags->"s:2",
   CellID->1990498196]},
 "s:3"->{
  Cell[10834, 378, 66, 2, 70, "Section",
   CellTags->"s:3",
   CellID->1456237599]},
 "s:4"->{
  Cell[35408, 960, 71, 2, 70, "Section",
   CellTags->"s:4",
   CellID->922101906],
  Cell[35504, 966, 85, 2, 70, "Subsection",
   CellTags->"s:4",
   CellID->36109258],
  Cell[37656, 1036, 83, 2, 70, "Subsection",
   CellTags->"s:4",
   CellID->1492346857]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 42764, 1178},
 {"s:1", 42854, 1182},
 {"s:2", 42946, 1186},
 {"s:3", 43040, 1190},
 {"s:4", 43136, 1194}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 92, 2, 70, "Title",
 CellTags->"c:1",
 CellID->478471212],
Cell[CellGroupData[{
Cell[845, 35, 69, 2, 70, "Section",
 CellTags->"s:1",
 CellID->809171758],
Cell[917, 39, 112, 3, 70, "Text",
 CellID->1178805418],
Cell[1032, 44, 196, 4, 70, "Text",
 CellID->2032572883],
Cell[1231, 50, 118, 3, 70, "Text",
 CellID->1863522326],
Cell[1352, 55, 311, 11, 70, "Input",
 InitializationCell->True,
 CellID->960491581]
}, Open  ]],
Cell[CellGroupData[{
Cell[1700, 71, 70, 2, 70, "Section",
 CellTags->"s:2",
 CellID->1990498196],
Cell[1773, 75, 236, 5, 70, "Text",
 CellID->1023480152],
Cell[2012, 82, 440, 13, 70, "Text",
 CellID->694216675],
Cell[2455, 97, 150, 4, 70, "Text",
 CellID->199624518]
}, Open  ]],
Cell[CellGroupData[{
Cell[2642, 106, 62, 1, 70, "Section",
 CellID->2105903498],
Cell[2707, 109, 610, 22, 70, "BulletedText",
 CellID->635264257],
Cell[3320, 133, 174, 4, 70, "BulletedText",
 CellID->1882342207],
Cell[3497, 139, 304, 8, 70, "BulletedText",
 CellID->960385003],
Cell[3804, 149, 241, 7, 70, "BulletedText",
 CellID->1663037271],
Cell[4048, 158, 193, 4, 70, "BulletedText",
 CellID->1521113161],
Cell[4244, 164, 286, 8, 70, "BulletedText",
 CellID->2000855841],
Cell[CellGroupData[{
Cell[4555, 176, 206, 4, 70, "BulletedText",
 CellID->692643658],
Cell[4764, 182, 166, 4, 70, "Text",
 CellID->1330400771],
Cell[CellGroupData[{
Cell[4955, 190, 168, 4, 70, "Input",
 CellID->607031499],
Cell[5126, 196, 830, 25, 156, "Output",
 CellID->2049871528]
}, Open  ]],
Cell[5971, 224, 350, 13, 70, "Text",
 CellID->249724719],
Cell[6324, 239, 234, 5, 70, "Text",
 CellID->535569124],
Cell[CellGroupData[{
Cell[6583, 248, 174, 4, 70, "Input",
 CellID->420114343],
Cell[6760, 254, 1149, 43, 51, "Output",
 CellID->479982586]
}, Open  ]],
Cell[7924, 300, 179, 4, 70, "Text",
 CellID->1945691278],
Cell[CellGroupData[{
Cell[8128, 308, 172, 4, 70, "Input",
 CellID->1316330249],
Cell[8303, 314, 2470, 57, 258, "Output",
 CellID->1261448693]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10834, 378, 66, 2, 70, "Section",
 CellTags->"s:3",
 CellID->1456237599],
Cell[10903, 382, 61, 1, 70, "Text",
 CellID->1069400663],
Cell[10967, 385, 324, 10, 70, "Input",
 CellID->1725878050],
Cell[11294, 397, 172, 4, 70, "Text",
 CellID->1934708811],
Cell[CellGroupData[{
Cell[11491, 405, 157, 4, 70, "Input",
 CellID->1878572421],
Cell[11651, 411, 1491, 52, 85, "Output",
 CellID->167811344]
}, Open  ]],
Cell[13157, 466, 223, 6, 70, "Text",
 CellID->1819798046],
Cell[CellGroupData[{
Cell[13405, 476, 562, 15, 65, "Input",
 CellID->1594611100],
Cell[13970, 493, 1578, 30, 88, "Output",
 Evaluatable->False,
 CellID->42017603]
}, Open  ]],
Cell[15563, 526, 131, 4, 70, "Text",
 CellID->1662812594],
Cell[CellGroupData[{
Cell[15719, 534, 366, 9, 47, "Input",
 CellID->470607604],
Cell[16088, 545, 7684, 130, 343, "Output",
 Evaluatable->False,
 CellID->100568620]
}, Open  ]],
Cell[23787, 678, 539, 18, 70, "Text",
 CellID->1862437112],
Cell[24329, 698, 379, 10, 70, "Text",
 CellID->429027455],
Cell[24711, 710, 160, 4, 70, "Text",
 CellID->899688686],
Cell[CellGroupData[{
Cell[24896, 718, 959, 22, 83, "Input",
 CellID->1597295671],
Cell[25858, 742, 1578, 30, 88, "Output",
 Evaluatable->False,
 CellID->38650140]
}, Open  ]],
Cell[27451, 775, 218, 5, 70, "Text",
 CellID->415242309],
Cell[27672, 782, 180, 4, 70, "Text",
 CellID->970925185],
Cell[CellGroupData[{
Cell[27877, 790, 367, 9, 47, "Input",
 CellID->1242784651],
Cell[28247, 801, 3779, 66, 348, "Output",
 Evaluatable->False,
 CellID->93496951]
}, Open  ]],
Cell[32041, 870, 146, 4, 70, "Text",
 CellID->153842308],
Cell[32190, 876, 180, 4, 70, "Text",
 CellID->1849816151],
Cell[32373, 882, 916, 22, 70, "Input",
 CellID->1421951171],
Cell[CellGroupData[{
Cell[33314, 908, 338, 9, 28, "Input",
 CellID->403567027],
Cell[33655, 919, 1526, 29, 88, "Output",
 Evaluatable->False,
 CellID->307946454]
}, Open  ]],
Cell[35196, 951, 175, 4, 70, "Text",
 CellID->1842065514]
}, Open  ]],
Cell[CellGroupData[{
Cell[35408, 960, 71, 2, 70, "Section",
 CellTags->"s:4",
 CellID->922101906],
Cell[CellGroupData[{
Cell[35504, 966, 85, 2, 70, "Subsection",
 CellTags->"s:4",
 CellID->36109258],
Cell[35592, 970, 1656, 43, 70, "DefinitionBox3Col",
 CellID->1010912116],
Cell[37251, 1015, 138, 5, 70, "Caption",
 CellID->2104637757],
Cell[37392, 1022, 227, 9, 70, "Text",
 CellID->197255785]
}, Open  ]],
Cell[CellGroupData[{
Cell[37656, 1036, 83, 2, 70, "Subsection",
 CellTags->"s:4",
 CellID->1492346857],
Cell[37742, 1040, 1412, 40, 70, "DefinitionBox3Col",
 CellID->2080312779],
Cell[39157, 1082, 130, 5, 70, "Caption",
 CellID->1683032159],
Cell[39290, 1089, 870, 21, 70, "DefinitionBox3Col",
 CellID->1279572020],
Cell[40163, 1112, 195, 7, 70, "Caption",
 CellID->1811401552]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[40397, 1124, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

